# Generated by default/object.tt
package Paws::FSX::WindowsAuditLogCreateConfiguration;
  use Moose;
  has AuditLogDestination => (is => 'ro', isa => 'Str');
  has FileAccessAuditLogLevel => (is => 'ro', isa => 'Str', required => 1);
  has FileShareAccessAuditLogLevel => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FSX::WindowsAuditLogCreateConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FSX::WindowsAuditLogCreateConfiguration object:

  $service_obj->Method(Att1 => { AuditLogDestination => $value, ..., FileShareAccessAuditLogLevel => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FSX::WindowsAuditLogCreateConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AuditLogDestination

=head1 DESCRIPTION

The Windows file access auditing configuration used when creating or
updating an Amazon FSx for Windows File Server file system.

=head1 ATTRIBUTES


=head2 AuditLogDestination => Str

The Amazon Resource Name (ARN) that specifies the destination of the
audit logs.

The destination can be any Amazon CloudWatch Logs log group ARN or
Amazon Kinesis Data Firehose delivery stream ARN, with the following
requirements:

=over

=item *

The destination ARN that you provide (either CloudWatch Logs log group
or Kinesis Data Firehose delivery stream) must be in the same AWS
partition, AWS region, and AWS account as your Amazon FSx file system.

=item *

The name of the Amazon CloudWatch Logs log group must begin with the
C</aws/fsx> prefix. The name of the Amazon Kinesis Data Firehouse
delivery stream must begin with the C<aws-fsx> prefix.

=item *

If you do not provide a destination in C<AuditLogDestination>, Amazon
FSx will create and use a log stream in the CloudWatch Logs
C</aws/fsx/windows> log group.

=item *

If C<AuditLogDestination> is provided and the resource does not exist,
the request will fail with a C<BadRequest> error.

=item *

If C<FileAccessAuditLogLevel> and C<FileShareAccessAuditLogLevel> are
both set to C<DISABLED>, you cannot specify a destination in
C<AuditLogDestination>.

=back



=head2 B<REQUIRED> FileAccessAuditLogLevel => Str

Sets which attempt type is logged by Amazon FSx for file and folder
accesses.

=over

=item *

C<SUCCESS_ONLY> - only successful attempts to access files or folders
are logged.

=item *

C<FAILURE_ONLY> - only failed attempts to access files or folders are
logged.

=item *

C<SUCCESS_AND_FAILURE> - both successful attempts and failed attempts
to access files or folders are logged.

=item *

C<DISABLED> - access auditing of files and folders is turned off.

=back



=head2 B<REQUIRED> FileShareAccessAuditLogLevel => Str

Sets which attempt type is logged by Amazon FSx for file share
accesses.

=over

=item *

C<SUCCESS_ONLY> - only successful attempts to access file shares are
logged.

=item *

C<FAILURE_ONLY> - only failed attempts to access file shares are
logged.

=item *

C<SUCCESS_AND_FAILURE> - both successful attempts and failed attempts
to access file shares are logged.

=item *

C<DISABLED> - access auditing of file shares is turned off.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FSX>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

