# Generated by default/object.tt
package Paws::AuditManager::Scope;
  use Moose;
  has AwsAccounts => (is => 'ro', isa => 'ArrayRef[Paws::AuditManager::AWSAccount]', request_name => 'awsAccounts', traits => ['NameInRequest']);
  has AwsServices => (is => 'ro', isa => 'ArrayRef[Paws::AuditManager::AWSService]', request_name => 'awsServices', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::Scope

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::Scope object:

  $service_obj->Method(Att1 => { AwsAccounts => $value, ..., AwsServices => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::Scope object:

  $result = $service_obj->Method(...);
  $result->Att1->AwsAccounts

=head1 DESCRIPTION

The wrapper that contains the AWS accounts and AWS services in scope
for the assessment.

=head1 ATTRIBUTES


=head2 AwsAccounts => ArrayRef[L<Paws::AuditManager::AWSAccount>]

The AWS accounts included in the scope of the assessment.


=head2 AwsServices => ArrayRef[L<Paws::AuditManager::AWSService>]

The AWS services included in the scope of the assessment.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

