# Generated by default/object.tt
package Paws::IoTSiteWise::GatewaySummary;
  use Moose;
  has CreationDate => (is => 'ro', isa => 'Str', request_name => 'creationDate', traits => ['NameInRequest'], required => 1);
  has GatewayCapabilitySummaries => (is => 'ro', isa => 'ArrayRef[Paws::IoTSiteWise::GatewayCapabilitySummary]', request_name => 'gatewayCapabilitySummaries', traits => ['NameInRequest']);
  has GatewayId => (is => 'ro', isa => 'Str', request_name => 'gatewayId', traits => ['NameInRequest'], required => 1);
  has GatewayName => (is => 'ro', isa => 'Str', request_name => 'gatewayName', traits => ['NameInRequest'], required => 1);
  has LastUpdateDate => (is => 'ro', isa => 'Str', request_name => 'lastUpdateDate', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::GatewaySummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::GatewaySummary object:

  $service_obj->Method(Att1 => { CreationDate => $value, ..., LastUpdateDate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::GatewaySummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationDate

=head1 DESCRIPTION

Contains a summary of a gateway.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CreationDate => Str

The date the gateway was created, in Unix epoch time.


=head2 GatewayCapabilitySummaries => ArrayRef[L<Paws::IoTSiteWise::GatewayCapabilitySummary>]

A list of gateway capability summaries that each contain a namespace
and status. Each gateway capability defines data sources for the
gateway. To retrieve a capability configuration's definition, use
DescribeGatewayCapabilityConfiguration
(https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html).


=head2 B<REQUIRED> GatewayId => Str

The ID of the gateway device.


=head2 B<REQUIRED> GatewayName => Str

The name of the asset.


=head2 B<REQUIRED> LastUpdateDate => Str

The date the gateway was last updated, in Unix epoch time.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

