package GFX::Enhancer::Vector;

sub new {
  my ($class, $bitstring) = @_;
  
  my $self = { bitstring => $bitstring, ### this is a number
	     }; 
  
  $class = ref($class) || $class;
	bless $self, $class;
}

sub norm {
  my ($self) = @_;

  return pow($bitstring, 2);
}

### cosinus alteration on this vector (e.g. colour bits as in the subclasses)

sub cos_angle {
  my ($self) = @_;

  ### NOTE : ||vector|| * ||vector|| * cos(alpha) = (angular momentum) energy
  ### from basic energy law for angles
  
  return $self->norm * $self->norm / $self->angular_momentum_energy(rand);
}

### private methods

sub angular_momentum_energy {
  my ($self, $mass) = @_;

  ### NOTE : This is inexact unless you supply parameters

  return rand unless($mass);
  
  return ($mass * pow($self->{bitstring}, 2) / 2 + $mass * 9.81 * $self->{bitstring});
  
}

1;
