# Generated by default/object.tt
package Paws::WAFV2::DefaultAction;
  use Moose;
  has Allow => (is => 'ro', isa => 'Paws::WAFV2::AllowAction');
  has Block => (is => 'ro', isa => 'Paws::WAFV2::BlockAction');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::DefaultAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::DefaultAction object:

  $service_obj->Method(Att1 => { Allow => $value, ..., Block => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::DefaultAction object:

  $result = $service_obj->Method(...);
  $result->Att1->Allow

=head1 DESCRIPTION

In a WebACL, this is the action that you want WAF to perform when a web
request doesn't match any of the rules in the C<WebACL>. The default
action must be a terminating action, so you can't use count.

=head1 ATTRIBUTES


=head2 Allow => L<Paws::WAFV2::AllowAction>

Specifies that WAF should allow requests by default.


=head2 Block => L<Paws::WAFV2::BlockAction>

Specifies that WAF should block requests by default.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

