#!/usr/bin/perl

use v5.14;
use warnings;

use Test2::V0;

BEGIN { $ENV{PERL_ASSERT_ENABLED} = 1; }  # default, but override test environment

use Syntax::Keyword::Assert;

# ok
{
   ok( lives { assert( 123 ) },    'assert(123)' );
   ok( lives { assert( 5 == 5 ) }, 'assert(5 == 5)' );
}

# fails
{
   like( dies { assert(0) },     qr/^assertion failed \(got 0\) /,     'assert(0)' );
   like( dies { assert("") },    qr/^assertion failed \(got ""\) /,    'assert("")' );
   like( dies { assert(undef) }, qr/^assertion failed \(got undef\) /, 'assert(undef)' );

   if( $^V ge v5.36 ) {
      my $false = 1 == 2;
      like( dies { assert($false) }, qr/^assertion failed \(got false\) /, 'assert(false)' );
   }
}

# scalar context
{
   my @items = (0);

   ok( lives { assert(@items) }, 'assert() expression forces scalar context' );
}

# failure appears from the right file/line
{
   my $file = __FILE__;
   my $line = __LINE__+1;
   is( dies { assert(0) }, "assertion failed (got 0) at $file line $line.\n",
      'assert gives correct file+line information' );
}

done_testing;
