/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.util.StringUtil;

public class FeatureCollectionConfig {
    private static boolean regularizeDefault = false;
    private static Logger log = LoggerFactory.getLogger(FeatureCollectionConfig.class);
    private static Set<FmrcDatasetType> defaultDatasetTypes = Collections.unmodifiableSet(EnumSet.of(FmrcDatasetType.TwoD, FmrcDatasetType.Best, FmrcDatasetType.Files, FmrcDatasetType.Runs));

    public static void setRegularizeDefault(boolean t) {
        regularizeDefault = t;
    }

    public static boolean getRegularizeDefault() {
        return regularizeDefault;
    }

    static /* synthetic */ boolean access$100() {
        return regularizeDefault;
    }

    static /* synthetic */ Set access$200() {
        return defaultDatasetTypes;
    }

    public static class BestDataset {
        public String name;
        public double greaterThan;

        public BestDataset(String name, double greaterThan) {
            this.name = name;
            this.greaterThan = greaterThan;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FmrcConfig {
        public boolean regularize = FeatureCollectionConfig.access$100();
        public Set<FmrcDatasetType> datasets = FeatureCollectionConfig.access$200();
        private boolean explicit = false;
        private List<BestDataset> bestDatasets = null;

        public FmrcConfig() {
        }

        public FmrcConfig(String regularize) {
            this.regularize = regularize != null && regularize.equalsIgnoreCase("true");
        }

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicit) {
                this.datasets = EnumSet.noneOf(FmrcDatasetType.class);
            }
            this.explicit = true;
            for (String type : types = StringUtil.splitString(datasetTypes)) {
                try {
                    FmrcDatasetType fdt = FmrcDatasetType.valueOf(type);
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize FmrcDatasetType " + type);
                }
            }
        }

        public void addBestDataset(String name, double greaterEqual) {
            if (this.bestDatasets == null) {
                this.bestDatasets = new ArrayList<BestDataset>(2);
            }
            this.bestDatasets.add(new BestDataset(name, greaterEqual));
        }

        public List<BestDataset> getBestDatasets() {
            return this.bestDatasets;
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("FmrcConfig: regularize=%s datasetTypes=%s", this.regularize, this.datasets);
            if (this.bestDatasets != null) {
                for (BestDataset bd : this.bestDatasets) {
                    f.format("best = (%s, %f) ", bd.name, bd.greaterThan);
                }
            }
            return f.toString();
        }
    }

    public static class ProtoConfig {
        public ProtoChoice choice = ProtoChoice.Penultimate;
        public String param = null;
        public String change = null;
        public Element outerNcml = null;
        public boolean cacheAll = true;

        public ProtoConfig() {
        }

        public ProtoConfig(String choice, String change, String param, Element ncml) {
            if (choice != null) {
                try {
                    this.choice = ProtoChoice.valueOf(choice);
                }
                catch (Exception e) {
                    log.warn("Dont recognize ProtoChoice " + choice);
                }
            }
            this.change = change;
            this.param = param;
            this.outerNcml = ncml;
        }

        public String toString() {
            return "ProtoConfig{choice=" + (Object)((Object)this.choice) + ", change='" + this.change + '\'' + ", param='" + this.param + '\'' + ", outerNcml='" + this.outerNcml + '\'' + ", cacheAll=" + this.cacheAll + '}';
        }
    }

    public static class UpdateConfig {
        public boolean startup;
        public String rescan = null;
        public boolean triggerOk;

        public UpdateConfig() {
        }

        public UpdateConfig(String startup, String rescan, String trigger) {
            if (startup != null) {
                this.startup = startup.equalsIgnoreCase("true");
            }
            if (trigger != null) {
                this.triggerOk = trigger.equalsIgnoreCase("allow");
            }
            this.rescan = rescan;
        }

        public String toString() {
            return "UpdateConfig{startup=" + this.startup + ", rescan='" + this.rescan + '\'' + ", triggerOk=" + this.triggerOk + '}';
        }
    }

    public static class Config {
        public String name;
        public String spec;
        public String olderThan;
        public String recheckAfter;
        public UpdateConfig updateConfig = new UpdateConfig();
        public ProtoConfig protoConfig = new ProtoConfig();
        public FmrcConfig fmrcConfig = new FmrcConfig();
        public Element innerNcml = null;

        public Config() {
        }

        public Config(String name, String spec, String olderThan, String recheckAfter, Element innerNcml) {
            this.name = name;
            this.spec = spec.trim();
            this.olderThan = olderThan;
            this.recheckAfter = recheckAfter;
            this.innerNcml = innerNcml;
        }

        public String toString() {
            return "Config{name='" + this.name + '\'' + "spec='" + this.spec + '\'' + ", olderThan='" + this.olderThan + '\'' + ", recheckAfter='" + this.recheckAfter + '\'' + "\n " + this.updateConfig + "\n " + this.protoConfig + "\n " + this.fmrcConfig + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FmrcDatasetType {
        TwoD,
        Best,
        Files,
        Runs,
        ConstantForecasts,
        ConstantOffsets;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProtoChoice {
        First,
        Random,
        Latest,
        Penultimate,
        Run;

    }
}

