#ifndef UU_TYPE_H
#define UU_TYPE_H

/* related from SO for gcc:
* https://stackoverflow.com/questions/1188939/representing-128-bit-numbers-in-c
*******************************************************************************
  typedef unsigned int uint128_t __attribute__((mode(TI)));

   uint64_t x = 0xABCDEF01234568;
   uint64_t y = ~x;

   uint128_t result = ((uint128_t) x * y);

   printf("%016llX * %016llX -> ", x, y);

   uint64_t r1 = (result >> 64);
   uint64_t r2 = result;

   printf("%016llX %016llX\n", r1, r2);
*/

#ifndef HAVE_TYPE_U64
#  if defined(HAS_QUAD)
     typedef Uquad_t U64;
#    define HAVE_TYPE_U64 1
#  elif defined(HAVE_STDINT_H)
     typedef uint64_t U64;
#    define HAVE_TYPE_U64 1
#  endif
#endif

#ifdef USE_WIN32_NATIVE
struct __declspec(align (8)) uu {
#else
struct uu {
#endif
  U32 time_low;
  U16 time_mid;
  U16 time_high_and_version;
  U16 clock_seq_and_variant;
  U8  node[6];
#ifndef USE_WIN32_NATIVE
} __attribute__((aligned (8)));
#else
};
#endif

#ifdef USE_WIN32_NATIVE
struct __declspec(align (8)) uu4 {
#else
struct uu4 {
#endif
  U32 rand_a;
  U32 rand_b_and_version;
  U32 rand_c_and_variant;
  U32 rand_d;
#ifndef USE_WIN32_NATIVE
} __attribute__((aligned (8)));
#else
};
#endif

#ifdef USE_WIN32_NATIVE
struct __declspec(align (8)) uu6 {
#else
struct uu6 {
#endif
  U32 time_high;
  U16 time_mid;
  U16 time_low_and_version;
  U16 clock_seq_and_variant;
  U8  node[6];
#ifndef USE_WIN32_NATIVE
} __attribute__((aligned (8)));
#else
};
#endif

#ifdef USE_WIN32_NATIVE
struct __declspec(align (8)) uu7 {
#else
struct uu7 {
#endif
  U32 time_high;
  U16 time_low;
  U16 rand_a_and_version;
  U64 rand_b_and_variant;
#ifndef USE_WIN32_NATIVE
} __attribute__((aligned (8)));
#else
};
#endif

/* this should be aligned at least 4 bytes, better yet 16 */
typedef U8 uu_t[16];

typedef unsigned char UCHAR;

#endif
/* ex:set ts=2 sw=2 itab=spaces */
