# Generated by default/object.tt
package Paws::SSMIncidents::ReplicationSet;
  use Moose;
  has CreatedBy => (is => 'ro', isa => 'Str', request_name => 'createdBy', traits => ['NameInRequest'], required => 1);
  has CreatedTime => (is => 'ro', isa => 'Str', request_name => 'createdTime', traits => ['NameInRequest'], required => 1);
  has DeletionProtected => (is => 'ro', isa => 'Bool', request_name => 'deletionProtected', traits => ['NameInRequest'], required => 1);
  has LastModifiedBy => (is => 'ro', isa => 'Str', request_name => 'lastModifiedBy', traits => ['NameInRequest'], required => 1);
  has LastModifiedTime => (is => 'ro', isa => 'Str', request_name => 'lastModifiedTime', traits => ['NameInRequest'], required => 1);
  has RegionMap => (is => 'ro', isa => 'Paws::SSMIncidents::RegionInfoMap', request_name => 'regionMap', traits => ['NameInRequest'], required => 1);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::ReplicationSet

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::ReplicationSet object:

  $service_obj->Method(Att1 => { CreatedBy => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::ReplicationSet object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedBy

=head1 DESCRIPTION

The set of Regions that your Incident Manager data will be replicated
to and the KMS key used to encrypt the data.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CreatedBy => Str

Details about who created the replication set.


=head2 B<REQUIRED> CreatedTime => Str

When the replication set was created.


=head2 B<REQUIRED> DeletionProtected => Bool

Determines if the replication set deletion protection is enabled or
not. If deletion protection is enabled, you can't delete the last
Region in the replication set.


=head2 B<REQUIRED> LastModifiedBy => Str

Who last modified the replication set.


=head2 B<REQUIRED> LastModifiedTime => Str

When the replication set was last updated.


=head2 B<REQUIRED> RegionMap => L<Paws::SSMIncidents::RegionInfoMap>

The map between each Region in your replication set and the KMS key
that is used to encrypt the data in that Region.


=head2 B<REQUIRED> Status => Str

The status of the replication set. If the replication set is still
pending, you can't use Incident Manager functionality.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

