#!/usr/bin/perl

package eBay::API::XML::Call::GetPromotionRules;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetPromotionRules.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetPromotionRules

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetPromotionRules inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetPromotionRules::GetPromotionRulesRequestType;
use eBay::API::XML::Call::GetPromotionRules::GetPromotionRulesResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetPromotionRules';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetPromotionRules::GetPromotionRulesRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetPromotionRules::GetPromotionRulesResponseType';
}

#
# input properties
#

=head2 setItemID()

The unique ID of the item for which to retrieve promotion rules.
Mutually exclusive with StoreCategoryID.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Conditionally
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setPromotionMethod()

The type of promotion. (CrossSell: items that are related to or
useful in combination with this item. UpSell: items that are more
expensive than or of higher quality than this item.)

  RequiredInput: Yes
#    Argument: 'ns:PromotionMethodCodeType'

=cut
       
sub setPromotionMethod {
   my $self   = shift;
   my $sPromotionMethod = shift;
   $self->getRequestDataType()->setPromotionMethod($sPromotionMethod);
}

=head2 setStoreCategoryID()

The unique ID of the store category for which to retrieve promotion rules.
Mutually exclusive with ItemID.

  RequiredInput: Conditionally
#    Argument: 'xs:long'

=cut
       
sub setStoreCategoryID {
   my $self   = shift;
   my $sStoreCategoryID = shift;
   $self->getRequestDataType()->setStoreCategoryID($sStoreCategoryID);
}



#
# output properties
#

=head2 getPromotionRuleArray()

An array of promotion rules associated with the item or store category
specified in the request.

  Returned: Always
#    Returns: 'ns:PromotionRuleArrayType'

=cut
       
sub getPromotionRuleArray {
   my $self = shift;
   return $self->getResponseDataType()->getPromotionRuleArray();
}





1;   
