#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::BuyerPaymentMethodCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BuyerPaymentMethodCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::BuyerPaymentMethodCodeType

=head1 DESCRIPTION

Identifies payment methods used by a buyer to pay a
seller. On item listings, identifies one of the payment methods
seller will accept for the item. Available payment methods can
differ by site and item. Payment methods are not applicable to eBay
Real Estate ad format listings.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 None

No payment method specified.
For example, no payment methods would be specified for Ad format listings.



=cut


use constant None => scalar('None');


=head2 MOCC

Money order/cashiers check.
Not applicable to US/CA eBay Motors listings.



=cut


use constant MOCC => scalar('MOCC');


=head2 AmEx

American Express.
Not applicable to US/CA eBay Motors listings.



=cut


use constant AmEx => scalar('AmEx');


=head2 PaymentSeeDescription

Payment instructions are contained in the item's description.



=cut


use constant PaymentSeeDescription => scalar('PaymentSeeDescription');


=head2 CCAccepted

Credit card.
Not applicable to Real Estate or US/CA eBay Motors listings.



=cut


use constant CCAccepted => scalar('CCAccepted');


=head2 PersonalCheck

Personal check.



=cut


use constant PersonalCheck => scalar('PersonalCheck');


=head2 COD

Cash on delivery.
This payment method is obsolete (ignored) for the US, US eBay Motors, UK, and Canada sites.
See "Field Differences for eBay Sites" in the eBay Web Services Guide for a list of sites
that accept COD as a payment method. Not applicable to Real Estate listings.
When revising an item (on sites that still support COD), you can add or change its value.



=cut


use constant COD => scalar('COD');


=head2 VisaMC

Visa/Mastercard. These qualify as safe payment methods.
Not applicable to US/CA eBay Motors listings.



=cut


use constant VisaMC => scalar('VisaMC');


=head2 PaisaPayAccepted

PaisaPay (for India site only). This qualifies as a safe payment method and is required for all categories on the IN site.



=cut


use constant PaisaPayAccepted => scalar('PaisaPayAccepted');


=head2 Other

Other forms of payment. Some custom methods are accepted by seller
as the payment method in the transaction.
Not applicable to US/CA eBay Motors listings
(see PaymentSeeDescription instead).



=cut


use constant Other => scalar('Other');


=head2 PayPal

PayPal is accepted as a payment method. This qualifies as a safe payment method. If true in listing
requests, Item.PayPalEmailAddress must also be specified.<br>
<br>
If you don't pass PayPal in the listing request but the seller's eBay
preferences are set to accept PayPal on all listings,
eBay will add PayPal as a payment method for you in most cases,
and we may return a warning. <br>
<br>
PayPal must be accepted when the seller requires immediate payment
(Item.AutoPay) or offers other PayPal-based features, such as a
finance offer (Item.FinanceOfferID).
PayPal must be accepted for charity listings.
PayPal must be accepted for event ticket listings when the venue is in
New York state or Illinois, so that eBay can offer buyer protection
(per state law). (For some applications, it may be
simplest to use errors returned from VerifyAddItem to flag the PayPal
requirement for New York and Illinois ticket listings.)
PayPal must be accepted for US eBay Motors listings that require a deposit (and it will not be set automatically based on the
seller's preferences). Conversely, if PayPal is specified for US eBay Motors listings, deposit attributes must be specified.<br>
<br>
For additional information about features that depend on PayPal,
see the eBay Web Services Guide.



=cut


use constant PayPal => scalar('PayPal');


=head2 Discover

Discover card.
Not applicable to US/CA eBay Motors listings.



=cut


use constant Discover => scalar('Discover');


=head2 CashOnPickup

Payment on delivery.
Not applicable to Real Estate or US/CA eBay Motors listings.



=cut


use constant CashOnPickup => scalar('CashOnPickup');


=head2 MoneyXferAccepted

Direct transfer of money.
Not applicable to US/CA eBay Motors listings.



=cut


use constant MoneyXferAccepted => scalar('MoneyXferAccepted');


=head2 MoneyXferAcceptedInCheckout

If the seller has bank account information on file, and
MoneyXferAcceptedInCheckout = true, then the bank account information will
be displayed in Checkout. Applicable only to certain global eBay sites. See
the "International Differences Overview" in the eBay Web Services Guide.



=cut


use constant MoneyXferAcceptedInCheckout => scalar('MoneyXferAcceptedInCheckout');


=head2 OtherOnlinePayments

All other online payments.
Not applicable to US/CA eBay Motors listings.



=cut


use constant OtherOnlinePayments => scalar('OtherOnlinePayments');


=head2 Escrow

Reserved for future use.



=cut


use constant Escrow => scalar('Escrow');


=head2 PrePayDelivery

Reserved for future use.



=cut


use constant PrePayDelivery => scalar('PrePayDelivery');


=head2 CODPrePayDelivery

Reserved for future use.



=cut


use constant CODPrePayDelivery => scalar('CODPrePayDelivery');


=head2 PostalTransfer

Reserved for future use.



=cut


use constant PostalTransfer => scalar('PostalTransfer');


=head2 CustomCode

Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');


=head2 LoanCheck

Loan check option (applicable only to the US eBay Motors site,
except in the Parts and Accessories category, and the eBay Canada site for motors).



=cut


use constant LoanCheck => scalar('LoanCheck');


=head2 CashInPerson

Cash-in-person option. Applicable only to US and Canada eBay Motors vehicles,
(not the Parts and Accessories category).



=cut


use constant CashInPerson => scalar('CashInPerson');


=head2 ELV

Elektronisches Lastschriftverfahren (direct debit).
Only applicable to Express Germany. The Germany Express site was shut down
in April 2008.



=cut


use constant ELV => scalar('ELV');


=head2 PaisaPayEscrow

PaisaPayEscrow payment option. Applicable on selected categories on the India site only.



=cut


use constant PaisaPayEscrow => scalar('PaisaPayEscrow');


=head2 PaisaPayEscrowEMI

PaisaPayEscrowEMI (Equal Monthly Installments) Payment option. Must be specified with PaisaPayEscrow. Applicable only to India site.



=cut


use constant PaisaPayEscrowEMI => scalar('PaisaPayEscrowEMI');







1;   
