---
title: Update Validity XML
---

# Update Validity XML

1. Create the archive ([Creating the Archive](/development/creating-the-archive)) with at least the last release (if you don't have it already)
2. Run GenerateValidityXML.java
3. This updates files in cldr/common/validity/. (If you set \-DSHOW\_FILES, you'll see this on the console.)
	1. New files should not be generated. If there are any, something has gone wrong, so raise this as an issue on cldr\-dev. **Note:** cldr/common/validity/currency.xml contains a comment line \- *\<!\-\- Deprecated values are those that are not legal tender in some country after 2021\.* The value of year is generated by the tool and this might be detected as diff. In this case, edit currency.xml to update the year in comment to the current year, and run the tool again.
		1. The units file is hand\-curated. It is kept in sync with the units supported in root/en.xml. The attribute values test ensures that it is a superset.
4. git diff for a sanity check \- may be no change.
5. Subdivisions are special.
	1. At the end you may see a "Codes added this release:".
	2. Compare the country codes to those from the "deprecated" list.
	3. If any are the same, you'll have to compare the deprecated codes to the new codes, to see if any deprecated code was changed into a new code.
	4. If so, then add necessary lines in supplemental data (below \<!\-\- end of data generated with GenerateSubdivisions \-\-\>) of the form:
		- \<subdivisionAlias type\="\<DEP\-CODE\>" replacement\="\<NEW\-CODE\>" reason\="deprecated"/\>
	5. Run the following (you must have all the archived versions loaded, back to cldr\-28\.0!)
		1. TestValidity \-e9
	6. If they are ok, replace and checkin

