/* { dg-final { check-function-bodies "**" "" "-DCHECK_ASM" } } */

#include "test_sve_acle.h"

/*
** addlb_u64_tied1:
**	uaddlb	z0\.d, z0\.s, z1\.s
**	ret
*/
TEST_TYPE_CHANGE_Z (addlb_u64_tied1, svuint64_t, svuint32_t,
		    z0_res = svaddlb_u64 (z0, z1),
		    z0_res = svaddlb (z0, z1))

/*
** addlb_u64_tied2:
**	uaddlb	z0\.d, z1\.s, z0\.s
**	ret
*/
TEST_TYPE_CHANGE_Z (addlb_u64_tied2, svuint64_t, svuint32_t,
		    z0_res = svaddlb_u64 (z1, z0),
		    z0_res = svaddlb (z1, z0))

/*
** addlb_u64_untied:
**	uaddlb	z0\.d, z1\.s, z2\.s
**	ret
*/
TEST_TYPE_CHANGE_Z (addlb_u64_untied, svuint64_t, svuint32_t,
		    z0_res = svaddlb_u64 (z1, z2),
		    z0_res = svaddlb (z1, z2))

/*
** addlb_w0_u64_tied1:
**	mov	(z[0-9]+\.s), w0
**	uaddlb	z0\.d, z0\.s, \1
**	ret
*/
TEST_TYPE_CHANGE_ZX (addlb_w0_u64_tied1, svuint64_t, svuint32_t, uint32_t,
		     z0_res = svaddlb_n_u64 (z0, x0),
		     z0_res = svaddlb (z0, x0))

/*
** addlb_w0_u64_untied:
**	mov	(z[0-9]+\.s), w0
**	uaddlb	z0\.d, z1\.s, \1
**	ret
*/
TEST_TYPE_CHANGE_ZX (addlb_w0_u64_untied, svuint64_t, svuint32_t, uint32_t,
		     z0_res = svaddlb_n_u64 (z1, x0),
		     z0_res = svaddlb (z1, x0))

/*
** addlb_11_u64_tied1:
**	mov	(z[0-9]+\.s), #11
**	uaddlb	z0\.d, z0\.s, \1
**	ret
*/
TEST_TYPE_CHANGE_Z (addlb_11_u64_tied1, svuint64_t, svuint32_t,
		    z0_res = svaddlb_n_u64 (z0, 11),
		    z0_res = svaddlb (z0, 11))

/*
** addlb_11_u64_untied:
**	mov	(z[0-9]+\.s), #11
**	uaddlb	z0\.d, z1\.s, \1
**	ret
*/
TEST_TYPE_CHANGE_Z (addlb_11_u64_untied, svuint64_t, svuint32_t,
		    z0_res = svaddlb_n_u64 (z1, 11),
		    z0_res = svaddlb (z1, 11))
