/*
 * Canopus HQ/HQA decoder
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "hq_hqa.h"

#define MAT_SIZE 64

static const uint8_t cbp_vlc_bits[16] = {
    0x04, 0x1C, 0x1D, 0x09, 0x1E, 0x0B, 0x1B, 0x08,
    0x1F, 0x1A, 0x0C, 0x07, 0x0A, 0x06, 0x05, 0x00,
};

static const uint8_t cbp_vlc_lens[16] = {
    4, 5, 5, 4, 5, 4, 5, 4, 5, 5, 4, 4, 4, 4, 4, 2,
};

static const int32_t qmat00[MAT_SIZE] = {
    0x0040000, 0x000B18B, 0x00058C5, 0x000B1B1, 0x00082D3, 0x000B1B1,
    0x000A953, 0x000827B, 0x00104F7, 0x000A953, 0x0009000, 0x000EADD,
    0x001037B, 0x000756E, 0x0009000, 0x000776D, 0x000696A, 0x000E987,
    0x000E987, 0x000D2D4, 0x000776D, 0x0016BAF, 0x0014B4C, 0x001A21A,
    0x001BA75, 0x001A21A, 0x000A5A6, 0x000B5D8, 0x000611E, 0x000811D,
    0x00150B6, 0x00181B0, 0x00181B0, 0x00150B6, 0x0020474, 0x0018477,
    0x0022710, 0x001FD1E, 0x001366C, 0x0015000, 0x001366C, 0x000FE8F,
    0x00044E2, 0x0008A6D, 0x000EA30, 0x0010E47, 0x0010E47, 0x001D460,
    0x00229B2, 0x001FCB2, 0x0019FA3, 0x000D94C, 0x000CFD2, 0x0007F2D,
    0x000DEED, 0x0014D5E, 0x0029ABD, 0x0037BB5, 0x002D16B, 0x001FECE,
    0x000B45B, 0x0011521, 0x0022A42, 0x0012B9C,
};

static const int32_t qmat01[MAT_SIZE] = {
    0x0040000, 0x000B18B, 0x00058C5, 0x000B1B1, 0x00082D3, 0x000B1B1,
    0x000EB2D, 0x000B53A, 0x0016A73, 0x000EB2D, 0x000D000, 0x0014632,
    0x0016314, 0x000A319, 0x000D000, 0x000A36D, 0x0009041, 0x0014BDA,
    0x0014BDA, 0x0012081, 0x000A36D, 0x0016BAF, 0x0014B4C, 0x001A21A,
    0x001BA75, 0x001A21A, 0x000A5A6, 0x000B5D8, 0x000611E, 0x000811D,
    0x00150B6, 0x00181B0, 0x00181B0, 0x00150B6, 0x0020474, 0x0018477,
    0x0045A60, 0x004058C, 0x0026CD9, 0x002A000, 0x0026CD9, 0x00202C6,
    0x0008B4C, 0x00114D9, 0x001D977, 0x0021C8F, 0x0021C8F, 0x003B2EF,
    0x0045365, 0x007FD2A, 0x00675E5, 0x0036A1F, 0x0033AF3, 0x001FF4B,
    0x001C010, 0x0029E24, 0x0053C47, 0x007003E, 0x005A9C7, 0x004024C,
    0x0016A72, 0x0022A42, 0x0045485, 0x0025738,
};

static const int32_t qmat02[MAT_SIZE] = {
    0x0040000, 0x0016315, 0x000B18B, 0x0016363, 0x00105A6, 0x0016363,
    0x00152A7, 0x00104F7, 0x00209EE, 0x00152A7, 0x0012000, 0x001D5B9,
    0x00206F6, 0x000EADD, 0x0012000, 0x000EEDA, 0x000D2D4, 0x001D30D,
    0x001D30D, 0x001A5A9, 0x000EEDA, 0x002D75E, 0x0029698, 0x0034433,
    0x00374EB, 0x0034433, 0x0014B4C, 0x0016BAF, 0x000C23C, 0x001023A,
    0x002A16C, 0x0030360, 0x0030360, 0x002A16C, 0x00408E9, 0x00308EF,
    0x0044E21, 0x003FA3C, 0x0026CD9, 0x002A000, 0x0026CD9, 0x001FD1E,
    0x00089C4, 0x00114D9, 0x001D460, 0x0021C8F, 0x0021C8F, 0x003A8C0,
    0x0045365, 0x003F964, 0x0033F47, 0x001B297, 0x0019FA3, 0x000FE59,
    0x001BDDA, 0x0029ABD, 0x0053579, 0x006F76A, 0x005A2D7, 0x003FD9D,
    0x00168B6, 0x0022A42, 0x0045485, 0x0025738,
};

static const int32_t qmat03[MAT_SIZE] = {
    0x0040000, 0x0016315, 0x000B18B, 0x0016363, 0x00105A6, 0x0016363,
    0x001D65A, 0x0016A73, 0x002D4E7, 0x001D65A, 0x001A000, 0x0028C65,
    0x002C628, 0x0014632, 0x001A000, 0x00146D9, 0x0012081, 0x00297B5,
    0x00297B5, 0x0024102, 0x00146D9, 0x002D75E, 0x0029698, 0x0034433,
    0x00374EB, 0x0034433, 0x0014B4C, 0x0016BAF, 0x000C23C, 0x001023A,
    0x002A16C, 0x0030360, 0x0030360, 0x002A16C, 0x00408E9, 0x00308EF,
    0x008B4C0, 0x0080B18, 0x004D9B2, 0x0054000, 0x004D9B2, 0x004058C,
    0x0011698, 0x00229B2, 0x003B2EF, 0x004391E, 0x004391E, 0x00765DD,
    0x008A6CA, 0x00FFA54, 0x00CEBCA, 0x006D43E, 0x00675E5, 0x003FE95,
    0x003801F, 0x0053C47, 0x00A788E, 0x00E007C, 0x00B538D, 0x0080498,
    0x002D4E3, 0x0045485, 0x008A90A, 0x004AE71,
};

static const int32_t qmat04[MAT_SIZE] = {
    0x0040000, 0x00214A0, 0x0010A50, 0x0021514, 0x0018879, 0x0021514,
    0x001FBFA, 0x0018772, 0x0030EE5, 0x001FBFA, 0x001B000, 0x002C096,
    0x0030A71, 0x001604B, 0x001B000, 0x0016647, 0x0013C3F, 0x002BC94,
    0x002BC94, 0x002787D, 0x0016647, 0x004430D, 0x003E1E4, 0x004E64D,
    0x0052F60, 0x004E64D, 0x001F0F2, 0x0022187, 0x001235A, 0x0018357,
    0x003F223, 0x0048510, 0x0048510, 0x003F223, 0x0060D5D, 0x0048D66,
    0x0067531, 0x005F75A, 0x003A345, 0x003F000, 0x003A345, 0x002FBAD,
    0x000CEA6, 0x0019F46, 0x002BE90, 0x0032AD6, 0x0032AD6, 0x0057D20,
    0x0067D17, 0x005F616, 0x004DEEA, 0x0028BE3, 0x0026F75, 0x0017D86,
    0x0029CC8, 0x003E81B, 0x007D036, 0x00A731F, 0x0087442, 0x005FC6B,
    0x0021D11, 0x0033F64, 0x0067EC7, 0x00382D5,
};

static const int32_t qmat05[MAT_SIZE] = {
    0x0040000, 0x00214A0, 0x0010A50, 0x0021514, 0x0018879, 0x0021514,
    0x002C186, 0x0021FAD, 0x0043F5A, 0x002C186, 0x0027000, 0x003D297,
    0x004293C, 0x001E94C, 0x0027000, 0x001EA46, 0x001B0C2, 0x003E38F,
    0x003E38F, 0x0036183, 0x001EA46, 0x004430D, 0x003E1E4, 0x004E64D,
    0x0052F60, 0x004E64D, 0x001F0F2, 0x0022187, 0x001235A, 0x0018357,
    0x003F223, 0x0048510, 0x0048510, 0x003F223, 0x0060D5D, 0x0048D66,
    0x00D0F1F, 0x00C10A4, 0x007468B, 0x007E000, 0x007468B, 0x0060852,
    0x001A1E4, 0x0033E8C, 0x0058C66, 0x00655AD, 0x00655AD, 0x00B18CC,
    0x00CFA2F, 0x017F77F, 0x01361B0, 0x00A3E5C, 0x009B0D8, 0x005FDE0,
    0x005402F, 0x007DA6B, 0x00FB4D5, 0x01500BA, 0x010FD54, 0x00C06E5,
    0x0043F55, 0x0067EC7, 0x00CFD8F, 0x00705A9,
};

static const int32_t qmat06[MAT_SIZE] = {
    0x0040000, 0x002C62A, 0x0016315, 0x002C6C5, 0x0020B4C, 0x002C6C5,
    0x002A54E, 0x00209EE, 0x00413DC, 0x002A54E, 0x0024000, 0x003AB73,
    0x0040DEC, 0x001D5B9, 0x0024000, 0x001DDB4, 0x001A5A9, 0x003A61B,
    0x003A61B, 0x0034B52, 0x001DDB4, 0x005AEBC, 0x0052D2F, 0x0068867,
    0x006E9D6, 0x0068867, 0x0029698, 0x002D75E, 0x0018477, 0x0020474,
    0x00542D9, 0x00606C0, 0x00606C0, 0x00542D9, 0x00811D1, 0x00611DE,
    0x0089C42, 0x007F478, 0x004D9B2, 0x0054000, 0x004D9B2, 0x003FA3C,
    0x0011388, 0x00229B2, 0x003A8C0, 0x004391E, 0x004391E, 0x0075180,
    0x008A6CA, 0x007F2C9, 0x0067E8E, 0x003652F, 0x0033F47, 0x001FCB2,
    0x0037BB5, 0x0053579, 0x00A6AF3, 0x00DEED4, 0x00B45AE, 0x007FB39,
    0x002D16B, 0x0045485, 0x008A90A, 0x004AE71,
};

static const int32_t qmat07[MAT_SIZE] = {
    0x0040000, 0x002C62A, 0x0016315, 0x002C6C5, 0x0020B4C, 0x002C6C5,
    0x003ACB3, 0x002D4E7, 0x005A9CE, 0x003ACB3, 0x0034000, 0x00518CA,
    0x0058C50, 0x0028C65, 0x0034000, 0x0028DB3, 0x0024102, 0x0052F69,
    0x0052F69, 0x0048204, 0x0028DB3, 0x005AEBC, 0x0052D2F, 0x0068867,
    0x006E9D6, 0x0068867, 0x0029698, 0x002D75E, 0x0018477, 0x0020474,
    0x00542D9, 0x00606C0, 0x00606C0, 0x00542D9, 0x00811D1, 0x00611DE,
    0x011697F, 0x0101631, 0x009B363, 0x00A8000, 0x009B363, 0x0080B18,
    0x0022D30, 0x0045365, 0x00765DD, 0x008723C, 0x008723C, 0x00ECBBB,
    0x0114D94, 0x01FF4A9, 0x019D795, 0x00DA87B, 0x00CEBCA, 0x007FD2A,
    0x007003E, 0x00A788E, 0x014F11C, 0x01C00F8, 0x016A71B, 0x0100931,
    0x005A9C7, 0x008A90A, 0x0115214, 0x0095CE2,
};

static const int32_t qmat08[MAT_SIZE] = {
    0x0040000, 0x00377B5, 0x001BBDA, 0x0037876, 0x0028E1E, 0x0037876,
    0x0034EA1, 0x0028C69, 0x00518D3, 0x0034EA1, 0x002D000, 0x004964F,
    0x0051167, 0x0024B28, 0x002D000, 0x0025521, 0x0020F13, 0x0048FA1,
    0x0048FA1, 0x0041E26, 0x0025521, 0x0071A6B, 0x006787B, 0x0082A80,
    0x008A44B, 0x0082A80, 0x0033C3E, 0x0038D36, 0x001E595, 0x0028591,
    0x006938F, 0x0078870, 0x0078870, 0x006938F, 0x00A1646, 0x0079655,
    0x00AC352, 0x009F196, 0x006101E, 0x0069000, 0x006101E, 0x004F8CB,
    0x001586A, 0x002B41F, 0x00492F0, 0x0054765, 0x0054765, 0x00925E0,
    0x00AD07C, 0x009EF7B, 0x0081E31, 0x0043E7A, 0x0040F19, 0x0027BDF,
    0x0045AA2, 0x00682D8, 0x00D05B0, 0x0116A89, 0x00E1719, 0x009FA07,
    0x00385C6, 0x00569A6, 0x00AD34C, 0x005DA0D,
};

static const int32_t qmat09[MAT_SIZE] = {
    0x0040000, 0x00377B5, 0x001BBDA, 0x0037876, 0x0028E1E, 0x0037876,
    0x00497E0, 0x0038A21, 0x0071441, 0x00497E0, 0x0041000, 0x0065EFC,
    0x006EF64, 0x0032F7E, 0x0041000, 0x003311F, 0x002D143, 0x0067B44,
    0x0067B44, 0x005A285, 0x003311F, 0x0071A6B, 0x006787B, 0x0082A80,
    0x008A44B, 0x0082A80, 0x0033C3E, 0x0038D36, 0x001E595, 0x0028591,
    0x006938F, 0x0078870, 0x0078870, 0x006938F, 0x00A1646, 0x0079655,
    0x015C3DF, 0x0141BBD, 0x00C203C, 0x00D2000, 0x00C203C, 0x00A0DDE,
    0x002B87C, 0x005683E, 0x0093F55, 0x00A8ECA, 0x00A8ECA, 0x0127EA9,
    0x015A0F9, 0x027F1D3, 0x0204D7A, 0x011129A, 0x01026BD, 0x009FC75,
    0x008C04E, 0x00D16B2, 0x01A2D64, 0x0230136, 0x01C50E1, 0x0140B7D,
    0x0071438, 0x00AD34C, 0x015A699, 0x00BB41A,
};

static const int32_t qmat0A[MAT_SIZE] = {
    0x0040000, 0x004293F, 0x00214A0, 0x0042A28, 0x00310F1, 0x0042A28,
    0x003F7F5, 0x0030EE5, 0x0061DCA, 0x003F7F5, 0x0036000, 0x005812C,
    0x00614E2, 0x002C096, 0x0036000, 0x002CC8E, 0x002787D, 0x0057928,
    0x0057928, 0x004F0FB, 0x002CC8E, 0x008861A, 0x007C3C7, 0x009CC9A,
    0x00A5EC1, 0x009CC9A, 0x003E1E4, 0x004430D, 0x00246B3, 0x00306AF,
    0x007E445, 0x0090A20, 0x0090A20, 0x007E445, 0x00C1ABA, 0x0091ACC,
    0x00CEA63, 0x00BEEB4, 0x007468B, 0x007E000, 0x007468B, 0x005F75A,
    0x0019D4C, 0x0033E8C, 0x0057D20, 0x00655AD, 0x00655AD, 0x00AFA40,
    0x00CFA2F, 0x00BEC2D, 0x009BDD5, 0x00517C6, 0x004DEEA, 0x002FB0B,
    0x005398F, 0x007D036, 0x00FA06C, 0x014E63E, 0x010E885, 0x00BF8D6,
    0x0043A21, 0x0067EC7, 0x00CFD8F, 0x00705A9,
};

static const int32_t qmat0B[MAT_SIZE] = {
    0x0040000, 0x004293F, 0x00214A0, 0x0042A28, 0x00310F1, 0x0042A28,
    0x005830D, 0x0043F5A, 0x0087EB5, 0x005830D, 0x004E000, 0x007A52F,
    0x0085278, 0x003D297, 0x004E000, 0x003D48C, 0x0036183, 0x007C71E,
    0x007C71E, 0x006C307, 0x003D48C, 0x008861A, 0x007C3C7, 0x009CC9A,
    0x00A5EC1, 0x009CC9A, 0x003E1E4, 0x004430D, 0x00246B3, 0x00306AF,
    0x007E445, 0x0090A20, 0x0090A20, 0x007E445, 0x00C1ABA, 0x0091ACC,
    0x01A1E3F, 0x0182149, 0x00E8D15, 0x00FC000, 0x00E8D15, 0x00C10A4,
    0x00343C8, 0x0067D17, 0x00B18CC, 0x00CAB59, 0x00CAB59, 0x0163198,
    0x019F45E, 0x02FEEFD, 0x026C35F, 0x0147CB9, 0x01361B0, 0x00BFBBF,
    0x00A805D, 0x00FB4D5, 0x01F69AB, 0x02A0174, 0x021FAA8, 0x0180DC9,
    0x0087EAA, 0x00CFD8F, 0x019FB1E, 0x00E0B52,
};

static const int32_t qmat0C[MAT_SIZE] = {
    0x0040000, 0x004DACA, 0x0026D65, 0x004DBD9, 0x00393C4, 0x004DBD9,
    0x004A148, 0x0039160, 0x00722C1, 0x004A148, 0x003F000, 0x0066C09,
    0x007185D, 0x0033604, 0x003F000, 0x00343FB, 0x002E1E8, 0x00662AF,
    0x00662AF, 0x005C3CF, 0x00343FB, 0x009F1C9, 0x0090F13, 0x00B6EB3,
    0x00C1936, 0x00B6EB3, 0x0048789, 0x004F8E5, 0x002A7D1, 0x00387CC,
    0x00934FB, 0x00A8BCF, 0x00A8BCF, 0x00934FB, 0x00E1F2E, 0x00A9F44,
    0x00F1173, 0x00DEBD1, 0x0087CF7, 0x0093000, 0x0087CF7, 0x006F5E9,
    0x001E22E, 0x003C8F8, 0x0066750, 0x00763F4, 0x00763F4, 0x00CCEA0,
    0x00F23E1, 0x00DE8DF, 0x00B5D78, 0x005F111, 0x005AEBC, 0x0037A38,
    0x006187D, 0x0091D95, 0x0123B29, 0x01861F3, 0x013B9F0, 0x00DF7A4,
    0x004EE7C, 0x00793E9, 0x00F27D1, 0x0083145,
};

static const int32_t qmat0D[MAT_SIZE] = {
    0x0040000, 0x004DACA, 0x0026D65, 0x004DBD9, 0x00393C4, 0x004DBD9,
    0x0066E3A, 0x004F494, 0x009E928, 0x0066E3A, 0x005B000, 0x008EB61,
    0x009B58C, 0x00475B1, 0x005B000, 0x00477F9, 0x003F1C4, 0x00912F8,
    0x00912F8, 0x007E388, 0x00477F9, 0x009F1C9, 0x0090F13, 0x00B6EB3,
    0x00C1936, 0x00B6EB3, 0x0048789, 0x004F8E5, 0x002A7D1, 0x00387CC,
    0x00934FB, 0x00A8BCF, 0x00A8BCF, 0x00934FB, 0x00E1F2E, 0x00A9F44,
    0x01E789E, 0x01C26D5, 0x010F9EE, 0x0126000, 0x010F9EE, 0x00E136B,
    0x003CF14, 0x00791F1, 0x00CF243, 0x00EC7E8, 0x00EC7E8, 0x019E487,
    0x01E47C3, 0x037EC27, 0x02D3944, 0x017E6D8, 0x0169CA2, 0x00DFB0A,
    0x00C406D, 0x01252F9, 0x024A5F2, 0x03101B2, 0x027A46F, 0x01C1016,
    0x009E91C, 0x00F27D1, 0x01E4FA3, 0x010628B,
};

static const int32_t qmat0E[MAT_SIZE] = {
    0x0040000, 0x0058C54, 0x002C62A, 0x0058D8A, 0x0041697, 0x0058D8A,
    0x0054A9C, 0x00413DC, 0x00827B8, 0x0054A9C, 0x0048000, 0x00756E5,
    0x0081BD8, 0x003AB73, 0x0048000, 0x003BB68, 0x0034B52, 0x0074C35,
    0x0074C35, 0x00696A4, 0x003BB68, 0x00B5D78, 0x00A5A5F, 0x00D10CD,
    0x00DD3AB, 0x00D10CD, 0x0052D2F, 0x005AEBC, 0x00308EF, 0x00408E9,
    0x00A85B1, 0x00C0D7F, 0x00C0D7F, 0x00A85B1, 0x01023A3, 0x00C23BB,
    0x0113883, 0x00FE8EF, 0x009B363, 0x00A8000, 0x009B363, 0x007F478,
    0x0022710, 0x0045365, 0x0075180, 0x008723C, 0x008723C, 0x00EA300,
    0x0114D94, 0x00FE591, 0x00CFD1C, 0x006CA5D, 0x0067E8E, 0x003F964,
    0x006F76A, 0x00A6AF3, 0x014D5E6, 0x01BDDA8, 0x0168B5C, 0x00FF672,
    0x005A2D7, 0x008A90A, 0x0115214, 0x0095CE2,
};

static const int32_t qmat0F[MAT_SIZE] = {
    0x0040000, 0x0058C54, 0x002C62A, 0x0058D8A, 0x0041697, 0x0058D8A,
    0x0075967, 0x005A9CE, 0x00B539C, 0x0075967, 0x0068000, 0x00A3194,
    0x00B18A0, 0x00518CA, 0x0068000, 0x0051B65, 0x0048204, 0x00A5ED3,
    0x00A5ED3, 0x0090409, 0x0051B65, 0x00B5D78, 0x00A5A5F, 0x00D10CD,
    0x00DD3AB, 0x00D10CD, 0x0052D2F, 0x005AEBC, 0x00308EF, 0x00408E9,
    0x00A85B1, 0x00C0D7F, 0x00C0D7F, 0x00A85B1, 0x01023A3, 0x00C23BB,
    0x022D2FE, 0x0202C61, 0x01366C7, 0x0150000, 0x01366C7, 0x0101631,
    0x0045A60, 0x008A6CA, 0x00ECBBB, 0x010E477, 0x010E477, 0x01D9776,
    0x0229B27, 0x03FE951, 0x033AF2A, 0x01B50F6, 0x019D795, 0x00FFA54,
    0x00E007C, 0x014F11C, 0x029E239, 0x03801F0, 0x02D4E36, 0x0201262,
    0x00B538D, 0x0115214, 0x022A428, 0x012B9C3,
};

static const int32_t qmat10[MAT_SIZE] = {
    0x0040000, 0x006EF69, 0x00377B5, 0x006F0ED, 0x0051C3D, 0x006F0ED,
    0x0069D43, 0x00518D3, 0x00A31A6, 0x0069D43, 0x005A000, 0x0092C9F,
    0x00A22CD, 0x004964F, 0x005A000, 0x004AA42, 0x0041E26, 0x0091F43,
    0x0091F43, 0x0083C4D, 0x004AA42, 0x00E34D6, 0x00CF0F6, 0x0105500,
    0x0114896, 0x0105500, 0x006787B, 0x0071A6B, 0x003CB2A, 0x0050B23,
    0x00D271E, 0x00F10DF, 0x00F10DF, 0x00D271E, 0x0142C8B, 0x00F2CAA,
    0x01586A4, 0x013E32B, 0x00C203C, 0x00D2000, 0x00C203C, 0x009F196,
    0x002B0D5, 0x005683E, 0x00925E0, 0x00A8ECA, 0x00A8ECA, 0x0124BC0,
    0x015A0F9, 0x013DEF5, 0x0103C63, 0x0087CF4, 0x0081E31, 0x004F7BD,
    0x008B544, 0x00D05B0, 0x01A0B5F, 0x022D511, 0x01C2E32, 0x013F40F,
    0x0070B8D, 0x00AD34C, 0x015A699, 0x00BB41A,
};

static const int32_t qmat11[MAT_SIZE] = {
    0x0040000, 0x006EF69, 0x00377B5, 0x006F0ED, 0x0051C3D, 0x006F0ED,
    0x0092FC0, 0x0071441, 0x00E2883, 0x0092FC0, 0x0082000, 0x00CBDF9,
    0x00DDEC8, 0x0065EFC, 0x0082000, 0x006623F, 0x005A285, 0x00CF687,
    0x00CF687, 0x00B450B, 0x006623F, 0x00E34D6, 0x00CF0F6, 0x0105500,
    0x0114896, 0x0105500, 0x006787B, 0x0071A6B, 0x003CB2A, 0x0050B23,
    0x00D271E, 0x00F10DF, 0x00F10DF, 0x00D271E, 0x0142C8B, 0x00F2CAA,
    0x02B87BE, 0x028377A, 0x0184078, 0x01A4000, 0x0184078, 0x0141BBD,
    0x00570F8, 0x00AD07C, 0x0127EA9, 0x0151D95, 0x0151D95, 0x024FD53,
    0x02B41F1, 0x04FE3A6, 0x0409AF4, 0x0222534, 0x0204D7A, 0x013F8E9,
    0x011809B, 0x01A2D64, 0x0345AC7, 0x046026C, 0x038A1C3, 0x02816FA,
    0x00E2871, 0x015A699, 0x02B4D32, 0x0176834,
};

static const int32_t qmat12[MAT_SIZE] = {
    0x0040000, 0x008527E, 0x004293F, 0x0085450, 0x00621E3, 0x0085450,
    0x007EFEA, 0x0061DCA, 0x00C3B94, 0x007EFEA, 0x006C000, 0x00B0258,
    0x00C29C3, 0x005812C, 0x006C000, 0x005991C, 0x004F0FB, 0x00AF250,
    0x00AF250, 0x009E1F6, 0x005991C, 0x0110C35, 0x00F878E, 0x0139934,
    0x014BD81, 0x0139934, 0x007C3C7, 0x008861A, 0x0048D66, 0x0060D5D,
    0x00FC88A, 0x012143F, 0x012143F, 0x00FC88A, 0x0183574, 0x0123599,
    0x019D4C5, 0x017DD67, 0x00E8D15, 0x00FC000, 0x00E8D15, 0x00BEEB4,
    0x0033A99, 0x0067D17, 0x00AFA40, 0x00CAB59, 0x00CAB59, 0x015F480,
    0x019F45E, 0x017D85A, 0x0137BAA, 0x00A2F8C, 0x009BDD5, 0x005F616,
    0x00A731F, 0x00FA06C, 0x01F40D9, 0x029CC7B, 0x021D109, 0x017F1AB,
    0x0087442, 0x00CFD8F, 0x019FB1E, 0x00E0B52,
};

static const int32_t qmat13[MAT_SIZE] = {
    0x0040000, 0x008527E, 0x004293F, 0x0085450, 0x00621E3, 0x0085450,
    0x00B061A, 0x0087EB5, 0x010FD69, 0x00B061A, 0x009C000, 0x00F4A5E,
    0x010A4F0, 0x007A52F, 0x009C000, 0x007A918, 0x006C307, 0x00F8E3C,
    0x00F8E3C, 0x00D860D, 0x007A918, 0x0110C35, 0x00F878E, 0x0139934,
    0x014BD81, 0x0139934, 0x007C3C7, 0x008861A, 0x0048D66, 0x0060D5D,
    0x00FC88A, 0x012143F, 0x012143F, 0x00FC88A, 0x0183574, 0x0123599,
    0x0343C7D, 0x0304292, 0x01D1A2A, 0x01F8000, 0x01D1A2A, 0x0182149,
    0x0068790, 0x00CFA2F, 0x0163198, 0x01956B3, 0x01956B3, 0x02C6330,
    0x033E8BB, 0x05FDDFA, 0x04D86BE, 0x028F971, 0x026C35F, 0x017F77F,
    0x01500BA, 0x01F69AB, 0x03ED355, 0x05402E9, 0x043F550, 0x0301B93,
    0x010FD54, 0x019FB1E, 0x033F63C, 0x01C16A5,
};

static const int32_t qmat14[MAT_SIZE] = {
    0x0040000, 0x009B593, 0x004DACA, 0x009B7B2, 0x0072789, 0x009B7B2,
    0x0094291, 0x00722C1, 0x00E4582, 0x0094291, 0x007E000, 0x00CD812,
    0x00E30B9, 0x0066C09, 0x007E000, 0x00687F5, 0x005C3CF, 0x00CC55D,
    0x00CC55D, 0x00B879F, 0x00687F5, 0x013E393, 0x0121E26, 0x016DD67,
    0x018326C, 0x016DD67, 0x0090F13, 0x009F1C9, 0x0054FA2, 0x0070F97,
    0x01269F7, 0x015179F, 0x015179F, 0x01269F7, 0x01C3E5D, 0x0153E87,
    0x01E22E6, 0x01BD7A3, 0x010F9EE, 0x0126000, 0x010F9EE, 0x00DEBD1,
    0x003C45D, 0x00791F1, 0x00CCEA0, 0x00EC7E8, 0x00EC7E8, 0x0199D41,
    0x01E47C3, 0x01BD1BE, 0x016BAF1, 0x00BE223, 0x00B5D78, 0x006F46F,
    0x00C30F9, 0x0123B29, 0x0247652, 0x030C3E5, 0x02773E0, 0x01BEF48,
    0x009DCF8, 0x00F27D1, 0x01E4FA3, 0x010628B,
};

static const int32_t qmat15[MAT_SIZE] = {
    0x0040000, 0x009B593, 0x004DACA, 0x009B7B2, 0x0072789, 0x009B7B2,
    0x00CDC74, 0x009E928, 0x013D250, 0x00CDC74, 0x00B6000, 0x011D6C3,
    0x0136B18, 0x008EB61, 0x00B6000, 0x008EFF2, 0x007E388, 0x01225F0,
    0x01225F0, 0x00FC70F, 0x008EFF2, 0x013E393, 0x0121E26, 0x016DD67,
    0x018326C, 0x016DD67, 0x0090F13, 0x009F1C9, 0x0054FA2, 0x0070F97,
    0x01269F7, 0x015179F, 0x015179F, 0x01269F7, 0x01C3E5D, 0x0153E87,
    0x03CF13D, 0x0384DAA, 0x021F3DC, 0x024C000, 0x021F3DC, 0x01C26D5,
    0x0079E28, 0x00F23E1, 0x019E487, 0x01D8FD0, 0x01D8FD0, 0x033C90E,
    0x03C8F85, 0x06FD84F, 0x05A7289, 0x02FCDAF, 0x02D3944, 0x01BF614,
    0x01880D9, 0x024A5F2, 0x0494BE4, 0x0620365, 0x04F48DE, 0x038202B,
    0x013D237, 0x01E4FA3, 0x03C9F46, 0x020C516,
};

static const int32_t qmat16[MAT_SIZE] = {
    0x0040000, 0x00B18A8, 0x0058C54, 0x00B1B15, 0x0082D2E, 0x00B1B15,
    0x00A9538, 0x00827B8, 0x0104F6F, 0x00A9538, 0x0090000, 0x00EADCB,
    0x01037AF, 0x00756E5, 0x0090000, 0x00776CF, 0x00696A4, 0x00E986B,
    0x00E986B, 0x00D2D48, 0x00776CF, 0x016BAF1, 0x014B4BD, 0x01A219A,
    0x01BA757, 0x01A219A, 0x00A5A5F, 0x00B5D78, 0x00611DE, 0x00811D1,
    0x0150B63, 0x0181AFF, 0x0181AFF, 0x0150B63, 0x0204745, 0x0184776,
    0x0227107, 0x01FD1DF, 0x01366C7, 0x0150000, 0x01366C7, 0x00FE8EF,
    0x0044E21, 0x008A6CA, 0x00EA300, 0x010E477, 0x010E477, 0x01D4601,
    0x0229B27, 0x01FCB22, 0x019FA38, 0x00D94BA, 0x00CFD1C, 0x007F2C9,
    0x00DEED4, 0x014D5E6, 0x029ABCC, 0x037BB4F, 0x02D16B7, 0x01FECE4,
    0x00B45AE, 0x0115214, 0x022A428, 0x012B9C3,
};

static const int32_t qmat17[MAT_SIZE] = {
    0x0040000, 0x00B18A8, 0x0058C54, 0x00B1B15, 0x0082D2E, 0x00B1B15,
    0x00EB2CD, 0x00B539C, 0x016A737, 0x00EB2CD, 0x00D0000, 0x0146328,
    0x0163140, 0x00A3194, 0x00D0000, 0x00A36CB, 0x0090409, 0x014BDA5,
    0x014BDA5, 0x0120812, 0x00A36CB, 0x016BAF1, 0x014B4BD, 0x01A219A,
    0x01BA757, 0x01A219A, 0x00A5A5F, 0x00B5D78, 0x00611DE, 0x00811D1,
    0x0150B63, 0x0181AFF, 0x0181AFF, 0x0150B63, 0x0204745, 0x0184776,
    0x045A5FD, 0x04058C2, 0x026CD8D, 0x02A0000, 0x026CD8D, 0x0202C61,
    0x008B4C0, 0x0114D94, 0x01D9776, 0x021C8EE, 0x021C8EE, 0x03B2EEB,
    0x045364F, 0x07FD2A3, 0x0675E53, 0x036A1ED, 0x033AF2A, 0x01FF4A9,
    0x01C00F8, 0x029E239, 0x053C472, 0x07003E1, 0x05A9C6B, 0x04024C4,
    0x016A71B, 0x022A428, 0x0454850, 0x0257386,
};

static const int32_t qmat18[MAT_SIZE] = {
    0x0040000, 0x00C7BBD, 0x0063DDF, 0x00C7E77, 0x00932D4, 0x00C7E77,
    0x00BE7DF, 0x0092CAF, 0x012595D, 0x00BE7DF, 0x00A2000, 0x0108384,
    0x0123EA5, 0x00841C2, 0x00A2000, 0x00865A9, 0x0076978, 0x0106B78,
    0x0106B78, 0x00ED2F1, 0x00865A9, 0x019924F, 0x0174B55, 0x01D65CD,
    0x01F1C42, 0x01D65CD, 0x00BA5AB, 0x00CC927, 0x006D419, 0x009140C,
    0x017ACCF, 0x01B1E5F, 0x01B1E5F, 0x017ACCF, 0x024502E, 0x01B5065,
    0x026BF28, 0x023CC1B, 0x015D3A0, 0x017A000, 0x015D3A0, 0x011E60D,
    0x004D7E5, 0x009BBA3, 0x0107760, 0x0130106, 0x0130106, 0x020EEC1,
    0x026EE8C, 0x023C486, 0x01D397F, 0x00F4751, 0x00E9CBF, 0x008F122,
    0x00FACAE, 0x01770A2, 0x02EE145, 0x03EB2B9, 0x032B98E, 0x023EA81,
    0x00CAE64, 0x0137C56, 0x026F8AD, 0x01510FC,
};

static const int32_t qmat19[MAT_SIZE] = {
    0x0040000, 0x00C7BBD, 0x0063DDF, 0x00C7E77, 0x00932D4, 0x00C7E77,
    0x0108927, 0x00CBE0F, 0x0197C1E, 0x0108927, 0x00EA000, 0x016EF8D,
    0x018F768, 0x00B77C6, 0x00EA000, 0x00B7DA4, 0x00A248A, 0x017555A,
    0x017555A, 0x0144914, 0x00B7DA4, 0x019924F, 0x0174B55, 0x01D65CD,
    0x01F1C42, 0x01D65CD, 0x00BA5AB, 0x00CC927, 0x006D419, 0x009140C,
    0x017ACCF, 0x01B1E5F, 0x01B1E5F, 0x017ACCF, 0x024502E, 0x01B5065,
    0x04E5ABC, 0x04863DB, 0x02BA73F, 0x02F4000, 0x02BA73F, 0x02431ED,
    0x009CB58, 0x0137746, 0x0214A64, 0x026020C, 0x026020C, 0x04294C8,
    0x04DDD19, 0x08FCCF7, 0x0744A1D, 0x03D762A, 0x03A250F, 0x023F33E,
    0x01F8117, 0x02F1E80, 0x05E3D00, 0x07E045D, 0x065EFF9, 0x048295C,
    0x0197BFE, 0x026F8AD, 0x04DF15A, 0x02A21F7,
};

static const int32_t qmat1A[MAT_SIZE] = {
    0x0040000, 0x00DDED2, 0x006EF69, 0x00DE1DA, 0x00A387A, 0x00DE1DA,
    0x00D3A86, 0x00A31A6, 0x014634B, 0x00D3A86, 0x00B4000, 0x012593E,
    0x014459B, 0x0092C9F, 0x00B4000, 0x0095483, 0x0083C4D, 0x0123E85,
    0x0123E85, 0x010789A, 0x0095483, 0x01C69AD, 0x019E1ED, 0x020AA01,
    0x022912D, 0x020AA01, 0x00CF0F6, 0x00E34D6, 0x0079655, 0x00A1646,
    0x01A4E3C, 0x01E21BE, 0x01E21BE, 0x01A4E3C, 0x0285917, 0x01E5954,
    0x02B0D48, 0x027C656, 0x0184078, 0x01A4000, 0x0184078, 0x013E32B,
    0x00561A9, 0x00AD07C, 0x0124BC0, 0x0151D95, 0x0151D95, 0x0249781,
    0x02B41F1, 0x027BDEB, 0x02078C6, 0x010F9E9, 0x0103C63, 0x009EF7B,
    0x0116A89, 0x01A0B5F, 0x03416BE, 0x045AA23, 0x0385C65, 0x027E81E,
    0x00E1719, 0x015A699, 0x02B4D32, 0x0176834,
};

static const int32_t qmat1B[MAT_SIZE] = {
    0x0040000, 0x00DDED2, 0x006EF69, 0x00DE1DA, 0x00A387A, 0x00DE1DA,
    0x0125F81, 0x00E2883, 0x01C5105, 0x0125F81, 0x0104000, 0x0197BF2,
    0x01BBD90, 0x00CBDF9, 0x0104000, 0x00CC47E, 0x00B450B, 0x019ED0E,
    0x019ED0E, 0x0168A16, 0x00CC47E, 0x01C69AD, 0x019E1ED, 0x020AA01,
    0x022912D, 0x020AA01, 0x00CF0F6, 0x00E34D6, 0x0079655, 0x00A1646,
    0x01A4E3C, 0x01E21BE, 0x01E21BE, 0x01A4E3C, 0x0285917, 0x01E5954,
    0x0570F7C, 0x0506EF3, 0x03080F1, 0x0348000, 0x03080F1, 0x028377A,
    0x00AE1EF, 0x015A0F9, 0x024FD53, 0x02A3B2A, 0x02A3B2A, 0x049FAA6,
    0x05683E3, 0x09FC74C, 0x08135E8, 0x0444A68, 0x0409AF4, 0x027F1D3,
    0x0230136, 0x0345AC7, 0x068B58E, 0x08C04D9, 0x0714386, 0x0502DF5,
    0x01C50E1, 0x02B4D32, 0x0569A64, 0x02ED068,
};

static const int32_t qmat1C[MAT_SIZE] = {
    0x0040000, 0x00F41E7, 0x007A0F4, 0x00F453D, 0x00B3E20, 0x00F453D,
    0x00E8D2D, 0x00B369D, 0x0166D39, 0x00E8D2D, 0x00C6000, 0x0142EF7,
    0x0164C91, 0x00A177B, 0x00C6000, 0x00A435D, 0x0090F21, 0x0141193,
    0x0141193, 0x0121E43, 0x00A435D, 0x01F410B, 0x01C7884, 0x023EE34,
    0x0260617, 0x023EE34, 0x00E3C42, 0x00FA086, 0x0085891, 0x00B1880,
    0x01CEFA8, 0x021251E, 0x021251E, 0x01CEFA8, 0x02C6200, 0x0216242,
    0x02F5B69, 0x02BC092, 0x01AAD51, 0x01CE000, 0x01AAD51, 0x015E049,
    0x005EB6D, 0x00BE556, 0x0142020, 0x0173A24, 0x0173A24, 0x0284041,
    0x02F9556, 0x02BB74F, 0x023B80D, 0x012AC80, 0x011DC06, 0x00AEDD4,
    0x0132863, 0x01CA61C, 0x0394C38, 0x04CA18D, 0x03DFF3C, 0x02BE5BA,
    0x00F7FCF, 0x017D0DB, 0x02FA1B7, 0x019BF6C,
};

static const int32_t qmat1D[MAT_SIZE] = {
    0x0040000, 0x00F41E7, 0x007A0F4, 0x00F453D, 0x00B3E20, 0x00F453D,
    0x01435DA, 0x00F92F6, 0x01F25EC, 0x01435DA, 0x011E000, 0x01C0857,
    0x01E83B8, 0x00E042B, 0x011E000, 0x00E0B57, 0x00C658C, 0x01C84C3,
    0x01C84C3, 0x018CB18, 0x00E0B57, 0x01F410B, 0x01C7884, 0x023EE34,
    0x0260617, 0x023EE34, 0x00E3C42, 0x00FA086, 0x0085891, 0x00B1880,
    0x01CEFA8, 0x021251E, 0x021251E, 0x01CEFA8, 0x02C6200, 0x0216242,
    0x05FC43B, 0x0587A0B, 0x0355AA3, 0x039C000, 0x0355AA3, 0x02C3D06,
    0x00BF887, 0x017CAAB, 0x028B042, 0x02E7447, 0x02E7447, 0x0516083,
    0x05F2AAD, 0x0AFC1A0, 0x08E21B2, 0x04B1EA5, 0x04710D9, 0x02BF068,
    0x0268155, 0x039970E, 0x0732E1D, 0x09A0555, 0x07C9713, 0x058328D,
    0x01F25C5, 0x02FA1B7, 0x05F436E, 0x0337ED9,
};

static const int32_t qmat1E[MAT_SIZE] = {
    0x0040000, 0x010A4FD, 0x008527E, 0x010A89F, 0x00C43C5, 0x010A89F,
    0x00FDFD3, 0x00C3B94, 0x0187727, 0x00FDFD3, 0x00D8000, 0x01604B0,
    0x0185387, 0x00B0258, 0x00D8000, 0x00B3237, 0x009E1F6, 0x015E4A0,
    0x015E4A0, 0x013C3EC, 0x00B3237, 0x0221869, 0x01F0F1C, 0x0273267,
    0x0297B02, 0x0273267, 0x00F878E, 0x0110C35, 0x0091ACC, 0x00C1ABA,
    0x01F9114, 0x024287E, 0x024287E, 0x01F9114, 0x0306AE8, 0x0246B31,
    0x033A98A, 0x02FBACE, 0x01D1A2A, 0x01F8000, 0x01D1A2A, 0x017DD67,
    0x0067531, 0x00CFA2F, 0x015F480, 0x01956B3, 0x01956B3, 0x02BE901,
    0x033E8BB, 0x02FB0B3, 0x026F754, 0x0145F17, 0x0137BAA, 0x00BEC2D,
    0x014E63E, 0x01F40D9, 0x03E81B1, 0x05398F7, 0x043A213, 0x02FE357,
    0x010E885, 0x019FB1E, 0x033F63C, 0x01C16A5,
};

static const int32_t qmat1F[MAT_SIZE] = {
    0x0040000, 0x010A4FD, 0x008527E, 0x010A89F, 0x00C43C5, 0x010A89F,
    0x0160C34, 0x010FD69, 0x021FAD3, 0x0160C34, 0x0138000, 0x01E94BC,
    0x02149E1, 0x00F4A5E, 0x0138000, 0x00F5230, 0x00D860D, 0x01F1C78,
    0x01F1C78, 0x01B0C1A, 0x00F5230, 0x0221869, 0x01F0F1C, 0x0273267,
    0x0297B02, 0x0273267, 0x00F878E, 0x0110C35, 0x0091ACC, 0x00C1ABA,
    0x01F9114, 0x024287E, 0x024287E, 0x01F9114, 0x0306AE8, 0x0246B31,
    0x06878FB, 0x0608524, 0x03A3454, 0x03F0000, 0x03A3454, 0x0304292,
    0x00D0F1F, 0x019F45E, 0x02C6330, 0x032AD65, 0x032AD65, 0x058C661,
    0x067D176, 0x0BFBBF4, 0x09B0D7D, 0x051F2E3, 0x04D86BE, 0x02FEEFD,
    0x02A0174, 0x03ED355, 0x07DA6AB, 0x0A805D1, 0x087EAA1, 0x0603726,
    0x021FAA8, 0x033F63C, 0x067EC78, 0x0382D4A,
};

static const int32_t qmat20[MAT_SIZE] = {
    0x0040000, 0x0136B27, 0x009B593, 0x0136F64, 0x00E4F11, 0x0136F64,
    0x0128521, 0x00E4582, 0x01C8B03, 0x0128521, 0x00FC000, 0x019B023,
    0x01C6172, 0x00CD812, 0x00FC000, 0x00D0FEB, 0x00B879F, 0x0198ABB,
    0x0198ABB, 0x0170F3E, 0x00D0FEB, 0x027C725, 0x0243C4B, 0x02DBACE,
    0x03064D8, 0x02DBACE, 0x0121E26, 0x013E393, 0x00A9F44, 0x00E1F2E,
    0x024D3ED, 0x02A2F3E, 0x02A2F3E, 0x024D3ED, 0x0387CBA, 0x02A7D0F,
    0x03C45CC, 0x037AF46, 0x021F3DC, 0x024C000, 0x021F3DC, 0x01BD7A3,
    0x00788B9, 0x00F23E1, 0x0199D41, 0x01D8FD0, 0x01D8FD0, 0x0333A81,
    0x03C8F85, 0x037A37C, 0x02D75E2, 0x017C446, 0x016BAF1, 0x00DE8DF,
    0x01861F3, 0x0247652, 0x048ECA4, 0x06187CA, 0x04EE7C1, 0x037DE90,
    0x013B9F0, 0x01E4FA3, 0x03C9F46, 0x020C516,
};

static const int32_t qmat21[MAT_SIZE] = {
    0x0040000, 0x0136B27, 0x009B593, 0x0136F64, 0x00E4F11, 0x0136F64,
    0x019B8E7, 0x013D250, 0x027A4A1, 0x019B8E7, 0x016C000, 0x023AD86,
    0x026D631, 0x011D6C3, 0x016C000, 0x011DFE3, 0x00FC70F, 0x0244BE1,
    0x0244BE1, 0x01F8E1F, 0x011DFE3, 0x027C725, 0x0243C4B, 0x02DBACE,
    0x03064D8, 0x02DBACE, 0x0121E26, 0x013E393, 0x00A9F44, 0x00E1F2E,
    0x024D3ED, 0x02A2F3E, 0x02A2F3E, 0x024D3ED, 0x0387CBA, 0x02A7D0F,
    0x079E27A, 0x0709B54, 0x043E7B8, 0x0498000, 0x043E7B8, 0x0384DAA,
    0x00F3C4F, 0x01E47C3, 0x033C90E, 0x03B1FA1, 0x03B1FA1, 0x067921B,
    0x0791F0A, 0x0DFB09D, 0x0B4E511, 0x05F9B5E, 0x05A7289, 0x037EC27,
    0x03101B2, 0x0494BE4, 0x09297C7, 0x0C406C9, 0x09E91BC, 0x0704057,
    0x027A46F, 0x03C9F46, 0x0793E8C, 0x0418A2B,
};

static const int32_t qmat22[MAT_SIZE] = {
    0x0040000, 0x0163151, 0x00B18A8, 0x0163629, 0x0105A5D, 0x0163629,
    0x0152A6F, 0x0104F6F, 0x0209EDF, 0x0152A6F, 0x0120000, 0x01D5B96,
    0x0206F5E, 0x00EADCB, 0x0120000, 0x00EED9F, 0x00D2D48, 0x01D30D5,
    0x01D30D5, 0x01A5A90, 0x00EED9F, 0x02D75E2, 0x029697B, 0x0344334,
    0x0374EAE, 0x0344334, 0x014B4BD, 0x016BAF1, 0x00C23BB, 0x01023A3,
    0x02A16C6, 0x03035FE, 0x03035FE, 0x02A16C6, 0x0408E8B, 0x0308EEC,
    0x044E20D, 0x03FA3BE, 0x026CD8D, 0x02A0000, 0x026CD8D, 0x01FD1DF,
    0x0089C42, 0x0114D94, 0x01D4601, 0x021C8EE, 0x021C8EE, 0x03A8C01,
    0x045364F, 0x03F9644, 0x033F46F, 0x01B2974, 0x019FA38, 0x00FE591,
    0x01BDDA8, 0x029ABCC, 0x0535797, 0x06F769E, 0x05A2D6E, 0x03FD9C9,
    0x0168B5C, 0x022A428, 0x0454850, 0x0257386,
};

static const int32_t qmat23[MAT_SIZE] = {
    0x0040000, 0x0163151, 0x00B18A8, 0x0163629, 0x0105A5D, 0x0163629,
    0x01D659B, 0x016A737, 0x02D4E6E, 0x01D659B, 0x01A0000, 0x028C650,
    0x02C6281, 0x0146328, 0x01A0000, 0x0146D96, 0x0120812, 0x0297B4A,
    0x0297B4A, 0x0241023, 0x0146D96, 0x02D75E2, 0x029697B, 0x0344334,
    0x0374EAE, 0x0344334, 0x014B4BD, 0x016BAF1, 0x00C23BB, 0x01023A3,
    0x02A16C6, 0x03035FE, 0x03035FE, 0x02A16C6, 0x0408E8B, 0x0308EEC,
    0x08B4BF9, 0x080B185, 0x04D9B1B, 0x0540000, 0x04D9B1B, 0x04058C2,
    0x011697F, 0x0229B27, 0x03B2EEB, 0x04391DC, 0x04391DC, 0x0765DD6,
    0x08A6C9E, 0x0FFA546, 0x0CEBCA6, 0x06D43D9, 0x0675E53, 0x03FE951,
    0x03801F0, 0x053C472, 0x0A788E4, 0x0E007C1, 0x0B538D6, 0x0804988,
    0x02D4E36, 0x0454850, 0x08A90A0, 0x04AE70D,
};

static const int32_t qmat24[MAT_SIZE] = {
    0x0040000, 0x018F77B, 0x00C7BBD, 0x018FCEF, 0x01265A8, 0x018FCEF,
    0x017CFBD, 0x012595D, 0x024B2BB, 0x017CFBD, 0x0144000, 0x0210708,
    0x0247D4A, 0x0108384, 0x0144000, 0x010CB53, 0x00ED2F1, 0x020D6F0,
    0x020D6F0, 0x01DA5E2, 0x010CB53, 0x033249E, 0x02E96AA, 0x03ACB9B,
    0x03E3883, 0x03ACB9B, 0x0174B55, 0x019924F, 0x00DA832, 0x0122817,
    0x02F599F, 0x0363CBD, 0x0363CBD, 0x02F599F, 0x048A05C, 0x036A0CA,
    0x04D7E4F, 0x0479835, 0x02BA73F, 0x02F4000, 0x02BA73F, 0x023CC1B,
    0x009AFCA, 0x0137746, 0x020EEC1, 0x026020C, 0x026020C, 0x041DD81,
    0x04DDD19, 0x047890D, 0x03A72FD, 0x01E8EA3, 0x01D397F, 0x011E243,
    0x01F595C, 0x02EE145, 0x05DC28A, 0x07D6572, 0x065731C, 0x047D502,
    0x0195CC7, 0x026F8AD, 0x04DF15A, 0x02A21F7,
};

static const int32_t qmat25[MAT_SIZE] = {
    0x0040000, 0x018F77B, 0x00C7BBD, 0x018FCEF, 0x01265A8, 0x018FCEF,
    0x021124E, 0x0197C1E, 0x032F83C, 0x021124E, 0x01D4000, 0x02DDF1A,
    0x031EED1, 0x016EF8D, 0x01D4000, 0x016FB49, 0x0144914, 0x02EAAB3,
    0x02EAAB3, 0x0289228, 0x016FB49, 0x033249E, 0x02E96AA, 0x03ACB9B,
    0x03E3883, 0x03ACB9B, 0x0174B55, 0x019924F, 0x00DA832, 0x0122817,
    0x02F599F, 0x0363CBD, 0x0363CBD, 0x02F599F, 0x048A05C, 0x036A0CA,
    0x09CB578, 0x090C7B6, 0x0574E7E, 0x05E8000, 0x0574E7E, 0x04863DB,
    0x01396AF, 0x026EE8C, 0x04294C8, 0x04C0418, 0x04C0418, 0x0852991,
    0x09BBA32, 0x11F99EF, 0x0E8943B, 0x07AEC54, 0x0744A1D, 0x047E67C,
    0x03F022E, 0x05E3D00, 0x0BC7A00, 0x0FC08BA, 0x0CBDFF1, 0x09052B9,
    0x032F7FC, 0x04DF15A, 0x09BE2B4, 0x05443EE,
};

static const int32_t qmat26[MAT_SIZE] = {
    0x0040000, 0x01BBDA5, 0x00DDED2, 0x01BC3B4, 0x01470F4, 0x01BC3B4,
    0x01A750B, 0x014634B, 0x028C697, 0x01A750B, 0x0168000, 0x024B27B,
    0x0288B36, 0x012593E, 0x0168000, 0x012A906, 0x010789A, 0x0247D0B,
    0x0247D0B, 0x020F134, 0x012A906, 0x038D35A, 0x033C3D9, 0x0415402,
    0x0452259, 0x0415402, 0x019E1ED, 0x01C69AD, 0x00F2CAA, 0x0142C8B,
    0x0349C77, 0x03C437D, 0x03C437D, 0x0349C77, 0x050B22E, 0x03CB2A7,
    0x0561A91, 0x04F8CAD, 0x03080F1, 0x0348000, 0x03080F1, 0x027C656,
    0x00AC352, 0x015A0F9, 0x0249781, 0x02A3B2A, 0x02A3B2A, 0x0492F02,
    0x05683E3, 0x04F7BD5, 0x040F18B, 0x021F3D1, 0x02078C6, 0x013DEF5,
    0x022D511, 0x03416BE, 0x0682D7D, 0x08B5446, 0x070B8CA, 0x04FD03B,
    0x01C2E32, 0x02B4D32, 0x0569A64, 0x02ED068,
};

static const int32_t qmat27[MAT_SIZE] = {
    0x0040000, 0x01BBDA5, 0x00DDED2, 0x01BC3B4, 0x01470F4, 0x01BC3B4,
    0x024BF01, 0x01C5105, 0x038A20A, 0x024BF01, 0x0208000, 0x032F7E4,
    0x0377B21, 0x0197BF2, 0x0208000, 0x01988FB, 0x0168A16, 0x033DA1D,
    0x033DA1D, 0x02D142C, 0x01988FB, 0x038D35A, 0x033C3D9, 0x0415402,
    0x0452259, 0x0415402, 0x019E1ED, 0x01C69AD, 0x00F2CAA, 0x0142C8B,
    0x0349C77, 0x03C437D, 0x03C437D, 0x0349C77, 0x050B22E, 0x03CB2A7,
    0x0AE1EF7, 0x0A0DDE6, 0x06101E2, 0x0690000, 0x06101E2, 0x0506EF3,
    0x015C3DF, 0x02B41F1, 0x049FAA6, 0x0547653, 0x0547653, 0x093F54C,
    0x0AD07C5, 0x13F8E97, 0x1026BD0, 0x08894CF, 0x08135E8, 0x04FE3A6,
    0x046026C, 0x068B58E, 0x0D16B1D, 0x11809B2, 0x0E2870C, 0x0A05BEA,
    0x038A1C3, 0x0569A64, 0x0AD34C8, 0x05DA0D0,
};

static const int32_t qmat28[MAT_SIZE] = {
    0x0040000, 0x01E83CF, 0x00F41E7, 0x01E8A79, 0x0167C3F, 0x01E8A79,
    0x01D1A59, 0x0166D39, 0x02CDA72, 0x01D1A59, 0x018C000, 0x0285DEE,
    0x02C9921, 0x0142EF7, 0x018C000, 0x01486BA, 0x0121E43, 0x0282325,
    0x0282325, 0x0243C86, 0x01486BA, 0x03E8216, 0x038F109, 0x047DC68,
    0x04C0C2F, 0x047DC68, 0x01C7884, 0x01F410B, 0x010B121, 0x0163100,
    0x039DF50, 0x0424A3D, 0x0424A3D, 0x039DF50, 0x058C3FF, 0x042C485,
    0x05EB6D3, 0x0578125, 0x0355AA3, 0x039C000, 0x0355AA3, 0x02BC092,
    0x00BD6DA, 0x017CAAB, 0x0284041, 0x02E7447, 0x02E7447, 0x0508082,
    0x05F2AAD, 0x0576E9E, 0x0477019, 0x0255900, 0x023B80D, 0x015DBA7,
    0x02650C6, 0x0394C38, 0x0729870, 0x0994319, 0x07BFE78, 0x057CB74,
    0x01EFF9E, 0x02FA1B7, 0x05F436E, 0x0337ED9,
};

static const int32_t qmat29[MAT_SIZE] = {
    0x0040000, 0x01E83CF, 0x00F41E7, 0x01E8A79, 0x0167C3F, 0x01E8A79,
    0x0286BB5, 0x01F25EC, 0x03E4BD8, 0x0286BB5, 0x023C000, 0x03810AE,
    0x03D0771, 0x01C0857, 0x023C000, 0x01C16AE, 0x018CB18, 0x0390986,
    0x0390986, 0x0319630, 0x01C16AE, 0x03E8216, 0x038F109, 0x047DC68,
    0x04C0C2F, 0x047DC68, 0x01C7884, 0x01F410B, 0x010B121, 0x0163100,
    0x039DF50, 0x0424A3D, 0x0424A3D, 0x039DF50, 0x058C3FF, 0x042C485,
    0x0BF8876, 0x0B0F417, 0x06AB545, 0x0738000, 0x06AB545, 0x0587A0B,
    0x017F10F, 0x02F9556, 0x0516083, 0x05CE88F, 0x05CE88F, 0x0A2C106,
    0x0BE5559, 0x15F8340, 0x11C4364, 0x0963D4B, 0x08E21B2, 0x057E0D0,
    0x04D02AB, 0x0732E1D, 0x0E65C39, 0x1340AAA, 0x0F92E27, 0x0B0651B,
    0x03E4B8A, 0x05F436E, 0x0BE86DC, 0x066FDB2,
};

static const int32_t qmat2A[MAT_SIZE] = {
    0x0040000, 0x02149F9, 0x010A4FD, 0x021513E, 0x018878B, 0x021513E,
    0x01FBFA7, 0x0187727, 0x030EE4E, 0x01FBFA7, 0x01B0000, 0x02C0961,
    0x030A70D, 0x01604B0, 0x01B0000, 0x016646E, 0x013C3EC, 0x02BC940,
    0x02BC940, 0x02787D8, 0x016646E, 0x04430D2, 0x03E1E38, 0x04E64CF,
    0x052F604, 0x04E64CF, 0x01F0F1C, 0x0221869, 0x0123599, 0x0183574,
    0x03F2229, 0x04850FC, 0x04850FC, 0x03F2229, 0x060D5D0, 0x048D662,
    0x0675314, 0x05F759C, 0x03A3454, 0x03F0000, 0x03A3454, 0x02FBACE,
    0x00CEA63, 0x019F45E, 0x02BE901, 0x032AD65, 0x032AD65, 0x057D202,
    0x067D176, 0x05F6166, 0x04DEEA7, 0x028BE2E, 0x026F754, 0x017D85A,
    0x029CC7B, 0x03E81B1, 0x07D0363, 0x0A731ED, 0x0874425, 0x05FC6AD,
    0x021D109, 0x033F63C, 0x067EC78, 0x0382D4A,
};

static const int32_t qmat2B[MAT_SIZE] = {
    0x0040000, 0x02149F9, 0x010A4FD, 0x021513E, 0x018878B, 0x021513E,
    0x02C1868, 0x021FAD3, 0x043F5A6, 0x02C1868, 0x0270000, 0x03D2978,
    0x04293C1, 0x01E94BC, 0x0270000, 0x01EA461, 0x01B0C1A, 0x03E38EF,
    0x03E38EF, 0x0361835, 0x01EA461, 0x04430D2, 0x03E1E38, 0x04E64CF,
    0x052F604, 0x04E64CF, 0x01F0F1C, 0x0221869, 0x0123599, 0x0183574,
    0x03F2229, 0x04850FC, 0x04850FC, 0x03F2229, 0x060D5D0, 0x048D662,
    0x0D0F1F6, 0x0C10A47, 0x07468A8, 0x07E0000, 0x07468A8, 0x0608524,
    0x01A1E3F, 0x033E8BB, 0x058C661, 0x0655ACA, 0x0655ACA, 0x0B18CC1,
    0x0CFA2ED, 0x17F77E9, 0x1361AF9, 0x0A3E5C6, 0x09B0D7D, 0x05FDDFA,
    0x05402E9, 0x07DA6AB, 0x0FB4D56, 0x1500BA2, 0x10FD541, 0x0C06E4C,
    0x043F550, 0x067EC78, 0x0CFD8F0, 0x0705A93,
};

static const int32_t qmat2C[MAT_SIZE] = {
    0x0040000, 0x0241023, 0x0120812, 0x0241803, 0x01A92D7, 0x0241803,
    0x02264F5, 0x01A8115, 0x035022A, 0x02264F5, 0x01D4000, 0x02FB4D3,
    0x034B4F9, 0x017DA6A, 0x01D4000, 0x0184222, 0x0156995, 0x02F6F5B,
    0x02F6F5B, 0x02AD32A, 0x0184222, 0x049DF8E, 0x0434B67, 0x054ED35,
    0x059DFDA, 0x054ED35, 0x021A5B4, 0x024EFC7, 0x013BA10, 0x01A39E8,
    0x0446502, 0x04E57BC, 0x04E57BC, 0x0446502, 0x068E7A2, 0x04EE840,
    0x06FEF56, 0x0676A14, 0x03F0E06, 0x0444000, 0x03F0E06, 0x033B50A,
    0x00DFDEB, 0x01C1E10, 0x02F91C1, 0x036E683, 0x036E683, 0x05F2382,
    0x0707840, 0x067542F, 0x0546D35, 0x02C235D, 0x02A369B, 0x019D50C,
    0x02D4830, 0x043B72B, 0x0876E56, 0x0B520C1, 0x09289D3, 0x067C1E6,
    0x024A275, 0x0384AC1, 0x0709582, 0x03CDBBA,
};

static const int32_t qmat2D[MAT_SIZE] = {
    0x0040000, 0x0241023, 0x0120812, 0x0241803, 0x01A92D7, 0x0241803,
    0x02FC51B, 0x024CFBA, 0x0499F73, 0x02FC51B, 0x02A4000, 0x0424242,
    0x0482011, 0x0212121, 0x02A4000, 0x0213214, 0x01D4D1D, 0x0436858,
    0x0436858, 0x03A9A39, 0x0213214, 0x049DF8E, 0x0434B67, 0x054ED35,
    0x059DFDA, 0x054ED35, 0x021A5B4, 0x024EFC7, 0x013BA10, 0x01A39E8,
    0x0446502, 0x04E57BC, 0x04E57BC, 0x0446502, 0x068E7A2, 0x04EE840,
    0x0E25B75, 0x0D12078, 0x07E1C0C, 0x0888000, 0x07E1C0C, 0x068903C,
    0x01C4B6F, 0x0383C20, 0x0602C3E, 0x06DCD06, 0x06DCD06, 0x0C0587C,
    0x0E0F081, 0x19F6C92, 0x14FF28E, 0x0B18E41, 0x0A7F947, 0x067DB24,
    0x05B0327, 0x0881F39, 0x1103E72, 0x16C0C9A, 0x1267C5C, 0x0D0777D,
    0x0499F17, 0x0709582, 0x0E12B04, 0x079B775,
};

static const int32_t qmat2E[MAT_SIZE] = {
    0x0040000, 0x026D64D, 0x0136B27, 0x026DEC9, 0x01C9E22, 0x026DEC9,
    0x0250A43, 0x01C8B03, 0x0391606, 0x0250A43, 0x01F8000, 0x0336046,
    0x038C2E5, 0x019B023, 0x01F8000, 0x01A1FD6, 0x0170F3E, 0x0331575,
    0x0331575, 0x02E1E7C, 0x01A1FD6, 0x04F8E4B, 0x0487897, 0x05B759C,
    0x060C9B0, 0x05B759C, 0x0243C4B, 0x027C725, 0x0153E87, 0x01C3E5D,
    0x049A7DA, 0x0545E7C, 0x0545E7C, 0x049A7DA, 0x070F973, 0x054FA1D,
    0x0788B98, 0x06F5E8C, 0x043E7B8, 0x0498000, 0x043E7B8, 0x037AF46,
    0x00F1173, 0x01E47C3, 0x0333A81, 0x03B1FA1, 0x03B1FA1, 0x0667502,
    0x0791F0A, 0x06F46F7, 0x05AEBC3, 0x02F888B, 0x02D75E2, 0x01BD1BE,
    0x030C3E5, 0x048ECA4, 0x091D948, 0x0C30F95, 0x09DCF81, 0x06FBD20,
    0x02773E0, 0x03C9F46, 0x0793E8C, 0x0418A2B,
};

static const int32_t qmat2F[MAT_SIZE] = {
    0x0040000, 0x026D64D, 0x0136B27, 0x026DEC9, 0x01C9E22, 0x026DEC9,
    0x03371CF, 0x027A4A1, 0x04F4941, 0x03371CF, 0x02D8000, 0x0475B0C,
    0x04DAC61, 0x023AD86, 0x02D8000, 0x023BFC6, 0x01F8E1F, 0x04897C2,
    0x04897C2, 0x03F1C3D, 0x023BFC6, 0x04F8E4B, 0x0487897, 0x05B759C,
    0x060C9B0, 0x05B759C, 0x0243C4B, 0x027C725, 0x0153E87, 0x01C3E5D,
    0x049A7DA, 0x0545E7C, 0x0545E7C, 0x049A7DA, 0x070F973, 0x054FA1D,
    0x0F3C4F4, 0x0E136A9, 0x087CF6F, 0x0930000, 0x087CF6F, 0x0709B54,
    0x01E789E, 0x03C8F85, 0x067921B, 0x0763F41, 0x0763F41, 0x0CF2437,
    0x0F23E14, 0x1BF613A, 0x169CA23, 0x0BF36BC, 0x0B4E511, 0x06FD84F,
    0x0620365, 0x09297C7, 0x1252F8F, 0x1880D93, 0x13D2377, 0x0E080AE,
    0x04F48DE, 0x0793E8C, 0x0F27D18, 0x0831457,
};

static const int32_t qmat30[MAT_SIZE] = {
    0x0040000, 0x02C62A1, 0x0163151, 0x02C6C53, 0x020B4B9, 0x02C6C53,
    0x02A54DF, 0x0209EDF, 0x0413DBE, 0x02A54DF, 0x0240000, 0x03AB72B,
    0x040DEBC, 0x01D5B96, 0x0240000, 0x01DDB3E, 0x01A5A90, 0x03A61AB,
    0x03A61AB, 0x034B520, 0x01DDB3E, 0x05AEBC3, 0x052D2F5, 0x0688669,
    0x06E9D5B, 0x0688669, 0x029697B, 0x02D75E2, 0x0184776, 0x0204745,
    0x0542D8C, 0x0606BFB, 0x0606BFB, 0x0542D8C, 0x0811D16, 0x0611DD8,
    0x089C41B, 0x07F477B, 0x04D9B1B, 0x0540000, 0x04D9B1B, 0x03FA3BE,
    0x0113883, 0x0229B27, 0x03A8C01, 0x04391DC, 0x04391DC, 0x0751803,
    0x08A6C9E, 0x07F2C88, 0x067E8DF, 0x03652E8, 0x033F46F, 0x01FCB22,
    0x037BB4F, 0x0535797, 0x0A6AF2E, 0x0DEED3C, 0x0B45ADD, 0x07FB392,
    0x02D16B7, 0x0454850, 0x08A90A0, 0x04AE70D,
};

static const int32_t qmat31[MAT_SIZE] = {
    0x0040000, 0x02C62A1, 0x0163151, 0x02C6C53, 0x020B4B9, 0x02C6C53,
    0x03ACB35, 0x02D4E6E, 0x05A9CDD, 0x03ACB35, 0x0340000, 0x0518CA0,
    0x058C501, 0x028C650, 0x0340000, 0x028DB2C, 0x0241023, 0x052F694,
    0x052F694, 0x0482046, 0x028DB2C, 0x05AEBC3, 0x052D2F5, 0x0688669,
    0x06E9D5B, 0x0688669, 0x029697B, 0x02D75E2, 0x0184776, 0x0204745,
    0x0542D8C, 0x0606BFB, 0x0606BFB, 0x0542D8C, 0x0811D16, 0x0611DD8,
    0x11697F2, 0x101630A, 0x09B3636, 0x0A80000, 0x09B3636, 0x080B185,
    0x022D2FE, 0x045364F, 0x0765DD6, 0x08723B8, 0x08723B8, 0x0ECBBAC,
    0x114D93C, 0x1FF4A8C, 0x19D794C, 0x0DA87B2, 0x0CEBCA6, 0x07FD2A3,
    0x07003E1, 0x0A788E4, 0x14F11C8, 0x1C00F83, 0x16A71AD, 0x1009310,
    0x05A9C6B, 0x08A90A0, 0x1152140, 0x095CE1A,
};

static const int32_t qmat32[MAT_SIZE] = {
    0x0040000, 0x031EEF6, 0x018F77B, 0x031F9DD, 0x024CB50, 0x031F9DD,
    0x02F9F7A, 0x024B2BB, 0x0496575, 0x02F9F7A, 0x0288000, 0x0420E11,
    0x048FA94, 0x0210708, 0x0288000, 0x02196A5, 0x01DA5E2, 0x041ADE0,
    0x041ADE0, 0x03B4BC4, 0x02196A5, 0x066493B, 0x05D2D54, 0x0759736,
    0x07C7107, 0x0759736, 0x02E96AA, 0x033249E, 0x01B5065, 0x024502E,
    0x05EB33D, 0x06C797A, 0x06C797A, 0x05EB33D, 0x09140B9, 0x06D4193,
    0x09AFC9E, 0x08F306A, 0x0574E7E, 0x05E8000, 0x0574E7E, 0x0479835,
    0x0135F94, 0x026EE8C, 0x041DD81, 0x04C0418, 0x04C0418, 0x083BB03,
    0x09BBA32, 0x08F1219, 0x074E5FB, 0x03D1D45, 0x03A72FD, 0x023C486,
    0x03EB2B9, 0x05DC28A, 0x0BB8514, 0x0FACAE4, 0x0CAE638, 0x08FAA04,
    0x032B98E, 0x04DF15A, 0x09BE2B4, 0x05443EE,
};

static const int32_t qmat33[MAT_SIZE] = {
    0x0040000, 0x031EEF6, 0x018F77B, 0x031F9DD, 0x024CB50, 0x031F9DD,
    0x042249C, 0x032F83C, 0x065F078, 0x042249C, 0x03A8000, 0x05BBE34,
    0x063DDA2, 0x02DDF1A, 0x03A8000, 0x02DF691, 0x0289228, 0x05D5567,
    0x05D5567, 0x051244F, 0x02DF691, 0x066493B, 0x05D2D54, 0x0759736,
    0x07C7107, 0x0759736, 0x02E96AA, 0x033249E, 0x01B5065, 0x024502E,
    0x05EB33D, 0x06C797A, 0x06C797A, 0x05EB33D, 0x09140B9, 0x06D4193,
    0x1396AF0, 0x1218F6B, 0x0AE9CFD, 0x0BD0000, 0x0AE9CFD, 0x090C7B6,
    0x0272D5E, 0x04DDD19, 0x0852991, 0x098082F, 0x098082F, 0x10A5322,
    0x1377463, 0x23F33DD, 0x1D12876, 0x0F5D8A9, 0x0E8943B, 0x08FCCF7,
    0x07E045D, 0x0BC7A00, 0x178F401, 0x1F81173, 0x197BFE2, 0x120A572,
    0x065EFF9, 0x09BE2B4, 0x137C568, 0x0A887DD,
};

static const int32_t qmat34[MAT_SIZE] = {
    0x0040000, 0x0377B4A, 0x01BBDA5, 0x0378768, 0x028E1E8, 0x0378768,
    0x034EA16, 0x028C697, 0x0518D2D, 0x034EA16, 0x02D0000, 0x04964F6,
    0x051166B, 0x024B27B, 0x02D0000, 0x025520D, 0x020F134, 0x048FA15,
    0x048FA15, 0x041E268, 0x025520D, 0x071A6B4, 0x06787B3, 0x082A803,
    0x08A44B2, 0x082A803, 0x033C3D9, 0x038D35A, 0x01E5954, 0x0285917,
    0x06938EF, 0x07886FA, 0x07886FA, 0x06938EF, 0x0A1645B, 0x079654E,
    0x0AC3522, 0x09F195A, 0x06101E2, 0x0690000, 0x06101E2, 0x04F8CAD,
    0x01586A4, 0x02B41F1, 0x0492F02, 0x0547653, 0x0547653, 0x0925E03,
    0x0AD07C5, 0x09EF7AA, 0x081E317, 0x043E7A2, 0x040F18B, 0x027BDEB,
    0x045AA23, 0x0682D7D, 0x0D05AFA, 0x116A88B, 0x0E17194, 0x09FA076,
    0x0385C65, 0x0569A64, 0x0AD34C8, 0x05DA0D0,
};

static const int32_t qmat35[MAT_SIZE] = {
    0x0040000, 0x0377B4A, 0x01BBDA5, 0x0378768, 0x028E1E8, 0x0378768,
    0x0497E02, 0x038A20A, 0x0714414, 0x0497E02, 0x0410000, 0x065EFC8,
    0x06EF642, 0x032F7E4, 0x0410000, 0x03311F7, 0x02D142C, 0x067B439,
    0x067B439, 0x05A2858, 0x03311F7, 0x071A6B4, 0x06787B3, 0x082A803,
    0x08A44B2, 0x082A803, 0x033C3D9, 0x038D35A, 0x01E5954, 0x0285917,
    0x06938EF, 0x07886FA, 0x07886FA, 0x06938EF, 0x0A1645B, 0x079654E,
    0x15C3DEF, 0x141BBCC, 0x0C203C3, 0x0D20000, 0x0C203C3, 0x0A0DDE6,
    0x02B87BE, 0x05683E3, 0x093F54C, 0x0A8ECA7, 0x0A8ECA7, 0x127EA97,
    0x15A0F8B, 0x27F1D2F, 0x204D79F, 0x111299F, 0x1026BD0, 0x09FC74C,
    0x08C04D9, 0x0D16B1D, 0x1A2D63A, 0x2301364, 0x1C50E18, 0x140B7D4,
    0x0714386, 0x0AD34C8, 0x15A6990, 0x0BB41A0,
};

static const int32_t qmat36[MAT_SIZE] = {
    0x0040000, 0x03D079E, 0x01E83CF, 0x03D14F2, 0x02CF87F, 0x03D14F2,
    0x03A34B2, 0x02CDA72, 0x059B4E5, 0x03A34B2, 0x0318000, 0x050BBDC,
    0x0593243, 0x0285DEE, 0x0318000, 0x0290D75, 0x0243C86, 0x050464B,
    0x050464B, 0x048790C, 0x0290D75, 0x07D042C, 0x071E211, 0x08FB8D0,
    0x098185E, 0x08FB8D0, 0x038F109, 0x03E8216, 0x0216242, 0x02C6200,
    0x073BEA0, 0x0849479, 0x0849479, 0x073BEA0, 0x0B187FE, 0x0858909,
    0x0BD6DA5, 0x0AF0249, 0x06AB545, 0x0738000, 0x06AB545, 0x0578125,
    0x017ADB5, 0x02F9556, 0x0508082, 0x05CE88F, 0x05CE88F, 0x0A10104,
    0x0BE5559, 0x0AEDD3B, 0x08EE032, 0x04AB1FF, 0x0477019, 0x02BB74F,
    0x04CA18D, 0x0729870, 0x0E530E0, 0x1328633, 0x0F7FCEF, 0x0AF96E8,
    0x03DFF3C, 0x05F436E, 0x0BE86DC, 0x066FDB2,
};

static const int32_t qmat37[MAT_SIZE] = {
    0x0040000, 0x03D079E, 0x01E83CF, 0x03D14F2, 0x02CF87F, 0x03D14F2,
    0x050D769, 0x03E4BD8, 0x07C97B0, 0x050D769, 0x0478000, 0x070215C,
    0x07A0EE2, 0x03810AE, 0x0478000, 0x0382D5C, 0x0319630, 0x072130C,
    0x072130C, 0x0632C61, 0x0382D5C, 0x07D042C, 0x071E211, 0x08FB8D0,
    0x098185E, 0x08FB8D0, 0x038F109, 0x03E8216, 0x0216242, 0x02C6200,
    0x073BEA0, 0x0849479, 0x0849479, 0x073BEA0, 0x0B187FE, 0x0858909,
    0x17F10ED, 0x161E82D, 0x0D56A8A, 0x0E70000, 0x0D56A8A, 0x0B0F417,
    0x02FE21E, 0x05F2AAD, 0x0A2C106, 0x0B9D11E, 0x0B9D11E, 0x145820D,
    0x17CAAB2, 0x2BF0680, 0x23886C9, 0x12C7A95, 0x11C4364, 0x0AFC1A0,
    0x09A0555, 0x0E65C39, 0x1CCB873, 0x2681554, 0x1F25C4D, 0x160CA36,
    0x07C9713, 0x0BE86DC, 0x17D0DB8, 0x0CDFB63,
};

static const int32_t qmat38[MAT_SIZE] = {
    0x0040000, 0x04293F2, 0x02149F9, 0x042A27C, 0x0310F16, 0x042A27C,
    0x03F7F4E, 0x030EE4E, 0x061DC9D, 0x03F7F4E, 0x0360000, 0x05812C1,
    0x0614E1A, 0x02C0961, 0x0360000, 0x02CC8DC, 0x02787D8, 0x0579280,
    0x0579280, 0x04F0FAF, 0x02CC8DC, 0x08861A5, 0x07C3C70, 0x09CC99D,
    0x0A5EC09, 0x09CC99D, 0x03E1E38, 0x04430D2, 0x0246B31, 0x0306AE8,
    0x07E4452, 0x090A1F9, 0x090A1F9, 0x07E4452, 0x0C1ABA1, 0x091ACC4,
    0x0CEA628, 0x0BEEB39, 0x07468A8, 0x07E0000, 0x07468A8, 0x05F759C,
    0x019D4C5, 0x033E8BB, 0x057D202, 0x0655ACA, 0x0655ACA, 0x0AFA404,
    0x0CFA2ED, 0x0BEC2CC, 0x09BDD4E, 0x0517C5D, 0x04DEEA7, 0x02FB0B3,
    0x05398F7, 0x07D0363, 0x0FA06C5, 0x14E63DA, 0x10E884B, 0x0BF8D5B,
    0x043A213, 0x067EC78, 0x0CFD8F0, 0x0705A93,
};

static const int32_t qmat39[MAT_SIZE] = {
    0x0040000, 0x04293F2, 0x02149F9, 0x042A27C, 0x0310F16, 0x042A27C,
    0x05830D0, 0x043F5A6, 0x087EB4B, 0x05830D0, 0x04E0000, 0x07A52F0,
    0x0852782, 0x03D2978, 0x04E0000, 0x03D48C2, 0x0361835, 0x07C71DE,
    0x07C71DE, 0x06C3069, 0x03D48C2, 0x08861A5, 0x07C3C70, 0x09CC99D,
    0x0A5EC09, 0x09CC99D, 0x03E1E38, 0x04430D2, 0x0246B31, 0x0306AE8,
    0x07E4452, 0x090A1F9, 0x090A1F9, 0x07E4452, 0x0C1ABA1, 0x091ACC4,
    0x1A1E3EB, 0x182148F, 0x0E8D151, 0x0FC0000, 0x0E8D151, 0x0C10A47,
    0x0343C7D, 0x067D176, 0x0B18CC1, 0x0CAB595, 0x0CAB595, 0x1631982,
    0x19F45DA, 0x2FEEFD2, 0x26C35F2, 0x147CB8C, 0x1361AF9, 0x0BFBBF4,
    0x0A805D1, 0x0FB4D56, 0x1F69AAC, 0x2A01744, 0x21FAA83, 0x180DC98,
    0x087EAA1, 0x0CFD8F0, 0x19FB1E0, 0x0E0B527,
};

static const int32_t qmat3A[MAT_SIZE] = {
    0x0040000, 0x0482046, 0x0241023, 0x0483007, 0x03525AD, 0x0483007,
    0x044C9EA, 0x035022A, 0x06A0454, 0x044C9EA, 0x03A8000, 0x05F69A7,
    0x06969F2, 0x02FB4D3, 0x03A8000, 0x0308444, 0x02AD32A, 0x05EDEB5,
    0x05EDEB5, 0x055A653, 0x0308444, 0x093BF1D, 0x08696CF, 0x0A9DA6A,
    0x0B3BFB4, 0x0A9DA6A, 0x0434B67, 0x049DF8E, 0x0277420, 0x03473D1,
    0x088CA03, 0x09CAF78, 0x09CAF78, 0x088CA03, 0x0D1CF44, 0x09DD07F,
    0x0DFDEAC, 0x0CED428, 0x07E1C0C, 0x0888000, 0x07E1C0C, 0x0676A14,
    0x01BFBD5, 0x0383C20, 0x05F2382, 0x06DCD06, 0x06DCD06, 0x0BE4704,
    0x0E0F081, 0x0CEA85D, 0x0A8DA6A, 0x05846BA, 0x0546D35, 0x033AA17,
    0x05A9060, 0x0876E56, 0x10EDCAB, 0x16A4182, 0x12513A7, 0x0CF83CD,
    0x04944EA, 0x0709582, 0x0E12B04, 0x079B775,
};

static const int32_t qmat3B[MAT_SIZE] = {
    0x0040000, 0x0482046, 0x0241023, 0x0483007, 0x03525AD, 0x0483007,
    0x05F8A36, 0x0499F73, 0x0933EE7, 0x05F8A36, 0x0548000, 0x0848484,
    0x0904022, 0x0424242, 0x0548000, 0x0426427, 0x03A9A39, 0x086D0B1,
    0x086D0B1, 0x0753472, 0x0426427, 0x093BF1D, 0x08696CF, 0x0A9DA6A,
    0x0B3BFB4, 0x0A9DA6A, 0x0434B67, 0x049DF8E, 0x0277420, 0x03473D1,
    0x088CA03, 0x09CAF78, 0x09CAF78, 0x088CA03, 0x0D1CF44, 0x09DD07F,
    0x1C4B6EA, 0x1A240F0, 0x0FC3818, 0x1110000, 0x0FC3818, 0x0D12078,
    0x03896DD, 0x0707840, 0x0C0587C, 0x0DB9A0C, 0x0DB9A0C, 0x180B0F8,
    0x1C1E101, 0x33ED923, 0x29FE51C, 0x1631C82, 0x14FF28E, 0x0CFB649,
    0x0B6064D, 0x1103E72, 0x2207CE5, 0x2D81935, 0x24CF8B9, 0x1A0EEFA,
    0x0933E2E, 0x0E12B04, 0x1C25608, 0x0F36EEA,
};

static const int32_t qmat3C[MAT_SIZE] = {
    0x0040000, 0x04DAC9A, 0x026D64D, 0x04DBD91, 0x0393C44, 0x04DBD91,
    0x04A1486, 0x0391606, 0x0722C0C, 0x04A1486, 0x03F0000, 0x066C08C,
    0x07185C9, 0x0336046, 0x03F0000, 0x0343FAC, 0x02E1E7C, 0x0662AEB,
    0x0662AEB, 0x05C3CF7, 0x0343FAC, 0x09F1C95, 0x090F12D, 0x0B6EB37,
    0x0C19360, 0x0B6EB37, 0x0487897, 0x04F8E4B, 0x02A7D0F, 0x0387CBA,
    0x0934FB5, 0x0A8BCF7, 0x0A8BCF7, 0x0934FB5, 0x0E1F2E6, 0x0A9F43A,
    0x0F1172F, 0x0DEBD17, 0x087CF6F, 0x0930000, 0x087CF6F, 0x06F5E8C,
    0x01E22E6, 0x03C8F85, 0x0667502, 0x0763F41, 0x0763F41, 0x0CCEA05,
    0x0F23E14, 0x0DE8DEE, 0x0B5D786, 0x05F1117, 0x05AEBC3, 0x037A37C,
    0x06187CA, 0x091D948, 0x123B291, 0x1861F29, 0x13B9F02, 0x0DF7A3F,
    0x04EE7C1, 0x0793E8C, 0x0F27D18, 0x0831457,
};

static const int32_t qmat3D[MAT_SIZE] = {
    0x0040000, 0x04DAC9A, 0x026D64D, 0x04DBD91, 0x0393C44, 0x04DBD91,
    0x066E39D, 0x04F4941, 0x09E9282, 0x066E39D, 0x05B0000, 0x08EB618,
    0x09B58C2, 0x0475B0C, 0x05B0000, 0x0477F8D, 0x03F1C3D, 0x0912F83,
    0x0912F83, 0x07E387B, 0x0477F8D, 0x09F1C95, 0x090F12D, 0x0B6EB37,
    0x0C19360, 0x0B6EB37, 0x0487897, 0x04F8E4B, 0x02A7D0F, 0x0387CBA,
    0x0934FB5, 0x0A8BCF7, 0x0A8BCF7, 0x0934FB5, 0x0E1F2E6, 0x0A9F43A,
    0x1E789E8, 0x1C26D51, 0x10F9EDE, 0x1260000, 0x10F9EDE, 0x0E136A9,
    0x03CF13D, 0x0791F0A, 0x0CF2437, 0x0EC7E83, 0x0EC7E83, 0x19E486D,
    0x1E47C29, 0x37EC275, 0x2D39446, 0x17E6D78, 0x169CA23, 0x0DFB09D,
    0x0C406C9, 0x1252F8F, 0x24A5F1E, 0x3101B25, 0x27A46EE, 0x1C1015C,
    0x09E91BC, 0x0F27D18, 0x1E4FA30, 0x10628AD,
};

static const int32_t qmat3E[MAT_SIZE] = {
    0x0040000, 0x058C543, 0x02C62A1, 0x058D8A6, 0x0416973, 0x058D8A6,
    0x054A9BD, 0x0413DBE, 0x0827B7B, 0x054A9BD, 0x0480000, 0x0756E57,
    0x081BD78, 0x03AB72B, 0x0480000, 0x03BB67B, 0x034B520, 0x074C355,
    0x074C355, 0x0696A3F, 0x03BB67B, 0x0B5D786, 0x0A5A5EB, 0x0D10CD2,
    0x0DD3AB7, 0x0D10CD2, 0x052D2F5, 0x05AEBC3, 0x0308EEC, 0x0408E8B,
    0x0A85B18, 0x0C0D7F6, 0x0C0D7F6, 0x0A85B18, 0x1023A2C, 0x0C23BB1,
    0x1138836, 0x0FE8EF6, 0x09B3636, 0x0A80000, 0x09B3636, 0x07F477B,
    0x0227107, 0x045364F, 0x0751803, 0x08723B8, 0x08723B8, 0x0EA3005,
    0x114D93C, 0x0FE5910, 0x0CFD1BE, 0x06CA5D1, 0x067E8DF, 0x03F9644,
    0x06F769E, 0x0A6AF2E, 0x14D5E5C, 0x1BDDA78, 0x168B5B9, 0x0FF6724,
    0x05A2D6E, 0x08A90A0, 0x1152140, 0x095CE1A,
};

static const int32_t qmat3F[MAT_SIZE] = {
    0x0040000, 0x058C543, 0x02C62A1, 0x058D8A6, 0x0416973, 0x058D8A6,
    0x075966A, 0x05A9CDD, 0x0B539BA, 0x075966A, 0x0680000, 0x0A31940,
    0x0B18A03, 0x0518CA0, 0x0680000, 0x051B658, 0x0482046, 0x0A5ED28,
    0x0A5ED28, 0x090408D, 0x051B658, 0x0B5D786, 0x0A5A5EB, 0x0D10CD2,
    0x0DD3AB7, 0x0D10CD2, 0x052D2F5, 0x05AEBC3, 0x0308EEC, 0x0408E8B,
    0x0A85B18, 0x0C0D7F6, 0x0C0D7F6, 0x0A85B18, 0x1023A2C, 0x0C23BB1,
    0x22D2FE4, 0x202C614, 0x1366C6C, 0x1500000, 0x1366C6C, 0x101630A,
    0x045A5FD, 0x08A6C9E, 0x0ECBBAC, 0x10E4771, 0x10E4771, 0x1D97758,
    0x229B278, 0x3FE9518, 0x33AF299, 0x1B50F65, 0x19D794C, 0x0FFA546,
    0x0E007C1, 0x14F11C8, 0x29E2390, 0x3801F06, 0x2D4E359, 0x2012620,
    0x0B538D6, 0x1152140, 0x22A4280, 0x12B9C33,
};

static const int32_t qmat40[MAT_SIZE] = {
    0x0040000, 0x063DDEB, 0x031EEF6, 0x063F3BB, 0x04996A1, 0x063F3BB,
    0x05F3EF5, 0x0496575, 0x092CAEB, 0x05F3EF5, 0x0510000, 0x0841C22,
    0x091F527, 0x0420E11, 0x0510000, 0x0432D4B, 0x03B4BC4, 0x0835BC0,
    0x0835BC0, 0x0769787, 0x0432D4B, 0x0CC9277, 0x0BA5AA8, 0x0EB2E6C,
    0x0F8E20D, 0x0EB2E6C, 0x05D2D54, 0x066493B, 0x036A0CA, 0x048A05C,
    0x0BD667B, 0x0D8F2F5, 0x0D8F2F5, 0x0BD667B, 0x1228171, 0x0DA8327,
    0x135F93D, 0x11E60D5, 0x0AE9CFD, 0x0BD0000, 0x0AE9CFD, 0x08F306A,
    0x026BF28, 0x04DDD19, 0x083BB03, 0x098082F, 0x098082F, 0x1077606,
    0x1377463, 0x11E2432, 0x0E9CBF6, 0x07A3A8B, 0x074E5FB, 0x047890D,
    0x07D6572, 0x0BB8514, 0x1770A28, 0x1F595C7, 0x195CC70, 0x11F5408,
    0x065731C, 0x09BE2B4, 0x137C568, 0x0A887DD,
};

static const int32_t qmat41[MAT_SIZE] = {
    0x0040000, 0x063DDEB, 0x031EEF6, 0x063F3BB, 0x04996A1, 0x063F3BB,
    0x0844938, 0x065F078, 0x0CBE0F1, 0x0844938, 0x0750000, 0x0B77C68,
    0x0C7BB43, 0x05BBE34, 0x0750000, 0x05BED23, 0x051244F, 0x0BAAACD,
    0x0BAAACD, 0x0A2489E, 0x05BED23, 0x0CC9277, 0x0BA5AA8, 0x0EB2E6C,
    0x0F8E20D, 0x0EB2E6C, 0x05D2D54, 0x066493B, 0x036A0CA, 0x048A05C,
    0x0BD667B, 0x0D8F2F5, 0x0D8F2F5, 0x0BD667B, 0x1228171, 0x0DA8327,
    0x272D5E1, 0x2431ED6, 0x15D39F9, 0x17A0000, 0x15D39F9, 0x1218F6B,
    0x04E5ABC, 0x09BBA32, 0x10A5322, 0x130105F, 0x130105F, 0x214A643,
    0x26EE8C7, 0x47E67BB, 0x3A250EC, 0x1EBB151, 0x1D12876, 0x11F99EF,
    0x0FC08BA, 0x178F401, 0x2F1E802, 0x3F022E7, 0x32F7FC4, 0x2414AE4,
    0x0CBDFF1, 0x137C568, 0x26F8AD0, 0x1510FBA,
};

static const int32_t qmat42[MAT_SIZE] = {
    0x0040000, 0x06EF693, 0x0377B4A, 0x06F0ECF, 0x051C3CF, 0x06F0ECF,
    0x069D42D, 0x0518D2D, 0x0A31A5A, 0x069D42D, 0x05A0000, 0x092C9ED,
    0x0A22CD6, 0x04964F6, 0x05A0000, 0x04AA41A, 0x041E268, 0x091F42B,
    0x091F42B, 0x083C4CF, 0x04AA41A, 0x0E34D68, 0x0CF0F65, 0x1055006,
    0x1148964, 0x1055006, 0x06787B3, 0x071A6B4, 0x03CB2A7, 0x050B22E,
    0x0D271DE, 0x0F10DF4, 0x0F10DF4, 0x0D271DE, 0x142C8B7, 0x0F2CA9D,
    0x1586A43, 0x13E32B4, 0x0C203C3, 0x0D20000, 0x0C203C3, 0x09F195A,
    0x02B0D48, 0x05683E3, 0x0925E03, 0x0A8ECA7, 0x0A8ECA7, 0x124BC06,
    0x15A0F8B, 0x13DEF54, 0x103C62D, 0x087CF45, 0x081E317, 0x04F7BD5,
    0x08B5446, 0x0D05AFA, 0x1A0B5F3, 0x22D5116, 0x1C2E328, 0x13F40EC,
    0x070B8CA, 0x0AD34C8, 0x15A6990, 0x0BB41A0,
};

static const int32_t qmat43[MAT_SIZE] = {
    0x0040000, 0x06EF693, 0x0377B4A, 0x06F0ECF, 0x051C3CF, 0x06F0ECF,
    0x092FC05, 0x0714414, 0x0E28828, 0x092FC05, 0x0820000, 0x0CBDF90,
    0x0DDEC84, 0x065EFC8, 0x0820000, 0x06623EE, 0x05A2858, 0x0CF6872,
    0x0CF6872, 0x0B450B0, 0x06623EE, 0x0E34D68, 0x0CF0F65, 0x1055006,
    0x1148964, 0x1055006, 0x06787B3, 0x071A6B4, 0x03CB2A7, 0x050B22E,
    0x0D271DE, 0x0F10DF4, 0x0F10DF4, 0x0D271DE, 0x142C8B7, 0x0F2CA9D,
    0x2B87BDD, 0x2837799, 0x1840787, 0x1A40000, 0x1840787, 0x141BBCC,
    0x0570F7C, 0x0AD07C5, 0x127EA97, 0x151D94D, 0x151D94D, 0x24FD52E,
    0x2B41F16, 0x4FE3A5E, 0x409AF3F, 0x222533E, 0x204D79F, 0x13F8E97,
    0x11809B2, 0x1A2D63A, 0x345AC74, 0x46026C7, 0x38A1C30, 0x2816FA7,
    0x0E2870C, 0x15A6990, 0x2B4D320, 0x1768340,
};

static const int32_t qmat44[MAT_SIZE] = {
    0x0040000, 0x07A0F3C, 0x03D079E, 0x07A29E4, 0x059F0FE, 0x07A29E4,
    0x0746964, 0x059B4E5, 0x0B369CA, 0x0746964, 0x0630000, 0x0A177B8,
    0x0B26485, 0x050BBDC, 0x0630000, 0x0521AE9, 0x048790C, 0x0A08C95,
    0x0A08C95, 0x090F217, 0x0521AE9, 0x0FA0858, 0x0E3C423, 0x11F71A0,
    0x13030BB, 0x11F71A0, 0x071E211, 0x07D042C, 0x042C485, 0x058C3FF,
    0x0E77D40, 0x10928F2, 0x10928F2, 0x0E77D40, 0x1630FFC, 0x10B1213,
    0x17ADB4A, 0x15E0492, 0x0D56A8A, 0x0E70000, 0x0D56A8A, 0x0AF0249,
    0x02F5B69, 0x05F2AAD, 0x0A10104, 0x0B9D11E, 0x0B9D11E, 0x1420207,
    0x17CAAB2, 0x15DBA76, 0x11DC065, 0x09563FF, 0x08EE032, 0x0576E9E,
    0x0994319, 0x0E530E0, 0x1CA61BF, 0x2650C65, 0x1EFF9DF, 0x15F2DD1,
    0x07BFE78, 0x0BE86DC, 0x17D0DB8, 0x0CDFB63,
};

static const int32_t qmat45[MAT_SIZE] = {
    0x0040000, 0x07A0F3C, 0x03D079E, 0x07A29E4, 0x059F0FE, 0x07A29E4,
    0x0A1AED2, 0x07C97B0, 0x0F92F5F, 0x0A1AED2, 0x08F0000, 0x0E042B8,
    0x0F41DC4, 0x070215C, 0x08F0000, 0x0705AB9, 0x0632C61, 0x0E42617,
    0x0E42617, 0x0C658C1, 0x0705AB9, 0x0FA0858, 0x0E3C423, 0x11F71A0,
    0x13030BB, 0x11F71A0, 0x071E211, 0x07D042C, 0x042C485, 0x058C3FF,
    0x0E77D40, 0x10928F2, 0x10928F2, 0x0E77D40, 0x1630FFC, 0x10B1213,
    0x2FE21DA, 0x2C3D05B, 0x1AAD514, 0x1CE0000, 0x1AAD514, 0x161E82D,
    0x05FC43B, 0x0BE5559, 0x145820D, 0x173A23B, 0x173A23B, 0x28B0419,
    0x2F95565, 0x57E0D01, 0x4710D92, 0x258F52A, 0x23886C9, 0x15F8340,
    0x1340AAA, 0x1CCB873, 0x39970E6, 0x4D02AA8, 0x3E4B89B, 0x2C1946B,
    0x0F92E27, 0x17D0DB8, 0x2FA1B6F, 0x19BF6C7,
};

static const int32_t qmat46[MAT_SIZE] = {
    0x0040000, 0x08527E4, 0x04293F2, 0x08544F9, 0x0621E2C, 0x08544F9,
    0x07EFE9C, 0x061DC9D, 0x0C3B939, 0x07EFE9C, 0x06C0000, 0x0B02582,
    0x0C29C34, 0x05812C1, 0x06C0000, 0x05991B9, 0x04F0FAF, 0x0AF2500,
    0x0AF2500, 0x09E1F5F, 0x05991B9, 0x110C349, 0x0F878E0, 0x139933B,
    0x14BD812, 0x139933B, 0x07C3C70, 0x08861A5, 0x048D662, 0x060D5D0,
    0x0FC88A3, 0x12143F1, 0x12143F1, 0x0FC88A3, 0x1835742, 0x1235989,
    0x19D4C51, 0x17DD671, 0x0E8D151, 0x0FC0000, 0x0E8D151, 0x0BEEB39,
    0x033A98A, 0x067D176, 0x0AFA404, 0x0CAB595, 0x0CAB595, 0x15F4808,
    0x19F45DA, 0x17D8598, 0x137BA9D, 0x0A2F8B9, 0x09BDD4E, 0x05F6166,
    0x0A731ED, 0x0FA06C5, 0x1F40D8B, 0x29CC7B4, 0x21D1096, 0x17F1AB5,
    0x0874425, 0x0CFD8F0, 0x19FB1E0, 0x0E0B527,
};

static const int32_t qmat47[MAT_SIZE] = {
    0x0040000, 0x08527E4, 0x04293F2, 0x08544F9, 0x0621E2C, 0x08544F9,
    0x0B061A0, 0x087EB4B, 0x10FD696, 0x0B061A0, 0x09C0000, 0x0F4A5E0,
    0x10A4F04, 0x07A52F0, 0x09C0000, 0x07A9184, 0x06C3069, 0x0F8E3BC,
    0x0F8E3BC, 0x0D860D3, 0x07A9184, 0x110C349, 0x0F878E0, 0x139933B,
    0x14BD812, 0x139933B, 0x07C3C70, 0x08861A5, 0x048D662, 0x060D5D0,
    0x0FC88A3, 0x12143F1, 0x12143F1, 0x0FC88A3, 0x1835742, 0x1235989,
    0x343C7D6, 0x304291D, 0x1D1A2A2, 0x1F80000, 0x1D1A2A2, 0x182148F,
    0x06878FB, 0x0CFA2ED, 0x1631982, 0x1956B29, 0x1956B29, 0x2C63305,
    0x33E8BB4, 0x5FDDFA4, 0x4D86BE5, 0x28F9717, 0x26C35F2, 0x17F77E9,
    0x1500BA2, 0x1F69AAC, 0x3ED3558, 0x5402E89, 0x43F5506, 0x301B92F,
    0x10FD541, 0x19FB1E0, 0x33F63BF, 0x1C16A4D,
};

static const int32_t qmat48[MAT_SIZE] = {
    0x0040000, 0x090408D, 0x0482046, 0x090600E, 0x06A4B5A, 0x090600E,
    0x08993D3, 0x06A0454, 0x0D408A9, 0x08993D3, 0x0750000, 0x0BED34D,
    0x0D2D3E3, 0x05F69A7, 0x0750000, 0x0610888, 0x055A653, 0x0BDBD6A,
    0x0BDBD6A, 0x0AB4CA7, 0x0610888, 0x1277E3A, 0x10D2D9D, 0x153B4D5,
    0x1677F69, 0x153B4D5, 0x08696CF, 0x093BF1D, 0x04EE840, 0x068E7A2,
    0x1119406, 0x1395EF0, 0x1395EF0, 0x1119406, 0x1A39E87, 0x13BA0FF,
    0x1BFBD57, 0x19DA850, 0x0FC3818, 0x1110000, 0x0FC3818, 0x0CED428,
    0x037F7AB, 0x0707840, 0x0BE4704, 0x0DB9A0C, 0x0DB9A0C, 0x17C8E08,
    0x1C1E101, 0x19D50BB, 0x151B4D4, 0x0B08D73, 0x0A8DA6A, 0x067542F,
    0x0B520C1, 0x10EDCAB, 0x21DB956, 0x2D48303, 0x24A274D, 0x19F079A,
    0x09289D3, 0x0E12B04, 0x1C25608, 0x0F36EEA,
};

static const int32_t qmat49[MAT_SIZE] = {
    0x0040000, 0x090408D, 0x0482046, 0x090600E, 0x06A4B5A, 0x090600E,
    0x0BF146D, 0x0933EE7, 0x1267DCE, 0x0BF146D, 0x0A90000, 0x1090908,
    0x1208045, 0x0848484, 0x0A90000, 0x084C84F, 0x0753472, 0x10DA161,
    0x10DA161, 0x0EA68E4, 0x084C84F, 0x1277E3A, 0x10D2D9D, 0x153B4D5,
    0x1677F69, 0x153B4D5, 0x08696CF, 0x093BF1D, 0x04EE840, 0x068E7A2,
    0x1119406, 0x1395EF0, 0x1395EF0, 0x1119406, 0x1A39E87, 0x13BA0FF,
    0x3896DD3, 0x34481E0, 0x1F8702F, 0x2220000, 0x1F8702F, 0x1A240F0,
    0x0712DBA, 0x0E0F081, 0x180B0F8, 0x1B73417, 0x1B73417, 0x30161F0,
    0x383C203, 0x67DB247, 0x53FCA38, 0x2C63904, 0x29FE51C, 0x19F6C92,
    0x16C0C9A, 0x2207CE5, 0x440F9CA, 0x5B0326A, 0x499F171, 0x341DDF3,
    0x1267C5C, 0x1C25608, 0x384AC0F, 0x1E6DDD4,
};

static const int32_t qmat4A[MAT_SIZE] = {
    0x0040000, 0x09B5935, 0x04DAC9A, 0x09B7B22, 0x0727888, 0x09B7B22,
    0x094290B, 0x0722C0C, 0x0E45818, 0x094290B, 0x07E0000, 0x0CD8118,
    0x0E30B92, 0x066C08C, 0x07E0000, 0x0687F58, 0x05C3CF7, 0x0CC55D5,
    0x0CC55D5, 0x0B879EF, 0x0687F58, 0x13E392B, 0x121E25B, 0x16DD66F,
    0x18326C0, 0x16DD66F, 0x090F12D, 0x09F1C95, 0x054FA1D, 0x070F973,
    0x1269F69, 0x15179EF, 0x15179EF, 0x1269F69, 0x1C3E5CD, 0x153E875,
    0x1E22E5E, 0x1BD7A2F, 0x10F9EDE, 0x1260000, 0x10F9EDE, 0x0DEBD17,
    0x03C45CC, 0x0791F0A, 0x0CCEA05, 0x0EC7E83, 0x0EC7E83, 0x199D409,
    0x1E47C29, 0x1BD1BDD, 0x16BAF0C, 0x0BE222D, 0x0B5D786, 0x06F46F7,
    0x0C30F95, 0x123B291, 0x2476522, 0x30C3E52, 0x2773E04, 0x1BEF47E,
    0x09DCF81, 0x0F27D18, 0x1E4FA30, 0x10628AD,
};

static const int32_t qmat4B[MAT_SIZE] = {
    0x0040000, 0x09B5935, 0x04DAC9A, 0x09B7B22, 0x0727888, 0x09B7B22,
    0x0CDC73A, 0x09E9282, 0x13D2505, 0x0CDC73A, 0x0B60000, 0x11D6C30,
    0x136B185, 0x08EB618, 0x0B60000, 0x08EFF19, 0x07E387B, 0x1225F06,
    0x1225F06, 0x0FC70F6, 0x08EFF19, 0x13E392B, 0x121E25B, 0x16DD66F,
    0x18326C0, 0x16DD66F, 0x090F12D, 0x09F1C95, 0x054FA1D, 0x070F973,
    0x1269F69, 0x15179EF, 0x15179EF, 0x1269F69, 0x1C3E5CD, 0x153E875,
    0x3CF13D0, 0x384DAA2, 0x21F3DBD, 0x24C0000, 0x21F3DBD, 0x1C26D51,
    0x079E27A, 0x0F23E14, 0x19E486D, 0x1D8FD05, 0x1D8FD05, 0x33C90DB,
    0x3C8F852, 0x6FD84EA, 0x5A7288B, 0x2FCDAF0, 0x2D39446, 0x1BF613A,
    0x1880D93, 0x24A5F1E, 0x494BE3C, 0x620364A, 0x4F48DDC, 0x38202B7,
    0x13D2377, 0x1E4FA30, 0x3C9F45F, 0x20C515A,
};

static const int32_t qmat4C[MAT_SIZE] = {
    0x0040000, 0x1208119, 0x090408D, 0x120C01B, 0x0D496B4, 0x120C01B,
    0x11327A7, 0x0D408A9, 0x1A81151, 0x11327A7, 0x0EA0000, 0x17DA69B,
    0x1A5A7C7, 0x0BED34D, 0x0EA0000, 0x0C21110, 0x0AB4CA7, 0x17B7AD5,
    0x17B7AD5, 0x156994E, 0x0C21110, 0x24EFC74, 0x21A5B3B, 0x2A769A9,
    0x2CEFED2, 0x2A769A9, 0x10D2D9D, 0x1277E3A, 0x09DD07F, 0x0D1CF44,
    0x223280D, 0x272BDE0, 0x272BDE0, 0x223280D, 0x3473D0E, 0x27741FE,
    0x37F7AAF, 0x33B50A0, 0x1F8702F, 0x2220000, 0x1F8702F, 0x19DA850,
    0x06FEF56, 0x0E0F081, 0x17C8E08, 0x1B73417, 0x1B73417, 0x2F91C11,
    0x383C203, 0x33AA175, 0x2A369A9, 0x1611AE6, 0x151B4D4, 0x0CEA85D,
    0x16A4182, 0x21DB956, 0x43B72AC, 0x5A90607, 0x4944E9A, 0x33E0F34,
    0x12513A7, 0x1C25608, 0x384AC0F, 0x1E6DDD4,
};

static const int32_t qmat4D[MAT_SIZE] = {
    0x0040000, 0x1208119, 0x090408D, 0x120C01B, 0x0D496B4, 0x120C01B,
    0x17E28DA, 0x1267DCE, 0x24CFB9B, 0x17E28DA, 0x1520000, 0x2121210,
    0x2410089, 0x1090908, 0x1520000, 0x109909D, 0x0EA68E4, 0x21B42C3,
    0x21B42C3, 0x1D4D1C9, 0x109909D, 0x24EFC74, 0x21A5B3B, 0x2A769A9,
    0x2CEFED2, 0x2A769A9, 0x10D2D9D, 0x1277E3A, 0x09DD07F, 0x0D1CF44,
    0x223280D, 0x272BDE0, 0x272BDE0, 0x223280D, 0x3473D0E, 0x27741FE,
    0x712DBA6, 0x68903C0, 0x3F0E05F, 0x4440000, 0x3F0E05F, 0x34481E0,
    0x0E25B75, 0x1C1E101, 0x30161F0, 0x36E682F, 0x36E682F, 0x602C3DF,
    0x7078406, 0xCFB648E, 0xA7F9470, 0x58C7207, 0x53FCA38, 0x33ED923,
    0x2D81935, 0x440F9CA, 0x881F394, 0xB6064D3, 0x933E2E2, 0x683BBE7,
    0x24CF8B9, 0x384AC0F, 0x709581F, 0x3CDBBA7,
};

const int32_t *const ff_hq_quants[NUM_HQ_QUANTS][2][4] = {
    { { qmat00, qmat02, qmat06, qmat0E }, { qmat01, qmat03, qmat07, qmat0F } },
    { { qmat02, qmat06, qmat0E, qmat16 }, { qmat03, qmat07, qmat0F, qmat17 } },
    { { qmat04, qmat0A, qmat12, qmat1E }, { qmat05, qmat0B, qmat13, qmat1F } },
    { { qmat06, qmat0E, qmat16, qmat22 }, { qmat07, qmat0F, qmat17, qmat23 } },
    { { qmat08, qmat10, qmat1A, qmat26 }, { qmat09, qmat11, qmat1B, qmat27 } },
    { { qmat0A, qmat12, qmat1E, qmat2A }, { qmat0B, qmat13, qmat1F, qmat2B } },
    { { qmat0C, qmat14, qmat20, qmat2E }, { qmat0D, qmat15, qmat21, qmat2F } },
    { { qmat0E, qmat16, qmat22, qmat30 }, { qmat0F, qmat17, qmat23, qmat31 } },
    { { qmat16, qmat22, qmat30, qmat3E }, { qmat17, qmat23, qmat31, qmat3F } },
    { { qmat18, qmat24, qmat32, qmat40 }, { qmat19, qmat25, qmat33, qmat41 } },
    { { qmat1A, qmat26, qmat34, qmat42 }, { qmat1B, qmat27, qmat35, qmat43 } },
    { { qmat1C, qmat28, qmat36, qmat44 }, { qmat1D, qmat29, qmat37, qmat45 } },
    { { qmat1E, qmat2A, qmat38, qmat46 }, { qmat1F, qmat2B, qmat39, qmat47 } },
    { { qmat20, qmat2E, qmat3C, qmat4A }, { qmat21, qmat2F, qmat3D, qmat4B } },
    { { qmat2C, qmat3A, qmat48, qmat4C }, { qmat2D, qmat3B, qmat49, qmat4D } },
    { { qmat3A, qmat48, qmat4C, qmat4C }, { qmat3B, qmat49, qmat4D, qmat4D } },
};

static const uint8_t hq_ac_bits[NUM_HQ_AC_ENTRIES] = {
     3,  3,  4,  4,  4,  5,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,
     6,  6,  6,  7,  7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
};

static const uint16_t hq_ac_codes[NUM_HQ_AC_ENTRIES] = {
    0x0000, 0x0001, 0x0004, 0x0005, 0x0006, 0x000E, 0x000F, 0x0010,
    0x0011, 0x0012, 0x0013, 0x0028, 0x0029, 0x002A, 0x002B, 0x002C,
    0x002D, 0x002E, 0x002F, 0x0060, 0x0061, 0x0062, 0x0063, 0x0064,
    0x0065, 0x0066, 0x0067, 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4,
    0x00D5, 0x00D6, 0x00D7, 0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC,
    0x00DD, 0x00DE, 0x00DF, 0x01C0, 0x01C1, 0x01C2, 0x01C3, 0x01C4,
    0x01C5, 0x01C6, 0x01C7, 0x01C8, 0x01C9, 0x01CA, 0x01CB, 0x01CC,
    0x01CD, 0x01CE, 0x01CF, 0x01D0, 0x01D1, 0x01D2, 0x01D3, 0x01D4,
    0x01D5, 0x01D6, 0x01D7, 0x01D8, 0x01D9, 0x01DA, 0x01DB, 0x01DC,
    0x01DD, 0x01DE, 0x01DF, 0x03C0, 0x03C1, 0x03C2, 0x03C3, 0x03C4,
    0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9, 0x03CA, 0x03CB, 0x03CC,
    0x03CD, 0x03CE, 0x03CF, 0x03D0, 0x03D1, 0x03D2, 0x03D3, 0x03D4,
    0x03D5, 0x03D6, 0x03D7, 0x03D8, 0x03D9, 0x03DA, 0x03DB, 0x03DC,
    0x03DD, 0x03DE, 0x03DF, 0x07C0, 0x07C1, 0x07C2, 0x07C3, 0x07C4,
    0x07C5, 0x07C6, 0x07C7, 0x07C8, 0x07C9, 0x07CA, 0x07CB, 0x07CC,
    0x07CD, 0x07CE, 0x07CF, 0x0FA0, 0x0FA1, 0x0FA2, 0x0FA3, 0x0FA4,
    0x0FA5, 0x0FA6, 0x0FA7, 0x0FA8, 0x0FA9, 0x0FAA, 0x0FAB, 0x0FAC,
    0x0FAD, 0x0FAE, 0x0FAF, 0x1F60, 0x1F61, 0x1F62, 0x1F63, 0x1F64,
    0x1F65, 0x1F66, 0x1F67, 0x1F68, 0x1F69, 0x1F6A, 0x1F6B, 0x1F6C,
    0x1F6D, 0x1F6E, 0x1F6F, 0x1F70, 0x1F71, 0x1F72, 0x1F73, 0x1F74,
    0x1F75, 0x1F76, 0x1F77, 0x1F78, 0x1F79, 0x1F7A, 0x1F7B, 0x1F7C,
    0x1F7D, 0x1F7E, 0x1F7F, 0x1F80, 0x1F81, 0x1F82, 0x1F83, 0x1F84,
    0x1F85, 0x1F86, 0x1F87, 0x1F88, 0x1F89, 0x1F8A, 0x1F8B, 0x1F8C,
    0x1F8D, 0x1F8E, 0x1F8F, 0x1F90, 0x1F91, 0x1F92, 0x1F93, 0x1F94,
    0x1F95, 0x1F96, 0x1F97, 0x1F98, 0x1F99, 0x1F9A, 0x1F9B, 0x1F9C,
    0x1F9D, 0x1F9E, 0x1F9F, 0x1FA0, 0x1FA1, 0x1FA2, 0x1FA3, 0x1FA4,
    0x1FA5, 0x1FA6, 0x1FA7, 0x1FA8, 0x1FA9, 0x1FAA, 0x1FAB, 0x1FAC,
    0x1FAD, 0x1FAE, 0x1FAF, 0x1FB0, 0x1FB1, 0x1FB2, 0x1FB3, 0x1FB4,
    0x1FB5, 0x1FB6, 0x1FB7, 0x1FB8, 0x1FB9, 0x1FBA, 0x1FBB, 0x1FBC,
    0x1FBD, 0x1FBE, 0x1FBF, 0xFE00, 0xFE02, 0xFE03, 0xFE04, 0xFE05,
    0xFE06, 0xFE07, 0xFE08, 0xFE09, 0xFE0A, 0xFE0B, 0xFE0C, 0xFE0D,
    0xFE0E, 0xFE0F, 0xFE10, 0xFE11, 0xFE12, 0xFE13, 0xFE14, 0xFE15,
    0xFE16, 0xFE17, 0xFE18, 0xFE19, 0xFE1A, 0xFE1B, 0xFE1C, 0xFE1D,
    0xFE1E, 0xFE1F, 0xFE20, 0xFE21, 0xFE22, 0xFE23, 0xFE24, 0xFE25,
    0xFE26, 0xFE27, 0xFE28, 0xFE29, 0xFE2A, 0xFE2B, 0xFE2C, 0xFE2D,
    0xFE2E, 0xFE2F, 0xFE30, 0xFE31, 0xFE32, 0xFE33, 0xFE34, 0xFE35,
    0xFE36, 0xFE37, 0xFE38, 0xFE39, 0xFE3A, 0xFE3B, 0xFE3C, 0xFE3D,
    0xFE3E, 0xFE3F, 0xFE40, 0xFE41, 0xFE42, 0xFE43, 0xFE44, 0xFE45,
    0xFE46, 0xFE47, 0xFE48, 0xFE49, 0xFE4A, 0xFE4B, 0xFE4C, 0xFE4D,
    0xFE4E, 0xFE4F, 0xFE50, 0xFE51, 0xFE52, 0xFE53, 0xFE54, 0xFE55,
    0xFE56, 0xFE57, 0xFE58, 0xFE59, 0xFE5A, 0xFE5B, 0xFE5C, 0xFE5D,
    0xFE5E, 0xFE5F, 0xFE60, 0xFE61, 0xFE62, 0xFE63, 0xFE64, 0xFE65,
    0xFE66, 0xFE67, 0xFE68, 0xFE69, 0xFE6A, 0xFE6B, 0xFE6C, 0xFE6D,
    0xFE6E, 0xFE6F, 0xFE70, 0xFE71, 0xFE72, 0xFE73, 0xFE74, 0xFE75,
    0xFE76, 0xFE77, 0xFE78, 0xFE79, 0xFE7A, 0xFE7B, 0xFE7C, 0xFE7D,
    0xFE7E, 0xFE7F, 0xFE80, 0xFE81, 0xFE82, 0xFE83, 0xFE84, 0xFE85,
    0xFE86, 0xFE87, 0xFE88, 0xFE89, 0xFE8A, 0xFE8B, 0xFE8C, 0xFE8D,
    0xFE8E, 0xFE8F, 0xFE90, 0xFE91, 0xFE92, 0xFE93, 0xFE94, 0xFE95,
    0xFE96, 0xFE97, 0xFE98, 0xFE99, 0xFE9A, 0xFE9B, 0xFE9C, 0xFE9D,
    0xFE9E, 0xFE9F, 0xFEA0, 0xFEA1, 0xFEA2, 0xFEA3, 0xFEA4, 0xFEA5,
    0xFEA6, 0xFEA7, 0xFEA8, 0xFEA9, 0xFEAA, 0xFEAB, 0xFEAC, 0xFEAD,
    0xFEAE, 0xFEAF, 0xFEB0, 0xFEB1, 0xFEB2, 0xFEB3, 0xFEB4, 0xFEB5,
    0xFEB6, 0xFEB7, 0xFEB8, 0xFEB9, 0xFEBA, 0xFEBB, 0xFEBC, 0xFEBD,
    0xFEBE, 0xFEBF, 0xFEC0, 0xFEC1, 0xFEC2, 0xFEC3, 0xFEC4, 0xFEC5,
    0xFEC6, 0xFEC7, 0xFEC8, 0xFEC9, 0xFECA, 0xFECB, 0xFECC, 0xFECD,
    0xFECE, 0xFECF, 0xFED0, 0xFED1, 0xFED2, 0xFED3, 0xFED4, 0xFED5,
    0xFED6, 0xFED7, 0xFED8, 0xFED9, 0xFEDA, 0xFEDB, 0xFEDC, 0xFEDD,
    0xFEDE, 0xFEDF, 0xFEE0, 0xFEE1, 0xFEE2, 0xFEE3, 0xFEE4, 0xFEE5,
    0xFEE6, 0xFEE7, 0xFEE8, 0xFEE9, 0xFEEA, 0xFEEB, 0xFEEC, 0xFEED,
    0xFEEE, 0xFEEF, 0xFEF0, 0xFEF1, 0xFEF2, 0xFEF3, 0xFEF4, 0xFEF5,
    0xFEF6, 0xFEF7, 0xFEF8, 0xFEF9, 0xFEFA, 0xFEFB, 0xFEFC, 0xFEFD,
    0xFEFE, 0xFEFF, 0xFF00, 0xFF01, 0xFF02, 0xFF03, 0xFF04, 0xFF05,
    0xFF06, 0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFF0B, 0xFF0C, 0xFF0D,
    0xFF0E, 0xFF0F, 0xFF10, 0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15,
    0xFF16, 0xFF17, 0xFF18, 0xFF19, 0xFF1A, 0xFF1B, 0xFF1C, 0xFF1D,
    0xFF1E, 0xFF1F, 0xFF20, 0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25,
    0xFF26, 0xFF27, 0xFF28, 0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D,
    0xFF2E, 0xFF2F, 0xFF30, 0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35,
    0xFF36, 0xFF37, 0xFF38, 0xFF39, 0xFF3A, 0xFF3B, 0xFF3C, 0xFF3D,
    0xFF3E, 0xFF3F, 0xFF40, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45,
    0xFF46, 0xFF47, 0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D,
    0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55,
    0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A, 0xFF5B, 0xFF5C, 0xFF5D,
    0xFF5E, 0xFF5F, 0xFF60, 0xFF61, 0xFF62, 0xFF63, 0xFF64, 0xFF65,
    0xFF66, 0xFF67, 0xFF68, 0xFF69, 0xFF6A, 0xFF6B, 0xFF6C, 0xFF6D,
    0xFF6E, 0xFF6F, 0xFF70, 0xFF71, 0xFF72, 0xFF73, 0xFF74, 0xFF75,
    0xFF76, 0xFF77, 0xFF78, 0xFF79, 0xFF7A, 0xFF7B, 0xFF7C, 0xFF7D,
    0xFF7E, 0xFF7F, 0xFF80, 0xFF81, 0xFF82, 0xFF83, 0xFF84, 0xFF85,
    0xFF86, 0xFF87, 0xFF88, 0xFF89, 0xFF8A, 0xFF8B, 0xFF8C, 0xFF8D,
    0xFF8E, 0xFF8F, 0xFF90, 0xFF91, 0xFF92, 0xFF93, 0xFF94, 0xFF95,
    0xFF96, 0xFF97, 0xFF98, 0xFF99, 0xFF9A, 0xFF9B, 0xFF9C, 0xFF9D,
    0xFF9E, 0xFF9F, 0xFFA0, 0xFFA1, 0xFFA2, 0xFFA3, 0xFFA4, 0xFFA5,
    0xFFA6, 0xFFA7, 0xFFA8, 0xFFA9, 0xFFAA, 0xFFAB, 0xFFAC, 0xFFAD,
    0xFFAE, 0xFFAF, 0xFFB0, 0xFFB1, 0xFFB2, 0xFFB3, 0xFFB4, 0xFFB5,
    0xFFB6, 0xFFB7, 0xFFB8, 0xFFB9, 0xFFBA, 0xFFBB, 0xFFBC, 0xFFBD,
    0xFFBE, 0xFFBF, 0xFFC0, 0xFFC1, 0xFFC2, 0xFFC3, 0xFFC4, 0xFFC5,
    0xFFC6, 0xFFC7, 0xFFC8, 0xFFC9, 0xFFCA, 0xFFCB, 0xFFCC, 0xFFCD,
    0xFFCE, 0xFFCF, 0xFFD0, 0xFFD1, 0xFFD2, 0xFFD3, 0xFFD4, 0xFFD5,
    0xFFD6, 0xFFD7, 0xFFD8, 0xFFD9, 0xFFDA, 0xFFDB, 0xFFDC, 0xFFDD,
    0xFFDE, 0xFFDF, 0xFFE0, 0xFFE1, 0xFFE2, 0xFFE3, 0xFFE4, 0xFFE5,
    0xFFE6, 0xFFE7, 0xFFE8, 0xFFE9, 0xFFEA, 0xFFEB, 0xFFEC, 0xFFED,
    0xFFEE, 0xFFEF, 0xFFF0, 0xFFF1, 0xFFF2, 0xFFF3, 0xFFF4, 0xFFF5,
    0xFFF6, 0xFFF7, 0xFFF8, 0xFFF9, 0xFFFA, 0xFFFB, 0xFFFC, 0xFFFD,
    0xFFFE, 0xFFFF,
};

const uint8_t ff_hq_ac_skips[NUM_HQ_AC_ENTRIES] = {
     0,  0,  0,  0, 64,  1,  1,  0,  0,  0,  0,  2,  2,  1,  1,  0,
     0,  0,  0,  3,  3,  4,  4,  0,  0,  0,  0,  5,  5,  6,  6,  2,
     2,  1,  1,  1,  1,  0,  0,  0,  0,  0,  0,  7,  7,  8,  8,  9,
     9, 10, 10,  3,  3,  4,  4,  2,  2,  1,  1,  1,  1,  1,  1,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11, 11, 12, 12, 13,
    13, 14, 14,  5,  5,  6,  6,  3,  3,  4,  4,  2,  2,  2,  2,  1,
     1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  5,  3,  3,  3,
     3,  2,  2,  1,  1,  1,  1,  1,  1,  0,  1,  6,  6,  4,  4,  3,
     3,  1,  1,  1,  1,  1,  1,  2,  3,  4,  5,  7,  7,  8,  8,  9,
     9, 10, 10,  7,  7,  8,  8,  4,  4,  3,  3,  2,  2,  2,  2,  2,
     2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  0,  1,  2,  3,  4,
     5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
    21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
    37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
    53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
};

const int16_t ff_hq_ac_syms[NUM_HQ_AC_ENTRIES] = {
      1,   -1,   2,   -2,   0,    1,  -1,    3,
     -3,    4,  -4,    1,  -1,    2,  -2,    5,
     -5,    6,  -6,    1,  -1,    1,  -1,    7,
     -7,    8,  -8,    1,  -1,    1,  -1,    2,
     -2,    3,  -3,    4,  -4,    9,  -9,   10,
    -10,   11, -11,    1,  -1,    1,  -1,    1,
     -1,    1,  -1,    2,  -2,    2,  -2,    3,
     -3,    5,  -5,    6,  -6,    7,  -7,   12,
    -12,   13, -13,   14, -14,   15, -15,   16,
    -16,   17, -17,    1,  -1,    1,  -1,    1,
     -1,    1,  -1,    2,  -2,    2,  -2,    3,
     -3,    3,  -3,    4,  -4,    5,  -5,    8,
     -8,   18, -18,   19, -19,   20, -20,   21,
    -21,   22, -22,    3,  -3,    4,  -4,    5,
     -5,    6,  -6,    9,  -9,   10, -10,   11,
    -11,    0,   0,    3,  -3,    4,  -4,    6,
     -6,   12, -12,   13, -13,   14, -14,    0,
      0,    0,   0,    2,  -2,    2,  -2,    2,
     -2,    2,  -2,    3,  -3,    3,  -3,    5,
     -5,    7,  -7,    7,  -7,    8,  -8,    9,
     -9,   10, -10,   11, -11,   15, -15,   16,
    -16,   17, -17,    0,   0,    0,   0,    0,
      0,    0,   0,    0,   0,    0,   0,    0,
      0,    0,   0,    0,   0,    0,   0,    0,
      0,    0,   0,    0,   0,    0,   0,    0,
      0,    0,   0,    0,   0,    0,   0,    0,
      0,    0,   0,    0,   0,    0,   0,    0,
      0,    0,   0,    0,   0,    0,   0,    0,
      0,    0,   0,    0,   0,    0,   0,    0,
      0,    0,   0,    0,   1,   -1,   2,   -2,
      3,   -3,   4,   -4,   5,   -5,   6,   -6,
      7,   -7,   8,   -8,   9,   -9,  10,  -10,
     11,  -11,  12,  -12,  13,  -13,  14,  -14,
     15,  -15,  16,  -16,  17,  -17,  18,  -18,
     19,  -19,  20,  -20,  21,  -21,  22,  -22,
     23,  -23,  24,  -24,  25,  -25,  26,  -26,
     27,  -27,  28,  -28,  29,  -29,  30,  -30,
     31,  -31,  32,  -32,  33,  -33,  34,  -34,
     35,  -35,  36,  -36,  37,  -37,  38,  -38,
     39,  -39,  40,  -40,  41,  -41,  42,  -42,
     43,  -43,  44,  -44,  45,  -45,  46,  -46,
     47,  -47,  48,  -48,  49,  -49,  50,  -50,
     51,  -51,  52,  -52,  53,  -53,  54,  -54,
     55,  -55,  56,  -56,  57,  -57,  58,  -58,
     59,  -59,  60,  -60,  61,  -61,  62,  -62,
     63,  -63,  64,  -64,  65,  -65,  66,  -66,
     67,  -67,  68,  -68,  69,  -69,  70,  -70,
     71,  -71,  72,  -72,  73,  -73,  74,  -74,
     75,  -75,  76,  -76,  77,  -77,  78,  -78,
     79,  -79,  80,  -80,  81,  -81,  82,  -82,
     83,  -83,  84,  -84,  85,  -85,  86,  -86,
     87,  -87,  88,  -88,  89,  -89,  90,  -90,
     91,  -91,  92,  -92,  93,  -93,  94,  -94,
     95,  -95,  96,  -96,  97,  -97,  98,  -98,
     99,  -99, 100, -100, 101, -101, 102, -102,
    103, -103, 104, -104, 105, -105, 106, -106,
    107, -107, 108, -108, 109, -109, 110, -110,
    111, -111, 112, -112, 113, -113, 114, -114,
    115, -115, 116, -116, 117, -117, 118, -118,
    119, -119, 120, -120, 121, -121, 122, -122,
    123, -123, 124, -124, 125, -125, 126, -126,
    127, -127, 128, -128, 129, -129, 130, -130,
    131, -131, 132, -132, 133, -133, 134, -134,
    135, -135, 136, -136, 137, -137, 138, -138,
    139, -139, 140, -140, 141, -141, 142, -142,
    143, -143, 144, -144, 145, -145, 146, -146,
    147, -147, 148, -148, 149, -149, 150, -150,
    151, -151, 152, -152, 153, -153, 154, -154,
    155, -155, 156, -156, 157, -157, 158, -158,
    159, -159, 160, -160, 161, -161, 162, -162,
    163, -163, 164, -164, 165, -165, 166, -166,
    167, -167, 168, -168, 169, -169, 170, -170,
    171, -171, 172, -172, 173, -173, 174, -174,
    175, -175, 176, -176, 177, -177, 178, -178,
    179, -179, 180, -180, 181, -181, 182, -182,
    183, -183, 184, -184, 185, -185, 186, -186,
    187, -187, 188, -188, 189, -189, 190, -190,
    191, -191, 192, -192, 193, -193, 194, -194,
    195, -195, 196, -196, 197, -197, 198, -198,
    199, -199, 200, -200, 201, -201, 202, -202,
    203, -203, 204, -204, 205, -205, 206, -206,
    207, -207, 208, -208, 209, -209, 210, -210,
    211, -211, 212, -212, 213, -213, 214, -214,
    215, -215, 216, -216, 217, -217, 218, -218,
    219, -219, 220, -220, 221, -221, 222, -222,
    223, -223, 224, -224, 225, -225, 226, -226,
    227, -227, 228, -228, 229, -229, 230, -230,
    231, -231, 232, -232, 233, -233, 234, -234,
    235, -235, 236, -236, 237, -237, 238, -238,
    239, -239, 240, -240, 241, -241, 242, -242,
    243, -243, 244, -244, 245, -245, 246, -246,
    247, -247, 248, -248, 249, -249, 250, -250,
    251, -251, 252, -252, 253, -253, 254, -254,
    255, -255,
};

/* tables section - one per supported profile */
static const uint8_t hq_tab_01[] = {
     0,  0, 12,  3, 20,  0, 28,  3, 40,  0,  0, 10, 15,  6, 20,
    10, 35,  6, 40, 10,  7, 13, 15, 16, 23, 13, 35, 16, 39, 13,
     7, 23, 10, 19, 23, 23, 27, 20, 39, 23,  2, 26, 10, 29, 22,
    26, 27, 24, 42, 26,  1,  0, 11,  3, 21,  0, 27,  3, 41,  0,
     1, 10, 16,  6, 21, 10, 35,  7, 41, 10,  6, 13, 16, 16, 22,
    13, 35, 17, 38, 13,  6, 23,  9, 19, 22, 23, 28, 20, 38, 23,
     3, 26,  9, 29, 23, 26, 28, 24, 43, 26,  2,  0, 10,  3, 22,
     0, 27,  4, 42,  0,  2, 10, 17,  6, 22, 10, 34,  7, 42, 10,
     5, 13, 17, 16, 21, 13, 34, 17, 37, 13,  5, 23,  9, 20, 21,
    23, 29, 20, 37, 23,  4, 26,  9, 24, 24, 26, 29, 24, 44, 26,
     3,  0,  9,  3, 23,  0, 28,  4, 43,  0,  3, 10, 17,  7, 23,
    10, 33,  7, 43, 10,  4, 13, 17, 17, 20, 13, 33, 17, 36, 13,
     4, 23, 10, 20, 20, 23, 30, 20, 36, 23,  5, 26, 10, 24, 25,
    26, 30, 24, 44, 27,  4,  0,  9,  4, 24,  0, 29,  4, 44,  0,
     4, 10, 16,  7, 24, 10, 32,  7, 44, 10,  3, 13, 16, 17, 19,
    13, 32, 17, 36, 14,  3, 23, 11, 20, 19, 23, 31, 20, 36, 18,
     6, 26, 11, 24, 26, 26, 31, 24, 43, 27,  5,  0, 10,  4, 25,
     0, 30,  4, 44,  1,  5, 10, 15,  7, 25, 10, 31,  7, 44, 11,
     2, 13, 15, 17, 18, 13, 31, 17, 37, 14,  2, 23, 12, 20, 18,
    23, 32, 20, 37, 18,  7, 26, 12, 24, 26, 27, 32, 24, 42, 27,
     6,  0, 11,  4, 26,  0, 31,  4, 43,  1,  6, 10, 14,  7, 26,
    10, 30,  7, 43, 11,  1, 13, 14, 17, 18, 14, 30, 17, 38, 14,
     1, 23, 13, 20, 18, 18, 33, 20, 38, 18,  8, 26, 13, 24, 25,
    27, 33, 24, 41, 27,  7,  0, 12,  4, 26,  1, 32,  4, 42,  1,
     7, 10, 13,  7, 26, 11, 29,  7, 42, 11,  0, 13, 13, 17, 19,
    14, 29, 17, 39, 14,  0, 23, 14, 20, 19, 18, 34, 20, 39, 18,
     8, 27, 14, 24, 24, 27, 34, 24, 40, 27,  8,  0, 13,  4, 25,
     1, 33,  4, 41,  1,  8, 10, 12,  7, 25, 11, 28,  7, 41, 11,
     0, 14, 12, 17, 20, 14, 28, 17, 40, 14,  0, 18, 15, 20, 20,
    18, 35, 20, 40, 18,  7, 27, 15, 24, 23, 27, 35, 24, 39, 27,
     8,  1, 14,  4, 24,  1, 34,  4, 40,  1,  8, 11, 11,  7, 24,
    11, 27,  7, 40, 11,  1, 14, 11, 17, 21, 14, 27, 17, 41, 14,
     1, 18, 16, 20, 21, 18, 35, 21, 41, 18,  6, 27, 16, 24, 22,
    27, 35, 25, 38, 27,  7,  1, 15,  4, 23,  1, 35,  4, 39,  1,
     7, 11, 10,  7, 23, 11, 27,  8, 39, 11,  2, 14, 10, 17, 22,
    14, 27, 12, 42, 14,  2, 18, 17, 20, 22, 18, 34, 21, 42, 18,
     5, 27, 17, 24, 21, 27, 34, 25, 37, 27,  6,  1, 16,  4, 22,
     1, 35,  5, 38,  1,  6, 11,  9,  7, 22, 11, 28,  8, 38, 11,
     3, 14,  9, 17, 23, 14, 28, 12, 43, 14,  3, 18, 17, 21, 23,
    18, 33, 21, 43, 18,  4, 27, 17, 25, 20, 27, 33, 25, 36, 27,
     5,  1, 17,  4, 21,  1, 34,  5, 37,  1,  5, 11,  9,  8, 21,
    11, 29,  8, 37, 11,  4, 14,  9, 12, 24, 14, 29, 12, 44, 14,
     4, 18, 16, 21, 24, 18, 32, 21, 44, 18,  3, 27, 16, 25, 19,
    27, 32, 25, 36, 28,  4,  1, 17,  5, 20,  1, 33,  5, 36,  1,
     4, 11, 10,  8, 20, 11, 30,  8, 36, 11,  5, 14, 10, 12, 25,
    14, 30, 12, 44, 15,  5, 18, 15, 21, 25, 18, 31, 21, 44, 19,
     2, 27, 15, 25, 18, 27, 31, 25, 37, 28,  3,  1, 16,  5, 19,
     1, 32,  5, 36,  2,  3, 11, 11,  8, 19, 11, 31,  8, 36,  6,
     6, 14, 11, 12, 26, 14, 31, 12, 43, 15,  6, 18, 14, 21, 26,
    18, 30, 21, 43, 19,  1, 27, 14, 25, 18, 28, 30, 25, 38, 28,
     2,  1, 15,  5, 18,  1, 31,  5, 37,  2,  2, 11, 12,  8, 18,
    11, 32,  8, 37,  6,  7, 14, 12, 12, 26, 15, 32, 12, 42, 15,
     7, 18, 13, 21, 26, 19, 29, 21, 42, 19,  0, 27, 13, 25, 19,
    28, 29, 25, 39, 28,  1,  1, 14,  5, 18,  2, 30,  5, 38,  2,
     1, 11, 13,  8, 18,  6, 33,  8, 38,  6,  8, 14, 13, 12, 25,
    15, 33, 12, 41, 15,  8, 18, 12, 21, 25, 19, 28, 21, 41, 19,
     0, 28, 12, 25, 20, 28, 28, 25, 40, 28,  0,  1, 13,  5, 19,
     2, 29,  5, 39,  2,  0, 11, 14,  8, 19,  6, 34,  8, 39,  6,
     8, 15, 14, 12, 24, 15, 34, 12, 40, 15,  8, 19, 11, 21, 24,
    19, 27, 21, 40, 19,  1, 28, 11, 25, 21, 28, 27, 25, 41, 28,
     0,  2, 12,  5, 20,  2, 28,  5, 40,  2,  0,  6, 15,  8, 20,
     6, 35,  8, 40,  6,  7, 15, 15, 12, 23, 15, 35, 12, 39, 15,
     7, 19, 10, 21, 23, 19, 27, 22, 39, 19,  2, 28, 10, 25, 22,
    28, 27, 26, 42, 28,  1,  2, 11,  5, 21,  2, 27,  5, 41,  2,
     1,  6, 16,  8, 21,  6, 35,  9, 41,  6,  6, 15, 16, 12, 22,
    15, 35, 13, 38, 15,  6, 19,  9, 21, 22, 19, 28, 22, 38, 19,
     3, 28,  9, 25, 23, 28, 28, 26, 43, 28,  2,  2, 10,  5, 22,
     2, 27,  0, 42,  2,  2,  6, 17,  8, 22,  6, 34,  9, 42,  6,
     5, 15, 17, 12, 21, 15, 34, 13, 37, 15,  5, 19,  9, 22, 21,
    19, 29, 22, 37, 19,  4, 28,  9, 26, 24, 28, 29, 26, 44, 28,
     3,  2,  9,  5, 23,  2, 28,  0, 43,  2,  3,  6, 17,  9, 23,
     6, 33,  9, 43,  6,  4, 15, 17, 13, 20, 15, 33, 13, 36, 15,
     4, 19, 10, 22, 20, 19, 30, 22, 36, 19,  5, 28, 10, 26, 25,
    28, 30, 26, 44, 29,  4,  2,  9,  0, 24,  2, 29,  0, 44,  2,
     4,  6, 16,  9, 24,  6, 32,  9, 44,  6,  3, 15, 16, 13, 19,
    15, 32, 13, 36, 16,  3, 19, 11, 22, 19, 19, 31, 22, 36, 20,
     6, 28, 11, 26, 26, 28, 31, 26, 43, 29,  5,  2, 10,  0, 25,
     2, 30,  0, 44,  3,  5,  6, 15,  9, 25,  6, 31,  9, 44,  7,
     2, 15, 15, 13, 18, 15, 31, 13, 37, 16,  2, 19, 12, 22, 18,
    19, 32, 22, 37, 20,  7, 28, 12, 26, 26, 29, 32, 26, 42, 29,
     6,  2, 11,  0, 26,  2, 31,  0, 43,  3,  6,  6, 14,  9, 26,
     6, 30,  9, 43,  7,  1, 15, 14, 13, 18, 16, 30, 13, 38, 16,
     1, 19, 13, 22, 18, 20, 33, 22, 38, 20,  8, 28, 13, 26, 25,
    29, 33, 26, 41, 29,  7,  2, 12,  0, 26,  3, 32,  0, 42,  3,
     7,  6, 13,  9, 26,  7, 29,  9, 42,  7,  0, 15, 13, 13, 19,
    16, 29, 13, 39, 16,  0, 19, 14, 22, 19, 20, 34, 22, 39, 20,
     8, 29, 14, 26, 24, 29, 34, 26, 40, 29,  8,  2, 13,  0, 25,
     3, 33,  0, 41,  3,  8,  6, 12,  9, 25,  7, 28,  9, 41,  7,
     0, 16, 12, 13, 20, 16, 28, 13, 40, 16,  0, 20, 15, 22, 20,
    20, 35, 22, 40, 20,  7, 29, 15, 26, 23, 29, 35, 26, 39, 29,
     8,  3, 14,  0, 24,  3, 34,  0, 40,  3,  8,  7, 11,  9, 24,
     7, 27,  9, 40,  7,  1, 16, 11, 13, 21, 16, 27, 13, 41, 16,
     1, 20, 16, 22, 21, 20, 35, 23, 41, 20,  6, 29, 16, 26, 22,
    29, 35, 27, 38, 29,  7,  3, 15,  0, 23,  3, 35,  0, 39,  3,
     7,  7, 10,  9, 23,  7, 27, 10, 39,  7,  2, 16, 10, 13, 22,
    16, 27, 14, 42, 16,  2, 20, 17, 22, 22, 20, 34, 23, 42, 20,
     5, 29, 17, 26, 21, 29, 34, 27, 37, 29,  6,  3, 16,  0, 22,
     3, 35,  1, 38,  3,  6,  7,  9,  9, 22,  7, 28, 10, 38,  7,
     3, 16,  9, 13, 23, 16, 28, 14, 43, 16,  3, 20, 17, 23, 23,
    20, 33, 23, 43, 20,  4, 29, 17, 27, 20, 29, 33, 27, 36, 29,
     5,  3, 17,  0, 21,  3, 34,  1, 37,  3,  5,  7,  9, 10, 21,
     7, 29, 10, 37,  7,  4, 16,  9, 14, 24, 16, 29, 14, 44, 16,
     4, 20, 16, 23, 24, 20, 32, 23, 44, 20,  3, 29, 16, 27, 19,
    29, 32, 27, 36, 24,  4,  3, 17,  1, 20,  3, 33,  1, 36,  3,
     4,  7, 10, 10, 20,  7, 30, 10, 36,  7,  5, 16, 10, 14, 25,
    16, 30, 14, 44, 17,  5, 20, 15, 23, 25, 20, 31, 23, 44, 21,
     2, 29, 15, 27, 18, 29, 31, 27, 37, 24,  3,  3, 16,  1, 19,
     3, 32,  1, 36,  4,  3,  7, 11, 10, 19,  7, 31, 10, 36,  8,
     6, 16, 11, 14, 26, 16, 31, 14, 43, 17,  6, 20, 14, 23, 26,
    20, 30, 23, 43, 21,  1, 29, 14, 27, 18, 24, 30, 27, 38, 24,
     2,  3, 15,  1, 18,  3, 31,  1, 37,  4,  2,  7, 12, 10, 18,
     7, 32, 10, 37,  8,  7, 16, 12, 14, 26, 17, 32, 14, 42, 17,
     7, 20, 13, 23, 26, 21, 29, 23, 42, 21,  0, 29, 13, 27, 19,
    24, 29, 27, 39, 24,  1,  3, 14,  1, 18,  4, 30,  1, 38,  4,
     1,  7, 13, 10, 18,  8, 33, 10, 38,  8,  8, 16, 13, 14, 25,
    17, 33, 14, 41, 17,  8, 20, 12, 23, 25, 21, 28, 23, 41, 21,
     0, 24, 12, 27, 20, 24, 28, 27, 40, 24,  0,  3, 13,  1, 19,
     4, 29,  1, 39,  4,  0,  7, 14, 10, 19,  8, 34, 10, 39,  8,
     8, 17, 14, 14, 24, 17, 34, 14, 40, 17,  8, 21, 11, 23, 24,
    21, 27, 23, 40, 21,  1, 24, 11, 27, 21, 24, 27, 27, 41, 24,
     0,  4, 12,  1, 20,  4, 28,  1, 40,  4,  0,  8, 15, 10, 20,
     8, 35, 10, 40,  8,  7, 17, 15, 14, 23, 17, 35, 14, 39, 17,
     7, 21, 10, 23, 23, 21, 27, 18, 39, 21,  2, 24, 10, 27, 22,
    24, 27, 28, 42, 24,  1,  4, 11,  1, 21,  4, 27,  1, 41,  4,
     1,  8, 16, 10, 21,  8, 35, 11, 41,  8,  6, 17, 16, 14, 22,
    17, 35, 15, 38, 17,  6, 21,  9, 23, 22, 21, 28, 18, 38, 21,
     3, 24,  9, 27, 23, 24, 28, 28, 43, 24,  2,  4, 10,  1, 22,
     4, 27,  2, 42,  4,  2,  8, 17, 10, 22,  8, 34, 11, 42,  8,
     5, 17, 17, 14, 21, 17, 34, 15, 37, 17,  5, 21,  9, 18, 21,
    21, 29, 18, 37, 21,  4, 24,  9, 28, 24, 24, 29, 28, 44, 24,
     3,  4,  9,  1, 23,  4, 28,  2, 43,  4,  3,  8, 17, 11, 23,
     8, 33, 11, 43,  8,  4, 17, 17, 15, 20, 17, 33, 15, 36, 17,
     4, 21, 10, 18, 20, 21, 30, 18, 36, 21,  5, 24, 10, 28, 25,
    24, 30, 28, 44, 25,  4,  4,  9,  2, 24,  4, 29,  2, 44,  4,
     4,  8, 16, 11, 24,  8, 32, 11, 44,  8,  3, 17, 16, 15, 19,
    17, 32, 15, 36, 12,  3, 21, 11, 18, 19, 21, 31, 18, 36, 22,
     6, 24, 11, 28, 26, 24, 31, 28, 43, 25,  5,  4, 10,  2, 25,
     4, 30,  2, 44,  5,  5,  8, 15, 11, 25,  8, 31, 11, 44,  9,
     2, 17, 15, 15, 18, 17, 31, 15, 37, 12,  2, 21, 12, 18, 18,
    21, 32, 18, 37, 22,  7, 24, 12, 28, 26, 25, 32, 28, 42, 25,
     6,  4, 11,  2, 26,  4, 31,  2, 43,  5,  6,  8, 14, 11, 26,
     8, 30, 11, 43,  9,  1, 17, 14, 15, 18, 12, 30, 15, 38, 12,
     1, 21, 13, 18, 18, 22, 33, 18, 38, 22,  8, 24, 13, 28, 25,
    25, 33, 28, 41, 25,  7,  4, 12,  2, 26,  5, 32,  2, 42,  5,
     7,  8, 13, 11, 26,  9, 29, 11, 42,  9,  0, 17, 13, 15, 19,
    12, 29, 15, 39, 12,  0, 21, 14, 18, 19, 22, 34, 18, 39, 22,
     8, 25, 14, 28, 24, 25, 34, 28, 40, 25,  8,  4, 13,  2, 25,
     5, 33,  2, 41,  5,  8,  8, 12, 11, 25,  9, 28, 11, 41,  9,
     0, 12, 12, 15, 20, 12, 28, 15, 40, 12,  0, 22, 15, 18, 20,
    22, 35, 18, 40, 22,  7, 25, 15, 28, 23, 25, 35, 28, 39, 25,
     8,  5, 14,  2, 24,  5, 34,  2, 40,  5,  8,  9, 11, 11, 24,
     9, 27, 11, 40,  9,  1, 12, 11, 15, 21, 12, 27, 15, 41, 12,
     1, 22, 16, 18, 21, 22, 35, 19, 41, 22,  6, 25, 16, 28, 22,
    25, 35, 29, 38, 25,  7,  5, 15,  2, 23,  5, 35,  2, 39,  5,
     7,  9, 10, 11, 23,  9, 27,  6, 39,  9,  2, 12, 10, 15, 22,
    12, 27, 16, 42, 12,  2, 22, 17, 18, 22, 22, 34, 19, 42, 22,
     5, 25, 17, 28, 21, 25, 34, 29, 37, 25,  6,  5, 16,  2, 22,
     5, 35,  3, 38,  5,  6,  9,  9, 11, 22,  9, 28,  6, 38,  9,
     3, 12,  9, 15, 23, 12, 28, 16, 43, 12,  3, 22, 17, 19, 23,
    22, 33, 19, 43, 22,  4, 25, 17, 29, 20, 25, 33, 29, 36, 25,
     5,  5, 17,  2, 21,  5, 34,  3, 37,  5,  5,  9,  9,  6, 21,
     9, 29,  6, 37,  9,  4, 12,  9, 16, 24, 12, 29, 16, 44, 12,
     4, 22, 16, 19, 24, 22, 32, 19, 44, 22,  3, 25, 16, 29, 19,
    25, 32, 29, 36, 26,  4,  5, 17,  3, 20,  5, 33,  3, 36,  5,
     4,  9, 10,  6, 20,  9, 30,  6, 36,  9,  5, 12, 10, 16, 25,
    12, 30, 16, 44, 13,  5, 22, 15, 19, 25, 22, 31, 19, 44, 23,
     2, 25, 15, 29, 18, 25, 31, 29, 37, 26,  3,  5, 16,  3, 19,
     5, 32,  3, 36,  0,  3,  9, 11,  6, 19,  9, 31,  6, 36, 10,
     6, 12, 11, 16, 26, 12, 31, 16, 43, 13,  6, 22, 14, 19, 26,
    22, 30, 19, 43, 23,  1, 25, 14, 29, 18, 26, 30, 29, 38, 26,
     2,  5, 15,  3, 18,  5, 31,  3, 37,  0,  2,  9, 12,  6, 18,
     9, 32,  6, 37, 10,  7, 12, 12, 16, 26, 13, 32, 16, 42, 13,
     7, 22, 13, 19, 26, 23, 29, 19, 42, 23,  0, 25, 13, 29, 19,
    26, 29, 29, 39, 26,  1,  5, 14,  3, 18,  0, 30,  3, 38,  0,
     1,  9, 13,  6, 18, 10, 33,  6, 38, 10,  8, 12, 13, 16, 25,
    13, 33, 16, 41, 13,  8, 22, 12, 19, 25, 23, 28, 19, 41, 23,
     0, 26, 12, 29, 20, 26, 28, 29, 40, 26,  0,  5, 13,  3, 19,
     0, 29,  3, 39,  0,  0,  9, 14,  6, 19, 10, 34,  6, 39, 10,
     8, 13, 14, 16, 24, 13, 34, 16, 40, 13,  8, 23, 11, 19, 24,
    23, 27, 19, 40, 23,  1, 26, 11, 29, 21, 26, 27, 29, 41, 26,
};

static const uint8_t hq_tab_02[] = {
     0,  0, 12,  5, 20,  0, 28,  5, 40,  0,  3, 16, 17, 11, 23,
    16, 33, 11, 43, 16,  1, 21, 14, 27, 18, 22, 30, 27, 38, 22,
     1,  0, 11,  5, 21,  0, 27,  5, 41,  0,  4, 16, 16, 11, 24,
    16, 32, 11, 44, 16,  0, 21, 13, 27, 19, 22, 29, 27, 39, 22,
     2,  0, 10,  5, 22,  0, 27,  6, 42,  0,  5, 16, 15, 11, 25,
    16, 31, 11, 44, 17,  0, 22, 12, 27, 20, 22, 28, 27, 40, 22,
     3,  0,  9,  5, 23,  0, 28,  6, 43,  0,  6, 16, 14, 11, 26,
    16, 30, 11, 43, 17,  1, 22, 11, 27, 21, 22, 27, 27, 41, 22,
     4,  0,  9,  6, 24,  0, 29,  6, 44,  0,  7, 16, 13, 11, 26,
    17, 29, 11, 42, 17,  2, 22, 10, 27, 22, 22, 27, 28, 42, 22,
     5,  0, 10,  6, 25,  0, 30,  6, 44,  1,  8, 16, 12, 11, 25,
    17, 28, 11, 41, 17,  3, 22,  9, 27, 23, 22, 28, 28, 43, 22,
     6,  0, 11,  6, 26,  0, 31,  6, 43,  1,  8, 17, 11, 11, 24,
    17, 27, 11, 40, 17,  4, 22,  9, 28, 24, 22, 29, 28, 44, 22,
     7,  0, 12,  6, 26,  1, 32,  6, 42,  1,  7, 17, 10, 11, 23,
    17, 27, 12, 39, 17,  5, 22, 10, 28, 25, 22, 30, 28, 44, 23,
     8,  0, 13,  6, 25,  1, 33,  6, 41,  1,  6, 17,  9, 11, 22,
    17, 28, 12, 38, 17,  6, 22, 11, 28, 26, 22, 31, 28, 43, 23,
     8,  1, 14,  6, 24,  1, 34,  6, 40,  1,  5, 17,  9, 12, 21,
    17, 29, 12, 37, 17,  7, 22, 12, 28, 26, 23, 32, 28, 42, 23,
     7,  1, 15,  6, 23,  1, 35,  6, 39,  1,  4, 17, 10, 12, 20,
    17, 30, 12, 36, 17,  8, 22, 13, 28, 25, 23, 33, 28, 41, 23,
     6,  1, 16,  6, 22,  1, 35,  7, 38,  1,  3, 17, 11, 12, 19,
    17, 31, 12, 36, 18,  8, 23, 14, 28, 24, 23, 34, 28, 40, 23,
     5,  1, 17,  6, 21,  1, 34,  7, 37,  1,  2, 17, 12, 12, 18,
    17, 32, 12, 37, 18,  7, 23, 15, 28, 23, 23, 35, 28, 39, 23,
     4,  1, 17,  7, 20,  1, 33,  7, 36,  1,  1, 17, 13, 12, 18,
    18, 33, 12, 38, 18,  6, 23, 16, 28, 22, 23, 35, 29, 38, 23,
     3,  1, 16,  7, 19,  1, 32,  7, 36,  2,  0, 17, 14, 12, 19,
    18, 34, 12, 39, 18,  5, 23, 17, 28, 21, 23, 34, 29, 37, 23,
     2,  1, 15,  7, 18,  1, 31,  7, 37,  2,  0, 18, 15, 12, 20,
    18, 35, 12, 40, 18,  4, 23, 17, 29, 20, 23, 33, 29, 36, 23,
     1,  1, 14,  7, 18,  2, 30,  7, 38,  2,  1, 18, 16, 12, 21,
    18, 35, 13, 41, 18,  3, 23, 16, 29, 19, 23, 32, 29, 36, 24,
     0,  1, 13,  7, 19,  2, 29,  7, 39,  2,  2, 18, 17, 12, 22,
    18, 34, 13, 42, 18,  2, 23, 15, 29, 18, 23, 31, 29, 37, 24,
     0,  2, 12,  7, 20,  2, 28,  7, 40,  2,  3, 18, 17, 13, 23,
    18, 33, 13, 43, 18,  1, 23, 14, 29, 18, 24, 30, 29, 38, 24,
     1,  2, 11,  7, 21,  2, 27,  7, 41,  2,  4, 18, 16, 13, 24,
    18, 32, 13, 44, 18,  0, 23, 13, 29, 19, 24, 29, 29, 39, 24,
     2,  2, 10,  7, 22,  2, 27,  8, 42,  2,  5, 18, 15, 13, 25,
    18, 31, 13, 44, 19,  0, 24, 12, 29, 20, 24, 28, 29, 40, 24,
     3,  2,  9,  7, 23,  2, 28,  8, 43,  2,  6, 18, 14, 13, 26,
    18, 30, 13, 43, 19,  1, 24, 11, 29, 21, 24, 27, 29, 41, 24,
     4,  2,  9,  8, 24,  2, 29,  8, 44,  2,  7, 18, 13, 13, 26,
    19, 29, 13, 42, 19,  2, 24, 10, 29, 22, 24, 27, 30, 42, 24,
     5,  2, 10,  8, 25,  2, 30,  8, 44,  3,  8, 18, 12, 13, 25,
    19, 28, 13, 41, 19,  3, 24,  9, 29, 23, 24, 28, 30, 43, 24,
     6,  2, 11,  8, 26,  2, 31,  8, 43,  3,  8, 19, 11, 13, 24,
    19, 27, 13, 40, 19,  4, 24,  9, 30, 24, 24, 29, 30, 44, 24,
     7,  2, 12,  8, 26,  3, 32,  8, 42,  3,  7, 19, 10, 13, 23,
    19, 27, 14, 39, 19,  5, 24, 10, 30, 25, 24, 30, 30, 44, 25,
     8,  2, 13,  8, 25,  3, 33,  8, 41,  3,  6, 19,  9, 13, 22,
    19, 28, 14, 38, 19,  6, 24, 11, 30, 26, 24, 31, 30, 43, 25,
     8,  3, 14,  8, 24,  3, 34,  8, 40,  3,  5, 19,  9, 14, 21,
    19, 29, 14, 37, 19,  7, 24, 12, 30, 26, 25, 32, 30, 42, 25,
     7,  3, 15,  8, 23,  3, 35,  8, 39,  3,  4, 19, 10, 14, 20,
    19, 30, 14, 36, 19,  8, 24, 13, 30, 25, 25, 33, 30, 41, 25,
     6,  3, 16,  8, 22,  3, 35,  9, 38,  3,  3, 19, 11, 14, 19,
    19, 31, 14, 36, 20,  8, 25, 14, 30, 24, 25, 34, 30, 40, 25,
     5,  3, 17,  8, 21,  3, 34,  9, 37,  3,  2, 19, 12, 14, 18,
    19, 32, 14, 37, 20,  7, 25, 15, 30, 23, 25, 35, 30, 39, 25,
     4,  3, 17,  9, 20,  3, 33,  9, 36,  3,  1, 19, 13, 14, 18,
    20, 33, 14, 38, 20,  6, 25, 16, 30, 22, 25, 33, 20, 38, 25,
     3,  3, 16,  9, 19,  3, 32,  9, 36,  4,  0, 19, 14, 14, 19,
    20, 34, 14, 39, 20,  5, 25, 17, 30, 21, 25, 34, 20, 37, 25,
     2,  3, 15,  9, 18,  3, 31,  9, 37,  4,  0, 20, 15, 14, 20,
    20, 35, 14, 40, 20,  4, 25, 15, 20, 20, 25, 35, 20, 36, 25,
     1,  3, 14,  9, 18,  4, 30,  9, 38,  4,  1, 20, 16, 14, 21,
    20, 35, 15, 41, 20,  3, 25, 16, 20, 19, 25, 35, 21, 36, 26,
     0,  3, 13,  9, 19,  4, 29,  9, 39,  4,  2, 20, 17, 14, 22,
    20, 34, 15, 39, 10,  2, 25, 17, 20, 18, 25, 34, 21, 37, 26,
     0,  4, 12,  9, 20,  4, 28,  9, 40,  4,  3, 20, 17, 15, 23,
    20, 33, 15, 40, 10,  1, 25, 17, 21, 18, 26, 33, 21, 38, 26,
     1,  4, 11,  9, 21,  4, 27,  9, 41,  4,  4, 20, 16, 15, 21,
    10, 32, 15, 41, 10,  0, 25, 16, 21, 19, 26, 32, 21, 39, 26,
     2,  4, 10,  9, 22,  4, 27, 10, 42,  4,  5, 20, 15, 15, 22,
    10, 31, 15, 42, 10,  0, 26, 15, 21, 20, 26, 31, 21, 40, 26,
     3,  4,  9,  9, 23,  4, 28, 10, 43,  4,  3, 10, 14, 15, 23,
    10, 30, 15, 43, 10,  1, 26, 14, 21, 21, 26, 30, 21, 41, 26,
     4,  4,  9, 10, 24,  4, 29, 10, 44,  4,  4, 10, 13, 15, 24,
    10, 29, 15, 44, 10,  2, 26, 13, 21, 22, 26, 29, 21, 42, 26,
     5,  4, 10, 10, 25,  4, 27,  0, 44,  5,  5, 10, 12, 15, 25,
    10, 28, 15, 44, 11,  3, 26, 12, 21, 23, 26, 28, 21, 43, 26,
     6,  4, 11, 10, 26,  4, 28,  0, 43,  5,  6, 10, 11, 15, 26,
    10, 27, 15, 43, 11,  4, 26, 11, 21, 24, 26, 27, 21, 44, 26,
     7,  4,  9,  0, 26,  5, 29,  0, 42,  5,  7, 10, 10, 15, 26,
    11, 27, 16, 42, 11,  5, 26, 10, 21, 25, 26, 27, 22, 44, 27,
     8,  4, 10,  0, 25,  5, 30,  0, 41,  5,  8, 10,  9, 15, 25,
    11, 28, 16, 41, 11,  6, 26,  9, 21, 26, 26, 28, 22, 43, 27,
     8,  5, 11,  0, 24,  5, 31,  0, 40,  5,  8, 11,  9, 16, 24,
    11, 29, 16, 40, 11,  7, 26,  9, 22, 26, 27, 29, 22, 42, 27,
     7,  5, 12,  0, 23,  5, 32,  0, 39,  5,  7, 11, 10, 16, 23,
    11, 30, 16, 39, 11,  8, 26, 10, 22, 25, 27, 30, 22, 41, 27,
     6,  5, 13,  0, 22,  5, 33,  0, 38,  5,  6, 11, 11, 16, 22,
    11, 31, 16, 38, 11,  8, 27, 11, 22, 24, 27, 31, 22, 40, 27,
     5,  5, 14,  0, 21,  5, 34,  0, 37,  5,  5, 11, 12, 16, 21,
    11, 32, 16, 37, 11,  7, 27, 12, 22, 23, 27, 32, 22, 39, 27,
     4,  5, 15,  0, 20,  5, 35,  0, 36,  5,  4, 11, 13, 16, 20,
    11, 33, 16, 36, 11,  6, 27, 13, 22, 22, 27, 33, 22, 38, 27,
     3,  5, 16,  0, 19,  5, 35,  1, 36,  6,  3, 11, 14, 16, 19,
    11, 34, 16, 36, 12,  5, 27, 14, 22, 21, 27, 34, 22, 37, 27,
     2,  5, 17,  0, 18,  5, 34,  1, 37,  6,  2, 11, 15, 16, 18,
    11, 35, 16, 37, 12,  4, 27, 15, 22, 20, 27, 35, 22, 36, 27,
     1,  5, 17,  1, 18,  6, 33,  1, 38,  6,  1, 11, 16, 16, 18,
    12, 35, 17, 38, 12,  3, 27, 16, 22, 19, 27, 35, 23, 36, 28,
     0,  5, 16,  1, 19,  6, 32,  1, 39,  6,  0, 11, 17, 16, 19,
    12, 34, 17, 39, 12,  2, 27, 17, 22, 18, 27, 34, 23, 37, 28,
     0,  6, 15,  1, 20,  6, 31,  1, 40,  6,  0, 12, 17, 17, 20,
    12, 33, 17, 40, 12,  1, 27, 17, 23, 18, 28, 33, 23, 38, 28,
     1,  6, 14,  1, 21,  6, 30,  1, 41,  6,  1, 12, 16, 17, 21,
    12, 32, 17, 41, 12,  0, 27, 16, 23, 19, 28, 32, 23, 39, 28,
     2,  6, 13,  1, 22,  6, 29,  1, 42,  6,  2, 12, 15, 17, 22,
    12, 31, 17, 42, 12,  0, 28, 15, 23, 20, 28, 31, 23, 40, 28,
     3,  6, 12,  1, 23,  6, 28,  1, 43,  6,  3, 12, 14, 17, 23,
    12, 30, 17, 43, 12,  1, 28, 14, 23, 21, 28, 30, 23, 41, 28,
     4,  6, 11,  1, 24,  6, 27,  1, 44,  6,  4, 12, 13, 17, 24,
    12, 29, 17, 44, 12,  2, 28, 13, 23, 22, 28, 29, 23, 42, 28,
     5,  6, 10,  1, 25,  6, 27,  2, 44,  7,  5, 12, 12, 17, 25,
    12, 28, 17, 44, 13,  3, 28, 12, 23, 23, 28, 28, 23, 43, 28,
     6,  6,  9,  1, 26,  6, 28,  2, 43,  7,  6, 12, 11, 17, 26,
    12, 27, 17, 43, 13,  4, 28, 11, 23, 24, 28, 27, 23, 44, 28,
     7,  6,  9,  2, 26,  7, 29,  2, 42,  7,  7, 12, 10, 17, 26,
    13, 27, 18, 42, 13,  5, 28, 10, 23, 25, 28, 27, 24, 44, 29,
     8,  6, 10,  2, 25,  7, 30,  2, 41,  7,  8, 12,  9, 17, 25,
    13, 28, 18, 41, 13,  6, 28,  9, 23, 26, 28, 28, 24, 43, 29,
     8,  7, 11,  2, 24,  7, 31,  2, 40,  7,  8, 13,  9, 18, 24,
    13, 29, 18, 40, 13,  7, 28,  9, 24, 26, 29, 29, 24, 42, 29,
     7,  7, 12,  2, 23,  7, 32,  2, 39,  7,  7, 13, 10, 18, 23,
    13, 30, 18, 39, 13,  8, 28, 10, 24, 25, 29, 30, 24, 41, 29,
     6,  7, 13,  2, 22,  7, 33,  2, 38,  7,  6, 13, 11, 18, 22,
    13, 31, 18, 38, 13,  8, 29, 11, 24, 24, 29, 31, 24, 40, 29,
     5,  7, 14,  2, 21,  7, 34,  2, 37,  7,  5, 13, 12, 18, 21,
    13, 32, 18, 37, 13,  7, 29, 12, 24, 23, 29, 32, 24, 39, 29,
     4,  7, 15,  2, 20,  7, 35,  2, 36,  7,  4, 13, 13, 18, 20,
    13, 33, 18, 36, 13,  6, 29, 13, 24, 22, 29, 33, 24, 38, 29,
     3,  7, 16,  2, 19,  7, 35,  3, 36,  8,  3, 13, 14, 18, 19,
    13, 34, 18, 36, 14,  5, 29, 14, 24, 21, 29, 34, 24, 37, 29,
     2,  7, 17,  2, 18,  7, 34,  3, 37,  8,  2, 13, 15, 18, 18,
    13, 35, 18, 37, 14,  4, 29, 15, 24, 20, 29, 35, 24, 36, 29,
     1,  7, 17,  3, 18,  8, 33,  3, 38,  8,  1, 13, 16, 18, 18,
    14, 35, 19, 38, 14,  3, 29, 16, 24, 19, 29, 35, 25, 36, 30,
     0,  7, 16,  3, 19,  8, 32,  3, 39,  8,  0, 13, 17, 18, 19,
    14, 34, 19, 39, 14,  2, 29, 17, 24, 18, 29, 34, 25, 37, 30,
     0,  8, 15,  3, 20,  8, 31,  3, 40,  8,  0, 14, 17, 19, 20,
    14, 33, 19, 40, 14,  1, 29, 17, 25, 18, 30, 33, 25, 38, 30,
     1,  8, 14,  3, 21,  8, 30,  3, 41,  8,  1, 14, 16, 19, 21,
    14, 32, 19, 41, 14,  0, 29, 16, 25, 19, 30, 32, 25, 39, 30,
     2,  8, 13,  3, 22,  8, 29,  3, 42,  8,  2, 14, 15, 19, 22,
    14, 31, 19, 42, 14,  0, 30, 15, 25, 20, 30, 31, 25, 40, 30,
     3,  8, 12,  3, 23,  8, 28,  3, 43,  8,  3, 14, 14, 19, 23,
    14, 30, 19, 43, 14,  1, 30, 14, 25, 21, 30, 30, 25, 41, 30,
     4,  8, 11,  3, 24,  8, 27,  3, 44,  8,  4, 14, 13, 19, 24,
    14, 29, 19, 44, 14,  2, 30, 13, 25, 22, 30, 29, 25, 42, 30,
     5,  8, 10,  3, 25,  8, 27,  4, 44,  9,  5, 14, 12, 19, 25,
    14, 28, 19, 44, 15,  3, 30, 12, 25, 23, 30, 28, 25, 43, 30,
     6,  8,  9,  3, 26,  8, 28,  4, 43,  9,  6, 14, 11, 19, 26,
    14, 27, 19, 43, 15,  4, 30, 11, 25, 24, 30, 27, 25, 44, 30,
     7,  8,  9,  4, 26,  9, 29,  4, 42,  9,  7, 14, 10, 19, 26,
    15, 27, 20, 42, 15,  5, 30, 10, 25, 25, 30, 27, 26, 42, 20,
     8,  8, 10,  4, 25,  9, 30,  4, 41,  9,  8, 14,  9, 19, 25,
    15, 28, 20, 41, 15,  6, 30,  9, 25, 26, 30, 28, 26, 43, 20,
     8,  9, 11,  4, 24,  9, 31,  4, 40,  9,  8, 15,  9, 20, 24,
    15, 29, 20, 40, 15,  7, 30,  9, 26, 24, 20, 29, 26, 44, 20,
     7,  9, 12,  4, 23,  9, 32,  4, 39,  9,  7, 15, 10, 20, 23,
    15, 30, 20, 39, 15,  8, 30, 10, 26, 25, 20, 30, 26, 44, 21,
     6,  9, 13,  4, 22,  9, 33,  4, 38,  9,  6, 15, 11, 20, 22,
    15, 31, 20, 38, 15,  6, 20, 11, 26, 26, 20, 31, 26, 43, 21,
     5,  9, 14,  4, 21,  9, 34,  4, 37,  9,  5, 15, 12, 20, 21,
    15, 32, 20, 37, 15,  7, 20, 12, 26, 26, 21, 32, 26, 42, 21,
     4,  9, 15,  4, 20,  9, 35,  4, 36,  9,  4, 15, 13, 20, 20,
    15, 30, 10, 36, 15,  8, 20, 13, 26, 25, 21, 33, 26, 41, 21,
     3,  9, 16,  4, 19,  9, 35,  5, 36, 10,  3, 15, 14, 20, 19,
    15, 31, 10, 36, 16,  8, 21, 14, 26, 24, 21, 34, 26, 40, 21,
     2,  9, 17,  4, 18,  9, 34,  5, 37, 10,  2, 15, 12, 10, 18,
    15, 32, 10, 37, 16,  7, 21, 15, 26, 23, 21, 35, 26, 39, 21,
     1,  9, 17,  5, 18, 10, 33,  5, 38, 10,  1, 15, 13, 10, 18,
    16, 33, 10, 38, 16,  6, 21, 16, 26, 22, 21, 35, 27, 38, 21,
     0,  9, 16,  5, 19, 10, 32,  5, 36,  0,  0, 15, 14, 10, 19,
    16, 34, 10, 39, 16,  5, 21, 17, 26, 21, 21, 34, 27, 37, 21,
     0, 10, 15,  5, 20, 10, 31,  5, 37,  0,  0, 16, 15, 10, 20,
    16, 35, 10, 40, 16,  4, 21, 17, 27, 20, 21, 33, 27, 36, 21,
     1, 10, 14,  5, 18,  0, 30,  5, 38,  0,  1, 16, 16, 10, 21,
    16, 35, 11, 41, 16,  3, 21, 16, 27, 19, 21, 32, 27, 36, 22,
     2, 10, 13,  5, 19,  0, 29,  5, 39,  0,  2, 16, 17, 10, 22,
    16, 34, 11, 42, 16,  2, 21, 15, 27, 18, 21, 31, 27, 37, 22,
     0,  0,
};

static const uint8_t hq_tab_03[] = {
     0,  0, 14,  4, 20,  0, 34,  4, 40,  0,  8, 14, 15,  9, 24,
    14, 35,  9, 40, 14,  7, 19, 11, 23, 23, 19, 27, 23, 39, 19,
     1, 33, 10, 28, 21, 33, 27, 29, 41, 33,  1,  0, 15,  4, 21,
     0, 35,  4, 41,  0,  7, 14, 16,  9, 23, 14, 35, 10, 39, 14,
     6, 19, 10, 23, 22, 19, 27, 24, 38, 19,  2, 33,  9, 28, 22,
    33, 28, 29, 42, 33,  2,  0, 16,  4, 22,  0, 35,  5, 42,  0,
     6, 14, 17,  9, 22, 14, 34, 10, 38, 14,  5, 19,  9, 23, 21,
    19, 28, 24, 37, 19,  3, 33,  9, 29, 23, 33, 29, 29, 43, 33,
     3,  0, 17,  4, 23,  0, 34,  5, 43,  0,  5, 14, 17, 10, 21,
    14, 33, 10, 37, 14,  4, 19,  9, 24, 20, 19, 29, 24, 36, 19,
     4, 33, 10, 29, 24, 33, 30, 29, 44, 33,  4,  0, 17,  5, 24,
     0, 33,  5, 44,  0,  4, 14, 16, 10, 20, 14, 32, 10, 36, 14,
     3, 19, 10, 24, 19, 19, 30, 24, 36, 20,  5, 33, 11, 29, 25,
    33, 31, 29, 44, 34,  5,  0, 16,  5, 25,  0, 32,  5, 44,  1,
     3, 14, 15, 10, 19, 14, 31, 10, 36, 15,  2, 19, 11, 24, 18,
    19, 31, 24, 37, 20,  6, 33, 12, 29, 26, 33, 32, 29, 43, 34,
     6,  0, 15,  5, 26,  0, 31,  5, 43,  1,  2, 14, 14, 10, 18,
    14, 30, 10, 37, 15,  1, 19, 12, 24, 18, 20, 32, 24, 38, 20,
     7, 33, 13, 29, 26, 34, 33, 29, 42, 34,  7,  0, 14,  5, 26,
     1, 30,  5, 42,  1,  1, 14, 13, 10, 18, 15, 29, 10, 38, 15,
     0, 19, 13, 24, 19, 20, 33, 24, 39, 20,  8, 33, 14, 29, 25,
    34, 34, 29, 41, 34,  8,  0, 13,  5, 25,  1, 29,  5, 41,  1,
     0, 14, 12, 10, 19, 15, 28, 10, 39, 15,  0, 20, 14, 24, 20,
    20, 34, 24, 40, 20,  8, 34, 15, 29, 24, 34, 35, 29, 40, 34,
     8,  1, 12,  5, 24,  1, 28,  5, 40,  1,  0, 15, 11, 10, 20,
    15, 27, 10, 40, 15,  1, 20, 15, 24, 21, 20, 35, 24, 41, 20,
     7, 34, 16, 29, 23, 34, 35, 30, 39, 34,  7,  1, 11,  5, 23,
     1, 27,  5, 39,  1,  1, 15, 10, 10, 21, 15, 27, 11, 41, 15,
     2, 20, 16, 24, 22, 20, 35, 25, 42, 20,  6, 34, 17, 29, 22,
    34, 34, 30, 38, 34,  6,  1, 10,  5, 22,  1, 27,  6, 38,  1,
     2, 15,  9, 10, 22, 15, 28, 11, 42, 15,  3, 20, 17, 24, 23,
    20, 34, 25, 43, 20,  5, 34, 17, 30, 21, 34, 33, 30, 37, 34,
     5,  1,  9,  5, 21,  1, 28,  6, 37,  1,  3, 15,  9, 11, 23,
    15, 29, 11, 43, 15,  4, 20, 17, 25, 24, 20, 33, 25, 44, 20,
     4, 34, 16, 30, 20, 34, 32, 30, 36, 34,  4,  1,  9,  6, 20,
     1, 29,  6, 36,  1,  4, 15, 10, 11, 24, 15, 30, 11, 44, 15,
     5, 20, 16, 25, 25, 20, 32, 25, 44, 21,  3, 34, 15, 30, 19,
    34, 31, 30, 36, 35,  3,  1, 10,  6, 19,  1, 30,  6, 36,  2,
     5, 15, 11, 11, 25, 15, 31, 11, 44, 16,  6, 20, 15, 25, 26,
    20, 31, 25, 43, 21,  2, 34, 14, 30, 18, 34, 30, 30, 37, 35,
     2,  1, 11,  6, 18,  1, 31,  6, 37,  2,  6, 15, 12, 11, 26,
    15, 32, 11, 43, 16,  7, 20, 14, 25, 26, 21, 30, 25, 42, 21,
     1, 34, 13, 30, 18, 35, 29, 30, 38, 35,  1,  1, 12,  6, 18,
     2, 32,  6, 38,  2,  7, 15, 13, 11, 26, 16, 33, 11, 42, 16,
     8, 20, 13, 25, 25, 21, 29, 25, 41, 21,  0, 34, 12, 30, 19,
    35, 28, 30, 39, 35,  0,  1, 13,  6, 19,  2, 33,  6, 39,  2,
     8, 15, 14, 11, 25, 16, 34, 11, 41, 16,  8, 21, 12, 25, 24,
    21, 28, 25, 40, 21,  0, 35, 11, 30, 20, 35, 27, 30, 40, 35,
     0,  2, 14,  6, 20,  2, 34,  6, 40,  2,  8, 16, 15, 11, 24,
    16, 35, 11, 40, 16,  7, 21, 11, 25, 23, 21, 27, 25, 39, 21,
     1, 35, 10, 30, 21, 35, 27, 31, 41, 35,  1,  2, 15,  6, 21,
     2, 35,  6, 41,  2,  7, 16, 16, 11, 23, 16, 35, 12, 39, 16,
     6, 21, 10, 25, 22, 21, 27, 26, 38, 21,  2, 35,  9, 30, 22,
    35, 28, 31, 42, 35,  2,  2, 16,  6, 22,  2, 35,  7, 42,  2,
     6, 16, 17, 11, 22, 16, 34, 12, 38, 16,  5, 21,  9, 25, 21,
    21, 28, 26, 37, 21,  3, 35,  9, 31, 23, 35, 29, 31, 43, 35,
     3,  2, 17,  6, 23,  2, 34,  7, 43,  2,  5, 16, 17, 12, 21,
    16, 33, 12, 37, 16,  4, 21,  9, 26, 20, 21, 29, 26, 36, 21,
     4, 35, 10, 31, 24, 35, 30, 31, 44, 35,  4,  2, 17,  7, 24,
     2, 33,  7, 44,  2,  4, 16, 16, 12, 20, 16, 32, 12, 36, 16,
     3, 21, 10, 26, 19, 21, 30, 26, 36, 22,  5, 35, 11, 31, 25,
    35, 31, 31, 36, 27,  5,  2, 16,  7, 25,  2, 32,  7, 44,  3,
     3, 16, 15, 12, 19, 16, 31, 12, 36, 17,  2, 21, 11, 26, 18,
    21, 31, 26, 37, 22,  6, 35, 12, 31, 26, 35, 32, 31, 37, 27,
     6,  2, 15,  7, 26,  2, 31,  7, 43,  3,  2, 16, 14, 12, 18,
    16, 30, 12, 37, 17,  1, 21, 12, 26, 18, 22, 32, 26, 38, 22,
     7, 35, 13, 31, 18, 27, 33, 31, 38, 27,  7,  2, 14,  7, 26,
     3, 30,  7, 42,  3,  1, 16, 13, 12, 18, 17, 29, 12, 38, 17,
     0, 21, 13, 26, 19, 22, 33, 26, 39, 22,  8, 35, 14, 31, 19,
    27, 34, 31, 39, 27,  8,  2, 13,  7, 25,  3, 29,  7, 41,  3,
     0, 16, 12, 12, 19, 17, 28, 12, 39, 17,  0, 22, 14, 26, 20,
    22, 34, 26, 40, 22,  0, 27, 15, 31, 20, 27, 35, 31, 40, 27,
     8,  3, 12,  7, 24,  3, 28,  7, 40,  3,  0, 17, 11, 12, 20,
    17, 27, 12, 40, 17,  1, 22, 15, 26, 21, 22, 35, 26, 41, 22,
     1, 27, 16, 31, 21, 27, 35, 32, 41, 27,  7,  3, 11,  7, 23,
     3, 27,  7, 39,  3,  1, 17, 10, 12, 21, 17, 27, 13, 41, 17,
     2, 22, 16, 26, 22, 22, 27, 18, 42, 22,  2, 27, 17, 31, 22,
    27, 34, 32, 42, 27,  6,  3, 10,  7, 22,  3, 27,  8, 38,  3,
     2, 17,  9, 12, 22, 17, 28, 13, 42, 17,  3, 22, 17, 26, 23,
    22, 28, 18, 43, 22,  3, 27, 17, 32, 23, 27, 33, 32, 43, 27,
     5,  3,  9,  7, 21,  3, 28,  8, 37,  3,  3, 17,  9, 13, 23,
    17, 29, 13, 43, 17,  4, 22,  9, 18, 24, 22, 29, 18, 44, 22,
     4, 27, 16, 32, 24, 27, 32, 32, 44, 27,  4,  3,  9,  8, 20,
     3, 29,  8, 36,  3,  4, 17, 10, 13, 24, 17, 30, 13, 44, 17,
     5, 22, 10, 18, 25, 22, 30, 18, 44, 23,  5, 27, 15, 32, 25,
    27, 31, 32, 44, 28,  3,  3, 10,  8, 19,  3, 30,  8, 36,  4,
     5, 17, 11, 13, 25, 17, 31, 13, 36,  9,  6, 22, 11, 18, 26,
    22, 31, 18, 43, 23,  6, 27, 14, 32, 26, 27, 30, 32, 43, 28,
     2,  3, 11,  8, 18,  3, 31,  8, 37,  4,  6, 17, 12, 13, 26,
    17, 32, 13, 37,  9,  7, 22, 12, 18, 26, 23, 32, 18, 42, 23,
     7, 27, 13, 32, 26, 28, 29, 32, 42, 28,  1,  3, 12,  8, 18,
     4, 32,  8, 38,  4,  7, 17, 13, 13, 18,  9, 33, 13, 38,  9,
     8, 22, 13, 18, 25, 23, 33, 18, 41, 23,  8, 27, 12, 32, 25,
    28, 28, 32, 41, 28,  0,  3, 13,  8, 19,  4, 33,  8, 39,  4,
     8, 17, 14, 13, 19,  9, 34, 13, 39,  9,  8, 23, 14, 18, 24,
    23, 34, 18, 40, 23,  8, 28, 11, 32, 24, 28, 27, 32, 40, 28,
     0,  4, 14,  8, 20,  4, 34,  8, 40,  4,  0,  9, 15, 13, 20,
     9, 35, 13, 40,  9,  7, 23, 15, 18, 23, 23, 35, 18, 39, 23,
     7, 28, 10, 32, 23, 28, 27, 33, 39, 28,  1,  4, 15,  8, 21,
     4, 35,  8, 41,  4,  1,  9, 16, 13, 21,  9, 35, 14, 41,  9,
     6, 23, 16, 18, 22, 23, 35, 19, 38, 23,  6, 28,  9, 32, 22,
    28, 28, 33, 38, 28,  2,  4, 16,  8, 22,  4, 27,  0, 42,  4,
     2,  9, 17, 13, 22,  9, 34, 14, 42,  9,  5, 23, 17, 18, 21,
    23, 34, 19, 37, 23,  5, 28,  9, 33, 21, 28, 29, 33, 37, 28,
     3,  4, 17,  8, 23,  4, 28,  0, 43,  4,  3,  9, 17, 14, 23,
     9, 33, 14, 43,  9,  4, 23, 17, 19, 20, 23, 33, 19, 36, 23,
     4, 28, 10, 33, 20, 28, 30, 33, 36, 28,  4,  4,  9,  0, 24,
     4, 29,  0, 44,  4,  4,  9, 16, 14, 24,  9, 32, 14, 44,  9,
     3, 23, 16, 19, 19, 23, 32, 19, 36, 24,  3, 28, 11, 33, 19,
    28, 31, 33, 36, 29,  5,  4, 10,  0, 25,  4, 30,  0, 44,  5,
     5,  9, 15, 14, 25,  9, 31, 14, 44, 10,  2, 23, 15, 19, 18,
    23, 31, 19, 37, 24,  2, 28, 12, 33, 18, 28, 32, 33, 37, 29,
     6,  4, 11,  0, 26,  4, 31,  0, 43,  5,  6,  9, 14, 14, 26,
     9, 30, 14, 43, 10,  1, 23, 14, 19, 18, 24, 30, 19, 38, 24,
     1, 28, 13, 33, 18, 29, 33, 33, 38, 29,  7,  4, 12,  0, 26,
     5, 32,  0, 42,  5,  7,  9, 13, 14, 26, 10, 29, 14, 42, 10,
     0, 23, 13, 19, 19, 24, 29, 19, 39, 24,  0, 28, 14, 33, 19,
    29, 34, 33, 39, 29,  8,  4, 13,  0, 25,  5, 33,  0, 41,  5,
     8,  9, 12, 14, 25, 10, 28, 14, 41, 10,  0, 24, 12, 19, 20,
    24, 28, 19, 40, 24,  0, 29, 15, 33, 20, 29, 35, 33, 40, 29,
     8,  5, 14,  0, 24,  5, 34,  0, 40,  5,  8, 10, 11, 14, 24,
    10, 27, 14, 40, 10,  1, 24, 11, 19, 21, 24, 27, 19, 41, 24,
     1, 29, 16, 33, 21, 29, 35, 34, 41, 29,  7,  5, 15,  0, 23,
     5, 35,  0, 39,  5,  7, 10, 10, 14, 23, 10, 27, 15, 39, 10,
     2, 24, 10, 19, 22, 24, 27, 20, 42, 24,  2, 29, 17, 33, 22,
    29, 34, 34, 42, 29,  6,  5, 16,  0, 22,  5, 35,  1, 38,  5,
     6, 10,  9, 14, 22, 10, 28, 15, 38, 10,  3, 24,  9, 19, 23,
    24, 28, 20, 43, 24,  3, 29, 17, 34, 23, 29, 33, 34, 43, 29,
     5,  5, 17,  0, 21,  5, 34,  1, 37,  5,  5, 10,  9, 15, 21,
    10, 29, 15, 37, 10,  4, 24,  9, 20, 24, 24, 29, 20, 44, 24,
     4, 29, 16, 34, 24, 29, 32, 34, 44, 29,  4,  5, 17,  1, 20,
     5, 33,  1, 36,  5,  4, 10, 10, 15, 20, 10, 30, 15, 36, 10,
     5, 24, 10, 20, 25, 24, 30, 20, 44, 25,  5, 29, 15, 34, 25,
    29, 31, 34, 44, 30,  3,  5, 16,  1, 19,  5, 32,  1, 36,  6,
     3, 10, 11, 15, 19, 10, 31, 15, 36, 11,  6, 24, 11, 20, 26,
    24, 31, 20, 43, 25,  6, 29, 14, 34, 26, 29, 30, 34, 43, 30,
     2,  5, 15,  1, 18,  5, 31,  1, 37,  6,  2, 10, 12, 15, 18,
    10, 32, 15, 37, 11,  7, 24, 12, 20, 26, 25, 32, 20, 42, 25,
     7, 29, 13, 34, 26, 30, 29, 34, 42, 30,  1,  5, 14,  1, 18,
     6, 30,  1, 38,  6,  1, 10, 13, 15, 18, 11, 33, 15, 38, 11,
     8, 24, 13, 20, 25, 25, 33, 20, 41, 25,  8, 29, 12, 34, 25,
    30, 28, 34, 41, 30,  0,  5, 13,  1, 19,  6, 29,  1, 39,  6,
     0, 10, 14, 15, 19, 11, 34, 15, 39, 11,  8, 25, 14, 20, 24,
    25, 34, 20, 40, 25,  8, 30, 11, 34, 24, 30, 27, 34, 40, 30,
     0,  6, 12,  1, 20,  6, 28,  1, 40,  6,  0, 11, 15, 15, 20,
    11, 35, 15, 40, 11,  7, 25, 15, 20, 23, 25, 35, 20, 39, 25,
     7, 30, 10, 34, 23, 30, 27, 35, 39, 30,  1,  6, 11,  1, 21,
     6, 27,  1, 41,  6,  1, 11, 16, 15, 21, 11, 35, 16, 41, 11,
     6, 25, 16, 20, 22, 25, 35, 21, 38, 25,  6, 30,  9, 34, 22,
    30, 28, 35, 38, 30,  2,  6, 10,  1, 22,  6, 27,  2, 42,  6,
     2, 11, 17, 15, 22, 11, 34, 16, 42, 11,  5, 25, 17, 20, 21,
    25, 34, 21, 37, 25,  5, 30,  9, 35, 21, 30, 29, 35, 37, 30,
     3,  6,  9,  1, 23,  6, 28,  2, 43,  6,  3, 11, 17, 16, 23,
    11, 33, 16, 43, 11,  4, 25, 17, 21, 20, 25, 33, 21, 36, 25,
     4, 30, 10, 35, 20, 30, 30, 35, 36, 30,  4,  6,  9,  2, 24,
     6, 29,  2, 44,  6,  4, 11, 16, 16, 24, 11, 32, 16, 44, 11,
     3, 25, 16, 21, 19, 25, 32, 21, 36, 26,  3, 30, 11, 35, 19,
    30, 31, 35, 36, 31,  5,  6, 10,  2, 25,  6, 30,  2, 44,  7,
     5, 11, 15, 16, 25, 11, 31, 16, 44, 12,  2, 25, 15, 21, 18,
    25, 31, 21, 37, 26,  2, 30, 12, 35, 18, 30, 32, 35, 37, 31,
     6,  6, 11,  2, 26,  6, 31,  2, 43,  7,  6, 11, 14, 16, 26,
    11, 30, 16, 43, 12,  1, 25, 14, 21, 18, 26, 30, 21, 38, 26,
     1, 30, 13, 35, 18, 31, 33, 35, 38, 31,  7,  6, 12,  2, 26,
     7, 32,  2, 42,  7,  7, 11, 13, 16, 26, 12, 29, 16, 42, 12,
     0, 25, 13, 21, 19, 26, 29, 21, 39, 26,  0, 30, 14, 35, 19,
    31, 34, 35, 39, 31,  8,  6, 13,  2, 25,  7, 33,  2, 41,  7,
     8, 11, 12, 16, 25, 12, 28, 16, 41, 12,  0, 26, 12, 21, 20,
    26, 28, 21, 40, 26,  0, 31, 15, 35, 20, 31, 35, 35, 40, 31,
     8,  7, 14,  2, 24,  7, 34,  2, 40,  7,  8, 12, 11, 16, 24,
    12, 27, 16, 40, 12,  1, 26, 11, 21, 21, 26, 27, 21, 41, 26,
     1, 31, 16, 35, 21, 31, 27, 27, 41, 31,  7,  7, 15,  2, 23,
     7, 35,  2, 39,  7,  7, 12, 10, 16, 23, 12, 27, 17, 39, 12,
     2, 26, 10, 21, 22, 26, 27, 22, 42, 26,  2, 31, 17, 35, 22,
    31, 28, 27, 42, 31,  6,  7, 16,  2, 22,  7, 35,  3, 38,  7,
     6, 12,  9, 16, 22, 12, 28, 17, 38, 12,  3, 26,  9, 21, 23,
    26, 28, 22, 43, 26,  3, 31,  9, 27, 23, 31, 29, 27, 43, 31,
     5,  7, 17,  2, 21,  7, 34,  3, 37,  7,  5, 12,  9, 17, 21,
    12, 29, 17, 37, 12,  4, 26,  9, 22, 24, 26, 29, 22, 44, 26,
     4, 31, 10, 27, 24, 31, 30, 27, 44, 31,  4,  7, 17,  3, 20,
     7, 33,  3, 36,  7,  4, 12, 10, 17, 20, 12, 30, 17, 36, 12,
     5, 26, 10, 22, 25, 26, 30, 22, 36, 18,  5, 31, 11, 27, 25,
    31, 31, 27, 44, 32,  3,  7, 16,  3, 19,  7, 32,  3, 36,  8,
     3, 12, 11, 17, 19, 12, 31, 17, 36, 13,  6, 26, 11, 22, 26,
    26, 31, 22, 37, 18,  6, 31, 12, 27, 26, 31, 32, 27, 43, 32,
     2,  7, 15,  3, 18,  7, 31,  3, 37,  8,  2, 12, 12, 17, 18,
    12, 32, 17, 37, 13,  7, 26, 12, 22, 18, 18, 32, 22, 38, 18,
     7, 31, 13, 27, 26, 32, 33, 27, 42, 32,  1,  7, 14,  3, 18,
     8, 30,  3, 38,  8,  1, 12, 13, 17, 18, 13, 33, 17, 38, 13,
     8, 26, 13, 22, 19, 18, 33, 22, 39, 18,  8, 31, 14, 27, 25,
    32, 34, 27, 41, 32,  0,  7, 13,  3, 19,  8, 29,  3, 39,  8,
     0, 12, 14, 17, 19, 13, 34, 17, 39, 13,  0, 18, 14, 22, 20,
    18, 34, 22, 40, 18,  8, 32, 15, 27, 24, 32, 35, 27, 40, 32,
     0,  8, 12,  3, 20,  8, 28,  3, 40,  8,  0, 13, 15, 17, 20,
    13, 35, 17, 40, 13,  1, 18, 15, 22, 21, 18, 35, 22, 41, 18,
     7, 32, 16, 27, 23, 32, 35, 28, 39, 32,  1,  8, 11,  3, 21,
     8, 27,  3, 41,  8,  1, 13, 16, 17, 21, 13, 27,  9, 41, 13,
     2, 18, 16, 22, 22, 18, 35, 23, 42, 18,  6, 32, 17, 27, 22,
    32, 34, 28, 38, 32,  2,  8, 10,  3, 22,  8, 27,  4, 42,  8,
     2, 13, 17, 17, 22, 13, 28,  9, 42, 13,  3, 18, 17, 22, 23,
    18, 34, 23, 43, 18,  5, 32, 17, 28, 21, 32, 33, 28, 37, 32,
     3,  8,  9,  3, 23,  8, 28,  4, 43,  8,  3, 13,  9,  9, 23,
    13, 29,  9, 43, 13,  4, 18, 17, 23, 24, 18, 33, 23, 44, 18,
     4, 32, 16, 28, 20, 32, 32, 28, 36, 32,  4,  8,  9,  4, 24,
     8, 29,  4, 44,  8,  4, 13, 10,  9, 24, 13, 30,  9, 44, 13,
     5, 18, 16, 23, 25, 18, 32, 23, 44, 19,  3, 32, 15, 28, 19,
    32, 31, 28, 36, 33,  5,  8, 10,  4, 25,  8, 30,  4, 36,  0,
     5, 13, 11,  9, 25, 13, 31,  9, 44, 14,  6, 18, 15, 23, 26,
    18, 31, 23, 43, 19,  2, 32, 14, 28, 18, 32, 30, 28, 37, 33,
     6,  8, 11,  4, 26,  8, 31,  4, 37,  0,  6, 13, 12,  9, 26,
    13, 32,  9, 43, 14,  7, 18, 14, 23, 26, 19, 30, 23, 42, 19,
     1, 32, 13, 28, 18, 33, 29, 28, 38, 33,  7,  8, 12,  4, 18,
     0, 32,  4, 38,  0,  7, 13, 13,  9, 26, 14, 33,  9, 42, 14,
     8, 18, 13, 23, 25, 19, 29, 23, 41, 19,  0, 32, 12, 28, 19,
    33, 28, 28, 39, 33,  8,  8, 13,  4, 19,  0, 33,  4, 39,  0,
     8, 13, 14,  9, 25, 14, 34,  9, 41, 14,  8, 19, 12, 23, 24,
    19, 28, 23, 40, 19,  0, 33, 11, 28, 20, 33, 27, 28, 40, 33,
};

static const uint8_t hq_tab_04[] = {
     0,  0, 19,  4, 26,  0, 45,  4, 52,  0, 11, 13, 18,  9, 34,
    14, 44,  9, 56, 14, 10, 18, 18, 23, 35, 19, 40, 23, 57, 19,
     2, 32, 19, 28, 24, 32, 41, 28, 49, 33,  3, 37, 15, 42, 25,
    37, 41, 42, 48, 38,  1,  0, 20,  4, 27,  0, 46,  4, 53,  0,
    11, 14, 19,  9, 33, 14, 45,  9, 55, 14, 11, 18, 17, 23, 34,
    19, 39, 23, 56, 19,  1, 32, 18, 28, 24, 33, 40, 28, 50, 33,
     2, 37, 16, 42, 24, 37, 42, 42, 49, 38,  2,  0, 21,  4, 28,
     0, 47,  4, 54,  0, 10, 14, 20,  9, 32, 14, 46,  9, 54, 14,
    11, 19, 16, 23, 33, 19, 38, 23, 55, 19,  0, 32, 17, 28, 25,
    33, 39, 28, 51, 33,  1, 37, 17, 42, 24, 38, 43, 42, 50, 38,
     3,  0, 22,  4, 29,  0, 47,  5, 55,  0,  9, 14, 21,  9, 31,
    14, 47,  9, 53, 14, 10, 19, 15, 23, 32, 19, 37, 23, 54, 19,
     0, 33, 16, 28, 26, 33, 38, 28, 52, 33,  0, 37, 18, 42, 25,
    38, 44, 42, 51, 38,  4,  0, 23,  4, 30,  0, 46,  5, 56,  0,
     8, 14, 22,  9, 30, 14, 47, 10, 52, 14,  9, 19, 14, 23, 31,
    19, 36, 23, 53, 19,  1, 33, 15, 28, 27, 33, 37, 28, 53, 33,
     0, 38, 19, 42, 26, 38, 45, 42, 52, 38,  5,  0, 23,  5, 31,
     0, 45,  5, 57,  0,  7, 14, 23,  9, 29, 14, 46, 10, 51, 14,
     8, 19, 13, 23, 30, 19, 36, 24, 52, 19,  2, 33, 14, 28, 28,
    33, 36, 28, 54, 33,  1, 38, 20, 42, 27, 38, 46, 42, 53, 38,
     6,  0, 22,  5, 32,  0, 44,  5, 58,  0,  6, 14, 23, 10, 28,
    14, 45, 10, 50, 14,  7, 19, 12, 23, 29, 19, 37, 24, 51, 19,
     3, 33, 13, 28, 29, 33, 36, 29, 55, 33,  2, 38, 21, 42, 28,
    38, 47, 42, 54, 38,  7,  0, 21,  5, 33,  0, 43,  5, 59,  0,
     5, 14, 22, 10, 27, 14, 44, 10, 49, 14,  6, 19, 12, 24, 28,
    19, 38, 24, 50, 19,  4, 33, 12, 28, 30, 33, 37, 29, 56, 33,
     3, 38, 22, 42, 29, 38, 47, 43, 55, 38,  8,  0, 20,  5, 34,
     0, 42,  5, 59,  1,  4, 14, 21, 10, 26, 14, 43, 10, 48, 14,
     5, 19, 13, 24, 27, 19, 39, 24, 49, 19,  5, 33, 12, 29, 31,
    33, 38, 29, 57, 33,  4, 38, 23, 42, 30, 38, 46, 43, 56, 38,
     9,  0, 19,  5, 35,  0, 41,  5, 58,  1,  3, 14, 20, 10, 25,
    14, 42, 10, 48, 15,  4, 19, 14, 24, 26, 19, 40, 24, 48, 19,
     6, 33, 13, 29, 32, 33, 39, 29, 58, 33,  5, 38, 23, 43, 31,
    38, 45, 43, 57, 38, 10,  0, 18,  5, 35,  1, 40,  5, 57,  1,
     2, 14, 19, 10, 24, 14, 41, 10, 49, 15,  3, 19, 15, 24, 25,
    19, 41, 24, 48, 20,  7, 33, 14, 29, 33, 33, 40, 29, 59, 33,
     6, 38, 22, 43, 32, 38, 44, 43, 58, 38, 11,  0, 17,  5, 34,
     1, 39,  5, 56,  1,  1, 14, 18, 10, 24, 15, 40, 10, 50, 15,
     2, 19, 16, 24, 24, 19, 42, 24, 49, 20,  8, 33, 15, 29, 34,
    33, 41, 29, 59, 34,  7, 38, 21, 43, 33, 38, 43, 43, 59, 38,
    11,  1, 16,  5, 33,  1, 38,  5, 55,  1,  0, 14, 17, 10, 25,
    15, 39, 10, 51, 15,  1, 19, 17, 24, 24, 20, 43, 24, 50, 20,
     9, 33, 16, 29, 35, 33, 42, 29, 58, 34,  8, 38, 20, 43, 34,
    38, 42, 43, 59, 39, 10,  1, 15,  5, 32,  1, 37,  5, 54,  1,
     0, 15, 16, 10, 26, 15, 38, 10, 52, 15,  0, 19, 18, 24, 25,
    20, 44, 24, 51, 20, 10, 33, 17, 29, 35, 34, 43, 29, 57, 34,
     9, 38, 19, 43, 35, 38, 41, 43, 58, 39,  9,  1, 14,  5, 31,
     1, 36,  5, 53,  1,  1, 15, 15, 10, 27, 15, 37, 10, 53, 15,
     0, 20, 19, 24, 26, 20, 45, 24, 52, 20, 11, 33, 18, 29, 34,
    34, 44, 29, 56, 34, 10, 38, 18, 43, 35, 39, 40, 43, 57, 39,
     8,  1, 13,  5, 30,  1, 36,  6, 52,  1,  2, 15, 14, 10, 28,
    15, 36, 10, 54, 15,  1, 20, 20, 24, 27, 20, 46, 24, 53, 20,
    11, 34, 19, 29, 33, 34, 45, 29, 55, 34, 11, 38, 17, 43, 34,
    39, 39, 43, 56, 39,  7,  1, 12,  5, 29,  1, 37,  6, 51,  1,
     3, 15, 13, 10, 29, 15, 36, 11, 55, 15,  2, 20, 21, 24, 28,
    20, 47, 24, 54, 20, 10, 34, 20, 29, 32, 34, 46, 29, 54, 34,
    11, 39, 16, 43, 33, 39, 38, 43, 55, 39,  6,  1, 12,  6, 28,
     1, 38,  6, 50,  1,  4, 15, 12, 10, 30, 15, 37, 11, 56, 15,
     3, 20, 22, 24, 29, 20, 47, 25, 55, 20,  9, 34, 21, 29, 31,
    34, 47, 29, 53, 34, 10, 39, 15, 43, 32, 39, 37, 43, 54, 39,
     5,  1, 13,  6, 27,  1, 39,  6, 49,  1,  5, 15, 12, 11, 31,
    15, 38, 11, 57, 15,  4, 20, 23, 24, 30, 20, 46, 25, 56, 20,
     8, 34, 22, 29, 30, 34, 47, 30, 52, 34,  9, 39, 14, 43, 31,
    39, 36, 43, 53, 39,  4,  1, 14,  6, 26,  1, 40,  6, 48,  1,
     6, 15, 13, 11, 32, 15, 39, 11, 58, 15,  5, 20, 23, 25, 31,
    20, 45, 25, 57, 20,  7, 34, 23, 29, 29, 34, 46, 30, 51, 34,
     8, 39, 13, 43, 30, 39, 36, 44, 52, 39,  3,  1, 15,  6, 25,
     1, 41,  6, 48,  2,  7, 15, 14, 11, 33, 15, 40, 11, 59, 15,
     6, 20, 22, 25, 32, 20, 44, 25, 58, 20,  6, 34, 23, 30, 28,
    34, 45, 30, 50, 34,  7, 39, 12, 43, 29, 39, 37, 44, 51, 39,
     2,  1, 16,  6, 24,  1, 42,  6, 49,  2,  8, 15, 15, 11, 34,
    15, 41, 11, 59, 16,  7, 20, 21, 25, 33, 20, 43, 25, 59, 20,
     5, 34, 22, 30, 27, 34, 44, 30, 49, 34,  6, 39, 12, 44, 28,
    39, 38, 44, 50, 39,  1,  1, 17,  6, 24,  2, 43,  6, 50,  2,
     9, 15, 16, 11, 35, 15, 42, 11, 58, 16,  8, 20, 20, 25, 34,
    20, 42, 25, 59, 21,  4, 34, 21, 30, 26, 34, 43, 30, 48, 34,
     5, 39, 13, 44, 27, 39, 39, 44, 49, 39,  0,  1, 18,  6, 25,
     2, 44,  6, 51,  2, 10, 15, 17, 11, 35, 16, 43, 11, 57, 16,
     9, 20, 19, 25, 35, 20, 41, 25, 58, 21,  3, 34, 20, 30, 25,
    34, 42, 30, 48, 35,  4, 39, 14, 44, 26, 39, 40, 44, 48, 39,
     0,  2, 19,  6, 26,  2, 45,  6, 52,  2, 11, 15, 18, 11, 34,
    16, 44, 11, 56, 16, 10, 20, 18, 25, 35, 21, 40, 25, 57, 21,
     2, 34, 19, 30, 24, 34, 41, 30, 49, 35,  3, 39, 15, 44, 25,
    39, 41, 44, 48, 40,  1,  2, 20,  6, 27,  2, 46,  6, 53,  2,
    11, 16, 19, 11, 33, 16, 45, 11, 55, 16, 11, 20, 17, 25, 34,
    21, 39, 25, 56, 21,  1, 34, 18, 30, 24, 35, 40, 30, 50, 35,
     2, 39, 16, 44, 24, 39, 42, 44, 49, 40,  2,  2, 21,  6, 28,
     2, 47,  6, 54,  2, 10, 16, 20, 11, 32, 16, 46, 11, 54, 16,
    11, 21, 16, 25, 33, 21, 38, 25, 55, 21,  0, 34, 17, 30, 25,
    35, 39, 30, 51, 35,  1, 39, 17, 44, 24, 40, 43, 44, 50, 40,
     3,  2, 22,  6, 29,  2, 47,  7, 55,  2,  9, 16, 21, 11, 31,
    16, 47, 11, 53, 16, 10, 21, 15, 25, 32, 21, 37, 25, 54, 21,
     0, 35, 16, 30, 26, 35, 38, 30, 52, 35,  0, 39, 18, 44, 25,
    40, 44, 44, 51, 40,  4,  2, 23,  6, 30,  2, 46,  7, 56,  2,
     8, 16, 22, 11, 30, 16, 47, 12, 52, 16,  9, 21, 14, 25, 31,
    21, 36, 25, 53, 21,  1, 35, 15, 30, 27, 35, 37, 30, 53, 35,
     0, 40, 19, 44, 26, 40, 45, 44, 52, 40,  5,  2, 23,  7, 31,
     2, 45,  7, 57,  2,  7, 16, 23, 11, 29, 16, 46, 12, 51, 16,
     8, 21, 13, 25, 30, 21, 36, 26, 52, 21,  2, 35, 14, 30, 28,
    35, 36, 30, 54, 35,  1, 40, 20, 44, 27, 40, 46, 44, 53, 40,
     6,  2, 22,  7, 32,  2, 44,  7, 58,  2,  6, 16, 23, 12, 28,
    16, 45, 12, 50, 16,  7, 21, 12, 25, 29, 21, 37, 26, 51, 21,
     3, 35, 13, 30, 29, 35, 36, 31, 55, 35,  2, 40, 21, 44, 28,
    40, 47, 44, 54, 40,  7,  2, 21,  7, 33,  2, 43,  7, 59,  2,
     5, 16, 22, 12, 27, 16, 44, 12, 49, 16,  6, 21, 12, 26, 28,
    21, 38, 26, 50, 21,  4, 35, 12, 30, 30, 35, 37, 31, 56, 35,
     3, 40, 22, 44, 29, 40, 36, 36, 55, 40,  8,  2, 20,  7, 34,
     2, 42,  7, 59,  3,  4, 16, 21, 12, 26, 16, 43, 12, 48, 16,
     5, 21, 13, 26, 27, 21, 39, 26, 49, 21,  5, 35, 12, 31, 31,
    35, 38, 31, 57, 35,  4, 40, 23, 44, 30, 40, 37, 36, 56, 40,
     9,  2, 19,  7, 35,  2, 41,  7, 58,  3,  3, 16, 20, 12, 25,
    16, 42, 12, 48, 17,  4, 21, 14, 26, 26, 21, 40, 26, 48, 21,
     6, 35, 13, 31, 32, 35, 39, 31, 58, 35,  5, 40, 12, 36, 31,
    40, 38, 36, 57, 40, 10,  2, 18,  7, 35,  3, 40,  7, 57,  3,
     2, 16, 19, 12, 24, 16, 41, 12, 49, 17,  3, 21, 15, 26, 25,
    21, 41, 26, 48, 22,  7, 35, 14, 31, 33, 35, 40, 31, 59, 35,
     6, 40, 13, 36, 32, 40, 39, 36, 58, 40, 11,  2, 17,  7, 34,
     3, 39,  7, 56,  3,  1, 16, 18, 12, 24, 17, 40, 12, 50, 17,
     2, 21, 16, 26, 24, 21, 42, 26, 49, 22,  8, 35, 15, 31, 34,
    35, 41, 31, 48, 27,  7, 40, 14, 36, 33, 40, 40, 36, 59, 40,
    11,  3, 16,  7, 33,  3, 38,  7, 55,  3,  0, 16, 17, 12, 25,
    17, 39, 12, 51, 17,  1, 21, 17, 26, 24, 22, 43, 26, 50, 22,
     9, 35, 16, 31, 35, 35, 42, 31, 49, 27,  8, 40, 15, 36, 34,
    40, 41, 36, 59, 41, 10,  3, 15,  7, 32,  3, 37,  7, 54,  3,
     0, 17, 16, 12, 26, 17, 38, 12, 52, 17,  0, 21, 18, 26, 25,
    22, 44, 26, 51, 22, 10, 35, 17, 31, 24, 27, 43, 31, 50, 27,
     9, 40, 16, 36, 35, 40, 42, 36, 58, 41,  9,  3, 14,  7, 31,
     3, 36,  7, 53,  3,  1, 17, 15, 12, 27, 17, 37, 12, 53, 17,
     0, 22, 19, 26, 26, 22, 45, 26, 52, 22, 11, 35, 18, 31, 25,
    27, 44, 31, 51, 27, 10, 40, 17, 36, 35, 41, 43, 36, 57, 41,
     8,  3, 13,  7, 30,  3, 36,  8, 52,  3,  2, 17, 14, 12, 28,
    17, 36, 12, 54, 17,  1, 22, 20, 26, 27, 22, 46, 26, 53, 22,
     0, 27, 19, 31, 26, 27, 45, 31, 52, 27, 11, 40, 18, 36, 34,
    41, 44, 36, 56, 41,  7,  3, 12,  7, 29,  3, 37,  8, 51,  3,
     3, 17, 13, 12, 29, 17, 36, 13, 55, 17,  2, 22, 21, 26, 28,
    22, 47, 26, 54, 22,  1, 27, 20, 31, 27, 27, 46, 31, 53, 27,
    11, 41, 19, 36, 33, 41, 45, 36, 55, 41,  6,  3, 12,  8, 28,
     3, 38,  8, 50,  3,  4, 17, 12, 12, 30, 17, 37, 13, 56, 17,
     3, 22, 22, 26, 29, 22, 36, 18, 55, 22,  2, 27, 21, 31, 28,
    27, 47, 31, 54, 27, 10, 41, 20, 36, 32, 41, 46, 36, 54, 41,
     5,  3, 13,  8, 27,  3, 39,  8, 49,  3,  5, 17, 12, 13, 31,
    17, 38, 13, 57, 17,  4, 22, 23, 26, 30, 22, 37, 18, 56, 22,
     3, 27, 22, 31, 29, 27, 47, 32, 55, 27,  9, 41, 21, 36, 31,
    41, 47, 36, 53, 41,  4,  3, 14,  8, 26,  3, 40,  8, 48,  3,
     6, 17, 13, 13, 32, 17, 39, 13, 58, 17,  5, 22, 12, 18, 31,
    22, 38, 18, 57, 22,  4, 27, 23, 31, 30, 27, 46, 32, 56, 27,
     8, 41, 22, 36, 30, 41, 47, 37, 52, 41,  3,  3, 15,  8, 25,
     3, 41,  8, 48,  4,  7, 17, 14, 13, 33, 17, 40, 13, 59, 17,
     6, 22, 13, 18, 32, 22, 39, 18, 58, 22,  5, 27, 23, 32, 31,
    27, 45, 32, 57, 27,  7, 41, 23, 36, 29, 41, 46, 37, 51, 41,
     2,  3, 16,  8, 24,  3, 42,  8, 49,  4,  8, 17, 15, 13, 34,
    17, 41, 13, 48,  9,  7, 22, 14, 18, 33, 22, 40, 18, 59, 22,
     6, 27, 22, 32, 32, 27, 44, 32, 58, 27,  6, 41, 23, 37, 28,
    41, 45, 37, 50, 41,  1,  3, 17,  8, 24,  4, 43,  8, 50,  4,
     9, 17, 16, 13, 35, 17, 42, 13, 49,  9,  8, 22, 15, 18, 34,
    22, 41, 18, 59, 23,  7, 27, 21, 32, 33, 27, 43, 32, 59, 27,
     5, 41, 22, 37, 27, 41, 44, 37, 49, 41,  0,  3, 18,  8, 25,
     4, 44,  8, 51,  4, 10, 17, 17, 13, 24,  9, 43, 13, 50,  9,
     9, 22, 16, 18, 35, 22, 42, 18, 58, 23,  8, 27, 20, 32, 34,
    27, 42, 32, 59, 28,  4, 41, 21, 37, 26, 41, 43, 37, 48, 41,
     0,  4, 19,  8, 26,  4, 45,  8, 52,  4, 11, 17, 18, 13, 25,
     9, 44, 13, 51,  9, 10, 22, 17, 18, 35, 23, 43, 18, 57, 23,
     9, 27, 19, 32, 35, 27, 41, 32, 58, 28,  3, 41, 20, 37, 25,
    41, 42, 37, 48, 42,  1,  4, 20,  8, 27,  4, 46,  8, 53,  4,
     0,  9, 19, 13, 26,  9, 45, 13, 52,  9, 11, 22, 18, 18, 34,
    23, 44, 18, 56, 23, 10, 27, 18, 32, 35, 28, 40, 32, 57, 28,
     2, 41, 19, 37, 24, 41, 41, 37, 49, 42,  2,  4, 21,  8, 28,
     4, 47,  8, 54,  4,  1,  9, 20, 13, 27,  9, 46, 13, 53,  9,
    11, 23, 19, 18, 33, 23, 45, 18, 55, 23, 11, 27, 17, 32, 34,
    28, 39, 32, 56, 28,  1, 41, 18, 37, 24, 42, 40, 37, 50, 42,
     3,  4, 22,  8, 29,  4, 36,  0, 55,  4,  2,  9, 21, 13, 28,
     9, 47, 13, 54,  9, 10, 23, 20, 18, 32, 23, 46, 18, 54, 23,
    11, 28, 16, 32, 33, 28, 38, 32, 55, 28,  0, 41, 17, 37, 25,
    42, 39, 37, 51, 42,  4,  4, 23,  8, 30,  4, 37,  0, 56,  4,
     3,  9, 22, 13, 29,  9, 47, 14, 55,  9,  9, 23, 21, 18, 31,
    23, 47, 18, 53, 23, 10, 28, 15, 32, 32, 28, 37, 32, 54, 28,
     0, 42, 16, 37, 26, 42, 38, 37, 52, 42,  5,  4, 12,  0, 31,
     4, 38,  0, 57,  4,  4,  9, 23, 13, 30,  9, 46, 14, 56,  9,
     8, 23, 22, 18, 30, 23, 47, 19, 52, 23,  9, 28, 14, 32, 31,
    28, 36, 32, 53, 28,  1, 42, 15, 37, 27, 42, 37, 37, 53, 42,
     6,  4, 13,  0, 32,  4, 39,  0, 58,  4,  5,  9, 23, 14, 31,
     9, 45, 14, 57,  9,  7, 23, 23, 18, 29, 23, 46, 19, 51, 23,
     8, 28, 13, 32, 30, 28, 36, 33, 52, 28,  2, 42, 14, 37, 28,
    42, 36, 37, 54, 42,  7,  4, 14,  0, 33,  4, 40,  0, 59,  4,
     6,  9, 22, 14, 32,  9, 44, 14, 58,  9,  6, 23, 23, 19, 28,
    23, 45, 19, 50, 23,  7, 28, 12, 32, 29, 28, 37, 33, 51, 28,
     3, 42, 13, 37, 29, 42, 36, 38, 55, 42,  8,  4, 15,  0, 34,
     4, 41,  0, 59,  5,  7,  9, 21, 14, 33,  9, 43, 14, 59,  9,
     5, 23, 22, 19, 27, 23, 44, 19, 49, 23,  6, 28, 12, 33, 28,
    28, 38, 33, 50, 28,  4, 42, 12, 37, 30, 42, 37, 38, 56, 42,
     9,  4, 16,  0, 35,  4, 42,  0, 58,  5,  8,  9, 20, 14, 34,
     9, 42, 14, 59, 10,  4, 23, 21, 19, 26, 23, 43, 19, 48, 23,
     5, 28, 13, 33, 27, 28, 39, 33, 49, 28,  5, 42, 12, 38, 31,
    42, 38, 38, 57, 42, 10,  4, 17,  0, 35,  5, 43,  0, 57,  5,
     9,  9, 19, 14, 35,  9, 41, 14, 58, 10,  3, 23, 20, 19, 25,
    23, 42, 19, 48, 24,  4, 28, 14, 33, 26, 28, 40, 33, 48, 28,
     6, 42, 13, 38, 32, 42, 39, 38, 58, 42, 11,  4, 18,  0, 34,
     5, 44,  0, 56,  5, 10,  9, 18, 14, 35, 10, 40, 14, 57, 10,
     2, 23, 19, 19, 24, 23, 41, 19, 49, 24,  3, 28, 15, 33, 25,
    28, 41, 33, 48, 29,  7, 42, 14, 38, 33, 42, 40, 38, 59, 42,
    11,  5, 19,  0, 33,  5, 45,  0, 55,  5, 11,  9, 17, 14, 34,
    10, 39, 14, 56, 10,  1, 23, 18, 19, 24, 24, 40, 19, 50, 24,
     2, 28, 16, 33, 24, 28, 42, 33, 49, 29,  8, 42, 15, 38, 34,
    42, 41, 38, 59, 43, 10,  5, 20,  0, 32,  5, 46,  0, 54,  5,
    11, 10, 16, 14, 33, 10, 38, 14, 55, 10,  0, 23, 17, 19, 25,
    24, 39, 19, 51, 24,  1, 28, 17, 33, 24, 29, 43, 33, 50, 29,
     9, 42, 16, 38, 35, 42, 42, 38, 58, 43,  9,  5, 21,  0, 31,
     5, 47,  0, 53,  5, 10, 10, 15, 14, 32, 10, 37, 14, 54, 10,
     0, 24, 16, 19, 26, 24, 38, 19, 52, 24,  0, 28, 18, 33, 25,
    29, 44, 33, 51, 29, 10, 42, 17, 38, 35, 43, 43, 38, 57, 43,
     8,  5, 22,  0, 30,  5, 47,  1, 52,  5,  9, 10, 14, 14, 31,
    10, 36, 14, 53, 10,  1, 24, 15, 19, 27, 24, 37, 19, 53, 24,
     0, 29, 19, 33, 26, 29, 45, 33, 52, 29, 11, 42, 18, 38, 34,
    43, 44, 38, 56, 43,  7,  5, 23,  0, 29,  5, 46,  1, 51,  5,
     8, 10, 13, 14, 30, 10, 36, 15, 52, 10,  2, 24, 14, 19, 28,
    24, 36, 19, 54, 24,  1, 29, 20, 33, 27, 29, 46, 33, 53, 29,
    11, 43, 19, 38, 33, 43, 45, 38, 55, 43,  6,  5, 23,  1, 28,
     5, 45,  1, 50,  5,  7, 10, 12, 14, 29, 10, 37, 15, 51, 10,
     3, 24, 13, 19, 29, 24, 36, 20, 55, 24,  2, 29, 21, 33, 28,
    29, 47, 33, 54, 29, 10, 43, 20, 38, 32, 43, 46, 38, 54, 43,
     5,  5, 22,  1, 27,  5, 44,  1, 49,  5,  6, 10, 12, 15, 28,
    10, 38, 15, 50, 10,  4, 24, 12, 19, 30, 24, 37, 20, 56, 24,
     3, 29, 22, 33, 29, 29, 47, 34, 55, 29,  9, 43, 21, 38, 31,
    43, 47, 38, 53, 43,  4,  5, 21,  1, 26,  5, 43,  1, 48,  5,
     5, 10, 13, 15, 27, 10, 39, 15, 49, 10,  5, 24, 12, 20, 31,
    24, 38, 20, 57, 24,  4, 29, 23, 33, 30, 29, 46, 34, 56, 29,
     8, 43, 22, 38, 30, 43, 47, 39, 52, 43,  3,  5, 20,  1, 25,
     5, 42,  1, 48,  6,  4, 10, 14, 15, 26, 10, 40, 15, 48, 10,
     6, 24, 13, 20, 32, 24, 39, 20, 58, 24,  5, 29, 23, 34, 31,
    29, 45, 34, 57, 29,  7, 43, 23, 38, 29, 43, 46, 39, 51, 43,
     2,  5, 19,  1, 24,  5, 41,  1, 49,  6,  3, 10, 15, 15, 25,
    10, 41, 15, 48, 11,  7, 24, 14, 20, 33, 24, 40, 20, 59, 24,
     6, 29, 22, 34, 32, 29, 44, 34, 58, 29,  6, 43, 23, 39, 28,
    43, 45, 39, 50, 43,  1,  5, 18,  1, 24,  6, 40,  1, 50,  6,
     2, 10, 16, 15, 24, 10, 42, 15, 49, 11,  8, 24, 15, 20, 34,
    24, 41, 20, 59, 25,  7, 29, 21, 34, 33, 29, 43, 34, 59, 29,
     5, 43, 22, 39, 27, 43, 44, 39, 49, 43,  0,  5, 17,  1, 25,
     6, 39,  1, 51,  6,  1, 10, 17, 15, 24, 11, 43, 15, 50, 11,
     9, 24, 16, 20, 35, 24, 42, 20, 58, 25,  8, 29, 20, 34, 34,
    29, 42, 34, 59, 30,  4, 43, 21, 39, 26, 43, 43, 39, 48, 43,
     0,  6, 16,  1, 26,  6, 38,  1, 52,  6,  0, 10, 18, 15, 25,
    11, 44, 15, 51, 11, 10, 24, 17, 20, 35, 25, 43, 20, 57, 25,
     9, 29, 19, 34, 35, 29, 41, 34, 58, 30,  3, 43, 20, 39, 25,
    43, 42, 39, 48, 44,  1,  6, 15,  1, 27,  6, 37,  1, 53,  6,
     0, 11, 19, 15, 26, 11, 45, 15, 52, 11, 11, 24, 18, 20, 34,
    25, 44, 20, 56, 25, 10, 29, 18, 34, 35, 30, 40, 34, 57, 30,
     2, 43, 19, 39, 24, 43, 41, 39, 49, 44,  2,  6, 14,  1, 28,
     6, 36,  1, 54,  6,  1, 11, 20, 15, 27, 11, 46, 15, 53, 11,
    11, 25, 19, 20, 33, 25, 45, 20, 55, 25, 11, 29, 17, 34, 34,
    30, 39, 34, 56, 30,  1, 43, 18, 39, 24, 44, 40, 39, 50, 44,
     3,  6, 13,  1, 29,  6, 36,  2, 55,  6,  2, 11, 21, 15, 28,
    11, 47, 15, 54, 11, 10, 25, 20, 20, 32, 25, 46, 20, 54, 25,
    11, 30, 16, 34, 33, 30, 38, 34, 55, 30,  0, 43, 17, 39, 25,
    44, 39, 39, 51, 44,  4,  6, 12,  1, 30,  6, 37,  2, 56,  6,
     3, 11, 22, 15, 29, 11, 47, 16, 55, 11,  9, 25, 21, 20, 31,
    25, 47, 20, 53, 25, 10, 30, 15, 34, 32, 30, 37, 34, 54, 30,
     0, 44, 16, 39, 26, 44, 38, 39, 52, 44,  5,  6, 12,  2, 31,
     6, 38,  2, 57,  6,  4, 11, 23, 15, 30, 11, 46, 16, 56, 11,
     8, 25, 22, 20, 30, 25, 47, 21, 52, 25,  9, 30, 14, 34, 31,
    30, 36, 34, 53, 30,  1, 44, 15, 39, 27, 44, 37, 39, 53, 44,
     6,  6, 13,  2, 32,  6, 39,  2, 58,  6,  5, 11, 23, 16, 31,
    11, 45, 16, 57, 11,  7, 25, 23, 20, 29, 25, 46, 21, 51, 25,
     8, 30, 13, 34, 30, 30, 36, 35, 52, 30,  2, 44, 14, 39, 28,
    44, 36, 39, 54, 44,  7,  6, 14,  2, 33,  6, 40,  2, 59,  6,
     6, 11, 22, 16, 32, 11, 44, 16, 58, 11,  6, 25, 23, 21, 28,
    25, 45, 21, 50, 25,  7, 30, 12, 34, 29, 30, 37, 35, 51, 30,
     3, 44, 13, 39, 29, 44, 36, 40, 55, 44,  8,  6, 15,  2, 34,
     6, 41,  2, 59,  7,  7, 11, 21, 16, 33, 11, 43, 16, 59, 11,
     5, 25, 22, 21, 27, 25, 44, 21, 49, 25,  6, 30, 12, 35, 28,
    30, 38, 35, 50, 30,  4, 44, 12, 39, 30, 44, 37, 40, 56, 44,
     9,  6, 16,  2, 35,  6, 42,  2, 58,  7,  8, 11, 20, 16, 34,
    11, 42, 16, 59, 12,  4, 25, 21, 21, 26, 25, 43, 21, 48, 25,
     5, 30, 13, 35, 27, 30, 39, 35, 49, 30,  5, 44, 12, 40, 31,
    44, 38, 40, 57, 44, 10,  6, 17,  2, 35,  7, 43,  2, 57,  7,
     9, 11, 19, 16, 35, 11, 41, 16, 58, 12,  3, 25, 20, 21, 25,
    25, 42, 21, 48, 26,  4, 30, 14, 35, 26, 30, 40, 35, 48, 30,
     6, 44, 13, 40, 32, 44, 39, 40, 58, 44, 11,  6, 18,  2, 34,
     7, 44,  2, 56,  7, 10, 11, 18, 16, 35, 12, 40, 16, 57, 12,
     2, 25, 19, 21, 24, 25, 41, 21, 49, 26,  3, 30, 15, 35, 25,
    30, 41, 35, 48, 31,  7, 44, 14, 40, 33, 44, 40, 40, 59, 44,
    11,  7, 19,  2, 33,  7, 45,  2, 55,  7, 11, 11, 17, 16, 34,
    12, 39, 16, 56, 12,  1, 25, 18, 21, 24, 26, 40, 21, 50, 26,
     2, 30, 16, 35, 24, 30, 42, 35, 49, 31,  8, 44, 15, 40, 34,
    44, 41, 40, 48, 36, 10,  7, 20,  2, 32,  7, 46,  2, 54,  7,
    11, 12, 16, 16, 33, 12, 38, 16, 55, 12,  0, 25, 17, 21, 25,
    26, 39, 21, 51, 26,  1, 30, 17, 35, 24, 31, 43, 35, 50, 31,
     9, 44, 16, 40, 35, 44, 42, 40, 49, 36,  9,  7, 21,  2, 31,
     7, 47,  2, 53,  7, 10, 12, 15, 16, 32, 12, 37, 16, 54, 12,
     0, 26, 16, 21, 26, 26, 38, 21, 52, 26,  0, 30, 18, 35, 25,
    31, 44, 35, 51, 31, 10, 44, 17, 40, 24, 36, 43, 40, 50, 36,
     8,  7, 22,  2, 30,  7, 47,  3, 52,  7,  9, 12, 14, 16, 31,
    12, 36, 16, 53, 12,  1, 26, 15, 21, 27, 26, 37, 21, 53, 26,
     0, 31, 19, 35, 26, 31, 45, 35, 52, 31, 11, 44, 18, 40, 25,
    36, 44, 40, 51, 36,  7,  7, 23,  2, 29,  7, 46,  3, 51,  7,
     8, 12, 13, 16, 30, 12, 36, 17, 52, 12,  2, 26, 14, 21, 28,
    26, 36, 21, 54, 26,  1, 31, 20, 35, 27, 31, 46, 35, 53, 31,
     0, 36, 19, 40, 26, 36, 45, 40, 52, 36,  6,  7, 23,  3, 28,
     7, 45,  3, 50,  7,  7, 12, 12, 16, 29, 12, 37, 17, 51, 12,
     3, 26, 13, 21, 29, 26, 36, 22, 55, 26,  2, 31, 21, 35, 28,
    31, 47, 35, 54, 31,  1, 36, 20, 40, 27, 36, 46, 40, 53, 36,
     5,  7, 22,  3, 27,  7, 44,  3, 49,  7,  6, 12, 12, 17, 28,
    12, 38, 17, 50, 12,  4, 26, 12, 21, 30, 26, 37, 22, 56, 26,
     3, 31, 22, 35, 29, 31, 36, 27, 55, 31,  2, 36, 21, 40, 28,
    36, 47, 40, 54, 36,  4,  7, 21,  3, 26,  7, 43,  3, 48,  7,
     5, 12, 13, 17, 27, 12, 39, 17, 49, 12,  5, 26, 12, 22, 31,
    26, 38, 22, 57, 26,  4, 31, 23, 35, 30, 31, 37, 27, 56, 31,
     3, 36, 22, 40, 29, 36, 47, 41, 55, 36,  3,  7, 20,  3, 25,
     7, 42,  3, 48,  8,  4, 12, 14, 17, 26, 12, 40, 17, 48, 12,
     6, 26, 13, 22, 32, 26, 39, 22, 58, 26,  5, 31, 12, 27, 31,
    31, 38, 27, 57, 31,  4, 36, 23, 40, 30, 36, 46, 41, 56, 36,
     2,  7, 19,  3, 24,  7, 41,  3, 49,  8,  3, 12, 15, 17, 25,
    12, 41, 17, 48, 13,  7, 26, 14, 22, 33, 26, 40, 22, 59, 26,
     6, 31, 13, 27, 32, 31, 39, 27, 58, 31,  5, 36, 23, 41, 31,
    36, 45, 41, 57, 36,  1,  7, 18,  3, 24,  8, 40,  3, 50,  8,
     2, 12, 16, 17, 24, 12, 42, 17, 49, 13,  8, 26, 15, 22, 34,
    26, 41, 22, 48, 18,  7, 31, 14, 27, 33, 31, 40, 27, 59, 31,
     6, 36, 22, 41, 32, 36, 44, 41, 58, 36,  0,  7, 17,  3, 25,
     8, 39,  3, 51,  8,  1, 12, 17, 17, 24, 13, 43, 17, 50, 13,
     9, 26, 16, 22, 35, 26, 42, 22, 49, 18,  8, 31, 15, 27, 34,
    31, 41, 27, 59, 32,  7, 36, 21, 41, 33, 36, 43, 41, 59, 36,
     0,  8, 16,  3, 26,  8, 38,  3, 52,  8,  0, 12, 18, 17, 25,
    13, 44, 17, 51, 13, 10, 26, 17, 22, 24, 18, 43, 22, 50, 18,
     9, 31, 16, 27, 35, 31, 42, 27, 58, 32,  8, 36, 20, 41, 34,
    36, 42, 41, 59, 37,  1,  8, 15,  3, 27,  8, 37,  3, 53,  8,
     0, 13, 19, 17, 26, 13, 45, 17, 52, 13, 11, 26, 18, 22, 25,
    18, 44, 22, 51, 18, 10, 31, 17, 27, 35, 32, 43, 27, 57, 32,
     9, 36, 19, 41, 35, 36, 41, 41, 58, 37,  2,  8, 14,  3, 28,
     8, 36,  3, 54,  8,  1, 13, 20, 17, 27, 13, 46, 17, 53, 13,
     0, 18, 19, 22, 26, 18, 45, 22, 52, 18, 11, 31, 18, 27, 34,
    32, 44, 27, 56, 32, 10, 36, 18, 41, 35, 37, 40, 41, 57, 37,
     3,  8, 13,  3, 29,  8, 36,  4, 55,  8,  2, 13, 21, 17, 28,
    13, 47, 17, 54, 13,  1, 18, 20, 22, 27, 18, 46, 22, 53, 18,
    11, 32, 19, 27, 33, 32, 45, 27, 55, 32, 11, 36, 17, 41, 34,
    37, 39, 41, 56, 37,  4,  8, 12,  3, 30,  8, 37,  4, 56,  8,
     3, 13, 22, 17, 29, 13, 36,  9, 55, 13,  2, 18, 21, 22, 28,
    18, 47, 22, 54, 18, 10, 32, 20, 27, 32, 32, 46, 27, 54, 32,
    11, 37, 16, 41, 33, 37, 38, 41, 55, 37,  5,  8, 12,  4, 31,
     8, 38,  4, 57,  8,  4, 13, 23, 17, 30, 13, 37,  9, 56, 13,
     3, 18, 22, 22, 29, 18, 47, 23, 55, 18,  9, 32, 21, 27, 31,
    32, 47, 27, 53, 32, 10, 37, 15, 41, 32, 37, 37, 41, 54, 37,
     6,  8, 13,  4, 32,  8, 39,  4, 58,  8,  5, 13, 12,  9, 31,
    13, 38,  9, 57, 13,  4, 18, 23, 22, 30, 18, 46, 23, 56, 18,
     8, 32, 22, 27, 30, 32, 47, 28, 52, 32,  9, 37, 14, 41, 31,
    37, 36, 41, 53, 37,  7,  8, 14,  4, 33,  8, 40,  4, 59,  8,
     6, 13, 13,  9, 32, 13, 39,  9, 58, 13,  5, 18, 23, 23, 31,
    18, 45, 23, 57, 18,  7, 32, 23, 27, 29, 32, 46, 28, 51, 32,
     8, 37, 13, 41, 30, 37, 36, 42, 52, 37,  8,  8, 15,  4, 34,
     8, 41,  4, 48,  0,  7, 13, 14,  9, 33, 13, 40,  9, 59, 13,
     6, 18, 22, 23, 32, 18, 44, 23, 58, 18,  6, 32, 23, 28, 28,
    32, 45, 28, 50, 32,  7, 37, 12, 41, 29, 37, 37, 42, 51, 37,
     9,  8, 16,  4, 35,  8, 42,  4, 49,  0,  8, 13, 15,  9, 34,
    13, 41,  9, 59, 14,  7, 18, 21, 23, 33, 18, 43, 23, 59, 18,
     5, 32, 22, 28, 27, 32, 44, 28, 49, 32,  6, 37, 12, 42, 28,
    37, 38, 42, 50, 37, 10,  8, 17,  4, 24,  0, 43,  4, 50,  0,
     9, 13, 16,  9, 35, 13, 42,  9, 58, 14,  8, 18, 20, 23, 34,
    18, 42, 23, 59, 19,  4, 32, 21, 28, 26, 32, 43, 28, 48, 32,
     5, 37, 13, 42, 27, 37, 39, 42, 49, 37, 11,  8, 18,  4, 25,
     0, 44,  4, 51,  0, 10, 13, 17,  9, 35, 14, 43,  9, 57, 14,
     9, 18, 19, 23, 35, 18, 41, 23, 58, 19,  3, 32, 20, 28, 25,
    32, 42, 28, 48, 33,  4, 37, 14, 42, 26, 37, 40, 42, 48, 37,
};

static const uint8_t hq_tab_05[] = {
     0,  0, 25,  4, 34,  0, 59,  4, 68,  0, 13, 13, 22,  9, 47,
    13, 56,  9, 78, 14, 10, 18, 28, 23, 44, 18, 58, 23, 78, 18,
     8, 32, 31, 28, 38, 32, 61, 28, 68, 32, 11, 37, 18, 41, 41,
    37, 48, 41, 71, 37,  1,  0, 26,  4, 35,  0, 60,  4, 69,  0,
    14, 13, 23,  9, 47, 14, 57,  9, 77, 14, 11, 18, 27, 23, 45,
    18, 57, 23, 79, 18,  7, 32, 30, 28, 37, 32, 60, 28, 67, 32,
    10, 37, 17, 41, 40, 37, 48, 42, 70, 37,  2,  0, 27,  4, 36,
     0, 61,  4, 70,  0, 15, 13, 24,  9, 46, 14, 58,  9, 76, 14,
    12, 18, 26, 23, 46, 18, 56, 23, 79, 19,  6, 32, 29, 28, 36,
    32, 59, 28, 66, 32,  9, 37, 16, 41, 39, 37, 49, 42, 69, 37,
     3,  0, 28,  4, 37,  0, 62,  4, 71,  0, 15, 14, 25,  9, 45,
    14, 59,  9, 75, 14, 13, 18, 25, 23, 47, 18, 55, 23, 78, 19,
     5, 32, 28, 28, 35, 32, 58, 28, 65, 32,  8, 37, 16, 42, 38,
    37, 50, 42, 68, 37,  4,  0, 29,  4, 38,  0, 63,  4, 72,  0,
    14, 14, 26,  9, 44, 14, 60,  9, 74, 14, 14, 18, 24, 23, 47,
    19, 54, 23, 77, 19,  4, 32, 27, 28, 34, 32, 57, 28, 64, 32,
     7, 37, 17, 42, 37, 37, 51, 42, 67, 37,  5,  0, 30,  4, 39,
     0, 63,  5, 73,  0, 13, 14, 27,  9, 43, 14, 61,  9, 73, 14,
    15, 18, 23, 23, 46, 19, 53, 23, 76, 19,  3, 32, 26, 28, 33,
    32, 56, 28, 64, 33,  6, 37, 18, 42, 36, 37, 52, 42, 66, 37,
     6,  0, 31,  4, 40,  0, 62,  5, 74,  0, 12, 14, 28,  9, 42,
    14, 62,  9, 72, 14, 15, 19, 22, 23, 45, 19, 52, 23, 75, 19,
     2, 32, 25, 28, 32, 32, 55, 28, 65, 33,  5, 37, 19, 42, 35,
    37, 53, 42, 65, 37,  7,  0, 31,  5, 41,  0, 61,  5, 75,  0,
    11, 14, 29,  9, 41, 14, 63,  9, 71, 14, 14, 19, 21, 23, 44,
    19, 51, 23, 74, 19,  1, 32, 24, 28, 32, 33, 54, 28, 66, 33,
     4, 37, 20, 42, 34, 37, 54, 42, 64, 37,  8,  0, 30,  5, 42,
     0, 60,  5, 76,  0, 10, 14, 30,  9, 40, 14, 63, 10, 70, 14,
    13, 19, 20, 23, 43, 19, 50, 23, 73, 19,  0, 32, 23, 28, 33,
    33, 53, 28, 67, 33,  3, 37, 21, 42, 33, 37, 55, 42, 64, 38,
     9,  0, 29,  5, 43,  0, 59,  5, 77,  0,  9, 14, 31,  9, 39,
    14, 62, 10, 69, 14, 12, 19, 19, 23, 42, 19, 49, 23, 72, 19,
     0, 33, 22, 28, 34, 33, 52, 28, 68, 33,  2, 37, 22, 42, 32,
    37, 56, 42, 65, 38, 10,  0, 28,  5, 44,  0, 58,  5, 78,  0,
     8, 14, 31, 10, 38, 14, 61, 10, 68, 14, 11, 19, 18, 23, 41,
    19, 48, 23, 71, 19,  1, 33, 21, 28, 35, 33, 51, 28, 69, 33,
     1, 37, 23, 42, 32, 38, 57, 42, 66, 38, 11,  0, 27,  5, 45,
     0, 57,  5, 79,  0,  7, 14, 30, 10, 37, 14, 60, 10, 67, 14,
    10, 19, 17, 23, 40, 19, 48, 24, 70, 19,  2, 33, 20, 28, 36,
    33, 50, 28, 70, 33,  0, 37, 24, 42, 33, 38, 58, 42, 67, 38,
    12,  0, 26,  5, 46,  0, 56,  5, 79,  1,  6, 14, 29, 10, 36,
    14, 59, 10, 66, 14,  9, 19, 16, 23, 39, 19, 49, 24, 69, 19,
     3, 33, 19, 28, 37, 33, 49, 28, 71, 33,  0, 38, 25, 42, 34,
    38, 59, 42, 68, 38, 13,  0, 25,  5, 47,  0, 55,  5, 78,  1,
     5, 14, 28, 10, 35, 14, 58, 10, 65, 14,  8, 19, 16, 24, 38,
    19, 50, 24, 68, 19,  4, 33, 18, 28, 38, 33, 48, 28, 72, 33,
     1, 38, 26, 42, 35, 38, 60, 42, 69, 38, 14,  0, 24,  5, 47,
     1, 54,  5, 77,  1,  4, 14, 27, 10, 34, 14, 57, 10, 64, 14,
     7, 19, 17, 24, 37, 19, 51, 24, 67, 19,  5, 33, 17, 28, 39,
    33, 48, 29, 73, 33,  2, 38, 27, 42, 36, 38, 61, 42, 70, 38,
    15,  0, 23,  5, 46,  1, 53,  5, 76,  1,  3, 14, 26, 10, 33,
    14, 56, 10, 64, 15,  6, 19, 18, 24, 36, 19, 52, 24, 66, 19,
     6, 33, 16, 28, 40, 33, 49, 29, 74, 33,  3, 38, 28, 42, 37,
    38, 62, 42, 71, 38, 15,  1, 22,  5, 45,  1, 52,  5, 75,  1,
     2, 14, 25, 10, 32, 14, 55, 10, 65, 15,  5, 19, 19, 24, 35,
    19, 53, 24, 65, 19,  7, 33, 16, 29, 41, 33, 50, 29, 75, 33,
     4, 38, 29, 42, 38, 38, 63, 42, 72, 38, 14,  1, 21,  5, 44,
     1, 51,  5, 74,  1,  1, 14, 24, 10, 32, 15, 54, 10, 66, 15,
     4, 19, 20, 24, 34, 19, 54, 24, 64, 19,  8, 33, 17, 29, 42,
    33, 51, 29, 76, 33,  5, 38, 30, 42, 39, 38, 63, 43, 73, 38,
    13,  1, 20,  5, 43,  1, 50,  5, 73,  1,  0, 14, 23, 10, 33,
    15, 53, 10, 67, 15,  3, 19, 21, 24, 33, 19, 55, 24, 64, 20,
     9, 33, 18, 29, 43, 33, 52, 29, 77, 33,  6, 38, 31, 42, 40,
    38, 62, 43, 74, 38, 12,  1, 19,  5, 42,  1, 49,  5, 72,  1,
     0, 15, 22, 10, 34, 15, 52, 10, 68, 15,  2, 19, 22, 24, 32,
    19, 56, 24, 65, 20, 10, 33, 19, 29, 44, 33, 53, 29, 78, 33,
     7, 38, 31, 43, 41, 38, 61, 43, 75, 38, 11,  1, 18,  5, 41,
     1, 48,  5, 71,  1,  1, 15, 21, 10, 35, 15, 51, 10, 69, 15,
     1, 19, 23, 24, 32, 20, 57, 24, 66, 20, 11, 33, 20, 29, 45,
    33, 54, 29, 79, 33,  8, 38, 30, 43, 42, 38, 60, 43, 76, 38,
    10,  1, 17,  5, 40,  1, 48,  6, 70,  1,  2, 15, 20, 10, 36,
    15, 50, 10, 70, 15,  0, 19, 24, 24, 33, 20, 58, 24, 67, 20,
    12, 33, 21, 29, 46, 33, 55, 29, 79, 34,  9, 38, 29, 43, 43,
    38, 59, 43, 77, 38,  9,  1, 16,  5, 39,  1, 49,  6, 69,  1,
     3, 15, 19, 10, 37, 15, 49, 10, 71, 15,  0, 20, 25, 24, 34,
    20, 59, 24, 68, 20, 13, 33, 22, 29, 47, 33, 56, 29, 78, 34,
    10, 38, 28, 43, 44, 38, 58, 43, 78, 38,  8,  1, 16,  6, 38,
     1, 50,  6, 68,  1,  4, 15, 18, 10, 38, 15, 48, 10, 72, 15,
     1, 20, 26, 24, 35, 20, 60, 24, 69, 20, 14, 33, 23, 29, 47,
    34, 57, 29, 77, 34, 11, 38, 27, 43, 45, 38, 57, 43, 79, 38,
     7,  1, 17,  6, 37,  1, 51,  6, 67,  1,  5, 15, 17, 10, 39,
    15, 48, 11, 73, 15,  2, 20, 27, 24, 36, 20, 61, 24, 70, 20,
    15, 33, 24, 29, 46, 34, 58, 29, 76, 34, 12, 38, 26, 43, 46,
    38, 56, 43, 79, 39,  6,  1, 18,  6, 36,  1, 52,  6, 66,  1,
     6, 15, 16, 10, 40, 15, 49, 11, 74, 15,  3, 20, 28, 24, 37,
    20, 62, 24, 71, 20, 15, 34, 25, 29, 45, 34, 59, 29, 75, 34,
    13, 38, 25, 43, 47, 38, 55, 43, 78, 39,  5,  1, 19,  6, 35,
     1, 53,  6, 65,  1,  7, 15, 16, 11, 41, 15, 50, 11, 75, 15,
     4, 20, 29, 24, 38, 20, 63, 24, 72, 20, 14, 34, 26, 29, 44,
    34, 60, 29, 74, 34, 14, 38, 24, 43, 47, 39, 54, 43, 77, 39,
     4,  1, 20,  6, 34,  1, 54,  6, 64,  1,  8, 15, 17, 11, 42,
    15, 51, 11, 76, 15,  5, 20, 30, 24, 39, 20, 63, 25, 73, 20,
    13, 34, 27, 29, 43, 34, 61, 29, 73, 34, 15, 38, 23, 43, 46,
    39, 53, 43, 76, 39,  3,  1, 21,  6, 33,  1, 55,  6, 64,  2,
     9, 15, 18, 11, 43, 15, 52, 11, 77, 15,  6, 20, 31, 24, 40,
    20, 62, 25, 74, 20, 12, 34, 28, 29, 42, 34, 62, 29, 72, 34,
    15, 39, 22, 43, 45, 39, 52, 43, 75, 39,  2,  1, 22,  6, 32,
     1, 56,  6, 65,  2, 10, 15, 19, 11, 44, 15, 53, 11, 78, 15,
     7, 20, 31, 25, 41, 20, 61, 25, 75, 20, 11, 34, 29, 29, 41,
    34, 63, 29, 71, 34, 14, 39, 21, 43, 44, 39, 51, 43, 74, 39,
     1,  1, 23,  6, 32,  2, 57,  6, 66,  2, 11, 15, 20, 11, 45,
    15, 54, 11, 79, 15,  8, 20, 30, 25, 42, 20, 60, 25, 76, 20,
    10, 34, 30, 29, 40, 34, 63, 30, 70, 34, 13, 39, 20, 43, 43,
    39, 50, 43, 73, 39,  0,  1, 24,  6, 33,  2, 58,  6, 67,  2,
    12, 15, 21, 11, 46, 15, 55, 11, 79, 16,  9, 20, 29, 25, 43,
    20, 59, 25, 77, 20,  9, 34, 31, 29, 39, 34, 62, 30, 69, 34,
    12, 39, 19, 43, 42, 39, 49, 43, 72, 39,  0,  2, 25,  6, 34,
     2, 59,  6, 68,  2, 13, 15, 22, 11, 47, 15, 56, 11, 78, 16,
    10, 20, 28, 25, 44, 20, 58, 25, 78, 20,  8, 34, 31, 30, 38,
    34, 61, 30, 68, 34, 11, 39, 18, 43, 41, 39, 48, 43, 71, 39,
     1,  2, 26,  6, 35,  2, 60,  6, 69,  2, 14, 15, 23, 11, 47,
    16, 57, 11, 77, 16, 11, 20, 27, 25, 45, 20, 57, 25, 79, 20,
     7, 34, 30, 30, 37, 34, 60, 30, 67, 34, 10, 39, 17, 43, 40,
    39, 48, 44, 70, 39,  2,  2, 27,  6, 36,  2, 61,  6, 70,  2,
    15, 15, 24, 11, 46, 16, 58, 11, 76, 16, 12, 20, 26, 25, 46,
    20, 56, 25, 79, 21,  6, 34, 29, 30, 36, 34, 59, 30, 66, 34,
     9, 39, 16, 43, 39, 39, 49, 44, 69, 39,  3,  2, 28,  6, 37,
     2, 62,  6, 71,  2, 15, 16, 25, 11, 45, 16, 59, 11, 75, 16,
    13, 20, 25, 25, 47, 20, 55, 25, 78, 21,  5, 34, 28, 30, 35,
    34, 58, 30, 65, 34,  8, 39, 16, 44, 38, 39, 50, 44, 68, 39,
     4,  2, 29,  6, 38,  2, 63,  6, 72,  2, 14, 16, 26, 11, 44,
    16, 60, 11, 74, 16, 14, 20, 24, 25, 47, 21, 54, 25, 77, 21,
     4, 34, 27, 30, 34, 34, 57, 30, 64, 34,  7, 39, 17, 44, 37,
    39, 51, 44, 67, 39,  5,  2, 30,  6, 39,  2, 63,  7, 73,  2,
    13, 16, 27, 11, 43, 16, 61, 11, 73, 16, 15, 20, 23, 25, 46,
    21, 53, 25, 76, 21,  3, 34, 26, 30, 33, 34, 56, 30, 64, 35,
     6, 39, 18, 44, 36, 39, 52, 44, 66, 39,  6,  2, 31,  6, 40,
     2, 62,  7, 74,  2, 12, 16, 28, 11, 42, 16, 62, 11, 72, 16,
    15, 21, 22, 25, 45, 21, 52, 25, 75, 21,  2, 34, 25, 30, 32,
    34, 55, 30, 65, 35,  5, 39, 19, 44, 35, 39, 53, 44, 65, 39,
     7,  2, 31,  7, 41,  2, 61,  7, 75,  2, 11, 16, 29, 11, 41,
    16, 63, 11, 71, 16, 14, 21, 21, 25, 44, 21, 51, 25, 74, 21,
     1, 34, 24, 30, 32, 35, 54, 30, 66, 35,  4, 39, 20, 44, 34,
    39, 54, 44, 64, 39,  8,  2, 30,  7, 42,  2, 60,  7, 76,  2,
    10, 16, 30, 11, 40, 16, 63, 12, 70, 16, 13, 21, 20, 25, 43,
    21, 50, 25, 73, 21,  0, 34, 23, 30, 33, 35, 53, 30, 67, 35,
     3, 39, 21, 44, 33, 39, 55, 44, 64, 40,  9,  2, 29,  7, 43,
     2, 59,  7, 77,  2,  9, 16, 31, 11, 39, 16, 62, 12, 69, 16,
    12, 21, 19, 25, 42, 21, 49, 25, 72, 21,  0, 35, 22, 30, 34,
    35, 52, 30, 68, 35,  2, 39, 22, 44, 32, 39, 56, 44, 65, 40,
    10,  2, 28,  7, 44,  2, 58,  7, 78,  2,  8, 16, 31, 12, 38,
    16, 61, 12, 68, 16, 11, 21, 18, 25, 41, 21, 48, 25, 71, 21,
     1, 35, 21, 30, 35, 35, 51, 30, 69, 35,  1, 39, 23, 44, 32,
    40, 57, 44, 66, 40, 11,  2, 27,  7, 45,  2, 57,  7, 79,  2,
     7, 16, 30, 12, 37, 16, 60, 12, 67, 16, 10, 21, 17, 25, 40,
    21, 48, 26, 70, 21,  2, 35, 20, 30, 36, 35, 50, 30, 70, 35,
     0, 39, 24, 44, 33, 40, 58, 44, 67, 40, 12,  2, 26,  7, 46,
     2, 56,  7, 79,  3,  6, 16, 29, 12, 36, 16, 59, 12, 66, 16,
     9, 21, 16, 25, 39, 21, 49, 26, 69, 21,  3, 35, 19, 30, 37,
    35, 49, 30, 71, 35,  0, 40, 25, 44, 34, 40, 59, 44, 68, 40,
    13,  2, 25,  7, 47,  2, 55,  7, 78,  3,  5, 16, 28, 12, 35,
    16, 58, 12, 65, 16,  8, 21, 16, 26, 38, 21, 50, 26, 68, 21,
     4, 35, 18, 30, 38, 35, 48, 30, 72, 35,  1, 40, 26, 44, 35,
    40, 60, 44, 69, 40, 14,  2, 24,  7, 47,  3, 54,  7, 77,  3,
     4, 16, 27, 12, 34, 16, 57, 12, 64, 16,  7, 21, 17, 26, 37,
    21, 51, 26, 67, 21,  5, 35, 17, 30, 39, 35, 48, 31, 73, 35,
     2, 40, 27, 44, 36, 40, 61, 44, 70, 40, 15,  2, 23,  7, 46,
     3, 53,  7, 76,  3,  3, 16, 26, 12, 33, 16, 56, 12, 64, 17,
     6, 21, 18, 26, 36, 21, 52, 26, 66, 21,  6, 35, 16, 30, 40,
    35, 49, 31, 74, 35,  3, 40, 28, 44, 37, 40, 62, 44, 71, 40,
    15,  3, 22,  7, 45,  3, 52,  7, 75,  3,  2, 16, 25, 12, 32,
    16, 55, 12, 65, 17,  5, 21, 19, 26, 35, 21, 53, 26, 65, 21,
     7, 35, 16, 31, 41, 35, 50, 31, 75, 35,  4, 40, 29, 44, 38,
    40, 63, 44, 72, 40, 14,  3, 21,  7, 44,  3, 51,  7, 74,  3,
     1, 16, 24, 12, 32, 17, 54, 12, 66, 17,  4, 21, 20, 26, 34,
    21, 54, 26, 64, 21,  8, 35, 17, 31, 42, 35, 51, 31, 76, 35,
     5, 40, 30, 44, 39, 40, 48, 36, 73, 40, 13,  3, 20,  7, 43,
     3, 50,  7, 73,  3,  0, 16, 23, 12, 33, 17, 53, 12, 67, 17,
     3, 21, 21, 26, 33, 21, 55, 26, 64, 22,  9, 35, 18, 31, 43,
    35, 52, 31, 77, 35,  6, 40, 31, 44, 40, 40, 49, 36, 74, 40,
    12,  3, 19,  7, 42,  3, 49,  7, 72,  3,  0, 17, 22, 12, 34,
    17, 52, 12, 68, 17,  2, 21, 22, 26, 32, 21, 56, 26, 65, 22,
    10, 35, 19, 31, 44, 35, 53, 31, 78, 35,  7, 40, 16, 36, 41,
    40, 50, 36, 75, 40, 11,  3, 18,  7, 41,  3, 48,  7, 71,  3,
     1, 17, 21, 12, 35, 17, 51, 12, 69, 17,  1, 21, 23, 26, 32,
    22, 57, 26, 66, 22, 11, 35, 20, 31, 45, 35, 54, 31, 79, 35,
     8, 40, 17, 36, 42, 40, 51, 36, 76, 40, 10,  3, 17,  7, 40,
     3, 48,  8, 70,  3,  2, 17, 20, 12, 36, 17, 50, 12, 70, 17,
     0, 21, 24, 26, 33, 22, 58, 26, 67, 22, 12, 35, 21, 31, 46,
    35, 55, 31, 64, 27,  9, 40, 18, 36, 43, 40, 52, 36, 77, 40,
     9,  3, 16,  7, 39,  3, 49,  8, 69,  3,  3, 17, 19, 12, 37,
    17, 49, 12, 71, 17,  0, 22, 25, 26, 34, 22, 59, 26, 68, 22,
    13, 35, 22, 31, 47, 35, 56, 31, 65, 27, 10, 40, 19, 36, 44,
    40, 53, 36, 78, 40,  8,  3, 16,  8, 38,  3, 50,  8, 68,  3,
     4, 17, 18, 12, 38, 17, 48, 12, 72, 17,  1, 22, 26, 26, 35,
    22, 60, 26, 69, 22, 14, 35, 23, 31, 32, 27, 57, 31, 66, 27,
    11, 40, 20, 36, 45, 40, 54, 36, 79, 40,  7,  3, 17,  8, 37,
     3, 51,  8, 67,  3,  5, 17, 17, 12, 39, 17, 48, 13, 73, 17,
     2, 22, 27, 26, 36, 22, 61, 26, 70, 22, 15, 35, 24, 31, 33,
    27, 58, 31, 67, 27, 12, 40, 21, 36, 46, 40, 55, 36, 79, 41,
     6,  3, 18,  8, 36,  3, 52,  8, 66,  3,  6, 17, 16, 12, 40,
    17, 49, 13, 74, 17,  3, 22, 28, 26, 37, 22, 62, 26, 71, 22,
     0, 27, 25, 31, 34, 27, 59, 31, 68, 27, 13, 40, 22, 36, 47,
    40, 56, 36, 78, 41,  5,  3, 19,  8, 35,  3, 53,  8, 65,  3,
     7, 17, 16, 13, 41, 17, 50, 13, 75, 17,  4, 22, 29, 26, 38,
    22, 63, 26, 72, 22,  1, 27, 26, 31, 35, 27, 60, 31, 69, 27,
    14, 40, 23, 36, 47, 41, 57, 36, 77, 41,  4,  3, 20,  8, 34,
     3, 54,  8, 64,  3,  8, 17, 17, 13, 42, 17, 51, 13, 76, 17,
     5, 22, 30, 26, 39, 22, 48, 18, 73, 22,  2, 27, 27, 31, 36,
    27, 61, 31, 70, 27, 15, 40, 24, 36, 46, 41, 58, 36, 76, 41,
     3,  3, 21,  8, 33,  3, 55,  8, 64,  4,  9, 17, 18, 13, 43,
    17, 52, 13, 77, 17,  6, 22, 31, 26, 40, 22, 49, 18, 74, 22,
     3, 27, 28, 31, 37, 27, 62, 31, 71, 27, 15, 41, 25, 36, 45,
    41, 59, 36, 75, 41,  2,  3, 22,  8, 32,  3, 56,  8, 65,  4,
    10, 17, 19, 13, 44, 17, 53, 13, 78, 17,  7, 22, 16, 18, 41,
    22, 50, 18, 75, 22,  4, 27, 29, 31, 38, 27, 63, 31, 72, 27,
    14, 41, 26, 36, 44, 41, 60, 36, 74, 41,  1,  3, 23,  8, 32,
     4, 57,  8, 66,  4, 11, 17, 20, 13, 45, 17, 54, 13, 79, 17,
     8, 22, 17, 18, 42, 22, 51, 18, 76, 22,  5, 27, 30, 31, 39,
    27, 63, 32, 73, 27, 13, 41, 27, 36, 43, 41, 61, 36, 73, 41,
     0,  3, 24,  8, 33,  4, 58,  8, 67,  4, 12, 17, 21, 13, 46,
    17, 55, 13, 64,  9,  9, 22, 18, 18, 43, 22, 52, 18, 77, 22,
     6, 27, 31, 31, 40, 27, 62, 32, 74, 27, 12, 41, 28, 36, 42,
    41, 62, 36, 72, 41,  0,  4, 25,  8, 34,  4, 59,  8, 68,  4,
    13, 17, 22, 13, 47, 17, 56, 13, 65,  9, 10, 22, 19, 18, 44,
    22, 53, 18, 78, 22,  7, 27, 31, 32, 41, 27, 61, 32, 75, 27,
    11, 41, 29, 36, 41, 41, 63, 36, 71, 41,  1,  4, 26,  8, 35,
     4, 60,  8, 69,  4, 14, 17, 23, 13, 32,  9, 57, 13, 66,  9,
    11, 22, 20, 18, 45, 22, 54, 18, 79, 22,  8, 27, 30, 32, 42,
    27, 60, 32, 76, 27, 10, 41, 30, 36, 40, 41, 63, 37, 70, 41,
     2,  4, 27,  8, 36,  4, 61,  8, 70,  4, 15, 17, 24, 13, 33,
     9, 58, 13, 67,  9, 12, 22, 21, 18, 46, 22, 55, 18, 79, 23,
     9, 27, 29, 32, 43, 27, 59, 32, 77, 27,  9, 41, 31, 36, 39,
    41, 62, 37, 69, 41,  3,  4, 28,  8, 37,  4, 62,  8, 71,  4,
     0,  9, 25, 13, 34,  9, 59, 13, 68,  9, 13, 22, 22, 18, 47,
    22, 56, 18, 78, 23, 10, 27, 28, 32, 44, 27, 58, 32, 78, 27,
     8, 41, 31, 37, 38, 41, 61, 37, 68, 41,  4,  4, 29,  8, 38,
     4, 63,  8, 72,  4,  1,  9, 26, 13, 35,  9, 60, 13, 69,  9,
    14, 22, 23, 18, 47, 23, 57, 18, 77, 23, 11, 27, 27, 32, 45,
    27, 57, 32, 79, 27,  7, 41, 30, 37, 37, 41, 60, 37, 67, 41,
     5,  4, 30,  8, 39,  4, 48,  0, 73,  4,  2,  9, 27, 13, 36,
     9, 61, 13, 70,  9, 15, 22, 24, 18, 46, 23, 58, 18, 76, 23,
    12, 27, 26, 32, 46, 27, 56, 32, 79, 28,  6, 41, 29, 37, 36,
    41, 59, 37, 66, 41,  6,  4, 31,  8, 40,  4, 49,  0, 74,  4,
     3,  9, 28, 13, 37,  9, 62, 13, 71,  9, 15, 23, 25, 18, 45,
    23, 59, 18, 75, 23, 13, 27, 25, 32, 47, 27, 55, 32, 78, 28,
     5, 41, 28, 37, 35, 41, 58, 37, 65, 41,  7,  4, 16,  0, 41,
     4, 50,  0, 75,  4,  4,  9, 29, 13, 38,  9, 63, 13, 72,  9,
    14, 23, 26, 18, 44, 23, 60, 18, 74, 23, 14, 27, 24, 32, 47,
    28, 54, 32, 77, 28,  4, 41, 27, 37, 34, 41, 57, 37, 64, 41,
     8,  4, 17,  0, 42,  4, 51,  0, 76,  4,  5,  9, 30, 13, 39,
     9, 63, 14, 73,  9, 13, 23, 27, 18, 43, 23, 61, 18, 73, 23,
    15, 27, 23, 32, 46, 28, 53, 32, 76, 28,  3, 41, 26, 37, 33,
    41, 56, 37, 64, 42,  9,  4, 18,  0, 43,  4, 52,  0, 77,  4,
     6,  9, 31, 13, 40,  9, 62, 14, 74,  9, 12, 23, 28, 18, 42,
    23, 62, 18, 72, 23, 15, 28, 22, 32, 45, 28, 52, 32, 75, 28,
     2, 41, 25, 37, 32, 41, 55, 37, 65, 42, 10,  4, 19,  0, 44,
     4, 53,  0, 78,  4,  7,  9, 31, 14, 41,  9, 61, 14, 75,  9,
    11, 23, 29, 18, 41, 23, 63, 18, 71, 23, 14, 28, 21, 32, 44,
    28, 51, 32, 74, 28,  1, 41, 24, 37, 32, 42, 54, 37, 66, 42,
    11,  4, 20,  0, 45,  4, 54,  0, 79,  4,  8,  9, 30, 14, 42,
     9, 60, 14, 76,  9, 10, 23, 30, 18, 40, 23, 63, 19, 70, 23,
    13, 28, 20, 32, 43, 28, 50, 32, 73, 28,  0, 41, 23, 37, 33,
    42, 53, 37, 67, 42, 12,  4, 21,  0, 46,  4, 55,  0, 79,  5,
     9,  9, 29, 14, 43,  9, 59, 14, 77,  9,  9, 23, 31, 18, 39,
    23, 62, 19, 69, 23, 12, 28, 19, 32, 42, 28, 49, 32, 72, 28,
     0, 42, 22, 37, 34, 42, 52, 37, 68, 42, 13,  4, 22,  0, 47,
     4, 56,  0, 78,  5, 10,  9, 28, 14, 44,  9, 58, 14, 78,  9,
     8, 23, 31, 19, 38, 23, 61, 19, 68, 23, 11, 28, 18, 32, 41,
    28, 48, 32, 71, 28,  1, 42, 21, 37, 35, 42, 51, 37, 69, 42,
    14,  4, 23,  0, 47,  5, 57,  0, 77,  5, 11,  9, 27, 14, 45,
     9, 57, 14, 79,  9,  7, 23, 30, 19, 37, 23, 60, 19, 67, 23,
    10, 28, 17, 32, 40, 28, 48, 33, 70, 28,  2, 42, 20, 37, 36,
    42, 50, 37, 70, 42, 15,  4, 24,  0, 46,  5, 58,  0, 76,  5,
    12,  9, 26, 14, 46,  9, 56, 14, 79, 10,  6, 23, 29, 19, 36,
    23, 59, 19, 66, 23,  9, 28, 16, 32, 39, 28, 49, 33, 69, 28,
     3, 42, 19, 37, 37, 42, 49, 37, 71, 42, 15,  5, 25,  0, 45,
     5, 59,  0, 75,  5, 13,  9, 25, 14, 47,  9, 55, 14, 78, 10,
     5, 23, 28, 19, 35, 23, 58, 19, 65, 23,  8, 28, 16, 33, 38,
    28, 50, 33, 68, 28,  4, 42, 18, 37, 38, 42, 48, 37, 72, 42,
    14,  5, 26,  0, 44,  5, 60,  0, 74,  5, 14,  9, 24, 14, 47,
    10, 54, 14, 77, 10,  4, 23, 27, 19, 34, 23, 57, 19, 64, 23,
     7, 28, 17, 33, 37, 28, 51, 33, 67, 28,  5, 42, 17, 37, 39,
    42, 48, 38, 73, 42, 13,  5, 27,  0, 43,  5, 61,  0, 73,  5,
    15,  9, 23, 14, 46, 10, 53, 14, 76, 10,  3, 23, 26, 19, 33,
    23, 56, 19, 64, 24,  6, 28, 18, 33, 36, 28, 52, 33, 66, 28,
     6, 42, 16, 37, 40, 42, 49, 38, 74, 42, 12,  5, 28,  0, 42,
     5, 62,  0, 72,  5, 15, 10, 22, 14, 45, 10, 52, 14, 75, 10,
     2, 23, 25, 19, 32, 23, 55, 19, 65, 24,  5, 28, 19, 33, 35,
    28, 53, 33, 65, 28,  7, 42, 16, 38, 41, 42, 50, 38, 75, 42,
    11,  5, 29,  0, 41,  5, 63,  0, 71,  5, 14, 10, 21, 14, 44,
    10, 51, 14, 74, 10,  1, 23, 24, 19, 32, 24, 54, 19, 66, 24,
     4, 28, 20, 33, 34, 28, 54, 33, 64, 28,  8, 42, 17, 38, 42,
    42, 51, 38, 76, 42, 10,  5, 30,  0, 40,  5, 63,  1, 70,  5,
    13, 10, 20, 14, 43, 10, 50, 14, 73, 10,  0, 23, 23, 19, 33,
    24, 53, 19, 67, 24,  3, 28, 21, 33, 33, 28, 55, 33, 64, 29,
     9, 42, 18, 38, 43, 42, 52, 38, 77, 42,  9,  5, 31,  0, 39,
     5, 62,  1, 69,  5, 12, 10, 19, 14, 42, 10, 49, 14, 72, 10,
     0, 24, 22, 19, 34, 24, 52, 19, 68, 24,  2, 28, 22, 33, 32,
    28, 56, 33, 65, 29, 10, 42, 19, 38, 44, 42, 53, 38, 78, 42,
     8,  5, 31,  1, 38,  5, 61,  1, 68,  5, 11, 10, 18, 14, 41,
    10, 48, 14, 71, 10,  1, 24, 21, 19, 35, 24, 51, 19, 69, 24,
     1, 28, 23, 33, 32, 29, 57, 33, 66, 29, 11, 42, 20, 38, 45,
    42, 54, 38, 79, 42,  7,  5, 30,  1, 37,  5, 60,  1, 67,  5,
    10, 10, 17, 14, 40, 10, 48, 15, 70, 10,  2, 24, 20, 19, 36,
    24, 50, 19, 70, 24,  0, 28, 24, 33, 33, 29, 58, 33, 67, 29,
    12, 42, 21, 38, 46, 42, 55, 38, 79, 43,  6,  5, 29,  1, 36,
     5, 59,  1, 66,  5,  9, 10, 16, 14, 39, 10, 49, 15, 69, 10,
     3, 24, 19, 19, 37, 24, 49, 19, 71, 24,  0, 29, 25, 33, 34,
    29, 59, 33, 68, 29, 13, 42, 22, 38, 47, 42, 56, 38, 78, 43,
     5,  5, 28,  1, 35,  5, 58,  1, 65,  5,  8, 10, 16, 15, 38,
    10, 50, 15, 68, 10,  4, 24, 18, 19, 38, 24, 48, 19, 72, 24,
     1, 29, 26, 33, 35, 29, 60, 33, 69, 29, 14, 42, 23, 38, 47,
    43, 57, 38, 77, 43,  4,  5, 27,  1, 34,  5, 57,  1, 64,  5,
     7, 10, 17, 15, 37, 10, 51, 15, 67, 10,  5, 24, 17, 19, 39,
    24, 48, 20, 73, 24,  2, 29, 27, 33, 36, 29, 61, 33, 70, 29,
    15, 42, 24, 38, 46, 43, 58, 38, 76, 43,  3,  5, 26,  1, 33,
     5, 56,  1, 64,  6,  6, 10, 18, 15, 36, 10, 52, 15, 66, 10,
     6, 24, 16, 19, 40, 24, 49, 20, 74, 24,  3, 29, 28, 33, 37,
    29, 62, 33, 71, 29, 15, 43, 25, 38, 45, 43, 59, 38, 75, 43,
     2,  5, 25,  1, 32,  5, 55,  1, 65,  6,  5, 10, 19, 15, 35,
    10, 53, 15, 65, 10,  7, 24, 16, 20, 41, 24, 50, 20, 75, 24,
     4, 29, 29, 33, 38, 29, 63, 33, 72, 29, 14, 43, 26, 38, 44,
    43, 60, 38, 74, 43,  1,  5, 24,  1, 32,  6, 54,  1, 66,  6,
     4, 10, 20, 15, 34, 10, 54, 15, 64, 10,  8, 24, 17, 20, 42,
    24, 51, 20, 76, 24,  5, 29, 30, 33, 39, 29, 63, 34, 73, 29,
    13, 43, 27, 38, 43, 43, 61, 38, 73, 43,  0,  5, 23,  1, 33,
     6, 53,  1, 67,  6,  3, 10, 21, 15, 33, 10, 55, 15, 64, 11,
     9, 24, 18, 20, 43, 24, 52, 20, 77, 24,  6, 29, 31, 33, 40,
    29, 62, 34, 74, 29, 12, 43, 28, 38, 42, 43, 62, 38, 72, 43,
     0,  6, 22,  1, 34,  6, 52,  1, 68,  6,  2, 10, 22, 15, 32,
    10, 56, 15, 65, 11, 10, 24, 19, 20, 44, 24, 53, 20, 78, 24,
     7, 29, 31, 34, 41, 29, 61, 34, 75, 29, 11, 43, 29, 38, 41,
    43, 63, 38, 71, 43,  1,  6, 21,  1, 35,  6, 51,  1, 69,  6,
     1, 10, 23, 15, 32, 11, 57, 15, 66, 11, 11, 24, 20, 20, 45,
    24, 54, 20, 79, 24,  8, 29, 30, 34, 42, 29, 60, 34, 76, 29,
    10, 43, 30, 38, 40, 43, 63, 39, 70, 43,  2,  6, 20,  1, 36,
     6, 50,  1, 70,  6,  0, 10, 24, 15, 33, 11, 58, 15, 67, 11,
    12, 24, 21, 20, 46, 24, 55, 20, 79, 25,  9, 29, 29, 34, 43,
    29, 59, 34, 77, 29,  9, 43, 31, 38, 39, 43, 62, 39, 69, 43,
     3,  6, 19,  1, 37,  6, 49,  1, 71,  6,  0, 11, 25, 15, 34,
    11, 59, 15, 68, 11, 13, 24, 22, 20, 47, 24, 56, 20, 78, 25,
    10, 29, 28, 34, 44, 29, 58, 34, 78, 29,  8, 43, 31, 39, 38,
    43, 61, 39, 68, 43,  4,  6, 18,  1, 38,  6, 48,  1, 72,  6,
     1, 11, 26, 15, 35, 11, 60, 15, 69, 11, 14, 24, 23, 20, 47,
    25, 57, 20, 77, 25, 11, 29, 27, 34, 45, 29, 57, 34, 79, 29,
     7, 43, 30, 39, 37, 43, 60, 39, 67, 43,  5,  6, 17,  1, 39,
     6, 48,  2, 73,  6,  2, 11, 27, 15, 36, 11, 61, 15, 70, 11,
    15, 24, 24, 20, 46, 25, 58, 20, 76, 25, 12, 29, 26, 34, 46,
    29, 56, 34, 79, 30,  6, 43, 29, 39, 36, 43, 59, 39, 66, 43,
     6,  6, 16,  1, 40,  6, 49,  2, 74,  6,  3, 11, 28, 15, 37,
    11, 62, 15, 71, 11, 15, 25, 25, 20, 45, 25, 59, 20, 75, 25,
    13, 29, 25, 34, 47, 29, 55, 34, 78, 30,  5, 43, 28, 39, 35,
    43, 58, 39, 65, 43,  7,  6, 16,  2, 41,  6, 50,  2, 75,  6,
     4, 11, 29, 15, 38, 11, 63, 15, 72, 11, 14, 25, 26, 20, 44,
    25, 60, 20, 74, 25, 14, 29, 24, 34, 47, 30, 54, 34, 77, 30,
     4, 43, 27, 39, 34, 43, 57, 39, 64, 43,  8,  6, 17,  2, 42,
     6, 51,  2, 76,  6,  5, 11, 30, 15, 39, 11, 63, 16, 73, 11,
    13, 25, 27, 20, 43, 25, 61, 20, 73, 25, 15, 29, 23, 34, 46,
    30, 53, 34, 76, 30,  3, 43, 26, 39, 33, 43, 56, 39, 64, 44,
     9,  6, 18,  2, 43,  6, 52,  2, 77,  6,  6, 11, 31, 15, 40,
    11, 62, 16, 74, 11, 12, 25, 28, 20, 42, 25, 62, 20, 72, 25,
    15, 30, 22, 34, 45, 30, 52, 34, 75, 30,  2, 43, 25, 39, 32,
    43, 55, 39, 65, 44, 10,  6, 19,  2, 44,  6, 53,  2, 78,  6,
     7, 11, 31, 16, 41, 11, 61, 16, 75, 11, 11, 25, 29, 20, 41,
    25, 63, 20, 71, 25, 14, 30, 21, 34, 44, 30, 51, 34, 74, 30,
     1, 43, 24, 39, 32, 44, 54, 39, 66, 44, 11,  6, 20,  2, 45,
     6, 54,  2, 79,  6,  8, 11, 30, 16, 42, 11, 60, 16, 76, 11,
    10, 25, 30, 20, 40, 25, 63, 21, 70, 25, 13, 30, 20, 34, 43,
    30, 50, 34, 73, 30,  0, 43, 23, 39, 33, 44, 53, 39, 67, 44,
    12,  6, 21,  2, 46,  6, 55,  2, 79,  7,  9, 11, 29, 16, 43,
    11, 59, 16, 77, 11,  9, 25, 31, 20, 39, 25, 62, 21, 69, 25,
    12, 30, 19, 34, 42, 30, 49, 34, 72, 30,  0, 44, 22, 39, 34,
    44, 52, 39, 68, 44, 13,  6, 22,  2, 47,  6, 56,  2, 78,  7,
    10, 11, 28, 16, 44, 11, 58, 16, 78, 11,  8, 25, 31, 21, 38,
    25, 61, 21, 68, 25, 11, 30, 18, 34, 41, 30, 48, 34, 71, 30,
     1, 44, 21, 39, 35, 44, 51, 39, 69, 44, 14,  6, 23,  2, 47,
     7, 57,  2, 77,  7, 11, 11, 27, 16, 45, 11, 57, 16, 79, 11,
     7, 25, 30, 21, 37, 25, 60, 21, 67, 25, 10, 30, 17, 34, 40,
    30, 48, 35, 70, 30,  2, 44, 20, 39, 36, 44, 50, 39, 70, 44,
    15,  6, 24,  2, 46,  7, 58,  2, 76,  7, 12, 11, 26, 16, 46,
    11, 56, 16, 79, 12,  6, 25, 29, 21, 36, 25, 59, 21, 66, 25,
     9, 30, 16, 34, 39, 30, 49, 35, 69, 30,  3, 44, 19, 39, 37,
    44, 49, 39, 71, 44, 15,  7, 25,  2, 45,  7, 59,  2, 75,  7,
    13, 11, 25, 16, 47, 11, 55, 16, 78, 12,  5, 25, 28, 21, 35,
    25, 58, 21, 65, 25,  8, 30, 16, 35, 38, 30, 50, 35, 68, 30,
     4, 44, 18, 39, 38, 44, 48, 39, 72, 44, 14,  7, 26,  2, 44,
     7, 60,  2, 74,  7, 14, 11, 24, 16, 47, 12, 54, 16, 77, 12,
     4, 25, 27, 21, 34, 25, 57, 21, 64, 25,  7, 30, 17, 35, 37,
    30, 51, 35, 67, 30,  5, 44, 17, 39, 39, 44, 48, 40, 73, 44,
    13,  7, 27,  2, 43,  7, 61,  2, 73,  7, 15, 11, 23, 16, 46,
    12, 53, 16, 76, 12,  3, 25, 26, 21, 33, 25, 56, 21, 64, 26,
     6, 30, 18, 35, 36, 30, 52, 35, 66, 30,  6, 44, 16, 39, 40,
    44, 49, 40, 74, 44, 12,  7, 28,  2, 42,  7, 62,  2, 72,  7,
    15, 12, 22, 16, 45, 12, 52, 16, 75, 12,  2, 25, 25, 21, 32,
    25, 55, 21, 65, 26,  5, 30, 19, 35, 35, 30, 53, 35, 65, 30,
     7, 44, 16, 40, 41, 44, 50, 40, 75, 44, 11,  7, 29,  2, 41,
     7, 63,  2, 71,  7, 14, 12, 21, 16, 44, 12, 51, 16, 74, 12,
     1, 25, 24, 21, 32, 26, 54, 21, 66, 26,  4, 30, 20, 35, 34,
    30, 54, 35, 64, 30,  8, 44, 17, 40, 42, 44, 51, 40, 76, 44,
    10,  7, 30,  2, 40,  7, 63,  3, 70,  7, 13, 12, 20, 16, 43,
    12, 50, 16, 73, 12,  0, 25, 23, 21, 33, 26, 53, 21, 67, 26,
     3, 30, 21, 35, 33, 30, 55, 35, 64, 31,  9, 44, 18, 40, 43,
    44, 52, 40, 77, 44,  9,  7, 31,  2, 39,  7, 62,  3, 69,  7,
    12, 12, 19, 16, 42, 12, 49, 16, 72, 12,  0, 26, 22, 21, 34,
    26, 52, 21, 68, 26,  2, 30, 22, 35, 32, 30, 56, 35, 65, 31,
    10, 44, 19, 40, 44, 44, 53, 40, 78, 44,  8,  7, 31,  3, 38,
     7, 61,  3, 68,  7, 11, 12, 18, 16, 41, 12, 48, 16, 71, 12,
     1, 26, 21, 21, 35, 26, 51, 21, 69, 26,  1, 30, 23, 35, 32,
    31, 57, 35, 66, 31, 11, 44, 20, 40, 45, 44, 54, 40, 79, 44,
     7,  7, 30,  3, 37,  7, 60,  3, 67,  7, 10, 12, 17, 16, 40,
    12, 48, 17, 70, 12,  2, 26, 20, 21, 36, 26, 50, 21, 70, 26,
     0, 30, 24, 35, 33, 31, 58, 35, 67, 31, 12, 44, 21, 40, 46,
    44, 55, 40, 64, 36,  6,  7, 29,  3, 36,  7, 59,  3, 66,  7,
     9, 12, 16, 16, 39, 12, 49, 17, 69, 12,  3, 26, 19, 21, 37,
    26, 49, 21, 71, 26,  0, 31, 25, 35, 34, 31, 59, 35, 68, 31,
    13, 44, 22, 40, 47, 44, 56, 40, 65, 36,  5,  7, 28,  3, 35,
     7, 58,  3, 65,  7,  8, 12, 16, 17, 38, 12, 50, 17, 68, 12,
     4, 26, 18, 21, 38, 26, 48, 21, 72, 26,  1, 31, 26, 35, 35,
    31, 60, 35, 69, 31, 14, 44, 23, 40, 32, 36, 57, 40, 66, 36,
     4,  7, 27,  3, 34,  7, 57,  3, 64,  7,  7, 12, 17, 17, 37,
    12, 51, 17, 67, 12,  5, 26, 17, 21, 39, 26, 48, 22, 73, 26,
     2, 31, 27, 35, 36, 31, 61, 35, 70, 31, 15, 44, 24, 40, 33,
    36, 58, 40, 67, 36,  3,  7, 26,  3, 33,  7, 56,  3, 64,  8,
     6, 12, 18, 17, 36, 12, 52, 17, 66, 12,  6, 26, 16, 21, 40,
    26, 49, 22, 74, 26,  3, 31, 28, 35, 37, 31, 62, 35, 71, 31,
     0, 36, 25, 40, 34, 36, 59, 40, 68, 36,  2,  7, 25,  3, 32,
     7, 55,  3, 65,  8,  5, 12, 19, 17, 35, 12, 53, 17, 65, 12,
     7, 26, 16, 22, 41, 26, 50, 22, 75, 26,  4, 31, 29, 35, 38,
    31, 63, 35, 72, 31,  1, 36, 26, 40, 35, 36, 60, 40, 69, 36,
     1,  7, 24,  3, 32,  8, 54,  3, 66,  8,  4, 12, 20, 17, 34,
    12, 54, 17, 64, 12,  8, 26, 17, 22, 42, 26, 51, 22, 76, 26,
     5, 31, 30, 35, 39, 31, 48, 27, 73, 31,  2, 36, 27, 40, 36,
    36, 61, 40, 70, 36,  0,  7, 23,  3, 33,  8, 53,  3, 67,  8,
     3, 12, 21, 17, 33, 12, 55, 17, 64, 13,  9, 26, 18, 22, 43,
    26, 52, 22, 77, 26,  6, 31, 31, 35, 40, 31, 49, 27, 74, 31,
     3, 36, 28, 40, 37, 36, 62, 40, 71, 36,  0,  8, 22,  3, 34,
     8, 52,  3, 68,  8,  2, 12, 22, 17, 32, 12, 56, 17, 65, 13,
    10, 26, 19, 22, 44, 26, 53, 22, 78, 26,  7, 31, 16, 27, 41,
    31, 50, 27, 75, 31,  4, 36, 29, 40, 38, 36, 63, 40, 72, 36,
     1,  8, 21,  3, 35,  8, 51,  3, 69,  8,  1, 12, 23, 17, 32,
    13, 57, 17, 66, 13, 11, 26, 20, 22, 45, 26, 54, 22, 79, 26,
     8, 31, 17, 27, 42, 31, 51, 27, 76, 31,  5, 36, 30, 40, 39,
    36, 63, 41, 73, 36,  2,  8, 20,  3, 36,  8, 50,  3, 70,  8,
     0, 12, 24, 17, 33, 13, 58, 17, 67, 13, 12, 26, 21, 22, 46,
    26, 55, 22, 64, 18,  9, 31, 18, 27, 43, 31, 52, 27, 77, 31,
     6, 36, 31, 40, 40, 36, 62, 41, 74, 36,  3,  8, 19,  3, 37,
     8, 49,  3, 71,  8,  0, 13, 25, 17, 34, 13, 59, 17, 68, 13,
    13, 26, 22, 22, 47, 26, 56, 22, 65, 18, 10, 31, 19, 27, 44,
    31, 53, 27, 78, 31,  7, 36, 31, 41, 41, 36, 61, 41, 75, 36,
     4,  8, 18,  3, 38,  8, 48,  3, 72,  8,  1, 13, 26, 17, 35,
    13, 60, 17, 69, 13, 14, 26, 23, 22, 32, 18, 57, 22, 66, 18,
    11, 31, 20, 27, 45, 31, 54, 27, 79, 31,  8, 36, 30, 41, 42,
    36, 60, 41, 76, 36,  5,  8, 17,  3, 39,  8, 48,  4, 73,  8,
     2, 13, 27, 17, 36, 13, 61, 17, 70, 13, 15, 26, 24, 22, 33,
    18, 58, 22, 67, 18, 12, 31, 21, 27, 46, 31, 55, 27, 79, 32,
     9, 36, 29, 41, 43, 36, 59, 41, 77, 36,  6,  8, 16,  3, 40,
     8, 49,  4, 74,  8,  3, 13, 28, 17, 37, 13, 62, 17, 71, 13,
     0, 18, 25, 22, 34, 18, 59, 22, 68, 18, 13, 31, 22, 27, 47,
    31, 56, 27, 78, 32, 10, 36, 28, 41, 44, 36, 58, 41, 78, 36,
     7,  8, 16,  4, 41,  8, 50,  4, 75,  8,  4, 13, 29, 17, 38,
    13, 63, 17, 72, 13,  1, 18, 26, 22, 35, 18, 60, 22, 69, 18,
    14, 31, 23, 27, 47, 32, 57, 27, 77, 32, 11, 36, 27, 41, 45,
    36, 57, 41, 79, 36,  8,  8, 17,  4, 42,  8, 51,  4, 76,  8,
     5, 13, 30, 17, 39, 13, 48,  9, 73, 13,  2, 18, 27, 22, 36,
    18, 61, 22, 70, 18, 15, 31, 24, 27, 46, 32, 58, 27, 76, 32,
    12, 36, 26, 41, 46, 36, 56, 41, 79, 37,  9,  8, 18,  4, 43,
     8, 52,  4, 77,  8,  6, 13, 31, 17, 40, 13, 49,  9, 74, 13,
     3, 18, 28, 22, 37, 18, 62, 22, 71, 18, 15, 32, 25, 27, 45,
    32, 59, 27, 75, 32, 13, 36, 25, 41, 47, 36, 55, 41, 78, 37,
    10,  8, 19,  4, 44,  8, 53,  4, 78,  8,  7, 13, 16,  9, 41,
    13, 50,  9, 75, 13,  4, 18, 29, 22, 38, 18, 63, 22, 72, 18,
    14, 32, 26, 27, 44, 32, 60, 27, 74, 32, 14, 36, 24, 41, 47,
    37, 54, 41, 77, 37, 11,  8, 20,  4, 45,  8, 54,  4, 79,  8,
     8, 13, 17,  9, 42, 13, 51,  9, 76, 13,  5, 18, 30, 22, 39,
    18, 63, 23, 73, 18, 13, 32, 27, 27, 43, 32, 61, 27, 73, 32,
    15, 36, 23, 41, 46, 37, 53, 41, 76, 37, 12,  8, 21,  4, 46,
     8, 55,  4, 64,  0,  9, 13, 18,  9, 43, 13, 52,  9, 77, 13,
     6, 18, 31, 22, 40, 18, 62, 23, 74, 18, 12, 32, 28, 27, 42,
    32, 62, 27, 72, 32, 15, 37, 22, 41, 45, 37, 52, 41, 75, 37,
    13,  8, 22,  4, 47,  8, 56,  4, 65,  0, 10, 13, 19,  9, 44,
    13, 53,  9, 78, 13,  7, 18, 31, 23, 41, 18, 61, 23, 75, 18,
    11, 32, 29, 27, 41, 32, 63, 27, 71, 32, 14, 37, 21, 41, 44,
    37, 51, 41, 74, 37, 14,  8, 23,  4, 32,  0, 57,  4, 66,  0,
    11, 13, 20,  9, 45, 13, 54,  9, 79, 13,  8, 18, 30, 23, 42,
    18, 60, 23, 76, 18, 10, 32, 30, 27, 40, 32, 63, 28, 70, 32,
    13, 37, 20, 41, 43, 37, 50, 41, 73, 37, 15,  8, 24,  4, 33,
     0, 58,  4, 67,  0, 12, 13, 21,  9, 46, 13, 55,  9, 79, 14,
     9, 18, 29, 23, 43, 18, 59, 23, 77, 18,  9, 32, 31, 27, 39,
    32, 62, 28, 69, 32, 12, 37, 19, 41, 42, 37, 49, 41, 72, 37,
};

static const uint8_t hq_tab_06[] = {
     0,  0, 25,  8, 34,  0, 59,  8, 68,  0, 13, 25, 22, 17, 47,
    25, 56, 17, 78, 26, 10, 34, 28, 43, 44, 34, 58, 43, 78, 34,
     8, 60, 31, 52, 38, 60, 61, 52, 68, 60,  1,  0, 26,  8, 35,
     0, 60,  8, 69,  0, 14, 25, 23, 17, 47, 26, 57, 17, 77, 26,
    11, 34, 27, 43, 45, 34, 57, 43, 79, 34,  7, 60, 30, 52, 37,
    60, 60, 52, 67, 60,  2,  0, 27,  8, 36,  0, 61,  8, 70,  0,
    15, 25, 24, 17, 46, 26, 58, 17, 76, 26, 12, 34, 26, 43, 46,
    34, 56, 43, 79, 35,  6, 60, 29, 52, 36, 60, 59, 52, 66, 60,
     3,  0, 28,  8, 37,  0, 62,  8, 71,  0, 15, 26, 25, 17, 45,
    26, 59, 17, 75, 26, 13, 34, 25, 43, 47, 34, 55, 43, 78, 35,
     5, 60, 28, 52, 35, 60, 58, 52, 65, 60,  4,  0, 29,  8, 38,
     0, 63,  8, 72,  0, 14, 26, 26, 17, 44, 26, 60, 17, 74, 26,
    14, 34, 24, 43, 47, 35, 54, 43, 77, 35,  4, 60, 27, 52, 34,
    60, 57, 52, 64, 60,  5,  0, 30,  8, 39,  0, 63,  9, 73,  0,
    13, 26, 27, 17, 43, 26, 61, 17, 73, 26, 15, 34, 23, 43, 46,
    35, 53, 43, 76, 35,  3, 60, 26, 52, 33, 60, 56, 52, 64, 61,
     6,  0, 31,  8, 40,  0, 62,  9, 74,  0, 12, 26, 28, 17, 42,
    26, 62, 17, 72, 26, 15, 35, 22, 43, 45, 35, 52, 43, 75, 35,
     2, 60, 25, 52, 32, 60, 55, 52, 65, 61,  7,  0, 31,  9, 41,
     0, 61,  9, 75,  0, 11, 26, 29, 17, 41, 26, 63, 17, 71, 26,
    14, 35, 21, 43, 44, 35, 51, 43, 74, 35,  1, 60, 24, 52, 32,
    61, 54, 52, 66, 61,  8,  0, 30,  9, 42,  0, 60,  9, 76,  0,
    10, 26, 30, 17, 40, 26, 63, 18, 70, 26, 13, 35, 20, 43, 43,
    35, 50, 43, 73, 35,  0, 60, 23, 52, 33, 61, 53, 52, 67, 61,
     9,  0, 29,  9, 43,  0, 59,  9, 77,  0,  9, 26, 31, 17, 39,
    26, 62, 18, 69, 26, 12, 35, 19, 43, 42, 35, 49, 43, 72, 35,
     0, 61, 22, 52, 34, 61, 52, 52, 68, 61, 10,  0, 28,  9, 44,
     0, 58,  9, 78,  0,  8, 26, 31, 18, 38, 26, 61, 18, 68, 26,
    11, 35, 18, 43, 41, 35, 48, 43, 71, 35,  1, 61, 21, 52, 35,
    61, 51, 52, 69, 61, 11,  0, 27,  9, 45,  0, 57,  9, 79,  0,
     7, 26, 30, 18, 37, 26, 60, 18, 67, 26, 10, 35, 17, 43, 40,
    35, 48, 44, 70, 35,  2, 61, 20, 52, 36, 61, 50, 52, 70, 61,
    12,  0, 26,  9, 46,  0, 56,  9, 79,  1,  6, 26, 29, 18, 36,
    26, 59, 18, 66, 26,  9, 35, 16, 43, 39, 35, 49, 44, 69, 35,
     3, 61, 19, 52, 37, 61, 49, 52, 71, 61, 13,  0, 25,  9, 47,
     0, 55,  9, 78,  1,  5, 26, 28, 18, 35, 26, 58, 18, 65, 26,
     8, 35, 16, 44, 38, 35, 50, 44, 68, 35,  4, 61, 18, 52, 38,
    61, 48, 52, 72, 61, 14,  0, 24,  9, 47,  1, 54,  9, 77,  1,
     4, 26, 27, 18, 34, 26, 57, 18, 64, 26,  7, 35, 17, 44, 37,
    35, 51, 44, 67, 35,  5, 61, 17, 52, 39, 61, 48, 53, 73, 61,
    15,  0, 23,  9, 46,  1, 53,  9, 76,  1,  3, 26, 26, 18, 33,
    26, 56, 18, 64, 27,  6, 35, 18, 44, 36, 35, 52, 44, 66, 35,
     6, 61, 16, 52, 40, 61, 49, 53, 74, 61, 15,  1, 22,  9, 45,
     1, 52,  9, 75,  1,  2, 26, 25, 18, 32, 26, 55, 18, 65, 27,
     5, 35, 19, 44, 35, 35, 53, 44, 65, 35,  7, 61, 16, 53, 41,
    61, 50, 53, 75, 61, 14,  1, 21,  9, 44,  1, 51,  9, 74,  1,
     1, 26, 24, 18, 32, 27, 54, 18, 66, 27,  4, 35, 20, 44, 34,
    35, 54, 44, 64, 35,  8, 61, 17, 53, 42, 61, 51, 53, 76, 61,
    13,  1, 20,  9, 43,  1, 50,  9, 73,  1,  0, 26, 23, 18, 33,
    27, 53, 18, 67, 27,  3, 35, 21, 44, 33, 35, 55, 44, 64, 36,
     9, 61, 18, 53, 43, 61, 52, 53, 77, 61, 12,  1, 19,  9, 42,
     1, 49,  9, 72,  1,  0, 27, 22, 18, 34, 27, 52, 18, 68, 27,
     2, 35, 22, 44, 32, 35, 56, 44, 65, 36, 10, 61, 19, 53, 44,
    61, 53, 53, 78, 61, 11,  1, 18,  9, 41,  1, 48,  9, 71,  1,
     1, 27, 21, 18, 35, 27, 51, 18, 69, 27,  1, 35, 23, 44, 32,
    36, 57, 44, 66, 36, 11, 61, 20, 53, 45, 61, 54, 53, 79, 61,
    10,  1, 17,  9, 40,  1, 48, 10, 70,  1,  2, 27, 20, 18, 36,
    27, 50, 18, 70, 27,  0, 35, 24, 44, 33, 36, 58, 44, 67, 36,
    12, 61, 21, 53, 46, 61, 55, 53, 79, 62,  9,  1, 16,  9, 39,
     1, 49, 10, 69,  1,  3, 27, 19, 18, 37, 27, 49, 18, 71, 27,
     0, 36, 25, 44, 34, 36, 59, 44, 68, 36, 13, 61, 22, 53, 47,
    61, 56, 53, 78, 62,  8,  1, 16, 10, 38,  1, 50, 10, 68,  1,
     4, 27, 18, 18, 38, 27, 48, 18, 72, 27,  1, 36, 26, 44, 35,
    36, 60, 44, 69, 36, 14, 61, 23, 53, 47, 62, 57, 53, 77, 62,
     7,  1, 17, 10, 37,  1, 51, 10, 67,  1,  5, 27, 17, 18, 39,
    27, 48, 19, 73, 27,  2, 36, 27, 44, 36, 36, 61, 44, 70, 36,
    15, 61, 24, 53, 46, 62, 58, 53, 76, 62,  6,  1, 18, 10, 36,
     1, 52, 10, 66,  1,  6, 27, 16, 18, 40, 27, 49, 19, 74, 27,
     3, 36, 28, 44, 37, 36, 62, 44, 71, 36, 15, 62, 25, 53, 45,
    62, 59, 53, 75, 62,  5,  1, 19, 10, 35,  1, 53, 10, 65,  1,
     7, 27, 16, 19, 41, 27, 50, 19, 75, 27,  4, 36, 29, 44, 38,
    36, 63, 44, 72, 36, 14, 62, 26, 53, 44, 62, 60, 53, 74, 62,
     4,  1, 20, 10, 34,  1, 54, 10, 64,  1,  8, 27, 17, 19, 42,
    27, 51, 19, 76, 27,  5, 36, 30, 44, 39, 36, 63, 45, 73, 36,
    13, 62, 27, 53, 43, 62, 61, 53, 73, 62,  3,  1, 21, 10, 33,
     1, 55, 10, 64,  2,  9, 27, 18, 19, 43, 27, 52, 19, 77, 27,
     6, 36, 31, 44, 40, 36, 62, 45, 74, 36, 12, 62, 28, 53, 42,
    62, 62, 53, 72, 62,  2,  1, 22, 10, 32,  1, 56, 10, 65,  2,
    10, 27, 19, 19, 44, 27, 53, 19, 78, 27,  7, 36, 31, 45, 41,
    36, 61, 45, 75, 36, 11, 62, 29, 53, 41, 62, 63, 53, 71, 62,
     1,  1, 23, 10, 32,  2, 57, 10, 66,  2, 11, 27, 20, 19, 45,
    27, 54, 19, 79, 27,  8, 36, 30, 45, 42, 36, 60, 45, 76, 36,
    10, 62, 30, 53, 40, 62, 63, 54, 70, 62,  0,  1, 24, 10, 33,
     2, 58, 10, 67,  2, 12, 27, 21, 19, 46, 27, 55, 19, 79, 28,
     9, 36, 29, 45, 43, 36, 59, 45, 77, 36,  9, 62, 31, 53, 39,
    62, 62, 54, 69, 62,  0,  2, 25, 10, 34,  2, 59, 10, 68,  2,
    13, 27, 22, 19, 47, 27, 56, 19, 78, 28, 10, 36, 28, 45, 44,
    36, 58, 45, 78, 36,  8, 62, 31, 54, 38, 62, 61, 54, 68, 62,
     1,  2, 26, 10, 35,  2, 60, 10, 69,  2, 14, 27, 23, 19, 47,
    28, 57, 19, 77, 28, 11, 36, 27, 45, 45, 36, 57, 45, 79, 36,
     7, 62, 30, 54, 37, 62, 60, 54, 67, 62,  2,  2, 27, 10, 36,
     2, 61, 10, 70,  2, 15, 27, 24, 19, 46, 28, 58, 19, 76, 28,
    12, 36, 26, 45, 46, 36, 56, 45, 79, 37,  6, 62, 29, 54, 36,
    62, 59, 54, 66, 62,  3,  2, 28, 10, 37,  2, 62, 10, 71,  2,
    15, 28, 25, 19, 45, 28, 59, 19, 75, 28, 13, 36, 25, 45, 47,
    36, 55, 45, 78, 37,  5, 62, 28, 54, 35, 62, 58, 54, 65, 62,
     4,  2, 29, 10, 38,  2, 63, 10, 72,  2, 14, 28, 26, 19, 44,
    28, 60, 19, 74, 28, 14, 36, 24, 45, 47, 37, 54, 45, 77, 37,
     4, 62, 27, 54, 34, 62, 57, 54, 64, 62,  5,  2, 30, 10, 39,
     2, 63, 11, 73,  2, 13, 28, 27, 19, 43, 28, 61, 19, 73, 28,
    15, 36, 23, 45, 46, 37, 53, 45, 76, 37,  3, 62, 26, 54, 33,
    62, 56, 54, 64, 63,  6,  2, 31, 10, 40,  2, 62, 11, 74,  2,
    12, 28, 28, 19, 42, 28, 62, 19, 72, 28, 15, 37, 22, 45, 45,
    37, 52, 45, 75, 37,  2, 62, 25, 54, 32, 62, 55, 54, 65, 63,
     7,  2, 31, 11, 41,  2, 61, 11, 75,  2, 11, 28, 29, 19, 41,
    28, 63, 19, 71, 28, 14, 37, 21, 45, 44, 37, 51, 45, 74, 37,
     1, 62, 24, 54, 32, 63, 54, 54, 66, 63,  8,  2, 30, 11, 42,
     2, 60, 11, 76,  2, 10, 28, 30, 19, 40, 28, 63, 20, 70, 28,
    13, 37, 20, 45, 43, 37, 50, 45, 73, 37,  0, 62, 23, 54, 33,
    63, 53, 54, 67, 63,  9,  2, 29, 11, 43,  2, 59, 11, 77,  2,
     9, 28, 31, 19, 39, 28, 62, 20, 69, 28, 12, 37, 19, 45, 42,
    37, 49, 45, 72, 37,  0, 63, 22, 54, 34, 63, 52, 54, 68, 63,
    10,  2, 28, 11, 44,  2, 58, 11, 78,  2,  8, 28, 31, 20, 38,
    28, 61, 20, 68, 28, 11, 37, 18, 45, 41, 37, 48, 45, 71, 37,
     1, 63, 21, 54, 35, 63, 51, 54, 69, 63, 11,  2, 27, 11, 45,
     2, 57, 11, 79,  2,  7, 28, 30, 20, 37, 28, 60, 20, 67, 28,
    10, 37, 17, 45, 40, 37, 48, 46, 70, 37,  2, 63, 20, 54, 36,
    63, 50, 54, 70, 63, 12,  2, 26, 11, 46,  2, 56, 11, 79,  3,
     6, 28, 29, 20, 36, 28, 59, 20, 66, 28,  9, 37, 16, 45, 39,
    37, 49, 46, 69, 37,  3, 63, 19, 54, 37, 63, 49, 54, 71, 63,
    13,  2, 25, 11, 47,  2, 55, 11, 78,  3,  5, 28, 28, 20, 35,
    28, 58, 20, 65, 28,  8, 37, 16, 46, 38, 37, 50, 46, 68, 37,
     4, 63, 18, 54, 38, 63, 48, 54, 72, 63, 14,  2, 24, 11, 47,
     3, 54, 11, 77,  3,  4, 28, 27, 20, 34, 28, 57, 20, 64, 28,
     7, 37, 17, 46, 37, 37, 51, 46, 67, 37,  5, 63, 17, 54, 39,
    63, 48, 55, 73, 63, 15,  2, 23, 11, 46,  3, 53, 11, 76,  3,
     3, 28, 26, 20, 33, 28, 56, 20, 64, 29,  6, 37, 18, 46, 36,
    37, 52, 46, 66, 37,  6, 63, 16, 54, 40, 63, 49, 55, 74, 63,
    15,  3, 22, 11, 45,  3, 52, 11, 75,  3,  2, 28, 25, 20, 32,
    28, 55, 20, 65, 29,  5, 37, 19, 46, 35, 37, 53, 46, 65, 37,
     7, 63, 16, 55, 41, 63, 50, 55, 75, 63, 14,  3, 21, 11, 44,
     3, 51, 11, 74,  3,  1, 28, 24, 20, 32, 29, 54, 20, 66, 29,
     4, 37, 20, 46, 34, 37, 54, 46, 64, 37,  8, 63, 17, 55, 42,
    63, 51, 55, 76, 63, 13,  3, 20, 11, 43,  3, 50, 11, 73,  3,
     0, 28, 23, 20, 33, 29, 53, 20, 67, 29,  3, 37, 21, 46, 33,
    37, 55, 46, 64, 38,  9, 63, 18, 55, 43, 63, 52, 55, 77, 63,
    12,  3, 19, 11, 42,  3, 49, 11, 72,  3,  0, 29, 22, 20, 34,
    29, 52, 20, 68, 29,  2, 37, 22, 46, 32, 37, 56, 46, 65, 38,
    10, 63, 19, 55, 44, 63, 53, 55, 78, 63, 11,  3, 18, 11, 41,
     3, 48, 11, 71,  3,  1, 29, 21, 20, 35, 29, 51, 20, 69, 29,
     1, 37, 23, 46, 32, 38, 57, 46, 66, 38, 11, 63, 20, 55, 45,
    63, 54, 55, 79, 63, 10,  3, 17, 11, 40,  3, 48, 12, 70,  3,
     2, 29, 20, 20, 36, 29, 50, 20, 70, 29,  0, 37, 24, 46, 33,
    38, 58, 46, 67, 38, 12, 63, 21, 55, 46, 63, 55, 55, 79, 64,
     9,  3, 16, 11, 39,  3, 49, 12, 69,  3,  3, 29, 19, 20, 37,
    29, 49, 20, 71, 29,  0, 38, 25, 46, 34, 38, 59, 46, 68, 38,
    13, 63, 22, 55, 47, 63, 56, 55, 78, 64,  8,  3, 16, 12, 38,
     3, 50, 12, 68,  3,  4, 29, 18, 20, 38, 29, 48, 20, 72, 29,
     1, 38, 26, 46, 35, 38, 60, 46, 69, 38, 14, 63, 23, 55, 47,
    64, 57, 55, 77, 64,  7,  3, 17, 12, 37,  3, 51, 12, 67,  3,
     5, 29, 17, 20, 39, 29, 48, 21, 73, 29,  2, 38, 27, 46, 36,
    38, 61, 46, 70, 38, 15, 63, 24, 55, 46, 64, 58, 55, 76, 64,
     6,  3, 18, 12, 36,  3, 52, 12, 66,  3,  6, 29, 16, 20, 40,
    29, 49, 21, 74, 29,  3, 38, 28, 46, 37, 38, 62, 46, 71, 38,
    15, 64, 25, 55, 45, 64, 59, 55, 75, 64,  5,  3, 19, 12, 35,
     3, 53, 12, 65,  3,  7, 29, 16, 21, 41, 29, 50, 21, 75, 29,
     4, 38, 29, 46, 38, 38, 63, 46, 72, 38, 14, 64, 26, 55, 44,
    64, 60, 55, 74, 64,  4,  3, 20, 12, 34,  3, 54, 12, 64,  3,
     8, 29, 17, 21, 42, 29, 51, 21, 76, 29,  5, 38, 30, 46, 39,
    38, 63, 47, 73, 38, 13, 64, 27, 55, 43, 64, 61, 55, 73, 64,
     3,  3, 21, 12, 33,  3, 55, 12, 64,  4,  9, 29, 18, 21, 43,
    29, 52, 21, 77, 29,  6, 38, 31, 46, 40, 38, 62, 47, 74, 38,
    12, 64, 28, 55, 42, 64, 62, 55, 72, 64,  2,  3, 22, 12, 32,
     3, 56, 12, 65,  4, 10, 29, 19, 21, 44, 29, 53, 21, 78, 29,
     7, 38, 31, 47, 41, 38, 61, 47, 75, 38, 11, 64, 29, 55, 41,
    64, 63, 55, 71, 64,  1,  3, 23, 12, 32,  4, 57, 12, 66,  4,
    11, 29, 20, 21, 45, 29, 54, 21, 79, 29,  8, 38, 30, 47, 42,
    38, 60, 47, 76, 38, 10, 64, 30, 55, 40, 64, 63, 56, 70, 64,
     0,  3, 24, 12, 33,  4, 58, 12, 67,  4, 12, 29, 21, 21, 46,
    29, 55, 21, 79, 30,  9, 38, 29, 47, 43, 38, 59, 47, 77, 38,
     9, 64, 31, 55, 39, 64, 62, 56, 69, 64,  0,  4, 25, 12, 34,
     4, 59, 12, 68,  4, 13, 29, 22, 21, 47, 29, 56, 21, 78, 30,
    10, 38, 28, 47, 44, 38, 58, 47, 78, 38,  8, 64, 31, 56, 38,
    64, 61, 56, 68, 64,  1,  4, 26, 12, 35,  4, 60, 12, 69,  4,
    14, 29, 23, 21, 47, 30, 57, 21, 77, 30, 11, 38, 27, 47, 45,
    38, 57, 47, 79, 38,  7, 64, 30, 56, 37, 64, 60, 56, 67, 64,
     2,  4, 27, 12, 36,  4, 61, 12, 70,  4, 15, 29, 24, 21, 46,
    30, 58, 21, 76, 30, 12, 38, 26, 47, 46, 38, 56, 47, 79, 39,
     6, 64, 29, 56, 36, 64, 59, 56, 66, 64,  3,  4, 28, 12, 37,
     4, 62, 12, 71,  4, 15, 30, 25, 21, 45, 30, 59, 21, 75, 30,
    13, 38, 25, 47, 47, 38, 55, 47, 78, 39,  5, 64, 28, 56, 35,
    64, 58, 56, 65, 64,  4,  4, 29, 12, 38,  4, 63, 12, 72,  4,
    14, 30, 26, 21, 44, 30, 60, 21, 74, 30, 14, 38, 24, 47, 47,
    39, 54, 47, 77, 39,  4, 64, 27, 56, 34, 64, 57, 56, 64, 64,
     5,  4, 30, 12, 39,  4, 63, 13, 73,  4, 13, 30, 27, 21, 43,
    30, 61, 21, 73, 30, 15, 38, 23, 47, 46, 39, 53, 47, 76, 39,
     3, 64, 26, 56, 33, 64, 56, 56, 64, 65,  6,  4, 31, 12, 40,
     4, 62, 13, 74,  4, 12, 30, 28, 21, 42, 30, 62, 21, 72, 30,
    15, 39, 22, 47, 45, 39, 52, 47, 75, 39,  2, 64, 25, 56, 32,
    64, 55, 56, 65, 65,  7,  4, 31, 13, 41,  4, 61, 13, 75,  4,
    11, 30, 29, 21, 41, 30, 63, 21, 71, 30, 14, 39, 21, 47, 44,
    39, 51, 47, 74, 39,  1, 64, 24, 56, 32, 65, 54, 56, 66, 65,
     8,  4, 30, 13, 42,  4, 60, 13, 76,  4, 10, 30, 30, 21, 40,
    30, 63, 22, 70, 30, 13, 39, 20, 47, 43, 39, 50, 47, 73, 39,
     0, 64, 23, 56, 33, 65, 53, 56, 67, 65,  9,  4, 29, 13, 43,
     4, 59, 13, 77,  4,  9, 30, 31, 21, 39, 30, 62, 22, 69, 30,
    12, 39, 19, 47, 42, 39, 49, 47, 72, 39,  0, 65, 22, 56, 34,
    65, 52, 56, 68, 65, 10,  4, 28, 13, 44,  4, 58, 13, 78,  4,
     8, 30, 31, 22, 38, 30, 61, 22, 68, 30, 11, 39, 18, 47, 41,
    39, 48, 47, 71, 39,  1, 65, 21, 56, 35, 65, 51, 56, 69, 65,
    11,  4, 27, 13, 45,  4, 57, 13, 79,  4,  7, 30, 30, 22, 37,
    30, 60, 22, 67, 30, 10, 39, 17, 47, 40, 39, 48, 48, 70, 39,
     2, 65, 20, 56, 36, 65, 50, 56, 70, 65, 12,  4, 26, 13, 46,
     4, 56, 13, 79,  5,  6, 30, 29, 22, 36, 30, 59, 22, 66, 30,
     9, 39, 16, 47, 39, 39, 49, 48, 69, 39,  3, 65, 19, 56, 37,
    65, 49, 56, 71, 65, 13,  4, 25, 13, 47,  4, 55, 13, 78,  5,
     5, 30, 28, 22, 35, 30, 58, 22, 65, 30,  8, 39, 16, 48, 38,
    39, 50, 48, 68, 39,  4, 65, 18, 56, 38, 65, 48, 56, 72, 65,
    14,  4, 24, 13, 47,  5, 54, 13, 77,  5,  4, 30, 27, 22, 34,
    30, 57, 22, 64, 30,  7, 39, 17, 48, 37, 39, 51, 48, 67, 39,
     5, 65, 17, 56, 39, 65, 48, 57, 73, 65, 15,  4, 23, 13, 46,
     5, 53, 13, 76,  5,  3, 30, 26, 22, 33, 30, 56, 22, 64, 31,
     6, 39, 18, 48, 36, 39, 52, 48, 66, 39,  6, 65, 16, 56, 40,
    65, 49, 57, 74, 65, 15,  5, 22, 13, 45,  5, 52, 13, 75,  5,
     2, 30, 25, 22, 32, 30, 55, 22, 65, 31,  5, 39, 19, 48, 35,
    39, 53, 48, 65, 39,  7, 65, 16, 57, 41, 65, 50, 57, 75, 65,
    14,  5, 21, 13, 44,  5, 51, 13, 74,  5,  1, 30, 24, 22, 32,
    31, 54, 22, 66, 31,  4, 39, 20, 48, 34, 39, 54, 48, 64, 39,
     8, 65, 17, 57, 42, 65, 51, 57, 76, 65, 13,  5, 20, 13, 43,
     5, 50, 13, 73,  5,  0, 30, 23, 22, 33, 31, 53, 22, 67, 31,
     3, 39, 21, 48, 33, 39, 55, 48, 64, 40,  9, 65, 18, 57, 43,
    65, 52, 57, 77, 65, 12,  5, 19, 13, 42,  5, 49, 13, 72,  5,
     0, 31, 22, 22, 34, 31, 52, 22, 68, 31,  2, 39, 22, 48, 32,
    39, 56, 48, 65, 40, 10, 65, 19, 57, 44, 65, 53, 57, 78, 65,
    11,  5, 18, 13, 41,  5, 48, 13, 71,  5,  1, 31, 21, 22, 35,
    31, 51, 22, 69, 31,  1, 39, 23, 48, 32, 40, 57, 48, 66, 40,
    11, 65, 20, 57, 45, 65, 54, 57, 79, 65, 10,  5, 17, 13, 40,
     5, 48, 14, 70,  5,  2, 31, 20, 22, 36, 31, 50, 22, 70, 31,
     0, 39, 24, 48, 33, 40, 58, 48, 67, 40, 12, 65, 21, 57, 46,
    65, 55, 57, 79, 66,  9,  5, 16, 13, 39,  5, 49, 14, 69,  5,
     3, 31, 19, 22, 37, 31, 49, 22, 71, 31,  0, 40, 25, 48, 34,
    40, 59, 48, 68, 40, 13, 65, 22, 57, 47, 65, 56, 57, 78, 66,
     8,  5, 16, 14, 38,  5, 50, 14, 68,  5,  4, 31, 18, 22, 38,
    31, 48, 22, 72, 31,  1, 40, 26, 48, 35, 40, 60, 48, 69, 40,
    14, 65, 23, 57, 47, 66, 57, 57, 77, 66,  7,  5, 17, 14, 37,
     5, 51, 14, 67,  5,  5, 31, 17, 22, 39, 31, 48, 23, 73, 31,
     2, 40, 27, 48, 36, 40, 61, 48, 70, 40, 15, 65, 24, 57, 46,
    66, 58, 57, 76, 66,  6,  5, 18, 14, 36,  5, 52, 14, 66,  5,
     6, 31, 16, 22, 40, 31, 49, 23, 74, 31,  3, 40, 28, 48, 37,
    40, 62, 48, 71, 40, 15, 66, 25, 57, 45, 66, 59, 57, 75, 66,
     5,  5, 19, 14, 35,  5, 53, 14, 65,  5,  7, 31, 16, 23, 41,
    31, 50, 23, 75, 31,  4, 40, 29, 48, 38, 40, 63, 48, 72, 40,
    14, 66, 26, 57, 44, 66, 60, 57, 74, 66,  4,  5, 20, 14, 34,
     5, 54, 14, 64,  5,  8, 31, 17, 23, 42, 31, 51, 23, 76, 31,
     5, 40, 30, 48, 39, 40, 63, 49, 73, 40, 13, 66, 27, 57, 43,
    66, 61, 57, 73, 66,  3,  5, 21, 14, 33,  5, 55, 14, 64,  6,
     9, 31, 18, 23, 43, 31, 52, 23, 77, 31,  6, 40, 31, 48, 40,
    40, 62, 49, 74, 40, 12, 66, 28, 57, 42, 66, 62, 57, 72, 66,
     2,  5, 22, 14, 32,  5, 56, 14, 65,  6, 10, 31, 19, 23, 44,
    31, 53, 23, 78, 31,  7, 40, 31, 49, 41, 40, 61, 49, 75, 40,
    11, 66, 29, 57, 41, 66, 63, 57, 71, 66,  1,  5, 23, 14, 32,
     6, 57, 14, 66,  6, 11, 31, 20, 23, 45, 31, 54, 23, 79, 31,
     8, 40, 30, 49, 42, 40, 60, 49, 76, 40, 10, 66, 30, 57, 40,
    66, 63, 58, 70, 66,  0,  5, 24, 14, 33,  6, 58, 14, 67,  6,
    12, 31, 21, 23, 46, 31, 55, 23, 79, 32,  9, 40, 29, 49, 43,
    40, 59, 49, 77, 40,  9, 66, 31, 57, 39, 66, 62, 58, 69, 66,
     0,  6, 25, 14, 34,  6, 59, 14, 68,  6, 13, 31, 22, 23, 47,
    31, 56, 23, 78, 32, 10, 40, 28, 49, 44, 40, 58, 49, 78, 40,
     8, 66, 31, 58, 38, 66, 61, 58, 68, 66,  1,  6, 26, 14, 35,
     6, 60, 14, 69,  6, 14, 31, 23, 23, 47, 32, 57, 23, 77, 32,
    11, 40, 27, 49, 45, 40, 57, 49, 79, 40,  7, 66, 30, 58, 37,
    66, 60, 58, 67, 66,  2,  6, 27, 14, 36,  6, 61, 14, 70,  6,
    15, 31, 24, 23, 46, 32, 58, 23, 76, 32, 12, 40, 26, 49, 46,
    40, 56, 49, 79, 41,  6, 66, 29, 58, 36, 66, 59, 58, 66, 66,
     3,  6, 28, 14, 37,  6, 62, 14, 71,  6, 15, 32, 25, 23, 45,
    32, 59, 23, 75, 32, 13, 40, 25, 49, 47, 40, 55, 49, 78, 41,
     5, 66, 28, 58, 35, 66, 58, 58, 65, 66,  4,  6, 29, 14, 38,
     6, 63, 14, 72,  6, 14, 32, 26, 23, 44, 32, 60, 23, 74, 32,
    14, 40, 24, 49, 47, 41, 54, 49, 77, 41,  4, 66, 27, 58, 34,
    66, 57, 58, 64, 66,  5,  6, 30, 14, 39,  6, 63, 15, 73,  6,
    13, 32, 27, 23, 43, 32, 61, 23, 73, 32, 15, 40, 23, 49, 46,
    41, 53, 49, 76, 41,  3, 66, 26, 58, 33, 66, 56, 58, 64, 67,
     6,  6, 31, 14, 40,  6, 62, 15, 74,  6, 12, 32, 28, 23, 42,
    32, 62, 23, 72, 32, 15, 41, 22, 49, 45, 41, 52, 49, 75, 41,
     2, 66, 25, 58, 32, 66, 55, 58, 65, 67,  7,  6, 31, 15, 41,
     6, 61, 15, 75,  6, 11, 32, 29, 23, 41, 32, 63, 23, 71, 32,
    14, 41, 21, 49, 44, 41, 51, 49, 74, 41,  1, 66, 24, 58, 32,
    67, 54, 58, 66, 67,  8,  6, 30, 15, 42,  6, 60, 15, 76,  6,
    10, 32, 30, 23, 40, 32, 63, 24, 70, 32, 13, 41, 20, 49, 43,
    41, 50, 49, 73, 41,  0, 66, 23, 58, 33, 67, 53, 58, 67, 67,
     9,  6, 29, 15, 43,  6, 59, 15, 77,  6,  9, 32, 31, 23, 39,
    32, 62, 24, 69, 32, 12, 41, 19, 49, 42, 41, 49, 49, 72, 41,
     0, 67, 22, 58, 34, 67, 52, 58, 68, 67, 10,  6, 28, 15, 44,
     6, 58, 15, 78,  6,  8, 32, 31, 24, 38, 32, 61, 24, 68, 32,
    11, 41, 18, 49, 41, 41, 48, 49, 71, 41,  1, 67, 21, 58, 35,
    67, 51, 58, 69, 67, 11,  6, 27, 15, 45,  6, 57, 15, 79,  6,
     7, 32, 30, 24, 37, 32, 60, 24, 67, 32, 10, 41, 17, 49, 40,
    41, 48, 50, 70, 41,  2, 67, 20, 58, 36, 67, 50, 58, 70, 67,
    12,  6, 26, 15, 46,  6, 56, 15, 79,  7,  6, 32, 29, 24, 36,
    32, 59, 24, 66, 32,  9, 41, 16, 49, 39, 41, 49, 50, 69, 41,
     3, 67, 19, 58, 37, 67, 49, 58, 71, 67, 13,  6, 25, 15, 47,
     6, 55, 15, 78,  7,  5, 32, 28, 24, 35, 32, 58, 24, 65, 32,
     8, 41, 16, 50, 38, 41, 50, 50, 68, 41,  4, 67, 18, 58, 38,
    67, 48, 58, 72, 67, 14,  6, 24, 15, 47,  7, 54, 15, 77,  7,
     4, 32, 27, 24, 34, 32, 57, 24, 64, 32,  7, 41, 17, 50, 37,
    41, 51, 50, 67, 41,  5, 67, 17, 58, 39, 67, 48, 59, 73, 67,
    15,  6, 23, 15, 46,  7, 53, 15, 76,  7,  3, 32, 26, 24, 33,
    32, 56, 24, 64, 33,  6, 41, 18, 50, 36, 41, 52, 50, 66, 41,
     6, 67, 16, 58, 40, 67, 49, 59, 74, 67, 15,  7, 22, 15, 45,
     7, 52, 15, 75,  7,  2, 32, 25, 24, 32, 32, 55, 24, 65, 33,
     5, 41, 19, 50, 35, 41, 53, 50, 65, 41,  7, 67, 16, 59, 41,
    67, 50, 59, 75, 67, 14,  7, 21, 15, 44,  7, 51, 15, 74,  7,
     1, 32, 24, 24, 32, 33, 54, 24, 66, 33,  4, 41, 20, 50, 34,
    41, 54, 50, 64, 41,  8, 67, 17, 59, 42, 67, 51, 59, 76, 67,
    13,  7, 20, 15, 43,  7, 50, 15, 73,  7,  0, 32, 23, 24, 33,
    33, 53, 24, 67, 33,  3, 41, 21, 50, 33, 41, 55, 50, 64, 42,
     9, 67, 18, 59, 43, 67, 52, 59, 77, 67, 12,  7, 19, 15, 42,
     7, 49, 15, 72,  7,  0, 33, 22, 24, 34, 33, 52, 24, 68, 33,
     2, 41, 22, 50, 32, 41, 56, 50, 65, 42, 10, 67, 19, 59, 44,
    67, 53, 59, 78, 67, 11,  7, 18, 15, 41,  7, 48, 15, 71,  7,
     1, 33, 21, 24, 35, 33, 51, 24, 69, 33,  1, 41, 23, 50, 32,
    42, 57, 50, 66, 42, 11, 67, 20, 59, 45, 67, 54, 59, 79, 67,
    10,  7, 17, 15, 40,  7, 48, 16, 70,  7,  2, 33, 20, 24, 36,
    33, 50, 24, 70, 33,  0, 41, 24, 50, 33, 42, 58, 50, 67, 42,
    12, 67, 21, 59, 46, 67, 55, 59, 64, 51,  9,  7, 16, 15, 39,
     7, 49, 16, 69,  7,  3, 33, 19, 24, 37, 33, 49, 24, 71, 33,
     0, 42, 25, 50, 34, 42, 59, 50, 68, 42, 13, 67, 22, 59, 47,
    67, 56, 59, 65, 51,  8,  7, 16, 16, 38,  7, 50, 16, 68,  7,
     4, 33, 18, 24, 38, 33, 48, 24, 72, 33,  1, 42, 26, 50, 35,
    42, 60, 50, 69, 42, 14, 67, 23, 59, 32, 51, 57, 59, 66, 51,
     7,  7, 17, 16, 37,  7, 51, 16, 67,  7,  5, 33, 17, 24, 39,
    33, 48, 25, 73, 33,  2, 42, 27, 50, 36, 42, 61, 50, 70, 42,
    15, 67, 24, 59, 33, 51, 58, 59, 67, 51,  6,  7, 18, 16, 36,
     7, 52, 16, 66,  7,  6, 33, 16, 24, 40, 33, 49, 25, 74, 33,
     3, 42, 28, 50, 37, 42, 62, 50, 71, 42,  0, 51, 25, 59, 34,
    51, 59, 59, 68, 51,  5,  7, 19, 16, 35,  7, 53, 16, 65,  7,
     7, 33, 16, 25, 41, 33, 50, 25, 75, 33,  4, 42, 29, 50, 38,
    42, 63, 50, 72, 42,  1, 51, 26, 59, 35, 51, 60, 59, 69, 51,
     4,  7, 20, 16, 34,  7, 54, 16, 64,  7,  8, 33, 17, 25, 42,
    33, 51, 25, 76, 33,  5, 42, 30, 50, 39, 42, 48, 34, 73, 42,
     2, 51, 27, 59, 36, 51, 61, 59, 70, 51,  3,  7, 21, 16, 33,
     7, 55, 16, 64,  8,  9, 33, 18, 25, 43, 33, 52, 25, 77, 33,
     6, 42, 31, 50, 40, 42, 49, 34, 74, 42,  3, 51, 28, 59, 37,
    51, 62, 59, 71, 51,  2,  7, 22, 16, 32,  7, 56, 16, 65,  8,
    10, 33, 19, 25, 44, 33, 53, 25, 78, 33,  7, 42, 16, 34, 41,
    42, 50, 34, 75, 42,  4, 51, 29, 59, 38, 51, 63, 59, 72, 51,
     1,  7, 23, 16, 32,  8, 57, 16, 66,  8, 11, 33, 20, 25, 45,
    33, 54, 25, 79, 33,  8, 42, 17, 34, 42, 42, 51, 34, 76, 42,
     5, 51, 30, 59, 39, 51, 63, 60, 73, 51,  0,  7, 24, 16, 33,
     8, 58, 16, 67,  8, 12, 33, 21, 25, 46, 33, 55, 25, 64, 17,
     9, 42, 18, 34, 43, 42, 52, 34, 77, 42,  6, 51, 31, 59, 40,
    51, 62, 60, 74, 51,  0,  8, 25, 16, 34,  8, 59, 16, 68,  8,
    13, 33, 22, 25, 47, 33, 56, 25, 65, 17, 10, 42, 19, 34, 44,
    42, 53, 34, 78, 42,  7, 51, 31, 60, 41, 51, 61, 60, 75, 51,
     1,  8, 26, 16, 35,  8, 60, 16, 69,  8, 14, 33, 23, 25, 32,
    17, 57, 25, 66, 17, 11, 42, 20, 34, 45, 42, 54, 34, 79, 42,
     8, 51, 30, 60, 42, 51, 60, 60, 76, 51,  2,  8, 27, 16, 36,
     8, 61, 16, 70,  8, 15, 33, 24, 25, 33, 17, 58, 25, 67, 17,
    12, 42, 21, 34, 46, 42, 55, 34, 79, 43,  9, 51, 29, 60, 43,
    51, 59, 60, 77, 51,  3,  8, 28, 16, 37,  8, 62, 16, 71,  8,
     0, 17, 25, 25, 34, 17, 59, 25, 68, 17, 13, 42, 22, 34, 47,
    42, 56, 34, 78, 43, 10, 51, 28, 60, 44, 51, 58, 60, 78, 51,
     4,  8, 29, 16, 38,  8, 63, 16, 72,  8,  1, 17, 26, 25, 35,
    17, 60, 25, 69, 17, 14, 42, 23, 34, 47, 43, 57, 34, 77, 43,
    11, 51, 27, 60, 45, 51, 57, 60, 79, 51,  5,  8, 30, 16, 39,
     8, 48,  0, 73,  8,  2, 17, 27, 25, 36, 17, 61, 25, 70, 17,
    15, 42, 24, 34, 46, 43, 58, 34, 76, 43, 12, 51, 26, 60, 46,
    51, 56, 60, 79, 52,  6,  8, 31, 16, 40,  8, 49,  0, 74,  8,
     3, 17, 28, 25, 37, 17, 62, 25, 71, 17, 15, 43, 25, 34, 45,
    43, 59, 34, 75, 43, 13, 51, 25, 60, 47, 51, 55, 60, 78, 52,
     7,  8, 16,  0, 41,  8, 50,  0, 75,  8,  4, 17, 29, 25, 38,
    17, 63, 25, 72, 17, 14, 43, 26, 34, 44, 43, 60, 34, 74, 43,
    14, 51, 24, 60, 47, 52, 54, 60, 77, 52,  8,  8, 17,  0, 42,
     8, 51,  0, 76,  8,  5, 17, 30, 25, 39, 17, 63, 26, 73, 17,
    13, 43, 27, 34, 43, 43, 61, 34, 73, 43, 15, 51, 23, 60, 46,
    52, 53, 60, 76, 52,  9,  8, 18,  0, 43,  8, 52,  0, 77,  8,
     6, 17, 31, 25, 40, 17, 62, 26, 74, 17, 12, 43, 28, 34, 42,
    43, 62, 34, 72, 43, 15, 52, 22, 60, 45, 52, 52, 60, 75, 52,
    10,  8, 19,  0, 44,  8, 53,  0, 78,  8,  7, 17, 31, 26, 41,
    17, 61, 26, 75, 17, 11, 43, 29, 34, 41, 43, 63, 34, 71, 43,
    14, 52, 21, 60, 44, 52, 51, 60, 74, 52, 11,  8, 20,  0, 45,
     8, 54,  0, 79,  8,  8, 17, 30, 26, 42, 17, 60, 26, 76, 17,
    10, 43, 30, 34, 40, 43, 63, 35, 70, 43, 13, 52, 20, 60, 43,
    52, 50, 60, 73, 52, 12,  8, 21,  0, 46,  8, 55,  0, 79,  9,
     9, 17, 29, 26, 43, 17, 59, 26, 77, 17,  9, 43, 31, 34, 39,
    43, 62, 35, 69, 43, 12, 52, 19, 60, 42, 52, 49, 60, 72, 52,
    13,  8, 22,  0, 47,  8, 56,  0, 78,  9, 10, 17, 28, 26, 44,
    17, 58, 26, 78, 17,  8, 43, 31, 35, 38, 43, 61, 35, 68, 43,
    11, 52, 18, 60, 41, 52, 48, 60, 71, 52, 14,  8, 23,  0, 47,
     9, 57,  0, 77,  9, 11, 17, 27, 26, 45, 17, 57, 26, 79, 17,
     7, 43, 30, 35, 37, 43, 60, 35, 67, 43, 10, 52, 17, 60, 40,
    52, 48, 61, 70, 52, 15,  8, 24,  0, 46,  9, 58,  0, 76,  9,
    12, 17, 26, 26, 46, 17, 56, 26, 79, 18,  6, 43, 29, 35, 36,
    43, 59, 35, 66, 43,  9, 52, 16, 60, 39, 52, 49, 61, 69, 52,
    15,  9, 25,  0, 45,  9, 59,  0, 75,  9, 13, 17, 25, 26, 47,
    17, 55, 26, 78, 18,  5, 43, 28, 35, 35, 43, 58, 35, 65, 43,
     8, 52, 16, 61, 38, 52, 50, 61, 68, 52, 14,  9, 26,  0, 44,
     9, 60,  0, 74,  9, 14, 17, 24, 26, 47, 18, 54, 26, 77, 18,
     4, 43, 27, 35, 34, 43, 57, 35, 64, 43,  7, 52, 17, 61, 37,
    52, 51, 61, 67, 52, 13,  9, 27,  0, 43,  9, 61,  0, 73,  9,
    15, 17, 23, 26, 46, 18, 53, 26, 76, 18,  3, 43, 26, 35, 33,
    43, 56, 35, 64, 44,  6, 52, 18, 61, 36, 52, 52, 61, 66, 52,
    12,  9, 28,  0, 42,  9, 62,  0, 72,  9, 15, 18, 22, 26, 45,
    18, 52, 26, 75, 18,  2, 43, 25, 35, 32, 43, 55, 35, 65, 44,
     5, 52, 19, 61, 35, 52, 53, 61, 65, 52, 11,  9, 29,  0, 41,
     9, 63,  0, 71,  9, 14, 18, 21, 26, 44, 18, 51, 26, 74, 18,
     1, 43, 24, 35, 32, 44, 54, 35, 66, 44,  4, 52, 20, 61, 34,
    52, 54, 61, 64, 52, 10,  9, 30,  0, 40,  9, 63,  1, 70,  9,
    13, 18, 20, 26, 43, 18, 50, 26, 73, 18,  0, 43, 23, 35, 33,
    44, 53, 35, 67, 44,  3, 52, 21, 61, 33, 52, 55, 61, 64, 53,
     9,  9, 31,  0, 39,  9, 62,  1, 69,  9, 12, 18, 19, 26, 42,
    18, 49, 26, 72, 18,  0, 44, 22, 35, 34, 44, 52, 35, 68, 44,
     2, 52, 22, 61, 32, 52, 56, 61, 65, 53,  8,  9, 31,  1, 38,
     9, 61,  1, 68,  9, 11, 18, 18, 26, 41, 18, 48, 26, 71, 18,
     1, 44, 21, 35, 35, 44, 51, 35, 69, 44,  1, 52, 23, 61, 32,
    53, 57, 61, 66, 53,  7,  9, 30,  1, 37,  9, 60,  1, 67,  9,
    10, 18, 17, 26, 40, 18, 48, 27, 70, 18,  2, 44, 20, 35, 36,
    44, 50, 35, 70, 44,  0, 52, 24, 61, 33, 53, 58, 61, 67, 53,
     6,  9, 29,  1, 36,  9, 59,  1, 66,  9,  9, 18, 16, 26, 39,
    18, 49, 27, 69, 18,  3, 44, 19, 35, 37, 44, 49, 35, 71, 44,
     0, 53, 25, 61, 34, 53, 59, 61, 68, 53,  5,  9, 28,  1, 35,
     9, 58,  1, 65,  9,  8, 18, 16, 27, 38, 18, 50, 27, 68, 18,
     4, 44, 18, 35, 38, 44, 48, 35, 72, 44,  1, 53, 26, 61, 35,
    53, 60, 61, 69, 53,  4,  9, 27,  1, 34,  9, 57,  1, 64,  9,
     7, 18, 17, 27, 37, 18, 51, 27, 67, 18,  5, 44, 17, 35, 39,
    44, 48, 36, 73, 44,  2, 53, 27, 61, 36, 53, 61, 61, 70, 53,
     3,  9, 26,  1, 33,  9, 56,  1, 64, 10,  6, 18, 18, 27, 36,
    18, 52, 27, 66, 18,  6, 44, 16, 35, 40, 44, 49, 36, 74, 44,
     3, 53, 28, 61, 37, 53, 62, 61, 71, 53,  2,  9, 25,  1, 32,
     9, 55,  1, 65, 10,  5, 18, 19, 27, 35, 18, 53, 27, 65, 18,
     7, 44, 16, 36, 41, 44, 50, 36, 75, 44,  4, 53, 29, 61, 38,
    53, 63, 61, 72, 53,  1,  9, 24,  1, 32, 10, 54,  1, 66, 10,
     4, 18, 20, 27, 34, 18, 54, 27, 64, 18,  8, 44, 17, 36, 42,
    44, 51, 36, 76, 44,  5, 53, 30, 61, 39, 53, 63, 62, 73, 53,
     0,  9, 23,  1, 33, 10, 53,  1, 67, 10,  3, 18, 21, 27, 33,
    18, 55, 27, 64, 19,  9, 44, 18, 36, 43, 44, 52, 36, 77, 44,
     6, 53, 31, 61, 40, 53, 62, 62, 74, 53,  0, 10, 22,  1, 34,
    10, 52,  1, 68, 10,  2, 18, 22, 27, 32, 18, 56, 27, 65, 19,
    10, 44, 19, 36, 44, 44, 53, 36, 78, 44,  7, 53, 31, 62, 41,
    53, 61, 62, 75, 53,  1, 10, 21,  1, 35, 10, 51,  1, 69, 10,
     1, 18, 23, 27, 32, 19, 57, 27, 66, 19, 11, 44, 20, 36, 45,
    44, 54, 36, 79, 44,  8, 53, 30, 62, 42, 53, 60, 62, 76, 53,
     2, 10, 20,  1, 36, 10, 50,  1, 70, 10,  0, 18, 24, 27, 33,
    19, 58, 27, 67, 19, 12, 44, 21, 36, 46, 44, 55, 36, 79, 45,
     9, 53, 29, 62, 43, 53, 59, 62, 77, 53,  3, 10, 19,  1, 37,
    10, 49,  1, 71, 10,  0, 19, 25, 27, 34, 19, 59, 27, 68, 19,
    13, 44, 22, 36, 47, 44, 56, 36, 78, 45, 10, 53, 28, 62, 44,
    53, 58, 62, 78, 53,  4, 10, 18,  1, 38, 10, 48,  1, 72, 10,
     1, 19, 26, 27, 35, 19, 60, 27, 69, 19, 14, 44, 23, 36, 47,
    45, 57, 36, 77, 45, 11, 53, 27, 62, 45, 53, 57, 62, 79, 53,
     5, 10, 17,  1, 39, 10, 48,  2, 73, 10,  2, 19, 27, 27, 36,
    19, 61, 27, 70, 19, 15, 44, 24, 36, 46, 45, 58, 36, 76, 45,
    12, 53, 26, 62, 46, 53, 56, 62, 79, 54,  6, 10, 16,  1, 40,
    10, 49,  2, 74, 10,  3, 19, 28, 27, 37, 19, 62, 27, 71, 19,
    15, 45, 25, 36, 45, 45, 59, 36, 75, 45, 13, 53, 25, 62, 47,
    53, 55, 62, 78, 54,  7, 10, 16,  2, 41, 10, 50,  2, 75, 10,
     4, 19, 29, 27, 38, 19, 63, 27, 72, 19, 14, 45, 26, 36, 44,
    45, 60, 36, 74, 45, 14, 53, 24, 62, 47, 54, 54, 62, 77, 54,
     8, 10, 17,  2, 42, 10, 51,  2, 76, 10,  5, 19, 30, 27, 39,
    19, 63, 28, 73, 19, 13, 45, 27, 36, 43, 45, 61, 36, 73, 45,
    15, 53, 23, 62, 46, 54, 53, 62, 76, 54,  9, 10, 18,  2, 43,
    10, 52,  2, 77, 10,  6, 19, 31, 27, 40, 19, 62, 28, 74, 19,
    12, 45, 28, 36, 42, 45, 62, 36, 72, 45, 15, 54, 22, 62, 45,
    54, 52, 62, 75, 54, 10, 10, 19,  2, 44, 10, 53,  2, 78, 10,
     7, 19, 31, 28, 41, 19, 61, 28, 75, 19, 11, 45, 29, 36, 41,
    45, 63, 36, 71, 45, 14, 54, 21, 62, 44, 54, 51, 62, 74, 54,
    11, 10, 20,  2, 45, 10, 54,  2, 79, 10,  8, 19, 30, 28, 42,
    19, 60, 28, 76, 19, 10, 45, 30, 36, 40, 45, 63, 37, 70, 45,
    13, 54, 20, 62, 43, 54, 50, 62, 73, 54, 12, 10, 21,  2, 46,
    10, 55,  2, 79, 11,  9, 19, 29, 28, 43, 19, 59, 28, 77, 19,
     9, 45, 31, 36, 39, 45, 62, 37, 69, 45, 12, 54, 19, 62, 42,
    54, 49, 62, 72, 54, 13, 10, 22,  2, 47, 10, 56,  2, 78, 11,
    10, 19, 28, 28, 44, 19, 58, 28, 78, 19,  8, 45, 31, 37, 38,
    45, 61, 37, 68, 45, 11, 54, 18, 62, 41, 54, 48, 62, 71, 54,
    14, 10, 23,  2, 47, 11, 57,  2, 77, 11, 11, 19, 27, 28, 45,
    19, 57, 28, 79, 19,  7, 45, 30, 37, 37, 45, 60, 37, 67, 45,
    10, 54, 17, 62, 40, 54, 48, 63, 70, 54, 15, 10, 24,  2, 46,
    11, 58,  2, 76, 11, 12, 19, 26, 28, 46, 19, 56, 28, 79, 20,
     6, 45, 29, 37, 36, 45, 59, 37, 66, 45,  9, 54, 16, 62, 39,
    54, 49, 63, 69, 54, 15, 11, 25,  2, 45, 11, 59,  2, 75, 11,
    13, 19, 25, 28, 47, 19, 55, 28, 78, 20,  5, 45, 28, 37, 35,
    45, 58, 37, 65, 45,  8, 54, 16, 63, 38, 54, 50, 63, 68, 54,
    14, 11, 26,  2, 44, 11, 60,  2, 74, 11, 14, 19, 24, 28, 47,
    20, 54, 28, 77, 20,  4, 45, 27, 37, 34, 45, 57, 37, 64, 45,
     7, 54, 17, 63, 37, 54, 51, 63, 67, 54, 13, 11, 27,  2, 43,
    11, 61,  2, 73, 11, 15, 19, 23, 28, 46, 20, 53, 28, 76, 20,
     3, 45, 26, 37, 33, 45, 56, 37, 64, 46,  6, 54, 18, 63, 36,
    54, 52, 63, 66, 54, 12, 11, 28,  2, 42, 11, 62,  2, 72, 11,
    15, 20, 22, 28, 45, 20, 52, 28, 75, 20,  2, 45, 25, 37, 32,
    45, 55, 37, 65, 46,  5, 54, 19, 63, 35, 54, 53, 63, 65, 54,
    11, 11, 29,  2, 41, 11, 63,  2, 71, 11, 14, 20, 21, 28, 44,
    20, 51, 28, 74, 20,  1, 45, 24, 37, 32, 46, 54, 37, 66, 46,
     4, 54, 20, 63, 34, 54, 54, 63, 64, 54, 10, 11, 30,  2, 40,
    11, 63,  3, 70, 11, 13, 20, 20, 28, 43, 20, 50, 28, 73, 20,
     0, 45, 23, 37, 33, 46, 53, 37, 67, 46,  3, 54, 21, 63, 33,
    54, 55, 63, 64, 55,  9, 11, 31,  2, 39, 11, 62,  3, 69, 11,
    12, 20, 19, 28, 42, 20, 49, 28, 72, 20,  0, 46, 22, 37, 34,
    46, 52, 37, 68, 46,  2, 54, 22, 63, 32, 54, 56, 63, 65, 55,
     8, 11, 31,  3, 38, 11, 61,  3, 68, 11, 11, 20, 18, 28, 41,
    20, 48, 28, 71, 20,  1, 46, 21, 37, 35, 46, 51, 37, 69, 46,
     1, 54, 23, 63, 32, 55, 57, 63, 66, 55,  7, 11, 30,  3, 37,
    11, 60,  3, 67, 11, 10, 20, 17, 28, 40, 20, 48, 29, 70, 20,
     2, 46, 20, 37, 36, 46, 50, 37, 70, 46,  0, 54, 24, 63, 33,
    55, 58, 63, 67, 55,  6, 11, 29,  3, 36, 11, 59,  3, 66, 11,
     9, 20, 16, 28, 39, 20, 49, 29, 69, 20,  3, 46, 19, 37, 37,
    46, 49, 37, 71, 46,  0, 55, 25, 63, 34, 55, 59, 63, 68, 55,
     5, 11, 28,  3, 35, 11, 58,  3, 65, 11,  8, 20, 16, 29, 38,
    20, 50, 29, 68, 20,  4, 46, 18, 37, 38, 46, 48, 37, 72, 46,
     1, 55, 26, 63, 35, 55, 60, 63, 69, 55,  4, 11, 27,  3, 34,
    11, 57,  3, 64, 11,  7, 20, 17, 29, 37, 20, 51, 29, 67, 20,
     5, 46, 17, 37, 39, 46, 48, 38, 73, 46,  2, 55, 27, 63, 36,
    55, 61, 63, 70, 55,  3, 11, 26,  3, 33, 11, 56,  3, 64, 12,
     6, 20, 18, 29, 36, 20, 52, 29, 66, 20,  6, 46, 16, 37, 40,
    46, 49, 38, 74, 46,  3, 55, 28, 63, 37, 55, 62, 63, 71, 55,
     2, 11, 25,  3, 32, 11, 55,  3, 65, 12,  5, 20, 19, 29, 35,
    20, 53, 29, 65, 20,  7, 46, 16, 38, 41, 46, 50, 38, 75, 46,
     4, 55, 29, 63, 38, 55, 63, 63, 72, 55,  1, 11, 24,  3, 32,
    12, 54,  3, 66, 12,  4, 20, 20, 29, 34, 20, 54, 29, 64, 20,
     8, 46, 17, 38, 42, 46, 51, 38, 76, 46,  5, 55, 30, 63, 39,
    55, 63, 64, 73, 55,  0, 11, 23,  3, 33, 12, 53,  3, 67, 12,
     3, 20, 21, 29, 33, 20, 55, 29, 64, 21,  9, 46, 18, 38, 43,
    46, 52, 38, 77, 46,  6, 55, 31, 63, 40, 55, 62, 64, 74, 55,
     0, 12, 22,  3, 34, 12, 52,  3, 68, 12,  2, 20, 22, 29, 32,
    20, 56, 29, 65, 21, 10, 46, 19, 38, 44, 46, 53, 38, 78, 46,
     7, 55, 31, 64, 41, 55, 61, 64, 75, 55,  1, 12, 21,  3, 35,
    12, 51,  3, 69, 12,  1, 20, 23, 29, 32, 21, 57, 29, 66, 21,
    11, 46, 20, 38, 45, 46, 54, 38, 79, 46,  8, 55, 30, 64, 42,
    55, 60, 64, 76, 55,  2, 12, 20,  3, 36, 12, 50,  3, 70, 12,
     0, 20, 24, 29, 33, 21, 58, 29, 67, 21, 12, 46, 21, 38, 46,
    46, 55, 38, 79, 47,  9, 55, 29, 64, 43, 55, 59, 64, 77, 55,
     3, 12, 19,  3, 37, 12, 49,  3, 71, 12,  0, 21, 25, 29, 34,
    21, 59, 29, 68, 21, 13, 46, 22, 38, 47, 46, 56, 38, 78, 47,
    10, 55, 28, 64, 44, 55, 58, 64, 78, 55,  4, 12, 18,  3, 38,
    12, 48,  3, 72, 12,  1, 21, 26, 29, 35, 21, 60, 29, 69, 21,
    14, 46, 23, 38, 47, 47, 57, 38, 77, 47, 11, 55, 27, 64, 45,
    55, 57, 64, 79, 55,  5, 12, 17,  3, 39, 12, 48,  4, 73, 12,
     2, 21, 27, 29, 36, 21, 61, 29, 70, 21, 15, 46, 24, 38, 46,
    47, 58, 38, 76, 47, 12, 55, 26, 64, 46, 55, 56, 64, 79, 56,
     6, 12, 16,  3, 40, 12, 49,  4, 74, 12,  3, 21, 28, 29, 37,
    21, 62, 29, 71, 21, 15, 47, 25, 38, 45, 47, 59, 38, 75, 47,
    13, 55, 25, 64, 47, 55, 55, 64, 78, 56,  7, 12, 16,  4, 41,
    12, 50,  4, 75, 12,  4, 21, 29, 29, 38, 21, 63, 29, 72, 21,
    14, 47, 26, 38, 44, 47, 60, 38, 74, 47, 14, 55, 24, 64, 47,
    56, 54, 64, 77, 56,  8, 12, 17,  4, 42, 12, 51,  4, 76, 12,
     5, 21, 30, 29, 39, 21, 63, 30, 73, 21, 13, 47, 27, 38, 43,
    47, 61, 38, 73, 47, 15, 55, 23, 64, 46, 56, 53, 64, 76, 56,
     9, 12, 18,  4, 43, 12, 52,  4, 77, 12,  6, 21, 31, 29, 40,
    21, 62, 30, 74, 21, 12, 47, 28, 38, 42, 47, 62, 38, 72, 47,
    15, 56, 22, 64, 45, 56, 52, 64, 75, 56, 10, 12, 19,  4, 44,
    12, 53,  4, 78, 12,  7, 21, 31, 30, 41, 21, 61, 30, 75, 21,
    11, 47, 29, 38, 41, 47, 63, 38, 71, 47, 14, 56, 21, 64, 44,
    56, 51, 64, 74, 56, 11, 12, 20,  4, 45, 12, 54,  4, 79, 12,
     8, 21, 30, 30, 42, 21, 60, 30, 76, 21, 10, 47, 30, 38, 40,
    47, 63, 39, 70, 47, 13, 56, 20, 64, 43, 56, 50, 64, 73, 56,
    12, 12, 21,  4, 46, 12, 55,  4, 79, 13,  9, 21, 29, 30, 43,
    21, 59, 30, 77, 21,  9, 47, 31, 38, 39, 47, 62, 39, 69, 47,
    12, 56, 19, 64, 42, 56, 49, 64, 72, 56, 13, 12, 22,  4, 47,
    12, 56,  4, 78, 13, 10, 21, 28, 30, 44, 21, 58, 30, 78, 21,
     8, 47, 31, 39, 38, 47, 61, 39, 68, 47, 11, 56, 18, 64, 41,
    56, 48, 64, 71, 56, 14, 12, 23,  4, 47, 13, 57,  4, 77, 13,
    11, 21, 27, 30, 45, 21, 57, 30, 79, 21,  7, 47, 30, 39, 37,
    47, 60, 39, 67, 47, 10, 56, 17, 64, 40, 56, 48, 65, 70, 56,
    15, 12, 24,  4, 46, 13, 58,  4, 76, 13, 12, 21, 26, 30, 46,
    21, 56, 30, 79, 22,  6, 47, 29, 39, 36, 47, 59, 39, 66, 47,
     9, 56, 16, 64, 39, 56, 49, 65, 69, 56, 15, 13, 25,  4, 45,
    13, 59,  4, 75, 13, 13, 21, 25, 30, 47, 21, 55, 30, 78, 22,
     5, 47, 28, 39, 35, 47, 58, 39, 65, 47,  8, 56, 16, 65, 38,
    56, 50, 65, 68, 56, 14, 13, 26,  4, 44, 13, 60,  4, 74, 13,
    14, 21, 24, 30, 47, 22, 54, 30, 77, 22,  4, 47, 27, 39, 34,
    47, 57, 39, 64, 47,  7, 56, 17, 65, 37, 56, 51, 65, 67, 56,
    13, 13, 27,  4, 43, 13, 61,  4, 73, 13, 15, 21, 23, 30, 46,
    22, 53, 30, 76, 22,  3, 47, 26, 39, 33, 47, 56, 39, 64, 48,
     6, 56, 18, 65, 36, 56, 52, 65, 66, 56, 12, 13, 28,  4, 42,
    13, 62,  4, 72, 13, 15, 22, 22, 30, 45, 22, 52, 30, 75, 22,
     2, 47, 25, 39, 32, 47, 55, 39, 65, 48,  5, 56, 19, 65, 35,
    56, 53, 65, 65, 56, 11, 13, 29,  4, 41, 13, 63,  4, 71, 13,
    14, 22, 21, 30, 44, 22, 51, 30, 74, 22,  1, 47, 24, 39, 32,
    48, 54, 39, 66, 48,  4, 56, 20, 65, 34, 56, 54, 65, 64, 56,
    10, 13, 30,  4, 40, 13, 63,  5, 70, 13, 13, 22, 20, 30, 43,
    22, 50, 30, 73, 22,  0, 47, 23, 39, 33, 48, 53, 39, 67, 48,
     3, 56, 21, 65, 33, 56, 55, 65, 64, 57,  9, 13, 31,  4, 39,
    13, 62,  5, 69, 13, 12, 22, 19, 30, 42, 22, 49, 30, 72, 22,
     0, 48, 22, 39, 34, 48, 52, 39, 68, 48,  2, 56, 22, 65, 32,
    56, 56, 65, 65, 57,  8, 13, 31,  5, 38, 13, 61,  5, 68, 13,
    11, 22, 18, 30, 41, 22, 48, 30, 71, 22,  1, 48, 21, 39, 35,
    48, 51, 39, 69, 48,  1, 56, 23, 65, 32, 57, 57, 65, 66, 57,
     7, 13, 30,  5, 37, 13, 60,  5, 67, 13, 10, 22, 17, 30, 40,
    22, 48, 31, 70, 22,  2, 48, 20, 39, 36, 48, 50, 39, 70, 48,
     0, 56, 24, 65, 33, 57, 58, 65, 67, 57,  6, 13, 29,  5, 36,
    13, 59,  5, 66, 13,  9, 22, 16, 30, 39, 22, 49, 31, 69, 22,
     3, 48, 19, 39, 37, 48, 49, 39, 71, 48,  0, 57, 25, 65, 34,
    57, 59, 65, 68, 57,  5, 13, 28,  5, 35, 13, 58,  5, 65, 13,
     8, 22, 16, 31, 38, 22, 50, 31, 68, 22,  4, 48, 18, 39, 38,
    48, 48, 39, 72, 48,  1, 57, 26, 65, 35, 57, 60, 65, 69, 57,
     4, 13, 27,  5, 34, 13, 57,  5, 64, 13,  7, 22, 17, 31, 37,
    22, 51, 31, 67, 22,  5, 48, 17, 39, 39, 48, 48, 40, 73, 48,
     2, 57, 27, 65, 36, 57, 61, 65, 70, 57,  3, 13, 26,  5, 33,
    13, 56,  5, 64, 14,  6, 22, 18, 31, 36, 22, 52, 31, 66, 22,
     6, 48, 16, 39, 40, 48, 49, 40, 74, 48,  3, 57, 28, 65, 37,
    57, 62, 65, 71, 57,  2, 13, 25,  5, 32, 13, 55,  5, 65, 14,
     5, 22, 19, 31, 35, 22, 53, 31, 65, 22,  7, 48, 16, 40, 41,
    48, 50, 40, 75, 48,  4, 57, 29, 65, 38, 57, 63, 65, 72, 57,
     1, 13, 24,  5, 32, 14, 54,  5, 66, 14,  4, 22, 20, 31, 34,
    22, 54, 31, 64, 22,  8, 48, 17, 40, 42, 48, 51, 40, 76, 48,
     5, 57, 30, 65, 39, 57, 63, 66, 73, 57,  0, 13, 23,  5, 33,
    14, 53,  5, 67, 14,  3, 22, 21, 31, 33, 22, 55, 31, 64, 23,
     9, 48, 18, 40, 43, 48, 52, 40, 77, 48,  6, 57, 31, 65, 40,
    57, 62, 66, 74, 57,  0, 14, 22,  5, 34, 14, 52,  5, 68, 14,
     2, 22, 22, 31, 32, 22, 56, 31, 65, 23, 10, 48, 19, 40, 44,
    48, 53, 40, 78, 48,  7, 57, 31, 66, 41, 57, 61, 66, 75, 57,
     1, 14, 21,  5, 35, 14, 51,  5, 69, 14,  1, 22, 23, 31, 32,
    23, 57, 31, 66, 23, 11, 48, 20, 40, 45, 48, 54, 40, 79, 48,
     8, 57, 30, 66, 42, 57, 60, 66, 76, 57,  2, 14, 20,  5, 36,
    14, 50,  5, 70, 14,  0, 22, 24, 31, 33, 23, 58, 31, 67, 23,
    12, 48, 21, 40, 46, 48, 55, 40, 79, 49,  9, 57, 29, 66, 43,
    57, 59, 66, 77, 57,  3, 14, 19,  5, 37, 14, 49,  5, 71, 14,
     0, 23, 25, 31, 34, 23, 59, 31, 68, 23, 13, 48, 22, 40, 47,
    48, 56, 40, 78, 49, 10, 57, 28, 66, 44, 57, 58, 66, 78, 57,
     4, 14, 18,  5, 38, 14, 48,  5, 72, 14,  1, 23, 26, 31, 35,
    23, 60, 31, 69, 23, 14, 48, 23, 40, 47, 49, 57, 40, 77, 49,
    11, 57, 27, 66, 45, 57, 57, 66, 79, 57,  5, 14, 17,  5, 39,
    14, 48,  6, 73, 14,  2, 23, 27, 31, 36, 23, 61, 31, 70, 23,
    15, 48, 24, 40, 46, 49, 58, 40, 76, 49, 12, 57, 26, 66, 46,
    57, 56, 66, 79, 58,  6, 14, 16,  5, 40, 14, 49,  6, 74, 14,
     3, 23, 28, 31, 37, 23, 62, 31, 71, 23, 15, 49, 25, 40, 45,
    49, 59, 40, 75, 49, 13, 57, 25, 66, 47, 57, 55, 66, 78, 58,
     7, 14, 16,  6, 41, 14, 50,  6, 75, 14,  4, 23, 29, 31, 38,
    23, 63, 31, 72, 23, 14, 49, 26, 40, 44, 49, 60, 40, 74, 49,
    14, 57, 24, 66, 47, 58, 54, 66, 77, 58,  8, 14, 17,  6, 42,
    14, 51,  6, 76, 14,  5, 23, 30, 31, 39, 23, 63, 32, 73, 23,
    13, 49, 27, 40, 43, 49, 61, 40, 73, 49, 15, 57, 23, 66, 46,
    58, 53, 66, 76, 58,  9, 14, 18,  6, 43, 14, 52,  6, 77, 14,
     6, 23, 31, 31, 40, 23, 62, 32, 74, 23, 12, 49, 28, 40, 42,
    49, 62, 40, 72, 49, 15, 58, 22, 66, 45, 58, 52, 66, 75, 58,
    10, 14, 19,  6, 44, 14, 53,  6, 78, 14,  7, 23, 31, 32, 41,
    23, 61, 32, 75, 23, 11, 49, 29, 40, 41, 49, 63, 40, 71, 49,
    14, 58, 21, 66, 44, 58, 51, 66, 74, 58, 11, 14, 20,  6, 45,
    14, 54,  6, 79, 14,  8, 23, 30, 32, 42, 23, 60, 32, 76, 23,
    10, 49, 30, 40, 40, 49, 63, 41, 70, 49, 13, 58, 20, 66, 43,
    58, 50, 66, 73, 58, 12, 14, 21,  6, 46, 14, 55,  6, 79, 15,
     9, 23, 29, 32, 43, 23, 59, 32, 77, 23,  9, 49, 31, 40, 39,
    49, 62, 41, 69, 49, 12, 58, 19, 66, 42, 58, 49, 66, 72, 58,
    13, 14, 22,  6, 47, 14, 56,  6, 78, 15, 10, 23, 28, 32, 44,
    23, 58, 32, 78, 23,  8, 49, 31, 41, 38, 49, 61, 41, 68, 49,
    11, 58, 18, 66, 41, 58, 48, 66, 71, 58, 14, 14, 23,  6, 47,
    15, 57,  6, 77, 15, 11, 23, 27, 32, 45, 23, 57, 32, 79, 23,
     7, 49, 30, 41, 37, 49, 60, 41, 67, 49, 10, 58, 17, 66, 40,
    58, 48, 67, 70, 58, 15, 14, 24,  6, 46, 15, 58,  6, 76, 15,
    12, 23, 26, 32, 46, 23, 56, 32, 79, 24,  6, 49, 29, 41, 36,
    49, 59, 41, 66, 49,  9, 58, 16, 66, 39, 58, 49, 67, 69, 58,
    15, 15, 25,  6, 45, 15, 59,  6, 75, 15, 13, 23, 25, 32, 47,
    23, 55, 32, 78, 24,  5, 49, 28, 41, 35, 49, 58, 41, 65, 49,
     8, 58, 16, 67, 38, 58, 50, 67, 68, 58, 14, 15, 26,  6, 44,
    15, 60,  6, 74, 15, 14, 23, 24, 32, 47, 24, 54, 32, 77, 24,
     4, 49, 27, 41, 34, 49, 57, 41, 64, 49,  7, 58, 17, 67, 37,
    58, 51, 67, 67, 58, 13, 15, 27,  6, 43, 15, 61,  6, 73, 15,
    15, 23, 23, 32, 46, 24, 53, 32, 76, 24,  3, 49, 26, 41, 33,
    49, 56, 41, 64, 50,  6, 58, 18, 67, 36, 58, 52, 67, 66, 58,
    12, 15, 28,  6, 42, 15, 62,  6, 72, 15, 15, 24, 22, 32, 45,
    24, 52, 32, 75, 24,  2, 49, 25, 41, 32, 49, 55, 41, 65, 50,
     5, 58, 19, 67, 35, 58, 53, 67, 65, 58, 11, 15, 29,  6, 41,
    15, 63,  6, 71, 15, 14, 24, 21, 32, 44, 24, 51, 32, 74, 24,
     1, 49, 24, 41, 32, 50, 54, 41, 66, 50,  4, 58, 20, 67, 34,
    58, 54, 67, 64, 58, 10, 15, 30,  6, 40, 15, 63,  7, 70, 15,
    13, 24, 20, 32, 43, 24, 50, 32, 73, 24,  0, 49, 23, 41, 33,
    50, 53, 41, 67, 50,  3, 58, 21, 67, 33, 58, 55, 67, 64, 59,
     9, 15, 31,  6, 39, 15, 62,  7, 69, 15, 12, 24, 19, 32, 42,
    24, 49, 32, 72, 24,  0, 50, 22, 41, 34, 50, 52, 41, 68, 50,
     2, 58, 22, 67, 32, 58, 56, 67, 65, 59,  8, 15, 31,  7, 38,
    15, 61,  7, 68, 15, 11, 24, 18, 32, 41, 24, 48, 32, 71, 24,
     1, 50, 21, 41, 35, 50, 51, 41, 69, 50,  1, 58, 23, 67, 32,
    59, 57, 67, 66, 59,  7, 15, 30,  7, 37, 15, 60,  7, 67, 15,
    10, 24, 17, 32, 40, 24, 48, 33, 70, 24,  2, 50, 20, 41, 36,
    50, 50, 41, 70, 50,  0, 58, 24, 67, 33, 59, 58, 67, 67, 59,
     6, 15, 29,  7, 36, 15, 59,  7, 66, 15,  9, 24, 16, 32, 39,
    24, 49, 33, 69, 24,  3, 50, 19, 41, 37, 50, 49, 41, 71, 50,
     0, 59, 25, 67, 34, 59, 59, 67, 68, 59,  5, 15, 28,  7, 35,
    15, 58,  7, 65, 15,  8, 24, 16, 33, 38, 24, 50, 33, 68, 24,
     4, 50, 18, 41, 38, 50, 48, 41, 72, 50,  1, 59, 26, 67, 35,
    59, 60, 67, 69, 59,  4, 15, 27,  7, 34, 15, 57,  7, 64, 15,
     7, 24, 17, 33, 37, 24, 51, 33, 67, 24,  5, 50, 17, 41, 39,
    50, 48, 42, 73, 50,  2, 59, 27, 67, 36, 59, 61, 67, 70, 59,
     3, 15, 26,  7, 33, 15, 56,  7, 64, 16,  6, 24, 18, 33, 36,
    24, 52, 33, 66, 24,  6, 50, 16, 41, 40, 50, 49, 42, 74, 50,
     3, 59, 28, 67, 37, 59, 62, 67, 71, 59,  2, 15, 25,  7, 32,
    15, 55,  7, 65, 16,  5, 24, 19, 33, 35, 24, 53, 33, 65, 24,
     7, 50, 16, 42, 41, 50, 50, 42, 75, 50,  4, 59, 29, 67, 38,
    59, 63, 67, 72, 59,  1, 15, 24,  7, 32, 16, 54,  7, 66, 16,
     4, 24, 20, 33, 34, 24, 54, 33, 64, 24,  8, 50, 17, 42, 42,
    50, 51, 42, 76, 50,  5, 59, 30, 67, 39, 59, 48, 51, 73, 59,
     0, 15, 23,  7, 33, 16, 53,  7, 67, 16,  3, 24, 21, 33, 33,
    24, 55, 33, 64, 25,  9, 50, 18, 42, 43, 50, 52, 42, 77, 50,
     6, 59, 31, 67, 40, 59, 49, 51, 74, 59,  0, 16, 22,  7, 34,
    16, 52,  7, 68, 16,  2, 24, 22, 33, 32, 24, 56, 33, 65, 25,
    10, 50, 19, 42, 44, 50, 53, 42, 78, 50,  7, 59, 16, 51, 41,
    59, 50, 51, 75, 59,  1, 16, 21,  7, 35, 16, 51,  7, 69, 16,
     1, 24, 23, 33, 32, 25, 57, 33, 66, 25, 11, 50, 20, 42, 45,
    50, 54, 42, 79, 50,  8, 59, 17, 51, 42, 59, 51, 51, 76, 59,
     2, 16, 20,  7, 36, 16, 50,  7, 70, 16,  0, 24, 24, 33, 33,
    25, 58, 33, 67, 25, 12, 50, 21, 42, 46, 50, 55, 42, 64, 34,
     9, 59, 18, 51, 43, 59, 52, 51, 77, 59,  3, 16, 19,  7, 37,
    16, 49,  7, 71, 16,  0, 25, 25, 33, 34, 25, 59, 33, 68, 25,
    13, 50, 22, 42, 47, 50, 56, 42, 65, 34, 10, 59, 19, 51, 44,
    59, 53, 51, 78, 59,  4, 16, 18,  7, 38, 16, 48,  7, 72, 16,
     1, 25, 26, 33, 35, 25, 60, 33, 69, 25, 14, 50, 23, 42, 32,
    34, 57, 42, 66, 34, 11, 59, 20, 51, 45, 59, 54, 51, 79, 59,
     5, 16, 17,  7, 39, 16, 48,  8, 73, 16,  2, 25, 27, 33, 36,
    25, 61, 33, 70, 25, 15, 50, 24, 42, 33, 34, 58, 42, 67, 34,
    12, 59, 21, 51, 46, 59, 55, 51, 79, 60,  6, 16, 16,  7, 40,
    16, 49,  8, 74, 16,  3, 25, 28, 33, 37, 25, 62, 33, 71, 25,
     0, 34, 25, 42, 34, 34, 59, 42, 68, 34, 13, 59, 22, 51, 47,
    59, 56, 51, 78, 60,  7, 16, 16,  8, 41, 16, 50,  8, 75, 16,
     4, 25, 29, 33, 38, 25, 63, 33, 72, 25,  1, 34, 26, 42, 35,
    34, 60, 42, 69, 34, 14, 59, 23, 51, 47, 60, 57, 51, 77, 60,
     8, 16, 17,  8, 42, 16, 51,  8, 76, 16,  5, 25, 30, 33, 39,
    25, 48, 17, 73, 25,  2, 34, 27, 42, 36, 34, 61, 42, 70, 34,
    15, 59, 24, 51, 46, 60, 58, 51, 76, 60,  9, 16, 18,  8, 43,
    16, 52,  8, 77, 16,  6, 25, 31, 33, 40, 25, 49, 17, 74, 25,
     3, 34, 28, 42, 37, 34, 62, 42, 71, 34, 15, 60, 25, 51, 45,
    60, 59, 51, 75, 60, 10, 16, 19,  8, 44, 16, 53,  8, 78, 16,
     7, 25, 16, 17, 41, 25, 50, 17, 75, 25,  4, 34, 29, 42, 38,
    34, 63, 42, 72, 34, 14, 60, 26, 51, 44, 60, 60, 51, 74, 60,
    11, 16, 20,  8, 45, 16, 54,  8, 79, 16,  8, 25, 17, 17, 42,
    25, 51, 17, 76, 25,  5, 34, 30, 42, 39, 34, 63, 43, 73, 34,
    13, 60, 27, 51, 43, 60, 61, 51, 73, 60, 12, 16, 21,  8, 46,
    16, 55,  8, 64,  0,  9, 25, 18, 17, 43, 25, 52, 17, 77, 25,
     6, 34, 31, 42, 40, 34, 62, 43, 74, 34, 12, 60, 28, 51, 42,
    60, 62, 51, 72, 60, 13, 16, 22,  8, 47, 16, 56,  8, 65,  0,
    10, 25, 19, 17, 44, 25, 53, 17, 78, 25,  7, 34, 31, 43, 41,
    34, 61, 43, 75, 34, 11, 60, 29, 51, 41, 60, 63, 51, 71, 60,
    14, 16, 23,  8, 32,  0, 57,  8, 66,  0, 11, 25, 20, 17, 45,
    25, 54, 17, 79, 25,  8, 34, 30, 43, 42, 34, 60, 43, 76, 34,
    10, 60, 30, 51, 40, 60, 63, 52, 70, 60, 15, 16, 24,  8, 33,
     0, 58,  8, 67,  0, 12, 25, 21, 17, 46, 25, 55, 17, 79, 26,
     9, 34, 29, 43, 43, 34, 59, 43, 77, 34,  9, 60, 31, 51, 39,
    60, 62, 52, 69, 60,
};

static const uint8_t hq_tab_07[] = {
     0,  0, 23,  8, 32,  0, 55,  8, 64,  0, 87,  8, 13, 25, 22,
    17, 44, 26, 54, 17, 72, 26, 86, 17, 12, 34, 24, 43, 44, 34,
    52, 43, 73, 35, 80, 43,  4, 60, 25, 52, 32, 60, 53, 52, 60,
    60, 81, 52,  1,  0, 24,  8, 33,  0, 56,  8, 65,  0, 88,  8,
    14, 25, 23, 17, 43, 26, 55, 17, 71, 26, 87, 17, 13, 34, 23,
    43, 44, 35, 51, 43, 72, 35, 79, 43,  3, 60, 24, 52, 31, 60,
    52, 52, 60, 61, 80, 52,  2,  0, 25,  8, 34,  0, 57,  8, 66,
     0, 89,  8, 14, 26, 24, 17, 42, 26, 56, 17, 70, 26, 88, 17,
    14, 34, 22, 43, 43, 35, 50, 43, 71, 35, 78, 43,  2, 60, 23,
    52, 30, 60, 51, 52, 61, 61, 79, 52,  3,  0, 26,  8, 35,  0,
    58,  8, 67,  0, 89,  9, 13, 26, 25, 17, 41, 26, 57, 17, 69,
    26, 89, 17, 14, 35, 21, 43, 42, 35, 49, 43, 70, 35, 77, 43,
     1, 60, 22, 52, 30, 61, 50, 52, 62, 61, 78, 52,  4,  0, 27,
     8, 36,  0, 59,  8, 68,  0, 88,  9, 12, 26, 26, 17, 40, 26,
    58, 17, 68, 26, 89, 18, 13, 35, 20, 43, 41, 35, 48, 43, 69,
    35, 76, 43,  0, 60, 21, 52, 31, 61, 49, 52, 63, 61, 77, 52,
     5,  0, 28,  8, 37,  0, 59,  9, 69,  0, 87,  9, 11, 26, 27,
    17, 39, 26, 59, 17, 67, 26, 88, 18, 12, 35, 19, 43, 40, 35,
    47, 43, 68, 35, 75, 43,  0, 61, 20, 52, 32, 61, 48, 52, 64,
    61, 76, 52,  6,  0, 29,  8, 38,  0, 58,  9, 70,  0, 86,  9,
    10, 26, 28, 17, 38, 26, 59, 18, 66, 26, 87, 18, 11, 35, 18,
    43, 39, 35, 46, 43, 67, 35, 75, 44,  1, 61, 19, 52, 33, 61,
    47, 52, 65, 61, 75, 52,  7,  0, 29,  9, 39,  0, 57,  9, 71,
     0, 85,  9,  9, 26, 29, 17, 37, 26, 58, 18, 65, 26, 86, 18,
    10, 35, 17, 43, 38, 35, 45, 43, 66, 35, 76, 44,  2, 61, 18,
    52, 34, 61, 46, 52, 66, 61, 75, 53,  8,  0, 28,  9, 40,  0,
    56,  9, 72,  0, 84,  9,  8, 26, 29, 18, 36, 26, 57, 18, 64,
    26, 85, 18,  9, 35, 16, 43, 37, 35, 45, 44, 65, 35, 77, 44,
     3, 61, 17, 52, 35, 61, 45, 52, 67, 61, 76, 53,  9,  0, 27,
     9, 41,  0, 55,  9, 73,  0, 83,  9,  7, 26, 28, 18, 35, 26,
    56, 18, 63, 26, 84, 18,  8, 35, 15, 43, 36, 35, 46, 44, 64,
    35, 78, 44,  4, 61, 16, 52, 36, 61, 45, 53, 68, 61, 77, 53,
    10,  0, 26,  9, 42,  0, 54,  9, 74,  0, 82,  9,  6, 26, 27,
    18, 34, 26, 55, 18, 62, 26, 83, 18,  7, 35, 15, 44, 35, 35,
    47, 44, 63, 35, 79, 44,  5, 61, 15, 52, 37, 61, 46, 53, 69,
    61, 78, 53, 11,  0, 25,  9, 43,  0, 53,  9, 74,  1, 81,  9,
     5, 26, 26, 18, 33, 26, 54, 18, 61, 26, 82, 18,  6, 35, 16,
    44, 34, 35, 48, 44, 62, 35, 80, 44,  6, 61, 15, 53, 38, 61,
    47, 53, 70, 61, 79, 53, 12,  0, 24,  9, 44,  0, 52,  9, 73,
     1, 80,  9,  4, 26, 25, 18, 32, 26, 53, 18, 60, 26, 81, 18,
     5, 35, 17, 44, 33, 35, 49, 44, 61, 35, 81, 44,  7, 61, 16,
    53, 39, 61, 48, 53, 71, 61, 80, 53, 13,  0, 23,  9, 44,  1,
    51,  9, 72,  1, 79,  9,  3, 26, 24, 18, 31, 26, 52, 18, 60,
    27, 80, 18,  4, 35, 18, 44, 32, 35, 50, 44, 60, 35, 82, 44,
     8, 61, 17, 53, 40, 61, 49, 53, 72, 61, 81, 53, 14,  0, 22,
     9, 43,  1, 50,  9, 71,  1, 78,  9,  2, 26, 23, 18, 30, 26,
    51, 18, 61, 27, 79, 18,  3, 35, 19, 44, 31, 35, 51, 44, 60,
    36, 83, 44,  9, 61, 18, 53, 41, 61, 50, 53, 73, 61, 82, 53,
    14,  1, 21,  9, 42,  1, 49,  9, 70,  1, 77,  9,  1, 26, 22,
    18, 30, 27, 50, 18, 62, 27, 78, 18,  2, 35, 20, 44, 30, 35,
    52, 44, 61, 36, 84, 44, 10, 61, 19, 53, 42, 61, 51, 53, 74,
    61, 83, 53, 13,  1, 20,  9, 41,  1, 48,  9, 69,  1, 76,  9,
     0, 26, 21, 18, 31, 27, 49, 18, 63, 27, 77, 18,  1, 35, 21,
    44, 30, 36, 53, 44, 62, 36, 85, 44, 11, 61, 20, 53, 43, 61,
    52, 53, 74, 62, 84, 53, 12,  1, 19,  9, 40,  1, 47,  9, 68,
     1, 75,  9,  0, 27, 20, 18, 32, 27, 48, 18, 64, 27, 76, 18,
     0, 35, 22, 44, 31, 36, 54, 44, 63, 36, 86, 44, 12, 61, 21,
    53, 44, 61, 53, 53, 73, 62, 85, 53, 11,  1, 18,  9, 39,  1,
    46,  9, 67,  1, 75, 10,  1, 27, 19, 18, 33, 27, 47, 18, 65,
    27, 75, 18,  0, 36, 23, 44, 32, 36, 55, 44, 64, 36, 87, 44,
    13, 61, 22, 53, 44, 62, 54, 53, 72, 62, 86, 53, 10,  1, 17,
     9, 38,  1, 45,  9, 66,  1, 76, 10,  2, 27, 18, 18, 34, 27,
    46, 18, 66, 27, 75, 19,  1, 36, 24, 44, 33, 36, 56, 44, 65,
    36, 88, 44, 14, 61, 23, 53, 43, 62, 55, 53, 71, 62, 87, 53,
     9,  1, 16,  9, 37,  1, 45, 10, 65,  1, 77, 10,  3, 27, 17,
    18, 35, 27, 45, 18, 67, 27, 76, 19,  2, 36, 25, 44, 34, 36,
    57, 44, 66, 36, 89, 44, 14, 62, 24, 53, 42, 62, 56, 53, 70,
    62, 88, 53,  8,  1, 15,  9, 36,  1, 46, 10, 64,  1, 78, 10,
     4, 27, 16, 18, 36, 27, 45, 19, 68, 27, 77, 19,  3, 36, 26,
    44, 35, 36, 58, 44, 67, 36, 89, 45, 13, 62, 25, 53, 41, 62,
    57, 53, 69, 62, 89, 53,  7,  1, 15, 10, 35,  1, 47, 10, 63,
     1, 79, 10,  5, 27, 15, 18, 37, 27, 46, 19, 69, 27, 78, 19,
     4, 36, 27, 44, 36, 36, 59, 44, 68, 36, 88, 45, 12, 62, 26,
    53, 40, 62, 58, 53, 68, 62, 89, 54,  6,  1, 16, 10, 34,  1,
    48, 10, 62,  1, 80, 10,  6, 27, 15, 19, 38, 27, 47, 19, 70,
    27, 79, 19,  5, 36, 28, 44, 37, 36, 59, 45, 69, 36, 87, 45,
    11, 62, 27, 53, 39, 62, 59, 53, 67, 62, 88, 54,  5,  1, 17,
    10, 33,  1, 49, 10, 61,  1, 81, 10,  7, 27, 16, 19, 39, 27,
    48, 19, 71, 27, 80, 19,  6, 36, 29, 44, 38, 36, 58, 45, 70,
    36, 86, 45, 10, 62, 28, 53, 38, 62, 59, 54, 66, 62, 87, 54,
     4,  1, 18, 10, 32,  1, 50, 10, 60,  1, 82, 10,  8, 27, 17,
    19, 40, 27, 49, 19, 72, 27, 81, 19,  7, 36, 29, 45, 39, 36,
    57, 45, 71, 36, 85, 45,  9, 62, 29, 53, 37, 62, 58, 54, 65,
    62, 86, 54,  3,  1, 19, 10, 31,  1, 51, 10, 60,  2, 83, 10,
     9, 27, 18, 19, 41, 27, 50, 19, 73, 27, 82, 19,  8, 36, 28,
    45, 40, 36, 56, 45, 72, 36, 84, 45,  8, 62, 29, 54, 36, 62,
    57, 54, 64, 62, 85, 54,  2,  1, 20, 10, 30,  1, 52, 10, 61,
     2, 84, 10, 10, 27, 19, 19, 42, 27, 51, 19, 74, 27, 83, 19,
     9, 36, 27, 45, 41, 36, 55, 45, 73, 36, 83, 45,  7, 62, 28,
    54, 35, 62, 56, 54, 63, 62, 84, 54,  1,  1, 21, 10, 30,  2,
    53, 10, 62,  2, 85, 10, 11, 27, 20, 19, 43, 27, 52, 19, 74,
    28, 84, 19, 10, 36, 26, 45, 42, 36, 54, 45, 74, 36, 82, 45,
     6, 62, 27, 54, 34, 62, 55, 54, 62, 62, 83, 54,  0,  1, 22,
    10, 31,  2, 54, 10, 63,  2, 86, 10, 12, 27, 21, 19, 44, 27,
    53, 19, 73, 28, 85, 19, 11, 36, 25, 45, 43, 36, 53, 45, 74,
    37, 81, 45,  5, 62, 26, 54, 33, 62, 54, 54, 61, 62, 82, 54,
     0,  2, 23, 10, 32,  2, 55, 10, 64,  2, 87, 10, 13, 27, 22,
    19, 44, 28, 54, 19, 72, 28, 86, 19, 12, 36, 24, 45, 44, 36,
    52, 45, 73, 37, 80, 45,  4, 62, 25, 54, 32, 62, 53, 54, 60,
    62, 81, 54,  1,  2, 24, 10, 33,  2, 56, 10, 65,  2, 88, 10,
    14, 27, 23, 19, 43, 28, 55, 19, 71, 28, 87, 19, 13, 36, 23,
    45, 44, 37, 51, 45, 72, 37, 79, 45,  3, 62, 24, 54, 31, 62,
    52, 54, 60, 63, 80, 54,  2,  2, 25, 10, 34,  2, 57, 10, 66,
     2, 89, 10, 14, 28, 24, 19, 42, 28, 56, 19, 70, 28, 88, 19,
    14, 36, 22, 45, 43, 37, 50, 45, 71, 37, 78, 45,  2, 62, 23,
    54, 30, 62, 51, 54, 61, 63, 79, 54,  3,  2, 26, 10, 35,  2,
    58, 10, 67,  2, 89, 11, 13, 28, 25, 19, 41, 28, 57, 19, 69,
    28, 89, 19, 14, 37, 21, 45, 42, 37, 49, 45, 70, 37, 77, 45,
     1, 62, 22, 54, 30, 63, 50, 54, 62, 63, 78, 54,  4,  2, 27,
    10, 36,  2, 59, 10, 68,  2, 88, 11, 12, 28, 26, 19, 40, 28,
    58, 19, 68, 28, 89, 20, 13, 37, 20, 45, 41, 37, 48, 45, 69,
    37, 76, 45,  0, 62, 21, 54, 31, 63, 49, 54, 63, 63, 77, 54,
     5,  2, 28, 10, 37,  2, 59, 11, 69,  2, 87, 11, 11, 28, 27,
    19, 39, 28, 59, 19, 67, 28, 88, 20, 12, 37, 19, 45, 40, 37,
    47, 45, 68, 37, 75, 45,  0, 63, 20, 54, 32, 63, 48, 54, 64,
    63, 76, 54,  6,  2, 29, 10, 38,  2, 58, 11, 70,  2, 86, 11,
    10, 28, 28, 19, 38, 28, 59, 20, 66, 28, 87, 20, 11, 37, 18,
    45, 39, 37, 46, 45, 67, 37, 75, 46,  1, 63, 19, 54, 33, 63,
    47, 54, 65, 63, 75, 54,  7,  2, 29, 11, 39,  2, 57, 11, 71,
     2, 85, 11,  9, 28, 29, 19, 37, 28, 58, 20, 65, 28, 86, 20,
    10, 37, 17, 45, 38, 37, 45, 45, 66, 37, 76, 46,  2, 63, 18,
    54, 34, 63, 46, 54, 66, 63, 75, 55,  8,  2, 28, 11, 40,  2,
    56, 11, 72,  2, 84, 11,  8, 28, 29, 20, 36, 28, 57, 20, 64,
    28, 85, 20,  9, 37, 16, 45, 37, 37, 45, 46, 65, 37, 77, 46,
     3, 63, 17, 54, 35, 63, 45, 54, 67, 63, 76, 55,  9,  2, 27,
    11, 41,  2, 55, 11, 73,  2, 83, 11,  7, 28, 28, 20, 35, 28,
    56, 20, 63, 28, 84, 20,  8, 37, 15, 45, 36, 37, 46, 46, 64,
    37, 78, 46,  4, 63, 16, 54, 36, 63, 45, 55, 68, 63, 77, 55,
    10,  2, 26, 11, 42,  2, 54, 11, 74,  2, 82, 11,  6, 28, 27,
    20, 34, 28, 55, 20, 62, 28, 83, 20,  7, 37, 15, 46, 35, 37,
    47, 46, 63, 37, 79, 46,  5, 63, 15, 54, 37, 63, 46, 55, 69,
    63, 78, 55, 11,  2, 25, 11, 43,  2, 53, 11, 74,  3, 81, 11,
     5, 28, 26, 20, 33, 28, 54, 20, 61, 28, 82, 20,  6, 37, 16,
    46, 34, 37, 48, 46, 62, 37, 80, 46,  6, 63, 15, 55, 38, 63,
    47, 55, 70, 63, 79, 55, 12,  2, 24, 11, 44,  2, 52, 11, 73,
     3, 80, 11,  4, 28, 25, 20, 32, 28, 53, 20, 60, 28, 81, 20,
     5, 37, 17, 46, 33, 37, 49, 46, 61, 37, 81, 46,  7, 63, 16,
    55, 39, 63, 48, 55, 71, 63, 80, 55, 13,  2, 23, 11, 44,  3,
    51, 11, 72,  3, 79, 11,  3, 28, 24, 20, 31, 28, 52, 20, 60,
    29, 80, 20,  4, 37, 18, 46, 32, 37, 50, 46, 60, 37, 82, 46,
     8, 63, 17, 55, 40, 63, 49, 55, 72, 63, 81, 55, 14,  2, 22,
    11, 43,  3, 50, 11, 71,  3, 78, 11,  2, 28, 23, 20, 30, 28,
    51, 20, 61, 29, 79, 20,  3, 37, 19, 46, 31, 37, 51, 46, 60,
    38, 83, 46,  9, 63, 18, 55, 41, 63, 50, 55, 73, 63, 82, 55,
    14,  3, 21, 11, 42,  3, 49, 11, 70,  3, 77, 11,  1, 28, 22,
    20, 30, 29, 50, 20, 62, 29, 78, 20,  2, 37, 20, 46, 30, 37,
    52, 46, 61, 38, 84, 46, 10, 63, 19, 55, 42, 63, 51, 55, 74,
    63, 83, 55, 13,  3, 20, 11, 41,  3, 48, 11, 69,  3, 76, 11,
     0, 28, 21, 20, 31, 29, 49, 20, 63, 29, 77, 20,  1, 37, 21,
    46, 30, 38, 53, 46, 62, 38, 85, 46, 11, 63, 20, 55, 43, 63,
    52, 55, 74, 64, 84, 55, 12,  3, 19, 11, 40,  3, 47, 11, 68,
     3, 75, 11,  0, 29, 20, 20, 32, 29, 48, 20, 64, 29, 76, 20,
     0, 37, 22, 46, 31, 38, 54, 46, 63, 38, 86, 46, 12, 63, 21,
    55, 44, 63, 53, 55, 73, 64, 85, 55, 11,  3, 18, 11, 39,  3,
    46, 11, 67,  3, 75, 12,  1, 29, 19, 20, 33, 29, 47, 20, 65,
    29, 75, 20,  0, 38, 23, 46, 32, 38, 55, 46, 64, 38, 87, 46,
    13, 63, 22, 55, 44, 64, 54, 55, 72, 64, 86, 55, 10,  3, 17,
    11, 38,  3, 45, 11, 66,  3, 76, 12,  2, 29, 18, 20, 34, 29,
    46, 20, 66, 29, 75, 21,  1, 38, 24, 46, 33, 38, 56, 46, 65,
    38, 88, 46, 14, 63, 23, 55, 43, 64, 55, 55, 71, 64, 87, 55,
     9,  3, 16, 11, 37,  3, 45, 12, 65,  3, 77, 12,  3, 29, 17,
    20, 35, 29, 45, 20, 67, 29, 76, 21,  2, 38, 25, 46, 34, 38,
    57, 46, 66, 38, 89, 46, 14, 64, 24, 55, 42, 64, 56, 55, 70,
    64, 88, 55,  8,  3, 15, 11, 36,  3, 46, 12, 64,  3, 78, 12,
     4, 29, 16, 20, 36, 29, 45, 21, 68, 29, 77, 21,  3, 38, 26,
    46, 35, 38, 58, 46, 67, 38, 89, 47, 13, 64, 25, 55, 41, 64,
    57, 55, 69, 64, 89, 55,  7,  3, 15, 12, 35,  3, 47, 12, 63,
     3, 79, 12,  5, 29, 15, 20, 37, 29, 46, 21, 69, 29, 78, 21,
     4, 38, 27, 46, 36, 38, 59, 46, 68, 38, 88, 47, 12, 64, 26,
    55, 40, 64, 58, 55, 68, 64, 89, 56,  6,  3, 16, 12, 34,  3,
    48, 12, 62,  3, 80, 12,  6, 29, 15, 21, 38, 29, 47, 21, 70,
    29, 79, 21,  5, 38, 28, 46, 37, 38, 59, 47, 69, 38, 87, 47,
    11, 64, 27, 55, 39, 64, 59, 55, 67, 64, 88, 56,  5,  3, 17,
    12, 33,  3, 49, 12, 61,  3, 81, 12,  7, 29, 16, 21, 39, 29,
    48, 21, 71, 29, 80, 21,  6, 38, 29, 46, 38, 38, 58, 47, 70,
    38, 86, 47, 10, 64, 28, 55, 38, 64, 59, 56, 66, 64, 87, 56,
     4,  3, 18, 12, 32,  3, 50, 12, 60,  3, 82, 12,  8, 29, 17,
    21, 40, 29, 49, 21, 72, 29, 81, 21,  7, 38, 29, 47, 39, 38,
    57, 47, 71, 38, 85, 47,  9, 64, 29, 55, 37, 64, 58, 56, 65,
    64, 86, 56,  3,  3, 19, 12, 31,  3, 51, 12, 60,  4, 83, 12,
     9, 29, 18, 21, 41, 29, 50, 21, 73, 29, 82, 21,  8, 38, 28,
    47, 40, 38, 56, 47, 72, 38, 84, 47,  8, 64, 29, 56, 36, 64,
    57, 56, 64, 64, 85, 56,  2,  3, 20, 12, 30,  3, 52, 12, 61,
     4, 84, 12, 10, 29, 19, 21, 42, 29, 51, 21, 74, 29, 83, 21,
     9, 38, 27, 47, 41, 38, 55, 47, 73, 38, 83, 47,  7, 64, 28,
    56, 35, 64, 56, 56, 63, 64, 84, 56,  1,  3, 21, 12, 30,  4,
    53, 12, 62,  4, 85, 12, 11, 29, 20, 21, 43, 29, 52, 21, 74,
    30, 84, 21, 10, 38, 26, 47, 42, 38, 54, 47, 74, 38, 82, 47,
     6, 64, 27, 56, 34, 64, 55, 56, 62, 64, 83, 56,  0,  3, 22,
    12, 31,  4, 54, 12, 63,  4, 86, 12, 12, 29, 21, 21, 44, 29,
    53, 21, 73, 30, 85, 21, 11, 38, 25, 47, 43, 38, 53, 47, 74,
    39, 81, 47,  5, 64, 26, 56, 33, 64, 54, 56, 61, 64, 82, 56,
     0,  4, 23, 12, 32,  4, 55, 12, 64,  4, 87, 12, 13, 29, 22,
    21, 44, 30, 54, 21, 72, 30, 86, 21, 12, 38, 24, 47, 44, 38,
    52, 47, 73, 39, 80, 47,  4, 64, 25, 56, 32, 64, 53, 56, 60,
    64, 81, 56,  1,  4, 24, 12, 33,  4, 56, 12, 65,  4, 88, 12,
    14, 29, 23, 21, 43, 30, 55, 21, 71, 30, 87, 21, 13, 38, 23,
    47, 44, 39, 51, 47, 72, 39, 79, 47,  3, 64, 24, 56, 31, 64,
    52, 56, 60, 65, 80, 56,  2,  4, 25, 12, 34,  4, 57, 12, 66,
     4, 89, 12, 14, 30, 24, 21, 42, 30, 56, 21, 70, 30, 88, 21,
    14, 38, 22, 47, 43, 39, 50, 47, 71, 39, 78, 47,  2, 64, 23,
    56, 30, 64, 51, 56, 61, 65, 79, 56,  3,  4, 26, 12, 35,  4,
    58, 12, 67,  4, 89, 13, 13, 30, 25, 21, 41, 30, 57, 21, 69,
    30, 89, 21, 14, 39, 21, 47, 42, 39, 49, 47, 70, 39, 77, 47,
     1, 64, 22, 56, 30, 65, 50, 56, 62, 65, 78, 56,  4,  4, 27,
    12, 36,  4, 59, 12, 68,  4, 88, 13, 12, 30, 26, 21, 40, 30,
    58, 21, 68, 30, 89, 22, 13, 39, 20, 47, 41, 39, 48, 47, 69,
    39, 76, 47,  0, 64, 21, 56, 31, 65, 49, 56, 63, 65, 77, 56,
     5,  4, 28, 12, 37,  4, 59, 13, 69,  4, 87, 13, 11, 30, 27,
    21, 39, 30, 59, 21, 67, 30, 88, 22, 12, 39, 19, 47, 40, 39,
    47, 47, 68, 39, 75, 47,  0, 65, 20, 56, 32, 65, 48, 56, 64,
    65, 76, 56,  6,  4, 29, 12, 38,  4, 58, 13, 70,  4, 86, 13,
    10, 30, 28, 21, 38, 30, 59, 22, 66, 30, 87, 22, 11, 39, 18,
    47, 39, 39, 46, 47, 67, 39, 75, 48,  1, 65, 19, 56, 33, 65,
    47, 56, 65, 65, 75, 56,  7,  4, 29, 13, 39,  4, 57, 13, 71,
     4, 85, 13,  9, 30, 29, 21, 37, 30, 58, 22, 65, 30, 86, 22,
    10, 39, 17, 47, 38, 39, 45, 47, 66, 39, 76, 48,  2, 65, 18,
    56, 34, 65, 46, 56, 66, 65, 75, 57,  8,  4, 28, 13, 40,  4,
    56, 13, 72,  4, 84, 13,  8, 30, 29, 22, 36, 30, 57, 22, 64,
    30, 85, 22,  9, 39, 16, 47, 37, 39, 45, 48, 65, 39, 77, 48,
     3, 65, 17, 56, 35, 65, 45, 56, 67, 65, 76, 57,  9,  4, 27,
    13, 41,  4, 55, 13, 73,  4, 83, 13,  7, 30, 28, 22, 35, 30,
    56, 22, 63, 30, 84, 22,  8, 39, 15, 47, 36, 39, 46, 48, 64,
    39, 78, 48,  4, 65, 16, 56, 36, 65, 45, 57, 68, 65, 77, 57,
    10,  4, 26, 13, 42,  4, 54, 13, 74,  4, 82, 13,  6, 30, 27,
    22, 34, 30, 55, 22, 62, 30, 83, 22,  7, 39, 15, 48, 35, 39,
    47, 48, 63, 39, 79, 48,  5, 65, 15, 56, 37, 65, 46, 57, 69,
    65, 78, 57, 11,  4, 25, 13, 43,  4, 53, 13, 74,  5, 81, 13,
     5, 30, 26, 22, 33, 30, 54, 22, 61, 30, 82, 22,  6, 39, 16,
    48, 34, 39, 48, 48, 62, 39, 80, 48,  6, 65, 15, 57, 38, 65,
    47, 57, 70, 65, 79, 57, 12,  4, 24, 13, 44,  4, 52, 13, 73,
     5, 80, 13,  4, 30, 25, 22, 32, 30, 53, 22, 60, 30, 81, 22,
     5, 39, 17, 48, 33, 39, 49, 48, 61, 39, 81, 48,  7, 65, 16,
    57, 39, 65, 48, 57, 71, 65, 80, 57, 13,  4, 23, 13, 44,  5,
    51, 13, 72,  5, 79, 13,  3, 30, 24, 22, 31, 30, 52, 22, 60,
    31, 80, 22,  4, 39, 18, 48, 32, 39, 50, 48, 60, 39, 82, 48,
     8, 65, 17, 57, 40, 65, 49, 57, 72, 65, 81, 57, 14,  4, 22,
    13, 43,  5, 50, 13, 71,  5, 78, 13,  2, 30, 23, 22, 30, 30,
    51, 22, 61, 31, 79, 22,  3, 39, 19, 48, 31, 39, 51, 48, 60,
    40, 83, 48,  9, 65, 18, 57, 41, 65, 50, 57, 73, 65, 82, 57,
    14,  5, 21, 13, 42,  5, 49, 13, 70,  5, 77, 13,  1, 30, 22,
    22, 30, 31, 50, 22, 62, 31, 78, 22,  2, 39, 20, 48, 30, 39,
    52, 48, 61, 40, 84, 48, 10, 65, 19, 57, 42, 65, 51, 57, 74,
    65, 83, 57, 13,  5, 20, 13, 41,  5, 48, 13, 69,  5, 76, 13,
     0, 30, 21, 22, 31, 31, 49, 22, 63, 31, 77, 22,  1, 39, 21,
    48, 30, 40, 53, 48, 62, 40, 85, 48, 11, 65, 20, 57, 43, 65,
    52, 57, 74, 66, 84, 57, 12,  5, 19, 13, 40,  5, 47, 13, 68,
     5, 75, 13,  0, 31, 20, 22, 32, 31, 48, 22, 64, 31, 76, 22,
     0, 39, 22, 48, 31, 40, 54, 48, 63, 40, 86, 48, 12, 65, 21,
    57, 44, 65, 53, 57, 73, 66, 85, 57, 11,  5, 18, 13, 39,  5,
    46, 13, 67,  5, 75, 14,  1, 31, 19, 22, 33, 31, 47, 22, 65,
    31, 75, 22,  0, 40, 23, 48, 32, 40, 55, 48, 64, 40, 87, 48,
    13, 65, 22, 57, 44, 66, 54, 57, 72, 66, 86, 57, 10,  5, 17,
    13, 38,  5, 45, 13, 66,  5, 76, 14,  2, 31, 18, 22, 34, 31,
    46, 22, 66, 31, 75, 23,  1, 40, 24, 48, 33, 40, 56, 48, 65,
    40, 88, 48, 14, 65, 23, 57, 43, 66, 55, 57, 71, 66, 87, 57,
     9,  5, 16, 13, 37,  5, 45, 14, 65,  5, 77, 14,  3, 31, 17,
    22, 35, 31, 45, 22, 67, 31, 76, 23,  2, 40, 25, 48, 34, 40,
    57, 48, 66, 40, 89, 48, 14, 66, 24, 57, 42, 66, 56, 57, 70,
    66, 88, 57,  8,  5, 15, 13, 36,  5, 46, 14, 64,  5, 78, 14,
     4, 31, 16, 22, 36, 31, 45, 23, 68, 31, 77, 23,  3, 40, 26,
    48, 35, 40, 58, 48, 67, 40, 89, 49, 13, 66, 25, 57, 41, 66,
    57, 57, 69, 66, 89, 57,  7,  5, 15, 14, 35,  5, 47, 14, 63,
     5, 79, 14,  5, 31, 15, 22, 37, 31, 46, 23, 69, 31, 78, 23,
     4, 40, 27, 48, 36, 40, 59, 48, 68, 40, 88, 49, 12, 66, 26,
    57, 40, 66, 58, 57, 68, 66, 89, 58,  6,  5, 16, 14, 34,  5,
    48, 14, 62,  5, 80, 14,  6, 31, 15, 23, 38, 31, 47, 23, 70,
    31, 79, 23,  5, 40, 28, 48, 37, 40, 59, 49, 69, 40, 87, 49,
    11, 66, 27, 57, 39, 66, 59, 57, 67, 66, 88, 58,  5,  5, 17,
    14, 33,  5, 49, 14, 61,  5, 81, 14,  7, 31, 16, 23, 39, 31,
    48, 23, 71, 31, 80, 23,  6, 40, 29, 48, 38, 40, 58, 49, 70,
    40, 86, 49, 10, 66, 28, 57, 38, 66, 59, 58, 66, 66, 87, 58,
     4,  5, 18, 14, 32,  5, 50, 14, 60,  5, 82, 14,  8, 31, 17,
    23, 40, 31, 49, 23, 72, 31, 81, 23,  7, 40, 29, 49, 39, 40,
    57, 49, 71, 40, 85, 49,  9, 66, 29, 57, 37, 66, 58, 58, 65,
    66, 86, 58,  3,  5, 19, 14, 31,  5, 51, 14, 60,  6, 83, 14,
     9, 31, 18, 23, 41, 31, 50, 23, 73, 31, 82, 23,  8, 40, 28,
    49, 40, 40, 56, 49, 72, 40, 84, 49,  8, 66, 29, 58, 36, 66,
    57, 58, 64, 66, 85, 58,  2,  5, 20, 14, 30,  5, 52, 14, 61,
     6, 84, 14, 10, 31, 19, 23, 42, 31, 51, 23, 74, 31, 83, 23,
     9, 40, 27, 49, 41, 40, 55, 49, 73, 40, 83, 49,  7, 66, 28,
    58, 35, 66, 56, 58, 63, 66, 84, 58,  1,  5, 21, 14, 30,  6,
    53, 14, 62,  6, 85, 14, 11, 31, 20, 23, 43, 31, 52, 23, 74,
    32, 84, 23, 10, 40, 26, 49, 42, 40, 54, 49, 74, 40, 82, 49,
     6, 66, 27, 58, 34, 66, 55, 58, 62, 66, 83, 58,  0,  5, 22,
    14, 31,  6, 54, 14, 63,  6, 86, 14, 12, 31, 21, 23, 44, 31,
    53, 23, 73, 32, 85, 23, 11, 40, 25, 49, 43, 40, 53, 49, 74,
    41, 81, 49,  5, 66, 26, 58, 33, 66, 54, 58, 61, 66, 82, 58,
     0,  6, 23, 14, 32,  6, 55, 14, 64,  6, 87, 14, 13, 31, 22,
    23, 44, 32, 54, 23, 72, 32, 86, 23, 12, 40, 24, 49, 44, 40,
    52, 49, 73, 41, 80, 49,  4, 66, 25, 58, 32, 66, 53, 58, 60,
    66, 81, 58,  1,  6, 24, 14, 33,  6, 56, 14, 65,  6, 88, 14,
    14, 31, 23, 23, 43, 32, 55, 23, 71, 32, 87, 23, 13, 40, 23,
    49, 44, 41, 51, 49, 72, 41, 79, 49,  3, 66, 24, 58, 31, 66,
    52, 58, 60, 67, 80, 58,  2,  6, 25, 14, 34,  6, 57, 14, 66,
     6, 89, 14, 14, 32, 24, 23, 42, 32, 56, 23, 70, 32, 88, 23,
    14, 40, 22, 49, 43, 41, 50, 49, 71, 41, 78, 49,  2, 66, 23,
    58, 30, 66, 51, 58, 61, 67, 79, 58,  3,  6, 26, 14, 35,  6,
    58, 14, 67,  6, 89, 15, 13, 32, 25, 23, 41, 32, 57, 23, 69,
    32, 89, 23, 14, 41, 21, 49, 42, 41, 49, 49, 70, 41, 77, 49,
     1, 66, 22, 58, 30, 67, 50, 58, 62, 67, 78, 58,  4,  6, 27,
    14, 36,  6, 59, 14, 68,  6, 88, 15, 12, 32, 26, 23, 40, 32,
    58, 23, 68, 32, 89, 24, 13, 41, 20, 49, 41, 41, 48, 49, 69,
    41, 76, 49,  0, 66, 21, 58, 31, 67, 49, 58, 63, 67, 77, 58,
     5,  6, 28, 14, 37,  6, 59, 15, 69,  6, 87, 15, 11, 32, 27,
    23, 39, 32, 59, 23, 67, 32, 88, 24, 12, 41, 19, 49, 40, 41,
    47, 49, 68, 41, 75, 49,  0, 67, 20, 58, 32, 67, 48, 58, 64,
    67, 76, 58,  6,  6, 29, 14, 38,  6, 58, 15, 70,  6, 86, 15,
    10, 32, 28, 23, 38, 32, 59, 24, 66, 32, 87, 24, 11, 41, 18,
    49, 39, 41, 46, 49, 67, 41, 75, 50,  1, 67, 19, 58, 33, 67,
    47, 58, 65, 67, 75, 58,  7,  6, 29, 15, 39,  6, 57, 15, 71,
     6, 85, 15,  9, 32, 29, 23, 37, 32, 58, 24, 65, 32, 86, 24,
    10, 41, 17, 49, 38, 41, 45, 49, 66, 41, 76, 50,  2, 67, 18,
    58, 34, 67, 46, 58, 66, 67, 75, 59,  8,  6, 28, 15, 40,  6,
    56, 15, 72,  6, 84, 15,  8, 32, 29, 24, 36, 32, 57, 24, 64,
    32, 85, 24,  9, 41, 16, 49, 37, 41, 45, 50, 65, 41, 77, 50,
     3, 67, 17, 58, 35, 67, 45, 58, 67, 67, 76, 59,  9,  6, 27,
    15, 41,  6, 55, 15, 73,  6, 83, 15,  7, 32, 28, 24, 35, 32,
    56, 24, 63, 32, 84, 24,  8, 41, 15, 49, 36, 41, 46, 50, 64,
    41, 78, 50,  4, 67, 16, 58, 36, 67, 45, 59, 68, 67, 77, 59,
    10,  6, 26, 15, 42,  6, 54, 15, 74,  6, 82, 15,  6, 32, 27,
    24, 34, 32, 55, 24, 62, 32, 83, 24,  7, 41, 15, 50, 35, 41,
    47, 50, 63, 41, 79, 50,  5, 67, 15, 58, 37, 67, 46, 59, 69,
    67, 78, 59, 11,  6, 25, 15, 43,  6, 53, 15, 74,  7, 81, 15,
     5, 32, 26, 24, 33, 32, 54, 24, 61, 32, 82, 24,  6, 41, 16,
    50, 34, 41, 48, 50, 62, 41, 80, 50,  6, 67, 15, 59, 38, 67,
    47, 59, 70, 67, 79, 59, 12,  6, 24, 15, 44,  6, 52, 15, 73,
     7, 80, 15,  4, 32, 25, 24, 32, 32, 53, 24, 60, 32, 81, 24,
     5, 41, 17, 50, 33, 41, 49, 50, 61, 41, 81, 50,  7, 67, 16,
    59, 39, 67, 48, 59, 71, 67, 80, 59, 13,  6, 23, 15, 44,  7,
    51, 15, 72,  7, 79, 15,  3, 32, 24, 24, 31, 32, 52, 24, 60,
    33, 80, 24,  4, 41, 18, 50, 32, 41, 50, 50, 60, 41, 82, 50,
     8, 67, 17, 59, 40, 67, 49, 59, 72, 67, 81, 59, 14,  6, 22,
    15, 43,  7, 50, 15, 71,  7, 78, 15,  2, 32, 23, 24, 30, 32,
    51, 24, 61, 33, 79, 24,  3, 41, 19, 50, 31, 41, 51, 50, 60,
    42, 83, 50,  9, 67, 18, 59, 41, 67, 50, 59, 73, 67, 82, 59,
    14,  7, 21, 15, 42,  7, 49, 15, 70,  7, 77, 15,  1, 32, 22,
    24, 30, 33, 50, 24, 62, 33, 78, 24,  2, 41, 20, 50, 30, 41,
    52, 50, 61, 42, 84, 50, 10, 67, 19, 59, 42, 67, 51, 59, 74,
    67, 83, 59, 13,  7, 20, 15, 41,  7, 48, 15, 69,  7, 76, 15,
     0, 32, 21, 24, 31, 33, 49, 24, 63, 33, 77, 24,  1, 41, 21,
    50, 30, 42, 53, 50, 62, 42, 85, 50, 11, 67, 20, 59, 43, 67,
    52, 59, 60, 51, 84, 59, 12,  7, 19, 15, 40,  7, 47, 15, 68,
     7, 75, 15,  0, 33, 20, 24, 32, 33, 48, 24, 64, 33, 76, 24,
     0, 41, 22, 50, 31, 42, 54, 50, 63, 42, 86, 50, 12, 67, 21,
    59, 44, 67, 53, 59, 61, 51, 85, 59, 11,  7, 18, 15, 39,  7,
    46, 15, 67,  7, 75, 16,  1, 33, 19, 24, 33, 33, 47, 24, 65,
    33, 75, 24,  0, 42, 23, 50, 32, 42, 55, 50, 64, 42, 87, 50,
    13, 67, 22, 59, 30, 51, 54, 59, 62, 51, 86, 59, 10,  7, 17,
    15, 38,  7, 45, 15, 66,  7, 76, 16,  2, 33, 18, 24, 34, 33,
    46, 24, 66, 33, 75, 25,  1, 42, 24, 50, 33, 42, 56, 50, 65,
    42, 88, 50, 14, 67, 23, 59, 31, 51, 55, 59, 63, 51, 87, 59,
     9,  7, 16, 15, 37,  7, 45, 16, 65,  7, 77, 16,  3, 33, 17,
    24, 35, 33, 45, 24, 67, 33, 76, 25,  2, 42, 25, 50, 34, 42,
    57, 50, 66, 42, 89, 50,  0, 51, 24, 59, 32, 51, 56, 59, 64,
    51, 88, 59,  8,  7, 15, 15, 36,  7, 46, 16, 64,  7, 78, 16,
     4, 33, 16, 24, 36, 33, 45, 25, 68, 33, 77, 25,  3, 42, 26,
    50, 35, 42, 58, 50, 67, 42, 75, 34,  1, 51, 25, 59, 33, 51,
    57, 59, 65, 51, 89, 59,  7,  7, 15, 16, 35,  7, 47, 16, 63,
     7, 79, 16,  5, 33, 15, 24, 37, 33, 46, 25, 69, 33, 78, 25,
     4, 42, 27, 50, 36, 42, 59, 50, 68, 42, 76, 34,  2, 51, 26,
    59, 34, 51, 58, 59, 66, 51, 89, 60,  6,  7, 16, 16, 34,  7,
    48, 16, 62,  7, 80, 16,  6, 33, 15, 25, 38, 33, 47, 25, 70,
    33, 79, 25,  5, 42, 28, 50, 37, 42, 45, 34, 69, 42, 77, 34,
     3, 51, 27, 59, 35, 51, 59, 59, 67, 51, 88, 60,  5,  7, 17,
    16, 33,  7, 49, 16, 61,  7, 81, 16,  7, 33, 16, 25, 39, 33,
    48, 25, 71, 33, 80, 25,  6, 42, 29, 50, 38, 42, 46, 34, 70,
    42, 78, 34,  4, 51, 28, 59, 36, 51, 59, 60, 68, 51, 87, 60,
     4,  7, 18, 16, 32,  7, 50, 16, 60,  7, 82, 16,  8, 33, 17,
    25, 40, 33, 49, 25, 72, 33, 81, 25,  7, 42, 15, 34, 39, 42,
    47, 34, 71, 42, 79, 34,  5, 51, 29, 59, 37, 51, 58, 60, 69,
    51, 86, 60,  3,  7, 19, 16, 31,  7, 51, 16, 60,  8, 83, 16,
     9, 33, 18, 25, 41, 33, 50, 25, 73, 33, 82, 25,  8, 42, 16,
    34, 40, 42, 48, 34, 72, 42, 80, 34,  6, 51, 29, 60, 38, 51,
    57, 60, 70, 51, 85, 60,  2,  7, 20, 16, 30,  7, 52, 16, 61,
     8, 84, 16, 10, 33, 19, 25, 42, 33, 51, 25, 74, 33, 83, 25,
     9, 42, 17, 34, 41, 42, 49, 34, 73, 42, 81, 34,  7, 51, 28,
    60, 39, 51, 56, 60, 71, 51, 84, 60,  1,  7, 21, 16, 30,  8,
    53, 16, 62,  8, 85, 16, 11, 33, 20, 25, 43, 33, 52, 25, 60,
    17, 84, 25, 10, 42, 18, 34, 42, 42, 50, 34, 74, 42, 82, 34,
     8, 51, 27, 60, 40, 51, 55, 60, 72, 51, 83, 60,  0,  7, 22,
    16, 31,  8, 54, 16, 63,  8, 86, 16, 12, 33, 21, 25, 44, 33,
    53, 25, 61, 17, 85, 25, 11, 42, 19, 34, 43, 42, 51, 34, 74,
    43, 83, 34,  9, 51, 26, 60, 41, 51, 54, 60, 73, 51, 82, 60,
     0,  8, 23, 16, 32,  8, 55, 16, 64,  8, 87, 16, 13, 33, 22,
    25, 30, 17, 54, 25, 62, 17, 86, 25, 12, 42, 20, 34, 44, 42,
    52, 34, 73, 43, 84, 34, 10, 51, 25, 60, 42, 51, 53, 60, 74,
    51, 81, 60,  1,  8, 24, 16, 33,  8, 56, 16, 65,  8, 88, 16,
    14, 33, 23, 25, 31, 17, 55, 25, 63, 17, 87, 25, 13, 42, 21,
    34, 44, 43, 53, 34, 72, 43, 85, 34, 11, 51, 24, 60, 43, 51,
    52, 60, 74, 52, 80, 60,  2,  8, 25, 16, 34,  8, 57, 16, 66,
     8, 89, 16,  0, 17, 24, 25, 32, 17, 56, 25, 64, 17, 88, 25,
    14, 42, 22, 34, 43, 43, 54, 34, 71, 43, 86, 34, 12, 51, 23,
    60, 44, 51, 51, 60, 73, 52, 79, 60,  3,  8, 26, 16, 35,  8,
    58, 16, 67,  8, 75,  0,  1, 17, 25, 25, 33, 17, 57, 25, 65,
    17, 89, 25, 14, 43, 23, 34, 42, 43, 55, 34, 70, 43, 87, 34,
    13, 51, 22, 60, 44, 52, 50, 60, 72, 52, 78, 60,  4,  8, 27,
    16, 36,  8, 59, 16, 68,  8, 76,  0,  2, 17, 26, 25, 34, 17,
    58, 25, 66, 17, 89, 26, 13, 43, 24, 34, 41, 43, 56, 34, 69,
    43, 88, 34, 14, 51, 21, 60, 43, 52, 49, 60, 71, 52, 77, 60,
     5,  8, 28, 16, 37,  8, 45,  0, 69,  8, 77,  0,  3, 17, 27,
    25, 35, 17, 59, 25, 67, 17, 88, 26, 12, 43, 25, 34, 40, 43,
    57, 34, 68, 43, 89, 34, 14, 52, 20, 60, 42, 52, 48, 60, 70,
    52, 76, 60,  6,  8, 29, 16, 38,  8, 46,  0, 70,  8, 78,  0,
     4, 17, 28, 25, 36, 17, 59, 26, 68, 17, 87, 26, 11, 43, 26,
    34, 39, 43, 58, 34, 67, 43, 89, 35, 13, 52, 19, 60, 41, 52,
    47, 60, 69, 52, 75, 60,  7,  8, 15,  0, 39,  8, 47,  0, 71,
     8, 79,  0,  5, 17, 29, 25, 37, 17, 58, 26, 69, 17, 86, 26,
    10, 43, 27, 34, 38, 43, 59, 34, 66, 43, 88, 35, 12, 52, 18,
    60, 40, 52, 46, 60, 68, 52, 75, 61,  8,  8, 16,  0, 40,  8,
    48,  0, 72,  8, 80,  0,  6, 17, 29, 26, 38, 17, 57, 26, 70,
    17, 85, 26,  9, 43, 28, 34, 37, 43, 59, 35, 65, 43, 87, 35,
    11, 52, 17, 60, 39, 52, 45, 60, 67, 52, 76, 61,  9,  8, 17,
     0, 41,  8, 49,  0, 73,  8, 81,  0,  7, 17, 28, 26, 39, 17,
    56, 26, 71, 17, 84, 26,  8, 43, 29, 34, 36, 43, 58, 35, 64,
    43, 86, 35, 10, 52, 16, 60, 38, 52, 45, 61, 66, 52, 77, 61,
    10,  8, 18,  0, 42,  8, 50,  0, 74,  8, 82,  0,  8, 17, 27,
    26, 40, 17, 55, 26, 72, 17, 83, 26,  7, 43, 29, 35, 35, 43,
    57, 35, 63, 43, 85, 35,  9, 52, 15, 60, 37, 52, 46, 61, 65,
    52, 78, 61, 11,  8, 19,  0, 43,  8, 51,  0, 74,  9, 83,  0,
     9, 17, 26, 26, 41, 17, 54, 26, 73, 17, 82, 26,  6, 43, 28,
    35, 34, 43, 56, 35, 62, 43, 84, 35,  8, 52, 15, 61, 36, 52,
    47, 61, 64, 52, 79, 61, 12,  8, 20,  0, 44,  8, 52,  0, 73,
     9, 84,  0, 10, 17, 25, 26, 42, 17, 53, 26, 74, 17, 81, 26,
     5, 43, 27, 35, 33, 43, 55, 35, 61, 43, 83, 35,  7, 52, 16,
    61, 35, 52, 48, 61, 63, 52, 80, 61, 13,  8, 21,  0, 44,  9,
    53,  0, 72,  9, 85,  0, 11, 17, 24, 26, 43, 17, 52, 26, 74,
    18, 80, 26,  4, 43, 26, 35, 32, 43, 54, 35, 60, 43, 82, 35,
     6, 52, 17, 61, 34, 52, 49, 61, 62, 52, 81, 61, 14,  8, 22,
     0, 43,  9, 54,  0, 71,  9, 86,  0, 12, 17, 23, 26, 44, 17,
    51, 26, 73, 18, 79, 26,  3, 43, 25, 35, 31, 43, 53, 35, 60,
    44, 81, 35,  5, 52, 18, 61, 33, 52, 50, 61, 61, 52, 82, 61,
    14,  9, 23,  0, 42,  9, 55,  0, 70,  9, 87,  0, 13, 17, 22,
    26, 44, 18, 50, 26, 72, 18, 78, 26,  2, 43, 24, 35, 30, 43,
    52, 35, 61, 44, 80, 35,  4, 52, 19, 61, 32, 52, 51, 61, 60,
    52, 83, 61, 13,  9, 24,  0, 41,  9, 56,  0, 69,  9, 88,  0,
    14, 17, 21, 26, 43, 18, 49, 26, 71, 18, 77, 26,  1, 43, 23,
    35, 30, 44, 51, 35, 62, 44, 79, 35,  3, 52, 20, 61, 31, 52,
    52, 61, 60, 53, 84, 61, 12,  9, 25,  0, 40,  9, 57,  0, 68,
     9, 89,  0, 14, 18, 20, 26, 42, 18, 48, 26, 70, 18, 76, 26,
     0, 43, 22, 35, 31, 44, 50, 35, 63, 44, 78, 35,  2, 52, 21,
    61, 30, 52, 53, 61, 61, 53, 85, 61, 11,  9, 26,  0, 39,  9,
    58,  0, 67,  9, 89,  1, 13, 18, 19, 26, 41, 18, 47, 26, 69,
    18, 75, 26,  0, 44, 21, 35, 32, 44, 49, 35, 64, 44, 77, 35,
     1, 52, 22, 61, 30, 53, 54, 61, 62, 53, 86, 61, 10,  9, 27,
     0, 38,  9, 59,  0, 66,  9, 88,  1, 12, 18, 18, 26, 40, 18,
    46, 26, 68, 18, 75, 27,  1, 44, 20, 35, 33, 44, 48, 35, 65,
    44, 76, 35,  0, 52, 23, 61, 31, 53, 55, 61, 63, 53, 87, 61,
     9,  9, 28,  0, 37,  9, 59,  1, 65,  9, 87,  1, 11, 18, 17,
    26, 39, 18, 45, 26, 67, 18, 76, 27,  2, 44, 19, 35, 34, 44,
    47, 35, 66, 44, 75, 35,  0, 53, 24, 61, 32, 53, 56, 61, 64,
    53, 88, 61,  8,  9, 29,  0, 36,  9, 58,  1, 64,  9, 86,  1,
    10, 18, 16, 26, 38, 18, 45, 27, 66, 18, 77, 27,  3, 44, 18,
    35, 35, 44, 46, 35, 67, 44, 75, 36,  1, 53, 25, 61, 33, 53,
    57, 61, 65, 53, 89, 61,  7,  9, 29,  1, 35,  9, 57,  1, 63,
     9, 85,  1,  9, 18, 15, 26, 37, 18, 46, 27, 65, 18, 78, 27,
     4, 44, 17, 35, 36, 44, 45, 35, 68, 44, 76, 36,  2, 53, 26,
    61, 34, 53, 58, 61, 66, 53, 89, 62,  6,  9, 28,  1, 34,  9,
    56,  1, 62,  9, 84,  1,  8, 18, 15, 27, 36, 18, 47, 27, 64,
    18, 79, 27,  5, 44, 16, 35, 37, 44, 45, 36, 69, 44, 77, 36,
     3, 53, 27, 61, 35, 53, 59, 61, 67, 53, 88, 62,  5,  9, 27,
     1, 33,  9, 55,  1, 61,  9, 83,  1,  7, 18, 16, 27, 35, 18,
    48, 27, 63, 18, 80, 27,  6, 44, 15, 35, 38, 44, 46, 36, 70,
    44, 78, 36,  4, 53, 28, 61, 36, 53, 59, 62, 68, 53, 87, 62,
     4,  9, 26,  1, 32,  9, 54,  1, 60,  9, 82,  1,  6, 18, 17,
    27, 34, 18, 49, 27, 62, 18, 81, 27,  7, 44, 15, 36, 39, 44,
    47, 36, 71, 44, 79, 36,  5, 53, 29, 61, 37, 53, 58, 62, 69,
    53, 86, 62,  3,  9, 25,  1, 31,  9, 53,  1, 60, 10, 81,  1,
     5, 18, 18, 27, 33, 18, 50, 27, 61, 18, 82, 27,  8, 44, 16,
    36, 40, 44, 48, 36, 72, 44, 80, 36,  6, 53, 29, 62, 38, 53,
    57, 62, 70, 53, 85, 62,  2,  9, 24,  1, 30,  9, 52,  1, 61,
    10, 80,  1,  4, 18, 19, 27, 32, 18, 51, 27, 60, 18, 83, 27,
     9, 44, 17, 36, 41, 44, 49, 36, 73, 44, 81, 36,  7, 53, 28,
    62, 39, 53, 56, 62, 71, 53, 84, 62,  1,  9, 23,  1, 30, 10,
    51,  1, 62, 10, 79,  1,  3, 18, 20, 27, 31, 18, 52, 27, 60,
    19, 84, 27, 10, 44, 18, 36, 42, 44, 50, 36, 74, 44, 82, 36,
     8, 53, 27, 62, 40, 53, 55, 62, 72, 53, 83, 62,  0,  9, 22,
     1, 31, 10, 50,  1, 63, 10, 78,  1,  2, 18, 21, 27, 30, 18,
    53, 27, 61, 19, 85, 27, 11, 44, 19, 36, 43, 44, 51, 36, 74,
    45, 83, 36,  9, 53, 26, 62, 41, 53, 54, 62, 73, 53, 82, 62,
     0, 10, 21,  1, 32, 10, 49,  1, 64, 10, 77,  1,  1, 18, 22,
    27, 30, 19, 54, 27, 62, 19, 86, 27, 12, 44, 20, 36, 44, 44,
    52, 36, 73, 45, 84, 36, 10, 53, 25, 62, 42, 53, 53, 62, 74,
    53, 81, 62,  1, 10, 20,  1, 33, 10, 48,  1, 65, 10, 76,  1,
     0, 18, 23, 27, 31, 19, 55, 27, 63, 19, 87, 27, 13, 44, 21,
    36, 44, 45, 53, 36, 72, 45, 85, 36, 11, 53, 24, 62, 43, 53,
    52, 62, 74, 54, 80, 62,  2, 10, 19,  1, 34, 10, 47,  1, 66,
    10, 75,  1,  0, 19, 24, 27, 32, 19, 56, 27, 64, 19, 88, 27,
    14, 44, 22, 36, 43, 45, 54, 36, 71, 45, 86, 36, 12, 53, 23,
    62, 44, 53, 51, 62, 73, 54, 79, 62,  3, 10, 18,  1, 35, 10,
    46,  1, 67, 10, 75,  2,  1, 19, 25, 27, 33, 19, 57, 27, 65,
    19, 89, 27, 14, 45, 23, 36, 42, 45, 55, 36, 70, 45, 87, 36,
    13, 53, 22, 62, 44, 54, 50, 62, 72, 54, 78, 62,  4, 10, 17,
     1, 36, 10, 45,  1, 68, 10, 76,  2,  2, 19, 26, 27, 34, 19,
    58, 27, 66, 19, 89, 28, 13, 45, 24, 36, 41, 45, 56, 36, 69,
    45, 88, 36, 14, 53, 21, 62, 43, 54, 49, 62, 71, 54, 77, 62,
     5, 10, 16,  1, 37, 10, 45,  2, 69, 10, 77,  2,  3, 19, 27,
    27, 35, 19, 59, 27, 67, 19, 88, 28, 12, 45, 25, 36, 40, 45,
    57, 36, 68, 45, 89, 36, 14, 54, 20, 62, 42, 54, 48, 62, 70,
    54, 76, 62,  6, 10, 15,  1, 38, 10, 46,  2, 70, 10, 78,  2,
     4, 19, 28, 27, 36, 19, 59, 28, 68, 19, 87, 28, 11, 45, 26,
    36, 39, 45, 58, 36, 67, 45, 89, 37, 13, 54, 19, 62, 41, 54,
    47, 62, 69, 54, 75, 62,  7, 10, 15,  2, 39, 10, 47,  2, 71,
    10, 79,  2,  5, 19, 29, 27, 37, 19, 58, 28, 69, 19, 86, 28,
    10, 45, 27, 36, 38, 45, 59, 36, 66, 45, 88, 37, 12, 54, 18,
    62, 40, 54, 46, 62, 68, 54, 75, 63,  8, 10, 16,  2, 40, 10,
    48,  2, 72, 10, 80,  2,  6, 19, 29, 28, 38, 19, 57, 28, 70,
    19, 85, 28,  9, 45, 28, 36, 37, 45, 59, 37, 65, 45, 87, 37,
    11, 54, 17, 62, 39, 54, 45, 62, 67, 54, 76, 63,  9, 10, 17,
     2, 41, 10, 49,  2, 73, 10, 81,  2,  7, 19, 28, 28, 39, 19,
    56, 28, 71, 19, 84, 28,  8, 45, 29, 36, 36, 45, 58, 37, 64,
    45, 86, 37, 10, 54, 16, 62, 38, 54, 45, 63, 66, 54, 77, 63,
    10, 10, 18,  2, 42, 10, 50,  2, 74, 10, 82,  2,  8, 19, 27,
    28, 40, 19, 55, 28, 72, 19, 83, 28,  7, 45, 29, 37, 35, 45,
    57, 37, 63, 45, 85, 37,  9, 54, 15, 62, 37, 54, 46, 63, 65,
    54, 78, 63, 11, 10, 19,  2, 43, 10, 51,  2, 74, 11, 83,  2,
     9, 19, 26, 28, 41, 19, 54, 28, 73, 19, 82, 28,  6, 45, 28,
    37, 34, 45, 56, 37, 62, 45, 84, 37,  8, 54, 15, 63, 36, 54,
    47, 63, 64, 54, 79, 63, 12, 10, 20,  2, 44, 10, 52,  2, 73,
    11, 84,  2, 10, 19, 25, 28, 42, 19, 53, 28, 74, 19, 81, 28,
     5, 45, 27, 37, 33, 45, 55, 37, 61, 45, 83, 37,  7, 54, 16,
    63, 35, 54, 48, 63, 63, 54, 80, 63, 13, 10, 21,  2, 44, 11,
    53,  2, 72, 11, 85,  2, 11, 19, 24, 28, 43, 19, 52, 28, 74,
    20, 80, 28,  4, 45, 26, 37, 32, 45, 54, 37, 60, 45, 82, 37,
     6, 54, 17, 63, 34, 54, 49, 63, 62, 54, 81, 63, 14, 10, 22,
     2, 43, 11, 54,  2, 71, 11, 86,  2, 12, 19, 23, 28, 44, 19,
    51, 28, 73, 20, 79, 28,  3, 45, 25, 37, 31, 45, 53, 37, 60,
    46, 81, 37,  5, 54, 18, 63, 33, 54, 50, 63, 61, 54, 82, 63,
    14, 11, 23,  2, 42, 11, 55,  2, 70, 11, 87,  2, 13, 19, 22,
    28, 44, 20, 50, 28, 72, 20, 78, 28,  2, 45, 24, 37, 30, 45,
    52, 37, 61, 46, 80, 37,  4, 54, 19, 63, 32, 54, 51, 63, 60,
    54, 83, 63, 13, 11, 24,  2, 41, 11, 56,  2, 69, 11, 88,  2,
    14, 19, 21, 28, 43, 20, 49, 28, 71, 20, 77, 28,  1, 45, 23,
    37, 30, 46, 51, 37, 62, 46, 79, 37,  3, 54, 20, 63, 31, 54,
    52, 63, 60, 55, 84, 63, 12, 11, 25,  2, 40, 11, 57,  2, 68,
    11, 89,  2, 14, 20, 20, 28, 42, 20, 48, 28, 70, 20, 76, 28,
     0, 45, 22, 37, 31, 46, 50, 37, 63, 46, 78, 37,  2, 54, 21,
    63, 30, 54, 53, 63, 61, 55, 85, 63, 11, 11, 26,  2, 39, 11,
    58,  2, 67, 11, 89,  3, 13, 20, 19, 28, 41, 20, 47, 28, 69,
    20, 75, 28,  0, 46, 21, 37, 32, 46, 49, 37, 64, 46, 77, 37,
     1, 54, 22, 63, 30, 55, 54, 63, 62, 55, 86, 63, 10, 11, 27,
     2, 38, 11, 59,  2, 66, 11, 88,  3, 12, 20, 18, 28, 40, 20,
    46, 28, 68, 20, 75, 29,  1, 46, 20, 37, 33, 46, 48, 37, 65,
    46, 76, 37,  0, 54, 23, 63, 31, 55, 55, 63, 63, 55, 87, 63,
     9, 11, 28,  2, 37, 11, 59,  3, 65, 11, 87,  3, 11, 20, 17,
    28, 39, 20, 45, 28, 67, 20, 76, 29,  2, 46, 19, 37, 34, 46,
    47, 37, 66, 46, 75, 37,  0, 55, 24, 63, 32, 55, 56, 63, 64,
    55, 88, 63,  8, 11, 29,  2, 36, 11, 58,  3, 64, 11, 86,  3,
    10, 20, 16, 28, 38, 20, 45, 29, 66, 20, 77, 29,  3, 46, 18,
    37, 35, 46, 46, 37, 67, 46, 75, 38,  1, 55, 25, 63, 33, 55,
    57, 63, 65, 55, 89, 63,  7, 11, 29,  3, 35, 11, 57,  3, 63,
    11, 85,  3,  9, 20, 15, 28, 37, 20, 46, 29, 65, 20, 78, 29,
     4, 46, 17, 37, 36, 46, 45, 37, 68, 46, 76, 38,  2, 55, 26,
    63, 34, 55, 58, 63, 66, 55, 89, 64,  6, 11, 28,  3, 34, 11,
    56,  3, 62, 11, 84,  3,  8, 20, 15, 29, 36, 20, 47, 29, 64,
    20, 79, 29,  5, 46, 16, 37, 37, 46, 45, 38, 69, 46, 77, 38,
     3, 55, 27, 63, 35, 55, 59, 63, 67, 55, 88, 64,  5, 11, 27,
     3, 33, 11, 55,  3, 61, 11, 83,  3,  7, 20, 16, 29, 35, 20,
    48, 29, 63, 20, 80, 29,  6, 46, 15, 37, 38, 46, 46, 38, 70,
    46, 78, 38,  4, 55, 28, 63, 36, 55, 59, 64, 68, 55, 87, 64,
     4, 11, 26,  3, 32, 11, 54,  3, 60, 11, 82,  3,  6, 20, 17,
    29, 34, 20, 49, 29, 62, 20, 81, 29,  7, 46, 15, 38, 39, 46,
    47, 38, 71, 46, 79, 38,  5, 55, 29, 63, 37, 55, 58, 64, 69,
    55, 86, 64,  3, 11, 25,  3, 31, 11, 53,  3, 60, 12, 81,  3,
     5, 20, 18, 29, 33, 20, 50, 29, 61, 20, 82, 29,  8, 46, 16,
    38, 40, 46, 48, 38, 72, 46, 80, 38,  6, 55, 29, 64, 38, 55,
    57, 64, 70, 55, 85, 64,  2, 11, 24,  3, 30, 11, 52,  3, 61,
    12, 80,  3,  4, 20, 19, 29, 32, 20, 51, 29, 60, 20, 83, 29,
     9, 46, 17, 38, 41, 46, 49, 38, 73, 46, 81, 38,  7, 55, 28,
    64, 39, 55, 56, 64, 71, 55, 84, 64,  1, 11, 23,  3, 30, 12,
    51,  3, 62, 12, 79,  3,  3, 20, 20, 29, 31, 20, 52, 29, 60,
    21, 84, 29, 10, 46, 18, 38, 42, 46, 50, 38, 74, 46, 82, 38,
     8, 55, 27, 64, 40, 55, 55, 64, 72, 55, 83, 64,  0, 11, 22,
     3, 31, 12, 50,  3, 63, 12, 78,  3,  2, 20, 21, 29, 30, 20,
    53, 29, 61, 21, 85, 29, 11, 46, 19, 38, 43, 46, 51, 38, 74,
    47, 83, 38,  9, 55, 26, 64, 41, 55, 54, 64, 73, 55, 82, 64,
     0, 12, 21,  3, 32, 12, 49,  3, 64, 12, 77,  3,  1, 20, 22,
    29, 30, 21, 54, 29, 62, 21, 86, 29, 12, 46, 20, 38, 44, 46,
    52, 38, 73, 47, 84, 38, 10, 55, 25, 64, 42, 55, 53, 64, 74,
    55, 81, 64,  1, 12, 20,  3, 33, 12, 48,  3, 65, 12, 76,  3,
     0, 20, 23, 29, 31, 21, 55, 29, 63, 21, 87, 29, 13, 46, 21,
    38, 44, 47, 53, 38, 72, 47, 85, 38, 11, 55, 24, 64, 43, 55,
    52, 64, 74, 56, 80, 64,  2, 12, 19,  3, 34, 12, 47,  3, 66,
    12, 75,  3,  0, 21, 24, 29, 32, 21, 56, 29, 64, 21, 88, 29,
    14, 46, 22, 38, 43, 47, 54, 38, 71, 47, 86, 38, 12, 55, 23,
    64, 44, 55, 51, 64, 73, 56, 79, 64,  3, 12, 18,  3, 35, 12,
    46,  3, 67, 12, 75,  4,  1, 21, 25, 29, 33, 21, 57, 29, 65,
    21, 89, 29, 14, 47, 23, 38, 42, 47, 55, 38, 70, 47, 87, 38,
    13, 55, 22, 64, 44, 56, 50, 64, 72, 56, 78, 64,  4, 12, 17,
     3, 36, 12, 45,  3, 68, 12, 76,  4,  2, 21, 26, 29, 34, 21,
    58, 29, 66, 21, 89, 30, 13, 47, 24, 38, 41, 47, 56, 38, 69,
    47, 88, 38, 14, 55, 21, 64, 43, 56, 49, 64, 71, 56, 77, 64,
     5, 12, 16,  3, 37, 12, 45,  4, 69, 12, 77,  4,  3, 21, 27,
    29, 35, 21, 59, 29, 67, 21, 88, 30, 12, 47, 25, 38, 40, 47,
    57, 38, 68, 47, 89, 38, 14, 56, 20, 64, 42, 56, 48, 64, 70,
    56, 76, 64,  6, 12, 15,  3, 38, 12, 46,  4, 70, 12, 78,  4,
     4, 21, 28, 29, 36, 21, 59, 30, 68, 21, 87, 30, 11, 47, 26,
    38, 39, 47, 58, 38, 67, 47, 89, 39, 13, 56, 19, 64, 41, 56,
    47, 64, 69, 56, 75, 64,  7, 12, 15,  4, 39, 12, 47,  4, 71,
    12, 79,  4,  5, 21, 29, 29, 37, 21, 58, 30, 69, 21, 86, 30,
    10, 47, 27, 38, 38, 47, 59, 38, 66, 47, 88, 39, 12, 56, 18,
    64, 40, 56, 46, 64, 68, 56, 75, 65,  8, 12, 16,  4, 40, 12,
    48,  4, 72, 12, 80,  4,  6, 21, 29, 30, 38, 21, 57, 30, 70,
    21, 85, 30,  9, 47, 28, 38, 37, 47, 59, 39, 65, 47, 87, 39,
    11, 56, 17, 64, 39, 56, 45, 64, 67, 56, 76, 65,  9, 12, 17,
     4, 41, 12, 49,  4, 73, 12, 81,  4,  7, 21, 28, 30, 39, 21,
    56, 30, 71, 21, 84, 30,  8, 47, 29, 38, 36, 47, 58, 39, 64,
    47, 86, 39, 10, 56, 16, 64, 38, 56, 45, 65, 66, 56, 77, 65,
    10, 12, 18,  4, 42, 12, 50,  4, 74, 12, 82,  4,  8, 21, 27,
    30, 40, 21, 55, 30, 72, 21, 83, 30,  7, 47, 29, 39, 35, 47,
    57, 39, 63, 47, 85, 39,  9, 56, 15, 64, 37, 56, 46, 65, 65,
    56, 78, 65, 11, 12, 19,  4, 43, 12, 51,  4, 74, 13, 83,  4,
     9, 21, 26, 30, 41, 21, 54, 30, 73, 21, 82, 30,  6, 47, 28,
    39, 34, 47, 56, 39, 62, 47, 84, 39,  8, 56, 15, 65, 36, 56,
    47, 65, 64, 56, 79, 65, 12, 12, 20,  4, 44, 12, 52,  4, 73,
    13, 84,  4, 10, 21, 25, 30, 42, 21, 53, 30, 74, 21, 81, 30,
     5, 47, 27, 39, 33, 47, 55, 39, 61, 47, 83, 39,  7, 56, 16,
    65, 35, 56, 48, 65, 63, 56, 80, 65, 13, 12, 21,  4, 44, 13,
    53,  4, 72, 13, 85,  4, 11, 21, 24, 30, 43, 21, 52, 30, 74,
    22, 80, 30,  4, 47, 26, 39, 32, 47, 54, 39, 60, 47, 82, 39,
     6, 56, 17, 65, 34, 56, 49, 65, 62, 56, 81, 65, 14, 12, 22,
     4, 43, 13, 54,  4, 71, 13, 86,  4, 12, 21, 23, 30, 44, 21,
    51, 30, 73, 22, 79, 30,  3, 47, 25, 39, 31, 47, 53, 39, 60,
    48, 81, 39,  5, 56, 18, 65, 33, 56, 50, 65, 61, 56, 82, 65,
    14, 13, 23,  4, 42, 13, 55,  4, 70, 13, 87,  4, 13, 21, 22,
    30, 44, 22, 50, 30, 72, 22, 78, 30,  2, 47, 24, 39, 30, 47,
    52, 39, 61, 48, 80, 39,  4, 56, 19, 65, 32, 56, 51, 65, 60,
    56, 83, 65, 13, 13, 24,  4, 41, 13, 56,  4, 69, 13, 88,  4,
    14, 21, 21, 30, 43, 22, 49, 30, 71, 22, 77, 30,  1, 47, 23,
    39, 30, 48, 51, 39, 62, 48, 79, 39,  3, 56, 20, 65, 31, 56,
    52, 65, 60, 57, 84, 65, 12, 13, 25,  4, 40, 13, 57,  4, 68,
    13, 89,  4, 14, 22, 20, 30, 42, 22, 48, 30, 70, 22, 76, 30,
     0, 47, 22, 39, 31, 48, 50, 39, 63, 48, 78, 39,  2, 56, 21,
    65, 30, 56, 53, 65, 61, 57, 85, 65, 11, 13, 26,  4, 39, 13,
    58,  4, 67, 13, 89,  5, 13, 22, 19, 30, 41, 22, 47, 30, 69,
    22, 75, 30,  0, 48, 21, 39, 32, 48, 49, 39, 64, 48, 77, 39,
     1, 56, 22, 65, 30, 57, 54, 65, 62, 57, 86, 65, 10, 13, 27,
     4, 38, 13, 59,  4, 66, 13, 88,  5, 12, 22, 18, 30, 40, 22,
    46, 30, 68, 22, 75, 31,  1, 48, 20, 39, 33, 48, 48, 39, 65,
    48, 76, 39,  0, 56, 23, 65, 31, 57, 55, 65, 63, 57, 87, 65,
     9, 13, 28,  4, 37, 13, 59,  5, 65, 13, 87,  5, 11, 22, 17,
    30, 39, 22, 45, 30, 67, 22, 76, 31,  2, 48, 19, 39, 34, 48,
    47, 39, 66, 48, 75, 39,  0, 57, 24, 65, 32, 57, 56, 65, 64,
    57, 88, 65,  8, 13, 29,  4, 36, 13, 58,  5, 64, 13, 86,  5,
    10, 22, 16, 30, 38, 22, 45, 31, 66, 22, 77, 31,  3, 48, 18,
    39, 35, 48, 46, 39, 67, 48, 75, 40,  1, 57, 25, 65, 33, 57,
    57, 65, 65, 57, 89, 65,  7, 13, 29,  5, 35, 13, 57,  5, 63,
    13, 85,  5,  9, 22, 15, 30, 37, 22, 46, 31, 65, 22, 78, 31,
     4, 48, 17, 39, 36, 48, 45, 39, 68, 48, 76, 40,  2, 57, 26,
    65, 34, 57, 58, 65, 66, 57, 89, 66,  6, 13, 28,  5, 34, 13,
    56,  5, 62, 13, 84,  5,  8, 22, 15, 31, 36, 22, 47, 31, 64,
    22, 79, 31,  5, 48, 16, 39, 37, 48, 45, 40, 69, 48, 77, 40,
     3, 57, 27, 65, 35, 57, 59, 65, 67, 57, 88, 66,  5, 13, 27,
     5, 33, 13, 55,  5, 61, 13, 83,  5,  7, 22, 16, 31, 35, 22,
    48, 31, 63, 22, 80, 31,  6, 48, 15, 39, 38, 48, 46, 40, 70,
    48, 78, 40,  4, 57, 28, 65, 36, 57, 59, 66, 68, 57, 87, 66,
     4, 13, 26,  5, 32, 13, 54,  5, 60, 13, 82,  5,  6, 22, 17,
    31, 34, 22, 49, 31, 62, 22, 81, 31,  7, 48, 15, 40, 39, 48,
    47, 40, 71, 48, 79, 40,  5, 57, 29, 65, 37, 57, 58, 66, 69,
    57, 86, 66,  3, 13, 25,  5, 31, 13, 53,  5, 60, 14, 81,  5,
     5, 22, 18, 31, 33, 22, 50, 31, 61, 22, 82, 31,  8, 48, 16,
    40, 40, 48, 48, 40, 72, 48, 80, 40,  6, 57, 29, 66, 38, 57,
    57, 66, 70, 57, 85, 66,  2, 13, 24,  5, 30, 13, 52,  5, 61,
    14, 80,  5,  4, 22, 19, 31, 32, 22, 51, 31, 60, 22, 83, 31,
     9, 48, 17, 40, 41, 48, 49, 40, 73, 48, 81, 40,  7, 57, 28,
    66, 39, 57, 56, 66, 71, 57, 84, 66,  1, 13, 23,  5, 30, 14,
    51,  5, 62, 14, 79,  5,  3, 22, 20, 31, 31, 22, 52, 31, 60,
    23, 84, 31, 10, 48, 18, 40, 42, 48, 50, 40, 74, 48, 82, 40,
     8, 57, 27, 66, 40, 57, 55, 66, 72, 57, 83, 66,  0, 13, 22,
     5, 31, 14, 50,  5, 63, 14, 78,  5,  2, 22, 21, 31, 30, 22,
    53, 31, 61, 23, 85, 31, 11, 48, 19, 40, 43, 48, 51, 40, 74,
    49, 83, 40,  9, 57, 26, 66, 41, 57, 54, 66, 73, 57, 82, 66,
     0, 14, 21,  5, 32, 14, 49,  5, 64, 14, 77,  5,  1, 22, 22,
    31, 30, 23, 54, 31, 62, 23, 86, 31, 12, 48, 20, 40, 44, 48,
    52, 40, 73, 49, 84, 40, 10, 57, 25, 66, 42, 57, 53, 66, 74,
    57, 81, 66,  1, 14, 20,  5, 33, 14, 48,  5, 65, 14, 76,  5,
     0, 22, 23, 31, 31, 23, 55, 31, 63, 23, 87, 31, 13, 48, 21,
    40, 44, 49, 53, 40, 72, 49, 85, 40, 11, 57, 24, 66, 43, 57,
    52, 66, 74, 58, 80, 66,  2, 14, 19,  5, 34, 14, 47,  5, 66,
    14, 75,  5,  0, 23, 24, 31, 32, 23, 56, 31, 64, 23, 88, 31,
    14, 48, 22, 40, 43, 49, 54, 40, 71, 49, 86, 40, 12, 57, 23,
    66, 44, 57, 51, 66, 73, 58, 79, 66,  3, 14, 18,  5, 35, 14,
    46,  5, 67, 14, 75,  6,  1, 23, 25, 31, 33, 23, 57, 31, 65,
    23, 89, 31, 14, 49, 23, 40, 42, 49, 55, 40, 70, 49, 87, 40,
    13, 57, 22, 66, 44, 58, 50, 66, 72, 58, 78, 66,  4, 14, 17,
     5, 36, 14, 45,  5, 68, 14, 76,  6,  2, 23, 26, 31, 34, 23,
    58, 31, 66, 23, 89, 32, 13, 49, 24, 40, 41, 49, 56, 40, 69,
    49, 88, 40, 14, 57, 21, 66, 43, 58, 49, 66, 71, 58, 77, 66,
     5, 14, 16,  5, 37, 14, 45,  6, 69, 14, 77,  6,  3, 23, 27,
    31, 35, 23, 59, 31, 67, 23, 88, 32, 12, 49, 25, 40, 40, 49,
    57, 40, 68, 49, 89, 40, 14, 58, 20, 66, 42, 58, 48, 66, 70,
    58, 76, 66,  6, 14, 15,  5, 38, 14, 46,  6, 70, 14, 78,  6,
     4, 23, 28, 31, 36, 23, 59, 32, 68, 23, 87, 32, 11, 49, 26,
    40, 39, 49, 58, 40, 67, 49, 89, 41, 13, 58, 19, 66, 41, 58,
    47, 66, 69, 58, 75, 66,  7, 14, 15,  6, 39, 14, 47,  6, 71,
    14, 79,  6,  5, 23, 29, 31, 37, 23, 58, 32, 69, 23, 86, 32,
    10, 49, 27, 40, 38, 49, 59, 40, 66, 49, 88, 41, 12, 58, 18,
    66, 40, 58, 46, 66, 68, 58, 75, 67,  8, 14, 16,  6, 40, 14,
    48,  6, 72, 14, 80,  6,  6, 23, 29, 32, 38, 23, 57, 32, 70,
    23, 85, 32,  9, 49, 28, 40, 37, 49, 59, 41, 65, 49, 87, 41,
    11, 58, 17, 66, 39, 58, 45, 66, 67, 58, 76, 67,  9, 14, 17,
     6, 41, 14, 49,  6, 73, 14, 81,  6,  7, 23, 28, 32, 39, 23,
    56, 32, 71, 23, 84, 32,  8, 49, 29, 40, 36, 49, 58, 41, 64,
    49, 86, 41, 10, 58, 16, 66, 38, 58, 45, 67, 66, 58, 77, 67,
    10, 14, 18,  6, 42, 14, 50,  6, 74, 14, 82,  6,  8, 23, 27,
    32, 40, 23, 55, 32, 72, 23, 83, 32,  7, 49, 29, 41, 35, 49,
    57, 41, 63, 49, 85, 41,  9, 58, 15, 66, 37, 58, 46, 67, 65,
    58, 78, 67, 11, 14, 19,  6, 43, 14, 51,  6, 74, 15, 83,  6,
     9, 23, 26, 32, 41, 23, 54, 32, 73, 23, 82, 32,  6, 49, 28,
    41, 34, 49, 56, 41, 62, 49, 84, 41,  8, 58, 15, 67, 36, 58,
    47, 67, 64, 58, 79, 67, 12, 14, 20,  6, 44, 14, 52,  6, 73,
    15, 84,  6, 10, 23, 25, 32, 42, 23, 53, 32, 74, 23, 81, 32,
     5, 49, 27, 41, 33, 49, 55, 41, 61, 49, 83, 41,  7, 58, 16,
    67, 35, 58, 48, 67, 63, 58, 80, 67, 13, 14, 21,  6, 44, 15,
    53,  6, 72, 15, 85,  6, 11, 23, 24, 32, 43, 23, 52, 32, 74,
    24, 80, 32,  4, 49, 26, 41, 32, 49, 54, 41, 60, 49, 82, 41,
     6, 58, 17, 67, 34, 58, 49, 67, 62, 58, 81, 67, 14, 14, 22,
     6, 43, 15, 54,  6, 71, 15, 86,  6, 12, 23, 23, 32, 44, 23,
    51, 32, 73, 24, 79, 32,  3, 49, 25, 41, 31, 49, 53, 41, 60,
    50, 81, 41,  5, 58, 18, 67, 33, 58, 50, 67, 61, 58, 82, 67,
    14, 15, 23,  6, 42, 15, 55,  6, 70, 15, 87,  6, 13, 23, 22,
    32, 44, 24, 50, 32, 72, 24, 78, 32,  2, 49, 24, 41, 30, 49,
    52, 41, 61, 50, 80, 41,  4, 58, 19, 67, 32, 58, 51, 67, 60,
    58, 83, 67, 13, 15, 24,  6, 41, 15, 56,  6, 69, 15, 88,  6,
    14, 23, 21, 32, 43, 24, 49, 32, 71, 24, 77, 32,  1, 49, 23,
    41, 30, 50, 51, 41, 62, 50, 79, 41,  3, 58, 20, 67, 31, 58,
    52, 67, 60, 59, 84, 67, 12, 15, 25,  6, 40, 15, 57,  6, 68,
    15, 89,  6, 14, 24, 20, 32, 42, 24, 48, 32, 70, 24, 76, 32,
     0, 49, 22, 41, 31, 50, 50, 41, 63, 50, 78, 41,  2, 58, 21,
    67, 30, 58, 53, 67, 61, 59, 85, 67, 11, 15, 26,  6, 39, 15,
    58,  6, 67, 15, 89,  7, 13, 24, 19, 32, 41, 24, 47, 32, 69,
    24, 75, 32,  0, 50, 21, 41, 32, 50, 49, 41, 64, 50, 77, 41,
     1, 58, 22, 67, 30, 59, 54, 67, 62, 59, 86, 67, 10, 15, 27,
     6, 38, 15, 59,  6, 66, 15, 88,  7, 12, 24, 18, 32, 40, 24,
    46, 32, 68, 24, 75, 33,  1, 50, 20, 41, 33, 50, 48, 41, 65,
    50, 76, 41,  0, 58, 23, 67, 31, 59, 55, 67, 63, 59, 87, 67,
     9, 15, 28,  6, 37, 15, 59,  7, 65, 15, 87,  7, 11, 24, 17,
    32, 39, 24, 45, 32, 67, 24, 76, 33,  2, 50, 19, 41, 34, 50,
    47, 41, 66, 50, 75, 41,  0, 59, 24, 67, 32, 59, 56, 67, 64,
    59, 88, 67,  8, 15, 29,  6, 36, 15, 58,  7, 64, 15, 86,  7,
    10, 24, 16, 32, 38, 24, 45, 33, 66, 24, 77, 33,  3, 50, 18,
    41, 35, 50, 46, 41, 67, 50, 75, 42,  1, 59, 25, 67, 33, 59,
    57, 67, 65, 59, 89, 67,  7, 15, 29,  7, 35, 15, 57,  7, 63,
    15, 85,  7,  9, 24, 15, 32, 37, 24, 46, 33, 65, 24, 78, 33,
     4, 50, 17, 41, 36, 50, 45, 41, 68, 50, 76, 42,  2, 59, 26,
    67, 34, 59, 58, 67, 66, 59, 75, 51,  6, 15, 28,  7, 34, 15,
    56,  7, 62, 15, 84,  7,  8, 24, 15, 33, 36, 24, 47, 33, 64,
    24, 79, 33,  5, 50, 16, 41, 37, 50, 45, 42, 69, 50, 77, 42,
     3, 59, 27, 67, 35, 59, 59, 67, 67, 59, 76, 51,  5, 15, 27,
     7, 33, 15, 55,  7, 61, 15, 83,  7,  7, 24, 16, 33, 35, 24,
    48, 33, 63, 24, 80, 33,  6, 50, 15, 41, 38, 50, 46, 42, 70,
    50, 78, 42,  4, 59, 28, 67, 36, 59, 45, 51, 68, 59, 77, 51,
     4, 15, 26,  7, 32, 15, 54,  7, 60, 15, 82,  7,  6, 24, 17,
    33, 34, 24, 49, 33, 62, 24, 81, 33,  7, 50, 15, 42, 39, 50,
    47, 42, 71, 50, 79, 42,  5, 59, 29, 67, 37, 59, 46, 51, 69,
    59, 78, 51,  3, 15, 25,  7, 31, 15, 53,  7, 60, 16, 81,  7,
     5, 24, 18, 33, 33, 24, 50, 33, 61, 24, 82, 33,  8, 50, 16,
    42, 40, 50, 48, 42, 72, 50, 80, 42,  6, 59, 15, 51, 38, 59,
    47, 51, 70, 59, 79, 51,  2, 15, 24,  7, 30, 15, 52,  7, 61,
    16, 80,  7,  4, 24, 19, 33, 32, 24, 51, 33, 60, 24, 83, 33,
     9, 50, 17, 42, 41, 50, 49, 42, 73, 50, 81, 42,  7, 59, 16,
    51, 39, 59, 48, 51, 71, 59, 80, 51,  1, 15, 23,  7, 30, 16,
    51,  7, 62, 16, 79,  7,  3, 24, 20, 33, 31, 24, 52, 33, 60,
    25, 84, 33, 10, 50, 18, 42, 42, 50, 50, 42, 74, 50, 82, 42,
     8, 59, 17, 51, 40, 59, 49, 51, 72, 59, 81, 51,  0, 15, 22,
     7, 31, 16, 50,  7, 63, 16, 78,  7,  2, 24, 21, 33, 30, 24,
    53, 33, 61, 25, 85, 33, 11, 50, 19, 42, 43, 50, 51, 42, 60,
    34, 83, 42,  9, 59, 18, 51, 41, 59, 50, 51, 73, 59, 82, 51,
     0, 16, 21,  7, 32, 16, 49,  7, 64, 16, 77,  7,  1, 24, 22,
    33, 30, 25, 54, 33, 62, 25, 86, 33, 12, 50, 20, 42, 44, 50,
    52, 42, 61, 34, 84, 42, 10, 59, 19, 51, 42, 59, 51, 51, 74,
    59, 83, 51,  1, 16, 20,  7, 33, 16, 48,  7, 65, 16, 76,  7,
     0, 24, 23, 33, 31, 25, 55, 33, 63, 25, 87, 33, 13, 50, 21,
    42, 30, 34, 53, 42, 62, 34, 85, 42, 11, 59, 20, 51, 43, 59,
    52, 51, 74, 60, 84, 51,  2, 16, 19,  7, 34, 16, 47,  7, 66,
    16, 75,  7,  0, 25, 24, 33, 32, 25, 56, 33, 64, 25, 88, 33,
    14, 50, 22, 42, 31, 34, 54, 42, 63, 34, 86, 42, 12, 59, 21,
    51, 44, 59, 53, 51, 73, 60, 85, 51,  3, 16, 18,  7, 35, 16,
    46,  7, 67, 16, 75,  8,  1, 25, 25, 33, 33, 25, 57, 33, 65,
    25, 89, 33,  0, 34, 23, 42, 32, 34, 55, 42, 64, 34, 87, 42,
    13, 59, 22, 51, 44, 60, 54, 51, 72, 60, 86, 51,  4, 16, 17,
     7, 36, 16, 45,  7, 68, 16, 76,  8,  2, 25, 26, 33, 34, 25,
    58, 33, 66, 25, 75, 17,  1, 34, 24, 42, 33, 34, 56, 42, 65,
    34, 88, 42, 14, 59, 23, 51, 43, 60, 55, 51, 71, 60, 87, 51,
     5, 16, 16,  7, 37, 16, 45,  8, 69, 16, 77,  8,  3, 25, 27,
    33, 35, 25, 59, 33, 67, 25, 76, 17,  2, 34, 25, 42, 34, 34,
    57, 42, 66, 34, 89, 42, 14, 60, 24, 51, 42, 60, 56, 51, 70,
    60, 88, 51,  6, 16, 15,  7, 38, 16, 46,  8, 70, 16, 78,  8,
     4, 25, 28, 33, 36, 25, 45, 17, 68, 25, 77, 17,  3, 34, 26,
    42, 35, 34, 58, 42, 67, 34, 89, 43, 13, 60, 25, 51, 41, 60,
    57, 51, 69, 60, 89, 51,  7, 16, 15,  8, 39, 16, 47,  8, 71,
    16, 79,  8,  5, 25, 29, 33, 37, 25, 46, 17, 69, 25, 78, 17,
     4, 34, 27, 42, 36, 34, 59, 42, 68, 34, 88, 43, 12, 60, 26,
    51, 40, 60, 58, 51, 68, 60, 89, 52,  8, 16, 16,  8, 40, 16,
    48,  8, 72, 16, 80,  8,  6, 25, 15, 17, 38, 25, 47, 17, 70,
    25, 79, 17,  5, 34, 28, 42, 37, 34, 59, 43, 69, 34, 87, 43,
    11, 60, 27, 51, 39, 60, 59, 51, 67, 60, 88, 52,  9, 16, 17,
     8, 41, 16, 49,  8, 73, 16, 81,  8,  7, 25, 16, 17, 39, 25,
    48, 17, 71, 25, 80, 17,  6, 34, 29, 42, 38, 34, 58, 43, 70,
    34, 86, 43, 10, 60, 28, 51, 38, 60, 59, 52, 66, 60, 87, 52,
    10, 16, 18,  8, 42, 16, 50,  8, 74, 16, 82,  8,  8, 25, 17,
    17, 40, 25, 49, 17, 72, 25, 81, 17,  7, 34, 29, 43, 39, 34,
    57, 43, 71, 34, 85, 43,  9, 60, 29, 51, 37, 60, 58, 52, 65,
    60, 86, 52, 11, 16, 19,  8, 43, 16, 51,  8, 60,  0, 83,  8,
     9, 25, 18, 17, 41, 25, 50, 17, 73, 25, 82, 17,  8, 34, 28,
    43, 40, 34, 56, 43, 72, 34, 84, 43,  8, 60, 29, 52, 36, 60,
    57, 52, 64, 60, 85, 52, 12, 16, 20,  8, 44, 16, 52,  8, 61,
     0, 84,  8, 10, 25, 19, 17, 42, 25, 51, 17, 74, 25, 83, 17,
     9, 34, 27, 43, 41, 34, 55, 43, 73, 34, 83, 43,  7, 60, 28,
    52, 35, 60, 56, 52, 63, 60, 84, 52, 13, 16, 21,  8, 30,  0,
    53,  8, 62,  0, 85,  8, 11, 25, 20, 17, 43, 25, 52, 17, 74,
    26, 84, 17, 10, 34, 26, 43, 42, 34, 54, 43, 74, 34, 82, 43,
     6, 60, 27, 52, 34, 60, 55, 52, 62, 60, 83, 52, 14, 16, 22,
     8, 31,  0, 54,  8, 63,  0, 86,  8, 12, 25, 21, 17, 44, 25,
    53, 17, 73, 26, 85, 17, 11, 34, 25, 43, 43, 34, 53, 43, 74,
    35, 81, 43,  5, 60, 26, 52, 33, 60, 54, 52, 61, 60, 82, 52,
};

static const uint8_t hq_tab_08[] = {
     0,   0, 31,  8,  42,  0, 73,   8, 84,  0, 115,  8, 16,  25, 27,
    17,  58, 25, 69,  17, 99, 26, 111, 17, 12,  34, 36, 43,  54, 34,
    74,  43, 96, 34, 112, 43, 11,  60, 39, 51,  49, 60, 78,  52, 87,
    60, 116, 52,  1,   0, 32,  8,  43,  0, 74,   8, 85,  0, 116,  8,
    17,  25, 28, 17,  59, 25, 70,  17, 98, 26, 112, 17, 13,  34, 35,
    43,  55, 34, 73,  43, 97, 34, 111, 43, 10,  60, 39, 52,  48, 60,
    77,  52, 86, 60, 115, 52,  2,   0, 33,  8,  44,  0, 75,   8, 86,
     0, 117,  8, 18,  25, 29, 17,  59, 26, 71,  17, 97, 26, 113, 17,
    14,  34, 34, 43,  56, 34, 72,  43, 98, 34, 110, 43,  9,  60, 38,
    52,  47, 60, 76,  52, 85, 60, 114, 52,  3,   0, 34,  8,  45,  0,
    76,   8, 87,  0, 118,  8, 19,  25, 30, 17,  58, 26, 72,  17, 96,
    26, 114, 17, 15,  34, 33, 43,  57, 34, 71,  43, 99, 34, 109, 43,
     8,  60, 37, 52,  46, 60, 75,  52, 84, 60, 113, 52,  4,   0, 35,
     8,  46,  0, 77,   8, 88,  0, 119,  8, 19,  26, 31, 17,  57, 26,
    73,  17, 95, 26, 115, 17, 16,  34, 32, 43,  58, 34, 70,  43, 99,
    35, 108, 43,  7,  60, 36, 52,  45, 60, 74,  52, 83, 60, 112, 52,
     5,   0, 36,  8,  47,  0, 78,   8, 89,  0, 119,  9, 18,  26, 32,
    17,  56, 26, 74,  17, 94, 26, 116, 17, 17,  34, 31, 43,  59, 34,
    69,  43, 98, 35, 107, 43,  6,  60, 35, 52,  44, 60, 73,  52, 82,
    60, 111, 52,  6,   0, 37,  8,  48,  0, 79,   8, 90,  0, 118,  9,
    17,  26, 33, 17,  55, 26, 75,  17, 93, 26, 117, 17, 18,  34, 30,
    43,  59, 35, 68,  43, 97, 35, 106, 43,  5,  60, 34, 52,  43, 60,
    72,  52, 81, 60, 110, 52,  7,   0, 38,  8,  49,  0, 79,   9, 91,
     0, 117,  9, 16,  26, 34, 17,  54, 26, 76,  17, 92, 26, 118, 17,
    19,  34, 29, 43,  58, 35, 67,  43, 96, 35, 105, 43,  4,  60, 33,
    52,  42, 60, 71,  52, 80, 60, 109, 52,  8,   0, 39,  8,  50,  0,
    78,   9, 92,  0, 116,  9, 15,  26, 35, 17,  53, 26, 77,  17, 91,
    26, 119, 17, 19,  35, 28, 43,  57, 35, 66,  43, 95, 35, 104, 43,
     3,  60, 32, 52,  41, 60, 70,  52, 80, 61, 108, 52,  9,   0, 39,
     9,  51,  0, 77,   9, 93,  0, 115,  9, 14,  26, 36, 17,  52, 26,
    78,  17, 90, 26, 119, 18, 18,  35, 27, 43,  56, 35, 65,  43, 94,
    35, 103, 43,  2,  60, 31, 52,  40, 60, 69,  52, 81, 61, 107, 52,
    10,   0, 38,  9,  52,  0, 76,   9, 94,  0, 114,  9, 13,  26, 37,
    17,  51, 26, 79,  17, 89, 26, 118, 18, 17,  35, 26, 43,  55, 35,
    64,  43, 93, 35, 102, 43,  1,  60, 30, 52,  40, 61, 68,  52, 82,
    61, 106, 52, 11,   0, 37,  9,  53,  0, 75,   9, 95,  0, 113,  9,
    12,  26, 38, 17,  50, 26, 79,  18, 88, 26, 117, 18, 16,  35, 25,
    43,  54, 35, 63,  43, 92, 35, 101, 43,  0,  60, 29, 52,  41, 61,
    67,  52, 83, 61, 105, 52, 12,   0, 36,  9,  54,  0, 74,   9, 96,
     0, 112,  9, 11,  26, 39, 17,  49, 26, 78,  18, 87, 26, 116, 18,
    15,  35, 24, 43,  53, 35, 62,  43, 91, 35, 100, 43,  0,  61, 28,
    52,  42, 61, 66,  52, 84, 61, 104, 52, 13,   0, 35,  9,  55,  0,
    73,   9, 97,  0, 111,  9, 10,  26, 39, 18,  48, 26, 77,  18, 86,
    26, 115, 18, 14,  35, 23, 43,  52, 35, 61,  43, 90, 35, 100, 44,
     1,  61, 27, 52,  43, 61, 65,  52, 85, 61, 103, 52, 14,   0, 34,
     9,  56,  0, 72,   9, 98,  0, 110,  9,  9,  26, 38, 18,  47, 26,
    76,  18, 85, 26, 114, 18, 13,  35, 22, 43,  51, 35, 60,  43, 89,
    35, 101, 44,  2,  61, 26, 52,  44, 61, 64,  52, 86, 61, 102, 52,
    15,   0, 33,  9,  57,  0, 71,   9, 99,  0, 109,  9,  8,  26, 37,
    18,  46, 26, 75,  18, 84, 26, 113, 18, 12,  35, 21, 43,  50, 35,
    60,  44, 88, 35, 102, 44,  3,  61, 25, 52,  45, 61, 63,  52, 87,
    61, 101, 52, 16,   0, 32,  9,  58,  0, 70,   9, 99,  1, 108,  9,
     7,  26, 36, 18,  45, 26, 74,  18, 83, 26, 112, 18, 11,  35, 20,
    43,  49, 35, 61,  44, 87, 35, 103, 44,  4,  61, 24, 52,  46, 61,
    62,  52, 88, 61, 100, 52, 17,   0, 31,  9,  59,  0, 69,   9, 98,
     1, 107,  9,  6,  26, 35, 18,  44, 26, 73,  18, 82, 26, 111, 18,
    10,  35, 20, 44,  48, 35, 62,  44, 86, 35, 104, 44,  5,  61, 23,
    52,  47, 61, 61,  52, 89, 61, 100, 53, 18,   0, 30,  9,  59,  1,
    68,   9, 97,  1, 106,  9,  5,  26, 34, 18,  43, 26, 72,  18, 81,
    26, 110, 18,  9,  35, 21, 44,  47, 35, 63,  44, 85, 35, 105, 44,
     6,  61, 22, 52,  48, 61, 60,  52, 90, 61, 101, 53, 19,   0, 29,
     9,  58,  1, 67,   9, 96,  1, 105,  9,  4,  26, 33, 18,  42, 26,
    71,  18, 80, 26, 109, 18,  8,  35, 22, 44,  46, 35, 64,  44, 84,
    35, 106, 44,  7,  61, 21, 52,  49, 61, 60,  53, 91, 61, 102, 53,
    19,   1, 28,  9,  57,  1, 66,   9, 95,  1, 104,  9,  3,  26, 32,
    18,  41, 26, 70,  18, 80, 27, 108, 18,  7,  35, 23, 44,  45, 35,
    65,  44, 83, 35, 107, 44,  8,  61, 20, 52,  50, 61, 61,  53, 92,
    61, 103, 53, 18,   1, 27,  9,  56,  1, 65,   9, 94,  1, 103,  9,
     2,  26, 31, 18,  40, 26, 69,  18, 81, 27, 107, 18,  6,  35, 24,
    44,  44, 35, 66,  44, 82, 35, 108, 44,  9,  61, 20, 53,  51, 61,
    62,  53, 93, 61, 104, 53, 17,   1, 26,  9,  55,  1, 64,   9, 93,
     1, 102,  9,  1,  26, 30, 18,  40, 27, 68,  18, 82, 27, 106, 18,
     5,  35, 25, 44,  43, 35, 67,  44, 81, 35, 109, 44, 10,  61, 21,
    53,  52, 61, 63,  53, 94, 61, 105, 53, 16,   1, 25,  9,  54,  1,
    63,   9, 92,  1, 101,  9,  0,  26, 29, 18,  41, 27, 67,  18, 83,
    27, 105, 18,  4,  35, 26, 44,  42, 35, 68,  44, 80, 35, 110, 44,
    11,  61, 22, 53,  53, 61, 64,  53, 95, 61, 106, 53, 15,   1, 24,
     9,  53,  1, 62,   9, 91,  1, 100,  9,  0,  27, 28, 18,  42, 27,
    66,  18, 84, 27, 104, 18,  3,  35, 27, 44,  41, 35, 69,  44, 80,
    36, 111, 44, 12,  61, 23, 53,  54, 61, 65,  53, 96, 61, 107, 53,
    14,   1, 23,  9,  52,  1, 61,   9, 90,  1, 100, 10,  1,  27, 27,
    18,  43, 27, 65,  18, 85, 27, 103, 18,  2,  35, 28, 44,  40, 35,
    70,  44, 81, 36, 112, 44, 13,  61, 24, 53,  55, 61, 66,  53, 97,
    61, 108, 53, 13,   1, 22,  9,  51,  1, 60,   9, 89,  1, 101, 10,
     2,  27, 26, 18,  44, 27, 64,  18, 86, 27, 102, 18,  1,  35, 29,
    44,  40, 36, 71,  44, 82, 36, 113, 44, 14,  61, 25, 53,  56, 61,
    67,  53, 98, 61, 109, 53, 12,   1, 21,  9,  50,  1, 60,  10, 88,
     1, 102, 10,  3,  27, 25, 18,  45, 27, 63,  18, 87, 27, 101, 18,
     0,  35, 30, 44,  41, 36, 72,  44, 83, 36, 114, 44, 15,  61, 26,
    53,  57, 61, 68,  53, 99, 61, 110, 53, 11,   1, 20,  9,  49,  1,
    61,  10, 87,  1, 103, 10,  4,  27, 24, 18,  46, 27, 62,  18, 88,
    27, 100, 18,  0,  36, 31, 44,  42, 36, 73,  44, 84, 36, 115, 44,
    16,  61, 27, 53,  58, 61, 69,  53, 99, 62, 111, 53, 10,   1, 20,
    10,  48,  1, 62,  10, 86,  1, 104, 10,  5,  27, 23, 18,  47, 27,
    61,  18, 89, 27, 100, 19,  1,  36, 32, 44,  43, 36, 74,  44, 85,
    36, 116, 44, 17,  61, 28, 53,  59, 61, 70,  53, 98, 62, 112, 53,
     9,   1, 21, 10,  47,  1, 63,  10, 85,  1, 105, 10,  6,  27, 22,
    18,  48, 27, 60,  18, 90, 27, 101, 19,  2,  36, 33, 44,  44, 36,
    75,  44, 86, 36, 117, 44, 18,  61, 29, 53,  59, 62, 71,  53, 97,
    62, 113, 53,  8,   1, 22, 10,  46,  1, 64,  10, 84,  1, 106, 10,
     7,  27, 21, 18,  49, 27, 60,  19, 91, 27, 102, 19,  3,  36, 34,
    44,  45, 36, 76,  44, 87, 36, 118, 44, 19,  61, 30, 53,  58, 62,
    72,  53, 96, 62, 114, 53,  7,   1, 23, 10,  45,  1, 65,  10, 83,
     1, 107, 10,  8,  27, 20, 18,  50, 27, 61,  19, 92, 27, 103, 19,
     4,  36, 35, 44,  46, 36, 77,  44, 88, 36, 119, 44, 19,  62, 31,
    53,  57, 62, 73,  53, 95, 62, 115, 53,  6,   1, 24, 10,  44,  1,
    66,  10, 82,  1, 108, 10,  9,  27, 20, 19,  51, 27, 62,  19, 93,
    27, 104, 19,  5,  36, 36, 44,  47, 36, 78,  44, 89, 36, 119, 45,
    18,  62, 32, 53,  56, 62, 74,  53, 94, 62, 116, 53,  5,   1, 25,
    10,  43,  1, 67,  10, 81,  1, 109, 10, 10,  27, 21, 19,  52, 27,
    63,  19, 94, 27, 105, 19,  6,  36, 37, 44,  48, 36, 79,  44, 90,
    36, 118, 45, 17,  62, 33, 53,  55, 62, 75,  53, 93, 62, 117, 53,
     4,   1, 26, 10,  42,  1, 68,  10, 80,  1, 110, 10, 11,  27, 22,
    19,  53, 27, 64,  19, 95, 27, 106, 19,  7,  36, 38, 44,  49, 36,
    79,  45, 91, 36, 117, 45, 16,  62, 34, 53,  54, 62, 76,  53, 92,
    62, 118, 53,  3,   1, 27, 10,  41,  1, 69,  10, 80,  2, 111, 10,
    12,  27, 23, 19,  54, 27, 65,  19, 96, 27, 107, 19,  8,  36, 39,
    44,  50, 36, 78,  45, 92, 36, 116, 45, 15,  62, 35, 53,  53, 62,
    77,  53, 91, 62, 119, 53,  2,   1, 28, 10,  40,  1, 70,  10, 81,
     2, 112, 10, 13,  27, 24, 19,  55, 27, 66,  19, 97, 27, 108, 19,
     9,  36, 39, 45,  51, 36, 77,  45, 93, 36, 115, 45, 14,  62, 36,
    53,  52, 62, 78,  53, 90, 62, 119, 54,  1,   1, 29, 10,  40,  2,
    71,  10, 82,  2, 113, 10, 14,  27, 25, 19,  56, 27, 67,  19, 98,
    27, 109, 19, 10,  36, 38, 45,  52, 36, 76,  45, 94, 36, 114, 45,
    13,  62, 37, 53,  51, 62, 79,  53, 89, 62, 118, 54,  0,   1, 30,
    10,  41,  2, 72,  10, 83,  2, 114, 10, 15,  27, 26, 19,  57, 27,
    68,  19, 99, 27, 110, 19, 11,  36, 37, 45,  53, 36, 75,  45, 95,
    36, 113, 45, 12,  62, 38, 53,  50, 62, 79,  54, 88, 62, 117, 54,
     0,   2, 31, 10,  42,  2, 73,  10, 84,  2, 115, 10, 16,  27, 27,
    19,  58, 27, 69,  19, 99, 28, 111, 19, 12,  36, 36, 45,  54, 36,
    74,  45, 96, 36, 112, 45, 11,  62, 39, 53,  49, 62, 78,  54, 87,
    62, 116, 54,  1,   2, 32, 10,  43,  2, 74,  10, 85,  2, 116, 10,
    17,  27, 28, 19,  59, 27, 70,  19, 98, 28, 112, 19, 13,  36, 35,
    45,  55, 36, 73,  45, 97, 36, 111, 45, 10,  62, 39, 54,  48, 62,
    77,  54, 86, 62, 115, 54,  2,   2, 33, 10,  44,  2, 75,  10, 86,
     2, 117, 10, 18,  27, 29, 19,  59, 28, 71,  19, 97, 28, 113, 19,
    14,  36, 34, 45,  56, 36, 72,  45, 98, 36, 110, 45,  9,  62, 38,
    54,  47, 62, 76,  54, 85, 62, 114, 54,  3,   2, 34, 10,  45,  2,
    76,  10, 87,  2, 118, 10, 19,  27, 30, 19,  58, 28, 72,  19, 96,
    28, 114, 19, 15,  36, 33, 45,  57, 36, 71,  45, 99, 36, 109, 45,
     8,  62, 37, 54,  46, 62, 75,  54, 84, 62, 113, 54,  4,   2, 35,
    10,  46,  2, 77,  10, 88,  2, 119, 10, 19,  28, 31, 19,  57, 28,
    73,  19, 95, 28, 115, 19, 16,  36, 32, 45,  58, 36, 70,  45, 99,
    37, 108, 45,  7,  62, 36, 54,  45, 62, 74,  54, 83, 62, 112, 54,
     5,   2, 36, 10,  47,  2, 78,  10, 89,  2, 119, 11, 18,  28, 32,
    19,  56, 28, 74,  19, 94, 28, 116, 19, 17,  36, 31, 45,  59, 36,
    69,  45, 98, 37, 107, 45,  6,  62, 35, 54,  44, 62, 73,  54, 82,
    62, 111, 54,  6,   2, 37, 10,  48,  2, 79,  10, 90,  2, 118, 11,
    17,  28, 33, 19,  55, 28, 75,  19, 93, 28, 117, 19, 18,  36, 30,
    45,  59, 37, 68,  45, 97, 37, 106, 45,  5,  62, 34, 54,  43, 62,
    72,  54, 81, 62, 110, 54,  7,   2, 38, 10,  49,  2, 79,  11, 91,
     2, 117, 11, 16,  28, 34, 19,  54, 28, 76,  19, 92, 28, 118, 19,
    19,  36, 29, 45,  58, 37, 67,  45, 96, 37, 105, 45,  4,  62, 33,
    54,  42, 62, 71,  54, 80, 62, 109, 54,  8,   2, 39, 10,  50,  2,
    78,  11, 92,  2, 116, 11, 15,  28, 35, 19,  53, 28, 77,  19, 91,
    28, 119, 19, 19,  37, 28, 45,  57, 37, 66,  45, 95, 37, 104, 45,
     3,  62, 32, 54,  41, 62, 70,  54, 80, 63, 108, 54,  9,   2, 39,
    11,  51,  2, 77,  11, 93,  2, 115, 11, 14,  28, 36, 19,  52, 28,
    78,  19, 90, 28, 119, 20, 18,  37, 27, 45,  56, 37, 65,  45, 94,
    37, 103, 45,  2,  62, 31, 54,  40, 62, 69,  54, 81, 63, 107, 54,
    10,   2, 38, 11,  52,  2, 76,  11, 94,  2, 114, 11, 13,  28, 37,
    19,  51, 28, 79,  19, 89, 28, 118, 20, 17,  37, 26, 45,  55, 37,
    64,  45, 93, 37, 102, 45,  1,  62, 30, 54,  40, 63, 68,  54, 82,
    63, 106, 54, 11,   2, 37, 11,  53,  2, 75,  11, 95,  2, 113, 11,
    12,  28, 38, 19,  50, 28, 79,  20, 88, 28, 117, 20, 16,  37, 25,
    45,  54, 37, 63,  45, 92, 37, 101, 45,  0,  62, 29, 54,  41, 63,
    67,  54, 83, 63, 105, 54, 12,   2, 36, 11,  54,  2, 74,  11, 96,
     2, 112, 11, 11,  28, 39, 19,  49, 28, 78,  20, 87, 28, 116, 20,
    15,  37, 24, 45,  53, 37, 62,  45, 91, 37, 100, 45,  0,  63, 28,
    54,  42, 63, 66,  54, 84, 63, 104, 54, 13,   2, 35, 11,  55,  2,
    73,  11, 97,  2, 111, 11, 10,  28, 39, 20,  48, 28, 77,  20, 86,
    28, 115, 20, 14,  37, 23, 45,  52, 37, 61,  45, 90, 37, 100, 46,
     1,  63, 27, 54,  43, 63, 65,  54, 85, 63, 103, 54, 14,   2, 34,
    11,  56,  2, 72,  11, 98,  2, 110, 11,  9,  28, 38, 20,  47, 28,
    76,  20, 85, 28, 114, 20, 13,  37, 22, 45,  51, 37, 60,  45, 89,
    37, 101, 46,  2,  63, 26, 54,  44, 63, 64,  54, 86, 63, 102, 54,
    15,   2, 33, 11,  57,  2, 71,  11, 99,  2, 109, 11,  8,  28, 37,
    20,  46, 28, 75,  20, 84, 28, 113, 20, 12,  37, 21, 45,  50, 37,
    60,  46, 88, 37, 102, 46,  3,  63, 25, 54,  45, 63, 63,  54, 87,
    63, 101, 54, 16,   2, 32, 11,  58,  2, 70,  11, 99,  3, 108, 11,
     7,  28, 36, 20,  45, 28, 74,  20, 83, 28, 112, 20, 11,  37, 20,
    45,  49, 37, 61,  46, 87, 37, 103, 46,  4,  63, 24, 54,  46, 63,
    62,  54, 88, 63, 100, 54, 17,   2, 31, 11,  59,  2, 69,  11, 98,
     3, 107, 11,  6,  28, 35, 20,  44, 28, 73,  20, 82, 28, 111, 20,
    10,  37, 20, 46,  48, 37, 62,  46, 86, 37, 104, 46,  5,  63, 23,
    54,  47, 63, 61,  54, 89, 63, 100, 55, 18,   2, 30, 11,  59,  3,
    68,  11, 97,  3, 106, 11,  5,  28, 34, 20,  43, 28, 72,  20, 81,
    28, 110, 20,  9,  37, 21, 46,  47, 37, 63,  46, 85, 37, 105, 46,
     6,  63, 22, 54,  48, 63, 60,  54, 90, 63, 101, 55, 19,   2, 29,
    11,  58,  3, 67,  11, 96,  3, 105, 11,  4,  28, 33, 20,  42, 28,
    71,  20, 80, 28, 109, 20,  8,  37, 22, 46,  46, 37, 64,  46, 84,
    37, 106, 46,  7,  63, 21, 54,  49, 63, 60,  55, 91, 63, 102, 55,
    19,   3, 28, 11,  57,  3, 66,  11, 95,  3, 104, 11,  3,  28, 32,
    20,  41, 28, 70,  20, 80, 29, 108, 20,  7,  37, 23, 46,  45, 37,
    65,  46, 83, 37, 107, 46,  8,  63, 20, 54,  50, 63, 61,  55, 92,
    63, 103, 55, 18,   3, 27, 11,  56,  3, 65,  11, 94,  3, 103, 11,
     2,  28, 31, 20,  40, 28, 69,  20, 81, 29, 107, 20,  6,  37, 24,
    46,  44, 37, 66,  46, 82, 37, 108, 46,  9,  63, 20, 55,  51, 63,
    62,  55, 93, 63, 104, 55, 17,   3, 26, 11,  55,  3, 64,  11, 93,
     3, 102, 11,  1,  28, 30, 20,  40, 29, 68,  20, 82, 29, 106, 20,
     5,  37, 25, 46,  43, 37, 67,  46, 81, 37, 109, 46, 10,  63, 21,
    55,  52, 63, 63,  55, 94, 63, 105, 55, 16,   3, 25, 11,  54,  3,
    63,  11, 92,  3, 101, 11,  0,  28, 29, 20,  41, 29, 67,  20, 83,
    29, 105, 20,  4,  37, 26, 46,  42, 37, 68,  46, 80, 37, 110, 46,
    11,  63, 22, 55,  53, 63, 64,  55, 95, 63, 106, 55, 15,   3, 24,
    11,  53,  3, 62,  11, 91,  3, 100, 11,  0,  29, 28, 20,  42, 29,
    66,  20, 84, 29, 104, 20,  3,  37, 27, 46,  41, 37, 69,  46, 80,
    38, 111, 46, 12,  63, 23, 55,  54, 63, 65,  55, 96, 63, 107, 55,
    14,   3, 23, 11,  52,  3, 61,  11, 90,  3, 100, 12,  1,  29, 27,
    20,  43, 29, 65,  20, 85, 29, 103, 20,  2,  37, 28, 46,  40, 37,
    70,  46, 81, 38, 112, 46, 13,  63, 24, 55,  55, 63, 66,  55, 97,
    63, 108, 55, 13,   3, 22, 11,  51,  3, 60,  11, 89,  3, 101, 12,
     2,  29, 26, 20,  44, 29, 64,  20, 86, 29, 102, 20,  1,  37, 29,
    46,  40, 38, 71,  46, 82, 38, 113, 46, 14,  63, 25, 55,  56, 63,
    67,  55, 98, 63, 109, 55, 12,   3, 21, 11,  50,  3, 60,  12, 88,
     3, 102, 12,  3,  29, 25, 20,  45, 29, 63,  20, 87, 29, 101, 20,
     0,  37, 30, 46,  41, 38, 72,  46, 83, 38, 114, 46, 15,  63, 26,
    55,  57, 63, 68,  55, 99, 63, 110, 55, 11,   3, 20, 11,  49,  3,
    61,  12, 87,  3, 103, 12,  4,  29, 24, 20,  46, 29, 62,  20, 88,
    29, 100, 20,  0,  38, 31, 46,  42, 38, 73,  46, 84, 38, 115, 46,
    16,  63, 27, 55,  58, 63, 69,  55, 99, 64, 111, 55, 10,   3, 20,
    12,  48,  3, 62,  12, 86,  3, 104, 12,  5,  29, 23, 20,  47, 29,
    61,  20, 89, 29, 100, 21,  1,  38, 32, 46,  43, 38, 74,  46, 85,
    38, 116, 46, 17,  63, 28, 55,  59, 63, 70,  55, 98, 64, 112, 55,
     9,   3, 21, 12,  47,  3, 63,  12, 85,  3, 105, 12,  6,  29, 22,
    20,  48, 29, 60,  20, 90, 29, 101, 21,  2,  38, 33, 46,  44, 38,
    75,  46, 86, 38, 117, 46, 18,  63, 29, 55,  59, 64, 71,  55, 97,
    64, 113, 55,  8,   3, 22, 12,  46,  3, 64,  12, 84,  3, 106, 12,
     7,  29, 21, 20,  49, 29, 60,  21, 91, 29, 102, 21,  3,  38, 34,
    46,  45, 38, 76,  46, 87, 38, 118, 46, 19,  63, 30, 55,  58, 64,
    72,  55, 96, 64, 114, 55,  7,   3, 23, 12,  45,  3, 65,  12, 83,
     3, 107, 12,  8,  29, 20, 20,  50, 29, 61,  21, 92, 29, 103, 21,
     4,  38, 35, 46,  46, 38, 77,  46, 88, 38, 119, 46, 19,  64, 31,
    55,  57, 64, 73,  55, 95, 64, 115, 55,  6,   3, 24, 12,  44,  3,
    66,  12, 82,  3, 108, 12,  9,  29, 20, 21,  51, 29, 62,  21, 93,
    29, 104, 21,  5,  38, 36, 46,  47, 38, 78,  46, 89, 38, 119, 47,
    18,  64, 32, 55,  56, 64, 74,  55, 94, 64, 116, 55,  5,   3, 25,
    12,  43,  3, 67,  12, 81,  3, 109, 12, 10,  29, 21, 21,  52, 29,
    63,  21, 94, 29, 105, 21,  6,  38, 37, 46,  48, 38, 79,  46, 90,
    38, 118, 47, 17,  64, 33, 55,  55, 64, 75,  55, 93, 64, 117, 55,
     4,   3, 26, 12,  42,  3, 68,  12, 80,  3, 110, 12, 11,  29, 22,
    21,  53, 29, 64,  21, 95, 29, 106, 21,  7,  38, 38, 46,  49, 38,
    79,  47, 91, 38, 117, 47, 16,  64, 34, 55,  54, 64, 76,  55, 92,
    64, 118, 55,  3,   3, 27, 12,  41,  3, 69,  12, 80,  4, 111, 12,
    12,  29, 23, 21,  54, 29, 65,  21, 96, 29, 107, 21,  8,  38, 39,
    46,  50, 38, 78,  47, 92, 38, 116, 47, 15,  64, 35, 55,  53, 64,
    77,  55, 91, 64, 119, 55,  2,   3, 28, 12,  40,  3, 70,  12, 81,
     4, 112, 12, 13,  29, 24, 21,  55, 29, 66,  21, 97, 29, 108, 21,
     9,  38, 39, 47,  51, 38, 77,  47, 93, 38, 115, 47, 14,  64, 36,
    55,  52, 64, 78,  55, 90, 64, 119, 56,  1,   3, 29, 12,  40,  4,
    71,  12, 82,  4, 113, 12, 14,  29, 25, 21,  56, 29, 67,  21, 98,
    29, 109, 21, 10,  38, 38, 47,  52, 38, 76,  47, 94, 38, 114, 47,
    13,  64, 37, 55,  51, 64, 79,  55, 89, 64, 118, 56,  0,   3, 30,
    12,  41,  4, 72,  12, 83,  4, 114, 12, 15,  29, 26, 21,  57, 29,
    68,  21, 99, 29, 110, 21, 11,  38, 37, 47,  53, 38, 75,  47, 95,
    38, 113, 47, 12,  64, 38, 55,  50, 64, 79,  56, 88, 64, 117, 56,
     0,   4, 31, 12,  42,  4, 73,  12, 84,  4, 115, 12, 16,  29, 27,
    21,  58, 29, 69,  21, 99, 30, 111, 21, 12,  38, 36, 47,  54, 38,
    74,  47, 96, 38, 112, 47, 11,  64, 39, 55,  49, 64, 78,  56, 87,
    64, 116, 56,  1,   4, 32, 12,  43,  4, 74,  12, 85,  4, 116, 12,
    17,  29, 28, 21,  59, 29, 70,  21, 98, 30, 112, 21, 13,  38, 35,
    47,  55, 38, 73,  47, 97, 38, 111, 47, 10,  64, 39, 56,  48, 64,
    77,  56, 86, 64, 115, 56,  2,   4, 33, 12,  44,  4, 75,  12, 86,
     4, 117, 12, 18,  29, 29, 21,  59, 30, 71,  21, 97, 30, 113, 21,
    14,  38, 34, 47,  56, 38, 72,  47, 98, 38, 110, 47,  9,  64, 38,
    56,  47, 64, 76,  56, 85, 64, 114, 56,  3,   4, 34, 12,  45,  4,
    76,  12, 87,  4, 118, 12, 19,  29, 30, 21,  58, 30, 72,  21, 96,
    30, 114, 21, 15,  38, 33, 47,  57, 38, 71,  47, 99, 38, 109, 47,
     8,  64, 37, 56,  46, 64, 75,  56, 84, 64, 113, 56,  4,   4, 35,
    12,  46,  4, 77,  12, 88,  4, 119, 12, 19,  30, 31, 21,  57, 30,
    73,  21, 95, 30, 115, 21, 16,  38, 32, 47,  58, 38, 70,  47, 99,
    39, 108, 47,  7,  64, 36, 56,  45, 64, 74,  56, 83, 64, 112, 56,
     5,   4, 36, 12,  47,  4, 78,  12, 89,  4, 119, 13, 18,  30, 32,
    21,  56, 30, 74,  21, 94, 30, 116, 21, 17,  38, 31, 47,  59, 38,
    69,  47, 98, 39, 107, 47,  6,  64, 35, 56,  44, 64, 73,  56, 82,
    64, 111, 56,  6,   4, 37, 12,  48,  4, 79,  12, 90,  4, 118, 13,
    17,  30, 33, 21,  55, 30, 75,  21, 93, 30, 117, 21, 18,  38, 30,
    47,  59, 39, 68,  47, 97, 39, 106, 47,  5,  64, 34, 56,  43, 64,
    72,  56, 81, 64, 110, 56,  7,   4, 38, 12,  49,  4, 79,  13, 91,
     4, 117, 13, 16,  30, 34, 21,  54, 30, 76,  21, 92, 30, 118, 21,
    19,  38, 29, 47,  58, 39, 67,  47, 96, 39, 105, 47,  4,  64, 33,
    56,  42, 64, 71,  56, 80, 64, 109, 56,  8,   4, 39, 12,  50,  4,
    78,  13, 92,  4, 116, 13, 15,  30, 35, 21,  53, 30, 77,  21, 91,
    30, 119, 21, 19,  39, 28, 47,  57, 39, 66,  47, 95, 39, 104, 47,
     3,  64, 32, 56,  41, 64, 70,  56, 80, 65, 108, 56,  9,   4, 39,
    13,  51,  4, 77,  13, 93,  4, 115, 13, 14,  30, 36, 21,  52, 30,
    78,  21, 90, 30, 119, 22, 18,  39, 27, 47,  56, 39, 65,  47, 94,
    39, 103, 47,  2,  64, 31, 56,  40, 64, 69,  56, 81, 65, 107, 56,
    10,   4, 38, 13,  52,  4, 76,  13, 94,  4, 114, 13, 13,  30, 37,
    21,  51, 30, 79,  21, 89, 30, 118, 22, 17,  39, 26, 47,  55, 39,
    64,  47, 93, 39, 102, 47,  1,  64, 30, 56,  40, 65, 68,  56, 82,
    65, 106, 56, 11,   4, 37, 13,  53,  4, 75,  13, 95,  4, 113, 13,
    12,  30, 38, 21,  50, 30, 79,  22, 88, 30, 117, 22, 16,  39, 25,
    47,  54, 39, 63,  47, 92, 39, 101, 47,  0,  64, 29, 56,  41, 65,
    67,  56, 83, 65, 105, 56, 12,   4, 36, 13,  54,  4, 74,  13, 96,
     4, 112, 13, 11,  30, 39, 21,  49, 30, 78,  22, 87, 30, 116, 22,
    15,  39, 24, 47,  53, 39, 62,  47, 91, 39, 100, 47,  0,  65, 28,
    56,  42, 65, 66,  56, 84, 65, 104, 56, 13,   4, 35, 13,  55,  4,
    73,  13, 97,  4, 111, 13, 10,  30, 39, 22,  48, 30, 77,  22, 86,
    30, 115, 22, 14,  39, 23, 47,  52, 39, 61,  47, 90, 39, 100, 48,
     1,  65, 27, 56,  43, 65, 65,  56, 85, 65, 103, 56, 14,   4, 34,
    13,  56,  4, 72,  13, 98,  4, 110, 13,  9,  30, 38, 22,  47, 30,
    76,  22, 85, 30, 114, 22, 13,  39, 22, 47,  51, 39, 60,  47, 89,
    39, 101, 48,  2,  65, 26, 56,  44, 65, 64,  56, 86, 65, 102, 56,
    15,   4, 33, 13,  57,  4, 71,  13, 99,  4, 109, 13,  8,  30, 37,
    22,  46, 30, 75,  22, 84, 30, 113, 22, 12,  39, 21, 47,  50, 39,
    60,  48, 88, 39, 102, 48,  3,  65, 25, 56,  45, 65, 63,  56, 87,
    65, 101, 56, 16,   4, 32, 13,  58,  4, 70,  13, 99,  5, 108, 13,
     7,  30, 36, 22,  45, 30, 74,  22, 83, 30, 112, 22, 11,  39, 20,
    47,  49, 39, 61,  48, 87, 39, 103, 48,  4,  65, 24, 56,  46, 65,
    62,  56, 88, 65, 100, 56, 17,   4, 31, 13,  59,  4, 69,  13, 98,
     5, 107, 13,  6,  30, 35, 22,  44, 30, 73,  22, 82, 30, 111, 22,
    10,  39, 20, 48,  48, 39, 62,  48, 86, 39, 104, 48,  5,  65, 23,
    56,  47, 65, 61,  56, 89, 65, 100, 57, 18,   4, 30, 13,  59,  5,
    68,  13, 97,  5, 106, 13,  5,  30, 34, 22,  43, 30, 72,  22, 81,
    30, 110, 22,  9,  39, 21, 48,  47, 39, 63,  48, 85, 39, 105, 48,
     6,  65, 22, 56,  48, 65, 60,  56, 90, 65, 101, 57, 19,   4, 29,
    13,  58,  5, 67,  13, 96,  5, 105, 13,  4,  30, 33, 22,  42, 30,
    71,  22, 80, 30, 109, 22,  8,  39, 22, 48,  46, 39, 64,  48, 84,
    39, 106, 48,  7,  65, 21, 56,  49, 65, 60,  57, 91, 65, 102, 57,
    19,   5, 28, 13,  57,  5, 66,  13, 95,  5, 104, 13,  3,  30, 32,
    22,  41, 30, 70,  22, 80, 31, 108, 22,  7,  39, 23, 48,  45, 39,
    65,  48, 83, 39, 107, 48,  8,  65, 20, 56,  50, 65, 61,  57, 92,
    65, 103, 57, 18,   5, 27, 13,  56,  5, 65,  13, 94,  5, 103, 13,
     2,  30, 31, 22,  40, 30, 69,  22, 81, 31, 107, 22,  6,  39, 24,
    48,  44, 39, 66,  48, 82, 39, 108, 48,  9,  65, 20, 57,  51, 65,
    62,  57, 93, 65, 104, 57, 17,   5, 26, 13,  55,  5, 64,  13, 93,
     5, 102, 13,  1,  30, 30, 22,  40, 31, 68,  22, 82, 31, 106, 22,
     5,  39, 25, 48,  43, 39, 67,  48, 81, 39, 109, 48, 10,  65, 21,
    57,  52, 65, 63,  57, 94, 65, 105, 57, 16,   5, 25, 13,  54,  5,
    63,  13, 92,  5, 101, 13,  0,  30, 29, 22,  41, 31, 67,  22, 83,
    31, 105, 22,  4,  39, 26, 48,  42, 39, 68,  48, 80, 39, 110, 48,
    11,  65, 22, 57,  53, 65, 64,  57, 95, 65, 106, 57, 15,   5, 24,
    13,  53,  5, 62,  13, 91,  5, 100, 13,  0,  31, 28, 22,  42, 31,
    66,  22, 84, 31, 104, 22,  3,  39, 27, 48,  41, 39, 69,  48, 80,
    40, 111, 48, 12,  65, 23, 57,  54, 65, 65,  57, 96, 65, 107, 57,
    14,   5, 23, 13,  52,  5, 61,  13, 90,  5, 100, 14,  1,  31, 27,
    22,  43, 31, 65,  22, 85, 31, 103, 22,  2,  39, 28, 48,  40, 39,
    70,  48, 81, 40, 112, 48, 13,  65, 24, 57,  55, 65, 66,  57, 97,
    65, 108, 57, 13,   5, 22, 13,  51,  5, 60,  13, 89,  5, 101, 14,
     2,  31, 26, 22,  44, 31, 64,  22, 86, 31, 102, 22,  1,  39, 29,
    48,  40, 40, 71,  48, 82, 40, 113, 48, 14,  65, 25, 57,  56, 65,
    67,  57, 98, 65, 109, 57, 12,   5, 21, 13,  50,  5, 60,  14, 88,
     5, 102, 14,  3,  31, 25, 22,  45, 31, 63,  22, 87, 31, 101, 22,
     0,  39, 30, 48,  41, 40, 72,  48, 83, 40, 114, 48, 15,  65, 26,
    57,  57, 65, 68,  57, 99, 65, 110, 57, 11,   5, 20, 13,  49,  5,
    61,  14, 87,  5, 103, 14,  4,  31, 24, 22,  46, 31, 62,  22, 88,
    31, 100, 22,  0,  40, 31, 48,  42, 40, 73,  48, 84, 40, 115, 48,
    16,  65, 27, 57,  58, 65, 69,  57, 99, 66, 111, 57, 10,   5, 20,
    14,  48,  5, 62,  14, 86,  5, 104, 14,  5,  31, 23, 22,  47, 31,
    61,  22, 89, 31, 100, 23,  1,  40, 32, 48,  43, 40, 74,  48, 85,
    40, 116, 48, 17,  65, 28, 57,  59, 65, 70,  57, 98, 66, 112, 57,
     9,   5, 21, 14,  47,  5, 63,  14, 85,  5, 105, 14,  6,  31, 22,
    22,  48, 31, 60,  22, 90, 31, 101, 23,  2,  40, 33, 48,  44, 40,
    75,  48, 86, 40, 117, 48, 18,  65, 29, 57,  59, 66, 71,  57, 97,
    66, 113, 57,  8,   5, 22, 14,  46,  5, 64,  14, 84,  5, 106, 14,
     7,  31, 21, 22,  49, 31, 60,  23, 91, 31, 102, 23,  3,  40, 34,
    48,  45, 40, 76,  48, 87, 40, 118, 48, 19,  65, 30, 57,  58, 66,
    72,  57, 96, 66, 114, 57,  7,   5, 23, 14,  45,  5, 65,  14, 83,
     5, 107, 14,  8,  31, 20, 22,  50, 31, 61,  23, 92, 31, 103, 23,
     4,  40, 35, 48,  46, 40, 77,  48, 88, 40, 119, 48, 19,  66, 31,
    57,  57, 66, 73,  57, 95, 66, 115, 57,  6,   5, 24, 14,  44,  5,
    66,  14, 82,  5, 108, 14,  9,  31, 20, 23,  51, 31, 62,  23, 93,
    31, 104, 23,  5,  40, 36, 48,  47, 40, 78,  48, 89, 40, 119, 49,
    18,  66, 32, 57,  56, 66, 74,  57, 94, 66, 116, 57,  5,   5, 25,
    14,  43,  5, 67,  14, 81,  5, 109, 14, 10,  31, 21, 23,  52, 31,
    63,  23, 94, 31, 105, 23,  6,  40, 37, 48,  48, 40, 79,  48, 90,
    40, 118, 49, 17,  66, 33, 57,  55, 66, 75,  57, 93, 66, 117, 57,
     4,   5, 26, 14,  42,  5, 68,  14, 80,  5, 110, 14, 11,  31, 22,
    23,  53, 31, 64,  23, 95, 31, 106, 23,  7,  40, 38, 48,  49, 40,
    79,  49, 91, 40, 117, 49, 16,  66, 34, 57,  54, 66, 76,  57, 92,
    66, 118, 57,  3,   5, 27, 14,  41,  5, 69,  14, 80,  6, 111, 14,
    12,  31, 23, 23,  54, 31, 65,  23, 96, 31, 107, 23,  8,  40, 39,
    48,  50, 40, 78,  49, 92, 40, 116, 49, 15,  66, 35, 57,  53, 66,
    77,  57, 91, 66, 119, 57,  2,   5, 28, 14,  40,  5, 70,  14, 81,
     6, 112, 14, 13,  31, 24, 23,  55, 31, 66,  23, 97, 31, 108, 23,
     9,  40, 39, 49,  51, 40, 77,  49, 93, 40, 115, 49, 14,  66, 36,
    57,  52, 66, 78,  57, 90, 66, 119, 58,  1,   5, 29, 14,  40,  6,
    71,  14, 82,  6, 113, 14, 14,  31, 25, 23,  56, 31, 67,  23, 98,
    31, 109, 23, 10,  40, 38, 49,  52, 40, 76,  49, 94, 40, 114, 49,
    13,  66, 37, 57,  51, 66, 79,  57, 89, 66, 118, 58,  0,   5, 30,
    14,  41,  6, 72,  14, 83,  6, 114, 14, 15,  31, 26, 23,  57, 31,
    68,  23, 99, 31, 110, 23, 11,  40, 37, 49,  53, 40, 75,  49, 95,
    40, 113, 49, 12,  66, 38, 57,  50, 66, 79,  58, 88, 66, 117, 58,
     0,   6, 31, 14,  42,  6, 73,  14, 84,  6, 115, 14, 16,  31, 27,
    23,  58, 31, 69,  23, 99, 32, 111, 23, 12,  40, 36, 49,  54, 40,
    74,  49, 96, 40, 112, 49, 11,  66, 39, 57,  49, 66, 78,  58, 87,
    66, 116, 58,  1,   6, 32, 14,  43,  6, 74,  14, 85,  6, 116, 14,
    17,  31, 28, 23,  59, 31, 70,  23, 98, 32, 112, 23, 13,  40, 35,
    49,  55, 40, 73,  49, 97, 40, 111, 49, 10,  66, 39, 58,  48, 66,
    77,  58, 86, 66, 115, 58,  2,   6, 33, 14,  44,  6, 75,  14, 86,
     6, 117, 14, 18,  31, 29, 23,  59, 32, 71,  23, 97, 32, 113, 23,
    14,  40, 34, 49,  56, 40, 72,  49, 98, 40, 110, 49,  9,  66, 38,
    58,  47, 66, 76,  58, 85, 66, 114, 58,  3,   6, 34, 14,  45,  6,
    76,  14, 87,  6, 118, 14, 19,  31, 30, 23,  58, 32, 72,  23, 96,
    32, 114, 23, 15,  40, 33, 49,  57, 40, 71,  49, 99, 40, 109, 49,
     8,  66, 37, 58,  46, 66, 75,  58, 84, 66, 113, 58,  4,   6, 35,
    14,  46,  6, 77,  14, 88,  6, 119, 14, 19,  32, 31, 23,  57, 32,
    73,  23, 95, 32, 115, 23, 16,  40, 32, 49,  58, 40, 70,  49, 99,
    41, 108, 49,  7,  66, 36, 58,  45, 66, 74,  58, 83, 66, 112, 58,
     5,   6, 36, 14,  47,  6, 78,  14, 89,  6, 119, 15, 18,  32, 32,
    23,  56, 32, 74,  23, 94, 32, 116, 23, 17,  40, 31, 49,  59, 40,
    69,  49, 98, 41, 107, 49,  6,  66, 35, 58,  44, 66, 73,  58, 82,
    66, 111, 58,  6,   6, 37, 14,  48,  6, 79,  14, 90,  6, 118, 15,
    17,  32, 33, 23,  55, 32, 75,  23, 93, 32, 117, 23, 18,  40, 30,
    49,  59, 41, 68,  49, 97, 41, 106, 49,  5,  66, 34, 58,  43, 66,
    72,  58, 81, 66, 110, 58,  7,   6, 38, 14,  49,  6, 79,  15, 91,
     6, 117, 15, 16,  32, 34, 23,  54, 32, 76,  23, 92, 32, 118, 23,
    19,  40, 29, 49,  58, 41, 67,  49, 96, 41, 105, 49,  4,  66, 33,
    58,  42, 66, 71,  58, 80, 66, 109, 58,  8,   6, 39, 14,  50,  6,
    78,  15, 92,  6, 116, 15, 15,  32, 35, 23,  53, 32, 77,  23, 91,
    32, 119, 23, 19,  41, 28, 49,  57, 41, 66,  49, 95, 41, 104, 49,
     3,  66, 32, 58,  41, 66, 70,  58, 80, 67, 108, 58,  9,   6, 39,
    15,  51,  6, 77,  15, 93,  6, 115, 15, 14,  32, 36, 23,  52, 32,
    78,  23, 90, 32, 119, 24, 18,  41, 27, 49,  56, 41, 65,  49, 94,
    41, 103, 49,  2,  66, 31, 58,  40, 66, 69,  58, 81, 67, 107, 58,
    10,   6, 38, 15,  52,  6, 76,  15, 94,  6, 114, 15, 13,  32, 37,
    23,  51, 32, 79,  23, 89, 32, 118, 24, 17,  41, 26, 49,  55, 41,
    64,  49, 93, 41, 102, 49,  1,  66, 30, 58,  40, 67, 68,  58, 82,
    67, 106, 58, 11,   6, 37, 15,  53,  6, 75,  15, 95,  6, 113, 15,
    12,  32, 38, 23,  50, 32, 79,  24, 88, 32, 117, 24, 16,  41, 25,
    49,  54, 41, 63,  49, 92, 41, 101, 49,  0,  66, 29, 58,  41, 67,
    67,  58, 83, 67, 105, 58, 12,   6, 36, 15,  54,  6, 74,  15, 96,
     6, 112, 15, 11,  32, 39, 23,  49, 32, 78,  24, 87, 32, 116, 24,
    15,  41, 24, 49,  53, 41, 62,  49, 91, 41, 100, 49,  0,  67, 28,
    58,  42, 67, 66,  58, 84, 67, 104, 58, 13,   6, 35, 15,  55,  6,
    73,  15, 97,  6, 111, 15, 10,  32, 39, 24,  48, 32, 77,  24, 86,
    32, 115, 24, 14,  41, 23, 49,  52, 41, 61,  49, 90, 41, 100, 50,
     1,  67, 27, 58,  43, 67, 65,  58, 85, 67, 103, 58, 14,   6, 34,
    15,  56,  6, 72,  15, 98,  6, 110, 15,  9,  32, 38, 24,  47, 32,
    76,  24, 85, 32, 114, 24, 13,  41, 22, 49,  51, 41, 60,  49, 89,
    41, 101, 50,  2,  67, 26, 58,  44, 67, 64,  58, 86, 67, 102, 58,
    15,   6, 33, 15,  57,  6, 71,  15, 99,  6, 109, 15,  8,  32, 37,
    24,  46, 32, 75,  24, 84, 32, 113, 24, 12,  41, 21, 49,  50, 41,
    60,  50, 88, 41, 102, 50,  3,  67, 25, 58,  45, 67, 63,  58, 87,
    67, 101, 58, 16,   6, 32, 15,  58,  6, 70,  15, 99,  7, 108, 15,
     7,  32, 36, 24,  45, 32, 74,  24, 83, 32, 112, 24, 11,  41, 20,
    49,  49, 41, 61,  50, 87, 41, 103, 50,  4,  67, 24, 58,  46, 67,
    62,  58, 88, 67, 100, 58, 17,   6, 31, 15,  59,  6, 69,  15, 98,
     7, 107, 15,  6,  32, 35, 24,  44, 32, 73,  24, 82, 32, 111, 24,
    10,  41, 20, 50,  48, 41, 62,  50, 86, 41, 104, 50,  5,  67, 23,
    58,  47, 67, 61,  58, 89, 67, 100, 59, 18,   6, 30, 15,  59,  7,
    68,  15, 97,  7, 106, 15,  5,  32, 34, 24,  43, 32, 72,  24, 81,
    32, 110, 24,  9,  41, 21, 50,  47, 41, 63,  50, 85, 41, 105, 50,
     6,  67, 22, 58,  48, 67, 60,  58, 90, 67, 101, 59, 19,   6, 29,
    15,  58,  7, 67,  15, 96,  7, 105, 15,  4,  32, 33, 24,  42, 32,
    71,  24, 80, 32, 109, 24,  8,  41, 22, 50,  46, 41, 64,  50, 84,
    41, 106, 50,  7,  67, 21, 58,  49, 67, 60,  59, 91, 67, 102, 59,
    19,   7, 28, 15,  57,  7, 66,  15, 95,  7, 104, 15,  3,  32, 32,
    24,  41, 32, 70,  24, 80, 33, 108, 24,  7,  41, 23, 50,  45, 41,
    65,  50, 83, 41, 107, 50,  8,  67, 20, 58,  50, 67, 61,  59, 92,
    67, 103, 59, 18,   7, 27, 15,  56,  7, 65,  15, 94,  7, 103, 15,
     2,  32, 31, 24,  40, 32, 69,  24, 81, 33, 107, 24,  6,  41, 24,
    50,  44, 41, 66,  50, 82, 41, 108, 50,  9,  67, 20, 59,  51, 67,
    62,  59, 93, 67, 104, 59, 17,   7, 26, 15,  55,  7, 64,  15, 93,
     7, 102, 15,  1,  32, 30, 24,  40, 33, 68,  24, 82, 33, 106, 24,
     5,  41, 25, 50,  43, 41, 67,  50, 81, 41, 109, 50, 10,  67, 21,
    59,  52, 67, 63,  59, 94, 67, 105, 59, 16,   7, 25, 15,  54,  7,
    63,  15, 92,  7, 101, 15,  0,  32, 29, 24,  41, 33, 67,  24, 83,
    33, 105, 24,  4,  41, 26, 50,  42, 41, 68,  50, 80, 41, 110, 50,
    11,  67, 22, 59,  53, 67, 64,  59, 95, 67, 106, 59, 15,   7, 24,
    15,  53,  7, 62,  15, 91,  7, 100, 15,  0,  33, 28, 24,  42, 33,
    66,  24, 84, 33, 104, 24,  3,  41, 27, 50,  41, 41, 69,  50, 80,
    42, 111, 50, 12,  67, 23, 59,  54, 67, 65,  59, 96, 67, 107, 59,
    14,   7, 23, 15,  52,  7, 61,  15, 90,  7, 100, 16,  1,  33, 27,
    24,  43, 33, 65,  24, 85, 33, 103, 24,  2,  41, 28, 50,  40, 41,
    70,  50, 81, 42, 112, 50, 13,  67, 24, 59,  55, 67, 66,  59, 97,
    67, 108, 59, 13,   7, 22, 15,  51,  7, 60,  15, 89,  7, 101, 16,
     2,  33, 26, 24,  44, 33, 64,  24, 86, 33, 102, 24,  1,  41, 29,
    50,  40, 42, 71,  50, 82, 42, 113, 50, 14,  67, 25, 59,  56, 67,
    67,  59, 98, 67, 109, 59, 12,   7, 21, 15,  50,  7, 60,  16, 88,
     7, 102, 16,  3,  33, 25, 24,  45, 33, 63,  24, 87, 33, 101, 24,
     0,  41, 30, 50,  41, 42, 72,  50, 83, 42, 114, 50, 15,  67, 26,
    59,  57, 67, 68,  59, 99, 67, 110, 59, 11,   7, 20, 15,  49,  7,
    61,  16, 87,  7, 103, 16,  4,  33, 24, 24,  46, 33, 62,  24, 88,
    33, 100, 24,  0,  42, 31, 50,  42, 42, 73,  50, 84, 42, 115, 50,
    16,  67, 27, 59,  58, 67, 69,  59, 80, 51, 111, 59, 10,   7, 20,
    16,  48,  7, 62,  16, 86,  7, 104, 16,  5,  33, 23, 24,  47, 33,
    61,  24, 89, 33, 100, 25,  1,  42, 32, 50,  43, 42, 74,  50, 85,
    42, 116, 50, 17,  67, 28, 59,  59, 67, 70,  59, 81, 51, 112, 59,
     9,   7, 21, 16,  47,  7, 63,  16, 85,  7, 105, 16,  6,  33, 22,
    24,  48, 33, 60,  24, 90, 33, 101, 25,  2,  42, 33, 50,  44, 42,
    75,  50, 86, 42, 117, 50, 18,  67, 29, 59,  40, 51, 71,  59, 82,
    51, 113, 59,  8,   7, 22, 16,  46,  7, 64,  16, 84,  7, 106, 16,
     7,  33, 21, 24,  49, 33, 60,  25, 91, 33, 102, 25,  3,  42, 34,
    50,  45, 42, 76,  50, 87, 42, 118, 50, 19,  67, 30, 59,  41, 51,
    72,  59, 83, 51, 114, 59,  7,   7, 23, 16,  45,  7, 65,  16, 83,
     7, 107, 16,  8,  33, 20, 24,  50, 33, 61,  25, 92, 33, 103, 25,
     4,  42, 35, 50,  46, 42, 77,  50, 88, 42, 119, 50,  0,  51, 31,
    59,  42, 51, 73,  59, 84, 51, 115, 59,  6,   7, 24, 16,  44,  7,
    66,  16, 82,  7, 108, 16,  9,  33, 20, 25,  51, 33, 62,  25, 93,
    33, 104, 25,  5,  42, 36, 50,  47, 42, 78,  50, 89, 42, 100, 34,
     1,  51, 32, 59,  43, 51, 74,  59, 85, 51, 116, 59,  5,   7, 25,
    16,  43,  7, 67,  16, 81,  7, 109, 16, 10,  33, 21, 25,  52, 33,
    63,  25, 94, 33, 105, 25,  6,  42, 37, 50,  48, 42, 79,  50, 90,
    42, 101, 34,  2,  51, 33, 59,  44, 51, 75,  59, 86, 51, 117, 59,
     4,   7, 26, 16,  42,  7, 68,  16, 80,  7, 110, 16, 11,  33, 22,
    25,  53, 33, 64,  25, 95, 33, 106, 25,  7,  42, 38, 50,  49, 42,
    60,  34, 91, 42, 102, 34,  3,  51, 34, 59,  45, 51, 76,  59, 87,
    51, 118, 59,  3,   7, 27, 16,  41,  7, 69,  16, 80,  8, 111, 16,
    12,  33, 23, 25,  54, 33, 65,  25, 96, 33, 107, 25,  8,  42, 39,
    50,  50, 42, 61,  34, 92, 42, 103, 34,  4,  51, 35, 59,  46, 51,
    77,  59, 88, 51, 119, 59,  2,   7, 28, 16,  40,  7, 70,  16, 81,
     8, 112, 16, 13,  33, 24, 25,  55, 33, 66,  25, 97, 33, 108, 25,
     9,  42, 20, 34,  51, 42, 62,  34, 93, 42, 104, 34,  5,  51, 36,
    59,  47, 51, 78,  59, 89, 51, 119, 60,  1,   7, 29, 16,  40,  8,
    71,  16, 82,  8, 113, 16, 14,  33, 25, 25,  56, 33, 67,  25, 98,
    33, 109, 25, 10,  42, 21, 34,  52, 42, 63,  34, 94, 42, 105, 34,
     6,  51, 37, 59,  48, 51, 79,  59, 90, 51, 118, 60,  0,   7, 30,
    16,  41,  8, 72,  16, 83,  8, 114, 16, 15,  33, 26, 25,  57, 33,
    68,  25, 99, 33, 110, 25, 11,  42, 22, 34,  53, 42, 64,  34, 95,
    42, 106, 34,  7,  51, 38, 59,  49, 51, 79,  60, 91, 51, 117, 60,
     0,   8, 31, 16,  42,  8, 73,  16, 84,  8, 115, 16, 16,  33, 27,
    25,  58, 33, 69,  25, 80, 17, 111, 25, 12,  42, 23, 34,  54, 42,
    65,  34, 96, 42, 107, 34,  8,  51, 39, 59,  50, 51, 78,  60, 92,
    51, 116, 60,  1,   8, 32, 16,  43,  8, 74,  16, 85,  8, 116, 16,
    17,  33, 28, 25,  59, 33, 70,  25, 81, 17, 112, 25, 13,  42, 24,
    34,  55, 42, 66,  34, 97, 42, 108, 34,  9,  51, 39, 60,  51, 51,
    77,  60, 93, 51, 115, 60,  2,   8, 33, 16,  44,  8, 75,  16, 86,
     8, 117, 16, 18,  33, 29, 25,  40, 17, 71,  25, 82, 17, 113, 25,
    14,  42, 25, 34,  56, 42, 67,  34, 98, 42, 109, 34, 10,  51, 38,
    60,  52, 51, 76,  60, 94, 51, 114, 60,  3,   8, 34, 16,  45,  8,
    76,  16, 87,  8, 118, 16, 19,  33, 30, 25,  41, 17, 72,  25, 83,
    17, 114, 25, 15,  42, 26, 34,  57, 42, 68,  34, 99, 42, 110, 34,
    11,  51, 37, 60,  53, 51, 75,  60, 95, 51, 113, 60,  4,   8, 35,
    16,  46,  8, 77,  16, 88,  8, 119, 16,  0,  17, 31, 25,  42, 17,
    73,  25, 84, 17, 115, 25, 16,  42, 27, 34,  58, 42, 69,  34, 99,
    43, 111, 34, 12,  51, 36, 60,  54, 51, 74,  60, 96, 51, 112, 60,
     5,   8, 36, 16,  47,  8, 78,  16, 89,  8, 100,  0,  1,  17, 32,
    25,  43, 17, 74,  25, 85, 17, 116, 25, 17,  42, 28, 34,  59, 42,
    70,  34, 98, 43, 112, 34, 13,  51, 35, 60,  55, 51, 73,  60, 97,
    51, 111, 60,  6,   8, 37, 16,  48,  8, 79,  16, 90,  8, 101,  0,
     2,  17, 33, 25,  44, 17, 75,  25, 86, 17, 117, 25, 18,  42, 29,
    34,  59, 43, 71,  34, 97, 43, 113, 34, 14,  51, 34, 60,  56, 51,
    72,  60, 98, 51, 110, 60,  7,   8, 38, 16,  49,  8, 60,   0, 91,
     8, 102,  0,  3,  17, 34, 25,  45, 17, 76,  25, 87, 17, 118, 25,
    19,  42, 30, 34,  58, 43, 72,  34, 96, 43, 114, 34, 15,  51, 33,
    60,  57, 51, 71,  60, 99, 51, 109, 60,  8,   8, 39, 16,  50,  8,
    61,   0, 92,  8, 103,  0,  4,  17, 35, 25,  46, 17, 77,  25, 88,
    17, 119, 25, 19,  43, 31, 34,  57, 43, 73,  34, 95, 43, 115, 34,
    16,  51, 32, 60,  58, 51, 70,  60, 99, 52, 108, 60,  9,   8, 20,
     0,  51,  8, 62,   0, 93,  8, 104,  0,  5,  17, 36, 25,  47, 17,
    78,  25, 89, 17, 119, 26, 18,  43, 32, 34,  56, 43, 74,  34, 94,
    43, 116, 34, 17,  51, 31, 60,  59, 51, 69,  60, 98, 52, 107, 60,
    10,   8, 21,  0,  52,  8, 63,   0, 94,  8, 105,  0,  6,  17, 37,
    25,  48, 17, 79,  25, 90, 17, 118, 26, 17,  43, 33, 34,  55, 43,
    75,  34, 93, 43, 117, 34, 18,  51, 30, 60,  59, 52, 68,  60, 97,
    52, 106, 60, 11,   8, 22,  0,  53,  8, 64,   0, 95,  8, 106,  0,
     7,  17, 38, 25,  49, 17, 79,  26, 91, 17, 117, 26, 16,  43, 34,
    34,  54, 43, 76,  34, 92, 43, 118, 34, 19,  51, 29, 60,  58, 52,
    67,  60, 96, 52, 105, 60, 12,   8, 23,  0,  54,  8, 65,   0, 96,
     8, 107,  0,  8,  17, 39, 25,  50, 17, 78,  26, 92, 17, 116, 26,
    15,  43, 35, 34,  53, 43, 77,  34, 91, 43, 119, 34, 19,  52, 28,
    60,  57, 52, 66,  60, 95, 52, 104, 60, 13,   8, 24,  0,  55,  8,
    66,   0, 97,  8, 108,  0,  9,  17, 39, 26,  51, 17, 77,  26, 93,
    17, 115, 26, 14,  43, 36, 34,  52, 43, 78,  34, 90, 43, 119, 35,
    18,  52, 27, 60,  56, 52, 65,  60, 94, 52, 103, 60, 14,   8, 25,
     0,  56,  8, 67,   0, 98,  8, 109,  0, 10,  17, 38, 26,  52, 17,
    76,  26, 94, 17, 114, 26, 13,  43, 37, 34,  51, 43, 79,  34, 89,
    43, 118, 35, 17,  52, 26, 60,  55, 52, 64,  60, 93, 52, 102, 60,
    15,   8, 26,  0,  57,  8, 68,   0, 99,  8, 110,  0, 11,  17, 37,
    26,  53, 17, 75,  26, 95, 17, 113, 26, 12,  43, 38, 34,  50, 43,
    79,  35, 88, 43, 117, 35, 16,  52, 25, 60,  54, 52, 63,  60, 92,
    52, 101, 60, 16,   8, 27,  0,  58,  8, 69,   0, 99,  9, 111,  0,
    12,  17, 36, 26,  54, 17, 74,  26, 96, 17, 112, 26, 11,  43, 39,
    34,  49, 43, 78,  35, 87, 43, 116, 35, 15,  52, 24, 60,  53, 52,
    62,  60, 91, 52, 100, 60, 17,   8, 28,  0,  59,  8, 70,   0, 98,
     9, 112,  0, 13,  17, 35, 26,  55, 17, 73,  26, 97, 17, 111, 26,
    10,  43, 39, 35,  48, 43, 77,  35, 86, 43, 115, 35, 14,  52, 23,
    60,  52, 52, 61,  60, 90, 52, 100, 61, 18,   8, 29,  0,  59,  9,
    71,   0, 97,  9, 113,  0, 14,  17, 34, 26,  56, 17, 72,  26, 98,
    17, 110, 26,  9,  43, 38, 35,  47, 43, 76,  35, 85, 43, 114, 35,
    13,  52, 22, 60,  51, 52, 60,  60, 89, 52, 101, 61, 19,   8, 30,
     0,  58,  9, 72,   0, 96,  9, 114,  0, 15,  17, 33, 26,  57, 17,
    71,  26, 99, 17, 109, 26,  8,  43, 37, 35,  46, 43, 75,  35, 84,
    43, 113, 35, 12,  52, 21, 60,  50, 52, 60,  61, 88, 52, 102, 61,
    19,   9, 31,  0,  57,  9, 73,   0, 95,  9, 115,  0, 16,  17, 32,
    26,  58, 17, 70,  26, 99, 18, 108, 26,  7,  43, 36, 35,  45, 43,
    74,  35, 83, 43, 112, 35, 11,  52, 20, 60,  49, 52, 61,  61, 87,
    52, 103, 61, 18,   9, 32,  0,  56,  9, 74,   0, 94,  9, 116,  0,
    17,  17, 31, 26,  59, 17, 69,  26, 98, 18, 107, 26,  6,  43, 35,
    35,  44, 43, 73,  35, 82, 43, 111, 35, 10,  52, 20, 61,  48, 52,
    62,  61, 86, 52, 104, 61, 17,   9, 33,  0,  55,  9, 75,   0, 93,
     9, 117,  0, 18,  17, 30, 26,  59, 18, 68,  26, 97, 18, 106, 26,
     5,  43, 34, 35,  43, 43, 72,  35, 81, 43, 110, 35,  9,  52, 21,
    61,  47, 52, 63,  61, 85, 52, 105, 61, 16,   9, 34,  0,  54,  9,
    76,   0, 92,  9, 118,  0, 19,  17, 29, 26,  58, 18, 67,  26, 96,
    18, 105, 26,  4,  43, 33, 35,  42, 43, 71,  35, 80, 43, 109, 35,
     8,  52, 22, 61,  46, 52, 64,  61, 84, 52, 106, 61, 15,   9, 35,
     0,  53,  9, 77,   0, 91,  9, 119,  0, 19,  18, 28, 26,  57, 18,
    66,  26, 95, 18, 104, 26,  3,  43, 32, 35,  41, 43, 70,  35, 80,
    44, 108, 35,  7,  52, 23, 61,  45, 52, 65,  61, 83, 52, 107, 61,
    14,   9, 36,  0,  52,  9, 78,   0, 90,  9, 119,  1, 18,  18, 27,
    26,  56, 18, 65,  26, 94, 18, 103, 26,  2,  43, 31, 35,  40, 43,
    69,  35, 81, 44, 107, 35,  6,  52, 24, 61,  44, 52, 66,  61, 82,
    52, 108, 61, 13,   9, 37,  0,  51,  9, 79,   0, 89,  9, 118,  1,
    17,  18, 26, 26,  55, 18, 64,  26, 93, 18, 102, 26,  1,  43, 30,
    35,  40, 44, 68,  35, 82, 44, 106, 35,  5,  52, 25, 61,  43, 52,
    67,  61, 81, 52, 109, 61, 12,   9, 38,  0,  50,  9, 79,   1, 88,
     9, 117,  1, 16,  18, 25, 26,  54, 18, 63,  26, 92, 18, 101, 26,
     0,  43, 29, 35,  41, 44, 67,  35, 83, 44, 105, 35,  4,  52, 26,
    61,  42, 52, 68,  61, 80, 52, 110, 61, 11,   9, 39,  0,  49,  9,
    78,   1, 87,  9, 116,  1, 15,  18, 24, 26,  53, 18, 62,  26, 91,
    18, 100, 26,  0,  44, 28, 35,  42, 44, 66,  35, 84, 44, 104, 35,
     3,  52, 27, 61,  41, 52, 69,  61, 80, 53, 111, 61, 10,   9, 39,
     1,  48,  9, 77,   1, 86,  9, 115,  1, 14,  18, 23, 26,  52, 18,
    61,  26, 90, 18, 100, 27,  1,  44, 27, 35,  43, 44, 65,  35, 85,
    44, 103, 35,  2,  52, 28, 61,  40, 52, 70,  61, 81, 53, 112, 61,
     9,   9, 38,  1,  47,  9, 76,   1, 85,  9, 114,  1, 13,  18, 22,
    26,  51, 18, 60,  26, 89, 18, 101, 27,  2,  44, 26, 35,  44, 44,
    64,  35, 86, 44, 102, 35,  1,  52, 29, 61,  40, 53, 71,  61, 82,
    53, 113, 61,  8,   9, 37,  1,  46,  9, 75,   1, 84,  9, 113,  1,
    12,  18, 21, 26,  50, 18, 60,  27, 88, 18, 102, 27,  3,  44, 25,
    35,  45, 44, 63,  35, 87, 44, 101, 35,  0,  52, 30, 61,  41, 53,
    72,  61, 83, 53, 114, 61,  7,   9, 36,  1,  45,  9, 74,   1, 83,
     9, 112,  1, 11,  18, 20, 26,  49, 18, 61,  27, 87, 18, 103, 27,
     4,  44, 24, 35,  46, 44, 62,  35, 88, 44, 100, 35,  0,  53, 31,
    61,  42, 53, 73,  61, 84, 53, 115, 61,  6,   9, 35,  1,  44,  9,
    73,   1, 82,  9, 111,  1, 10,  18, 20, 27,  48, 18, 62,  27, 86,
    18, 104, 27,  5,  44, 23, 35,  47, 44, 61,  35, 89, 44, 100, 36,
     1,  53, 32, 61,  43, 53, 74,  61, 85, 53, 116, 61,  5,   9, 34,
     1,  43,  9, 72,   1, 81,  9, 110,  1,  9,  18, 21, 27,  47, 18,
    63,  27, 85, 18, 105, 27,  6,  44, 22, 35,  48, 44, 60,  35, 90,
    44, 101, 36,  2,  53, 33, 61,  44, 53, 75,  61, 86, 53, 117, 61,
     4,   9, 33,  1,  42,  9, 71,   1, 80,  9, 109,  1,  8,  18, 22,
    27,  46, 18, 64,  27, 84, 18, 106, 27,  7,  44, 21, 35,  49, 44,
    60,  36, 91, 44, 102, 36,  3,  53, 34, 61,  45, 53, 76,  61, 87,
    53, 118, 61,  3,   9, 32,  1,  41,  9, 70,   1, 80, 10, 108,  1,
     7,  18, 23, 27,  45, 18, 65,  27, 83, 18, 107, 27,  8,  44, 20,
    35,  50, 44, 61,  36, 92, 44, 103, 36,  4,  53, 35, 61,  46, 53,
    77,  61, 88, 53, 119, 61,  2,   9, 31,  1,  40,  9, 69,   1, 81,
    10, 107,  1,  6,  18, 24, 27,  44, 18, 66,  27, 82, 18, 108, 27,
     9,  44, 20, 36,  51, 44, 62,  36, 93, 44, 104, 36,  5,  53, 36,
    61,  47, 53, 78,  61, 89, 53, 119, 62,  1,   9, 30,  1,  40, 10,
    68,   1, 82, 10, 106,  1,  5,  18, 25, 27,  43, 18, 67,  27, 81,
    18, 109, 27, 10,  44, 21, 36,  52, 44, 63,  36, 94, 44, 105, 36,
     6,  53, 37, 61,  48, 53, 79,  61, 90, 53, 118, 62,  0,   9, 29,
     1,  41, 10, 67,   1, 83, 10, 105,  1,  4,  18, 26, 27,  42, 18,
    68,  27, 80, 18, 110, 27, 11,  44, 22, 36,  53, 44, 64,  36, 95,
    44, 106, 36,  7,  53, 38, 61,  49, 53, 79,  62, 91, 53, 117, 62,
     0,  10, 28,  1,  42, 10, 66,   1, 84, 10, 104,  1,  3,  18, 27,
    27,  41, 18, 69,  27, 80, 19, 111, 27, 12,  44, 23, 36,  54, 44,
    65,  36, 96, 44, 107, 36,  8,  53, 39, 61,  50, 53, 78,  62, 92,
    53, 116, 62,  1,  10, 27,  1,  43, 10, 65,   1, 85, 10, 103,  1,
     2,  18, 28, 27,  40, 18, 70,  27, 81, 19, 112, 27, 13,  44, 24,
    36,  55, 44, 66,  36, 97, 44, 108, 36,  9,  53, 39, 62,  51, 53,
    77,  62, 93, 53, 115, 62,  2,  10, 26,  1,  44, 10, 64,   1, 86,
    10, 102,  1,  1,  18, 29, 27,  40, 19, 71,  27, 82, 19, 113, 27,
    14,  44, 25, 36,  56, 44, 67,  36, 98, 44, 109, 36, 10,  53, 38,
    62,  52, 53, 76,  62, 94, 53, 114, 62,  3,  10, 25,  1,  45, 10,
    63,   1, 87, 10, 101,  1,  0,  18, 30, 27,  41, 19, 72,  27, 83,
    19, 114, 27, 15,  44, 26, 36,  57, 44, 68,  36, 99, 44, 110, 36,
    11,  53, 37, 62,  53, 53, 75,  62, 95, 53, 113, 62,  4,  10, 24,
     1,  46, 10, 62,   1, 88, 10, 100,  1,  0,  19, 31, 27,  42, 19,
    73,  27, 84, 19, 115, 27, 16,  44, 27, 36,  58, 44, 69,  36, 99,
    45, 111, 36, 12,  53, 36, 62,  54, 53, 74,  62, 96, 53, 112, 62,
     5,  10, 23,  1,  47, 10, 61,   1, 89, 10, 100,  2,  1,  19, 32,
    27,  43, 19, 74,  27, 85, 19, 116, 27, 17,  44, 28, 36,  59, 44,
    70,  36, 98, 45, 112, 36, 13,  53, 35, 62,  55, 53, 73,  62, 97,
    53, 111, 62,  6,  10, 22,  1,  48, 10, 60,   1, 90, 10, 101,  2,
     2,  19, 33, 27,  44, 19, 75,  27, 86, 19, 117, 27, 18,  44, 29,
    36,  59, 45, 71,  36, 97, 45, 113, 36, 14,  53, 34, 62,  56, 53,
    72,  62, 98, 53, 110, 62,  7,  10, 21,  1,  49, 10, 60,   2, 91,
    10, 102,  2,  3,  19, 34, 27,  45, 19, 76,  27, 87, 19, 118, 27,
    19,  44, 30, 36,  58, 45, 72,  36, 96, 45, 114, 36, 15,  53, 33,
    62,  57, 53, 71,  62, 99, 53, 109, 62,  8,  10, 20,  1,  50, 10,
    61,   2, 92, 10, 103,  2,  4,  19, 35, 27,  46, 19, 77,  27, 88,
    19, 119, 27, 19,  45, 31, 36,  57, 45, 73,  36, 95, 45, 115, 36,
    16,  53, 32, 62,  58, 53, 70,  62, 99, 54, 108, 62,  9,  10, 20,
     2,  51, 10, 62,   2, 93, 10, 104,  2,  5,  19, 36, 27,  47, 19,
    78,  27, 89, 19, 119, 28, 18,  45, 32, 36,  56, 45, 74,  36, 94,
    45, 116, 36, 17,  53, 31, 62,  59, 53, 69,  62, 98, 54, 107, 62,
    10,  10, 21,  2,  52, 10, 63,   2, 94, 10, 105,  2,  6,  19, 37,
    27,  48, 19, 79,  27, 90, 19, 118, 28, 17,  45, 33, 36,  55, 45,
    75,  36, 93, 45, 117, 36, 18,  53, 30, 62,  59, 54, 68,  62, 97,
    54, 106, 62, 11,  10, 22,  2,  53, 10, 64,   2, 95, 10, 106,  2,
     7,  19, 38, 27,  49, 19, 79,  28, 91, 19, 117, 28, 16,  45, 34,
    36,  54, 45, 76,  36, 92, 45, 118, 36, 19,  53, 29, 62,  58, 54,
    67,  62, 96, 54, 105, 62, 12,  10, 23,  2,  54, 10, 65,   2, 96,
    10, 107,  2,  8,  19, 39, 27,  50, 19, 78,  28, 92, 19, 116, 28,
    15,  45, 35, 36,  53, 45, 77,  36, 91, 45, 119, 36, 19,  54, 28,
    62,  57, 54, 66,  62, 95, 54, 104, 62, 13,  10, 24,  2,  55, 10,
    66,   2, 97, 10, 108,  2,  9,  19, 39, 28,  51, 19, 77,  28, 93,
    19, 115, 28, 14,  45, 36, 36,  52, 45, 78,  36, 90, 45, 119, 37,
    18,  54, 27, 62,  56, 54, 65,  62, 94, 54, 103, 62, 14,  10, 25,
     2,  56, 10, 67,   2, 98, 10, 109,  2, 10,  19, 38, 28,  52, 19,
    76,  28, 94, 19, 114, 28, 13,  45, 37, 36,  51, 45, 79,  36, 89,
    45, 118, 37, 17,  54, 26, 62,  55, 54, 64,  62, 93, 54, 102, 62,
    15,  10, 26,  2,  57, 10, 68,   2, 99, 10, 110,  2, 11,  19, 37,
    28,  53, 19, 75,  28, 95, 19, 113, 28, 12,  45, 38, 36,  50, 45,
    79,  37, 88, 45, 117, 37, 16,  54, 25, 62,  54, 54, 63,  62, 92,
    54, 101, 62, 16,  10, 27,  2,  58, 10, 69,   2, 99, 11, 111,  2,
    12,  19, 36, 28,  54, 19, 74,  28, 96, 19, 112, 28, 11,  45, 39,
    36,  49, 45, 78,  37, 87, 45, 116, 37, 15,  54, 24, 62,  53, 54,
    62,  62, 91, 54, 100, 62, 17,  10, 28,  2,  59, 10, 70,   2, 98,
    11, 112,  2, 13,  19, 35, 28,  55, 19, 73,  28, 97, 19, 111, 28,
    10,  45, 39, 37,  48, 45, 77,  37, 86, 45, 115, 37, 14,  54, 23,
    62,  52, 54, 61,  62, 90, 54, 100, 63, 18,  10, 29,  2,  59, 11,
    71,   2, 97, 11, 113,  2, 14,  19, 34, 28,  56, 19, 72,  28, 98,
    19, 110, 28,  9,  45, 38, 37,  47, 45, 76,  37, 85, 45, 114, 37,
    13,  54, 22, 62,  51, 54, 60,  62, 89, 54, 101, 63, 19,  10, 30,
     2,  58, 11, 72,   2, 96, 11, 114,  2, 15,  19, 33, 28,  57, 19,
    71,  28, 99, 19, 109, 28,  8,  45, 37, 37,  46, 45, 75,  37, 84,
    45, 113, 37, 12,  54, 21, 62,  50, 54, 60,  63, 88, 54, 102, 63,
    19,  11, 31,  2,  57, 11, 73,   2, 95, 11, 115,  2, 16,  19, 32,
    28,  58, 19, 70,  28, 99, 20, 108, 28,  7,  45, 36, 37,  45, 45,
    74,  37, 83, 45, 112, 37, 11,  54, 20, 62,  49, 54, 61,  63, 87,
    54, 103, 63, 18,  11, 32,  2,  56, 11, 74,   2, 94, 11, 116,  2,
    17,  19, 31, 28,  59, 19, 69,  28, 98, 20, 107, 28,  6,  45, 35,
    37,  44, 45, 73,  37, 82, 45, 111, 37, 10,  54, 20, 63,  48, 54,
    62,  63, 86, 54, 104, 63, 17,  11, 33,  2,  55, 11, 75,   2, 93,
    11, 117,  2, 18,  19, 30, 28,  59, 20, 68,  28, 97, 20, 106, 28,
     5,  45, 34, 37,  43, 45, 72,  37, 81, 45, 110, 37,  9,  54, 21,
    63,  47, 54, 63,  63, 85, 54, 105, 63, 16,  11, 34,  2,  54, 11,
    76,   2, 92, 11, 118,  2, 19,  19, 29, 28,  58, 20, 67,  28, 96,
    20, 105, 28,  4,  45, 33, 37,  42, 45, 71,  37, 80, 45, 109, 37,
     8,  54, 22, 63,  46, 54, 64,  63, 84, 54, 106, 63, 15,  11, 35,
     2,  53, 11, 77,   2, 91, 11, 119,  2, 19,  20, 28, 28,  57, 20,
    66,  28, 95, 20, 104, 28,  3,  45, 32, 37,  41, 45, 70,  37, 80,
    46, 108, 37,  7,  54, 23, 63,  45, 54, 65,  63, 83, 54, 107, 63,
    14,  11, 36,  2,  52, 11, 78,   2, 90, 11, 119,  3, 18,  20, 27,
    28,  56, 20, 65,  28, 94, 20, 103, 28,  2,  45, 31, 37,  40, 45,
    69,  37, 81, 46, 107, 37,  6,  54, 24, 63,  44, 54, 66,  63, 82,
    54, 108, 63, 13,  11, 37,  2,  51, 11, 79,   2, 89, 11, 118,  3,
    17,  20, 26, 28,  55, 20, 64,  28, 93, 20, 102, 28,  1,  45, 30,
    37,  40, 46, 68,  37, 82, 46, 106, 37,  5,  54, 25, 63,  43, 54,
    67,  63, 81, 54, 109, 63, 12,  11, 38,  2,  50, 11, 79,   3, 88,
    11, 117,  3, 16,  20, 25, 28,  54, 20, 63,  28, 92, 20, 101, 28,
     0,  45, 29, 37,  41, 46, 67,  37, 83, 46, 105, 37,  4,  54, 26,
    63,  42, 54, 68,  63, 80, 54, 110, 63, 11,  11, 39,  2,  49, 11,
    78,   3, 87, 11, 116,  3, 15,  20, 24, 28,  53, 20, 62,  28, 91,
    20, 100, 28,  0,  46, 28, 37,  42, 46, 66,  37, 84, 46, 104, 37,
     3,  54, 27, 63,  41, 54, 69,  63, 80, 55, 111, 63, 10,  11, 39,
     3,  48, 11, 77,   3, 86, 11, 115,  3, 14,  20, 23, 28,  52, 20,
    61,  28, 90, 20, 100, 29,  1,  46, 27, 37,  43, 46, 65,  37, 85,
    46, 103, 37,  2,  54, 28, 63,  40, 54, 70,  63, 81, 55, 112, 63,
     9,  11, 38,  3,  47, 11, 76,   3, 85, 11, 114,  3, 13,  20, 22,
    28,  51, 20, 60,  28, 89, 20, 101, 29,  2,  46, 26, 37,  44, 46,
    64,  37, 86, 46, 102, 37,  1,  54, 29, 63,  40, 55, 71,  63, 82,
    55, 113, 63,  8,  11, 37,  3,  46, 11, 75,   3, 84, 11, 113,  3,
    12,  20, 21, 28,  50, 20, 60,  29, 88, 20, 102, 29,  3,  46, 25,
    37,  45, 46, 63,  37, 87, 46, 101, 37,  0,  54, 30, 63,  41, 55,
    72,  63, 83, 55, 114, 63,  7,  11, 36,  3,  45, 11, 74,   3, 83,
    11, 112,  3, 11,  20, 20, 28,  49, 20, 61,  29, 87, 20, 103, 29,
     4,  46, 24, 37,  46, 46, 62,  37, 88, 46, 100, 37,  0,  55, 31,
    63,  42, 55, 73,  63, 84, 55, 115, 63,  6,  11, 35,  3,  44, 11,
    73,   3, 82, 11, 111,  3, 10,  20, 20, 29,  48, 20, 62,  29, 86,
    20, 104, 29,  5,  46, 23, 37,  47, 46, 61,  37, 89, 46, 100, 38,
     1,  55, 32, 63,  43, 55, 74,  63, 85, 55, 116, 63,  5,  11, 34,
     3,  43, 11, 72,   3, 81, 11, 110,  3,  9,  20, 21, 29,  47, 20,
    63,  29, 85, 20, 105, 29,  6,  46, 22, 37,  48, 46, 60,  37, 90,
    46, 101, 38,  2,  55, 33, 63,  44, 55, 75,  63, 86, 55, 117, 63,
     4,  11, 33,  3,  42, 11, 71,   3, 80, 11, 109,  3,  8,  20, 22,
    29,  46, 20, 64,  29, 84, 20, 106, 29,  7,  46, 21, 37,  49, 46,
    60,  38, 91, 46, 102, 38,  3,  55, 34, 63,  45, 55, 76,  63, 87,
    55, 118, 63,  3,  11, 32,  3,  41, 11, 70,   3, 80, 12, 108,  3,
     7,  20, 23, 29,  45, 20, 65,  29, 83, 20, 107, 29,  8,  46, 20,
    37,  50, 46, 61,  38, 92, 46, 103, 38,  4,  55, 35, 63,  46, 55,
    77,  63, 88, 55, 119, 63,  2,  11, 31,  3,  40, 11, 69,   3, 81,
    12, 107,  3,  6,  20, 24, 29,  44, 20, 66,  29, 82, 20, 108, 29,
     9,  46, 20, 38,  51, 46, 62,  38, 93, 46, 104, 38,  5,  55, 36,
    63,  47, 55, 78,  63, 89, 55, 119, 64,  1,  11, 30,  3,  40, 12,
    68,   3, 82, 12, 106,  3,  5,  20, 25, 29,  43, 20, 67,  29, 81,
    20, 109, 29, 10,  46, 21, 38,  52, 46, 63,  38, 94, 46, 105, 38,
     6,  55, 37, 63,  48, 55, 79,  63, 90, 55, 118, 64,  0,  11, 29,
     3,  41, 12, 67,   3, 83, 12, 105,  3,  4,  20, 26, 29,  42, 20,
    68,  29, 80, 20, 110, 29, 11,  46, 22, 38,  53, 46, 64,  38, 95,
    46, 106, 38,  7,  55, 38, 63,  49, 55, 79,  64, 91, 55, 117, 64,
     0,  12, 28,  3,  42, 12, 66,   3, 84, 12, 104,  3,  3,  20, 27,
    29,  41, 20, 69,  29, 80, 21, 111, 29, 12,  46, 23, 38,  54, 46,
    65,  38, 96, 46, 107, 38,  8,  55, 39, 63,  50, 55, 78,  64, 92,
    55, 116, 64,  1,  12, 27,  3,  43, 12, 65,   3, 85, 12, 103,  3,
     2,  20, 28, 29,  40, 20, 70,  29, 81, 21, 112, 29, 13,  46, 24,
    38,  55, 46, 66,  38, 97, 46, 108, 38,  9,  55, 39, 64,  51, 55,
    77,  64, 93, 55, 115, 64,  2,  12, 26,  3,  44, 12, 64,   3, 86,
    12, 102,  3,  1,  20, 29, 29,  40, 21, 71,  29, 82, 21, 113, 29,
    14,  46, 25, 38,  56, 46, 67,  38, 98, 46, 109, 38, 10,  55, 38,
    64,  52, 55, 76,  64, 94, 55, 114, 64,  3,  12, 25,  3,  45, 12,
    63,   3, 87, 12, 101,  3,  0,  20, 30, 29,  41, 21, 72,  29, 83,
    21, 114, 29, 15,  46, 26, 38,  57, 46, 68,  38, 99, 46, 110, 38,
    11,  55, 37, 64,  53, 55, 75,  64, 95, 55, 113, 64,  4,  12, 24,
     3,  46, 12, 62,   3, 88, 12, 100,  3,  0,  21, 31, 29,  42, 21,
    73,  29, 84, 21, 115, 29, 16,  46, 27, 38,  58, 46, 69,  38, 99,
    47, 111, 38, 12,  55, 36, 64,  54, 55, 74,  64, 96, 55, 112, 64,
     5,  12, 23,  3,  47, 12, 61,   3, 89, 12, 100,  4,  1,  21, 32,
    29,  43, 21, 74,  29, 85, 21, 116, 29, 17,  46, 28, 38,  59, 46,
    70,  38, 98, 47, 112, 38, 13,  55, 35, 64,  55, 55, 73,  64, 97,
    55, 111, 64,  6,  12, 22,  3,  48, 12, 60,   3, 90, 12, 101,  4,
     2,  21, 33, 29,  44, 21, 75,  29, 86, 21, 117, 29, 18,  46, 29,
    38,  59, 47, 71,  38, 97, 47, 113, 38, 14,  55, 34, 64,  56, 55,
    72,  64, 98, 55, 110, 64,  7,  12, 21,  3,  49, 12, 60,   4, 91,
    12, 102,  4,  3,  21, 34, 29,  45, 21, 76,  29, 87, 21, 118, 29,
    19,  46, 30, 38,  58, 47, 72,  38, 96, 47, 114, 38, 15,  55, 33,
    64,  57, 55, 71,  64, 99, 55, 109, 64,  8,  12, 20,  3,  50, 12,
    61,   4, 92, 12, 103,  4,  4,  21, 35, 29,  46, 21, 77,  29, 88,
    21, 119, 29, 19,  47, 31, 38,  57, 47, 73,  38, 95, 47, 115, 38,
    16,  55, 32, 64,  58, 55, 70,  64, 99, 56, 108, 64,  9,  12, 20,
     4,  51, 12, 62,   4, 93, 12, 104,  4,  5,  21, 36, 29,  47, 21,
    78,  29, 89, 21, 119, 30, 18,  47, 32, 38,  56, 47, 74,  38, 94,
    47, 116, 38, 17,  55, 31, 64,  59, 55, 69,  64, 98, 56, 107, 64,
    10,  12, 21,  4,  52, 12, 63,   4, 94, 12, 105,  4,  6,  21, 37,
    29,  48, 21, 79,  29, 90, 21, 118, 30, 17,  47, 33, 38,  55, 47,
    75,  38, 93, 47, 117, 38, 18,  55, 30, 64,  59, 56, 68,  64, 97,
    56, 106, 64, 11,  12, 22,  4,  53, 12, 64,   4, 95, 12, 106,  4,
     7,  21, 38, 29,  49, 21, 79,  30, 91, 21, 117, 30, 16,  47, 34,
    38,  54, 47, 76,  38, 92, 47, 118, 38, 19,  55, 29, 64,  58, 56,
    67,  64, 96, 56, 105, 64, 12,  12, 23,  4,  54, 12, 65,   4, 96,
    12, 107,  4,  8,  21, 39, 29,  50, 21, 78,  30, 92, 21, 116, 30,
    15,  47, 35, 38,  53, 47, 77,  38, 91, 47, 119, 38, 19,  56, 28,
    64,  57, 56, 66,  64, 95, 56, 104, 64, 13,  12, 24,  4,  55, 12,
    66,   4, 97, 12, 108,  4,  9,  21, 39, 30,  51, 21, 77,  30, 93,
    21, 115, 30, 14,  47, 36, 38,  52, 47, 78,  38, 90, 47, 119, 39,
    18,  56, 27, 64,  56, 56, 65,  64, 94, 56, 103, 64, 14,  12, 25,
     4,  56, 12, 67,   4, 98, 12, 109,  4, 10,  21, 38, 30,  52, 21,
    76,  30, 94, 21, 114, 30, 13,  47, 37, 38,  51, 47, 79,  38, 89,
    47, 118, 39, 17,  56, 26, 64,  55, 56, 64,  64, 93, 56, 102, 64,
    15,  12, 26,  4,  57, 12, 68,   4, 99, 12, 110,  4, 11,  21, 37,
    30,  53, 21, 75,  30, 95, 21, 113, 30, 12,  47, 38, 38,  50, 47,
    79,  39, 88, 47, 117, 39, 16,  56, 25, 64,  54, 56, 63,  64, 92,
    56, 101, 64, 16,  12, 27,  4,  58, 12, 69,   4, 99, 13, 111,  4,
    12,  21, 36, 30,  54, 21, 74,  30, 96, 21, 112, 30, 11,  47, 39,
    38,  49, 47, 78,  39, 87, 47, 116, 39, 15,  56, 24, 64,  53, 56,
    62,  64, 91, 56, 100, 64, 17,  12, 28,  4,  59, 12, 70,   4, 98,
    13, 112,  4, 13,  21, 35, 30,  55, 21, 73,  30, 97, 21, 111, 30,
    10,  47, 39, 39,  48, 47, 77,  39, 86, 47, 115, 39, 14,  56, 23,
    64,  52, 56, 61,  64, 90, 56, 100, 65, 18,  12, 29,  4,  59, 13,
    71,   4, 97, 13, 113,  4, 14,  21, 34, 30,  56, 21, 72,  30, 98,
    21, 110, 30,  9,  47, 38, 39,  47, 47, 76,  39, 85, 47, 114, 39,
    13,  56, 22, 64,  51, 56, 60,  64, 89, 56, 101, 65, 19,  12, 30,
     4,  58, 13, 72,   4, 96, 13, 114,  4, 15,  21, 33, 30,  57, 21,
    71,  30, 99, 21, 109, 30,  8,  47, 37, 39,  46, 47, 75,  39, 84,
    47, 113, 39, 12,  56, 21, 64,  50, 56, 60,  65, 88, 56, 102, 65,
    19,  13, 31,  4,  57, 13, 73,   4, 95, 13, 115,  4, 16,  21, 32,
    30,  58, 21, 70,  30, 99, 22, 108, 30,  7,  47, 36, 39,  45, 47,
    74,  39, 83, 47, 112, 39, 11,  56, 20, 64,  49, 56, 61,  65, 87,
    56, 103, 65, 18,  13, 32,  4,  56, 13, 74,   4, 94, 13, 116,  4,
    17,  21, 31, 30,  59, 21, 69,  30, 98, 22, 107, 30,  6,  47, 35,
    39,  44, 47, 73,  39, 82, 47, 111, 39, 10,  56, 20, 65,  48, 56,
    62,  65, 86, 56, 104, 65, 17,  13, 33,  4,  55, 13, 75,   4, 93,
    13, 117,  4, 18,  21, 30, 30,  59, 22, 68,  30, 97, 22, 106, 30,
     5,  47, 34, 39,  43, 47, 72,  39, 81, 47, 110, 39,  9,  56, 21,
    65,  47, 56, 63,  65, 85, 56, 105, 65, 16,  13, 34,  4,  54, 13,
    76,   4, 92, 13, 118,  4, 19,  21, 29, 30,  58, 22, 67,  30, 96,
    22, 105, 30,  4,  47, 33, 39,  42, 47, 71,  39, 80, 47, 109, 39,
     8,  56, 22, 65,  46, 56, 64,  65, 84, 56, 106, 65, 15,  13, 35,
     4,  53, 13, 77,   4, 91, 13, 119,  4, 19,  22, 28, 30,  57, 22,
    66,  30, 95, 22, 104, 30,  3,  47, 32, 39,  41, 47, 70,  39, 80,
    48, 108, 39,  7,  56, 23, 65,  45, 56, 65,  65, 83, 56, 107, 65,
    14,  13, 36,  4,  52, 13, 78,   4, 90, 13, 119,  5, 18,  22, 27,
    30,  56, 22, 65,  30, 94, 22, 103, 30,  2,  47, 31, 39,  40, 47,
    69,  39, 81, 48, 107, 39,  6,  56, 24, 65,  44, 56, 66,  65, 82,
    56, 108, 65, 13,  13, 37,  4,  51, 13, 79,   4, 89, 13, 118,  5,
    17,  22, 26, 30,  55, 22, 64,  30, 93, 22, 102, 30,  1,  47, 30,
    39,  40, 48, 68,  39, 82, 48, 106, 39,  5,  56, 25, 65,  43, 56,
    67,  65, 81, 56, 109, 65, 12,  13, 38,  4,  50, 13, 79,   5, 88,
    13, 117,  5, 16,  22, 25, 30,  54, 22, 63,  30, 92, 22, 101, 30,
     0,  47, 29, 39,  41, 48, 67,  39, 83, 48, 105, 39,  4,  56, 26,
    65,  42, 56, 68,  65, 80, 56, 110, 65, 11,  13, 39,  4,  49, 13,
    78,   5, 87, 13, 116,  5, 15,  22, 24, 30,  53, 22, 62,  30, 91,
    22, 100, 30,  0,  48, 28, 39,  42, 48, 66,  39, 84, 48, 104, 39,
     3,  56, 27, 65,  41, 56, 69,  65, 80, 57, 111, 65, 10,  13, 39,
     5,  48, 13, 77,   5, 86, 13, 115,  5, 14,  22, 23, 30,  52, 22,
    61,  30, 90, 22, 100, 31,  1,  48, 27, 39,  43, 48, 65,  39, 85,
    48, 103, 39,  2,  56, 28, 65,  40, 56, 70,  65, 81, 57, 112, 65,
     9,  13, 38,  5,  47, 13, 76,   5, 85, 13, 114,  5, 13,  22, 22,
    30,  51, 22, 60,  30, 89, 22, 101, 31,  2,  48, 26, 39,  44, 48,
    64,  39, 86, 48, 102, 39,  1,  56, 29, 65,  40, 57, 71,  65, 82,
    57, 113, 65,  8,  13, 37,  5,  46, 13, 75,   5, 84, 13, 113,  5,
    12,  22, 21, 30,  50, 22, 60,  31, 88, 22, 102, 31,  3,  48, 25,
    39,  45, 48, 63,  39, 87, 48, 101, 39,  0,  56, 30, 65,  41, 57,
    72,  65, 83, 57, 114, 65,  7,  13, 36,  5,  45, 13, 74,   5, 83,
    13, 112,  5, 11,  22, 20, 30,  49, 22, 61,  31, 87, 22, 103, 31,
     4,  48, 24, 39,  46, 48, 62,  39, 88, 48, 100, 39,  0,  57, 31,
    65,  42, 57, 73,  65, 84, 57, 115, 65,  6,  13, 35,  5,  44, 13,
    73,   5, 82, 13, 111,  5, 10,  22, 20, 31,  48, 22, 62,  31, 86,
    22, 104, 31,  5,  48, 23, 39,  47, 48, 61,  39, 89, 48, 100, 40,
     1,  57, 32, 65,  43, 57, 74,  65, 85, 57, 116, 65,  5,  13, 34,
     5,  43, 13, 72,   5, 81, 13, 110,  5,  9,  22, 21, 31,  47, 22,
    63,  31, 85, 22, 105, 31,  6,  48, 22, 39,  48, 48, 60,  39, 90,
    48, 101, 40,  2,  57, 33, 65,  44, 57, 75,  65, 86, 57, 117, 65,
     4,  13, 33,  5,  42, 13, 71,   5, 80, 13, 109,  5,  8,  22, 22,
    31,  46, 22, 64,  31, 84, 22, 106, 31,  7,  48, 21, 39,  49, 48,
    60,  40, 91, 48, 102, 40,  3,  57, 34, 65,  45, 57, 76,  65, 87,
    57, 118, 65,  3,  13, 32,  5,  41, 13, 70,   5, 80, 14, 108,  5,
     7,  22, 23, 31,  45, 22, 65,  31, 83, 22, 107, 31,  8,  48, 20,
    39,  50, 48, 61,  40, 92, 48, 103, 40,  4,  57, 35, 65,  46, 57,
    77,  65, 88, 57, 119, 65,  2,  13, 31,  5,  40, 13, 69,   5, 81,
    14, 107,  5,  6,  22, 24, 31,  44, 22, 66,  31, 82, 22, 108, 31,
     9,  48, 20, 40,  51, 48, 62,  40, 93, 48, 104, 40,  5,  57, 36,
    65,  47, 57, 78,  65, 89, 57, 119, 66,  1,  13, 30,  5,  40, 14,
    68,   5, 82, 14, 106,  5,  5,  22, 25, 31,  43, 22, 67,  31, 81,
    22, 109, 31, 10,  48, 21, 40,  52, 48, 63,  40, 94, 48, 105, 40,
     6,  57, 37, 65,  48, 57, 79,  65, 90, 57, 118, 66,  0,  13, 29,
     5,  41, 14, 67,   5, 83, 14, 105,  5,  4,  22, 26, 31,  42, 22,
    68,  31, 80, 22, 110, 31, 11,  48, 22, 40,  53, 48, 64,  40, 95,
    48, 106, 40,  7,  57, 38, 65,  49, 57, 79,  66, 91, 57, 117, 66,
     0,  14, 28,  5,  42, 14, 66,   5, 84, 14, 104,  5,  3,  22, 27,
    31,  41, 22, 69,  31, 80, 23, 111, 31, 12,  48, 23, 40,  54, 48,
    65,  40, 96, 48, 107, 40,  8,  57, 39, 65,  50, 57, 78,  66, 92,
    57, 116, 66,  1,  14, 27,  5,  43, 14, 65,   5, 85, 14, 103,  5,
     2,  22, 28, 31,  40, 22, 70,  31, 81, 23, 112, 31, 13,  48, 24,
    40,  55, 48, 66,  40, 97, 48, 108, 40,  9,  57, 39, 66,  51, 57,
    77,  66, 93, 57, 115, 66,  2,  14, 26,  5,  44, 14, 64,   5, 86,
    14, 102,  5,  1,  22, 29, 31,  40, 23, 71,  31, 82, 23, 113, 31,
    14,  48, 25, 40,  56, 48, 67,  40, 98, 48, 109, 40, 10,  57, 38,
    66,  52, 57, 76,  66, 94, 57, 114, 66,  3,  14, 25,  5,  45, 14,
    63,   5, 87, 14, 101,  5,  0,  22, 30, 31,  41, 23, 72,  31, 83,
    23, 114, 31, 15,  48, 26, 40,  57, 48, 68,  40, 99, 48, 110, 40,
    11,  57, 37, 66,  53, 57, 75,  66, 95, 57, 113, 66,  4,  14, 24,
     5,  46, 14, 62,   5, 88, 14, 100,  5,  0,  23, 31, 31,  42, 23,
    73,  31, 84, 23, 115, 31, 16,  48, 27, 40,  58, 48, 69,  40, 99,
    49, 111, 40, 12,  57, 36, 66,  54, 57, 74,  66, 96, 57, 112, 66,
     5,  14, 23,  5,  47, 14, 61,   5, 89, 14, 100,  6,  1,  23, 32,
    31,  43, 23, 74,  31, 85, 23, 116, 31, 17,  48, 28, 40,  59, 48,
    70,  40, 98, 49, 112, 40, 13,  57, 35, 66,  55, 57, 73,  66, 97,
    57, 111, 66,  6,  14, 22,  5,  48, 14, 60,   5, 90, 14, 101,  6,
     2,  23, 33, 31,  44, 23, 75,  31, 86, 23, 117, 31, 18,  48, 29,
    40,  59, 49, 71,  40, 97, 49, 113, 40, 14,  57, 34, 66,  56, 57,
    72,  66, 98, 57, 110, 66,  7,  14, 21,  5,  49, 14, 60,   6, 91,
    14, 102,  6,  3,  23, 34, 31,  45, 23, 76,  31, 87, 23, 118, 31,
    19,  48, 30, 40,  58, 49, 72,  40, 96, 49, 114, 40, 15,  57, 33,
    66,  57, 57, 71,  66, 99, 57, 109, 66,  8,  14, 20,  5,  50, 14,
    61,   6, 92, 14, 103,  6,  4,  23, 35, 31,  46, 23, 77,  31, 88,
    23, 119, 31, 19,  49, 31, 40,  57, 49, 73,  40, 95, 49, 115, 40,
    16,  57, 32, 66,  58, 57, 70,  66, 99, 58, 108, 66,  9,  14, 20,
     6,  51, 14, 62,   6, 93, 14, 104,  6,  5,  23, 36, 31,  47, 23,
    78,  31, 89, 23, 119, 32, 18,  49, 32, 40,  56, 49, 74,  40, 94,
    49, 116, 40, 17,  57, 31, 66,  59, 57, 69,  66, 98, 58, 107, 66,
    10,  14, 21,  6,  52, 14, 63,   6, 94, 14, 105,  6,  6,  23, 37,
    31,  48, 23, 79,  31, 90, 23, 118, 32, 17,  49, 33, 40,  55, 49,
    75,  40, 93, 49, 117, 40, 18,  57, 30, 66,  59, 58, 68,  66, 97,
    58, 106, 66, 11,  14, 22,  6,  53, 14, 64,   6, 95, 14, 106,  6,
     7,  23, 38, 31,  49, 23, 79,  32, 91, 23, 117, 32, 16,  49, 34,
    40,  54, 49, 76,  40, 92, 49, 118, 40, 19,  57, 29, 66,  58, 58,
    67,  66, 96, 58, 105, 66, 12,  14, 23,  6,  54, 14, 65,   6, 96,
    14, 107,  6,  8,  23, 39, 31,  50, 23, 78,  32, 92, 23, 116, 32,
    15,  49, 35, 40,  53, 49, 77,  40, 91, 49, 119, 40, 19,  58, 28,
    66,  57, 58, 66,  66, 95, 58, 104, 66, 13,  14, 24,  6,  55, 14,
    66,   6, 97, 14, 108,  6,  9,  23, 39, 32,  51, 23, 77,  32, 93,
    23, 115, 32, 14,  49, 36, 40,  52, 49, 78,  40, 90, 49, 119, 41,
    18,  58, 27, 66,  56, 58, 65,  66, 94, 58, 103, 66, 14,  14, 25,
     6,  56, 14, 67,   6, 98, 14, 109,  6, 10,  23, 38, 32,  52, 23,
    76,  32, 94, 23, 114, 32, 13,  49, 37, 40,  51, 49, 79,  40, 89,
    49, 118, 41, 17,  58, 26, 66,  55, 58, 64,  66, 93, 58, 102, 66,
    15,  14, 26,  6,  57, 14, 68,   6, 99, 14, 110,  6, 11,  23, 37,
    32,  53, 23, 75,  32, 95, 23, 113, 32, 12,  49, 38, 40,  50, 49,
    79,  41, 88, 49, 117, 41, 16,  58, 25, 66,  54, 58, 63,  66, 92,
    58, 101, 66, 16,  14, 27,  6,  58, 14, 69,   6, 99, 15, 111,  6,
    12,  23, 36, 32,  54, 23, 74,  32, 96, 23, 112, 32, 11,  49, 39,
    40,  49, 49, 78,  41, 87, 49, 116, 41, 15,  58, 24, 66,  53, 58,
    62,  66, 91, 58, 100, 66, 17,  14, 28,  6,  59, 14, 70,   6, 98,
    15, 112,  6, 13,  23, 35, 32,  55, 23, 73,  32, 97, 23, 111, 32,
    10,  49, 39, 41,  48, 49, 77,  41, 86, 49, 115, 41, 14,  58, 23,
    66,  52, 58, 61,  66, 90, 58, 100, 67, 18,  14, 29,  6,  59, 15,
    71,   6, 97, 15, 113,  6, 14,  23, 34, 32,  56, 23, 72,  32, 98,
    23, 110, 32,  9,  49, 38, 41,  47, 49, 76,  41, 85, 49, 114, 41,
    13,  58, 22, 66,  51, 58, 60,  66, 89, 58, 101, 67, 19,  14, 30,
     6,  58, 15, 72,   6, 96, 15, 114,  6, 15,  23, 33, 32,  57, 23,
    71,  32, 99, 23, 109, 32,  8,  49, 37, 41,  46, 49, 75,  41, 84,
    49, 113, 41, 12,  58, 21, 66,  50, 58, 60,  67, 88, 58, 102, 67,
    19,  15, 31,  6,  57, 15, 73,   6, 95, 15, 115,  6, 16,  23, 32,
    32,  58, 23, 70,  32, 99, 24, 108, 32,  7,  49, 36, 41,  45, 49,
    74,  41, 83, 49, 112, 41, 11,  58, 20, 66,  49, 58, 61,  67, 87,
    58, 103, 67, 18,  15, 32,  6,  56, 15, 74,   6, 94, 15, 116,  6,
    17,  23, 31, 32,  59, 23, 69,  32, 98, 24, 107, 32,  6,  49, 35,
    41,  44, 49, 73,  41, 82, 49, 111, 41, 10,  58, 20, 67,  48, 58,
    62,  67, 86, 58, 104, 67, 17,  15, 33,  6,  55, 15, 75,   6, 93,
    15, 117,  6, 18,  23, 30, 32,  59, 24, 68,  32, 97, 24, 106, 32,
     5,  49, 34, 41,  43, 49, 72,  41, 81, 49, 110, 41,  9,  58, 21,
    67,  47, 58, 63,  67, 85, 58, 105, 67, 16,  15, 34,  6,  54, 15,
    76,   6, 92, 15, 118,  6, 19,  23, 29, 32,  58, 24, 67,  32, 96,
    24, 105, 32,  4,  49, 33, 41,  42, 49, 71,  41, 80, 49, 109, 41,
     8,  58, 22, 67,  46, 58, 64,  67, 84, 58, 106, 67, 15,  15, 35,
     6,  53, 15, 77,   6, 91, 15, 119,  6, 19,  24, 28, 32,  57, 24,
    66,  32, 95, 24, 104, 32,  3,  49, 32, 41,  41, 49, 70,  41, 80,
    50, 108, 41,  7,  58, 23, 67,  45, 58, 65,  67, 83, 58, 107, 67,
    14,  15, 36,  6,  52, 15, 78,   6, 90, 15, 119,  7, 18,  24, 27,
    32,  56, 24, 65,  32, 94, 24, 103, 32,  2,  49, 31, 41,  40, 49,
    69,  41, 81, 50, 107, 41,  6,  58, 24, 67,  44, 58, 66,  67, 82,
    58, 108, 67, 13,  15, 37,  6,  51, 15, 79,   6, 89, 15, 118,  7,
    17,  24, 26, 32,  55, 24, 64,  32, 93, 24, 102, 32,  1,  49, 30,
    41,  40, 50, 68,  41, 82, 50, 106, 41,  5,  58, 25, 67,  43, 58,
    67,  67, 81, 58, 109, 67, 12,  15, 38,  6,  50, 15, 79,   7, 88,
    15, 117,  7, 16,  24, 25, 32,  54, 24, 63,  32, 92, 24, 101, 32,
     0,  49, 29, 41,  41, 50, 67,  41, 83, 50, 105, 41,  4,  58, 26,
    67,  42, 58, 68,  67, 80, 58, 110, 67, 11,  15, 39,  6,  49, 15,
    78,   7, 87, 15, 116,  7, 15,  24, 24, 32,  53, 24, 62,  32, 91,
    24, 100, 32,  0,  50, 28, 41,  42, 50, 66,  41, 84, 50, 104, 41,
     3,  58, 27, 67,  41, 58, 69,  67, 80, 59, 111, 67, 10,  15, 39,
     7,  48, 15, 77,   7, 86, 15, 115,  7, 14,  24, 23, 32,  52, 24,
    61,  32, 90, 24, 100, 33,  1,  50, 27, 41,  43, 50, 65,  41, 85,
    50, 103, 41,  2,  58, 28, 67,  40, 58, 70,  67, 81, 59, 112, 67,
     9,  15, 38,  7,  47, 15, 76,   7, 85, 15, 114,  7, 13,  24, 22,
    32,  51, 24, 60,  32, 89, 24, 101, 33,  2,  50, 26, 41,  44, 50,
    64,  41, 86, 50, 102, 41,  1,  58, 29, 67,  40, 59, 71,  67, 82,
    59, 113, 67,  8,  15, 37,  7,  46, 15, 75,   7, 84, 15, 113,  7,
    12,  24, 21, 32,  50, 24, 60,  33, 88, 24, 102, 33,  3,  50, 25,
    41,  45, 50, 63,  41, 87, 50, 101, 41,  0,  58, 30, 67,  41, 59,
    72,  67, 83, 59, 114, 67,  7,  15, 36,  7,  45, 15, 74,   7, 83,
    15, 112,  7, 11,  24, 20, 32,  49, 24, 61,  33, 87, 24, 103, 33,
     4,  50, 24, 41,  46, 50, 62,  41, 88, 50, 100, 41,  0,  59, 31,
    67,  42, 59, 73,  67, 84, 59, 115, 67,  6,  15, 35,  7,  44, 15,
    73,   7, 82, 15, 111,  7, 10,  24, 20, 33,  48, 24, 62,  33, 86,
    24, 104, 33,  5,  50, 23, 41,  47, 50, 61,  41, 89, 50, 100, 42,
     1,  59, 32, 67,  43, 59, 74,  67, 85, 59, 116, 67,  5,  15, 34,
     7,  43, 15, 72,   7, 81, 15, 110,  7,  9,  24, 21, 33,  47, 24,
    63,  33, 85, 24, 105, 33,  6,  50, 22, 41,  48, 50, 60,  41, 90,
    50, 101, 42,  2,  59, 33, 67,  44, 59, 75,  67, 86, 59, 117, 67,
     4,  15, 33,  7,  42, 15, 71,   7, 80, 15, 109,  7,  8,  24, 22,
    33,  46, 24, 64,  33, 84, 24, 106, 33,  7,  50, 21, 41,  49, 50,
    60,  42, 91, 50, 102, 42,  3,  59, 34, 67,  45, 59, 76,  67, 87,
    59, 118, 67,  3,  15, 32,  7,  41, 15, 70,   7, 80, 16, 108,  7,
     7,  24, 23, 33,  45, 24, 65,  33, 83, 24, 107, 33,  8,  50, 20,
    41,  50, 50, 61,  42, 92, 50, 103, 42,  4,  59, 35, 67,  46, 59,
    77,  67, 88, 59, 119, 67,  2,  15, 31,  7,  40, 15, 69,   7, 81,
    16, 107,  7,  6,  24, 24, 33,  44, 24, 66,  33, 82, 24, 108, 33,
     9,  50, 20, 42,  51, 50, 62,  42, 93, 50, 104, 42,  5,  59, 36,
    67,  47, 59, 78,  67, 89, 59, 100, 51,  1,  15, 30,  7,  40, 16,
    68,   7, 82, 16, 106,  7,  5,  24, 25, 33,  43, 24, 67,  33, 81,
    24, 109, 33, 10,  50, 21, 42,  52, 50, 63,  42, 94, 50, 105, 42,
     6,  59, 37, 67,  48, 59, 79,  67, 90, 59, 101, 51,  0,  15, 29,
     7,  41, 16, 67,   7, 83, 16, 105,  7,  4,  24, 26, 33,  42, 24,
    68,  33, 80, 24, 110, 33, 11,  50, 22, 42,  53, 50, 64,  42, 95,
    50, 106, 42,  7,  59, 38, 67,  49, 59, 60,  51, 91, 59, 102, 51,
     0,  16, 28,  7,  42, 16, 66,   7, 84, 16, 104,  7,  3,  24, 27,
    33,  41, 24, 69,  33, 80, 25, 111, 33, 12,  50, 23, 42,  54, 50,
    65,  42, 96, 50, 107, 42,  8,  59, 39, 67,  50, 59, 61,  51, 92,
    59, 103, 51,  1,  16, 27,  7,  43, 16, 65,   7, 85, 16, 103,  7,
     2,  24, 28, 33,  40, 24, 70,  33, 81, 25, 112, 33, 13,  50, 24,
    42,  55, 50, 66,  42, 97, 50, 108, 42,  9,  59, 20, 51,  51, 59,
    62,  51, 93, 59, 104, 51,  2,  16, 26,  7,  44, 16, 64,   7, 86,
    16, 102,  7,  1,  24, 29, 33,  40, 25, 71,  33, 82, 25, 113, 33,
    14,  50, 25, 42,  56, 50, 67,  42, 98, 50, 109, 42, 10,  59, 21,
    51,  52, 59, 63,  51, 94, 59, 105, 51,  3,  16, 25,  7,  45, 16,
    63,   7, 87, 16, 101,  7,  0,  24, 30, 33,  41, 25, 72,  33, 83,
    25, 114, 33, 15,  50, 26, 42,  57, 50, 68,  42, 99, 50, 110, 42,
    11,  59, 22, 51,  53, 59, 64,  51, 95, 59, 106, 51,  4,  16, 24,
     7,  46, 16, 62,   7, 88, 16, 100,  7,  0,  25, 31, 33,  42, 25,
    73,  33, 84, 25, 115, 33, 16,  50, 27, 42,  58, 50, 69,  42, 80,
    34, 111, 42, 12,  59, 23, 51,  54, 59, 65,  51, 96, 59, 107, 51,
     5,  16, 23,  7,  47, 16, 61,   7, 89, 16, 100,  8,  1,  25, 32,
    33,  43, 25, 74,  33, 85, 25, 116, 33, 17,  50, 28, 42,  59, 50,
    70,  42, 81, 34, 112, 42, 13,  59, 24, 51,  55, 59, 66,  51, 97,
    59, 108, 51,  6,  16, 22,  7,  48, 16, 60,   7, 90, 16, 101,  8,
     2,  25, 33, 33,  44, 25, 75,  33, 86, 25, 117, 33, 18,  50, 29,
    42,  40, 34, 71,  42, 82, 34, 113, 42, 14,  59, 25, 51,  56, 59,
    67,  51, 98, 59, 109, 51,  7,  16, 21,  7,  49, 16, 60,   8, 91,
    16, 102,  8,  3,  25, 34, 33,  45, 25, 76,  33, 87, 25, 118, 33,
    19,  50, 30, 42,  41, 34, 72,  42, 83, 34, 114, 42, 15,  59, 26,
    51,  57, 59, 68,  51, 99, 59, 110, 51,  8,  16, 20,  7,  50, 16,
    61,   8, 92, 16, 103,  8,  4,  25, 35, 33,  46, 25, 77,  33, 88,
    25, 119, 33,  0,  34, 31, 42,  42, 34, 73,  42, 84, 34, 115, 42,
    16,  59, 27, 51,  58, 59, 69,  51, 99, 60, 111, 51,  9,  16, 20,
     8,  51, 16, 62,   8, 93, 16, 104,  8,  5,  25, 36, 33,  47, 25,
    78,  33, 89, 25, 100, 17,  1,  34, 32, 42,  43, 34, 74,  42, 85,
    34, 116, 42, 17,  59, 28, 51,  59, 59, 70,  51, 98, 60, 112, 51,
    10,  16, 21,  8,  52, 16, 63,   8, 94, 16, 105,  8,  6,  25, 37,
    33,  48, 25, 79,  33, 90, 25, 101, 17,  2,  34, 33, 42,  44, 34,
    75,  42, 86, 34, 117, 42, 18,  59, 29, 51,  59, 60, 71,  51, 97,
    60, 113, 51, 11,  16, 22,  8,  53, 16, 64,   8, 95, 16, 106,  8,
     7,  25, 38, 33,  49, 25, 60,  17, 91, 25, 102, 17,  3,  34, 34,
    42,  45, 34, 76,  42, 87, 34, 118, 42, 19,  59, 30, 51,  58, 60,
    72,  51, 96, 60, 114, 51, 12,  16, 23,  8,  54, 16, 65,   8, 96,
    16, 107,  8,  8,  25, 39, 33,  50, 25, 61,  17, 92, 25, 103, 17,
     4,  34, 35, 42,  46, 34, 77,  42, 88, 34, 119, 42, 19,  60, 31,
    51,  57, 60, 73,  51, 95, 60, 115, 51, 13,  16, 24,  8,  55, 16,
    66,   8, 97, 16, 108,  8,  9,  25, 20, 17,  51, 25, 62,  17, 93,
    25, 104, 17,  5,  34, 36, 42,  47, 34, 78,  42, 89, 34, 119, 43,
    18,  60, 32, 51,  56, 60, 74,  51, 94, 60, 116, 51, 14,  16, 25,
     8,  56, 16, 67,   8, 98, 16, 109,  8, 10,  25, 21, 17,  52, 25,
    63,  17, 94, 25, 105, 17,  6,  34, 37, 42,  48, 34, 79,  42, 90,
    34, 118, 43, 17,  60, 33, 51,  55, 60, 75,  51, 93, 60, 117, 51,
    15,  16, 26,  8,  57, 16, 68,   8, 99, 16, 110,  8, 11,  25, 22,
    17,  53, 25, 64,  17, 95, 25, 106, 17,  7,  34, 38, 42,  49, 34,
    79,  43, 91, 34, 117, 43, 16,  60, 34, 51,  54, 60, 76,  51, 92,
    60, 118, 51, 16,  16, 27,  8,  58, 16, 69,   8, 80,  0, 111,  8,
    12,  25, 23, 17,  54, 25, 65,  17, 96, 25, 107, 17,  8,  34, 39,
    42,  50, 34, 78,  43, 92, 34, 116, 43, 15,  60, 35, 51,  53, 60,
    77,  51, 91, 60, 119, 51, 17,  16, 28,  8,  59, 16, 70,   8, 81,
     0, 112,  8, 13,  25, 24, 17,  55, 25, 66,  17, 97, 25, 108, 17,
     9,  34, 39, 43,  51, 34, 77,  43, 93, 34, 115, 43, 14,  60, 36,
    51,  52, 60, 78,  51, 90, 60, 119, 52, 18,  16, 29,  8,  40,  0,
    71,   8, 82,  0, 113,  8, 14,  25, 25, 17,  56, 25, 67,  17, 98,
    25, 109, 17, 10,  34, 38, 43,  52, 34, 76,  43, 94, 34, 114, 43,
    13,  60, 37, 51,  51, 60, 79,  51, 89, 60, 118, 52, 19,  16, 30,
     8,  41,  0, 72,   8, 83,  0, 114,  8, 15,  25, 26, 17,  57, 25,
    68,  17, 99, 25, 110, 17, 11,  34, 37, 43,  53, 34, 75,  43, 95,
    34, 113, 43, 12,  60, 38, 51,  50, 60, 79,  52, 88, 60, 117, 52,
     0,   0,  0,  0,   0,  0,  0,   0,
};

static const uint8_t hq_tab_09[] = {
     0,  0, 10,  3, 18,  0, 24,  3, 36,  0,  1, 10, 14,  6, 19,
    10, 31,  7, 37, 10,  5, 13, 15, 16, 19, 13, 30, 17, 33, 13,
     4, 23,  8, 20, 18, 23, 26, 20, 32, 23,  4, 26,  9, 24, 22,
    26, 27, 24, 39, 27,  1,  0,  9,  3, 19,  0, 24,  4, 37,  0,
     2, 10, 15,  6, 20, 10, 30,  7, 38, 10,  4, 13, 15, 17, 18,
    13, 29, 17, 32, 13,  3, 23,  9, 20, 17, 23, 27, 20, 32, 18,
     5, 26, 10, 24, 23, 26, 28, 24, 38, 27,  2,  0,  8,  3, 20,
     0, 25,  4, 38,  0,  3, 10, 15,  7, 21, 10, 29,  7, 39, 10,
     3, 13, 14, 17, 17, 13, 28, 17, 32, 14,  2, 23, 10, 20, 16,
    23, 28, 20, 33, 18,  6, 26, 11, 24, 23, 27, 29, 24, 37, 27,
     3,  0,  8,  4, 21,  0, 26,  4, 39,  0,  4, 10, 14,  7, 22,
    10, 28,  7, 39, 11,  2, 13, 13, 17, 16, 13, 27, 17, 33, 14,
     1, 23, 11, 20, 16, 18, 29, 20, 34, 18,  7, 26, 12, 24, 22,
    27, 30, 24, 36, 27,  4,  0,  9,  4, 22,  0, 27,  4, 39,  1,
     5, 10, 13,  7, 23, 10, 27,  7, 38, 11,  1, 13, 12, 17, 16,
    14, 26, 17, 34, 14,  0, 23, 12, 20, 17, 18, 30, 20, 35, 18,
     7, 27, 13, 24, 21, 27, 31, 24, 35, 27,  5,  0, 10,  4, 23,
     0, 28,  4, 38,  1,  6, 10, 12,  7, 23, 11, 26,  7, 37, 11,
     0, 13, 11, 17, 17, 14, 25, 17, 35, 14,  0, 18, 13, 20, 18,
    18, 31, 20, 36, 18,  6, 27, 14, 24, 20, 27, 31, 25, 34, 27,
     6,  0, 11,  4, 23,  1, 29,  4, 37,  1,  7, 10, 11,  7, 22,
    11, 25,  7, 36, 11,  0, 14, 10, 17, 18, 14, 24, 17, 36, 14,
     1, 18, 14, 20, 19, 18, 31, 21, 37, 18,  5, 27, 15, 24, 19,
    27, 30, 25, 33, 27,  7,  0, 12,  4, 22,  1, 30,  4, 36,  1,
     7, 11, 10,  7, 21, 11, 24,  7, 35, 11,  1, 14,  9, 17, 19,
    14, 24, 12, 37, 14,  2, 18, 15, 20, 20, 18, 30, 21, 38, 18,
     4, 27, 15, 25, 18, 27, 29, 25, 32, 27,  7,  1, 13,  4, 21,
     1, 31,  4, 35,  1,  6, 11,  9,  7, 20, 11, 24,  8, 34, 11,
     2, 14,  8, 17, 20, 14, 25, 12, 38, 14,  3, 18, 15, 21, 21,
    18, 29, 21, 39, 18,  3, 27, 14, 25, 17, 27, 28, 25, 32, 28,
     6,  1, 14,  4, 20,  1, 31,  5, 34,  1,  5, 11,  8,  7, 19,
    11, 25,  8, 33, 11,  3, 14,  8, 12, 21, 14, 26, 12, 39, 14,
     4, 18, 14, 21, 22, 18, 28, 21, 39, 19,  2, 27, 13, 25, 16,
    27, 27, 25, 33, 28,  5,  1, 15,  4, 19,  1, 30,  5, 33,  1,
     4, 11,  8,  8, 18, 11, 26,  8, 32, 11,  4, 14,  9, 12, 22,
    14, 27, 12, 39, 15,  5, 18, 13, 21, 23, 18, 27, 21, 38, 19,
     1, 27, 12, 25, 16, 28, 26, 25, 34, 28,  4,  1, 15,  5, 18,
     1, 29,  5, 32,  1,  3, 11,  9,  8, 17, 11, 27,  8, 32,  6,
     5, 14, 10, 12, 23, 14, 28, 12, 38, 15,  6, 18, 12, 21, 23,
    19, 26, 21, 37, 19,  0, 27, 11, 25, 17, 28, 25, 25, 35, 28,
     3,  1, 14,  5, 17,  1, 28,  5, 32,  2,  2, 11, 10,  8, 16,
    11, 28,  8, 33,  6,  6, 14, 11, 12, 23, 15, 29, 12, 37, 15,
     7, 18, 11, 21, 22, 19, 25, 21, 36, 19,  0, 28, 10, 25, 18,
    28, 24, 25, 36, 28,  2,  1, 13,  5, 16,  1, 27,  5, 33,  2,
     1, 11, 11,  8, 16,  6, 29,  8, 34,  6,  7, 14, 12, 12, 22,
    15, 30, 12, 36, 15,  7, 19, 10, 21, 21, 19, 24, 21, 35, 19,
     1, 28,  9, 25, 19, 28, 24, 26, 37, 28,  1,  1, 12,  5, 16,
     2, 26,  5, 34,  2,  0, 11, 12,  8, 17,  6, 30,  8, 35,  6,
     7, 15, 13, 12, 21, 15, 31, 12, 35, 15,  6, 19,  9, 21, 20,
    19, 24, 22, 34, 19,  2, 28,  8, 25, 20, 28, 25, 26, 38, 28,
     0,  1, 11,  5, 17,  2, 25,  5, 35,  2,  0,  6, 13,  8, 18,
     6, 31,  8, 36,  6,  6, 15, 14, 12, 20, 15, 31, 13, 34, 15,
     5, 19,  8, 21, 19, 19, 25, 22, 33, 19,  3, 28,  8, 26, 21,
    28, 26, 26, 39, 28,  0,  2, 10,  5, 18,  2, 24,  5, 36,  2,
     1,  6, 14,  8, 19,  6, 31,  9, 37,  6,  5, 15, 15, 12, 19,
    15, 30, 13, 33, 15,  4, 19,  8, 22, 18, 19, 26, 22, 32, 19,
     4, 28,  9, 26, 22, 28, 27, 26, 39, 29,  1,  2,  9,  5, 19,
     2, 24,  0, 37,  2,  2,  6, 15,  8, 20,  6, 30,  9, 38,  6,
     4, 15, 15, 13, 18, 15, 29, 13, 32, 15,  3, 19,  9, 22, 17,
    19, 27, 22, 32, 20,  5, 28, 10, 26, 23, 28, 28, 26, 38, 29,
     2,  2,  8,  5, 20,  2, 25,  0, 38,  2,  3,  6, 15,  9, 21,
     6, 29,  9, 39,  6,  3, 15, 14, 13, 17, 15, 28, 13, 32, 16,
     2, 19, 10, 22, 16, 19, 28, 22, 33, 20,  6, 28, 11, 26, 23,
    29, 29, 26, 37, 29,  3,  2,  8,  0, 21,  2, 26,  0, 39,  2,
     4,  6, 14,  9, 22,  6, 28,  9, 39,  7,  2, 15, 13, 13, 16,
    15, 27, 13, 33, 16,  1, 19, 11, 22, 16, 20, 29, 22, 34, 20,
     7, 28, 12, 26, 22, 29, 30, 26, 36, 29,  4,  2,  9,  0, 22,
     2, 27,  0, 39,  3,  5,  6, 13,  9, 23,  6, 27,  9, 38,  7,
     1, 15, 12, 13, 16, 16, 26, 13, 34, 16,  0, 19, 12, 22, 17,
    20, 30, 22, 35, 20,  7, 29, 13, 26, 21, 29, 31, 26, 35, 29,
     5,  2, 10,  0, 23,  2, 28,  0, 38,  3,  6,  6, 12,  9, 23,
     7, 26,  9, 37,  7,  0, 15, 11, 13, 17, 16, 25, 13, 35, 16,
     0, 20, 13, 22, 18, 20, 31, 22, 36, 20,  6, 29, 14, 26, 20,
    29, 31, 27, 34, 29,  6,  2, 11,  0, 23,  3, 29,  0, 37,  3,
     7,  6, 11,  9, 22,  7, 25,  9, 36,  7,  0, 16, 10, 13, 18,
    16, 24, 13, 36, 16,  1, 20, 14, 22, 19, 20, 31, 23, 37, 20,
     5, 29, 15, 26, 19, 29, 30, 27, 33, 29,  7,  2, 12,  0, 22,
     3, 30,  0, 36,  3,  7,  7, 10,  9, 21,  7, 24,  9, 35,  7,
     1, 16,  9, 13, 19, 16, 24, 14, 37, 16,  2, 20, 15, 22, 20,
    20, 30, 23, 38, 20,  4, 29, 15, 27, 18, 29, 29, 27, 32, 29,
     7,  3, 13,  0, 21,  3, 31,  0, 35,  3,  6,  7,  9,  9, 20,
     7, 24, 10, 34,  7,  2, 16,  8, 13, 20, 16, 25, 14, 38, 16,
     3, 20, 15, 23, 21, 20, 29, 23, 39, 20,  3, 29, 14, 27, 17,
    29, 28, 27, 32, 24,  6,  3, 14,  0, 20,  3, 31,  1, 34,  3,
     5,  7,  8,  9, 19,  7, 25, 10, 33,  7,  3, 16,  8, 14, 21,
    16, 26, 14, 39, 16,  4, 20, 14, 23, 22, 20, 28, 23, 39, 21,
     2, 29, 13, 27, 16, 29, 27, 27, 33, 24,  5,  3, 15,  0, 19,
     3, 30,  1, 33,  3,  4,  7,  8, 10, 18,  7, 26, 10, 32,  7,
     4, 16,  9, 14, 22, 16, 27, 14, 39, 17,  5, 20, 13, 23, 23,
    20, 27, 23, 38, 21,  1, 29, 12, 27, 16, 24, 26, 27, 34, 24,
     4,  3, 15,  1, 18,  3, 29,  1, 32,  3,  3,  7,  9, 10, 17,
     7, 27, 10, 32,  8,  5, 16, 10, 14, 23, 16, 28, 14, 38, 17,
     6, 20, 12, 23, 23, 21, 26, 23, 37, 21,  0, 29, 11, 27, 17,
    24, 25, 27, 35, 24,  3,  3, 14,  1, 17,  3, 28,  1, 32,  4,
     2,  7, 10, 10, 16,  7, 28, 10, 33,  8,  6, 16, 11, 14, 23,
    17, 29, 14, 37, 17,  7, 20, 11, 23, 22, 21, 25, 23, 36, 21,
     0, 24, 10, 27, 18, 24, 24, 27, 36, 24,  2,  3, 13,  1, 16,
     3, 27,  1, 33,  4,  1,  7, 11, 10, 16,  8, 29, 10, 34,  8,
     7, 16, 12, 14, 22, 17, 30, 14, 36, 17,  7, 21, 10, 23, 21,
    21, 24, 23, 35, 21,  1, 24,  9, 27, 19, 24, 24, 28, 37, 24,
     1,  3, 12,  1, 16,  4, 26,  1, 34,  4,  0,  7, 12, 10, 17,
     8, 30, 10, 35,  8,  7, 17, 13, 14, 21, 17, 31, 14, 35, 17,
     6, 21,  9, 23, 20, 21, 24, 18, 34, 21,  2, 24,  8, 27, 20,
    24, 25, 28, 38, 24,  0,  3, 11,  1, 17,  4, 25,  1, 35,  4,
     0,  8, 13, 10, 18,  8, 31, 10, 36,  8,  6, 17, 14, 14, 20,
    17, 31, 15, 34, 17,  5, 21,  8, 23, 19, 21, 25, 18, 33, 21,
     3, 24,  8, 28, 21, 24, 26, 28, 39, 24,  0,  4, 10,  1, 18,
     4, 24,  1, 36,  4,  1,  8, 14, 10, 19,  8, 31, 11, 37,  8,
     5, 17, 15, 14, 19, 17, 30, 15, 33, 17,  4, 21,  8, 18, 18,
    21, 26, 18, 32, 21,  4, 24,  9, 28, 22, 24, 27, 28, 39, 25,
     1,  4,  9,  1, 19,  4, 24,  2, 37,  4,  2,  8, 15, 10, 20,
     8, 30, 11, 38,  8,  4, 17, 15, 15, 18, 17, 29, 15, 32, 17,
     3, 21,  9, 18, 17, 21, 27, 18, 32, 22,  5, 24, 10, 28, 23,
    24, 28, 28, 38, 25,  2,  4,  8,  1, 20,  4, 25,  2, 38,  4,
     3,  8, 15, 11, 21,  8, 29, 11, 39,  8,  3, 17, 14, 15, 17,
    17, 28, 15, 32, 12,  2, 21, 10, 18, 16, 21, 28, 18, 33, 22,
     6, 24, 11, 28, 23, 25, 29, 28, 37, 25,  3,  4,  8,  2, 21,
     4, 26,  2, 39,  4,  4,  8, 14, 11, 22,  8, 28, 11, 39,  9,
     2, 17, 13, 15, 16, 17, 27, 15, 33, 12,  1, 21, 11, 18, 16,
    22, 29, 18, 34, 22,  7, 24, 12, 28, 22, 25, 30, 28, 36, 25,
     4,  4,  9,  2, 22,  4, 27,  2, 39,  5,  5,  8, 13, 11, 23,
     8, 27, 11, 38,  9,  1, 17, 12, 15, 16, 12, 26, 15, 34, 12,
     0, 21, 12, 18, 17, 22, 30, 18, 35, 22,  7, 25, 13, 28, 21,
    25, 31, 28, 35, 25,  5,  4, 10,  2, 23,  4, 28,  2, 38,  5,
     6,  8, 12, 11, 23,  9, 26, 11, 37,  9,  0, 17, 11, 15, 17,
    12, 25, 15, 35, 12,  0, 22, 13, 18, 18, 22, 31, 18, 36, 22,
     6, 25, 14, 28, 20, 25, 31, 29, 34, 25,  6,  4, 11,  2, 23,
     5, 29,  2, 37,  5,  7,  8, 11, 11, 22,  9, 25, 11, 36,  9,
     0, 12, 10, 15, 18, 12, 24, 15, 36, 12,  1, 22, 14, 18, 19,
    22, 31, 19, 37, 22,  5, 25, 15, 28, 19, 25, 30, 29, 33, 25,
     7,  4, 12,  2, 22,  5, 30,  2, 36,  5,  7,  9, 10, 11, 21,
     9, 24, 11, 35,  9,  1, 12,  9, 15, 19, 12, 24, 16, 37, 12,
     2, 22, 15, 18, 20, 22, 30, 19, 38, 22,  4, 25, 15, 29, 18,
    25, 29, 29, 32, 25,  7,  5, 13,  2, 21,  5, 31,  2, 35,  5,
     6,  9,  9, 11, 20,  9, 24,  6, 34,  9,  2, 12,  8, 15, 20,
    12, 25, 16, 38, 12,  3, 22, 15, 19, 21, 22, 29, 19, 39, 22,
     3, 25, 14, 29, 17, 25, 28, 29, 32, 26,  6,  5, 14,  2, 20,
     5, 31,  3, 34,  5,  5,  9,  8, 11, 19,  9, 25,  6, 33,  9,
     3, 12,  8, 16, 21, 12, 26, 16, 39, 12,  4, 22, 14, 19, 22,
    22, 28, 19, 39, 23,  2, 25, 13, 29, 16, 25, 27, 29, 33, 26,
     5,  5, 15,  2, 19,  5, 30,  3, 33,  5,  4,  9,  8,  6, 18,
     9, 26,  6, 32,  9,  4, 12,  9, 16, 22, 12, 27, 16, 39, 13,
     5, 22, 13, 19, 23, 22, 27, 19, 38, 23,  1, 25, 12, 29, 16,
    26, 26, 29, 34, 26,  4,  5, 15,  3, 18,  5, 29,  3, 32,  5,
     3,  9,  9,  6, 17,  9, 27,  6, 32, 10,  5, 12, 10, 16, 23,
    12, 28, 16, 38, 13,  6, 22, 12, 19, 23, 23, 26, 19, 37, 23,
     0, 25, 11, 29, 17, 26, 25, 29, 35, 26,  3,  5, 14,  3, 17,
     5, 28,  3, 32,  0,  2,  9, 10,  6, 16,  9, 28,  6, 33, 10,
     6, 12, 11, 16, 23, 13, 29, 16, 37, 13,  7, 22, 11, 19, 22,
    23, 25, 19, 36, 23,  0, 26, 10, 29, 18, 26, 24, 29, 36, 26,
     2,  5, 13,  3, 16,  5, 27,  3, 33,  0,  1,  9, 11,  6, 16,
    10, 29,  6, 34, 10,  7, 12, 12, 16, 22, 13, 30, 16, 36, 13,
     7, 23, 10, 19, 21, 23, 24, 19, 35, 23,  1, 26,  9, 29, 19,
    26, 24, 24, 37, 26,  1,  5, 12,  3, 16,  0, 26,  3, 34,  0,
     0,  9, 12,  6, 17, 10, 30,  6, 35, 10,  7, 13, 13, 16, 21,
    13, 31, 16, 35, 13,  6, 23,  9, 19, 20, 23, 24, 20, 34, 23,
     2, 26,  8, 29, 20, 26, 25, 24, 38, 26,  0,  5, 11,  3, 17,
     0, 25,  3, 35,  0,  0, 10, 13,  6, 18, 10, 31,  6, 36, 10,
     6, 13, 14, 16, 20, 13, 31, 17, 34, 13,  5, 23,  8, 19, 19,
    23, 25, 20, 33, 23,  3, 26,  8, 24, 21, 26, 26, 24, 39, 26,
};

static const uint8_t hq_tab_10[] = {
     0,  0,  4,  1, 10,  0, 13,  2, 19,  1,  0,  5,  6,  4, 10,
     3, 15,  5, 16,  3,  2,  8,  6,  7,  8,  6, 12,  7, 18,  6,
     2, 11,  4, 10,  8, 11, 14, 10, 18,  9,  0, 14,  7, 12, 10,
    14, 14, 13, 16, 12,  1,  0,  4,  2, 11,  0, 14,  2, 18,  1,
     3,  3,  7,  4,  9,  3, 14,  5, 16,  4,  3,  8,  5,  7,  9,
     6, 12,  8, 19,  6,  1, 11,  5, 10, 11,  9, 15, 10, 17,  9,
     1, 14,  7, 13, 11, 14, 13, 13, 17, 12,  2,  0,  5,  2, 11,
     1, 15,  2, 17,  1,  2,  3,  7,  5,  8,  3, 13,  5, 17,  4,
     0,  6,  4,  7, 10,  6, 13,  8, 19,  7,  0, 11,  6, 10, 10,
     9, 15, 11, 16,  9,  2, 14,  6, 13,  8, 12, 12, 13, 18, 12,
     3,  0,  6,  2, 10,  1, 12,  0, 16,  1,  1,  3,  6,  5,  8,
     4, 12,  5, 18,  4,  1,  6,  4,  8, 11,  6, 14,  8, 18,  7,
     3,  9,  7, 10,  9,  9, 14, 11, 16, 10,  3, 14,  5, 13,  9,
    12, 12, 14, 19, 12,  3,  1,  7,  2,  9,  1, 13,  0, 16,  2,
     0,  3,  5,  5,  9,  4, 15,  3, 19,  4,  2,  6,  5,  8, 11,
     7, 15,  8, 17,  7,  2,  9,  7, 11,  8,  9, 13, 11, 17, 10,
     0, 12,  4, 13, 10, 12, 13, 14, 19, 13,  2,  1,  4,  0,  8,
     1, 14,  0, 17,  2,  0,  4,  4,  5, 10,  4, 14,  3, 19,  5,
     3,  6,  6,  8, 10,  7, 12,  6, 16,  7,  1,  9,  6, 11,  8,
    10, 12, 11, 18, 10,  1, 12,  4, 14, 11, 12, 14, 14, 18, 13,
     1,  1,  5,  0,  8,  2, 15,  0, 18,  2,  1,  4,  7,  3, 11,
     4, 13,  3, 18,  5,  3,  7,  7,  8,  9,  7, 13,  6, 16,  8,
     0,  9,  5, 11,  9, 10, 15,  9, 19, 10,  2, 12,  5, 14, 11,
    13, 15, 14, 17, 13,  0,  1,  6,  0,  9,  2, 15,  1, 19,  2,
     2,  4,  6,  3, 11,  5, 12,  3, 17,  5,  2,  7,  4,  6,  8,
     7, 14,  6, 17,  8,  0, 10,  4, 11, 10, 10, 14,  9, 19, 11,
     3, 12,  6, 14, 10, 13, 12, 12, 16, 13,  0,  2,  7,  0, 10,
     2, 14,  1, 16,  0,  3,  4,  5,  3, 10,  5, 12,  4, 16,  5,
     1,  7,  5,  6,  8,  8, 15,  6, 18,  8,  1, 10,  7,  9, 11,
    10, 13,  9, 18, 11,  3, 13,  7, 14,  9, 13, 13, 12, 16, 14,
     1,  2,  7,  1, 11,  2, 13,  1, 17,  0,  3,  5,  4,  3,  9,
     5, 13,  4, 19,  3,  0,  7,  6,  6,  9,  8, 15,  7, 19,  8,
     2, 10,  6,  9, 11, 11, 12,  9, 17, 11,  2, 13,  4, 12,  8,
    13, 14, 12, 17, 14,  2,  2,  6,  1,  8,  0, 12,  1, 18,  0,
     2,  5,  4,  4,  8,  5, 14,  4, 18,  3,  0,  8,  7,  6, 10,
     8, 14,  7, 16,  6,  3, 10,  5,  9, 10, 11, 12, 10, 16, 11,
     1, 13,  5, 12,  8, 14, 15, 12, 18, 14,  3,  2,  5,  1,  9,
     0, 12,  2, 19,  0,  1,  5,  5,  4, 11,  3, 15,  4, 17,  3,
     1,  8,  7,  7, 11,  8, 13,  7, 17,  6,  3, 11,  4,  9,  9,
    11, 13, 10, 19,  9,  0, 13,  6, 12,  9, 14, 15, 13, 19, 14,
};

static const uint8_t hq_tab_11[] = {
    0, 0, 3, 3, 5, 1, 6, 0, 8, 2, 1, 5, 3, 7, 4,
    6, 6, 4, 9, 7, 1, 0, 2, 3, 4, 1, 7, 0, 9, 2,
    0, 5, 2, 7, 5, 6, 7, 4, 8, 7, 1, 1, 2, 0, 4,
    2, 7, 1, 9, 3, 0, 6, 2, 4, 5, 7, 7, 5, 8, 4,
    0, 1, 3, 0, 5, 2, 6, 1, 8, 3, 1, 6, 3, 4, 4,
    7, 6, 5, 9, 4, 0, 2, 3, 1, 5, 3, 6, 2, 8, 0,
    1, 7, 3, 5, 4, 4, 6, 6, 9, 5, 1, 2, 2, 1, 4,
    3, 7, 2, 9, 0, 0, 7, 2, 5, 5, 4, 7, 6, 8, 5,
    1, 3, 2, 2, 4, 0, 7, 3, 9, 1, 0, 4, 2, 6, 5,
    5, 7, 7, 8, 6, 0, 3, 3, 2, 5, 0, 6, 3, 8, 1,
    1, 4, 3, 6, 4, 5, 6, 7, 9, 6,
};

static const uint8_t hq_tab_12[] = {
     0,  0, 13,  3, 22,  0, 31,  3, 44,  0,  3, 11, 12,  8, 21,
    11, 34,  8, 40, 12,  2, 16, 11, 19, 24, 16, 30, 20, 46, 16,
     1, 27, 14, 24, 20, 28, 36, 24, 42, 28,  4, 32, 10, 36, 26,
    32, 32, 36, 48, 32,  1,  0, 12,  3, 23,  0, 30,  3, 45,  0,
     2, 11, 13,  8, 20, 11, 35,  8, 41, 12,  3, 16, 10, 19, 25,
    16, 31, 20, 47, 16,  0, 27, 15, 24, 21, 28, 37, 24, 43, 28,
     5, 32, 11, 36, 27, 32, 33, 36, 49, 32,  2,  0, 11,  3, 24,
     0, 30,  4, 46,  0,  1, 11, 14,  8, 20, 12, 36,  8, 42, 12,
     4, 16, 10, 20, 26, 16, 32, 20, 48, 16,  0, 28, 16, 24, 22,
    28, 38, 24, 44, 28,  6, 32, 12, 36, 28, 32, 34, 36, 49, 33,
     3,  0, 10,  3, 25,  0, 31,  4, 47,  0,  0, 11, 15,  8, 21,
    12, 37,  8, 43, 12,  5, 16, 11, 20, 27, 16, 33, 20, 49, 16,
     1, 28, 17, 24, 23, 28, 39, 24, 45, 28,  7, 32, 13, 36, 29,
    32, 35, 36, 48, 33,  4,  0, 10,  4, 26,  0, 32,  4, 48,  0,
     0, 12, 16,  8, 22, 12, 38,  8, 44, 12,  6, 16, 12, 20, 28,
    16, 34, 20, 49, 17,  2, 28, 18, 24, 24, 28, 39, 25, 46, 28,
     8, 32, 14, 36, 29, 33, 36, 36, 47, 33,  5,  0, 11,  4, 27,
     0, 33,  4, 49,  0,  1, 12, 17,  8, 23, 12, 39,  8, 45, 12,
     7, 16, 13, 20, 29, 16, 35, 20, 48, 17,  3, 28, 19, 24, 25,
    28, 38, 25, 47, 28,  9, 32, 15, 36, 28, 33, 37, 36, 46, 33,
     6,  0, 12,  4, 28,  0, 34,  4, 49,  1,  2, 12, 18,  8, 24,
    12, 39,  9, 46, 12,  8, 16, 14, 20, 29, 17, 36, 20, 47, 17,
     4, 28, 19, 25, 26, 28, 37, 25, 48, 28,  9, 33, 16, 36, 27,
    33, 38, 36, 45, 33,  7,  0, 13,  4, 29,  0, 35,  4, 48,  1,
     3, 12, 19,  8, 25, 12, 38,  9, 47, 12,  9, 16, 15, 20, 28,
    17, 37, 20, 46, 17,  5, 28, 18, 25, 27, 28, 36, 25, 49, 28,
     8, 33, 17, 36, 26, 33, 39, 36, 44, 33,  8,  0, 14,  4, 29,
     1, 36,  4, 47,  1,  4, 12, 19,  9, 26, 12, 37,  9, 48, 12,
     9, 17, 16, 20, 27, 17, 38, 20, 45, 17,  6, 28, 17, 25, 28,
    28, 35, 25, 49, 29,  7, 33, 18, 36, 25, 33, 39, 37, 43, 33,
     9,  0, 15,  4, 28,  1, 37,  4, 46,  1,  5, 12, 18,  9, 27,
    12, 36,  9, 49, 12,  8, 17, 17, 20, 26, 17, 39, 20, 44, 17,
     7, 28, 16, 25, 29, 28, 34, 25, 48, 29,  6, 33, 19, 36, 24,
    33, 38, 37, 42, 33,  9,  1, 16,  4, 27,  1, 38,  4, 45,  1,
     6, 12, 17,  9, 28, 12, 35,  9, 49, 13,  7, 17, 18, 20, 25,
    17, 39, 21, 43, 17,  8, 28, 15, 25, 29, 29, 33, 25, 47, 29,
     5, 33, 19, 37, 23, 33, 37, 37, 41, 33,  8,  1, 17,  4, 26,
     1, 39,  4, 44,  1,  7, 12, 16,  9, 29, 12, 34,  9, 48, 13,
     6, 17, 19, 20, 24, 17, 38, 21, 42, 17,  9, 28, 14, 25, 28,
    29, 32, 25, 46, 29,  4, 33, 18, 37, 22, 33, 36, 37, 40, 33,
     7,  1, 18,  4, 25,  1, 39,  5, 43,  1,  8, 12, 15,  9, 29,
    13, 33,  9, 47, 13,  5, 17, 19, 21, 23, 17, 37, 21, 41, 17,
     9, 29, 13, 25, 27, 29, 31, 25, 45, 29,  3, 33, 17, 37, 21,
    33, 35, 37, 40, 34,  6,  1, 19,  4, 24,  1, 38,  5, 42,  1,
     9, 12, 14,  9, 28, 13, 32,  9, 46, 13,  4, 17, 18, 21, 22,
    17, 36, 21, 40, 17,  8, 29, 12, 25, 26, 29, 30, 25, 44, 29,
     2, 33, 16, 37, 20, 33, 34, 37, 41, 34,  5,  1, 19,  5, 23,
     1, 37,  5, 41,  1,  9, 13, 13,  9, 27, 13, 31,  9, 45, 13,
     3, 17, 17, 21, 21, 17, 35, 21, 40, 18,  7, 29, 11, 25, 25,
    29, 30, 26, 43, 29,  1, 33, 15, 37, 20, 34, 33, 37, 42, 34,
     4,  1, 18,  5, 22,  1, 36,  5, 40,  1,  8, 13, 12,  9, 26,
    13, 30,  9, 44, 13,  2, 17, 16, 21, 20, 17, 34, 21, 41, 18,
     6, 29, 10, 25, 24, 29, 31, 26, 42, 29,  0, 33, 14, 37, 21,
    34, 32, 37, 43, 34,  3,  1, 17,  5, 21,  1, 35,  5, 40,  2,
     7, 13, 11,  9, 25, 13, 30, 10, 43, 13,  1, 17, 15, 21, 20,
    18, 33, 21, 42, 18,  5, 29, 10, 26, 23, 29, 32, 26, 41, 29,
     0, 34, 13, 37, 22, 34, 31, 37, 44, 34,  2,  1, 16,  5, 20,
     1, 34,  5, 41,  2,  6, 13, 10,  9, 24, 13, 31, 10, 42, 13,
     0, 17, 14, 21, 21, 18, 32, 21, 43, 18,  4, 29, 11, 26, 22,
    29, 33, 26, 40, 29,  1, 34, 12, 37, 23, 34, 30, 37, 45, 34,
     1,  1, 15,  5, 20,  2, 33,  5, 42,  2,  5, 13, 10, 10, 23,
    13, 32, 10, 41, 13,  0, 18, 13, 21, 22, 18, 31, 21, 44, 18,
     3, 29, 12, 26, 21, 29, 34, 26, 40, 30,  2, 34, 11, 37, 24,
    34, 34, 30, 46, 34,  0,  1, 14,  5, 21,  2, 32,  5, 43,  2,
     4, 13, 11, 10, 22, 13, 33, 10, 40, 13,  1, 18, 12, 21, 23,
    18, 30, 21, 45, 18,  2, 29, 13, 26, 20, 29, 35, 26, 41, 30,
     3, 34, 10, 37, 25, 34, 35, 30, 47, 34,  0,  2, 13,  5, 22,
     2, 31,  5, 44,  2,  3, 13, 12, 10, 21, 13, 34, 10, 40, 14,
     2, 18, 11, 21, 24, 18, 30, 22, 46, 18,  1, 29, 14, 26, 20,
    30, 36, 26, 42, 30,  4, 34, 14, 30, 26, 34, 36, 30, 48, 34,
     1,  2, 12,  5, 23,  2, 30,  5, 45,  2,  2, 13, 13, 10, 20,
    13, 35, 10, 41, 14,  3, 18, 10, 21, 25, 18, 31, 22, 47, 18,
     0, 29, 15, 26, 21, 30, 37, 26, 43, 30,  5, 34, 15, 30, 27,
    34, 37, 30, 49, 34,  2,  2, 11,  5, 24,  2, 30,  6, 46,  2,
     1, 13, 14, 10, 20, 14, 36, 10, 42, 14,  4, 18, 10, 22, 26,
    18, 32, 22, 48, 18,  0, 30, 16, 26, 22, 30, 38, 26, 48, 22,
     6, 34, 16, 30, 28, 34, 38, 30, 49, 35,  3,  2, 10,  5, 25,
     2, 31,  6, 47,  2,  0, 13, 15, 10, 21, 14, 37, 10, 43, 14,
     5, 18, 11, 22, 27, 18, 33, 22, 49, 18,  1, 30, 17, 26, 23,
    30, 39, 26, 49, 22,  7, 34, 17, 30, 29, 34, 39, 30, 48, 35,
     4,  2, 10,  6, 26,  2, 32,  6, 48,  2,  0, 14, 16, 10, 22,
    14, 38, 10, 44, 14,  6, 18, 12, 22, 28, 18, 34, 22, 49, 19,
     2, 30, 18, 26, 28, 22, 39, 27, 49, 23,  8, 34, 18, 30, 29,
    35, 39, 31, 47, 35,  5,  2, 11,  6, 27,  2, 33,  6, 49,  2,
     1, 14, 17, 10, 23, 14, 39, 10, 45, 14,  7, 18, 13, 22, 29,
    18, 35, 22, 48, 19,  3, 30, 19, 26, 29, 22, 38, 27, 48, 23,
     9, 34, 19, 30, 28, 35, 38, 31, 46, 35,  6,  2, 12,  6, 28,
     2, 34,  6, 49,  3,  2, 14, 18, 10, 24, 14, 39, 11, 46, 14,
     8, 18, 14, 22, 29, 19, 36, 22, 47, 19,  8, 22, 19, 27, 29,
    23, 37, 27, 47, 23,  9, 35, 19, 31, 27, 35, 37, 31, 45, 35,
     7,  2, 13,  6, 29,  2, 35,  6, 48,  3,  3, 14, 19, 10, 25,
    14, 38, 11, 47, 14,  9, 18, 15, 22, 28, 19, 37, 22, 46, 19,
     9, 22, 18, 27, 28, 23, 36, 27, 46, 23,  8, 35, 18, 31, 26,
    35, 36, 31, 44, 35,  8,  2, 14,  6, 29,  3, 36,  6, 47,  3,
     4, 14, 19, 11, 26, 14, 37, 11, 48, 14,  9, 19, 16, 22, 27,
    19, 37, 15, 45, 19,  9, 23, 17, 27, 27, 23, 35, 27, 45, 23,
     7, 35, 17, 31, 25, 35, 35, 31, 43, 35,  9,  2, 15,  6, 28,
     3, 37,  6, 46,  3,  5, 14, 18, 11, 27, 14, 36, 11, 49, 14,
     8, 19, 17, 22, 26, 19, 36, 15, 44, 19,  8, 23, 16, 27, 26,
    23, 34, 27, 44, 23,  6, 35, 16, 31, 24, 35, 34, 31, 42, 35,
     9,  3, 16,  6, 27,  3, 38,  6, 45,  3,  6, 14, 17, 11, 28,
    14, 35, 11, 49, 15,  7, 19, 17, 15, 25, 19, 35, 15, 43, 19,
     7, 23, 15, 27, 25, 23, 33, 27, 43, 23,  5, 35, 15, 31, 23,
    35, 33, 31, 41, 35,  8,  3, 17,  6, 26,  3, 39,  6, 44,  3,
     7, 14, 16, 11, 29, 14, 34, 11, 48, 15,  6, 19, 16, 15, 24,
    19, 34, 15, 42, 19,  6, 23, 14, 27, 24, 23, 32, 27, 42, 23,
     4, 35, 14, 31, 22, 35, 32, 31, 40, 35,  7,  3, 18,  6, 25,
     3, 39,  7, 43,  3,  8, 14, 15, 11, 29, 15, 33, 11, 43,  7,
     5, 19, 15, 15, 23, 19, 33, 15, 41, 19,  5, 23, 13, 27, 23,
    23, 31, 27, 41, 23,  3, 35, 13, 31, 21, 35, 31, 31, 40, 36,
     6,  3, 19,  6, 24,  3, 38,  7, 42,  3,  9, 14, 14, 11, 28,
    15, 32, 11, 42,  7,  4, 19, 14, 15, 22, 19, 32, 15, 40, 19,
     4, 23, 12, 27, 22, 23, 30, 27, 40, 23,  2, 35, 12, 31, 20,
    35, 30, 31, 41, 36,  5,  3, 19,  7, 23,  3, 37,  7, 41,  3,
     9, 15, 13, 11, 23,  7, 31, 11, 41,  7,  3, 19, 13, 15, 21,
    19, 31, 15, 40, 20,  3, 23, 11, 27, 21, 23, 30, 28, 40, 24,
     1, 35, 11, 31, 20, 36, 30, 32, 42, 36,  4,  3, 18,  7, 22,
     3, 36,  7, 40,  3,  8, 15, 12, 11, 22,  7, 30, 11, 40,  7,
     2, 19, 12, 15, 20, 19, 30, 15, 41, 20,  2, 23, 10, 27, 20,
    23, 31, 28, 41, 24,  0, 35, 10, 31, 21, 36, 31, 32, 43, 36,
     3,  3, 17,  7, 21,  3, 35,  7, 40,  4,  3,  7, 11, 11, 21,
     7, 30, 12, 40,  8,  1, 19, 11, 15, 20, 20, 30, 16, 42, 20,
     1, 23, 10, 28, 20, 24, 32, 28, 42, 24,  0, 36, 10, 32, 22,
    36, 32, 32, 44, 36,  2,  3, 16,  7, 20,  3, 34,  7, 41,  4,
     2,  7, 10, 11, 20,  7, 31, 12, 41,  8,  0, 19, 10, 15, 21,
    20, 31, 16, 43, 20,  0, 23, 11, 28, 21, 24, 33, 28, 43, 24,
     1, 36, 11, 32, 23, 36, 33, 32, 45, 36,  1,  3, 15,  7, 20,
     4, 30,  0, 42,  4,  1,  7, 10, 12, 20,  8, 32, 12, 42,  8,
     0, 20, 10, 16, 22, 20, 32, 16, 44, 20,  0, 24, 12, 28, 22,
    24, 34, 28, 44, 24,  2, 36, 12, 32, 24, 36, 34, 32, 46, 36,
     0,  3, 14,  7, 21,  4, 31,  0, 43,  4,  0,  7, 11, 12, 21,
     8, 33, 12, 43,  8,  1, 20, 11, 16, 23, 20, 33, 16, 45, 20,
     1, 24, 13, 28, 23, 24, 35, 28, 45, 24,  3, 36, 13, 32, 25,
    36, 35, 32, 47, 36,  0,  4, 10,  0, 22,  4, 32,  0, 44,  4,
     0,  8, 12, 12, 22,  8, 34, 12, 44,  8,  2, 20, 12, 16, 24,
    20, 34, 16, 46, 20,  2, 24, 14, 28, 24, 24, 36, 28, 46, 24,
     4, 36, 14, 32, 26, 36, 36, 32, 48, 36,  1,  4, 11,  0, 23,
     4, 33,  0, 45,  4,  1,  8, 13, 12, 23,  8, 35, 12, 45,  8,
     3, 20, 13, 16, 25, 20, 35, 16, 47, 20,  3, 24, 15, 28, 25,
    24, 37, 28, 47, 24,  5, 36, 15, 32, 27, 36, 37, 32, 49, 36,
     2,  4, 12,  0, 24,  4, 34,  0, 46,  4,  2,  8, 14, 12, 24,
     8, 36, 12, 46,  8,  4, 20, 14, 16, 26, 20, 36, 16, 48, 20,
     4, 24, 16, 28, 26, 24, 38, 28, 48, 24,  6, 36, 16, 32, 28,
    36, 38, 32, 49, 37,  3,  4, 13,  0, 25,  4, 35,  0, 47,  4,
     3,  8, 15, 12, 25,  8, 37, 12, 47,  8,  5, 20, 15, 16, 27,
    20, 37, 16, 49, 20,  5, 24, 17, 28, 27, 24, 39, 28, 49, 24,
     7, 36, 17, 32, 29, 36, 39, 32, 48, 37,  4,  4, 14,  0, 26,
     4, 36,  0, 48,  4,  4,  8, 16, 12, 26,  8, 38, 12, 48,  8,
     6, 20, 16, 16, 28, 20, 38, 16, 49, 21,  6, 24, 18, 28, 28,
    24, 39, 29, 49, 25,  8, 36, 18, 32, 29, 37, 39, 33, 47, 37,
     5,  4, 15,  0, 27,  4, 37,  0, 49,  4,  5,  8, 17, 12, 27,
     8, 39, 12, 49,  8,  7, 20, 17, 16, 29, 20, 39, 16, 48, 21,
     7, 24, 19, 28, 29, 24, 38, 29, 48, 25,  9, 36, 19, 32, 28,
    37, 38, 33, 46, 37,  6,  4, 16,  0, 28,  4, 38,  0, 49,  5,
     6,  8, 18, 12, 28,  8, 39, 13, 49,  9,  8, 20, 18, 16, 29,
    21, 39, 17, 47, 21,  8, 24, 19, 29, 29, 25, 37, 29, 47, 25,
     9, 37, 19, 33, 27, 37, 37, 33, 45, 37,  7,  4, 17,  0, 29,
     4, 39,  0, 48,  5,  7,  8, 19, 12, 29,  8, 38, 13, 48,  9,
     9, 20, 19, 16, 28, 21, 38, 17, 46, 21,  9, 24, 18, 29, 28,
    25, 36, 29, 46, 25,  8, 37, 18, 33, 26, 37, 36, 33, 44, 37,
     8,  4, 18,  0, 29,  5, 39,  1, 47,  5,  8,  8, 19, 13, 29,
     9, 37, 13, 47,  9,  9, 21, 19, 17, 27, 21, 37, 17, 45, 21,
     9, 25, 17, 29, 27, 25, 35, 29, 45, 25,  7, 37, 17, 33, 25,
    37, 35, 33, 43, 37,  9,  4, 19,  0, 28,  5, 38,  1, 46,  5,
     9,  8, 18, 13, 28,  9, 36, 13, 46,  9,  8, 21, 18, 17, 26,
    21, 36, 17, 44, 21,  8, 25, 16, 29, 26, 25, 34, 29, 44, 25,
     6, 37, 16, 33, 24, 37, 34, 33, 42, 37,  9,  5, 19,  1, 27,
     5, 37,  1, 45,  5,  9,  9, 17, 13, 27,  9, 35, 13, 45,  9,
     7, 21, 17, 17, 25, 21, 35, 17, 43, 21,  7, 25, 15, 29, 25,
    25, 33, 29, 43, 25,  5, 37, 15, 33, 23, 37, 33, 33, 41, 37,
     8,  5, 18,  1, 26,  5, 36,  1, 44,  5,  8,  9, 16, 13, 26,
     9, 34, 13, 44,  9,  6, 21, 16, 17, 24, 21, 34, 17, 42, 21,
     6, 25, 14, 29, 24, 25, 32, 29, 42, 25,  4, 37, 14, 33, 22,
    37, 32, 33, 40, 37,  7,  5, 17,  1, 25,  5, 35,  1, 43,  5,
     7,  9, 15, 13, 25,  9, 33, 13, 43,  9,  5, 21, 15, 17, 23,
    21, 33, 17, 41, 21,  5, 25, 13, 29, 23, 25, 31, 29, 41, 25,
     3, 37, 13, 33, 21, 37, 31, 33, 44, 30,  6,  5, 16,  1, 24,
     5, 34,  1, 42,  5,  6,  9, 14, 13, 24,  9, 32, 13, 42,  9,
     4, 21, 14, 17, 22, 21, 32, 17, 40, 21,  4, 25, 12, 29, 22,
    25, 30, 29, 40, 25,  2, 37, 12, 33, 20, 37, 30, 33, 45, 30,
     5,  5, 15,  1, 23,  5, 33,  1, 41,  5,  5,  9, 13, 13, 23,
     9, 31, 13, 41,  9,  3, 21, 13, 17, 21, 21, 31, 17, 40, 22,
     3, 25, 11, 29, 21, 25, 30, 30, 40, 26,  1, 37, 11, 33, 24,
    30, 30, 34, 46, 30,  4,  5, 14,  1, 22,  5, 32,  1, 40,  5,
     4,  9, 12, 13, 22,  9, 30, 13, 40,  9,  2, 21, 12, 17, 20,
    21, 30, 17, 41, 22,  2, 25, 10, 29, 20, 25, 31, 30, 41, 26,
     0, 37, 10, 33, 25, 30, 31, 34, 47, 30,  3,  5, 13,  1, 21,
     5, 31,  1, 40,  6,  3,  9, 11, 13, 21,  9, 30, 14, 40, 10,
     1, 21, 11, 17, 20, 22, 30, 18, 42, 22,  1, 25, 10, 30, 20,
    26, 32, 30, 42, 26,  4, 30, 10, 34, 26, 30, 32, 34, 48, 30,
     2,  5, 12,  1, 20,  5, 30,  1, 41,  6,  2,  9, 10, 13, 20,
     9, 31, 14, 41, 10,  0, 21, 10, 17, 21, 22, 31, 18, 43, 22,
     0, 25, 11, 30, 21, 26, 33, 30, 43, 26,  5, 30, 11, 34, 27,
    30, 33, 34, 49, 30,  1,  5, 11,  1, 20,  6, 30,  2, 42,  6,
     1,  9, 10, 14, 20, 10, 32, 14, 42, 10,  0, 22, 10, 18, 22,
    22, 32, 18, 44, 22,  0, 26, 12, 30, 22, 26, 38, 22, 44, 26,
     6, 30, 12, 34, 28, 30, 34, 34, 49, 31,  0,  5, 10,  1, 21,
     6, 31,  2, 43,  6,  0,  9, 11, 14, 21, 10, 33, 14, 43, 10,
     1, 22, 11, 18, 23, 22, 33, 18, 45, 22,  1, 26, 13, 30, 23,
    26, 39, 22, 45, 26,  7, 30, 13, 34, 29, 30, 35, 34, 48, 31,
     0,  6, 10,  2, 22,  6, 32,  2, 44,  6,  0, 10, 12, 14, 22,
    10, 34, 14, 44, 10,  2, 22, 12, 18, 24, 22, 34, 18, 46, 22,
     2, 26, 18, 22, 24, 26, 39, 23, 46, 26,  8, 30, 14, 34, 29,
    31, 36, 34, 47, 31,  1,  6, 11,  2, 23,  6, 33,  2, 45,  6,
     1, 10, 13, 14, 23, 10, 35, 14, 45, 10,  3, 22, 13, 18, 25,
    22, 35, 18, 47, 22,  3, 26, 19, 22, 25, 26, 38, 23, 47, 26,
     9, 30, 15, 34, 28, 31, 37, 34, 46, 31,  2,  6, 12,  2, 24,
     6, 34,  2, 46,  6,  2, 10, 14, 14, 24, 10, 36, 14, 46, 10,
     4, 22, 14, 18, 26, 22, 36, 18, 47, 15,  4, 26, 19, 23, 26,
    26, 37, 23, 48, 26,  9, 31, 16, 34, 27, 31, 38, 34, 45, 31,
     3,  6, 13,  2, 25,  6, 35,  2, 47,  6,  3, 10, 15, 14, 25,
    10, 37, 14, 47, 10,  5, 22, 15, 18, 27, 22, 37, 18, 46, 15,
     5, 26, 18, 23, 27, 26, 36, 23, 49, 26,  8, 31, 17, 34, 26,
    31, 39, 34, 44, 31,  4,  6, 14,  2, 26,  6, 36,  2, 48,  6,
     4, 10, 16, 14, 26, 10, 38, 14, 48, 10,  6, 22, 16, 18, 27,
    15, 38, 18, 45, 15,  6, 26, 17, 23, 28, 26, 35, 23, 49, 27,
     7, 31, 18, 34, 25, 31, 39, 35, 43, 31,  5,  6, 15,  2, 27,
     6, 37,  2, 49,  6,  5, 10, 17, 14, 27, 10, 39, 14, 49, 10,
     7, 22, 17, 18, 26, 15, 39, 18, 44, 15,  7, 26, 16, 23, 29,
    26, 34, 23, 48, 27,  6, 31, 19, 34, 24, 31, 38, 35, 42, 31,
     6,  6, 16,  2, 28,  6, 38,  2, 49,  7,  6, 10, 18, 14, 28,
    10, 39, 15, 49, 11,  7, 15, 18, 18, 25, 15, 39, 19, 43, 15,
     8, 26, 15, 23, 29, 27, 33, 23, 47, 27,  5, 31, 19, 35, 23,
    31, 37, 35, 41, 31,  7,  6, 17,  2, 29,  6, 39,  2, 48,  7,
     7, 10, 19, 14, 29, 10, 38, 15, 48, 11,  6, 15, 19, 18, 24,
    15, 38, 19, 42, 15,  9, 26, 14, 23, 28, 27, 32, 23, 46, 27,
     4, 31, 18, 35, 22, 31, 36, 35, 40, 31,  8,  6, 18,  2, 29,
     7, 39,  3, 47,  7,  8, 10, 19, 15, 29, 11, 33,  7, 47, 11,
     5, 15, 19, 19, 23, 15, 37, 19, 41, 15,  9, 27, 13, 23, 27,
    27, 31, 23, 45, 27,  3, 31, 17, 35, 21, 31, 35, 35, 40, 32,
     9,  6, 19,  2, 28,  7, 38,  3, 46,  7,  9, 10, 18, 15, 28,
    11, 32,  7, 46, 11,  4, 15, 18, 19, 22, 15, 36, 19, 40, 15,
     8, 27, 12, 23, 26, 27, 30, 23, 44, 27,  2, 31, 16, 35, 20,
    31, 34, 35, 41, 32,  9,  7, 19,  3, 27,  7, 37,  3, 45,  7,
     9, 11, 13,  7, 27, 11, 31,  7, 45, 11,  3, 15, 17, 19, 21,
    15, 35, 19, 40, 16,  7, 27, 11, 23, 25, 27, 30, 24, 43, 27,
     1, 31, 15, 35, 20, 32, 33, 35, 42, 32,  8,  7, 18,  3, 26,
     7, 36,  3, 44,  7,  8, 11, 12,  7, 26, 11, 30,  7, 44, 11,
     2, 15, 16, 19, 20, 15, 34, 19, 41, 16,  6, 27, 10, 23, 24,
    27, 31, 24, 42, 27,  0, 31, 14, 35, 21, 32, 32, 35, 43, 32,
     7,  7, 17,  3, 25,  7, 35,  3, 40,  0,  7, 11, 11,  7, 25,
    11, 30,  8, 43, 11,  1, 15, 15, 19, 20, 16, 33, 19, 42, 16,
     5, 27, 10, 24, 23, 27, 32, 24, 41, 27,  0, 32, 13, 35, 22,
    32, 31, 35, 44, 32,  6,  7, 16,  3, 24,  7, 34,  3, 41,  0,
     6, 11, 10,  7, 24, 11, 31,  8, 42, 11,  0, 15, 14, 19, 21,
    16, 32, 19, 43, 16,  4, 27, 11, 24, 22, 27, 33, 24, 40, 27,
     1, 32, 12, 35, 23, 32, 30, 35, 45, 32,  5,  7, 15,  3, 20,
     0, 33,  3, 42,  0,  5, 11, 10,  8, 23, 11, 32,  8, 41, 11,
     0, 16, 13, 19, 22, 16, 31, 19, 44, 16,  3, 27, 12, 24, 21,
    27, 34, 24, 40, 28,  2, 32, 11, 35, 24, 32, 30, 36, 46, 32,
     4,  7, 14,  3, 21,  0, 32,  3, 43,  0,  4, 11, 11,  8, 22,
    11, 33,  8, 40, 11,  1, 16, 12, 19, 23, 16, 30, 19, 45, 16,
     2, 27, 13, 24, 20, 27, 35, 24, 41, 28,  3, 32, 10, 35, 25,
    32, 31, 36, 47, 32,
};

static const uint8_t hq_tab_13[] = {
     0,  0, 15,  1,  7,  4, 18,  3,  4,  6, 11,  7, 10, 11, 14,
     9,  8, 12, 14, 14,  6, 17, 11, 16,  9, 19, 18, 20,  2, 23,
    15, 22,  5, 25, 11, 24,  9, 27, 19, 28,  1,  0, 14,  1,  8,
     4, 17,  3,  5,  6, 11,  8,  9, 11, 13,  9,  9, 12, 15, 14,
     5, 17, 12, 16,  8, 19, 19, 20,  1, 23, 16, 22,  4, 25, 12,
    24,  8, 27, 20, 28,  2,  0, 13,  1,  9,  4, 16,  3,  6,  6,
    12,  8,  8, 11, 12,  9, 10, 12, 16, 14,  4, 17, 13, 16,  7,
    19, 20, 20,  0, 23, 17, 22,  3, 25, 13, 24,  7, 27, 21, 28,
     3,  0, 12,  1, 10,  4, 15,  3,  7,  6, 13,  8,  7, 11, 11,
     9, 10, 13, 17, 14,  3, 17, 14, 16,  6, 19, 21, 20, 10, 21,
    18, 22,  2, 25, 14, 24,  6, 27, 21, 29,  4,  0, 11,  1, 10,
     5, 14,  3,  8,  6, 14,  8,  6, 11, 11, 10,  9, 13, 18, 14,
     2, 17, 15, 16,  5, 19, 11, 18,  9, 21, 19, 22,  1, 25, 15,
    24,  5, 27, 20, 29,  5,  0, 11,  2,  9,  5, 13,  3,  9,  6,
    15,  8,  5, 11, 12, 10,  8, 13, 19, 14,  1, 17, 16, 16,  4,
    19, 12, 18,  8, 21, 20, 22,  0, 25, 16, 24,  4, 27, 19, 29,
     6,  0, 12,  2,  8,  5, 12,  3, 10,  6, 16,  8,  4, 11, 13,
    10,  7, 13, 20, 14,  0, 17, 17, 16,  3, 19, 13, 18,  7, 21,
    21, 22,  0, 26, 17, 24,  3, 27, 18, 29,  7,  0, 13,  2,  7,
     5, 11,  3, 10,  7, 17,  8,  3, 11, 14, 10,  6, 13, 21, 14,
    10, 15, 18, 16,  2, 19, 14, 18,  6, 21, 21, 23,  1, 26, 18,
    24,  2, 27, 17, 29,  8,  0, 14,  2,  6,  5, 11,  4,  9,  7,
    18,  8,  2, 11, 15, 10,  5, 13, 11, 12,  9, 15, 19, 16,  1,
    19, 15, 18,  5, 21, 20, 23,  2, 26, 19, 24,  1, 27, 16, 29,
     9,  0, 15,  2,  5,  5, 12,  4,  8,  7, 19,  8,  1, 11, 16,
    10,  4, 13, 12, 12,  8, 15, 20, 16,  0, 19, 16, 18,  4, 21,
    19, 23,  3, 26, 20, 24,  0, 27, 15, 29, 10,  0, 16,  2,  4,
     5, 13,  4,  7,  7, 20,  8,  0, 11, 17, 10,  3, 13, 13, 12,
     7, 15, 21, 16,  0, 20, 17, 18,  3, 21, 18, 23,  4, 26, 21,
    24,  0, 28, 14, 29, 10,  1, 17,  2,  3,  5, 14,  4,  6,  7,
    21,  8, 10,  9, 18, 10,  2, 13, 14, 12,  6, 15, 21, 17,  1,
    20, 18, 18,  2, 21, 17, 23,  5, 26, 21, 25,  1, 28, 13, 29,
     9,  1, 18,  2,  2,  5, 15,  4,  5,  7, 11,  6,  9,  9, 19,
    10,  1, 13, 15, 12,  5, 15, 20, 17,  2, 20, 19, 18,  1, 21,
    16, 23,  6, 26, 20, 25,  2, 28, 12, 29,  8,  1, 19,  2,  1,
     5, 16,  4,  4,  7, 12,  6,  8,  9, 20, 10,  0, 13, 16, 12,
     4, 15, 19, 17,  3, 20, 20, 18,  0, 21, 15, 23,  7, 26, 19,
    25,  3, 28, 11, 29,  7,  1, 20,  2,  0,  5, 17,  4,  3,  7,
    13,  6,  7,  9, 21, 10,  0, 14, 17, 12,  3, 15, 18, 17,  4,
    20, 21, 18,  0, 22, 14, 23,  8, 26, 18, 25,  4, 28, 21, 27,
     6,  1, 21,  2, 10,  3, 18,  4,  2,  7, 14,  6,  6,  9, 21,
    11,  1, 14, 18, 12,  2, 15, 17, 17,  5, 20, 21, 19,  1, 22,
    13, 23,  9, 26, 17, 25,  5, 28, 20, 27,  5,  1, 11,  0,  9,
     3, 19,  4,  1,  7, 15,  6,  5,  9, 20, 11,  2, 14, 19, 12,
     1, 15, 16, 17,  6, 20, 20, 19,  2, 22, 12, 23, 10, 26, 16,
    25,  6, 28, 19, 27,  4,  1, 12,  0,  8,  3, 20,  4,  0,  7,
    16,  6,  4,  9, 19, 11,  3, 14, 20, 12,  0, 15, 15, 17,  7,
    20, 19, 19,  3, 22, 11, 23,  0, 24, 15, 25,  7, 28, 18, 27,
     3,  1, 13,  0,  7,  3, 21,  4,  0,  8, 17,  6,  3,  9, 18,
    11,  4, 14, 21, 12,  0, 16, 14, 17,  8, 20, 18, 19,  4, 22,
    21, 21,  1, 24, 14, 25,  8, 28, 17, 27,  2,  1, 14,  0,  6,
     3, 21,  5,  1,  8, 18,  6,  2,  9, 17, 11,  5, 14, 21, 13,
     1, 16, 13, 17,  9, 20, 17, 19,  5, 22, 20, 21,  2, 24, 13,
    25,  9, 28, 16, 27,  1,  1, 15,  0,  5,  3, 20,  5,  2,  8,
    19,  6,  1,  9, 16, 11,  6, 14, 20, 13,  2, 16, 12, 17, 10,
    20, 16, 19,  6, 22, 19, 21,  3, 24, 12, 25, 10, 28, 15, 27,
     0,  1, 16,  0,  4,  3, 19,  5,  3,  8, 20,  6,  0,  9, 15,
    11,  7, 14, 19, 13,  3, 16, 11, 17,  0, 18, 15, 19,  7, 22,
    18, 21,  4, 24, 11, 25, 10, 29, 14, 27,  0,  2, 17,  0,  3,
     3, 18,  5,  4,  8, 21,  6,  0, 10, 14, 11,  8, 14, 18, 13,
     4, 16, 21, 15,  1, 18, 14, 19,  8, 22, 17, 21,  5, 24, 11,
    26,  9, 29, 13, 27,  1,  2, 18,  0,  2,  3, 17,  5,  5,  8,
    21,  7,  1, 10, 13, 11,  9, 14, 17, 13,  5, 16, 20, 15,  2,
    18, 13, 19,  9, 22, 16, 21,  6, 24, 12, 26,  8, 29, 12, 27,
     2,  2, 19,  0,  1,  3, 16,  5,  6,  8, 20,  7,  2, 10, 12,
    11, 10, 14, 16, 13,  6, 16, 19, 15,  3, 18, 12, 19, 10, 22,
    15, 21,  7, 24, 13, 26,  7, 29, 11, 27,  3,  2, 20,  0,  0,
     3, 15,  5,  7,  8, 19,  7,  3, 10, 11, 11,  0, 12, 15, 13,
     7, 16, 18, 15,  4, 18, 11, 19, 10, 23, 14, 21,  8, 24, 14,
    26,  6, 29, 11, 28,  4,  2, 21,  0,  0,  4, 14,  5,  8,  8,
    18,  7,  4, 10, 21,  9,  1, 12, 14, 13,  8, 16, 17, 15,  5,
    18, 11, 20,  9, 23, 13, 21,  9, 24, 15, 26,  5, 29, 12, 28,
     5,  2, 21,  1,  1,  4, 13,  5,  9,  8, 17,  7,  5, 10, 20,
     9,  2, 12, 13, 13,  9, 16, 16, 15,  6, 18, 12, 20,  8, 23,
    12, 21, 10, 24, 16, 26,  4, 29, 13, 28,  6,  2, 20,  1,  2,
     4, 12,  5, 10,  8, 16,  7,  6, 10, 19,  9,  3, 12, 12, 13,
    10, 16, 15, 15,  7, 18, 13, 20,  7, 23, 11, 21, 10, 25, 17,
    26,  3, 29, 14, 28,  7,  2, 19,  1,  3,  4, 11,  5,  0,  6,
    15,  7,  7, 10, 18,  9,  4, 12, 11, 13, 10, 17, 14, 15,  8,
    18, 14, 20,  6, 23, 11, 22,  9, 25, 18, 26,  2, 29, 15, 28,
     8,  2, 18,  1,  4,  4, 21,  3,  1,  6, 14,  7,  8, 10, 17,
     9,  5, 12, 11, 14,  9, 17, 13, 15,  9, 18, 15, 20,  5, 23,
    12, 22,  8, 25, 19, 26,  1, 29, 16, 28,  9,  2, 17,  1,  5,
     4, 20,  3,  2,  6, 13,  7,  9, 10, 16,  9,  6, 12, 12, 14,
     8, 17, 12, 15, 10, 18, 16, 20,  4, 23, 13, 22,  7, 25, 20,
    26,  0, 29, 17, 28, 10,  2, 16,  1,  6,  4, 19,  3,  3,  6,
    12,  7, 10, 10, 15,  9,  7, 12, 13, 14,  7, 17, 11, 15, 10,
    19, 17, 20,  3, 23, 14, 22,  6, 25, 21, 26, 10, 27, 18, 28,
};

static const uint8_t hq_tab_14[] = {
     0,  0, 17,  0,  0,  2, 14,  1,  9,  3, 14,  3,  9,  5, 19,
     4,  2,  6, 19,  6,  9,  6, 12,  7,  7,  9, 16,  8,  0,  9,
    15,  9, 10, 11, 15, 11, 10, 13, 18, 12,  1, 14, 18, 14,  1,
     0, 18,  0,  1,  2, 13,  1,  8,  3, 13,  3,  8,  5, 20,  4,
     3,  6, 16,  5, 10,  6, 11,  7,  6,  9, 17,  8,  0, 10, 14,
     9,  9, 11, 14, 11,  9, 13, 19, 12,  2, 14, 19, 14,  2,  0,
    19,  0,  2,  2, 12,  1,  7,  3, 12,  3,  7,  5, 21,  4,  4,
     6, 15,  5, 10,  7, 11,  8,  5,  9, 18,  8,  1, 10, 13,  9,
     8, 11, 13, 11,  8, 13, 20, 12,  3, 14, 20, 14,  3,  0, 20,
     0,  3,  2, 11,  1,  6,  3, 11,  3,  6,  5, 21,  5,  5,  6,
    14,  5,  9,  7, 12,  8,  2,  8, 19,  8,  2, 10, 12,  9,  7,
    11, 12, 11,  7, 13, 21, 12,  4, 14, 21, 14,  4,  0, 21,  0,
     4,  2, 11,  2,  5,  3, 11,  4,  1,  4, 20,  5,  6,  6, 13,
     5,  8,  7, 20,  6,  3,  8, 20,  8,  3, 10, 11,  9,  6, 11,
    11, 11,  6, 13, 21, 13,  5, 14, 14, 13,  5,  0, 21,  1,  5,
     2, 12,  2,  4,  3, 19,  2,  2,  4, 19,  5,  7,  6, 12,  5,
     7,  7, 21,  6,  4,  8, 21,  8,  4, 10, 11, 10,  5, 11, 11,
    12,  5, 13, 20, 13,  6, 14, 13, 13,  6,  0, 20,  1,  6,  2,
    13,  2,  3,  3, 20,  2,  3,  4, 18,  5,  8,  6, 11,  5,  6,
     7, 21,  7,  5,  8, 21,  9,  5, 10, 12, 10,  4, 11, 12, 12,
     4, 13, 19, 13,  7, 14, 12, 13,  7,  0, 19,  1,  7,  2, 14,
     2,  2,  3, 21,  2,  4,  4, 17,  5,  5,  5, 11,  6,  5,  7,
    20,  7,  6,  8, 20,  9,  6, 10, 13, 10,  3, 11, 13, 12,  3,
    12, 18, 13,  8, 14, 11, 13,  8,  0, 18,  1,  6,  1, 15,  2,
     1,  3, 21,  3,  5,  4, 12,  4,  4,  5, 12,  6,  4,  7, 19,
     7,  7,  8, 19,  9,  7, 10, 14, 10,  2, 11, 21, 10,  4, 12,
    17, 13,  9, 14, 11, 14,  9,  0, 11,  0,  5,  1, 16,  2,  0,
     3, 20,  3,  6,  4, 13,  4,  3,  5, 13,  6,  3,  7, 18,  7,
     8,  8, 18,  9,  8, 10, 15, 10,  1, 11, 21, 11,  5, 12, 16,
    13, 10, 14, 12, 14, 10,  0, 12,  0,  4,  1, 17,  2,  0,  4,
    19,  3,  7,  4, 14,  4,  2,  5, 14,  6,  2,  7, 17,  7,  9,
     8, 17,  9,  9, 10, 16, 10,  0, 11, 20, 11,  6, 12, 15, 13,
     3, 13, 13, 14, 10,  1, 13,  0,  3,  1, 18,  2,  8,  2, 18,
     3,  8,  4, 15,  4,  1,  5, 15,  6,  1,  7, 16,  7, 10,  8,
    16,  9,  4,  9, 17, 10,  0, 12, 19, 11,  7, 12, 14, 12,  2,
    13, 14, 14,  9,  1, 14,  0,  2,  1, 17,  1,  9,  2, 17,  3,
     9,  4, 16,  4,  0,  5, 16,  6,  0,  7, 15,  7, 10,  9, 13,
     8,  3,  9, 18, 10,  1, 12, 18, 11,  8, 12, 15, 12,  1, 13,
    15, 14,  8,  1, 15,  0,  1,  1, 16,  1, 10,  2, 16,  3, 10,
     4, 17,  4,  0,  6, 17,  6,  0,  8, 14,  7,  9,  9, 14,  8,
     2,  9, 19, 10,  2, 12, 17, 11,  9, 12, 16, 12,  0, 13, 16,
    14,  7,  1, 16,  0,  0,  1, 15,  1, 10,  3, 15,  3, 10,  5,
    18,  4,  1,  6, 18,  6,  1,  8, 13,  7,  8,  9, 15,  8,  1,
     9, 20, 10, 10, 10, 16, 11, 10, 12, 17, 12,  0, 14, 17, 14,
};

static const uint8_t hq_tab_15[] = {
     0,  0, 15,  1,  3,  3, 14,  2,  4,  4, 11,  5,  0,  6, 18,
     6,  8,  8, 14,  8,  4, 10, 21, 11,  9, 13, 18, 12,  8, 14,
    17, 15,  5, 17, 21, 17,  1,  0, 14,  1,  2,  3, 15,  2,  5,
     4, 11,  4,  1,  6, 19,  6,  9,  8, 15,  8,  5, 10, 20, 11,
     8, 13, 19, 12,  9, 14, 16, 15,  4, 17, 20, 17,  2,  0, 13,
     1,  1,  3, 16,  2,  6,  4, 12,  4,  2,  6, 20,  6, 10,  8,
    16,  8,  6, 10, 19, 11,  7, 13, 20, 12, 10, 14, 15, 15,  3,
    17, 19, 17,  3,  0, 12,  1,  0,  3, 17,  2,  7,  4, 13,  4,
     3,  6, 21,  6, 10,  9, 17,  8,  7, 10, 18, 11,  6, 13, 21,
    12, 10, 15, 14, 15,  2, 17, 18, 17,  4,  0, 11,  1,  0,  2,
    18,  2,  8,  4, 14,  4,  4,  6, 21,  7,  9,  9, 18,  8,  8,
    10, 17, 11,  5, 13, 21, 13,  9, 15, 13, 15,  1, 17, 17, 17,
     5,  0, 11,  0,  1,  2, 19,  2,  9,  4, 15,  4,  5,  6, 20,
     7,  8,  9, 19,  8,  9, 10, 16, 11,  4, 13, 20, 13,  8, 15,
    12, 15,  0, 17, 16, 17,  6,  0, 12,  0,  2,  2, 20,  2, 10,
     4, 16,  4,  6,  6, 19,  7,  7,  9, 20,  8, 10, 10, 15, 11,
     3, 13, 19, 13,  7, 15, 11, 15,  0, 16, 15, 17,  7,  0, 13,
     0,  3,  2, 21,  2, 10,  5, 17,  4,  7,  6, 18,  7,  6,  9,
    21,  8, 10, 11, 14, 11,  2, 13, 18, 13,  6, 15, 11, 14,  1,
    16, 14, 17,  8,  0, 14,  0,  4,  2, 21,  3,  9,  5, 18,  4,
     8,  6, 17,  7,  5,  9, 21,  9,  9, 11, 13, 11,  1, 13, 17,
    13,  5, 15, 12, 14,  2, 16, 13, 17,  9,  0, 15,  0,  5,  2,
    20,  3,  8,  5, 19,  4,  9,  6, 16,  7,  4,  9, 20,  9,  8,
    11, 12, 11,  0, 13, 16, 13,  4, 15, 13, 14,  3, 16, 12, 17,
    10,  0, 16,  0,  6,  2, 19,  3,  7,  5, 20,  4, 10,  6, 15,
     7,  3,  9, 19,  9,  7, 11, 11, 11,  0, 12, 15, 13,  3, 15,
    14, 14,  4, 16, 11, 17, 10,  1, 17,  0,  7,  2, 18,  3,  6,
     5, 21,  4, 10,  7, 14,  7,  2,  9, 18,  9,  6, 11, 11, 10,
     1, 12, 14, 13,  2, 15, 15, 14,  5, 16, 11, 16,  9,  1, 18,
     0,  8,  2, 17,  3,  5,  5, 21,  5,  9,  7, 13,  7,  1,  9,
    17,  9,  5, 11, 12, 10,  2, 12, 13, 13,  1, 15, 16, 14,  6,
    16, 12, 16,  8,  1, 19,  0,  9,  2, 16,  3,  4,  5, 20,  5,
     8,  7, 12,  7,  0,  9, 16,  9,  4, 11, 13, 10,  3, 12, 12,
    13,  0, 15, 17, 14,  7, 16, 13, 16,  7,  1, 20,  0, 10,  2,
    15,  3,  3,  5, 19,  5,  7,  7, 11,  7,  0,  8, 15,  9,  3,
    11, 14, 10,  4, 12, 11, 13,  0, 14, 18, 14,  8, 16, 14, 16,
     6,  1, 21,  0, 10,  3, 14,  3,  2,  5, 18,  5,  6,  7, 11,
     6,  1,  8, 14,  9,  2, 11, 15, 10,  5, 12, 11, 12,  1, 14,
    19, 14,  9, 16, 15, 16,  5,  1, 21,  1,  9,  3, 13,  3,  1,
     5, 17,  5,  5,  7, 12,  6,  2,  8, 13,  9,  1, 11, 16, 10,
     6, 12, 12, 12,  2, 14, 20, 14, 10, 16, 16, 16,  4,  1, 20,
     1,  8,  3, 12,  3,  0,  5, 16,  5,  4,  7, 13,  6,  3,  8,
    12,  9,  0, 11, 17, 10,  7, 12, 13, 12,  3, 14, 21, 14, 10,
    17, 17, 16,  3,  1, 19,  1,  7,  3, 11,  3,  0,  4, 15,  5,
     3,  7, 14,  6,  4,  8, 11,  9,  0, 10, 18, 10,  8, 12, 14,
    12,  4, 14, 21, 15,  9, 17, 18, 16,  2,  1, 18,  1,  6,  3,
    11,  2,  1,  4, 14,  5,  2,  7, 15,  6,  5,  8, 11,  8,  1,
    10, 19, 10,  9, 12, 15, 12,  5, 14, 20, 15,  8, 17, 19, 16,
     1,  1, 17,  1,  5,  3, 12,  2,  2,  4, 13,  5,  1,  7, 16,
     6,  6,  8, 12,  8,  2, 10, 20, 10, 10, 12, 16, 12,  6, 14,
    19, 15,  7, 17, 20, 16,  0,  1, 16,  1,  4,  3, 13,  2,  3,
     4, 12,  5,  0,  7, 17,  6,  7,  8, 13,  8,  3, 10, 21, 10,
    10, 13, 17, 12,  7, 14, 18, 15,  6, 17, 21, 16,
};

static const uint8_t hq_tab_16[] = {
     0, 0,  4, 1, 2, 2, 2,  3, 4,  4, 0,  5, 6,  6,  9,
     7, 8,  8, 1, 0, 3, 1,  3, 2,  1, 3,  5, 4, 10,  5,
     7, 6,  8, 7, 9, 8, 2,  0, 2,  1, 4,  2, 0,  3,  6,
     4, 9,  5, 8, 6, 7, 7, 10, 8,  3, 0,  1, 1,  5,  2,
    10, 3,  7, 4, 8, 5, 9,  6, 6,  7, 0,  8, 4,  0,  0,
     1, 6,  2, 9, 3, 8, 4,  7, 5, 10, 6,  5, 7,  1,  8,
     5, 0, 10, 1, 7, 2, 8,  3, 9,  4, 6,  5, 0,  6,  4,
     7, 2,  8, 6, 0, 9, 1,  8, 2,  7, 3, 10, 4,  5,  5,
     1, 6,  3, 7, 3, 8, 7,  0, 8,  1, 9,  2, 6,  3,  0,
     4, 4,  5, 2, 6, 2, 7,  4, 8,  8, 0,  7, 1, 10,  2,
     5, 3,  1, 4, 3, 5, 3,  6, 1,  7, 5,  8, 9,  0,  6,
     1, 0,  2, 4, 3, 2, 4,  2, 5,  4, 6,  0, 7,  6,  8,
    10, 0,  5, 1, 1, 2, 3,  3, 3,  4, 1,  5, 5,  6, 10,
     7, 7,  8, 0, 0,
};

static const uint8_t hq_tab_17[] = {
     0,  0, 25,  8, 34,  0, 59,  8, 68,  0, 13, 24, 22, 16, 47,
    24, 56, 16, 78, 25, 10, 32, 28, 41, 44, 32, 58, 41, 78, 32,
     8, 57, 31, 49, 38, 57, 61, 49, 68, 57,  1,  0, 26,  8, 35,
     0, 60,  8, 69,  0, 14, 24, 23, 16, 47, 25, 57, 16, 77, 25,
    11, 32, 27, 41, 45, 32, 57, 41, 79, 32,  7, 57, 30, 49, 37,
    57, 60, 49, 67, 57,  2,  0, 27,  8, 36,  0, 61,  8, 70,  0,
    15, 24, 24, 16, 46, 25, 58, 16, 76, 25, 12, 32, 26, 41, 46,
    32, 56, 41, 79, 33,  6, 57, 29, 49, 36, 57, 59, 49, 66, 57,
     3,  0, 28,  8, 37,  0, 62,  8, 71,  0, 15, 25, 25, 16, 45,
    25, 59, 16, 75, 25, 13, 32, 25, 41, 47, 32, 55, 41, 78, 33,
     5, 57, 28, 49, 35, 57, 58, 49, 65, 57,  4,  0, 29,  8, 38,
     0, 63,  8, 72,  0, 14, 25, 26, 16, 44, 25, 60, 16, 74, 25,
    14, 32, 24, 41, 47, 33, 54, 41, 77, 33,  4, 57, 27, 49, 34,
    57, 57, 49, 64, 57,  5,  0, 30,  8, 39,  0, 63,  9, 73,  0,
    13, 25, 27, 16, 43, 25, 61, 16, 73, 25, 15, 32, 23, 41, 46,
    33, 53, 41, 76, 33,  3, 57, 26, 49, 33, 57, 56, 49, 64, 58,
     6,  0, 31,  8, 40,  0, 62,  9, 74,  0, 12, 25, 28, 16, 42,
    25, 62, 16, 72, 25, 15, 33, 22, 41, 45, 33, 52, 41, 75, 33,
     2, 57, 25, 49, 32, 57, 55, 49, 65, 58,  7,  0, 31,  9, 41,
     0, 61,  9, 75,  0, 11, 25, 29, 16, 41, 25, 63, 16, 71, 25,
    14, 33, 21, 41, 44, 33, 51, 41, 74, 33,  1, 57, 24, 49, 32,
    58, 54, 49, 66, 58,  8,  0, 30,  9, 42,  0, 60,  9, 76,  0,
    10, 25, 30, 16, 40, 25, 63, 17, 70, 25, 13, 33, 20, 41, 43,
    33, 50, 41, 73, 33,  0, 57, 23, 49, 33, 58, 53, 49, 67, 58,
     9,  0, 29,  9, 43,  0, 59,  9, 77,  0,  9, 25, 31, 16, 39,
    25, 62, 17, 69, 25, 12, 33, 19, 41, 42, 33, 49, 41, 72, 33,
     0, 58, 22, 49, 34, 58, 52, 49, 68, 58, 10,  0, 28,  9, 44,
     0, 58,  9, 78,  0,  8, 25, 31, 17, 38, 25, 61, 17, 68, 25,
    11, 33, 18, 41, 41, 33, 48, 41, 71, 33,  1, 58, 21, 49, 35,
    58, 51, 49, 69, 58, 11,  0, 27,  9, 45,  0, 57,  9, 79,  0,
     7, 25, 30, 17, 37, 25, 60, 17, 67, 25, 10, 33, 17, 41, 40,
    33, 48, 42, 70, 33,  2, 58, 20, 49, 36, 58, 50, 49, 70, 58,
    12,  0, 26,  9, 46,  0, 56,  9, 79,  1,  6, 25, 29, 17, 36,
    25, 59, 17, 66, 25,  9, 33, 16, 41, 39, 33, 49, 42, 69, 33,
     3, 58, 19, 49, 37, 58, 49, 49, 71, 58, 13,  0, 25,  9, 47,
     0, 55,  9, 78,  1,  5, 25, 28, 17, 35, 25, 58, 17, 65, 25,
     8, 33, 16, 42, 38, 33, 50, 42, 68, 33,  4, 58, 18, 49, 38,
    58, 48, 49, 72, 58, 14,  0, 24,  9, 47,  1, 54,  9, 77,  1,
     4, 25, 27, 17, 34, 25, 57, 17, 64, 25,  7, 33, 17, 42, 37,
    33, 51, 42, 67, 33,  5, 58, 17, 49, 39, 58, 48, 50, 73, 58,
    15,  0, 23,  9, 46,  1, 53,  9, 76,  1,  3, 25, 26, 17, 33,
    25, 56, 17, 64, 26,  6, 33, 18, 42, 36, 33, 52, 42, 66, 33,
     6, 58, 16, 49, 40, 58, 49, 50, 74, 58, 15,  1, 22,  9, 45,
     1, 52,  9, 75,  1,  2, 25, 25, 17, 32, 25, 55, 17, 65, 26,
     5, 33, 19, 42, 35, 33, 53, 42, 65, 33,  7, 58, 16, 50, 41,
    58, 50, 50, 75, 58, 14,  1, 21,  9, 44,  1, 51,  9, 74,  1,
     1, 25, 24, 17, 32, 26, 54, 17, 66, 26,  4, 33, 20, 42, 34,
    33, 54, 42, 64, 33,  8, 58, 17, 50, 42, 58, 51, 50, 76, 58,
    13,  1, 20,  9, 43,  1, 50,  9, 73,  1,  0, 25, 23, 17, 33,
    26, 53, 17, 67, 26,  3, 33, 21, 42, 33, 33, 55, 42, 64, 34,
     9, 58, 18, 50, 43, 58, 52, 50, 77, 58, 12,  1, 19,  9, 42,
     1, 49,  9, 72,  1,  0, 26, 22, 17, 34, 26, 52, 17, 68, 26,
     2, 33, 22, 42, 32, 33, 56, 42, 65, 34, 10, 58, 19, 50, 44,
    58, 53, 50, 78, 58, 11,  1, 18,  9, 41,  1, 48,  9, 71,  1,
     1, 26, 21, 17, 35, 26, 51, 17, 69, 26,  1, 33, 23, 42, 32,
    34, 57, 42, 66, 34, 11, 58, 20, 50, 45, 58, 54, 50, 79, 58,
    10,  1, 17,  9, 40,  1, 48, 10, 70,  1,  2, 26, 20, 17, 36,
    26, 50, 17, 70, 26,  0, 33, 24, 42, 33, 34, 58, 42, 67, 34,
    12, 58, 21, 50, 46, 58, 55, 50, 79, 59,  9,  1, 16,  9, 39,
     1, 49, 10, 69,  1,  3, 26, 19, 17, 37, 26, 49, 17, 71, 26,
     0, 34, 25, 42, 34, 34, 59, 42, 68, 34, 13, 58, 22, 50, 47,
    58, 56, 50, 78, 59,  8,  1, 16, 10, 38,  1, 50, 10, 68,  1,
     4, 26, 18, 17, 38, 26, 48, 17, 72, 26,  1, 34, 26, 42, 35,
    34, 60, 42, 69, 34, 14, 58, 23, 50, 47, 59, 57, 50, 77, 59,
     7,  1, 17, 10, 37,  1, 51, 10, 67,  1,  5, 26, 17, 17, 39,
    26, 48, 18, 73, 26,  2, 34, 27, 42, 36, 34, 61, 42, 70, 34,
    15, 58, 24, 50, 46, 59, 58, 50, 76, 59,  6,  1, 18, 10, 36,
     1, 52, 10, 66,  1,  6, 26, 16, 17, 40, 26, 49, 18, 74, 26,
     3, 34, 28, 42, 37, 34, 62, 42, 71, 34, 15, 59, 25, 50, 45,
    59, 59, 50, 75, 59,  5,  1, 19, 10, 35,  1, 53, 10, 65,  1,
     7, 26, 16, 18, 41, 26, 50, 18, 75, 26,  4, 34, 29, 42, 38,
    34, 63, 42, 72, 34, 14, 59, 26, 50, 44, 59, 60, 50, 74, 59,
     4,  1, 20, 10, 34,  1, 54, 10, 64,  1,  8, 26, 17, 18, 42,
    26, 51, 18, 76, 26,  5, 34, 30, 42, 39, 34, 63, 43, 73, 34,
    13, 59, 27, 50, 43, 59, 61, 50, 73, 59,  3,  1, 21, 10, 33,
     1, 55, 10, 64,  2,  9, 26, 18, 18, 43, 26, 52, 18, 77, 26,
     6, 34, 31, 42, 40, 34, 62, 43, 74, 34, 12, 59, 28, 50, 42,
    59, 62, 50, 72, 59,  2,  1, 22, 10, 32,  1, 56, 10, 65,  2,
    10, 26, 19, 18, 44, 26, 53, 18, 78, 26,  7, 34, 31, 43, 41,
    34, 61, 43, 75, 34, 11, 59, 29, 50, 41, 59, 63, 50, 71, 59,
     1,  1, 23, 10, 32,  2, 57, 10, 66,  2, 11, 26, 20, 18, 45,
    26, 54, 18, 79, 26,  8, 34, 30, 43, 42, 34, 60, 43, 76, 34,
    10, 59, 30, 50, 40, 59, 63, 51, 70, 59,  0,  1, 24, 10, 33,
     2, 58, 10, 67,  2, 12, 26, 21, 18, 46, 26, 55, 18, 79, 27,
     9, 34, 29, 43, 43, 34, 59, 43, 77, 34,  9, 59, 31, 50, 39,
    59, 62, 51, 69, 59,  0,  2, 25, 10, 34,  2, 59, 10, 68,  2,
    13, 26, 22, 18, 47, 26, 56, 18, 78, 27, 10, 34, 28, 43, 44,
    34, 58, 43, 78, 34,  8, 59, 31, 51, 38, 59, 61, 51, 68, 59,
     1,  2, 26, 10, 35,  2, 60, 10, 69,  2, 14, 26, 23, 18, 47,
    27, 57, 18, 77, 27, 11, 34, 27, 43, 45, 34, 57, 43, 79, 34,
     7, 59, 30, 51, 37, 59, 60, 51, 67, 59,  2,  2, 27, 10, 36,
     2, 61, 10, 70,  2, 15, 26, 24, 18, 46, 27, 58, 18, 76, 27,
    12, 34, 26, 43, 46, 34, 56, 43, 79, 35,  6, 59, 29, 51, 36,
    59, 59, 51, 66, 59,  3,  2, 28, 10, 37,  2, 62, 10, 71,  2,
    15, 27, 25, 18, 45, 27, 59, 18, 75, 27, 13, 34, 25, 43, 47,
    34, 55, 43, 78, 35,  5, 59, 28, 51, 35, 59, 58, 51, 65, 59,
     4,  2, 29, 10, 38,  2, 63, 10, 72,  2, 14, 27, 26, 18, 44,
    27, 60, 18, 74, 27, 14, 34, 24, 43, 47, 35, 54, 43, 77, 35,
     4, 59, 27, 51, 34, 59, 57, 51, 64, 59,  5,  2, 30, 10, 39,
     2, 63, 11, 73,  2, 13, 27, 27, 18, 43, 27, 61, 18, 73, 27,
    15, 34, 23, 43, 46, 35, 53, 43, 76, 35,  3, 59, 26, 51, 33,
    59, 56, 51, 64, 60,  6,  2, 31, 10, 40,  2, 62, 11, 74,  2,
    12, 27, 28, 18, 42, 27, 62, 18, 72, 27, 15, 35, 22, 43, 45,
    35, 52, 43, 75, 35,  2, 59, 25, 51, 32, 59, 55, 51, 65, 60,
     7,  2, 31, 11, 41,  2, 61, 11, 75,  2, 11, 27, 29, 18, 41,
    27, 63, 18, 71, 27, 14, 35, 21, 43, 44, 35, 51, 43, 74, 35,
     1, 59, 24, 51, 32, 60, 54, 51, 66, 60,  8,  2, 30, 11, 42,
     2, 60, 11, 76,  2, 10, 27, 30, 18, 40, 27, 63, 19, 70, 27,
    13, 35, 20, 43, 43, 35, 50, 43, 73, 35,  0, 59, 23, 51, 33,
    60, 53, 51, 67, 60,  9,  2, 29, 11, 43,  2, 59, 11, 77,  2,
     9, 27, 31, 18, 39, 27, 62, 19, 69, 27, 12, 35, 19, 43, 42,
    35, 49, 43, 72, 35,  0, 60, 22, 51, 34, 60, 52, 51, 68, 60,
    10,  2, 28, 11, 44,  2, 58, 11, 78,  2,  8, 27, 31, 19, 38,
    27, 61, 19, 68, 27, 11, 35, 18, 43, 41, 35, 48, 43, 71, 35,
     1, 60, 21, 51, 35, 60, 51, 51, 69, 60, 11,  2, 27, 11, 45,
     2, 57, 11, 79,  2,  7, 27, 30, 19, 37, 27, 60, 19, 67, 27,
    10, 35, 17, 43, 40, 35, 48, 44, 70, 35,  2, 60, 20, 51, 36,
    60, 50, 51, 70, 60, 12,  2, 26, 11, 46,  2, 56, 11, 79,  3,
     6, 27, 29, 19, 36, 27, 59, 19, 66, 27,  9, 35, 16, 43, 39,
    35, 49, 44, 69, 35,  3, 60, 19, 51, 37, 60, 49, 51, 71, 60,
    13,  2, 25, 11, 47,  2, 55, 11, 78,  3,  5, 27, 28, 19, 35,
    27, 58, 19, 65, 27,  8, 35, 16, 44, 38, 35, 50, 44, 68, 35,
     4, 60, 18, 51, 38, 60, 48, 51, 72, 60, 14,  2, 24, 11, 47,
     3, 54, 11, 77,  3,  4, 27, 27, 19, 34, 27, 57, 19, 64, 27,
     7, 35, 17, 44, 37, 35, 51, 44, 67, 35,  5, 60, 17, 51, 39,
    60, 48, 52, 73, 60, 15,  2, 23, 11, 46,  3, 53, 11, 76,  3,
     3, 27, 26, 19, 33, 27, 56, 19, 64, 28,  6, 35, 18, 44, 36,
    35, 52, 44, 66, 35,  6, 60, 16, 51, 40, 60, 49, 52, 74, 60,
    15,  3, 22, 11, 45,  3, 52, 11, 75,  3,  2, 27, 25, 19, 32,
    27, 55, 19, 65, 28,  5, 35, 19, 44, 35, 35, 53, 44, 65, 35,
     7, 60, 16, 52, 41, 60, 50, 52, 75, 60, 14,  3, 21, 11, 44,
     3, 51, 11, 74,  3,  1, 27, 24, 19, 32, 28, 54, 19, 66, 28,
     4, 35, 20, 44, 34, 35, 54, 44, 64, 35,  8, 60, 17, 52, 42,
    60, 51, 52, 76, 60, 13,  3, 20, 11, 43,  3, 50, 11, 73,  3,
     0, 27, 23, 19, 33, 28, 53, 19, 67, 28,  3, 35, 21, 44, 33,
    35, 55, 44, 64, 36,  9, 60, 18, 52, 43, 60, 52, 52, 77, 60,
    12,  3, 19, 11, 42,  3, 49, 11, 72,  3,  0, 28, 22, 19, 34,
    28, 52, 19, 68, 28,  2, 35, 22, 44, 32, 35, 56, 44, 65, 36,
    10, 60, 19, 52, 44, 60, 53, 52, 78, 60, 11,  3, 18, 11, 41,
     3, 48, 11, 71,  3,  1, 28, 21, 19, 35, 28, 51, 19, 69, 28,
     1, 35, 23, 44, 32, 36, 57, 44, 66, 36, 11, 60, 20, 52, 45,
    60, 54, 52, 79, 60, 10,  3, 17, 11, 40,  3, 48, 12, 70,  3,
     2, 28, 20, 19, 36, 28, 50, 19, 70, 28,  0, 35, 24, 44, 33,
    36, 58, 44, 67, 36, 12, 60, 21, 52, 46, 60, 55, 52, 79, 61,
     9,  3, 16, 11, 39,  3, 49, 12, 69,  3,  3, 28, 19, 19, 37,
    28, 49, 19, 71, 28,  0, 36, 25, 44, 34, 36, 59, 44, 68, 36,
    13, 60, 22, 52, 47, 60, 56, 52, 78, 61,  8,  3, 16, 12, 38,
     3, 50, 12, 68,  3,  4, 28, 18, 19, 38, 28, 48, 19, 72, 28,
     1, 36, 26, 44, 35, 36, 60, 44, 69, 36, 14, 60, 23, 52, 47,
    61, 57, 52, 77, 61,  7,  3, 17, 12, 37,  3, 51, 12, 67,  3,
     5, 28, 17, 19, 39, 28, 48, 20, 73, 28,  2, 36, 27, 44, 36,
    36, 61, 44, 70, 36, 15, 60, 24, 52, 46, 61, 58, 52, 76, 61,
     6,  3, 18, 12, 36,  3, 52, 12, 66,  3,  6, 28, 16, 19, 40,
    28, 49, 20, 74, 28,  3, 36, 28, 44, 37, 36, 62, 44, 71, 36,
    15, 61, 25, 52, 45, 61, 59, 52, 75, 61,  5,  3, 19, 12, 35,
     3, 53, 12, 65,  3,  7, 28, 16, 20, 41, 28, 50, 20, 75, 28,
     4, 36, 29, 44, 38, 36, 63, 44, 72, 36, 14, 61, 26, 52, 44,
    61, 60, 52, 74, 61,  4,  3, 20, 12, 34,  3, 54, 12, 64,  3,
     8, 28, 17, 20, 42, 28, 51, 20, 76, 28,  5, 36, 30, 44, 39,
    36, 63, 45, 73, 36, 13, 61, 27, 52, 43, 61, 61, 52, 73, 61,
     3,  3, 21, 12, 33,  3, 55, 12, 64,  4,  9, 28, 18, 20, 43,
    28, 52, 20, 77, 28,  6, 36, 31, 44, 40, 36, 62, 45, 74, 36,
    12, 61, 28, 52, 42, 61, 62, 52, 72, 61,  2,  3, 22, 12, 32,
     3, 56, 12, 65,  4, 10, 28, 19, 20, 44, 28, 53, 20, 78, 28,
     7, 36, 31, 45, 41, 36, 61, 45, 75, 36, 11, 61, 29, 52, 41,
    61, 63, 52, 71, 61,  1,  3, 23, 12, 32,  4, 57, 12, 66,  4,
    11, 28, 20, 20, 45, 28, 54, 20, 79, 28,  8, 36, 30, 45, 42,
    36, 60, 45, 76, 36, 10, 61, 30, 52, 40, 61, 63, 53, 70, 61,
     0,  3, 24, 12, 33,  4, 58, 12, 67,  4, 12, 28, 21, 20, 46,
    28, 55, 20, 79, 29,  9, 36, 29, 45, 43, 36, 59, 45, 77, 36,
     9, 61, 31, 52, 39, 61, 62, 53, 69, 61,  0,  4, 25, 12, 34,
     4, 59, 12, 68,  4, 13, 28, 22, 20, 47, 28, 56, 20, 78, 29,
    10, 36, 28, 45, 44, 36, 58, 45, 78, 36,  8, 61, 31, 53, 38,
    61, 61, 53, 68, 61,  1,  4, 26, 12, 35,  4, 60, 12, 69,  4,
    14, 28, 23, 20, 47, 29, 57, 20, 77, 29, 11, 36, 27, 45, 45,
    36, 57, 45, 79, 36,  7, 61, 30, 53, 37, 61, 60, 53, 67, 61,
     2,  4, 27, 12, 36,  4, 61, 12, 70,  4, 15, 28, 24, 20, 46,
    29, 58, 20, 76, 29, 12, 36, 26, 45, 46, 36, 56, 45, 79, 37,
     6, 61, 29, 53, 36, 61, 59, 53, 66, 61,  3,  4, 28, 12, 37,
     4, 62, 12, 71,  4, 15, 29, 25, 20, 45, 29, 59, 20, 75, 29,
    13, 36, 25, 45, 47, 36, 55, 45, 78, 37,  5, 61, 28, 53, 35,
    61, 58, 53, 65, 61,  4,  4, 29, 12, 38,  4, 63, 12, 72,  4,
    14, 29, 26, 20, 44, 29, 60, 20, 74, 29, 14, 36, 24, 45, 47,
    37, 54, 45, 77, 37,  4, 61, 27, 53, 34, 61, 57, 53, 64, 61,
     5,  4, 30, 12, 39,  4, 63, 13, 73,  4, 13, 29, 27, 20, 43,
    29, 61, 20, 73, 29, 15, 36, 23, 45, 46, 37, 53, 45, 76, 37,
     3, 61, 26, 53, 33, 61, 56, 53, 64, 62,  6,  4, 31, 12, 40,
     4, 62, 13, 74,  4, 12, 29, 28, 20, 42, 29, 62, 20, 72, 29,
    15, 37, 22, 45, 45, 37, 52, 45, 75, 37,  2, 61, 25, 53, 32,
    61, 55, 53, 65, 62,  7,  4, 31, 13, 41,  4, 61, 13, 75,  4,
    11, 29, 29, 20, 41, 29, 63, 20, 71, 29, 14, 37, 21, 45, 44,
    37, 51, 45, 74, 37,  1, 61, 24, 53, 32, 62, 54, 53, 66, 62,
     8,  4, 30, 13, 42,  4, 60, 13, 76,  4, 10, 29, 30, 20, 40,
    29, 63, 21, 70, 29, 13, 37, 20, 45, 43, 37, 50, 45, 73, 37,
     0, 61, 23, 53, 33, 62, 53, 53, 67, 62,  9,  4, 29, 13, 43,
     4, 59, 13, 77,  4,  9, 29, 31, 20, 39, 29, 62, 21, 69, 29,
    12, 37, 19, 45, 42, 37, 49, 45, 72, 37,  0, 62, 22, 53, 34,
    62, 52, 53, 68, 62, 10,  4, 28, 13, 44,  4, 58, 13, 78,  4,
     8, 29, 31, 21, 38, 29, 61, 21, 68, 29, 11, 37, 18, 45, 41,
    37, 48, 45, 71, 37,  1, 62, 21, 53, 35, 62, 51, 53, 69, 62,
    11,  4, 27, 13, 45,  4, 57, 13, 79,  4,  7, 29, 30, 21, 37,
    29, 60, 21, 67, 29, 10, 37, 17, 45, 40, 37, 48, 46, 70, 37,
     2, 62, 20, 53, 36, 62, 50, 53, 70, 62, 12,  4, 26, 13, 46,
     4, 56, 13, 79,  5,  6, 29, 29, 21, 36, 29, 59, 21, 66, 29,
     9, 37, 16, 45, 39, 37, 49, 46, 69, 37,  3, 62, 19, 53, 37,
    62, 49, 53, 71, 62, 13,  4, 25, 13, 47,  4, 55, 13, 78,  5,
     5, 29, 28, 21, 35, 29, 58, 21, 65, 29,  8, 37, 16, 46, 38,
    37, 50, 46, 68, 37,  4, 62, 18, 53, 38, 62, 48, 53, 72, 62,
    14,  4, 24, 13, 47,  5, 54, 13, 77,  5,  4, 29, 27, 21, 34,
    29, 57, 21, 64, 29,  7, 37, 17, 46, 37, 37, 51, 46, 67, 37,
     5, 62, 17, 53, 39, 62, 48, 54, 73, 62, 15,  4, 23, 13, 46,
     5, 53, 13, 76,  5,  3, 29, 26, 21, 33, 29, 56, 21, 64, 30,
     6, 37, 18, 46, 36, 37, 52, 46, 66, 37,  6, 62, 16, 53, 40,
    62, 49, 54, 74, 62, 15,  5, 22, 13, 45,  5, 52, 13, 75,  5,
     2, 29, 25, 21, 32, 29, 55, 21, 65, 30,  5, 37, 19, 46, 35,
    37, 53, 46, 65, 37,  7, 62, 16, 54, 41, 62, 50, 54, 75, 62,
    14,  5, 21, 13, 44,  5, 51, 13, 74,  5,  1, 29, 24, 21, 32,
    30, 54, 21, 66, 30,  4, 37, 20, 46, 34, 37, 54, 46, 64, 37,
     8, 62, 17, 54, 42, 62, 51, 54, 76, 62, 13,  5, 20, 13, 43,
     5, 50, 13, 73,  5,  0, 29, 23, 21, 33, 30, 53, 21, 67, 30,
     3, 37, 21, 46, 33, 37, 55, 46, 64, 38,  9, 62, 18, 54, 43,
    62, 52, 54, 77, 62, 12,  5, 19, 13, 42,  5, 49, 13, 72,  5,
     0, 30, 22, 21, 34, 30, 52, 21, 68, 30,  2, 37, 22, 46, 32,
    37, 56, 46, 65, 38, 10, 62, 19, 54, 44, 62, 53, 54, 78, 62,
    11,  5, 18, 13, 41,  5, 48, 13, 71,  5,  1, 30, 21, 21, 35,
    30, 51, 21, 69, 30,  1, 37, 23, 46, 32, 38, 57, 46, 66, 38,
    11, 62, 20, 54, 45, 62, 54, 54, 79, 62, 10,  5, 17, 13, 40,
     5, 48, 14, 70,  5,  2, 30, 20, 21, 36, 30, 50, 21, 70, 30,
     0, 37, 24, 46, 33, 38, 58, 46, 67, 38, 12, 62, 21, 54, 46,
    62, 55, 54, 79, 63,  9,  5, 16, 13, 39,  5, 49, 14, 69,  5,
     3, 30, 19, 21, 37, 30, 49, 21, 71, 30,  0, 38, 25, 46, 34,
    38, 59, 46, 68, 38, 13, 62, 22, 54, 47, 62, 56, 54, 78, 63,
     8,  5, 16, 14, 38,  5, 50, 14, 68,  5,  4, 30, 18, 21, 38,
    30, 48, 21, 72, 30,  1, 38, 26, 46, 35, 38, 60, 46, 69, 38,
    14, 62, 23, 54, 47, 63, 57, 54, 77, 63,  7,  5, 17, 14, 37,
     5, 51, 14, 67,  5,  5, 30, 17, 21, 39, 30, 48, 22, 73, 30,
     2, 38, 27, 46, 36, 38, 61, 46, 70, 38, 15, 62, 24, 54, 46,
    63, 58, 54, 76, 63,  6,  5, 18, 14, 36,  5, 52, 14, 66,  5,
     6, 30, 16, 21, 40, 30, 49, 22, 74, 30,  3, 38, 28, 46, 37,
    38, 62, 46, 71, 38, 15, 63, 25, 54, 45, 63, 59, 54, 75, 63,
     5,  5, 19, 14, 35,  5, 53, 14, 65,  5,  7, 30, 16, 22, 41,
    30, 50, 22, 75, 30,  4, 38, 29, 46, 38, 38, 63, 46, 72, 38,
    14, 63, 26, 54, 44, 63, 60, 54, 74, 63,  4,  5, 20, 14, 34,
     5, 54, 14, 64,  5,  8, 30, 17, 22, 42, 30, 51, 22, 76, 30,
     5, 38, 30, 46, 39, 38, 63, 47, 73, 38, 13, 63, 27, 54, 43,
    63, 61, 54, 73, 63,  3,  5, 21, 14, 33,  5, 55, 14, 64,  6,
     9, 30, 18, 22, 43, 30, 52, 22, 77, 30,  6, 38, 31, 46, 40,
    38, 62, 47, 74, 38, 12, 63, 28, 54, 42, 63, 62, 54, 72, 63,
     2,  5, 22, 14, 32,  5, 56, 14, 65,  6, 10, 30, 19, 22, 44,
    30, 53, 22, 78, 30,  7, 38, 31, 47, 41, 38, 61, 47, 75, 38,
    11, 63, 29, 54, 41, 63, 63, 54, 71, 63,  1,  5, 23, 14, 32,
     6, 57, 14, 66,  6, 11, 30, 20, 22, 45, 30, 54, 22, 79, 30,
     8, 38, 30, 47, 42, 38, 60, 47, 76, 38, 10, 63, 30, 54, 40,
    63, 63, 55, 70, 63,  0,  5, 24, 14, 33,  6, 58, 14, 67,  6,
    12, 30, 21, 22, 46, 30, 55, 22, 79, 31,  9, 38, 29, 47, 43,
    38, 59, 47, 77, 38,  9, 63, 31, 54, 39, 63, 62, 55, 69, 63,
     0,  6, 25, 14, 34,  6, 59, 14, 68,  6, 13, 30, 22, 22, 47,
    30, 56, 22, 78, 31, 10, 38, 28, 47, 44, 38, 58, 47, 78, 38,
     8, 63, 31, 55, 38, 63, 61, 55, 68, 63,  1,  6, 26, 14, 35,
     6, 60, 14, 69,  6, 14, 30, 23, 22, 47, 31, 57, 22, 77, 31,
    11, 38, 27, 47, 45, 38, 57, 47, 79, 38,  7, 63, 30, 55, 37,
    63, 60, 55, 67, 63,  2,  6, 27, 14, 36,  6, 61, 14, 70,  6,
    15, 30, 24, 22, 46, 31, 58, 22, 76, 31, 12, 38, 26, 47, 46,
    38, 56, 47, 79, 39,  6, 63, 29, 55, 36, 63, 59, 55, 66, 63,
     3,  6, 28, 14, 37,  6, 62, 14, 71,  6, 15, 31, 25, 22, 45,
    31, 59, 22, 75, 31, 13, 38, 25, 47, 47, 38, 55, 47, 78, 39,
     5, 63, 28, 55, 35, 63, 58, 55, 65, 63,  4,  6, 29, 14, 38,
     6, 63, 14, 72,  6, 14, 31, 26, 22, 44, 31, 60, 22, 74, 31,
    14, 38, 24, 47, 47, 39, 54, 47, 77, 39,  4, 63, 27, 55, 34,
    63, 57, 55, 64, 63,  5,  6, 30, 14, 39,  6, 63, 15, 73,  6,
    13, 31, 27, 22, 43, 31, 61, 22, 73, 31, 15, 38, 23, 47, 46,
    39, 53, 47, 76, 39,  3, 63, 26, 55, 33, 63, 56, 55, 64, 48,
     6,  6, 31, 14, 40,  6, 62, 15, 74,  6, 12, 31, 28, 22, 42,
    31, 62, 22, 72, 31, 15, 39, 22, 47, 45, 39, 52, 47, 75, 39,
     2, 63, 25, 55, 32, 63, 55, 55, 65, 48,  7,  6, 31, 15, 41,
     6, 61, 15, 75,  6, 11, 31, 29, 22, 41, 31, 63, 22, 71, 31,
    14, 39, 21, 47, 44, 39, 51, 47, 74, 39,  1, 63, 24, 55, 32,
    48, 54, 55, 66, 48,  8,  6, 30, 15, 42,  6, 60, 15, 76,  6,
    10, 31, 30, 22, 40, 31, 63, 23, 70, 31, 13, 39, 20, 47, 43,
    39, 50, 47, 73, 39,  0, 63, 23, 55, 33, 48, 53, 55, 67, 48,
     9,  6, 29, 15, 43,  6, 59, 15, 77,  6,  9, 31, 31, 22, 39,
    31, 62, 23, 69, 31, 12, 39, 19, 47, 42, 39, 49, 47, 72, 39,
     0, 48, 22, 55, 34, 48, 52, 55, 68, 48, 10,  6, 28, 15, 44,
     6, 58, 15, 78,  6,  8, 31, 31, 23, 38, 31, 61, 23, 68, 31,
    11, 39, 18, 47, 41, 39, 48, 47, 71, 39,  1, 48, 21, 55, 35,
    48, 51, 55, 69, 48, 11,  6, 27, 15, 45,  6, 57, 15, 79,  6,
     7, 31, 30, 23, 37, 31, 60, 23, 67, 31, 10, 39, 17, 47, 40,
    39, 48, 32, 70, 39,  2, 48, 20, 55, 36, 48, 50, 55, 70, 48,
    12,  6, 26, 15, 46,  6, 56, 15, 79,  7,  6, 31, 29, 23, 36,
    31, 59, 23, 66, 31,  9, 39, 16, 47, 39, 39, 49, 32, 69, 39,
     3, 48, 19, 55, 37, 48, 49, 55, 71, 48, 13,  6, 25, 15, 47,
     6, 55, 15, 78,  7,  5, 31, 28, 23, 35, 31, 58, 23, 65, 31,
     8, 39, 16, 32, 38, 39, 50, 32, 68, 39,  4, 48, 18, 55, 38,
    48, 48, 55, 72, 48, 14,  6, 24, 15, 47,  7, 54, 15, 77,  7,
     4, 31, 27, 23, 34, 31, 57, 23, 64, 31,  7, 39, 17, 32, 37,
    39, 51, 32, 67, 39,  5, 48, 17, 55, 39, 48, 48, 56, 73, 48,
    15,  6, 23, 15, 46,  7, 53, 15, 76,  7,  3, 31, 26, 23, 33,
    31, 56, 23, 64, 16,  6, 39, 18, 32, 36, 39, 52, 32, 66, 39,
     6, 48, 16, 55, 40, 48, 49, 56, 74, 48, 15,  7, 22, 15, 45,
     7, 52, 15, 75,  7,  2, 31, 25, 23, 32, 31, 55, 23, 65, 16,
     5, 39, 19, 32, 35, 39, 53, 32, 65, 39,  7, 48, 16, 56, 41,
    48, 50, 56, 75, 48, 14,  7, 21, 15, 44,  7, 51, 15, 74,  7,
     1, 31, 24, 23, 32, 16, 54, 23, 66, 16,  4, 39, 20, 32, 34,
    39, 54, 32, 64, 39,  8, 48, 17, 56, 42, 48, 51, 56, 76, 48,
    13,  7, 20, 15, 43,  7, 50, 15, 73,  7,  0, 31, 23, 23, 33,
    16, 53, 23, 67, 16,  3, 39, 21, 32, 33, 39, 55, 32, 64, 40,
     9, 48, 18, 56, 43, 48, 52, 56, 77, 48, 12,  7, 19, 15, 42,
     7, 49, 15, 72,  7,  0, 16, 22, 23, 34, 16, 52, 23, 68, 16,
     2, 39, 22, 32, 32, 39, 56, 32, 65, 40, 10, 48, 19, 56, 44,
    48, 53, 56, 78, 48, 11,  7, 18, 15, 41,  7, 48, 15, 71,  7,
     1, 16, 21, 23, 35, 16, 51, 23, 69, 16,  1, 39, 23, 32, 32,
    40, 57, 32, 66, 40, 11, 48, 20, 56, 45, 48, 54, 56, 79, 48,
    10,  7, 17, 15, 40,  7, 48,  0, 70,  7,  2, 16, 20, 23, 36,
    16, 50, 23, 70, 16,  0, 39, 24, 32, 33, 40, 58, 32, 67, 40,
    12, 48, 21, 56, 46, 48, 55, 56, 79, 49,  9,  7, 16, 15, 39,
     7, 49,  0, 69,  7,  3, 16, 19, 23, 37, 16, 49, 23, 71, 16,
     0, 40, 25, 32, 34, 40, 59, 32, 68, 40, 13, 48, 22, 56, 47,
    48, 56, 56, 78, 49,  8,  7, 16,  0, 38,  7, 50,  0, 68,  7,
     4, 16, 18, 23, 38, 16, 48, 23, 72, 16,  1, 40, 26, 32, 35,
    40, 60, 32, 69, 40, 14, 48, 23, 56, 47, 49, 57, 56, 77, 49,
     7,  7, 17,  0, 37,  7, 51,  0, 67,  7,  5, 16, 17, 23, 39,
    16, 48, 24, 73, 16,  2, 40, 27, 32, 36, 40, 61, 32, 70, 40,
    15, 48, 24, 56, 46, 49, 58, 56, 76, 49,  6,  7, 18,  0, 36,
     7, 52,  0, 66,  7,  6, 16, 16, 23, 40, 16, 49, 24, 74, 16,
     3, 40, 28, 32, 37, 40, 62, 32, 71, 40, 15, 49, 25, 56, 45,
    49, 59, 56, 75, 49,  5,  7, 19,  0, 35,  7, 53,  0, 65,  7,
     7, 16, 16, 24, 41, 16, 50, 24, 75, 16,  4, 40, 29, 32, 38,
    40, 63, 32, 72, 40, 14, 49, 26, 56, 44, 49, 60, 56, 74, 49,
     4,  7, 20,  0, 34,  7, 54,  0, 64,  7,  8, 16, 17, 24, 42,
    16, 51, 24, 76, 16,  5, 40, 30, 32, 39, 40, 63, 33, 73, 40,
    13, 49, 27, 56, 43, 49, 61, 56, 73, 49,  3,  7, 21,  0, 33,
     7, 55,  0, 64,  8,  9, 16, 18, 24, 43, 16, 52, 24, 77, 16,
     6, 40, 31, 32, 40, 40, 62, 33, 74, 40, 12, 49, 28, 56, 42,
    49, 62, 56, 72, 49,  2,  7, 22,  0, 32,  7, 56,  0, 65,  8,
    10, 16, 19, 24, 44, 16, 53, 24, 78, 16,  7, 40, 31, 33, 41,
    40, 61, 33, 75, 40, 11, 49, 29, 56, 41, 49, 63, 56, 71, 49,
     1,  7, 23,  0, 32,  8, 57,  0, 66,  8, 11, 16, 20, 24, 45,
    16, 54, 24, 79, 16,  8, 40, 30, 33, 42, 40, 60, 33, 76, 40,
    10, 49, 30, 56, 40, 49, 63, 57, 70, 49,  0,  7, 24,  0, 33,
     8, 58,  0, 67,  8, 12, 16, 21, 24, 46, 16, 55, 24, 79, 17,
     9, 40, 29, 33, 43, 40, 59, 33, 77, 40,  9, 49, 31, 56, 39,
    49, 62, 57, 69, 49,  0,  8, 25,  0, 34,  8, 59,  0, 68,  8,
    13, 16, 22, 24, 47, 16, 56, 24, 78, 17, 10, 40, 28, 33, 44,
    40, 58, 33, 78, 40,  8, 49, 31, 57, 38, 49, 61, 57, 68, 49,
     1,  8, 26,  0, 35,  8, 60,  0, 69,  8, 14, 16, 23, 24, 47,
    17, 57, 24, 77, 17, 11, 40, 27, 33, 45, 40, 57, 33, 79, 40,
     7, 49, 30, 57, 37, 49, 60, 57, 67, 49,  2,  8, 27,  0, 36,
     8, 61,  0, 70,  8, 15, 16, 24, 24, 46, 17, 58, 24, 76, 17,
    12, 40, 26, 33, 46, 40, 56, 33, 79, 41,  6, 49, 29, 57, 36,
    49, 59, 57, 66, 49,  3,  8, 28,  0, 37,  8, 62,  0, 71,  8,
    15, 17, 25, 24, 45, 17, 59, 24, 75, 17, 13, 40, 25, 33, 47,
    40, 55, 33, 78, 41,  5, 49, 28, 57, 35, 49, 58, 57, 65, 49,
     4,  8, 29,  0, 38,  8, 63,  0, 72,  8, 14, 17, 26, 24, 44,
    17, 60, 24, 74, 17, 14, 40, 24, 33, 47, 41, 54, 33, 77, 41,
     4, 49, 27, 57, 34, 49, 57, 57, 64, 49,  5,  8, 30,  0, 39,
     8, 63,  1, 73,  8, 13, 17, 27, 24, 43, 17, 61, 24, 73, 17,
    15, 40, 23, 33, 46, 41, 53, 33, 76, 41,  3, 49, 26, 57, 33,
    49, 56, 57, 64, 50,  6,  8, 31,  0, 40,  8, 62,  1, 74,  8,
    12, 17, 28, 24, 42, 17, 62, 24, 72, 17, 15, 41, 22, 33, 45,
    41, 52, 33, 75, 41,  2, 49, 25, 57, 32, 49, 55, 57, 65, 50,
     7,  8, 31,  1, 41,  8, 61,  1, 75,  8, 11, 17, 29, 24, 41,
    17, 63, 24, 71, 17, 14, 41, 21, 33, 44, 41, 51, 33, 74, 41,
     1, 49, 24, 57, 32, 50, 54, 57, 66, 50,  8,  8, 30,  1, 42,
     8, 60,  1, 76,  8, 10, 17, 30, 24, 40, 17, 63, 25, 70, 17,
    13, 41, 20, 33, 43, 41, 50, 33, 73, 41,  0, 49, 23, 57, 33,
    50, 53, 57, 67, 50,  9,  8, 29,  1, 43,  8, 59,  1, 77,  8,
     9, 17, 31, 24, 39, 17, 62, 25, 69, 17, 12, 41, 19, 33, 42,
    41, 49, 33, 72, 41,  0, 50, 22, 57, 34, 50, 52, 57, 68, 50,
    10,  8, 28,  1, 44,  8, 58,  1, 78,  8,  8, 17, 31, 25, 38,
    17, 61, 25, 68, 17, 11, 41, 18, 33, 41, 41, 48, 33, 71, 41,
     1, 50, 21, 57, 35, 50, 51, 57, 69, 50, 11,  8, 27,  1, 45,
     8, 57,  1, 79,  8,  7, 17, 30, 25, 37, 17, 60, 25, 67, 17,
    10, 41, 17, 33, 40, 41, 48, 34, 70, 41,  2, 50, 20, 57, 36,
    50, 50, 57, 70, 50, 12,  8, 26,  1, 46,  8, 56,  1, 79,  9,
     6, 17, 29, 25, 36, 17, 59, 25, 66, 17,  9, 41, 16, 33, 39,
    41, 49, 34, 69, 41,  3, 50, 19, 57, 37, 50, 49, 57, 71, 50,
    13,  8, 25,  1, 47,  8, 55,  1, 78,  9,  5, 17, 28, 25, 35,
    17, 58, 25, 65, 17,  8, 41, 16, 34, 38, 41, 50, 34, 68, 41,
     4, 50, 18, 57, 38, 50, 48, 57, 72, 50, 14,  8, 24,  1, 47,
     9, 54,  1, 77,  9,  4, 17, 27, 25, 34, 17, 57, 25, 64, 17,
     7, 41, 17, 34, 37, 41, 51, 34, 67, 41,  5, 50, 17, 57, 39,
    50, 48, 58, 73, 50, 15,  8, 23,  1, 46,  9, 53,  1, 76,  9,
     3, 17, 26, 25, 33, 17, 56, 25, 64, 18,  6, 41, 18, 34, 36,
    41, 52, 34, 66, 41,  6, 50, 16, 57, 40, 50, 49, 58, 74, 50,
    15,  9, 22,  1, 45,  9, 52,  1, 75,  9,  2, 17, 25, 25, 32,
    17, 55, 25, 65, 18,  5, 41, 19, 34, 35, 41, 53, 34, 65, 41,
     7, 50, 16, 58, 41, 50, 50, 58, 75, 50, 14,  9, 21,  1, 44,
     9, 51,  1, 74,  9,  1, 17, 24, 25, 32, 18, 54, 25, 66, 18,
     4, 41, 20, 34, 34, 41, 54, 34, 64, 41,  8, 50, 17, 58, 42,
    50, 51, 58, 76, 50, 13,  9, 20,  1, 43,  9, 50,  1, 73,  9,
     0, 17, 23, 25, 33, 18, 53, 25, 67, 18,  3, 41, 21, 34, 33,
    41, 55, 34, 64, 42,  9, 50, 18, 58, 43, 50, 52, 58, 77, 50,
    12,  9, 19,  1, 42,  9, 49,  1, 72,  9,  0, 18, 22, 25, 34,
    18, 52, 25, 68, 18,  2, 41, 22, 34, 32, 41, 56, 34, 65, 42,
    10, 50, 19, 58, 44, 50, 53, 58, 78, 50, 11,  9, 18,  1, 41,
     9, 48,  1, 71,  9,  1, 18, 21, 25, 35, 18, 51, 25, 69, 18,
     1, 41, 23, 34, 32, 42, 57, 34, 66, 42, 11, 50, 20, 58, 45,
    50, 54, 58, 79, 50, 10,  9, 17,  1, 40,  9, 48,  2, 70,  9,
     2, 18, 20, 25, 36, 18, 50, 25, 70, 18,  0, 41, 24, 34, 33,
    42, 58, 34, 67, 42, 12, 50, 21, 58, 46, 50, 55, 58, 79, 51,
     9,  9, 16,  1, 39,  9, 49,  2, 69,  9,  3, 18, 19, 25, 37,
    18, 49, 25, 71, 18,  0, 42, 25, 34, 34, 42, 59, 34, 68, 42,
    13, 50, 22, 58, 47, 50, 56, 58, 78, 51,  8,  9, 16,  2, 38,
     9, 50,  2, 68,  9,  4, 18, 18, 25, 38, 18, 48, 25, 72, 18,
     1, 42, 26, 34, 35, 42, 60, 34, 69, 42, 14, 50, 23, 58, 47,
    51, 57, 58, 77, 51,  7,  9, 17,  2, 37,  9, 51,  2, 67,  9,
     5, 18, 17, 25, 39, 18, 48, 26, 73, 18,  2, 42, 27, 34, 36,
    42, 61, 34, 70, 42, 15, 50, 24, 58, 46, 51, 58, 58, 76, 51,
     6,  9, 18,  2, 36,  9, 52,  2, 66,  9,  6, 18, 16, 25, 40,
    18, 49, 26, 74, 18,  3, 42, 28, 34, 37, 42, 62, 34, 71, 42,
    15, 51, 25, 58, 45, 51, 59, 58, 75, 51,  5,  9, 19,  2, 35,
     9, 53,  2, 65,  9,  7, 18, 16, 26, 41, 18, 50, 26, 75, 18,
     4, 42, 29, 34, 38, 42, 63, 34, 72, 42, 14, 51, 26, 58, 44,
    51, 60, 58, 74, 51,  4,  9, 20,  2, 34,  9, 54,  2, 64,  9,
     8, 18, 17, 26, 42, 18, 51, 26, 76, 18,  5, 42, 30, 34, 39,
    42, 63, 35, 73, 42, 13, 51, 27, 58, 43, 51, 61, 58, 73, 51,
     3,  9, 21,  2, 33,  9, 55,  2, 64, 10,  9, 18, 18, 26, 43,
    18, 52, 26, 77, 18,  6, 42, 31, 34, 40, 42, 62, 35, 74, 42,
    12, 51, 28, 58, 42, 51, 62, 58, 72, 51,  2,  9, 22,  2, 32,
     9, 56,  2, 65, 10, 10, 18, 19, 26, 44, 18, 53, 26, 78, 18,
     7, 42, 31, 35, 41, 42, 61, 35, 75, 42, 11, 51, 29, 58, 41,
    51, 63, 58, 71, 51,  1,  9, 23,  2, 32, 10, 57,  2, 66, 10,
    11, 18, 20, 26, 45, 18, 54, 26, 79, 18,  8, 42, 30, 35, 42,
    42, 60, 35, 76, 42, 10, 51, 30, 58, 40, 51, 63, 59, 70, 51,
     0,  9, 24,  2, 33, 10, 58,  2, 67, 10, 12, 18, 21, 26, 46,
    18, 55, 26, 79, 19,  9, 42, 29, 35, 43, 42, 59, 35, 77, 42,
     9, 51, 31, 58, 39, 51, 62, 59, 69, 51,  0, 10, 25,  2, 34,
    10, 59,  2, 68, 10, 13, 18, 22, 26, 47, 18, 56, 26, 78, 19,
    10, 42, 28, 35, 44, 42, 58, 35, 78, 42,  8, 51, 31, 59, 38,
    51, 61, 59, 68, 51,  1, 10, 26,  2, 35, 10, 60,  2, 69, 10,
    14, 18, 23, 26, 47, 19, 57, 26, 77, 19, 11, 42, 27, 35, 45,
    42, 57, 35, 79, 42,  7, 51, 30, 59, 37, 51, 60, 59, 67, 51,
     2, 10, 27,  2, 36, 10, 61,  2, 70, 10, 15, 18, 24, 26, 46,
    19, 58, 26, 76, 19, 12, 42, 26, 35, 46, 42, 56, 35, 79, 43,
     6, 51, 29, 59, 36, 51, 59, 59, 66, 51,  3, 10, 28,  2, 37,
    10, 62,  2, 71, 10, 15, 19, 25, 26, 45, 19, 59, 26, 75, 19,
    13, 42, 25, 35, 47, 42, 55, 35, 78, 43,  5, 51, 28, 59, 35,
    51, 58, 59, 65, 51,  4, 10, 29,  2, 38, 10, 63,  2, 72, 10,
    14, 19, 26, 26, 44, 19, 60, 26, 74, 19, 14, 42, 24, 35, 47,
    43, 54, 35, 77, 43,  4, 51, 27, 59, 34, 51, 57, 59, 64, 51,
     5, 10, 30,  2, 39, 10, 63,  3, 73, 10, 13, 19, 27, 26, 43,
    19, 61, 26, 73, 19, 15, 42, 23, 35, 46, 43, 53, 35, 76, 43,
     3, 51, 26, 59, 33, 51, 56, 59, 64, 52,  6, 10, 31,  2, 40,
    10, 62,  3, 74, 10, 12, 19, 28, 26, 42, 19, 62, 26, 72, 19,
    15, 43, 22, 35, 45, 43, 52, 35, 75, 43,  2, 51, 25, 59, 32,
    51, 55, 59, 65, 52,  7, 10, 31,  3, 41, 10, 61,  3, 75, 10,
    11, 19, 29, 26, 41, 19, 63, 26, 71, 19, 14, 43, 21, 35, 44,
    43, 51, 35, 74, 43,  1, 51, 24, 59, 32, 52, 54, 59, 66, 52,
     8, 10, 30,  3, 42, 10, 60,  3, 76, 10, 10, 19, 30, 26, 40,
    19, 63, 27, 70, 19, 13, 43, 20, 35, 43, 43, 50, 35, 73, 43,
     0, 51, 23, 59, 33, 52, 53, 59, 67, 52,  9, 10, 29,  3, 43,
    10, 59,  3, 77, 10,  9, 19, 31, 26, 39, 19, 62, 27, 69, 19,
    12, 43, 19, 35, 42, 43, 49, 35, 72, 43,  0, 52, 22, 59, 34,
    52, 52, 59, 68, 52, 10, 10, 28,  3, 44, 10, 58,  3, 78, 10,
     8, 19, 31, 27, 38, 19, 61, 27, 68, 19, 11, 43, 18, 35, 41,
    43, 48, 35, 71, 43,  1, 52, 21, 59, 35, 52, 51, 59, 69, 52,
    11, 10, 27,  3, 45, 10, 57,  3, 79, 10,  7, 19, 30, 27, 37,
    19, 60, 27, 67, 19, 10, 43, 17, 35, 40, 43, 48, 36, 70, 43,
     2, 52, 20, 59, 36, 52, 50, 59, 70, 52, 12, 10, 26,  3, 46,
    10, 56,  3, 79, 11,  6, 19, 29, 27, 36, 19, 59, 27, 66, 19,
     9, 43, 16, 35, 39, 43, 49, 36, 69, 43,  3, 52, 19, 59, 37,
    52, 49, 59, 71, 52, 13, 10, 25,  3, 47, 10, 55,  3, 78, 11,
     5, 19, 28, 27, 35, 19, 58, 27, 65, 19,  8, 43, 16, 36, 38,
    43, 50, 36, 68, 43,  4, 52, 18, 59, 38, 52, 48, 59, 72, 52,
    14, 10, 24,  3, 47, 11, 54,  3, 77, 11,  4, 19, 27, 27, 34,
    19, 57, 27, 64, 19,  7, 43, 17, 36, 37, 43, 51, 36, 67, 43,
     5, 52, 17, 59, 39, 52, 48, 60, 73, 52, 15, 10, 23,  3, 46,
    11, 53,  3, 76, 11,  3, 19, 26, 27, 33, 19, 56, 27, 64, 20,
     6, 43, 18, 36, 36, 43, 52, 36, 66, 43,  6, 52, 16, 59, 40,
    52, 49, 60, 74, 52, 15, 11, 22,  3, 45, 11, 52,  3, 75, 11,
     2, 19, 25, 27, 32, 19, 55, 27, 65, 20,  5, 43, 19, 36, 35,
    43, 53, 36, 65, 43,  7, 52, 16, 60, 41, 52, 50, 60, 75, 52,
    14, 11, 21,  3, 44, 11, 51,  3, 74, 11,  1, 19, 24, 27, 32,
    20, 54, 27, 66, 20,  4, 43, 20, 36, 34, 43, 54, 36, 64, 43,
     8, 52, 17, 60, 42, 52, 51, 60, 76, 52, 13, 11, 20,  3, 43,
    11, 50,  3, 73, 11,  0, 19, 23, 27, 33, 20, 53, 27, 67, 20,
     3, 43, 21, 36, 33, 43, 55, 36, 64, 44,  9, 52, 18, 60, 43,
    52, 52, 60, 77, 52, 12, 11, 19,  3, 42, 11, 49,  3, 72, 11,
     0, 20, 22, 27, 34, 20, 52, 27, 68, 20,  2, 43, 22, 36, 32,
    43, 56, 36, 65, 44, 10, 52, 19, 60, 44, 52, 53, 60, 78, 52,
    11, 11, 18,  3, 41, 11, 48,  3, 71, 11,  1, 20, 21, 27, 35,
    20, 51, 27, 69, 20,  1, 43, 23, 36, 32, 44, 57, 36, 66, 44,
    11, 52, 20, 60, 45, 52, 54, 60, 79, 52, 10, 11, 17,  3, 40,
    11, 48,  4, 70, 11,  2, 20, 20, 27, 36, 20, 50, 27, 70, 20,
     0, 43, 24, 36, 33, 44, 58, 36, 67, 44, 12, 52, 21, 60, 46,
    52, 55, 60, 79, 53,  9, 11, 16,  3, 39, 11, 49,  4, 69, 11,
     3, 20, 19, 27, 37, 20, 49, 27, 71, 20,  0, 44, 25, 36, 34,
    44, 59, 36, 68, 44, 13, 52, 22, 60, 47, 52, 56, 60, 78, 53,
     8, 11, 16,  4, 38, 11, 50,  4, 68, 11,  4, 20, 18, 27, 38,
    20, 48, 27, 72, 20,  1, 44, 26, 36, 35, 44, 60, 36, 69, 44,
    14, 52, 23, 60, 47, 53, 57, 60, 77, 53,  7, 11, 17,  4, 37,
    11, 51,  4, 67, 11,  5, 20, 17, 27, 39, 20, 48, 28, 73, 20,
     2, 44, 27, 36, 36, 44, 61, 36, 70, 44, 15, 52, 24, 60, 46,
    53, 58, 60, 76, 53,  6, 11, 18,  4, 36, 11, 52,  4, 66, 11,
     6, 20, 16, 27, 40, 20, 49, 28, 74, 20,  3, 44, 28, 36, 37,
    44, 62, 36, 71, 44, 15, 53, 25, 60, 45, 53, 59, 60, 75, 53,
     5, 11, 19,  4, 35, 11, 53,  4, 65, 11,  7, 20, 16, 28, 41,
    20, 50, 28, 75, 20,  4, 44, 29, 36, 38, 44, 63, 36, 72, 44,
    14, 53, 26, 60, 44, 53, 60, 60, 74, 53,  4, 11, 20,  4, 34,
    11, 54,  4, 64, 11,  8, 20, 17, 28, 42, 20, 51, 28, 76, 20,
     5, 44, 30, 36, 39, 44, 63, 37, 73, 44, 13, 53, 27, 60, 43,
    53, 61, 60, 73, 53,  3, 11, 21,  4, 33, 11, 55,  4, 64, 12,
     9, 20, 18, 28, 43, 20, 52, 28, 77, 20,  6, 44, 31, 36, 40,
    44, 62, 37, 74, 44, 12, 53, 28, 60, 42, 53, 62, 60, 72, 53,
     2, 11, 22,  4, 32, 11, 56,  4, 65, 12, 10, 20, 19, 28, 44,
    20, 53, 28, 78, 20,  7, 44, 31, 37, 41, 44, 61, 37, 75, 44,
    11, 53, 29, 60, 41, 53, 63, 60, 71, 53,  1, 11, 23,  4, 32,
    12, 57,  4, 66, 12, 11, 20, 20, 28, 45, 20, 54, 28, 79, 20,
     8, 44, 30, 37, 42, 44, 60, 37, 76, 44, 10, 53, 30, 60, 40,
    53, 63, 61, 70, 53,  0, 11, 24,  4, 33, 12, 58,  4, 67, 12,
    12, 20, 21, 28, 46, 20, 55, 28, 79, 21,  9, 44, 29, 37, 43,
    44, 59, 37, 77, 44,  9, 53, 31, 60, 39, 53, 62, 61, 69, 53,
     0, 12, 25,  4, 34, 12, 59,  4, 68, 12, 13, 20, 22, 28, 47,
    20, 56, 28, 78, 21, 10, 44, 28, 37, 44, 44, 58, 37, 78, 44,
     8, 53, 31, 61, 38, 53, 61, 61, 68, 53,  1, 12, 26,  4, 35,
    12, 60,  4, 69, 12, 14, 20, 23, 28, 47, 21, 57, 28, 77, 21,
    11, 44, 27, 37, 45, 44, 57, 37, 79, 44,  7, 53, 30, 61, 37,
    53, 60, 61, 67, 53,  2, 12, 27,  4, 36, 12, 61,  4, 70, 12,
    15, 20, 24, 28, 46, 21, 58, 28, 76, 21, 12, 44, 26, 37, 46,
    44, 56, 37, 79, 45,  6, 53, 29, 61, 36, 53, 59, 61, 66, 53,
     3, 12, 28,  4, 37, 12, 62,  4, 71, 12, 15, 21, 25, 28, 45,
    21, 59, 28, 75, 21, 13, 44, 25, 37, 47, 44, 55, 37, 78, 45,
     5, 53, 28, 61, 35, 53, 58, 61, 65, 53,  4, 12, 29,  4, 38,
    12, 63,  4, 72, 12, 14, 21, 26, 28, 44, 21, 60, 28, 74, 21,
    14, 44, 24, 37, 47, 45, 54, 37, 77, 45,  4, 53, 27, 61, 34,
    53, 57, 61, 64, 53,  5, 12, 30,  4, 39, 12, 63,  5, 73, 12,
    13, 21, 27, 28, 43, 21, 61, 28, 73, 21, 15, 44, 23, 37, 46,
    45, 53, 37, 76, 45,  3, 53, 26, 61, 33, 53, 56, 61, 64, 54,
     6, 12, 31,  4, 40, 12, 62,  5, 74, 12, 12, 21, 28, 28, 42,
    21, 62, 28, 72, 21, 15, 45, 22, 37, 45, 45, 52, 37, 75, 45,
     2, 53, 25, 61, 32, 53, 55, 61, 65, 54,  7, 12, 31,  5, 41,
    12, 61,  5, 75, 12, 11, 21, 29, 28, 41, 21, 63, 28, 71, 21,
    14, 45, 21, 37, 44, 45, 51, 37, 74, 45,  1, 53, 24, 61, 32,
    54, 54, 61, 66, 54,  8, 12, 30,  5, 42, 12, 60,  5, 76, 12,
    10, 21, 30, 28, 40, 21, 63, 29, 70, 21, 13, 45, 20, 37, 43,
    45, 50, 37, 73, 45,  0, 53, 23, 61, 33, 54, 53, 61, 67, 54,
     9, 12, 29,  5, 43, 12, 59,  5, 77, 12,  9, 21, 31, 28, 39,
    21, 62, 29, 69, 21, 12, 45, 19, 37, 42, 45, 49, 37, 72, 45,
     0, 54, 22, 61, 34, 54, 52, 61, 68, 54, 10, 12, 28,  5, 44,
    12, 58,  5, 78, 12,  8, 21, 31, 29, 38, 21, 61, 29, 68, 21,
    11, 45, 18, 37, 41, 45, 48, 37, 71, 45,  1, 54, 21, 61, 35,
    54, 51, 61, 69, 54, 11, 12, 27,  5, 45, 12, 57,  5, 79, 12,
     7, 21, 30, 29, 37, 21, 60, 29, 67, 21, 10, 45, 17, 37, 40,
    45, 48, 38, 70, 45,  2, 54, 20, 61, 36, 54, 50, 61, 70, 54,
    12, 12, 26,  5, 46, 12, 56,  5, 79, 13,  6, 21, 29, 29, 36,
    21, 59, 29, 66, 21,  9, 45, 16, 37, 39, 45, 49, 38, 69, 45,
     3, 54, 19, 61, 37, 54, 49, 61, 71, 54, 13, 12, 25,  5, 47,
    12, 55,  5, 78, 13,  5, 21, 28, 29, 35, 21, 58, 29, 65, 21,
     8, 45, 16, 38, 38, 45, 50, 38, 68, 45,  4, 54, 18, 61, 38,
    54, 48, 61, 72, 54, 14, 12, 24,  5, 47, 13, 54,  5, 77, 13,
     4, 21, 27, 29, 34, 21, 57, 29, 64, 21,  7, 45, 17, 38, 37,
    45, 51, 38, 67, 45,  5, 54, 17, 61, 39, 54, 48, 62, 73, 54,
    15, 12, 23,  5, 46, 13, 53,  5, 76, 13,  3, 21, 26, 29, 33,
    21, 56, 29, 64, 22,  6, 45, 18, 38, 36, 45, 52, 38, 66, 45,
     6, 54, 16, 61, 40, 54, 49, 62, 74, 54, 15, 13, 22,  5, 45,
    13, 52,  5, 75, 13,  2, 21, 25, 29, 32, 21, 55, 29, 65, 22,
     5, 45, 19, 38, 35, 45, 53, 38, 65, 45,  7, 54, 16, 62, 41,
    54, 50, 62, 75, 54, 14, 13, 21,  5, 44, 13, 51,  5, 74, 13,
     1, 21, 24, 29, 32, 22, 54, 29, 66, 22,  4, 45, 20, 38, 34,
    45, 54, 38, 64, 45,  8, 54, 17, 62, 42, 54, 51, 62, 76, 54,
    13, 13, 20,  5, 43, 13, 50,  5, 73, 13,  0, 21, 23, 29, 33,
    22, 53, 29, 67, 22,  3, 45, 21, 38, 33, 45, 55, 38, 64, 46,
     9, 54, 18, 62, 43, 54, 52, 62, 77, 54, 12, 13, 19,  5, 42,
    13, 49,  5, 72, 13,  0, 22, 22, 29, 34, 22, 52, 29, 68, 22,
     2, 45, 22, 38, 32, 45, 56, 38, 65, 46, 10, 54, 19, 62, 44,
    54, 53, 62, 78, 54, 11, 13, 18,  5, 41, 13, 48,  5, 71, 13,
     1, 22, 21, 29, 35, 22, 51, 29, 69, 22,  1, 45, 23, 38, 32,
    46, 57, 38, 66, 46, 11, 54, 20, 62, 45, 54, 54, 62, 79, 54,
    10, 13, 17,  5, 40, 13, 48,  6, 70, 13,  2, 22, 20, 29, 36,
    22, 50, 29, 70, 22,  0, 45, 24, 38, 33, 46, 58, 38, 67, 46,
    12, 54, 21, 62, 46, 54, 55, 62, 79, 55,  9, 13, 16,  5, 39,
    13, 49,  6, 69, 13,  3, 22, 19, 29, 37, 22, 49, 29, 71, 22,
     0, 46, 25, 38, 34, 46, 59, 38, 68, 46, 13, 54, 22, 62, 47,
    54, 56, 62, 78, 55,  8, 13, 16,  6, 38, 13, 50,  6, 68, 13,
     4, 22, 18, 29, 38, 22, 48, 29, 72, 22,  1, 46, 26, 38, 35,
    46, 60, 38, 69, 46, 14, 54, 23, 62, 47, 55, 57, 62, 77, 55,
     7, 13, 17,  6, 37, 13, 51,  6, 67, 13,  5, 22, 17, 29, 39,
    22, 48, 30, 73, 22,  2, 46, 27, 38, 36, 46, 61, 38, 70, 46,
    15, 54, 24, 62, 46, 55, 58, 62, 76, 55,  6, 13, 18,  6, 36,
    13, 52,  6, 66, 13,  6, 22, 16, 29, 40, 22, 49, 30, 74, 22,
     3, 46, 28, 38, 37, 46, 62, 38, 71, 46, 15, 55, 25, 62, 45,
    55, 59, 62, 75, 55,  5, 13, 19,  6, 35, 13, 53,  6, 65, 13,
     7, 22, 16, 30, 41, 22, 50, 30, 75, 22,  4, 46, 29, 38, 38,
    46, 63, 38, 72, 46, 14, 55, 26, 62, 44, 55, 60, 62, 74, 55,
     4, 13, 20,  6, 34, 13, 54,  6, 64, 13,  8, 22, 17, 30, 42,
    22, 51, 30, 76, 22,  5, 46, 30, 38, 39, 46, 63, 39, 73, 46,
    13, 55, 27, 62, 43, 55, 61, 62, 73, 55,  3, 13, 21,  6, 33,
    13, 55,  6, 64, 14,  9, 22, 18, 30, 43, 22, 52, 30, 77, 22,
     6, 46, 31, 38, 40, 46, 62, 39, 74, 46, 12, 55, 28, 62, 42,
    55, 62, 62, 72, 55,  2, 13, 22,  6, 32, 13, 56,  6, 65, 14,
    10, 22, 19, 30, 44, 22, 53, 30, 78, 22,  7, 46, 31, 39, 41,
    46, 61, 39, 75, 46, 11, 55, 29, 62, 41, 55, 63, 62, 71, 55,
     1, 13, 23,  6, 32, 14, 57,  6, 66, 14, 11, 22, 20, 30, 45,
    22, 54, 30, 79, 22,  8, 46, 30, 39, 42, 46, 60, 39, 76, 46,
    10, 55, 30, 62, 40, 55, 63, 63, 70, 55,  0, 13, 24,  6, 33,
    14, 58,  6, 67, 14, 12, 22, 21, 30, 46, 22, 55, 30, 79, 23,
     9, 46, 29, 39, 43, 46, 59, 39, 77, 46,  9, 55, 31, 62, 39,
    55, 62, 63, 69, 55,  0, 14, 25,  6, 34, 14, 59,  6, 68, 14,
    13, 22, 22, 30, 47, 22, 56, 30, 78, 23, 10, 46, 28, 39, 44,
    46, 58, 39, 78, 46,  8, 55, 31, 63, 38, 55, 61, 63, 68, 55,
     1, 14, 26,  6, 35, 14, 60,  6, 69, 14, 14, 22, 23, 30, 47,
    23, 57, 30, 77, 23, 11, 46, 27, 39, 45, 46, 57, 39, 79, 46,
     7, 55, 30, 63, 37, 55, 60, 63, 67, 55,  2, 14, 27,  6, 36,
    14, 61,  6, 70, 14, 15, 22, 24, 30, 46, 23, 58, 30, 76, 23,
    12, 46, 26, 39, 46, 46, 56, 39, 79, 47,  6, 55, 29, 63, 36,
    55, 59, 63, 66, 55,  3, 14, 28,  6, 37, 14, 62,  6, 71, 14,
    15, 23, 25, 30, 45, 23, 59, 30, 75, 23, 13, 46, 25, 39, 47,
    46, 55, 39, 78, 47,  5, 55, 28, 63, 35, 55, 58, 63, 65, 55,
     4, 14, 29,  6, 38, 14, 63,  6, 72, 14, 14, 23, 26, 30, 44,
    23, 60, 30, 74, 23, 14, 46, 24, 39, 47, 47, 54, 39, 77, 47,
     4, 55, 27, 63, 34, 55, 57, 63, 64, 55,  5, 14, 30,  6, 39,
    14, 63,  7, 73, 14, 13, 23, 27, 30, 43, 23, 61, 30, 73, 23,
    15, 46, 23, 39, 46, 47, 53, 39, 76, 47,  3, 55, 26, 63, 33,
    55, 56, 63, 64, 56,  6, 14, 31,  6, 40, 14, 62,  7, 74, 14,
    12, 23, 28, 30, 42, 23, 62, 30, 72, 23, 15, 47, 22, 39, 45,
    47, 52, 39, 75, 47,  2, 55, 25, 63, 32, 55, 55, 63, 65, 56,
     7, 14, 31,  7, 41, 14, 61,  7, 75, 14, 11, 23, 29, 30, 41,
    23, 63, 30, 71, 23, 14, 47, 21, 39, 44, 47, 51, 39, 74, 47,
     1, 55, 24, 63, 32, 56, 54, 63, 66, 56,  8, 14, 30,  7, 42,
    14, 60,  7, 76, 14, 10, 23, 30, 30, 40, 23, 63, 31, 70, 23,
    13, 47, 20, 39, 43, 47, 50, 39, 73, 47,  0, 55, 23, 63, 33,
    56, 53, 63, 67, 56,  9, 14, 29,  7, 43, 14, 59,  7, 77, 14,
     9, 23, 31, 30, 39, 23, 62, 31, 69, 23, 12, 47, 19, 39, 42,
    47, 49, 39, 72, 47,  0, 56, 22, 63, 34, 56, 52, 63, 68, 56,
    10, 14, 28,  7, 44, 14, 58,  7, 78, 14,  8, 23, 31, 31, 38,
    23, 61, 31, 68, 23, 11, 47, 18, 39, 41, 47, 48, 39, 71, 47,
     1, 56, 21, 63, 35, 56, 51, 63, 69, 56, 11, 14, 27,  7, 45,
    14, 57,  7, 79, 14,  7, 23, 30, 31, 37, 23, 60, 31, 67, 23,
    10, 47, 17, 39, 40, 47, 48, 40, 70, 47,  2, 56, 20, 63, 36,
    56, 50, 63, 70, 56, 12, 14, 26,  7, 46, 14, 56,  7, 79, 15,
     6, 23, 29, 31, 36, 23, 59, 31, 66, 23,  9, 47, 16, 39, 39,
    47, 49, 40, 69, 47,  3, 56, 19, 63, 37, 56, 49, 63, 71, 56,
    13, 14, 25,  7, 47, 14, 55,  7, 78, 15,  5, 23, 28, 31, 35,
    23, 58, 31, 65, 23,  8, 47, 16, 40, 38, 47, 50, 40, 68, 47,
     4, 56, 18, 63, 38, 56, 48, 63, 72, 56, 14, 14, 24,  7, 47,
    15, 54,  7, 77, 15,  4, 23, 27, 31, 34, 23, 57, 31, 64, 23,
     7, 47, 17, 40, 37, 47, 51, 40, 67, 47,  5, 56, 17, 63, 39,
    56, 48, 48, 73, 56, 15, 14, 23,  7, 46, 15, 53,  7, 76, 15,
     3, 23, 26, 31, 33, 23, 56, 31, 64, 24,  6, 47, 18, 40, 36,
    47, 52, 40, 66, 47,  6, 56, 16, 63, 40, 56, 49, 48, 74, 56,
    15, 15, 22,  7, 45, 15, 52,  7, 75, 15,  2, 23, 25, 31, 32,
    23, 55, 31, 65, 24,  5, 47, 19, 40, 35, 47, 53, 40, 65, 47,
     7, 56, 16, 48, 41, 56, 50, 48, 75, 56, 14, 15, 21,  7, 44,
    15, 51,  7, 74, 15,  1, 23, 24, 31, 32, 24, 54, 31, 66, 24,
     4, 47, 20, 40, 34, 47, 54, 40, 64, 47,  8, 56, 17, 48, 42,
    56, 51, 48, 76, 56, 13, 15, 20,  7, 43, 15, 50,  7, 73, 15,
     0, 23, 23, 31, 33, 24, 53, 31, 67, 24,  3, 47, 21, 40, 33,
    47, 55, 40, 64, 32,  9, 56, 18, 48, 43, 56, 52, 48, 77, 56,
    12, 15, 19,  7, 42, 15, 49,  7, 72, 15,  0, 24, 22, 31, 34,
    24, 52, 31, 68, 24,  2, 47, 22, 40, 32, 47, 56, 40, 65, 32,
    10, 56, 19, 48, 44, 56, 53, 48, 78, 56, 11, 15, 18,  7, 41,
    15, 48,  7, 71, 15,  1, 24, 21, 31, 35, 24, 51, 31, 69, 24,
     1, 47, 23, 40, 32, 32, 57, 40, 66, 32, 11, 56, 20, 48, 45,
    56, 54, 48, 79, 56, 10, 15, 17,  7, 40, 15, 48,  8, 70, 15,
     2, 24, 20, 31, 36, 24, 50, 31, 70, 24,  0, 47, 24, 40, 33,
    32, 58, 40, 67, 32, 12, 56, 21, 48, 46, 56, 55, 48, 79, 57,
     9, 15, 16,  7, 39, 15, 49,  8, 69, 15,  3, 24, 19, 31, 37,
    24, 49, 31, 71, 24,  0, 32, 25, 40, 34, 32, 59, 40, 68, 32,
    13, 56, 22, 48, 47, 56, 56, 48, 78, 57,  8, 15, 16,  8, 38,
    15, 50,  8, 68, 15,  4, 24, 18, 31, 38, 24, 48, 31, 72, 24,
     1, 32, 26, 40, 35, 32, 60, 40, 69, 32, 14, 56, 23, 48, 47,
    57, 57, 48, 77, 57,  7, 15, 17,  8, 37, 15, 51,  8, 67, 15,
     5, 24, 17, 31, 39, 24, 48, 16, 73, 24,  2, 32, 27, 40, 36,
    32, 61, 40, 70, 32, 15, 56, 24, 48, 46, 57, 58, 48, 76, 57,
     6, 15, 18,  8, 36, 15, 52,  8, 66, 15,  6, 24, 16, 31, 40,
    24, 49, 16, 74, 24,  3, 32, 28, 40, 37, 32, 62, 40, 71, 32,
    15, 57, 25, 48, 45, 57, 59, 48, 75, 57,  5, 15, 19,  8, 35,
    15, 53,  8, 65, 15,  7, 24, 16, 16, 41, 24, 50, 16, 75, 24,
     4, 32, 29, 40, 38, 32, 63, 40, 72, 32, 14, 57, 26, 48, 44,
    57, 60, 48, 74, 57,  4, 15, 20,  8, 34, 15, 54,  8, 64, 15,
     8, 24, 17, 16, 42, 24, 51, 16, 76, 24,  5, 32, 30, 40, 39,
    32, 63, 41, 73, 32, 13, 57, 27, 48, 43, 57, 61, 48, 73, 57,
     3, 15, 21,  8, 33, 15, 55,  8, 64,  0,  9, 24, 18, 16, 43,
    24, 52, 16, 77, 24,  6, 32, 31, 40, 40, 32, 62, 41, 74, 32,
    12, 57, 28, 48, 42, 57, 62, 48, 72, 57,  2, 15, 22,  8, 32,
    15, 56,  8, 65,  0, 10, 24, 19, 16, 44, 24, 53, 16, 78, 24,
     7, 32, 31, 41, 41, 32, 61, 41, 75, 32, 11, 57, 29, 48, 41,
    57, 63, 48, 71, 57,  1, 15, 23,  8, 32,  0, 57,  8, 66,  0,
    11, 24, 20, 16, 45, 24, 54, 16, 79, 24,  8, 32, 30, 41, 42,
    32, 60, 41, 76, 32, 10, 57, 30, 48, 40, 57, 63, 49, 70, 57,
     0, 15, 24,  8, 33,  0, 58,  8, 67,  0, 12, 24, 21, 16, 46,
    24, 55, 16, 79, 25,  9, 32, 29, 41, 43, 32, 59, 41, 77, 32,
     9, 57, 31, 48, 39, 57, 62, 49, 69, 57,
};

static const uint8_t hq_tab_18[] = {
     0,  0, 25,  6, 34,  0, 59,  6, 68,  0, 13, 18, 22, 12, 47,
    18, 56, 12, 78, 19, 10, 24, 28, 31, 44, 24, 58, 31, 78, 24,
     8, 43, 31, 37, 38, 43, 61, 37, 68, 43, 11, 49, 18, 55, 41,
    49, 48, 55, 71, 49,  1,  0, 26,  6, 35,  0, 60,  6, 69,  0,
    14, 18, 23, 12, 47, 19, 57, 12, 77, 19, 11, 24, 27, 31, 45,
    24, 57, 31, 79, 24,  7, 43, 30, 37, 37, 43, 60, 37, 67, 43,
    10, 49, 17, 55, 40, 49, 48, 56, 70, 49,  2,  0, 27,  6, 36,
     0, 61,  6, 70,  0, 15, 18, 24, 12, 46, 19, 58, 12, 76, 19,
    12, 24, 26, 31, 46, 24, 56, 31, 79, 25,  6, 43, 29, 37, 36,
    43, 59, 37, 66, 43,  9, 49, 16, 55, 39, 49, 49, 56, 69, 49,
     3,  0, 28,  6, 37,  0, 62,  6, 71,  0, 15, 19, 25, 12, 45,
    19, 59, 12, 75, 19, 13, 24, 25, 31, 47, 24, 55, 31, 78, 25,
     5, 43, 28, 37, 35, 43, 58, 37, 65, 43,  8, 49, 16, 56, 38,
    49, 50, 56, 68, 49,  4,  0, 29,  6, 38,  0, 63,  6, 72,  0,
    14, 19, 26, 12, 44, 19, 60, 12, 74, 19, 14, 24, 24, 31, 47,
    25, 54, 31, 77, 25,  4, 43, 27, 37, 34, 43, 57, 37, 64, 43,
     7, 49, 17, 56, 37, 49, 51, 56, 67, 49,  5,  0, 30,  6, 39,
     0, 63,  7, 73,  0, 13, 19, 27, 12, 43, 19, 61, 12, 73, 19,
    15, 24, 23, 31, 46, 25, 53, 31, 76, 25,  3, 43, 26, 37, 33,
    43, 56, 37, 64, 44,  6, 49, 18, 56, 36, 49, 52, 56, 66, 49,
     6,  0, 31,  6, 40,  0, 62,  7, 74,  0, 12, 19, 28, 12, 42,
    19, 62, 12, 72, 19, 15, 25, 22, 31, 45, 25, 52, 31, 75, 25,
     2, 43, 25, 37, 32, 43, 55, 37, 65, 44,  5, 49, 19, 56, 35,
    49, 53, 56, 65, 49,  7,  0, 31,  7, 41,  0, 61,  7, 75,  0,
    11, 19, 29, 12, 41, 19, 63, 12, 71, 19, 14, 25, 21, 31, 44,
    25, 51, 31, 74, 25,  1, 43, 24, 37, 32, 44, 54, 37, 66, 44,
     4, 49, 20, 56, 34, 49, 54, 56, 64, 49,  8,  0, 30,  7, 42,
     0, 60,  7, 76,  0, 10, 19, 30, 12, 40, 19, 63, 13, 70, 19,
    13, 25, 20, 31, 43, 25, 50, 31, 73, 25,  0, 43, 23, 37, 33,
    44, 53, 37, 67, 44,  3, 49, 21, 56, 33, 49, 55, 56, 64, 50,
     9,  0, 29,  7, 43,  0, 59,  7, 77,  0,  9, 19, 31, 12, 39,
    19, 62, 13, 69, 19, 12, 25, 19, 31, 42, 25, 49, 31, 72, 25,
     0, 44, 22, 37, 34, 44, 52, 37, 68, 44,  2, 49, 22, 56, 32,
    49, 56, 56, 65, 50, 10,  0, 28,  7, 44,  0, 58,  7, 78,  0,
     8, 19, 31, 13, 38, 19, 61, 13, 68, 19, 11, 25, 18, 31, 41,
    25, 48, 31, 71, 25,  1, 44, 21, 37, 35, 44, 51, 37, 69, 44,
     1, 49, 23, 56, 32, 50, 57, 56, 66, 50, 11,  0, 27,  7, 45,
     0, 57,  7, 79,  0,  7, 19, 30, 13, 37, 19, 60, 13, 67, 19,
    10, 25, 17, 31, 40, 25, 48, 32, 70, 25,  2, 44, 20, 37, 36,
    44, 50, 37, 70, 44,  0, 49, 24, 56, 33, 50, 58, 56, 67, 50,
    12,  0, 26,  7, 46,  0, 56,  7, 79,  1,  6, 19, 29, 13, 36,
    19, 59, 13, 66, 19,  9, 25, 16, 31, 39, 25, 49, 32, 69, 25,
     3, 44, 19, 37, 37, 44, 49, 37, 71, 44,  0, 50, 25, 56, 34,
    50, 59, 56, 68, 50, 13,  0, 25,  7, 47,  0, 55,  7, 78,  1,
     5, 19, 28, 13, 35, 19, 58, 13, 65, 19,  8, 25, 16, 32, 38,
    25, 50, 32, 68, 25,  4, 44, 18, 37, 38, 44, 48, 37, 72, 44,
     1, 50, 26, 56, 35, 50, 60, 56, 69, 50, 14,  0, 24,  7, 47,
     1, 54,  7, 77,  1,  4, 19, 27, 13, 34, 19, 57, 13, 64, 19,
     7, 25, 17, 32, 37, 25, 51, 32, 67, 25,  5, 44, 17, 37, 39,
    44, 48, 38, 73, 44,  2, 50, 27, 56, 36, 50, 61, 56, 70, 50,
    15,  0, 23,  7, 46,  1, 53,  7, 76,  1,  3, 19, 26, 13, 33,
    19, 56, 13, 64, 20,  6, 25, 18, 32, 36, 25, 52, 32, 66, 25,
     6, 44, 16, 37, 40, 44, 49, 38, 74, 44,  3, 50, 28, 56, 37,
    50, 62, 56, 71, 50, 15,  1, 22,  7, 45,  1, 52,  7, 75,  1,
     2, 19, 25, 13, 32, 19, 55, 13, 65, 20,  5, 25, 19, 32, 35,
    25, 53, 32, 65, 25,  7, 44, 16, 38, 41, 44, 50, 38, 75, 44,
     4, 50, 29, 56, 38, 50, 63, 56, 72, 50, 14,  1, 21,  7, 44,
     1, 51,  7, 74,  1,  1, 19, 24, 13, 32, 20, 54, 13, 66, 20,
     4, 25, 20, 32, 34, 25, 54, 32, 64, 25,  8, 44, 17, 38, 42,
    44, 51, 38, 76, 44,  5, 50, 30, 56, 39, 50, 63, 57, 73, 50,
    13,  1, 20,  7, 43,  1, 50,  7, 73,  1,  0, 19, 23, 13, 33,
    20, 53, 13, 67, 20,  3, 25, 21, 32, 33, 25, 55, 32, 64, 26,
     9, 44, 18, 38, 43, 44, 52, 38, 77, 44,  6, 50, 31, 56, 40,
    50, 62, 57, 74, 50, 12,  1, 19,  7, 42,  1, 49,  7, 72,  1,
     0, 20, 22, 13, 34, 20, 52, 13, 68, 20,  2, 25, 22, 32, 32,
    25, 56, 32, 65, 26, 10, 44, 19, 38, 44, 44, 53, 38, 78, 44,
     7, 50, 31, 57, 41, 50, 61, 57, 75, 50, 11,  1, 18,  7, 41,
     1, 48,  7, 71,  1,  1, 20, 21, 13, 35, 20, 51, 13, 69, 20,
     1, 25, 23, 32, 32, 26, 57, 32, 66, 26, 11, 44, 20, 38, 45,
    44, 54, 38, 79, 44,  8, 50, 30, 57, 42, 50, 60, 57, 76, 50,
    10,  1, 17,  7, 40,  1, 48,  8, 70,  1,  2, 20, 20, 13, 36,
    20, 50, 13, 70, 20,  0, 25, 24, 32, 33, 26, 58, 32, 67, 26,
    12, 44, 21, 38, 46, 44, 55, 38, 79, 45,  9, 50, 29, 57, 43,
    50, 59, 57, 77, 50,  9,  1, 16,  7, 39,  1, 49,  8, 69,  1,
     3, 20, 19, 13, 37, 20, 49, 13, 71, 20,  0, 26, 25, 32, 34,
    26, 59, 32, 68, 26, 13, 44, 22, 38, 47, 44, 56, 38, 78, 45,
    10, 50, 28, 57, 44, 50, 58, 57, 78, 50,  8,  1, 16,  8, 38,
     1, 50,  8, 68,  1,  4, 20, 18, 13, 38, 20, 48, 13, 72, 20,
     1, 26, 26, 32, 35, 26, 60, 32, 69, 26, 14, 44, 23, 38, 47,
    45, 57, 38, 77, 45, 11, 50, 27, 57, 45, 50, 57, 57, 79, 50,
     7,  1, 17,  8, 37,  1, 51,  8, 67,  1,  5, 20, 17, 13, 39,
    20, 48, 14, 73, 20,  2, 26, 27, 32, 36, 26, 61, 32, 70, 26,
    15, 44, 24, 38, 46, 45, 58, 38, 76, 45, 12, 50, 26, 57, 46,
    50, 56, 57, 79, 51,  6,  1, 18,  8, 36,  1, 52,  8, 66,  1,
     6, 20, 16, 13, 40, 20, 49, 14, 74, 20,  3, 26, 28, 32, 37,
    26, 62, 32, 71, 26, 15, 45, 25, 38, 45, 45, 59, 38, 75, 45,
    13, 50, 25, 57, 47, 50, 55, 57, 78, 51,  5,  1, 19,  8, 35,
     1, 53,  8, 65,  1,  7, 20, 16, 14, 41, 20, 50, 14, 75, 20,
     4, 26, 29, 32, 38, 26, 63, 32, 72, 26, 14, 45, 26, 38, 44,
    45, 60, 38, 74, 45, 14, 50, 24, 57, 47, 51, 54, 57, 77, 51,
     4,  1, 20,  8, 34,  1, 54,  8, 64,  1,  8, 20, 17, 14, 42,
    20, 51, 14, 76, 20,  5, 26, 30, 32, 39, 26, 63, 33, 73, 26,
    13, 45, 27, 38, 43, 45, 61, 38, 73, 45, 15, 50, 23, 57, 46,
    51, 53, 57, 76, 51,  3,  1, 21,  8, 33,  1, 55,  8, 64,  2,
     9, 20, 18, 14, 43, 20, 52, 14, 77, 20,  6, 26, 31, 32, 40,
    26, 62, 33, 74, 26, 12, 45, 28, 38, 42, 45, 62, 38, 72, 45,
    15, 51, 22, 57, 45, 51, 52, 57, 75, 51,  2,  1, 22,  8, 32,
     1, 56,  8, 65,  2, 10, 20, 19, 14, 44, 20, 53, 14, 78, 20,
     7, 26, 31, 33, 41, 26, 61, 33, 75, 26, 11, 45, 29, 38, 41,
    45, 63, 38, 71, 45, 14, 51, 21, 57, 44, 51, 51, 57, 74, 51,
     1,  1, 23,  8, 32,  2, 57,  8, 66,  2, 11, 20, 20, 14, 45,
    20, 54, 14, 79, 20,  8, 26, 30, 33, 42, 26, 60, 33, 76, 26,
    10, 45, 30, 38, 40, 45, 63, 39, 70, 45, 13, 51, 20, 57, 43,
    51, 50, 57, 73, 51,  0,  1, 24,  8, 33,  2, 58,  8, 67,  2,
    12, 20, 21, 14, 46, 20, 55, 14, 79, 21,  9, 26, 29, 33, 43,
    26, 59, 33, 77, 26,  9, 45, 31, 38, 39, 45, 62, 39, 69, 45,
    12, 51, 19, 57, 42, 51, 49, 57, 72, 51,  0,  2, 25,  8, 34,
     2, 59,  8, 68,  2, 13, 20, 22, 14, 47, 20, 56, 14, 78, 21,
    10, 26, 28, 33, 44, 26, 58, 33, 78, 26,  8, 45, 31, 39, 38,
    45, 61, 39, 68, 45, 11, 51, 18, 57, 41, 51, 48, 57, 71, 51,
     1,  2, 26,  8, 35,  2, 60,  8, 69,  2, 14, 20, 23, 14, 47,
    21, 57, 14, 77, 21, 11, 26, 27, 33, 45, 26, 57, 33, 79, 26,
     7, 45, 30, 39, 37, 45, 60, 39, 67, 45, 10, 51, 17, 57, 40,
    51, 48, 58, 70, 51,  2,  2, 27,  8, 36,  2, 61,  8, 70,  2,
    15, 20, 24, 14, 46, 21, 58, 14, 76, 21, 12, 26, 26, 33, 46,
    26, 56, 33, 79, 27,  6, 45, 29, 39, 36, 45, 59, 39, 66, 45,
     9, 51, 16, 57, 39, 51, 49, 58, 69, 51,  3,  2, 28,  8, 37,
     2, 62,  8, 71,  2, 15, 21, 25, 14, 45, 21, 59, 14, 75, 21,
    13, 26, 25, 33, 47, 26, 55, 33, 78, 27,  5, 45, 28, 39, 35,
    45, 58, 39, 65, 45,  8, 51, 16, 58, 38, 51, 50, 58, 68, 51,
     4,  2, 29,  8, 38,  2, 63,  8, 72,  2, 14, 21, 26, 14, 44,
    21, 60, 14, 74, 21, 14, 26, 24, 33, 47, 27, 54, 33, 77, 27,
     4, 45, 27, 39, 34, 45, 57, 39, 64, 45,  7, 51, 17, 58, 37,
    51, 51, 58, 67, 51,  5,  2, 30,  8, 39,  2, 63,  9, 73,  2,
    13, 21, 27, 14, 43, 21, 61, 14, 73, 21, 15, 26, 23, 33, 46,
    27, 53, 33, 76, 27,  3, 45, 26, 39, 33, 45, 56, 39, 64, 46,
     6, 51, 18, 58, 36, 51, 52, 58, 66, 51,  6,  2, 31,  8, 40,
     2, 62,  9, 74,  2, 12, 21, 28, 14, 42, 21, 62, 14, 72, 21,
    15, 27, 22, 33, 45, 27, 52, 33, 75, 27,  2, 45, 25, 39, 32,
    45, 55, 39, 65, 46,  5, 51, 19, 58, 35, 51, 53, 58, 65, 51,
     7,  2, 31,  9, 41,  2, 61,  9, 75,  2, 11, 21, 29, 14, 41,
    21, 63, 14, 71, 21, 14, 27, 21, 33, 44, 27, 51, 33, 74, 27,
     1, 45, 24, 39, 32, 46, 54, 39, 66, 46,  4, 51, 20, 58, 34,
    51, 54, 58, 64, 51,  8,  2, 30,  9, 42,  2, 60,  9, 76,  2,
    10, 21, 30, 14, 40, 21, 63, 15, 70, 21, 13, 27, 20, 33, 43,
    27, 50, 33, 73, 27,  0, 45, 23, 39, 33, 46, 53, 39, 67, 46,
     3, 51, 21, 58, 33, 51, 55, 58, 64, 52,  9,  2, 29,  9, 43,
     2, 59,  9, 77,  2,  9, 21, 31, 14, 39, 21, 62, 15, 69, 21,
    12, 27, 19, 33, 42, 27, 49, 33, 72, 27,  0, 46, 22, 39, 34,
    46, 52, 39, 68, 46,  2, 51, 22, 58, 32, 51, 56, 58, 65, 52,
    10,  2, 28,  9, 44,  2, 58,  9, 78,  2,  8, 21, 31, 15, 38,
    21, 61, 15, 68, 21, 11, 27, 18, 33, 41, 27, 48, 33, 71, 27,
     1, 46, 21, 39, 35, 46, 51, 39, 69, 46,  1, 51, 23, 58, 32,
    52, 57, 58, 66, 52, 11,  2, 27,  9, 45,  2, 57,  9, 79,  2,
     7, 21, 30, 15, 37, 21, 60, 15, 67, 21, 10, 27, 17, 33, 40,
    27, 48, 34, 70, 27,  2, 46, 20, 39, 36, 46, 50, 39, 70, 46,
     0, 51, 24, 58, 33, 52, 58, 58, 67, 52, 12,  2, 26,  9, 46,
     2, 56,  9, 79,  3,  6, 21, 29, 15, 36, 21, 59, 15, 66, 21,
     9, 27, 16, 33, 39, 27, 49, 34, 69, 27,  3, 46, 19, 39, 37,
    46, 49, 39, 71, 46,  0, 52, 25, 58, 34, 52, 59, 58, 68, 52,
    13,  2, 25,  9, 47,  2, 55,  9, 78,  3,  5, 21, 28, 15, 35,
    21, 58, 15, 65, 21,  8, 27, 16, 34, 38, 27, 50, 34, 68, 27,
     4, 46, 18, 39, 38, 46, 48, 39, 72, 46,  1, 52, 26, 58, 35,
    52, 60, 58, 69, 52, 14,  2, 24,  9, 47,  3, 54,  9, 77,  3,
     4, 21, 27, 15, 34, 21, 57, 15, 64, 21,  7, 27, 17, 34, 37,
    27, 51, 34, 67, 27,  5, 46, 17, 39, 39, 46, 48, 40, 73, 46,
     2, 52, 27, 58, 36, 52, 61, 58, 70, 52, 15,  2, 23,  9, 46,
     3, 53,  9, 76,  3,  3, 21, 26, 15, 33, 21, 56, 15, 64, 22,
     6, 27, 18, 34, 36, 27, 52, 34, 66, 27,  6, 46, 16, 39, 40,
    46, 49, 40, 74, 46,  3, 52, 28, 58, 37, 52, 62, 58, 71, 52,
    15,  3, 22,  9, 45,  3, 52,  9, 75,  3,  2, 21, 25, 15, 32,
    21, 55, 15, 65, 22,  5, 27, 19, 34, 35, 27, 53, 34, 65, 27,
     7, 46, 16, 40, 41, 46, 50, 40, 75, 46,  4, 52, 29, 58, 38,
    52, 63, 58, 72, 52, 14,  3, 21,  9, 44,  3, 51,  9, 74,  3,
     1, 21, 24, 15, 32, 22, 54, 15, 66, 22,  4, 27, 20, 34, 34,
    27, 54, 34, 64, 27,  8, 46, 17, 40, 42, 46, 51, 40, 76, 46,
     5, 52, 30, 58, 39, 52, 63, 59, 73, 52, 13,  3, 20,  9, 43,
     3, 50,  9, 73,  3,  0, 21, 23, 15, 33, 22, 53, 15, 67, 22,
     3, 27, 21, 34, 33, 27, 55, 34, 64, 28,  9, 46, 18, 40, 43,
    46, 52, 40, 77, 46,  6, 52, 31, 58, 40, 52, 62, 59, 74, 52,
    12,  3, 19,  9, 42,  3, 49,  9, 72,  3,  0, 22, 22, 15, 34,
    22, 52, 15, 68, 22,  2, 27, 22, 34, 32, 27, 56, 34, 65, 28,
    10, 46, 19, 40, 44, 46, 53, 40, 78, 46,  7, 52, 31, 59, 41,
    52, 61, 59, 75, 52, 11,  3, 18,  9, 41,  3, 48,  9, 71,  3,
     1, 22, 21, 15, 35, 22, 51, 15, 69, 22,  1, 27, 23, 34, 32,
    28, 57, 34, 66, 28, 11, 46, 20, 40, 45, 46, 54, 40, 79, 46,
     8, 52, 30, 59, 42, 52, 60, 59, 76, 52, 10,  3, 17,  9, 40,
     3, 48, 10, 70,  3,  2, 22, 20, 15, 36, 22, 50, 15, 70, 22,
     0, 27, 24, 34, 33, 28, 58, 34, 67, 28, 12, 46, 21, 40, 46,
    46, 55, 40, 79, 47,  9, 52, 29, 59, 43, 52, 59, 59, 77, 52,
     9,  3, 16,  9, 39,  3, 49, 10, 69,  3,  3, 22, 19, 15, 37,
    22, 49, 15, 71, 22,  0, 28, 25, 34, 34, 28, 59, 34, 68, 28,
    13, 46, 22, 40, 47, 46, 56, 40, 78, 47, 10, 52, 28, 59, 44,
    52, 58, 59, 78, 52,  8,  3, 16, 10, 38,  3, 50, 10, 68,  3,
     4, 22, 18, 15, 38, 22, 48, 15, 72, 22,  1, 28, 26, 34, 35,
    28, 60, 34, 69, 28, 14, 46, 23, 40, 47, 47, 57, 40, 77, 47,
    11, 52, 27, 59, 45, 52, 57, 59, 79, 52,  7,  3, 17, 10, 37,
     3, 51, 10, 67,  3,  5, 22, 17, 15, 39, 22, 48, 16, 73, 22,
     2, 28, 27, 34, 36, 28, 61, 34, 70, 28, 15, 46, 24, 40, 46,
    47, 58, 40, 76, 47, 12, 52, 26, 59, 46, 52, 56, 59, 79, 53,
     6,  3, 18, 10, 36,  3, 52, 10, 66,  3,  6, 22, 16, 15, 40,
    22, 49, 16, 74, 22,  3, 28, 28, 34, 37, 28, 62, 34, 71, 28,
    15, 47, 25, 40, 45, 47, 59, 40, 75, 47, 13, 52, 25, 59, 47,
    52, 55, 59, 78, 53,  5,  3, 19, 10, 35,  3, 53, 10, 65,  3,
     7, 22, 16, 16, 41, 22, 50, 16, 75, 22,  4, 28, 29, 34, 38,
    28, 63, 34, 72, 28, 14, 47, 26, 40, 44, 47, 60, 40, 74, 47,
    14, 52, 24, 59, 47, 53, 54, 59, 77, 53,  4,  3, 20, 10, 34,
     3, 54, 10, 64,  3,  8, 22, 17, 16, 42, 22, 51, 16, 76, 22,
     5, 28, 30, 34, 39, 28, 63, 35, 73, 28, 13, 47, 27, 40, 43,
    47, 61, 40, 73, 47, 15, 52, 23, 59, 46, 53, 53, 59, 76, 53,
     3,  3, 21, 10, 33,  3, 55, 10, 64,  4,  9, 22, 18, 16, 43,
    22, 52, 16, 77, 22,  6, 28, 31, 34, 40, 28, 62, 35, 74, 28,
    12, 47, 28, 40, 42, 47, 62, 40, 72, 47, 15, 53, 22, 59, 45,
    53, 52, 59, 75, 53,  2,  3, 22, 10, 32,  3, 56, 10, 65,  4,
    10, 22, 19, 16, 44, 22, 53, 16, 78, 22,  7, 28, 31, 35, 41,
    28, 61, 35, 75, 28, 11, 47, 29, 40, 41, 47, 63, 40, 71, 47,
    14, 53, 21, 59, 44, 53, 51, 59, 74, 53,  1,  3, 23, 10, 32,
     4, 57, 10, 66,  4, 11, 22, 20, 16, 45, 22, 54, 16, 79, 22,
     8, 28, 30, 35, 42, 28, 60, 35, 76, 28, 10, 47, 30, 40, 40,
    47, 63, 41, 70, 47, 13, 53, 20, 59, 43, 53, 50, 59, 73, 53,
     0,  3, 24, 10, 33,  4, 58, 10, 67,  4, 12, 22, 21, 16, 46,
    22, 55, 16, 79, 23,  9, 28, 29, 35, 43, 28, 59, 35, 77, 28,
     9, 47, 31, 40, 39, 47, 62, 41, 69, 47, 12, 53, 19, 59, 42,
    53, 49, 59, 72, 53,  0,  4, 25, 10, 34,  4, 59, 10, 68,  4,
    13, 22, 22, 16, 47, 22, 56, 16, 78, 23, 10, 28, 28, 35, 44,
    28, 58, 35, 78, 28,  8, 47, 31, 41, 38, 47, 61, 41, 68, 47,
    11, 53, 18, 59, 41, 53, 48, 59, 71, 53,  1,  4, 26, 10, 35,
     4, 60, 10, 69,  4, 14, 22, 23, 16, 47, 23, 57, 16, 77, 23,
    11, 28, 27, 35, 45, 28, 57, 35, 79, 28,  7, 47, 30, 41, 37,
    47, 60, 41, 67, 47, 10, 53, 17, 59, 40, 53, 48, 48, 70, 53,
     2,  4, 27, 10, 36,  4, 61, 10, 70,  4, 15, 22, 24, 16, 46,
    23, 58, 16, 76, 23, 12, 28, 26, 35, 46, 28, 56, 35, 79, 29,
     6, 47, 29, 41, 36, 47, 59, 41, 66, 47,  9, 53, 16, 59, 39,
    53, 49, 48, 69, 53,  3,  4, 28, 10, 37,  4, 62, 10, 71,  4,
    15, 23, 25, 16, 45, 23, 59, 16, 75, 23, 13, 28, 25, 35, 47,
    28, 55, 35, 78, 29,  5, 47, 28, 41, 35, 47, 58, 41, 65, 47,
     8, 53, 16, 48, 38, 53, 50, 48, 68, 53,  4,  4, 29, 10, 38,
     4, 63, 10, 72,  4, 14, 23, 26, 16, 44, 23, 60, 16, 74, 23,
    14, 28, 24, 35, 47, 29, 54, 35, 77, 29,  4, 47, 27, 41, 34,
    47, 57, 41, 64, 47,  7, 53, 17, 48, 37, 53, 51, 48, 67, 53,
     5,  4, 30, 10, 39,  4, 63, 11, 73,  4, 13, 23, 27, 16, 43,
    23, 61, 16, 73, 23, 15, 28, 23, 35, 46, 29, 53, 35, 76, 29,
     3, 47, 26, 41, 33, 47, 56, 41, 64, 36,  6, 53, 18, 48, 36,
    53, 52, 48, 66, 53,  6,  4, 31, 10, 40,  4, 62, 11, 74,  4,
    12, 23, 28, 16, 42, 23, 62, 16, 72, 23, 15, 29, 22, 35, 45,
    29, 52, 35, 75, 29,  2, 47, 25, 41, 32, 47, 55, 41, 65, 36,
     5, 53, 19, 48, 35, 53, 53, 48, 65, 53,  7,  4, 31, 11, 41,
     4, 61, 11, 75,  4, 11, 23, 29, 16, 41, 23, 63, 16, 71, 23,
    14, 29, 21, 35, 44, 29, 51, 35, 74, 29,  1, 47, 24, 41, 32,
    36, 54, 41, 66, 36,  4, 53, 20, 48, 34, 53, 54, 48, 64, 53,
     8,  4, 30, 11, 42,  4, 60, 11, 76,  4, 10, 23, 30, 16, 40,
    23, 63, 17, 70, 23, 13, 29, 20, 35, 43, 29, 50, 35, 73, 29,
     0, 47, 23, 41, 33, 36, 53, 41, 67, 36,  3, 53, 21, 48, 33,
    53, 55, 48, 64, 54,  9,  4, 29, 11, 43,  4, 59, 11, 77,  4,
     9, 23, 31, 16, 39, 23, 62, 17, 69, 23, 12, 29, 19, 35, 42,
    29, 49, 35, 72, 29,  0, 36, 22, 41, 34, 36, 52, 41, 68, 36,
     2, 53, 22, 48, 32, 53, 56, 48, 65, 54, 10,  4, 28, 11, 44,
     4, 58, 11, 78,  4,  8, 23, 31, 17, 38, 23, 61, 17, 68, 23,
    11, 29, 18, 35, 41, 29, 48, 35, 71, 29,  1, 36, 21, 41, 35,
    36, 51, 41, 69, 36,  1, 53, 23, 48, 32, 54, 57, 48, 66, 54,
    11,  4, 27, 11, 45,  4, 57, 11, 79,  4,  7, 23, 30, 17, 37,
    23, 60, 17, 67, 23, 10, 29, 17, 35, 40, 29, 48, 24, 70, 29,
     2, 36, 20, 41, 36, 36, 50, 41, 70, 36,  0, 53, 24, 48, 33,
    54, 58, 48, 67, 54, 12,  4, 26, 11, 46,  4, 56, 11, 79,  5,
     6, 23, 29, 17, 36, 23, 59, 17, 66, 23,  9, 29, 16, 35, 39,
    29, 49, 24, 69, 29,  3, 36, 19, 41, 37, 36, 49, 41, 71, 36,
     0, 54, 25, 48, 34, 54, 59, 48, 68, 54, 13,  4, 25, 11, 47,
     4, 55, 11, 78,  5,  5, 23, 28, 17, 35, 23, 58, 17, 65, 23,
     8, 29, 16, 24, 38, 29, 50, 24, 68, 29,  4, 36, 18, 41, 38,
    36, 48, 41, 72, 36,  1, 54, 26, 48, 35, 54, 60, 48, 69, 54,
    14,  4, 24, 11, 47,  5, 54, 11, 77,  5,  4, 23, 27, 17, 34,
    23, 57, 17, 64, 23,  7, 29, 17, 24, 37, 29, 51, 24, 67, 29,
     5, 36, 17, 41, 39, 36, 48, 42, 73, 36,  2, 54, 27, 48, 36,
    54, 61, 48, 70, 54, 15,  4, 23, 11, 46,  5, 53, 11, 76,  5,
     3, 23, 26, 17, 33, 23, 56, 17, 64, 12,  6, 29, 18, 24, 36,
    29, 52, 24, 66, 29,  6, 36, 16, 41, 40, 36, 49, 42, 74, 36,
     3, 54, 28, 48, 37, 54, 62, 48, 71, 54, 15,  5, 22, 11, 45,
     5, 52, 11, 75,  5,  2, 23, 25, 17, 32, 23, 55, 17, 65, 12,
     5, 29, 19, 24, 35, 29, 53, 24, 65, 29,  7, 36, 16, 42, 41,
    36, 50, 42, 75, 36,  4, 54, 29, 48, 38, 54, 63, 48, 72, 54,
    14,  5, 21, 11, 44,  5, 51, 11, 74,  5,  1, 23, 24, 17, 32,
    12, 54, 17, 66, 12,  4, 29, 20, 24, 34, 29, 54, 24, 64, 29,
     8, 36, 17, 42, 42, 36, 51, 42, 76, 36,  5, 54, 30, 48, 39,
    54, 63, 49, 73, 54, 13,  5, 20, 11, 43,  5, 50, 11, 73,  5,
     0, 23, 23, 17, 33, 12, 53, 17, 67, 12,  3, 29, 21, 24, 33,
    29, 55, 24, 64, 30,  9, 36, 18, 42, 43, 36, 52, 42, 77, 36,
     6, 54, 31, 48, 40, 54, 62, 49, 74, 54, 12,  5, 19, 11, 42,
     5, 49, 11, 72,  5,  0, 12, 22, 17, 34, 12, 52, 17, 68, 12,
     2, 29, 22, 24, 32, 29, 56, 24, 65, 30, 10, 36, 19, 42, 44,
    36, 53, 42, 78, 36,  7, 54, 31, 49, 41, 54, 61, 49, 75, 54,
    11,  5, 18, 11, 41,  5, 48, 11, 71,  5,  1, 12, 21, 17, 35,
    12, 51, 17, 69, 12,  1, 29, 23, 24, 32, 30, 57, 24, 66, 30,
    11, 36, 20, 42, 45, 36, 54, 42, 79, 36,  8, 54, 30, 49, 42,
    54, 60, 49, 76, 54, 10,  5, 17, 11, 40,  5, 48,  0, 70,  5,
     2, 12, 20, 17, 36, 12, 50, 17, 70, 12,  0, 29, 24, 24, 33,
    30, 58, 24, 67, 30, 12, 36, 21, 42, 46, 36, 55, 42, 79, 37,
     9, 54, 29, 49, 43, 54, 59, 49, 77, 54,  9,  5, 16, 11, 39,
     5, 49,  0, 69,  5,  3, 12, 19, 17, 37, 12, 49, 17, 71, 12,
     0, 30, 25, 24, 34, 30, 59, 24, 68, 30, 13, 36, 22, 42, 47,
    36, 56, 42, 78, 37, 10, 54, 28, 49, 44, 54, 58, 49, 78, 54,
     8,  5, 16,  0, 38,  5, 50,  0, 68,  5,  4, 12, 18, 17, 38,
    12, 48, 17, 72, 12,  1, 30, 26, 24, 35, 30, 60, 24, 69, 30,
    14, 36, 23, 42, 47, 37, 57, 42, 77, 37, 11, 54, 27, 49, 45,
    54, 57, 49, 79, 54,  7,  5, 17,  0, 37,  5, 51,  0, 67,  5,
     5, 12, 17, 17, 39, 12, 48, 18, 73, 12,  2, 30, 27, 24, 36,
    30, 61, 24, 70, 30, 15, 36, 24, 42, 46, 37, 58, 42, 76, 37,
    12, 54, 26, 49, 46, 54, 56, 49, 79, 55,  6,  5, 18,  0, 36,
     5, 52,  0, 66,  5,  6, 12, 16, 17, 40, 12, 49, 18, 74, 12,
     3, 30, 28, 24, 37, 30, 62, 24, 71, 30, 15, 37, 25, 42, 45,
    37, 59, 42, 75, 37, 13, 54, 25, 49, 47, 54, 55, 49, 78, 55,
     5,  5, 19,  0, 35,  5, 53,  0, 65,  5,  7, 12, 16, 18, 41,
    12, 50, 18, 75, 12,  4, 30, 29, 24, 38, 30, 63, 24, 72, 30,
    14, 37, 26, 42, 44, 37, 60, 42, 74, 37, 14, 54, 24, 49, 47,
    55, 54, 49, 77, 55,  4,  5, 20,  0, 34,  5, 54,  0, 64,  5,
     8, 12, 17, 18, 42, 12, 51, 18, 76, 12,  5, 30, 30, 24, 39,
    30, 63, 25, 73, 30, 13, 37, 27, 42, 43, 37, 61, 42, 73, 37,
    15, 54, 23, 49, 46, 55, 53, 49, 76, 55,  3,  5, 21,  0, 33,
     5, 55,  0, 64,  6,  9, 12, 18, 18, 43, 12, 52, 18, 77, 12,
     6, 30, 31, 24, 40, 30, 62, 25, 74, 30, 12, 37, 28, 42, 42,
    37, 62, 42, 72, 37, 15, 55, 22, 49, 45, 55, 52, 49, 75, 55,
     2,  5, 22,  0, 32,  5, 56,  0, 65,  6, 10, 12, 19, 18, 44,
    12, 53, 18, 78, 12,  7, 30, 31, 25, 41, 30, 61, 25, 75, 30,
    11, 37, 29, 42, 41, 37, 63, 42, 71, 37, 14, 55, 21, 49, 44,
    55, 51, 49, 74, 55,  1,  5, 23,  0, 32,  6, 57,  0, 66,  6,
    11, 12, 20, 18, 45, 12, 54, 18, 79, 12,  8, 30, 30, 25, 42,
    30, 60, 25, 76, 30, 10, 37, 30, 42, 40, 37, 63, 43, 70, 37,
    13, 55, 20, 49, 43, 55, 50, 49, 73, 55,  0,  5, 24,  0, 33,
     6, 58,  0, 67,  6, 12, 12, 21, 18, 46, 12, 55, 18, 79, 13,
     9, 30, 29, 25, 43, 30, 59, 25, 77, 30,  9, 37, 31, 42, 39,
    37, 62, 43, 69, 37, 12, 55, 19, 49, 42, 55, 49, 49, 72, 55,
     0,  6, 25,  0, 34,  6, 59,  0, 68,  6, 13, 12, 22, 18, 47,
    12, 56, 18, 78, 13, 10, 30, 28, 25, 44, 30, 58, 25, 78, 30,
     8, 37, 31, 43, 38, 37, 61, 43, 68, 37, 11, 55, 18, 49, 41,
    55, 48, 49, 71, 55,  1,  6, 26,  0, 35,  6, 60,  0, 69,  6,
    14, 12, 23, 18, 47, 13, 57, 18, 77, 13, 11, 30, 27, 25, 45,
    30, 57, 25, 79, 30,  7, 37, 30, 43, 37, 37, 60, 43, 67, 37,
    10, 55, 17, 49, 40, 55, 48, 50, 70, 55,  2,  6, 27,  0, 36,
     6, 61,  0, 70,  6, 15, 12, 24, 18, 46, 13, 58, 18, 76, 13,
    12, 30, 26, 25, 46, 30, 56, 25, 79, 31,  6, 37, 29, 43, 36,
    37, 59, 43, 66, 37,  9, 55, 16, 49, 39, 55, 49, 50, 69, 55,
     3,  6, 28,  0, 37,  6, 62,  0, 71,  6, 15, 13, 25, 18, 45,
    13, 59, 18, 75, 13, 13, 30, 25, 25, 47, 30, 55, 25, 78, 31,
     5, 37, 28, 43, 35, 37, 58, 43, 65, 37,  8, 55, 16, 50, 38,
    55, 50, 50, 68, 55,  4,  6, 29,  0, 38,  6, 63,  0, 72,  6,
    14, 13, 26, 18, 44, 13, 60, 18, 74, 13, 14, 30, 24, 25, 47,
    31, 54, 25, 77, 31,  4, 37, 27, 43, 34, 37, 57, 43, 64, 37,
     7, 55, 17, 50, 37, 55, 51, 50, 67, 55,  5,  6, 30,  0, 39,
     6, 63,  1, 73,  6, 13, 13, 27, 18, 43, 13, 61, 18, 73, 13,
    15, 30, 23, 25, 46, 31, 53, 25, 76, 31,  3, 37, 26, 43, 33,
    37, 56, 43, 64, 38,  6, 55, 18, 50, 36, 55, 52, 50, 66, 55,
     6,  6, 31,  0, 40,  6, 62,  1, 74,  6, 12, 13, 28, 18, 42,
    13, 62, 18, 72, 13, 15, 31, 22, 25, 45, 31, 52, 25, 75, 31,
     2, 37, 25, 43, 32, 37, 55, 43, 65, 38,  5, 55, 19, 50, 35,
    55, 53, 50, 65, 55,  7,  6, 31,  1, 41,  6, 61,  1, 75,  6,
    11, 13, 29, 18, 41, 13, 63, 18, 71, 13, 14, 31, 21, 25, 44,
    31, 51, 25, 74, 31,  1, 37, 24, 43, 32, 38, 54, 43, 66, 38,
     4, 55, 20, 50, 34, 55, 54, 50, 64, 55,  8,  6, 30,  1, 42,
     6, 60,  1, 76,  6, 10, 13, 30, 18, 40, 13, 63, 19, 70, 13,
    13, 31, 20, 25, 43, 31, 50, 25, 73, 31,  0, 37, 23, 43, 33,
    38, 53, 43, 67, 38,  3, 55, 21, 50, 33, 55, 55, 50, 64, 56,
     9,  6, 29,  1, 43,  6, 59,  1, 77,  6,  9, 13, 31, 18, 39,
    13, 62, 19, 69, 13, 12, 31, 19, 25, 42, 31, 49, 25, 72, 31,
     0, 38, 22, 43, 34, 38, 52, 43, 68, 38,  2, 55, 22, 50, 32,
    55, 56, 50, 65, 56, 10,  6, 28,  1, 44,  6, 58,  1, 78,  6,
     8, 13, 31, 19, 38, 13, 61, 19, 68, 13, 11, 31, 18, 25, 41,
    31, 48, 25, 71, 31,  1, 38, 21, 43, 35, 38, 51, 43, 69, 38,
     1, 55, 23, 50, 32, 56, 57, 50, 66, 56, 11,  6, 27,  1, 45,
     6, 57,  1, 79,  6,  7, 13, 30, 19, 37, 13, 60, 19, 67, 13,
    10, 31, 17, 25, 40, 31, 48, 26, 70, 31,  2, 38, 20, 43, 36,
    38, 50, 43, 70, 38,  0, 55, 24, 50, 33, 56, 58, 50, 67, 56,
    12,  6, 26,  1, 46,  6, 56,  1, 79,  7,  6, 13, 29, 19, 36,
    13, 59, 19, 66, 13,  9, 31, 16, 25, 39, 31, 49, 26, 69, 31,
     3, 38, 19, 43, 37, 38, 49, 43, 71, 38,  0, 56, 25, 50, 34,
    56, 59, 50, 68, 56, 13,  6, 25,  1, 47,  6, 55,  1, 78,  7,
     5, 13, 28, 19, 35, 13, 58, 19, 65, 13,  8, 31, 16, 26, 38,
    31, 50, 26, 68, 31,  4, 38, 18, 43, 38, 38, 48, 43, 72, 38,
     1, 56, 26, 50, 35, 56, 60, 50, 69, 56, 14,  6, 24,  1, 47,
     7, 54,  1, 77,  7,  4, 13, 27, 19, 34, 13, 57, 19, 64, 13,
     7, 31, 17, 26, 37, 31, 51, 26, 67, 31,  5, 38, 17, 43, 39,
    38, 48, 44, 73, 38,  2, 56, 27, 50, 36, 56, 61, 50, 70, 56,
    15,  6, 23,  1, 46,  7, 53,  1, 76,  7,  3, 13, 26, 19, 33,
    13, 56, 19, 64, 14,  6, 31, 18, 26, 36, 31, 52, 26, 66, 31,
     6, 38, 16, 43, 40, 38, 49, 44, 74, 38,  3, 56, 28, 50, 37,
    56, 62, 50, 71, 56, 15,  7, 22,  1, 45,  7, 52,  1, 75,  7,
     2, 13, 25, 19, 32, 13, 55, 19, 65, 14,  5, 31, 19, 26, 35,
    31, 53, 26, 65, 31,  7, 38, 16, 44, 41, 38, 50, 44, 75, 38,
     4, 56, 29, 50, 38, 56, 63, 50, 72, 56, 14,  7, 21,  1, 44,
     7, 51,  1, 74,  7,  1, 13, 24, 19, 32, 14, 54, 19, 66, 14,
     4, 31, 20, 26, 34, 31, 54, 26, 64, 31,  8, 38, 17, 44, 42,
    38, 51, 44, 76, 38,  5, 56, 30, 50, 39, 56, 63, 51, 73, 56,
    13,  7, 20,  1, 43,  7, 50,  1, 73,  7,  0, 13, 23, 19, 33,
    14, 53, 19, 67, 14,  3, 31, 21, 26, 33, 31, 55, 26, 64, 32,
     9, 38, 18, 44, 43, 38, 52, 44, 77, 38,  6, 56, 31, 50, 40,
    56, 62, 51, 74, 56, 12,  7, 19,  1, 42,  7, 49,  1, 72,  7,
     0, 14, 22, 19, 34, 14, 52, 19, 68, 14,  2, 31, 22, 26, 32,
    31, 56, 26, 65, 32, 10, 38, 19, 44, 44, 38, 53, 44, 78, 38,
     7, 56, 31, 51, 41, 56, 61, 51, 75, 56, 11,  7, 18,  1, 41,
     7, 48,  1, 71,  7,  1, 14, 21, 19, 35, 14, 51, 19, 69, 14,
     1, 31, 23, 26, 32, 32, 57, 26, 66, 32, 11, 38, 20, 44, 45,
    38, 54, 44, 79, 38,  8, 56, 30, 51, 42, 56, 60, 51, 76, 56,
    10,  7, 17,  1, 40,  7, 48,  2, 70,  7,  2, 14, 20, 19, 36,
    14, 50, 19, 70, 14,  0, 31, 24, 26, 33, 32, 58, 26, 67, 32,
    12, 38, 21, 44, 46, 38, 55, 44, 79, 39,  9, 56, 29, 51, 43,
    56, 59, 51, 77, 56,  9,  7, 16,  1, 39,  7, 49,  2, 69,  7,
     3, 14, 19, 19, 37, 14, 49, 19, 71, 14,  0, 32, 25, 26, 34,
    32, 59, 26, 68, 32, 13, 38, 22, 44, 47, 38, 56, 44, 78, 39,
    10, 56, 28, 51, 44, 56, 58, 51, 78, 56,  8,  7, 16,  2, 38,
     7, 50,  2, 68,  7,  4, 14, 18, 19, 38, 14, 48, 19, 72, 14,
     1, 32, 26, 26, 35, 32, 60, 26, 69, 32, 14, 38, 23, 44, 47,
    39, 57, 44, 77, 39, 11, 56, 27, 51, 45, 56, 57, 51, 79, 56,
     7,  7, 17,  2, 37,  7, 51,  2, 67,  7,  5, 14, 17, 19, 39,
    14, 48, 20, 73, 14,  2, 32, 27, 26, 36, 32, 61, 26, 70, 32,
    15, 38, 24, 44, 46, 39, 58, 44, 76, 39, 12, 56, 26, 51, 46,
    56, 56, 51, 79, 57,  6,  7, 18,  2, 36,  7, 52,  2, 66,  7,
     6, 14, 16, 19, 40, 14, 49, 20, 74, 14,  3, 32, 28, 26, 37,
    32, 62, 26, 71, 32, 15, 39, 25, 44, 45, 39, 59, 44, 75, 39,
    13, 56, 25, 51, 47, 56, 55, 51, 78, 57,  5,  7, 19,  2, 35,
     7, 53,  2, 65,  7,  7, 14, 16, 20, 41, 14, 50, 20, 75, 14,
     4, 32, 29, 26, 38, 32, 63, 26, 72, 32, 14, 39, 26, 44, 44,
    39, 60, 44, 74, 39, 14, 56, 24, 51, 47, 57, 54, 51, 77, 57,
     4,  7, 20,  2, 34,  7, 54,  2, 64,  7,  8, 14, 17, 20, 42,
    14, 51, 20, 76, 14,  5, 32, 30, 26, 39, 32, 63, 27, 73, 32,
    13, 39, 27, 44, 43, 39, 61, 44, 73, 39, 15, 56, 23, 51, 46,
    57, 53, 51, 76, 57,  3,  7, 21,  2, 33,  7, 55,  2, 64,  8,
     9, 14, 18, 20, 43, 14, 52, 20, 77, 14,  6, 32, 31, 26, 40,
    32, 62, 27, 74, 32, 12, 39, 28, 44, 42, 39, 62, 44, 72, 39,
    15, 57, 22, 51, 45, 57, 52, 51, 75, 57,  2,  7, 22,  2, 32,
     7, 56,  2, 65,  8, 10, 14, 19, 20, 44, 14, 53, 20, 78, 14,
     7, 32, 31, 27, 41, 32, 61, 27, 75, 32, 11, 39, 29, 44, 41,
    39, 63, 44, 71, 39, 14, 57, 21, 51, 44, 57, 51, 51, 74, 57,
     1,  7, 23,  2, 32,  8, 57,  2, 66,  8, 11, 14, 20, 20, 45,
    14, 54, 20, 79, 14,  8, 32, 30, 27, 42, 32, 60, 27, 76, 32,
    10, 39, 30, 44, 40, 39, 63, 45, 70, 39, 13, 57, 20, 51, 43,
    57, 50, 51, 73, 57,  0,  7, 24,  2, 33,  8, 58,  2, 67,  8,
    12, 14, 21, 20, 46, 14, 55, 20, 79, 15,  9, 32, 29, 27, 43,
    32, 59, 27, 77, 32,  9, 39, 31, 44, 39, 39, 62, 45, 69, 39,
    12, 57, 19, 51, 42, 57, 49, 51, 72, 57,  0,  8, 25,  2, 34,
     8, 59,  2, 68,  8, 13, 14, 22, 20, 47, 14, 56, 20, 78, 15,
    10, 32, 28, 27, 44, 32, 58, 27, 78, 32,  8, 39, 31, 45, 38,
    39, 61, 45, 68, 39, 11, 57, 18, 51, 41, 57, 48, 51, 71, 57,
     1,  8, 26,  2, 35,  8, 60,  2, 69,  8, 14, 14, 23, 20, 47,
    15, 57, 20, 77, 15, 11, 32, 27, 27, 45, 32, 57, 27, 79, 32,
     7, 39, 30, 45, 37, 39, 60, 45, 67, 39, 10, 57, 17, 51, 40,
    57, 48, 52, 70, 57,  2,  8, 27,  2, 36,  8, 61,  2, 70,  8,
    15, 14, 24, 20, 46, 15, 58, 20, 76, 15, 12, 32, 26, 27, 46,
    32, 56, 27, 79, 33,  6, 39, 29, 45, 36, 39, 59, 45, 66, 39,
     9, 57, 16, 51, 39, 57, 49, 52, 69, 57,  3,  8, 28,  2, 37,
     8, 62,  2, 71,  8, 15, 15, 25, 20, 45, 15, 59, 20, 75, 15,
    13, 32, 25, 27, 47, 32, 55, 27, 78, 33,  5, 39, 28, 45, 35,
    39, 58, 45, 65, 39,  8, 57, 16, 52, 38, 57, 50, 52, 68, 57,
     4,  8, 29,  2, 38,  8, 63,  2, 72,  8, 14, 15, 26, 20, 44,
    15, 60, 20, 74, 15, 14, 32, 24, 27, 47, 33, 54, 27, 77, 33,
     4, 39, 27, 45, 34, 39, 57, 45, 64, 39,  7, 57, 17, 52, 37,
    57, 51, 52, 67, 57,  5,  8, 30,  2, 39,  8, 63,  3, 73,  8,
    13, 15, 27, 20, 43, 15, 61, 20, 73, 15, 15, 32, 23, 27, 46,
    33, 53, 27, 76, 33,  3, 39, 26, 45, 33, 39, 56, 45, 64, 40,
     6, 57, 18, 52, 36, 57, 52, 52, 66, 57,  6,  8, 31,  2, 40,
     8, 62,  3, 74,  8, 12, 15, 28, 20, 42, 15, 62, 20, 72, 15,
    15, 33, 22, 27, 45, 33, 52, 27, 75, 33,  2, 39, 25, 45, 32,
    39, 55, 45, 65, 40,  5, 57, 19, 52, 35, 57, 53, 52, 65, 57,
     7,  8, 31,  3, 41,  8, 61,  3, 75,  8, 11, 15, 29, 20, 41,
    15, 63, 20, 71, 15, 14, 33, 21, 27, 44, 33, 51, 27, 74, 33,
     1, 39, 24, 45, 32, 40, 54, 45, 66, 40,  4, 57, 20, 52, 34,
    57, 54, 52, 64, 57,  8,  8, 30,  3, 42,  8, 60,  3, 76,  8,
    10, 15, 30, 20, 40, 15, 63, 21, 70, 15, 13, 33, 20, 27, 43,
    33, 50, 27, 73, 33,  0, 39, 23, 45, 33, 40, 53, 45, 67, 40,
     3, 57, 21, 52, 33, 57, 55, 52, 64, 58,  9,  8, 29,  3, 43,
     8, 59,  3, 77,  8,  9, 15, 31, 20, 39, 15, 62, 21, 69, 15,
    12, 33, 19, 27, 42, 33, 49, 27, 72, 33,  0, 40, 22, 45, 34,
    40, 52, 45, 68, 40,  2, 57, 22, 52, 32, 57, 56, 52, 65, 58,
    10,  8, 28,  3, 44,  8, 58,  3, 78,  8,  8, 15, 31, 21, 38,
    15, 61, 21, 68, 15, 11, 33, 18, 27, 41, 33, 48, 27, 71, 33,
     1, 40, 21, 45, 35, 40, 51, 45, 69, 40,  1, 57, 23, 52, 32,
    58, 57, 52, 66, 58, 11,  8, 27,  3, 45,  8, 57,  3, 79,  8,
     7, 15, 30, 21, 37, 15, 60, 21, 67, 15, 10, 33, 17, 27, 40,
    33, 48, 28, 70, 33,  2, 40, 20, 45, 36, 40, 50, 45, 70, 40,
     0, 57, 24, 52, 33, 58, 58, 52, 67, 58, 12,  8, 26,  3, 46,
     8, 56,  3, 79,  9,  6, 15, 29, 21, 36, 15, 59, 21, 66, 15,
     9, 33, 16, 27, 39, 33, 49, 28, 69, 33,  3, 40, 19, 45, 37,
    40, 49, 45, 71, 40,  0, 58, 25, 52, 34, 58, 59, 52, 68, 58,
    13,  8, 25,  3, 47,  8, 55,  3, 78,  9,  5, 15, 28, 21, 35,
    15, 58, 21, 65, 15,  8, 33, 16, 28, 38, 33, 50, 28, 68, 33,
     4, 40, 18, 45, 38, 40, 48, 45, 72, 40,  1, 58, 26, 52, 35,
    58, 60, 52, 69, 58, 14,  8, 24,  3, 47,  9, 54,  3, 77,  9,
     4, 15, 27, 21, 34, 15, 57, 21, 64, 15,  7, 33, 17, 28, 37,
    33, 51, 28, 67, 33,  5, 40, 17, 45, 39, 40, 48, 46, 73, 40,
     2, 58, 27, 52, 36, 58, 61, 52, 70, 58, 15,  8, 23,  3, 46,
     9, 53,  3, 76,  9,  3, 15, 26, 21, 33, 15, 56, 21, 64, 16,
     6, 33, 18, 28, 36, 33, 52, 28, 66, 33,  6, 40, 16, 45, 40,
    40, 49, 46, 74, 40,  3, 58, 28, 52, 37, 58, 62, 52, 71, 58,
    15,  9, 22,  3, 45,  9, 52,  3, 75,  9,  2, 15, 25, 21, 32,
    15, 55, 21, 65, 16,  5, 33, 19, 28, 35, 33, 53, 28, 65, 33,
     7, 40, 16, 46, 41, 40, 50, 46, 75, 40,  4, 58, 29, 52, 38,
    58, 63, 52, 72, 58, 14,  9, 21,  3, 44,  9, 51,  3, 74,  9,
     1, 15, 24, 21, 32, 16, 54, 21, 66, 16,  4, 33, 20, 28, 34,
    33, 54, 28, 64, 33,  8, 40, 17, 46, 42, 40, 51, 46, 76, 40,
     5, 58, 30, 52, 39, 58, 63, 53, 73, 58, 13,  9, 20,  3, 43,
     9, 50,  3, 73,  9,  0, 15, 23, 21, 33, 16, 53, 21, 67, 16,
     3, 33, 21, 28, 33, 33, 55, 28, 64, 34,  9, 40, 18, 46, 43,
    40, 52, 46, 77, 40,  6, 58, 31, 52, 40, 58, 62, 53, 74, 58,
    12,  9, 19,  3, 42,  9, 49,  3, 72,  9,  0, 16, 22, 21, 34,
    16, 52, 21, 68, 16,  2, 33, 22, 28, 32, 33, 56, 28, 65, 34,
    10, 40, 19, 46, 44, 40, 53, 46, 78, 40,  7, 58, 31, 53, 41,
    58, 61, 53, 75, 58, 11,  9, 18,  3, 41,  9, 48,  3, 71,  9,
     1, 16, 21, 21, 35, 16, 51, 21, 69, 16,  1, 33, 23, 28, 32,
    34, 57, 28, 66, 34, 11, 40, 20, 46, 45, 40, 54, 46, 79, 40,
     8, 58, 30, 53, 42, 58, 60, 53, 76, 58, 10,  9, 17,  3, 40,
     9, 48,  4, 70,  9,  2, 16, 20, 21, 36, 16, 50, 21, 70, 16,
     0, 33, 24, 28, 33, 34, 58, 28, 67, 34, 12, 40, 21, 46, 46,
    40, 55, 46, 79, 41,  9, 58, 29, 53, 43, 58, 59, 53, 77, 58,
     9,  9, 16,  3, 39,  9, 49,  4, 69,  9,  3, 16, 19, 21, 37,
    16, 49, 21, 71, 16,  0, 34, 25, 28, 34, 34, 59, 28, 68, 34,
    13, 40, 22, 46, 47, 40, 56, 46, 78, 41, 10, 58, 28, 53, 44,
    58, 58, 53, 78, 58,  8,  9, 16,  4, 38,  9, 50,  4, 68,  9,
     4, 16, 18, 21, 38, 16, 48, 21, 72, 16,  1, 34, 26, 28, 35,
    34, 60, 28, 69, 34, 14, 40, 23, 46, 47, 41, 57, 46, 77, 41,
    11, 58, 27, 53, 45, 58, 57, 53, 79, 58,  7,  9, 17,  4, 37,
     9, 51,  4, 67,  9,  5, 16, 17, 21, 39, 16, 48, 22, 73, 16,
     2, 34, 27, 28, 36, 34, 61, 28, 70, 34, 15, 40, 24, 46, 46,
    41, 58, 46, 76, 41, 12, 58, 26, 53, 46, 58, 56, 53, 79, 59,
     6,  9, 18,  4, 36,  9, 52,  4, 66,  9,  6, 16, 16, 21, 40,
    16, 49, 22, 74, 16,  3, 34, 28, 28, 37, 34, 62, 28, 71, 34,
    15, 41, 25, 46, 45, 41, 59, 46, 75, 41, 13, 58, 25, 53, 47,
    58, 55, 53, 78, 59,  5,  9, 19,  4, 35,  9, 53,  4, 65,  9,
     7, 16, 16, 22, 41, 16, 50, 22, 75, 16,  4, 34, 29, 28, 38,
    34, 63, 28, 72, 34, 14, 41, 26, 46, 44, 41, 60, 46, 74, 41,
    14, 58, 24, 53, 47, 59, 54, 53, 77, 59,  4,  9, 20,  4, 34,
     9, 54,  4, 64,  9,  8, 16, 17, 22, 42, 16, 51, 22, 76, 16,
     5, 34, 30, 28, 39, 34, 63, 29, 73, 34, 13, 41, 27, 46, 43,
    41, 61, 46, 73, 41, 15, 58, 23, 53, 46, 59, 53, 53, 76, 59,
     3,  9, 21,  4, 33,  9, 55,  4, 64, 10,  9, 16, 18, 22, 43,
    16, 52, 22, 77, 16,  6, 34, 31, 28, 40, 34, 62, 29, 74, 34,
    12, 41, 28, 46, 42, 41, 62, 46, 72, 41, 15, 59, 22, 53, 45,
    59, 52, 53, 75, 59,  2,  9, 22,  4, 32,  9, 56,  4, 65, 10,
    10, 16, 19, 22, 44, 16, 53, 22, 78, 16,  7, 34, 31, 29, 41,
    34, 61, 29, 75, 34, 11, 41, 29, 46, 41, 41, 63, 46, 71, 41,
    14, 59, 21, 53, 44, 59, 51, 53, 74, 59,  1,  9, 23,  4, 32,
    10, 57,  4, 66, 10, 11, 16, 20, 22, 45, 16, 54, 22, 79, 16,
     8, 34, 30, 29, 42, 34, 60, 29, 76, 34, 10, 41, 30, 46, 40,
    41, 63, 47, 70, 41, 13, 59, 20, 53, 43, 59, 50, 53, 73, 59,
     0,  9, 24,  4, 33, 10, 58,  4, 67, 10, 12, 16, 21, 22, 46,
    16, 55, 22, 79, 17,  9, 34, 29, 29, 43, 34, 59, 29, 77, 34,
     9, 41, 31, 46, 39, 41, 62, 47, 69, 41, 12, 59, 19, 53, 42,
    59, 49, 53, 72, 59,  0, 10, 25,  4, 34, 10, 59,  4, 68, 10,
    13, 16, 22, 22, 47, 16, 56, 22, 78, 17, 10, 34, 28, 29, 44,
    34, 58, 29, 78, 34,  8, 41, 31, 47, 38, 41, 61, 47, 68, 41,
    11, 59, 18, 53, 41, 59, 48, 53, 71, 59,  1, 10, 26,  4, 35,
    10, 60,  4, 69, 10, 14, 16, 23, 22, 47, 17, 57, 22, 77, 17,
    11, 34, 27, 29, 45, 34, 57, 29, 79, 34,  7, 41, 30, 47, 37,
    41, 60, 47, 67, 41, 10, 59, 17, 53, 40, 59, 48, 54, 70, 59,
     2, 10, 27,  4, 36, 10, 61,  4, 70, 10, 15, 16, 24, 22, 46,
    17, 58, 22, 76, 17, 12, 34, 26, 29, 46, 34, 56, 29, 79, 35,
     6, 41, 29, 47, 36, 41, 59, 47, 66, 41,  9, 59, 16, 53, 39,
    59, 49, 54, 69, 59,  3, 10, 28,  4, 37, 10, 62,  4, 71, 10,
    15, 17, 25, 22, 45, 17, 59, 22, 75, 17, 13, 34, 25, 29, 47,
    34, 55, 29, 78, 35,  5, 41, 28, 47, 35, 41, 58, 47, 65, 41,
     8, 59, 16, 54, 38, 59, 50, 54, 68, 59,  4, 10, 29,  4, 38,
    10, 63,  4, 72, 10, 14, 17, 26, 22, 44, 17, 60, 22, 74, 17,
    14, 34, 24, 29, 47, 35, 54, 29, 77, 35,  4, 41, 27, 47, 34,
    41, 57, 47, 64, 41,  7, 59, 17, 54, 37, 59, 51, 54, 67, 59,
     5, 10, 30,  4, 39, 10, 63,  5, 73, 10, 13, 17, 27, 22, 43,
    17, 61, 22, 73, 17, 15, 34, 23, 29, 46, 35, 53, 29, 76, 35,
     3, 41, 26, 47, 33, 41, 56, 47, 64, 42,  6, 59, 18, 54, 36,
    59, 52, 54, 66, 59,  6, 10, 31,  4, 40, 10, 62,  5, 74, 10,
    12, 17, 28, 22, 42, 17, 62, 22, 72, 17, 15, 35, 22, 29, 45,
    35, 52, 29, 75, 35,  2, 41, 25, 47, 32, 41, 55, 47, 65, 42,
     5, 59, 19, 54, 35, 59, 53, 54, 65, 59,  7, 10, 31,  5, 41,
    10, 61,  5, 75, 10, 11, 17, 29, 22, 41, 17, 63, 22, 71, 17,
    14, 35, 21, 29, 44, 35, 51, 29, 74, 35,  1, 41, 24, 47, 32,
    42, 54, 47, 66, 42,  4, 59, 20, 54, 34, 59, 54, 54, 64, 59,
     8, 10, 30,  5, 42, 10, 60,  5, 76, 10, 10, 17, 30, 22, 40,
    17, 63, 23, 70, 17, 13, 35, 20, 29, 43, 35, 50, 29, 73, 35,
     0, 41, 23, 47, 33, 42, 53, 47, 67, 42,  3, 59, 21, 54, 33,
    59, 55, 54, 64, 48,  9, 10, 29,  5, 43, 10, 59,  5, 77, 10,
     9, 17, 31, 22, 39, 17, 62, 23, 69, 17, 12, 35, 19, 29, 42,
    35, 49, 29, 72, 35,  0, 42, 22, 47, 34, 42, 52, 47, 68, 42,
     2, 59, 22, 54, 32, 59, 56, 54, 65, 48, 10, 10, 28,  5, 44,
    10, 58,  5, 78, 10,  8, 17, 31, 23, 38, 17, 61, 23, 68, 17,
    11, 35, 18, 29, 41, 35, 48, 29, 71, 35,  1, 42, 21, 47, 35,
    42, 51, 47, 69, 42,  1, 59, 23, 54, 32, 48, 57, 54, 66, 48,
    11, 10, 27,  5, 45, 10, 57,  5, 79, 10,  7, 17, 30, 23, 37,
    17, 60, 23, 67, 17, 10, 35, 17, 29, 40, 35, 48, 30, 70, 35,
     2, 42, 20, 47, 36, 42, 50, 47, 70, 42,  0, 59, 24, 54, 33,
    48, 58, 54, 67, 48, 12, 10, 26,  5, 46, 10, 56,  5, 79, 11,
     6, 17, 29, 23, 36, 17, 59, 23, 66, 17,  9, 35, 16, 29, 39,
    35, 49, 30, 69, 35,  3, 42, 19, 47, 37, 42, 49, 47, 71, 42,
     0, 48, 25, 54, 34, 48, 59, 54, 68, 48, 13, 10, 25,  5, 47,
    10, 55,  5, 78, 11,  5, 17, 28, 23, 35, 17, 58, 23, 65, 17,
     8, 35, 16, 30, 38, 35, 50, 30, 68, 35,  4, 42, 18, 47, 38,
    42, 48, 47, 72, 42,  1, 48, 26, 54, 35, 48, 60, 54, 69, 48,
    14, 10, 24,  5, 47, 11, 54,  5, 77, 11,  4, 17, 27, 23, 34,
    17, 57, 23, 64, 17,  7, 35, 17, 30, 37, 35, 51, 30, 67, 35,
     5, 42, 17, 47, 39, 42, 48, 36, 73, 42,  2, 48, 27, 54, 36,
    48, 61, 54, 70, 48, 15, 10, 23,  5, 46, 11, 53,  5, 76, 11,
     3, 17, 26, 23, 33, 17, 56, 23, 64, 18,  6, 35, 18, 30, 36,
    35, 52, 30, 66, 35,  6, 42, 16, 47, 40, 42, 49, 36, 74, 42,
     3, 48, 28, 54, 37, 48, 62, 54, 71, 48, 15, 11, 22,  5, 45,
    11, 52,  5, 75, 11,  2, 17, 25, 23, 32, 17, 55, 23, 65, 18,
     5, 35, 19, 30, 35, 35, 53, 30, 65, 35,  7, 42, 16, 36, 41,
    42, 50, 36, 75, 42,  4, 48, 29, 54, 38, 48, 63, 54, 72, 48,
    14, 11, 21,  5, 44, 11, 51,  5, 74, 11,  1, 17, 24, 23, 32,
    18, 54, 23, 66, 18,  4, 35, 20, 30, 34, 35, 54, 30, 64, 35,
     8, 42, 17, 36, 42, 42, 51, 36, 76, 42,  5, 48, 30, 54, 39,
    48, 63, 55, 73, 48, 13, 11, 20,  5, 43, 11, 50,  5, 73, 11,
     0, 17, 23, 23, 33, 18, 53, 23, 67, 18,  3, 35, 21, 30, 33,
    35, 55, 30, 64, 24,  9, 42, 18, 36, 43, 42, 52, 36, 77, 42,
     6, 48, 31, 54, 40, 48, 62, 55, 74, 48, 12, 11, 19,  5, 42,
    11, 49,  5, 72, 11,  0, 18, 22, 23, 34, 18, 52, 23, 68, 18,
     2, 35, 22, 30, 32, 35, 56, 30, 65, 24, 10, 42, 19, 36, 44,
    42, 53, 36, 78, 42,  7, 48, 31, 55, 41, 48, 61, 55, 75, 48,
    11, 11, 18,  5, 41, 11, 48,  5, 71, 11,  1, 18, 21, 23, 35,
    18, 51, 23, 69, 18,  1, 35, 23, 30, 32, 24, 57, 30, 66, 24,
    11, 42, 20, 36, 45, 42, 54, 36, 79, 42,  8, 48, 30, 55, 42,
    48, 60, 55, 76, 48, 10, 11, 17,  5, 40, 11, 48,  6, 70, 11,
     2, 18, 20, 23, 36, 18, 50, 23, 70, 18,  0, 35, 24, 30, 33,
    24, 58, 30, 67, 24, 12, 42, 21, 36, 46, 42, 55, 36, 79, 43,
     9, 48, 29, 55, 43, 48, 59, 55, 77, 48,  9, 11, 16,  5, 39,
    11, 49,  6, 69, 11,  3, 18, 19, 23, 37, 18, 49, 23, 71, 18,
     0, 24, 25, 30, 34, 24, 59, 30, 68, 24, 13, 42, 22, 36, 47,
    42, 56, 36, 78, 43, 10, 48, 28, 55, 44, 48, 58, 55, 78, 48,
     8, 11, 16,  6, 38, 11, 50,  6, 68, 11,  4, 18, 18, 23, 38,
    18, 48, 23, 72, 18,  1, 24, 26, 30, 35, 24, 60, 30, 69, 24,
    14, 42, 23, 36, 47, 43, 57, 36, 77, 43, 11, 48, 27, 55, 45,
    48, 57, 55, 79, 48,  7, 11, 17,  6, 37, 11, 51,  6, 67, 11,
     5, 18, 17, 23, 39, 18, 48, 12, 73, 18,  2, 24, 27, 30, 36,
    24, 61, 30, 70, 24, 15, 42, 24, 36, 46, 43, 58, 36, 76, 43,
    12, 48, 26, 55, 46, 48, 56, 55, 79, 49,  6, 11, 18,  6, 36,
    11, 52,  6, 66, 11,  6, 18, 16, 23, 40, 18, 49, 12, 74, 18,
     3, 24, 28, 30, 37, 24, 62, 30, 71, 24, 15, 43, 25, 36, 45,
    43, 59, 36, 75, 43, 13, 48, 25, 55, 47, 48, 55, 55, 78, 49,
     5, 11, 19,  6, 35, 11, 53,  6, 65, 11,  7, 18, 16, 12, 41,
    18, 50, 12, 75, 18,  4, 24, 29, 30, 38, 24, 63, 30, 72, 24,
    14, 43, 26, 36, 44, 43, 60, 36, 74, 43, 14, 48, 24, 55, 47,
    49, 54, 55, 77, 49,  4, 11, 20,  6, 34, 11, 54,  6, 64, 11,
     8, 18, 17, 12, 42, 18, 51, 12, 76, 18,  5, 24, 30, 30, 39,
    24, 63, 31, 73, 24, 13, 43, 27, 36, 43, 43, 61, 36, 73, 43,
    15, 48, 23, 55, 46, 49, 53, 55, 76, 49,  3, 11, 21,  6, 33,
    11, 55,  6, 64,  0,  9, 18, 18, 12, 43, 18, 52, 12, 77, 18,
     6, 24, 31, 30, 40, 24, 62, 31, 74, 24, 12, 43, 28, 36, 42,
    43, 62, 36, 72, 43, 15, 49, 22, 55, 45, 49, 52, 55, 75, 49,
     2, 11, 22,  6, 32, 11, 56,  6, 65,  0, 10, 18, 19, 12, 44,
    18, 53, 12, 78, 18,  7, 24, 31, 31, 41, 24, 61, 31, 75, 24,
    11, 43, 29, 36, 41, 43, 63, 36, 71, 43, 14, 49, 21, 55, 44,
    49, 51, 55, 74, 49,  1, 11, 23,  6, 32,  0, 57,  6, 66,  0,
    11, 18, 20, 12, 45, 18, 54, 12, 79, 18,  8, 24, 30, 31, 42,
    24, 60, 31, 76, 24, 10, 43, 30, 36, 40, 43, 63, 37, 70, 43,
    13, 49, 20, 55, 43, 49, 50, 55, 73, 49,  0, 11, 24,  6, 33,
     0, 58,  6, 67,  0, 12, 18, 21, 12, 46, 18, 55, 12, 79, 19,
     9, 24, 29, 31, 43, 24, 59, 31, 77, 24,  9, 43, 31, 36, 39,
    43, 62, 37, 69, 43, 12, 49, 19, 55, 42, 49, 49, 55, 72, 49,
};

static const uint8_t hq_tab_19[] = {
     0,  0, 25,  4, 34,  0, 59,  4, 12, 12, 21,  8, 46, 12, 55,
     8,  8, 16, 30, 21, 42, 16, 60, 21, 11, 29, 29, 24, 41, 29,
    63, 24, 15, 33, 22, 37, 45, 33, 52, 37,  3, 45, 26, 41, 33,
    45, 56, 41,  1,  0, 26,  4, 35,  0, 60,  4, 13, 12, 22,  8,
    47, 12, 56,  8,  9, 16, 29, 21, 43, 16, 59, 21, 10, 29, 30,
    24, 40, 29, 63, 25, 14, 33, 21, 37, 44, 33, 51, 37,  2, 45,
    25, 41, 32, 45, 55, 41,  2,  0, 27,  4, 36,  0, 61,  4, 14,
    12, 23,  8, 47, 13, 57,  8, 10, 16, 28, 21, 44, 16, 58, 21,
     9, 29, 31, 24, 39, 29, 62, 25, 13, 33, 20, 37, 43, 33, 50,
    37,  1, 45, 24, 41, 32, 46, 54, 41,  3,  0, 28,  4, 37,  0,
    62,  4, 15, 12, 24,  8, 46, 13, 58,  8, 11, 16, 27, 21, 45,
    16, 57, 21,  8, 29, 31, 25, 38, 29, 61, 25, 12, 33, 19, 37,
    42, 33, 49, 37,  0, 45, 23, 41, 33, 46, 53, 41,  4,  0, 29,
     4, 38,  0, 63,  4, 15, 13, 25,  8, 45, 13, 59,  8, 12, 16,
    26, 21, 46, 16, 56, 21,  7, 29, 30, 25, 37, 29, 60, 25, 11,
    33, 18, 37, 41, 33, 48, 37,  0, 46, 22, 41, 34, 46, 52, 41,
     5,  0, 30,  4, 39,  0, 63,  5, 14, 13, 26,  8, 44, 13, 60,
     8, 13, 16, 25, 21, 47, 16, 55, 21,  6, 29, 29, 25, 36, 29,
    59, 25, 10, 33, 17, 37, 40, 33, 48, 38,  1, 46, 21, 41, 35,
    46, 51, 41,  6,  0, 31,  4, 40,  0, 62,  5, 13, 13, 27,  8,
    43, 13, 61,  8, 14, 16, 24, 21, 47, 17, 54, 21,  5, 29, 28,
    25, 35, 29, 58, 25,  9, 33, 16, 37, 39, 33, 49, 38,  2, 46,
    20, 41, 36, 46, 50, 41,  7,  0, 31,  5, 41,  0, 61,  5, 12,
    13, 28,  8, 42, 13, 62,  8, 15, 16, 23, 21, 46, 17, 53, 21,
     4, 29, 27, 25, 34, 29, 57, 25,  8, 33, 16, 38, 38, 33, 50,
    38,  3, 46, 19, 41, 37, 46, 49, 41,  8,  0, 30,  5, 42,  0,
    60,  5, 11, 13, 29,  8, 41, 13, 63,  8, 15, 17, 22, 21, 45,
    17, 52, 21,  3, 29, 26, 25, 33, 29, 56, 25,  7, 33, 17, 38,
    37, 33, 51, 38,  4, 46, 18, 41, 38, 46, 48, 41,  9,  0, 29,
     5, 43,  0, 59,  5, 10, 13, 30,  8, 40, 13, 63,  9, 14, 17,
    21, 21, 44, 17, 51, 21,  2, 29, 25, 25, 32, 29, 55, 25,  6,
    33, 18, 38, 36, 33, 52, 38,  5, 46, 17, 41, 39, 46, 48, 42,
    10,  0, 28,  5, 44,  0, 58,  5,  9, 13, 31,  8, 39, 13, 62,
     9, 13, 17, 20, 21, 43, 17, 50, 21,  1, 29, 24, 25, 32, 30,
    54, 25,  5, 33, 19, 38, 35, 33, 53, 38,  6, 46, 16, 41, 40,
    46, 49, 42, 11,  0, 27,  5, 45,  0, 57,  5,  8, 13, 31,  9,
    38, 13, 61,  9, 12, 17, 19, 21, 42, 17, 49, 21,  0, 29, 23,
    25, 33, 30, 53, 25,  4, 33, 20, 38, 34, 33, 54, 38,  7, 46,
    16, 42, 41, 46, 50, 42, 12,  0, 26,  5, 46,  0, 56,  5,  7,
    13, 30,  9, 37, 13, 60,  9, 11, 17, 18, 21, 41, 17, 48, 21,
     0, 30, 22, 25, 34, 30, 52, 25,  3, 33, 21, 38, 33, 33, 55,
    38,  8, 46, 17, 42, 42, 46, 51, 42, 13,  0, 25,  5, 47,  0,
    55,  5,  6, 13, 29,  9, 36, 13, 59,  9, 10, 17, 17, 21, 40,
    17, 48, 22,  1, 30, 21, 25, 35, 30, 51, 25,  2, 33, 22, 38,
    32, 33, 56, 38,  9, 46, 18, 42, 43, 46, 52, 42, 14,  0, 24,
     5, 47,  1, 54,  5,  5, 13, 28,  9, 35, 13, 58,  9,  9, 17,
    16, 21, 39, 17, 49, 22,  2, 30, 20, 25, 36, 30, 50, 25,  1,
    33, 23, 38, 32, 34, 57, 38, 10, 46, 19, 42, 44, 46, 53, 42,
    15,  0, 23,  5, 46,  1, 53,  5,  4, 13, 27,  9, 34, 13, 57,
     9,  8, 17, 16, 22, 38, 17, 50, 22,  3, 30, 19, 25, 37, 30,
    49, 25,  0, 33, 24, 38, 33, 34, 58, 38, 11, 46, 20, 42, 45,
    46, 54, 42, 15,  1, 22,  5, 45,  1, 52,  5,  3, 13, 26,  9,
    33, 13, 56,  9,  7, 17, 17, 22, 37, 17, 51, 22,  4, 30, 18,
    25, 38, 30, 48, 25,  0, 34, 25, 38, 34, 34, 59, 38, 12, 46,
    21, 42, 46, 46, 55, 42, 14,  1, 21,  5, 44,  1, 51,  5,  2,
    13, 25,  9, 32, 13, 55,  9,  6, 17, 18, 22, 36, 17, 52, 22,
     5, 30, 17, 25, 39, 30, 48, 26,  1, 34, 26, 38, 35, 34, 60,
    38, 13, 46, 22, 42, 47, 46, 56, 42, 13,  1, 20,  5, 43,  1,
    50,  5,  1, 13, 24,  9, 32, 14, 54,  9,  5, 17, 19, 22, 35,
    17, 53, 22,  6, 30, 16, 25, 40, 30, 49, 26,  2, 34, 27, 38,
    36, 34, 61, 38, 14, 46, 23, 42, 47, 47, 57, 42, 12,  1, 19,
     5, 42,  1, 49,  5,  0, 13, 23,  9, 33, 14, 53,  9,  4, 17,
    20, 22, 34, 17, 54, 22,  7, 30, 16, 26, 41, 30, 50, 26,  3,
    34, 28, 38, 37, 34, 62, 38, 15, 46, 24, 42, 46, 47, 58, 42,
    11,  1, 18,  5, 41,  1, 48,  5,  0, 14, 22,  9, 34, 14, 52,
     9,  3, 17, 21, 22, 33, 17, 55, 22,  8, 30, 17, 26, 42, 30,
    51, 26,  4, 34, 29, 38, 38, 34, 63, 38, 15, 47, 25, 42, 45,
    47, 59, 42, 10,  1, 17,  5, 40,  1, 48,  6,  1, 14, 21,  9,
    35, 14, 51,  9,  2, 17, 22, 22, 32, 17, 56, 22,  9, 30, 18,
    26, 43, 30, 52, 26,  5, 34, 30, 38, 39, 34, 63, 39, 14, 47,
    26, 42, 44, 47, 60, 42,  9,  1, 16,  5, 39,  1, 49,  6,  2,
    14, 20,  9, 36, 14, 50,  9,  1, 17, 23, 22, 32, 18, 57, 22,
    10, 30, 19, 26, 44, 30, 53, 26,  6, 34, 31, 38, 40, 34, 62,
    39, 13, 47, 27, 42, 43, 47, 61, 42,  8,  1, 16,  6, 38,  1,
    50,  6,  3, 14, 19,  9, 37, 14, 49,  9,  0, 17, 24, 22, 33,
    18, 58, 22, 11, 30, 20, 26, 45, 30, 54, 26,  7, 34, 31, 39,
    41, 34, 61, 39, 12, 47, 28, 42, 42, 47, 62, 42,  7,  1, 17,
     6, 37,  1, 51,  6,  4, 14, 18,  9, 38, 14, 48,  9,  0, 18,
    25, 22, 34, 18, 59, 22, 12, 30, 21, 26, 46, 30, 55, 26,  8,
    34, 30, 39, 42, 34, 60, 39, 11, 47, 29, 42, 41, 47, 63, 42,
     6,  1, 18,  6, 36,  1, 52,  6,  5, 14, 17,  9, 39, 14, 48,
    10,  1, 18, 26, 22, 35, 18, 60, 22, 13, 30, 22, 26, 47, 30,
    56, 26,  9, 34, 29, 39, 43, 34, 59, 39, 10, 47, 30, 42, 40,
    47, 63, 43,  5,  1, 19,  6, 35,  1, 53,  6,  6, 14, 16,  9,
    40, 14, 49, 10,  2, 18, 27, 22, 36, 18, 61, 22, 14, 30, 23,
    26, 47, 31, 57, 26, 10, 34, 28, 39, 44, 34, 58, 39,  9, 47,
    31, 42, 39, 47, 62, 43,  4,  1, 20,  6, 34,  1, 54,  6,  7,
    14, 16, 10, 41, 14, 50, 10,  3, 18, 28, 22, 37, 18, 62, 22,
    15, 30, 24, 26, 46, 31, 58, 26, 11, 34, 27, 39, 45, 34, 57,
    39,  8, 47, 31, 43, 38, 47, 61, 43,  3,  1, 21,  6, 33,  1,
    55,  6,  8, 14, 17, 10, 42, 14, 51, 10,  4, 18, 29, 22, 38,
    18, 63, 22, 15, 31, 25, 26, 45, 31, 59, 26, 12, 34, 26, 39,
    46, 34, 56, 39,  7, 47, 30, 43, 37, 47, 60, 43,  2,  1, 22,
     6, 32,  1, 56,  6,  9, 14, 18, 10, 43, 14, 52, 10,  5, 18,
    30, 22, 39, 18, 63, 23, 14, 31, 26, 26, 44, 31, 60, 26, 13,
    34, 25, 39, 47, 34, 55, 39,  6, 47, 29, 43, 36, 47, 59, 43,
     1,  1, 23,  6, 32,  2, 57,  6, 10, 14, 19, 10, 44, 14, 53,
    10,  6, 18, 31, 22, 40, 18, 62, 23, 13, 31, 27, 26, 43, 31,
    61, 26, 14, 34, 24, 39, 47, 35, 54, 39,  5, 47, 28, 43, 35,
    47, 58, 43,  0,  1, 24,  6, 33,  2, 58,  6, 11, 14, 20, 10,
    45, 14, 54, 10,  7, 18, 31, 23, 41, 18, 61, 23, 12, 31, 28,
    26, 42, 31, 62, 26, 15, 34, 23, 39, 46, 35, 53, 39,  4, 47,
    27, 43, 34, 47, 57, 43,  0,  2, 25,  6, 34,  2, 59,  6, 12,
    14, 21, 10, 46, 14, 55, 10,  8, 18, 30, 23, 42, 18, 60, 23,
    11, 31, 29, 26, 41, 31, 63, 26, 15, 35, 22, 39, 45, 35, 52,
    39,  3, 47, 26, 43, 33, 47, 56, 43,  1,  2, 26,  6, 35,  2,
    60,  6, 13, 14, 22, 10, 47, 14, 56, 10,  9, 18, 29, 23, 43,
    18, 59, 23, 10, 31, 30, 26, 40, 31, 63, 27, 14, 35, 21, 39,
    44, 35, 51, 39,  2, 47, 25, 43, 32, 47, 55, 43,  2,  2, 27,
     6, 36,  2, 61,  6, 14, 14, 23, 10, 47, 15, 57, 10, 10, 18,
    28, 23, 44, 18, 58, 23,  9, 31, 31, 26, 39, 31, 62, 27, 13,
    35, 20, 39, 43, 35, 50, 39,  1, 47, 24, 43, 32, 40, 54, 43,
     3,  2, 28,  6, 37,  2, 62,  6, 15, 14, 24, 10, 46, 15, 58,
    10, 11, 18, 27, 23, 45, 18, 57, 23,  8, 31, 31, 27, 38, 31,
    61, 27, 12, 35, 19, 39, 42, 35, 49, 39,  0, 47, 23, 43, 33,
    40, 53, 43,  4,  2, 29,  6, 38,  2, 63,  6, 15, 15, 25, 10,
    45, 15, 59, 10, 12, 18, 26, 23, 46, 18, 56, 23,  7, 31, 30,
    27, 37, 31, 60, 27, 11, 35, 18, 39, 41, 35, 48, 39,  0, 40,
    22, 43, 34, 40, 52, 43,  5,  2, 30,  6, 39,  2, 63,  7, 14,
    15, 26, 10, 44, 15, 60, 10, 13, 18, 25, 23, 47, 18, 55, 23,
     6, 31, 29, 27, 36, 31, 59, 27, 10, 35, 17, 39, 40, 35, 48,
    32,  1, 40, 21, 43, 35, 40, 51, 43,  6,  2, 31,  6, 40,  2,
    62,  7, 13, 15, 27, 10, 43, 15, 61, 10, 14, 18, 24, 23, 47,
    19, 54, 23,  5, 31, 28, 27, 35, 31, 58, 27,  9, 35, 16, 39,
    39, 35, 49, 32,  2, 40, 20, 43, 36, 40, 50, 43,  7,  2, 31,
     7, 41,  2, 61,  7, 12, 15, 28, 10, 42, 15, 62, 10, 15, 18,
    23, 23, 46, 19, 53, 23,  4, 31, 27, 27, 34, 31, 57, 27,  8,
    35, 16, 32, 38, 35, 50, 32,  3, 40, 19, 43, 37, 40, 49, 43,
     8,  2, 30,  7, 42,  2, 60,  7, 11, 15, 29, 10, 41, 15, 63,
    10, 15, 19, 22, 23, 45, 19, 52, 23,  3, 31, 26, 27, 33, 31,
    56, 27,  7, 35, 17, 32, 37, 35, 51, 32,  4, 40, 18, 43, 38,
    40, 48, 43,  9,  2, 29,  7, 43,  2, 59,  7, 10, 15, 30, 10,
    40, 15, 63, 11, 14, 19, 21, 23, 44, 19, 51, 23,  2, 31, 25,
    27, 32, 31, 55, 27,  6, 35, 18, 32, 36, 35, 52, 32,  5, 40,
    17, 43, 39, 40, 48, 44, 10,  2, 28,  7, 44,  2, 58,  7,  9,
    15, 31, 10, 39, 15, 62, 11, 13, 19, 20, 23, 43, 19, 50, 23,
     1, 31, 24, 27, 32, 24, 54, 27,  5, 35, 19, 32, 35, 35, 53,
    32,  6, 40, 16, 43, 40, 40, 49, 44, 11,  2, 27,  7, 45,  2,
    57,  7,  8, 15, 31, 11, 38, 15, 61, 11, 12, 19, 19, 23, 42,
    19, 49, 23,  0, 31, 23, 27, 33, 24, 53, 27,  4, 35, 20, 32,
    34, 35, 54, 32,  7, 40, 16, 44, 41, 40, 50, 44, 12,  2, 26,
     7, 46,  2, 56,  7,  7, 15, 30, 11, 37, 15, 60, 11, 11, 19,
    18, 23, 41, 19, 48, 23,  0, 24, 22, 27, 34, 24, 52, 27,  3,
    35, 21, 32, 33, 35, 55, 32,  8, 40, 17, 44, 42, 40, 51, 44,
    13,  2, 25,  7, 47,  2, 55,  7,  6, 15, 29, 11, 36, 15, 59,
    11, 10, 19, 17, 23, 40, 19, 48, 16,  1, 24, 21, 27, 35, 24,
    51, 27,  2, 35, 22, 32, 32, 35, 56, 32,  9, 40, 18, 44, 43,
    40, 52, 44, 14,  2, 24,  7, 47,  3, 54,  7,  5, 15, 28, 11,
    35, 15, 58, 11,  9, 19, 16, 23, 39, 19, 49, 16,  2, 24, 20,
    27, 36, 24, 50, 27,  1, 35, 23, 32, 32, 36, 57, 32, 10, 40,
    19, 44, 44, 40, 53, 44, 15,  2, 23,  7, 46,  3, 53,  7,  4,
    15, 27, 11, 34, 15, 57, 11,  8, 19, 16, 16, 38, 19, 50, 16,
     3, 24, 19, 27, 37, 24, 49, 27,  0, 35, 24, 32, 33, 36, 58,
    32, 11, 40, 20, 44, 45, 40, 54, 44, 15,  3, 22,  7, 45,  3,
    52,  7,  3, 15, 26, 11, 33, 15, 56, 11,  7, 19, 17, 16, 37,
    19, 51, 16,  4, 24, 18, 27, 38, 24, 48, 27,  0, 36, 25, 32,
    34, 36, 59, 32, 12, 40, 21, 44, 46, 40, 55, 44, 14,  3, 21,
     7, 44,  3, 51,  7,  2, 15, 25, 11, 32, 15, 55, 11,  6, 19,
    18, 16, 36, 19, 52, 16,  5, 24, 17, 27, 39, 24, 48, 28,  1,
    36, 26, 32, 35, 36, 60, 32, 13, 40, 22, 44, 47, 40, 56, 44,
    13,  3, 20,  7, 43,  3, 50,  7,  1, 15, 24, 11, 32,  8, 54,
    11,  5, 19, 19, 16, 35, 19, 53, 16,  6, 24, 16, 27, 40, 24,
    49, 28,  2, 36, 27, 32, 36, 36, 61, 32, 14, 40, 23, 44, 47,
    41, 57, 44, 12,  3, 19,  7, 42,  3, 49,  7,  0, 15, 23, 11,
    33,  8, 53, 11,  4, 19, 20, 16, 34, 19, 54, 16,  7, 24, 16,
    28, 41, 24, 50, 28,  3, 36, 28, 32, 37, 36, 62, 32, 15, 40,
    24, 44, 46, 41, 58, 44, 11,  3, 18,  7, 41,  3, 48,  7,  0,
     8, 22, 11, 34,  8, 52, 11,  3, 19, 21, 16, 33, 19, 55, 16,
     8, 24, 17, 28, 42, 24, 51, 28,  4, 36, 29, 32, 38, 36, 63,
    32, 15, 41, 25, 44, 45, 41, 59, 44, 10,  3, 17,  7, 40,  3,
    48,  0,  1,  8, 21, 11, 35,  8, 51, 11,  2, 19, 22, 16, 32,
    19, 56, 16,  9, 24, 18, 28, 43, 24, 52, 28,  5, 36, 30, 32,
    39, 36, 63, 33, 14, 41, 26, 44, 44, 41, 60, 44,  9,  3, 16,
     7, 39,  3, 49,  0,  2,  8, 20, 11, 36,  8, 50, 11,  1, 19,
    23, 16, 32, 20, 57, 16, 10, 24, 19, 28, 44, 24, 53, 28,  6,
    36, 31, 32, 40, 36, 62, 33, 13, 41, 27, 44, 43, 41, 61, 44,
     8,  3, 16,  0, 38,  3, 50,  0,  3,  8, 19, 11, 37,  8, 49,
    11,  0, 19, 24, 16, 33, 20, 58, 16, 11, 24, 20, 28, 45, 24,
    54, 28,  7, 36, 31, 33, 41, 36, 61, 33, 12, 41, 28, 44, 42,
    41, 62, 44,  7,  3, 17,  0, 37,  3, 51,  0,  4,  8, 18, 11,
    38,  8, 48, 11,  0, 20, 25, 16, 34, 20, 59, 16, 12, 24, 21,
    28, 46, 24, 55, 28,  8, 36, 30, 33, 42, 36, 60, 33, 11, 41,
    29, 44, 41, 41, 63, 44,  6,  3, 18,  0, 36,  3, 52,  0,  5,
     8, 17, 11, 39,  8, 48, 12,  1, 20, 26, 16, 35, 20, 60, 16,
    13, 24, 22, 28, 47, 24, 56, 28,  9, 36, 29, 33, 43, 36, 59,
    33, 10, 41, 30, 44, 40, 41, 63, 45,  5,  3, 19,  0, 35,  3,
    53,  0,  6,  8, 16, 11, 40,  8, 49, 12,  2, 20, 27, 16, 36,
    20, 61, 16, 14, 24, 23, 28, 47, 25, 57, 28, 10, 36, 28, 33,
    44, 36, 58, 33,  9, 41, 31, 44, 39, 41, 62, 45,  4,  3, 20,
     0, 34,  3, 54,  0,  7,  8, 16, 12, 41,  8, 50, 12,  3, 20,
    28, 16, 37, 20, 62, 16, 15, 24, 24, 28, 46, 25, 58, 28, 11,
    36, 27, 33, 45, 36, 57, 33,  8, 41, 31, 45, 38, 41, 61, 45,
     3,  3, 21,  0, 33,  3, 55,  0,  8,  8, 17, 12, 42,  8, 51,
    12,  4, 20, 29, 16, 38, 20, 63, 16, 15, 25, 25, 28, 45, 25,
    59, 28, 12, 36, 26, 33, 46, 36, 56, 33,  7, 41, 30, 45, 37,
    41, 60, 45,  2,  3, 22,  0, 32,  3, 56,  0,  9,  8, 18, 12,
    43,  8, 52, 12,  5, 20, 30, 16, 39, 20, 63, 17, 14, 25, 26,
    28, 44, 25, 60, 28, 13, 36, 25, 33, 47, 36, 55, 33,  6, 41,
    29, 45, 36, 41, 59, 45,  1,  3, 23,  0, 32,  4, 57,  0, 10,
     8, 19, 12, 44,  8, 53, 12,  6, 20, 31, 16, 40, 20, 62, 17,
    13, 25, 27, 28, 43, 25, 61, 28, 14, 36, 24, 33, 47, 37, 54,
    33,  5, 41, 28, 45, 35, 41, 58, 45,  0,  3, 24,  0, 33,  4,
    58,  0, 11,  8, 20, 12, 45,  8, 54, 12,  7, 20, 31, 17, 41,
    20, 61, 17, 12, 25, 28, 28, 42, 25, 62, 28, 15, 36, 23, 33,
    46, 37, 53, 33,  4, 41, 27, 45, 34, 41, 57, 45,  0,  4, 25,
     0, 34,  4, 59,  0, 12,  8, 21, 12, 46,  8, 55, 12,  8, 20,
    30, 17, 42, 20, 60, 17, 11, 25, 29, 28, 41, 25, 63, 28, 15,
    37, 22, 33, 45, 37, 52, 33,  3, 41, 26, 45, 33, 41, 56, 45,
     1,  4, 26,  0, 35,  4, 60,  0, 13,  8, 22, 12, 47,  8, 56,
    12,  9, 20, 29, 17, 43, 20, 59, 17, 10, 25, 30, 28, 40, 25,
    63, 29, 14, 37, 21, 33, 44, 37, 51, 33,  2, 41, 25, 45, 32,
    41, 55, 45,  2,  4, 27,  0, 36,  4, 61,  0, 14,  8, 23, 12,
    47,  9, 57, 12, 10, 20, 28, 17, 44, 20, 58, 17,  9, 25, 31,
    28, 39, 25, 62, 29, 13, 37, 20, 33, 43, 37, 50, 33,  1, 41,
    24, 45, 32, 42, 54, 45,  3,  4, 28,  0, 37,  4, 62,  0, 15,
     8, 24, 12, 46,  9, 58, 12, 11, 20, 27, 17, 45, 20, 57, 17,
     8, 25, 31, 29, 38, 25, 61, 29, 12, 37, 19, 33, 42, 37, 49,
    33,  0, 41, 23, 45, 33, 42, 53, 45,  4,  4, 29,  0, 38,  4,
    63,  0, 15,  9, 25, 12, 45,  9, 59, 12, 12, 20, 26, 17, 46,
    20, 56, 17,  7, 25, 30, 29, 37, 25, 60, 29, 11, 37, 18, 33,
    41, 37, 48, 33,  0, 42, 22, 45, 34, 42, 52, 45,  5,  4, 30,
     0, 39,  4, 63,  1, 14,  9, 26, 12, 44,  9, 60, 12, 13, 20,
    25, 17, 47, 20, 55, 17,  6, 25, 29, 29, 36, 25, 59, 29, 10,
    37, 17, 33, 40, 37, 48, 34,  1, 42, 21, 45, 35, 42, 51, 45,
     6,  4, 31,  0, 40,  4, 62,  1, 13,  9, 27, 12, 43,  9, 61,
    12, 14, 20, 24, 17, 47, 21, 54, 17,  5, 25, 28, 29, 35, 25,
    58, 29,  9, 37, 16, 33, 39, 37, 49, 34,  2, 42, 20, 45, 36,
    42, 50, 45,  7,  4, 31,  1, 41,  4, 61,  1, 12,  9, 28, 12,
    42,  9, 62, 12, 15, 20, 23, 17, 46, 21, 53, 17,  4, 25, 27,
    29, 34, 25, 57, 29,  8, 37, 16, 34, 38, 37, 50, 34,  3, 42,
    19, 45, 37, 42, 49, 45,  8,  4, 30,  1, 42,  4, 60,  1, 11,
     9, 29, 12, 41,  9, 63, 12, 15, 21, 22, 17, 45, 21, 52, 17,
     3, 25, 26, 29, 33, 25, 56, 29,  7, 37, 17, 34, 37, 37, 51,
    34,  4, 42, 18, 45, 38, 42, 48, 45,  9,  4, 29,  1, 43,  4,
    59,  1, 10,  9, 30, 12, 40,  9, 63, 13, 14, 21, 21, 17, 44,
    21, 51, 17,  2, 25, 25, 29, 32, 25, 55, 29,  6, 37, 18, 34,
    36, 37, 52, 34,  5, 42, 17, 45, 39, 42, 48, 46, 10,  4, 28,
     1, 44,  4, 58,  1,  9,  9, 31, 12, 39,  9, 62, 13, 13, 21,
    20, 17, 43, 21, 50, 17,  1, 25, 24, 29, 32, 26, 54, 29,  5,
    37, 19, 34, 35, 37, 53, 34,  6, 42, 16, 45, 40, 42, 49, 46,
    11,  4, 27,  1, 45,  4, 57,  1,  8,  9, 31, 13, 38,  9, 61,
    13, 12, 21, 19, 17, 42, 21, 49, 17,  0, 25, 23, 29, 33, 26,
    53, 29,  4, 37, 20, 34, 34, 37, 54, 34,  7, 42, 16, 46, 41,
    42, 50, 46, 12,  4, 26,  1, 46,  4, 56,  1,  7,  9, 30, 13,
    37,  9, 60, 13, 11, 21, 18, 17, 41, 21, 48, 17,  0, 26, 22,
    29, 34, 26, 52, 29,  3, 37, 21, 34, 33, 37, 55, 34,  8, 42,
    17, 46, 42, 42, 51, 46, 13,  4, 25,  1, 47,  4, 55,  1,  6,
     9, 29, 13, 36,  9, 59, 13, 10, 21, 17, 17, 40, 21, 48, 18,
     1, 26, 21, 29, 35, 26, 51, 29,  2, 37, 22, 34, 32, 37, 56,
    34,  9, 42, 18, 46, 43, 42, 52, 46, 14,  4, 24,  1, 47,  5,
    54,  1,  5,  9, 28, 13, 35,  9, 58, 13,  9, 21, 16, 17, 39,
    21, 49, 18,  2, 26, 20, 29, 36, 26, 50, 29,  1, 37, 23, 34,
    32, 38, 57, 34, 10, 42, 19, 46, 44, 42, 53, 46, 15,  4, 23,
     1, 46,  5, 53,  1,  4,  9, 27, 13, 34,  9, 57, 13,  8, 21,
    16, 18, 38, 21, 50, 18,  3, 26, 19, 29, 37, 26, 49, 29,  0,
    37, 24, 34, 33, 38, 58, 34, 11, 42, 20, 46, 45, 42, 54, 46,
    15,  5, 22,  1, 45,  5, 52,  1,  3,  9, 26, 13, 33,  9, 56,
    13,  7, 21, 17, 18, 37, 21, 51, 18,  4, 26, 18, 29, 38, 26,
    48, 29,  0, 38, 25, 34, 34, 38, 59, 34, 12, 42, 21, 46, 46,
    42, 55, 46, 14,  5, 21,  1, 44,  5, 51,  1,  2,  9, 25, 13,
    32,  9, 55, 13,  6, 21, 18, 18, 36, 21, 52, 18,  5, 26, 17,
    29, 39, 26, 48, 30,  1, 38, 26, 34, 35, 38, 60, 34, 13, 42,
    22, 46, 47, 42, 56, 46, 13,  5, 20,  1, 43,  5, 50,  1,  1,
     9, 24, 13, 32, 10, 54, 13,  5, 21, 19, 18, 35, 21, 53, 18,
     6, 26, 16, 29, 40, 26, 49, 30,  2, 38, 27, 34, 36, 38, 61,
    34, 14, 42, 23, 46, 47, 43, 57, 46, 12,  5, 19,  1, 42,  5,
    49,  1,  0,  9, 23, 13, 33, 10, 53, 13,  4, 21, 20, 18, 34,
    21, 54, 18,  7, 26, 16, 30, 41, 26, 50, 30,  3, 38, 28, 34,
    37, 38, 62, 34, 15, 42, 24, 46, 46, 43, 58, 46, 11,  5, 18,
     1, 41,  5, 48,  1,  0, 10, 22, 13, 34, 10, 52, 13,  3, 21,
    21, 18, 33, 21, 55, 18,  8, 26, 17, 30, 42, 26, 51, 30,  4,
    38, 29, 34, 38, 38, 63, 34, 15, 43, 25, 46, 45, 43, 59, 46,
    10,  5, 17,  1, 40,  5, 48,  2,  1, 10, 21, 13, 35, 10, 51,
    13,  2, 21, 22, 18, 32, 21, 56, 18,  9, 26, 18, 30, 43, 26,
    52, 30,  5, 38, 30, 34, 39, 38, 63, 35, 14, 43, 26, 46, 44,
    43, 60, 46,  9,  5, 16,  1, 39,  5, 49,  2,  2, 10, 20, 13,
    36, 10, 50, 13,  1, 21, 23, 18, 32, 22, 57, 18, 10, 26, 19,
    30, 44, 26, 53, 30,  6, 38, 31, 34, 40, 38, 62, 35, 13, 43,
    27, 46, 43, 43, 61, 46,  8,  5, 16,  2, 38,  5, 50,  2,  3,
    10, 19, 13, 37, 10, 49, 13,  0, 21, 24, 18, 33, 22, 58, 18,
    11, 26, 20, 30, 45, 26, 54, 30,  7, 38, 31, 35, 41, 38, 61,
    35, 12, 43, 28, 46, 42, 43, 62, 46,  7,  5, 17,  2, 37,  5,
    51,  2,  4, 10, 18, 13, 38, 10, 48, 13,  0, 22, 25, 18, 34,
    22, 59, 18, 12, 26, 21, 30, 46, 26, 55, 30,  8, 38, 30, 35,
    42, 38, 60, 35, 11, 43, 29, 46, 41, 43, 63, 46,  6,  5, 18,
     2, 36,  5, 52,  2,  5, 10, 17, 13, 39, 10, 48, 14,  1, 22,
    26, 18, 35, 22, 60, 18, 13, 26, 22, 30, 47, 26, 56, 30,  9,
    38, 29, 35, 43, 38, 59, 35, 10, 43, 30, 46, 40, 43, 63, 47,
     5,  5, 19,  2, 35,  5, 53,  2,  6, 10, 16, 13, 40, 10, 49,
    14,  2, 22, 27, 18, 36, 22, 61, 18, 14, 26, 23, 30, 47, 27,
    57, 30, 10, 38, 28, 35, 44, 38, 58, 35,  9, 43, 31, 46, 39,
    43, 62, 47,  4,  5, 20,  2, 34,  5, 54,  2,  7, 10, 16, 14,
    41, 10, 50, 14,  3, 22, 28, 18, 37, 22, 62, 18, 15, 26, 24,
    30, 46, 27, 58, 30, 11, 38, 27, 35, 45, 38, 57, 35,  8, 43,
    31, 47, 38, 43, 61, 47,  3,  5, 21,  2, 33,  5, 55,  2,  8,
    10, 17, 14, 42, 10, 51, 14,  4, 22, 29, 18, 38, 22, 63, 18,
    15, 27, 25, 30, 45, 27, 59, 30, 12, 38, 26, 35, 46, 38, 56,
    35,  7, 43, 30, 47, 37, 43, 60, 47,  2,  5, 22,  2, 32,  5,
    56,  2,  9, 10, 18, 14, 43, 10, 52, 14,  5, 22, 30, 18, 39,
    22, 63, 19, 14, 27, 26, 30, 44, 27, 60, 30, 13, 38, 25, 35,
    47, 38, 55, 35,  6, 43, 29, 47, 36, 43, 59, 47,  1,  5, 23,
     2, 32,  6, 57,  2, 10, 10, 19, 14, 44, 10, 53, 14,  6, 22,
    31, 18, 40, 22, 62, 19, 13, 27, 27, 30, 43, 27, 61, 30, 14,
    38, 24, 35, 47, 39, 54, 35,  5, 43, 28, 47, 35, 43, 58, 47,
     0,  5, 24,  2, 33,  6, 58,  2, 11, 10, 20, 14, 45, 10, 54,
    14,  7, 22, 31, 19, 41, 22, 61, 19, 12, 27, 28, 30, 42, 27,
    62, 30, 15, 38, 23, 35, 46, 39, 53, 35,  4, 43, 27, 47, 34,
    43, 57, 47,  0,  6, 25,  2, 34,  6, 59,  2, 12, 10, 21, 14,
    46, 10, 55, 14,  8, 22, 30, 19, 42, 22, 60, 19, 11, 27, 29,
    30, 41, 27, 63, 30, 15, 39, 22, 35, 45, 39, 52, 35,  3, 43,
    26, 47, 33, 43, 56, 47,  1,  6, 26,  2, 35,  6, 60,  2, 13,
    10, 22, 14, 47, 10, 56, 14,  9, 22, 29, 19, 43, 22, 59, 19,
    10, 27, 30, 30, 40, 27, 63, 31, 14, 39, 21, 35, 44, 39, 51,
    35,  2, 43, 25, 47, 32, 43, 55, 47,  2,  6, 27,  2, 36,  6,
    61,  2, 14, 10, 23, 14, 47, 11, 57, 14, 10, 22, 28, 19, 44,
    22, 58, 19,  9, 27, 31, 30, 39, 27, 62, 31, 13, 39, 20, 35,
    43, 39, 50, 35,  1, 43, 24, 47, 32, 44, 54, 47,  3,  6, 28,
     2, 37,  6, 62,  2, 15, 10, 24, 14, 46, 11, 58, 14, 11, 22,
    27, 19, 45, 22, 57, 19,  8, 27, 31, 31, 38, 27, 61, 31, 12,
    39, 19, 35, 42, 39, 49, 35,  0, 43, 23, 47, 33, 44, 53, 47,
     4,  6, 29,  2, 38,  6, 63,  2, 15, 11, 25, 14, 45, 11, 59,
    14, 12, 22, 26, 19, 46, 22, 56, 19,  7, 27, 30, 31, 37, 27,
    60, 31, 11, 39, 18, 35, 41, 39, 48, 35,  0, 44, 22, 47, 34,
    44, 52, 47,  5,  6, 30,  2, 39,  6, 63,  3, 14, 11, 26, 14,
    44, 11, 60, 14, 13, 22, 25, 19, 47, 22, 55, 19,  6, 27, 29,
    31, 36, 27, 59, 31, 10, 39, 17, 35, 40, 39, 48, 36,  1, 44,
    21, 47, 35, 44, 51, 47,  6,  6, 31,  2, 40,  6, 62,  3, 13,
    11, 27, 14, 43, 11, 61, 14, 14, 22, 24, 19, 47, 23, 54, 19,
     5, 27, 28, 31, 35, 27, 58, 31,  9, 39, 16, 35, 39, 39, 49,
    36,  2, 44, 20, 47, 36, 44, 50, 47,  7,  6, 31,  3, 41,  6,
    61,  3, 12, 11, 28, 14, 42, 11, 62, 14, 15, 22, 23, 19, 46,
    23, 53, 19,  4, 27, 27, 31, 34, 27, 57, 31,  8, 39, 16, 36,
    38, 39, 50, 36,  3, 44, 19, 47, 37, 44, 49, 47,  8,  6, 30,
     3, 42,  6, 60,  3, 11, 11, 29, 14, 41, 11, 63, 14, 15, 23,
    22, 19, 45, 23, 52, 19,  3, 27, 26, 31, 33, 27, 56, 31,  7,
    39, 17, 36, 37, 39, 51, 36,  4, 44, 18, 47, 38, 44, 48, 47,
     9,  6, 29,  3, 43,  6, 59,  3, 10, 11, 30, 14, 40, 11, 63,
    15, 14, 23, 21, 19, 44, 23, 51, 19,  2, 27, 25, 31, 32, 27,
    55, 31,  6, 39, 18, 36, 36, 39, 52, 36,  5, 44, 17, 47, 39,
    44, 48, 40, 10,  6, 28,  3, 44,  6, 58,  3,  9, 11, 31, 14,
    39, 11, 62, 15, 13, 23, 20, 19, 43, 23, 50, 19,  1, 27, 24,
    31, 32, 28, 54, 31,  5, 39, 19, 36, 35, 39, 53, 36,  6, 44,
    16, 47, 40, 44, 49, 40, 11,  6, 27,  3, 45,  6, 57,  3,  8,
    11, 31, 15, 38, 11, 61, 15, 12, 23, 19, 19, 42, 23, 49, 19,
     0, 27, 23, 31, 33, 28, 53, 31,  4, 39, 20, 36, 34, 39, 54,
    36,  7, 44, 16, 40, 41, 44, 50, 40, 12,  6, 26,  3, 46,  6,
    56,  3,  7, 11, 30, 15, 37, 11, 60, 15, 11, 23, 18, 19, 41,
    23, 48, 19,  0, 28, 22, 31, 34, 28, 52, 31,  3, 39, 21, 36,
    33, 39, 55, 36,  8, 44, 17, 40, 42, 44, 51, 40, 13,  6, 25,
     3, 47,  6, 55,  3,  6, 11, 29, 15, 36, 11, 59, 15, 10, 23,
    17, 19, 40, 23, 48, 20,  1, 28, 21, 31, 35, 28, 51, 31,  2,
    39, 22, 36, 32, 39, 56, 36,  9, 44, 18, 40, 43, 44, 52, 40,
    14,  6, 24,  3, 47,  7, 54,  3,  5, 11, 28, 15, 35, 11, 58,
    15,  9, 23, 16, 19, 39, 23, 49, 20,  2, 28, 20, 31, 36, 28,
    50, 31,  1, 39, 23, 36, 32, 32, 57, 36, 10, 44, 19, 40, 44,
    44, 53, 40, 15,  6, 23,  3, 46,  7, 53,  3,  4, 11, 27, 15,
    34, 11, 57, 15,  8, 23, 16, 20, 38, 23, 50, 20,  3, 28, 19,
    31, 37, 28, 49, 31,  0, 39, 24, 36, 33, 32, 58, 36, 11, 44,
    20, 40, 45, 44, 54, 40, 15,  7, 22,  3, 45,  7, 52,  3,  3,
    11, 26, 15, 33, 11, 56, 15,  7, 23, 17, 20, 37, 23, 51, 20,
     4, 28, 18, 31, 38, 28, 48, 31,  0, 32, 25, 36, 34, 32, 59,
    36, 12, 44, 21, 40, 46, 44, 55, 40, 14,  7, 21,  3, 44,  7,
    51,  3,  2, 11, 25, 15, 32, 11, 55, 15,  6, 23, 18, 20, 36,
    23, 52, 20,  5, 28, 17, 31, 39, 28, 48, 24,  1, 32, 26, 36,
    35, 32, 60, 36, 13, 44, 22, 40, 47, 44, 56, 40, 13,  7, 20,
     3, 43,  7, 50,  3,  1, 11, 24, 15, 32, 12, 54, 15,  5, 23,
    19, 20, 35, 23, 53, 20,  6, 28, 16, 31, 40, 28, 49, 24,  2,
    32, 27, 36, 36, 32, 61, 36, 14, 44, 23, 40, 47, 45, 57, 40,
    12,  7, 19,  3, 42,  7, 49,  3,  0, 11, 23, 15, 33, 12, 53,
    15,  4, 23, 20, 20, 34, 23, 54, 20,  7, 28, 16, 24, 41, 28,
    50, 24,  3, 32, 28, 36, 37, 32, 62, 36, 15, 44, 24, 40, 46,
    45, 58, 40, 11,  7, 18,  3, 41,  7, 48,  3,  0, 12, 22, 15,
    34, 12, 52, 15,  3, 23, 21, 20, 33, 23, 55, 20,  8, 28, 17,
    24, 42, 28, 51, 24,  4, 32, 29, 36, 38, 32, 63, 36, 15, 45,
    25, 40, 45, 45, 59, 40, 10,  7, 17,  3, 40,  7, 48,  4,  1,
    12, 21, 15, 35, 12, 51, 15,  2, 23, 22, 20, 32, 23, 56, 20,
     9, 28, 18, 24, 43, 28, 52, 24,  5, 32, 30, 36, 39, 32, 63,
    37, 14, 45, 26, 40, 44, 45, 60, 40,  9,  7, 16,  3, 39,  7,
    49,  4,  2, 12, 20, 15, 36, 12, 50, 15,  1, 23, 23, 20, 32,
    16, 57, 20, 10, 28, 19, 24, 44, 28, 53, 24,  6, 32, 31, 36,
    40, 32, 62, 37, 13, 45, 27, 40, 43, 45, 61, 40,  8,  7, 16,
     4, 38,  7, 50,  4,  3, 12, 19, 15, 37, 12, 49, 15,  0, 23,
    24, 20, 33, 16, 58, 20, 11, 28, 20, 24, 45, 28, 54, 24,  7,
    32, 31, 37, 41, 32, 61, 37, 12, 45, 28, 40, 42, 45, 62, 40,
     7,  7, 17,  4, 37,  7, 51,  4,  4, 12, 18, 15, 38, 12, 48,
    15,  0, 16, 25, 20, 34, 16, 59, 20, 12, 28, 21, 24, 46, 28,
    55, 24,  8, 32, 30, 37, 42, 32, 60, 37, 11, 45, 29, 40, 41,
    45, 63, 40,  6,  7, 18,  4, 36,  7, 52,  4,  5, 12, 17, 15,
    39, 12, 48,  8,  1, 16, 26, 20, 35, 16, 60, 20, 13, 28, 22,
    24, 47, 28, 56, 24,  9, 32, 29, 37, 43, 32, 59, 37, 10, 45,
    30, 40, 40, 45, 63, 41,  5,  7, 19,  4, 35,  7, 53,  4,  6,
    12, 16, 15, 40, 12, 49,  8,  2, 16, 27, 20, 36, 16, 61, 20,
    14, 28, 23, 24, 47, 29, 57, 24, 10, 32, 28, 37, 44, 32, 58,
    37,  9, 45, 31, 40, 39, 45, 62, 41,  4,  7, 20,  4, 34,  7,
    54,  4,  7, 12, 16,  8, 41, 12, 50,  8,  3, 16, 28, 20, 37,
    16, 62, 20, 15, 28, 24, 24, 46, 29, 58, 24, 11, 32, 27, 37,
    45, 32, 57, 37,  8, 45, 31, 41, 38, 45, 61, 41,  3,  7, 21,
     4, 33,  7, 55,  4,  8, 12, 17,  8, 42, 12, 51,  8,  4, 16,
    29, 20, 38, 16, 63, 20, 15, 29, 25, 24, 45, 29, 59, 24, 12,
    32, 26, 37, 46, 32, 56, 37,  7, 45, 30, 41, 37, 45, 60, 41,
     2,  7, 22,  4, 32,  7, 56,  4,  9, 12, 18,  8, 43, 12, 52,
     8,  5, 16, 30, 20, 39, 16, 63, 21, 14, 29, 26, 24, 44, 29,
    60, 24, 13, 32, 25, 37, 47, 32, 55, 37,  6, 45, 29, 41, 36,
    45, 59, 41,  1,  7, 23,  4, 32,  0, 57,  4, 10, 12, 19,  8,
    44, 12, 53,  8,  6, 16, 31, 20, 40, 16, 62, 21, 13, 29, 27,
    24, 43, 29, 61, 24, 14, 32, 24, 37, 47, 33, 54, 37,  5, 45,
    28, 41, 35, 45, 58, 41,  0,  7, 24,  4, 33,  0, 58,  4, 11,
    12, 20,  8, 45, 12, 54,  8,  7, 16, 31, 21, 41, 16, 61, 21,
    12, 29, 28, 24, 42, 29, 62, 24, 15, 32, 23, 37, 46, 33, 53,
    37,  4, 45, 27, 41, 34, 45, 57, 41,
};

static const uint8_t hq_tab_20[] = {
     0,  0, 15,  3, 24,  0, 35,  3,  1,  9, 16,  6, 22, 10, 40,
     6,  8, 12, 14, 16, 32, 12, 38, 16,  6, 22, 19, 19, 30, 22,
    39, 19,  5, 25, 21, 29, 25, 25, 41, 29,  1,  0, 14,  3, 25,
     0, 34,  3,  0,  9, 17,  6, 23, 10, 41,  6,  9, 12, 15, 16,
    32, 13, 39, 16,  7, 22, 18, 19, 31, 22, 38, 19,  4, 25, 20,
    29, 24, 25, 40, 29,  2,  0, 13,  3, 26,  0, 33,  3,  0, 10,
    18,  6, 24, 10, 42,  6, 10, 12, 16, 16, 31, 13, 40, 16,  8,
    22, 17, 19, 32, 22, 37, 19,  3, 25, 19, 29, 23, 25, 39, 29,
     3,  0, 12,  3, 27,  0, 33,  4,  1, 10, 19,  6, 25, 10, 43,
     6, 10, 13, 17, 16, 30, 13, 41, 16,  9, 22, 16, 19, 32, 23,
    36, 19,  2, 25, 18, 29, 22, 25, 38, 29,  4,  0, 11,  3, 28,
     0, 34,  4,  2, 10, 20,  6, 26, 10, 43,  7,  9, 13, 18, 16,
    29, 13, 42, 16, 10, 22, 15, 19, 31, 23, 35, 19,  1, 25, 17,
    29, 22, 26, 37, 29,  5,  0, 11,  4, 29,  0, 35,  4,  3, 10,
    21,  6, 27, 10, 42,  7,  8, 13, 19, 16, 28, 13, 43, 16, 10,
    23, 14, 19, 30, 23, 34, 19,  0, 25, 16, 29, 23, 26, 36, 29,
     6,  0, 12,  4, 30,  0, 36,  4,  4, 10, 21,  7, 28, 10, 41,
     7,  7, 13, 20, 16, 27, 13, 43, 17,  9, 23, 13, 19, 29, 23,
    33, 19,  0, 26, 15, 29, 24, 26, 35, 29,  7,  0, 13,  4, 31,
     0, 37,  4,  5, 10, 20,  7, 29, 10, 40,  7,  6, 13, 21, 16,
    26, 13, 42, 17,  8, 23, 12, 19, 28, 23, 33, 20,  1, 26, 14,
    29, 25, 26, 34, 29,  8,  0, 14,  4, 32,  0, 38,  4,  6, 10,
    19,  7, 30, 10, 39,  7,  5, 13, 21, 17, 25, 13, 41, 17,  7,
    23, 11, 19, 27, 23, 34, 20,  2, 26, 13, 29, 26, 26, 33, 29,
     9,  0, 15,  4, 32,  1, 39,  4,  7, 10, 18,  7, 31, 10, 38,
     7,  4, 13, 20, 17, 24, 13, 40, 17,  6, 23, 11, 20, 26, 23,
    35, 20,  3, 26, 12, 29, 27, 26, 33, 24, 10,  0, 16,  4, 31,
     1, 40,  4,  8, 10, 17,  7, 32, 10, 37,  7,  3, 13, 19, 17,
    23, 13, 39, 17,  5, 23, 12, 20, 25, 23, 36, 20,  4, 26, 11,
    29, 28, 26, 34, 24, 10,  1, 17,  4, 30,  1, 41,  4,  9, 10,
    16,  7, 32, 11, 36,  7,  2, 13, 18, 17, 22, 13, 38, 17,  4,
    23, 13, 20, 24, 23, 37, 20,  5, 26, 11, 24, 29, 26, 35, 24,
     9,  1, 18,  4, 29,  1, 42,  4, 10, 10, 15,  7, 31, 11, 35,
     7,  1, 13, 17, 17, 22, 14, 37, 17,  3, 23, 14, 20, 23, 23,
    38, 20,  6, 26, 12, 24, 30, 26, 36, 24,  8,  1, 19,  4, 28,
     1, 43,  4, 10, 11, 14,  7, 30, 11, 34,  7,  0, 13, 16, 17,
    23, 14, 36, 17,  2, 23, 15, 20, 22, 23, 39, 20,  7, 26, 13,
    24, 31, 26, 37, 24,  7,  1, 20,  4, 27,  1, 43,  5,  9, 11,
    13,  7, 29, 11, 33,  7,  0, 14, 15, 17, 24, 14, 35, 17,  1,
    23, 16, 20, 22, 18, 40, 20,  8, 26, 14, 24, 32, 26, 38, 24,
     6,  1, 21,  4, 26,  1, 42,  5,  8, 11, 12,  7, 28, 11, 33,
     8,  1, 14, 14, 17, 25, 14, 34, 17,  0, 23, 17, 20, 23, 18,
    41, 20,  9, 26, 15, 24, 32, 27, 39, 24,  5,  1, 21,  5, 25,
     1, 41,  5,  7, 11, 11,  7, 27, 11, 34,  8,  2, 14, 13, 17,
    26, 14, 33, 17,  0, 18, 18, 20, 24, 18, 42, 20, 10, 26, 16,
    24, 31, 27, 40, 24,  4,  1, 20,  5, 24,  1, 40,  5,  6, 11,
    11,  8, 26, 11, 35,  8,  3, 14, 12, 17, 27, 14, 33, 12,  1,
    18, 19, 20, 25, 18, 43, 20, 10, 27, 17, 24, 30, 27, 41, 24,
     3,  1, 19,  5, 23,  1, 39,  5,  5, 11, 12,  8, 25, 11, 36,
     8,  4, 14, 11, 17, 28, 14, 34, 12,  2, 18, 20, 20, 26, 18,
    43, 21,  9, 27, 18, 24, 29, 27, 42, 24,  2,  1, 18,  5, 22,
     1, 38,  5,  4, 11, 13,  8, 24, 11, 37,  8,  5, 14, 11, 12,
    29, 14, 35, 12,  3, 18, 21, 20, 27, 18, 42, 21,  8, 27, 19,
    24, 28, 27, 43, 24,  1,  1, 17,  5, 22,  2, 37,  5,  3, 11,
    14,  8, 23, 11, 38,  8,  6, 14, 12, 12, 30, 14, 36, 12,  4,
    18, 21, 21, 28, 18, 41, 21,  7, 27, 20, 24, 27, 27, 43, 25,
     0,  1, 16,  5, 23,  2, 36,  5,  2, 11, 15,  8, 22, 11, 39,
     8,  7, 14, 13, 12, 31, 14, 37, 12,  5, 18, 20, 21, 29, 18,
    40, 21,  6, 27, 21, 24, 26, 27, 42, 25,  0,  2, 15,  5, 24,
     2, 35,  5,  1, 11, 16,  8, 22,  6, 40,  8,  8, 14, 14, 12,
    32, 14, 38, 12,  6, 18, 19, 21, 30, 18, 39, 21,  5, 27, 21,
    25, 25, 27, 41, 25,  1,  2, 14,  5, 25,  2, 34,  5,  0, 11,
    17,  8, 23,  6, 41,  8,  9, 14, 15, 12, 32, 15, 39, 12,  7,
    18, 18, 21, 31, 18, 38, 21,  4, 27, 20, 25, 24, 27, 40, 25,
     2,  2, 13,  5, 26,  2, 33,  5,  0,  6, 18,  8, 24,  6, 42,
     8, 10, 14, 16, 12, 31, 15, 40, 12,  8, 18, 17, 21, 32, 18,
    37, 21,  3, 27, 19, 25, 23, 27, 39, 25,  3,  2, 12,  5, 27,
     2, 33,  0,  1,  6, 19,  8, 25,  6, 43,  8, 10, 15, 17, 12,
    30, 15, 41, 12,  9, 18, 16, 21, 32, 19, 36, 21,  2, 27, 18,
    25, 22, 27, 38, 25,  4,  2, 11,  5, 28,  2, 34,  0,  2,  6,
    20,  8, 26,  6, 43,  9,  9, 15, 18, 12, 29, 15, 42, 12, 10,
    18, 15, 21, 31, 19, 35, 21,  1, 27, 17, 25, 22, 28, 37, 25,
     5,  2, 11,  0, 29,  2, 35,  0,  3,  6, 21,  8, 27,  6, 42,
     9,  8, 15, 19, 12, 28, 15, 43, 12, 10, 19, 14, 21, 30, 19,
    34, 21,  0, 27, 16, 25, 23, 28, 36, 25,  6,  2, 12,  0, 30,
     2, 36,  0,  4,  6, 21,  9, 28,  6, 41,  9,  7, 15, 20, 12,
    27, 15, 43, 13,  9, 19, 13, 21, 29, 19, 33, 21,  0, 28, 15,
    25, 24, 28, 35, 25,  7,  2, 13,  0, 31,  2, 37,  0,  5,  6,
    20,  9, 29,  6, 40,  9,  6, 15, 21, 12, 26, 15, 42, 13,  8,
    19, 12, 21, 28, 19, 33, 22,  1, 28, 14, 25, 25, 28, 34, 25,
     8,  2, 14,  0, 32,  2, 38,  0,  6,  6, 19,  9, 30,  6, 39,
     9,  5, 15, 21, 13, 25, 15, 41, 13,  7, 19, 11, 21, 27, 19,
    34, 22,  2, 28, 13, 25, 26, 28, 33, 25,  9,  2, 15,  0, 32,
     3, 39,  0,  7,  6, 18,  9, 31,  6, 38,  9,  4, 15, 20, 13,
    24, 15, 40, 13,  6, 19, 11, 22, 26, 19, 35, 22,  3, 28, 12,
    25, 27, 28, 33, 26, 10,  2, 16,  0, 31,  3, 40,  0,  8,  6,
    17,  9, 32,  6, 37,  9,  3, 15, 19, 13, 23, 15, 39, 13,  5,
    19, 12, 22, 25, 19, 36, 22,  4, 28, 11, 25, 28, 28, 34, 26,
    10,  3, 17,  0, 30,  3, 41,  0,  9,  6, 16,  9, 32,  7, 36,
     9,  2, 15, 18, 13, 22, 15, 38, 13,  4, 19, 13, 22, 24, 19,
    37, 22,  5, 28, 11, 26, 29, 28, 35, 26,  9,  3, 18,  0, 29,
     3, 42,  0, 10,  6, 15,  9, 31,  7, 35,  9,  1, 15, 17, 13,
    22, 16, 37, 13,  3, 19, 14, 22, 23, 19, 38, 22,  6, 28, 12,
    26, 30, 28, 36, 26,  8,  3, 19,  0, 28,  3, 43,  0, 10,  7,
    14,  9, 30,  7, 34,  9,  0, 15, 16, 13, 23, 16, 36, 13,  2,
    19, 15, 22, 22, 19, 39, 22,  7, 28, 13, 26, 31, 28, 37, 26,
     7,  3, 20,  0, 27,  3, 43,  1,  9,  7, 13,  9, 29,  7, 33,
     9,  0, 16, 15, 13, 24, 16, 35, 13,  1, 19, 16, 22, 22, 20,
    40, 22,  8, 28, 14, 26, 32, 28, 38, 26,  6,  3, 21,  0, 26,
     3, 42,  1,  8,  7, 12,  9, 28,  7, 33, 10,  1, 16, 14, 13,
    25, 16, 34, 13,  0, 19, 17, 22, 23, 20, 41, 22,  9, 28, 15,
    26, 32, 29, 39, 26,  5,  3, 21,  1, 25,  3, 41,  1,  7,  7,
    11,  9, 27,  7, 34, 10,  2, 16, 13, 13, 26, 16, 33, 13,  0,
    20, 18, 22, 24, 20, 42, 22, 10, 28, 16, 26, 31, 29, 40, 26,
     4,  3, 20,  1, 24,  3, 40,  1,  6,  7, 11, 10, 26,  7, 35,
    10,  3, 16, 12, 13, 27, 16, 33, 14,  1, 20, 19, 22, 25, 20,
    43, 22, 10, 29, 17, 26, 30, 29, 41, 26,  3,  3, 19,  1, 23,
     3, 39,  1,  5,  7, 12, 10, 25,  7, 36, 10,  4, 16, 11, 13,
    28, 16, 34, 14,  2, 20, 20, 22, 26, 20, 43, 23,  9, 29, 18,
    26, 29, 29, 42, 26,  2,  3, 18,  1, 22,  3, 38,  1,  4,  7,
    13, 10, 24,  7, 37, 10,  5, 16, 11, 14, 29, 16, 35, 14,  3,
    20, 21, 22, 27, 20, 42, 23,  8, 29, 19, 26, 28, 29, 43, 26,
     1,  3, 17,  1, 22,  4, 37,  1,  3,  7, 14, 10, 23,  7, 38,
    10,  6, 16, 12, 14, 30, 16, 36, 14,  4, 20, 21, 23, 28, 20,
    41, 23,  7, 29, 20, 26, 27, 29, 43, 27,  0,  3, 16,  1, 23,
     4, 36,  1,  2,  7, 15, 10, 22,  7, 39, 10,  7, 16, 13, 14,
    31, 16, 37, 14,  5, 20, 20, 23, 29, 20, 40, 23,  6, 29, 21,
    26, 26, 29, 42, 27,  0,  4, 15,  1, 24,  4, 35,  1,  1,  7,
    16, 10, 22,  8, 40, 10,  8, 16, 14, 14, 32, 16, 38, 14,  6,
    20, 19, 23, 30, 20, 39, 23,  5, 29, 21, 27, 25, 29, 41, 27,
     1,  4, 14,  1, 25,  4, 34,  1,  0,  7, 17, 10, 23,  8, 41,
    10,  9, 16, 15, 14, 32, 17, 39, 14,  7, 20, 18, 23, 31, 20,
    38, 23,  4, 29, 20, 27, 24, 29, 40, 27,  2,  4, 13,  1, 26,
     4, 33,  1,  0,  8, 18, 10, 24,  8, 42, 10, 10, 16, 16, 14,
    31, 17, 40, 14,  8, 20, 17, 23, 32, 20, 37, 23,  3, 29, 19,
    27, 23, 29, 39, 27,  3,  4, 12,  1, 27,  4, 33,  2,  1,  8,
    19, 10, 25,  8, 43, 10, 10, 17, 17, 14, 30, 17, 41, 14,  9,
    20, 16, 23, 32, 21, 36, 23,  2, 29, 18, 27, 22, 29, 38, 27,
     4,  4, 11,  1, 28,  4, 34,  2,  2,  8, 20, 10, 26,  8, 43,
    11,  9, 17, 18, 14, 29, 17, 42, 14, 10, 20, 15, 23, 31, 21,
    35, 23,  1, 29, 17, 27, 22, 24, 37, 27,  5,  4, 11,  2, 29,
     4, 35,  2,  3,  8, 21, 10, 27,  8, 42, 11,  8, 17, 19, 14,
    28, 17, 43, 14, 10, 21, 14, 23, 30, 21, 34, 23,  0, 29, 16,
    27, 23, 24, 36, 27,  6,  4, 12,  2, 30,  4, 36,  2,  4,  8,
    21, 11, 28,  8, 41, 11,  7, 17, 20, 14, 27, 17, 43, 15,  9,
    21, 13, 23, 29, 21, 33, 23,  0, 24, 15, 27, 24, 24, 35, 27,
     7,  4, 13,  2, 31,  4, 37,  2,  5,  8, 20, 11, 29,  8, 40,
    11,  6, 17, 21, 14, 26, 17, 42, 15,  8, 21, 12, 23, 28, 21,
    33, 18,  1, 24, 14, 27, 25, 24, 34, 27,  8,  4, 14,  2, 32,
     4, 38,  2,  6,  8, 19, 11, 30,  8, 39, 11,  5, 17, 21, 15,
    25, 17, 41, 15,  7, 21, 11, 23, 27, 21, 34, 18,  2, 24, 13,
    27, 26, 24, 33, 27,  9,  4, 15,  2, 32,  5, 39,  2,  7,  8,
    18, 11, 31,  8, 38, 11,  4, 17, 20, 15, 24, 17, 40, 15,  6,
    21, 11, 18, 26, 21, 35, 18,  3, 24, 12, 27, 27, 24, 33, 28,
    10,  4, 16,  2, 31,  5, 40,  2,  8,  8, 17, 11, 32,  8, 37,
    11,  3, 17, 19, 15, 23, 17, 39, 15,  5, 21, 12, 18, 25, 21,
    36, 18,  4, 24, 11, 27, 28, 24, 34, 28, 10,  5, 17,  2, 30,
     5, 41,  2,  9,  8, 16, 11, 32,  9, 36, 11,  2, 17, 18, 15,
    22, 17, 38, 15,  4, 21, 13, 18, 24, 21, 37, 18,  5, 24, 11,
    28, 29, 24, 35, 28,  9,  5, 18,  2, 29,  5, 42,  2, 10,  8,
    15, 11, 31,  9, 35, 11,  1, 17, 17, 15, 22, 12, 37, 15,  3,
    21, 14, 18, 23, 21, 38, 18,  6, 24, 12, 28, 30, 24, 36, 28,
     8,  5, 19,  2, 28,  5, 43,  2, 10,  9, 14, 11, 30,  9, 34,
    11,  0, 17, 16, 15, 23, 12, 36, 15,  2, 21, 15, 18, 22, 21,
    39, 18,  7, 24, 13, 28, 31, 24, 37, 28,  7,  5, 20,  2, 27,
     5, 43,  3,  9,  9, 13, 11, 29,  9, 33, 11,  0, 12, 15, 15,
    24, 12, 35, 15,  1, 21, 16, 18, 22, 22, 40, 18,  8, 24, 14,
    28, 32, 24, 38, 28,  6,  5, 21,  2, 26,  5, 42,  3,  8,  9,
    12, 11, 28,  9, 33,  6,  1, 12, 14, 15, 25, 12, 34, 15,  0,
    21, 17, 18, 23, 22, 41, 18,  9, 24, 15, 28, 32, 25, 39, 28,
     5,  5, 21,  3, 25,  5, 41,  3,  7,  9, 11, 11, 27,  9, 34,
     6,  2, 12, 13, 15, 26, 12, 33, 15,  0, 22, 18, 18, 24, 22,
    42, 18, 10, 24, 16, 28, 31, 25, 40, 28,  4,  5, 20,  3, 24,
     5, 40,  3,  6,  9, 11,  6, 26,  9, 35,  6,  3, 12, 12, 15,
    27, 12, 33, 16,  1, 22, 19, 18, 25, 22, 43, 18, 10, 25, 17,
    28, 30, 25, 41, 28,  3,  5, 19,  3, 23,  5, 39,  3,  5,  9,
    12,  6, 25,  9, 36,  6,  4, 12, 11, 15, 28, 12, 34, 16,  2,
    22, 20, 18, 26, 22, 43, 19,  9, 25, 18, 28, 29, 25, 42, 28,
     2,  5, 18,  3, 22,  5, 38,  3,  4,  9, 13,  6, 24,  9, 37,
     6,  5, 12, 11, 16, 29, 12, 35, 16,  3, 22, 21, 18, 27, 22,
    42, 19,  8, 25, 19, 28, 28, 25, 43, 28,  1,  5, 17,  3, 22,
     0, 37,  3,  3,  9, 14,  6, 23,  9, 38,  6,  6, 12, 12, 16,
    30, 12, 36, 16,  4, 22, 21, 19, 28, 22, 41, 19,  7, 25, 20,
    28, 27, 25, 43, 29,  0,  5, 16,  3, 23,  0, 36,  3,  2,  9,
    15,  6, 22,  9, 39,  6,  7, 12, 13, 16, 31, 12, 37, 16,  5,
    22, 20, 19, 29, 22, 40, 19,  6, 25, 21, 28, 26, 25, 42, 29,
};

static const uint8_t hq_tab_21[] = {
     0,  0, 15,  3, 24,  0, 35,  3,  1,  9, 16,  6, 22, 10, 40,
     6,  8, 12, 14, 16, 32, 12, 38, 16,  6, 22, 19, 19, 30, 22,
    39, 19,  5, 25, 21, 29, 25, 25, 41, 29,  7, 35, 11, 31, 27,
    35, 34, 32,  1,  0, 14,  3, 25,  0, 34,  3,  0,  9, 17,  6,
    23, 10, 41,  6,  9, 12, 15, 16, 32, 13, 39, 16,  7, 22, 18,
    19, 31, 22, 38, 19,  4, 25, 20, 29, 24, 25, 40, 29,  6, 35,
    11, 32, 26, 35, 35, 32,  2,  0, 13,  3, 26,  0, 33,  3,  0,
    10, 18,  6, 24, 10, 42,  6, 10, 12, 16, 16, 31, 13, 40, 16,
     8, 22, 17, 19, 32, 22, 37, 19,  3, 25, 19, 29, 23, 25, 39,
    29,  5, 35, 12, 32, 25, 35, 36, 32,  3,  0, 12,  3, 27,  0,
    33,  4,  1, 10, 19,  6, 25, 10, 43,  6, 10, 13, 17, 16, 30,
    13, 41, 16,  9, 22, 16, 19, 32, 23, 36, 19,  2, 25, 18, 29,
    22, 25, 38, 29,  4, 35, 13, 32, 24, 35, 37, 32,  4,  0, 11,
     3, 28,  0, 34,  4,  2, 10, 20,  6, 26, 10, 43,  7,  9, 13,
    18, 16, 29, 13, 42, 16, 10, 22, 15, 19, 31, 23, 35, 19,  1,
    25, 17, 29, 22, 26, 37, 29,  3, 35, 14, 32, 23, 35, 38, 32,
     5,  0, 11,  4, 29,  0, 35,  4,  3, 10, 21,  6, 27, 10, 42,
     7,  8, 13, 19, 16, 28, 13, 43, 16, 10, 23, 14, 19, 30, 23,
    34, 19,  0, 25, 16, 29, 23, 26, 36, 29,  2, 35, 15, 32, 22,
    35, 39, 32,  6,  0, 12,  4, 30,  0, 36,  4,  4, 10, 21,  7,
    28, 10, 41,  7,  7, 13, 20, 16, 27, 13, 43, 17,  9, 23, 13,
    19, 29, 23, 33, 19,  0, 26, 15, 29, 24, 26, 35, 29,  1, 35,
    16, 32, 22, 30, 40, 32,  7,  0, 13,  4, 31,  0, 37,  4,  5,
    10, 20,  7, 29, 10, 40,  7,  6, 13, 21, 16, 26, 13, 42, 17,
     8, 23, 12, 19, 28, 23, 33, 20,  1, 26, 14, 29, 25, 26, 34,
    29,  0, 35, 17, 32, 23, 30, 41, 32,  8,  0, 14,  4, 32,  0,
    38,  4,  6, 10, 19,  7, 30, 10, 39,  7,  5, 13, 21, 17, 25,
    13, 41, 17,  7, 23, 11, 19, 27, 23, 34, 20,  2, 26, 13, 29,
    26, 26, 33, 29,  0, 30, 18, 32, 24, 30, 42, 32,  9,  0, 15,
     4, 32,  1, 39,  4,  7, 10, 18,  7, 31, 10, 38,  7,  4, 13,
    20, 17, 24, 13, 40, 17,  6, 23, 11, 20, 26, 23, 35, 20,  3,
    26, 12, 29, 27, 26, 33, 24,  1, 30, 19, 32, 25, 30, 43, 32,
    10,  0, 16,  4, 31,  1, 40,  4,  8, 10, 17,  7, 32, 10, 37,
     7,  3, 13, 19, 17, 23, 13, 39, 17,  5, 23, 12, 20, 25, 23,
    36, 20,  4, 26, 11, 29, 28, 26, 34, 24,  2, 30, 20, 32, 26,
    30, 43, 33, 10,  1, 17,  4, 30,  1, 41,  4,  9, 10, 16,  7,
    32, 11, 36,  7,  2, 13, 18, 17, 22, 13, 38, 17,  4, 23, 13,
    20, 24, 23, 37, 20,  5, 26, 11, 24, 29, 26, 35, 24,  3, 30,
    21, 32, 27, 30, 42, 33,  9,  1, 18,  4, 29,  1, 42,  4, 10,
    10, 15,  7, 31, 11, 35,  7,  1, 13, 17, 17, 22, 14, 37, 17,
     3, 23, 14, 20, 23, 23, 38, 20,  6, 26, 12, 24, 30, 26, 36,
    24,  4, 30, 21, 33, 28, 30, 41, 33,  8,  1, 19,  4, 28,  1,
    43,  4, 10, 11, 14,  7, 30, 11, 34,  7,  0, 13, 16, 17, 23,
    14, 36, 17,  2, 23, 15, 20, 22, 23, 39, 20,  7, 26, 13, 24,
    31, 26, 37, 24,  5, 30, 20, 33, 29, 30, 40, 33,  7,  1, 20,
     4, 27,  1, 43,  5,  9, 11, 13,  7, 29, 11, 33,  7,  0, 14,
    15, 17, 24, 14, 35, 17,  1, 23, 16, 20, 22, 18, 40, 20,  8,
    26, 14, 24, 32, 26, 38, 24,  6, 30, 19, 33, 30, 30, 39, 33,
     6,  1, 21,  4, 26,  1, 42,  5,  8, 11, 12,  7, 28, 11, 33,
     8,  1, 14, 14, 17, 25, 14, 34, 17,  0, 23, 17, 20, 23, 18,
    41, 20,  9, 26, 15, 24, 32, 27, 39, 24,  7, 30, 18, 33, 31,
    30, 38, 33,  5,  1, 21,  5, 25,  1, 41,  5,  7, 11, 11,  7,
    27, 11, 34,  8,  2, 14, 13, 17, 26, 14, 33, 17,  0, 18, 18,
    20, 24, 18, 42, 20, 10, 26, 16, 24, 31, 27, 40, 24,  8, 30,
    17, 33, 32, 30, 37, 33,  4,  1, 20,  5, 24,  1, 40,  5,  6,
    11, 11,  8, 26, 11, 35,  8,  3, 14, 12, 17, 27, 14, 33, 12,
     1, 18, 19, 20, 25, 18, 43, 20, 10, 27, 17, 24, 30, 27, 41,
    24,  9, 30, 16, 33, 32, 31, 36, 33,  3,  1, 19,  5, 23,  1,
    39,  5,  5, 11, 12,  8, 25, 11, 36,  8,  4, 14, 11, 17, 28,
    14, 34, 12,  2, 18, 20, 20, 26, 18, 43, 21,  9, 27, 18, 24,
    29, 27, 42, 24, 10, 30, 15, 33, 31, 31, 35, 33,  2,  1, 18,
     5, 22,  1, 38,  5,  4, 11, 13,  8, 24, 11, 37,  8,  5, 14,
    11, 12, 29, 14, 35, 12,  3, 18, 21, 20, 27, 18, 42, 21,  8,
    27, 19, 24, 28, 27, 43, 24, 10, 31, 14, 33, 30, 31, 34, 33,
     1,  1, 17,  5, 22,  2, 37,  5,  3, 11, 14,  8, 23, 11, 38,
     8,  6, 14, 12, 12, 30, 14, 36, 12,  4, 18, 21, 21, 28, 18,
    41, 21,  7, 27, 20, 24, 27, 27, 43, 25,  9, 31, 13, 33, 29,
    31, 33, 33,  0,  1, 16,  5, 23,  2, 36,  5,  2, 11, 15,  8,
    22, 11, 39,  8,  7, 14, 13, 12, 31, 14, 37, 12,  5, 18, 20,
    21, 29, 18, 40, 21,  6, 27, 21, 24, 26, 27, 42, 25,  8, 31,
    12, 33, 28, 31, 33, 34,  0,  2, 15,  5, 24,  2, 35,  5,  1,
    11, 16,  8, 22,  6, 40,  8,  8, 14, 14, 12, 32, 14, 38, 12,
     6, 18, 19, 21, 30, 18, 39, 21,  5, 27, 21, 25, 25, 27, 41,
    25,  7, 31, 11, 33, 27, 31, 34, 34,  1,  2, 14,  5, 25,  2,
    34,  5,  0, 11, 17,  8, 23,  6, 41,  8,  9, 14, 15, 12, 32,
    15, 39, 12,  7, 18, 18, 21, 31, 18, 38, 21,  4, 27, 20, 25,
    24, 27, 40, 25,  6, 31, 11, 34, 26, 31, 35, 34,  2,  2, 13,
     5, 26,  2, 33,  5,  0,  6, 18,  8, 24,  6, 42,  8, 10, 14,
    16, 12, 31, 15, 40, 12,  8, 18, 17, 21, 32, 18, 37, 21,  3,
    27, 19, 25, 23, 27, 39, 25,  5, 31, 12, 34, 25, 31, 36, 34,
     3,  2, 12,  5, 27,  2, 33,  0,  1,  6, 19,  8, 25,  6, 43,
     8, 10, 15, 17, 12, 30, 15, 41, 12,  9, 18, 16, 21, 32, 19,
    36, 21,  2, 27, 18, 25, 22, 27, 38, 25,  4, 31, 13, 34, 24,
    31, 37, 34,  4,  2, 11,  5, 28,  2, 34,  0,  2,  6, 20,  8,
    26,  6, 43,  9,  9, 15, 18, 12, 29, 15, 42, 12, 10, 18, 15,
    21, 31, 19, 35, 21,  1, 27, 17, 25, 22, 28, 37, 25,  3, 31,
    14, 34, 23, 31, 38, 34,  5,  2, 11,  0, 29,  2, 35,  0,  3,
     6, 21,  8, 27,  6, 42,  9,  8, 15, 19, 12, 28, 15, 43, 12,
    10, 19, 14, 21, 30, 19, 34, 21,  0, 27, 16, 25, 23, 28, 36,
    25,  2, 31, 15, 34, 22, 31, 39, 34,  6,  2, 12,  0, 30,  2,
    36,  0,  4,  6, 21,  9, 28,  6, 41,  9,  7, 15, 20, 12, 27,
    15, 43, 13,  9, 19, 13, 21, 29, 19, 33, 21,  0, 28, 15, 25,
    24, 28, 35, 25,  1, 31, 16, 34, 22, 32, 40, 34,  7,  2, 13,
     0, 31,  2, 37,  0,  5,  6, 20,  9, 29,  6, 40,  9,  6, 15,
    21, 12, 26, 15, 42, 13,  8, 19, 12, 21, 28, 19, 33, 22,  1,
    28, 14, 25, 25, 28, 34, 25,  0, 31, 17, 34, 23, 32, 41, 34,
     8,  2, 14,  0, 32,  2, 38,  0,  6,  6, 19,  9, 30,  6, 39,
     9,  5, 15, 21, 13, 25, 15, 41, 13,  7, 19, 11, 21, 27, 19,
    34, 22,  2, 28, 13, 25, 26, 28, 33, 25,  0, 32, 18, 34, 24,
    32, 42, 34,  9,  2, 15,  0, 32,  3, 39,  0,  7,  6, 18,  9,
    31,  6, 38,  9,  4, 15, 20, 13, 24, 15, 40, 13,  6, 19, 11,
    22, 26, 19, 35, 22,  3, 28, 12, 25, 27, 28, 33, 26,  1, 32,
    19, 34, 25, 32, 43, 34, 10,  2, 16,  0, 31,  3, 40,  0,  8,
     6, 17,  9, 32,  6, 37,  9,  3, 15, 19, 13, 23, 15, 39, 13,
     5, 19, 12, 22, 25, 19, 36, 22,  4, 28, 11, 25, 28, 28, 34,
    26,  2, 32, 20, 34, 26, 32, 43, 35, 10,  3, 17,  0, 30,  3,
    41,  0,  9,  6, 16,  9, 32,  7, 36,  9,  2, 15, 18, 13, 22,
    15, 38, 13,  4, 19, 13, 22, 24, 19, 37, 22,  5, 28, 11, 26,
    29, 28, 35, 26,  3, 32, 21, 34, 27, 32, 42, 35,  9,  3, 18,
     0, 29,  3, 42,  0, 10,  6, 15,  9, 31,  7, 35,  9,  1, 15,
    17, 13, 22, 16, 37, 13,  3, 19, 14, 22, 23, 19, 38, 22,  6,
    28, 12, 26, 30, 28, 36, 26,  4, 32, 21, 35, 28, 32, 41, 35,
     8,  3, 19,  0, 28,  3, 43,  0, 10,  7, 14,  9, 30,  7, 34,
     9,  0, 15, 16, 13, 23, 16, 36, 13,  2, 19, 15, 22, 22, 19,
    39, 22,  7, 28, 13, 26, 31, 28, 37, 26,  5, 32, 20, 35, 29,
    32, 40, 35,  7,  3, 20,  0, 27,  3, 43,  1,  9,  7, 13,  9,
    29,  7, 33,  9,  0, 16, 15, 13, 24, 16, 35, 13,  1, 19, 16,
    22, 22, 20, 40, 22,  8, 28, 14, 26, 32, 28, 38, 26,  6, 32,
    19, 35, 30, 32, 39, 35,  6,  3, 21,  0, 26,  3, 42,  1,  8,
     7, 12,  9, 28,  7, 33, 10,  1, 16, 14, 13, 25, 16, 34, 13,
     0, 19, 17, 22, 23, 20, 41, 22,  9, 28, 15, 26, 32, 29, 39,
    26,  7, 32, 18, 35, 31, 32, 38, 35,  5,  3, 21,  1, 25,  3,
    41,  1,  7,  7, 11,  9, 27,  7, 34, 10,  2, 16, 13, 13, 26,
    16, 33, 13,  0, 20, 18, 22, 24, 20, 42, 22, 10, 28, 16, 26,
    31, 29, 40, 26,  8, 32, 17, 35, 32, 32, 37, 35,  4,  3, 20,
     1, 24,  3, 40,  1,  6,  7, 11, 10, 26,  7, 35, 10,  3, 16,
    12, 13, 27, 16, 33, 14,  1, 20, 19, 22, 25, 20, 43, 22, 10,
    29, 17, 26, 30, 29, 41, 26,  9, 32, 16, 35, 32, 33, 36, 35,
     3,  3, 19,  1, 23,  3, 39,  1,  5,  7, 12, 10, 25,  7, 36,
    10,  4, 16, 11, 13, 28, 16, 34, 14,  2, 20, 20, 22, 26, 20,
    43, 23,  9, 29, 18, 26, 29, 29, 42, 26, 10, 32, 15, 35, 31,
    33, 35, 35,  2,  3, 18,  1, 22,  3, 38,  1,  4,  7, 13, 10,
    24,  7, 37, 10,  5, 16, 11, 14, 29, 16, 35, 14,  3, 20, 21,
    22, 27, 20, 42, 23,  8, 29, 19, 26, 28, 29, 43, 26, 10, 33,
    14, 35, 30, 33, 34, 35,  1,  3, 17,  1, 22,  4, 37,  1,  3,
     7, 14, 10, 23,  7, 38, 10,  6, 16, 12, 14, 30, 16, 36, 14,
     4, 20, 21, 23, 28, 20, 41, 23,  7, 29, 20, 26, 27, 29, 43,
    27,  9, 33, 13, 35, 29, 33, 33, 35,  0,  3, 16,  1, 23,  4,
    36,  1,  2,  7, 15, 10, 22,  7, 39, 10,  7, 16, 13, 14, 31,
    16, 37, 14,  5, 20, 20, 23, 29, 20, 40, 23,  6, 29, 21, 26,
    26, 29, 42, 27,  8, 33, 12, 35, 28, 33, 33, 30,  0,  4, 15,
     1, 24,  4, 35,  1,  1,  7, 16, 10, 22,  8, 40, 10,  8, 16,
    14, 14, 32, 16, 38, 14,  6, 20, 19, 23, 30, 20, 39, 23,  5,
    29, 21, 27, 25, 29, 41, 27,  7, 33, 11, 35, 27, 33, 34, 30,
     1,  4, 14,  1, 25,  4, 34,  1,  0,  7, 17, 10, 23,  8, 41,
    10,  9, 16, 15, 14, 32, 17, 39, 14,  7, 20, 18, 23, 31, 20,
    38, 23,  4, 29, 20, 27, 24, 29, 40, 27,  6, 33, 11, 30, 26,
    33, 35, 30,  2,  4, 13,  1, 26,  4, 33,  1,  0,  8, 18, 10,
    24,  8, 42, 10, 10, 16, 16, 14, 31, 17, 40, 14,  8, 20, 17,
    23, 32, 20, 37, 23,  3, 29, 19, 27, 23, 29, 39, 27,  5, 33,
    12, 30, 25, 33, 36, 30,  3,  4, 12,  1, 27,  4, 33,  2,  1,
     8, 19, 10, 25,  8, 43, 10, 10, 17, 17, 14, 30, 17, 41, 14,
     9, 20, 16, 23, 32, 21, 36, 23,  2, 29, 18, 27, 22, 29, 38,
    27,  4, 33, 13, 30, 24, 33, 37, 30,  4,  4, 11,  1, 28,  4,
    34,  2,  2,  8, 20, 10, 26,  8, 43, 11,  9, 17, 18, 14, 29,
    17, 42, 14, 10, 20, 15, 23, 31, 21, 35, 23,  1, 29, 17, 27,
    22, 24, 37, 27,  3, 33, 14, 30, 23, 33, 38, 30,  5,  4, 11,
     2, 29,  4, 35,  2,  3,  8, 21, 10, 27,  8, 42, 11,  8, 17,
    19, 14, 28, 17, 43, 14, 10, 21, 14, 23, 30, 21, 34, 23,  0,
    29, 16, 27, 23, 24, 36, 27,  2, 33, 15, 30, 22, 33, 39, 30,
     6,  4, 12,  2, 30,  4, 36,  2,  4,  8, 21, 11, 28,  8, 41,
    11,  7, 17, 20, 14, 27, 17, 43, 15,  9, 21, 13, 23, 29, 21,
    33, 23,  0, 24, 15, 27, 24, 24, 35, 27,  1, 33, 16, 30, 22,
    34, 40, 30,  7,  4, 13,  2, 31,  4, 37,  2,  5,  8, 20, 11,
    29,  8, 40, 11,  6, 17, 21, 14, 26, 17, 42, 15,  8, 21, 12,
    23, 28, 21, 33, 18,  1, 24, 14, 27, 25, 24, 34, 27,  0, 33,
    17, 30, 23, 34, 41, 30,  8,  4, 14,  2, 32,  4, 38,  2,  6,
     8, 19, 11, 30,  8, 39, 11,  5, 17, 21, 15, 25, 17, 41, 15,
     7, 21, 11, 23, 27, 21, 34, 18,  2, 24, 13, 27, 26, 24, 33,
    27,  0, 34, 18, 30, 24, 34, 42, 30,  9,  4, 15,  2, 32,  5,
    39,  2,  7,  8, 18, 11, 31,  8, 38, 11,  4, 17, 20, 15, 24,
    17, 40, 15,  6, 21, 11, 18, 26, 21, 35, 18,  3, 24, 12, 27,
    27, 24, 33, 28,  1, 34, 19, 30, 25, 34, 43, 30, 10,  4, 16,
     2, 31,  5, 40,  2,  8,  8, 17, 11, 32,  8, 37, 11,  3, 17,
    19, 15, 23, 17, 39, 15,  5, 21, 12, 18, 25, 21, 36, 18,  4,
    24, 11, 27, 28, 24, 34, 28,  2, 34, 20, 30, 26, 34, 43, 31,
    10,  5, 17,  2, 30,  5, 41,  2,  9,  8, 16, 11, 32,  9, 36,
    11,  2, 17, 18, 15, 22, 17, 38, 15,  4, 21, 13, 18, 24, 21,
    37, 18,  5, 24, 11, 28, 29, 24, 35, 28,  3, 34, 21, 30, 27,
    34, 42, 31,  9,  5, 18,  2, 29,  5, 42,  2, 10,  8, 15, 11,
    31,  9, 35, 11,  1, 17, 17, 15, 22, 12, 37, 15,  3, 21, 14,
    18, 23, 21, 38, 18,  6, 24, 12, 28, 30, 24, 36, 28,  4, 34,
    21, 31, 28, 34, 41, 31,  8,  5, 19,  2, 28,  5, 43,  2, 10,
     9, 14, 11, 30,  9, 34, 11,  0, 17, 16, 15, 23, 12, 36, 15,
     2, 21, 15, 18, 22, 21, 39, 18,  7, 24, 13, 28, 31, 24, 37,
    28,  5, 34, 20, 31, 29, 34, 40, 31,  7,  5, 20,  2, 27,  5,
    43,  3,  9,  9, 13, 11, 29,  9, 33, 11,  0, 12, 15, 15, 24,
    12, 35, 15,  1, 21, 16, 18, 22, 22, 40, 18,  8, 24, 14, 28,
    32, 24, 38, 28,  6, 34, 19, 31, 30, 34, 39, 31,  6,  5, 21,
     2, 26,  5, 42,  3,  8,  9, 12, 11, 28,  9, 33,  6,  1, 12,
    14, 15, 25, 12, 34, 15,  0, 21, 17, 18, 23, 22, 41, 18,  9,
    24, 15, 28, 32, 25, 39, 28,  7, 34, 18, 31, 31, 34, 38, 31,
     5,  5, 21,  3, 25,  5, 41,  3,  7,  9, 11, 11, 27,  9, 34,
     6,  2, 12, 13, 15, 26, 12, 33, 15,  0, 22, 18, 18, 24, 22,
    42, 18, 10, 24, 16, 28, 31, 25, 40, 28,  8, 34, 17, 31, 32,
    34, 37, 31,  4,  5, 20,  3, 24,  5, 40,  3,  6,  9, 11,  6,
    26,  9, 35,  6,  3, 12, 12, 15, 27, 12, 33, 16,  1, 22, 19,
    18, 25, 22, 43, 18, 10, 25, 17, 28, 30, 25, 41, 28,  9, 34,
    16, 31, 32, 35, 36, 31,  3,  5, 19,  3, 23,  5, 39,  3,  5,
     9, 12,  6, 25,  9, 36,  6,  4, 12, 11, 15, 28, 12, 34, 16,
     2, 22, 20, 18, 26, 22, 43, 19,  9, 25, 18, 28, 29, 25, 42,
    28, 10, 34, 15, 31, 31, 35, 35, 31,  2,  5, 18,  3, 22,  5,
    38,  3,  4,  9, 13,  6, 24,  9, 37,  6,  5, 12, 11, 16, 29,
    12, 35, 16,  3, 22, 21, 18, 27, 22, 42, 19,  8, 25, 19, 28,
    28, 25, 43, 28, 10, 35, 14, 31, 30, 35, 34, 31,  1,  5, 17,
     3, 22,  0, 37,  3,  3,  9, 14,  6, 23,  9, 38,  6,  6, 12,
    12, 16, 30, 12, 36, 16,  4, 22, 21, 19, 28, 22, 41, 19,  7,
    25, 20, 28, 27, 25, 43, 29,  9, 35, 13, 31, 29, 35, 33, 31,
     0,  5, 16,  3, 23,  0, 36,  3,  2,  9, 15,  6, 22,  9, 39,
     6,  7, 12, 13, 16, 31, 12, 37, 16,  5, 22, 20, 19, 29, 22,
    40, 19,  6, 25, 21, 28, 26, 25, 42, 29,  8, 35, 12, 31, 28,
    35, 33, 32,
};

/* List of profiles, order is important */
const HQProfile ff_hq_profile[NUM_HQ_PROFILES] = {
    { hq_tab_11,  160,  120,  8, 10,   8 }, // case 0 (default) = case 11
    { hq_tab_01,  720,  480,  8, 25,  54 },
    { hq_tab_02,  720,  486,  8, 15,  93 },
    { hq_tab_03,  720,  576,  8, 20,  81 },
    { hq_tab_04,  960,  720, 12, 25, 108 },
    { hq_tab_05, 1280,  720, 16, 25, 144 },
    { hq_tab_06, 1280, 1080, 16, 20, 272 },
    { hq_tab_07, 1440, 1080, 16, 24, 255 },
    { hq_tab_08, 1920, 1080, 20, 24, 340 },
    { hq_tab_09,  640,  480,  8, 25,  48 },
    { hq_tab_10,  320,  240,  8, 25,  12 },
    { hq_tab_11,  160,  120,  8, 10,   8 },
    { hq_tab_12,  800,  600,  8, 25,  76 },
    { hq_tab_13,  352,  480,  8, 20,  33 },
    { hq_tab_14,  352,  240,  8, 22,  15 },
    { hq_tab_15,  352,  288,  8, 18,  22 },
    { hq_tab_16,  176,  144,  8,  9,  11 },
    { hq_tab_17, 1280, 1024, 16, 20, 256 },
    { hq_tab_18, 1280,  960, 16, 25, 192 },
    { hq_tab_19, 1024,  768, 16, 24, 128 },
    { hq_tab_20,  704,  480,  8, 20,  66 },
    { hq_tab_21,  704,  576,  8, 24,  66 },
};

av_cold int ff_hq_init_vlcs(HQContext *c)
{
    int ret = vlc_init(&c->hqa_cbp_vlc, 5, FF_ARRAY_ELEMS(cbp_vlc_lens),
                       cbp_vlc_lens, 1, 1, cbp_vlc_bits, 1, 1, 0);
    if (ret < 0)
        return ret;

    return vlc_init(&c->hq_ac_vlc, 9, NUM_HQ_AC_ENTRIES,
                    hq_ac_bits, 1, 1, hq_ac_codes, 2, 2, 0);
}
