/*
  Definition of constant tables

  This module contains most of the constant data that can be stored in ROM.
*/

#include <stdio.h>
#include "aacplusenc.h"

#define NEGATE_IPD_MASK                 ( 0x00001000 )

const int aHybridResolution[3] = {
  8, 4, 4
};

const int hiResBandBorders[8+12+1] = {
  0,   1,   2,   3,
  10,  11, 12,  13,
  3,   4,   5,   6,   7,   8,   9,   11,  14,  18,  23,  35,  64
};

const int groupBordersMix[28 + 1] =
{
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
    3, 4, 5, 6, 7, 8, 9, 11, 14, 18, 23, 35, 64
};
const int bins2groupMap[28 + 1] =
{
    0, 1, 2, 3, 4, 4,
    ( NEGATE_IPD_MASK | 1 ), ( NEGATE_IPD_MASK | 0 ),
    6, 3, 4, 5, 6, 7, 8, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19
};
const float panClass[7] = {0.1661f,  0.4983f,  0.9135f,  1.4118f,  1.9932f,  2.6576f,  3.5711f};

const float saClass[7]  = {0.088900f,  0.229800f,  0.364250f,  0.504500f,  0.635100f,  0.799600f,  0.945650f};

const float p4_13[13] =
{

  -0.00305151927305f,  0.00794862316203f,  0.0f,              -0.04318924038756f,
  -0.12542448210445f,  0.21227807049160f,  0.25f,              0.21227807049160f,
   0.12542448210445f, -0.04318924038756f,  0.0f,               0.00794862316203f,
   0.00305151927305f
};

const float p8_13[13] =
{
  -0.00746082949812f, -0.02270420949825f, -0.04546865930473f, -0.07266113929591f,
  -0.09885108575264f,  0.11793710567217f,  0.125f,             0.11793710567217f,
   0.09885108575264f,  0.07266113929591f,  0.04546865930473f,  0.02270420949825f,
   0.00746082949812f
};

const float sbr_cos_twiddle[] =
{
  0.9996988177299500f,
  0.9924795627593994f,
  0.9757021069526672f,
  0.9495281577110291f,
  0.9142097234725952f,
  0.8700869679450989f,
  0.8175848126411438f,
  0.7572088241577148f,
  0.6895405054092407f,
  0.6152315735816956f,
  0.5349975824356079f,
  0.4496113061904907f,
  0.3598949909210205f,
  0.2667127251625061f,
  0.1709618568420410f,
  0.0735645219683647f
};

const float sbr_sin_twiddle[] =
{
  0.0245412290096283f,
  0.1224106773734093f,
  0.2191012501716614f,
  0.3136817514896393f,
  0.4052413105964661f,
  0.4928981959819794f,
  0.5758082270622253f,
  0.6531728506088257f,
  0.7242470979690552f,
  0.7883464694023132f,
  0.8448535799980164f,
  0.8932242989540100f,
  0.9329928159713745f,
  0.9637760519981384f,
  0.9852776527404785f,
  0.9972904324531555f
};

const float sbr_alt_sin_twiddle[] =
{
  0.0000000000000000f,
  0.0980171412229538f,
  0.1950903236865997f,
  0.2902846932411194f,
  0.3826834559440613f,
  0.4713967442512512f,
  0.5555702447891235f,
  0.6343932747840881f,
  0.7071067690849304f,
  0.7730104923248291f,
  0.8314696550369263f,
  0.8819212913513184f,
  0.9238795638084412f,
  0.9569403529167175f,
  0.9807853102684021f,
  0.9951847195625305f,
  1.0000000000000000f
};

const float p_64_640_qmf[640] =
{
  -5.525286504714797e-004f,-5.617692573788820e-004f,-4.947518089560348e-004f,-4.875227971213061e-004f,
  -4.893791249849297e-004f,-5.040714349717598e-004f,-5.226564297171536e-004f,-5.466565633704553e-004f,
  -5.677802561282153e-004f,-5.870930485225149e-004f,-6.132747393831305e-004f,-6.312493531935796e-004f,
  -6.540333362057484e-004f,-6.777690776369781e-004f,-6.941614627303249e-004f,-7.157736474351309e-004f,
  -7.255043122205504e-004f,-7.440941854094920e-004f,-7.490598053217391e-004f,-7.681371927024808e-004f,
  -7.724848594888575e-004f,-7.834332287666293e-004f,-7.779869492680295e-004f,-7.803664709970310e-004f,
  -7.801449625711068e-004f,-7.757977330969382e-004f,-7.630793575703050e-004f,-7.530001420101251e-004f,
  -7.319357152453665e-004f,-7.215391987622286e-004f,-6.917937537191035e-004f,-6.650415089345047e-004f,
  -6.341594902471489e-004f,-5.946118933031955e-004f,-5.564576390631206e-004f,-5.145572210825134e-004f,
  -4.606325480338262e-004f,-4.095121452206994e-004f,-3.501175875595919e-004f,-2.896981174825215e-004f,
  -2.098337343963717e-004f,-1.446380934949981e-004f,-6.173344071970479e-005f, 1.349497417596386e-005f,
   1.094383127384685e-004f, 2.043017068780772e-004f, 2.949531104116364e-004f, 4.026540215999252e-004f,
   5.107388495248741e-004f, 6.239376139142985e-004f, 7.458025886538838e-004f, 8.608443326193891e-004f,
   9.885988301536750e-004f, 1.125015513066064e-003f, 1.257788464745049e-003f, 1.390249482718497e-003f,
   1.544321984713545e-003f, 1.686808325309625e-003f, 1.834826542238209e-003f, 1.984114073694576e-003f,
   2.146158355573756e-003f, 2.301725477463282e-003f, 2.462561691257243e-003f, 2.620175869023839e-003f,
   2.787046434648109e-003f, 2.946944771654501e-003f, 3.112542065248617e-003f, 3.273961348469476e-003f,
   3.441887418281308e-003f, 3.600826812313299e-003f, 3.760392291041691e-003f, 3.920743237034152e-003f,
   4.081975319350373e-003f, 4.226426922703637e-003f, 4.373071967813425e-003f, 4.520985278247952e-003f,
   4.660646061176193e-003f, 4.793256084983462e-003f, 4.913760357448478e-003f, 5.039302260125202e-003f,
   5.140735390322959e-003f, 5.246116613236508e-003f, 5.347168119820721e-003f, 5.419677593070989e-003f,
   5.487604015074597e-003f, 5.547571450883520e-003f, 5.593802300454330e-003f, 5.622064320965902e-003f,
   5.645519691635520e-003f, 5.638919951508487e-003f, 5.626611419323720e-003f, 5.591712866303156e-003f,
   5.540436394000088e-003f, 5.475378307696386e-003f, 5.383897589704628e-003f, 5.271575872723485e-003f,
   5.138227545142836e-003f, 4.983968776294583e-003f, 4.810946905999106e-003f, 4.603953014705050e-003f,
   4.380186174471733e-003f, 4.125164232698537e-003f, 3.845640812460432e-003f, 3.540124655067661e-003f,
   3.209188580984976e-003f, 2.844675786234913e-003f, 2.450854003212794e-003f, 2.027417618500581e-003f,
   1.578468257676472e-003f, 1.090232905120221e-003f, 5.832264248006948e-004f, 2.760451905299060e-005f,
  -5.464280866436426e-004f,-1.156813552266513e-003f,-1.803947258930832e-003f,-2.482672364493203e-003f,
  -3.193377839003896e-003f,-3.940112405218538e-003f,-4.722259624000638e-003f,-5.533721110879950e-003f,
  -6.379229326851348e-003f,-7.261581685172976e-003f,-8.179823337263956e-003f,-9.132532960846242e-003f,
  -1.011502154985735e-002f,-1.113155480320807e-002f,-1.218499959507776e-002f,-1.327182200350553e-002f,
   1.439046660791857e-002f, 1.554055533423407e-002f, 1.673247129988964e-002f, 1.794333813443166e-002f,
   1.918724313697539e-002f, 2.045317933555374e-002f, 2.174675502535081e-002f, 2.306801692862206e-002f,
   2.441609920284815e-002f, 2.578758475467104e-002f, 2.718594296328715e-002f, 2.860721736384611e-002f,
   3.005026574279500e-002f, 3.150176087389379e-002f, 3.297540810337295e-002f, 3.446209487686384e-002f,
   3.596975605541700e-002f, 3.748128504251629e-002f, 3.900536794745497e-002f, 4.053491705584002e-002f,
   4.206490946366589e-002f, 4.360975421303862e-002f, 4.514884056413160e-002f, 4.668430272642297e-002f,
   4.821657200671922e-002f, 4.973857556013930e-002f, 5.125561555215880e-002f, 5.276307465206772e-002f,
   5.424527683588578e-002f, 5.571736482138088e-002f, 5.716164501298929e-002f, 5.859156836259560e-002f,
   5.998374801761285e-002f, 6.134551717206593e-002f, 6.268578081171672e-002f, 6.397158980680977e-002f,
   6.522471064379697e-002f, 6.643675122104309e-002f, 6.760759851227793e-002f, 6.870438283511596e-002f,
   6.976302447126595e-002f, 7.076287107265650e-002f, 7.170026731101810e-002f, 7.256825833083160e-002f,
   7.336202550803318e-002f, 7.410036424341697e-002f, 7.474525581193675e-002f, 7.531373362019285e-002f,
   7.580083586584310e-002f, 7.619924793395567e-002f, 7.649921704119105e-002f, 7.670934904244611e-002f,
   7.681739756964497e-002f, 7.682300113922813e-002f, 7.672049241745922e-002f, 7.650507183193828e-002f,
   7.617483218536458e-002f, 7.573057565061056e-002f, 7.515762552869984e-002f, 7.446643947564230e-002f,
   7.364060057620300e-002f, 7.267746427298773e-002f, 7.158263647902899e-002f, 7.035330735092815e-002f,
   6.896640131950568e-002f, 6.745250215166189e-002f, 6.576906686507557e-002f, 6.394448059633222e-002f,
   6.196027790386974e-002f, 5.981665708090339e-002f, 5.751526919867195e-002f, 5.504600343008619e-002f,
   5.240938217365652e-002f, 4.959786763444761e-002f, 4.663033051701176e-002f, 4.347687821958321e-002f,
   4.014582784127306e-002f, 3.664181168133450e-002f, 3.295839306690847e-002f, 2.908240060124874e-002f,
   2.503075618908813e-002f, 2.079970728622271e-002f, 1.637012582228135e-002f, 1.176238327857339e-002f,
   6.963686216167498e-003f, 1.976560145028481e-003f,-3.208689683036121e-003f,-8.571174913661668e-003f,
  -1.412888273557668e-002f,-1.988341292573269e-002f,-2.582272888063778e-002f,-3.195312745331961e-002f,
  -3.827765720821592e-002f,-4.478068215855852e-002f,-5.148041767933625e-002f,-5.837053268336145e-002f,
  -6.544098531359448e-002f,-7.269433008129310e-002f,-8.013729344279387e-002f,-8.775475365592653e-002f,
  -9.555333528914223e-002f,-1.035329531146302e-001f,-1.116826931773024e-001f,-1.200077984679968e-001f,
  -1.285002850387848e-001f,-1.371551761193432e-001f,-1.459766491186991e-001f,-1.549607071060459e-001f,
  -1.640958855666853e-001f,-1.733808172170604e-001f,-1.828172548514229e-001f,-1.923966745726700e-001f,
  -2.021250176810344e-001f,-2.119735853805564e-001f,-2.219652696414943e-001f,-2.320690870679074e-001f,
  -2.423016884597387e-001f,-2.526480309572177e-001f,-2.631053299460340e-001f,-2.736634040562456e-001f,
  -2.843214189108535e-001f,-2.950716717064639e-001f,-3.059098575191602e-001f,-3.168278913645616e-001f,
  -3.278113727210475e-001f,-3.388722693866466e-001f,-3.499914122930965e-001f,-3.611589903135513e-001f,
   3.723795546306128e-001f, 3.836350013904333e-001f, 3.949211761567527e-001f, 4.062317676762485e-001f,
   4.175696896840907e-001f, 4.289119920737320e-001f, 4.402553754366491e-001f, 4.515996535682373e-001f,
   4.629308085275695e-001f, 4.742453214611543e-001f, 4.855253091109857e-001f, 4.967708254570692e-001f,
   5.079817500043367e-001f, 5.191234970239136e-001f, 5.302240895685498e-001f, 5.412553448732201e-001f,
   5.522051258506063e-001f, 5.630789140137003e-001f, 5.738524131692298e-001f, 5.845403235467916e-001f,
   5.951123086249566e-001f, 6.055783538918024e-001f, 6.159109932029110e-001f, 6.261242695605493e-001f,
   6.361980107728613e-001f, 6.461269695946109e-001f, 6.559016302467067e-001f, 6.655139880162695e-001f,
   6.749663190171162e-001f, 6.842353293459781e-001f, 6.933282376703176e-001f, 7.022388719353935e-001f,
   7.109410426309526e-001f, 7.194462634956096e-001f, 7.277448900299428e-001f, 7.358211758276898e-001f,
   7.436827863648809e-001f, 7.513137456123731e-001f, 7.587080760824195e-001f, 7.658674865093896e-001f,
   7.727780881332725e-001f, 7.794287519021588e-001f, 7.858353120392010e-001f, 7.919735841642436e-001f,
   7.978466413770040e-001f, 8.034485751850518e-001f, 8.087695004449111e-001f, 8.138191270621699e-001f,
   8.185776004646774e-001f, 8.230419890540879e-001f, 8.272275347335977e-001f, 8.311038457151991e-001f,
   8.346937361840173e-001f, 8.379717337886474e-001f, 8.409541392472186e-001f, 8.436238281200542e-001f,
   8.459818469820640e-001f, 8.480315777076319e-001f, 8.497805198426792e-001f, 8.511971524934298e-001f,
   8.523047035214708e-001f, 8.531020949701688e-001f, 8.535720573910749e-001f, 8.537385600593657e-001f,
   8.535720573910749e-001f, 8.531020949701688e-001f, 8.523047035214708e-001f, 8.511971524934298e-001f,
   8.497805198426792e-001f, 8.480315777076319e-001f, 8.459818469820640e-001f, 8.436238281200542e-001f,
   8.409541392472186e-001f, 8.379717337886474e-001f, 8.346937361840173e-001f, 8.311038457151991e-001f,
   8.272275347335977e-001f, 8.230419890540879e-001f, 8.185776004646774e-001f, 8.138191270621699e-001f,
   8.087695004449111e-001f, 8.034485751850518e-001f, 7.978466413770040e-001f, 7.919735841642436e-001f,
   7.858353120392010e-001f, 7.794287519021588e-001f, 7.727780881332725e-001f, 7.658674865093896e-001f,
   7.587080760824195e-001f, 7.513137456123731e-001f, 7.436827863648809e-001f, 7.358211758276898e-001f,
   7.277448900299428e-001f, 7.194462634956096e-001f, 7.109410426309526e-001f, 7.022388719353935e-001f,
   6.933282376703176e-001f, 6.842353293459781e-001f, 6.749663190171162e-001f, 6.655139880162695e-001f,
   6.559016302467067e-001f, 6.461269695946109e-001f, 6.361980107728613e-001f, 6.261242695605493e-001f,
   6.159109932029110e-001f, 6.055783538918024e-001f, 5.951123086249566e-001f, 5.845403235467916e-001f,
   5.738524131692298e-001f, 5.630789140137003e-001f, 5.522051258506063e-001f, 5.412553448732201e-001f,
   5.302240895685498e-001f, 5.191234970239136e-001f, 5.079817500043367e-001f, 4.967708254570692e-001f,
   4.855253091109857e-001f, 4.742453214611543e-001f, 4.629308085275695e-001f, 4.515996535682373e-001f,
   4.402553754366491e-001f, 4.289119920737320e-001f, 4.175696896840907e-001f, 4.062317676762485e-001f,
   3.949211761567527e-001f, 3.836350013904333e-001f, 3.723795546306128e-001f, 3.611589903135513e-001f,
  -3.499914122930965e-001f,-3.388722693866466e-001f,-3.278113727210475e-001f,-3.168278913645616e-001f,
  -3.059098575191602e-001f,-2.950716717064639e-001f,-2.843214189108535e-001f,-2.736634040562456e-001f,
  -2.631053299460340e-001f,-2.526480309572177e-001f,-2.423016884597387e-001f,-2.320690870679074e-001f,
  -2.219652696414943e-001f,-2.119735853805564e-001f,-2.021250176810344e-001f,-1.923966745726700e-001f,
  -1.828172548514229e-001f,-1.733808172170604e-001f,-1.640958855666853e-001f,-1.549607071060459e-001f,
  -1.459766491186991e-001f,-1.371551761193432e-001f,-1.285002850387848e-001f,-1.200077984679968e-001f,
  -1.116826931773024e-001f,-1.035329531146302e-001f,-9.555333528914223e-002f,-8.775475365592653e-002f,
  -8.013729344279387e-002f,-7.269433008129310e-002f,-6.544098531359448e-002f,-5.837053268336145e-002f,
  -5.148041767933625e-002f,-4.478068215855852e-002f,-3.827765720821592e-002f,-3.195312745331961e-002f,
  -2.582272888063778e-002f,-1.988341292573269e-002f,-1.412888273557668e-002f,-8.571174913661668e-003f,
  -3.208689683036121e-003f, 1.976560145028481e-003f, 6.963686216167498e-003f, 1.176238327857339e-002f,
   1.637012582228135e-002f, 2.079970728622271e-002f, 2.503075618908813e-002f, 2.908240060124874e-002f,
   3.295839306690847e-002f, 3.664181168133450e-002f, 4.014582784127306e-002f, 4.347687821958321e-002f,
   4.663033051701176e-002f, 4.959786763444761e-002f, 5.240938217365652e-002f, 5.504600343008619e-002f,
   5.751526919867195e-002f, 5.981665708090339e-002f, 6.196027790386974e-002f, 6.394448059633222e-002f,
   6.576906686507557e-002f, 6.745250215166189e-002f, 6.896640131950568e-002f, 7.035330735092815e-002f,
   7.158263647902899e-002f, 7.267746427298773e-002f, 7.364060057620300e-002f, 7.446643947564230e-002f,
   7.515762552869984e-002f, 7.573057565061056e-002f, 7.617483218536458e-002f, 7.650507183193828e-002f,
   7.672049241745922e-002f, 7.682300113922813e-002f, 7.681739756964497e-002f, 7.670934904244611e-002f,
   7.649921704119105e-002f, 7.619924793395567e-002f, 7.580083586584310e-002f, 7.531373362019285e-002f,
   7.474525581193675e-002f, 7.410036424341697e-002f, 7.336202550803318e-002f, 7.256825833083160e-002f,
   7.170026731101810e-002f, 7.076287107265650e-002f, 6.976302447126595e-002f, 6.870438283511596e-002f,
   6.760759851227793e-002f, 6.643675122104309e-002f, 6.522471064379697e-002f, 6.397158980680977e-002f,
   6.268578081171672e-002f, 6.134551717206593e-002f, 5.998374801761285e-002f, 5.859156836259560e-002f,
   5.716164501298929e-002f, 5.571736482138088e-002f, 5.424527683588578e-002f, 5.276307465206772e-002f,
   5.125561555215880e-002f, 4.973857556013930e-002f, 4.821657200671922e-002f, 4.668430272642297e-002f,
   4.514884056413160e-002f, 4.360975421303862e-002f, 4.206490946366589e-002f, 4.053491705584002e-002f,
   3.900536794745497e-002f, 3.748128504251629e-002f, 3.596975605541700e-002f, 3.446209487686384e-002f,
   3.297540810337295e-002f, 3.150176087389379e-002f, 3.005026574279500e-002f, 2.860721736384611e-002f,
   2.718594296328715e-002f, 2.578758475467104e-002f, 2.441609920284815e-002f, 2.306801692862206e-002f,
   2.174675502535081e-002f, 2.045317933555374e-002f, 1.918724313697539e-002f, 1.794333813443166e-002f,
   1.673247129988964e-002f, 1.554055533423407e-002f, 1.439046660791857e-002f, 1.327182200350553e-002f,
  -1.218499959507776e-002f,-1.113155480320807e-002f,-1.011502154985735e-002f,-9.132532960846242e-003f,
  -8.179823337263956e-003f,-7.261581685172976e-003f,-6.379229326851348e-003f,-5.533721110879950e-003f,
  -4.722259624000638e-003f,-3.940112405218538e-003f,-3.193377839003896e-003f,-2.482672364493203e-003f,
  -1.803947258930832e-003f,-1.156813552266513e-003f,-5.464280866436426e-004f, 2.760451905299060e-005f,
   5.832264248006948e-004f, 1.090232905120221e-003f, 1.578468257676472e-003f, 2.027417618500581e-003f,
   2.450854003212794e-003f, 2.844675786234913e-003f, 3.209188580984976e-003f, 3.540124655067661e-003f,
   3.845640812460432e-003f, 4.125164232698537e-003f, 4.380186174471733e-003f, 4.603953014705050e-003f,
   4.810946905999106e-003f, 4.983968776294583e-003f, 5.138227545142836e-003f, 5.271575872723485e-003f,
   5.383897589704628e-003f, 5.475378307696386e-003f, 5.540436394000088e-003f, 5.591712866303156e-003f,
   5.626611419323720e-003f, 5.638919951508487e-003f, 5.645519691635520e-003f, 5.622064320965902e-003f,
   5.593802300454330e-003f, 5.547571450883520e-003f, 5.487604015074597e-003f, 5.419677593070989e-003f,
   5.347168119820721e-003f, 5.246116613236508e-003f, 5.140735390322959e-003f, 5.039302260125202e-003f,
   4.913760357448478e-003f, 4.793256084983462e-003f, 4.660646061176193e-003f, 4.520985278247952e-003f,
   4.373071967813425e-003f, 4.226426922703637e-003f, 4.081975319350373e-003f, 3.920743237034152e-003f,
   3.760392291041691e-003f, 3.600826812313299e-003f, 3.441887418281308e-003f, 3.273961348469476e-003f,
   3.112542065248617e-003f, 2.946944771654501e-003f, 2.787046434648109e-003f, 2.620175869023839e-003f,
   2.462561691257243e-003f, 2.301725477463282e-003f, 2.146158355573756e-003f, 1.984114073694576e-003f,
   1.834826542238209e-003f, 1.686808325309625e-003f, 1.544321984713545e-003f, 1.390249482718497e-003f,
   1.257788464745049e-003f, 1.125015513066064e-003f, 9.885988301536750e-004f, 8.608443326193891e-004f,
   7.458025886538838e-004f, 6.239376139142985e-004f, 5.107388495248741e-004f, 4.026540215999252e-004f,
   2.949531104116364e-004f, 2.043017068780772e-004f, 1.094383127384685e-004f, 1.349497417596386e-005f,
  -6.173344071970479e-005f,-1.446380934949981e-004f,-2.098337343963717e-004f,-2.896981174825215e-004f,
  -3.501175875595919e-004f,-4.095121452206994e-004f,-4.606325480338262e-004f,-5.145572210825134e-004f,
  -5.564576390631206e-004f,-5.946118933031955e-004f,-6.341594902471489e-004f,-6.650415089345047e-004f,
  -6.917937537191035e-004f,-7.215391987622286e-004f,-7.319357152453665e-004f,-7.530001420101251e-004f,
  -7.630793575703050e-004f,-7.757977330969382e-004f,-7.801449625711068e-004f,-7.803664709970310e-004f,
  -7.779869492680295e-004f,-7.834332287666293e-004f,-7.724848594888575e-004f,-7.681371927024808e-004f,
  -7.490598053217391e-004f,-7.440941854094920e-004f,-7.255043122205504e-004f,-7.157736474351309e-004f,
  -6.941614627303249e-004f,-6.777690776369781e-004f,-6.540333362057484e-004f,-6.312493531935796e-004f,
  -6.132747393831305e-004f,-5.870930485225149e-004f,-5.677802561282153e-004f,-5.466565633704553e-004f,
  -5.226564297171536e-004f,-5.040714349717598e-004f,-4.893791249849297e-004f,-4.875227971213061e-004f,
  -4.947518089560348e-004f,-5.617692573788820e-004f,-5.525286504714797e-004f, 0.000000000000000e+000f
};

const int aBookPsIidTimeCode[29] =
{
 0x0007FFF9,  0x0007FFFA,  0x0007FFFB,  0x000FFFF8,  0x000FFFF9,  0x000FFFFA,
 0x0001FFFD,  0x00007FFE,  0x00000FFE,  0x000003FE,  0x000000FE,  0x0000003E,
 0x0000000E,  0x00000002,  0x00000000,  0x00000006,  0x0000001E,  0x0000007E,
 0x000001FE,  0x000007FE,  0x00001FFE,  0x00003FFE,  0x0001FFFC,  0x0007FFF8,
 0x000FFFFB,  0x000FFFFC,  0x000FFFFD,  0x000FFFFE,  0x000FFFFF
};


const char aBookPsIidTimeLength[29] =
{
 0x13,  0x13,  0x13,  0x14,  0x14,  0x14,
 0x11,  0x0F,  0x0C,  0x0A,  0x08,  0x06,
 0x04,  0x02,  0x01,  0x03,  0x05,  0x07,
 0x09,  0x0B,  0x0D,  0x0E,  0x11,  0x13,
 0x14,  0x14,  0x14,  0x14,  0x14
};

const int aBookPsIidFreqCode[29] =
{
 0x0001FFFB,  0x0001FFFC,  0x0001FFFD,  0x0001FFFA,  0x0000FFFC,  0x00007FFC,
 0x00001FFD,  0x000003FE,  0x000001FE,  0x0000007E,  0x0000003C,  0x0000001D,
 0x0000000D,  0x00000005,  0x00000000,  0x00000004,  0x0000000C,  0x0000001C,
 0x0000003D,  0x0000003E,  0x000000FE,  0x000007FE,  0x00001FFC,  0x00003FFC,
 0x00003FFD,  0x00007FFD,  0x0001FFFE,  0x0003FFFE,  0x0003FFFF
};

const char aBookPsIidFreqLength[29] =
{
 0x11,  0x11,  0x11,  0x11,  0x10,  0x0F,
 0x0D,  0x0A,  0x09,  0x07,  0x06,  0x05,
 0x04,  0x03,  0x01,  0x03,  0x04,  0x05,
 0x06,  0x06,  0x08,  0x0B,  0x0D,  0x0E,
 0x0E,  0x0F,  0x11,  0x12,  0x12
};

const short aBookPsIccTimeCode[15] =
{
 0x3FFE,  0x1FFE,  0x07FE,  0x01FE,  0x007E,  0x001E,
 0x0006,  0x0000,  0x0002,  0x000E,  0x003E,  0x00FE,
 0x03FE,  0x0FFE,  0x3FFF
};

const char aBookPsIccTimeLength[15] =
{
 0x0E,  0x0D,  0x0B,  0x09,  0x07,  0x05,
 0x03,  0x01,  0x02,  0x04,  0x06,  0x08,
 0x0A,  0x0C,  0x0E
};

const short aBookPsIccFreqCode[15] =
{
 0x3FFF,  0x3FFE,  0x0FFE,  0x03FE,  0x007E,  0x001E,
 0x0006,  0x0000,  0x0002,  0x000E,  0x003E,  0x00FE,
 0x01FE,  0x07FE,  0x1FFE
};

const char aBookPsIccFreqLength[15] =
{
 0x0E,  0x0E,  0x0C,  0x0A,  0x07,  0x05,
 0x03,  0x01,  0x02,  0x04,  0x06,  0x08,
 0x09,  0x0B,  0x0D
};

const float sbr_qmf_64_640[] =
{
-5.525286504714797e-004f,+1.439046660791857e-002f,+3.723795546306128e-001f,-3.499914122930965e-001f,-1.218499959507776e-002f,
-5.617692573788820e-004f,+1.554055533423407e-002f,+3.836350013904333e-001f,-3.388722693866466e-001f,-1.113155480320807e-002f,
-4.947518089560348e-004f,+1.673247129988964e-002f,+3.949211761567527e-001f,-3.278113727210475e-001f,-1.011502154985735e-002f,
-4.875227971213061e-004f,+1.794333813443166e-002f,+4.062317676762485e-001f,-3.168278913645616e-001f,-9.132532960846242e-003f,
-4.893791249849297e-004f,+1.918724313697539e-002f,+4.175696896840907e-001f,-3.059098575191602e-001f,-8.179823337263956e-003f,
-5.040714349717598e-004f,+2.045317933555374e-002f,+4.289119920737320e-001f,-2.950716717064639e-001f,-7.261581685172976e-003f,
-5.226564297171536e-004f,+2.174675502535081e-002f,+4.402553754366491e-001f,-2.843214189108535e-001f,-6.379229326851348e-003f,
-5.466565633704553e-004f,+2.306801692862206e-002f,+4.515996535682373e-001f,-2.736634040562456e-001f,-5.533721110879950e-003f,
-5.677802561282153e-004f,+2.441609920284815e-002f,+4.629308085275695e-001f,-2.631053299460340e-001f,-4.722259624000638e-003f,
-5.870930485225149e-004f,+2.578758475467104e-002f,+4.742453214611543e-001f,-2.526480309572177e-001f,-3.940112405218538e-003f,
-6.132747393831305e-004f,+2.718594296328715e-002f,+4.855253091109857e-001f,-2.423016884597387e-001f,-3.193377839003896e-003f,
-6.312493531935796e-004f,+2.860721736384611e-002f,+4.967708254570692e-001f,-2.320690870679074e-001f,-2.482672364493203e-003f,
-6.540333362057484e-004f,+3.005026574279500e-002f,+5.079817500043367e-001f,-2.219652696414943e-001f,-1.803947258930832e-003f,
-6.777690776369781e-004f,+3.150176087389379e-002f,+5.191234970239136e-001f,-2.119735853805564e-001f,-1.156813552266513e-003f,
-6.941614627303249e-004f,+3.297540810337295e-002f,+5.302240895685498e-001f,-2.021250176810344e-001f,-5.464280866436426e-004f,
-7.157736474351309e-004f,+3.446209487686384e-002f,+5.412553448732201e-001f,-1.923966745726700e-001f,+2.760451905299060e-005f,
-7.255043122205504e-004f,+3.596975605541700e-002f,+5.522051258506063e-001f,-1.828172548514229e-001f,+5.832264248006948e-004f,
-7.440941854094920e-004f,+3.748128504251629e-002f,+5.630789140137003e-001f,-1.733808172170604e-001f,+1.090232905120221e-003f,
-7.490598053217391e-004f,+3.900536794745497e-002f,+5.738524131692298e-001f,-1.640958855666853e-001f,+1.578468257676472e-003f,
-7.681371927024808e-004f,+4.053491705584002e-002f,+5.845403235467916e-001f,-1.549607071060459e-001f,+2.027417618500581e-003f,
-7.724848594888575e-004f,+4.206490946366589e-002f,+5.951123086249566e-001f,-1.459766491186991e-001f,+2.450854003212794e-003f,
-7.834332287666293e-004f,+4.360975421303862e-002f,+6.055783538918024e-001f,-1.371551761193432e-001f,+2.844675786234913e-003f,
-7.779869492680295e-004f,+4.514884056413160e-002f,+6.159109932029110e-001f,-1.285002850387848e-001f,+3.209188580984976e-003f,
-7.803664709970310e-004f,+4.668430272642297e-002f,+6.261242695605493e-001f,-1.200077984679968e-001f,+3.540124655067661e-003f,
-7.801449625711068e-004f,+4.821657200671922e-002f,+6.361980107728613e-001f,-1.116826931773024e-001f,+3.845640812460432e-003f,
-7.757977330969382e-004f,+4.973857556013930e-002f,+6.461269695946109e-001f,-1.035329531146302e-001f,+4.125164232698537e-003f,
-7.630793575703050e-004f,+5.125561555215880e-002f,+6.559016302467067e-001f,-9.555333528914223e-002f,+4.380186174471733e-003f,
-7.530001420101251e-004f,+5.276307465206772e-002f,+6.655139880162695e-001f,-8.775475365592653e-002f,+4.603953014705050e-003f,
-7.319357152453665e-004f,+5.424527683588578e-002f,+6.749663190171162e-001f,-8.013729344279387e-002f,+4.810946905999106e-003f,
-7.215391987622286e-004f,+5.571736482138088e-002f,+6.842353293459781e-001f,-7.269433008129310e-002f,+4.983968776294583e-003f,
-6.917937537191035e-004f,+5.716164501298929e-002f,+6.933282376703176e-001f,-6.544098531359448e-002f,+5.138227545142836e-003f,
-6.650415089345047e-004f,+5.859156836259560e-002f,+7.022388719353935e-001f,-5.837053268336145e-002f,+5.271575872723485e-003f,
-6.341594902471489e-004f,+5.998374801761285e-002f,+7.109410426309526e-001f,-5.148041767933625e-002f,+5.383897589704628e-003f,
-5.946118933031955e-004f,+6.134551717206593e-002f,+7.194462634956096e-001f,-4.478068215855852e-002f,+5.475378307696386e-003f,
-5.564576390631206e-004f,+6.268578081171672e-002f,+7.277448900299428e-001f,-3.827765720821592e-002f,+5.540436394000088e-003f,
-5.145572210825134e-004f,+6.397158980680977e-002f,+7.358211758276898e-001f,-3.195312745331961e-002f,+5.591712866303156e-003f,
-4.606325480338262e-004f,+6.522471064379697e-002f,+7.436827863648809e-001f,-2.582272888063778e-002f,+5.626611419323720e-003f,
-4.095121452206994e-004f,+6.643675122104309e-002f,+7.513137456123731e-001f,-1.988341292573269e-002f,+5.638919951508487e-003f,
-3.501175875595919e-004f,+6.760759851227793e-002f,+7.587080760824195e-001f,-1.412888273557668e-002f,+5.645519691635520e-003f,
-2.896981174825215e-004f,+6.870438283511596e-002f,+7.658674865093896e-001f,-8.571174913661668e-003f,+5.622064320965902e-003f,
-2.098337343963717e-004f,+6.976302447126595e-002f,+7.727780881332725e-001f,-3.208689683036121e-003f,+5.593802300454330e-003f,
-1.446380934949981e-004f,+7.076287107265650e-002f,+7.794287519021588e-001f,+1.976560145028481e-003f,+5.547571450883520e-003f,
-6.173344071970479e-005f,+7.170026731101810e-002f,+7.858353120392010e-001f,+6.963686216167498e-003f,+5.487604015074597e-003f,
+1.349497417596386e-005f,+7.256825833083160e-002f,+7.919735841642436e-001f,+1.176238327857339e-002f,+5.419677593070989e-003f,
+1.094383127384685e-004f,+7.336202550803318e-002f,+7.978466413770040e-001f,+1.637012582228135e-002f,+5.347168119820721e-003f,
+2.043017068780772e-004f,+7.410036424341697e-002f,+8.034485751850518e-001f,+2.079970728622271e-002f,+5.246116613236508e-003f,
+2.949531104116364e-004f,+7.474525581193675e-002f,+8.087695004449111e-001f,+2.503075618908813e-002f,+5.140735390322959e-003f,
+4.026540215999252e-004f,+7.531373362019285e-002f,+8.138191270621699e-001f,+2.908240060124874e-002f,+5.039302260125202e-003f,
+5.107388495248741e-004f,+7.580083586584310e-002f,+8.185776004646774e-001f,+3.295839306690847e-002f,+4.913760357448478e-003f,
+6.239376139142985e-004f,+7.619924793395567e-002f,+8.230419890540879e-001f,+3.664181168133450e-002f,+4.793256084983462e-003f,
+7.458025886538838e-004f,+7.649921704119105e-002f,+8.272275347335977e-001f,+4.014582784127306e-002f,+4.660646061176193e-003f,
+8.608443326193891e-004f,+7.670934904244611e-002f,+8.311038457151991e-001f,+4.347687821958321e-002f,+4.520985278247952e-003f,
+9.885988301536750e-004f,+7.681739756964497e-002f,+8.346937361840173e-001f,+4.663033051701176e-002f,+4.373071967813425e-003f,
+1.125015513066064e-003f,+7.682300113922813e-002f,+8.379717337886474e-001f,+4.959786763444761e-002f,+4.226426922703637e-003f,
+1.257788464745049e-003f,+7.672049241745922e-002f,+8.409541392472186e-001f,+5.240938217365652e-002f,+4.081975319350373e-003f,
+1.390249482718497e-003f,+7.650507183193828e-002f,+8.436238281200542e-001f,+5.504600343008619e-002f,+3.920743237034152e-003f,
+1.544321984713545e-003f,+7.617483218536458e-002f,+8.459818469820640e-001f,+5.751526919867195e-002f,+3.760392291041691e-003f,
+1.686808325309625e-003f,+7.573057565061056e-002f,+8.480315777076319e-001f,+5.981665708090339e-002f,+3.600826812313299e-003f,
+1.834826542238209e-003f,+7.515762552869984e-002f,+8.497805198426792e-001f,+6.196027790386974e-002f,+3.441887418281308e-003f,
+1.984114073694576e-003f,+7.446643947564230e-002f,+8.511971524934298e-001f,+6.394448059633222e-002f,+3.273961348469476e-003f,
+2.146158355573756e-003f,+7.364060057620300e-002f,+8.523047035214708e-001f,+6.576906686507557e-002f,+3.112542065248617e-003f,
+2.301725477463282e-003f,+7.267746427298773e-002f,+8.531020949701688e-001f,+6.745250215166189e-002f,+2.946944771654501e-003f,
+2.462561691257243e-003f,+7.158263647902899e-002f,+8.535720573910749e-001f,+6.896640131950568e-002f,+2.787046434648109e-003f,
+2.620175869023839e-003f,+7.035330735092815e-002f,+8.537385600593657e-001f,+7.035330735092815e-002f,+2.620175869023839e-003f,
-1.327182200350553e-002f,-3.611589903135513e-001f,+3.611589903135513e-001f,+1.327182200350553e-002f,+0.000000000000000e+000f
};

const float trigData_fct4_32[32] =
{
  0.999698818696204f, 0.024541228522912f, 0.997290456678690f, 0.073564563599667f,
  0.992479534598710f, 0.122410675199216f, 0.985277642388941f, 0.170961888760301f,
  0.975702130038529f, 0.219101240156870f, 0.963776065795440f, 0.266712757474898f,
  0.949528180593037f, 0.313681740398892f, 0.932992798834739f, 0.359895036534988f,
  0.914209755703531f, 0.405241314004990f, 0.893224301195515f, 0.449611329654607f,
  0.870086991108711f, 0.492898192229784f, 0.844853565249707f, 0.534997619887097f,
  0.817584813151584f, 0.575808191417845f, 0.788346427626606f, 0.615231590580627f,
  0.757208846506485f, 0.653172842953777f, 0.724247082951467f, 0.689540544737067f
};

const float trigData_fct4_16[16] =
{
  0.998795456205172f, 0.049067674327418f, 0.989176509964781f, 0.146730474455362f,
  0.970031253194544f, 0.242980179903264f, 0.941544065183021f, 0.336889853392220f,
  0.903989293123443f, 0.427555093430282f, 0.857728610000272f, 0.514102744193222f,
  0.803207531480645f, 0.595699304492433f, 0.740951125354959f, 0.671558954847018f
};

const float trigData_fct4_8[8] =
{
  0.995184726672197f, 0.098017140329561f, 0.956940335732209f, 0.290284677254462f,
  0.881921264348355f, 0.471396736825998f, 0.773010453362737f, 0.634393284163645f
};


//@{

const int v_Huff_envelopeLevelC10T[121] =
{
0x0003FFD6,
0x0003FFD7,
0x0003FFD8,
0x0003FFD9,
0x0003FFDA,
0x0003FFDB,
0x0007FFB8,
0x0007FFB9,
0x0007FFBA,
0x0007FFBB,
0x0007FFBC,
0x0007FFBD,
0x0007FFBE,
0x0007FFBF,
0x0007FFC0,
0x0007FFC1,
0x0007FFC2,
0x0007FFC3,
0x0007FFC4,
0x0007FFC5,
0x0007FFC6,
0x0007FFC7,
0x0007FFC8,
0x0007FFC9,
0x0007FFCA,
0x0007FFCB,
0x0007FFCC,
0x0007FFCD,
0x0007FFCE,
0x0007FFCF,
0x0007FFD0,
0x0007FFD1,
0x0007FFD2,
0x0007FFD3,
0x0001FFE6,
0x0003FFD4,
0x0000FFF0,
0x0001FFE9,
0x0003FFD5,
0x0001FFE7,
0x0000FFF1,
0x0000FFEC,
0x0000FFED,
0x0000FFEE,
0x00007FF4,
0x00003FF9,
0x00003FF7,
0x00001FFA,
0x00001FF9,
0x00000FFB,
0x000007FC,
0x000003FC,
0x000001FD,
0x000000FD,
0x0000007D,
0x0000003D,
0x0000001D,
0x0000000D,
0x00000005,
0x00000001,
0x00000000,
0x00000004,
0x0000000C,
0x0000001C,
0x0000003C,
0x0000007C,
0x000000FC,
0x000001FC,
0x000003FD,
0x00000FFA,
0x00001FF8,
0x00003FF6,
0x00003FF8,
0x00007FF5,
0x0000FFEF,
0x0001FFE8,
0x0000FFF2,
0x0007FFD4,
0x0007FFD5,
0x0007FFD6,
0x0007FFD7,
0x0007FFD8,
0x0007FFD9,
0x0007FFDA,
0x0007FFDB,
0x0007FFDC,
0x0007FFDD,
0x0007FFDE,
0x0007FFDF,
0x0007FFE0,
0x0007FFE1,
0x0007FFE2,
0x0007FFE3,
0x0007FFE4,
0x0007FFE5,
0x0007FFE6,
0x0007FFE7,
0x0007FFE8,
0x0007FFE9,
0x0007FFEA,
0x0007FFEB,
0x0007FFEC,
0x0007FFED,
0x0007FFEE,
0x0007FFEF,
0x0007FFF0,
0x0007FFF1,
0x0007FFF2,
0x0007FFF3,
0x0007FFF4,
0x0007FFF5,
0x0007FFF6,
0x0007FFF7,
0x0007FFF8,
0x0007FFF9,
0x0007FFFA,
0x0007FFFB,
0x0007FFFC,
0x0007FFFD,
0x0007FFFE,
0x0007FFFF
};

const unsigned char v_Huff_envelopeLevelL10T[121] =
{
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000011,
0x00000012,
0x00000010,
0x00000011,
0x00000012,
0x00000011,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x0000000F,
0x0000000E,
0x0000000E,
0x0000000D,
0x0000000D,
0x0000000C,
0x0000000B,
0x0000000A,
0x00000009,
0x00000008,
0x00000007,
0x00000006,
0x00000005,
0x00000004,
0x00000003,
0x00000002,
0x00000002,
0x00000003,
0x00000004,
0x00000005,
0x00000006,
0x00000007,
0x00000008,
0x00000009,
0x0000000A,
0x0000000C,
0x0000000D,
0x0000000E,
0x0000000E,
0x0000000F,
0x00000010,
0x00000011,
0x00000010,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013,
0x00000013
};

const int v_Huff_envelopeLevelC10F[121] =
{
0x0007FFE7,
0x0007FFE8,
0x000FFFD2,
0x000FFFD3,
0x000FFFD4,
0x000FFFD5,
0x000FFFD6,
0x000FFFD7,
0x000FFFD8,
0x0007FFDA,
0x000FFFD9,
0x000FFFDA,
0x000FFFDB,
0x000FFFDC,
0x0007FFDB,
0x000FFFDD,
0x0007FFDC,
0x0007FFDD,
0x000FFFDE,
0x0003FFE4,
0x000FFFDF,
0x000FFFE0,
0x000FFFE1,
0x0007FFDE,
0x000FFFE2,
0x000FFFE3,
0x000FFFE4,
0x0007FFDF,
0x000FFFE5,
0x0007FFE0,
0x0003FFE8,
0x0007FFE1,
0x0003FFE0,
0x0003FFE9,
0x0001FFEF,
0x0003FFE5,
0x0001FFEC,
0x0001FFED,
0x0001FFEE,
0x0000FFF4,
0x0000FFF3,
0x0000FFF0,
0x00007FF7,
0x00007FF6,
0x00003FFA,
0x00001FFA,
0x00001FF9,
0x00000FFA,
0x00000FF8,
0x000007F9,
0x000003FB,
0x000001FC,
0x000001FA,
0x000000FB,
0x0000007C,
0x0000003C,
0x0000001C,
0x0000000C,
0x00000005,
0x00000001,
0x00000000,
0x00000004,
0x0000000D,
0x0000001D,
0x0000003D,
0x000000FA,
0x000000FC,
0x000001FB,
0x000003FA,
0x000007F8,
0x000007FA,
0x000007FB,
0x00000FF9,
0x00000FFB,
0x00001FF8,
0x00001FFB,
0x00003FF8,
0x00003FF9,
0x0000FFF1,
0x0000FFF2,
0x0001FFEA,
0x0001FFEB,
0x0003FFE1,
0x0003FFE2,
0x0003FFEA,
0x0003FFE3,
0x0003FFE6,
0x0003FFE7,
0x0003FFEB,
0x000FFFE6,
0x0007FFE2,
0x000FFFE7,
0x000FFFE8,
0x000FFFE9,
0x000FFFEA,
0x000FFFEB,
0x000FFFEC,
0x0007FFE3,
0x000FFFED,
0x000FFFEE,
0x000FFFEF,
0x000FFFF0,
0x0007FFE4,
0x000FFFF1,
0x0003FFEC,
0x000FFFF2,
0x000FFFF3,
0x0007FFE5,
0x0007FFE6,
0x000FFFF4,
0x000FFFF5,
0x000FFFF6,
0x000FFFF7,
0x000FFFF8,
0x000FFFF9,
0x000FFFFA,
0x000FFFFB,
0x000FFFFC,
0x000FFFFD,
0x000FFFFE,
0x000FFFFF
};

const unsigned char v_Huff_envelopeLevelL10F[121] =
{
0x00000013,
0x00000013,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000013,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000013,
0x00000014,
0x00000013,
0x00000013,
0x00000014,
0x00000012,
0x00000014,
0x00000014,
0x00000014,
0x00000013,
0x00000014,
0x00000014,
0x00000014,
0x00000013,
0x00000014,
0x00000013,
0x00000012,
0x00000013,
0x00000012,
0x00000012,
0x00000011,
0x00000012,
0x00000011,
0x00000011,
0x00000011,
0x00000010,
0x00000010,
0x00000010,
0x0000000F,
0x0000000F,
0x0000000E,
0x0000000D,
0x0000000D,
0x0000000C,
0x0000000C,
0x0000000B,
0x0000000A,
0x00000009,
0x00000009,
0x00000008,
0x00000007,
0x00000006,
0x00000005,
0x00000004,
0x00000003,
0x00000002,
0x00000002,
0x00000003,
0x00000004,
0x00000005,
0x00000006,
0x00000008,
0x00000008,
0x00000009,
0x0000000A,
0x0000000B,
0x0000000B,
0x0000000B,
0x0000000C,
0x0000000C,
0x0000000D,
0x0000000D,
0x0000000E,
0x0000000E,
0x00000010,
0x00000010,
0x00000011,
0x00000011,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000014,
0x00000013,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000013,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000013,
0x00000014,
0x00000012,
0x00000014,
0x00000014,
0x00000013,
0x00000013,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014,
0x00000014
};


const int bookSbrEnvBalanceC10T[49] =
{
0x0000FFE4,
0x0000FFE5,
0x0000FFE6,
0x0000FFE7,
0x0000FFE8,
0x0000FFE9,
0x0000FFEA,
0x0000FFEB,
0x0000FFEC,
0x0000FFED,
0x0000FFEE,
0x0000FFEF,
0x0000FFF0,
0x0000FFF1,
0x0000FFF2,
0x0000FFF3,
0x0000FFF4,
0x0000FFE2,
0x00000FFC,
0x000007FC,
0x000001FE,
0x0000007E,
0x0000001E,
0x00000006,
0x00000000,
0x00000002,
0x0000000E,
0x0000003E,
0x000000FE,
0x000007FD,
0x00000FFD,
0x00007FF0,
0x0000FFE3,
0x0000FFF5,
0x0000FFF6,
0x0000FFF7,
0x0000FFF8,
0x0000FFF9,
0x0000FFFA,
0x0001FFF6,
0x0001FFF7,
0x0001FFF8,
0x0001FFF9,
0x0001FFFA,
0x0001FFFB,
0x0001FFFC,
0x0001FFFD,
0x0001FFFE,
0x0001FFFF
};


const unsigned char bookSbrEnvBalanceL10T[49] =
{
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x0000000C,
0x0000000B,
0x00000009,
0x00000007,
0x00000005,
0x00000003,
0x00000001,
0x00000002,
0x00000004,
0x00000006,
0x00000008,
0x0000000B,
0x0000000C,
0x0000000F,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000010,
0x00000011,
0x00000011,
0x00000011,
0x00000011,
0x00000011,
0x00000011,
0x00000011,
0x00000011,
0x00000011,
0x00000011
};


const int bookSbrEnvBalanceC10F[49] =
{
0x0003FFE2,
0x0003FFE3,
0x0003FFE4,
0x0003FFE5,
0x0003FFE6,
0x0003FFE7,
0x0003FFE8,
0x0003FFE9,
0x0003FFEA,
0x0003FFEB,
0x0003FFEC,
0x0003FFED,
0x0003FFEE,
0x0003FFEF,
0x0003FFF0,
0x0000FFF7,
0x0001FFF0,
0x00003FFC,
0x000007FE,
0x000007FC,
0x000000FE,
0x0000007E,
0x0000000E,
0x00000002,
0x00000000,
0x00000006,
0x0000001E,
0x0000003E,
0x000001FE,
0x000007FD,
0x00000FFE,
0x00007FFA,
0x0000FFF6,
0x0003FFF1,
0x0003FFF2,
0x0003FFF3,
0x0003FFF4,
0x0003FFF5,
0x0003FFF6,
0x0003FFF7,
0x0003FFF8,
0x0003FFF9,
0x0003FFFA,
0x0003FFFB,
0x0003FFFC,
0x0003FFFD,
0x0003FFFE,
0x0007FFFE,
0x0007FFFF
};


const unsigned char bookSbrEnvBalanceL10F[49] =
{
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000010,
0x00000011,
0x0000000E,
0x0000000B,
0x0000000B,
0x00000008,
0x00000007,
0x00000004,
0x00000002,
0x00000001,
0x00000003,
0x00000005,
0x00000006,
0x00000009,
0x0000000B,
0x0000000C,
0x0000000F,
0x00000010,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000012,
0x00000013,
0x00000013
};


const int v_Huff_envelopeLevelC11T[63] = {
  0x0003FFED, 0x0003FFEE, 0x0007FFDE, 0x0007FFDF, 0x0007FFE0, 0x0007FFE1,
    0x0007FFE2, 0x0007FFE3,
  0x0007FFE4, 0x0007FFE5, 0x0007FFE6, 0x0007FFE7, 0x0007FFE8, 0x0007FFE9,
    0x0007FFEA, 0x0007FFEB,
  0x0007FFEC, 0x0001FFF4, 0x0000FFF7, 0x0000FFF9, 0x0000FFF8, 0x00003FFB,
    0x00003FFA, 0x00003FF8,
  0x00001FFA, 0x00000FFC, 0x000007FC, 0x000000FE, 0x0000003E, 0x0000000E,
    0x00000002, 0x00000000,
  0x00000006, 0x0000001E, 0x0000007E, 0x000001FE, 0x000007FD, 0x00001FFB,
    0x00003FF9, 0x00003FFC,
  0x00007FFA, 0x0000FFF6, 0x0001FFF5, 0x0003FFEC, 0x0007FFED, 0x0007FFEE,
    0x0007FFEF, 0x0007FFF0,
  0x0007FFF1, 0x0007FFF2, 0x0007FFF3, 0x0007FFF4, 0x0007FFF5, 0x0007FFF6,
    0x0007FFF7, 0x0007FFF8,
  0x0007FFF9, 0x0007FFFA, 0x0007FFFB, 0x0007FFFC, 0x0007FFFD, 0x0007FFFE,
    0x0007FFFF
};


const unsigned char v_Huff_envelopeLevelL11T[63] = {
  0x00000012, 0x00000012, 0x00000013, 0x00000013, 0x00000013, 0x00000013,
    0x00000013, 0x00000013,
  0x00000013, 0x00000013, 0x00000013, 0x00000013, 0x00000013, 0x00000013,
    0x00000013, 0x00000013,
  0x00000013, 0x00000011, 0x00000010, 0x00000010, 0x00000010, 0x0000000E,
    0x0000000E, 0x0000000E,
  0x0000000D, 0x0000000C, 0x0000000B, 0x00000008, 0x00000006, 0x00000004,
    0x00000002, 0x00000001,
  0x00000003, 0x00000005, 0x00000007, 0x00000009, 0x0000000B, 0x0000000D,
    0x0000000E, 0x0000000E,
  0x0000000F, 0x00000010, 0x00000011, 0x00000012, 0x00000013, 0x00000013,
    0x00000013, 0x00000013,
  0x00000013, 0x00000013, 0x00000013, 0x00000013, 0x00000013, 0x00000013,
    0x00000013, 0x00000013,
  0x00000013, 0x00000013, 0x00000013, 0x00000013, 0x00000013, 0x00000013,
    0x00000013
};


const int v_Huff_envelopeLevelC11F[63] = {
  0x000FFFF0, 0x000FFFF1, 0x000FFFF2, 0x000FFFF3, 0x000FFFF4, 0x000FFFF5,
    0x000FFFF6, 0x0003FFF3,
  0x0007FFF5, 0x0007FFEE, 0x0007FFEF, 0x0007FFF6, 0x0003FFF4, 0x0003FFF2,
    0x000FFFF7, 0x0007FFF0,
  0x0001FFF5, 0x0003FFF0, 0x0001FFF4, 0x0000FFF7, 0x0000FFF6, 0x00007FF8,
    0x00003FFB, 0x00000FFD,
  0x000007FD, 0x000003FD, 0x000001FD, 0x000000FD, 0x0000003E, 0x0000000E,
    0x00000002, 0x00000000,
  0x00000006, 0x0000001E, 0x000000FC, 0x000001FC, 0x000003FC, 0x000007FC,
    0x00000FFC, 0x00001FFC,
  0x00003FFA, 0x00007FF9, 0x00007FFA, 0x0000FFF8, 0x0000FFF9, 0x0001FFF6,
    0x0001FFF7, 0x0003FFF5,
  0x0003FFF6, 0x0003FFF1, 0x000FFFF8, 0x0007FFF1, 0x0007FFF2, 0x0007FFF3,
    0x000FFFF9, 0x0007FFF7,
  0x0007FFF4, 0x000FFFFA, 0x000FFFFB, 0x000FFFFC, 0x000FFFFD, 0x000FFFFE,
    0x000FFFFF
};


const unsigned char v_Huff_envelopeLevelL11F[63] = {
  0x00000014, 0x00000014, 0x00000014, 0x00000014, 0x00000014, 0x00000014,
    0x00000014, 0x00000012,
  0x00000013, 0x00000013, 0x00000013, 0x00000013, 0x00000012, 0x00000012,
    0x00000014, 0x00000013,
  0x00000011, 0x00000012, 0x00000011, 0x00000010, 0x00000010, 0x0000000F,
    0x0000000E, 0x0000000C,
  0x0000000B, 0x0000000A, 0x00000009, 0x00000008, 0x00000006, 0x00000004,
    0x00000002, 0x00000001,
  0x00000003, 0x00000005, 0x00000008, 0x00000009, 0x0000000A, 0x0000000B,
    0x0000000C, 0x0000000D,
  0x0000000E, 0x0000000F, 0x0000000F, 0x00000010, 0x00000010, 0x00000011,
    0x00000011, 0x00000012,
  0x00000012, 0x00000012, 0x00000014, 0x00000013, 0x00000013, 0x00000013,
    0x00000014, 0x00000013,
  0x00000013, 0x00000014, 0x00000014, 0x00000014, 0x00000014, 0x00000014,
    0x00000014
};


const int bookSbrEnvBalanceC11T[25] =
{
0x00001FF2,
0x00001FF3,
0x00001FF4,
0x00001FF5,
0x00001FF6,
0x00001FF7,
0x00001FF8,
0x00000FF8,
0x000000FE,
0x0000007E,
0x0000000E,
0x00000006,
0x00000000,
0x00000002,
0x0000001E,
0x0000003E,
0x000001FE,
0x00001FF9,
0x00001FFA,
0x00001FFB,
0x00001FFC,
0x00001FFD,
0x00001FFE,
0x00003FFE,
0x00003FFF
};


const unsigned char bookSbrEnvBalanceL11T[25] =
{
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000C,
0x00000008,
0x00000007,
0x00000004,
0x00000003,
0x00000001,
0x00000002,
0x00000005,
0x00000006,
0x00000009,
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000E,
0x0000000E
};


const int bookSbrEnvBalanceC11F[25] =
{
0x00001FF7,
0x00001FF8,
0x00001FF9,
0x00001FFA,
0x00001FFB,
0x00003FF8,
0x00003FF9,
0x000007FC,
0x000000FE,
0x0000007E,
0x0000000E,
0x00000002,
0x00000000,
0x00000006,
0x0000001E,
0x0000003E,
0x000001FE,
0x00000FFA,
0x00001FF6,
0x00003FFA,
0x00003FFB,
0x00003FFC,
0x00003FFD,
0x00003FFE,
0x00003FFF
};


const unsigned char bookSbrEnvBalanceL11F[25] =
{
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000D,
0x0000000E,
0x0000000E,
0x0000000B,
0x00000008,
0x00000007,
0x00000004,
0x00000002,
0x00000001,
0x00000003,
0x00000005,
0x00000006,
0x00000009,
0x0000000C,
0x0000000D,
0x0000000E,
0x0000000E,
0x0000000E,
0x0000000E,
0x0000000E,
0x0000000E
};


const int v_Huff_NoiseLevelC11T[63] = {
  0x00001FCE, 0x00001FCF, 0x00001FD0, 0x00001FD1, 0x00001FD2, 0x00001FD3,
    0x00001FD4, 0x00001FD5,
  0x00001FD6, 0x00001FD7, 0x00001FD8, 0x00001FD9, 0x00001FDA, 0x00001FDB,
    0x00001FDC, 0x00001FDD,
  0x00001FDE, 0x00001FDF, 0x00001FE0, 0x00001FE1, 0x00001FE2, 0x00001FE3,
    0x00001FE4, 0x00001FE5,
  0x00001FE6, 0x00001FE7, 0x000007F2, 0x000000FD, 0x0000003E, 0x0000000E,
    0x00000006, 0x00000000,
  0x00000002, 0x0000001E, 0x000000FC, 0x000003F8, 0x00001FCC, 0x00001FE8,
    0x00001FE9, 0x00001FEA,
  0x00001FEB, 0x00001FEC, 0x00001FCD, 0x00001FED, 0x00001FEE, 0x00001FEF,
    0x00001FF0, 0x00001FF1,
  0x00001FF2, 0x00001FF3, 0x00001FF4, 0x00001FF5, 0x00001FF6, 0x00001FF7,
    0x00001FF8, 0x00001FF9,
  0x00001FFA, 0x00001FFB, 0x00001FFC, 0x00001FFD, 0x00001FFE, 0x00003FFE,
    0x00003FFF
};


const unsigned char v_Huff_NoiseLevelL11T[63] = {
  0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D,
    0x0000000D, 0x0000000D,
  0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D,
    0x0000000D, 0x0000000D,
  0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D,
    0x0000000D, 0x0000000D,
  0x0000000D, 0x0000000D, 0x0000000B, 0x00000008, 0x00000006, 0x00000004,
    0x00000003, 0x00000001,
  0x00000002, 0x00000005, 0x00000008, 0x0000000A, 0x0000000D, 0x0000000D,
    0x0000000D, 0x0000000D,
  0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D,
    0x0000000D, 0x0000000D,
  0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D,
    0x0000000D, 0x0000000D,
  0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000D, 0x0000000E,
    0x0000000E
};


const int bookSbrNoiseBalanceC11T[25] =
{
0x000000EC,
0x000000ED,
0x000000EE,
0x000000EF,
0x000000F0,
0x000000F1,
0x000000F2,
0x000000F3,
0x000000F4,
0x000000F5,
0x0000001C,
0x00000002,
0x00000000,
0x00000006,
0x0000003A,
0x000000F6,
0x000000F7,
0x000000F8,
0x000000F9,
0x000000FA,
0x000000FB,
0x000000FC,
0x000000FD,
0x000000FE,
0x000000FF
};


const unsigned char bookSbrNoiseBalanceL11T[25] =
{
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000005,
0x00000002,
0x00000001,
0x00000003,
0x00000006,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008,
0x00000008
};

