// Automatically created with man2help.sh, don't edit!

#include "operator_help.h"

// clang-format off

const CdoHelp AdisitHelp = {
    "NAME",
    "    adisit, adipot - Potential temperature to in-situ temperature and vice versa",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,pressure]  infile outfile",
    "",
    "OPERATORS",
    "",
    "    adisit Potential temperature to in-situ temperature",
    "",
    "           This is a special operator for the post processing of the ocean and sea ice model [MPIOM].",
    "           It converts potential temperature adiabatically to in-situ temperature to(t, s, p).",
    "           Required input fields are sea water potential temperature (name=tho; code=2) and sea water",
    "           salinity (name=sao; code=5).  Pressure is calculated from the level information or can be",
    "           specified by the optional parameter.  Output fields are sea water temperature (name=to;",
    "           code=20) and sea water salinity (name=s; code=5).",
    "",
    "    adipot In-situ temperature to potential temperature",
    "",
    "           This is a special operator for the post processing of the ocean and sea ice model [MPIOM].",
    "           It converts in-situ temperature to potential temperature tho(to, s, p). Required input",
    "           fields are sea water in-situ temperature (name=t; code=2) and sea water salinity",
    "           (name=sao,s; code=5).  Pressure is calculated from the level information or can be",
    "           specified by the optional parameter.  Output fields are sea water temperature (name=tho;",
    "           code=2) and sea water salinity (name=s; code=5).",
    "",
    "PARAMETERS",
    "",
    "    pressure (FLOAT)",
    "           Pressure in bar (constant value assigned to all levels)",
    "",
    "AUTHOR",
    "    Uwe Schulzweida, Helmut Haak",
    "",
};

const CdoHelp AfterburnerHelp = {
    "NAME",
    "    after - ECHAM standard post processor",
    "",
    "SYNOPSIS",
    "    cdo  after[,vct]  infile outfile",
    "",
    "DESCRIPTION",
    "    The afterburner is the standard post processor for [ECHAM] GRIB and NetCDF data which provides the",
    "    following operations:",
    "",
    "    • Extract specified variables and levels",
    "",
    "    • Compute derived variables",
    "",
    "    • Transform spectral data to Gaussian grid representation",
    "",
    "    • Vertical interpolation to pressure levels",
    "",
    "    • Compute temporal means",
    "",
    "    This operator reads selection parameters as namelist from stdin.  Use the UNIX redirection",
    "    “<namelistfile” to read the namelist from file.",
    "",
    "    The input files can’t be combined with other CDO operators because of an optimized reader for this",
    "    operator.",
    "",
    "NAMELIST",
    "    Namelist parameter and there defaults:",
    "",
    "       TYPE=0, CODE=-1, LEVEL=-1, INTERVAL=0, MEAN=0, EXTRAPOLATE=1",
    "",
    "    TYPE controls the transformation and vertical interpolation. Transforming spectral data to",
    "    Gaussian grid representation and vertical interpolation to pressure levels are performed in a",
    "    chain of steps.  The TYPE parameter may be used to stop the chain at a certain step. Valid values",
    "    are:",
    "",
    "       TYPE  =  0 : Hybrid   level spectral coefficients",
    "       TYPE  = 10 : Hybrid   level fourier  coefficients",
    "       TYPE  = 11 : Hybrid   level zonal mean sections",
    "       TYPE  = 20 : Hybrid   level gauss grids",
    "       TYPE  = 30 : Pressure level gauss grids",
    "       TYPE  = 40 : Pressure level fourier  coefficients",
    "       TYPE  = 41 : Pressure level zonal mean sections",
    "       TYPE  = 50 : Pressure level spectral coefficients",
    "       TYPE  = 60 : Pressure level fourier  coefficients",
    "       TYPE  = 61 : Pressure level zonal mean sections",
    "       TYPE  = 70 : Pressure level gauss grids",
    "",
    "    Vorticity, divergence, streamfunction and velocity potential need special treatment in the",
    "    vertical transformation.  They are not available as types 30, 40 and 41. If you select one of",
    "    these combinations, type is automatically switched to the equivalent types 70, 60 and 61. The type",
    "    of all other variables will be switched too, because the type is a global parameter.",
    "",
    "    CODE selects the variables by the ECHAM GRIB1 code number (1-255). The default value -1 processes",
    "    all detected codes.  Derived variables computed by the afterburner:",
    "",
    "               ┌─────┬───────────┬─────────────────┬───────┬─────────────┬────────────────┐",
    "               │Code │ Name      │ Longname        │ Units │ Level       │ Needed Codes   │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │34   │ low_cld   │ low cloud       │       │ single      │ 223 on         │",
    "               │     │           │                 │       │             │ modellevel     │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │35   │ mid_cld   │ mid cloud       │       │ single      │ 223 on         │",
    "               │     │           │                 │       │             │ modellevel     │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │36   │ hih_cld   │ high cloud      │       │ single      │ 223 on         │",
    "               │     │           │                 │       │             │ modellevel     │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │131  │ u         │ u-velocity      │ m/s   │ atm (ml+pl) │ 138, 155       │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │132  │ v         │ v-velocity      │ m/s   │ atm (ml+pl) │ 138, 155       │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │135  │ omega     │ vertical        │ Pa/s  │ atm (ml+pl) │ 138, 152, 155  │",
    "               │     │           │ velocity        │       │             │                │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │148  │ stream    │ streamfunction  │ m^2/s │ atm (ml+pl) │ 131, 132       │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │149  │ velopot   │ velocity        │ m^2/s │ atm (ml+pl) │ 131, 132       │",
    "               │     │           │ potential       │       │             │                │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │151  │ slp       │ mean sea level  │ Pa    │ surface     │ 129, 130, 152  │",
    "               │     │           │ pressure        │       │             │                │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │156  │ geopoth   │ geopotential    │ m     │ atm (ml+pl) │ 129, 130, 133, │",
    "               │     │           │ height          │       │             │ 152            │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │157  │ rhumidity │ relative        │       │ atm (ml+pl) │ 130, 133, 152  │",
    "               │     │           │ humidity        │       │             │                │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │189  │ sclfs     │ surface solar   │       │ surface     │ 176-185        │",
    "               │     │           │ cloud forcing   │       │             │                │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │190  │ tclfs     │ surface thermal │       │ surface     │ 177-186        │",
    "               │     │           │ cloud forcing   │       │             │                │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │191  │ sclf0     │ top solar cloud │       │ surface     │ 178-187        │",
    "               │     │           │ forcing         │       │             │                │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │192  │ tclf0     │ top thermal     │       │ surface     │ 179-188        │",
    "               │     │           │ cloud forcing   │       │             │                │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │259  │ windspeed │ windspeed       │ m/s   │ atm (ml+pl) │ sqrt(u*u+v*v)  │",
    "               ├─────┼───────────┼─────────────────┼───────┼─────────────┼────────────────┤",
    "               │260  │ precip    │ total           │       │ surface     │ 142+143        │",
    "               │     │           │ precipitation   │       │             │                │",
    "               └─────┴───────────┴─────────────────┴───────┴─────────────┴────────────────┘",
    "    LEVEL selects the hybrid or pressure levels. The allowed values depends on the parameter TYPE.",
    "    The default value -1 processes all detected levels.",
    "",
    "    INTERVAL selects the processing interval. The default value 0 process data on monthly intervals.",
    "    INTERVAL=1 sets the interval to daily.",
    "",
    "    MEAN=1 compute and write monthly or daily mean fields. The default value 0 writes out all",
    "    timesteps.",
    "",
    "    EXTRAPOLATE=0 switch of the extrapolation of missing values during the interpolation from model to",
    "    pressure level (only available with MEAN=0 and TYPE=30). The default value 1 extrapolate missing",
    "    values.",
    "",
    "    Possible combinations of TYPE, CODE and MEAN:",
    "",
    "                               ┌────────┬──────┬────────────────────┬──────┐",
    "                               │TYPE    │ CODE │                    │ MEAN │",
    "                               ├────────┼──────┼────────────────────┼──────┤",
    "                               │0/10/11 │ 130  │ temperature        │ 0    │",
    "                               ├────────┼──────┼────────────────────┼──────┤",
    "                               │0/10/11 │ 131  │ u-velocity         │ 0    │",
    "                               ├────────┼──────┼────────────────────┼──────┤",
    "                               │0/10/11 │ 132  │ v-velocity         │ 0    │",
    "                               ├────────┼──────┼────────────────────┼──────┤",
    "                               │0/10/11 │ 133  │ specific humidity  │ 0    │",
    "                               ├────────┼──────┼────────────────────┼──────┤",
    "                               │0/10/11 │ 138  │ vorticity          │ 0    │",
    "                               ├────────┼──────┼────────────────────┼──────┤",
    "                               │0/10/11 │ 148  │ streamfunction     │ 0    │",
    "                               ├────────┼──────┼────────────────────┼──────┤",
    "                               │0/10/11 │ 149  │ velocity potential │ 0    │",
    "                               ├────────┼──────┼────────────────────┼──────┤",
    "                               │0/10/11 │ 152  │ LnPs               │ 0    │",
    "                               ├────────┼──────┼────────────────────┼──────┤",
    "                               │0/10/11 │ 155  │ divergence         │ 0    │",
    "                               ├────────┼──────┼────────────────────┼──────┤",
    "                               │>11     │ all  │ codes              │ 0/1  │",
    "                               └────────┴──────┴────────────────────┴──────┘",
    "PARAMETERS",
    "",
    "    vct (STRING)",
    "           File with VCT in ASCII format",
    "",
    "EXAMPLE",
    "    To interpolate ECHAM hybrid model level data to pressure levels of 925, 850, 500 and 200 hPa, use:",
    "",
    "       cdo after infile outfile << EON",
    "          TYPE=30  LEVEL=92500,85000,50000,20000",
    "       EON",
    "",
};

const CdoHelp ArithHelp = {
    "NAME",
    "    add, sub, mul, div, min, max, atan2, setmiss - Arithmetic on two datasets",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of two datasets.  The number of fields in infile1 should be",
    "    the same as in infile2.  The fields in outfile inherit the meta data from infile1.  All operators",
    "    in this module simply process one field after the other from the two input files.  Neither the",
    "    order of the variables nor the date is checked.  One of the input files can contain only one",
    "    timestep or one variable.",
    "",
    "OPERATORS",
    "",
    "    add    Add two fields",
    "",
    "           o(t,x) = i_1(t,x) + i_2(t,x)",
    "",
    "    sub    Subtract two fields",
    "",
    "           o(t,x) = i_1(t,x) - i_2(t,x)",
    "",
    "    mul    Multiply two fields",
    "",
    "           o(t,x) = i_1(t,x) * i_2(t,x)",
    "",
    "    div    Divide two fields",
    "",
    "           o(t,x) = i_1(t,x) / i_2(t,x)",
    "",
    "    min    Minimum of two fields",
    "",
    "           o(t,x) = min(i_1(t,x), i_2(t,x))",
    "",
    "    max    Maximum of two fields",
    "",
    "           o(t,x) = max(i_1(t,x), i_2(t,x))",
    "",
    "    atan2  Arc tangent of two fields",
    "",
    "           The atan2 operator calculates the arc tangent of two fields. The result is in radians,",
    "           which is between -PI and PI (inclusive).",
    "",
    "           o(t,x) = atan2(i_1(t,x), i_2(t,x))",
    "",
    "    setmiss",
    "           Set missing values",
    "",
    "           Sets missing values of infile1 to values from infile2.",
    "",
    "EXAMPLE",
    "    To sum all fields of the first input file with the corresponding fields of the second input file",
    "    use:",
    "",
    "       cdo add infile1 infile2 outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ArithcHelp = {
    "NAME",
    "    addc, subc, mulc, divc, minc, maxc - Arithmetic with a constant",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic with all field elements of a dataset and a constant. The",
    "    fields in outfile inherit the meta data from infile.",
    "",
    "OPERATORS",
    "",
    "    addc   Add a constant",
    "",
    "           o(t,x) = i(t,x) + c",
    "",
    "    subc   Subtract a constant",
    "",
    "           o(t,x) = i(t,x) - c",
    "",
    "    mulc   Multiply with a constant",
    "",
    "           o(t,x) = i(t,x) * c",
    "",
    "    divc   Divide by a constant",
    "",
    "           o(t,x) = i(t,x) / c",
    "",
    "    minc   Minimum of a field and a constant",
    "",
    "           o(t,x) = min(i(t,x), c)",
    "",
    "    maxc   Maximum of a field and a constant",
    "",
    "           o(t,x) = max(i(t,x), c)",
    "",
    "PARAMETERS",
    "",
    "    c (FLOAT)",
    "           Constant",
    "",
    "EXAMPLE",
    "    To sum all input fields with the constant -273.15 use:",
    "",
    "       cdo addc,-273.15 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ArithdaysHelp = {
    "NAME",
    "    muldpm, divdpm, muldpy, divdpy - Arithmetic with days",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module multiplies or divides each timestep of a dataset with the corresponding days per month",
    "    or days per year. The result of these functions depends on the used calendar of the input data.",
    "",
    "OPERATORS",
    "",
    "    muldpm Multiply with days per month",
    "",
    "           o(t,x) = i(t,x) * days_per_month",
    "",
    "    divdpm Divide by days per month",
    "",
    "           o(t,x) = i(t,x) / days_per_month",
    "",
    "    muldpy Multiply with days per year",
    "",
    "           o(t,x) = i(t,x) * days_per_year",
    "",
    "    divdpy Divide by days per year",
    "",
    "           o(t,x) = i(t,x) / days_per_year",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ArithlatHelp = {
    "NAME",
    "    mulcoslat, divcoslat - Arithmetic with latitude",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module multiplies or divides each field element with the cosine of the latitude.",
    "",
    "OPERATORS",
    "",
    "    mulcoslat",
    "           Multiply with the cosine of the latitude",
    "",
    "           o(t,x) = i(t,x) * cos(latitude(x))",
    "",
    "    divcoslat",
    "           Divide by cosine of the latitude",
    "",
    "           o(t,x) = i(t,x) / cos(latitude(x))",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp BitroundingHelp = {
    "NAME",
    "    bitrounding - Bit rounding",
    "",
    "SYNOPSIS",
    "    cdo  bitrounding[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator calculates for each field the number of necessary mantissa bits to get a certain",
    "    information level in the data. With this number of significant bits (numbits) a rounding of the",
    "    data is performed.  This allows the data to be compressed to a higher level.",
    "",
    "    The default value of the information level is 0.9999 and can be adjusted with the parameter",
    "    inflevel.  That means 99.99% of the information in the mantissa bits is preserved.",
    "",
    "    Alternatively, the number of significant bits can be set for all variables with the numbits",
    "    parameter.  Furthermore, numbits can be assigned for each variable via the filename parameter. In",
    "    this case, numbits is still calculated for all variables if they are not present in the file.",
    "",
    "    The analysis of the bit information is based on the Julia library BitInformation.jl.  The",
    "    procedure to derive the number of significant mantissa bits was adapted from the Python library",
    "    xbitinfo.  Quantize to the number of mantissa bits is done with IEEE rounding using code from",
    "    NetCDF 4.9.0.",
    "",
    "    Currently only 32-bit float data is rounded. Data with missing values are not yet supported for",
    "    the calculation of significant bits.",
    "",
    "PARAMETERS",
    "",
    "    inflevel (FLOAT)",
    "           Information level (0 - 1) [default: 0.9999]",
    "",
    "    addbits (INTEGER)",
    "           Add bits to the number of significant bits [default: 0]",
    "",
    "    minbits (INTEGER)",
    "           Minimum value of the number of bits [default: 1]",
    "",
    "    maxbits (INTEGER)",
    "           Maximum value of the number of bits [default: 23]",
    "",
    "    numsteps (INTEGER)",
    "           Set to 1 to run the calculation only in the first time step",
    "",
    "    numbits (INTEGER)",
    "           Set number of significant bits",
    "",
    "    printbits (BOOL)",
    "           Print max. numbits per variable of 1st timestep to stdout [format: name=numbits]",
    "",
    "    filename (STRING)",
    "           Read number of significant bits per variable from file [format: name=numbits]",
    "",
    "EXAMPLE",
    "    Apply bit rounding to all 32-bit float fields, preserving 99.9% of the information, followed by",
    "    compression and storage to NetCDF4:",
    "",
    "       cdo -f nc4 -z zip bitrounding,inflevel=0.999 infile outfile",
    "",
    "    Add the option -v to view used number of mantissa bits for each field:",
    "",
    "       cdo -v -f nc4 -z zip bitrounding,inflevel=0.999 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ChangeHelp = {
    "NAME",
    "    chcode, chparam, chname, chunit, chlevel, chlevelc, chlevelv - Change field header",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module reads fields from infile, changes some header values and writes the results to",
    "    outfile. The kind of changes depends on the chosen operator.",
    "",
    "OPERATORS",
    "",
    "    chcode Change code number",
    "",
    "           Changes some user given code numbers to new user given values (Parameter: oldcode newcode",
    "           […]).",
    "",
    "    chparam",
    "           Change parameter identifier",
    "",
    "           Changes some user given parameter identifiers to new user given values (Parameter: oldparam",
    "           newparam …).",
    "",
    "    chname Change variable or coordinate name",
    "",
    "           Changes some user given variable or coordinate names to new user given names (Parameter:",
    "           oldname newname …).",
    "",
    "    chunit Change variable unit",
    "",
    "           Changes some user given variable units to new user given units (Parameter: oldunit newunit",
    "           …).",
    "",
    "    chlevel",
    "           Change level",
    "",
    "           Changes some user given levels to new user given values (Parameter: oldlev newlev …).",
    "",
    "    chlevelc",
    "           Change level of one code",
    "",
    "           Changes one level of a user given code number (Parameter: code oldlev newlev).",
    "",
    "    chlevelv",
    "           Change level of one variable",
    "",
    "           Changes one level of a user given variable name (Parameter: name oldlev newlev).",
    "",
    "PARAMETERS",
    "",
    "    code (INTEGER)",
    "           Code number",
    "",
    "    oldcode,newcode,… (INTEGER)",
    "           Pairs of old and new code numbers",
    "",
    "    oldparam,newparam,… (STRING)",
    "           Pairs of old and new parameter identifiers",
    "",
    "    name (STRING)",
    "           Variable name",
    "",
    "    oldname,newname,… (STRING)",
    "           Pairs of old and new variable names",
    "",
    "    oldlev (FLOAT)",
    "           Old level",
    "",
    "    newlev (FLOAT)",
    "           New level",
    "",
    "    oldlev,newlev,… (FLOAT)",
    "           Pairs of old and new levels",
    "",
    "EXAMPLE",
    "    To change the code number 98 to 179 and 99 to 211 use:",
    "",
    "       cdo chcode,98,179,99,211 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp CmorHelp = {
    "NAME",
    "    cmor - Climate Model Output Rewriting to produce CMIP-compliant data",
    "",
    "SYNOPSIS",
    "    cdo  cmor,MIPtable[,cmor_name=VarList[,key=value[,…]]]  infile",
    "",
    "DESCRIPTION",
    "    The CDO operator cmor converts an infile into a CMIP-compliant format by using the CMOR library.",
    "    Each output file contains a single output variable.  The name of the output files are generated by",
    "    CMOR according to a template based on the DRS (Data reference Syntax) of the project. CMOR checks",
    "    and applies the information delivered through the project dependent MIPtable on the infile.",
    "    Additional information which is required for the conversion can be configured via keyvalues as",
    "    optional parameters.",
    "",
    "    By specifying a variable selector keyvalue, e.g. cmor_name=tas, the user can pre-select a subset",
    "    of infile variables. If name or code is specified, a corresponding cmor_name which can also be",
    "    found in the MIPtable is also required to map the infile variable to the CMOR-variable. For",
    "    mapping more variables at the operator call, one can specify a mapping table via keyword",
    "    mapping_table.",
    "",
    "    Global attributes must be collected in info files and can be specified via keyword info. All",
    "    required and optional global attributes as well as information about table file formats are given",
    "    in the ‘cdo cmor manual’.",
    "",
    "    If questions remain, do not hesitate to ask and send an email to wachsmannATdkrz.de.",
    "",
    "PARAMETERS",
    "",
    "    MIPtable (STRING)",
    "           Name of the MIP table as used by CMOR.",
    "",
    "    cmor_name           | cn (STRING)",
    "           Variable selector and specified in the MIP table.",
    "           Comma-separated list of CMOR variable names.",
    "           Default is to process all variables.",
    "",
    "",
    "    name                | n (STRING)",
    "           Variable selector.",
    "           Name of a selected infile variable.",
    "",
    "",
    "    code                | c (INTEGER)",
    "           Variable selector.",
    "           Three digits (GRIB) Code of a selected infile variable.",
    "",
    "",
    "    info                | i (STRING)",
    "           Preprozessing.",
    "           Comma-separated list of filenames.",
    "           Containins global attributes and control keywords.",
    "           Default: CWD/.cdocmorinfo",
    "",
    "",
    "    grid_info           | gi (STRING)",
    "           Preprozessing.",
    "           NetCDF or table formatted file with model grid description.",
    "           Horizontal and vertical axes are substituted with the ones from grid info file.",
    "",
    "",
    "    mapping_table       | mt (STRING)",
    "           Preprozessing.",
    "           Fortran Namelist containing variable information for e.g. renaming.",
    "",
    "",
    "    keep_all_attributes | kaa (STRING)",
    "           Preprozessing.",
    "           ‘y’ for passing all infile attributes. ‘n’ for discarding all infile attributes.",
    "",
    "",
    "    drs                 | d (CHARACTER)",
    "           Output control.",
    "           Do(=y, default) or do not(=n) move output into the project DRS structure.",
    "",
    "",
    "    drs_root            | dr (STRING)",
    "           Output control. CMOR output root directory.",
    "           Default: CWD.",
    "",
    "",
    "    output_mode         | om (CHARACTER)",
    "           Output control.  Either ‘r’ for replace (default) or ‘a’ for append mode.",
    "",
    "    last_chunk          | lc (STRING)",
    "           Output control. Filename of chunk to which shall be appended.",
    "",
    "    max_size            | ms (INTEGER)",
    "           Output control. Limit of output file sie in GigaByte.",
    "",
    "    deflate_level       | dl (INTEGER)",
    "           Output control. Compression level. -1: No compression. 0: Only shuffle.",
    "",
    "    version_date        | vd (INTEGER)",
    "           Output control. Subdirectory name in CMIP6 DRS.",
    "",
    "    required_time_units | rtu (STRING)",
    "           Temporal description.",
    "           Time axis reference date specified by the experiment.",
    "           Format: ‘days since YYYY-day-month hh:mm:ss’.",
    "",
    "",
    "    cell_methods        | cm (CHARACTER)",
    "           Temporal description.",
    "           Cell_methods of time axis.",
    "           Value is one of ‘m’ (default), ‘p’, ‘c’, ‘n’, ‘d’",
    "",
    "",
    "    units               | u (STRING)",
    "           Variable attribute. Units of the variable.",
    "           Must be known by library UDunits.",
    "",
    "",
    "    variable_comment    | vc (STRING)",
    "           Variable attribute. Variable comment.",
    "",
    "    positive            | p (CHARACTER)",
    "           Variable attribute.  Positive flux direction, either ‘u’ for upward or ‘d’ for downward.",
    "",
    "    z_axis              | za (STRING)",
    "           Name of the coordinate variable associated with the z-axis of the target variable.",
    "",
    "    character_axis      | ca (STRING)",
    "           Name of the coordinate variable associated with",
    "           a character axis of the target variable.",
    "           Valid axes names are: basin, vegtype or oline.",
    "",
    "",
    "    t_axis              | ta (STRING)",
    "           Sets time values and time bounds to the nearest value",
    "           required by the project given by the value of t_axis.",
    "           Valid value is: cmip",
    "",
    "",
    "EXAMPLE",
    "    Process file with CMOR. In this case a grid mapping is used. The file {cmor.rc} contains metadata",
    "    CMOR expects for http://cmor.llnl.gov/mydoc_cmor3_api/#cmordatasetjson {cmor_dataset_json()}.",
    "",
    "       cdo cmor,Tables/CMIP6_day.json,__grid_table=Tables/CMIP6_grids.json,__info=cmor.rc CNRM-CERFACS_rllc.nc",
    "",
    "AUTHOR",
    "    Fabian Wachsmann",
    "",
};

const CdoHelp CmorliteHelp = {
    "NAME",
    "    cmorlite - CMOR lite",
    "",
    "SYNOPSIS",
    "    cdo  cmorlite,table[,convert]  infile outfile",
    "",
    "DESCRIPTION",
    "    The [CMOR] (Climate Model Output Rewriter) library comprises a set of functions, that can be used",
    "    to produce CF-compliant NetCDF files that fulfill the requirements of many of the climate",
    "    community’s standard model experiments. These experiments are collectively referred to as MIP’s.",
    "    Much of the metadata written to the output files is defined in MIP-specific tables, typically made",
    "    available from each MIP’s web site.",
    "",
    "    The CDO operator cmorlite process the header and variable section of such MIP tables and writes",
    "    the result with the internal IO library [CDI].  In addition to the CMOR 2 and 3 table format, the",
    "    CDO parameter table format is also supported. The following parameter table entries are available:",
    "",
    "                         ┌────────────────┬─────────┬────────────────────────────┐",
    "                         │Entry           │ Type    │ Description                │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │name            │ WORD    │ Name of the variable       │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │out_name        │ WORD    │ New name of the variable   │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │type            │ WORD    │ Data type (real or double) │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │standard_name   │ WORD    │ As defined in the CF       │",
    "                         │                │         │ standard name table        │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │long_name       │ STRING  │ Describing the variable    │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │units           │ STRING  │ Specifying the units for   │",
    "                         │                │         │ the variable               │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │comment         │ STRING  │ Information concerning the │",
    "                         │                │         │ variable                   │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │cell_methods    │ STRING  │ Information concerning     │",
    "                         │                │         │ calculation of means or    │",
    "                         │                │         │ climatologies              │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │cell_measures   │ STRING  │ Indicates the names of the │",
    "                         │                │         │ variables containing cell  │",
    "                         │                │         │ areas and volumes          │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │missing_value   │ FLOAT   │ Specifying how missing     │",
    "                         │                │         │ data will be identified    │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │valid_min       │ FLOAT   │ Minimum valid value        │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │valid_max       │ FLOAT   │ Maximum valid value        │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │ok_min_mean_abs │ FLOAT   │ Minimum absolute mean      │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │ok_max_mean_abs │ FLOAT   │ Maximum absolute mean      │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │factor          │ FLOAT   │ Scale factor               │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │delete          │ INTEGER │ Set to 1 to delete         │",
    "                         │                │         │ variable                   │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │convert         │ INTEGER │ Set to 1 to convert the    │",
    "                         │                │         │ unit if necessary          │",
    "                         └────────────────┴─────────┴────────────────────────────┘",
    "    Most of the above entries are stored as variables attributes, some of them are handled",
    "    differently.  The variable name is used as a search key for the parameter table. valid_min,",
    "    valid_max, ok_min_mean_abs and ok_max_mean_abs are used to check the range of the data.",
    "",
    "PARAMETERS",
    "",
    "    table (STRING)",
    "           Name of the CMOR table as specified from PCMDI",
    "",
    "    convert (STRING)",
    "           Converts the units if necessary",
    "",
    "EXAMPLE",
    "    Here is an example of a parameter table for one variable:",
    "",
    "       prompt> cat mypartab",
    "       &parameter",
    "       name            = t",
    "       out_name        = ta",
    "       standard_name   = air_temperature",
    "       units           = \"K\"",
    "       missing_value   = 1.0e+20",
    "       valid_min       = 157.1",
    "       valid_max       = 336.3",
    "       /",
    "",
    "    To apply this parameter table to a dataset use:",
    "",
    "       cdo -f nc cmorlite,mypartab,convert  infile  outfile",
    "",
    "    This command renames the variable t to ta. The standard name of this variable is set to",
    "    air_temperature and the unit is set to [K] (converts the unit if necessary). The missing value",
    "    will be set to 1.0e+20.  In addition it will be checked whether the values of the variable are in",
    "    the range of 157.1 to 336.3.  The result will be stored in NetCDF.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp CollgridHelp = {
    "NAME",
    "    collgrid - Collect horizontal grid",
    "",
    "SYNOPSIS",
    "    cdo  collgrid,parameters  infiles obase",
    "",
    "DESCRIPTION",
    "    This operator collects the data of the input files to one output file. All input files need to",
    "    have the same variables and the same number of timesteps on a different horizontal grid region.",
    "    If the source regions are on a structured lon/lat grid, all regions together must result in a new",
    "    structured lat/long grid box. Data on an unstructured grid are concatenated in the order of the",
    "    input files.  For ICON restart data, the array global_cell_indices is used for indexing if it is",
    "    available.  The parameter nx needs to be specified only for curvilinear grids.",
    "",
    "PARAMETERS",
    "",
    "    nx (INTEGER)",
    "           Number of regions in x direction [default: number of input files]",
    "",
    "    name (STRING)",
    "           Comma-separated list of variable names.",
    "",
    "    levidx (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of index of levels.",
    "",
    "    gridtype (STRING)",
    "           For unstructured grids, set to unstructured.",
    "",
    "NOTE",
    "    This operator needs to open all input files simultaneously.  The maximum number of open files",
    "    depends on the operating system!",
    "",
    "EXAMPLE",
    "    Collect the horizontal grid of 6 input files.  Each input file contains a lon/lat region of the",
    "    target grid:",
    "",
    "       cdo collgrid infile[1-6] outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp CompHelp = {
    "NAME",
    "    eq, ne, le, lt, ge, gt - Comparison of two fields",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module compares two datasets field by field.  The resulting field is a mask containing 1 if",
    "    the comparison is true and 0 if not.  The number of fields in infile1 should be the same as in",
    "    infile2.  One of the input files can contain only one timestep or one field.  The fields in",
    "    outfile inherit the meta data from infile1 or infile2.  The type of comparison depends on the",
    "    chosen operator.",
    "",
    "OPERATORS",
    "",
    "    eq     Equal",
    "",
    "                 /   1   if i_1(t,x) EQ i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "       o(t,x) = <    0   if i_1(t,x) NE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                 \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "",
    "    ne     Not equal",
    "",
    "                 /   1   if i_1(t,x) NE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "       o(t,x) = <    0   if i_1(t,x) EQ i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                 \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "",
    "    le     Less equal",
    "",
    "                 /   1   if i_1(t,x) LE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "       o(t,x) = <    0   if i_1(t,x) GT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                 \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "",
    "    lt     Less than",
    "",
    "                 /   1   if i_1(t,x) LT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "       o(t,x) = <    0   if i_1(t,x) GE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                 \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "",
    "    ge     Greater equal",
    "",
    "                 /   1   if i_1(t,x) GE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "       o(t,x) = <    0   if i_1(t,x) LT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                 \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "",
    "    gt     Greater than",
    "",
    "                 /   1   if i_1(t,x) GT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "       o(t,x) = <    0   if i_1(t,x) LE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss",
    "                 \\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss",
    "",
    "EXAMPLE",
    "    To create a mask containing 1 if the elements of two fields are the same and 0 if the elements are",
    "    different use:",
    "",
    "       cdo eq infile1 infile2 outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp CompcHelp = {
    "NAME",
    "    eqc, nec, lec, ltc, gec, gtc - Comparison of a field with a constant",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,c  infile outfile",
    "",
    "DESCRIPTION",
    "    This module compares all fields of a dataset with a constant. The resulting field is a mask",
    "    containing 1 if the comparison is true and 0 if not.  The type of comparison depends on the chosen",
    "    operator.",
    "",
    "OPERATORS",
    "",
    "    eqc    Equal constant",
    "",
    "                 /   1   if i(t,x) EQ c     AND  i(t,x),c NE miss",
    "       o(t,x) = <    0   if i(t,x) NE c     AND  i(t,x),c NE miss",
    "                 \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "",
    "    nec    Not equal constant",
    "",
    "                 /   1   if i(t,x) NE c     AND  i(t,x),c NE miss",
    "       o(t,x) = <    0   if i(t,x) EQ c     AND  i(t,x),c NE miss",
    "                 \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "",
    "    lec    Less equal constant",
    "",
    "                 /   1   if i(t,x) LE c     AND  i(t,x),c NE miss",
    "       o(t,x) = <    0   if i(t,x) GT c     AND  i(t,x),c NE miss",
    "                 \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "",
    "    ltc    Less than constant",
    "",
    "                 /   1   if i(t,x) LT c     AND  i(t,x),c NE miss",
    "       o(t,x) = <    0   if i(t,x) GE c     AND  i(t,x),c NE miss",
    "                 \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "",
    "    gec    Greater equal constant",
    "",
    "                 /   1   if i(t,x) GE c     AND  i(t,x),c NE miss",
    "       o(t,x) = <    0   if i(t,x) LT c     AND  i(t,x),c NE miss",
    "                 \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "",
    "    gtc    Greater than constant",
    "",
    "                 /   1   if i(t,x) GT c     AND  i(t,x),c NE miss",
    "       o(t,x) = <    0   if i(t,x) LE c     AND  i(t,x),c NE miss",
    "                 \\  miss if i(t,x) EQ miss  OR   c EQ miss",
    "",
    "PARAMETERS",
    "",
    "    c (FLOAT)",
    "           Constant",
    "",
    "EXAMPLE",
    "    To create a mask containing 1 if the field element is greater than 273.15 and 0 if not use:",
    "",
    "       cdo gtc,273.15 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp CondHelp = {
    "NAME",
    "    ifthen, ifnotthen - Conditional selection",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module selects field elements from infile2 with respect to infile1 and writes them to",
    "    outfile. The fields in infile1 are handled as a mask. A value not equal to zero is treated as",
    "    “true”, zero is treated as “false”.  The number of fields in infile1 has either to be the same as",
    "    in infile2 or the same as in one timestep of infile2 or only one.  The fields in outfile inherit",
    "    the meta data from infile2.",
    "",
    "OPERATORS",
    "",
    "    ifthen If then",
    "",
    "               / i_2(t,x) if i_1(t,x) NE 0  AND  i_1(t,x) NE miss",
    "       o(t,x) =",
    "               \\ miss     if i_1(t,x) EQ 0  OR   i_1(t,x) EQ miss",
    "",
    "    ifnotthen",
    "           If not then",
    "",
    "               / i_2(t,x) if i_1(t,x) EQ 0  AND  i_1(t,x) NE miss",
    "       o(t,x) =",
    "               \\ miss     if i_1(t,x) NE 0  OR   i_1(t,x) EQ miss",
    "",
    "EXAMPLE",
    "    To select all field elements of infile2 if the corresponding field element of infile1 is greater",
    "    than 0 use:",
    "",
    "       cdo ifthen infile1 infile2 outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp Cond2Help = {
    "NAME",
    "    ifthenelse - Conditional selection",
    "",
    "SYNOPSIS",
    "    cdo  ifthenelse  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator selects field elements from infile2 or infile3 with respect to infile1 and writes",
    "    them to outfile. The fields in infile1 are handled as a mask.  A value not equal to zero is",
    "    treated as “true”, zero is treated as “false”.  The number of fields in infile1 has either to be",
    "    the same as in infile2 or the same as in one timestep of infile2 or only one.  infile2 and infile3",
    "    need to have the same number of fields.  The fields in outfile inherit the meta data from infile2.",
    "",
    "                 / i_2(t,x) if i_1(t,x) NE 0  AND  i_1(t,x) NE miss",
    "       o(t,x) = <  i_3(t,x) if i_1(t,x) EQ 0  AND  i_1[t,x) NE miss",
    "                 \\ miss     if i_1(t,x) EQ miss",
    "",
    "EXAMPLE",
    "    To select all field elements of infile2 if the corresponding field element of infile1 is greater",
    "    than 0 and from infile3 otherwise use:",
    "",
    "       cdo ifthenelse infile1 infile2 infile3 outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp CondcHelp = {
    "NAME",
    "    ifthenc, ifnotthenc - Conditional selection",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,c  infile outfile",
    "",
    "DESCRIPTION",
    "    This module creates fields with a constant value or missing value.  The fields in infile are",
    "    handled as a mask. A value not equal to zero is treated as “true”, zero is treated as “false”.",
    "",
    "OPERATORS",
    "",
    "    ifthenc",
    "           If then constant",
    "",
    "               / c      if i(t,x) NE 0  AND  i(t,x) NE miss",
    "       o(t,x) =",
    "               \\ miss   if i(t,x) EQ 0  OR   i(t,x) EQ miss",
    "",
    "    ifnotthenc",
    "           If not then constant",
    "",
    "               / c      if i(t,x) EQ 0  AND  i(t,x) NE miss",
    "       o(t,x) =",
    "               \\ miss   if i(t,x) NE 0  OR   i(t,x) EQ miss",
    "",
    "PARAMETERS",
    "",
    "    c (FLOAT)",
    "           Constant",
    "",
    "EXAMPLE",
    "    To create fields with the constant value 7 if the corresponding field element of infile is greater",
    "    than 0 use:",
    "",
    "       cdo ifthenc,7 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ConsecstatHelp = {
    "NAME",
    "    consecsum, consects - Consecute timestep periods",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes periods over all timesteps in infile where a certain property is valid. The",
    "    property can be chosen by creating a mask from the original data, which is the expected input",
    "    format for operators of this module. Depending on the operator full information about each period",
    "    or just its length and ending date are computed.",
    "",
    "OPERATORS",
    "",
    "    consecsum",
    "           Consecutive Sum",
    "",
    "           This operator computes periods of consecutive timesteps similar to a runsum, but periods",
    "           are finished, when the mask value is 0. That way multiple periods can be found. Timesteps",
    "           from the input are preserved. Missing values are handled like 0, i.e. finish periods of",
    "           consecutive timesteps.",
    "",
    "    consects",
    "           Consecutive Timesteps",
    "",
    "           In contrast to the operator above consects only computes the length of each period together",
    "           with its last timestep. To be able to perform statistical analysis like min, max or mean,",
    "           everything else is set to missing value.",
    "",
    "EXAMPLE",
    "    For a given time series of daily temperatures, the periods of summer days can be calculated with",
    "    in-place masking the input field:",
    "",
    "       cdo consects -gtc,20.0 infile1 outfile",
    "",
    "AUTHOR",
    "    Ralf Müller",
    "",
};

const CdoHelp CopyHelp = {
    "NAME",
    "    copy, clone, cat - Copy datasets",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infiles outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators to copy, clone or concatenate datasets.  infiles is an arbitrary",
    "    number of input files. All input files need to have the same structure with the same variables on",
    "    different timesteps.",
    "",
    "OPERATORS",
    "",
    "    copy   Copy datasets",
    "",
    "           Copies all input datasets to outfile.",
    "",
    "    clone  Clone datasets",
    "",
    "           Copies all input datasets to outfile. In contrast to the copy operator, clone tries not to",
    "           change the input data. GRIB records are neither decoded nor decompressed.",
    "",
    "    cat    Concatenate datasets",
    "",
    "           Concatenates all input datasets and appends the result to the end of outfile. If outfile",
    "           does not exist it will be created.",
    "",
    "EXAMPLE",
    "    To change the format of a dataset to NetCDF use:",
    "",
    "       cdo -f nc copy infile outfile.nc",
    "",
    "    Add the option ‘-r’ to create a relative time axis, as is required for proper recognition by GrADS",
    "    or Ferret:",
    "",
    "       cdo -r -f nc copy infile outfile.nc",
    "",
    "    To concatenate 3 datasets with different timesteps of the same variables use:",
    "",
    "       cdo copy infile1 infile2 infile3 outfile",
    "",
    "    If the output dataset already exists and you wish to extend it with more timesteps use:",
    "",
    "       cdo cat infile1 infile2 infile3 outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp DayarithHelp = {
    "NAME",
    "    dayadd, daysub, daymul, daydiv - Daily arithmetic",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same day, month",
    "    and year.  For each field in infile1 the corresponding field of the timestep in infile2 with the",
    "    same day, month and year is used.  The input files need to have the same structure with the same",
    "    variables.  Usually infile2 is generated by an operator of the module Daystat.",
    "",
    "OPERATORS",
    "",
    "    dayadd Add daily time series",
    "",
    "           Adds a time series and a daily time series.",
    "",
    "    daysub Subtract daily time series",
    "",
    "           Subtracts a time series and a daily time series.",
    "",
    "    daymul Multiply daily time series",
    "",
    "           Multiplies a time series and a daily time series.",
    "",
    "    daydiv Divide daily time series",
    "",
    "           Divides a time series and a daily time series.",
    "",
    "EXAMPLE",
    "    To subtract a daily time average from a time series use:",
    "",
    "       cdo daysub infile -dayavg infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp DaypctlHelp = {
    "NAME",
    "    daypctl - Daily percentile",
    "",
    "SYNOPSIS",
    "    cdo  daypctl,pn  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same day in infile1.  The algorithm",
    "    uses histograms with minimum and maximum bounds given in infile2 and infile3, respectively. The",
    "    default number of histogram bins is 101.  The default can be overridden by defining the",
    "    environment variable :CDO_PCTL_NBINS.  The files infile2 and infile3 should be the result of",
    "    corresponding daymin and daymax operations, respectively.  The time of outfile is determined by",
    "    the time in the middle of all contributing timesteps of infile1.  This can be change with the CDO",
    "    option –timestat_date <first|middle|last>.",
    "",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "",
    "    o(t,x) = pth percentile {i(t’,x), t_1<=t’<=t_n}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "EXAMPLE",
    "    To compute the daily 90th percentile of a time series use:",
    "",
    "       cdo daymin infile minfile",
    "       cdo daymax infile maxfile",
    "       cdo daypctl,90 infile minfile maxfile outfile",
    "",
    "    Or shorter using operator piping:",
    "",
    "       cdo daypctl,90 infile -daymin infile -daymax infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp DaystatHelp = {
    "NAME",
    "    daymin, daymax, dayrange, daysum, daymean, dayavg, daystd, daystd1, dayvar, dayvar1 - Daily",
    "    statistics",
    "",
    "SYNOPSIS",
    "    cdo [options]  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same day.  Depending on the chosen",
    "    operator the minimum, maximum, range, sum, average, variance or standard deviation of timesteps of",
    "    the same day is written to outfile.  The time of outfile is determined by the time in the middle",
    "    of all contributing timesteps of infile.  This can be change with the CDO option –timestat_date",
    "    <first|middle|last>.  Set the parameter complete_only=TRUE to process the last day only when it is",
    "    complete.",
    "",
    "OPERATORS",
    "",
    "    daymin Daily minimum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "",
    "           o(t,x) = min{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    daymax Daily maximum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "",
    "           o(t,x) = max{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    dayrange",
    "           Daily range",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "",
    "           o(t,x) = range{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    daysum Daily sum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "",
    "           o(t,x) = sum{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    daymean",
    "           Daily mean",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "",
    "           o(t,x) = mean{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    dayavg Daily average",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same day it is:",
    "",
    "           o(t,x) = avg{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    dayvar Daily variance",
    "",
    "           Normalize by n.  For every adjacent sequence t_1, ...,t_n of timesteps of the same day it",
    "           is:",
    "",
    "           o(t,x) = var{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    dayvar1",
    "           Daily variance (n-1)",
    "",
    "           Normalize by (n-1).  For every adjacent sequence t_1, ...,t_n of timesteps of the same day",
    "           it is:",
    "",
    "           o(t,x) = var1{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    daystd Daily standard deviation",
    "",
    "           Normalize by n.  For every adjacent sequence t_1, ...,t_n of timesteps of the same day it",
    "           is:",
    "",
    "           o(t,x) = std{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    daystd1",
    "           Daily standard deviation (n-1)",
    "",
    "           Normalize by (n-1).  For every adjacent sequence t_1, ...,t_n of timesteps of the same day",
    "           it is:",
    "",
    "           o(t,x) = std1{i(t’,x), t_1<=t’<=t_n}",
    "",
    "PARAMETERS",
    "",
    "    complete_only (BOOL)",
    "           Process the last day only when it is complete",
    "",
    "OPTIONS",
    "    -S, --diagnostic to create a diagnostic output stream with the number of non missing values for",
    "    each output period.",
    "",
    "    -p, --async_read true to read input data asynchronously.",
    "",
    "EXAMPLE",
    "    To compute the daily mean of a time series use:",
    "",
    "       cdo daymean infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp DeltatHelp = {
    "NAME",
    "    deltat - Difference between timesteps",
    "",
    "SYNOPSIS",
    "    cdo  deltat  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator computes the difference between each timestep.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp DeriveparHelp = {
    "NAME",
    "    sealevelpressure, gheight, gheight_half, air_density - Derived model parameters",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators that calculate derived model parameters. All necessary input",
    "    variables are identified by their GRIB1 code number or the NetCDF CF standard name.  Supported",
    "    GRIB1 parameter tables are: WMO standard table number 2 and ECMWF local table number 128.",
    "",
    "                              ┌─────────────────────┬────────┬─────────────┐",
    "                              │CF standard name     │ Units  │ GRIB 1 code │",
    "                              ├─────────────────────┼────────┼─────────────┤",
    "                              │surface_air_pressure │ Pa     │ 134         │",
    "                              ├─────────────────────┼────────┼─────────────┤",
    "                              │air_temperature      │ K      │ 130         │",
    "                              ├─────────────────────┼────────┼─────────────┤",
    "                              │specific_humidity    │ kg/kg  │ 133         │",
    "                              ├─────────────────────┼────────┼─────────────┤",
    "                              │surface_geopotential │ m2 s-2 │ 129         │",
    "                              ├─────────────────────┼────────┼─────────────┤",
    "                              │geopotential_height  │ m      │ 156         │",
    "                              └─────────────────────┴────────┴─────────────┘",
    "OPERATORS",
    "",
    "    sealevelpressure",
    "           Sea level pressure",
    "",
    "           This operator computes the sea level pressure (air_pressure_at_sea_level). Required input",
    "           fields are surface_air_pressure, surface_geopotential and air_temperature on full hybrid",
    "           sigma pressure levels.",
    "",
    "    gheight",
    "           Geopotential height on full-levels",
    "",
    "           This operator computes the geopotential height (geopotential_height) on model full-levels",
    "           in metres.  Required input fields are surface_air_pressure, surface_geopotential,",
    "           specific_humidity and air_temperature on full hybrid sigma pressure levels. Note, this",
    "           procedure is an approximation, which doesn’t take into account the effects of e.g. cloud",
    "           ice and water, rain and snow.",
    "",
    "    gheight_half",
    "           Geopotential height on half-levels",
    "",
    "           This operator computes the geopotential height (geopotential_height) on model half-levels",
    "           in metres.  Required input fields are surface_air_pressure, surface_geopotential,",
    "           specific_humidity and air_temperature on full hybrid sigma pressure levels. Note, this",
    "           procedure is an approximation, which doesn’t take into account the effects of e.g. cloud",
    "           ice and water, rain and snow.",
    "",
    "    air_density",
    "           Air density",
    "",
    "           This operator computes the air density, it depends on pressure, humidity and temperature.",
    "           Required input fields are surface_air_pressure, specific_humidity and air_temperature on",
    "           full hybrid sigma pressure levels. The air density (rho) is calculated with the following",
    "           formula:",
    "",
    "           rho = P  / Rs * Tv",
    "           P: air pressure in Pascal",
    "           Tv: virtual temperature in Kelvin",
    "           Rs: specific gas constant for try air; 287.085 J/(kg*K)",
    "",
    "",
    "           Tv = T * [1 + a * q]",
    "           T: air temperature in Kelvin",
    "           q: specific humidity",
    "           a: gas constants of air and water vapor; 0.6078",
    "",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp DetrendHelp = {
    "NAME",
    "    detrend - Detrend time series",
    "",
    "SYNOPSIS",
    "    cdo [options]  detrend[,equal]  infile outfile",
    "",
    "DESCRIPTION",
    "    Every time series in infile is linearly detrended. For every field element x only those timesteps",
    "    t belong to the sample S(x), which have i(t,x) NE miss.  It is assumed that all timesteps are",
    "    equidistant, if this is not the case set the parameter equal=false.",
    "",
    "PARAMETERS",
    "",
    "    equal (BOOL)",
    "           Set to false for unequal distributed timesteps (default: true)",
    "",
    "OPTIONS",
    "    -p, --async_read true to read input data asynchronously.",
    "",
    "NOTE",
    "    This operator has to keep the fields of all timesteps concurrently in the memory.  If not enough",
    "    memory is available use the operators trend and subtrend.",
    "",
    "EXAMPLE",
    "    To detrend the data in infile and to store the detrended data in outfile use:",
    "",
    "       cdo detrend infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp DhourstatHelp = {
    "NAME",
    "    dhourmin, dhourmax, dhourrange, dhoursum, dhourmean, dhouravg, dhourstd, dhourstd1, dhourvar,",
    "    dhourvar1 - Multi-day hourly statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each hour of day.  Depending on the chosen operator the",
    "    minimum, maximum, range, sum, average, variance or standard deviation of each hour of day in",
    "    infile is written to outfile.  The date information in an output field is the date of the last",
    "    contributing input field.",
    "",
    "OPERATORS",
    "",
    "    dhourmin",
    "           Multi-day hourly minimum",
    "",
    "              o(01,x) = min{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(24,x) = min{i(t,x), day(i(t)) = 24}",
    "",
    "    dhourmax",
    "           Multi-day hourly maximum",
    "",
    "              o(01,x) = max{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(24,x) = max{i(t,x), day(i(t)) = 24}",
    "",
    "    dhourrange",
    "           Multi-day hourly range",
    "",
    "              o(01,x) = range{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(24,x) = range{i(t,x), day(i(t)) = 24}",
    "",
    "    dhoursum",
    "           Multi-day hourly sum",
    "",
    "              o(01,x) = sum{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(24,x) = sum{i(t,x), day(i(t)) = 24}",
    "",
    "    dhourmean",
    "           Multi-day hourly mean",
    "",
    "              o(01,x) = mean{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(24,x) = mean{i(t,x), day(i(t)) = 24}",
    "",
    "    dhouravg",
    "           Multi-day hourly average",
    "",
    "              o(01,x) = avg{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(24,x) = avg{i(t,x), day(i(t)) = 24}",
    "",
    "    dhourvar",
    "           Multi-day hourly variance",
    "",
    "           Normalize by n.",
    "",
    "              o(01,x) = var{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(24,x) = var{i(t,x), day(i(t)) = 24}",
    "",
    "    dhourvar1",
    "           Multi-day hourly variance (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(01,x) = var1{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(24,x) = var1{i(t,x), day(i(t)) = 24}",
    "",
    "    dhourstd",
    "           Multi-day hourly standard deviation",
    "",
    "           Normalize by n.",
    "",
    "              o(01,x) = std{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(24,x) = std{i(t,x), day(i(t)) = 24}",
    "",
    "    dhourstd1",
    "           Multi-day hourly standard deviation (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(01,x) = std1{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(24,x) = std1{i(t,x), day(i(t)) = 24}",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp DiffHelp = {
    "NAME",
    "    diff, diffn - Compare two datasets field by field",
    "",
    "SYNOPSIS",
    "    cdo [options]  <operator>[,parameters]  infile1 infile2",
    "",
    "DESCRIPTION",
    "    Compares the contents of two datasets field by field. The input datasets need to have the same",
    "    structure and its fields need to have the dimensions.  Try the option names if the number of",
    "    variables differ.  Exit status is 0 if inputs are the same and 1 if they differ.",
    "",
    "OPERATORS",
    "",
    "    diff   Compare two datasets listed by identifier",
    "",
    "           Provides statistics on differences between two datasets.  For each pair of fields the",
    "           operator prints one line with the following information:",
    "",
    "           • Date and Time",
    "",
    "           • Level, Gridsize and number of Missing values",
    "",
    "           • Number of different values",
    "",
    "           • Occurrence of coefficient pairs with different signs (S)",
    "",
    "           • Occurrence of zero values (Z)",
    "",
    "           • Maxima of absolute difference of coefficient pairs",
    "",
    "           • Maxima of relative difference of non-zero coefficient pairs with equal signs",
    "",
    "           • Parameter identifier",
    "",
    "    diffn  Compare two datasets listed by name",
    "",
    "           The same as operator diff. Using the name instead of the identifier to label the parameter.",
    "",
    "PARAMETERS",
    "",
    "    maxcount (INTEGER)",
    "           Stop after maxcount different fields.",
    "",
    "    abslim (FLOAT)",
    "           Limit of the maximum absolute difference (default: 0).",
    "",
    "    rellim (FLOAT)",
    "           Limit of the maximum relative difference (default: 1).",
    "",
    "    names (STRING)",
    "           Consideration of the variable names of only one input file (left/right) or the intersection",
    "           of both (intersect).",
    "",
    "OPTIONS",
    "    -p, --async_read true to read input data asynchronously.",
    "",
    "EXAMPLE",
    "    To print the difference for each field of two datasets use:",
    "",
    "       cdo diffn infile1 infile2",
    "",
    "    This is an example result of two datasets with one 2D parameter over 12 timesteps:",
    "",
    "                  Date   Time Level Size Miss Diff : S Z Max_Absdiff Max_Reldiff : Name",
    "        1 : 1987-01-31 12:00:00   0 2048 1361  273 : F F  0.00010681  4.1660e-07 : SST",
    "        2 : 1987-02-28 12:00:00   0 2048 1361  309 : F F  6.1035e-05  2.3742e-07 : SST",
    "        3 : 1987-03-31 12:00:00   0 2048 1361  292 : F F  7.6294e-05  3.3784e-07 : SST",
    "        4 : 1987-04-30 12:00:00   0 2048 1361  183 : F F  7.6294e-05  3.5117e-07 : SST",
    "        5 : 1987-05-31 12:00:00   0 2048 1361  207 : F F  0.00010681  4.0307e-07 : SST",
    "        7 : 1987-07-31 12:00:00   0 2048 1361  317 : F F  9.1553e-05  3.5634e-07 : SST",
    "        8 : 1987-08-31 12:00:00   0 2048 1361  219 : F F  7.6294e-05  2.8849e-07 : SST",
    "        9 : 1987-09-30 12:00:00   0 2048 1361  188 : F F  7.6294e-05  3.6168e-07 : SST",
    "       10 : 1987-10-31 12:00:00   0 2048 1361  297 : F F  9.1553e-05  3.5001e-07 : SST",
    "       11 : 1987-11-30 12:00:00   0 2048 1361  234 : F F  6.1035e-05  2.3839e-07 : SST",
    "       12 : 1987-12-31 12:00:00   0 2048 1361  267 : F F  9.3553e-05  3.7624e-07 : SST",
    "       11 of 12 records differ",
    "",
    "AUTHOR",
    "    Uwe Schulzweida, Karl-Hermann Wieners",
    "",
};

const CdoHelp DistgridHelp = {
    "NAME",
    "    distgrid - Distribute horizontal grid",
    "",
    "SYNOPSIS",
    "    cdo  distgrid,parameters  infile obase",
    "",
    "DESCRIPTION",
    "    This operator distributes a dataset into smaller pieces. Each output file contains a different",
    "    region of the horizontal source grid. 2D Lon/Lat grids can be split into nx*ny pieces, where a",
    "    target grid region contains a structured longitude/latitude box of the source grid. Data on an",
    "    unstructured grid is split into nx pieces.  The output files will be named <obase><xxx><suffix>",
    "    where suffix is the filename extension derived from the file format. xxx will have five digits",
    "    with the number of the target region.",
    "",
    "PARAMETERS",
    "",
    "    nx (INTEGER)",
    "           Number of regions in x direction, or number of pieces for unstructured grids",
    "",
    "    ny (INTEGER)",
    "           Number of regions in y direction [default: 1]",
    "",
    "NOTE",
    "    This operator needs to open all output files simultaneously.  The maximum number of open files",
    "    depends on the operating system!",
    "",
    "EXAMPLE",
    "    Distribute data on a 2D Lon/Lat grid into 6 smaller files, each output file receives one half of x",
    "    and a third of y of the source grid:",
    "",
    "       cdo distgrid,2,3 infile.nc obase",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp DminutestatHelp = {
    "NAME",
    "    dminutemin, dminutemax, dminuterange, dminutesum, dminutemean, dminuteavg, dminutestd,",
    "    dminutestd1, dminutevar, dminutevar1 - Multi-day by the minute statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each minute of day.  Depending on the chosen operator",
    "    the minimum, maximum, range, sum, average, variance or standard deviation of each minute of day in",
    "    infile is written to outfile.  The date information in an output field is the date of the last",
    "    contributing input field.",
    "",
    "OPERATORS",
    "",
    "    dminutemin",
    "           Multi-day by the minute minimum",
    "",
    "              o(01,x) = min{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(1440,x) = min{i(t,x), day(i(t)) = 1440}",
    "",
    "    dminutemax",
    "           Multi-day by the minute maximum",
    "",
    "              o(01,x) = max{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(1440,x) = max{i(t,x), day(i(t)) = 1440}",
    "",
    "    dminuterange",
    "           Multi-day by the minute range",
    "",
    "              o(01,x) = range{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(1440,x) = range{i(t,x), day(i(t)) = 1440}",
    "",
    "    dminutesum",
    "           Multi-day by the minute sum",
    "",
    "              o(01,x) = sum{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(1440,x) = sum{i(t,x), day(i(t)) = 1440}",
    "",
    "    dminutemean",
    "           Multi-day by the minute mean",
    "",
    "              o(01,x) = mean{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(1440,x) = mean{i(t,x), day(i(t)) = 1440}",
    "",
    "    dminuteavg",
    "           Multi-day by the minute average",
    "",
    "              o(01,x) = avg{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(1440,x) = avg{i(t,x), day(i(t)) = 1440}",
    "",
    "    dminutevar",
    "           Multi-day by the minute variance",
    "",
    "           Normalize by n.",
    "",
    "              o(01,x) = var{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(1440,x) = var{i(t,x), day(i(t)) = 1440}",
    "",
    "    dminutevar1",
    "           Multi-day by the minute variance (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(01,x) = var1{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(1440,x) = var1{i(t,x), day(i(t)) = 1440}",
    "",
    "    dminutestd",
    "           Multi-day by the minute standard deviation",
    "",
    "           Normalize by n.",
    "",
    "              o(01,x) = std{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(1440,x) = std{i(t,x), day(i(t)) = 1440}",
    "",
    "    dminutestd1",
    "           Multi-day by the minute standard deviation (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(01,x) = std1{i(t,x), day(i(t)) = 01}",
    "                          ...",
    "              o(1440,x) = std1{i(t,x), day(i(t)) = 1440}",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp DuplicateHelp = {
    "NAME",
    "    duplicate - Duplicates a dataset",
    "",
    "SYNOPSIS",
    "    cdo  duplicate[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator duplicates the contents of infile and writes the result to outfile.  The optional",
    "    parameter sets the number of duplicates, the default is 2.",
    "",
    "PARAMETERS",
    "",
    "    ndup (INTEGER)",
    "           Number of duplicates, default is 2.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp Eca_cddHelp = {
    "NAME",
    "    eca_cdd, etccdi_cdd - Consecutive dry days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,R[,N[,params]]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR, then the largest number of",
    "    consecutive days where RR is less than R is counted. R is an optional parameter with default R=1",
    "    mm. A further output variable is the number of dry periods of more than N days.  Parameter is a",
    "    comma-separated list of “key=values” pairs.",
    "",
    "OPERATORS",
    "",
    "    eca_cdd",
    "           Consecutive dry days index per time period",
    "",
    "           The operator counts over the entire time series.  The date information of a timestep in",
    "           outfile is the date of the last contributing timestep in infile.",
    "",
    "    etccdi_cdd",
    "           Consecutive dry days index per time period",
    "",
    "           The default output frequency is yearly.  Periods within overlapping years are accounted for",
    "           the first year.  The date information of a timestep in outfile is the mid of the frequency",
    "           interval.",
    "",
    "PARAMETERS",
    "",
    "    R FLOAT",
    "           Precipitation threshold (unit: mm; default: R=1 mm)",
    "",
    "    N INTEGER",
    "           Minimum number of days exceeded (default: N=5)",
    "",
    "    freq STRING",
    "           Output frequency (year, month)",
    "",
    "EXAMPLE",
    "    To get the largest number of consecutive dry days of a time series of daily precipitation amounts",
    "    use:",
    "",
    "       cdo eca_cdd rrfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Fabian Wachsmann",
    "",
};

const CdoHelp Eca_cfdHelp = {
    "NAME",
    "    eca_cfd - Consecutive frost days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  eca_cfd[,N]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily minimum temperature TN, then the largest number of",
    "    consecutive days where TN < 0°C is counted. Note that TN have to be given in units of Kelvin.  A",
    "    further output variable is the number of frost periods of more than N days.  The date information",
    "    of a timestep in outfile is the date of the last contributing timestep in infile.",
    "",
    "PARAMETERS",
    "",
    "    N INTEGER",
    "           Minimum number of days exceeded (default: N=5)",
    "",
    "EXAMPLE",
    "    To get the largest number of consecutive frost days of a time series of daily minimum temperatures",
    "    use:",
    "",
    "       cdo eca_cfd tnfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_csuHelp = {
    "NAME",
    "    eca_csu - Consecutive summer days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  eca_csu[,T[,N]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum temperature TX, then the largest number of",
    "    consecutive days where TX > T is counted. The number T is an optional parameter with default T =",
    "    25°C.  Note that TN have to be given in units of Kelvin, whereas T have to be given in degrees",
    "    Celsius.  A further output variable is the number of summer periods of more than N days.  The date",
    "    information of a timestep in outfile is the date of the last contributing timestep in infile.",
    "",
    "PARAMETERS",
    "",
    "    T FLOAT",
    "           Temperature threshold (unit: °C; default: T=25°C)",
    "",
    "    N INTEGER",
    "           Minimum number of days exceeded (default: N=5)",
    "",
    "EXAMPLE",
    "    To get the largest number of consecutive summer days of a time series of daily maximum",
    "    temperatures use:",
    "",
    "       cdo eca_csu txfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_cwdHelp = {
    "NAME",
    "    eca_cwd, etccdi_cwd - Consecutive wet days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,params]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR, then the largest number of",
    "    consecutive days where RR is at least R is counted. R is an optional parameter with default R = 1",
    "    mm. A further output variable is the number of wet periods of more than N days.  Parameter is a",
    "    comma-separated list of “key=values” pairs.",
    "",
    "OPERATORS",
    "",
    "    eca_cwd",
    "           Consecutive wet days index per time period",
    "",
    "           The operator counts over the entire time series.  The date information of a timestep in",
    "           outfile is the date of the last contributing timestep in infile.",
    "",
    "    etccdi_cwd",
    "           Consecutive wet days index per time period",
    "",
    "           The default output frequency is yearly.  Periods within overlapping years are accounted for",
    "           the first year.  The date information of a timestep in outfile is the mid of the frequency",
    "           interval.",
    "",
    "PARAMETERS",
    "",
    "    R FLOAT",
    "           Precipitation threshold (unit: mm; default: R=1mm)",
    "",
    "    N INTEGER",
    "           Minimum number of days exceeded (default: N=5)",
    "",
    "    freq STRING",
    "           Output frequency (year, month)",
    "",
    "EXAMPLE",
    "    To get the largest number of consecutive wet days of a time series of daily precipitation amounts",
    "    use:",
    "",
    "       cdo eca_cwd rrfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Fabian Wachsmann",
    "",
};

const CdoHelp Eca_cwdiHelp = {
    "NAME",
    "    eca_cwdi - Cold wave duration index wrt mean of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_cwdi[,nday[,T]]  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily minimum temperature TN, and let infile2 be the mean",
    "    TNnorm of daily minimum temperatures for any period used as reference. Then counted is the number",
    "    of days where, in intervals of at least nday consecutive days, TN < TNnorm - T.  The numbers nday",
    "    and T are optional parameters with default nday = 6 and T = 5°C.  A further output variable is the",
    "    number of cold waves longer than or equal to nday days.  TNnorm is calculated as the mean of",
    "    minimum temperatures of a five day window centered on each calendar day of a given climate",
    "    reference period. Note that both TN and TNnorm have to be given in the same units.  The date",
    "    information of a timestep in outfile is the date of the last contributing timestep in infile1.",
    "",
    "PARAMETERS",
    "",
    "    nday INTEGER",
    "           Number of consecutive days (default: nday=6)",
    "",
    "    T FLOAT",
    "           Temperature offset (unit: °C; default: T=5°C)",
    "",
    "EXAMPLE",
    "    To compute the cold wave duration index of a time series of daily minimum temperatures use:",
    "",
    "       cdo eca_cwdi tnfile tnnormfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_cwfiHelp = {
    "NAME",
    "    eca_cwfi, etccdi_csdi - Cold-spell days index wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,nday[,params]]  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily mean temperature TG, and infile2 be the 10th percentile",
    "    TGn10 of daily mean temperatures for any period used as reference.  Then counted is the number of",
    "    days where, in intervals of at least nday consecutive days, TG < TGn10. The number nday is an",
    "    optional parameter with default nday = 6.  A further output variable is the number of cold-spell",
    "    periods longer than or equal to nday days.  TGn10 is calculated as the 10th percentile of daily",
    "    mean temperatures of a five day window centered on each calendar day of a given climate reference",
    "    period. Note that both TG and TGn10 have to be given in the same units.",
    "",
    "OPERATORS",
    "",
    "    eca_cwfi",
    "           Cold-spell days index wrt 10th percentile of reference period",
    "",
    "           The operator counts over the entire time series.  The date information of a timestep in",
    "           outfile is the date of the last contributing timestep in infile.",
    "",
    "    etccdi_csdi",
    "           Cold-spell duration index",
    "",
    "           The default output frequency is yearly.  Periods within overlapping years are accounted for",
    "           the first year.  The date information of a timestep in outfile is the mid of the frequency",
    "           interval.",
    "",
    "PARAMETERS",
    "",
    "    nday INTEGER",
    "           Number of consecutive days (default: nday=6)",
    "",
    "    freq STRING",
    "           Output frequency (year, month)",
    "",
    "EXAMPLE",
    "    To compute the number of cold-spell days of a time series of daily mean temperatures use:",
    "",
    "       cdo eca_cwfi tgfile tgn10file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Fabian Wachsmann",
    "",
};

const CdoHelp Eca_etccdiHelp = {
    "NAME",
    "    etccdi_tx90p, etccdi_tx10p, etccdi_tn90p, etccdi_tn10p, etccdi_r95p, etccdi_r99p - ETCCDI conform",
    "    index for a reference periode calculated with bootstrapping",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,n,startboot,endboot[,m]  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This module enables to compute Climate Extremes Indices according to the method recommended by the",
    "    Expert Team on Climate Change Detection and Indices. It differs from the corresponding eca_*",
    "    indices by applying bootstrapping for a reference period (see Zhang et al. 2005) given by",
    "    startboot and endboot and using the R-type 8 method for percentile calculation.  A requirement for",
    "    correct percentile calculation is that",
    "    CDO_PCTL_NBINS>=window*(endboot-startboot+1)*(sizeof(double)/sizeof(int))+2 This demands for high",
    "    working storage since the entire data of the bootstrapping interval need to be hold in storage.",
    "    Otherwise, a histogram is used to calculate the percentile.  infile2 (infile3) contains the daily",
    "    minimum (maximum) of the bootstrapping interval.  If m=m, the output variable will be saved",
    "    monthly, otherwise with yearly frequency.",
    "",
    "OPERATORS",
    "",
    "    etccdi_tx90p",
    "           Percentage of Days when Daily Maximum Temperature is Above the 90th Percentile",
    "",
    "    etccdi_tx10p",
    "           Percentage of Days when Daily Maximum Temperature is Below the 10th Percentile",
    "",
    "    etccdi_tn90p",
    "           Percentage of Days when Daily Minimum Temperature is Above the 90th Percentile",
    "",
    "    etccdi_tn10p",
    "           Percentage of Days when Daily Minimum Temperature is Below the 10th Percentile",
    "",
    "    etccdi_r95p",
    "           Annual Total Precipitation when Daily Precipitation Exceeds the 95th Percentile of Wet Day",
    "           Precipitation",
    "",
    "    etccdi_r99p",
    "           Annual Total Precipitation when Daily Precipitation Exceeds the 99th Percentile of Wet Day",
    "           Precipitation",
    "",
    "PARAMETERS",
    "",
    "    n INTEGER",
    "           Window days, number of timesteps",
    "",
    "    startboot INTEGER",
    "           First year of bootstrapping interval",
    "",
    "    endboot INTEGER",
    "           Last year of bootstrapping interval",
    "",
    "    m CHARACTER",
    "           Output frequency",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "EXAMPLE",
    "    To compute the percentage of timesteps of each month with a daily maximum temperature greater than",
    "    the 90th percentile of the daily maximum temperatures for a reference period 1960-1989 and a 5",
    "    consecutive days window use:",
    "",
    "       cdo etccdi_tx90p,5,1960,1989,m txfile -ydrunmin,5 txfile -ydrunmax,5 txfile outfile",
    "",
    "AUTHOR",
    "    Fabian Wachsmann",
    "",
};

const CdoHelp Eca_etrHelp = {
    "NAME",
    "    eca_etr - Intra-period extreme temperature range",
    "",
    "SYNOPSIS",
    "    cdo  eca_etr  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 and infile2 be time series of thr maximum and minimum temperature TX and TN,",
    "    respectively. Then the extreme temperature range is the difference of the maximum of TX and the",
    "    minimum of TN.  Note that TX and TN have to be given in the same units.  The date information of a",
    "    timestep in outfile is the date of the last contributing timesteps in infile1 and infile2.",
    "",
    "EXAMPLE",
    "    To get the intra-period extreme temperature range for two time series of maximum and minimum",
    "    temperatures use:",
    "",
    "       cdo eca_etr txfile tnfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_fdHelp = {
    "NAME",
    "    eca_fd, etccdi_fd - Frost days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily minimum temperature TN, then the number of days where TN",
    "    < 0°C is counted. Note that TN have to be given in units of Kelvin. Parameter is a comma-separated",
    "    list of “key=value” pairs.",
    "",
    "OPERATORS",
    "",
    "    eca_fd Frost days index per time period",
    "",
    "           The operator counts over the entire time series.  The date information of a timestep in",
    "           outfile is the date of the last contributing timestep in infile.",
    "",
    "    etccdi_fd",
    "           Frost days index per time period",
    "",
    "           The default output frequency is yearly.  The date information of a timestep in outfile is",
    "           the mid of the frequency interval.",
    "",
    "PARAMETERS",
    "",
    "    freq STRING",
    "           Output frequency (year, month)",
    "",
    "EXAMPLE",
    "    To get the number of frost days of a time series of daily minimum temperatures use:",
    "",
    "       cdo eca_fd tnfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_gslHelp = {
    "NAME",
    "    eca_gsl - Thermal Growing season length index",
    "",
    "SYNOPSIS",
    "    cdo  eca_gsl[,nday[,T[,fland]]]  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily mean temperature TG, and infile2 be a land-water mask.",
    "    Within a period of 12 months, the thermal growing season length is officially defined as the",
    "    number of days between:",
    "",
    "    • first occurrence of at least nday consecutive days with TG > T",
    "",
    "    • first occurrence of at least nday consecutive days with TG < T within the last 6 months",
    "",
    "    On northern hemisphere, this period corresponds with the regular year, whereas on southern",
    "    hemisphere, it starts at July 1st. Please note, that this definition may lead to weird results",
    "    concerning values TG=T: In the first half of the period, these days do not contribute to the gsl,",
    "    but they do within the second half.  Moreover this definition could lead to discontinuous values",
    "    in equatorial regions.",
    "",
    "    The numbers nday and T are optional parameter with default nday=6 and T=5°C.  The number fland is",
    "    an optional parameter with default value fland=0.5 and denotes the fraction of a grid point that",
    "    have to be covered by land in order to be included in the calculation. A further output variable",
    "    is the start day of year of the growing season. Note that TG have to be given in units of Kelvin,",
    "    whereas T have to be given in degrees Celsius.",
    "",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in",
    "    infile.",
    "",
    "PARAMETERS",
    "",
    "    nday INTEGER",
    "           Number of consecutive days (default: nday=6)",
    "",
    "    T FLOAT",
    "           Temperature threshold (unit: °C; default: T=5°C)",
    "",
    "    fland FLOAT",
    "           Land fraction threshold (default: fland=0.5)",
    "",
    "EXAMPLE",
    "    To get the growing season length of a time series of daily mean temperatures use:",
    "",
    "       cdo eca_gsl tgfile maskfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_hdHelp = {
    "NAME",
    "    eca_hd - Heating degree days per time period",
    "",
    "SYNOPSIS",
    "    cdo  eca_hd[,T1[,T2]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily mean temperature TG, then the heating degree days are",
    "    defined as the sum of T1 - TG, where only values TG < T2 are considered.  If T1 and T2 are",
    "    omitted, a temperature of 17°C is used for both parameters.  If only T1 is given, T2 is set to T1.",
    "    Note that TG have to be given in units of kelvin, whereas T1 and T2 have to be given in degrees",
    "    Celsius.",
    "",
    "PARAMETERS",
    "",
    "    T1 FLOAT",
    "           Temperature limit (unit: °C; default: T1=17°C)",
    "",
    "    T2 FLOAT",
    "           Temperature limit (unit: °C; default: T2=T1)",
    "",
    "EXAMPLE",
    "    To compute the heating degree days of a time series of daily mean temperatures use:",
    "",
    "       cdo eca_hd tgfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_hwdiHelp = {
    "NAME",
    "    eca_hwdi - Heat wave duration index wrt mean of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_hwdi[,nday[,T]]  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily maximum temperature TX, and let infile2 be the mean",
    "    TXnorm of daily maximum temperatures for any period used as reference. Then counted is the number",
    "    of days where, in intervals of at least nday consecutive days, TX > TXnorm + T.  The numbers nday",
    "    and T are optional parameters with default nday=6 and T=5°C.  A further output variable is the",
    "    number of heat waves longer than or equal to nday days.  TXnorm is calculated as the mean of",
    "    maximum temperatures of a five day window centered on each calendar day of a given climate",
    "    reference period. Note that both TX and TXnorm have to be given in the same units.  The date",
    "    information of a timestep in outfile is the date of the last contributing timestep in infile1.",
    "",
    "PARAMETERS",
    "",
    "    nday INTEGER",
    "           Number of consecutive days (default: nday=6)",
    "",
    "    T FLOAT",
    "           Temperature offset (unit: °C; default: T=5°C)",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_hwfiHelp = {
    "NAME",
    "    eca_hwfi, etccdi_wsdi - Warm spell index",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,nday[,freq]]  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily mean temperature TG, and infile2 be the 90th percentile",
    "    TGn90 of daily mean temperatures for any period used as reference. Then counted is the number of",
    "    days where, in intervals of at least nday consecutive days, TG > TGn90. The number nday is an",
    "    optional parameter with default nday=6. A further output variable is the number of warm-spell",
    "    periods longer than or equal to nday days.  TGn90 is calculated as the 90th percentile of daily",
    "    mean temperatures of a five day window centered on each calendar day of a given climate reference",
    "    period.  Note that both TG and TGn90 have to be given in the same units.  Parameter is a",
    "    comma-separated list of “key=values” pairs.",
    "",
    "OPERATORS",
    "",
    "    eca_hwfi",
    "           Warm spell days index wrt 90th percentile of reference period",
    "",
    "           The operator counts over the entire time series.  The date information of a timestep in",
    "           outfile is the date of the last contributing timestep in infile.",
    "",
    "    etccdi_wsdi",
    "           Warm Spell Duration Index",
    "",
    "           The default output frequency is yearly.  Periods within overlapping years are accounted for",
    "           the first year.  The date information of a timestep in outfile is the mid of the frequency",
    "           interval.",
    "",
    "PARAMETERS",
    "",
    "    nday INTEGER",
    "           Number of consecutive days (default: nday = 6)",
    "",
    "    freq STRING",
    "           Output frequency (year, month)",
    "",
    "EXAMPLE",
    "    To compute the number of warm-spell days of a time series of daily mean temperatures use:",
    "",
    "       cdo eca_hwfi tgfile tgn90file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Fabian Wachsmann",
    "",
};

const CdoHelp Eca_idHelp = {
    "NAME",
    "    eca_id, etccdi_id - Ice days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,freq]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum temperature TX, then the number of days where TX",
    "    < 0°C is counted. Note that TX have to be given in units of Kelvin. Parameter is a comma-separated",
    "    list of “key=values” pairs.",
    "",
    "OPERATORS",
    "",
    "    eca_id Ice days index per time period",
    "",
    "           The operator counts over the entire time series.  The date information of a timestep in",
    "           outfile is the date of the last contributing timestep in infile.",
    "",
    "    etccdi_id",
    "           Ice days index per time period",
    "",
    "           The default output frequency is yearly.  The date information of a timestep in outfile is",
    "           the mid of the frequency interval.",
    "",
    "PARAMETERS",
    "",
    "    freq STRING",
    "           Output frequency (year, month)",
    "",
    "EXAMPLE",
    "    To get the number of ice days of a time series of daily maximum temperatures use:",
    "",
    "       cdo eca_id txfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Fabian Wachsmann",
    "",
};

const CdoHelp Eca_pdHelp = {
    "NAME",
    "    eca_pd, etccdi_r1mm, eca_r10mm, eca_r20mm - Precipitation days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  eca_pd,x infile outfile",
    "",
    "    cdo  etccdi_r1mm[,parameter]  infile outfile",
    "",
    "    cdo  eca_r10mm  infile outfile",
    "",
    "    cdo  eca_r20mm  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR in [mm] (or alternatively in [kg",
    "    m-2]), then the number of days where RR is at least x mm is counted.  eca_r10mm and eca_r20mm are",
    "    specific ECA operators with a daily precipitation amount of 10 and 20 mm respectively.  The date",
    "    information of a timestep in outfile is the date of the last contributing timestep in infile",
    "    except for the etccdi operator. Parameter is a comma-separated list of “key=values” pairs.",
    "",
    "OPERATORS",
    "",
    "    eca_pd Precipitation days index per time period",
    "",
    "           Generic ECA operator with daily precipitation sum exceeding x mm.",
    "",
    "    etccdi_r1mm",
    "           Precipitation days index per time period",
    "",
    "           The default output frequency is yearly.  The date information of a timestep in outfile is",
    "           the mid of the frequency interval.",
    "",
    "    eca_r10mm",
    "           Heavy precipitation days index per time period",
    "",
    "           Specific ECA operator with daily precipitation sum exceeding 10 mm.",
    "",
    "    eca_r20mm",
    "           Very heavy precipitation days index per time period",
    "",
    "           Specific ECA operator with daily precipitation sum exceeding 20 mm.",
    "",
    "PARAMETERS",
    "",
    "    x FLOAT",
    "           Daily precipitation amount threshold in [mm]",
    "",
    "    freq STRING",
    "           Output frequency (year, month)",
    "",
    "NOTE",
    "    Precipitation rates in [mm/s] have to be converted to precipitation amounts (multiply with 86400",
    "    s).  Apart from metadata information the result of eca_pd,1 and eca_rr1 is the same.",
    "",
    "EXAMPLE",
    "    To get the number of days with precipitation greater than 25 mm for a time series of daily",
    "    precipitation amounts use:",
    "",
    "       cdo eca_pd,25 infile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Fabian Wachsmann",
    "",
};

const CdoHelp Eca_r75pHelp = {
    "NAME",
    "    eca_r75p - Moderate wet days wrt 75th percentile of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_r75p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1",
    "    mm) and infile2 be the 75th percentile RRn75 of the daily precipitation amount at wet days for any",
    "    period used as reference. Then the percentage of wet days with RR > RRn75 is calculated.  RRn75 is",
    "    calculated as the 75th percentile of all wet days of a given climate reference period.  Usually",
    "    infile2 is generated by the operator ydaypctl,75.  The date information of a timestep in outfile",
    "    is the date of the last contributing timestep in infile1.",
    "",
    "EXAMPLE",
    "    To compute the percentage of wet days with daily precipitation amount greater than the 75th",
    "    percentile of the daily precipitation amount at wet days for a given reference period use:",
    "",
    "       cdo eca_r75p rrfile rrn75file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_r75ptotHelp = {
    "NAME",
    "    eca_r75ptot - Precipitation percent due to R75p days",
    "",
    "SYNOPSIS",
    "    cdo  eca_r75ptot  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1",
    "    mm) and infile2 be the 75th percentile RRn75 of the daily precipitation amount at wet days for any",
    "    period used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn75 to",
    "    the total precipitation sum is calculated.  RRn75 is calculated as the 75th percentile of all wet",
    "    days of a given climate reference period.  Usually infile2 is generated by the operator",
    "    ydaypctl,75.  The date information of a timestep in outfile is the date of the last contributing",
    "    timestep in infile1.",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_r90pHelp = {
    "NAME",
    "    eca_r90p - Wet days wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_r90p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1",
    "    mm) and infile2 be the 90th percentile RRn90 of the daily precipitation amount at wet days for any",
    "    period used as reference. Then the percentage of wet days with RR > RRn90 is calculated.  RRn90 is",
    "    calculated as the 90th percentile of all wet days of a given climate reference period.  Usually",
    "    infile2 is generated by the operator ydaypctl,90.",
    "",
    "EXAMPLE",
    "    To compute the percentage of wet days where the daily precipitation amount is greater than the",
    "    90th percentile of the daily precipitation amount at wet days for a given reference period use:",
    "",
    "       cdo eca_r90p rrfile rrn90file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_r90ptotHelp = {
    "NAME",
    "    eca_r90ptot - Precipitation percent due to R90p days",
    "",
    "SYNOPSIS",
    "    cdo  eca_r90ptot  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1",
    "    mm) and infile2 be the 90th percentile RRn90 of the daily precipitation amount at wet days for any",
    "    period used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn90 to",
    "    the total precipitation sum is calculated.  RRn90 is calculated as the 90th percentile of all wet",
    "    days of a given climate reference period.  Usually infile2 is generated by the operator",
    "    ydaypctl,90.  The date information of a timestep in outfile is the date of the last contributing",
    "    timestep in infile1.",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_r95pHelp = {
    "NAME",
    "    eca_r95p - Very wet days wrt 95th percentile of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_r95p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1",
    "    mm) and infile2 be the 95th percentile RRn95 of the daily precipitation amount at wet days for any",
    "    period used as reference. Then the percentage of wet days with RR > RRn95 is calculated.  RRn95 is",
    "    calculated as the 95th percentile of all wet days of a given climate reference period.  Usually",
    "    infile2 is generated by the operator ydaypctl,95.  The date information of a timestep in outfile",
    "    is the date of the last contributing timestep in infile1.",
    "",
    "EXAMPLE",
    "    To compute the percentage of wet days where the daily precipitation amount is greater than the",
    "    95th percentile of the daily precipitation amount at wet days for a given reference period use:",
    "",
    "       cdo eca_r95p rrfile rrn95file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_r95ptotHelp = {
    "NAME",
    "    eca_r95ptot - Precipitation percent due to R95p days",
    "",
    "SYNOPSIS",
    "    cdo  eca_r95ptot  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1",
    "    mm) and infile2 be the 95th percentile RRn95 of the daily precipitation amount at wet days for any",
    "    period used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn95 to",
    "    the total precipitation sum is calculated.  RRn95 is calculated as the 95th percentile of all wet",
    "    days of a given climate reference period.  Usually infile2 is generated by the operator",
    "    ydaypctl,95.  The date information of a timestep in outfile is the date of the last contributing",
    "    timestep in infile1.",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_r99pHelp = {
    "NAME",
    "    eca_r99p - Extremely wet days wrt 99th percentile of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_r99p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1",
    "    mm) and infile2 be the 99th percentile RRn99 of the daily precipitation amount at wet days for any",
    "    period used as reference. Then the percentage of wet days with RR > RRn99 is calculated.  RRn99 is",
    "    calculated as the 99th percentile of all wet days of a given climate reference period.  Usually",
    "    infile2 is generated by the operator ydaypctl,99.  The date information of a timestep in outfile",
    "    is the date of the last contributing timestep in infile1.",
    "",
    "EXAMPLE",
    "    To compute the percentage of wet days where the daily precipitation amount is greater than the",
    "    99th percentile of the daily precipitation amount at wet days for a given reference period use:",
    "",
    "       cdo eca_r99p rrfile rrn99file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_r99ptotHelp = {
    "NAME",
    "    eca_r99ptot - Precipitation percent due to R99p days",
    "",
    "SYNOPSIS",
    "    cdo  eca_r99ptot  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series RR of the daily precipitation amount at wet days (precipitation >= 1",
    "    mm) and infile2 be the 99th percentile RRn99 of the daily precipitation amount at wet days for any",
    "    period used as reference. Then the ratio of the precipitation sum at wet days with RR > RRn99 to",
    "    the total precipitation sum is calculated.  RRn99 is calculated as the 99th percentile of all wet",
    "    days of a given climate reference period.  Usually infile2 is generated by the operator",
    "    ydaypctl,99.  The date information of a timestep in outfile is the date of the last contributing",
    "    timestep in infile1.",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_rr1Help = {
    "NAME",
    "    eca_rr1 - Wet days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  eca_rr1[,R]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR in [mm] (or alternatively in [kg",
    "    m-2]), then the number of days where RR is at least R is counted. R is an optional parameter with",
    "    default R = 1 mm.  The date information of a timestep in outfile is the date of the last",
    "    contributing timestep in infile.",
    "",
    "PARAMETERS",
    "",
    "    R FLOAT",
    "           Precipitation threshold (unit: mm; default: R=1 mm)",
    "",
    "EXAMPLE",
    "    To get the number of wet days of a time series of daily precipitation amounts use:",
    "",
    "       cdo eca_rr1 rrfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_rx1dayHelp = {
    "NAME",
    "    eca_rx1day, etccdi_rx1day - Highest one day precipitation amount per time period",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,freq]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR, then the maximum of RR is",
    "    written to outfile. If the optional parameter mode is set to ‘m’ the maximum daily precipitation",
    "    amounts are determined for each month.  Parameter is a comma-separated list of “key=values” pairs.",
    "",
    "OPERATORS",
    "",
    "    eca_rx1day",
    "           Highest one day precipitation amount per time period",
    "",
    "           The operator counts over the entire time series.  The date information of a timestep in",
    "           outfile is the date of the last contributing timestep in infile.",
    "",
    "    etccdi_rx1day",
    "           Maximum 1-day Precipitation",
    "",
    "           The default output frequency is yearly.  The date information of a timestep in outfile is",
    "           the mid of the frequency interval.",
    "",
    "PARAMETERS",
    "",
    "    freq STRING",
    "           Output frequency (year, month)",
    "",
    "EXAMPLE",
    "    To get the maximum of a time series of daily precipitation amounts use:",
    "",
    "       cdo eca_rx1day rrfile outfile",
    "",
    "    If you are interested in the maximum daily precipitation for each month, use:",
    "",
    "       cdo eca_rx1day,freq=month rrfile outfile",
    "",
    "    Apart from metadata information, both operations yield the same as:",
    "",
    "       cdo timmax rrfile outfile",
    "       cdo monmax rrfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Fabian Wachsmann",
    "",
};

const CdoHelp Eca_rx5dayHelp = {
    "NAME",
    "    eca_rx5day, etccdi_rx5day - Highest five-day precipitation amount per time period",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,x[,params]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of 5-day precipitation totals RR, then the maximum of RR is written to",
    "    outfile.  A further output variable is the number of 5 day period with precipitation totals",
    "    greater than x mm, where x is an optional parameter with default x=50mm.  Parameter is a",
    "    comma-separated list of “key=values” pairs.",
    "",
    "OPERATORS",
    "",
    "    eca_rx5day",
    "           Highest five-day precipitation amount per time period",
    "",
    "           The operator counts over the entire time series.  The date information of a timestep in",
    "           outfile is the date of the last contributing timestep in infile.",
    "",
    "    etccdi_rx5day",
    "           Highest five-day precipitation amount per time period",
    "",
    "           The default output frequency is yearly.  Periods within overlapping years are accounted for",
    "           the first year.  The date information of a timestep in outfile is the mid of the frequency",
    "           interval.",
    "",
    "PARAMETERS",
    "",
    "    x FLOAT",
    "           Precipitation threshold (unit: mm; default: x=50mm)",
    "",
    "    freq STRING",
    "           Output frequency (year, month)",
    "",
    "EXAMPLE",
    "    To get the maximum of a time series of 5-day precipitation totals use:",
    "",
    "       cdo eca_rx5day rrfile outfile",
    "",
    "    Apart from metadata information, the above operation yields the same as:",
    "",
    "       cdo timmax rrfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Fabian Wachsmann",
    "",
};

const CdoHelp Eca_sdiiHelp = {
    "NAME",
    "    eca_sdii - Simple daily intensity index per time period",
    "",
    "SYNOPSIS",
    "    cdo  eca_sdii[,R]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily precipitation amount RR, then the mean precipitation",
    "    amount at wet days (RR >= R) is written to outfile. R is an optional parameter with default R=1mm.",
    "    The date information of a timestep in outfile is the date of the last contributing timestep in",
    "    infile.",
    "",
    "PARAMETERS",
    "",
    "    R FLOAT",
    "           Precipitation threshold (unit: mm; default: R=1 mm)",
    "",
    "EXAMPLE",
    "    To get the daily intensity index of a time series of daily precipitation amounts use:",
    "",
    "       cdo eca_sdii rrfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_suHelp = {
    "NAME",
    "    eca_su, etccdi_su - Summer days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,T[,params]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum temperature TX, then the number of days where TX",
    "    > T is counted. The number T is an optional parameter with default T=25°C.  Note that TX have to",
    "    be given in units of Kelvin, whereas T have to be given in degrees Celsius.  Parameter is a",
    "    comma-separated list of “key=values” pairs.",
    "",
    "OPERATORS",
    "",
    "    eca_su Summer days index per time period",
    "",
    "           The operator counts over the entire time series.  The date information of a timestep in",
    "           outfile is the date of the last contributing timestep in infile.",
    "",
    "    etccdi_su",
    "           Summer days index per time period",
    "",
    "           The default output frequency is yearly.  The date information of a timestep in outfile is",
    "           the mid of the frequency interval.",
    "",
    "PARAMETERS",
    "",
    "    T FLOAT",
    "           Temperature threshold (unit: °C; default: T=25°C)",
    "",
    "    freq STRING",
    "           Output frequency (year, month)",
    "",
    "EXAMPLE",
    "    To get the number of summer days of a time series of daily maximum temperatures use:",
    "",
    "       cdo eca_su txfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Fabian Wachsmann",
    "",
};

const CdoHelp Eca_tg10pHelp = {
    "NAME",
    "    eca_tg10p - Cold days percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_tg10p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily mean temperature TG, and infile2 be the 10th percentile",
    "    TGn10 of daily mean temperatures for any period used as reference. Then the percentage of time",
    "    where TG < TGn10 is calculated.  TGn10 is calculated as the 10th percentile of daily mean",
    "    temperatures of a five day window centered on each calendar day of a given climate reference",
    "    period.  Note that both TG and TGn10 have to be given in the same units.  The date information of",
    "    a timestep in outfile is the date of the last contributing timestep in infile1.",
    "",
    "EXAMPLE",
    "    To compute the percentage of timesteps with a daily mean temperature smaller than the 10th",
    "    percentile of the daily mean temperatures for a given reference period use:",
    "",
    "       cdo eca_tg10p tgfile tgn10file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_tg90pHelp = {
    "NAME",
    "    eca_tg90p - Warm days percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_tg90p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily mean temperature TG, and infile2 be the 90th percentile",
    "    TGn90 of daily mean temperatures for any period used as reference. Then the percentage of time",
    "    where TG > TGn90 is calculated.  TGn90 is calculated as the 90th percentile of daily mean",
    "    temperatures of a five day window centered on each calendar day of a given climate reference",
    "    period.  Note that both TG and TGn90 have to be given in the same units.  The date information of",
    "    a timestep in outfile is the date of the last contributing timestep in infile1.",
    "",
    "EXAMPLE",
    "    To compute the percentage of timesteps with a daily mean temperature greater than the 90th",
    "    percentile of the daily mean temperatures for a given reference period use:",
    "",
    "       cdo eca_tg90p tgfile tgn90file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_tn10pHelp = {
    "NAME",
    "    eca_tn10p - Cold nights percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_tn10p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time serie of the daily minimum temperature TN, and infile2 be the 10th",
    "    percentile TNn10 of daily minimum temperatures for any period used as reference. Then the",
    "    percentage of time where TN < TNn10 is calculated.  TNn10 is calculated as the 10th percentile of",
    "    daily minimum temperatures of a five day window centered on each calendar day of a given climate",
    "    reference period.  Note that both TN and TNn10 have to be given in the same units.  The date",
    "    information of a timestep in outfile is the date of the last contributing timestep in infile1.",
    "",
    "EXAMPLE",
    "    To compute the percentage of timesteps with a daily minimum temperature smaller than the 10th",
    "    percentile of the daily minimum temperatures for a given reference period use:",
    "",
    "       cdo eca_tn10p tnfile tnn10file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_tn90pHelp = {
    "NAME",
    "    eca_tn90p - Warm nights percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_tn90p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily minimum temperature TN, and infile2 be the 90th",
    "    percentile TNn90 of daily minimum temperatures for any period used as reference.  Then the",
    "    percentage of time where TN > TNn90 is calculated. TNn90 is calculated as the 90th percentile of",
    "    daily minimum temperatures of a five day window centered on each calendar day of a given climate",
    "    reference period. Note that both TN and TNn90 have to be given in the same units.  The date",
    "    information of a timestep in outfile is the date of the last contributing timestep in infile1.",
    "",
    "EXAMPLE",
    "    To compute the percentage of timesteps with a daily minimum temperature greater than the 90th",
    "    percentile of the daily minimum temperatures for a given reference period use:",
    "",
    "       cdo eca_tn90p tnfile tnn90file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_trHelp = {
    "NAME",
    "    eca_tr, etccdi_tr - Tropical nights index per time period",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,T[,params]]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily minimum temperature TN, then the number of days where TN",
    "    > T is counted. The number T is an optional parameter with default T= 20°C.  Note that TN have to",
    "    be given in units of Kelvin, whereas T have to be given in degrees Celsius.  Parameter is a",
    "    comma-separated list of “key=values” pairs.",
    "",
    "OPERATORS",
    "",
    "    eca_tr Tropical nights index per time period",
    "",
    "           The operator counts over the entire time series.  The date information of a timestep in",
    "           outfile is the date of the last contributing timestep in infile.",
    "",
    "    etccdi_tr",
    "           Tropical nights index per time period",
    "",
    "           The default output frequency is yearly.  The date information of a timestep in outfile is",
    "           the mid of the frequency interval.",
    "",
    "PARAMETERS",
    "",
    "    T FLOAT",
    "           Temperature threshold (unit: °C; default: T=20°C)",
    "",
    "    freq STRING",
    "           Output frequency (year, month)",
    "",
    "EXAMPLE",
    "    To get the number of tropical nights of a time series of daily minimum temperatures use:",
    "",
    "       cdo eca_tr tnfile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Fabian Wachsmann",
    "",
};

const CdoHelp Eca_tx10pHelp = {
    "NAME",
    "    eca_tx10p - Very cold days percent wrt 10th percentile of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_tx10p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily maximum temperature TX, and infile2 be the 10th",
    "    percentile TXn10 of daily maximum temperatures for any period used as reference. Then the",
    "    percentage of time where TX < TXn10.  is calculated.  TXn10 is calculated as the 10th percentile",
    "    of daily maximum temperatures of a five day window centered on each calendar day of a given",
    "    climate reference period.  Note that both TX and TXn10 have to be given in the same units.  The",
    "    date information of a timestep in outfile is the date of the last contributing timestep in",
    "    infile1.",
    "",
    "EXAMPLE",
    "    To compute the percentage of timesteps with a daily maximum temperature smaller than the 10th",
    "    percentile of the daily maximum temperatures for a given reference period use:",
    "",
    "       cdo eca_tx10p txfile txn10file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp Eca_tx90pHelp = {
    "NAME",
    "    eca_tx90p - Very warm days percent wrt 90th percentile of reference period",
    "",
    "SYNOPSIS",
    "    cdo  eca_tx90p  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily maximum temperature TX, and infile2 be the 90th",
    "    percentile TXn90 of daily maximum temperatures for any period used as reference. Then the",
    "    percentage of time where TX > TXn90.  is calculated.  TXn90 is calculated as the 90th percentile",
    "    of daily maximum temperatures of a five day window centered on each calendar day of a given",
    "    climate reference period.  Note that both TX and TXn90 have to be given in the same units.  The",
    "    date information of a timestep in outfile is the date of the last contributing timestep in",
    "    infile1.",
    "",
    "EXAMPLE",
    "    To compute the percentage of timesteps with a daily maximum temperature greater than the 90th",
    "    percentile of the daily maximum temperatures for a given reference period use:",
    "",
    "       cdo eca_tx90p txfile txn90file outfile",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp EnlargeHelp = {
    "NAME",
    "    enlarge - Enlarge fields",
    "",
    "SYNOPSIS",
    "    cdo  enlarge,grid  infile outfile",
    "",
    "DESCRIPTION",
    "    Enlarge all fields of infile to a user given horizontal grid. Normally only the last field element",
    "    is used for the enlargement. If however the input and output grid are regular lon/lat grids, a",
    "    zonal or meridional enlargement is possible.  Zonal enlargement takes place, if the xsize of the",
    "    input field is 1 and the ysize of both grids are the same. For meridional enlargement the ysize",
    "    have to be 1 and the xsize of both grids should have the same size.",
    "",
    "PARAMETERS",
    "",
    "    grid (STRING)",
    "           Target grid description file or name",
    "",
    "EXAMPLE",
    "    Assumed you want to add two datasets. The first dataset is a field on a global grid (n field",
    "    elements) and the second dataset is a global mean (1 field element).  Before you can add these two",
    "    datasets the second dataset have to be enlarged to the grid size of the first dataset:",
    "",
    "       cdo enlarge,infile1 infile2 tmpfile",
    "       cdo add infile1 tmpfile outfile",
    "",
    "    Or shorter using operator piping:",
    "",
    "       cdo add infile1 -enlarge,infile1 infile2 outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp EnsstatHelp = {
    "NAME",
    "    ensmin, ensmax, ensrange, enssum, ensmean, ensavg, ensstd, ensstd1, ensvar, ensvar1, ensskew,",
    "    enskurt, ensmedian, enspctl - Ensemble statistics",
    "",
    "SYNOPSIS",
    "    cdo [options]  <operator>  infiles outfile",
    "",
    "    cdo [options]  enspctl,pn  infiles outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over an ensemble of input files.  Depending on the chosen",
    "    operator, the minimum, maximum, range, sum, average, standard deviation, variance, skewness,",
    "    kurtosis, median or a certain percentile over all input files is written to outfile.  All input",
    "    files need to have the same structure with the same variables.  The date information of a timestep",
    "    in outfile is the date of the first input file.",
    "",
    "OPERATORS",
    "",
    "    ensmin Ensemble minimum",
    "",
    "           o(t,x) = min{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    ensmax Ensemble maximum",
    "",
    "           o(t,x) = max{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    ensrange",
    "           Ensemble range",
    "",
    "           o(t,x) = range{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    enssum Ensemble sum",
    "",
    "           o(t,x) = sum{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    ensmean",
    "           Ensemble mean",
    "",
    "           o(t,x) = mean{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    ensavg Ensemble average",
    "",
    "           o(t,x) = avg{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    ensstd Ensemble standard deviation",
    "",
    "           Normalize by n.",
    "",
    "           o(t,x) = std{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    ensstd1",
    "           Ensemble standard deviation (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "           o(t,x) = std1{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    ensvar Ensemble variance",
    "",
    "           Normalize by n.",
    "",
    "           o(t,x) = var{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    ensvar1",
    "           Ensemble variance (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "           o(t,x) = var1{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    ensskew",
    "           Ensemble skewness",
    "",
    "           o(t,x) = skew{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    enskurt",
    "           Ensemble kurtosis",
    "",
    "           o(t,x) = kurt{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    ensmedian",
    "           Ensemble median",
    "",
    "           o(t,x) = median{i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "    enspctl",
    "           Ensemble percentile",
    "",
    "           o(t,x) = pth percentile {i1(t,x), i2(t,x), …, in(t,x)}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "OPTIONS",
    "    -O, --overwrite to overwrite existing output file.",
    "",
    "NOTE",
    "    Operators of this module need to open all input files simultaneously.  The maximum number of open",
    "    files depends on the operating system!",
    "",
    "EXAMPLE",
    "    To compute the ensemble mean over 6 input files use:",
    "",
    "       cdo ensmean infile1 infile2 infile3 infile4 infile5 infile6 outfile",
    "",
    "    Or shorter with filename substitution:",
    "",
    "       cdo ensmean infile[1-6] outfile",
    "",
    "    To compute the 50th percentile (median) over 6 input files use:",
    "",
    "       cdo enspctl,50 infile1 infile2 infile3 infile4 infile5 infile6 outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp Ensstat2Help = {
    "NAME",
    "    ensrkhistspace, ensrkhisttime, ensroc - Statistical values over an ensemble",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  obsfile ensfiles outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over the ensemble of ensfiles using obsfile as a",
    "    reference. Depending on the operator a ranked Histogram or a roc-curve over all Ensembles ensfiles",
    "    with reference to obsfile is written to outfile.  The date and grid information of a timestep in",
    "    outfile is the date of the first input file. Thus all input files are required to have the same",
    "    structure in terms of the gridsize, variable definitions and number of timesteps.",
    "",
    "    All Operators in this module use obsfile as the reference (for instance an observation) whereas",
    "    ensfiles are understood as an ensemble consisting of n (where n is the number of ensfiles)",
    "    members.",
    "",
    "    The operators ensrkhistspace and ensrkhisttime compute Ranked Histograms.  Therefor the vertical",
    "    axis is utilized as the Histogram axis, which prohibits the use of files containing more than one",
    "    level. The histogram axis has nensfiles+1 bins with level 0 containing for each grid point the",
    "    number of observations being smaller as all ensembles and level nensfiles+1 indicating the number",
    "    of observations being larger than all ensembles.",
    "",
    "    ensrkhisttime computes a ranked histogram at each timestep reducing each horizontal grid to a 1x1",
    "    grid and keeping the time axis as in obsfile.  Contrary ensrkhistspace  computes a histogram at",
    "    each grid point keeping the horizontal grid for each variable and reducing the time-axis. The time",
    "    information is that from the last timestep in obsfile.",
    "",
    "OPERATORS",
    "",
    "    ensrkhisttime",
    "           Ranked Histogram averaged over time",
    "",
    "    ensrkhistspace",
    "           Ranked Histogram averaged over space",
    "",
    "    ensroc Ensemble Receiver Operating characteristics",
    "",
    "EXAMPLE",
    "    To compute a rank histogram over 5 input files ensfile1-ensfile5 given an observation in obsfile",
    "    use:",
    "",
    "       cdo ensrkhisttime obsfile ensfile1 ensfile2 ensfile3 ensfile4 ensfile5 outfile",
    "",
    "    Or shorter with filename substitution:",
    "",
    "       cdo ensrkhisttime obsfile ensfile[1-5] outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp EnsvalHelp = {
    "NAME",
    "    enscrps, ensbrs - Ensemble validation tools",
    "",
    "SYNOPSIS",
    "    cdo  enscrps  rfile infiles outfilebase",
    "",
    "    cdo  ensbrs,x  rfile infiles outfilebase",
    "",
    "DESCRIPTION",
    "    This module computes ensemble validation scores and their decomposition such as the Brier and",
    "    cumulative ranked probability score (CRPS).  The first file is used as a reference it can be a",
    "    climatology, observation or reanalysis against which the skill of the ensembles given in infiles",
    "    is measured.  Depending on the operator a number of output files is generated each containing the",
    "    skill score and its decomposition corresponding to the operator.  The output is averaged  over",
    "    horizontal fields using appropriate weights for each level and timestep in rfile.",
    "",
    "    All input files need to have the same structure with the same variables.  The date information of",
    "    a timestep in outfile is the date of the first input file.  The output files are named as",
    "    <outfilebase>.<type>.<filesuffix> where <type> depends on the operator and <filesuffix> is",
    "    determined from the output file type.  There are three output files for operator enscrps and four",
    "    output files for operator ensbrs.",
    "",
    "    The CRPS and its decomposition into Reliability and the potential CRPS are calculated by an",
    "    appropriate averaging over the field members (note, that the CRPS does not average linearly).  In",
    "    the three output files <type> has the following meaning: crps for the CRPS, reli for the",
    "    reliability and crpspot for the potential crps. The relation CRPS = CRPS_{pot} + RELI holds.",
    "",
    "    The Brier score of the Ensemble given by infiles with respect to the reference given in rfile and",
    "    the threshold x is calculated.  In the four output files <type> has the following meaning: brs for",
    "    the Brier score wrt threshold  x; brsreli for the Brier score reliability wrt threshold x; brsreso",
    "    for the Brier score resolution wrt threshold x; brsunct for the Brier score uncertainty wrt",
    "    threshold x.  In analogy to the CRPS the following relation holds BRS(x) = RELI(x)-RESO(x)+",
    "    UNCT(x).",
    "",
    "    The implementation of the decomposition of the CRPS and Brier Score follows",
    "           Hans Hersbach (2000): Decomposition of the Continuous Ranked Probability Score for Ensemble",
    "           Prediction Systems, in: Weather and Forecasting (15) pp. 559-570.",
    "",
    "    The CRPS code decomposition has been verified against the CRAN - ensemble validation package from",
    "    R. Differences occur when grid-cell area is not uniform as the implementation in R does not",
    "    account for that.",
    "",
    "OPERATORS",
    "",
    "    enscrps",
    "           Ensemble CRPS and decomposition",
    "",
    "    ensbrs Ensemble Brier score",
    "",
    "PARAMETERS",
    "",
    "    x (FLOAT)",
    "           threshold",
    "",
    "EXAMPLE",
    "    To compute the field averaged Brier score at x=5 over an ensemble with 5 members ensfile1-5 w.r.t.",
    "    the reference rfile and write the results to files obase.brs.<suff>, obase.brsreli<suff>,",
    "    obase.brsreso<suff>, obase.brsunct<suff> where <suff> is determined from the output file type, use",
    "",
    "       cdo ensbrs,5 rfile ensfile1 ensfile2 ensfile3 ensfile4 ensfile5 obase",
    "",
    "    or shorter using file name substitution:",
    "",
    "       cdo ensbrs,5 rfile ensfile[1-5] obase",
    "",
    "AUTHOR",
    "    Cedrick Ansorge",
    "",
};

const CdoHelp EofHelp = {
    "NAME",
    "    eof, eoftime, eofspatial, eof3d - Empirical Orthogonal Functions",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,neof  infile outfile1 outfile2",
    "",
    "DESCRIPTION",
    "    This module calculates empirical orthogonal functions of the data in infile as the eigen values of",
    "    the scatter matrix (covariance matrix) S of the data sample z(t). A more detailed description can",
    "    be found above.",
    "",
    "    Please note, that the input data are assumed to be anomalies.",
    "",
    "    If operator eof is chosen, the EOFs are computed in either time or spatial space, whichever is the",
    "    fastest. If the user already knows, which computation is faster, the module can be forced to",
    "    perform a computation in time- or gridspace by using the operators eoftime or eofspatial,",
    "    respectively. This can enhance performance, especially for very long time series, where the number",
    "    of timesteps is larger than the number of grid-points. Data in infile are assumed to be anomalies.",
    "    If they are not, the behavior of this module is not well defined.  After execution outfile1 will",
    "    contain all eigen-values and outfile2 the eigenvectors e_j. All EOFs and eigen-values are",
    "    computed. However, only the first neof EOFs are written to outfile2. Nonetheless, outfile1",
    "    contains all eigen-values.",
    "",
    "    Missing values are not fully supported. Support is only checked for non-changing masks of missing",
    "    values in time. Although there still will be results, they are not trustworthy, and a warning will",
    "    occur. In the latter case we suggest to replace missing values by 0 in infile.",
    "",
    "OPERATORS",
    "",
    "    eof    Calculate EOFs in spatial or time space",
    "",
    "    eof3d  Calculate 3-Dimensional EOFs in time space",
    "",
    "    eoftime",
    "           Calculate EOFs in time space",
    "",
    "    eofspatial",
    "           Calculate EOFs in spatial space",
    "",
    "PARAMETERS",
    "",
    "    neof (INTEGER)",
    "           Number of eigen functions",
    "",
    "ENVIRONMENT",
    "",
    "    CDO_SVD_MODE",
    "           Is used to choose the algorithm for eigenvalue calculation. Options are ‘jacobi’ for a",
    "           one-sided parallel jacobi-algorithm (only executed in parallel if -P flag is set) and",
    "           ‘danielson_lanczos’ for a non-parallel d/l algorithm. The default setting is ‘jacobi’.",
    "",
    "    CDO_WEIGHT_MODE",
    "           It is used to set the weight mode. The default is ‘off’. Set it to ‘on’ for a weighted",
    "           version.",
    "",
    "    MAX_JACOBI_ITER",
    "           Is the maximum integer number of annihilation sweeps that is executed if the",
    "           jacobi-algorithm is used to compute the eigen values. The default value is 12.",
    "",
    "    FNORM_PRECISION",
    "           Is the Frobenius norm of the matrix consisting of an annihilation pair of eigenvectors that",
    "           is used to determine if the eigenvectors have reached a sufficient level of convergence. If",
    "           all annihilation-pairs of vectors have a norm below this value, the computation is",
    "           considered to have converged properly. Otherwise, a warning will occur. The default value",
    "           1e-12.",
    "",
    "EXAMPLE",
    "    To calculate the first 40 EOFs of a data-set containing anomalies use:",
    "",
    "       cdo eof,40 infile outfile1 outfile2",
    "",
    "    If the dataset does not contain anomalies, process them first, and use:",
    "",
    "       cdo sub infile1 -timmean infile1 anom_file",
    "       cdo eof,40 anom_file outfile1 outfile2",
    "",
    "AUTHOR",
    "    Cedrick Ansorge",
    "",
};

const CdoHelp EofcoeffHelp = {
    "NAME",
    "    eofcoeff - Principal coefficients of EOFs",
    "",
    "SYNOPSIS",
    "    cdo  eofcoeff  infile1 infile2 obase",
    "",
    "DESCRIPTION",
    "    This module calculates the time series of the principal coefficients for given EOF (empirical",
    "    orthogonal functions) and data. Time steps in infile1 are assumed to be the EOFs, time steps in",
    "    infile2 are assumed to be the time series.",
    "",
    "    Note, that this operator calculates a non weighted dot product of the fields in infile1 and",
    "    infile2.  For consistency set the environment variable CDO_WEIGHT_MODE=off when using eof or",
    "    eof3d.",
    "",
    "    There will be a separate file containing a time series of principal coefficients with time",
    "    information from infile2 for each EOF in infile1. Output files will be numbered as",
    "    <obase><neof><suffix> where neof+1 is the number of the EOF (timestep) in infile1 and suffix is",
    "    the filename extension derived from the file format.",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX sets the filename suffix.",
    "",
    "EXAMPLE",
    "    To calculate principal coefficients of the first 40 EOFs of anom_file, and write them to files",
    "    beginning with obase, use:",
    "",
    "       export CDO_WEIGHT_MODE=off",
    "       cdo eof,40 anom_file eval_file eof_file",
    "       cdo eofcoeff eof_file anom_file obase",
    "",
    "    The principal coefficients of the first EOF will be in the file obase000000.nc (and so forth for",
    "    higher EOFs, nth EOF will be in obase<n-1>).",
    "",
    "    If the dataset infile does not containt anomalies, process them first, and use:",
    "",
    "       export CDO_WEIGHT_MODE=off",
    "       cdo sub infile -timmean infile anom_file",
    "       cdo eof,40 anom_file eval_file eof_file",
    "       cdo eofcoeff eof_file anom_file obase",
    "",
    "AUTHOR",
    "    Cedrick Ansorge",
    "",
};

const CdoHelp ExprHelp = {
    "NAME",
    "    expr, exprf, aexpr, aexprf - Evaluate expressions",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module arithmetically processes every timestep of the input dataset.  Each individual",
    "    assignment statement have to end with a semi-colon.  The special key _ALL_ is used as a template.",
    "    A statement with a template is replaced for all variable names.  Unlike regular variables,",
    "    temporary variables are never written to the output stream.  To define a temporary variable simply",
    "    prefix the variable name with an underscore (e.g. _varname) when the variable is declared.",
    "",
    "    The following operators are supported:",
    "",
    "                   ┌─────────┬─────────────────────┬───────────┬───────────────────────┐",
    "                   │Operator │ Meaning             │ Example   │ Result                │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │=        │ assignment          │ x = y     │ Assigns y to x        │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │+        │ addition            │ x + y     │ Sum of x and y        │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │-        │ subtraction         │ x - y     │ Difference of x and y │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │*        │ multiplication      │ x * y     │ Product of x and y    │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │/        │ division            │ x / y     │ Quotient of x and y   │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │exp      │ exponentiation      │ x exp y   │ Exponentiates x with  │",
    "                   │         │                     │           │ y                     │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │==       │ equal to            │ x == y    │ 1, if x equal to y;   │",
    "                   │         │                     │           │ else 0                │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │!=       │ not equal to        │ x != y    │ 1, if x not equal to  │",
    "                   │         │                     │           │ y; else 0             │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │>        │ greater than        │ x > y     │ 1, if x greater than  │",
    "                   │         │                     │           │ y; else 0             │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │<        │ less than           │ x < y     │ 1, if x less than y;  │",
    "                   │         │                     │           │ else 0                │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │>=       │ greater equal       │ x >= y    │ 1, if x greater equal │",
    "                   │         │                     │           │ y; else 0             │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │<=       │ less equal          │ x <= y    │ 1, if x less equal y; │",
    "                   │         │                     │           │ else 0                │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │<=>      │ less equal greater  │ x <=> y   │ -1, if x less y; 1,   │",
    "                   │         │                     │           │ if x greater y; else  │",
    "                   │         │                     │           │ 0                     │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │and      │ logical AND         │ x and y   │ 1, if x and y not     │",
    "                   │         │                     │           │ equal 0; else 0       │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │or       │ logical OR          │ x or y    │ 1, if x or y not      │",
    "                   │         │                     │           │ equal 0; else 0       │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │!        │ logical NOT         │ !x        │ 1, if x equal 0; else │",
    "                   │         │                     │           │ 0                     │",
    "                   ├─────────┼─────────────────────┼───────────┼───────────────────────┤",
    "                   │?:       │ ternary conditional │ x ? y : z │ y, if x not equal 0,  │",
    "                   │         │                     │           │ else z                │",
    "                   └─────────┴─────────────────────┴───────────┴───────────────────────┘",
    "    The following functions are supported:",
    "",
    "    Math intrinsics:",
    "",
    "                           ┌─────────────┬─────────────────────────────────────┐",
    "                           │abs(x)       │ Absolute value of x                 │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │floor(x)     │ Round to largest integral value not │",
    "                           │             │ greater than x                      │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │ceil(x)      │ Round to smallest integral value    │",
    "                           │             │ not less than x                     │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │float(x)     │ 32-bit float value of x             │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │int(x)       │ Integer value of x                  │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │nint(x)      │ Nearest integer value of x          │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │sqr(x)       │ Square of x                         │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │sqrt(x)      │ Square Root of x                    │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │exp(x)       │ Exponential of x                    │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │ln(x)        │ Natural logarithm of x              │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │log10(x)     │ Base 10 logarithm of x              │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │sin(x)       │ Sine of x, where x is specified in  │",
    "                           │             │ radians                             │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │cos(x)       │ Cosine of x, where x is specified   │",
    "                           │             │ in radians                          │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │tan(x)       │ Tangent of x, where x is specified  │",
    "                           │             │ in radians                          │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │asin(x)      │ Arc-sine of x, where x is specified │",
    "                           │             │ in radians                          │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │acos(x)      │ Arc-cosine of x, where x is         │",
    "                           │             │ specified in radians                │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │atan(x)      │ Arc-tangent of x, where x is        │",
    "                           │             │ specified in radians                │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │sinh(x)      │ Hyperbolic sine of x, where x is    │",
    "                           │             │ specified in radians                │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │cosh(x)      │ Hyperbolic cosine of x, where x is  │",
    "                           │             │ specified in radians                │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │tanh(x)      │ Hyperbolic tangent of x, where x is │",
    "                           │             │ specified in radians                │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │asinh(x)     │ Inverse hyperbolic sine of x, where │",
    "                           │             │ x is specified in radians           │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │acosh(x)     │ Inverse hyperbolic cosine of x,     │",
    "                           │             │ where x is specified in radians     │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │atanh(x)     │ Inverse hyperbolic tangent of x,    │",
    "                           │             │ where x is specified in radians     │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │rad(x)       │ Convert x from degrees to radians   │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │deg(x)       │ Convert x from radians to degrees   │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │rand(x)      │ Replace x by pseudo-random numbers  │",
    "                           │             │ in the range of 0 to 1              │",
    "                           ├─────────────┼─────────────────────────────────────┤",
    "                           │isMissval(x) │ Returns 1 where x is missing        │",
    "                           └─────────────┴─────────────────────────────────────┘",
    "┌───────────────┬───────────────────────────────────────────────────────────────────────────────────────────────────┐",
    "│mod(x,y)       │ Floating-point remainder of x/ y                                                                  │",
    "├───────────────┼───────────────────────────────────────────────────────────────────────────────────────────────────┤",
    "│min(x,y)       │ Minimum value of x and y                                                                          │",
    "├───────────────┼───────────────────────────────────────────────────────────────────────────────────────────────────┤",
    "│max(x,y)       │ Maximum value of x and y                                                                          │",
    "├───────────────┼───────────────────────────────────────────────────────────────────────────────────────────────────┤",
    "│pow(x,y)       │ Power function                                                                                    │",
    "├───────────────┼───────────────────────────────────────────────────────────────────────────────────────────────────┤",
    "│hypot(x,y)     │ Euclidean distance function, sqrt(x*x + y*y)                                                      │",
    "├───────────────┼───────────────────────────────────────────────────────────────────────────────────────────────────┤",
    "│atan2(x,y)     │ Arc tangent function of y/x, using signs to determine quadrants                                   │",
    "├───────────────┼───────────────────────────────────────────────────────────────────────────────────────────────────┤",
    "│trimrel(x,kb)  │ Trim relative precision to kb keep-bits. Max relative error to a value | result - x | / x <       │",
    "│               │ 2**(-1-kb) for any finite x. trimrel is a non-decreasing function of x. Loosely follows A5 of     │",
    "│               │ https://gmd.copernicus.org/articles/14/377/2021/                                                  │",
    "├───────────────┼───────────────────────────────────────────────────────────────────────────────────────────────────┤",
    "│trimabs(x,err) │ Trim absolute precision introducing given max. absolute error | result - x | < err, trimabs is a  │",
    "│               │ non-decreasing function of x. Loosely follows A6 of                                               │",
    "│               │ https://gmd.copernicus.org/articles/14/377/2021/                                                  │",
    "└───────────────┴───────────────────────────────────────────────────────────────────────────────────────────────────┘",
    "    Coordinates:",
    "",
    "                          ┌──────────────┬─────────────────────────────────────┐",
    "                          │clon(x)       │ Longitude coordinate of x           │",
    "                          │              │ (available only if x has            │",
    "                          │              │ geographical coordinates)           │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │clat(x)       │ Latitude coordinate of x (available │",
    "                          │              │ only if x has geographical          │",
    "                          │              │ coordinates)                        │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │gridarea(x)   │ Grid cell area of x (available only │",
    "                          │              │ if x has geographical coordinates)  │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │gridindex(x)  │ Grid cell indices of x              │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │clev(x)       │ Level coordinate of x (0, if x is a │",
    "                          │              │ 2D surface variable)                │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │clevidx(x)    │ Level index of x (0, if x is a 2D   │",
    "                          │              │ surface variable)                   │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │cthickness(x) │ Layer thickness, upper minus lower  │",
    "                          │              │ level bound of x (1, if level       │",
    "                          │              │ bounds are missing)                 │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │ctimestep()   │ Timestep number (1 to N)            │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │cdate()       │ Verification date as YYYYMMDD       │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │ctime()       │ Verification time as                │",
    "                          │              │ HHMMSS.millisecond                  │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │cdeltat()     │ Difference between current and last │",
    "                          │              │ timestep in seconds                 │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │cday()        │ Day as DD                           │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │cmonth()      │ Month as MM                         │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │cyear()       │ Year as YYYY                        │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │csecond()     │ Second as SS.millisecond            │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │cminute()     │ Minute as MM                        │",
    "                          ├──────────────┼─────────────────────────────────────┤",
    "                          │chour()       │ Hour as HH                          │",
    "                          └──────────────┴─────────────────────────────────────┘",
    "    Constants:",
    "",
    "                             ┌───────────┬──────────────────────────────────┐",
    "                             │ngp(x)     │ Number of horizontal grid points │",
    "                             ├───────────┼──────────────────────────────────┤",
    "                             │nlev(x)    │ Number of vertical levels        │",
    "                             ├───────────┼──────────────────────────────────┤",
    "                             │size(x)    │ Total number of elements         │",
    "                             │           │ (ngp(x)*nlev(x))                 │",
    "                             ├───────────┼──────────────────────────────────┤",
    "                             │missval(x) │ Returns the missing value of     │",
    "                             │           │ variable x                       │",
    "                             └───────────┴──────────────────────────────────┘",
    "    Statistics over a field:",
    "",
    "    fldmin(x), fldmax(x), fldrange(x), fldsum(x), fldmean(x), fldavg(x), fldstd(x), fldstd1(x),",
    "    fldvar(x), fldvar1(x), fldskew(x), fldkurt(x), fldmedian(x)",
    "",
    "    Zonal statistics for regular 2D grids:",
    "",
    "    zonmin(x), zonmax(x), zonrange(x), zonsum(x), zonmean(x), zonavg(x), zonstd(x), zonstd1(x),",
    "    zonvar(x), zonvar1(x), zonskew(x), zonkurt(x), zonmedian(x)",
    "",
    "    Vertical statistics:",
    "",
    "    vertmin(x), vertmax(x), vertrange(x), vertsum(x), vertmean(x), vertavg(x), vertstd(x),",
    "    vertstd1(x), vertvar(x), vertvar1(x)",
    "",
    "    Miscellaneous:",
    "",
    "                      ┌────────────────────────┬────────────────────────────────────┐",
    "                      │sellevel(x,k)           │ Select level k of variable x       │",
    "                      ├────────────────────────┼────────────────────────────────────┤",
    "                      │sellevidx(x,k)          │ Select level index k of variable x │",
    "                      ├────────────────────────┼────────────────────────────────────┤",
    "                      │sellevelrange(x,k1,k2)  │ Select all levels of variable x in │",
    "                      │                        │ the range k1 to k2                 │",
    "                      ├────────────────────────┼────────────────────────────────────┤",
    "                      │sellevidxrange(x,k1,k2) │ Select all level indices of        │",
    "                      │                        │ variable x in the range k1 to k2   │",
    "                      ├────────────────────────┼────────────────────────────────────┤",
    "                      │remove(x)               │ Remove variable x from output      │",
    "                      │                        │ stream                             │",
    "                      └────────────────────────┴────────────────────────────────────┘",
    "OPERATORS",
    "",
    "    expr   Evaluate expressions",
    "",
    "           The processing instructions are read from the instr parameter .",
    "",
    "    exprf  Evaluate expressions script",
    "",
    "           Contrary to expr the processing instructions are read from a file (Parameter: filename).",
    "",
    "    aexpr  Evaluate expressions and append results",
    "",
    "           Same as expr, but keep input variables and append results",
    "",
    "    aexprf Evaluate expression script and append results",
    "",
    "           Same as exprf, but keep input variables and append results",
    "",
    "PARAMETERS",
    "",
    "    instr (STRING)",
    "           Processing instructions (need to be 'quoted' in most cases)",
    "",
    "    filename (STRING)",
    "           File with processing instructions",
    "",
    "NOTE",
    "    If the input stream contains duplicate entries of the same variable name then the last one is",
    "    used.",
    "",
    "EXAMPLE",
    "    Assume an input dataset contains at least the variables 'aprl', 'aprc' and 'ts'.  To create a new",
    "    variable 'var1' with the sum of 'aprl' and 'aprc' and a variable 'var2' which convert the",
    "    temperature 'ts' from Kelvin to Celsius use:",
    "",
    "       cdo expr,'var1=aprl+aprc;var2=ts-273.15;' infile outfile",
    "",
    "    The same example, but the instructions are read from a file:",
    "",
    "       cdo exprf,myexpr infile outfile",
    "",
    "    The file myexpr contains:",
    "",
    "       var1 = aprl + aprc;",
    "       var2 = ts - 273.15;",
    "",
    "AUTHOR",
    "    Uwe Schulzweida, Karl-Hermann Wieners",
    "",
};

const CdoHelp FdnsHelp = {
    "NAME",
    "    fdns - Frost days where no snow index per time period",
    "",
    "SYNOPSIS",
    "    cdo  fdns  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 be a time series of the daily minimum temperature TN and infile2 be a corresponding",
    "    series of daily surface snow amounts. Then the number of days where TN < 0°C and the surface snow",
    "    amount is less than 1 cm is counted. The temperature TN have to be given in units of Kelvin.  The",
    "    date information of a timestep in outfile is the date of the last contributing timestep in infile.",
    "",
};

const CdoHelp FiledesHelp = {
    "NAME",
    "    partab, codetab, griddes, zaxisdes, vct - Dataset description",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile",
    "",
    "DESCRIPTION",
    "    This module provides operators to print meta information about a dataset.  The printed meta-data",
    "    depends on the chosen operator.",
    "",
    "OPERATORS",
    "",
    "    partab Parameter table",
    "",
    "           Prints all available meta information of the variables.",
    "",
    "    codetab",
    "           Parameter code table",
    "",
    "           Prints a code table with a description of all variables.  For each variable the operator",
    "           prints one line listing the code, name, description and units.",
    "",
    "    griddes",
    "           Grid description",
    "",
    "           Prints the description of all grids.",
    "",
    "    zaxisdes",
    "           Z-axis description",
    "",
    "           Prints the description of all z-axes.",
    "",
    "    vct    Vertical coordinate table",
    "",
    "           Prints the vertical coordinate table.",
    "",
    "PARAMETERS",
    "",
    "    genbounds (BOOL)",
    "           Generates cell bounds for regular LonLat grids.",
    "",
    "EXAMPLE",
    "    Assume all variables of the dataset are on a regular Gausssian F16 grid.  To print the grid",
    "    description of this dataset use:",
    "",
    "       cdo griddes infile",
    "",
    "    Result:",
    "",
    "       gridtype  : gaussian",
    "       gridsize  : 2048",
    "       xname     : lon",
    "       xlongname : longitude",
    "       xunits    : degrees_east",
    "       yname     : lat",
    "       ylongname : latitude",
    "       yunits    : degrees_north",
    "       xsize     : 64",
    "       ysize     : 32",
    "       xfirst    : 0",
    "       xinc      : 5.625",
    "       yvals     : 85.76058 80.26877 74.74454 69.21297 63.67863 58.1429 52.6065",
    "                   47.06964 41.53246 35.99507 30.4575 24.91992 19.38223 13.84448",
    "                   8.306702 2.768903 -2.768903 -8.306702 -13.84448 -19.38223",
    "                   -24.91992 -30.4575 -35.99507 -41.53246 -47.06964 -52.6065",
    "                   -58.1429 -63.67863 -69.21297 -74.74454 -80.26877 -85.76058",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp FilterHelp = {
    "NAME",
    "    bandpass, lowpass, highpass - Time series filtering",
    "",
    "SYNOPSIS",
    "    cdo  bandpass,fmin,fmax  infile outfile",
    "",
    "    cdo  lowpass,fmin  infile outfile",
    "",
    "    cdo  highpass,fmax   infile outfile",
    "",
    "DESCRIPTION",
    "    This module takes the time series for each gridpoint in infile and (fast fourier) transforms it",
    "    into the frequency domain. According to the particular operator and its parameters certain",
    "    frequencies are filtered (set to zero) in the frequency domain and the spectrum is (inverse fast",
    "    fourier) transformed back into the time domain.  To determine the frequency the time-axis of",
    "    infile is used. (Data should have a constant time increment since this assumption applies for",
    "    transformation. However, the time increment has to be different from zero.)  All frequencies given",
    "    as parameter are interpreted per year. This is done by the assumption of a 365-day calendar.",
    "    Consequently if you want to perform multiyear-filtering accurately you have to delete the 29th of",
    "    February.  If your infile has a 360 year calendar the frequency parameters fmin respectively fmax",
    "    should be multiplied with a factor of 360/365 in order to obtain accurate results.  For the set up",
    "    of a frequency filter the frequency parameters have to be adjusted to a frequency in the data.",
    "    Here fmin is rounded down and fmax is always rounded up. Consequently it is possible to use",
    "    bandpass with fmin=fmax without getting a zero-field for outfile.  Hints for efficient usage:",
    "",
    "    • to get reliable results the time-series has to be detrended (cdo detrend)",
    "",
    "    • the lowest frequency greater zero that can be contained in infile is 1/(N*dT),",
    "",
    "    • the greatest frequency is 1/(2dT) (Nyquist frequency),",
    "",
    "    with N the number of timesteps and dT the time increment of infile in years.",
    "",
    "    Missing value support for operators in this module is not implemented, yet!",
    "",
    "OPERATORS",
    "",
    "    bandpass",
    "           Bandpass filtering",
    "",
    "           Bandpass filtering (pass for frequencies between fmin and fmax).  Suppresses all",
    "           variability outside the frequency range specified by [fmin,fmax].",
    "",
    "    highpass",
    "           Highpass filtering",
    "",
    "           Highpass filtering (pass for frequencies greater than fmin).  Suppresses all variability",
    "           with frequencies lower than fmin.",
    "",
    "    lowpass",
    "           Lowpass filtering",
    "",
    "           Lowpass filtering (pass for frequencies lower than fmax).  Suppresses all variability with",
    "           frequencies greater than fmax.",
    "",
    "PARAMETERS",
    "",
    "    fmin (FLOAT)",
    "           Minimum frequency per year that passes the filter.",
    "",
    "    fmax (FLOAT)",
    "           Maximum frequency per year that passes the filter.",
    "",
    "NOTE",
    "    For better performance of these operators use the CDO configure option –with-fftw3.",
    "",
    "EXAMPLE",
    "    Now assume your data are still hourly for a time period of 5 years but with a 365/366-day-calendar",
    "    and you want to suppress the variability on timescales greater or equal to one year (we suggest",
    "    here to use a number x bigger than one (e.g. x=1.5) since there will be dominant frequencies",
    "    around the peak (if there is one) as well due to the issue that the time series is not of infinite",
    "    length).  Therefor you can use the following:",
    "",
    "       cdo highpass,x -del29feb infile outfile",
    "",
    "    Accordingly you might use the following to suppress variability on timescales shorter than one",
    "    year:",
    "",
    "       cdo lowpass,1 -del29feb infile outfile",
    "",
    "    Finally you might be interested in 2-year variability. If you want to suppress the seasonal cycle",
    "    as well as say the longer cycles in climate system you might use:",
    "",
    "       cdo bandpass,x,y -del29feb infile outfile",
    "",
    "    with x<=0.5 and y >=0.5.",
    "",
    "AUTHOR",
    "    Cedrick Ansorge",
    "",
};

const CdoHelp FldcorHelp = {
    "NAME",
    "    fldcor - Correlation in grid space",
    "",
    "SYNOPSIS",
    "    cdo  fldcor  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    The correlation coefficient is a quantity that gives the quality of a least squares fitting to the",
    "    original data. This operator correlates all gridpoints of two fields for each timestep. With",
    "",
    "       S(t) = {x, i_1(t,x) != missval and i_2(t,x) != missval}",
    "",
    "    it is",
    "",
    "       o(t,1) = Cor{(i_1(t,x), i_2(t,x)), x_1 < x <= x_n}",
    "",
    "    where w(x) are the area weights obtained by the input streams.  For every timestep t only those",
    "    field elements x belong to the sample, which have i_1(t,x) != missval and i_2(t,x) != missval.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp FldcovarHelp = {
    "NAME",
    "    fldcovar - Covariance in grid space",
    "",
    "SYNOPSIS",
    "    cdo  fldcovar  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This operator calculates the covariance of two fields over all gridpoints for each timestep. With",
    "",
    "       S(t) = {x, i_1(t,x) != missval and i_2(t,x) != missval}",
    "",
    "    it is",
    "",
    "       o(t,1) = Covar{(i_1(t,x), i_2(t,x)), x_1 < x <= x_n}",
    "",
    "    where w(x) are the area weights obtained by the input streams.  For every timestep t only those",
    "    field elements x belong to the sample, which have i_1(t,x) != missval and i_2(t,x) != missval.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp FldstatHelp = {
    "NAME",
    "    fldmin, fldmax, fldrange, fldsum, fldint, fldmean, fldavg, fldstd, fldstd1, fldvar, fldvar1,",
    "    fldskew, fldkurt, fldmedian, fldcount, fldpctl - Statistical values over a field",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of all input fields. A field is a horizontal layer of a",
    "    data variable.  Depending on the chosen operator, the minimum, maximum, range, sum, integral,",
    "    average, standard deviation, variance, skewness, kurtosis, median or a certain percentile of the",
    "    field is written to outfile.",
    "",
    "OPERATORS",
    "",
    "    fldmin Field minimum",
    "",
    "           For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = min{i(t,x’), x_1<=x’<=x_n}",
    "",
    "    fldmax Field maximum",
    "",
    "           For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = max{i(t,x’), x_1<=x’<=x_n}",
    "",
    "    fldrange",
    "           Field range",
    "",
    "           For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = range{i(t,x’), x_1<=x’<=x_n}",
    "",
    "    fldsum Field sum",
    "",
    "           For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = sum{i(t,x’), x_1<=x’<=x_n}",
    "",
    "    fldint Field integral",
    "",
    "           For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = sum{i(t,x’)*cellarea(x’), x_1<=x’<=x_n}",
    "",
    "    fldmean",
    "           Field mean",
    "",
    "           For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = mean{i(t,x’), x_1<=x’<=x_n}",
    "",
    "           weighted by area weights obtained by the input field.",
    "",
    "    fldavg Field average",
    "",
    "           For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = avg{i(t,x’), x_1<=x’<=x_n}",
    "",
    "           weighted by area weights obtained by the input field.",
    "",
    "    fldvar Field variance",
    "",
    "           Normalize by n. For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = var{i(t,x’), x_1<=x’<=x_n}",
    "",
    "           weighted by area weights obtained by the input field.",
    "",
    "    fldvar1",
    "           Field variance (n-1)",
    "",
    "           Normalize by (n-1). For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = var1{i(t,x’), x_1<=x’<=x_n}",
    "",
    "           weighted by area weights obtained by the input field.",
    "",
    "    fldstd Field standard deviation",
    "",
    "           Normalize by n. For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = std{i(t,x’), x_1<=x’<=x_n}",
    "",
    "           weighted by area weights obtained by the input field.",
    "",
    "    fldstd1",
    "           Field standard deviation (n-1)",
    "",
    "           Normalize by (n-1). For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = std1{i(t,x’), x_1<=x’<=x_n}",
    "",
    "           weighted by area weights obtained by the input field.",
    "",
    "    fldskew",
    "           Field skewness",
    "",
    "           For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = skew{i(t,x’), x_1<=x’<=x_n}",
    "",
    "    fldkurt",
    "           Field kurtosis",
    "",
    "           For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = kurt{i(t,x’), x_1<=x’<=x_n}",
    "",
    "    fldmedian",
    "           Field median",
    "",
    "           For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = median{i(t,x’), x_1<=x’<=x_n}",
    "",
    "    fldcount",
    "           Field count",
    "",
    "           Number of non-missing values of the field.",
    "",
    "    fldpctl",
    "           Field percentile",
    "",
    "           For every gridpoint x_1, ..., x_n of the same field it is:",
    "",
    "           o(t,1) = pth percentile {i(t,x’), x_1<=x’<=x_n}",
    "",
    "PARAMETERS",
    "",
    "    verbose (BOOL)",
    "           print lon/lat coordinates of min/max values",
    "",
    "    weights (BOOL)",
    "           weights=FALSE disables weighting by grid cell area [default: weights=TRUE]",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "EXAMPLE",
    "    To compute the field mean of all input fields use:",
    "",
    "       cdo fldmean infile outfile",
    "",
    "    To compute the 90th percentile of all input fields use:",
    "",
    "       cdo fldpctl,pn=90 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp FourierHelp = {
    "NAME",
    "    fourier - Fourier transformation",
    "",
    "SYNOPSIS",
    "    cdo  fourier,epsilon  infile outfile",
    "",
    "DESCRIPTION",
    "    The fourier operator performs the fourier transformation or the inverse fourier transformation of",
    "    all input fields.  If the number of timesteps is a power of 2 then the algorithm of the Fast",
    "    Fourier Transformation (FFT) is used.",
    "",
    "    If the input stream infile consists only of complex fields, then the fields of outfile, computed",
    "    by",
    "",
    "       cdo -f ext fourier,1 -fourier,-1 infile outfile",
    "",
    "    are the same than that of infile. For real input files see function retocomplex.",
    "",
    "PARAMETERS",
    "",
    "    epsilon (INTEGER)",
    "           -1: forward transformation;  1: backward transformation",
    "",
    "NOTE",
    "    Complex numbers can only be stored in NetCDF4 and EXTRA format.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp GetgridcellHelp = {
    "NAME",
    "    gridcellindex - Get grid cell index",
    "",
    "SYNOPSIS",
    "    cdo  gridcellindex,parameters  infile",
    "",
    "DESCRIPTION",
    "    Get the grid cell index of one grid point selected by the parameter lon and lat.",
    "",
    "PARAMETERS",
    "",
    "    lon (FLOAT)",
    "           Longitude of the grid cell in degree",
    "",
    "    lat (FLOAT)",
    "           Latitude of the grid cell in degree",
    "",
    "EXAMPLE",
    "    The grid cell index of a data set on an F80 regular Gaussian grid at lon=10/lat=53.5 is 10250:",
    "",
    "       cdo gridcellindex,lon=10,lat=53.5 F80data",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp GradsdesHelp = {
    "NAME",
    "    gradsdes - GrADS data descriptor file",
    "",
    "SYNOPSIS",
    "    cdo  gradsdes[,mapversion]  infile",
    "",
    "DESCRIPTION",
    "    Creates a [GrADS] data descriptor file. Supported file formats are GRIB1, NetCDF, SERVICE, EXTRA",
    "    and IEG. For GRIB1 files the GrADS map file is also generated. For SERVICE and EXTRA files the",
    "    grid have to be specified with the CDO option ‘-g <grid>’. This module takes infile in order to",
    "    create filenames for the descriptor (infile.ctl) and the map (infile.gmp) file.",
    "",
    "PARAMETERS",
    "",
    "    mapversion (INTEGER)",
    "           Format version of the GrADS map file for GRIB1 datasets. Use 1 for a machine specific",
    "           version 1 GrADS map file, 2 for a machine independent version 2 GrADS map file and 4 to",
    "           support GRIB files >2GB.",
    "           A version 2 map file can be used only with GrADS version 1.8 or newer.",
    "           A version 4 map file can be used only with GrADS version 2.0 or newer.",
    "",
    "",
    "           The default is 4 for files >2GB, otherwise 2.",
    "",
    "EXAMPLE",
    "    To create a GrADS data descriptor file from a GRIB1 dataset use:",
    "",
    "       cdo gradsdes infile.grb",
    "",
    "    This will create a descriptor file with the name infile.ctl and the map file infile.gmp.",
    "",
    "    Assumed the input GRIB1 dataset has 3 variables over 12 timesteps on a regular Gaussian F16 grid.",
    "    The contents of the resulting GrADS data description file is approximately:",
    "",
    "       DSET  ^infile.grb",
    "       DTYPE  GRIB",
    "       INDEX  ^infile.gmp",
    "       XDEF 64 LINEAR 0.000000 5.625000",
    "       YDEF 32 LEVELS -85.761 -80.269 -74.745 -69.213 -63.679 -58.143",
    "                      -52.607 -47.070 -41.532 -35.995 -30.458 -24.920",
    "                      -19.382 -13.844  -8.307  -2.769   2.769   8.307",
    "                       13.844  19.382  24.920  30.458  35.995  41.532",
    "                       47.070  52.607  58.143  63.679  69.213  74.745",
    "                       80.269  85.761",
    "       ZDEF 4 LEVELS 925 850 500 200",
    "       TDEF 12 LINEAR 12:00Z1jan1987 1mo",
    "       TITLE  infile.grb  T21 grid",
    "       OPTIONS yrev",
    "       UNDEF  -9e+33",
    "       VARS  3",
    "       geosp    0  129,1,0  surface geopotential (orography)  [m^2/s^2]",
    "       t        4  130,99,0  temperature  [K]",
    "       tslm1    0  139,1,0  surface temperature of land  [K]",
    "       ENDVARS",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp GridboxstatHelp = {
    "NAME",
    "    gridboxmin, gridboxmax, gridboxrange, gridboxsum, gridboxmean, gridboxavg, gridboxstd,",
    "    gridboxstd1, gridboxvar, gridboxvar1, gridboxskew, gridboxkurt, gridboxmedian - Statistical values",
    "    over grid boxes",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over surrounding grid boxes.  Depending on the chosen",
    "    operator, the minimum, maximum, range, sum, average, standard deviation, variance, skewness,",
    "    kurtosis or median of the neighboring grid boxes is written to outfile.  All gridbox operators",
    "    only work on quadrilateral curvilinear grids.",
    "",
    "OPERATORS",
    "",
    "    gridboxmin",
    "           Gridbox minimum",
    "",
    "           Minimum value of the selected grid boxes.",
    "",
    "    gridboxmax",
    "           Gridbox maximum",
    "",
    "           Maximum value of the selected grid boxes.",
    "",
    "    gridboxrange",
    "           Gridbox range",
    "",
    "           Range (max-min value) of the selected grid boxes.",
    "",
    "    gridboxsum",
    "           Gridbox sum",
    "",
    "           Sum of the selected grid boxes.",
    "",
    "    gridboxmean",
    "           Gridbox mean",
    "",
    "           Mean of the selected grid boxes.",
    "",
    "    gridboxavg",
    "           Gridbox average",
    "",
    "           Average of the selected grid boxes.",
    "",
    "    gridboxvar",
    "           Gridbox variance",
    "",
    "           Variance of the selected grid boxes. Normalize by n.",
    "",
    "    gridboxvar1",
    "           Gridbox variance (n-1)",
    "",
    "           Variance of the selected grid boxes. Normalize by (n-1).",
    "",
    "    gridboxstd",
    "           Gridbox standard deviation",
    "",
    "           Standard deviation of the selected grid boxes. Normalize by n.",
    "",
    "    gridboxstd1",
    "           Gridbox standard deviation (n-1)",
    "",
    "           Standard deviation of the selected grid boxes. Normalize by (n-1).",
    "",
    "    gridboxskew",
    "           Gridbox skewness",
    "",
    "           Skewness of the selected grid boxes.",
    "",
    "    gridboxkurt",
    "           Gridbox kurtosis",
    "",
    "           Kurtosis of the selected grid boxes.",
    "",
    "    gridboxmedian",
    "           Gridbox median",
    "",
    "           Median of the selected grid boxes.",
    "",
    "PARAMETERS",
    "",
    "    nx (INTEGER)",
    "           Number of grid boxes in x direction",
    "",
    "    ny (INTEGER)",
    "           Number of grid boxes in y direction",
    "",
    "EXAMPLE",
    "    To compute the mean over 10x10 grid boxes of the input field use:",
    "",
    "       cdo gridboxmean,10,10 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp GridcellHelp = {
    "NAME",
    "    gridarea, gridweights - Grid cell quantities",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,parameters]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module reads the grid cell area of the first grid from the input stream. If the grid cell",
    "    area is missing it will be computed from the grid coordinates. The area of a grid cell is",
    "    calculated using spherical triangles from the coordinates of the center and the vertices. The base",
    "    is a unit sphere which is scaled with the radius of the planet.  The default planet radius is",
    "    6371000 meter. The parameter radius or the environment variable PLANET_RADIUS can be used to",
    "    change the default.  Depending on the chosen operator the grid cell area or weights are written to",
    "    the output stream.",
    "",
    "OPERATORS",
    "",
    "    gridarea",
    "           Grid cell area",
    "",
    "           Writes the grid cell area to the output stream. If the grid cell area have to be computed",
    "           it is scaled with the planet radius to square meters.",
    "",
    "    gridweights",
    "           Grid cell weights",
    "",
    "           Writes the grid cell area weights to the output stream.",
    "",
    "PARAMETERS",
    "",
    "    radius (FLOAT)",
    "           Planet radius in meter",
    "",
    "ENVIRONMENT",
    "",
    "    PLANET_RADIUS",
    "           This variable is used to scale the computed grid cell areas to square meters.  By default",
    "           PLANET_RADIUS is set to an earth radius of 6371000 meter.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp HealpixHelp = {
    "NAME",
    "    hpdegrade, hpupgrade - Change healpix resolution",
    "",
    "SYNOPSIS",
    "    cdo [options]  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    Degrade or upgrade the resolution of a healpix grid.",
    "",
    "OPERATORS",
    "",
    "    hpdegrade",
    "           Degrade healpix",
    "",
    "           Degrade the resolution of a healpix grid. The value of the target pixel is the mean of the",
    "           source pixels.",
    "",
    "    hpupgrade",
    "           Upgrade healpix",
    "",
    "           Upgrade the resolution of a healpix grid. The values of the target pixels are the value of",
    "           the source pixel.",
    "",
    "PARAMETERS",
    "",
    "    nside (INTEGER)",
    "           The nside of the target healpix, must be a power of two [default: same as input].",
    "",
    "    zoom (INTEGER)",
    "           zoom is the refinement level and the relation to nside is: nside=2^{zoom}.",
    "",
    "    order (STRING)",
    "           Pixel ordering of the target healpix (‘nested’ or ‘ring’).",
    "",
    "    power (FLOAT)",
    "           If non-zero, divide the result by (nside[in]/nside[out])**power. power=-2 keeps the sum of",
    "           the map invariant.",
    "",
    "OPTIONS",
    "    -p, --async_read true to read input data asynchronously.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp HistogramHelp = {
    "NAME",
    "    histcount, histsum, histmean, histfreq - Histogram",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,bounds  infile outfile",
    "",
    "DESCRIPTION",
    "    This module creates bins for a histogram of the input data.  The bins have to be adjacent and have",
    "    non-overlapping intervals.  The user has to define the bounds of the bins. The first value is the",
    "    lower bound and the second value the upper bound of the first bin. The bounds of the second bin",
    "    are defined by the second and third value, aso.  Only 2-dimensional input fields are allowed. The",
    "    output file contains one vertical level for each of the bins requested.",
    "",
    "OPERATORS",
    "",
    "    histcount",
    "           Histogram count",
    "",
    "           Number of elements in the bin range.",
    "",
    "    histsum",
    "           Histogram sum",
    "",
    "           Sum of elements in the bin range.",
    "",
    "    histmean",
    "           Histogram mean",
    "",
    "           Mean of elements in the bin range.",
    "",
    "    histfreq",
    "           Histogram frequency",
    "",
    "           Relative frequency of elements in the bin range.",
    "",
    "PARAMETERS",
    "",
    "    bounds (FLOAT)",
    "           Comma-separated list of the bin bounds (-inf and inf valid)",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp HourpctlHelp = {
    "NAME",
    "    hourpctl - Hourly percentile",
    "",
    "SYNOPSIS",
    "    cdo  hourpctl,pn  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same hour in infile1.  The algorithm",
    "    uses histograms with minimum and maximum bounds given in infile2 and infile3, respectively. The",
    "    default number of histogram bins is 101.  The default can be overridden by defining the",
    "    environment variable CDO_PCTL_NBINS.  The files infile2 and infile3 should be the result of",
    "    corresponding hourmin and hourmax operations, respectively.  The time of outfile is determined by",
    "    the time in the middle of all contributing timesteps of infile1.  This can be change with the CDO",
    "    option –timestat_date <first|middle|last>.",
    "",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "",
    "    o(t,x) = pth percentile {i(t’,x), t_1<=t’<=t_n}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "EXAMPLE",
    "    To compute the hourly 90th percentile of a time series use:",
    "",
    "       cdo hourmin infile minfile",
    "       cdo hourmax infile maxfile",
    "       cdo hourpctl,90 infile minfile maxfile outfile",
    "",
    "    Or shorter using operator piping:",
    "",
    "       cdo hourpctl,90 infile -hourmin infile -hourmax infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp HourstatHelp = {
    "NAME",
    "    hourmin, hourmax, hourrange, hoursum, hourmean, houravg, hourstd, hourstd1, hourvar, hourvar1 -",
    "    Hourly statistics",
    "",
    "SYNOPSIS",
    "    cdo [options]  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same hour.  Depending on the chosen",
    "    operator the minimum, maximum, range, sum, average, variance or standard deviation of timesteps of",
    "    the same hour is written to outfile.  The time of outfile is determined by the time in the middle",
    "    of all contributing timesteps of infile.  This can be change with the CDO option –timestat_date",
    "    <first|middle|last>.",
    "",
    "OPERATORS",
    "",
    "    hourmin",
    "           Hourly minimum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "",
    "           o(t,x) = min{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    hourmax",
    "           Hourly maximum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "",
    "           o(t,x) = max{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    hourrange",
    "           Hourly range",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "",
    "           o(t,x) = range{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    hoursum",
    "           Hourly sum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "",
    "           o(t,x) = sum{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    hourmean",
    "           Hourly mean",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "",
    "           o(t,x) = mean{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    houravg",
    "           Hourly average",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it is:",
    "",
    "           o(t,x) = avg{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    hourvar",
    "           Hourly variance",
    "",
    "           Normalize by n.  For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it",
    "           is:",
    "",
    "           o(t,x) = var{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    hourvar1",
    "           Hourly variance (n-1)",
    "",
    "           Normalize by (n-1).  For every adjacent sequence t_1, ...,t_n of timesteps of the same hour",
    "           it is:",
    "",
    "           o(t,x) = var1{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    hourstd",
    "           Hourly standard deviation",
    "",
    "           Normalize by n.  For every adjacent sequence t_1, ...,t_n of timesteps of the same hour it",
    "           is:",
    "",
    "           o(t,x) = std{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    hourstd1",
    "           Hourly standard deviation (n-1)",
    "",
    "           Normalize by (n-1).  For every adjacent sequence t_1, ...,t_n of timesteps of the same hour",
    "           it is:",
    "",
    "           o(t,x) = std1{i(t’,x), t_1<=t’<=t_n}",
    "",
    "OPTIONS",
    "    -S, --diagnostic to create a diagnostic output stream with the number of non missing values for",
    "    each output period.",
    "",
    "    -p, --async_read true to read input data asynchronously.",
    "",
    "EXAMPLE",
    "    To compute the hourly mean of a time series use:",
    "",
    "       cdo hourmean infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp HurrHelp = {
    "NAME",
    "    hurr - Hurricane days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  hurr  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum horizontal wind speed VX, then the number of days",
    "    where VX is greater than or equal to 32.5 m/s is counted. A further output variable is the maximum",
    "    number of consecutive days with maximum wind speed greater than or equal to 32.5 m/s. Note that VX",
    "    is defined as the square root of the sum of squares of the zonal and meridional wind speeds and",
    "    have to be given in units of m/s.  The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile.",
    "",
};

const CdoHelp ImportbinaryHelp = {
    "NAME",
    "    import_binary - Import binary data sets",
    "",
    "SYNOPSIS",
    "    cdo  import_binary  infile.ctl outfile",
    "",
    "DESCRIPTION",
    "    This operator imports gridded binary data sets via a GrADS data descriptor file.  The GrADS data",
    "    descriptor file contains a complete description of the binary data as well as instructions on",
    "    where to find the data and how to read it. The descriptor file is an ASCII file that can be",
    "    created easily with a text editor. The general contents of a gridded data descriptor file are as",
    "    follows:",
    "",
    "    • Filename for the binary data",
    "",
    "    • Missing or undefined data value",
    "",
    "    • Mapping between grid coordinates and world coordinates",
    "",
    "    • Description of variables in the binary data set",
    "",
    "    A detailed description of the components of a GrADS data descriptor file can be found in [GrADS].",
    "    Here is a list of the supported components: BYTESWAPPED, CHSUB, DSET, ENDVARS, FILEHEADER,",
    "    HEADERBYTES, OPTIONS, TDEF, TITLE, TRAILERBYTES, UNDEF, VARS, XDEF, XYHEADER, YDEF, ZDEF",
    "",
    "NOTE",
    "    Only 32-bit IEEE floats are supported for standard binary files!",
    "",
    "EXAMPLE",
    "    To convert a binary data file to NetCDF use:",
    "",
    "       cdo -f nc import_binary infile.ctl outfile.nc",
    "",
    "    Here is an example of a GrADS data descriptor file:",
    "",
    "       DSET  ^infile.bin",
    "       OPTIONS sequential",
    "       UNDEF  -9e+33",
    "       XDEF 360 LINEAR -179.5 1",
    "       YDEF 180 LINEAR  -89.5 1",
    "       ZDEF   1 LINEAR 1 1",
    "       TDEF   1 LINEAR 00:00Z15jun1989 12hr",
    "       VARS   1",
    "       param  1  99  description of the variable",
    "       ENDVARS",
    "",
    "    The binary data file infile.bin contains one parameter on a global 1 degree lon/lat grid written",
    "    with FORTRAN record length headers (sequential).",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ImportcmsafHelp = {
    "NAME",
    "    import_cmsaf - Import CM-SAF HDF5 files",
    "",
    "SYNOPSIS",
    "    cdo  import_cmsaf  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator imports gridded CM-SAF (Satellite Application Facility on Climate Monitoring) HDF5",
    "    files. CM-SAF exploits data from polar-orbiting and geostationary satellites in order to provide",
    "    climate monitoring products of the following parameters:",
    "",
    "    Cloud parameters:",
    "       cloud fraction (CFC), cloud type (CTY), cloud phase (CPH), cloud top height, pressure and",
    "       temperature (CTH,CTP,CTT), cloud optical thickness (COT), cloud water path (CWP).",
    "",
    "    Surface radiation components:",
    "       Surface albedo (SAL); surface incoming (SIS) and net (SNS) shortwave radiation; surface",
    "       downward (SDL) and outgoing (SOL) longwave radiation, surface net longwave radiation (SNL) and",
    "       surface radiation budget (SRB).",
    "",
    "    Top-of-atmosphere radiation components:",
    "       Incoming (TIS) and reflected (TRS) solar radiative flux at top-of-atmosphere. Emitted thermal",
    "       radiative flux at top-of-atmosphere (TET).",
    "",
    "    Water vapour:",
    "       Vertically integrated water vapour (HTW), layered vertically integrated water vapour and layer",
    "       mean temperature and relative humidity for 5 layers (HLW), temperature and mixing ratio at 6",
    "       pressure levels.",
    "",
    "    Daily and monthly mean products can be ordered via the CM-SAF web page (www.cmsaf.eu).  Products",
    "    with higher spatial and temporal resolution, i.e. instantaneous swath-based products, are",
    "    available on request (contact.cmsaf@dwd.de). All products are distributed free-of-charge.  More",
    "    information on the data is available on the CM-SAF homepage (www.cmsaf.eu).",
    "",
    "    Daily and monthly mean products are provided in equal-area projections. CDO reads the projection",
    "    parameters from the metadata in the HDF5-headers in order to allow spatial operations like",
    "    remapping. For spatial operations with instantaneous products on original satellite projection,",
    "    additional files with arrays of latitudes and longitudes are needed.  These can be obtained from",
    "    CM-SAF together with the data.",
    "",
    "NOTE",
    "    To use this operator, it is necessary to build CDO with [HDF5] support (version 1.6 or higher).",
    "    The [PROJ] library (version 5.0 or higher) is needed for full support of the remapping",
    "    functionality.",
    "",
    "EXAMPLE",
    "    A typical sequence of commands with this operator could look like this:",
    "",
    "       cdo -f nc remapbil,r360x180 -import_cmsaf cmsaf_product.hdf output.nc",
    "",
    "    (bilinear remapping to a predefined global grid with 1 deg resolution and conversion to NetCDF).",
    "",
    "    If you work with CM-SAF data on original satellite project, an additional file with information on",
    "    geolocation is required, to perform such spatial operations:",
    "",
    "       cdo -f nc remapbil,r720x360 -setgrid,cmsaf_latlon.h5 -import_cmsaf cmsaf.hdf out.nc",
    "",
    "    Some CM-SAF data are stored as scaled integer values. For some operations, it could be desirable",
    "    (or necessary) to increase the accuracy of the converted products:",
    "",
    "       cdo -b f32 -f nc fldmean -sellonlatbox,0,10,0,10 -remapbil,r720x360 \\",
    "                       -import_cmsaf cmsaf_product.hdf output.nc",
    "",
    "AUTHOR",
    "    Uwe Schulzweida, Frank Kaspar",
    "",
};

const CdoHelp InfoHelp = {
    "NAME",
    "    info, infon, cinfo, map - Information and simple statistics",
    "",
    "SYNOPSIS",
    "    cdo [options]  <operator>  infiles",
    "",
    "DESCRIPTION",
    "    This module writes information about the structure and contents for each field of all input files",
    "    to standard output. A field is a horizontal layer of a data variable. All input files need to have",
    "    the same structure with the same variables on different timesteps.  The information displayed",
    "    depends on the chosen operator.",
    "",
    "OPERATORS",
    "",
    "    info   Dataset information listed by identifier",
    "",
    "           Prints information and simple statistics for each field of all input datasets.  For each",
    "           field the operator prints one line with the following elements:",
    "",
    "           • Date and Time",
    "",
    "           • Level, Gridsize and number of Missing values",
    "",
    "           •",
    "             Minimum, Mean and Maximum",
    "             The mean value is computed without the use of area weights!",
    "",
    "",
    "           • Parameter identifier",
    "",
    "    infon  Dataset information listed by name",
    "",
    "           The same as operator info but using the parameter name instead of the identifier to label",
    "           the parameter.",
    "",
    "    cinfo  Compact information listed by name",
    "",
    "           cinfo is a compact version of infon.  It prints the minimum, mean and maximum value for",
    "           each variable across all layers and time steps.",
    "",
    "    map    Dataset information and simple map",
    "",
    "           Prints information, simple statistics and a map for each field of all input datasets. The",
    "           map will be printed only for fields on a regular lon/lat grid.",
    "",
    "OPTIONS",
    "    -p, --async_read true to read input data asynchronously.",
    "",
    "EXAMPLE",
    "    To print information and simple statistics for each field of a dataset use:",
    "",
    "       cdo [options] infon infile",
    "",
    "    This is an example result of a dataset with one 2D parameter over 12 timesteps:",
    "",
    "       -1 :       Date     Time Level  Size  Miss : Minimum    Mean Maximum : Name",
    "        1 : 1987-01-31 12:00:00     0  2048  1361 :  232.77  266.65  305.31 : SST",
    "        2 : 1987-02-28 12:00:00     0  2048  1361 :  233.64  267.11  307.15 : SST",
    "        3 : 1987-03-31 12:00:00     0  2048  1361 :  225.31  267.52  307.67 : SST",
    "        4 : 1987-04-30 12:00:00     0  2048  1361 :  215.68  268.65  310.47 : SST",
    "        5 : 1987-05-31 12:00:00     0  2048  1361 :  215.78  271.53  312.49 : SST",
    "        6 : 1987-06-30 12:00:00     0  2048  1361 :  212.89  272.80  314.18 : SST",
    "        7 : 1987-07-31 12:00:00     0  2048  1361 :  209.52  274.29  316.34 : SST",
    "        8 : 1987-08-31 12:00:00     0  2048  1361 :  210.48  274.41  315.83 : SST",
    "        9 : 1987-09-30 12:00:00     0  2048  1361 :  210.48  272.37  312.86 : SST",
    "       10 : 1987-10-31 12:00:00     0  2048  1361 :  219.46  270.53  309.51 : SST",
    "       11 : 1987-11-30 12:00:00     0  2048  1361 :  230.98  269.85  308.61 : SST",
    "       12 : 1987-12-31 12:00:00     0  2048  1361 :  241.25  269.94  309.27 : SST",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp InputHelp = {
    "NAME",
    "    input, inputsrv, inputext - Formatted input",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  outfile",
    "",
    "    cdo  input,grid[,zaxis]  outfile",
    "",
    "DESCRIPTION",
    "    This module reads time series of one 2D variable from standard input.  All input fields need to",
    "    have the same horizontal grid.  The format of the input depends on the chosen operator.",
    "",
    "OPERATORS",
    "",
    "    input  ASCII input",
    "",
    "           Reads fields with ASCII numbers from standard input and stores them in outfile.  The",
    "           numbers read are exactly that ones which are written out by the output operator.",
    "",
    "    inputsrv",
    "           SERVICE ASCII input",
    "",
    "           Reads fields with ASCII numbers from standard input and stores them in outfile.  Each field",
    "           should have a header of 8 integers (SERVICE likely).  The numbers that are read are exactly",
    "           that ones which are written out by the outputsrv operator.",
    "",
    "    inputext",
    "           EXTRA ASCII input",
    "",
    "           Read fields with ASCII numbers from standard input and stores them in outfile.  Each field",
    "           should have header of 4 integers (EXTRA likely).  The numbers read are exactly that ones",
    "           which are written out by the outputext operator.",
    "",
    "PARAMETERS",
    "",
    "    grid (STRING)",
    "           Grid description file or name",
    "",
    "    **",
    "           zaxis: STRING Z-axis description file",
    "",
    "EXAMPLE",
    "    Assume an ASCII dataset contains a field on a global regular grid with 32 longitudes and 16",
    "    latitudes (512 elements). To create a GRIB1 dataset from the ASCII dataset use:",
    "       cdo -f grb input,r32x16 outfile.grb < my_ascii_data",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp IntlevelHelp = {
    "NAME",
    "    intlevel - Linear level interpolation",
    "",
    "SYNOPSIS",
    "    cdo  intlevel,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator performs a linear vertical interpolation of 3D variables. The 1D target levels can",
    "    be specified with the level parameter or read in via a Z-axis description file.",
    "",
    "PARAMETERS",
    "",
    "    level (FLOAT)",
    "           Comma-separated list of target levels",
    "",
    "    zdescription (STRING)",
    "           Path to a file containing a description of the Z-axis",
    "",
    "    zvarname (STRING)",
    "           Use zvarname as the vertical 3D source coordinate instead of the 1D coordinate variable",
    "",
    "    extrapolate (BOOL)",
    "           Fill target layers out of the source layer range with the nearest source layer",
    "",
    "EXAMPLE",
    "    To interpolate 3D variables on height levels to a new set of height levels use:",
    "",
    "       cdo intlevel,level=10,50,100,500,1000 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp Intlevel3dHelp = {
    "NAME",
    "    intlevel3d - Linear level interpolation from/to 3D vertical coordinates",
    "",
    "SYNOPSIS",
    "    cdo  intlevel3d,tgtcoordinate  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This operator performs a linear vertical interpolation of 3D variables fields with given 3D",
    "    vertical coordinates.  infile1 contains the 3D data variables and infile2 the 3D vertical source",
    "    coordinate. The parameter tgtcoordinate is a datafile with the 3D vertical target coordinate.  Use",
    "    the alias intlevel3dx to fill in missing values with the next available value of the same vertical",
    "    column.",
    "",
    "PARAMETERS",
    "",
    "    tgtcoordinate (STRING)",
    "           filename for 3D vertical target coordinates",
    "",
    "EXAMPLE",
    "    To interpolate 3D variables from one set of 3D height levels into another one where",
    "",
    "    • infile2 contains a single 3D variable, which represents the source 3D vertical coordinate",
    "",
    "    • infile1 contains the source data, which the vertical coordinate from infile2 belongs to",
    "",
    "    • tgtcoordinate only contains the target 3D height levels",
    "",
    "       cdo intlevel3d,tgtcoordinate infile1 infile2 outfile",
    "",
    "AUTHOR",
    "    Ralf Müller",
    "",
};

const CdoHelp InttimeHelp = {
    "NAME",
    "    inttime, intntime - Time interpolation",
    "",
    "SYNOPSIS",
    "    cdo  inttime,date,time[,inc]  infile outfile",
    "",
    "    cdo  intntime,n  infile outfile",
    "",
    "DESCRIPTION",
    "    This module performs linear interpolation between timesteps.  Interpolation is only performed if",
    "    both values exist.  If both values are missing values, the result is also a missing value.  If",
    "    only one value exists, it is taken if the time weighting is greater than or equal to 0.5.  So no",
    "    new value will be created at existing time steps, if the value is missing there.",
    "",
    "OPERATORS",
    "",
    "    inttime",
    "           Interpolation between timesteps",
    "",
    "           This operator creates a new dataset by linear interpolation between timesteps.  The user",
    "           has to define the start date/time with an optional increment.",
    "",
    "    intntime",
    "           Interpolation between timesteps",
    "",
    "           This operator performs linear interpolation between timesteps.  The user has to define the",
    "           number of timesteps from one timestep to the next.",
    "",
    "PARAMETERS",
    "",
    "    date (STRING)",
    "           Start date (format YYYY-MM-DD)",
    "",
    "    time (STRING)",
    "           Start time (format hh:mm:ss)",
    "",
    "    inc (STRING)",
    "           Optional increment (seconds, minutes, hours, days, months, years) [default: 0hour]",
    "",
    "    n (INTEGER)",
    "           Number of timesteps from one timestep to the next",
    "",
    "EXAMPLE",
    "    Assumed a 6 hourly dataset starts at 1987-01-01 12:00:00.  To interpolate this time series to a",
    "    one hourly dataset use:",
    "",
    "       cdo inttime,1987-01-01,12:00:00,1hour infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp IntyearHelp = {
    "NAME",
    "    intyear - Interpolation between two years",
    "",
    "SYNOPSIS",
    "    cdo  intntime,years  infile1 infile2 obase",
    "",
    "DESCRIPTION",
    "    This operator performs linear interpolation between two years, timestep by timestep.  The input",
    "    files need to have the same structure with the same variables.  The output files will be named",
    "    <obase><yyyy><suffix> where yyyy will be the year and suffix is the filename extension derived",
    "    from the file format.",
    "",
    "PARAMETERS",
    "",
    "    years (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of years",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX sets the filename suffix.",
    "",
    "NOTE",
    "    This operator needs to open all output files simultaneously.  The maximum number of open files",
    "    depends on the operating system!",
    "",
    "EXAMPLE",
    "    Assume there are two monthly mean datasets over a year. The first dataset has 12 timesteps for the",
    "    year 1985 and the second one for the year 1990.  To interpolate the years between 1985 and 1990",
    "    month by month use:",
    "",
    "       cdo intyear,1986,1987,1988,1989 infile1 infile2 year",
    "",
    "    Example result of ‘dir year*’ for NetCDF datasets:",
    "",
    "       year1986.nc year1987.nc year1988.nc year1989.nc",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp InvertHelp = {
    "NAME",
    "    invertlat - Invert latitudes",
    "",
    "SYNOPSIS",
    "    cdo  invertlat  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator inverts the latitudes of all fields on a rectilinear grid.",
    "",
    "EXAMPLE",
    "    To invert the latitudes of a 2D field from N->S to S->N use:",
    "",
    "       cdo invertlat infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp InvertlevHelp = {
    "NAME",
    "    invertlev - Invert levels",
    "",
    "SYNOPSIS",
    "    cdo  invertlev  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator inverts the levels of all 3D variables.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp MaggraphHelp = {
    "NAME",
    "    graph - Line graph plot",
    "",
    "SYNOPSIS",
    "    cdo  graph,parameter  infiles obase",
    "",
    "DESCRIPTION",
    "    This operator generates line graph plots.  The data for the plot is read from infiles. The result",
    "    is written to outfile.  The default output file format is postscript, this can be changed with the",
    "    device parameter.",
    "",
    "    Here is a list of all graph plot parameters:",
    "",
    "                            ┌──────────┬────────┬────────────────────────────┐",
    "                            │Keyname   │ Type   │ Description                │",
    "                            ├──────────┼────────┼────────────────────────────┤",
    "                            │device    │ STRING │ Output device (ps, eps,    │",
    "                            │          │        │ pdf, png, gif,             │",
    "                            │          │        │ gif_animation, jpeg, svg,  │",
    "                            │          │        │ kml)                       │",
    "                            ├──────────┼────────┼────────────────────────────┤",
    "                            │ymin      │ FLOAT  │ Minimum value of the       │",
    "                            │          │        │ y-axis data                │",
    "                            ├──────────┼────────┼────────────────────────────┤",
    "                            │ymax      │ FLOAT  │ Maximum value of the       │",
    "                            │          │        │ y-axis data                │",
    "                            ├──────────┼────────┼────────────────────────────┤",
    "                            │linewidth │ INT    │ Line width (default 8)     │",
    "                            ├──────────┼────────┼────────────────────────────┤",
    "                            │stat      │ STRING │ “TRUE” or “FALSE”, to      │",
    "                            │          │        │ switch on the mean         │",
    "                            │          │        │ computation. Default is    │",
    "                            │          │        │ “FALSE”. Will be           │",
    "                            │          │        │ overridden to “FALSE”, if  │",
    "                            │          │        │ input files have unequal   │",
    "                            │          │        │ number of time steps or    │",
    "                            │          │        │ different start/end times. │",
    "                            ├──────────┼────────┼────────────────────────────┤",
    "                            │sigma     │ FLOAT  │ Standard deviation value   │",
    "                            │          │        │ for generating shaded back │",
    "                            │          │        │ ground around the mean     │",
    "                            │          │        │ value. To be used in       │",
    "                            │          │        │ conjunction with           │",
    "                            │          │        │ ‘stat=”TRUE”’              │",
    "                            ├──────────┼────────┼────────────────────────────┤",
    "                            │obsv      │ STRING │ To indicate if the input   │",
    "                            │          │        │ files have an observation  │",
    "                            │          │        │ data, by setting to        │",
    "                            │          │        │ “TRUE”. Default value is   │",
    "                            │          │        │ “FALSE”. The observation   │",
    "                            │          │        │ data should be the first   │",
    "                            │          │        │ file in the input file     │",
    "                            │          │        │ list. The observation data │",
    "                            │          │        │ is always plotted in black │",
    "                            │          │        │ colour.                    │",
    "                            └──────────┴────────┴────────────────────────────┘",
    "PARAMETERS",
    "",
    "    parameter STRING",
    "           Comma-separated list of plot parameters",
    "",
    "EXAMPLE",
    "    Graph plot of an atlantic MOC time series from 1965 to 1976:",
    "",
    "       cdo graph amoc plot",
    "",
    "AUTHOR",
    "    Kameswarrao Modali",
    "",
};

const CdoHelp MagplotHelp = {
    "NAME",
    "    contour, shaded, grfill - Lon/Lat plot",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameter  infile obase",
    "",
    "DESCRIPTION",
    "    The operators in this module generates 2D Lon/Lat plots.  The data for the plot is read from",
    "    infile.  Only data on rectilinear Lon/Lat grids are supported.  The output file will be named",
    "    <obase>_<param>.<device> where param is the parameter name and device is the device name. The",
    "    default output file format is postscript, this can be changed with the device parameter.  The type",
    "    of the plot depends on the choosen operator.",
    "",
    "    Here is a list of all common plot parameters:",
    "",
    "                           ┌───────────┬─────────┬────────────────────────────┐",
    "                           │Keyname    │ Type    │ Description                │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │device     │ STRING  │ Output device (ps, eps,    │",
    "                           │           │         │ pdf, png, gif,             │",
    "                           │           │         │ gif_animation, jpeg, svg,  │",
    "                           │           │         │ kml)                       │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │projection │ STRING  │ Projection (cylindrical,   │",
    "                           │           │         │ polar_stereographic,       │",
    "                           │           │         │ robinson, mercator)        │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │style      │ STRING  │ Contour line style (solid, │",
    "                           │           │         │ dash, dot, chain_dash,     │",
    "                           │           │         │ chain_dot)                 │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │min        │ FLOAT   │ Minimum value              │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │max        │ FLOAT   │ Maximum value              │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │lon_max    │ FLOAT   │ Maximum longitude of the   │",
    "                           │           │         │ image                      │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │lon_min    │ FLOAT   │ Minimum longitude of the   │",
    "                           │           │         │ image                      │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │lat_max    │ FLOAT   │ Maximum latitude of the    │",
    "                           │           │         │ image                      │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │lat_min    │ FLOAT   │ Minimum latitude of the    │",
    "                           │           │         │ image                      │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │count      │ INTEGER │ Number of Contour levels / │",
    "                           │           │         │ Colour bands               │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │interval   │ FLOAT   │ Interval in data units     │",
    "                           │           │         │ between two bands lines    │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │list       │ INTEGER │ List of levels to be       │",
    "                           │           │         │ plotted                    │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │RGB        │ STRING  │ TRUE or FALSE, to          │",
    "                           │           │         │ indicate, if the input     │",
    "                           │           │         │ colour is in RGB format    │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │step_freq  │ INTEGER │ Frequency of time steps to │",
    "                           │           │         │ be considered for making   │",
    "                           │           │         │ the animation              │",
    "                           │           │         │ (device=gif_animation).    │",
    "                           │           │         │ Default value is “1” (all  │",
    "                           │           │         │ time steps). Will be       │",
    "                           │           │         │ ignored if input file has  │",
    "                           │           │         │ multiple variables.        │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │file_split │ STRING  │ TRUE or FALSE, to split    │",
    "                           │           │         │ the output file for each   │",
    "                           │           │         │ variable, if input has     │",
    "                           │           │         │ multiple variables.        │",
    "                           │           │         │ Default value is “FALSE”.  │",
    "                           │           │         │ Valid only for “PS”        │",
    "                           │           │         │ format.                    │",
    "                           └───────────┴─────────┴────────────────────────────┘",
    "OPERATORS",
    "",
    "    contour",
    "           Contour plot",
    "",
    "           The operator contour generates the discrete contour lines of the input field values.  The",
    "           following additional parameters are valid for contour operator, module in addition to the",
    "           common plot parameters:",
    "",
    "                                ┌──────────┬────────┬────────────────────────────┐",
    "                                │Keyname   │ Type   │ Description                │",
    "                                ├──────────┼────────┼────────────────────────────┤",
    "                                │colour    │ STRING │ Colour for drawing the     │",
    "                                │          │        │ contours                   │",
    "                                ├──────────┼────────┼────────────────────────────┤",
    "                                │thickness │ FLOAT  │ Thickness of the contour   │",
    "                                │          │        │ line                       │",
    "                                ├──────────┼────────┼────────────────────────────┤",
    "                                │style     │ STRING │ Line Style can be “SOLID”, │",
    "                                │          │        │ “DASH”, “DOT”,             │",
    "                                │          │        │ “CHAIN_DASH”, “CHAIN_DOT”  │",
    "                                └──────────┴────────┴────────────────────────────┘",
    "    shaded Shaded contour plot",
    "",
    "           The operator shaded generates the filled contours of the given input field values.  The",
    "           following additional parameters are valid for shaded contour and gridfill operator, in",
    "           addition to the common plot parameters.",
    "",
    "                              ┌─────────────┬────────┬────────────────────────────┐",
    "                              │Keyname      │ Type   │ Description                │",
    "                              ├─────────────┼────────┼────────────────────────────┤",
    "                              │colour_min   │ STRING │ Colour for the Minimum     │",
    "                              │             │        │ colour band                │",
    "                              ├─────────────┼────────┼────────────────────────────┤",
    "                              │colour_max   │ STRING │ Colour for the Minimum     │",
    "                              │             │        │ colour band                │",
    "                              ├─────────────┼────────┼────────────────────────────┤",
    "                              │colour_triad │ STRING │ Direction of colour        │",
    "                              │             │        │ sequencing for shading     │",
    "                              │             │        │ “CW” or “ACW”, to denote   │",
    "                              │             │        │ “clockwise” and            │",
    "                              │             │        │ “anticlockwise”            │",
    "                              │             │        │ respectively. To be used   │",
    "                              │             │        │ in conjunction with        │",
    "                              │             │        │ “colour_min”, “colour_max” │",
    "                              │             │        │ options. Default is “ACW”  │",
    "                              ├─────────────┼────────┼────────────────────────────┤",
    "                              │colour_table │ STRING │ File with user specified   │",
    "                              │             │        │ colours with the format as │",
    "                              └─────────────┴────────┴────────────────────────────┘",
    "           Example file for 6 colours in RGB format:",
    "",
    "              6",
    "              RGB(0.0;0.0;1.0)",
    "              RGB(0.0;0.0;0.5)",
    "              RGB(0.0;0.5;0.5)",
    "              RGB(0.0;1.0;0.0)",
    "              RGB(0.5;0.5;0.0)",
    "              RGB(1.0;0.0;0.0)",
    "",
    "    grfill Shaded gridfill plot",
    "",
    "           The operator grfill is similar to satellite imaging and shades each cell (pixel) according",
    "           to the value of the field at that cell.",
    "",
    "PARAMETERS",
    "",
    "    parameter STRING",
    "           Comma-separated list of plot parameters",
    "",
    "NOTE",
    "    All colour parameter can be either standard name or in RGB format.  The valid standard name",
    "    strings for “colour” are:",
    "",
    "    “red”, “green”, “blue”, “yellow”, “cyan”, “magenta”, “black”, “avocado”, “beige”, “brick”,",
    "    “brown”, “burgundy”, “charcoal”, “chestnut”, “coral”, “cream”, “evergreen”, “gold”, “grey”,",
    "    “khaki”, “kellygreen”, “lavender”, “mustard”, “navy”, “ochre”, “olive”, “peach”, “pink”, “rose”,",
    "    “rust”, “sky”, “tan”, “tangerine”, “turquoise”, “violet”, “reddishpurple”, “purplered”,",
    "    “purplishred”, “orangishred”, “redorange”, “reddishorange”, “orange”, “yellowishorange”,",
    "    “orangeyellow”, “orangishyellow”, “greenishyellow”, “yellowgreen”, “yellowishgreen”,",
    "    “bluishgreen”, “bluegreen”, “greenishblue”, “purplishblue”, “bluepurple”, “bluishpurple”,",
    "    “purple”, “white”",
    "",
    "EXAMPLE",
    "",
    "    1. Shaded contour plot of a global temperature field with a resolution of 4 degree.  The contour",
    "       interval is 3 with a rainbow color table.",
    "",
    "          cdo shaded,interval=3,colour_min=violet,colour_max=red,colour_triad=cw temp plot",
    "",
    "    2. Shaded gridfill plot of a global temperature field with a resolution of 4 degree.  The contour",
    "       interval is 3 with a rainbow color table.",
    "",
    "          cdo grfill,interval=3,colour_min=violet,colour_max=red,colour_triad=cw temp plot",
    "",
    "AUTHOR",
    "    Kameswarrao Modali",
    "",
};

const CdoHelp MagvectorHelp = {
    "NAME",
    "    vector - Lon/Lat vector plot",
    "",
    "SYNOPSIS",
    "    cdo  vector,parameter  infile obase",
    "",
    "DESCRIPTION",
    "    This operator generates 2D Lon/Lat vector plots.  The data for the plot is read from infile. The",
    "    input is expected to contain two velocity components. Only data on rectilinear Lon/Lat grids are",
    "    supported.  The output file will be named <obase>.<device> where device is the device name.  The",
    "    default output file format is postscript, this can be changed with the device parameter.",
    "",
    "    Here is a list of all vector plot parameters:",
    "",
    "                           ┌───────────┬─────────┬────────────────────────────┐",
    "                           │Keyname    │ Type    │ Description                │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │device     │ STRING  │ Output device (ps, eps,    │",
    "                           │           │         │ pdf, png, gif,             │",
    "                           │           │         │ gif_animation, jpeg, svg,  │",
    "                           │           │         │ kml)                       │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │projection │ STRING  │ Projection (cylindrical,   │",
    "                           │           │         │ polar_stereographic,       │",
    "                           │           │         │ robinson, mercator)        │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │thin_fac   │ FLOAT   │ Controls the actual number │",
    "                           │           │         │ of wind arrows or flags    │",
    "                           │           │         │ plotted (default 2).       │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │unit_vec   │ FLOAT   │ Wind speed in m/s          │",
    "                           │           │         │ represented by a unit      │",
    "                           │           │         │ vector (1.0cm)             │",
    "                           ├───────────┼─────────┼────────────────────────────┤",
    "                           │step_freq  │ INTEGER │ Frequency of time steps to │",
    "                           │           │         │ be considered for making   │",
    "                           │           │         │ the animation              │",
    "                           │           │         │ (device=gif_animation).    │",
    "                           │           │         │ Default value is “1” (all  │",
    "                           │           │         │ time steps). Will be       │",
    "                           │           │         │ ignored if input file has  │",
    "                           │           │         │ multiple variables.        │",
    "                           └───────────┴─────────┴────────────────────────────┘",
    "PARAMETERS",
    "",
    "    parameter STRING",
    "           Comma-separated list of plot parameters",
    "",
    "EXAMPLE",
    "    Vector plot of global wind vectors with a resolution of 5 degree.  The unit vector is set to 70",
    "    and all wind arrows are plotted.",
    "",
    "       cdo vector,thin_fac=1,unit_vec=70 uvdata plot",
    "",
    "AUTHOR",
    "    Kameswarrao Modali",
    "",
};

const CdoHelp MapreduceHelp = {
    "NAME",
    "    reducegrid - Reduce fields to user-defined mask",
    "",
    "SYNOPSIS",
    "    cdo  reducegrid,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module holds an operator for data reduction based on a user defined mask.  The output grid is",
    "    unstructured and includes coordinate bounds. Bounds can be avoided by using the additional",
    "    ‘nobounds’ keyword. With ‘nocoords’ given, coordinates a completely suppressed.",
    "",
    "OPERATORS",
    "",
    "    reducegrid",
    "           Reduce fields to user-defined mask",
    "",
    "           Reduce input file variables to locations, where mask is non-zero.  Horizontal grids of mask",
    "           and infile must be identical.",
    "",
    "PARAMETERS",
    "",
    "    mask (STRING)",
    "           file which holds the mask field",
    "",
    "    limitCoordsOutput (STRING)",
    "           optional parameter to limit coordinates output: ‘nobounds’ disables coordinate bounds,",
    "           ‘nocoords’ avoids all coordinate information",
    "",
    "EXAMPLE",
    "    To limit data fields to land values, a mask has to be created first with:",
    "",
    "       cdo -gtc,0 -topo,ni96 lsm_gme96.grb",
    "",
    "    Here a GME grid is used. Say temp_gme96.grb contains a global temperature field.  The following",
    "    command limits the global grid to landpoints:",
    "",
    "       cdo -f nc reducegrid,lsm_gme96.grb temp_gme96.grb tempOnLand_gme96.nc",
    "",
    "    Note that output file type is NetCDF, because unstructured grids cannot be stored in GRIB format.",
    "",
    "AUTHOR",
    "    Ralf Müller",
    "",
};

const CdoHelp MaskboxHelp = {
    "NAME",
    "    masklonlatbox, maskindexbox - Mask a box",
    "",
    "SYNOPSIS",
    "    cdo  masklonlatbox,lon1,lon2,lat1,lat2  infile outfile",
    "",
    "    cdo  maskindexbox,idx1,idx2,idy1,idy2  infile outfile",
    "",
    "DESCRIPTION",
    "    Masks grid cells inside a lon/lat or index box. The elements inside the box are untouched, the",
    "    elements outside are set to missing value. All input fields need to have the same horizontal grid.",
    "    Use sellonlatbox or selindexbox if only the data inside the box are needed.",
    "",
    "OPERATORS",
    "",
    "    masklonlatbox",
    "           Mask a longitude/latitude box",
    "",
    "           Masks grid cells inside a lon/lat box. The user must specify the longitude and latitude of",
    "           the edges of the box.  Only those grid cells are considered whose grid center lies within",
    "           the lon/lat box.  For rotated lon/lat grids the parameters must be specified in rotated",
    "           coordinates.",
    "",
    "    maskindexbox",
    "           Mask an index box",
    "",
    "           Masks grid cells within an index box. The user must specify the indices of the edges of the",
    "           box.  The index of the left edge can be greater then the one of the right edge. Use",
    "           negative indexing to start from the end. The input grid must be a regular lon/lat or a 2D",
    "           curvilinear grid.",
    "",
    "PARAMETERS",
    "",
    "    lon1 (FLOAT)",
    "           Western longitude in degrees",
    "",
    "    lon2 (FLOAT)",
    "           Eastern longitude in degrees",
    "",
    "    lat1 (FLOAT)",
    "           Southern or northern latitude in degrees",
    "",
    "    lat2 (FLOAT)",
    "           Northern or southern latitude in degrees",
    "",
    "    idx1 (INTEGER)",
    "           Index of first longitude (1 - nlon)",
    "",
    "    idx2 (INTEGER)",
    "           Index of last longitude (1 - nlon)",
    "",
    "    idy1 (INTEGER)",
    "           Index of first latitude (1 - nlat)",
    "",
    "    idy2 (INTEGER)",
    "           Index of last latitude (1 - nlat)",
    "",
    "EXAMPLE",
    "    To mask the region with the longitudes from 120E to 90W and latitudes from 20N to 20S on all input",
    "    fields use:",
    "",
    "       cdo masklonlatbox,120,-90,20,-20 infile outfile",
    "",
    "    If the input dataset has fields on a regular Gaussian F16 grid, the same box can be masked with",
    "    maskindexbox by:",
    "",
    "       cdo maskindexbox,23,48,13,20 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp MaskregionHelp = {
    "NAME",
    "    maskregion - Mask regions",
    "",
    "SYNOPSIS",
    "    cdo  maskregion,regions  infile outfile",
    "",
    "DESCRIPTION",
    "    Masks different regions of the input fields.  The grid cells inside a region are untouched, the",
    "    cells outside are set to missing value.  Considered are only those grid cells with the grid center",
    "    inside the regions.  All input fields must have the same horizontal grid.",
    "",
    "    Regions can be defined by the user via an ASCII file.  Each region consists of the geographic",
    "    coordinates of a polygon.  Each line of a polygon description file contains the longitude and",
    "    latitude of one point.  Each polygon description file can contain one or more polygons separated",
    "    by a line with the character &.",
    "",
    "    Predefined regions of countries can be specified via the country codes.  A country is specified",
    "    with dcw:<CountryCode>. Country codes can be combined with the plus sign.",
    "",
    "PARAMETERS",
    "",
    "    regions (STRING)",
    "           Comma-separated list of ASCII formatted files with different regions",
    "",
    "EXAMPLE",
    "    To mask the region with the longitudes from 120E to 90W and latitudes from 20N to 20S on all input",
    "    fields use:",
    "",
    "       cdo maskregion,myregion infile outfile",
    "",
    "    For this example the description file of the region myregion should contain one polygon with the",
    "    following four coordinates:",
    "",
    "       120  20",
    "       120 -20",
    "       270 -20",
    "       270  20",
    "",
    "    To mask the region of a country use the country code with data from the Digital Chart of the",
    "    World.  Here is an example for Spain with the country code ES:",
    "",
    "       cdo maskregion,dcw:ES infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida, Cedrick Ansorge",
    "",
};

const CdoHelp MastrfuHelp = {
    "NAME",
    "    mastrfu - Mass stream function",
    "",
    "SYNOPSIS",
    "    cdo  mastrfu  infile outfile",
    "",
    "DESCRIPTION",
    "    This is a special operator for the post processing of the atmospheric general circulation model",
    "    [ECHAM]. It computes the mass stream function (code=272). The input dataset have to be a zonal",
    "    mean of v-velocity [m/s] (code=132) on pressure levels.",
    "",
    "EXAMPLE",
    "    To compute the mass stream function from a zonal mean v-velocity dataset use:",
    "",
    "       cdo mastrfu infile outfile",
    "",
};

const CdoHelp MathHelp = {
    "NAME",
    "    abs, int, nint, pow, sqr, sqrt, exp, ln, log10, sin, cos, tan, asin, acos, atan, reci, not -",
    "    Mathematical functions",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains some standard mathematical functions.  All trigonometric functions calculate",
    "    with radians.",
    "",
    "OPERATORS",
    "",
    "    abs    Absolute value",
    "",
    "           o(t,x) = abs(i(t,x))",
    "",
    "    int    Integer value",
    "",
    "           o(t,x) = int(i(t,x))",
    "",
    "    nint   Nearest integer value",
    "",
    "           o(t,x) = nint(i(t,x))",
    "",
    "    pow    Power",
    "",
    "           o(t,x) = i(t,x)^y",
    "",
    "    sqr    Square",
    "",
    "           o(t,x) = i(t,x)^2",
    "",
    "    sqrt   Square root",
    "",
    "           o(t,x) = sqrt(i(t,x))",
    "",
    "    exp    Exponential",
    "",
    "           o(t,x) = e^i(t,x)",
    "",
    "    ln     Natural logarithm",
    "",
    "           o(t,x) = ln(i(t,x))",
    "",
    "    log10  Base 10 logarithm",
    "",
    "           o(t,x) = log10(i(t,x))",
    "",
    "    sin    Sine",
    "",
    "           o(t,x) = sin(i(t,x))",
    "",
    "    cos    Cosine",
    "",
    "           o(t,x) = cos(i(t,x))",
    "",
    "    tan    Tangent",
    "",
    "           o(t,x) = tan(i(t,x))",
    "",
    "    asin   Arc sine",
    "",
    "           o(t,x) = asin(i(t,x))",
    "",
    "    acos   Arc cosine",
    "",
    "           o(t,x) = acos(i(t,x))",
    "",
    "    atan   Arc tangent",
    "",
    "           o(t,x) = atan(i(t,x))",
    "",
    "    reci   Reciprocal value",
    "",
    "           o(t,x) = 1 / i(t,x)",
    "",
    "    not    Logical NOT",
    "",
    "           o(t,x) = 1, if x equal 0; else 0",
    "",
    "EXAMPLE",
    "    To calculate the square root for all field elements use:",
    "",
    "       cdo sqrt infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp MergeHelp = {
    "NAME",
    "    merge, mergetime - Merge datasets",
    "",
    "SYNOPSIS",
    "    cdo [options]  merge  infiles outfile",
    "",
    "    cdo [options]  mergetime[,parameters]  infiles outfile",
    "",
    "DESCRIPTION",
    "    This module reads datasets from several input files, merges them and writes the resulting dataset",
    "    to outfile.",
    "",
    "OPERATORS",
    "",
    "    merge  Merge datasets with different fields",
    "",
    "           Merges time series of different fields from several input datasets. The number of fields",
    "           per timestep written to outfile is the sum of the field numbers per timestep in all input",
    "           datasets. The time series on all input datasets are required to have different fields and",
    "           the same number of timesteps.  The fields in each different input file either have to be",
    "           different variables or different levels of the same variable. A mixture of different",
    "           variables on different levels in different input files is not allowed.",
    "",
    "    mergetime",
    "           Merge datasets sorted by date and time",
    "",
    "           Merges all timesteps of all input files sorted by date and time.  All input files need to",
    "           have the same structure with the same variables on different timesteps. After this",
    "           operation every input timestep is in outfile and all timesteps are sorted by date and time.",
    "",
    "PARAMETERS",
    "",
    "    skip_same_time (BOOL)",
    "           Skips all consecutive timesteps with a double entry of the same timestamp.",
    "",
    "    names (STRING)",
    "           Fill missing variable names with missing values (union) or use the intersection",
    "           (intersect).",
    "",
    "OPTIONS",
    "    -O, --overwrite to overwrite existing output file.",
    "",
    "NOTE",
    "    Operators of this module need to open all input files simultaneously.  The maximum number of open",
    "    files depends on the operating system!",
    "",
    "EXAMPLE",
    "    Assume three datasets with the same number of timesteps and different variables in each dataset.",
    "    To merge these datasets to a new dataset use:",
    "",
    "       cdo merge infile1 infile2 infile3 outfile",
    "",
    "    Assume you split a 6 hourly dataset with splithour. This produces four datasets, one for each",
    "    hour.  The following command merges them together:",
    "",
    "       cdo mergetime infile1 infile2 infile3 infile4 outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp MergegridHelp = {
    "NAME",
    "    mergegrid - Merge grid",
    "",
    "SYNOPSIS",
    "    cdo  mergegrid  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Merges grid points of all variables from infile2 to infile1 and write the result to outfile.  Only",
    "    the non missing values of infile2 will be used. The horizontal grid of infile2 should be smaller",
    "    or equal to the grid of infile1 and the resolution must be the same.  Only rectilinear grids are",
    "    supported. Both input files need to have the same variables and the same number of timesteps.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp MerstatHelp = {
    "NAME",
    "    mermin, mermax, merrange, mersum, mermean, meravg, merstd, merstd1, mervar, mervar1, merskew,",
    "    merkurt, mermedian, merpctl - Meridional statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "    cdo  merpctl,pn  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes meridional statistical values of the input fields.  Depending on the chosen",
    "    operator, the meridional minimum, maximum, range, sum, average, standard deviation, variance,",
    "    skewness, kurtosis, median or a certain percentile of the field is written to outfile.  Operators",
    "    of this module require all variables on the same regular lon/lat grid.",
    "",
    "OPERATORS",
    "",
    "    mermin Meridional minimum",
    "",
    "           For every longitude the minimum over all latitudes is computed.",
    "",
    "    mermax Meridional maximum",
    "",
    "           For every longitude the maximum over all latitudes is computed.",
    "",
    "    merrange",
    "           Meridional range",
    "",
    "           For every longitude the range over all latitudes is computed.",
    "",
    "    mersum Meridional sum",
    "",
    "           For every longitude the sum over all latitudes is computed.",
    "",
    "    mermean",
    "           Meridional mean",
    "",
    "           For every longitude the area weighted mean over all latitudes is computed.",
    "",
    "    meravg Meridional average",
    "",
    "           For every longitude the area weighted average over all latitudes is computed.",
    "",
    "    mervar Meridional variance",
    "",
    "           For every longitude the variance over all latitudes is computed. Normalize by n.",
    "",
    "    mervar1",
    "           Meridional variance (n-1)",
    "",
    "           For every longitude the variance over all latitudes is computed. Normalize by (n-1).",
    "",
    "    merstd Meridional standard deviation",
    "",
    "           For every longitude the standard deviation over all latitudes is computed. Normalize by n.",
    "",
    "    merstd1",
    "           Meridional standard deviation (n-1)",
    "",
    "           For every longitude the standard deviation over all latitudes is computed. Normalize by",
    "           (n-1).",
    "",
    "    merskew",
    "           Meridional skewness",
    "",
    "           For every longitude the skewness over all latitudes is computed.",
    "",
    "    merkurt",
    "           Meridional kurtosis",
    "",
    "           For every longitude the kurtosis over all latitudes is computed.",
    "",
    "    mermedian",
    "           Meridional median",
    "",
    "           For every longitude the median over all latitudes is computed.",
    "",
    "    merpctl",
    "           Meridional percentile",
    "",
    "           For every longitude the pth percentile over all latitudes is computed.",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "EXAMPLE",
    "    To compute the meridional mean of all input fields use:",
    "",
    "       cdo mermean infile outfile",
    "",
    "    To compute the 50th meridional percentile (median) of all input fields use:",
    "",
    "       cdo merpctl,50 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp MonarithHelp = {
    "NAME",
    "    monadd, monsub, monmul, mondiv - Monthly arithmetic",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same month and",
    "    year.  For each field in infile1 the corresponding field of the timestep in infile2 with the same",
    "    month and year is used.  The input files need to have the same structure with the same variables.",
    "    Usually infile2 is generated by an operator of the module Monstat.",
    "",
    "OPERATORS",
    "",
    "    monadd Add monthly time series",
    "",
    "           Adds a time series and a monthly time series.",
    "",
    "    monsub Subtract monthly time series",
    "",
    "           Subtracts a time series and a monthly time series.",
    "",
    "    monmul Multiply monthly time series",
    "",
    "           Multiplies a time series and a monthly time series.",
    "",
    "    mondiv Divide monthly time series",
    "",
    "           Divides a time series and a monthly time series.",
    "",
    "EXAMPLE",
    "    To subtract a monthly time average from a time series use:",
    "",
    "       cdo monsub infile -monavg infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp MonpctlHelp = {
    "NAME",
    "    monpctl - Monthly percentile",
    "",
    "SYNOPSIS",
    "    cdo  monpctl,pn  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same month in infile1.  The algorithm",
    "    uses histograms with minimum and maximum bounds given in infile2 and infile3, respectively. The",
    "    default number of histogram bins is 101.  The default can be overridden by defining the",
    "    environment variable CDO_PCTL_NBINS.  The files infile2 and infile3 should be the result of",
    "    corresponding monmin and monmax operations, respectively.  The time of outfile is determined by",
    "    the time in the middle of all contributing timesteps of infile1.  This can be change with the CDO",
    "    option –timestat_date <first|middle|last>.",
    "",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "",
    "    o(t,x) = pth percentile {i(t’,x), t_1<=t’<=t_n}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "EXAMPLE",
    "    To compute the monthly 90th percentile of a time series use:",
    "",
    "       cdo monmin infile minfile",
    "       cdo monmax infile maxfile",
    "       cdo monpctl,90 infile minfile maxfile outfile",
    "",
    "    Or shorter using operator piping:",
    "",
    "       cdo monpctl,90 infile -monmin infile -monmax infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp MonstatHelp = {
    "NAME",
    "    monmin, monmax, monrange, monsum, monmean, monavg, monstd, monstd1, monvar, monvar1 - Monthly",
    "    statistics",
    "",
    "SYNOPSIS",
    "    cdo [options]  <operator>[,parameters]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same month.  Depending on the chosen",
    "    operator the minimum, maximum, range, sum, average, variance or standard deviation of timesteps of",
    "    the same month is written to outfile.  The time of outfile is determined by the time in the middle",
    "    of all contributing timesteps of infile.  This can be change with the CDO option –timestat_date",
    "    <first|middle|last>.",
    "",
    "OPERATORS",
    "",
    "    monmin Monthly minimum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "",
    "           o(t,x) = min{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    monmax Monthly maximum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "",
    "           o(t,x) = max{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    monrange",
    "           Monthly range",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "",
    "           o(t,x) = range{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    monsum Monthly sum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "",
    "           o(t,x) = sum{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    monmean",
    "           Monthly mean",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "",
    "           o(t,x) = mean{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    monavg Monthly average",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "",
    "           o(t,x) = avg{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    monvar Monthly variance",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "",
    "           o(t,x) = var{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    monvar1",
    "           Monthly variance (n-1)",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "",
    "           o(t,x) = var1{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    monstd Monthly standard deviation",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "",
    "           o(t,x) = std{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    monstd1",
    "           Monthly standard deviation (n-1)",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same month it is:",
    "",
    "           o(t,x) = std1{i(t’,x), t_1<=t’<=t_n}",
    "",
    "PARAMETERS",
    "",
    "    complete_only (BOOL)",
    "           Process the last month only if it is complete",
    "",
    "OPTIONS",
    "    -S, --diagnostic to create a diagnostic output stream with the number of non missing values for",
    "    each output period.",
    "",
    "    -p, --async_read true to read input data asynchronously.",
    "",
    "EXAMPLE",
    "    To compute the monthly mean of a time series use:",
    "",
    "       cdo monmean infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp MrotuvbHelp = {
    "NAME",
    "    mrotuvb - Backward rotation of MPIOM data",
    "",
    "SYNOPSIS",
    "    cdo  mrotuvb  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    MPIOM data are on a rotated Arakawa C grid. The velocity components U and V are located on the",
    "    edges of the cells and point in the direction of the grid lines and rows.  With mrotuvb the",
    "    velocity vector is rotated in latitudinal and longitudinal direction.  Before the rotation, U and",
    "    V are interpolated to the scalar points (cell center).  U is located with the coordinates for U in",
    "    infile1 and V in infile2.  mrotuvb assumes a positive meridional flow for a flow from grid",
    "    point(i,j) to grid point(i,j+1) and positive zonal flow for a flow from grid point(i+1,j) to",
    "    point(i,j).",
    "",
    "NOTE",
    "    This is a specific implementation for data from the MPIOM model, it may not work with data from",
    "    other sources.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp Ncl_windHelp = {
    "NAME",
    "    uv2vr_cfd, uv2dv_cfd - Wind transformation",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,u,v,boundOpt,outMode]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains CDO operators with an interface to NCL functions.  The corresponding NCL",
    "    functions have the same name. A more detailed description of those NCL function can be found on",
    "    the NCL homepage https://www.ncl.ucar.edu.",
    "",
    "OPERATORS",
    "",
    "    uv2vr_cfd",
    "           U and V wind to relative vorticity",
    "",
    "           Computes relative vorticity for a latitude-longitude grid using centered finite",
    "           differences.  The grid need not be global and missing values are allowed.",
    "",
    "    uv2dv_cfd",
    "           U and V wind to divergence",
    "",
    "           Computes divergence for a latitude-longitude grid using centered finite differences.  The",
    "           grid need not be global and missing values are allowed.",
    "",
    "PARAMETERS",
    "",
    "    u STRING",
    "           Name of variable u (default: u)",
    "",
    "    v STRING",
    "           Name of variable v (default: v)",
    "",
    "    boundOpt INTEGER",
    "           Boundary condition option (0-3) (default: 0/1 for cyclic grids)",
    "",
    "    outMode STRING",
    "           Output mode new/append (default: new)",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp NinfoHelp = {
    "NAME",
    "    npar, nlevel, nyear, nmon, ndate, ntime, ngridpoints, ngrids - Print the number of parameters,",
    "    levels or times",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile",
    "",
    "DESCRIPTION",
    "    This module prints the number of variables, levels or times of the input dataset.",
    "",
    "OPERATORS",
    "",
    "    npar   Number of parameters",
    "",
    "           Prints the number of parameters (variables).",
    "",
    "    nlevel Number of levels",
    "",
    "           Prints the number of levels for each variable.",
    "",
    "    nyear  Number of years",
    "",
    "           Prints the number of different years.",
    "",
    "    nmon   Number of months",
    "",
    "           Prints the number of different combinations of years and months.",
    "",
    "    ndate  Number of dates",
    "",
    "           Prints the number of different dates.",
    "",
    "    ntime  Number of timesteps",
    "",
    "           Prints the number of timesteps.",
    "",
    "    ngridpoints",
    "           Number of gridpoints",
    "",
    "           Prints the number of gridpoints for each variable.",
    "",
    "    ngrids Number of horizontal grids",
    "",
    "           Prints the number of horizontal grids.",
    "",
    "EXAMPLE",
    "    To print the number of parameters (variables) in a dataset use:",
    "",
    "       cdo npar infile",
    "",
    "    To print the number of months in a dataset use:",
    "",
    "       cdo nmon infile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida, Ralf Müller",
    "",
};

const CdoHelp OutputHelp = {
    "NAME",
    "    output, outputf, outputint, outputsrv, outputext - Formatted output",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infiles",
    "",
    "    cdo  outputf[,format[,nelem]]  infiles",
    "",
    "DESCRIPTION",
    "    This module prints all values of all input datasets to standard output.  All input fields need to",
    "    have the same horizontal grid.  All input files need to have the same structure with the same",
    "    variables.  The format of the output depends on the chosen operator.",
    "",
    "OPERATORS",
    "",
    "    output ASCII output",
    "",
    "           Prints all values to standard output.  Each row has 6 elements with the C-style format",
    "           “%13.6g”.",
    "",
    "    outputf",
    "           Formatted output",
    "",
    "           Prints all values to standard output.  The format and number of elements for each row have",
    "           to be specified by the parameters format and nelem. The default for nelem is 1.",
    "",
    "    outputint",
    "           Integer output",
    "",
    "           Prints all values rounded to the nearest integer to standard output.",
    "",
    "    outputsrv",
    "           SERVICE ASCII output",
    "",
    "           Prints all values to standard output.  Each field with a header of 8 integers (SERVICE",
    "           likely).",
    "",
    "    outputext",
    "           EXTRA ASCII output",
    "",
    "           Prints all values to standard output.  Each field with a header of 4 integers (EXTRA",
    "           likely).",
    "",
    "PARAMETERS",
    "",
    "    format (STRING)",
    "           C-style format for one element (e.g. %13.6g)",
    "",
    "    nelem (INTEGER)",
    "           Number of elements for each row (default: nelem = 1)",
    "",
    "EXAMPLE",
    "    To print all field elements of a dataset formatted with “%8.4g” and 8 values per line use:",
    "",
    "       cdo outputf,%8.4g,8 infile",
    "",
    "    Example result of a dataset with one field on 64 grid points:",
    "",
    "       261.7     262   257.8   252.5   248.8   247.7   246.3   246.1",
    "       250.6   252.6   253.9   254.8     252   246.6   249.7   257.9",
    "       273.4   266.2   259.8   261.6   257.2   253.4     251   263.7",
    "       267.5   267.4   272.2   266.7   259.6   255.2   272.9   277.1",
    "       275.3   275.5   276.4   278.4     282   269.6   278.7   279.5",
    "       282.3   284.5   280.3   280.3     280   281.5   284.7   283.6",
    "       292.9   290.5   293.9   292.6   292.7   292.8   294.1   293.6",
    "       293.8   292.6   291.2   292.6   293.2   292.8     291   291.2",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp OutputgmtHelp = {
    "NAME",
    "    gmtxyz, gmtcells - GMT output",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile",
    "",
    "DESCRIPTION",
    "    This module prints the first field of the input dataset to standard output.  The output can be",
    "    used to generate 2D Lon/Lat plots with [GMT].  The format of the output depends on the chosen",
    "    operator.",
    "",
    "OPERATORS",
    "",
    "    gmtxyz GMT xyz format",
    "",
    "           The operator exports the first field to the GMT xyz ASCII format.  The output can be used",
    "           to create contour plots with the GMT module pscontour.",
    "",
    "    gmtcells",
    "           GMT multiple segment format",
    "",
    "           The operator exports the first field to the GMT multiple segment ASCII format.  The output",
    "           can be used to create shaded gridfill plots with the GMT module psxy.",
    "",
    "EXAMPLE",
    "    1) GMT shaded contour plot of a global temperature field with a resolution of 4 degree.  The",
    "    contour interval is 3 with a rainbow color table:",
    "",
    "       cdo gmtxyz temp > data.gmt",
    "       makecpt -T213/318/3  -Crainbow > gmt.cpt",
    "       pscontour -K -JQ0/10i -Rd -I -Cgmt.cpt data.gmt > gmtplot.ps",
    "       pscoast -O -J -R -Dc -W -B40g20 >> gmtplot.ps",
    "",
    "    2) GMT shaded gridfill plot of a global temperature field with a resolution of 4 degree.  The",
    "    contour interval is 3 with a rainbow color table:",
    "",
    "       cdo gmtcells temp > data.gmt",
    "       makecpt -T213/318/3  -Crainbow > gmt.cpt",
    "       psxy -K -JQ0/10i -Rd -L -Cgmt.cpt -m data.gmt > gmtplot.ps",
    "       pscoast -O -J -R -Dc -W -B40g20 >> gmtplot.ps",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp OutputtabHelp = {
    "NAME",
    "    outputtab - Table output",
    "",
    "SYNOPSIS",
    "    cdo  outputtab,parameters  infiles",
    "",
    "DESCRIPTION",
    "    This operator prints a table of all input datasets to standard output.  infiles is an arbitrary",
    "    number of input files. All input files need to have the same structure with the same variables on",
    "    different timesteps.  All input fields need to have the same horizontal grid.",
    "",
    "    The contents of the table depends on the chosen parameters. The format of each table parameter is",
    "    keyname[:len].  len is the optional length of a table entry. The number of significant digits of",
    "    floating point parameters can be set with the CDO option –precision, the default is 7.  Here is a",
    "    list of all valid keynames:",
    "",
    "                             ┌─────────┬─────────┬───────────────────────────┐",
    "                             │Keyname  │ Type    │ Description               │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │value    │ FLOAT   │ Value of the variable     │",
    "                             │         │         │ [len:8]                   │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │name     │ STRING  │ Name of the variable      │",
    "                             │         │         │ [len:8]                   │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │param    │ STRING  │ Parameter ID (GRIB1:      │",
    "                             │         │         │ code[.tabnum]; GRIB2:     │",
    "                             │         │         │ num[.cat[.dis]]) [len:11] │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │code     │ INTEGER │ Code number [len:4]       │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │x        │ FLOAT   │ X coordinate of the       │",
    "                             │         │         │ original grid [len:6]     │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │y        │ FLOAT   │ Y coordinate of the       │",
    "                             │         │         │ original grid [len:6]     │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │lon      │ FLOAT   │ Longitude coordinate in   │",
    "                             │         │         │ degrees [len:6]           │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │lat      │ FLOAT   │ Latitude coordinate in    │",
    "                             │         │         │ degrees [len:6]           │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │lev      │ FLOAT   │ Vertical level [len:6]    │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │xind     │ INTEGER │ Grid x index [len:4]      │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │yind     │ INTEGER │ Grid y index [len:4]      │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │timestep │ INTEGER │ Timestep number [len:6]   │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │date     │ STRING  │ Date (format YYYY-MM-DD)  │",
    "                             │         │         │ [len:10]                  │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │time     │ STRING  │ Time (format hh:mm:ss)    │",
    "                             │         │         │ [len:8]                   │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │year     │ INTEGER │ Year [len:5]              │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │month    │ INTEGER │ Month [len:2]             │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │day      │ INTEGER │ Day [len:2]               │",
    "                             ├─────────┼─────────┼───────────────────────────┤",
    "                             │nohead   │ INTEGER │ Disable output of header  │",
    "                             │         │         │ line                      │",
    "                             └─────────┴─────────┴───────────────────────────┘",
    "PARAMETERS",
    "",
    "    keynames (STRING)",
    "           Comma-separated list of keynames, one for each column of the table",
    "",
    "EXAMPLE",
    "    To print a table with name, date, lon, lat and value information use:",
    "",
    "       cdo  outputtab,name,date,lon,lat,value  infile",
    "",
    "    Here is an example output of a time series with the yearly mean temperatur at lon=10/lat=53.5:",
    "",
    "       #   name       date    lon    lat    value",
    "          tsurf  1991-12-31     10   53.5  8.83903",
    "          tsurf  1992-12-31     10   53.5  8.17439",
    "          tsurf  1993-12-31     10   53.5  7.90489",
    "          tsurf  1994-12-31     10   53.5  10.0216",
    "          tsurf  1995-12-31     10   53.5  9.07798",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp PackHelp = {
    "NAME",
    "    pack - Pack data",
    "",
    "SYNOPSIS",
    "    cdo  pack[,parameter]  infile outfile",
    "",
    "DESCRIPTION",
    "    Packing reduces the data volume by reducing the precision of the stored numbers.  It is",
    "    implemented using the NetCDF attributes add_offset and scale_factor.  The operator pack calculates",
    "    the attributes add_offset and scale_factor for all variables.  The default data type for all",
    "    variables is automatically changed to 16-bit integer.  Use the CDO option -b to change the data",
    "    type to a different integer precision, if needed.  Missing values are automatically transformed to",
    "    the current data type.",
    "",
    "    Alternatively, the pack parameters add_offset and scale_factor can be read from a file for each",
    "    variable.",
    "",
    "PARAMETERS",
    "",
    "    printparam (BOOL)",
    "           Print pack parameters to stdout for each variable",
    "",
    "    filename (STRING)",
    "           Read pack parameters from file for each variable[format: name=<> add_offset=<>",
    "           scale_factor=<>]",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp PressureHelp = {
    "NAME",
    "    pressure_half, pressure, delta_pressure - Pressure on model levels",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators to calculate the pressure on model levels.  To calculate the",
    "    pressure on model levels, the a and b coefficients defining the model levels and the surface",
    "    pressure are required. The a and b coefficients are normally part of the model level data.  If not",
    "    available, the surface pressure can be derived from the logarithm of the surface pressure.  The",
    "    surface pressure is identified by the GRIB1 code number or NetCDF CF standard name.",
    "",
    "                    ┌─────────────────────┬───────┬────────────┬──────────────────────┐",
    "                    │Name                 │ Units │ GRIB1 code │ CF standard name     │",
    "                    ├─────────────────────┼───────┼────────────┼──────────────────────┤",
    "                    │log surface pressure │ Pa    │ 152        │                      │",
    "                    ├─────────────────────┼───────┼────────────┼──────────────────────┤",
    "                    │surface pressure     │ Pa    │ 134        │ surface_air_pressure │",
    "                    └─────────────────────┴───────┴────────────┴──────────────────────┘",
    "OPERATORS",
    "",
    "    pressure_half",
    "           Pressure on half-levels",
    "",
    "           This operator computes the pressure on model half-levels in pascal.  The model half-level",
    "           pressure (p_half) is given by:",
    "",
    "           p_half = a + b * sp",
    "           with:",
    "           a, b: coefficients defining the model levels",
    "           sp: surface pressure",
    "",
    "",
    "    pressure",
    "           Pressure on full-levels",
    "",
    "           This operator computes the pressure on model full-levels in pascal.  The pressure on model",
    "           full-levels (p_full) is in the middle of the layers defined by the model half-levels:",
    "",
    "           p_full = (p_half_above + p_half_below) / 2",
    "",
    "    delta_pressure",
    "           Pressure difference of half-levels",
    "",
    "           This operator computes the pressure difference between to model half-levels.",
    "",
    "           delta_p = p_half_below - p_half_above",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp RegresHelp = {
    "NAME",
    "    regres - Regression",
    "",
    "SYNOPSIS",
    "    cdo  regres[,equal]  infile outfile",
    "",
    "DESCRIPTION",
    "    The values of the input file infile are assumed to be distributed as N(a+b*t,S^2) with unknown a,",
    "    b and S^2. This operator estimates the parameter b. For every field element x only those timesteps",
    "    t belong to the sample S(x), which have i(t,x) NE miss.",
    "",
    "    It is assumed that all timesteps are equidistant, if this is not the case set the parameter",
    "    equal=false.",
    "",
    "PARAMETERS",
    "",
    "    equal (BOOL)",
    "           Set to false for unequal distributed timesteps (default: true)",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp RemapHelp = {
    "NAME",
    "    remap - Grid remapping",
    "",
    "SYNOPSIS",
    "    cdo  remap,targetgrid,weights  infile outfile",
    "",
    "DESCRIPTION",
    "    Interpolation between different horizontal grids can be a very time-consuming process. Especially",
    "    if the data are on an unstructured and/or a large grid.  In this case the interpolation process",
    "    can be split into two parts.  Firstly the generation of the interpolation weights, which is the",
    "    most time-consuming part.  These interpolation weights can be reused for every remapping process",
    "    with the operator remap.  This operator remaps all input fields to a new horizontal grid. The",
    "    remap type and the interpolation weights of one input grid are read from a NetCDF file. More",
    "    weights are computed if the input fields are on different grids. The NetCDF file with the weights",
    "    should follow the [SCRIP] convention. Normally these weights come from a previous call to one of",
    "    the genXXX operators (e.g. genbil) or were created by the original SCRIP package.",
    "",
    "PARAMETERS",
    "",
    "    targetgrid (STRING)",
    "           Target grid description file or name",
    "",
    "    weights (STRING)",
    "           Interpolation weights (SCRIP NetCDF file)",
    "",
    "ENVIRONMENT",
    "    CDO_GRIDSEARCH_RADIUS sets the grid search radius in degree (default: CDO_GRIDSEARCH_RADIUS=180).",
    "",
    "    CDO_REMAP_NORM is used to choose the normalization of the conservative interpolation.  By default",
    "    CDO_REMAP_NORM is set to ‘fracarea’. ‘fracarea’ uses the sum of the non-masked source cell",
    "    intersected areas to normalize each target cell field value.  This results in a reasonable flux",
    "    value but the flux is not locally conserved.  The option ‘destarea’ uses the total target cell",
    "    area to normalize each target cell field value. Local flux conservation is ensured, but",
    "    unreasonable flux values may result.",
    "",
    "    REMAP_AREA_MIN is used to set the minimum destination area fraction (default: REMAP_AREA_MIN=0.0).",
    "",
    "    REMAP_EXTRAPOLATE is used to switch the extrapolation feature ‘on’ or ‘off’.  By default the",
    "    extrapolation is enabled for circular grids.",
    "",
    "EXAMPLE",
    "    Say infile contains fields on a quadrilateral curvilinear grid.  To remap all fields bilinear to a",
    "    regular Gaussian F32 grid use:",
    "",
    "       cdo genbil,F32 infile remapweights.nc",
    "       cdo remap,F32,remapweights.nc infile outfile",
    "",
    "    The result will be the same as::",
    "           cdo remapbil,F32 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp RemapbicHelp = {
    "NAME",
    "    remapbic, genbic - Bicubic interpolation",
    "",
    "SYNOPSIS",
    "    cdo  remapbic,targetgrid  infile outfile",
    "",
    "    cdo  genbic,targetgrid[,map3d]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a bicubic remapping of fields between grids in spherical",
    "    coordinates.  The interpolation is based on an adapted SCRIP library version.  For a detailed",
    "    description of the interpolation method see [SCRIP].  This interpolation method only works on",
    "    quadrilateral curvilinear source grids.",
    "",
    "OPERATORS",
    "",
    "    remapbic",
    "           Bicubic interpolation",
    "",
    "           Performs a bicubic interpolation on all input fields.",
    "",
    "    genbic Generate bicubic interpolation weights",
    "",
    "           Generates bicubic interpolation weights for the first input field and writes the result to",
    "           a file. The format of this file is NetCDF following the SCRIP convention.  Use the operator",
    "           remap to apply this remapping weights to a data file with the same source grid.  Set the",
    "           parameter map3d=true to generate all mapfiles of the first 3D field with varying masks.  In",
    "           this case the mapfiles will be named <outfile><xxx>.nc. xxx will have five digits with the",
    "           number of the mapfile.",
    "",
    "PARAMETERS",
    "",
    "    targetgrid (STRING)",
    "           Target grid description file or name",
    "",
    "    map3d (BOOL)",
    "           Generate all mapfiles of the first 3D field",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE is used to switch the extrapolation feature ‘on’ or ‘off’.  By default the",
    "    extrapolation is enabled for cyclic grids.",
    "",
    "EXAMPLE",
    "    Say infile contains fields on a quadrilateral curvilinear grid.  To remap all fields bicubic to a",
    "    regular Gaussian F32 grid, type:",
    "",
    "       cdo remapbic,F32 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp RemapbilHelp = {
    "NAME",
    "    remapbil, genbil - Bilinear interpolation",
    "",
    "SYNOPSIS",
    "    cdo  remapbil,targetgrid  infile outfile",
    "",
    "    cdo  genbil,targetgrid[,map3d]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a bilinear remapping of fields between grids in spherical",
    "    coordinates.  The interpolation is based on an adapted SCRIP library version.  For a detailed",
    "    description of the interpolation method see [SCRIP].  This interpolation method only works on",
    "    quadrilateral curvilinear source grids.",
    "",
    "OPERATORS",
    "",
    "    remapbil",
    "           Bilinear interpolation",
    "",
    "           Performs a bilinear interpolation on all input fields.",
    "",
    "    genbil Generate bilinear interpolation weights",
    "",
    "           Generates bilinear interpolation weights for the first input field and writes the result to",
    "           a file. The format of this file is NetCDF following the SCRIP convention.  Use the operator",
    "           remap to apply this remapping weights to a data file with the same source grid.  Set the",
    "           parameter map3d=true to generate all mapfiles of the first 3D field with varying masks.  In",
    "           this case the mapfiles will be named <outfile><xxx>.nc. xxx will have five digits with the",
    "           number of the mapfile.",
    "",
    "PARAMETERS",
    "",
    "    targetgrid (STRING)",
    "           Target grid description file or name",
    "",
    "    map3d (BOOL)",
    "           Generate all mapfiles of the first 3D field",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE is used to switch the extrapolation feature ‘on’ or ‘off’.  By default the",
    "    extrapolation is enabled for cyclic grids.",
    "",
    "EXAMPLE",
    "    Say infile contains fields on a quadrilateral curvilinear grid.  To remap all fields bilinear to a",
    "    regular Gaussian F32 grid, type:",
    "",
    "       cdo remapbil,F32 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp RemapconHelp = {
    "NAME",
    "    remapcon, gencon - First order conservative remapping",
    "",
    "SYNOPSIS",
    "    cdo  remapcon,targetgrid  infile outfile",
    "",
    "    cdo  gencon,targetgrid[,map3d]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a first order conservative remapping of fields between grids in",
    "    spherical coordinates.  The operators in this module uses code from the YAC software package to",
    "    compute the conservative remapping weights.  For a detailed description of the interpolation",
    "    method see [YAC].  The interpolation method is completely general and can be used for any grid on",
    "    a sphere.  The search algorithm for the conservative remapping requires that no grid cell occurs",
    "    more than once.",
    "",
    "OPERATORS",
    "",
    "    remapcon",
    "           First order conservative remapping",
    "",
    "           Performs a first order conservative remapping on all input fields.",
    "",
    "    gencon Generate 1st order conservative remap weights",
    "",
    "           Generates first order conservative remapping weights for the first input field and writes",
    "           the result to a file. The format of this file is NetCDF following the SCRIP convention.",
    "           Use the operator remap to apply this remapping weights to a data file with the same source",
    "           grid.  Set the parameter map3d=true to generate all mapfiles of the first 3D field with",
    "           varying masks.  In this case the mapfiles will be named <outfile><xxx>.nc. xxx will have",
    "           five digits with the number of the mapfile.",
    "",
    "PARAMETERS",
    "",
    "    targetgrid (STRING)",
    "           Target grid description file or name",
    "",
    "    map3d (BOOL)",
    "           Generate all mapfiles of the first 3D field",
    "",
    "ENVIRONMENT",
    "    CDO_REMAP_NORM is used to choose the normalization of the conservative interpolation.  By default",
    "    CDO_REMAP_NORM is set to ‘fracarea’. ‘fracarea’ uses the sum of the non-masked source cell",
    "    intersected areas to normalize each target cell field value.  This results in a reasonable flux",
    "    value but the flux is not locally conserved.  The option ‘destarea’ uses the total target cell",
    "    area to normalize each target cell field value. Local flux conservation is ensured, but",
    "    unreasonable flux values may result.",
    "",
    "    REMAP_AREA_MIN is used to set the minimum destination area fraction (default: REMAP_AREA_MIN=0.0).",
    "",
    "EXAMPLE",
    "    Say infile contains fields on a quadrilateral curvilinear grid.  To remap all fields conservative",
    "    to a regular Gaussian F32 grid, type:",
    "",
    "       cdo remapcon,F32 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp RemapdisHelp = {
    "NAME",
    "    remapdis, gendis - Distance weighted average remapping",
    "",
    "SYNOPSIS",
    "    cdo  remapdis,targetgrid[,neighbors]  infile outfile",
    "",
    "    cdo  gendis,targetgrid[,neighbors][,map3d]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for an inverse distance weighted average remapping of the four",
    "    nearest neighbor values of fields between grids in spherical coordinates.  The default number of 4",
    "    neighbors can be changed with the neighbors parameter.",
    "",
    "OPERATORS",
    "",
    "    remapdis",
    "           Distance weighted average remapping",
    "",
    "           Performs an inverse distance weighted averaged remapping of the nearest neighbor values on",
    "           all input fields.",
    "",
    "    gendis Generate distance weighted average remap weights",
    "",
    "           Generates distance weighted averaged remapping weights of the nearest neighbor values for",
    "           the first input field and writes the result to a file. The format of this file is NetCDF",
    "           following the SCRIP convention.  Use the operator remap to apply this remapping weights to",
    "           a data file with the same source grid.  Set the parameter map3d=true to generate all",
    "           mapfiles of the first 3D field with varying masks.  In this case the mapfiles will be named",
    "           <outfile><xxx>.nc. xxx will have five digits with the number of the mapfile.",
    "",
    "PARAMETERS",
    "",
    "    targetgrid (STRING)",
    "           Target grid description file or name",
    "",
    "    neighbors (INTEGER)",
    "           Number of nearest neighbors [default: 4]",
    "",
    "    map3d (BOOL)",
    "           Generate all mapfiles of the first 3D field",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE is used to switch the extrapolation feature ‘on’ or ‘off’.  By default the",
    "    extrapolation is enabled for circular grids.",
    "",
    "    CDO_GRIDSEARCH_RADIUS sets the grid search radius in degree (default: CDO_GRIDSEARCH_RADIUS=180).",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp RemapetaHelp = {
    "NAME",
    "    remapeta - Remap vertical hybrid levels",
    "",
    "SYNOPSIS",
    "    cdo  remapeta,vct[,oro]  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator interpolates between different vertical hybrid levels. This include the preparation",
    "    of consistent data for the free atmosphere. The procedure for the vertical interpolation is based",
    "    on the HIRLAM scheme and was adapted from [INTERA].  The vertical interpolation is based on the",
    "    vertical integration of the hydrostatic equation with few adjustments. The basic tasks are the",
    "    following one:",
    "",
    "    • at first integration of hydrostatic equation",
    "",
    "    • extrapolation of surface pressure",
    "",
    "    • Planetary Boundary-Layer (PBL) proutfile interpolation",
    "",
    "    • interpolation in free atmosphere",
    "",
    "    • merging of both proutfiles",
    "",
    "    • final surface pressure correction",
    "",
    "    The vertical interpolation corrects the surface pressure. This is simply a cut-off or an addition",
    "    of air mass. This mass correction should not influence the geostrophic velocity field in the",
    "    middle troposphere. Therefore the total mass above a given reference level is conserved. As",
    "    reference level the geopotential height of the 400 hPa level is used. Near the surface the",
    "    correction can affect the vertical structure of the PBL. Therefore the interpolation is done using",
    "    the potential temperature.  But in the free atmosphere above a certain n (n=0.8 defining the top",
    "    of the PBL) the interpolation is done linearly. After the interpolation both proutfiles are",
    "    merged. With the resulting temperature/pressure correction the hydrostatic equation is integrated",
    "    again and adjusted to the reference level finding the final surface pressure correction. A more",
    "    detailed description of the interpolation can be found in [INTERA]. This operator requires all",
    "    variables on the same horizontal grid.",
    "",
    "PARAMETERS",
    "",
    "    vct (STRING)",
    "           File name of an ASCII dataset with the vertical coordinate table",
    "",
    "    oro (STRING)",
    "           File name with the orography (surf. geopotential) of the target dataset (optional)",
    "",
    "ENVIRONMENT",
    "",
    "    REMAPETA_PTOP",
    "           Sets the minimum pressure level for condensation.  Above this level the humidity is set to",
    "           the constant 1.E-6.  The default value is 0 Pa.",
    "",
    "NOTE",
    "    The code numbers or the variable names of the required parameter have to follow the [ECHAM]",
    "    convention.",
    "",
    "    Use the sinfo command to test if your vertical coordinate system is recognized as hybrid system.",
    "",
    "    In case remapeta complains about not finding any data on hybrid model levels you may wish to use",
    "    the setzaxis command to generate a zaxis description which conforms to the ECHAM convention.  See",
    "    section Z-axis description for an example how to define a hybrid Z-axis.",
    "",
    "EXAMPLE",
    "    To remap between different hybrid model level data use:",
    "",
    "       cdo remapeta,vct infile outfile",
    "",
    "    Here is an example vct file with 19 hybrid model level:",
    "",
    "        0       0.00000000000000000       0.00000000000000000",
    "        1    2000.00000000000000000       0.00000000000000000",
    "        2    4000.00000000000000000       0.00000000000000000",
    "        3    6046.10937500000000000       0.00033899326808751",
    "        4    8267.92968750000000000       0.00335718691349030",
    "        5   10609.51171875000000000       0.01307003945112228",
    "        6   12851.10156250000000000       0.03407714888453484",
    "        7   14698.50000000000000000       0.07064980268478394",
    "        8   15861.12890625000000000       0.12591671943664551",
    "        9   16116.23828125000000000       0.20119541883468628",
    "       10   15356.92187500000000000       0.29551959037780762",
    "       11   13621.46093750000000000       0.40540921688079834",
    "       12   11101.55859375000000000       0.52493220567703247",
    "       13    8127.14453125000000000       0.64610791206359863",
    "       14    5125.14062500000000000       0.75969839096069336",
    "       15    2549.96899414062500000       0.85643762350082397",
    "       16     783.19506835937500000       0.92874687910079956",
    "       17       0.00000000000000000       0.97298520803451538",
    "       18       0.00000000000000000       0.99228149652481079",
    "       19       0.00000000000000000       1.00000000000000000",
    "",
    "AUTHOR",
    "    Uwe Schulzweida, Ingo Kirchner",
    "",
};

const CdoHelp RemapknnHelp = {
    "NAME",
    "    remapknn, remapnn, remapdis, genknn, gennn, gendis - k-nearest neighbor remapping",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameter  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a k-nearest neighbor remapping of fields between grids in",
    "    spherical coordinates.  The default number for k is 1.  If k is greater than 1, the weighted",
    "    parameter can be used to choose between different weighting methods.  The default method is",
    "    weighted=dist, for an inverse distance weighting.  Here is a list of all available weighting",
    "    methods.",
    "",
    "                                   ┌──────┬───────────────────────────┐",
    "                                   │dist  │ Inverse distance weighted │",
    "                                   ├──────┼───────────────────────────┤",
    "                                   │avg   │ Simple arithmetic average │",
    "                                   ├──────┼───────────────────────────┤",
    "                                   │gauss │ Gaussian filter           │",
    "                                   └──────┴───────────────────────────┘",
    "OPERATORS",
    "",
    "    remapknn",
    "           k-nearest neighbor remapping",
    "",
    "           Performs a k-nearest neighbor remapping on all input fields.",
    "",
    "    remapnn",
    "           Nearest neighbor remapping",
    "",
    "           remapnn,<targetgrid> corresponds to remapknn,grid=<targetgrid>,extrapolate=true",
    "",
    "    remapdis",
    "           Distance weighted average remapping",
    "",
    "           remapdis,<targetgrid> corresponds to",
    "           remapknn,grid=<targetgrid>,k=4,kmin=1,weighted=dist,extrapolate=true",
    "",
    "    genknn Generate k-nearest neighbor remap weights",
    "",
    "           Generates k-nearest neighbor remapping weights for the first input field and writes the",
    "           result to a file.  The format of this file is NetCDF following the SCRIP convention.  Use",
    "           the operator remap to apply this remapping weights to a data file with the same source",
    "           grid.  Set the parameter map3d=true to generate all mapfiles of the first 3D field with",
    "           varying masks.  In this case the mapfiles will be named <outfile><xxx>.nc. xxx will have",
    "           five digits with the number of the mapfile.",
    "",
    "    gennn  Generate nearest neighbor remap weights",
    "",
    "           gennn,<targetgrid> corresponds to genknn,grid=<targetgrid>,extrapolate=true",
    "",
    "    gendis Generate distance weighted average remap weights",
    "",
    "           gendis,<targetgrid> corresponds to",
    "           genknn,grid=<targetgrid>,k=4,kmin=1,weighted=dist,extrapolate=true",
    "",
    "PARAMETERS",
    "",
    "    grid (STRING)",
    "           Target grid description file or name",
    "",
    "    k (INTEGER)",
    "           Number of nearest neighbors [default: 1]",
    "",
    "    kmin (INTEGER)",
    "           Minimum number of nearest neighbors [default: k]",
    "",
    "    weighted (WORD)",
    "           Weighting method (dist/avg/gauss) [default: dist]",
    "",
    "    gauss_scale (FLOAT)",
    "           Scaling factor for gauss weighting method [default: 0.1]",
    "",
    "    extrapolate (BOOL)",
    "           Extrapolate [default: false]",
    "",
    "    map3d (BOOL)",
    "           Generate all mapfiles of the first 3D field [default: false]",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE is used to switch the extrapolation feature ‘on’ or ‘off’.  By default the",
    "    extrapolation is enabled for circular grids.",
    "",
    "    CDO_GRIDSEARCH_RADIUS sets the grid search radius in degree (default: CDO_GRIDSEARCH_RADIUS=180).",
    "",
    "SEE ALSO",
    "    Remapbil, Remapbic, Remapcon",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp RemaplafHelp = {
    "NAME",
    "    remaplaf, genlaf - Largest area fraction remapping",
    "",
    "SYNOPSIS",
    "    cdo  remaplaf,targetgrid  infile outfile",
    "",
    "    cdo  genlaf,targetgrid[,map3d]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a largest area fraction remapping of fields between grids in",
    "    spherical coordinates.  The operators in this module uses code from the YAC software package to",
    "    compute the largest area fraction.  For a detailed description of the interpolation method see",
    "    [YAC].  The interpolation method is completely general and can be used for any grid on a sphere.",
    "    The search algorithm for this remapping method requires that no grid cell occurs more than once.",
    "",
    "OPERATORS",
    "",
    "    remaplaf",
    "           Largest area fraction remapping",
    "",
    "           Performs a largest area fraction remapping on all input fields.",
    "",
    "    genlaf Generate largest area fraction remap weights",
    "",
    "           Generates largest area fraction remapping weights for the first input field and writes the",
    "           result to a file. The format of this file is NetCDF following the SCRIP convention.  Use",
    "           the operator remap to apply this remapping weights to a data file with the same source",
    "           grid.",
    "",
    "PARAMETERS",
    "",
    "    targetgrid (STRING)",
    "           Target grid description file or name",
    "",
    "    map3d (BOOL)",
    "           Generate all mapfiles of the first 3D field",
    "",
    "ENVIRONMENT",
    "    REMAP_AREA_MIN is used to set the minimum destination area fraction (default: REMAP_AREA_MIN=0.0).",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp RemapnnHelp = {
    "NAME",
    "    remapnn, gennn - Nearest neighbor remapping",
    "",
    "SYNOPSIS",
    "    cdo  remapnn,targetgrid  infile outfile",
    "",
    "    cdo  gennn,targetgrid[,map3d]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators for a nearest neighbor remapping of fields between grids in",
    "    spherical coordinates.",
    "",
    "OPERATORS",
    "",
    "    remapnn",
    "           Nearest neighbor remapping",
    "",
    "           Performs a nearest neighbor remapping on all input fields.",
    "",
    "    gennn  Generate nearest neighbor remap weights",
    "",
    "           Generates nearest neighbor remapping weights for the first input field and writes the",
    "           result to a file.  The format of this file is NetCDF following the SCRIP convention.  Use",
    "           the operator remap to apply this remapping weights to a data file with the same source",
    "           grid.  Set the parameter map3d=true to generate all mapfiles of the first 3D field with",
    "           varying masks.  In this case the mapfiles will be named <outfile><xxx>.nc. xxx will have",
    "           five digits with the number of the mapfile.",
    "",
    "PARAMETERS",
    "",
    "    targetgrid (STRING)",
    "           Target grid description file or name",
    "",
    "    map3d (BOOL)",
    "           Generate all mapfiles of the first 3D field",
    "",
    "ENVIRONMENT",
    "    REMAP_EXTRAPOLATE is used to switch the extrapolation feature ‘on’ or ‘off’.  By default the",
    "    extrapolation is enabled for cyclic grids.",
    "",
    "    CDO_GRIDSEARCH_RADIUS sets the grid search radius in degree (default: CDO_GRIDSEARCH_RADIUS=180).",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp RemapstatHelp = {
    "NAME",
    "    remapmin, remapmax, remaprange, remapsum, remapmean, remapavg, remapstd, remapstd1, remapvar,",
    "    remapvar1, remapskew, remapkurt, remapmedian - Remaps source points to target cells",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module maps source points to target cells by calculating a statistical value from the source",
    "    points.  Each target cell contains the statistical value from all source points within that target",
    "    cell.  If there are no source points within a target cell, it gets a missing value.  Depending on",
    "    the chosen operator the minimum, maximum, range, sum, average, variance, standard deviation,",
    "    skewness, kurtosis or median of source points is computed.",
    "",
    "OPERATORS",
    "",
    "    remapmin",
    "           Remap minimum",
    "",
    "           Minimum value of the source points.",
    "",
    "    remapmax",
    "           Remap maximum",
    "",
    "           Maximum value of the source points.",
    "",
    "    remaprange",
    "           Remap range",
    "",
    "           Range (max-min value) of the source points.",
    "",
    "    remapsum",
    "           Remap sum",
    "",
    "           Sum of the source points.",
    "",
    "    remapmean",
    "           Remap mean",
    "",
    "           Mean of the source points.",
    "",
    "    remapavg",
    "           Remap average",
    "",
    "           Average of the source points.",
    "",
    "    remapvar",
    "           Remap variance",
    "",
    "           Variance of the source points. Normalize by n.",
    "",
    "    remapvar1",
    "           Remap variance (n-1)",
    "",
    "           Variance of the source points. Normalize by (n-1).",
    "",
    "    remapstd",
    "           Remap standard deviation",
    "",
    "           Standard deviation of the source points. Normalize by n.",
    "",
    "    remapstd1",
    "           Remap standard deviation (n-1)",
    "",
    "           Standard deviation of the source points. Normalize by (n-1).",
    "",
    "    remapskew",
    "           Remap skewness",
    "",
    "           Skewness of the source points.",
    "",
    "    remapkurt",
    "           Remap kurtosis",
    "",
    "           Kurtosis of the source points.",
    "",
    "    remapmedian",
    "           Remap median",
    "",
    "           Median of the source points.",
    "",
    "PARAMETERS",
    "",
    "    grid (STRING)",
    "           Target grid description file or name",
    "",
    "EXAMPLE",
    "    To compute the mean over source points within the taget cells, use:",
    "",
    "       cdo remapmean,<targetgrid> infile outfile",
    "",
    "    If some of the target cells contain missing values, use the Operator setmisstonn to fill these",
    "    missing values with the nearest neighbor cell:",
    "",
    "       cdo setmisstonn -remapmean,<targetgrid> infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ReplaceHelp = {
    "NAME",
    "    replace - Replace variables",
    "",
    "SYNOPSIS",
    "    cdo  replace  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This operator replaces variables in infile1 by variables from infile2 and write the result to",
    "    outfile. Both input datasets need to have the same number of timesteps.  All variable names may",
    "    only occur once!",
    "",
    "EXAMPLE",
    "    Assume the first input dataset infile1 has three variables with the names geosp, t and tslm1 and",
    "    the second input dataset infile2 has only the variable tslm1.  To replace the variable tslm1 in",
    "    infile1 by tslm1 from infile2 use:",
    "",
    "       cdo replace infile1 infile2 outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ReplacevaluesHelp = {
    "NAME",
    "    setvals, setrtoc, setrtoc2 - Replace data values",
    "",
    "SYNOPSIS",
    "    cdo  setvals,oldval,newval  infile outfile",
    "",
    "    cdo  setrtoc,rmin,rmax,c  infile outfile",
    "",
    "    cdo  setrtoc2,rmin,rmax,c,c2  infile outfile",
    "",
    "DESCRIPTION",
    "    This module replaces old variable values with new values, depending on the operator.",
    "",
    "OPERATORS",
    "",
    "    setvals",
    "           Set list of old values to new values",
    "",
    "           Supply a list of n pairs of old and new values.",
    "",
    "    setrtoc",
    "           Set range to constant",
    "",
    "                      / c      if i(t,x) GE rmin AND i(t,x) LE rmax",
    "              o(t,x) =",
    "                      \\ i(t,x) if i(t,x) LT rmin AND i(t,x) GT rmax",
    "",
    "    setrtoc2",
    "           Set range to constant others to constant2",
    "",
    "                      / c      if i(t,x) GE rmin AND i(t,x) LE rmax",
    "              o(t,x) =",
    "                      \\ c2     if i(t,x) LT rmin AND i(t,x) GT rmax",
    "",
    "PARAMETERS",
    "",
    "    oldval,newval,… (FLOAT)",
    "           Pairs of old and new values",
    "",
    "    rmin (FLOAT)",
    "           Lower bound",
    "",
    "    rmax (FLOAT)",
    "           Upper bound",
    "",
    "    c (FLOAT)",
    "           New value - inside range",
    "",
    "    c2 (FLOAT)",
    "           New value - outside range",
    "",
    "AUTHOR",
    "    Etienne Tourigny",
    "",
};

const CdoHelp RhopotHelp = {
    "NAME",
    "    rhopot - Calculates potential density",
    "",
    "SYNOPSIS",
    "    cdo  rhopot[,pressure]  infile outfile",
    "",
    "DESCRIPTION",
    "    This is a special operator for the post processing of the ocean and sea ice model [MPIOM].  It",
    "    calculates the sea water potential density (name=rhopoto; code=18). Required input fields are sea",
    "    water in-situ temperature (name=to; code=20) and sea water salinity (name=sao; code=5).  Pressure",
    "    is calculated from the level information or can be specified by the optional parameter.",
    "",
    "PARAMETERS",
    "",
    "    pressure (FLOAT)",
    "           Pressure in bar (constant value assigned to all levels)",
    "",
    "EXAMPLE",
    "    To compute the sea water potential density from the potential temperature use this operator in",
    "    combination with adisit:",
    "",
    "       cdo rhopot -adisit infile outfile",
    "",
};

const CdoHelp RotuvHelp = {
    "NAME",
    "    rotuvb - Backward wind rotation",
    "",
    "SYNOPSIS",
    "    cdo  rotuvb,u,v[, …]  infile outfile",
    "",
    "DESCRIPTION",
    "    This is a special operator for datasets with wind components on a rotated grid, e.g. data from the",
    "    regional model [REMO]. It performs a backward transformation of velocity components U and V from a",
    "    rotated spherical system to a geographical system.",
    "",
    "PARAMETERS",
    "",
    "    u,v (STRING)",
    "           Pairs of zonal and meridional velocity components (use variable names or code numbers)",
    "",
    "NOTE",
    "    This is a specific implementation for data from the REMO model, it may not work with data from",
    "    other sources.",
    "",
    "EXAMPLE",
    "    To transform the u and v velocity of a dataset from a rotated spherical system to a geographical",
    "    system use:",
    "",
    "       cdo rotuvb,u,v infile outfile",
    "",
};

const CdoHelp RunpctlHelp = {
    "NAME",
    "    runpctl - Running percentile",
    "",
    "SYNOPSIS",
    "    cdo  runpctl,pn,nts  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes running percentiles over a selected number of timesteps in infile.  The time",
    "    of outfile is determined by the time in the middle of all contributing timesteps of infile.  This",
    "    can be change with the CDO option –timestat_date <first|middle|last>.",
    "",
    "    o(t+(nts-1)/2,x) = pth percentile {i(t,x), i(t+1,x), …, i(t+nts-1,x)}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "    nts (INTEGER)",
    "           Number of timesteps",
    "",
    "EXAMPLE",
    "    To compute the running 50th percentile (median) over 9 timesteps use:",
    "",
    "       cdo runpctl,50,9 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp RunstatHelp = {
    "NAME",
    "    runmin, runmax, runrange, runsum, runmean, runavg, runstd, runstd1, runvar, runvar1 - Running",
    "    statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,nts  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes running statistical values over a selected number of timesteps. Depending on",
    "    the chosen operator the minimum, maximum, range, sum, average, variance or standard deviation of a",
    "    selected number of consecutive timesteps read from infile is written to outfile.  The time of",
    "    outfile is determined by the time in the middle of all contributing timesteps of infile.  This can",
    "    be change with the CDO option –timestat_date <first|middle|last>.",
    "",
    "OPERATORS",
    "",
    "    runmin Running minimum",
    "",
    "           o(t+(nts-1)/2,x) = min{i(t,x), i(t+1,x), …, i(t+nts-1,x)}",
    "",
    "    runmax Running maximum",
    "",
    "           o(t+(nts-1)/2,x) = max{i(t,x), i(t+1,x), …, i(t+nts-1,x)}",
    "",
    "    runrange",
    "           Running range",
    "",
    "           o(t+(nts-1)/2,x) = range{i(t,x), i(t+1,x), …, i(t+nts-1,x)}",
    "",
    "    runsum Running sum",
    "",
    "           o(t+(nts-1)/2,x) = sum{i(t,x), i(t+1,x), …, i(t+nts-1,x)}",
    "",
    "    runmean",
    "           Running mean",
    "",
    "           o(t+(nts-1)/2,x) = mean{i(t,x), i(t+1,x), …, i(t+nts-1,x)}",
    "",
    "    runavg Running average",
    "",
    "           o(t+(nts-1)/2,x) = avg{i(t,x), i(t+1,x), …, i(t+nts-1,x)}",
    "",
    "    runvar Running variance",
    "",
    "           Normalize by n.",
    "",
    "           o(t+(nts-1)/2,x) = var{i(t,x), i(t+1,x), …, i(t+nts-1,x)}",
    "",
    "    runvar1",
    "           Running variance (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "           o(t+(nts-1)/2,x) = var1{i(t,x), i(t+1,x), …, i(t+nts-1,x)}",
    "",
    "    runstd Running standard deviation",
    "",
    "           Normalize by n.",
    "",
    "           o(t+(nts-1)/2,x) = std{i(t,x), i(t+1,x), …, i(t+nts-1,x)}",
    "",
    "    runstd1",
    "           Running standard deviation (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "           o(t+(nts-1)/2,x) = std1{i(t,x), i(t+1,x), …, i(t+nts-1,x)}",
    "",
    "PARAMETERS",
    "",
    "    nts (INTEGER)",
    "           Number of timesteps",
    "",
    "EXAMPLE",
    "    To compute the running mean over 9 timesteps use:",
    "",
    "       cdo runmean,9 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SamplegridHelp = {
    "NAME",
    "    samplegrid - Resample grid cells",
    "",
    "SYNOPSIS",
    "    cdo  samplegrid,factor  infile outfile",
    "",
    "DESCRIPTION",
    "    This is a special operator for resampling the horizontal grid.  No interpolation takes place.",
    "    Resample factor=2 means every second grid point is removed.  Only rectilinear and curvilinear",
    "    source grids are supported by this operator.",
    "",
    "PARAMETERS",
    "",
    "    factor (INTEGER)",
    "           Resample factor, typically 2, which will half the resolution",
    "",
    "AUTHOR",
    "    Michal Koutek",
    "",
};

const CdoHelp SeaspctlHelp = {
    "NAME",
    "    seaspctl - Seasonal percentile",
    "",
    "SYNOPSIS",
    "    cdo  seaspctl,pn  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps in infile1 of the same season.  The",
    "    algorithm uses histograms with minimum and maximum bounds given in infile2 and infile3,",
    "    respectively. The default number of histogram bins is 101. The default can be overridden by",
    "    defining the environment variable CDO_PCTL_NBINS. The files infile2 and infile3 should be the",
    "    result of corresponding seasmin and seasmax operations, respectively.  The time of outfile is",
    "    determined by the time in the middle of all contributing timesteps of infile1.  This can be change",
    "    with the CDO option –timestat_date <first|middle|last>.  Be careful about the first and the last",
    "    output timestep, they may be incorrect values if the seasons have incomplete timesteps.",
    "",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "",
    "    o(t,x) = pth percentile {i(t’,x), t1<=t’<=tn}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "EXAMPLE",
    "    To compute the seasonal 90th percentile of a time series use:",
    "",
    "       cdo seasmin infile minfile",
    "       cdo seasmax infile maxfile",
    "       cdo seaspctl,90 infile minfile maxfile outfile",
    "",
    "    Or shorter using operator piping:",
    "",
    "       cdo seaspctl,90 infile -seasmin infile -seasmax infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SeasstatHelp = {
    "NAME",
    "    seasmin, seasmax, seasrange, seassum, seasmean, seasavg, seasstd, seasstd1, seasvar, seasvar1 -",
    "    Seasonal statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same meteorological season.",
    "    Depending on the chosen operator the minimum, maximum, range, sum, average, variance or standard",
    "    deviation of timesteps of the same season is written to outfile.  The time of outfile is",
    "    determined by the time in the middle of all contributing timesteps of infile.  This can be change",
    "    with the CDO option –timestat_date <first|middle|last>.  Be careful about the first and the last",
    "    output timestep, they may be incorrect values if the seasons have incomplete timesteps.",
    "",
    "OPERATORS",
    "",
    "    seasmin",
    "           Seasonal minimum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "",
    "           o(t,x) = min{i(t’,x), t1<=t’<=tn}",
    "",
    "    seasmax",
    "           Seasonal maximum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "",
    "           o(t,x) = max{i(t’,x), t1<=t’<=tn}",
    "",
    "    seasrange",
    "           Seasonal range",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "",
    "           o(t,x) = range{i(t’,x), t1<=t’<=tn}",
    "",
    "    seassum",
    "           Seasonal sum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "",
    "           o(t,x) = sum{i(t’,x), t1<=t’<=tn}",
    "",
    "    seasmean",
    "           Seasonal mean",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "",
    "           o(t,x) = mean{i(t’,x), t1<=t’<=tn}",
    "",
    "    seasavg",
    "           Seasonal average",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:",
    "",
    "           o(t,x) = avg{i(t’,x), t1<=t’<=tn}",
    "",
    "    seasvar",
    "           Seasonal variance",
    "",
    "           Normalize by n.  For every adjacent sequence t_1, ...,t_n of timesteps of the same season",
    "           it is:",
    "",
    "           o(t,x) = var{i(t’,x), t1<=t’<=tn}",
    "",
    "    seasvar1",
    "           Seasonal variance (n-1)",
    "",
    "           Normalize by (n-1).  For every adjacent sequence t_1, ...,t_n of timesteps of the same",
    "           season it is:",
    "",
    "           o(t,x) = var1{i(t’,x), t1<=t’<=tn}",
    "",
    "    seasstd",
    "           Seasonal standard deviation",
    "",
    "           Normalize by n.  For every adjacent sequence t_1, ...,t_n of timesteps of the same season",
    "           it is:",
    "",
    "           o(t,x) = std{i(t’,x), t1<=t’<=tn}",
    "",
    "    seasstd1",
    "           Seasonal standard deviation (n-1)",
    "",
    "           Normalize by (n-1).  For every adjacent sequence t_1, ...,t_n of timesteps of the same",
    "           season it is:",
    "",
    "           o(t,x) = std1{i(t’,x), t1<=t’<=tn}",
    "",
    "EXAMPLE",
    "    To compute the seasonal mean of a time series use:",
    "",
    "       cdo seasmean infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SelboxHelp = {
    "NAME",
    "    sellonlatbox, selindexbox - Select a box",
    "",
    "SYNOPSIS",
    "    cdo  sellonlatbox,lon1,lon2,lat1,lat2  infile outfile",
    "",
    "    cdo  selindexbox,idx1,idx2,idy1,idy2  infile outfile",
    "",
    "DESCRIPTION",
    "    Selects grid cells inside a lon/lat or index box.",
    "",
    "OPERATORS",
    "",
    "    sellonlatbox",
    "           Select a longitude/latitude box",
    "",
    "           Selects grid cells inside a lon/lat box. The user must specify the longitude and latitude",
    "           of the edges of the box.  Only those grid cells are considered whose grid center lies",
    "           within the lon/lat box.  For rotated lon/lat grids the parameters must be specified in",
    "           rotated coordinates.",
    "",
    "    selindexbox",
    "           Select an index box",
    "",
    "           Selects grid cells within an index box. The user must specify the indices of the edges of",
    "           the box.  The index of the left edge can be greater then the one of the right edge. Use",
    "           negative indexing to start from the end. The input grid must be a regular lon/lat or a 2D",
    "           curvilinear grid.",
    "",
    "PARAMETERS",
    "",
    "    lon1 (FLOAT)",
    "           Western longitude in degrees",
    "",
    "    lon2 (FLOAT)",
    "           Eastern longitude in degrees",
    "",
    "    lat1 (FLOAT)",
    "           Southern or northern latitude in degrees",
    "",
    "    lat2 (FLOAT)",
    "           Northern or southern latitude in degrees",
    "",
    "    idx1 (INTEGER)",
    "           Index of first longitude (1 - nlon)",
    "",
    "    idx2 (INTEGER)",
    "           Index of last longitude (1 - nlon)",
    "",
    "    idy1 (INTEGER)",
    "           Index of first latitude (1 - nlat)",
    "",
    "    idy2 (INTEGER)",
    "           Index of last latitude (1 - nlat)",
    "",
    "EXAMPLE",
    "    To select the region with the longitudes from 30W to 60E and latitudes from 30N to 80N from all",
    "    input fields use:",
    "",
    "       cdo sellonlatbox,-30,60,30,80 infile outfile",
    "",
    "    If the input dataset has fields on a regular Gaussian F16 grid, the same box can be selected with",
    "    selindexbox by:",
    "",
    "       cdo selindexbox,60,11,3,11 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SelectHelp = {
    "NAME",
    "    select, delete - Select fields",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infiles outfile",
    "",
    "DESCRIPTION",
    "    This module selects some fields from infiles and writes them to outfile.  infiles is an arbitrary",
    "    number of input files. All input files need to have the same structure with the same variables on",
    "    different timesteps.  The fields selected depends on the chosen parameters. Parameter is a",
    "    comma-separated list of “key=value” pairs. A range of integer values can be specified by",
    "    first/last[/inc].  Wildcards are supported for string values.",
    "",
    "OPERATORS",
    "",
    "    select Select fields",
    "",
    "           Selects all fields with parameters in a user given list.",
    "",
    "    delete Delete fields",
    "",
    "           Deletes all fields with parameters in a user given list.",
    "",
    "PARAMETERS",
    "",
    "    name (STRING)",
    "           Comma-separated list of variable names.",
    "",
    "    param (STRING)",
    "           Comma-separated list of parameter identifiers.",
    "",
    "    code (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of code numbers.",
    "",
    "    level (FLOAT)",
    "           Comma-separated list of vertical levels.",
    "",
    "    levrange (FLOAT)",
    "           First and last value of the level range.",
    "",
    "    levidx (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of index of levels.",
    "",
    "    zaxisname (STRING)",
    "           Comma-separated list of zaxis names.",
    "",
    "    zaxisnum (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of zaxis numbers.",
    "",
    "    ltype (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of GRIB level types.",
    "",
    "    gridname (STRING)",
    "           Comma-separated list of grid names.",
    "",
    "    gridnum (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of grid numbers.",
    "",
    "    steptype (STRING)",
    "           Comma-separated list of timestep types (constant|avg|accum|min|max|range|diff|sum)",
    "",
    "    date (STRING)",
    "           Comma-separated list of dates (format: YYYY-MM-DDThh:mm:ss).",
    "",
    "    startdate (STRING)",
    "           Start date (format: YYYY-MM-DDThh:mm:ss).",
    "",
    "    enddate (STRING)",
    "           End date (format: YYYY-MM-DDThh:mm:ss).",
    "",
    "    minute (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of minutes.",
    "",
    "    hour (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of hours.",
    "",
    "    day (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of days.",
    "",
    "    month (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of months.",
    "",
    "    season (STRING)",
    "           Comma-separated list of seasons (substring of DJFMAMJJASOND or ANN).",
    "",
    "    year (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of years.",
    "",
    "    dom (STRING)",
    "           Comma-separated list of the day of month (e.g. 29feb).",
    "",
    "    timestep (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of timesteps. Negative values select",
    "           timesteps from the end (NetCDF only).",
    "",
    "    timestep_of_year (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of timesteps of year.",
    "",
    "    timestepmask (STRING)",
    "           Read timesteps from a mask file.",
    "",
    "EXAMPLE",
    "    Assume you have 3 inputfiles. Each inputfile contains the same variables for a different time",
    "    period.  To select the variable T,U and V on the levels 200, 500 and 850 from all 3 input files,",
    "    use:",
    "",
    "       cdo select,name=T,U,V,level=200,500,850 infile1 infile2 infile3 outfile",
    "",
    "    To remove the February 29th use:",
    "",
    "       cdo delete,dom=29feb infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SelgridcellHelp = {
    "NAME",
    "    selgridcell, delgridcell - Select grid cells",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,indices  infile outfile",
    "",
    "DESCRIPTION",
    "    The operator selects grid cells of all fields from infile. The user must specify the index of each",
    "    grid cell.  The resulting grid in outfile is unstructured.",
    "",
    "OPERATORS",
    "",
    "    selgridcell",
    "           Select grid cells",
    "",
    "    delgridcell",
    "           Delete grid cells",
    "",
    "PARAMETERS",
    "",
    "    indices (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of indices",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SelmultiHelp = {
    "NAME",
    "    selmulti, delmulti, changemulti - Select multiple fields via GRIB1 parameters",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module selects multiple fields from infile and writes them to outfile.",
    "    selection-specification is a filename or in-place string with the selection specification.  Each",
    "    selection-specification has the following compact notation format:",
    "",
    "       <type>(parameters; leveltype(s); levels)",
    "",
    "    type : sel for select or del for delete (optional)",
    "",
    "    parameters : GRIB1 parameter code number",
    "",
    "    leveltype : GRIB1 level type",
    "",
    "    levels : value of each level",
    "",
    "    Examples:",
    "",
    "       (1; 103; 0)",
    "       (33,34; 105; 10)",
    "       (11,17; 105; 2)",
    "       (71,73,74,75,61,62,65,117,67,122,121,11,131,66,84,111,112; 105; 0)",
    "",
    "    The following descriptive notation can also be used for selection specification from a file:",
    "",
    "       SELECT/DELETE, PARAMETER=parameters, LEVTYPE=leveltye(s), LEVEL=levels",
    "",
    "    Examples:",
    "",
    "       SELECT, PARAMETER=1, LEVTYPE=103, LEVEL=0",
    "       SELECT, PARAMETER=33/34, LEVTYPE=105, LEVEL=10",
    "       SELECT, PARAMETER=11/17, LEVTYPE=105, LEVEL=2",
    "       SELECT, PARAMETER=71/73/74/75/61/62/65/117/67/122, LEVTYPE=105, LEVEL=0",
    "       DELETE, PARAMETER=128, LEVTYPE=109, LEVEL=*",
    "",
    "    The following will convert Pressure from Pa into hPa; Temp from Kelvin to Celsius:",
    "",
    "       SELECT, PARAMETER=1, LEVTYPE= 103, LEVEL=0, SCALE=0.01",
    "       SELECT, PARAMETER=11, LEVTYPE=105, LEVEL=2, OFFSET=273.15",
    "",
    "    If SCALE and/or OFFSET are defined, then the data values are scaled as SCALE*(VALUE-OFFSET).",
    "",
    "OPERATORS",
    "",
    "    selmulti",
    "           Select multiple fields",
    "",
    "    delmulti",
    "           Delete multiple fields",
    "",
    "    changemulti",
    "           Change identification of multiple fields",
    "",
    "EXAMPLE",
    "    Change ECMWF GRIB code of surface pressure to Hirlam notation:",
    "",
    "       cdo changemulti,'{(134;1;*|1;105;*)}' infile outfile",
    "",
    "AUTHOR",
    "    Michal Koutek",
    "",
};

const CdoHelp SelregionHelp = {
    "NAME",
    "    selregion, selcircle - Select horizontal regions",
    "",
    "SYNOPSIS",
    "    cdo  selregion,regions  infile outfile",
    "",
    "    cdo  selcircle,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    Selects all grid cells with the center point inside user defined regions or a circle.  The",
    "    resulting grid is unstructured.",
    "",
    "OPERATORS",
    "",
    "    selregion",
    "           Select cells inside regions",
    "",
    "           Selects all grid cells with the center point inside the regions.  Regions can be defined by",
    "           the user via an ASCII file.  Each region consists of the geographic coordinates of a",
    "           polygon.  Each line of a polygon description file contains the longitude and latitude of",
    "           one point.  Each polygon description file can contain one or more polygons separated by a",
    "           line with the character &.",
    "",
    "           Predefined regions of countries can be specified via the country codes.  A country is",
    "           specified with dcw:<CountryCode>. Country codes can be combined with the plus sign.",
    "",
    "    selcircle",
    "           Select cells inside a circle",
    "",
    "           Selects all grid cells with the center point inside a circle. The circle is described by",
    "           geographic coordinates of the center and the radius of the circle (Parameter: lon, lat,",
    "           radius).",
    "",
    "PARAMETERS",
    "",
    "    regions (STRING)",
    "           Comma-separated list of ASCII formatted files with different regions",
    "",
    "    lon (FLOAT)",
    "           Longitude of the center of the circle in degrees, default lon=0.0",
    "",
    "    lat (FLOAT)",
    "           Latitude of the center of the circle in degrees, default lat=0.0",
    "",
    "    radius (STRING)",
    "           Radius of the circle, default radius=1deg (units: deg, rad, km, m)",
    "",
    "EXAMPLE",
    "    To select all grid cells of a country use the country code with data from the Digital Chart of the",
    "    World.  Here is an example for Spain with the country code ES:",
    "",
    "       cdo selregion,dcw:ES infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SelsurfaceHelp = {
    "NAME",
    "    bottomvalue, topvalue, isosurface - Extract surface",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "    cdo  isosurface,isovalue  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes a surface from all 3D variables. The result is a horizontal 2D field.",
    "",
    "OPERATORS",
    "",
    "    isosurface",
    "           Extract isosurface",
    "",
    "           This operator computes an isosurface. The value of the isosurfce is specified by the",
    "           parameter isovalue.  The isosurface is calculated by linear interpolation between two",
    "           layers.",
    "",
    "    bottomvalue",
    "           Extract bottom level",
    "",
    "           This operator selects the valid values at the bottom level.  The NetCDF CF compliant",
    "           attribute positive is used to determine where top and bottom are.  If this attribute is",
    "           missing, low values are bottom and high values are top.",
    "",
    "    topvalue",
    "           Extract top level",
    "",
    "           This operator selects the valid values at the top level.  The NetCDF CF compliant attribute",
    "           positive is used to determine where top and bottom are.  If this attribute is missing, low",
    "           values are bottom and high values are top.",
    "",
    "PARAMETERS",
    "",
    "    isovalue (FLOAT)",
    "           Isosurface value",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SeltimeHelp = {
    "NAME",
    "    seltimestep, seltime, selhour, selday, selmonth, selyear, selseason, seldate, selsmon - Select",
    "    timesteps",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module selects user specified timesteps from infile and writes them to outfile.  The",
    "    timesteps selected depends on the chosen operator and the parameters. A range of integer values",
    "    can be specified by first/last[/inc].",
    "",
    "OPERATORS",
    "",
    "    seltimestep",
    "           Select timesteps",
    "",
    "           Selects all timesteps with a timestep in a user given list or range (Parameter: timesteps).",
    "",
    "    seltime",
    "           Select times",
    "",
    "           Selects all timesteps with a time in a user given list or range (Parameter: times).",
    "",
    "    selhour",
    "           Select hours",
    "",
    "           Selects all timesteps with a hour in a user given list or range (Parameter: hours).",
    "",
    "    selday Select days",
    "",
    "           Selects all timesteps with a day in a user given list or range (Parameter: days).",
    "",
    "    selmonth",
    "           Select months",
    "",
    "           Selects all timesteps with a month in a user given list or range (Parameter: months).",
    "",
    "    selyear",
    "           Select years",
    "",
    "           Selects all timesteps with a year in a user given list or range (Parameter: years).",
    "",
    "    selseason",
    "           Select seasons",
    "",
    "           Selects all timesteps with a month of a season in a user given list (Parameter: seasons).",
    "",
    "    seldate",
    "           Select dates",
    "",
    "           Selects all timesteps with a date in a user given range (Parameter: startdate [enddate]).",
    "",
    "    selsmon",
    "           Select single month",
    "",
    "           Selects a month and optional an arbitrary number of timesteps before and after this month",
    "           (Parameter: month [nts1] [nts2]).",
    "",
    "PARAMETERS",
    "",
    "    timesteps (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of timesteps. Negative values select",
    "           timesteps from the end (NetCDF only).",
    "",
    "    times (STRING)",
    "           Comma-separated list of times (format hh:mm:ss).",
    "",
    "    hours (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of hours.",
    "",
    "    days (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of days.",
    "",
    "    months (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of months.",
    "",
    "    years (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of years.",
    "",
    "    seasons (STRING)",
    "           Comma-separated list of seasons (substring of DJFMAMJJASOND or ANN).",
    "",
    "    startdate (STRING)",
    "           Start date (format: YYYY-MM-DDThh:mm:ss).",
    "",
    "    enddate (STRING)",
    "           End date (format: YYYY-MM-DDThh:mm:ss) [default: startdate].",
    "",
    "    nts1 (INTEGER)",
    "           Number of timesteps before the selected month [default: 0].",
    "",
    "    nts2 (INTEGER)",
    "           Number of timesteps after the selected month [default: nts1].",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SeltimeidxHelp = {
    "NAME",
    "    seltimeidx - Select timestep by index",
    "",
    "SYNOPSIS",
    "    cdo  seltimeidx  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Selects field elements from infile2 according to a timestep index from infile1.  The index of the",
    "    timestep in infile1 should be the result of corresponding timminidx or timmaxidx operations,",
    "    respectively.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SelvarHelp = {
    "NAME",
    "    selparam, delparam, selcode, delcode, selname, delname, selstdname, sellevel, sellevidx, selgrid,",
    "    selzaxis, selzaxisname, selltype, seltabnum - Select fields",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module selects some fields from infile and writes them to outfile.  The fields selected",
    "    depends on the chosen operator and the parameters. A range of integer values can be specified by",
    "    first/last[/inc].",
    "",
    "OPERATORS",
    "",
    "    selparam",
    "           Select parameters by identifier",
    "",
    "           Selects all fields with parameter identifiers in a user given list (Parameter:",
    "           identifiers).",
    "",
    "    delparam",
    "           Delete parameters by identifier",
    "",
    "           Deletes all fields with parameter identifiers in a user given list (Parameter:",
    "           identifiers).",
    "",
    "    selcode",
    "           Select parameters by code number",
    "",
    "           Selects all fields with code numbers in a user given list or range (Parameter: codes).",
    "",
    "    delcode",
    "           Delete parameters by code number",
    "",
    "           Deletes all fields with code numbers in a user given list or range (Parameter: codes).",
    "",
    "    selname",
    "           Select parameters by name",
    "",
    "           Selects all fields with parameter names in a user given list (Parameter: names).",
    "",
    "    delname",
    "           Delete parameters by name",
    "",
    "           Deletes all fields with parameter names in a user given list (Parameter: names).",
    "",
    "    selstdname",
    "           Select parameters by standard name",
    "",
    "           Selects all fields with standard names in a user given list (Parameter: stdnames).",
    "",
    "    sellevel",
    "           Select levels",
    "",
    "           Selects all fields with levels in a user given list (Parameter: levels).",
    "",
    "    sellevidx",
    "           Select levels by index",
    "",
    "           Selects all fields with index of levels in a user given list or range (Parameter: levidx).",
    "",
    "    selgrid",
    "           Select grids",
    "",
    "           Selects all fields with grids in a user given list (Parameter: grids).",
    "",
    "    selzaxis",
    "           Select z-axes",
    "",
    "           Selects all fields with z-axes in a user given list (Parameter: zaxes).",
    "",
    "    selzaxisname",
    "           Select z-axes by name",
    "",
    "           Selects all fields with z-axis names in a user given list (Parameter: zaxisnames).",
    "",
    "    selltype",
    "           Select GRIB level types",
    "",
    "           Selects all fields with GRIB level type in a user given list or range (Parameter: ltypes).",
    "",
    "    seltabnum",
    "           Select parameter table numbers",
    "",
    "           Selects all fields with parameter table numbers in a user given list or range (Parameter:",
    "           tabnums).",
    "",
    "PARAMETERS",
    "",
    "    identifier (STRING)",
    "           Comma-separated list of parameter identifiers.",
    "",
    "    codes (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of code numbers.",
    "",
    "    names (STRING)",
    "           Comma-separated list of variable names.",
    "",
    "    stdnames (STRING)",
    "           Comma-separated list of standard names.",
    "",
    "    levels (FLOAT)",
    "           Comma-separated list of vertical levels.",
    "",
    "    levidx (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of index of levels.",
    "",
    "    ltypes (INTEGER)",
    "           Comma-separated list or first/last[/inc] range of GRIB level types.",
    "",
    "    grids (STRING)",
    "           Comma-separated list of grid names or numbers.",
    "",
    "    zaxes (STRING)",
    "           Comma-separated list of z-axis types or numbers.",
    "",
    "    zaxisnames (STRING)",
    "           Comma-separated list of z-axis names.",
    "",
    "    tabnums (INTEGER)",
    "           Comma-separated list or range of parameter table numbers.",
    "",
    "EXAMPLE",
    "    Assume an input dataset has three variables with the code numbers 129, 130 and 139.  To select the",
    "    variables with the code number 129 and 139 use:",
    "",
    "       cdo selcode,129,139 infile outfile",
    "",
    "    You can also select the code number 129 and 139 by deleting the code number 130 with:",
    "",
    "       cdo delcode,130 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SelyearidxHelp = {
    "NAME",
    "    selyearidx - Select year by index",
    "",
    "SYNOPSIS",
    "    cdo  selyearidx  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Selects field elements from infile2 according to a year index from infile1.  The index of the year",
    "    in infile1 should be the result of corresponding yearminidx or yearmaxidx operations,",
    "    respectively.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SetHelp = {
    "NAME",
    "    setcodetab, setcode, setparam, setname, setstdname, setunit, setlevel, setltype, setmaxsteps - Set",
    "    field info",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module sets some field information. Depending on the chosen operator the parameter table,",
    "    code number, parameter identifier, variable name or level is set.",
    "",
    "OPERATORS",
    "",
    "    setcodetab",
    "           Set parameter code table",
    "",
    "           Sets the parameter code table for all variables (Parameter: table).",
    "",
    "    setcode",
    "           Set code number",
    "",
    "           Sets the code number for all variables to the same given value (Parameter: code).",
    "",
    "    setparam",
    "           Set parameter identifier",
    "",
    "           Sets the parameter identifier of the first variable (Parameter: param).",
    "",
    "    setname",
    "           Set variable name",
    "",
    "           Sets the name of the first variable (Parameter: name).",
    "",
    "    setstdname",
    "           Set standard name",
    "",
    "           Sets the standard name of the first variable (Parameter: stdname).",
    "",
    "    setunit",
    "           Set variable unit",
    "",
    "           Sets the unit of the first variable (Parameter: unit).",
    "",
    "    setlevel",
    "           Set level",
    "",
    "           Sets the first level of all variables (Parameter: level).",
    "",
    "    setltype",
    "           Set GRIB level type",
    "",
    "           Sets the GRIB level type of all variables (Parameter: ltype).",
    "",
    "    setmaxsteps",
    "           Set max timesteps",
    "",
    "           Sets maximum number of timesteps (Parameter: maxsteps).",
    "",
    "PARAMETERS",
    "",
    "    table (STRING)",
    "           Parameter table file or name",
    "",
    "    code (INTEGER)",
    "           Code number",
    "",
    "    param (STRING)",
    "           Parameter identifier (GRIB1: code[.tabnum]; GRIB2: num[.cat[.dis]])",
    "",
    "    name (STRING)",
    "           Variable name",
    "",
    "    stdname (STRING)",
    "           Standard name",
    "",
    "    level (FLOAT)",
    "           New level",
    "",
    "    ltype (INTEGER)",
    "           GRIB level type",
    "",
    "    maxsteps (INTEGER)",
    "           Maximum number of timesteps",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SetattributeHelp = {
    "NAME",
    "    setattribute, delattribute - Set attributes",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator sets or deletes attributes of a dataset and writes the result to outfile.  The new",
    "    attributes are only available in outfile if the file format supports attributes.",
    "",
    "    Each attribute has the following structure:",
    "",
    "    [var_nm@]att_nm[:s|d|i]=[att_val | {[var_nm@]att_nm}]",
    "",
    "                              ┌────────┬────────────────────────────────────┐",
    "                              │var_nm  │ Variable name (optional). Example: │",
    "                              │        │ pressure                           │",
    "                              ├────────┼────────────────────────────────────┤",
    "                              │att_nm  │ Attribute name. Example: units     │",
    "                              ├────────┼────────────────────────────────────┤",
    "                              │att_val │ Comma-separated list of attribute  │",
    "                              │        │ values. Example: pascal            │",
    "                              └────────┴────────────────────────────────────┘",
    "    The value of var_nm is the name of the variable containing the attribute (named att_nm) that you",
    "    want to set. Use wildcards to set the attribute att_nm to more than one variable.  A value of",
    "    var_nm of ‘*’ will set the attribute att_nm to all data variables.  If var_nm is missing then",
    "    att_nm refers to a global attribute.",
    "",
    "    The value of att_nm is the name of the attribute you want to set. For each attribute a string",
    "    (att_nm:s), a double (att_nm:d) or an integer (att_nm:i) type can be defined. By default the",
    "    native type is set.",
    "",
    "    The value of att_val is the contents of the attribute att_nm. att_val may be a single value or",
    "    one-dimensional array of elements. The type and the number of elements of an attribute will be",
    "    detected automatically from the contents of the values. An already existing attribute att_nm will",
    "    be overwritten or it will be removed if att_val is omitted. Alternatively, the values of an",
    "    existing attribute can be copied.  This attribute must then be enclosed in curly brackets.",
    "",
    "    A special meaning has the attribute name FILE. If this is the 1st attribute then all attributes",
    "    are read from a file specified in the value of att_val.",
    "",
    "    Some NetCDF attributes can’t be deleted. Here is a incomplete list: missing_value, formula_terms,",
    "    cell_measures, coordinates, grid_mapping, valid_range, …",
    "",
    "OPERATORS",
    "",
    "    setattribute",
    "           Set attributes",
    "",
    "    delattribute",
    "           Delete attributes",
    "",
    "PARAMETERS",
    "",
    "    attributes (STRING)",
    "           Comma-separated list of attributes.",
    "",
    "NOTE",
    "    Attributes are evaluated by CDO when opening infile. Therefor the result of this operator is not",
    "    available for other operators when this operator is used in chaining operators.",
    "",
    "EXAMPLE",
    "    To set the units of the variable pressure to pascal use:",
    "",
    "       cdo  setattribute,pressure@units=pascal  infile  outfile",
    "",
    "    To set the global text attribute “my_att” to “my contents”, use:",
    "",
    "       cdo  setattribute,my_att=\"my contents\"  infile  outfile",
    "",
    "    Result of ncdump -h outfile:",
    "",
    "       netcdf outfile {",
    "       dimensions: ...",
    "",
    "       variables: ...",
    "",
    "       // global attributes:",
    "                       :my_att = \"my contents\" ;",
    "       }",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SetboxHelp = {
    "NAME",
    "    setclonlatbox, setcindexbox - Set a box to constant",
    "",
    "SYNOPSIS",
    "    cdo  setclonlatbox,c,lon1,lon2,lat1,lat2  infile outfile",
    "",
    "    cdo  setcindexbox,c,idx1,idx2,idy1,idy2  infile outfile",
    "",
    "DESCRIPTION",
    "    Sets a box of the rectangularly understood field to a constant value. The elements outside the box",
    "    are untouched, the elements inside are set to the given constant. All input fields need to have",
    "    the same horizontal grid.",
    "",
    "OPERATORS",
    "",
    "    setclonlatbox",
    "           Set a longitude/latitude box to constant",
    "",
    "           Sets the values of a longitude/latitude box to a constant value. The user has to give the",
    "           longitudes and latitudes of the edges of the box.",
    "",
    "    setcindexbox",
    "           Set an index box to constant",
    "",
    "           Sets the values of an index box to a constant value. The user has to give the indices of",
    "           the edges of the box. The index of the left edge can be greater than the one of the right",
    "           edge.",
    "",
    "PARAMETERS",
    "",
    "    c (FLOAT)",
    "           Constant",
    "",
    "    lon1 (FLOAT)",
    "           Western longitude in degrees",
    "",
    "    lon2 (FLOAT)",
    "           Eastern longitude in degrees",
    "",
    "    lat1 (FLOAT)",
    "           Southern or northern latitude in degrees",
    "",
    "    lat2 (FLOAT)",
    "           Northern or southern latitude in degrees",
    "",
    "    idx1 (INTEGER)",
    "           Index of first longitude (1 - nlon)",
    "",
    "    idx2 (INTEGER)",
    "           Index of last longitude (1 - nlon)",
    "",
    "    idy1 (INTEGER)",
    "           Index of first latitude (1 - nlat)",
    "",
    "    idy2 (INTEGER)",
    "           Index of last latitude (1 - nlat)",
    "",
    "EXAMPLE",
    "    To set all values in the region with the longitudes from 120E to 90W and latitudes from 20N to 20S",
    "    to the constant value -1.23 use:",
    "",
    "       cdo setclonlatbox,-1.23,120,-90,20,-20 infile outfile",
    "",
    "    If the input dataset has fields on a regular Gaussian F16 grid, the same box can be set with",
    "    setcindexbox by:",
    "",
    "       cdo setcindexbox,-1.23,23,48,13,20 infile outfile",
    "",
    "AUTHOR",
    "    Etienne Tourigny",
    "",
};

const CdoHelp SetchunkspecHelp = {
    "NAME",
    "    setchunkspec - Specify chunking",
    "",
    "SYNOPSIS",
    "    cdo  setchunkspec,parameter  infile outfile",
    "",
    "DESCRIPTION",
    "    Specify chunking for selected variables in the output.  Chunking is available for NetCDF4 and",
    "    useful to specify the units of disk access and compression.  The filename parameter is used to",
    "    specify the file which contains the chunk specification for each variable.  The chunkspec argument",
    "    is a comma-separated string with the chunk size for the dimensions x,y,z,t.  A chunkspec must name",
    "    at least one dimension, e.g. t=<chunksize> to set the chunk size of the time dimension to",
    "    <chunksize>.",
    "",
    "    Use the CDO option –chunkspec instead of setchunkspec if all variables require the same chunks.",
    "",
    "PARAMETERS",
    "",
    "    filename (STRING)",
    "           Name of the file containing the chunk specification per variable [format:",
    "           varname=”<chunkspec>”]",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SetfilterHelp = {
    "NAME",
    "    setfilter - Specify filter",
    "",
    "SYNOPSIS",
    "    cdo  setfilter,parameter  infile outfile",
    "",
    "DESCRIPTION",
    "    Specify filter for selected variables in the output.  Filters are available for NetCDF4 and mainly",
    "    used to compress/decompress data.  NetCDF4 uses the HDF5 plugins for filter support.  To find the",
    "    HDF5 plugins, the environment variable HDF5_PLUGIN_PATH must point to the directory with the",
    "    installed plugins.  The program may terminate unexpectedly if filters are used whose plugins are",
    "    not found.",
    "",
    "    The filename parameter is used to specify the file which contains the filter specification for",
    "    each variable.  A filter specification consists of the filterId and the filter parameters.  CDO",
    "    supports multiple filters connected with ‘|’.  Here is a filter specification for bzip2 (filterId:",
    "    307) combined with szip (filterId:4): “307,9|4,32,32”.",
    "",
    "    Use the CDO option –filter instead of setfilter if all variables require the same filter.  More",
    "    information about NetCDF4 filters can be found in",
    "    https://docs.unidata.ucar.edu/netcdf-c/current/filters.html.",
    "",
    "PARAMETERS",
    "",
    "    filename (STRING)",
    "           Name of the file containing the filter specification per variable [format:",
    "           varname=”<filterspec>”]",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SetgridHelp = {
    "NAME",
    "    setgrid, setgridtype, setgridarea, setgridmask, setprojparams - Set grid information",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module modifies the metadata of the horizontal grid. Depending on the chosen operator a new",
    "    grid description is set, the coordinates are converted or the grid cell area is added.",
    "",
    "OPERATORS",
    "",
    "    setgrid",
    "           Set grid",
    "",
    "           Sets a new grid description (Parameter: grid). The input fields need to have the same grid",
    "           size as the size of the target grid description.",
    "",
    "    setgridtype",
    "           Set grid type",
    "",
    "           Sets the grid type of all input fields (Parameter: gridtype). The following grid types are",
    "           available:",
    "",
    "                              ┌─────────────┬─────────────────────────────────────┐",
    "                              │curvilinear  │ Converts a regular grid to a        │",
    "                              │             │ curvilinear grid                    │",
    "                              ├─────────────┼─────────────────────────────────────┤",
    "                              │unstructured │ Converts a regular or curvilinear   │",
    "                              │             │ grid to an unstructured grid        │",
    "                              ├─────────────┼─────────────────────────────────────┤",
    "                              │dereference  │ Dereference a reference to a grid   │",
    "                              ├─────────────┼─────────────────────────────────────┤",
    "                              │regular      │ Linear interpolation of a reduced   │",
    "                              │             │ Gaussian grid to a regular Gaussian │",
    "                              │             │ grid                                │",
    "                              ├─────────────┼─────────────────────────────────────┤",
    "                              │regularnn    │ Nearest neighbor interpolation of a │",
    "                              │             │ reduced Gaussian grid to a regular  │",
    "                              │             │ Gaussian grid                       │",
    "                              ├─────────────┼─────────────────────────────────────┤",
    "                              │lonlat       │ Converts a regular lonlat grid      │",
    "                              │             │ stored as a curvilinear grid back   │",
    "                              │             │ to a lonlat grid                    │",
    "                              ├─────────────┼─────────────────────────────────────┤",
    "                              │projection   │ Removes the geographical            │",
    "                              │             │ coordinates if projection parameter │",
    "                              │             │ available                           │",
    "                              └─────────────┴─────────────────────────────────────┘",
    "    setgridarea",
    "           Set grid cell area",
    "",
    "           Sets the grid cell area. The parameter gridarea is the path to a data file, the first field",
    "           is used as grid cell area. The input fields need to have the same grid size as the grid",
    "           cell area. The grid cell area is used to compute the weights of each grid cell if needed by",
    "           an operator, e.g. for fldmean.",
    "",
    "    setgridmask",
    "           Set grid mask",
    "",
    "           Sets the grid mask. The parameter gridmask is the path to a data file, the first field is",
    "           used as the grid mask. The input fields need to have the same grid size as the grid mask.",
    "           The grid mask is used as the target grid mask for remapping, e.g. for remapbil.",
    "",
    "    setprojparams",
    "           Set proj params",
    "",
    "           Sets the proj_params attribute of a projection. This attribute is used to compute",
    "           geographic coordinates of a projecton with the proj library (Parameter: projparams).",
    "",
    "PARAMETERS",
    "",
    "    grid (STRING)",
    "           Grid description file or name",
    "",
    "    gridtype (STRING)",
    "           Grid type (curvilinear, unstructured, regular, lonlat, projection or dereference)",
    "",
    "    gridarea (STRING)",
    "           Data file, the first field is used as grid cell area",
    "",
    "    gridmask (STRING)",
    "           Data file, the first field is used as grid mask",
    "",
    "    projparams (STRING)",
    "           Proj library parameter (e.g.:+init=EPSG:3413)",
    "",
    "EXAMPLE",
    "    Assuming a dataset has fields on a grid with 2048 elements without or with wrong grid description.",
    "    To set the grid description of all input fields to a regular Gaussian F32 grid (8192 gridpoints)",
    "    use:",
    "",
    "       cdo setgrid,F32 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SetgridcellHelp = {
    "NAME",
    "    setgridcell - Set the value of a grid cell",
    "",
    "SYNOPSIS",
    "    cdo  setgridcell,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator sets the value of the selected grid cells. The grid cells can be selected by a",
    "    comma-separated list of grid cell indices or a mask. The mask is read from a data file, which may",
    "    contain only one field. If no grid cells are selected, all values are set.",
    "",
    "PARAMETERS",
    "",
    "    value (FLOAT)",
    "           Value of the grid cell",
    "",
    "    cell (INTEGER)",
    "           Comma-separated list of grid cell indices",
    "",
    "    mask (STRING)",
    "           Name of the data file which contains the mask",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SethaloHelp = {
    "NAME",
    "    sethalo - Set the bounds of a field",
    "",
    "SYNOPSIS",
    "    cdo  sethalo,parameter  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator sets the boundary in the east, west, south and north of the rectangular understood",
    "    fields.  Positive values of the parameters increase the boundary in the selected direction.",
    "    Negative values decrease the field at the selected boundary. The new rows and columns are filled",
    "    with the missing value.  With the optional parameter value a different fill value can be used.",
    "    Global cyclic fields are filled cyclically at the east and west borders, if the fill value is not",
    "    set by the user.  All input fields need to have the same horizontal grid.",
    "",
    "PARAMETERS",
    "",
    "    east (INTEGER)",
    "           East halo",
    "",
    "    west (INTEGER)",
    "           West halo",
    "",
    "    south (INTEGER)",
    "           South halo",
    "",
    "    north (INTEGER)",
    "           North halo",
    "",
    "    value (FLOAT)",
    "           Fill value (default is the missing value)",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SetmissHelp = {
    "NAME",
    "    setmissval, setctomiss, setmisstoc, setrtomiss, setvrange, setmisstonn, setmisstodis - Set missing",
    "    value",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module sets part of a field to missing value or missing values to a constant value. Which",
    "    part of the field is set depends on the chosen operator.",
    "",
    "OPERATORS",
    "",
    "    setmissval",
    "           Set a new missing value",
    "",
    "                / newmiss   if i(t,x) EQ miss",
    "       o(t,x) =",
    "                \\ i(t,x)    if i(t,x) NE miss",
    "",
    "    setctomiss",
    "           Set constant to missing value",
    "",
    "                / miss   if i(t,x) EQ c",
    "       o(t,x) =",
    "                \\ i(t,x) if i(t,x) NE c",
    "",
    "    setmisstoc",
    "           Set missing value to constant",
    "",
    "                / c      if i(t,x) EQ miss",
    "       o(t,x) =",
    "                \\ i(t,x) if i(t,x) NE miss",
    "",
    "    setrtomiss",
    "           Set range to missing value",
    "",
    "                / miss   if i(t,x) GE rmin AND i(t,x) LE rmax",
    "       o(t,x) =",
    "                \\ i(t,x) if i(t,x) LT rmin OR  i(t,x) GT rmax",
    "",
    "    setvrange",
    "           Set valid range",
    "",
    "                / miss   if i(t,x) LT rmin OR  i(t,x) GT rmax",
    "       o(t,x) =",
    "                \\ i(t,x) if i(t,x) GE rmin AND i(t,x) LE rmax",
    "",
    "    setmisstonn",
    "           Set missing value to nearest neighbor",
    "",
    "           Set all missing values to the nearest non missing value.",
    "",
    "                / i(t,y) if i(t,x) EQ miss AND i(t,y) NE miss",
    "       o(t,x) =",
    "                \\ i(t,x) if i(t,x) NE miss",
    "",
    "    setmisstodis",
    "           Set missing value to distance-weighted average",
    "",
    "           Set all missing values to the distance-weighted average of the nearest non missing values.",
    "           The default number of nearest neighbors is 4.",
    "",
    "PARAMETERS",
    "",
    "    neighbors (INTEGER)",
    "           Number of nearest neighbors",
    "",
    "    newmiss (FLOAT)",
    "           New missing value",
    "",
    "    c (FLOAT)",
    "           Constant",
    "",
    "    rmin (FLOAT)",
    "           Lower bound",
    "",
    "    rmax (FLOAT)",
    "           Upper bound",
    "",
    "EXAMPLE",
    "    setrtomiss",
    "",
    "    Assume an input dataset has one field with temperatures in the range from 246 to 304 Kelvin.  To",
    "    set all values below 273.15 Kelvin to missing value use:",
    "",
    "       cdo setrtomiss,0,273.15 infile outfile",
    "",
    "    Result of cdo info infile:",
    "",
    "       -1 :       Date  Time    Code Level  Size  Miss :  Minimum     Mean  Maximum",
    "        1 : 1987-12-31 12:00:00 139      0  2048     0 :   246.27   276.75   303.71",
    "",
    "    Result of cdo info outfile:",
    "",
    "       -1 :       Date  Time    Code Level  Size  Miss :  Minimum     Mean  Maximum",
    "        1 : 1987-12-31 12:00:00 139      0  2048   871 :   273.16   287.08   303.71",
    "",
    "    setmisstonn",
    "",
    "    Set all missing values to the nearest non missing value:",
    "",
    "       cdo setmisstonn infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SetpartabHelp = {
    "NAME",
    "    setpartabp, setpartabn - Set parameter table",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module transforms data and metadata of infile via a parameter table and writes the result to",
    "    outfile.  A parameter table is an ASCII formatted file with a set of parameter entries for each",
    "    variable. Each new set have to start with “&parameter” and to end with “/”.",
    "",
    "    The following parameter table entries are supported:",
    "",
    "                         ┌────────────────┬─────────┬────────────────────────────┐",
    "                         │Entry           │ Type    │ Description                │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │name            │ WORD    │ Name of the variable       │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │out_name        │ WORD    │ New name of the variable   │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │param           │ WORD    │ Parameter identifier       │",
    "                         │                │         │ (GRIB1: code[.tabnum];     │",
    "                         │                │         │ GRIB2: num[.cat[.dis]])    │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │out_param       │ WORD    │ New parameter identifier   │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │type            │ WORD    │ Data type (real or double) │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │standard_name   │ WORD    │ As defined in the CF       │",
    "                         │                │         │ standard name table        │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │long_name       │ STRING  │ Describing the variable    │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │units           │ STRING  │ Specifying the units for   │",
    "                         │                │         │ the variable               │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │comment         │ STRING  │ Information concerning the │",
    "                         │                │         │ variable                   │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │cell_methods    │ STRING  │ Information concerning     │",
    "                         │                │         │ calculation of means or    │",
    "                         │                │         │ climatologies              │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │cell_measures   │ STRING  │ Indicates the names of the │",
    "                         │                │         │ variables containing cell  │",
    "                         │                │         │ areas and volumes          │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │filterspec      │ STRING  │ NetCDF4 filter             │",
    "                         │                │         │ specification              │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │missing_value   │ FLOAT   │ Specifying how missing     │",
    "                         │                │         │ data will be identified    │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │valid_min       │ FLOAT   │ Minimum valid value        │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │valid_max       │ FLOAT   │ Maximum valid value        │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │ok_min_mean_abs │ FLOAT   │ Minimum absolute mean      │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │ok_max_mean_abs │ FLOAT   │ Maximum absolute mean      │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │factor          │ FLOAT   │ Scale factor               │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │delete          │ INTEGER │ Set to 1 to delete         │",
    "                         │                │         │ variable                   │",
    "                         ├────────────────┼─────────┼────────────────────────────┤",
    "                         │convert         │ INTEGER │ Set to 1 to convert the    │",
    "                         │                │         │ unit if necessary          │",
    "                         └────────────────┴─────────┴────────────────────────────┘",
    "    Unsupported parameter table entries are stored as variable attributes.  The search key for the",
    "    variable depends on the operator. Use @oper{setpartabn} to search variables by the name.  This is",
    "    typically used for NetCDF datasets. The operator @oper{setpartabp} searches variables by the",
    "    parameter ID.",
    "",
    "OPERATORS",
    "",
    "    setpartabp",
    "           Set parameter table",
    "",
    "           Search variables by the parameter identifier.",
    "",
    "    setpartabn",
    "           Set parameter table",
    "",
    "           Search variables by name.",
    "",
    "PARAMETERS",
    "",
    "    table (STRING)",
    "           Parameter table file or name",
    "",
    "    convert (STRING)",
    "           Converts the units if necessary",
    "",
    "EXAMPLE",
    "    Here is an example of a parameter table for one variable:",
    "",
    "       prompt> cat mypartab",
    "       &parameter",
    "       name            = t",
    "       out_name        = ta",
    "       standard_name   = air_temperature",
    "       units           = \"K\"",
    "       missing_value   = 1.0e+20",
    "       valid_min       = 157.1",
    "       valid_max       = 336.3",
    "       /",
    "",
    "    To apply this parameter table to a dataset use:",
    "",
    "       cdo setpartabn,mypartab,convert  infile  outfile",
    "",
    "    This command renames the variable t to ta. The standard name of this variable is set to",
    "    air_temperature and the unit is set to [K] (converts the unit if necessary). The missing value",
    "    will be set to 1.0e+20.  In addition it will be checked whether the values of the variable are in",
    "    the range of 157.1 to 336.3.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SettimeHelp = {
    "NAME",
    "    setdate, settime, setday, setmon, setyear, settunits, settaxis, settbounds, setreftime,",
    "    setcalendar, shifttime - Set time",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module sets the time axis or part of the time axis. Which part of the time axis is",
    "    overwritten/created depends on the chosen operator. The number of time steps does not change.",
    "",
    "OPERATORS",
    "",
    "    setdate",
    "           Set date",
    "",
    "           Sets the date in every timestep to the same given value (Parameter: date).",
    "",
    "    settime",
    "           Set time of the day",
    "",
    "           Sets the time in every timestep to the same given value (Parameter: time).",
    "",
    "    setday Set day",
    "",
    "           Sets the day in every timestep to the same given value (Parameter: day).",
    "",
    "    setmon Set month",
    "",
    "           Sets the month in every timestep to the same given value (Parameter: month).",
    "",
    "    setyear",
    "           Set year",
    "",
    "           Sets the year in every timestep to the same given value (Parameter: year).",
    "",
    "    settunits",
    "           Set time units",
    "",
    "           Sets the base units of a relative time axis (Parameter: units).",
    "",
    "    settaxis",
    "           Set time axis",
    "",
    "           Sets the time axis (Parameter: date time [inc]).",
    "",
    "    settbounds",
    "           Set time bounds",
    "",
    "           Sets the time bounds (Parameter: frequency).",
    "",
    "    setreftime",
    "           Set reference time",
    "",
    "           Sets the reference time of a relative time axis (Parameter: date time [units]).",
    "",
    "    setcalendar",
    "           Set calendar",
    "",
    "           Sets the calendar attribute of a relative time axis (Parameter: calendar).",
    "",
    "    shifttime",
    "           Shift timesteps",
    "",
    "           Shifts all timesteps by the parameter shiftValue (Parameter: shiftValue).",
    "",
    "PARAMETERS",
    "",
    "    day (INTEGER)",
    "           Value of the new day",
    "",
    "    month (INTEGER)",
    "           Value of the new month",
    "",
    "    year (INTEGER)",
    "           Value of the new year",
    "",
    "    units (STRING)",
    "           Base units of the time axis (seconds|minutes|hours|days|months|years)",
    "",
    "    date (STRING)",
    "           Date (format: YYYY-MM-DD)",
    "",
    "    time (STRING)",
    "           Time (format: hh:mm:ss)",
    "",
    "    inc (STRING)",
    "           Optional increment (seconds|minutes|hours|days|months|years) [default: 1hour]",
    "",
    "    frequency (STRING)",
    "           Frequency of the time series (hour|day|month|year)",
    "",
    "    calendar (STRING)",
    "           Calendar (standard|proleptic_gregorian|360_day|365_day|366_day)",
    "",
    "    shiftValue (STRING)",
    "           Shift value (e.g. -3hour)",
    "",
    "EXAMPLE",
    "    To set the time axis to 1987-01-16 12:00:00 with an increment of one month for each timestep use:",
    "",
    "       cdo settaxis,1987-01-16,12:00:00,1mon infile outfile",
    "",
    "    Result of cdo showdate outfile for a dataset with 12 timesteps:",
    "",
    "       1987-01-16 1987-02-16 1987-03-16 1987-04-16 1987-05-16 1987-06-16 \\",
    "       1987-07-16 1987-08-16 1987-09-16 1987-10-16 1987-11-16 1987-12-16",
    "",
    "    To shift this time axis by -15 days use:",
    "",
    "       cdo shifttime,-15days infile outfile",
    "",
    "    Result of cdo showdate outfile:",
    "",
    "       1987-01-01 1987-02-01 1987-03-01 1987-04-01 1987-05-01 1987-06-01 \\",
    "       1987-07-01 1987-08-01 1987-09-01 1987-10-01 1987-11-01 1987-12-01",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SetzaxisHelp = {
    "NAME",
    "    setzaxis, genlevelbounds - Set z-axis information",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module modifies the metadata of the vertical grid.",
    "",
    "OPERATORS",
    "",
    "    setzaxis",
    "           Set z-axis",
    "",
    "           This operator sets the z-axis description of all variables with the same number of level as",
    "           the new z-axis (Parameter: zaxis).",
    "",
    "    genlevelbounds",
    "           Generate level bounds",
    "",
    "           Generates the layer bounds of the z-axis (Parameter: zbot ztop).",
    "",
    "PARAMETERS",
    "",
    "    zaxis (STRING)",
    "           Z-axis description file or name of the target z-axis",
    "",
    "    zbot (FLOAT)",
    "           Specifying the bottom of the vertical column. Must have the same units as z-axis.",
    "",
    "    ztop (FLOAT)",
    "           Specifying the top of the vertical column. Must have the same units as z-axis.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ShiftxyHelp = {
    "NAME",
    "    shiftx, shifty - Shift field",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains operators to shift all fields in x or y direction.  All fields need to have",
    "    the same horizontal rectilinear or curvilinear grid.",
    "",
    "OPERATORS",
    "",
    "    shiftx Shift x",
    "",
    "           Shifts all fields in x direction.",
    "",
    "    shifty Shift y",
    "",
    "           Shifts all fields in y direction.",
    "",
    "PARAMETERS",
    "",
    "    nshift (INTEGER)",
    "           Number of grid cells to shift (default: 1)",
    "",
    "    cyclic (STRING)",
    "           If set, cells are filled up cyclic (default: missing value)",
    "",
    "    coord (STRING)",
    "           If set, coordinates are also shifted",
    "",
    "EXAMPLE",
    "    To shift all input fields in the x direction by +1 cells and fill the new cells with missing",
    "    value, use:",
    "",
    "       cdo shiftx infile outfile",
    "",
    "    To shift all input fields in the x direction by +1 cells and fill the new cells cyclic, use:",
    "",
    "       cdo shiftx,1,cyclic infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ShowattributeHelp = {
    "NAME",
    "    showattribute - Show attributes",
    "",
    "SYNOPSIS",
    "    cdo  showattribute[,attributes]  infile",
    "",
    "DESCRIPTION",
    "    This operator prints the attributes of the data variables of a dataset.",
    "",
    "    Each attribute has the following structure: [var_nm@][att_nm]",
    "",
    "                              ┌───────┬─────────────────────────────────────┐",
    "                              │var_nm │ Variable name (optional). Example:  │",
    "                              │       │ pressure                            │",
    "                              ├───────┼─────────────────────────────────────┤",
    "                              │att_nm │ Attribute name (optional). Example: │",
    "                              │       │ units                               │",
    "                              └───────┴─────────────────────────────────────┘",
    "    The value of var_nm is the name of the variable containing the attribute (named att_nm) that you",
    "    want to print. Use wildcards to print the attribute att_nm of more than one variable.  A value of",
    "    var_nm of ‘*’ will print the attribute att_nm of all data variables.  If var_nm is missing then",
    "    att_nm refers to a global attribute.",
    "",
    "    The value of att_nm is the name of the attribute you want to print. Use wildcards to print more",
    "    than one attribute. A value of att_nm of ‘*’ will print all attributes.",
    "",
    "NOTE",
    "    NetCDF attributes that are interpreted in CDO can’t be displayed. Here is a incomplete list:",
    "    formula_terms, cell_measures, coordinates, grid_mapping, valid_range, …",
    "",
    "PARAMETERS",
    "",
    "    attributes (STRING)",
    "           Comma-separated list of attributes.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ShowinfoHelp = {
    "NAME",
    "    showformat, showcode, showname, showstdname, showlevel, showltype, showyear, showmon, showdate,",
    "    showtime, showtimestamp, showchunkspec, showfilter - Show variable information",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile",
    "",
    "DESCRIPTION",
    "    This module prints meta-data information of all input variables.  Depending on the chosen operator",
    "    the name, level, date, time and other information is printed.",
    "",
    "OPERATORS",
    "",
    "    showformat",
    "           Show file format",
    "",
    "           Prints the file format of the input dataset.",
    "",
    "    showcode",
    "           Show code numbers",
    "",
    "           Prints the code number of all variables.",
    "",
    "    showname",
    "           Show variable names",
    "",
    "           Prints the name of all variables.",
    "",
    "    showstdname",
    "           Show standard names",
    "",
    "           Prints the standard name of all variables.",
    "",
    "    showlevel",
    "           Show levels",
    "",
    "           Prints all levels for each variable.",
    "",
    "    showltype",
    "           Show GRIB level types",
    "",
    "           Prints the GRIB level type for all z-axes.",
    "",
    "    showyear",
    "           Show years",
    "",
    "           Prints all years.",
    "",
    "    showmon",
    "           Show months",
    "",
    "           Prints all months.",
    "",
    "    showdate",
    "           Show date information",
    "",
    "           Prints date information of all timesteps (format YYYY-MM-DD).",
    "",
    "    showtime",
    "           Show time information",
    "",
    "           Prints time information of all timesteps (format hh:mm:ss).",
    "",
    "    showtimestamp",
    "           Show timestamp",
    "",
    "           Prints timestamp of all timesteps (format YYYY-MM-DDThh:mm:ss).",
    "",
    "    showchunkspec",
    "           Show chunk specification",
    "",
    "           Prints NetCDF4 chunk specification of all variables.",
    "",
    "    showfilter",
    "           Show filter specification",
    "",
    "           Prints NetCDF4 filter specification of all variables.",
    "",
    "EXAMPLE",
    "    To print the code number of all variables in a dataset use:",
    "",
    "       cdo showcode infile",
    "",
    "    This is an example result of a dataset with three variables:",
    "",
    "       129 130 139",
    "",
    "    To print all months in a dataset use:",
    "",
    "       cdo showmon infile",
    "",
    "    This is an examples result of a dataset with an annual cycle:",
    "",
    "       1 2 3 4 5 6 7 8 9 10 11 12",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SinfoHelp = {
    "NAME",
    "    sinfo, sinfon - Short information",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infiles",
    "",
    "DESCRIPTION",
    "    This module writes short information about the structure of infiles to standard output.  infiles",
    "    is an arbitrary number of input files. All input files need to have the same structure with the",
    "    same variables on different timesteps.  The information displayed depends on the chosen operator.",
    "",
    "OPERATORS",
    "",
    "    sinfo  Short information listed by identifier",
    "",
    "           Prints short information of a dataset. The information is divided into 4 sections.  Section",
    "           1 prints one line per parameter with the following information:",
    "",
    "           • institute and source",
    "",
    "           • time c=constant v=varying",
    "",
    "           • type of statistical processing",
    "",
    "           • number of levels and z-axis number",
    "",
    "           • horizontal grid size and number",
    "",
    "           • data type",
    "",
    "           • parameter identifier",
    "",
    "           Section 2 and 3 gives a short overview of all grid and vertical coordinates.  And the last",
    "           section contains short information of the time coordinate.",
    "",
    "    sinfon Short information listed by name",
    "",
    "           The same as operator sinfo but using the name instead of the identifier to label the",
    "           parameter.",
    "",
    "EXAMPLE",
    "    To print short information of a dataset use:",
    "",
    "       cdo sinfon infile",
    "",
    "    This is the result of an ECHAM5 dataset with 3 parameter over 12 timesteps:",
    "",
    "          -1 : Institut Source  T Steptype Levels Num   Points Num Dtype : Name",
    "           1 : MPIMET   ECHAM5  c instant       1   1     2048   1  F32  : GEOSP",
    "           2 : MPIMET   ECHAM5  v instant       4   2     2048   1  F32  : T",
    "           3 : MPIMET   ECHAM5  v instant       1   1     2048   1  F32  : TSURF",
    "         Grid coordinates :",
    "           1 : gaussian              : points=2048 (64x32)  F16",
    "                           longitude : 0 to 354.375 by 5.625 degrees_east  circular",
    "                            latitude : 85.7606 to -85.7606 degrees_north",
    "         Vertical coordinates :",
    "           1 : surface               : levels=1",
    "           2 : pressure              : levels=4",
    "                               level : 92500 to 20000 Pa",
    "         Time coordinate :",
    "                                time : 12 steps",
    "       YYYY-MM-DD hh:mm:ss YYYY-MM-DD hh:mm:ss YYYY-MM-DD hh:mm:ss YYYY-MM-DD hh:mm:ss",
    "       1987-01-31 12:00:00 1987-02-28 12:00:00 1987-03-31 12:00:00 1987-04-30 12:00:00",
    "       1987-05-31 12:00:00 1987-06-30 12:00:00 1987-07-31 12:00:00 1987-08-31 12:00:00",
    "       1987-09-30 12:00:00 1987-10-31 12:00:00 1987-11-30 12:00:00 1987-12-31 12:00:00",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SmoothHelp = {
    "NAME",
    "    smooth, smooth9 - Smooth grid points",
    "",
    "SYNOPSIS",
    "    cdo  smooth[,parameters]  infile outfile",
    "",
    "    cdo  smooth9  infile outfile",
    "",
    "DESCRIPTION",
    "    Smooth all grid points of a horizontal grid.",
    "",
    "OPERATORS",
    "",
    "    smooth Smooth grid points",
    "",
    "           Performs a N point smoothing on all input fields. The number of points used depend on the",
    "           search radius (radius) and the maximum number of points (maxpoints).  Per default all",
    "           points within the search radius of 1degree are used.  The weights for the points depend on",
    "           the weighting method and the distance.  The implemented weighting method is linear with",
    "           constant default weights of 0.25 at distance 0 (weight0) and at the search radius",
    "           (weightR).",
    "",
    "    smooth9",
    "           9 point smoothing",
    "",
    "           Performs a 9 point smoothing on all fields with a quadrilateral curvilinear grid.  The",
    "           result at each grid point is a weighted average of the grid point plus the 8 surrounding",
    "           points. The center point receives a weight of 1.0, the points at each side and above and",
    "           below receive a weight of 0.5, and corner points receive a weight of 0.3.  All 9 points are",
    "           multiplied by their weights and summed, then divided by the total weight to obtain the",
    "           smoothed value. Any missing data points are not included in the sum; points beyond the grid",
    "           boundary are considered to be missing. Thus the final result may be the result of an",
    "           averaging with less than 9 points.",
    "",
    "PARAMETERS",
    "",
    "    nsmooth (INTEGER)",
    "           Number of times to smooth, default nsmooth=1",
    "",
    "    radius (STRING)",
    "           Search radius, default radius=1deg (units: deg, rad, km, m)",
    "",
    "    maxpoints (INTEGER)",
    "           Maximum number of points, default maxpoints=<gridsize>",
    "",
    "    weighted (STRING)",
    "           Weighting method, default weighted=linear",
    "",
    "    weight0 (FLOAT)",
    "           Weight at distance 0, default weight0=0.25",
    "",
    "    weightR (FLOAT)",
    "           Weight at the search radius, default weightR=0.25",
    "",
    "AUTHOR",
    "    Uwe Schulzweida, Cedrick Ansorge",
    "",
};

const CdoHelp SpecconvHelp = {
    "NAME",
    "    sp2sp - Spectral to spectral",
    "",
    "SYNOPSIS",
    "    cdo  sp2sp,trunc  infile outfile",
    "",
    "DESCRIPTION",
    "    Changed the triangular truncation of all spectral fields. This operator performs downward",
    "    conversion by cutting the resolution. Upward conversions are achieved by filling in zeros.",
    "",
    "PARAMETERS",
    "",
    "    trunc (INTEGER)",
    "           New spectral resolution",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SpectralHelp = {
    "NAME",
    "    sp2gp, gp2sp - Spectral transformation",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,parameters]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module transforms fields on a global regular Gaussian grid to spectral coefficients and vice",
    "    versa.  The transformation is achieved by applying Fast Fourier Transformation (FFT) first and",
    "    direct Legendre Transformation afterwards in gp2sp. In sp2gp the inverse Legendre Transformation",
    "    and inverse FFT are used.  Missing values are not supported.",
    "",
    "    The relationship between the spectral resolution, governed by the truncation number T, and the",
    "    grid resolution depends on the number of grid points at which the shortest wavelength field is",
    "    represented.  For a grid with 2N points between the poles (so 4N grid points in total around the",
    "    globe) the relationship is:",
    "",
    "    linear grid: the shortest wavelength is represented by 2 grid points -> 4N ~= 2(TL + 1)",
    "    quadratic grid: the shortest wavelength is represented by 3 grid points -> 4N ~= 3(TQ + 1)",
    "    cubic grid: the shortest wavelength is represented by 4 grid points -> 4N ~= 4(TC + 1)",
    "",
    "",
    "    The quadratic grid is used by ECHAM and ERA15. ERA40 is using a linear Gaussian grid reflected by",
    "    the TL notation.",
    "",
    "    The following table shows the calculation of the number of latitudes and the triangular truncation",
    "    for the different grid types:",
    "",
    "                   ┌──────────┬───────────────────────────┬────────────────────────────┐",
    "                   │Gridtype  │ Number of latitudes: nlat │ Triangular truncation: ntr │",
    "                   ├──────────┼───────────────────────────┼────────────────────────────┤",
    "                   │linear    │ NINT((ntr*2 + 1)/2)       │ (nlat*2 - 1) / 2           │",
    "                   ├──────────┼───────────────────────────┼────────────────────────────┤",
    "                   │quadratic │ NINT((ntr*3 + 1)/2)       │ (nlat*2 - 1) / 3           │",
    "                   ├──────────┼───────────────────────────┼────────────────────────────┤",
    "                   │cubic     │ NINT((ntr*4 + 1)/2)       │ (nlat*2 - 1) / 4           │",
    "                   └──────────┴───────────────────────────┴────────────────────────────┘",
    "OPERATORS",
    "",
    "    sp2gp  Spectral to gridpoint",
    "",
    "           Convert all spectral fields to a global regular Gaussian grid.  The optional parameter",
    "           trunc must be greater than the input truncation.",
    "",
    "    gp2sp  Gridpoint to spectral",
    "",
    "           Convert all Gaussian gridpoint fields to spectral fields.  The optional parameter trunc",
    "           must be lower than the input truncation.",
    "",
    "PARAMETERS",
    "",
    "    type (STRING)",
    "           Type of the grid: quadratic, linear, cubic (default: type=quadratic)",
    "",
    "    trunc (INTEGER)",
    "           Triangular truncation",
    "",
    "NOTE",
    "    To speed up the calculations, the Legendre polynoms are kept in memory. This requires a relatively",
    "    large amount of memory. This is for example 12GB for T1279 data.",
    "",
    "EXAMPLE",
    "    To transform spectral coefficients from T106 to F80 regular Gaussian grid use:",
    "",
    "       cdo sp2gp infile outfile",
    "",
    "    To transform spectral coefficients from TL159 to F80 regular Gaussian grid use:",
    "",
    "       cdo sp2gp,type=linear infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SplitHelp = {
    "NAME",
    "    splitcode, splitparam, splitname, splitlevel, splitgrid, splitzaxis, splittabnum, splitensemble -",
    "    Split a dataset",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,parameters]  infile obase",
    "",
    "DESCRIPTION",
    "    This module splits infile into pieces. The output files will be named <obase><xxx><suffix> where",
    "    suffix is the filename extension derived from the file format. xxx and the contents of the output",
    "    files depends on the chosen operator.  params is a comma-separated list of processing parameters.",
    "",
    "OPERATORS",
    "",
    "    splitcode",
    "           Split code numbers",
    "",
    "           Splits a dataset into pieces, one for each different code number.  xxx will have three",
    "           digits with the code number.",
    "",
    "    splitparam",
    "           Split parameter identifiers",
    "",
    "           Splits a dataset into pieces, one for each different parameter identifier.  xxx will be a",
    "           string with the parameter identifier.",
    "",
    "    splitname",
    "           Split variable names",
    "",
    "           Splits a dataset into pieces, one for each variable name.  xxx will be a string with the",
    "           variable name.",
    "",
    "    splitlevel",
    "           Split levels",
    "",
    "           Splits a dataset into pieces, one for each different level.  xxx will have six digits with",
    "           the level.",
    "",
    "    splitgrid",
    "           Split grids",
    "",
    "           Splits a dataset into pieces, one for each different grid.  xxx will have two digits with",
    "           the grid number.",
    "",
    "    splitzaxis",
    "           Split z-axes",
    "",
    "           Splits a dataset into pieces, one for each different z-axis.  xxx will have two digits with",
    "           the z-axis number.",
    "",
    "    splittabnum",
    "           Split parameter table numbers",
    "",
    "           Splits a dataset into pieces, one for each GRIB1 parameter table number.  xxx will have",
    "           three digits with the GRIB1 parameter table number.",
    "",
    "    splitensemble",
    "           Split ensembles",
    "",
    "           Splits a dataset into pieces, one for each GRIB2 ensemble member.  xxx will have five",
    "           digits with the GRIB2 key perturbationNumber.",
    "",
    "PARAMETERS",
    "",
    "    swap (STRING)",
    "           Swap the position of obase and xxx in the output filename",
    "",
    "    uuid=<attname> (STRING)",
    "           Add a UUID as global attribute <attname> to each output file",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX sets the filename suffix.",
    "",
    "NOTE",
    "    Operators of this module need to open all output files simultaneously.  The maximum number of open",
    "    files depends on the operating system!",
    "",
    "EXAMPLE",
    "    Assume an input GRIB1 dataset with three variables, e.g. code number 129, 130 and 139.  To split",
    "    this dataset into three pieces, one for each code number use:",
    "",
    "       cdo splitcode infile code",
    "",
    "    Result of dir code*:",
    "",
    "       code129.grb code130.grb code139.grb",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SplitdateHelp = {
    "NAME",
    "    splitdate - Splits a file into dates",
    "",
    "SYNOPSIS",
    "    cdo  splitdate  infile obase",
    "",
    "DESCRIPTION",
    "    This operator splits infile into pieces, one for each different date.  The output files will be",
    "    named <obase><YYYY-MM-DD><suffix> where YYYY-MM-DD is the date and suffix is the filename",
    "    extension derived from the file format.",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX sets the filename suffix.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp SplitselHelp = {
    "NAME",
    "    splitsel - Split selected timesteps",
    "",
    "SYNOPSIS",
    "    cdo  splitsel,parameters  infile obase",
    "",
    "DESCRIPTION",
    "    This operator splits infile into pieces, one for each adjacent sequence t_1, ...., t_n of",
    "    timesteps of the same selected time range.  The output files will be named <obase><nnnnnn><suffix>",
    "    where nnnnnn is the sequence number and suffix is the filename extension derived from the file",
    "    format.",
    "",
    "PARAMETERS",
    "",
    "    nsets (INTEGER)",
    "           Number of input timesteps for each output file",
    "",
    "    noffset (INTEGER)",
    "           Number of input timesteps skipped before the first timestep range (optional)",
    "",
    "    nskip (INTEGER)",
    "           Number of input timesteps skipped between timestep ranges (optional)",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX sets the filename suffix.",
    "",
    "AUTHOR",
    "    Etienne Tourigny",
    "",
};

const CdoHelp SplittimeHelp = {
    "NAME",
    "    splithour, splitday, splitseas, splityear, splityearmon, splitmon - Split timesteps of a dataset",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile obase",
    "",
    "DESCRIPTION",
    "    This module splits infile into  timesteps pieces. The output files will be named",
    "    <obase><xxx><suffix>} where :file:`suffix is the filename extension derived from the file format.",
    "    xxx and the contents of the output files depends on the chosen operator.",
    "",
    "OPERATORS",
    "",
    "    splithour",
    "           Split hours",
    "",
    "           Splits a file into pieces, one for each different hour.  xxx will have two digits with the",
    "           hour.",
    "",
    "    splitday",
    "           Split days",
    "",
    "           Splits a file into pieces, one for each different day.  xxx will have two digits with the",
    "           day.",
    "",
    "    splitmon",
    "           Split months",
    "",
    "           Splits a file into pieces, one for each different month.  xxx will have two digits with the",
    "           month.  Use the optional format parameter to change the format for the month.",
    "",
    "    splitseas",
    "           Split seasons",
    "",
    "           Splits a file into pieces, one for each different season.  xxx will have three characters",
    "           with the season.",
    "",
    "    splityearmon",
    "           Split in years and months",
    "",
    "           Splits a file into pieces, one for each different year and month.  xxx will have six digits",
    "           with the year and month (YYYYMM).",
    "",
    "    splityear",
    "           Split years",
    "",
    "           Splits a file into pieces, one for each different year.  xxx will have four digits with the",
    "           year (YYYY).",
    "",
    "PARAMETERS",
    "",
    "    format (STRING)",
    "           C-style format for strftime() (e.g. %B for the full month name)",
    "",
    "ENVIRONMENT",
    "    CDO_FILE_SUFFIX sets the filename suffix.",
    "",
    "NOTE",
    "    Operators of this module need to open all output files simultaneously.  The maximum number of open",
    "    files depends on the operating system!",
    "",
    "EXAMPLE",
    "    Assume the input GRIB1 dataset has timesteps from January to December.  To split each month with",
    "    all variables into one separate file use:",
    "",
    "       cdo splitmon infile mon",
    "",
    "    Result of dir mon*:",
    "",
    "       mon01.grb  mon02.grb  mon03.grb  mon04.grb  mon05.grb  mon06.grb",
    "       mon07.grb  mon08.grb  mon09.grb  mon10.grb  mon11.grb  mon12.grb",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp StrbreHelp = {
    "NAME",
    "    strbre - Strong breeze days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  strbre[,v]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum horizontal wind speed VX, then the number of days",
    "    where VX is greater than or equal to 10.5 m/s is counted. A further output variable is the maximum",
    "    number of consecutive days with maximum wind speed greater than or equal to 10.5 m/s. Note that VX",
    "    is defined as the square root of the sum of squares of the zonal and meridional wind speeds and",
    "    have to be given in units of m/s.  The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile.",
    "",
};

const CdoHelp StrgalHelp = {
    "NAME",
    "    strgal - Strong gale days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  strgal[,v]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum horizontal wind speed VX, then the number of days",
    "    where VX is greater than or equal to 20.5 m/s is counted. A further output variable is the maximum",
    "    number of consecutive days with maximum wind speed greater than or equal to 20.5 m/s. Note that VX",
    "    is defined as the square root of the sum of square of the zonal and meridional wind speeds and",
    "    have to be given in units of m/s.  The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile.",
    "",
};

const CdoHelp StrwinHelp = {
    "NAME",
    "    strwin - Strong wind days index per time period",
    "",
    "SYNOPSIS",
    "    cdo  strwin[,v]  infile outfile",
    "",
    "DESCRIPTION",
    "    Let infile be a time series of the daily maximum horizontal wind speed VX, then the number of days",
    "    where VX > v is counted. The horizontal wind speed v is an optional parameter with default v =",
    "    10.5 m/s. A further output variable is the maximum number of consecutive days with maximum wind",
    "    speed greater than or equal to v. Note that both VX and v have to be given in units of m/s. Also",
    "    note that the horizontal wind speed is defined as the square root of the sum of squares of the",
    "    zonal and meridional wind speeds.  The date information of a timestep in outfile is the date of",
    "    the last contributing timestep in infile.",
    "",
    "PARAMETERS",
    "",
    "    v (FLOAT)",
    "           Horizontal wind speed threshold (m/s, default v = 10.5 m/s)",
    "",
};

const CdoHelp SymmetrizeHelp = {
    "NAME",
    "    symmetrize - Mirrors data at the equator",
    "",
    "SYNOPSIS",
    "    cdo  symmetrize[,parameters]  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator symmetrizes global fields relative to the equator.  By default, data with positive",
    "    latitudes are mirrored.  With the parameter lat=negative, it is the data with negative latitudes.",
    "    The result for fields on a global lon/lat or Gaussian grid is perfectly symmetrical.  For fields",
    "    on an unstructured grid, the result is the nearest neighbour of the other hemisphere.  Use the",
    "    grid parameter to specify the path to a grid description file if the unstructured data is",
    "    available without grid coordinates.",
    "",
    "PARAMETERS",
    "",
    "    lat (STRING)",
    "           lat=negative mirrors data with negative latitudes",
    "",
    "    grid (STRING)",
    "           Grid description file or name",
    "",
    "AUTHOR",
    "    Uwe Schulzweida, Bjorn Stevens",
    "",
};

const CdoHelp TeeHelp = {
    "NAME",
    "    tee - Duplicate a data stream and write it to file",
    "",
    "SYNOPSIS",
    "    cdo  tee,outfile2  infile outfile1",
    "",
    "DESCRIPTION",
    "    This operator copies the input dataset to outfile1 and outfile2.  The first output stream in",
    "    outfile1 can be further processed with other cdo operators.  The second output outfile2 is written",
    "    to disk.  It can be used to store intermediate results to a file.",
    "",
    "PARAMETERS",
    "",
    "    outfile2 (STRING)",
    "           Destination filename for the copy of the input file",
    "",
    "EXAMPLE",
    "    To compute the daily and monthy average of a dataset use:",
    "",
    "       cdo monavg -tee,outfile_dayavg dayavg infile outfile_monavg",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp TimcorHelp = {
    "NAME",
    "    timcor - Correlation over time",
    "",
    "SYNOPSIS",
    "    cdo  timcor  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    The correlation coefficient is a quantity that gives the quality of a least squares fitting to the",
    "    original data. This operator correlates each gridpoint of two fields over all timesteps.  If there",
    "    is only one input field, the p-value (probability value) is also written out.  With",
    "",
    "       S(x) = {t, i_1(t,x) != missval and i_2(t,x) != missval}",
    "",
    "    it is",
    "",
    "       o(1,x) = Cor{(i_1(t,x), i_2(t,x)), t_1 < t <= t_n}",
    "",
    "    For every gridpoint x only those timesteps t belong to the sample, which have i_1(t,x) !=",
    "    missval and i_2(t,x) != missval.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp TimcovarHelp = {
    "NAME",
    "    timcovar - Covariance over time",
    "",
    "SYNOPSIS",
    "    cdo  timcovar  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This operator calculates the covariance of two fields at each gridpoint over all timesteps. With",
    "",
    "       S(x) = {t, i_1(t,x) != missval and i_2(t,x) != missval}",
    "",
    "    it is",
    "",
    "       o(1,x) = Covar{(i_1(t,x), i_2(t,x)), t_1 < t <= t_n}",
    "",
    "    For every gridpoint x only those timesteps t belong to the sample, which have i_1(t,x) !=",
    "    missval and i_2(t,x) != missval.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp TimcumsumHelp = {
    "NAME",
    "    timcumsum - Cumulative sum over all timesteps",
    "",
    "SYNOPSIS",
    "    cdo  timcumsum  infile outfile",
    "",
    "DESCRIPTION",
    "    The timcumsum operator calculates the cumulative sum over all timesteps.  Missing values are",
    "    treated as numeric zero when summing.",
    "",
    "    o(t,x) = sum{i(t’,x), 0<=t’<=t}",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp TimfillmissHelp = {
    "NAME",
    "    timfillmiss - Temporal filling of missing values",
    "",
    "SYNOPSIS",
    "    cdo  timfillmiss,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator fills in temporally missing values.  The method parameter can be used to select the",
    "    filling method.  The default method=nearest fills missing values with the nearest neighbor value.",
    "    Other options are forward and backward to fill missing values by forward or backward propagation",
    "    of values.  Use the limit parameter to set the maximum number of consecutive missing values to",
    "    fill and max_gaps to set the maximum number of gaps to fill.",
    "",
    "PARAMETERS",
    "",
    "    method (STRING)",
    "           Fill method [nearest|linear|forward|backward] (default: nearest)",
    "",
    "    limit (INTEGER)",
    "           The maximum number of consecutive missing values to fill (default: all)",
    "",
    "    max_gaps (INTEGER)",
    "           The maximum number of gaps to fill (default: all)",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp TimpctlHelp = {
    "NAME",
    "    timpctl - Temporal percentile",
    "",
    "SYNOPSIS",
    "    cdo  timpctl,pn  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps in infile1. The algorithm uses histograms",
    "    with minimum and maximum bounds given in infile2 and infile3, respectively.  The default number of",
    "    histogram bins is 101. The default can be overridden by defining the environment variable",
    "    CDO_PCTL_NBINS. The files infile2 and infile3 should be the result of corresponding timmin and",
    "    timmax operations, respectively.  The time of outfile is determined by the time in the middle of",
    "    all contributing timesteps of infile1.  This can be change with the CDO option –timestat_date",
    "    <first|middle|last>.",
    "",
    "    o(1,x) = pth percentile {i(t’,x), t_1<=t’<=t_n}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "EXAMPLE",
    "    To compute the 90th percentile over all input timesteps use:",
    "",
    "       cdo timmin infile minfile",
    "       cdo timmax infile maxfile",
    "       cdo timpctl,90 infile minfile maxfile outfile",
    "",
    "    Or shorter using operator piping:",
    "",
    "       cdo timpctl,90 infile -timmin infile -timmax infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp TimselpctlHelp = {
    "NAME",
    "    timselpctl - Time range percentile",
    "",
    "SYNOPSIS",
    "    cdo  timselpctl,pn,nsets[,noffset[,nskip]]  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentile values over a selected number of timesteps in infile1.  The",
    "    algorithm uses histograms with minimum and maximum bounds given in infile2 and infile3,",
    "    respectively. The default number of histogram bins is 101. The default can be overridden by",
    "    setting the environment variable CDO_PCTL_NBINS to a different value. The files infile2 and",
    "    infile3 should be the result of corresponding timselmin and timselmax operations, respectively.",
    "    The time of outfile is determined by the time in the middle of all contributing timesteps of",
    "    infile1.  This can be change with the CDO option –timestat_date <first|middle|last>.",
    "",
    "    For every adjacent sequence :t_1, ...,t_n of timesteps of the same selected time range it is:",
    "",
    "    o(t,x) = pth percentile {i(t’,x), t1<=t’<=tn}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "    nsets (INTEGER)",
    "           Number of input timesteps for each output timestep",
    "",
    "    noffset (INTEGER)",
    "           Number of input timesteps skipped before the first timestep range (optional)",
    "",
    "    nskip (INTEGER)",
    "           Number of input timesteps skipped between timestep ranges (optional)",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp TimselstatHelp = {
    "NAME",
    "    timselmin, timselmax, timselrange, timselsum, timselmean, timselavg, timselstd, timselstd1,",
    "    timselvar, timselvar1 - Time range statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,nsets[,noffset[,nskip]]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values for a selected number of timesteps. According to the",
    "    chosen operator the minimum, maximum, range, sum, average, variance or standard deviation of the",
    "    selected timesteps is written to outfile.  The time of outfile is determined by the time in the",
    "    middle of all contributing timesteps of infile.  This can be change with the CDO option",
    "    –timestat_date <first|middle|last>.",
    "",
    "OPERATORS",
    "",
    "    timselmin",
    "           Time selection minimum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same selected time range it",
    "           is:",
    "",
    "           o(t,x) = min{i(t’,x), t1<=t’<=tn}",
    "",
    "    timselmax",
    "           Time selection maximum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same selected time range it",
    "           is:",
    "",
    "           o(t,x) = max{i(t’,x), t1<=t’<=tn}",
    "",
    "    timselrange",
    "           Time selection range",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same selected time range it",
    "           is:",
    "",
    "           o(t,x) = range{i(t’,x), t1<=t’<=tn}",
    "",
    "    timselsum",
    "           Time selection sum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same selected time range it",
    "           is:",
    "",
    "           o(t,x) = sum{i(t’,x), t1<=t’<=tn}",
    "",
    "    timselmean",
    "           Time selection mean",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same selected time range it",
    "           is:",
    "",
    "           o(t,x) = mean{i(t’,x), t1<=t’<=tn}",
    "",
    "    timselavg",
    "           Time selection average",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same selected time range it",
    "           is:",
    "",
    "           o(t,x) = avg{i(t’,x), t1<=t’<=tn}",
    "",
    "    timselvar",
    "           Time selection variance",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same selected time range it",
    "           is:",
    "",
    "           o(t,x) = var{i(t’,x), t1<=t’<=tn}",
    "",
    "    timselvar1",
    "           Time selection variance (n-1)",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same selected time range it",
    "           is:",
    "",
    "           o(t,x) = var1{i(t’,x), t1<=t’<=tn}",
    "",
    "    timselstd",
    "           Time selection standard deviation",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same selected time range it",
    "           is:",
    "",
    "           o(t,x) = std{i(t’,x), t1<=t’<=tn}",
    "",
    "    timselstd1",
    "           Time selection standard deviation (n-1)",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same selected time range it",
    "           is:",
    "",
    "           o(t,x) = std1{i(t’,x), t1<=t’<=tn}",
    "",
    "PARAMETERS",
    "",
    "    nsets (INTEGER)",
    "           Number of input timesteps for each output timestep",
    "",
    "    noffset (INTEGER)",
    "           Number of input timesteps skipped before the first timestep range (optional)",
    "",
    "    nskip (INTEGER)",
    "           Number of input timesteps skipped between timestep ranges (optional)",
    "",
    "EXAMPLE",
    "    Assume an input dataset has monthly means over several years.  To compute seasonal means from",
    "    monthly means the first two month have to be skipped:",
    "",
    "       cdo timselmean,3,2 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp TimsortHelp = {
    "NAME",
    "    timsort - Temporal sorting",
    "",
    "SYNOPSIS",
    "    cdo  timsort  infile outfile",
    "",
    "DESCRIPTION",
    "    Sorts the elements in ascending order over all timesteps for every field position.  After sorting",
    "    it is:",
    "",
    "    o(t_1,x) <= o(t_2,x)      forall (t_1<t_2),x",
    "",
    "EXAMPLE",
    "    To sort all field elements of a dataset over all timesteps use:",
    "",
    "       cdo timsort infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp TimstatHelp = {
    "NAME",
    "    timmin, timmax, timminidx, timmaxidx, timrange, timsum, timmean, timavg, timstd, timstd1, timvar,",
    "    timvar1 - Statistical values over all timesteps",
    "",
    "SYNOPSIS",
    "    cdo [options]  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over all timesteps in infile. Depending on the chosen",
    "    operator the minimum, maximum, range, sum, average, variance or standard deviation of all",
    "    timesteps read from infile is written to outfile.  The time of outfile is determined by the time",
    "    in the middle of all contributing timesteps of infile.  This can be change with the CDO option",
    "    –timestat_date <first|middle|last>.",
    "",
    "OPERATORS",
    "",
    "    timmin Time minimum",
    "",
    "           o(1,x) = min{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    timmax Time maximum",
    "",
    "           o(1,x) = max{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    timminidx",
    "           Index of time minimum",
    "",
    "           o(1,x) = minidx{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    timmaxidx",
    "           Index of time maximum",
    "",
    "           o(1,x) = maxidx{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    timrange",
    "           Time range",
    "",
    "           o(1,x) = range{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    timsum Time sum",
    "",
    "           o(1,x) = sum{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    timmean",
    "           Time mean",
    "",
    "           o(1,x) = mean{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    timavg Time average",
    "",
    "           o(1,x) = avg{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    timvar Time variance",
    "",
    "           Normalize by n.",
    "",
    "           o(1,x) = var{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    timvar1",
    "           Time variance (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "           o(1,x) = var1{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    timstd Time standard deviation",
    "",
    "           Normalize by n.",
    "",
    "           o(1,x) = std{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    timstd1",
    "           Time standard deviation (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "           o(1,x) = std1{i(t’,x), t_1<=t’<=t_n}",
    "",
    "OPTIONS",
    "    -S, --diagnostic to create a diagnostic output stream with the number of non missing values for",
    "    each output period.",
    "",
    "    -p, --async_read true to read input data asynchronously.",
    "",
    "EXAMPLE",
    "    To compute the mean over all input timesteps use:",
    "",
    "       cdo timmean infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp TrendHelp = {
    "NAME",
    "    trend - Trend of time series",
    "",
    "SYNOPSIS",
    "    cdo [options]  trend[,equal]  infile outfile1 outfile2",
    "",
    "DESCRIPTION",
    "    The values of the input file infile are assumed to be distributed as N(a+b*t,S^2) with unknown a,",
    "    b and S^2. This operator estimates the parameter a and b. For every field element x only those",
    "    timesteps t belong to the sample S(x), which have i(t,x) NE miss.",
    "",
    "    Thus the estimation for a is stored in outfile1 and that for b is stored in outfile2. To subtract",
    "    the trend from the data see operator subtrend.  It is assumed that all timesteps are equidistant,",
    "    if this is not the case set the parameter equal=false.",
    "",
    "PARAMETERS",
    "",
    "    equal (BOOL)",
    "           Set to false for unequal distributed timesteps (default: true)",
    "",
    "OPTIONS",
    "    -p, --async_read true to read input data asynchronously.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp TrendarithHelp = {
    "NAME",
    "    addtrend, subtrend - Add or subtract a trend",
    "",
    "SYNOPSIS",
    "    cdo  trend[,equal]  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This module is for adding or subtracting a trend computed by the operator trend.",
    "",
    "OPERATORS",
    "",
    "    addtrend",
    "           Add trend",
    "",
    "           It is",
    "",
    "           o(t,x) = i_1(t,x) + (i_2(1,x) + i_3(1,x)*t)",
    "",
    "           where t is the timesteps.",
    "",
    "    subtrend",
    "           Subtract trend",
    "",
    "           It is",
    "",
    "           o(t,x) = i_1(t,x) - (i_2(1,x) + i_3(1,x)*t)",
    "",
    "           where t is the timesteps.",
    "",
    "PARAMETERS",
    "",
    "    equal (BOOL)",
    "           Set to false for unequal distributed timesteps (default: true)",
    "",
    "EXAMPLE",
    "    The typical call for detrending the data in infile and storing the detrended data in outfile is:",
    "",
    "       cdo trend infile afile bfile",
    "       cdo subtrend infile afile bfile outfile",
    "",
    "    The result is identical to a call of the operator detrend:",
    "",
    "       cdo detrend infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp UnpackHelp = {
    "NAME",
    "    unpack - Unpack data",
    "",
    "SYNOPSIS",
    "    cdo  unpack  infile outfile",
    "",
    "DESCRIPTION",
    "    Packing reduces the data volume by reducing the precision of the stored numbers.  It is",
    "    implemented using the NetCDF attributes add_offset and scale_factor.  The operator unpack unpack",
    "    all packed variables.  The default data type for all variables is automatically changed to 32-bit",
    "    floats.  Use the CDO option -b F64 to change the data type to 64-bit floats, if needed.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp VargenHelp = {
    "NAME",
    "    const, random, topo, seq, stdatm - Generate a field",
    "",
    "SYNOPSIS",
    "    cdo  const,const,grid  outfile",
    "",
    "    cdo  random,grid[,seed]  outfile",
    "",
    "    cdo  topo,grid  outfile",
    "",
    "    cdo  seq,start,end[,inc]  outfile",
    "",
    "    cdo  stdatm,levels  outfile",
    "",
    "DESCRIPTION",
    "    Generates a dataset with one or more fields.",
    "",
    "OPERATORS",
    "",
    "    const  Create a constant field",
    "",
    "           Creates a constant field. All field elements of the grid have the same value.",
    "",
    "    random Create a field with random numbers",
    "",
    "           Creates a field with rectangularly distributed random numbers in the interval [0,1].",
    "",
    "    topo   Create a field with topography",
    "",
    "           Creates a field with topography data, per default on a global half degree grid.",
    "",
    "    seq    Create a time series",
    "",
    "           Creates a time series with field size 1 and field elements beginning with a start value in",
    "           time step 1 which is increased from one time step to the next.",
    "",
    "    stdatm Create values for pressure and temperature for hydrostatic atmosphere",
    "",
    "           Creates pressure and temperature values for the given list of vertical levels.  The",
    "           formulas are:",
    "",
    "           P(z) = P_0 * exp(-1 * g/R * H/T_0 * log( (exp(z/H)*T_0 + T_Delta)/(T_0 + T_Delta)) T(z) =",
    "           T_0 + T_Delta * exp(-z/H)",
    "",
    "           with the following constants",
    "",
    "           T_0     = 213 K           Offset to get a surface temperature of 288K T_Delta = 75 K",
    "           Temperature lapse rate for 10Km P_0     = 1013.25 hPa     Surface pressure H       =",
    "           10000.0 m       Scale height g       = 9.80665 m/s**2  Earth gravity R       = 287.05",
    "           J/kg*K   Gas constant for air",
    "",
    "           This is the solution for the hydrostatic equations and is only valid for the troposphere",
    "           (constant positive lapse rate). The temperature increase in the stratosphere and other",
    "           effects of the upper atmosphere are not taken into account.",
    "",
    "PARAMETERS",
    "",
    "    const (FLOAT)",
    "           Constant",
    "",
    "    seed (INTEGER)",
    "           The seed for a new sequence of pseudo-random numbers [default: 1]",
    "",
    "    grid (STRING)",
    "           Target grid description file or name",
    "",
    "    start (FLOAT)",
    "           Start value of the loop",
    "",
    "    end (FLOAT)",
    "           End value of the loop",
    "",
    "    inc (FLOAT)",
    "           Increment of the loop [default: 1]",
    "",
    "    levels (FLOAT)",
    "           Target levels in metre above surface",
    "",
    "EXAMPLE",
    "    To create a standard atmosphere dataset on a given horizontal grid:",
    "",
    "       cdo enlarge,gridfile -stdatm,10000,8000,5000,3000,2000,1000,500,200,0 outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida, Ralf Müller",
    "",
};

const CdoHelp VarsstatHelp = {
    "NAME",
    "    varsmin, varsmax, varsrange, varssum, varsmean, varsavg, varsstd, varsstd1, varsvar, varsvar1,",
    "    varsskew, varskurt, varsmedian, varspctl - Statistical values over all variables",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "    cdo  varspctl,pn  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over all variables for each timestep.  Depending on the",
    "    chosen operator the minimum, maximum, range, sum, average, standard deviation, variance, skewness,",
    "    kurtosis, median or a certain percentile is written to outfile.  All input variables need to have",
    "    the same gridsize and the same number of levels.",
    "",
    "OPERATORS",
    "",
    "    varsmin",
    "           Variables minimum",
    "",
    "           For every timestep the minimum over all variables is computed.",
    "",
    "    varsmax",
    "           Variables maximum",
    "",
    "           For every timestep the maximum over all variables is computed.",
    "",
    "    varsrange",
    "           Variables range",
    "",
    "           For every timestep the range over all variables is computed.",
    "",
    "    varssum",
    "           Variables sum",
    "",
    "           For every timestep the sum over all variables is computed.",
    "",
    "    varsmean",
    "           Variables mean",
    "",
    "           For every timestep the mean over all variables is computed.",
    "",
    "    varsavg",
    "           Variables average",
    "",
    "           For every timestep the average over all variables is computed.",
    "",
    "    varsstd",
    "           Variables standard deviation",
    "",
    "           For every timestep the standard deviation over all variables is computed. Normalize by n.",
    "",
    "    varsstd1",
    "           Variables standard deviation (n-1)",
    "",
    "           For every timestep the standard deviation over all variables is computed. Normalize by",
    "           (n-1).",
    "",
    "    varsvar",
    "           Variables variance",
    "",
    "           For every timestep the variance over all variables is computed. Normalize by n.",
    "",
    "    varsvar1",
    "           Variables variance (n-1)",
    "",
    "           For every timestep the variance over all variables is computed. Normalize by (n-1).",
    "",
    "    varsskew",
    "           Variables skewness",
    "",
    "           For every timestep the skewness over all variables is computed.",
    "",
    "    varskurt",
    "           Variables kurtosis",
    "",
    "           For every timestep the kurtosis over all variables is computed.",
    "",
    "    varsmedian",
    "           Variables median",
    "",
    "           For every timestep the median over all variables is computed.",
    "",
    "    varspctl",
    "           Variables percentile",
    "",
    "           For every timestep the percentile over all variables is computed.",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, ..., 100}",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp VerifygridHelp = {
    "NAME",
    "    verifygrid - Verify grid coordinates",
    "",
    "SYNOPSIS",
    "    cdo  verifygrid  infile",
    "",
    "DESCRIPTION",
    "    This operator verifies the coordinates of all horizontal grids found in infile.  Among other",
    "    things, it searches for duplicate cells, non-convex cells, and whether the center is located",
    "    outside the cell bounds.  Use the CDO option -v to output the position of these cells.  This",
    "    information can be useful to avoid problems when interpolating the data.",
    "",
};

const CdoHelp VertfillmissHelp = {
    "NAME",
    "    vertfillmiss - Vertical filling of missing values",
    "",
    "SYNOPSIS",
    "    cdo  vertfillmiss,parameters  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator fills in vertical missing values.  The method parameter can be used to select the",
    "    filling method.  The default method=nearest fills missing values with the nearest neighbor value.",
    "    Other options are forward and backward to fill missing values by forward or backward propagation",
    "    of values.  Use the limit parameter to set the maximum number of consecutive missing values to",
    "    fill and max_gaps to set the maximum number of gaps to fill.",
    "",
    "PARAMETERS",
    "",
    "    method (STRING)",
    "           Fill method [nearest|linear|forward|backward] (default: nearest)",
    "",
    "    limit (INTEGER)",
    "           The maximum number of consecutive missing values to fill (default: all)",
    "",
    "    max_gaps (INTEGER)",
    "           The maximum number of gaps to fill (default: all)",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp VertintapHelp = {
    "NAME",
    "    ap2pl - Vertical pressure interpolation",
    "",
    "SYNOPSIS",
    "    cdo  ap2pl,levels  infile outfile",
    "",
    "DESCRIPTION",
    "    Interpolate 3D variables on hybrid sigma height coordinates to pressure levels.  A basic linear",
    "    method is used for interpolation. The input file must contain the 3D air pressure in pascal. The",
    "    air pressure is identified by the NetCDF CF standard name air_pressure.  Use the alias ap2plx to",
    "    fill in missing values with the next available value of the same vertical column. This operator",
    "    requires all variables on the same horizontal grid.  Missing values in the input data are not",
    "    supported.",
    "",
    "PARAMETERS",
    "",
    "    levels (Float)",
    "           Comma-separated list of pressure levels in pascal",
    "",
    "NOTE",
    "    This is a specific implementation for NetCDF files from the ICON model, it may not work with data",
    "    from other sources.",
    "",
    "EXAMPLE",
    "    To interpolate 3D variables on hybrid sigma height level to pressure levels of 925, 850, 500 and",
    "    200 hPa use:",
    "",
    "       cdo ap2pl,92500,85000,50000,20000 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp VertintghHelp = {
    "NAME",
    "    gh2hl - Geometric height interpolation",
    "",
    "SYNOPSIS",
    "    cdo  gh2hl,levels  infile outfile",
    "",
    "DESCRIPTION",
    "    Interpolate 3D variables on hybrid sigma height coordinates to height levels.  A basic linear",
    "    method is used for interpolation. The input file must contain the 3D geometric height in meter.",
    "    The geometric height is identified by the NetCDF CF standard name",
    "    geometric_height_at_full_level_center.  Use the alias gh2hlx to fill in missing values with the",
    "    next available value of the same vertical column. This operator requires all variables on the same",
    "    horizontal grid.  Missing values in the input data are not supported.",
    "",
    "PARAMETERS",
    "",
    "    levels (Float)",
    "           Comma-separated list of height levels in meter",
    "",
    "NOTE",
    "    This is a specific implementation for NetCDF files from the ICON model, it may not work with data",
    "    from other sources.",
    "",
    "EXAMPLE",
    "    To interpolate 3D variables on hybrid sigma height level to height levels of 20, 100, 500, 1000,",
    "    5000, 10000 and 20000 meter use:",
    "",
    "       cdo gh2hl,20,100,500,1000,5000,10000,20000 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp VertintmlHelp = {
    "NAME",
    "    ml2pl - Model to pressure level interpolation",
    "",
    "SYNOPSIS",
    "    cdo  ml2pl,plevels  infile outfile",
    "",
    "DESCRIPTION",
    "    Interpolates 3D variables on hybrid sigma pressure level to pressure levels.  A basic linear",
    "    method is used for interpolation.  To calculate the pressure on model levels, the a and b",
    "    coefficients defining the model levels and the surface pressure are required. The a and b",
    "    coefficients are normally part of the model level data.  If not available, the surface pressure",
    "    can be derived from the logarithm of the surface pressure.  To extrapolate the temperature, the",
    "    surface geopotential is also needed.  The geopotential height must be present at the hybrid layer",
    "    interfaces (model half-layers)!  All needed variables are identified by their GRIB1 code number or",
    "    NetCDF CF standard name.  Supported parameter tables are: WMO standard table number 2 and ECMWF",
    "    local table number 128.",
    "",
    "                   ┌─────────────────────┬────────┬────────────┬──────────────────────┐",
    "                   │Name                 │ Units  │ GRIB1 code │ CF standard name     │",
    "                   ├─────────────────────┼────────┼────────────┼──────────────────────┤",
    "                   │log surface pressure │ Pa     │ 152        │                      │",
    "                   ├─────────────────────┼────────┼────────────┼──────────────────────┤",
    "                   │surface pressure     │ Pa     │ 134        │ surface_air_pressure │",
    "                   ├─────────────────────┼────────┼────────────┼──────────────────────┤",
    "                   │air temperature      │ K      │ 130        │ air_temperature      │",
    "                   ├─────────────────────┼────────┼────────────┼──────────────────────┤",
    "                   │surface geopotential │ m2 s-2 │ 129        │ surface_geopotential │",
    "                   ├─────────────────────┼────────┼────────────┼──────────────────────┤",
    "                   │geopotential height  │ m      │ 156        │ geopotential_height  │",
    "                   └─────────────────────┴────────┴────────────┴──────────────────────┘",
    "    Use the alias ml2plx to fill in missing values with the next available value of the same vertical",
    "    column.  Only the temperature is extrapolated in this case. The extrapolation method originates",
    "    from the ECHAM postprocessing.  This operator requires all variables on the same horizontal grid.",
    "    Missing values in the input data are not supported.",
    "",
    "PARAMETERS",
    "",
    "    plevels (Float)",
    "           Pressure levels in pascal",
    "",
    "NOTE",
    "    This is a specific implementation for data from the ECHAM model, it may not work with data from",
    "    other sources.  The components of the hybrid coordinate must always be available at the hybrid",
    "    layer interfaces even if the data is defined at the hybrid layer midpoints.",
    "",
    "EXAMPLE",
    "    To interpolate hybrid model level data to pressure levels of 925, 850, 500 and 200 hPa use:",
    "",
    "       cdo ml2pl,92500,85000,50000,20000 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp VertstatHelp = {
    "NAME",
    "    vertmin, vertmax, vertrange, vertsum, vertmean, vertavg, vertstd, vertstd1, vertvar, vertvar1 -",
    "    Vertical statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over all levels of the input variables.  According to",
    "    chosen operator the vertical minimum, maximum, range, sum, average, variance or standard deviation",
    "    is written to outfile.  Weighting based on layer thickness can be disabled with the parameter",
    "    weights=FALSE.",
    "",
    "OPERATORS",
    "",
    "    vertmin",
    "           Vertical minimum",
    "",
    "           For every gridpoint the minimum over all levels is computed.",
    "",
    "    vertmax",
    "           Vertical maximum",
    "",
    "           For every gridpoint the maximum over all levels is computed.",
    "",
    "    vertrange",
    "           Vertical range",
    "",
    "           For every gridpoint the range over all levels is computed.",
    "",
    "    vertsum",
    "           Vertical sum",
    "",
    "           For every gridpoint the sum over all levels is computed.",
    "",
    "    vertmean",
    "           Vertical mean",
    "",
    "           For every gridpoint the weighted mean over all levels is computed.",
    "",
    "    vertavg",
    "           Vertical average",
    "",
    "           For every gridpoint the weighted average over all levels is computed.",
    "",
    "    vertvar",
    "           Vertical variance",
    "",
    "           For every gridpoint the weighted variance over all levels is computed. Normalize by n.",
    "",
    "    vertvar1",
    "           Vertical variance (n-1)",
    "",
    "           For every gridpoint the weighted variance over all levels is computed. Normalize by (n-1).",
    "",
    "    vertstd",
    "           Vertical standard deviation",
    "",
    "           For every gridpoint the weighted standard deviation over all levels is computed. Normalize",
    "           by n.",
    "",
    "    vertstd1",
    "           Vertical standard deviation (n-1)",
    "",
    "           For every gridpoint the weighted standard deviation over all levels is computed. Normalize",
    "           by (n-1).",
    "",
    "PARAMETERS",
    "",
    "    weights (BOOL)",
    "           weights=FALSE disables weighting with layer thickness [default: weights=TRUE]",
    "",
    "EXAMPLE",
    "    To compute the vertical sum of all input variables use:",
    "",
    "       cdo vertsum infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp WctHelp = {
    "NAME",
    "    wct - Windchill temperature",
    "",
    "SYNOPSIS",
    "    cdo  wct  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    Let infile1 and infile2 be time series of temperature and wind speed fields, then a corresponding",
    "    time series of resulting windchill temperatures is written to outfile. The wind chill temperature",
    "    calculation is only valid for a temperature of T <= 33°C and a wind speed of v >= 1.39 m/s.",
    "    Whenever these conditions are not satisfied, a missing value is written to outfile. Note that",
    "    temperature and wind speed fields have to be given in units of °C and m/s, respectively.",
    "",
    "AUTHOR",
    "    Ralf Quast",
    "",
};

const CdoHelp WindHelp = {
    "NAME",
    "    dv2uv, uv2dv - Wind transformation",
    "",
    "SYNOPSIS",
    "    cdo  <operator>[,gridtype]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module converts relative divergence and vorticity to U and V wind and vice versa.  Divergence",
    "    and vorticity are spherical harmonic coefficients in spectral space and U and V are on a global",
    "    regular Gaussian grid. The Gaussian latitudes need to be ordered from north to south. Missing",
    "    values are not supported.",
    "",
    "    The relationship between the spectral resolution, governed by the truncation number T, and the",
    "    grid resolution depends on the number of grid points at which the shortest wavelength field is",
    "    represented.  For a grid with 2N points between the poles (so 4N grid points in total around the",
    "    globe) the relationship is:",
    "",
    "    linear grid: the shortest wavelength is represented by 2 grid points -> 4N ~= 2(TL + 1)",
    "    quadratic grid: the shortest wavelength is represented by 3 grid points -> 4N ~= 3(TQ + 1)",
    "    cubic grid: the shortest wavelength is represented by 4 grid points -> 4N ~= 4(TC + 1)",
    "",
    "",
    "    The quadratic grid is used by ECHAM and ERA15. ERA40 is using a linear Gaussian grid reflected by",
    "    the TL notation.",
    "",
    "    The following table shows the calculation of the number of latitudes and the triangular truncation",
    "    for the different grid types:",
    "",
    "                   ┌──────────┬───────────────────────────┬────────────────────────────┐",
    "                   │Gridtype  │ Number of latitudes: nlat │ Triangular truncation: ntr │",
    "                   ├──────────┼───────────────────────────┼────────────────────────────┤",
    "                   │linear    │ NINT((ntr*2 + 1)/2)       │ (nlat*2 - 1) / 2           │",
    "                   ├──────────┼───────────────────────────┼────────────────────────────┤",
    "                   │quadratic │ NINT((ntr*3 + 1)/2)       │ (nlat*2 - 1) / 3           │",
    "                   ├──────────┼───────────────────────────┼────────────────────────────┤",
    "                   │cubic     │ NINT((ntr*4 + 1)/2)       │ (nlat*2 - 1) / 4           │",
    "                   └──────────┴───────────────────────────┴────────────────────────────┘",
    "OPERATORS",
    "",
    "    dv2uv  Divergence and vorticity to U and V wind",
    "",
    "           Calculate U and V wind on a Gaussian grid from spherical harmonic coefficients of relative",
    "           divergence and vorticity. The divergence and vorticity need to have the names sd and svo or",
    "           code numbers 155 and 138.",
    "",
    "    uv2dv  U and V wind to divergence and vorticity",
    "",
    "           Calculate spherical harmonic coefficients of relative divergence and vorticity from U and V",
    "           wind. The U and V wind need to be on a Gaussian grid and need to have the names u and v or",
    "           the code numbers 131 and 132.",
    "",
    "PARAMETERS",
    "",
    "    gridtype (STRING)",
    "           Type of the grid: quadratic, linear, cubic (default: quadratic)",
    "",
    "NOTE",
    "    To speed up the calculations, the Legendre polynoms are kept in memory. This requires a relatively",
    "    large amount of memory. This is for example 12GB for T1279 data.",
    "",
    "EXAMPLE",
    "    Assume a dataset has at least spherical harmonic coefficients of divergence and vorticity.  To",
    "    transform the spectral divergence and vorticity to U and V wind on a Gaussian grid use:",
    "",
    "       cdo dv2uv infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp Wind2Help = {
    "NAME",
    "    dv2ps - D and V to vel. potential and stream function",
    "",
    "SYNOPSIS",
    "    cdo  dv2ps  infile outfile",
    "",
    "DESCRIPTION",
    "    Calculate spherical harmonic coefficients of velocity potential and stream function from spherical",
    "    harmonic coefficients of relative divergence and vorticity. The divergence and vorticity need to",
    "    have the names sd and svo or code numbers 155 and 138.",
    "",
};

const CdoHelp WindtransHelp = {
    "NAME",
    "    uvDestag, rotuvNorth, projuvLatLon - Wind transformation",
    "",
    "SYNOPSIS",
    "    cdo  uvDestag,u,v[,-/+0.5,-/+0.5]  infile outfile",
    "",
    "    cdo  rotuvNorth,u,v  infile outfile",
    "",
    "    cdo  projuvLatLon,u,v  infile outfile",
    "",
    "DESCRIPTION",
    "    This module contains special operators for datsets with wind components on a rotated lon/lat grid,",
    "    e.g. data from the regional model HIRLAM or [REMO].",
    "",
    "OPERATORS",
    "",
    "    uvDestag",
    "           Destaggering of u/v wind components",
    "",
    "           This is a special operator for destaggering of wind components.  If the file contains a",
    "           grid with temperature (name=’t’ or code=11) then grid_temp will be used for destaggered",
    "           wind.",
    "",
    "    rotuvNorth",
    "           Rotate u/v wind to North pole",
    "",
    "           This is an operator for transformation of wind-vectors from grid-relative to north-pole",
    "           relative for the whole file. (FAST implementation with JACOBIANS)",
    "",
    "    projuvLatLon",
    "           Cylindrical Equidistant projection",
    "",
    "           Thus is an operator for transformation of wind-vectors from the globe-spherical coordinate",
    "           system into a flat Cylindrical Equidistant (lat-lon) projection. (FAST JACOBIAN",
    "           implementation)",
    "",
    "PARAMETERS",
    "",
    "    u,v (STRING)",
    "           Pair of u,v wind components (use variable names or code numbers)",
    "",
    "    -/+0.5,-/+0.5 (STRING)",
    "           Destaggered grid offsets are optional (default -0.5,-0.5)",
    "",
    "EXAMPLE",
    "    Typical operator sequence on HIRLAM NWP model output (LAMH_D11 files):",
    "",
    "       cdo uvDestag,33,34   inputfile inputfile_destag",
    "       cdo rotuvNorth,33,34 inputfile_destag inputfile_rotuvN",
    "",
    "AUTHOR",
    "    Michal Koutek",
    "",
};

const CdoHelp XsinfoHelp = {
    "NAME",
    "    xsinfo, xsinfop - Extra short information",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infiles",
    "",
    "DESCRIPTION",
    "    This module writes extra short information about the structure of infiles to standard output.",
    "    infiles is an arbitrary number of input files. All input files need to have the same structure",
    "    with the same variables on different timesteps.  The information displayed depends on the chosen",
    "    operator.",
    "",
    "OPERATORS",
    "",
    "    xsinfo Extra short information listed by name",
    "",
    "           Prints extra short information of a dataset. The information is divided into 4 sections.",
    "           Section 1 prints one line per parameter with the following information:",
    "",
    "           • institute and source",
    "",
    "           • time c=constant v=varying",
    "",
    "           • type of statistical processing",
    "",
    "           • number of levels and z-axis number",
    "",
    "           • horizontal grid size and number",
    "",
    "           • data type",
    "",
    "           • memory type (float or double)",
    "",
    "           • parameter name",
    "",
    "           Section 2 to 4 gives a extra short overview of all grid, vertical and time coordinates.",
    "",
    "    xsinfop",
    "           Extra short information listed by identifier",
    "",
    "           The same as operator xsinfo but using the identifier instead of the name to label the",
    "           parameter.",
    "",
    "EXAMPLE",
    "    To print extra short information of a dataset use:",
    "",
    "       cdo xsinfo infile",
    "",
    "    This is the result of an ECHAM5 dataset with 3 parameter over 12 timesteps:",
    "",
    "        -1 : Institut Source  T Steptype Levels Num   Points Num Dtype Mtype : Name",
    "         1 : MPIMET   ECHAM5  c instant       1   1     2048   1  F32   F32 : GEOSP",
    "         2 : MPIMET   ECHAM5  v instant       4   2     2048   1  F32   F32 : T",
    "         3 : MPIMET   ECHAM5  v instant       1   1     2048   1  F32   F32 : TSURF",
    "       Grid coordinates :",
    "         1 : gaussian         : points=2048 (64x32)  F16",
    "                     longitude: 0 to 354.375 by 5.625 degrees_east  circular",
    "                      latitude: 85.7606 to -85.7606 degrees_north",
    "       Vertical coordinates :",
    "         1 : surface          : levels=1",
    "         2 : pressure         : levels=4",
    "                         level: 92500 to 20000 Pa",
    "       Time coordinate :",
    "                         steps: 12",
    "                          time: 1987-01-31T18:00:00 to 1987-12-31T18:00:00 by 1 month",
    "                         units: days since  1987-01-01T00:00:00",
    "                      calendar: proleptic_gregorian",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YdayarithHelp = {
    "NAME",
    "    ydayadd, ydaysub, ydaymul, ydaydiv - Multi-year daily arithmetic",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same day of",
    "    year.  For each field in infile1 the corresponding field of the timestep in infile2 with the same",
    "    day of year is used.  The input files need to have the same structure with the same variables.",
    "    Usually infile2 is generated by an operator of the module Ydaystat.",
    "",
    "OPERATORS",
    "",
    "    ydayadd",
    "           Add multi-year daily time series",
    "",
    "           Adds a time series and a multi-year daily time series.",
    "",
    "    ydaysub",
    "           Subtract multi-year daily time series",
    "",
    "           Subtracts a time series and a multi-year daily time series.",
    "",
    "    ydaymul",
    "           Multiply multi-year daily time series",
    "",
    "           Multiplies a time series and a multi-year daily time series.",
    "",
    "    ydaydiv",
    "           Divide multi-year daily time series",
    "",
    "           Divides a time series and a multi-year daily time series.",
    "",
    "EXAMPLE",
    "    To subtract a multi-year daily time average from a time series use:",
    "",
    "       cdo ydaysub infile -ydayavg infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YdaypctlHelp = {
    "NAME",
    "    ydaypctl - Multi-year daily percentile",
    "",
    "SYNOPSIS",
    "    cdo  ydaypctl,pn  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each day of year in infile1 to outfile.  The",
    "    algorithm uses histograms with minimum and maximum bounds given in infile2 and infile3,",
    "    respectively. The default number of histogram bins is 101. The default can be overridden by",
    "    setting the environment variable CDO_PCTL_NBINS to a different value.  The files infile2 and",
    "    infile3 should be the result of corresponding ydaymin and ydaymax operations, respectively.  The",
    "    date information in an output field is the date of the last contributing input field.",
    "",
    "       o(001,x) = pth percentile {i(t,x), day(i(t)) = 001}",
    "                   ...",
    "       o(366,x) = pth percentile {i(t,x), day(i(t)) = 366}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "EXAMPLE",
    "    To compute the daily 90th percentile over all input years use:",
    "",
    "       cdo ydaymin infile minfile",
    "       cdo ydaymax infile maxfile",
    "       cdo ydaypctl,90 infile minfile maxfile outfile",
    "",
    "    Or shorter using operator piping:",
    "",
    "       cdo ydaypctl,90 infile -ydaymin infile -ydaymax infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YdaystatHelp = {
    "NAME",
    "    ydaymin, ydaymax, ydayrange, ydaysum, ydaymean, ydayavg, ydaystd, ydaystd1, ydayvar, ydayvar1 -",
    "    Multi-year daily statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each day of year.  Depending on the chosen operator the",
    "    minimum, maximum, range, sum, average, variance or standard deviation of each day of year in",
    "    infile is written to outfile.  The date information in an output field is the date of the last",
    "    contributing input field.",
    "",
    "OPERATORS",
    "",
    "    ydaymin",
    "           Multi-year daily minimum",
    "",
    "              o(001,x) = min{i(t,x), day(i(t)) = 001}",
    "                          ...",
    "              o(366,x) = min{i(t,x), day(i(t)) = 366}",
    "",
    "    ydaymax",
    "           Multi-year daily maximum",
    "",
    "              o(001,x) = max{i(t,x), day(i(t)) = 001}",
    "                          ...",
    "              o(366,x) = max{i(t,x), day(i(t)) = 366}",
    "",
    "    ydayrange",
    "           Multi-year daily range",
    "",
    "              o(001,x) = range{i(t,x), day(i(t)) = 001}",
    "                          ...",
    "              o(366,x) = range{i(t,x), day(i(t)) = 366}",
    "",
    "    ydaysum",
    "           Multi-year daily sum",
    "",
    "              o(001,x) = sum{i(t,x), day(i(t)) = 001}",
    "                          ...",
    "              o(366,x) = sum{i(t,x), day(i(t)) = 366}",
    "",
    "    ydaymean",
    "           Multi-year daily mean",
    "",
    "              o(001,x) = mean{i(t,x), day(i(t)) = 001}",
    "                          ...",
    "              o(366,x) = mean{i(t,x), day(i(t)) = 366}",
    "",
    "    ydayavg",
    "           Multi-year daily average",
    "",
    "              o(001,x) = avg{i(t,x), day(i(t)) = 001}",
    "                          ...",
    "              o(366,x) = avg{i(t,x), day(i(t)) = 366}",
    "",
    "    ydayvar",
    "           Multi-year daily variance",
    "",
    "           Normalize by n.",
    "",
    "              o(001,x) = var{i(t,x), day(i(t)) = 001}",
    "                          ...",
    "              o(366,x) = var{i(t,x), day(i(t)) = 366}",
    "",
    "    ydayvar1",
    "           Multi-year daily variance (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(001,x) = var1{i(t,x), day(i(t)) = 001}",
    "                          ...",
    "              o(366,x) = var1{i(t,x), day(i(t)) = 366}",
    "",
    "    ydaystd",
    "           Multi-year daily standard deviation",
    "",
    "           Normalize by n.",
    "",
    "              o(001,x) = std{i(t,x), day(i(t)) = 001}",
    "                          ...",
    "              o(366,x) = std{i(t,x), day(i(t)) = 366}",
    "",
    "    ydaystd1",
    "           Multi-year daily standard deviation (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(001,x) = std1{i(t,x), day(i(t)) = 001}",
    "                          ...",
    "              o(366,x) = std1{i(t,x), day(i(t)) = 366}",
    "",
    "EXAMPLE",
    "    To compute the daily mean over all input years use:",
    "",
    "       cdo ydaymean infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YdrunpctlHelp = {
    "NAME",
    "    ydrunpctl - Multi-year daily running percentile",
    "",
    "SYNOPSIS",
    "    cdo  ydrunpctl,pn,nts[,rm=c][,pm=r8] infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator writes running percentile values for each day of year in infile1 to outfile.  A",
    "    certain percentile is computed for all timesteps in running windows of which the medium timestep",
    "    corresponds to a certain day of year.  The algorithm uses histograms with minimum and maximum",
    "    bounds given in infile2 and infile3, respectively. The default number of histogram bins is 101.",
    "    The default can be overridden by setting the environment variable CDO_PCTL_NBINS to a different",
    "    value. The files infile2 and infile3 should be the result of corresponding ydrunmin and ydrunmax",
    "    operations, respectively.  The date information in an output field is the date of the timestep in",
    "    the middle of the last contributing running window.  Note that the operator have to be applied to",
    "    a continuous time series of daily measurements in order to yield physically meaningful results.",
    "    Also note that the output time series begins (nts-1)/2 timesteps after the first timestep of the",
    "    input time series and ends (nts-1)/2 timesteps before the last.  For input data which are complete",
    "    but not continuous, such as time series of daily measurements for the same month or season within",
    "    different years, the operator only yields physically meaningful results if the input time series",
    "    does include the (nts-1)/2 days before and after each period of interest.",
    "",
    "       o(001,x) = pth percentile {i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                   ...",
    "       o(366,x) = pth percentile {i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "    nts (INTEGER)",
    "           Number of timesteps",
    "",
    "    rm=c (STRING)",
    "           Read method circular",
    "",
    "    pm=r8 (STRING)",
    "           Percentile method rtype8",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "EXAMPLE",
    "    Assume the input data provide a continuous time series of daily measurements. To compute the",
    "    running multi-year daily 90th percentile over all input timesteps for a running window of five",
    "    days use:",
    "",
    "       cdo ydrunmin,5 infile minfile",
    "       cdo ydrunmax,5 infile maxfile",
    "       cdo ydrunpctl,90,5 infile minfile maxfile outfile",
    "",
    "    Or shorter using operator piping:",
    "",
    "       cdo ydrunpctl,90,5 infile -ydrunmin infile -ydrunmax infile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Uwe Schulzweida, Fabian Wachsmann",
    "",
};

const CdoHelp YdrunstatHelp = {
    "NAME",
    "    ydrunmin, ydrunmax, ydrunsum, ydrunmean, ydrunavg, ydrunstd, ydrunstd1, ydrunvar, ydrunvar1 -",
    "    Multi-year daily running statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>,nts[,rm=c]  infile outfile",
    "",
    "DESCRIPTION",
    "    This module writes running statistical values for each day of year in infile to outfile.",
    "    Depending on the chosen operator, the minimum, maximum, sum, average, variance or standard",
    "    deviation of all timesteps in running windows of which the medium timestep corresponds to a",
    "    certain day of year is computed. The date information in an output field is the date of the",
    "    timestep in the middle of the last contributing running window.  Note that the operator have to be",
    "    applied to a continuous time series of daily measurements in order to yield physically meaningful",
    "    results. Also note that the output time series begins (nts-1)/2 timesteps after the first timestep",
    "    of the input time series and ends (nts-1)/2 timesteps before the last one.  For input data which",
    "    are complete but not continuous, such as time series of daily measurements for the same month or",
    "    season within different years, the operator yields physically meaningful results only if the input",
    "    time series does include the (nts-1)/2 days before and after each period of interest.",
    "",
    "OPERATORS",
    "",
    "    ydrunmin",
    "           Multi-year daily running minimum",
    "",
    "              o(001,x) = min{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                          ...",
    "              o(366,x) = min{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "    ydrunmax",
    "           Multi-year daily running maximum",
    "",
    "              o(001,x) = max{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                          ...",
    "              o(366,x) = max{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "    ydrunsum",
    "           Multi-year daily running sum",
    "",
    "              o(001,x) = sum{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                          ...",
    "              o(366,x) = sum{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "    ydrunmean",
    "           Multi-year daily running mean",
    "",
    "              o(001,x) = mean{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                          ...",
    "              o(366,x) = mean{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "    ydrunavg",
    "           Multi-year daily running average",
    "",
    "              o(001,x) = avg{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                          ...",
    "              o(366,x) = avg{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "    ydrunvar",
    "           Multi-year daily running variance",
    "",
    "           Normalize by n.",
    "",
    "              o(001,x) = var{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                          ...",
    "              o(366,x) = var{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "    ydrunvar1",
    "           Multi-year daily running variance (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(001,x) = var1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 001}",
    "                          ...",
    "              o(366,x) = var1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[(i(t+(nts-1)/2)] = 366}",
    "",
    "    ydrunstd",
    "           Multi-year daily running standard deviation",
    "",
    "           Normalize by n.",
    "",
    "              o(001,x) = std{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 001}",
    "                          ...",
    "              o(366,x) = std{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 366}",
    "",
    "    ydrunstd1",
    "           Multi-year daily running standard deviation (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(001,x) = std1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 001}",
    "                          ...",
    "              o(366,x) = std1{i(t,x), i(t+1,x), ..., i(t+nts-1,x); day[i(t+(nts-1)/2)] = 366}",
    "",
    "PARAMETERS",
    "",
    "    nts (INTEGER)",
    "           Number of timesteps",
    "",
    "    rm=c (STRING)",
    "           Read method circular",
    "",
    "EXAMPLE",
    "    Assume the input data provide a continuous time series of daily measurements. To compute the",
    "    running multi-year daily mean over all input timesteps for a running window of five days use:",
    "",
    "       cdo ydrunmean,5 infile outfile",
    "",
    "    Note that except for the standard deviation the results of the operators in this module are",
    "    equivalent to a composition of corresponding operators from the Ydaystat and Runstat modules. For",
    "    instance, the above command yields the same result as:",
    "",
    "       cdo ydaymean -runmean,5 infile outfile",
    "",
    "AUTHOR",
    "    Ralf Quast, Uwe Schulzweida, Fabian Wachsmann",
    "",
};

const CdoHelp YeararithHelp = {
    "NAME",
    "    yearadd, yearsub, yearmul, yeardiv - Yearly arithmetic",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same year. For",
    "    each field in infile1 the corresponding field of the timestep in infile2 with the same year is",
    "    used.  The header information in infile1 have to be the same as in infile2.  Usually infile2 is",
    "    generated by an operator of the module Yearstat.",
    "",
    "OPERATORS",
    "",
    "    yearadd",
    "           Add yearly time series",
    "",
    "           Adds a time series and a yearly time series.",
    "",
    "    yearsub",
    "           Subtract yearly time series",
    "",
    "           Subtracts a time series and a yearly time series.",
    "",
    "    yearmul",
    "           Multiply yearly time series",
    "",
    "           Multiplies a time series and a yearly time series.",
    "",
    "    yeardiv",
    "           Divide yearly time series",
    "",
    "           Divides a time series and a yearly time series.",
    "",
    "EXAMPLE",
    "    To subtract a yearly time average from a time series use:",
    "",
    "       cdo yearsub infile -yearavg infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YearmonstatHelp = {
    "NAME",
    "    yearmonmean - Yearly mean from monthly data",
    "",
    "SYNOPSIS",
    "    cdo  yearmonmean  infile outfile",
    "",
    "DESCRIPTION",
    "    This operator computes the yearly mean of a monthly time series.  Each month is weighted with the",
    "    number of days per month.  The time of outfile is determined by the time in the middle of all",
    "    contributing timesteps of infile.  This can be change with the CDO option –timestat_date",
    "    <first|middle|last>.",
    "",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "",
    "    o(t,x) = mean{i(t’,x), t_1<=t’<=t_n}",
    "",
    "EXAMPLE",
    "    To compute the yearly mean of a monthly time series use:",
    "",
    "       cdo yearmonmean infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YearpctlHelp = {
    "NAME",
    "    yearpctl - Yearly percentile",
    "",
    "SYNOPSIS",
    "    cdo  yearpctl,pn  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator computes percentiles over all timesteps of the same year in infile1.  The algorithm",
    "    uses histograms with minimum and maximum bounds given in infile2 and infile3, respectively. The",
    "    default number of histogram bins is 101. The default can be overridden by defining the environment",
    "    variable CDO_PCTL_NBINS. The files infile2 and infile3 should be the result of corresponding",
    "    yearmin and yearmax operations, respectively.  The time of outfile is determined by the time in",
    "    the middle of all contributing timesteps of infile1.  This can be change with the CDO option",
    "    –timestat_date <first|middle|last>.",
    "",
    "    For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "",
    "    o(t,x) = pth percentile {i(t’,x), t_1<=t’<=t_n}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "EXAMPLE",
    "    To compute the yearly 90th percentile of a time series use:",
    "",
    "       cdo yearmin infile minfile",
    "       cdo yearmax infile maxfile",
    "       cdo yearpctl,90 infile minfile maxfile outfile",
    "",
    "    Or shorter using operator piping:",
    "",
    "       cdo yearpctl,90 infile -yearmin infile -yearmax infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YearstatHelp = {
    "NAME",
    "    yearmin, yearmax, yearminidx, yearmaxidx, yearrange, yearsum, yearmean, yearavg, yearstd,",
    "    yearstd1, yearvar, yearvar1 - Yearly statistics",
    "",
    "SYNOPSIS",
    "    cdo [options]  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values over timesteps of the same year.  Depending on the chosen",
    "    operator the minimum, maximum, range, sum, average, variance or standard deviation of timesteps of",
    "    the same year is written to outfile.  The time of outfile is determined by the time in the middle",
    "    of all contributing timesteps of infile.  This can be change with the CDO option –timestat_date",
    "    <first|middle|last>.  Set the parameter complete_only=TRUE to process the last year only when it",
    "    is complete.",
    "",
    "OPERATORS",
    "",
    "    yearmin",
    "           Yearly minimum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "",
    "           o(t,x) = min{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    yearmax",
    "           Yearly maximum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "",
    "           o(t,x) = max{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    yearminidx",
    "           Index of yearly minimum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "",
    "           o(t,x) = minidx{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    yearmaxidx",
    "           Index of yearly maximum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "",
    "           o(t,x) = maxidx{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    yearrange",
    "           Yearly range",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "",
    "           o(t,x) = range{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    yearsum",
    "           Yearly sum",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "",
    "           o(t,x) = sum{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    yearmean",
    "           Yearly mean",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "",
    "           o(t,x) = mean{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    yearavg",
    "           Yearly average",
    "",
    "           For every adjacent sequence t_1, ...,t_n of timesteps of the same year it is:",
    "",
    "           o(t,x) = avg{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    yearvar",
    "           Yearly variance",
    "",
    "           Normalize by n.  For every adjacent sequence t_1, ...,t_n of timesteps of the same year it",
    "           is:",
    "",
    "           o(t,x) = var{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    yearvar1",
    "           Yearly variance (n-1)",
    "",
    "           Normalize by (n-1).  For every adjacent sequence t_1, ...,t_n of timesteps of the same year",
    "           it is:",
    "",
    "           o(t,x) = var1{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    yearstd",
    "           Yearly standard deviation",
    "",
    "           Normalize by n.  For every adjacent sequence t_1, ...,t_n of timesteps of the same year it",
    "           is:",
    "",
    "           o(t,x) = std{i(t’,x), t_1<=t’<=t_n}",
    "",
    "    yearstd1",
    "           Yearly standard deviation (n-1)",
    "",
    "           Normalize by (n-1).  For every adjacent sequence t_1, ...,t_n of timesteps of the same year",
    "           it is:",
    "",
    "           o(t,x) = std1{i(t’,x), t_1<=t’<=t_n}",
    "",
    "PARAMETERS",
    "",
    "    complete_only (BOOL)",
    "           Process the last year only when it is complete",
    "",
    "OPTIONS",
    "    -S, --diagnostic to create a diagnostic output stream with the number of non missing values for",
    "    each output period.",
    "",
    "    -p, --async_read true to read input data asynchronously.",
    "",
    "NOTE",
    "    The operators yearmean and yearavg compute only arithmetical means!",
    "",
    "EXAMPLE",
    "    To compute the yearly mean of a time series use:",
    "",
    "       cdo yearmean infile outfile",
    "",
    "    To compute the yearly mean from the correct weighted monthly mean use:",
    "",
    "       cdo yearmonmean infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YhourarithHelp = {
    "NAME",
    "    yhouradd, yhoursub, yhourmul, yhourdiv - Multi-year hourly arithmetic",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same hour and",
    "    day of year.  For each field in infile1 the corresponding field of the timestep in infile2 with",
    "    the same hour and day of year is used.  The input files need to have the same structure with the",
    "    same variables.  Usually infile2 is generated by an operator of the module Yhourstat.",
    "",
    "OPERATORS",
    "",
    "    yhouradd",
    "           Add multi-year hourly time series",
    "",
    "           Adds a time series and a multi-year hourly time series.",
    "",
    "    yhoursub",
    "           Subtract multi-year hourly time series",
    "",
    "           Subtracts a time series and a multi-year hourly time series.",
    "",
    "    yhourmul",
    "           Multiply multi-year hourly time series",
    "",
    "           Multiplies a time series and a multi-year hourly time series.",
    "",
    "    yhourdiv",
    "           Divide multi-year hourly time series",
    "",
    "           Divides a time series and a multi-year hourly time series.",
    "",
    "EXAMPLE",
    "    To subtract a multi-year hourly time average from a time series use:",
    "",
    "       cdo yhoursub infile -yhouravg infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YhourstatHelp = {
    "NAME",
    "    yhourmin, yhourmax, yhourrange, yhoursum, yhourmean, yhouravg, yhourstd, yhourstd1, yhourvar,",
    "    yhourvar1 - Multi-year hourly statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each hour and day of year.  Depending on the chosen",
    "    operator the minimum, maximum, range, sum, average, variance or standard deviation of each hour",
    "    and day of year in infile is written to outfile.  The date information in an output field is the",
    "    date of the last contributing input field.",
    "",
    "OPERATORS",
    "",
    "    yhourmin",
    "           Multi-year hourly minimum",
    "",
    "              o(0001,x) = min{i(t,x), day(i(t)) = 0001}",
    "                              ...",
    "              o(8784,x) = min{i(t,x), day(i(t)) = 8784}",
    "",
    "    yhourmax",
    "           Multi-year hourly maximum",
    "",
    "              o(0001,x) = max{i(t,x), day(i(t)) = 0001}",
    "                              ...",
    "              o(8784,x) = max{i(t,x), day(i(t)) = 8784}",
    "",
    "    yhourrange",
    "           Multi-year hourly range",
    "",
    "              o(0001,x) = range{i(t,x), day(i(t)) = 0001}",
    "                              ...",
    "              o(8784,x) = range{i(t,x), day(i(t)) = 8784}",
    "",
    "    yhoursum",
    "           Multi-year hourly sum",
    "",
    "              o(0001,x) = sum{i(t,x), day(i(t)) = 0001}",
    "                              ...",
    "              o(8784,x) = sum{i(t,x), day(i(t)) = 8784}",
    "",
    "    yhourmean",
    "           Multi-year hourly mean",
    "",
    "              o(0001,x) = mean{i(t,x), day(i(t)) = 0001}",
    "                              ...",
    "              o(8784,x) = mean{i(t,x), day(i(t)) = 8784}",
    "",
    "    yhouravg",
    "           Multi-year hourly average",
    "",
    "              o(0001,x) = avg{i(t,x), day(i(t)) = 0001}",
    "                              ...",
    "              o(8784,x) = avg{i(t,x), day(i(t)) = 8784}",
    "",
    "    yhourvar",
    "           Multi-year hourly variance",
    "",
    "           Normalize by n.",
    "",
    "              o(0001,x) = var{i(t,x), day(i(t)) = 0001}",
    "                              ...",
    "              o(8784,x) = var{i(t,x), day(i(t)) = 8784}",
    "",
    "    yhourvar1",
    "           Multi-year hourly variance (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(0001,x) = var1{i(t,x), day(i(t)) = 0001}",
    "                              ...",
    "              o(8784,x) = var1{i(t,x), day(i(t)) = 8784}",
    "",
    "    yhourstd",
    "           Multi-year hourly standard deviation",
    "",
    "           Normalize by n.",
    "",
    "              o(0001,x) = std{i(t,x), day(i(t)) = 0001}",
    "                              ...",
    "              o(8784,x) = std{i(t,x), day(i(t)) = 8784}",
    "",
    "    yhourstd1",
    "           Multi-year hourly standard deviation (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(0001,x) = std1{i(t,x), day(i(t)) = 0001}",
    "                              ...",
    "              o(8784,x) = std1{i(t,x), day(i(t)) = 8784}",
    "",
    "EXAMPLE",
    "    To compute the hourly mean for all days over all input years use:",
    "",
    "       cdo yhourmean infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YmonarithHelp = {
    "NAME",
    "    ymonadd, ymonsub, ymonmul, ymondiv - Multi-year monthly arithmetic",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same month of",
    "    year.  For each field in infile1 the corresponding field of the timestep in infile2 with the same",
    "    month of year is used.  The input files need to have the same structure with the same variables.",
    "    Usually infile2 is generated by an operator of the module Ymonstat.",
    "",
    "OPERATORS",
    "",
    "    ymonadd",
    "           Add multi-year monthly time series",
    "",
    "           Adds a time series and a multi-year monthly time series.",
    "",
    "    ymonsub",
    "           Subtract multi-year monthly time series",
    "",
    "           Subtracts a time series and a multi-year monthly time series.",
    "",
    "    ymonmul",
    "           Multiply multi-year monthly time series",
    "",
    "           Multiplies a time series with a multi-year monthly time series.",
    "",
    "    ymondiv",
    "           Divide multi-year monthly time series",
    "",
    "           Divides a time series by a multi-year monthly time series.",
    "",
    "EXAMPLE",
    "    To subtract a multi-year monthly time average from a time series use:",
    "",
    "       cdo ymonsub infile -ymonavg infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YmoncompHelp = {
    "NAME",
    "    ymoneq, ymonne, ymonle, ymonlt, ymonge, ymongt - Multi-year monthly comparison",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs comparisons of a time series and one timestep with the same month of year.",
    "    For each field in infile1 the corresponding field of the timestep in infile2 with the same month",
    "    of year is used.  The resulting field is a mask containing 1 if the comparison is true and 0 if",
    "    not.  The type of comparison depends on the chosen operator.  The input files need to have the",
    "    same structure with the same variables.  Usually infile2 is generated by an operator of the module",
    "    Ymonstat.",
    "",
    "OPERATORS",
    "",
    "    ymoneq Compare time series with Equal",
    "",
    "           Compares whether a time series is equal to a multi-year monthly time series.",
    "",
    "    ymonne Compare time series with NotEqual",
    "",
    "           Compares whether a time series is not equal to a multi-year monthly time series.",
    "",
    "    ymonle Compare time series with LessEqual",
    "",
    "           Compares whether a time series is less than or equal to a multi-year monthly time series.",
    "",
    "    ymonlt Compares if time series with LessThan",
    "",
    "           Compares whether a time series is less than a multi-year monthly time series.",
    "",
    "    ymonge Compares if time series with GreaterEqual",
    "",
    "           Compares whether a time series is greater than or equal to a multi-year monthly time",
    "           series.",
    "",
    "    ymongt Compares if time series with GreaterThan",
    "",
    "           Compares whether a time series is greater than a multi-year monthly time series.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YmonpctlHelp = {
    "NAME",
    "    ymonpctl - Multi-year monthly percentile",
    "",
    "SYNOPSIS",
    "    cdo  ymonpctl,pn  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each month of year in infile1 to outfile.  The",
    "    algorithm uses histograms with minimum and maximum bounds given in infile2 and infile3,",
    "    respectively. The default number of histogram bins is 101. The default can be overridden by",
    "    setting the environment variable CDO_PCTL_NBINS to a different value. The files infile2 and",
    "    infile3 should be the result of corresponding ymonmin and ymonmax operations, respectively.  The",
    "    date information in an output field is the date of the last contributing input field.",
    "",
    "       o(01,x) = pth percentile {i(t,x), month(i(t)) = 01}",
    "                   ...",
    "       o(12,x) = pth percentile {i(t,x), month(i(t)) = 12}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "EXAMPLE",
    "    To compute the monthly 90th percentile over all input years use:",
    "",
    "       cdo ymonmin infile minfile",
    "       cdo ymonmax infile maxfile",
    "       cdo ymonpctl,90 infile minfile maxfile outfile",
    "",
    "    Or shorter using operator piping:",
    "",
    "       cdo ymonpctl,90 infile -ymonmin infile -ymonmax infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YmonstatHelp = {
    "NAME",
    "    ymonmin, ymonmax, ymonrange, ymonsum, ymonmean, ymonavg, ymonstd, ymonstd1, ymonvar, ymonvar1 -",
    "    Multi-year monthly statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each month of year.  Depending on the chosen operator",
    "    the minimum, maximum, range, sum, average, variance or standard deviation of each month of year in",
    "    infile is written to outfile.  The date information in an output field is the date of the last",
    "    contributing input field.  This can be change with the CDO option –timestat_date",
    "    <first|middle|last>.",
    "",
    "OPERATORS",
    "",
    "    ymonmin",
    "           Multi-year monthly minimum",
    "",
    "              o(01,x) = min{i(t,x), month(i(t)) = 01}",
    "                          ...",
    "              o(12,x) = min{i(t,x), month(i(t)) = 12}",
    "",
    "    ymonmax",
    "           Multi-year monthly maximum",
    "",
    "              o(01,x) = max{i(t,x), month(i(t)) = 01}",
    "                          ...",
    "              o(12,x) = max{i(t,x), month(i(t)) = 12}",
    "",
    "    ymonrange",
    "           Multi-year monthly range",
    "",
    "              o(01,x) = range{i(t,x), month(i(t)) = 01}",
    "                          ...",
    "              o(12,x) = range{i(t,x), month(i(t)) = 12}",
    "",
    "    ymonsum",
    "           Multi-year monthly sum",
    "",
    "              o(01,x) = sum{i(t,x), month(i(t)) = 01}",
    "                          ...",
    "              o(12,x) = sum{i(t,x), month(i(t)) = 12}",
    "",
    "    ymonmean",
    "           Multi-year monthly mean",
    "",
    "              o(01,x) = mean{i(t,x), month(i(t)) = 01}",
    "                          ...",
    "              o(12,x) = mean{i(t,x), month(i(t)) = 12}",
    "",
    "    ymonavg",
    "           Multi-year monthly average",
    "",
    "              o(01,x) = avg{i(t,x), month(i(t)) = 01}",
    "                          ...",
    "              o(12,x) = avg{i(t,x), month(i(t)) = 12}",
    "",
    "    ymonvar",
    "           Multi-year monthly variance",
    "",
    "           Normalize by n.",
    "",
    "              o(01,x) = var{i(t,x), month(i(t)) = 01}",
    "                          ...",
    "              o(12,x) = var{i(t,x), month(i(t)) = 12}",
    "",
    "    ymonvar1",
    "           Multi-year monthly variance (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(01,x) = var1{i(t,x), month(i(t)) = 01}",
    "                          ...",
    "              o(12,x) = var1{i(t,x), month(i(t)) = 12}",
    "",
    "    ymonstd",
    "           Multi-year monthly standard deviation",
    "",
    "           Normalize by n.",
    "",
    "              o(01,x) = std{i(t,x), month(i(t)) = 01}",
    "                          ...",
    "              o(12,x) = std{i(t,x), month(i(t)) = 12}",
    "",
    "    ymonstd1",
    "           Multi-year monthly standard deviation (n-1)",
    "",
    "           Normalize by (n-1).",
    "",
    "              o(01,x) = std1{i(t,x), month(i(t)) = 01}",
    "                          ...",
    "              o(12,x) = std1{i(t,x), month(i(t)) = 12}",
    "",
    "EXAMPLE",
    "    To compute the monthly mean over all input years use:",
    "",
    "       cdo ymonmean infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YseasarithHelp = {
    "NAME",
    "    yseasadd, yseassub, yseasmul, yseasdiv - Multi-year seasonal arithmetic",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs simple arithmetic of a time series and one timestep with the same season.",
    "    For each field in infile1 the corresponding field of the timestep in infile2 with the same season",
    "    is used.  The input files need to have the same structure with the same variables.  Usually",
    "    infile2 is generated by an operator of the module Yseasstat.",
    "",
    "OPERATORS",
    "",
    "    yseasadd",
    "           Add multi-year seasonal time series",
    "",
    "           Adds a time series and a multi-year seasonal time series.",
    "",
    "    yseassub",
    "           Subtract multi-year seasonal time series",
    "",
    "           Subtracts a time series and a multi-year seasonal time series.",
    "",
    "    yseasmul",
    "           Multiply multi-year seasonal time series",
    "",
    "           Multiplies a time series and a multi-year seasonal time series.",
    "",
    "    yseasdiv",
    "           Divide multi-year seasonal time series",
    "",
    "           Divides a time series and a multi-year seasonal time series.",
    "",
    "EXAMPLE",
    "    To subtract a multi-year seasonal time average from a time series use:",
    "",
    "       cdo yseassub infile -yseasavg infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YseascompHelp = {
    "NAME",
    "    yseaseq, yseasne, yseasle, yseaslt, yseasge, yseasgt - Multi-year seasonal comparison",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile1 infile2 outfile",
    "",
    "DESCRIPTION",
    "    This module performs comparisons of a time series and one timestep with the same season of year.",
    "    For each field in infile1 the corresponding field of the timestep in infile2 with the same season",
    "    of year is used.  The resulting field is a mask containing 1 if the comparison is true and 0 if",
    "    not.  The type of comparison depends on the chosen operator.  The input files need to have the",
    "    same structure with the same variables.  Usually infile2 is generated by an operator of the module",
    "    @mod{YseasSTAT}.",
    "",
    "OPERATORS",
    "",
    "    yseaseq",
    "           Compare time series with Equal",
    "",
    "           Compares whether a time series is equal to a multi-year seasonal time series.",
    "",
    "    yseasne",
    "           Compare time series with NotEqual",
    "",
    "           Compares whether a time series is not equal to a multi-year seasonal time series.",
    "",
    "    yseasle",
    "           Compare time series with LessEqual",
    "",
    "           Compares whether a time series is less than or equal to a multi-year seasonal time series.",
    "",
    "    yseaslt",
    "           Compares if time series with LessThan",
    "",
    "           Compares whether a time series is less than a multi-year seasonal time series.",
    "",
    "    yseasge",
    "           Compares if time series with GreaterEqual",
    "",
    "           Compares whether a time series is greater than or equal to a multi-year seasonal time",
    "           series.",
    "",
    "    yseasgt",
    "           Compares if time series with GreaterThan",
    "",
    "           Compares whether a time series is greater than a multi-year seasonal time series.",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YseaspctlHelp = {
    "NAME",
    "    yseaspctl - Multi-year seasonal percentile",
    "",
    "SYNOPSIS",
    "    cdo  yseaspctl,pn  infile1 infile2 infile3 outfile",
    "",
    "DESCRIPTION",
    "    This operator writes a certain percentile of each season in infile1 to outfile.  The algorithm",
    "    uses histograms with minimum and maximum bounds given in infile2 and infile3, respectively. The",
    "    default number of histogram bins is 101. The default can be overridden by setting the environment",
    "    variable CDO_PCTL_NBINS to a different value. The files infile2 and infile3 should be the result",
    "    of corresponding yseasmin and yseasmax operations, respectively.  The date information in an",
    "    output field is the date of the last contributing input field.",
    "",
    "       o(1,x) = pth percentile {i(t,x), month(i(t)) = 12, 01, 02}",
    "       o(2,x) = pth percentile {i(t,x), month(i(t)) = 03, 04, 05}",
    "       o(3,x) = pth percentile {i(t,x), month(i(t)) = 06, 07, 08}",
    "       o(4,x) = pth percentile {i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "ENVIRONMENT",
    "    CDO_PCTL_NBINS sets the number of histogram bins (default: CDO_PCTL_NBINS=101).",
    "",
    "EXAMPLE",
    "    To compute the seasonal 90th percentile over all input years use:",
    "",
    "       cdo yseasmin infile minfile",
    "       cdo yseasmax infile maxfile",
    "       cdo yseaspctl,90 infile minfile maxfile outfile",
    "",
    "    Or shorter using operator piping:",
    "",
    "       cdo yseaspctl,90 infile -yseasmin infile -yseasmax infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp YseasstatHelp = {
    "NAME",
    "    yseasmin, yseasmax, yseasrange, yseassum, yseasmean, yseasavg, yseasstd, yseasstd1, yseasvar,",
    "    yseasvar1 - Multi-year seasonal statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes statistical values of each season.  Depending on the chosen operator the",
    "    minimum, maximum, range, sum, average, variance or standard deviation of each season in infile is",
    "    written to outfile.  The date information in an output field is the date of the last contributing",
    "    input field.",
    "",
    "OPERATORS",
    "",
    "    yseasmin",
    "           Multi-year seasonal minimum",
    "",
    "              o(1,x) = min{i(t,x), month(i(t)) = 12, 01, 02}",
    "              o(2,x) = min{i(t,x), month(i(t)) = 03, 04, 05}",
    "              o(3,x) = min{i(t,x), month(i(t)) = 06, 07, 08}",
    "              o(4,x) = min{i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "    yseasmax",
    "           Multi-year seasonal maximum",
    "",
    "              o(1,x) = max{i(t,x), month(i(t)) = 12, 01, 02}",
    "              o(2,x) = max{i(t,x), month(i(t)) = 03, 04, 05}",
    "              o(3,x) = max{i(t,x), month(i(t)) = 06, 07, 08}",
    "              o(4,x) = max{i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "    yseasrange",
    "           Multi-year seasonal range",
    "",
    "              o(1,x) = range{i(t,x), month(i(t)) = 12, 01, 02}",
    "              o(2,x) = range{i(t,x), month(i(t)) = 03, 04, 05}",
    "              o(3,x) = range{i(t,x), month(i(t)) = 06, 07, 08}",
    "              o(4,x) = range{i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "    yseassum",
    "           Multi-year seasonal sum",
    "",
    "              o(1,x) = sum{i(t,x), month(i(t)) = 12, 01, 02}",
    "              o(2,x) = sum{i(t,x), month(i(t)) = 03, 04, 05}",
    "              o(3,x) = sum{i(t,x), month(i(t)) = 06, 07, 08}",
    "              o(4,x) = sum{i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "    yseasmean",
    "           Multi-year seasonal mean",
    "",
    "              o(1,x) = mean{i(t,x), month(i(t)) = 12, 01, 02}",
    "              o(2,x) = mean{i(t,x), month(i(t)) = 03, 04, 05}",
    "              o(3,x) = mean{i(t,x), month(i(t)) = 06, 07, 08}",
    "              o(4,x) = mean{i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "    yseasavg",
    "           Multi-year seasonal average",
    "",
    "              o(1,x) = avg{i(t,x), month(i(t)) = 12, 01, 02}",
    "              o(2,x) = avg{i(t,x), month(i(t)) = 03, 04, 05}",
    "              o(3,x) = avg{i(t,x), month(i(t)) = 06, 07, 08}",
    "              o(4,x) = avg{i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "    yseasvar",
    "           Multi-year seasonal variance",
    "",
    "              o(1,x) = var{i(t,x), month(i(t)) = 12, 01, 02}",
    "              o(2,x) = var{i(t,x), month(i(t)) = 03, 04, 05}",
    "              o(3,x) = var{i(t,x), month(i(t)) = 06, 07, 08}",
    "              o(4,x) = var{i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "    yseasvar1",
    "           Multi-year seasonal variance (n-1)",
    "",
    "              o(1,x) = var1{i(t,x), month(i(t)) = 12, 01, 02}",
    "              o(2,x) = var1{i(t,x), month(i(t)) = 03, 04, 05}",
    "              o(3,x) = var1{i(t,x), month(i(t)) = 06, 07, 08}",
    "              o(4,x) = var1{i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "    yseasstd",
    "           Multi-year seasonal standard deviation",
    "",
    "              o(1,x) = std{i(t,x), month(i(t)) = 12, 01, 02}",
    "              o(2,x) = std{i(t,x), month(i(t)) = 03, 04, 05}",
    "              o(3,x) = std{i(t,x), month(i(t)) = 06, 07, 08}",
    "              o(4,x) = std{i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "    yseasstd1",
    "           Multi-year seasonal standard deviation (n-1)",
    "",
    "              o(1,x) = std1{i(t,x), month(i(t)) = 12, 01, 02}",
    "              o(2,x) = std1{i(t,x), month(i(t)) = 03, 04, 05}",
    "              o(3,x) = std1{i(t,x), month(i(t)) = 06, 07, 08}",
    "              o(4,x) = std1{i(t,x), month(i(t)) = 09, 10, 11}",
    "",
    "EXAMPLE",
    "    To compute the seasonal mean over all input years use:",
    "",
    "       cdo yseasmean infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

const CdoHelp ZonstatHelp = {
    "NAME",
    "    zonmin, zonmax, zonrange, zonsum, zonmean, zonavg, zonstd, zonstd1, zonvar, zonvar1, zonskew,",
    "    zonkurt, zonmedian, zonpctl - Zonal statistics",
    "",
    "SYNOPSIS",
    "    cdo  <operator>  infile outfile",
    "",
    "    cdo  zonpctl,pn  infile outfile",
    "",
    "DESCRIPTION",
    "    This module computes zonal statistical values of the input fields.  Depending on the chosen",
    "    operator, the zonal minimum, maximum, range, sum, average, standard deviation, variance, skewness,",
    "    kurtosis, median or a certain percentile of the field is written to outfile.  Operators of this",
    "    module require all variables on the same regular lon/lat grid.  Only the zonal mean (zonmean) can",
    "    be calculated for data on an unstructured grid if the latitude bins are defined with the optional",
    "    parameter zonaldes.",
    "",
    "OPERATORS",
    "",
    "    zonmin Zonal minimum",
    "",
    "           For every latitude the minimum over all longitudes is computed.",
    "",
    "    zonmax Zonal maximum",
    "",
    "           For every latitude the maximum over all longitudes is computed.",
    "",
    "    zonrange",
    "           Zonal range",
    "",
    "           For every latitude the range over all longitudes is computed.",
    "",
    "    zonsum Zonal sum",
    "",
    "           For every latitude the sum over all longitudes is computed.",
    "",
    "    zonmean",
    "           Zonal mean",
    "",
    "           For every latitude the mean over all longitudes is computed.  Use the optional parameter",
    "           zonaldes for data on an unstructured grid.",
    "",
    "    zonavg Zonal average",
    "",
    "           For every latitude the average over all longitudes is computed.",
    "",
    "    zonvar Zonal variance",
    "",
    "           For every latitude the variance over all longitudes is computed. Normalize by n.",
    "",
    "    zonvar1",
    "           Zonal variance (n-1)",
    "",
    "           For every latitude the variance over all longitudes is computed. Normalize by (n-1).",
    "",
    "    zonstd Zonal standard deviation",
    "",
    "           For every latitude the standard deviation over all longitudes is computed. Normalize by n.",
    "",
    "    zonstd1",
    "           Zonal standard deviation (n-1)",
    "",
    "           For every latitude the standard deviation over all longitudes is computed. Normalize by",
    "           (n-1).",
    "",
    "    zonskew",
    "           Zonal skewness",
    "",
    "           For every latitude the skewness over all longitudes is computed.",
    "",
    "    zonkurt",
    "           Zonal kurtosis",
    "",
    "           For every latitude the kurtosis over all longitudes is computed.",
    "",
    "    zonmedian",
    "           Zonal median",
    "",
    "           For every latitude the median over all longitudes is computed.",
    "",
    "    zonpctl",
    "           Zonal percentile",
    "",
    "           For every latitude the pth percentile over all longitudes is computed.",
    "",
    "PARAMETERS",
    "",
    "    pn (FLOAT)",
    "           Percentile number in {0, …, 100}",
    "",
    "    zonaldes (STRING)",
    "           Description of the zonal latitude bins needed for data on an unstructured grid. A",
    "           predefined zonal description is zonal_<DY>. DY is the increment of the latitudes in",
    "           degrees.",
    "",
    "EXAMPLE",
    "    To compute the zonal mean of all input fields use:",
    "",
    "       cdo zonmean infile outfile",
    "",
    "    To compute the 50th meridional percentile (median) of all input fields use:",
    "",
    "       cdo zonpctl,50 infile outfile",
    "",
    "AUTHOR",
    "    Uwe Schulzweida",
    "",
};

// clang-format on
