/*

Author:  Bob Dean
Copyright (c) 1999, 2000


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public Licensse as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#ifdef __cplusplus
	extern "C"
	{
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <stdarg.h>
#include <sys/shm.h>
#include <glib.h>
#include <math.h>
#include <dbsoundcard.h>
#include <dbchannel.h>
#include <dbdebug.h>
#include <dbaudiolib.h>

#include "prototypes.h"

		extern local_channel * ch;

		extern int errno;
		extern int debug_level; /* declared in debug module */


		/*
		  DBAudio_Get_Channel_Name
		  returns a pointer to the name associated with this channel,
		  and also copies the name in to the character buffer
		  pointed to by name.
		*/
		char * DBAudio_Get_Channel_Name(char * name)
		{
			if (name == NULL)
			{
				errno = ERROR_BAD_PARAM;
				return NULL;
			}

			if (ch == NULL)  
			{
				errno = ERROR_NOT_INITIALIZED; 
				return NULL;
			}

			strcpy(name,ch->channel_name);

			return name;
		}


		/*
		  DBAudio_Set_Channel_name
		  sets the name for this channel to be name
		*/
		int DBAudio_Set_Channel_Name(char * name)
		{
			int i;
			static char temp[DB_CHANNEL_NAME_SIZE],temp2[DB_CHANNEL_NAME_SIZE];

			if (name == NULL)
			{
				errno = ERROR_BAD_PARAM;
				return FAILURE;
			}

			if (ch == NULL)  
			{
				errno = ERROR_NOT_INITIALIZED; 
				return FAILURE;
			}

			/* if the name is longer than the name buffer for 
			   the channel, truncate it */
			if ((strlen(name) - 6) > DB_CHANNEL_NAME_SIZE)
			{
				for (i = 0; i < (DB_CHANNEL_NAME_SIZE - 6); i++)
				{
					temp[i] = name[i];
				}
		
				temp[i] = '\0';
				sprintf(temp2,"%s - %d",temp,ch->index+1);
			}
			else
			{
				sprintf(temp2,"%s - %d",name,ch->index+1);
			}

			strcpy(ch->channel_name,temp2);

			return SUCCESS;
		}


#ifdef __cplusplus
	}
#endif
