/*
  prototypes.h 
  
  this file contains function prototypes and definitions private to dbaudiolib, and
  therefore are should not be exported in the dbaudiolib.h header file.

  Author:  Bob Dean
  Copyright (c) 1999, 2000


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifdef __cplusplus
extern "C"
{
#endif

#ifndef __DBAUDIO_PROTO_H__
#define __DBAUDIO_PROTO_H__
	
#include <dbaudiolib.h>

/*  DBAudioLib Prototypes */
	int    DBAudio_Init(char * name, int fmt, int rte, int numch,
						enum channel_type_e type, int chindex);
	int    DBAudio_Ready();
	int    DBAudio_Write(char* buf, int len);
	int    DBAudio_Close();
	int    DBAudio_Set_Volume(int left, int right);
	int    DBAudio_Get_Volume(int *left, int *right);
	int    DBAudio_Pause(int value);
	char * DBAudio_Get_Version();
	char * DBAudio_Get_Channel_Name(char * name);
	int    DBAudio_Set_Channel_Name(char * name);
	enum channel_type_e DBAudio_Get_Channel_Type();
	int    DBAudio_Set_Channel_Type(enum channel_type_e type);
	int    DBAudio_Cue_Enabled();
	int    DBAudio_Set_Rate(int rte);
	int    DBAudio_Get_Rate();
	int    DBAudio_Set_Channels(int numch);
	int    DBAudio_Get_Channels();
	int    DBAudio_Set_Format(int fmt);
	int    DBAudio_Get_Format();
	int    DBAudio_Get_Bufsize(int input_bufsize);
	void   DBAudio_perror(char *str);
	int    DBAudio_Set_Message_Handler(void(*message_handler)(dbfsd_msg msg), int msg_flags);
	int    DBAudio_Handle_Message_Queue();
	int    DBAudio_Set_Channel_Flag(unsigned int flag);
	int    DBAudio_Clear_Channel_Flag(unsigned int flag);
	unsigned int DBAudio_Get_Channel_Flags();
	int    DBAudio_Set_Mute(int value);
	int    DBAudio_Get_Mute();
	int    DBAudio_Sample_Record();
	int    DBAudio_Sample_Stop();
	int    DBAudio_Sampler_Loop();
	int    DBAudio_Sampler_Single();
	int    DBAudio_Sample_Get_Offsets(int * start_offset, int * end_offset);
	int    DBAudio_Sample_Set_Offsets(int start_offset, int end_offset);
	int    DBAudio_Sampler_Get_Size(int * size);
	int    DBAudio_Sampler_Save(char * filename);
	int    DBAudio_Sampler_Load(char * filename);
	sampler_state DBAudio_Sampler_Get_State();
	
#define OUTPUT_BUFSIZE     (PIPE_BUF * 6)  /* size of internal buffers for audio format conversion */
#define SAMPLER_WRITESIZE  (PIPE_BUF * 2)  /* amount of bytes to write if sampler is in play mode */
	
#endif /* __DBAUDIO_PROTO_H__ */
	
#ifdef __cplusplus
}
#endif
