/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.FillerModel;
import friendless.games.filler.FillerPlayer;
import java.util.BitSet;
import java.util.Random;

public abstract class AbstractFillerPlayer
implements FillerPlayer {
    protected static Random rng = new Random();
    protected int[] origins;
    protected int[] reverseOrigins;
    static final int[] ROOTS = new int[]{0, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4};

    protected static final int getX(int n) {
        return FillerModel.getX(n);
    }

    protected static final int getY(int n) {
        return FillerModel.getY(n);
    }

    protected static final int makeIndex(int n, int n2) {
        return FillerModel.makeIndex(n, n2);
    }

    public void setOrigin(int n, int n2) {
        this.origins = new int[]{n, n2};
        this.reverseOrigins = new int[]{n2, n};
    }

    public abstract int turn();

    protected static BitSet allColours() {
        BitSet bitSet = new BitSet(9);
        int n = 0;
        while (n < 9) {
            bitSet.set(n);
            ++n;
        }
        return bitSet;
    }

    protected final int[] copy(int[] nArray) {
        return (int[])nArray.clone();
    }

    protected int chooseRandom(BitSet bitSet) {
        if (bitSet == null) {
            return -1;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 9) {
            if (bitSet.get(n2)) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return -1;
        }
        int n3 = rng.nextInt(n);
        n = 0;
        int n4 = 0;
        while (n4 < 9) {
            if (bitSet.get(n4)) {
                if (n == n3) {
                    return n4;
                }
                ++n;
            }
            ++n4;
        }
        return -1;
    }

    protected static final int intRoot(int n) {
        if (n < 20) {
            return ROOTS[n];
        }
        int n2 = n / 2;
        int n3 = n / n2;
        while (Math.abs(n2 - n3) > 1) {
            n2 = (n2 + n3) / 2;
            n3 = n / n2;
        }
        return n2;
    }

    protected static final int sideDistance(int n, int n2) {
        return Math.abs(AbstractFillerPlayer.getX(n) - AbstractFillerPlayer.getX(n2)) + Math.abs(AbstractFillerPlayer.getY(n) - AbstractFillerPlayer.getY(n2));
    }

    protected static final int diagDistance(int n, int n2) {
        int n3 = AbstractFillerPlayer.getX(n) - AbstractFillerPlayer.getX(n2);
        int n4 = (AbstractFillerPlayer.getY(n) - AbstractFillerPlayer.getY(n2)) * 3;
        return AbstractFillerPlayer.intRoot(n3 * n3 + n4 * n4);
    }

    public String getIcon() {
        return null;
    }

    public abstract boolean colourChosen(int var1);

    public abstract int takeTurn(FillerModel var1, int var2);

    public abstract boolean requiresButtons();

    public abstract String getFullName();

    public abstract String getName();
}

