
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file TableDecoderAttributes.h
    \\brief Definition of TableDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "TableDecoderWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


TableDecoderWrapper::TableDecoderWrapper(): tabledecoder_(new TableDecoder())

{

	
	
	
} 
TableDecoderWrapper::TableDecoderWrapper(TableDecoder* tabledecoder): tabledecoder_(tabledecoder)
{
	
	
} 

TableDecoderWrapper::~TableDecoderWrapper()
{
	
}

void TableDecoderWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("TABLE_FILENAME") ) {
		string path_value = request("TABLE_FILENAME");
		tabledecoder_->path_ = path_value;
		}
	if  (request.countValues("TABLE_DELIMITER") ) {
		string delimiter_value = request("TABLE_DELIMITER");
		tabledecoder_->delimiter_ = delimiter_value;
		}
	if  (request.countValues("TABLE_COMBINE_DELIMITERS") ) {
		string combine_delimiters_value = request("TABLE_COMBINE_DELIMITERS");
		tabledecoder_->combine_delimiters_ = MagTranslator<string, bool>()(combine_delimiters_value);
		}
	if  (request.countValues("TABLE_HEADER_ROW") ) {
		int header_row_value = request("TABLE_HEADER_ROW");
		tabledecoder_->header_row_ = header_row_value;
		}
	if  (request.countValues("TABLE_DATA_ROW_OFFSET") ) {
		int data_row_offset_value = request("TABLE_DATA_ROW_OFFSET");
		tabledecoder_->data_row_offset_ = data_row_offset_value;
		}
	intarray meta_data_rows_value;
	for (int i = 0; i < request.countValues("TABLE_META_DATA_ROWS"); i++)
		meta_data_rows_value.push_back((int)request("TABLE_META_DATA_ROWS", i));
	if ( !meta_data_rows_value.empty() ) 
		tabledecoder_->meta_data_rows_ = meta_data_rows_value;
	if  (request.countValues("TABLE_X_TYPE") ) {
		string x_type_value = request("TABLE_X_TYPE");
		tabledecoder_->x_type_ = x_type_value;
		}
	if  (request.countValues("TABLE_Y_TYPE") ) {
		string y_type_value = request("TABLE_Y_TYPE");
		tabledecoder_->y_type_ = y_type_value;
		}
	if  (request.countValues("TABLE_VARIABLE_IDENTIFIER_TYPE") ) {
		string name_mode_value = request("TABLE_VARIABLE_IDENTIFIER_TYPE");
		tabledecoder_->name_mode_ = name_mode_value;
		}
	if  (request.countValues("TABLE_X_VARIABLE") ) {
		string x_value = request("TABLE_X_VARIABLE");
		tabledecoder_->x_ = x_value;
		}
	if  (request.countValues("TABLE_Y_VARIABLE") ) {
		string y_value = request("TABLE_Y_VARIABLE");
		tabledecoder_->y_ = y_value;
		}
	if  (request.countValues("TABLE_VALUE_VARIABLE") ) {
		string values_value = request("TABLE_VALUE_VARIABLE");
		tabledecoder_->values_ = values_value;
		}
	if  (request.countValues("TABLE_LATITUDE_VARIABLE") ) {
		string lat_value = request("TABLE_LATITUDE_VARIABLE");
		tabledecoder_->lat_ = lat_value;
		}
	if  (request.countValues("TABLE_LONGITUDE_VARIABLE") ) {
		string lon_value = request("TABLE_LONGITUDE_VARIABLE");
		tabledecoder_->lon_ = lon_value;
		}
	if  (request.countValues("TABLE_X_COMPONENT_VARIABLE") ) {
		string x_component_value = request("TABLE_X_COMPONENT_VARIABLE");
		tabledecoder_->x_component_ = x_component_value;
		}
	if  (request.countValues("TABLE_Y_COMPONENT_VARIABLE") ) {
		string y_component_value = request("TABLE_Y_COMPONENT_VARIABLE");
		tabledecoder_->y_component_ = y_component_value;
		}
	if  (request.countValues("TABLE_X_MISSING_VALUE") ) {
		double x_missing_value = request("TABLE_X_MISSING_VALUE");
		tabledecoder_->x_missing_ = x_missing_value;
		}
	if  (request.countValues("TABLE_Y_MISSING_VALUE") ) {
		double y_missing_value = request("TABLE_Y_MISSING_VALUE");
		tabledecoder_->y_missing_ = y_missing_value;
		}
	
	
		string table_binning_value = request.countValues("TABLE_BINNING") ?  (string) request("TABLE_BINNING") : "on";
	MagLog::debug() << " TABLE_BINNING set to " << table_binning_value << endl;
	BinningObjectWrapper* table_binning_wrapper = 0;
	try
	{
		table_binning_wrapper = SimpleFactory<BinningObjectWrapper>::create(table_binning_value);
	}
	 catch (NoFactoryException) {
		MagLog::warning() << "[" << table_binning_value << "] is not a valid value for table_binning: reset to default -> [on]" << endl;
		table_binning_wrapper = SimpleFactory<BinningObjectWrapper>::create("on");
	}
	table_binning_wrapper->set(request);
	tabledecoder_->table_binning_ =  unique_ptr<BinningObject>(table_binning_wrapper->object());
	delete table_binning_wrapper;
	
}

void TableDecoderWrapper::print(ostream& out)  const
{
	out << "TableDecoderWrapper[]";
}


    



#include "NoBinningObjectWrapper.h"
static SimpleObjectMaker<NoBinningObject, BinningObject> TableDecoder_table_binning_nobinning ("nobinning");
static SimpleObjectMaker<NoBinningObjectWrapper, BinningObjectWrapper> TableDecoder_table_binning_nobinning_wrapper ("nobinning");


#include "NoBinningObjectWrapper.h"
static SimpleObjectMaker<NoBinningObject, BinningObject> TableDecoder_table_binning_off ("off");
static SimpleObjectMaker<NoBinningObjectWrapper, BinningObjectWrapper> TableDecoder_table_binning_off_wrapper ("off");


#include "BinningObjectWrapper.h"

static SimpleObjectMaker<BinningObjectWrapper> TableDecoder_table_binning_binning_Wrapper("binning");


#include "BinningObjectWrapper.h"

static SimpleObjectMaker<BinningObjectWrapper> TableDecoder_table_binning_on_Wrapper("on");



