# Fetch iso cd boot files.

readonly MSGF10=$(gettext 'fetching iso cd files')
readonly MSGF90=$(gettext 'iso cd files fetched')

if (($OPT_PHASE_F)); then

    inform "$MSGF10..."
    mkdir -p$V -- "$ISOCD_TARGET/$ISOCD_VER/$ARCH/iso-cd"
    pushd >/dev/null -- "$ISOCD_TARGET/$ISOCD_VER/$ARCH/iso-cd"
    readonly ARGS=$(
        declare PREFIX=$MIRROR_PRIMARY FP1
        for FP1 in $(
            # The 'echox' is needed because a name beginning with a hyphen
            # makes a legal value for $ISOCD_VER. (But you don't see
            # any $ISOCD_VER? Look in the referenced list file:
            # it's there.)
            eval echox $(<"$LIST_DIR/files-to-fetch-from-debian-cd.list")
        ); do
            printf '%s::%s/%s ' "$PREFIX" "$CD_ARCHIVE_NAME" "$FP1"
            PREFIX=''
        done
    )
    # The $ARGS on the next line is purposely unquoted.
    until rsync -tv --progress --stats -- $ARGS ./; do
        pause_before_retrying
    done
    popd >/dev/null
    inform "$MSGF90"

fi

