# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AksClusterProfile(_serialization.Model):
    """Properties of the cluster pool underlying AKS cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aks_cluster_resource_id: ARM Resource ID of the AKS cluster.
    :vartype aks_cluster_resource_id: str
    :ivar aks_cluster_agent_pool_identity_profile: Identity properties of the AKS cluster agentpool
     MSI.
    :vartype aks_cluster_agent_pool_identity_profile:
     ~azure.mgmt.hdinsightcontainers.models.AksClusterProfileAksClusterAgentPoolIdentityProfile
    :ivar aks_version: AKS control plane and default node pool version of this ClusterPool.
    :vartype aks_version: str
    """

    _validation = {
        "aks_version": {"readonly": True},
    }

    _attribute_map = {
        "aks_cluster_resource_id": {"key": "aksClusterResourceId", "type": "str"},
        "aks_cluster_agent_pool_identity_profile": {
            "key": "aksClusterAgentPoolIdentityProfile",
            "type": "AksClusterProfileAksClusterAgentPoolIdentityProfile",
        },
        "aks_version": {"key": "aksVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        aks_cluster_resource_id: Optional[str] = None,
        aks_cluster_agent_pool_identity_profile: Optional[
            "_models.AksClusterProfileAksClusterAgentPoolIdentityProfile"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword aks_cluster_resource_id: ARM Resource ID of the AKS cluster.
        :paramtype aks_cluster_resource_id: str
        :keyword aks_cluster_agent_pool_identity_profile: Identity properties of the AKS cluster
         agentpool MSI.
        :paramtype aks_cluster_agent_pool_identity_profile:
         ~azure.mgmt.hdinsightcontainers.models.AksClusterProfileAksClusterAgentPoolIdentityProfile
        """
        super().__init__(**kwargs)
        self.aks_cluster_resource_id = aks_cluster_resource_id
        self.aks_cluster_agent_pool_identity_profile = aks_cluster_agent_pool_identity_profile
        self.aks_version = None


class IdentityProfile(_serialization.Model):
    """Identity Profile with details of an MSI.

    All required parameters must be populated in order to send to server.

    :ivar msi_resource_id: ResourceId of the MSI. Required.
    :vartype msi_resource_id: str
    :ivar msi_client_id: ClientId of the MSI. Required.
    :vartype msi_client_id: str
    :ivar msi_object_id: ObjectId of the MSI. Required.
    :vartype msi_object_id: str
    """

    _validation = {
        "msi_resource_id": {"required": True},
        "msi_client_id": {
            "required": True,
            "pattern": r"^[{(]?[0-9A-Fa-f]{8}[-]?(?:[0-9A-Fa-f]{4}[-]?){3}[0-9A-Fa-f]{12}[)}]?$",
        },
        "msi_object_id": {
            "required": True,
            "pattern": r"^[{(]?[0-9A-Fa-f]{8}[-]?(?:[0-9A-Fa-f]{4}[-]?){3}[0-9A-Fa-f]{12}[)}]?$",
        },
    }

    _attribute_map = {
        "msi_resource_id": {"key": "msiResourceId", "type": "str"},
        "msi_client_id": {"key": "msiClientId", "type": "str"},
        "msi_object_id": {"key": "msiObjectId", "type": "str"},
    }

    def __init__(self, *, msi_resource_id: str, msi_client_id: str, msi_object_id: str, **kwargs: Any) -> None:
        """
        :keyword msi_resource_id: ResourceId of the MSI. Required.
        :paramtype msi_resource_id: str
        :keyword msi_client_id: ClientId of the MSI. Required.
        :paramtype msi_client_id: str
        :keyword msi_object_id: ObjectId of the MSI. Required.
        :paramtype msi_object_id: str
        """
        super().__init__(**kwargs)
        self.msi_resource_id = msi_resource_id
        self.msi_client_id = msi_client_id
        self.msi_object_id = msi_object_id


class AksClusterProfileAksClusterAgentPoolIdentityProfile(IdentityProfile):  # pylint: disable=name-too-long
    """Identity properties of the AKS cluster agentpool MSI.

    All required parameters must be populated in order to send to server.

    :ivar msi_resource_id: ResourceId of the MSI. Required.
    :vartype msi_resource_id: str
    :ivar msi_client_id: ClientId of the MSI. Required.
    :vartype msi_client_id: str
    :ivar msi_object_id: ObjectId of the MSI. Required.
    :vartype msi_object_id: str
    """


class AuthorizationProfile(_serialization.Model):
    """Authorization profile with details of AAD user Ids and group Ids authorized for data plane
    access.

    :ivar user_ids: AAD user Ids authorized for data plane access.
    :vartype user_ids: list[str]
    :ivar group_ids: AAD group Ids authorized for data plane access.
    :vartype group_ids: list[str]
    """

    _attribute_map = {
        "user_ids": {"key": "userIds", "type": "[str]"},
        "group_ids": {"key": "groupIds", "type": "[str]"},
    }

    def __init__(
        self, *, user_ids: Optional[List[str]] = None, group_ids: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword user_ids: AAD user Ids authorized for data plane access.
        :paramtype user_ids: list[str]
        :keyword group_ids: AAD group Ids authorized for data plane access.
        :paramtype group_ids: list[str]
        """
        super().__init__(**kwargs)
        self.user_ids = user_ids
        self.group_ids = group_ids


class AutoscaleProfile(_serialization.Model):
    """This is the Autoscale profile for the cluster. This will allow customer to create cluster
    enabled with Autoscale.

    All required parameters must be populated in order to send to server.

    :ivar enabled: This indicates whether auto scale is enabled on HDInsight on AKS cluster.
     Required.
    :vartype enabled: bool
    :ivar graceful_decommission_timeout: This property is for graceful decommission timeout; It has
     a default setting of 3600 seconds before forced shutdown takes place. This is the maximal time
     to wait for running containers and applications to complete before transition a DECOMMISSIONING
     node into DECOMMISSIONED. The default value is 3600 seconds. Negative value (like -1) is
     handled as infinite timeout.
    :vartype graceful_decommission_timeout: int
    :ivar autoscale_type: User to specify which type of Autoscale to be implemented - Scheduled
     Based or Load Based. Known values are: "ScheduleBased" and "LoadBased".
    :vartype autoscale_type: str or ~azure.mgmt.hdinsightcontainers.models.AutoscaleType
    :ivar schedule_based_config: Profiles of schedule based Autoscale.
    :vartype schedule_based_config: ~azure.mgmt.hdinsightcontainers.models.ScheduleBasedConfig
    :ivar load_based_config: Profiles of load based Autoscale.
    :vartype load_based_config: ~azure.mgmt.hdinsightcontainers.models.LoadBasedConfig
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "graceful_decommission_timeout": {"key": "gracefulDecommissionTimeout", "type": "int"},
        "autoscale_type": {"key": "autoscaleType", "type": "str"},
        "schedule_based_config": {"key": "scheduleBasedConfig", "type": "ScheduleBasedConfig"},
        "load_based_config": {"key": "loadBasedConfig", "type": "LoadBasedConfig"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        graceful_decommission_timeout: Optional[int] = None,
        autoscale_type: Optional[Union[str, "_models.AutoscaleType"]] = None,
        schedule_based_config: Optional["_models.ScheduleBasedConfig"] = None,
        load_based_config: Optional["_models.LoadBasedConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: This indicates whether auto scale is enabled on HDInsight on AKS cluster.
         Required.
        :paramtype enabled: bool
        :keyword graceful_decommission_timeout: This property is for graceful decommission timeout; It
         has a default setting of 3600 seconds before forced shutdown takes place. This is the maximal
         time to wait for running containers and applications to complete before transition a
         DECOMMISSIONING node into DECOMMISSIONED. The default value is 3600 seconds. Negative value
         (like -1) is handled as infinite timeout.
        :paramtype graceful_decommission_timeout: int
        :keyword autoscale_type: User to specify which type of Autoscale to be implemented - Scheduled
         Based or Load Based. Known values are: "ScheduleBased" and "LoadBased".
        :paramtype autoscale_type: str or ~azure.mgmt.hdinsightcontainers.models.AutoscaleType
        :keyword schedule_based_config: Profiles of schedule based Autoscale.
        :paramtype schedule_based_config: ~azure.mgmt.hdinsightcontainers.models.ScheduleBasedConfig
        :keyword load_based_config: Profiles of load based Autoscale.
        :paramtype load_based_config: ~azure.mgmt.hdinsightcontainers.models.LoadBasedConfig
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.graceful_decommission_timeout = graceful_decommission_timeout
        self.autoscale_type = autoscale_type
        self.schedule_based_config = schedule_based_config
        self.load_based_config = load_based_config


class CatalogOptions(_serialization.Model):
    """Trino cluster catalog options.

    :ivar hive: hive catalog options.
    :vartype hive: list[~azure.mgmt.hdinsightcontainers.models.HiveCatalogOption]
    """

    _attribute_map = {
        "hive": {"key": "hive", "type": "[HiveCatalogOption]"},
    }

    def __init__(self, *, hive: Optional[List["_models.HiveCatalogOption"]] = None, **kwargs: Any) -> None:
        """
        :keyword hive: hive catalog options.
        :paramtype hive: list[~azure.mgmt.hdinsightcontainers.models.HiveCatalogOption]
        """
        super().__init__(**kwargs)
        self.hive = hive


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Cluster(TrackedResource):
    """The cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Gets or sets the properties. Define cluster specific properties.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ClusterResourceProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ClusterResourceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Gets or sets the properties. Define cluster specific properties.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterResourceProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class ClusterAccessProfile(_serialization.Model):
    """Cluster access profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar enable_internal_ingress: Whether to create cluster using private IP instead of public IP.
     This property must be set at create time. Required.
    :vartype enable_internal_ingress: bool
    :ivar private_link_service_id: Private link service resource ID. Only when
     enableInternalIngress is true, this property will be returned.
    :vartype private_link_service_id: str
    """

    _validation = {
        "enable_internal_ingress": {"required": True},
        "private_link_service_id": {"readonly": True},
    }

    _attribute_map = {
        "enable_internal_ingress": {"key": "enableInternalIngress", "type": "bool"},
        "private_link_service_id": {"key": "privateLinkServiceId", "type": "str"},
    }

    def __init__(self, *, enable_internal_ingress: bool, **kwargs: Any) -> None:
        """
        :keyword enable_internal_ingress: Whether to create cluster using private IP instead of public
         IP. This property must be set at create time. Required.
        :paramtype enable_internal_ingress: bool
        """
        super().__init__(**kwargs)
        self.enable_internal_ingress = enable_internal_ingress
        self.private_link_service_id = None


class ClusterUpgradeHistoryProperties(_serialization.Model):
    """Properties of cluster upgrade history.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClusterAksPatchUpgradeHistoryProperties, ClusterInPlaceUpgradeHistoryProperties

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", "HotfixUpgradeRollback", "PatchVersionUpgrade", and
     "PatchVersionUpgradeRollback".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryType
    :ivar utc_time: Time when created this upgrade history. Required.
    :vartype utc_time: str
    :ivar upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
     "Failed".
    :vartype upgrade_result: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
    """

    _validation = {
        "upgrade_type": {"required": True},
        "utc_time": {"required": True},
        "upgrade_result": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "utc_time": {"key": "utcTime", "type": "str"},
        "upgrade_result": {"key": "upgradeResult", "type": "str"},
    }

    _subtype_map = {
        "upgrade_type": {
            "AKSPatchUpgrade": "ClusterAksPatchUpgradeHistoryProperties",
            "ClusterInPlaceUpgradeHistoryProperties": "ClusterInPlaceUpgradeHistoryProperties",
        }
    }

    def __init__(
        self,
        *,
        utc_time: str,
        upgrade_result: Union[str, "_models.ClusterUpgradeHistoryUpgradeResultType"],
        **kwargs: Any
    ) -> None:
        """
        :keyword utc_time: Time when created this upgrade history. Required.
        :paramtype utc_time: str
        :keyword upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
         "Failed".
        :paramtype upgrade_result: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
        """
        super().__init__(**kwargs)
        self.upgrade_type: Optional[str] = None
        self.utc_time = utc_time
        self.upgrade_result = upgrade_result


class ClusterAksPatchUpgradeHistoryProperties(ClusterUpgradeHistoryProperties):
    """Cluster aks patch upgrade history properties.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", "HotfixUpgradeRollback", "PatchVersionUpgrade", and
     "PatchVersionUpgradeRollback".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryType
    :ivar utc_time: Time when created this upgrade history. Required.
    :vartype utc_time: str
    :ivar upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
     "Failed".
    :vartype upgrade_result: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
    :ivar original_version: Version before update.
    :vartype original_version: str
    :ivar new_version: Version going to update.
    :vartype new_version: str
    """

    _validation = {
        "upgrade_type": {"required": True},
        "utc_time": {"required": True},
        "upgrade_result": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "utc_time": {"key": "utcTime", "type": "str"},
        "upgrade_result": {"key": "upgradeResult", "type": "str"},
        "original_version": {"key": "originalVersion", "type": "str"},
        "new_version": {"key": "newVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        utc_time: str,
        upgrade_result: Union[str, "_models.ClusterUpgradeHistoryUpgradeResultType"],
        original_version: Optional[str] = None,
        new_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utc_time: Time when created this upgrade history. Required.
        :paramtype utc_time: str
        :keyword upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
         "Failed".
        :paramtype upgrade_result: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
        :keyword original_version: Version before update.
        :paramtype original_version: str
        :keyword new_version: Version going to update.
        :paramtype new_version: str
        """
        super().__init__(utc_time=utc_time, upgrade_result=upgrade_result, **kwargs)
        self.upgrade_type: str = "AKSPatchUpgrade"
        self.original_version = original_version
        self.new_version = new_version


class ClusterUpgradeProperties(_serialization.Model):
    """Properties of upgrading cluster.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClusterAKSPatchVersionUpgradeProperties, ClusterInPlaceUpgradeProperties

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", and "PatchVersionUpgrade".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeType
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
    }

    _subtype_map = {
        "upgrade_type": {
            "AKSPatchUpgrade": "ClusterAKSPatchVersionUpgradeProperties",
            "ClusterInPlaceUpgradeProperties": "ClusterInPlaceUpgradeProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.upgrade_type: Optional[str] = None


class ClusterAKSPatchVersionUpgradeProperties(ClusterUpgradeProperties):
    """Properties of upgrading cluster's AKS patch version.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", and "PatchVersionUpgrade".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeType
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.upgrade_type: str = "AKSPatchUpgrade"


class ClusterAvailableUpgradeProperties(_serialization.Model):
    """Cluster available upgrade properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClusterAvailableUpgradeAksPatchUpgradeProperties, ClusterAvailableInPlaceUpgradeProperties

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", and "PatchVersionUpgrade".
    :vartype upgrade_type: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterAvailableUpgradeType
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
    }

    _subtype_map = {
        "upgrade_type": {
            "AKSPatchUpgrade": "ClusterAvailableUpgradeAksPatchUpgradeProperties",
            "ClusterAvailableInPlaceUpgradeProperties": "ClusterAvailableInPlaceUpgradeProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.upgrade_type: Optional[str] = None


class ClusterAvailableInPlaceUpgradeProperties(
    ClusterAvailableUpgradeProperties
):  # pylint: disable=too-many-instance-attributes
    """Cluster available in-place upgrade.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClusterAvailableUpgradeHotfixUpgradeProperties,
    ClusterAvailableUpgradePatchVersionUpgradeProperties

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", and "PatchVersionUpgrade".
    :vartype upgrade_type: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterAvailableUpgradeType
    :ivar description: Hotfix version upgrade description.
    :vartype description: str
    :ivar source_oss_version: Source OSS version of current cluster component.
    :vartype source_oss_version: str
    :ivar source_cluster_version: Source cluster version of current cluster component.
    :vartype source_cluster_version: str
    :ivar source_build_number: Source build number of current cluster component.
    :vartype source_build_number: str
    :ivar target_oss_version: Target OSS version of component to be upgraded.
    :vartype target_oss_version: str
    :ivar target_cluster_version: Target cluster version of component to be upgraded.
    :vartype target_cluster_version: str
    :ivar target_build_number: Target build number of component to be upgraded.
    :vartype target_build_number: str
    :ivar component_name: Name of component to be upgraded.
    :vartype component_name: str
    :ivar severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
     "critical".
    :vartype severity: str or ~azure.mgmt.hdinsightcontainers.models.Severity
    :ivar extended_properties: Extended properties of current available upgrade version.
    :vartype extended_properties: str
    :ivar created_time: Created time of current available upgrade version.
    :vartype created_time: ~datetime.datetime
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "source_oss_version": {"key": "sourceOssVersion", "type": "str"},
        "source_cluster_version": {"key": "sourceClusterVersion", "type": "str"},
        "source_build_number": {"key": "sourceBuildNumber", "type": "str"},
        "target_oss_version": {"key": "targetOssVersion", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "target_build_number": {"key": "targetBuildNumber", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "extended_properties": {"key": "extendedProperties", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
    }

    _subtype_map = {
        "upgrade_type": {
            "HotfixUpgrade": "ClusterAvailableUpgradeHotfixUpgradeProperties",
            "PatchVersionUpgrade": "ClusterAvailableUpgradePatchVersionUpgradeProperties",
        }
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        source_oss_version: Optional[str] = None,
        source_cluster_version: Optional[str] = None,
        source_build_number: Optional[str] = None,
        target_oss_version: Optional[str] = None,
        target_cluster_version: Optional[str] = None,
        target_build_number: Optional[str] = None,
        component_name: Optional[str] = None,
        severity: Optional[Union[str, "_models.Severity"]] = None,
        extended_properties: Optional[str] = None,
        created_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Hotfix version upgrade description.
        :paramtype description: str
        :keyword source_oss_version: Source OSS version of current cluster component.
        :paramtype source_oss_version: str
        :keyword source_cluster_version: Source cluster version of current cluster component.
        :paramtype source_cluster_version: str
        :keyword source_build_number: Source build number of current cluster component.
        :paramtype source_build_number: str
        :keyword target_oss_version: Target OSS version of component to be upgraded.
        :paramtype target_oss_version: str
        :keyword target_cluster_version: Target cluster version of component to be upgraded.
        :paramtype target_cluster_version: str
        :keyword target_build_number: Target build number of component to be upgraded.
        :paramtype target_build_number: str
        :keyword component_name: Name of component to be upgraded.
        :paramtype component_name: str
        :keyword severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
         "critical".
        :paramtype severity: str or ~azure.mgmt.hdinsightcontainers.models.Severity
        :keyword extended_properties: Extended properties of current available upgrade version.
        :paramtype extended_properties: str
        :keyword created_time: Created time of current available upgrade version.
        :paramtype created_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.upgrade_type: str = "ClusterAvailableInPlaceUpgradeProperties"
        self.description = description
        self.source_oss_version = source_oss_version
        self.source_cluster_version = source_cluster_version
        self.source_build_number = source_build_number
        self.target_oss_version = target_oss_version
        self.target_cluster_version = target_cluster_version
        self.target_build_number = target_build_number
        self.component_name = component_name
        self.severity = severity
        self.extended_properties = extended_properties
        self.created_time = created_time


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    """


class ClusterAvailableUpgrade(ProxyResource):
    """Cluster available upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar properties: Gets or sets the properties. Define cluster upgrade specific properties.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterAvailableUpgradeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ClusterAvailableUpgradeProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.ClusterAvailableUpgradeProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Gets or sets the properties. Define cluster upgrade specific properties.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterAvailableUpgradeProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterAvailableUpgradeAksPatchUpgradeProperties(
    ClusterAvailableUpgradeProperties
):  # pylint: disable=name-too-long
    """Cluster available AKS patch version upgrade.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", and "PatchVersionUpgrade".
    :vartype upgrade_type: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterAvailableUpgradeType
    :ivar current_version: Current node pool version.
    :vartype current_version: str
    :ivar current_version_status: Current AKS version's status: whether it is deprecated or
     supported. Known values are: "Deprecated" and "Supported".
    :vartype current_version_status: str or
     ~azure.mgmt.hdinsightcontainers.models.CurrentClusterAksVersionStatus
    :ivar latest_version: Latest available version, which should be equal to AKS control plane
     version if it's not deprecated.
    :vartype latest_version: str
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "current_version": {"key": "currentVersion", "type": "str"},
        "current_version_status": {"key": "currentVersionStatus", "type": "str"},
        "latest_version": {"key": "latestVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        current_version: Optional[str] = None,
        current_version_status: Optional[Union[str, "_models.CurrentClusterAksVersionStatus"]] = None,
        latest_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword current_version: Current node pool version.
        :paramtype current_version: str
        :keyword current_version_status: Current AKS version's status: whether it is deprecated or
         supported. Known values are: "Deprecated" and "Supported".
        :paramtype current_version_status: str or
         ~azure.mgmt.hdinsightcontainers.models.CurrentClusterAksVersionStatus
        :keyword latest_version: Latest available version, which should be equal to AKS control plane
         version if it's not deprecated.
        :paramtype latest_version: str
        """
        super().__init__(**kwargs)
        self.upgrade_type: str = "AKSPatchUpgrade"
        self.current_version = current_version
        self.current_version_status = current_version_status
        self.latest_version = latest_version


class ClusterAvailableUpgradeHotfixUpgradeProperties(
    ClusterAvailableInPlaceUpgradeProperties
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Cluster available hotfix version upgrade.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", and "PatchVersionUpgrade".
    :vartype upgrade_type: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterAvailableUpgradeType
    :ivar description: Hotfix version upgrade description.
    :vartype description: str
    :ivar source_oss_version: Source OSS version of current cluster component.
    :vartype source_oss_version: str
    :ivar source_cluster_version: Source cluster version of current cluster component.
    :vartype source_cluster_version: str
    :ivar source_build_number: Source build number of current cluster component.
    :vartype source_build_number: str
    :ivar target_oss_version: Target OSS version of component to be upgraded.
    :vartype target_oss_version: str
    :ivar target_cluster_version: Target cluster version of component to be upgraded.
    :vartype target_cluster_version: str
    :ivar target_build_number: Target build number of component to be upgraded.
    :vartype target_build_number: str
    :ivar component_name: Name of component to be upgraded.
    :vartype component_name: str
    :ivar severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
     "critical".
    :vartype severity: str or ~azure.mgmt.hdinsightcontainers.models.Severity
    :ivar extended_properties: Extended properties of current available upgrade version.
    :vartype extended_properties: str
    :ivar created_time: Created time of current available upgrade version.
    :vartype created_time: ~datetime.datetime
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "source_oss_version": {"key": "sourceOssVersion", "type": "str"},
        "source_cluster_version": {"key": "sourceClusterVersion", "type": "str"},
        "source_build_number": {"key": "sourceBuildNumber", "type": "str"},
        "target_oss_version": {"key": "targetOssVersion", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "target_build_number": {"key": "targetBuildNumber", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "extended_properties": {"key": "extendedProperties", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        source_oss_version: Optional[str] = None,
        source_cluster_version: Optional[str] = None,
        source_build_number: Optional[str] = None,
        target_oss_version: Optional[str] = None,
        target_cluster_version: Optional[str] = None,
        target_build_number: Optional[str] = None,
        component_name: Optional[str] = None,
        severity: Optional[Union[str, "_models.Severity"]] = None,
        extended_properties: Optional[str] = None,
        created_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Hotfix version upgrade description.
        :paramtype description: str
        :keyword source_oss_version: Source OSS version of current cluster component.
        :paramtype source_oss_version: str
        :keyword source_cluster_version: Source cluster version of current cluster component.
        :paramtype source_cluster_version: str
        :keyword source_build_number: Source build number of current cluster component.
        :paramtype source_build_number: str
        :keyword target_oss_version: Target OSS version of component to be upgraded.
        :paramtype target_oss_version: str
        :keyword target_cluster_version: Target cluster version of component to be upgraded.
        :paramtype target_cluster_version: str
        :keyword target_build_number: Target build number of component to be upgraded.
        :paramtype target_build_number: str
        :keyword component_name: Name of component to be upgraded.
        :paramtype component_name: str
        :keyword severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
         "critical".
        :paramtype severity: str or ~azure.mgmt.hdinsightcontainers.models.Severity
        :keyword extended_properties: Extended properties of current available upgrade version.
        :paramtype extended_properties: str
        :keyword created_time: Created time of current available upgrade version.
        :paramtype created_time: ~datetime.datetime
        """
        super().__init__(
            description=description,
            source_oss_version=source_oss_version,
            source_cluster_version=source_cluster_version,
            source_build_number=source_build_number,
            target_oss_version=target_oss_version,
            target_cluster_version=target_cluster_version,
            target_build_number=target_build_number,
            component_name=component_name,
            severity=severity,
            extended_properties=extended_properties,
            created_time=created_time,
            **kwargs
        )
        self.upgrade_type: str = "HotfixUpgrade"


class ClusterAvailableUpgradeList(_serialization.Model):
    """Collection of cluster available upgrade.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of Cluster available upgrade. Required.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterAvailableUpgrade]
    :ivar next_link: The URL of next result page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterAvailableUpgrade]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ClusterAvailableUpgrade"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Cluster available upgrade. Required.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterAvailableUpgrade]
        :keyword next_link: The URL of next result page.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ClusterAvailableUpgradePatchVersionUpgradeProperties(
    ClusterAvailableInPlaceUpgradeProperties
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Cluster available patch version upgrade.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", and "PatchVersionUpgrade".
    :vartype upgrade_type: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterAvailableUpgradeType
    :ivar description: Hotfix version upgrade description.
    :vartype description: str
    :ivar source_oss_version: Source OSS version of current cluster component.
    :vartype source_oss_version: str
    :ivar source_cluster_version: Source cluster version of current cluster component.
    :vartype source_cluster_version: str
    :ivar source_build_number: Source build number of current cluster component.
    :vartype source_build_number: str
    :ivar target_oss_version: Target OSS version of component to be upgraded.
    :vartype target_oss_version: str
    :ivar target_cluster_version: Target cluster version of component to be upgraded.
    :vartype target_cluster_version: str
    :ivar target_build_number: Target build number of component to be upgraded.
    :vartype target_build_number: str
    :ivar component_name: Name of component to be upgraded.
    :vartype component_name: str
    :ivar severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
     "critical".
    :vartype severity: str or ~azure.mgmt.hdinsightcontainers.models.Severity
    :ivar extended_properties: Extended properties of current available upgrade version.
    :vartype extended_properties: str
    :ivar created_time: Created time of current available upgrade version.
    :vartype created_time: ~datetime.datetime
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "source_oss_version": {"key": "sourceOssVersion", "type": "str"},
        "source_cluster_version": {"key": "sourceClusterVersion", "type": "str"},
        "source_build_number": {"key": "sourceBuildNumber", "type": "str"},
        "target_oss_version": {"key": "targetOssVersion", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "target_build_number": {"key": "targetBuildNumber", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "extended_properties": {"key": "extendedProperties", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        source_oss_version: Optional[str] = None,
        source_cluster_version: Optional[str] = None,
        source_build_number: Optional[str] = None,
        target_oss_version: Optional[str] = None,
        target_cluster_version: Optional[str] = None,
        target_build_number: Optional[str] = None,
        component_name: Optional[str] = None,
        severity: Optional[Union[str, "_models.Severity"]] = None,
        extended_properties: Optional[str] = None,
        created_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Hotfix version upgrade description.
        :paramtype description: str
        :keyword source_oss_version: Source OSS version of current cluster component.
        :paramtype source_oss_version: str
        :keyword source_cluster_version: Source cluster version of current cluster component.
        :paramtype source_cluster_version: str
        :keyword source_build_number: Source build number of current cluster component.
        :paramtype source_build_number: str
        :keyword target_oss_version: Target OSS version of component to be upgraded.
        :paramtype target_oss_version: str
        :keyword target_cluster_version: Target cluster version of component to be upgraded.
        :paramtype target_cluster_version: str
        :keyword target_build_number: Target build number of component to be upgraded.
        :paramtype target_build_number: str
        :keyword component_name: Name of component to be upgraded.
        :paramtype component_name: str
        :keyword severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
         "critical".
        :paramtype severity: str or ~azure.mgmt.hdinsightcontainers.models.Severity
        :keyword extended_properties: Extended properties of current available upgrade version.
        :paramtype extended_properties: str
        :keyword created_time: Created time of current available upgrade version.
        :paramtype created_time: ~datetime.datetime
        """
        super().__init__(
            description=description,
            source_oss_version=source_oss_version,
            source_cluster_version=source_cluster_version,
            source_build_number=source_build_number,
            target_oss_version=target_oss_version,
            target_cluster_version=target_cluster_version,
            target_build_number=target_build_number,
            component_name=component_name,
            severity=severity,
            extended_properties=extended_properties,
            created_time=created_time,
            **kwargs
        )
        self.upgrade_type: str = "PatchVersionUpgrade"


class ClusterComponentsItem(_serialization.Model):
    """ClusterComponentsItem.

    :ivar name:
    :vartype name: str
    :ivar version:
    :vartype version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword version:
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.version = version


class ClusterConfigFile(_serialization.Model):
    """Cluster configuration files.

    All required parameters must be populated in order to send to server.

    :ivar file_name: Configuration file name. Required.
    :vartype file_name: str
    :ivar content: Free form content of the entire configuration file.
    :vartype content: str
    :ivar encoding: This property indicates if the content is encoded and is case-insensitive.
     Please set the value to base64 if the content is base64 encoded. Set it to none or skip it if
     the content is plain text. Known values are: "Base64" and "None".
    :vartype encoding: str or ~azure.mgmt.hdinsightcontainers.models.ContentEncoding
    :ivar path: Path of the config file if content is specified.
    :vartype path: str
    :ivar values: List of key value pairs
     where key represents a valid service configuration name and value represents the value of the
     config.
    :vartype values: dict[str, str]
    """

    _validation = {
        "file_name": {"required": True},
    }

    _attribute_map = {
        "file_name": {"key": "fileName", "type": "str"},
        "content": {"key": "content", "type": "str"},
        "encoding": {"key": "encoding", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "values": {"key": "values", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        file_name: str,
        content: Optional[str] = None,
        encoding: Optional[Union[str, "_models.ContentEncoding"]] = None,
        path: Optional[str] = None,
        values: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword file_name: Configuration file name. Required.
        :paramtype file_name: str
        :keyword content: Free form content of the entire configuration file.
        :paramtype content: str
        :keyword encoding: This property indicates if the content is encoded and is case-insensitive.
         Please set the value to base64 if the content is base64 encoded. Set it to none or skip it if
         the content is plain text. Known values are: "Base64" and "None".
        :paramtype encoding: str or ~azure.mgmt.hdinsightcontainers.models.ContentEncoding
        :keyword path: Path of the config file if content is specified.
        :paramtype path: str
        :keyword values: List of key value pairs
         where key represents a valid service configuration name and value represents the value of the
         config.
        :paramtype values: dict[str, str]
        """
        super().__init__(**kwargs)
        self.file_name = file_name
        self.content = content
        self.encoding = encoding
        self.path = path
        self.values = values


class ClusterInPlaceUpgradeHistoryProperties(
    ClusterUpgradeHistoryProperties
):  # pylint: disable=too-many-instance-attributes
    """Cluster in-place upgrade history properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClusterHotfixUpgradeHistoryProperties, ClusterHotfixUpgradeRollbackHistoryProperties,
    ClusterPatchVersionUpgradeHistoryProperties,
    ClusterPatchVersionUpgradeRollbackHistoryProperties

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", "HotfixUpgradeRollback", "PatchVersionUpgrade", and
     "PatchVersionUpgradeRollback".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryType
    :ivar utc_time: Time when created this upgrade history. Required.
    :vartype utc_time: str
    :ivar upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
     "Failed".
    :vartype upgrade_result: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
    :ivar source_cluster_version: Version with three part.
    :vartype source_cluster_version: str
    :ivar source_oss_version: Version with three part.
    :vartype source_oss_version: str
    :ivar source_build_number: Source build number.
    :vartype source_build_number: str
    :ivar target_cluster_version: Version with three part.
    :vartype target_cluster_version: str
    :ivar target_oss_version: Version with three part.
    :vartype target_oss_version: str
    :ivar target_build_number: Target build number.
    :vartype target_build_number: str
    :ivar component_name: Component name to upgrade.
    :vartype component_name: str
    :ivar severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
     "critical".
    :vartype severity: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistorySeverityType
    """

    _validation = {
        "upgrade_type": {"required": True},
        "utc_time": {"required": True},
        "upgrade_result": {"required": True},
        "source_cluster_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "source_oss_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "target_cluster_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "target_oss_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "utc_time": {"key": "utcTime", "type": "str"},
        "upgrade_result": {"key": "upgradeResult", "type": "str"},
        "source_cluster_version": {"key": "sourceClusterVersion", "type": "str"},
        "source_oss_version": {"key": "sourceOssVersion", "type": "str"},
        "source_build_number": {"key": "sourceBuildNumber", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "target_oss_version": {"key": "targetOssVersion", "type": "str"},
        "target_build_number": {"key": "targetBuildNumber", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
    }

    _subtype_map = {
        "upgrade_type": {
            "HotfixUpgrade": "ClusterHotfixUpgradeHistoryProperties",
            "HotfixUpgradeRollback": "ClusterHotfixUpgradeRollbackHistoryProperties",
            "PatchVersionUpgrade": "ClusterPatchVersionUpgradeHistoryProperties",
            "PatchVersionUpgradeRollback": "ClusterPatchVersionUpgradeRollbackHistoryProperties",
        }
    }

    def __init__(
        self,
        *,
        utc_time: str,
        upgrade_result: Union[str, "_models.ClusterUpgradeHistoryUpgradeResultType"],
        source_cluster_version: Optional[str] = None,
        source_oss_version: Optional[str] = None,
        source_build_number: Optional[str] = None,
        target_cluster_version: Optional[str] = None,
        target_oss_version: Optional[str] = None,
        target_build_number: Optional[str] = None,
        component_name: Optional[str] = None,
        severity: Optional[Union[str, "_models.ClusterUpgradeHistorySeverityType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utc_time: Time when created this upgrade history. Required.
        :paramtype utc_time: str
        :keyword upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
         "Failed".
        :paramtype upgrade_result: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
        :keyword source_cluster_version: Version with three part.
        :paramtype source_cluster_version: str
        :keyword source_oss_version: Version with three part.
        :paramtype source_oss_version: str
        :keyword source_build_number: Source build number.
        :paramtype source_build_number: str
        :keyword target_cluster_version: Version with three part.
        :paramtype target_cluster_version: str
        :keyword target_oss_version: Version with three part.
        :paramtype target_oss_version: str
        :keyword target_build_number: Target build number.
        :paramtype target_build_number: str
        :keyword component_name: Component name to upgrade.
        :paramtype component_name: str
        :keyword severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
         "critical".
        :paramtype severity: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistorySeverityType
        """
        super().__init__(utc_time=utc_time, upgrade_result=upgrade_result, **kwargs)
        self.upgrade_type: str = "ClusterInPlaceUpgradeHistoryProperties"
        self.source_cluster_version = source_cluster_version
        self.source_oss_version = source_oss_version
        self.source_build_number = source_build_number
        self.target_cluster_version = target_cluster_version
        self.target_oss_version = target_oss_version
        self.target_build_number = target_build_number
        self.component_name = component_name
        self.severity = severity


class ClusterHotfixUpgradeHistoryProperties(
    ClusterInPlaceUpgradeHistoryProperties
):  # pylint: disable=too-many-instance-attributes
    """Cluster hotfix upgrade history properties.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", "HotfixUpgradeRollback", "PatchVersionUpgrade", and
     "PatchVersionUpgradeRollback".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryType
    :ivar utc_time: Time when created this upgrade history. Required.
    :vartype utc_time: str
    :ivar upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
     "Failed".
    :vartype upgrade_result: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
    :ivar source_cluster_version: Version with three part.
    :vartype source_cluster_version: str
    :ivar source_oss_version: Version with three part.
    :vartype source_oss_version: str
    :ivar source_build_number: Source build number.
    :vartype source_build_number: str
    :ivar target_cluster_version: Version with three part.
    :vartype target_cluster_version: str
    :ivar target_oss_version: Version with three part.
    :vartype target_oss_version: str
    :ivar target_build_number: Target build number.
    :vartype target_build_number: str
    :ivar component_name: Component name to upgrade.
    :vartype component_name: str
    :ivar severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
     "critical".
    :vartype severity: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistorySeverityType
    """

    _validation = {
        "upgrade_type": {"required": True},
        "utc_time": {"required": True},
        "upgrade_result": {"required": True},
        "source_cluster_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "source_oss_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "target_cluster_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "target_oss_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "utc_time": {"key": "utcTime", "type": "str"},
        "upgrade_result": {"key": "upgradeResult", "type": "str"},
        "source_cluster_version": {"key": "sourceClusterVersion", "type": "str"},
        "source_oss_version": {"key": "sourceOssVersion", "type": "str"},
        "source_build_number": {"key": "sourceBuildNumber", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "target_oss_version": {"key": "targetOssVersion", "type": "str"},
        "target_build_number": {"key": "targetBuildNumber", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
    }

    def __init__(
        self,
        *,
        utc_time: str,
        upgrade_result: Union[str, "_models.ClusterUpgradeHistoryUpgradeResultType"],
        source_cluster_version: Optional[str] = None,
        source_oss_version: Optional[str] = None,
        source_build_number: Optional[str] = None,
        target_cluster_version: Optional[str] = None,
        target_oss_version: Optional[str] = None,
        target_build_number: Optional[str] = None,
        component_name: Optional[str] = None,
        severity: Optional[Union[str, "_models.ClusterUpgradeHistorySeverityType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utc_time: Time when created this upgrade history. Required.
        :paramtype utc_time: str
        :keyword upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
         "Failed".
        :paramtype upgrade_result: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
        :keyword source_cluster_version: Version with three part.
        :paramtype source_cluster_version: str
        :keyword source_oss_version: Version with three part.
        :paramtype source_oss_version: str
        :keyword source_build_number: Source build number.
        :paramtype source_build_number: str
        :keyword target_cluster_version: Version with three part.
        :paramtype target_cluster_version: str
        :keyword target_oss_version: Version with three part.
        :paramtype target_oss_version: str
        :keyword target_build_number: Target build number.
        :paramtype target_build_number: str
        :keyword component_name: Component name to upgrade.
        :paramtype component_name: str
        :keyword severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
         "critical".
        :paramtype severity: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistorySeverityType
        """
        super().__init__(
            utc_time=utc_time,
            upgrade_result=upgrade_result,
            source_cluster_version=source_cluster_version,
            source_oss_version=source_oss_version,
            source_build_number=source_build_number,
            target_cluster_version=target_cluster_version,
            target_oss_version=target_oss_version,
            target_build_number=target_build_number,
            component_name=component_name,
            severity=severity,
            **kwargs
        )
        self.upgrade_type: str = "HotfixUpgrade"


class ClusterInPlaceUpgradeProperties(ClusterUpgradeProperties):
    """Properties of in-place upgrading cluster.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClusterHotfixUpgradeProperties, ClusterPatchVersionUpgradeProperties

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", and "PatchVersionUpgrade".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeType
    :ivar target_oss_version: Target OSS version of component to be upgraded.
    :vartype target_oss_version: str
    :ivar target_cluster_version: Target cluster version of component to be upgraded.
    :vartype target_cluster_version: str
    :ivar target_build_number: Target build number of component to be upgraded.
    :vartype target_build_number: str
    :ivar component_name: Name of component to be upgraded.
    :vartype component_name: str
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "target_oss_version": {"key": "targetOssVersion", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "target_build_number": {"key": "targetBuildNumber", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
    }

    _subtype_map = {
        "upgrade_type": {
            "HotfixUpgrade": "ClusterHotfixUpgradeProperties",
            "PatchVersionUpgrade": "ClusterPatchVersionUpgradeProperties",
        }
    }

    def __init__(
        self,
        *,
        target_oss_version: Optional[str] = None,
        target_cluster_version: Optional[str] = None,
        target_build_number: Optional[str] = None,
        component_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_oss_version: Target OSS version of component to be upgraded.
        :paramtype target_oss_version: str
        :keyword target_cluster_version: Target cluster version of component to be upgraded.
        :paramtype target_cluster_version: str
        :keyword target_build_number: Target build number of component to be upgraded.
        :paramtype target_build_number: str
        :keyword component_name: Name of component to be upgraded.
        :paramtype component_name: str
        """
        super().__init__(**kwargs)
        self.upgrade_type: str = "ClusterInPlaceUpgradeProperties"
        self.target_oss_version = target_oss_version
        self.target_cluster_version = target_cluster_version
        self.target_build_number = target_build_number
        self.component_name = component_name


class ClusterHotfixUpgradeProperties(ClusterInPlaceUpgradeProperties):
    """Properties of upgrading cluster's hotfix.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", and "PatchVersionUpgrade".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeType
    :ivar target_oss_version: Target OSS version of component to be upgraded.
    :vartype target_oss_version: str
    :ivar target_cluster_version: Target cluster version of component to be upgraded.
    :vartype target_cluster_version: str
    :ivar target_build_number: Target build number of component to be upgraded.
    :vartype target_build_number: str
    :ivar component_name: Name of component to be upgraded.
    :vartype component_name: str
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "target_oss_version": {"key": "targetOssVersion", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "target_build_number": {"key": "targetBuildNumber", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_oss_version: Optional[str] = None,
        target_cluster_version: Optional[str] = None,
        target_build_number: Optional[str] = None,
        component_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_oss_version: Target OSS version of component to be upgraded.
        :paramtype target_oss_version: str
        :keyword target_cluster_version: Target cluster version of component to be upgraded.
        :paramtype target_cluster_version: str
        :keyword target_build_number: Target build number of component to be upgraded.
        :paramtype target_build_number: str
        :keyword component_name: Name of component to be upgraded.
        :paramtype component_name: str
        """
        super().__init__(
            target_oss_version=target_oss_version,
            target_cluster_version=target_cluster_version,
            target_build_number=target_build_number,
            component_name=component_name,
            **kwargs
        )
        self.upgrade_type: str = "HotfixUpgrade"


class ClusterHotfixUpgradeRollbackHistoryProperties(
    ClusterInPlaceUpgradeHistoryProperties
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Cluster hotfix upgrade rollback history properties.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", "HotfixUpgradeRollback", "PatchVersionUpgrade", and
     "PatchVersionUpgradeRollback".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryType
    :ivar utc_time: Time when created this upgrade history. Required.
    :vartype utc_time: str
    :ivar upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
     "Failed".
    :vartype upgrade_result: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
    :ivar source_cluster_version: Version with three part.
    :vartype source_cluster_version: str
    :ivar source_oss_version: Version with three part.
    :vartype source_oss_version: str
    :ivar source_build_number: Source build number.
    :vartype source_build_number: str
    :ivar target_cluster_version: Version with three part.
    :vartype target_cluster_version: str
    :ivar target_oss_version: Version with three part.
    :vartype target_oss_version: str
    :ivar target_build_number: Target build number.
    :vartype target_build_number: str
    :ivar component_name: Component name to upgrade.
    :vartype component_name: str
    :ivar severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
     "critical".
    :vartype severity: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistorySeverityType
    """

    _validation = {
        "upgrade_type": {"required": True},
        "utc_time": {"required": True},
        "upgrade_result": {"required": True},
        "source_cluster_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "source_oss_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "target_cluster_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "target_oss_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "utc_time": {"key": "utcTime", "type": "str"},
        "upgrade_result": {"key": "upgradeResult", "type": "str"},
        "source_cluster_version": {"key": "sourceClusterVersion", "type": "str"},
        "source_oss_version": {"key": "sourceOssVersion", "type": "str"},
        "source_build_number": {"key": "sourceBuildNumber", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "target_oss_version": {"key": "targetOssVersion", "type": "str"},
        "target_build_number": {"key": "targetBuildNumber", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
    }

    def __init__(
        self,
        *,
        utc_time: str,
        upgrade_result: Union[str, "_models.ClusterUpgradeHistoryUpgradeResultType"],
        source_cluster_version: Optional[str] = None,
        source_oss_version: Optional[str] = None,
        source_build_number: Optional[str] = None,
        target_cluster_version: Optional[str] = None,
        target_oss_version: Optional[str] = None,
        target_build_number: Optional[str] = None,
        component_name: Optional[str] = None,
        severity: Optional[Union[str, "_models.ClusterUpgradeHistorySeverityType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utc_time: Time when created this upgrade history. Required.
        :paramtype utc_time: str
        :keyword upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
         "Failed".
        :paramtype upgrade_result: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
        :keyword source_cluster_version: Version with three part.
        :paramtype source_cluster_version: str
        :keyword source_oss_version: Version with three part.
        :paramtype source_oss_version: str
        :keyword source_build_number: Source build number.
        :paramtype source_build_number: str
        :keyword target_cluster_version: Version with three part.
        :paramtype target_cluster_version: str
        :keyword target_oss_version: Version with three part.
        :paramtype target_oss_version: str
        :keyword target_build_number: Target build number.
        :paramtype target_build_number: str
        :keyword component_name: Component name to upgrade.
        :paramtype component_name: str
        :keyword severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
         "critical".
        :paramtype severity: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistorySeverityType
        """
        super().__init__(
            utc_time=utc_time,
            upgrade_result=upgrade_result,
            source_cluster_version=source_cluster_version,
            source_oss_version=source_oss_version,
            source_build_number=source_build_number,
            target_cluster_version=target_cluster_version,
            target_oss_version=target_oss_version,
            target_build_number=target_build_number,
            component_name=component_name,
            severity=severity,
            **kwargs
        )
        self.upgrade_type: str = "HotfixUpgradeRollback"


class ClusterInstanceViewProperties(_serialization.Model):
    """Cluster Instance View Properties.

    All required parameters must be populated in order to send to server.

    :ivar status: Status of the instance view. Required.
    :vartype status: ~azure.mgmt.hdinsightcontainers.models.ClusterInstanceViewPropertiesStatus
    :ivar service_statuses: List of statuses of relevant services that make up the HDInsight on AKS
     cluster to surface to the customer. Required.
    :vartype service_statuses: list[~azure.mgmt.hdinsightcontainers.models.ServiceStatus]
    """

    _validation = {
        "status": {"required": True},
        "service_statuses": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "ClusterInstanceViewPropertiesStatus"},
        "service_statuses": {"key": "serviceStatuses", "type": "[ServiceStatus]"},
    }

    def __init__(
        self,
        *,
        status: "_models.ClusterInstanceViewPropertiesStatus",
        service_statuses: List["_models.ServiceStatus"],
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the instance view. Required.
        :paramtype status: ~azure.mgmt.hdinsightcontainers.models.ClusterInstanceViewPropertiesStatus
        :keyword service_statuses: List of statuses of relevant services that make up the HDInsight on
         AKS cluster to surface to the customer. Required.
        :paramtype service_statuses: list[~azure.mgmt.hdinsightcontainers.models.ServiceStatus]
        """
        super().__init__(**kwargs)
        self.status = status
        self.service_statuses = service_statuses


class ClusterInstanceViewStatus(_serialization.Model):
    """Status of the instance view.

    All required parameters must be populated in order to send to server.

    :ivar ready: The cluster ready status. Required.
    :vartype ready: str
    :ivar reason: The status reason.
    :vartype reason: str
    :ivar message: The additional message.
    :vartype message: str
    """

    _validation = {
        "ready": {"required": True},
    }

    _attribute_map = {
        "ready": {"key": "ready", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, ready: str, reason: Optional[str] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword ready: The cluster ready status. Required.
        :paramtype ready: str
        :keyword reason: The status reason.
        :paramtype reason: str
        :keyword message: The additional message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.ready = ready
        self.reason = reason
        self.message = message


class ClusterInstanceViewPropertiesStatus(ClusterInstanceViewStatus):
    """Status of the instance view.

    All required parameters must be populated in order to send to server.

    :ivar ready: The cluster ready status. Required.
    :vartype ready: str
    :ivar reason: The status reason.
    :vartype reason: str
    :ivar message: The additional message.
    :vartype message: str
    """


class ClusterInstanceViewResult(_serialization.Model):
    """Cluster Instance View.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the instance view. Required.
    :vartype name: str
    :ivar properties: Properties of the instance view. Required.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterInstanceViewResultProperties
    """

    _validation = {
        "name": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "ClusterInstanceViewResultProperties"},
    }

    def __init__(self, *, name: str, properties: "_models.ClusterInstanceViewResultProperties", **kwargs: Any) -> None:
        """
        :keyword name: Name of the instance view. Required.
        :paramtype name: str
        :keyword properties: Properties of the instance view. Required.
        :paramtype properties:
         ~azure.mgmt.hdinsightcontainers.models.ClusterInstanceViewResultProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class ClusterInstanceViewResultProperties(ClusterInstanceViewProperties):
    """Properties of the instance view.

    All required parameters must be populated in order to send to server.

    :ivar status: Status of the instance view. Required.
    :vartype status: ~azure.mgmt.hdinsightcontainers.models.ClusterInstanceViewPropertiesStatus
    :ivar service_statuses: List of statuses of relevant services that make up the HDInsight on AKS
     cluster to surface to the customer. Required.
    :vartype service_statuses: list[~azure.mgmt.hdinsightcontainers.models.ServiceStatus]
    """


class ClusterInstanceViewsResult(_serialization.Model):
    """The instance view of a HDInsight Cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Cluster instance view array.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterInstanceViewResult]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterInstanceViewResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ClusterInstanceViewResult"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Cluster instance view array.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterInstanceViewResult]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClusterJob(ProxyResource):
    """Cluster job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar properties: Properties of cluster job. Required.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterJobProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ClusterJobProperties"},
    }

    def __init__(self, *, properties: "_models.ClusterJobProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of cluster job. Required.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterJobProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterJobList(_serialization.Model):
    """Collection of cluster job.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of cluster job. Required.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterJob]
    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterJob]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ClusterJob"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Collection of cluster job. Required.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterJob]
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ClusterJobProperties(_serialization.Model):
    """Properties of cluster job.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FlinkJobProperties

    All required parameters must be populated in order to send to server.

    :ivar job_type: Type of cluster job. Required. "FlinkJob"
    :vartype job_type: str or ~azure.mgmt.hdinsightcontainers.models.JobType
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "job_type": {"key": "jobType", "type": "str"},
    }

    _subtype_map = {"job_type": {"FlinkJob": "FlinkJobProperties"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.job_type: Optional[str] = None


class ClusterLibrary(ProxyResource):
    """Libraries in the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar properties: Properties of a library in the cluster. Required.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterLibraryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ClusterLibraryProperties"},
    }

    def __init__(self, *, properties: "_models.ClusterLibraryProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of a library in the cluster. Required.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterLibraryProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterLibraryList(_serialization.Model):
    """Collection of libraries in the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of libraries in the cluster. Required.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterLibrary]
    :ivar next_link: The url of next result page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterLibrary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ClusterLibrary"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of libraries in the cluster. Required.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterLibrary]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClusterLibraryManagementOperation(ProxyResource):
    """Library management operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar properties: Properties of a library management operation. Required.
    :vartype properties:
     ~azure.mgmt.hdinsightcontainers.models.ClusterLibraryManagementOperationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ClusterLibraryManagementOperationProperties"},
    }

    def __init__(self, *, properties: "_models.ClusterLibraryManagementOperationProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of a library management operation. Required.
        :paramtype properties:
         ~azure.mgmt.hdinsightcontainers.models.ClusterLibraryManagementOperationProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterLibraryManagementOperationProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Properties of a library management operation.

    All required parameters must be populated in order to send to server.

    :ivar action: The library management action. Required. Known values are: "Install" and
     "Uninstall".
    :vartype action: str or ~azure.mgmt.hdinsightcontainers.models.LibraryManagementAction
    :ivar libraries: The libraries to be installed/updated/uninstalled. Required.
    :vartype libraries: list[~azure.mgmt.hdinsightcontainers.models.ClusterLibrary]
    """

    _validation = {
        "action": {"required": True},
        "libraries": {"required": True},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "libraries": {"key": "libraries", "type": "[ClusterLibrary]"},
    }

    def __init__(
        self,
        *,
        action: Union[str, "_models.LibraryManagementAction"],
        libraries: List["_models.ClusterLibrary"],
        **kwargs: Any
    ) -> None:
        """
        :keyword action: The library management action. Required. Known values are: "Install" and
         "Uninstall".
        :paramtype action: str or ~azure.mgmt.hdinsightcontainers.models.LibraryManagementAction
        :keyword libraries: The libraries to be installed/updated/uninstalled. Required.
        :paramtype libraries: list[~azure.mgmt.hdinsightcontainers.models.ClusterLibrary]
        """
        super().__init__(**kwargs)
        self.action = action
        self.libraries = libraries


class ClusterLibraryProperties(_serialization.Model):
    """Properties of a library in the cluster.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MavenLibraryProperties, PyPiLibraryProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of the library. Required. Known values are: "pypi" and "maven".
    :vartype type: str or ~azure.mgmt.hdinsightcontainers.models.Type
    :ivar remarks: Remark of the latest library management operation.
    :vartype remarks: str
    :ivar timestamp: Timestamp of the latest library management operation.
    :vartype timestamp: ~datetime.datetime
    :ivar status: Status of the library. Known values are: "INSTALLING", "INSTALLED",
     "INSTALL_FAILED", "UNINSTALLING", and "UNINSTALL_FAILED".
    :vartype status: str or ~azure.mgmt.hdinsightcontainers.models.Status
    :ivar message: Error message of the library operation when a failure occurs.
    :vartype message: str
    """

    _validation = {
        "type": {"required": True},
        "timestamp": {"readonly": True},
        "status": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "remarks": {"key": "remarks", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    _subtype_map = {"type": {"maven": "MavenLibraryProperties", "pypi": "PyPiLibraryProperties"}}

    def __init__(self, *, remarks: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword remarks: Remark of the latest library management operation.
        :paramtype remarks: str
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.remarks = remarks
        self.timestamp = None
        self.status = None
        self.message = None


class ClusterListResult(_serialization.Model):
    """The list cluster operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of clusters.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.Cluster]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Cluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Cluster"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of clusters.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.Cluster]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClusterLogAnalyticsApplicationLogs(_serialization.Model):
    """Collection of logs to be enabled or disabled for log analytics.

    :ivar std_out_enabled: True if stdout is enabled, otherwise false.
    :vartype std_out_enabled: bool
    :ivar std_error_enabled: True if stderror is enabled, otherwise false.
    :vartype std_error_enabled: bool
    """

    _attribute_map = {
        "std_out_enabled": {"key": "stdOutEnabled", "type": "bool"},
        "std_error_enabled": {"key": "stdErrorEnabled", "type": "bool"},
    }

    def __init__(
        self, *, std_out_enabled: Optional[bool] = None, std_error_enabled: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword std_out_enabled: True if stdout is enabled, otherwise false.
        :paramtype std_out_enabled: bool
        :keyword std_error_enabled: True if stderror is enabled, otherwise false.
        :paramtype std_error_enabled: bool
        """
        super().__init__(**kwargs)
        self.std_out_enabled = std_out_enabled
        self.std_error_enabled = std_error_enabled


class ClusterLogAnalyticsProfile(_serialization.Model):
    """Cluster log analytics profile to enable or disable OMS agent for cluster.

    All required parameters must be populated in order to send to server.

    :ivar enabled: True if log analytics is enabled for the cluster, otherwise false. Required.
    :vartype enabled: bool
    :ivar application_logs: Collection of logs to be enabled or disabled for log analytics.
    :vartype application_logs:
     ~azure.mgmt.hdinsightcontainers.models.ClusterLogAnalyticsApplicationLogs
    :ivar metrics_enabled: True if metrics are enabled, otherwise false.
    :vartype metrics_enabled: bool
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "application_logs": {"key": "applicationLogs", "type": "ClusterLogAnalyticsApplicationLogs"},
        "metrics_enabled": {"key": "metricsEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        application_logs: Optional["_models.ClusterLogAnalyticsApplicationLogs"] = None,
        metrics_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: True if log analytics is enabled for the cluster, otherwise false. Required.
        :paramtype enabled: bool
        :keyword application_logs: Collection of logs to be enabled or disabled for log analytics.
        :paramtype application_logs:
         ~azure.mgmt.hdinsightcontainers.models.ClusterLogAnalyticsApplicationLogs
        :keyword metrics_enabled: True if metrics are enabled, otherwise false.
        :paramtype metrics_enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.application_logs = application_logs
        self.metrics_enabled = metrics_enabled


class ClusterPatch(_serialization.Model):
    """The patch for a cluster.

    :ivar properties: Define cluster patch specific properties.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterPatchProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ClusterPatchProperties"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.ClusterPatchProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Define cluster patch specific properties.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterPatchProperties
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags


class ClusterPatchProperties(_serialization.Model):
    """Cluster resource patch data.

    :ivar cluster_profile: Cluster resource patch properties.
    :vartype cluster_profile: ~azure.mgmt.hdinsightcontainers.models.UpdatableClusterProfile
    """

    _attribute_map = {
        "cluster_profile": {"key": "clusterProfile", "type": "UpdatableClusterProfile"},
    }

    def __init__(self, *, cluster_profile: Optional["_models.UpdatableClusterProfile"] = None, **kwargs: Any) -> None:
        """
        :keyword cluster_profile: Cluster resource patch properties.
        :paramtype cluster_profile: ~azure.mgmt.hdinsightcontainers.models.UpdatableClusterProfile
        """
        super().__init__(**kwargs)
        self.cluster_profile = cluster_profile


class ClusterPatchVersionUpgradeHistoryProperties(
    ClusterInPlaceUpgradeHistoryProperties
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Cluster patch version upgrade history properties.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", "HotfixUpgradeRollback", "PatchVersionUpgrade", and
     "PatchVersionUpgradeRollback".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryType
    :ivar utc_time: Time when created this upgrade history. Required.
    :vartype utc_time: str
    :ivar upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
     "Failed".
    :vartype upgrade_result: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
    :ivar source_cluster_version: Version with three part.
    :vartype source_cluster_version: str
    :ivar source_oss_version: Version with three part.
    :vartype source_oss_version: str
    :ivar source_build_number: Source build number.
    :vartype source_build_number: str
    :ivar target_cluster_version: Version with three part.
    :vartype target_cluster_version: str
    :ivar target_oss_version: Version with three part.
    :vartype target_oss_version: str
    :ivar target_build_number: Target build number.
    :vartype target_build_number: str
    :ivar component_name: Component name to upgrade.
    :vartype component_name: str
    :ivar severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
     "critical".
    :vartype severity: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistorySeverityType
    """

    _validation = {
        "upgrade_type": {"required": True},
        "utc_time": {"required": True},
        "upgrade_result": {"required": True},
        "source_cluster_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "source_oss_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "target_cluster_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "target_oss_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "utc_time": {"key": "utcTime", "type": "str"},
        "upgrade_result": {"key": "upgradeResult", "type": "str"},
        "source_cluster_version": {"key": "sourceClusterVersion", "type": "str"},
        "source_oss_version": {"key": "sourceOssVersion", "type": "str"},
        "source_build_number": {"key": "sourceBuildNumber", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "target_oss_version": {"key": "targetOssVersion", "type": "str"},
        "target_build_number": {"key": "targetBuildNumber", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
    }

    def __init__(
        self,
        *,
        utc_time: str,
        upgrade_result: Union[str, "_models.ClusterUpgradeHistoryUpgradeResultType"],
        source_cluster_version: Optional[str] = None,
        source_oss_version: Optional[str] = None,
        source_build_number: Optional[str] = None,
        target_cluster_version: Optional[str] = None,
        target_oss_version: Optional[str] = None,
        target_build_number: Optional[str] = None,
        component_name: Optional[str] = None,
        severity: Optional[Union[str, "_models.ClusterUpgradeHistorySeverityType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utc_time: Time when created this upgrade history. Required.
        :paramtype utc_time: str
        :keyword upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
         "Failed".
        :paramtype upgrade_result: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
        :keyword source_cluster_version: Version with three part.
        :paramtype source_cluster_version: str
        :keyword source_oss_version: Version with three part.
        :paramtype source_oss_version: str
        :keyword source_build_number: Source build number.
        :paramtype source_build_number: str
        :keyword target_cluster_version: Version with three part.
        :paramtype target_cluster_version: str
        :keyword target_oss_version: Version with three part.
        :paramtype target_oss_version: str
        :keyword target_build_number: Target build number.
        :paramtype target_build_number: str
        :keyword component_name: Component name to upgrade.
        :paramtype component_name: str
        :keyword severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
         "critical".
        :paramtype severity: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistorySeverityType
        """
        super().__init__(
            utc_time=utc_time,
            upgrade_result=upgrade_result,
            source_cluster_version=source_cluster_version,
            source_oss_version=source_oss_version,
            source_build_number=source_build_number,
            target_cluster_version=target_cluster_version,
            target_oss_version=target_oss_version,
            target_build_number=target_build_number,
            component_name=component_name,
            severity=severity,
            **kwargs
        )
        self.upgrade_type: str = "PatchVersionUpgrade"


class ClusterPatchVersionUpgradeProperties(ClusterInPlaceUpgradeProperties):
    """Properties of upgrading cluster's patch version.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", and "PatchVersionUpgrade".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeType
    :ivar target_oss_version: Target OSS version of component to be upgraded.
    :vartype target_oss_version: str
    :ivar target_cluster_version: Target cluster version of component to be upgraded.
    :vartype target_cluster_version: str
    :ivar target_build_number: Target build number of component to be upgraded.
    :vartype target_build_number: str
    :ivar component_name: Name of component to be upgraded.
    :vartype component_name: str
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "target_oss_version": {"key": "targetOssVersion", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "target_build_number": {"key": "targetBuildNumber", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_oss_version: Optional[str] = None,
        target_cluster_version: Optional[str] = None,
        target_build_number: Optional[str] = None,
        component_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_oss_version: Target OSS version of component to be upgraded.
        :paramtype target_oss_version: str
        :keyword target_cluster_version: Target cluster version of component to be upgraded.
        :paramtype target_cluster_version: str
        :keyword target_build_number: Target build number of component to be upgraded.
        :paramtype target_build_number: str
        :keyword component_name: Name of component to be upgraded.
        :paramtype component_name: str
        """
        super().__init__(
            target_oss_version=target_oss_version,
            target_cluster_version=target_cluster_version,
            target_build_number=target_build_number,
            component_name=component_name,
            **kwargs
        )
        self.upgrade_type: str = "PatchVersionUpgrade"


class ClusterPatchVersionUpgradeRollbackHistoryProperties(
    ClusterInPlaceUpgradeHistoryProperties
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Cluster patch version upgrade rollback history properties.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade",
     "HotfixUpgrade", "HotfixUpgradeRollback", "PatchVersionUpgrade", and
     "PatchVersionUpgradeRollback".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryType
    :ivar utc_time: Time when created this upgrade history. Required.
    :vartype utc_time: str
    :ivar upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
     "Failed".
    :vartype upgrade_result: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
    :ivar source_cluster_version: Version with three part.
    :vartype source_cluster_version: str
    :ivar source_oss_version: Version with three part.
    :vartype source_oss_version: str
    :ivar source_build_number: Source build number.
    :vartype source_build_number: str
    :ivar target_cluster_version: Version with three part.
    :vartype target_cluster_version: str
    :ivar target_oss_version: Version with three part.
    :vartype target_oss_version: str
    :ivar target_build_number: Target build number.
    :vartype target_build_number: str
    :ivar component_name: Component name to upgrade.
    :vartype component_name: str
    :ivar severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
     "critical".
    :vartype severity: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistorySeverityType
    """

    _validation = {
        "upgrade_type": {"required": True},
        "utc_time": {"required": True},
        "upgrade_result": {"required": True},
        "source_cluster_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "source_oss_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "target_cluster_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "target_oss_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "utc_time": {"key": "utcTime", "type": "str"},
        "upgrade_result": {"key": "upgradeResult", "type": "str"},
        "source_cluster_version": {"key": "sourceClusterVersion", "type": "str"},
        "source_oss_version": {"key": "sourceOssVersion", "type": "str"},
        "source_build_number": {"key": "sourceBuildNumber", "type": "str"},
        "target_cluster_version": {"key": "targetClusterVersion", "type": "str"},
        "target_oss_version": {"key": "targetOssVersion", "type": "str"},
        "target_build_number": {"key": "targetBuildNumber", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
    }

    def __init__(
        self,
        *,
        utc_time: str,
        upgrade_result: Union[str, "_models.ClusterUpgradeHistoryUpgradeResultType"],
        source_cluster_version: Optional[str] = None,
        source_oss_version: Optional[str] = None,
        source_build_number: Optional[str] = None,
        target_cluster_version: Optional[str] = None,
        target_oss_version: Optional[str] = None,
        target_build_number: Optional[str] = None,
        component_name: Optional[str] = None,
        severity: Optional[Union[str, "_models.ClusterUpgradeHistorySeverityType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utc_time: Time when created this upgrade history. Required.
        :paramtype utc_time: str
        :keyword upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
         "Failed".
        :paramtype upgrade_result: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryUpgradeResultType
        :keyword source_cluster_version: Version with three part.
        :paramtype source_cluster_version: str
        :keyword source_oss_version: Version with three part.
        :paramtype source_oss_version: str
        :keyword source_build_number: Source build number.
        :paramtype source_build_number: str
        :keyword target_cluster_version: Version with three part.
        :paramtype target_cluster_version: str
        :keyword target_oss_version: Version with three part.
        :paramtype target_oss_version: str
        :keyword target_build_number: Target build number.
        :paramtype target_build_number: str
        :keyword component_name: Component name to upgrade.
        :paramtype component_name: str
        :keyword severity: Severity of this upgrade. Known values are: "low", "medium", "high", and
         "critical".
        :paramtype severity: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistorySeverityType
        """
        super().__init__(
            utc_time=utc_time,
            upgrade_result=upgrade_result,
            source_cluster_version=source_cluster_version,
            source_oss_version=source_oss_version,
            source_build_number=source_build_number,
            target_cluster_version=target_cluster_version,
            target_oss_version=target_oss_version,
            target_build_number=target_build_number,
            component_name=component_name,
            severity=severity,
            **kwargs
        )
        self.upgrade_type: str = "PatchVersionUpgradeRollback"


class ClusterPool(TrackedResource):
    """Cluster pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Gets or sets the properties. Define cluster pool specific properties.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterPoolResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ClusterPoolResourceProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ClusterPoolResourceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Gets or sets the properties. Define cluster pool specific properties.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterPoolResourceProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class ClusterPoolUpgradeHistoryProperties(_serialization.Model):
    """Properties of cluster pool upgrade history.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClusterPoolAksPatchUpgradeHistoryProperties, ClusterPoolNodeOsUpgradeHistoryProperties

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade" and
     "NodeOsUpgrade".
    :vartype upgrade_type: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistoryType
    :ivar utc_time: Time when created this upgrade history. Required.
    :vartype utc_time: str
    :ivar upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
     "Failed".
    :vartype upgrade_result: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistoryUpgradeResultType
    """

    _validation = {
        "upgrade_type": {"required": True},
        "utc_time": {"required": True},
        "upgrade_result": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "utc_time": {"key": "utcTime", "type": "str"},
        "upgrade_result": {"key": "upgradeResult", "type": "str"},
    }

    _subtype_map = {
        "upgrade_type": {
            "AKSPatchUpgrade": "ClusterPoolAksPatchUpgradeHistoryProperties",
            "NodeOsUpgrade": "ClusterPoolNodeOsUpgradeHistoryProperties",
        }
    }

    def __init__(
        self,
        *,
        utc_time: str,
        upgrade_result: Union[str, "_models.ClusterPoolUpgradeHistoryUpgradeResultType"],
        **kwargs: Any
    ) -> None:
        """
        :keyword utc_time: Time when created this upgrade history. Required.
        :paramtype utc_time: str
        :keyword upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
         "Failed".
        :paramtype upgrade_result: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistoryUpgradeResultType
        """
        super().__init__(**kwargs)
        self.upgrade_type: Optional[str] = None
        self.utc_time = utc_time
        self.upgrade_result = upgrade_result


class ClusterPoolAksPatchUpgradeHistoryProperties(ClusterPoolUpgradeHistoryProperties):  # pylint: disable=name-too-long
    """Cluster pool aks upgrade history properties.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade" and
     "NodeOsUpgrade".
    :vartype upgrade_type: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistoryType
    :ivar utc_time: Time when created this upgrade history. Required.
    :vartype utc_time: str
    :ivar upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
     "Failed".
    :vartype upgrade_result: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistoryUpgradeResultType
    :ivar upgrade_cluster_pool: Whether upgrade cluster pool.
    :vartype upgrade_cluster_pool: bool
    :ivar upgrade_all_cluster_nodes: Whether upgrade all cluster nodes.
    :vartype upgrade_all_cluster_nodes: bool
    :ivar original_version: Version before update.
    :vartype original_version: str
    :ivar new_version: Version going to update.
    :vartype new_version: str
    """

    _validation = {
        "upgrade_type": {"required": True},
        "utc_time": {"required": True},
        "upgrade_result": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "utc_time": {"key": "utcTime", "type": "str"},
        "upgrade_result": {"key": "upgradeResult", "type": "str"},
        "upgrade_cluster_pool": {"key": "upgradeClusterPool", "type": "bool"},
        "upgrade_all_cluster_nodes": {"key": "upgradeAllClusterNodes", "type": "bool"},
        "original_version": {"key": "originalVersion", "type": "str"},
        "new_version": {"key": "newVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        utc_time: str,
        upgrade_result: Union[str, "_models.ClusterPoolUpgradeHistoryUpgradeResultType"],
        upgrade_cluster_pool: Optional[bool] = None,
        upgrade_all_cluster_nodes: Optional[bool] = None,
        original_version: Optional[str] = None,
        new_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utc_time: Time when created this upgrade history. Required.
        :paramtype utc_time: str
        :keyword upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
         "Failed".
        :paramtype upgrade_result: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistoryUpgradeResultType
        :keyword upgrade_cluster_pool: Whether upgrade cluster pool.
        :paramtype upgrade_cluster_pool: bool
        :keyword upgrade_all_cluster_nodes: Whether upgrade all cluster nodes.
        :paramtype upgrade_all_cluster_nodes: bool
        :keyword original_version: Version before update.
        :paramtype original_version: str
        :keyword new_version: Version going to update.
        :paramtype new_version: str
        """
        super().__init__(utc_time=utc_time, upgrade_result=upgrade_result, **kwargs)
        self.upgrade_type: str = "AKSPatchUpgrade"
        self.upgrade_cluster_pool = upgrade_cluster_pool
        self.upgrade_all_cluster_nodes = upgrade_all_cluster_nodes
        self.original_version = original_version
        self.new_version = new_version


class ClusterPoolUpgradeProperties(_serialization.Model):
    """Properties of upgrading cluster pool.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClusterPoolAKSPatchVersionUpgradeProperties, ClusterPoolNodeOsImageUpdateProperties

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade" and
     "NodeOsUpgrade".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeType
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
    }

    _subtype_map = {
        "upgrade_type": {
            "AKSPatchUpgrade": "ClusterPoolAKSPatchVersionUpgradeProperties",
            "NodeOsUpgrade": "ClusterPoolNodeOsImageUpdateProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.upgrade_type: Optional[str] = None


class ClusterPoolAKSPatchVersionUpgradeProperties(ClusterPoolUpgradeProperties):  # pylint: disable=name-too-long
    """Properties of upgrading cluster pool's AKS patch version.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade" and
     "NodeOsUpgrade".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeType
    :ivar upgrade_cluster_pool: whether upgrade cluster pool or not. If it's true,
     upgradeAllClusterNodes should be false.
    :vartype upgrade_cluster_pool: bool
    :ivar upgrade_all_cluster_nodes: whether upgrade all clusters' nodes. If it's true,
     upgradeClusterPool should be false.
    :vartype upgrade_all_cluster_nodes: bool
    :ivar target_aks_version: Target AKS version. When it's not set, latest version will be used.
     When upgradeClusterPool is true and upgradeAllClusterNodes is false, target version should be
     greater or equal to current version. When upgradeClusterPool is false and
     upgradeAllClusterNodes is true, target version should be equal to AKS version of cluster pool.
    :vartype target_aks_version: str
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "upgrade_cluster_pool": {"key": "upgradeClusterPool", "type": "bool"},
        "upgrade_all_cluster_nodes": {"key": "upgradeAllClusterNodes", "type": "bool"},
        "target_aks_version": {"key": "targetAksVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        upgrade_cluster_pool: bool = False,
        upgrade_all_cluster_nodes: bool = False,
        target_aks_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword upgrade_cluster_pool: whether upgrade cluster pool or not. If it's true,
         upgradeAllClusterNodes should be false.
        :paramtype upgrade_cluster_pool: bool
        :keyword upgrade_all_cluster_nodes: whether upgrade all clusters' nodes. If it's true,
         upgradeClusterPool should be false.
        :paramtype upgrade_all_cluster_nodes: bool
        :keyword target_aks_version: Target AKS version. When it's not set, latest version will be
         used. When upgradeClusterPool is true and upgradeAllClusterNodes is false, target version
         should be greater or equal to current version. When upgradeClusterPool is false and
         upgradeAllClusterNodes is true, target version should be equal to AKS version of cluster pool.
        :paramtype target_aks_version: str
        """
        super().__init__(**kwargs)
        self.upgrade_type: str = "AKSPatchUpgrade"
        self.upgrade_cluster_pool = upgrade_cluster_pool
        self.upgrade_all_cluster_nodes = upgrade_all_cluster_nodes
        self.target_aks_version = target_aks_version


class ClusterPoolAvailableUpgrade(ProxyResource):
    """Cluster pool available upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar properties: Gets or sets the properties. Define cluster pool upgrade specific properties.
    :vartype properties:
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolAvailableUpgradeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ClusterPoolAvailableUpgradeProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.ClusterPoolAvailableUpgradeProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Gets or sets the properties. Define cluster pool upgrade specific
         properties.
        :paramtype properties:
         ~azure.mgmt.hdinsightcontainers.models.ClusterPoolAvailableUpgradeProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterPoolAvailableUpgradeProperties(_serialization.Model):
    """Cluster pool available upgrade properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClusterPoolAvailableUpgradeAksPatchUpgradeProperties,
    ClusterPoolAvailableUpgradeNodeOsUpgradeProperties

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade" and
     "NodeOsUpgrade".
    :vartype upgrade_type: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolAvailableUpgradeType
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
    }

    _subtype_map = {
        "upgrade_type": {
            "AKSPatchUpgrade": "ClusterPoolAvailableUpgradeAksPatchUpgradeProperties",
            "NodeOsUpgrade": "ClusterPoolAvailableUpgradeNodeOsUpgradeProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.upgrade_type: Optional[str] = None


class ClusterPoolAvailableUpgradeAksPatchUpgradeProperties(
    ClusterPoolAvailableUpgradeProperties
):  # pylint: disable=name-too-long
    """Cluster pool available AKS patch version upgrade.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade" and
     "NodeOsUpgrade".
    :vartype upgrade_type: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolAvailableUpgradeType
    :ivar current_version: Current AKS version.
    :vartype current_version: str
    :ivar current_version_status: Current AKS version's status: whether it is deprecated or
     supported. Known values are: "Deprecated" and "Supported".
    :vartype current_version_status: str or
     ~azure.mgmt.hdinsightcontainers.models.CurrentClusterPoolAksVersionStatus
    :ivar latest_version: Latest AKS patch version.
    :vartype latest_version: str
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "current_version": {"key": "currentVersion", "type": "str"},
        "current_version_status": {"key": "currentVersionStatus", "type": "str"},
        "latest_version": {"key": "latestVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        current_version: Optional[str] = None,
        current_version_status: Optional[Union[str, "_models.CurrentClusterPoolAksVersionStatus"]] = None,
        latest_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword current_version: Current AKS version.
        :paramtype current_version: str
        :keyword current_version_status: Current AKS version's status: whether it is deprecated or
         supported. Known values are: "Deprecated" and "Supported".
        :paramtype current_version_status: str or
         ~azure.mgmt.hdinsightcontainers.models.CurrentClusterPoolAksVersionStatus
        :keyword latest_version: Latest AKS patch version.
        :paramtype latest_version: str
        """
        super().__init__(**kwargs)
        self.upgrade_type: str = "AKSPatchUpgrade"
        self.current_version = current_version
        self.current_version_status = current_version_status
        self.latest_version = latest_version


class ClusterPoolAvailableUpgradeList(_serialization.Model):
    """collection of cluster pool available upgrade.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of cluster pool available upgrade. Required.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterPoolAvailableUpgrade]
    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterPoolAvailableUpgrade]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ClusterPoolAvailableUpgrade"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of cluster pool available upgrade. Required.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterPoolAvailableUpgrade]
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ClusterPoolAvailableUpgradeNodeOsUpgradeProperties(
    ClusterPoolAvailableUpgradeProperties
):  # pylint: disable=name-too-long
    """Cluster pool available node OS update.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade" and
     "NodeOsUpgrade".
    :vartype upgrade_type: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolAvailableUpgradeType
    :ivar latest_version: The latest node OS version.
    :vartype latest_version: str
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "latest_version": {"key": "latestVersion", "type": "str"},
    }

    def __init__(self, *, latest_version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword latest_version: The latest node OS version.
        :paramtype latest_version: str
        """
        super().__init__(**kwargs)
        self.upgrade_type: str = "NodeOsUpgrade"
        self.latest_version = latest_version


class ClusterPoolComputeProfile(_serialization.Model):
    """Cluster pool compute profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar vm_size: The virtual machine SKU. Required.
    :vartype vm_size: str
    :ivar count: The number of virtual machines.
    :vartype count: int
    :ivar availability_zones: The list of Availability zones to use for AKS VMSS nodes.
    :vartype availability_zones: list[str]
    """

    _validation = {
        "vm_size": {"required": True, "pattern": r"^[a-zA-Z0-9_\-]{0,256}$"},
        "count": {"readonly": True},
    }

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
    }

    def __init__(self, *, vm_size: str, availability_zones: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword vm_size: The virtual machine SKU. Required.
        :paramtype vm_size: str
        :keyword availability_zones: The list of Availability zones to use for AKS VMSS nodes.
        :paramtype availability_zones: list[str]
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.count = None
        self.availability_zones = availability_zones


class ClusterPoolListResult(_serialization.Model):
    """The list cluster pools operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of cluster pools.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterPool]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ClusterPool"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of cluster pools.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterPool]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClusterPoolLogAnalyticsProfile(_serialization.Model):
    """Cluster pool log analytics profile used to enable or disable OMS agent for AKS cluster.

    All required parameters must be populated in order to send to server.

    :ivar enabled: True if log analytics is enabled for cluster pool, otherwise false. Required.
    :vartype enabled: bool
    :ivar workspace_id: Log analytics workspace to associate with the OMS agent.
    :vartype workspace_id: str
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
    }

    def __init__(self, *, enabled: bool, workspace_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: True if log analytics is enabled for cluster pool, otherwise false. Required.
        :paramtype enabled: bool
        :keyword workspace_id: Log analytics workspace to associate with the OMS agent.
        :paramtype workspace_id: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workspace_id = workspace_id


class ClusterPoolNetworkProfile(_serialization.Model):
    """Cluster pool networking configuration.

    All required parameters must be populated in order to send to server.

    :ivar subnet_id: Cluster pool subnet resource id. Required.
    :vartype subnet_id: str
    :ivar outbound_type: This can only be set at cluster pool creation time and cannot be changed
     later. Known values are: "loadBalancer" and "userDefinedRouting".
    :vartype outbound_type: str or ~azure.mgmt.hdinsightcontainers.models.OutboundType
    :ivar enable_private_api_server: ClusterPool is based on AKS cluster. AKS cluster exposes the
     API server to public internet by default. If you set this property to true, a private AKS
     cluster will be created, and it will use private apiserver, which is not exposed to public
     internet.
    :vartype enable_private_api_server: bool
    :ivar api_server_authorized_ip_ranges: IP ranges are specified in CIDR format, e.g.
     137.117.106.88/29. This feature is not compatible with private AKS clusters. So you cannot set
     enablePrivateApiServer to true and apiServerAuthorizedIpRanges at the same time. Currently,
     this property is not supported and please don't use it.
    :vartype api_server_authorized_ip_ranges: list[str]
    """

    _validation = {
        "subnet_id": {"required": True},
    }

    _attribute_map = {
        "subnet_id": {"key": "subnetId", "type": "str"},
        "outbound_type": {"key": "outboundType", "type": "str"},
        "enable_private_api_server": {"key": "enablePrivateApiServer", "type": "bool"},
        "api_server_authorized_ip_ranges": {"key": "apiServerAuthorizedIpRanges", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        subnet_id: str,
        outbound_type: Union[str, "_models.OutboundType"] = "loadBalancer",
        enable_private_api_server: Optional[bool] = None,
        api_server_authorized_ip_ranges: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subnet_id: Cluster pool subnet resource id. Required.
        :paramtype subnet_id: str
        :keyword outbound_type: This can only be set at cluster pool creation time and cannot be
         changed later. Known values are: "loadBalancer" and "userDefinedRouting".
        :paramtype outbound_type: str or ~azure.mgmt.hdinsightcontainers.models.OutboundType
        :keyword enable_private_api_server: ClusterPool is based on AKS cluster. AKS cluster exposes
         the API server to public internet by default. If you set this property to true, a private AKS
         cluster will be created, and it will use private apiserver, which is not exposed to public
         internet.
        :paramtype enable_private_api_server: bool
        :keyword api_server_authorized_ip_ranges: IP ranges are specified in CIDR format, e.g.
         137.117.106.88/29. This feature is not compatible with private AKS clusters. So you cannot set
         enablePrivateApiServer to true and apiServerAuthorizedIpRanges at the same time. Currently,
         this property is not supported and please don't use it.
        :paramtype api_server_authorized_ip_ranges: list[str]
        """
        super().__init__(**kwargs)
        self.subnet_id = subnet_id
        self.outbound_type = outbound_type
        self.enable_private_api_server = enable_private_api_server
        self.api_server_authorized_ip_ranges = api_server_authorized_ip_ranges


class ClusterPoolNodeOsImageUpdateProperties(ClusterPoolUpgradeProperties):
    """Properties of upgrading cluster pool's AKS patch version.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade" and
     "NodeOsUpgrade".
    :vartype upgrade_type: str or ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeType
    """

    _validation = {
        "upgrade_type": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.upgrade_type: str = "NodeOsUpgrade"


class ClusterPoolNodeOsUpgradeHistoryProperties(ClusterPoolUpgradeHistoryProperties):  # pylint: disable=name-too-long
    """Cluster pool node os upgrade history properties.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_type: Type of upgrade. Required. Known values are: "AKSPatchUpgrade" and
     "NodeOsUpgrade".
    :vartype upgrade_type: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistoryType
    :ivar utc_time: Time when created this upgrade history. Required.
    :vartype utc_time: str
    :ivar upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
     "Failed".
    :vartype upgrade_result: str or
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistoryUpgradeResultType
    :ivar new_node_os: New Node Os version.
    :vartype new_node_os: str
    """

    _validation = {
        "upgrade_type": {"required": True},
        "utc_time": {"required": True},
        "upgrade_result": {"required": True},
    }

    _attribute_map = {
        "upgrade_type": {"key": "upgradeType", "type": "str"},
        "utc_time": {"key": "utcTime", "type": "str"},
        "upgrade_result": {"key": "upgradeResult", "type": "str"},
        "new_node_os": {"key": "newNodeOs", "type": "str"},
    }

    def __init__(
        self,
        *,
        utc_time: str,
        upgrade_result: Union[str, "_models.ClusterPoolUpgradeHistoryUpgradeResultType"],
        new_node_os: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword utc_time: Time when created this upgrade history. Required.
        :paramtype utc_time: str
        :keyword upgrade_result: Result of this upgrade. Required. Known values are: "Succeed" and
         "Failed".
        :paramtype upgrade_result: str or
         ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistoryUpgradeResultType
        :keyword new_node_os: New Node Os version.
        :paramtype new_node_os: str
        """
        super().__init__(utc_time=utc_time, upgrade_result=upgrade_result, **kwargs)
        self.upgrade_type: str = "NodeOsUpgrade"
        self.new_node_os = new_node_os


class ClusterPoolProfile(_serialization.Model):
    """Cluster pool profile.

    All required parameters must be populated in order to send to server.

    :ivar cluster_pool_version: Cluster pool version is a 2-part version. Required.
    :vartype cluster_pool_version: str
    :ivar public_ip_tag: Gets or sets the IP tag for the public IPs created along with the
     HDInsightOnAks ClusterPools and Clusters.
    :vartype public_ip_tag: ~azure.mgmt.hdinsightcontainers.models.IpTag
    """

    _validation = {
        "cluster_pool_version": {"required": True, "pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
    }

    _attribute_map = {
        "cluster_pool_version": {"key": "clusterPoolVersion", "type": "str"},
        "public_ip_tag": {"key": "publicIpTag", "type": "IpTag"},
    }

    def __init__(
        self, *, cluster_pool_version: str, public_ip_tag: Optional["_models.IpTag"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword cluster_pool_version: Cluster pool version is a 2-part version. Required.
        :paramtype cluster_pool_version: str
        :keyword public_ip_tag: Gets or sets the IP tag for the public IPs created along with the
         HDInsightOnAks ClusterPools and Clusters.
        :paramtype public_ip_tag: ~azure.mgmt.hdinsightcontainers.models.IpTag
        """
        super().__init__(**kwargs)
        self.cluster_pool_version = cluster_pool_version
        self.public_ip_tag = public_ip_tag


class ClusterPoolResourceProperties(_serialization.Model):
    """Cluster pool resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.hdinsightcontainers.models.ProvisioningStatus
    :ivar deployment_id: A unique id generated by the RP to identify the resource.
    :vartype deployment_id: str
    :ivar managed_resource_group_name: A resource group created by RP, to hold the resources
     created by RP on-behalf of customers. It will also be used to generate
     aksManagedResourceGroupName by pattern: MC\\ *{managedResourceGroupName}*\\
     {clusterPoolName}_{region}. Please make sure it meets resource group name restriction.
    :vartype managed_resource_group_name: str
    :ivar aks_managed_resource_group_name: A resource group created by AKS, to hold the
     infrastructure resources created by AKS on-behalf of customers. It is generated by cluster pool
     name and managed resource group name by pattern: MC\\ *{managedResourceGroupName}*\\
     {clusterPoolName}_{region}.
    :vartype aks_managed_resource_group_name: str
    :ivar cluster_pool_profile: CLuster pool profile.
    :vartype cluster_pool_profile:
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolResourcePropertiesClusterPoolProfile
    :ivar compute_profile: CLuster pool compute profile. Required.
    :vartype compute_profile:
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolResourcePropertiesComputeProfile
    :ivar aks_cluster_profile: Properties of underlying AKS cluster.
    :vartype aks_cluster_profile:
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolResourcePropertiesAksClusterProfile
    :ivar network_profile: Cluster pool network profile.
    :vartype network_profile:
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolResourcePropertiesNetworkProfile
    :ivar log_analytics_profile: Cluster pool log analytics profile to enable OMS agent for AKS
     cluster.
    :vartype log_analytics_profile:
     ~azure.mgmt.hdinsightcontainers.models.ClusterPoolResourcePropertiesLogAnalyticsProfile
    :ivar status: Business status of the resource.
    :vartype status: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_id": {"readonly": True},
        "managed_resource_group_name": {"max_length": 40, "min_length": 1},
        "aks_managed_resource_group_name": {"readonly": True},
        "compute_profile": {"required": True},
        "aks_cluster_profile": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_id": {"key": "deploymentId", "type": "str"},
        "managed_resource_group_name": {"key": "managedResourceGroupName", "type": "str"},
        "aks_managed_resource_group_name": {"key": "aksManagedResourceGroupName", "type": "str"},
        "cluster_pool_profile": {
            "key": "clusterPoolProfile",
            "type": "ClusterPoolResourcePropertiesClusterPoolProfile",
        },
        "compute_profile": {"key": "computeProfile", "type": "ClusterPoolResourcePropertiesComputeProfile"},
        "aks_cluster_profile": {"key": "aksClusterProfile", "type": "ClusterPoolResourcePropertiesAksClusterProfile"},
        "network_profile": {"key": "networkProfile", "type": "ClusterPoolResourcePropertiesNetworkProfile"},
        "log_analytics_profile": {
            "key": "logAnalyticsProfile",
            "type": "ClusterPoolResourcePropertiesLogAnalyticsProfile",
        },
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        compute_profile: "_models.ClusterPoolResourcePropertiesComputeProfile",
        managed_resource_group_name: Optional[str] = None,
        cluster_pool_profile: Optional["_models.ClusterPoolResourcePropertiesClusterPoolProfile"] = None,
        network_profile: Optional["_models.ClusterPoolResourcePropertiesNetworkProfile"] = None,
        log_analytics_profile: Optional["_models.ClusterPoolResourcePropertiesLogAnalyticsProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_resource_group_name: A resource group created by RP, to hold the resources
         created by RP on-behalf of customers. It will also be used to generate
         aksManagedResourceGroupName by pattern: MC\\ *{managedResourceGroupName}*\\
         {clusterPoolName}_{region}. Please make sure it meets resource group name restriction.
        :paramtype managed_resource_group_name: str
        :keyword cluster_pool_profile: CLuster pool profile.
        :paramtype cluster_pool_profile:
         ~azure.mgmt.hdinsightcontainers.models.ClusterPoolResourcePropertiesClusterPoolProfile
        :keyword compute_profile: CLuster pool compute profile. Required.
        :paramtype compute_profile:
         ~azure.mgmt.hdinsightcontainers.models.ClusterPoolResourcePropertiesComputeProfile
        :keyword network_profile: Cluster pool network profile.
        :paramtype network_profile:
         ~azure.mgmt.hdinsightcontainers.models.ClusterPoolResourcePropertiesNetworkProfile
        :keyword log_analytics_profile: Cluster pool log analytics profile to enable OMS agent for AKS
         cluster.
        :paramtype log_analytics_profile:
         ~azure.mgmt.hdinsightcontainers.models.ClusterPoolResourcePropertiesLogAnalyticsProfile
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_id = None
        self.managed_resource_group_name = managed_resource_group_name
        self.aks_managed_resource_group_name = None
        self.cluster_pool_profile = cluster_pool_profile
        self.compute_profile = compute_profile
        self.aks_cluster_profile = None
        self.network_profile = network_profile
        self.log_analytics_profile = log_analytics_profile
        self.status = None


class ClusterPoolResourcePropertiesAksClusterProfile(AksClusterProfile):  # pylint: disable=name-too-long
    """Properties of underlying AKS cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aks_cluster_resource_id: ARM Resource ID of the AKS cluster.
    :vartype aks_cluster_resource_id: str
    :ivar aks_cluster_agent_pool_identity_profile: Identity properties of the AKS cluster agentpool
     MSI.
    :vartype aks_cluster_agent_pool_identity_profile:
     ~azure.mgmt.hdinsightcontainers.models.AksClusterProfileAksClusterAgentPoolIdentityProfile
    :ivar aks_version: AKS control plane and default node pool version of this ClusterPool.
    :vartype aks_version: str
    """


class ClusterPoolResourcePropertiesClusterPoolProfile(ClusterPoolProfile):  # pylint: disable=name-too-long
    """CLuster pool profile.

    All required parameters must be populated in order to send to server.

    :ivar cluster_pool_version: Cluster pool version is a 2-part version. Required.
    :vartype cluster_pool_version: str
    :ivar public_ip_tag: Gets or sets the IP tag for the public IPs created along with the
     HDInsightOnAks ClusterPools and Clusters.
    :vartype public_ip_tag: ~azure.mgmt.hdinsightcontainers.models.IpTag
    """


class ClusterPoolResourcePropertiesComputeProfile(ClusterPoolComputeProfile):  # pylint: disable=name-too-long
    """CLuster pool compute profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar vm_size: The virtual machine SKU. Required.
    :vartype vm_size: str
    :ivar count: The number of virtual machines.
    :vartype count: int
    :ivar availability_zones: The list of Availability zones to use for AKS VMSS nodes.
    :vartype availability_zones: list[str]
    """


class ClusterPoolResourcePropertiesLogAnalyticsProfile(ClusterPoolLogAnalyticsProfile):  # pylint: disable=name-too-long
    """Cluster pool log analytics profile to enable OMS agent for AKS cluster.

    All required parameters must be populated in order to send to server.

    :ivar enabled: True if log analytics is enabled for cluster pool, otherwise false. Required.
    :vartype enabled: bool
    :ivar workspace_id: Log analytics workspace to associate with the OMS agent.
    :vartype workspace_id: str
    """


class ClusterPoolResourcePropertiesNetworkProfile(ClusterPoolNetworkProfile):  # pylint: disable=name-too-long
    """Cluster pool network profile.

    All required parameters must be populated in order to send to server.

    :ivar subnet_id: Cluster pool subnet resource id. Required.
    :vartype subnet_id: str
    :ivar outbound_type: This can only be set at cluster pool creation time and cannot be changed
     later. Known values are: "loadBalancer" and "userDefinedRouting".
    :vartype outbound_type: str or ~azure.mgmt.hdinsightcontainers.models.OutboundType
    :ivar enable_private_api_server: ClusterPool is based on AKS cluster. AKS cluster exposes the
     API server to public internet by default. If you set this property to true, a private AKS
     cluster will be created, and it will use private apiserver, which is not exposed to public
     internet.
    :vartype enable_private_api_server: bool
    :ivar api_server_authorized_ip_ranges: IP ranges are specified in CIDR format, e.g.
     137.117.106.88/29. This feature is not compatible with private AKS clusters. So you cannot set
     enablePrivateApiServer to true and apiServerAuthorizedIpRanges at the same time. Currently,
     this property is not supported and please don't use it.
    :vartype api_server_authorized_ip_ranges: list[str]
    """


class ClusterPoolUpgrade(_serialization.Model):
    """Cluster Pool Upgrade.

    All required parameters must be populated in order to send to server.

    :ivar properties: Properties of upgrading cluster pool. Required.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "ClusterPoolUpgradeProperties"},
    }

    def __init__(self, *, properties: "_models.ClusterPoolUpgradeProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of upgrading cluster pool. Required.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterPoolUpgradeHistory(ProxyResource):
    """Cluster pool upgrade history.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar properties: Properties of cluster pool upgrade history. Required.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistoryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ClusterPoolUpgradeHistoryProperties"},
    }

    def __init__(self, *, properties: "_models.ClusterPoolUpgradeHistoryProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of cluster pool upgrade history. Required.
        :paramtype properties:
         ~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistoryProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterPoolUpgradeHistoryListResult(_serialization.Model):
    """Represents a list of cluster pool upgrade history.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of cluster pool upgrade history. Required.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistory]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterPoolUpgradeHistory]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ClusterPoolUpgradeHistory"], **kwargs: Any) -> None:
        """
        :keyword value: The list of cluster pool upgrade history. Required.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterPoolUpgradeHistory]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClusterPoolVersion(ProxyResource):
    """Available cluster pool version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar properties: Cluster pool version properties.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterPoolVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ClusterPoolVersionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ClusterPoolVersionProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Cluster pool version properties.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterPoolVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterPoolVersionProperties(_serialization.Model):
    """Cluster pool version properties.

    :ivar cluster_pool_version: Cluster pool version is a 2-part version.
    :vartype cluster_pool_version: str
    :ivar aks_version: AKS version.
    :vartype aks_version: str
    :ivar is_preview: Indicate if this version is in preview or not.
    :vartype is_preview: bool
    """

    _validation = {
        "cluster_pool_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
    }

    _attribute_map = {
        "cluster_pool_version": {"key": "clusterPoolVersion", "type": "str"},
        "aks_version": {"key": "aksVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(
        self,
        *,
        cluster_pool_version: Optional[str] = None,
        aks_version: Optional[str] = None,
        is_preview: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword cluster_pool_version: Cluster pool version is a 2-part version.
        :paramtype cluster_pool_version: str
        :keyword aks_version: AKS version.
        :paramtype aks_version: str
        :keyword is_preview: Indicate if this version is in preview or not.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.cluster_pool_version = cluster_pool_version
        self.aks_version = aks_version
        self.is_preview = is_preview


class ClusterPoolVersionsListResult(_serialization.Model):
    """Represents a list of cluster pool versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of cluster pool versions.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterPoolVersion]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterPoolVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ClusterPoolVersion"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of cluster pool versions.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterPoolVersion]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClusterProfile(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Cluster profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar cluster_version: Version with 3/4 part. Required.
    :vartype cluster_version: str
    :ivar oss_version: Version with three part. Required.
    :vartype oss_version: str
    :ivar components: Component list of this cluster type and version.
    :vartype components: list[~azure.mgmt.hdinsightcontainers.models.ClusterComponentsItem]
    :ivar identity_profile: This is deprecated. Please use managed identity profile instead.
    :vartype identity_profile: ~azure.mgmt.hdinsightcontainers.models.IdentityProfile
    :ivar managed_identity_profile: This property is required by Trino, Spark and Flink cluster but
     is optional for Kafka cluster.
    :vartype managed_identity_profile:
     ~azure.mgmt.hdinsightcontainers.models.ManagedIdentityProfile
    :ivar authorization_profile: Authorization profile with details of AAD user Ids and group Ids
     authorized for data plane access. Required.
    :vartype authorization_profile: ~azure.mgmt.hdinsightcontainers.models.AuthorizationProfile
    :ivar secrets_profile: The cluster secret profile.
    :vartype secrets_profile: ~azure.mgmt.hdinsightcontainers.models.SecretsProfile
    :ivar service_configs_profiles: The service configs profiles.
    :vartype service_configs_profiles:
     list[~azure.mgmt.hdinsightcontainers.models.ClusterServiceConfigsProfile]
    :ivar connectivity_profile: Cluster connectivity profile.
    :vartype connectivity_profile: ~azure.mgmt.hdinsightcontainers.models.ConnectivityProfile
    :ivar cluster_access_profile: Cluster access profile.
    :vartype cluster_access_profile: ~azure.mgmt.hdinsightcontainers.models.ClusterAccessProfile
    :ivar log_analytics_profile: Cluster log analytics profile to enable or disable OMS agent for
     cluster.
    :vartype log_analytics_profile:
     ~azure.mgmt.hdinsightcontainers.models.ClusterLogAnalyticsProfile
    :ivar prometheus_profile: Cluster Prometheus profile.
    :vartype prometheus_profile: ~azure.mgmt.hdinsightcontainers.models.ClusterPrometheusProfile
    :ivar ssh_profile: Ssh profile for the cluster.
    :vartype ssh_profile: ~azure.mgmt.hdinsightcontainers.models.SshProfile
    :ivar autoscale_profile: This is the Autoscale profile for the cluster. This will allow
     customer to create cluster enabled with Autoscale.
    :vartype autoscale_profile: ~azure.mgmt.hdinsightcontainers.models.AutoscaleProfile
    :ivar ranger_plugin_profile: Cluster Ranger plugin profile.
    :vartype ranger_plugin_profile:
     ~azure.mgmt.hdinsightcontainers.models.ClusterRangerPluginProfile
    :ivar kafka_profile: The Kafka cluster profile.
    :vartype kafka_profile: ~azure.mgmt.hdinsightcontainers.models.KafkaProfile
    :ivar trino_profile: Trino Cluster profile.
    :vartype trino_profile: ~azure.mgmt.hdinsightcontainers.models.TrinoProfile
    :ivar llap_profile: LLAP cluster profile.
    :vartype llap_profile: dict[str, any]
    :ivar flink_profile: The Flink cluster profile.
    :vartype flink_profile: ~azure.mgmt.hdinsightcontainers.models.FlinkProfile
    :ivar spark_profile: The spark cluster profile.
    :vartype spark_profile: ~azure.mgmt.hdinsightcontainers.models.SparkProfile
    :ivar ranger_profile: The ranger cluster profile.
    :vartype ranger_profile: ~azure.mgmt.hdinsightcontainers.models.RangerProfile
    :ivar stub_profile: Stub cluster profile.
    :vartype stub_profile: dict[str, any]
    :ivar script_action_profiles: The script action profile list.
    :vartype script_action_profiles:
     list[~azure.mgmt.hdinsightcontainers.models.ScriptActionProfile]
    """

    _validation = {
        "cluster_version": {
            "required": True,
            "pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})(?:\.(0|[1-9][0-9]{0,18}))?$",
        },
        "oss_version": {
            "required": True,
            "pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$",
        },
        "components": {"readonly": True},
        "authorization_profile": {"required": True},
        "connectivity_profile": {"readonly": True},
    }

    _attribute_map = {
        "cluster_version": {"key": "clusterVersion", "type": "str"},
        "oss_version": {"key": "ossVersion", "type": "str"},
        "components": {"key": "components", "type": "[ClusterComponentsItem]"},
        "identity_profile": {"key": "identityProfile", "type": "IdentityProfile"},
        "managed_identity_profile": {"key": "managedIdentityProfile", "type": "ManagedIdentityProfile"},
        "authorization_profile": {"key": "authorizationProfile", "type": "AuthorizationProfile"},
        "secrets_profile": {"key": "secretsProfile", "type": "SecretsProfile"},
        "service_configs_profiles": {"key": "serviceConfigsProfiles", "type": "[ClusterServiceConfigsProfile]"},
        "connectivity_profile": {"key": "connectivityProfile", "type": "ConnectivityProfile"},
        "cluster_access_profile": {"key": "clusterAccessProfile", "type": "ClusterAccessProfile"},
        "log_analytics_profile": {"key": "logAnalyticsProfile", "type": "ClusterLogAnalyticsProfile"},
        "prometheus_profile": {"key": "prometheusProfile", "type": "ClusterPrometheusProfile"},
        "ssh_profile": {"key": "sshProfile", "type": "SshProfile"},
        "autoscale_profile": {"key": "autoscaleProfile", "type": "AutoscaleProfile"},
        "ranger_plugin_profile": {"key": "rangerPluginProfile", "type": "ClusterRangerPluginProfile"},
        "kafka_profile": {"key": "kafkaProfile", "type": "KafkaProfile"},
        "trino_profile": {"key": "trinoProfile", "type": "TrinoProfile"},
        "llap_profile": {"key": "llapProfile", "type": "{object}"},
        "flink_profile": {"key": "flinkProfile", "type": "FlinkProfile"},
        "spark_profile": {"key": "sparkProfile", "type": "SparkProfile"},
        "ranger_profile": {"key": "rangerProfile", "type": "RangerProfile"},
        "stub_profile": {"key": "stubProfile", "type": "{object}"},
        "script_action_profiles": {"key": "scriptActionProfiles", "type": "[ScriptActionProfile]"},
    }

    def __init__(
        self,
        *,
        cluster_version: str,
        oss_version: str,
        authorization_profile: "_models.AuthorizationProfile",
        identity_profile: Optional["_models.IdentityProfile"] = None,
        managed_identity_profile: Optional["_models.ManagedIdentityProfile"] = None,
        secrets_profile: Optional["_models.SecretsProfile"] = None,
        service_configs_profiles: Optional[List["_models.ClusterServiceConfigsProfile"]] = None,
        cluster_access_profile: Optional["_models.ClusterAccessProfile"] = None,
        log_analytics_profile: Optional["_models.ClusterLogAnalyticsProfile"] = None,
        prometheus_profile: Optional["_models.ClusterPrometheusProfile"] = None,
        ssh_profile: Optional["_models.SshProfile"] = None,
        autoscale_profile: Optional["_models.AutoscaleProfile"] = None,
        ranger_plugin_profile: Optional["_models.ClusterRangerPluginProfile"] = None,
        kafka_profile: Optional["_models.KafkaProfile"] = None,
        trino_profile: Optional["_models.TrinoProfile"] = None,
        llap_profile: Optional[Dict[str, Any]] = None,
        flink_profile: Optional["_models.FlinkProfile"] = None,
        spark_profile: Optional["_models.SparkProfile"] = None,
        ranger_profile: Optional["_models.RangerProfile"] = None,
        stub_profile: Optional[Dict[str, Any]] = None,
        script_action_profiles: Optional[List["_models.ScriptActionProfile"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cluster_version: Version with 3/4 part. Required.
        :paramtype cluster_version: str
        :keyword oss_version: Version with three part. Required.
        :paramtype oss_version: str
        :keyword identity_profile: This is deprecated. Please use managed identity profile instead.
        :paramtype identity_profile: ~azure.mgmt.hdinsightcontainers.models.IdentityProfile
        :keyword managed_identity_profile: This property is required by Trino, Spark and Flink cluster
         but is optional for Kafka cluster.
        :paramtype managed_identity_profile:
         ~azure.mgmt.hdinsightcontainers.models.ManagedIdentityProfile
        :keyword authorization_profile: Authorization profile with details of AAD user Ids and group
         Ids authorized for data plane access. Required.
        :paramtype authorization_profile: ~azure.mgmt.hdinsightcontainers.models.AuthorizationProfile
        :keyword secrets_profile: The cluster secret profile.
        :paramtype secrets_profile: ~azure.mgmt.hdinsightcontainers.models.SecretsProfile
        :keyword service_configs_profiles: The service configs profiles.
        :paramtype service_configs_profiles:
         list[~azure.mgmt.hdinsightcontainers.models.ClusterServiceConfigsProfile]
        :keyword cluster_access_profile: Cluster access profile.
        :paramtype cluster_access_profile: ~azure.mgmt.hdinsightcontainers.models.ClusterAccessProfile
        :keyword log_analytics_profile: Cluster log analytics profile to enable or disable OMS agent
         for cluster.
        :paramtype log_analytics_profile:
         ~azure.mgmt.hdinsightcontainers.models.ClusterLogAnalyticsProfile
        :keyword prometheus_profile: Cluster Prometheus profile.
        :paramtype prometheus_profile: ~azure.mgmt.hdinsightcontainers.models.ClusterPrometheusProfile
        :keyword ssh_profile: Ssh profile for the cluster.
        :paramtype ssh_profile: ~azure.mgmt.hdinsightcontainers.models.SshProfile
        :keyword autoscale_profile: This is the Autoscale profile for the cluster. This will allow
         customer to create cluster enabled with Autoscale.
        :paramtype autoscale_profile: ~azure.mgmt.hdinsightcontainers.models.AutoscaleProfile
        :keyword ranger_plugin_profile: Cluster Ranger plugin profile.
        :paramtype ranger_plugin_profile:
         ~azure.mgmt.hdinsightcontainers.models.ClusterRangerPluginProfile
        :keyword kafka_profile: The Kafka cluster profile.
        :paramtype kafka_profile: ~azure.mgmt.hdinsightcontainers.models.KafkaProfile
        :keyword trino_profile: Trino Cluster profile.
        :paramtype trino_profile: ~azure.mgmt.hdinsightcontainers.models.TrinoProfile
        :keyword llap_profile: LLAP cluster profile.
        :paramtype llap_profile: dict[str, any]
        :keyword flink_profile: The Flink cluster profile.
        :paramtype flink_profile: ~azure.mgmt.hdinsightcontainers.models.FlinkProfile
        :keyword spark_profile: The spark cluster profile.
        :paramtype spark_profile: ~azure.mgmt.hdinsightcontainers.models.SparkProfile
        :keyword ranger_profile: The ranger cluster profile.
        :paramtype ranger_profile: ~azure.mgmt.hdinsightcontainers.models.RangerProfile
        :keyword stub_profile: Stub cluster profile.
        :paramtype stub_profile: dict[str, any]
        :keyword script_action_profiles: The script action profile list.
        :paramtype script_action_profiles:
         list[~azure.mgmt.hdinsightcontainers.models.ScriptActionProfile]
        """
        super().__init__(**kwargs)
        self.cluster_version = cluster_version
        self.oss_version = oss_version
        self.components = None
        self.identity_profile = identity_profile
        self.managed_identity_profile = managed_identity_profile
        self.authorization_profile = authorization_profile
        self.secrets_profile = secrets_profile
        self.service_configs_profiles = service_configs_profiles
        self.connectivity_profile = None
        self.cluster_access_profile = cluster_access_profile
        self.log_analytics_profile = log_analytics_profile
        self.prometheus_profile = prometheus_profile
        self.ssh_profile = ssh_profile
        self.autoscale_profile = autoscale_profile
        self.ranger_plugin_profile = ranger_plugin_profile
        self.kafka_profile = kafka_profile
        self.trino_profile = trino_profile
        self.llap_profile = llap_profile
        self.flink_profile = flink_profile
        self.spark_profile = spark_profile
        self.ranger_profile = ranger_profile
        self.stub_profile = stub_profile
        self.script_action_profiles = script_action_profiles


class ClusterPrometheusProfile(_serialization.Model):
    """Cluster Prometheus profile.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Enable Prometheus for cluster or not. Required.
    :vartype enabled: bool
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: bool = False, **kwargs: Any) -> None:
        """
        :keyword enabled: Enable Prometheus for cluster or not. Required.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ClusterRangerPluginProfile(_serialization.Model):
    """Cluster Ranger plugin profile.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Enable Ranger for cluster or not. Required.
    :vartype enabled: bool
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: bool = False, **kwargs: Any) -> None:
        """
        :keyword enabled: Enable Ranger for cluster or not. Required.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ClusterResizeData(TrackedResource):
    """The parameters for resizing a cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Sets the properties. Define cluster resize specific properties.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterResizeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ClusterResizeProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ClusterResizeProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Sets the properties. Define cluster resize specific properties.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterResizeProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class ClusterResizeProperties(_serialization.Model):
    """The properties for resizing a cluster.

    All required parameters must be populated in order to send to server.

    :ivar target_worker_node_count: Target node count of worker node. Required.
    :vartype target_worker_node_count: int
    """

    _validation = {
        "target_worker_node_count": {"required": True},
    }

    _attribute_map = {
        "target_worker_node_count": {"key": "targetWorkerNodeCount", "type": "int"},
    }

    def __init__(self, *, target_worker_node_count: int, **kwargs: Any) -> None:
        """
        :keyword target_worker_node_count: Target node count of worker node. Required.
        :paramtype target_worker_node_count: int
        """
        super().__init__(**kwargs)
        self.target_worker_node_count = target_worker_node_count


class ClusterResourceProperties(_serialization.Model):
    """Cluster resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Succeeded", "Canceled", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.hdinsightcontainers.models.ProvisioningStatus
    :ivar cluster_type: The type of cluster. Required.
    :vartype cluster_type: str
    :ivar deployment_id: A unique id generated by the RP to identify the resource.
    :vartype deployment_id: str
    :ivar compute_profile: The compute profile. Required.
    :vartype compute_profile: ~azure.mgmt.hdinsightcontainers.models.ComputeProfile
    :ivar cluster_profile: Cluster profile. Required.
    :vartype cluster_profile: ~azure.mgmt.hdinsightcontainers.models.ClusterProfile
    :ivar status: Business status of the resource.
    :vartype status: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "cluster_type": {"required": True, "pattern": r"^[a-zA-Z][a-zA-Z0-9]{0,31}$"},
        "deployment_id": {"readonly": True},
        "compute_profile": {"required": True},
        "cluster_profile": {"required": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "cluster_type": {"key": "clusterType", "type": "str"},
        "deployment_id": {"key": "deploymentId", "type": "str"},
        "compute_profile": {"key": "computeProfile", "type": "ComputeProfile"},
        "cluster_profile": {"key": "clusterProfile", "type": "ClusterProfile"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        cluster_type: str,
        compute_profile: "_models.ComputeProfile",
        cluster_profile: "_models.ClusterProfile",
        **kwargs: Any
    ) -> None:
        """
        :keyword cluster_type: The type of cluster. Required.
        :paramtype cluster_type: str
        :keyword compute_profile: The compute profile. Required.
        :paramtype compute_profile: ~azure.mgmt.hdinsightcontainers.models.ComputeProfile
        :keyword cluster_profile: Cluster profile. Required.
        :paramtype cluster_profile: ~azure.mgmt.hdinsightcontainers.models.ClusterProfile
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.cluster_type = cluster_type
        self.deployment_id = None
        self.compute_profile = compute_profile
        self.cluster_profile = cluster_profile
        self.status = None


class ClusterServiceConfig(_serialization.Model):
    """Cluster configs per component.

    All required parameters must be populated in order to send to server.

    :ivar component: Name of the component the config files should apply to. Required.
    :vartype component: str
    :ivar files: List of Config Files. Required.
    :vartype files: list[~azure.mgmt.hdinsightcontainers.models.ClusterConfigFile]
    """

    _validation = {
        "component": {"required": True},
        "files": {"required": True},
    }

    _attribute_map = {
        "component": {"key": "component", "type": "str"},
        "files": {"key": "files", "type": "[ClusterConfigFile]"},
    }

    def __init__(self, *, component: str, files: List["_models.ClusterConfigFile"], **kwargs: Any) -> None:
        """
        :keyword component: Name of the component the config files should apply to. Required.
        :paramtype component: str
        :keyword files: List of Config Files. Required.
        :paramtype files: list[~azure.mgmt.hdinsightcontainers.models.ClusterConfigFile]
        """
        super().__init__(**kwargs)
        self.component = component
        self.files = files


class ClusterServiceConfigsProfile(_serialization.Model):
    """Cluster service configs.

    All required parameters must be populated in order to send to server.

    :ivar service_name: Name of the service the configurations should apply to. Required.
    :vartype service_name: str
    :ivar configs: List of service configs. Required.
    :vartype configs: list[~azure.mgmt.hdinsightcontainers.models.ClusterServiceConfig]
    """

    _validation = {
        "service_name": {"required": True},
        "configs": {"required": True},
    }

    _attribute_map = {
        "service_name": {"key": "serviceName", "type": "str"},
        "configs": {"key": "configs", "type": "[ClusterServiceConfig]"},
    }

    def __init__(self, *, service_name: str, configs: List["_models.ClusterServiceConfig"], **kwargs: Any) -> None:
        """
        :keyword service_name: Name of the service the configurations should apply to. Required.
        :paramtype service_name: str
        :keyword configs: List of service configs. Required.
        :paramtype configs: list[~azure.mgmt.hdinsightcontainers.models.ClusterServiceConfig]
        """
        super().__init__(**kwargs)
        self.service_name = service_name
        self.configs = configs


class ClusterUpgrade(_serialization.Model):
    """Cluster Upgrade.

    All required parameters must be populated in order to send to server.

    :ivar properties: Properties of upgrading cluster. Required.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "ClusterUpgradeProperties"},
    }

    def __init__(self, *, properties: "_models.ClusterUpgradeProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of upgrading cluster. Required.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterUpgradeHistory(ProxyResource):
    """Cluster upgrade history.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar properties: Properties of cluster upgrade history. Required.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ClusterUpgradeHistoryProperties"},
    }

    def __init__(self, *, properties: "_models.ClusterUpgradeHistoryProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties of cluster upgrade history. Required.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistoryProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterUpgradeHistoryListResult(_serialization.Model):
    """Represents a list of cluster upgrade history.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of cluster upgrade history. Required.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistory]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterUpgradeHistory]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ClusterUpgradeHistory"], **kwargs: Any) -> None:
        """
        :keyword value: The list of cluster upgrade history. Required.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeHistory]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ClusterUpgradeRollback(_serialization.Model):
    """Cluster Upgrade.

    All required parameters must be populated in order to send to server.

    :ivar properties: Properties for manual rollback of cluster's upgrade. Required.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeRollbackProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "ClusterUpgradeRollbackProperties"},
    }

    def __init__(self, *, properties: "_models.ClusterUpgradeRollbackProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Properties for manual rollback of cluster's upgrade. Required.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterUpgradeRollbackProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterUpgradeRollbackProperties(_serialization.Model):
    """Properties for manual rollback of cluster's upgrade.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_history: A specific upgrade history to rollback. Required.
    :vartype upgrade_history: str
    """

    _validation = {
        "upgrade_history": {"required": True},
    }

    _attribute_map = {
        "upgrade_history": {"key": "upgradeHistory", "type": "str"},
    }

    def __init__(self, *, upgrade_history: str, **kwargs: Any) -> None:
        """
        :keyword upgrade_history: A specific upgrade history to rollback. Required.
        :paramtype upgrade_history: str
        """
        super().__init__(**kwargs)
        self.upgrade_history = upgrade_history


class ClusterVersion(ProxyResource):
    """Available cluster version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hdinsightcontainers.models.SystemData
    :ivar properties: Cluster version properties.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterVersionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ClusterVersionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ClusterVersionProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Cluster version properties.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ClusterVersionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ClusterVersionProperties(_serialization.Model):
    """Cluster version properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cluster_type: The type of cluster.
    :vartype cluster_type: str
    :ivar cluster_version: Version with three part.
    :vartype cluster_version: str
    :ivar oss_version: Version with three part.
    :vartype oss_version: str
    :ivar cluster_pool_version: The two part cluster pool version. If the cluster version is before
     cluster pool version on-board, the return value will be empty string.
    :vartype cluster_pool_version: str
    :ivar is_preview: Indicate if this version is in preview or not.
    :vartype is_preview: bool
    :ivar components: Component list of this cluster type and version.
    :vartype components: list[~azure.mgmt.hdinsightcontainers.models.ClusterComponentsItem]
    """

    _validation = {
        "cluster_type": {"pattern": r"^[a-zA-Z][a-zA-Z0-9]{0,31}$"},
        "cluster_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "oss_version": {"pattern": r"^(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})\.(0|[1-9][0-9]{0,18})$"},
        "components": {"readonly": True},
    }

    _attribute_map = {
        "cluster_type": {"key": "clusterType", "type": "str"},
        "cluster_version": {"key": "clusterVersion", "type": "str"},
        "oss_version": {"key": "ossVersion", "type": "str"},
        "cluster_pool_version": {"key": "clusterPoolVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
        "components": {"key": "components", "type": "[ClusterComponentsItem]"},
    }

    def __init__(
        self,
        *,
        cluster_type: Optional[str] = None,
        cluster_version: Optional[str] = None,
        oss_version: Optional[str] = None,
        cluster_pool_version: Optional[str] = None,
        is_preview: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword cluster_type: The type of cluster.
        :paramtype cluster_type: str
        :keyword cluster_version: Version with three part.
        :paramtype cluster_version: str
        :keyword oss_version: Version with three part.
        :paramtype oss_version: str
        :keyword cluster_pool_version: The two part cluster pool version. If the cluster version is
         before cluster pool version on-board, the return value will be empty string.
        :paramtype cluster_pool_version: str
        :keyword is_preview: Indicate if this version is in preview or not.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.cluster_type = cluster_type
        self.cluster_version = cluster_version
        self.oss_version = oss_version
        self.cluster_pool_version = cluster_pool_version
        self.is_preview = is_preview
        self.components = None


class ClusterVersionsListResult(_serialization.Model):
    """Represents a list of cluster versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of cluster versions.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterVersion]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ClusterVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ClusterVersion"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of cluster versions.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.ClusterVersion]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ComparisonRule(_serialization.Model):
    """The comparison rule.

    All required parameters must be populated in order to send to server.

    :ivar operator: The comparison operator. Required. Known values are: "greaterThan",
     "greaterThanOrEqual", "lessThan", and "lessThanOrEqual".
    :vartype operator: str or ~azure.mgmt.hdinsightcontainers.models.ComparisonOperator
    :ivar threshold: Threshold setting. Required.
    :vartype threshold: float
    """

    _validation = {
        "operator": {"required": True},
        "threshold": {"required": True},
    }

    _attribute_map = {
        "operator": {"key": "operator", "type": "str"},
        "threshold": {"key": "threshold", "type": "float"},
    }

    def __init__(self, *, operator: Union[str, "_models.ComparisonOperator"], threshold: float, **kwargs: Any) -> None:
        """
        :keyword operator: The comparison operator. Required. Known values are: "greaterThan",
         "greaterThanOrEqual", "lessThan", and "lessThanOrEqual".
        :paramtype operator: str or ~azure.mgmt.hdinsightcontainers.models.ComparisonOperator
        :keyword threshold: Threshold setting. Required.
        :paramtype threshold: float
        """
        super().__init__(**kwargs)
        self.operator = operator
        self.threshold = threshold


class ComputeProfile(_serialization.Model):
    """The compute profile.

    All required parameters must be populated in order to send to server.

    :ivar nodes: The nodes definitions. Required.
    :vartype nodes: list[~azure.mgmt.hdinsightcontainers.models.NodeProfile]
    :ivar availability_zones: The list of Availability zones to use for AKS VMSS nodes.
    :vartype availability_zones: list[str]
    """

    _validation = {
        "nodes": {"required": True},
    }

    _attribute_map = {
        "nodes": {"key": "nodes", "type": "[NodeProfile]"},
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
    }

    def __init__(
        self, *, nodes: List["_models.NodeProfile"], availability_zones: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword nodes: The nodes definitions. Required.
        :paramtype nodes: list[~azure.mgmt.hdinsightcontainers.models.NodeProfile]
        :keyword availability_zones: The list of Availability zones to use for AKS VMSS nodes.
        :paramtype availability_zones: list[str]
        """
        super().__init__(**kwargs)
        self.nodes = nodes
        self.availability_zones = availability_zones


class ComputeResourceDefinition(_serialization.Model):
    """The cpu and memory requirement definition.

    All required parameters must be populated in order to send to server.

    :ivar cpu: The required CPU. Required.
    :vartype cpu: float
    :ivar memory: The required memory in MB, Container memory will be 110 percentile. Required.
    :vartype memory: int
    """

    _validation = {
        "cpu": {"required": True},
        "memory": {"required": True},
    }

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "float"},
        "memory": {"key": "memory", "type": "int"},
    }

    def __init__(self, *, cpu: float, memory: int, **kwargs: Any) -> None:
        """
        :keyword cpu: The required CPU. Required.
        :paramtype cpu: float
        :keyword memory: The required memory in MB, Container memory will be 110 percentile. Required.
        :paramtype memory: int
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.memory = memory


class ConnectivityProfile(_serialization.Model):
    """Cluster connectivity profile.

    All required parameters must be populated in order to send to server.

    :ivar web: Web connectivity endpoint details. Required.
    :vartype web: ~azure.mgmt.hdinsightcontainers.models.ConnectivityProfileWeb
    :ivar ssh: List of SSH connectivity endpoints.
    :vartype ssh: list[~azure.mgmt.hdinsightcontainers.models.SshConnectivityEndpoint]
    """

    _validation = {
        "web": {"required": True},
    }

    _attribute_map = {
        "web": {"key": "web", "type": "ConnectivityProfileWeb"},
        "ssh": {"key": "ssh", "type": "[SshConnectivityEndpoint]"},
    }

    def __init__(
        self,
        *,
        web: "_models.ConnectivityProfileWeb",
        ssh: Optional[List["_models.SshConnectivityEndpoint"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword web: Web connectivity endpoint details. Required.
        :paramtype web: ~azure.mgmt.hdinsightcontainers.models.ConnectivityProfileWeb
        :keyword ssh: List of SSH connectivity endpoints.
        :paramtype ssh: list[~azure.mgmt.hdinsightcontainers.models.SshConnectivityEndpoint]
        """
        super().__init__(**kwargs)
        self.web = web
        self.ssh = ssh


class WebConnectivityEndpoint(_serialization.Model):
    """Web connectivity endpoint details.

    All required parameters must be populated in order to send to server.

    :ivar fqdn: Web connectivity endpoint. Required.
    :vartype fqdn: str
    :ivar private_fqdn: Private web connectivity endpoint. This property will only be returned when
     enableInternalIngress is true.
    :vartype private_fqdn: str
    """

    _validation = {
        "fqdn": {"required": True},
    }

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
        "private_fqdn": {"key": "privateFqdn", "type": "str"},
    }

    def __init__(self, *, fqdn: str, private_fqdn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword fqdn: Web connectivity endpoint. Required.
        :paramtype fqdn: str
        :keyword private_fqdn: Private web connectivity endpoint. This property will only be returned
         when enableInternalIngress is true.
        :paramtype private_fqdn: str
        """
        super().__init__(**kwargs)
        self.fqdn = fqdn
        self.private_fqdn = private_fqdn


class ConnectivityProfileWeb(WebConnectivityEndpoint):
    """Web connectivity endpoint details.

    All required parameters must be populated in order to send to server.

    :ivar fqdn: Web connectivity endpoint. Required.
    :vartype fqdn: str
    :ivar private_fqdn: Private web connectivity endpoint. This property will only be returned when
     enableInternalIngress is true.
    :vartype private_fqdn: str
    """


class DiskStorageProfile(_serialization.Model):
    """Kafka disk storage profile.

    All required parameters must be populated in order to send to server.

    :ivar data_disk_size: Managed Disk size in GB. The maximum supported disk size for Standard and
     Premium HDD/SSD is 32TB, except for Premium SSD v2, which supports up to 64TB. Required.
    :vartype data_disk_size: int
    :ivar data_disk_type: Managed Disk Type. Required. Known values are: "Standard_HDD_LRS",
     "Standard_SSD_LRS", "Standard_SSD_ZRS", "Premium_SSD_LRS", "Premium_SSD_ZRS", and
     "Premium_SSD_v2_LRS".
    :vartype data_disk_type: str or ~azure.mgmt.hdinsightcontainers.models.DataDiskType
    """

    _validation = {
        "data_disk_size": {"required": True},
        "data_disk_type": {"required": True},
    }

    _attribute_map = {
        "data_disk_size": {"key": "dataDiskSize", "type": "int"},
        "data_disk_type": {"key": "dataDiskType", "type": "str"},
    }

    def __init__(
        self, *, data_disk_size: int, data_disk_type: Union[str, "_models.DataDiskType"], **kwargs: Any
    ) -> None:
        """
        :keyword data_disk_size: Managed Disk size in GB. The maximum supported disk size for Standard
         and Premium HDD/SSD is 32TB, except for Premium SSD v2, which supports up to 64TB. Required.
        :paramtype data_disk_size: int
        :keyword data_disk_type: Managed Disk Type. Required. Known values are: "Standard_HDD_LRS",
         "Standard_SSD_LRS", "Standard_SSD_ZRS", "Premium_SSD_LRS", "Premium_SSD_ZRS", and
         "Premium_SSD_v2_LRS".
        :paramtype data_disk_type: str or ~azure.mgmt.hdinsightcontainers.models.DataDiskType
        """
        super().__init__(**kwargs)
        self.data_disk_size = data_disk_size
        self.data_disk_type = data_disk_type


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.hdinsightcontainers.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.hdinsightcontainers.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.hdinsightcontainers.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.hdinsightcontainers.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class FlinkCatalogOptions(_serialization.Model):
    """Flink cluster catalog options.

    :ivar hive: Hive Catalog Option for Flink cluster.
    :vartype hive: ~azure.mgmt.hdinsightcontainers.models.FlinkHiveCatalogOption
    """

    _attribute_map = {
        "hive": {"key": "hive", "type": "FlinkHiveCatalogOption"},
    }

    def __init__(self, *, hive: Optional["_models.FlinkHiveCatalogOption"] = None, **kwargs: Any) -> None:
        """
        :keyword hive: Hive Catalog Option for Flink cluster.
        :paramtype hive: ~azure.mgmt.hdinsightcontainers.models.FlinkHiveCatalogOption
        """
        super().__init__(**kwargs)
        self.hive = hive


class FlinkHiveCatalogOption(_serialization.Model):
    """Hive Catalog Option for Flink cluster.

    All required parameters must be populated in order to send to server.

    :ivar metastore_db_connection_authentication_mode: The authentication mode to connect to your
     Hive metastore database. More details:
     https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization.  # pylint: disable=line-too-long
     Known values are: "SqlAuth" and "IdentityAuth".
    :vartype metastore_db_connection_authentication_mode: str or
     ~azure.mgmt.hdinsightcontainers.models.MetastoreDbConnectionAuthenticationMode
    :ivar metastore_db_connection_password_secret: Secret reference name from
     secretsProfile.secrets containing password for database connection.
    :vartype metastore_db_connection_password_secret: str
    :ivar metastore_db_connection_url: Connection string for hive metastore database. Required.
    :vartype metastore_db_connection_url: str
    :ivar metastore_db_connection_user_name: User name for database connection.
    :vartype metastore_db_connection_user_name: str
    """

    _validation = {
        "metastore_db_connection_url": {"required": True},
    }

    _attribute_map = {
        "metastore_db_connection_authentication_mode": {
            "key": "metastoreDbConnectionAuthenticationMode",
            "type": "str",
        },
        "metastore_db_connection_password_secret": {"key": "metastoreDbConnectionPasswordSecret", "type": "str"},
        "metastore_db_connection_url": {"key": "metastoreDbConnectionURL", "type": "str"},
        "metastore_db_connection_user_name": {"key": "metastoreDbConnectionUserName", "type": "str"},
    }

    def __init__(
        self,
        *,
        metastore_db_connection_url: str,
        metastore_db_connection_authentication_mode: Optional[
            Union[str, "_models.MetastoreDbConnectionAuthenticationMode"]
        ] = None,
        metastore_db_connection_password_secret: Optional[str] = None,
        metastore_db_connection_user_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metastore_db_connection_authentication_mode: The authentication mode to connect to
         your Hive metastore database. More details:
         https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization.  # pylint: disable=line-too-long
         Known values are: "SqlAuth" and "IdentityAuth".
        :paramtype metastore_db_connection_authentication_mode: str or
         ~azure.mgmt.hdinsightcontainers.models.MetastoreDbConnectionAuthenticationMode
        :keyword metastore_db_connection_password_secret: Secret reference name from
         secretsProfile.secrets containing password for database connection.
        :paramtype metastore_db_connection_password_secret: str
        :keyword metastore_db_connection_url: Connection string for hive metastore database. Required.
        :paramtype metastore_db_connection_url: str
        :keyword metastore_db_connection_user_name: User name for database connection.
        :paramtype metastore_db_connection_user_name: str
        """
        super().__init__(**kwargs)
        self.metastore_db_connection_authentication_mode = metastore_db_connection_authentication_mode
        self.metastore_db_connection_password_secret = metastore_db_connection_password_secret
        self.metastore_db_connection_url = metastore_db_connection_url
        self.metastore_db_connection_user_name = metastore_db_connection_user_name


class FlinkJobProfile(_serialization.Model):
    """Job specifications for flink clusters in application deployment mode. The specification is
    immutable even if job properties are changed by calling the RunJob API, please use the ListJob
    API to get the latest job information.

    All required parameters must be populated in order to send to server.

    :ivar job_jar_directory: A string property that specifies the directory where the job JAR is
     located. Required.
    :vartype job_jar_directory: str
    :ivar jar_name: A string property that represents the name of the job JAR. Required.
    :vartype jar_name: str
    :ivar entry_class: A string property that specifies the entry class for the Flink job. If not
     specified, the entry point is auto-detected from the flink job jar package.
    :vartype entry_class: str
    :ivar args: A string property representing additional JVM arguments for the Flink job. It
     should be space separated value.
    :vartype args: str
    :ivar save_point_name: A string property that represents the name of the savepoint for the
     Flink job.
    :vartype save_point_name: str
    :ivar upgrade_mode: A string property that indicates the upgrade mode to be performed on the
     Flink job. It can have one of the following enum values => STATELESS_UPDATE, UPDATE,
     LAST_STATE_UPDATE. Required. Known values are: "STATELESS_UPDATE", "UPDATE", and
     "LAST_STATE_UPDATE".
    :vartype upgrade_mode: str or ~azure.mgmt.hdinsightcontainers.models.UpgradeMode
    """

    _validation = {
        "job_jar_directory": {"required": True},
        "jar_name": {"required": True},
        "upgrade_mode": {"required": True},
    }

    _attribute_map = {
        "job_jar_directory": {"key": "jobJarDirectory", "type": "str"},
        "jar_name": {"key": "jarName", "type": "str"},
        "entry_class": {"key": "entryClass", "type": "str"},
        "args": {"key": "args", "type": "str"},
        "save_point_name": {"key": "savePointName", "type": "str"},
        "upgrade_mode": {"key": "upgradeMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        job_jar_directory: str,
        jar_name: str,
        upgrade_mode: Union[str, "_models.UpgradeMode"],
        entry_class: Optional[str] = None,
        args: Optional[str] = None,
        save_point_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword job_jar_directory: A string property that specifies the directory where the job JAR is
         located. Required.
        :paramtype job_jar_directory: str
        :keyword jar_name: A string property that represents the name of the job JAR. Required.
        :paramtype jar_name: str
        :keyword entry_class: A string property that specifies the entry class for the Flink job. If
         not specified, the entry point is auto-detected from the flink job jar package.
        :paramtype entry_class: str
        :keyword args: A string property representing additional JVM arguments for the Flink job. It
         should be space separated value.
        :paramtype args: str
        :keyword save_point_name: A string property that represents the name of the savepoint for the
         Flink job.
        :paramtype save_point_name: str
        :keyword upgrade_mode: A string property that indicates the upgrade mode to be performed on the
         Flink job. It can have one of the following enum values => STATELESS_UPDATE, UPDATE,
         LAST_STATE_UPDATE. Required. Known values are: "STATELESS_UPDATE", "UPDATE", and
         "LAST_STATE_UPDATE".
        :paramtype upgrade_mode: str or ~azure.mgmt.hdinsightcontainers.models.UpgradeMode
        """
        super().__init__(**kwargs)
        self.job_jar_directory = job_jar_directory
        self.jar_name = jar_name
        self.entry_class = entry_class
        self.args = args
        self.save_point_name = save_point_name
        self.upgrade_mode = upgrade_mode


class FlinkJobProperties(ClusterJobProperties):  # pylint: disable=too-many-instance-attributes
    """Properties of flink job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar job_type: Type of cluster job. Required. "FlinkJob"
    :vartype job_type: str or ~azure.mgmt.hdinsightcontainers.models.JobType
    :ivar run_id: Run id of job.
    :vartype run_id: str
    :ivar job_name: Name of job.
    :vartype job_name: str
    :ivar job_jar_directory: A string property that specifies the directory where the job JAR is
     located.
    :vartype job_jar_directory: str
    :ivar jar_name: A string property that represents the name of the job JAR.
    :vartype jar_name: str
    :ivar entry_class: A string property that specifies the entry class for the Flink job.
    :vartype entry_class: str
    :ivar args: A string property representing additional JVM arguments for the Flink job. It
     should be space separated value.
    :vartype args: str
    :ivar save_point_name: A string property that represents the name of the savepoint for the
     Flink job.
    :vartype save_point_name: str
    :ivar action: A string property that indicates the action to be performed on the Flink job. It
     can have one of the following enum values => NEW, UPDATE, STATELESS_UPDATE, STOP, START,
     CANCEL, SAVEPOINT, LIST_SAVEPOINT, or DELETE. Known values are: "NEW", "UPDATE",
     "STATELESS_UPDATE", "STOP", "START", "CANCEL", "SAVEPOINT", "LIST_SAVEPOINT", "DELETE",
     "LAST_STATE_UPDATE", and "RE_LAUNCH".
    :vartype action: str or ~azure.mgmt.hdinsightcontainers.models.Action
    :ivar flink_configuration: Additional properties used to configure Flink jobs. It allows users
     to set properties such as parallelism and jobSavePointDirectory. It accepts additional
     key-value pairs as properties, where the keys are strings and the values are strings as well.
    :vartype flink_configuration: dict[str, str]
    :ivar job_id: Unique id for identifying a job.
    :vartype job_id: str
    :ivar status: Status of job.
    :vartype status: str
    :ivar job_output: Output of job.
    :vartype job_output: str
    :ivar action_result: Action result of job.
    :vartype action_result: str
    :ivar last_save_point: The last savepoint.
    :vartype last_save_point: str
    """

    _validation = {
        "job_type": {"required": True},
        "job_id": {"readonly": True},
        "status": {"readonly": True},
        "job_output": {"readonly": True},
        "action_result": {"readonly": True},
        "last_save_point": {"readonly": True},
    }

    _attribute_map = {
        "job_type": {"key": "jobType", "type": "str"},
        "run_id": {"key": "runId", "type": "str"},
        "job_name": {"key": "jobName", "type": "str"},
        "job_jar_directory": {"key": "jobJarDirectory", "type": "str"},
        "jar_name": {"key": "jarName", "type": "str"},
        "entry_class": {"key": "entryClass", "type": "str"},
        "args": {"key": "args", "type": "str"},
        "save_point_name": {"key": "savePointName", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "flink_configuration": {"key": "flinkConfiguration", "type": "{str}"},
        "job_id": {"key": "jobId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "job_output": {"key": "jobOutput", "type": "str"},
        "action_result": {"key": "actionResult", "type": "str"},
        "last_save_point": {"key": "lastSavePoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        run_id: Optional[str] = None,
        job_name: Optional[str] = None,
        job_jar_directory: Optional[str] = None,
        jar_name: Optional[str] = None,
        entry_class: Optional[str] = None,
        args: Optional[str] = None,
        save_point_name: Optional[str] = None,
        action: Optional[Union[str, "_models.Action"]] = None,
        flink_configuration: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword run_id: Run id of job.
        :paramtype run_id: str
        :keyword job_name: Name of job.
        :paramtype job_name: str
        :keyword job_jar_directory: A string property that specifies the directory where the job JAR is
         located.
        :paramtype job_jar_directory: str
        :keyword jar_name: A string property that represents the name of the job JAR.
        :paramtype jar_name: str
        :keyword entry_class: A string property that specifies the entry class for the Flink job.
        :paramtype entry_class: str
        :keyword args: A string property representing additional JVM arguments for the Flink job. It
         should be space separated value.
        :paramtype args: str
        :keyword save_point_name: A string property that represents the name of the savepoint for the
         Flink job.
        :paramtype save_point_name: str
        :keyword action: A string property that indicates the action to be performed on the Flink job.
         It can have one of the following enum values => NEW, UPDATE, STATELESS_UPDATE, STOP, START,
         CANCEL, SAVEPOINT, LIST_SAVEPOINT, or DELETE. Known values are: "NEW", "UPDATE",
         "STATELESS_UPDATE", "STOP", "START", "CANCEL", "SAVEPOINT", "LIST_SAVEPOINT", "DELETE",
         "LAST_STATE_UPDATE", and "RE_LAUNCH".
        :paramtype action: str or ~azure.mgmt.hdinsightcontainers.models.Action
        :keyword flink_configuration: Additional properties used to configure Flink jobs. It allows
         users to set properties such as parallelism and jobSavePointDirectory. It accepts additional
         key-value pairs as properties, where the keys are strings and the values are strings as well.
        :paramtype flink_configuration: dict[str, str]
        """
        super().__init__(**kwargs)
        self.job_type: str = "FlinkJob"
        self.run_id = run_id
        self.job_name = job_name
        self.job_jar_directory = job_jar_directory
        self.jar_name = jar_name
        self.entry_class = entry_class
        self.args = args
        self.save_point_name = save_point_name
        self.action = action
        self.flink_configuration = flink_configuration
        self.job_id = None
        self.status = None
        self.job_output = None
        self.action_result = None
        self.last_save_point = None


class FlinkProfile(_serialization.Model):
    """The Flink cluster profile.

    All required parameters must be populated in order to send to server.

    :ivar storage: The storage profile. Required.
    :vartype storage: ~azure.mgmt.hdinsightcontainers.models.FlinkStorageProfile
    :ivar num_replicas: The number of task managers.
    :vartype num_replicas: int
    :ivar job_manager: Job Manager container/ process CPU and memory requirements. Required.
    :vartype job_manager: ~azure.mgmt.hdinsightcontainers.models.ComputeResourceDefinition
    :ivar history_server: History Server container/ process CPU and memory requirements.
    :vartype history_server: ~azure.mgmt.hdinsightcontainers.models.ComputeResourceDefinition
    :ivar task_manager: Task Manager container/ process CPU and memory requirements. Required.
    :vartype task_manager: ~azure.mgmt.hdinsightcontainers.models.ComputeResourceDefinition
    :ivar catalog_options: Flink cluster catalog options.
    :vartype catalog_options: ~azure.mgmt.hdinsightcontainers.models.FlinkCatalogOptions
    :ivar deployment_mode: A string property that indicates the deployment mode of Flink cluster.
     It can have one of the following enum values => Application, Session. Default value is Session.
     Known values are: "Application" and "Session".
    :vartype deployment_mode: str or ~azure.mgmt.hdinsightcontainers.models.DeploymentMode
    :ivar job_spec: Job specifications for flink clusters in application deployment mode. The
     specification is immutable even if job properties are changed by calling the RunJob API, please
     use the ListJob API to get the latest job information.
    :vartype job_spec: ~azure.mgmt.hdinsightcontainers.models.FlinkJobProfile
    """

    _validation = {
        "storage": {"required": True},
        "job_manager": {"required": True},
        "task_manager": {"required": True},
    }

    _attribute_map = {
        "storage": {"key": "storage", "type": "FlinkStorageProfile"},
        "num_replicas": {"key": "numReplicas", "type": "int"},
        "job_manager": {"key": "jobManager", "type": "ComputeResourceDefinition"},
        "history_server": {"key": "historyServer", "type": "ComputeResourceDefinition"},
        "task_manager": {"key": "taskManager", "type": "ComputeResourceDefinition"},
        "catalog_options": {"key": "catalogOptions", "type": "FlinkCatalogOptions"},
        "deployment_mode": {"key": "deploymentMode", "type": "str"},
        "job_spec": {"key": "jobSpec", "type": "FlinkJobProfile"},
    }

    def __init__(
        self,
        *,
        storage: "_models.FlinkStorageProfile",
        job_manager: "_models.ComputeResourceDefinition",
        task_manager: "_models.ComputeResourceDefinition",
        num_replicas: Optional[int] = None,
        history_server: Optional["_models.ComputeResourceDefinition"] = None,
        catalog_options: Optional["_models.FlinkCatalogOptions"] = None,
        deployment_mode: Optional[Union[str, "_models.DeploymentMode"]] = None,
        job_spec: Optional["_models.FlinkJobProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage: The storage profile. Required.
        :paramtype storage: ~azure.mgmt.hdinsightcontainers.models.FlinkStorageProfile
        :keyword num_replicas: The number of task managers.
        :paramtype num_replicas: int
        :keyword job_manager: Job Manager container/ process CPU and memory requirements. Required.
        :paramtype job_manager: ~azure.mgmt.hdinsightcontainers.models.ComputeResourceDefinition
        :keyword history_server: History Server container/ process CPU and memory requirements.
        :paramtype history_server: ~azure.mgmt.hdinsightcontainers.models.ComputeResourceDefinition
        :keyword task_manager: Task Manager container/ process CPU and memory requirements. Required.
        :paramtype task_manager: ~azure.mgmt.hdinsightcontainers.models.ComputeResourceDefinition
        :keyword catalog_options: Flink cluster catalog options.
        :paramtype catalog_options: ~azure.mgmt.hdinsightcontainers.models.FlinkCatalogOptions
        :keyword deployment_mode: A string property that indicates the deployment mode of Flink
         cluster. It can have one of the following enum values => Application, Session. Default value is
         Session. Known values are: "Application" and "Session".
        :paramtype deployment_mode: str or ~azure.mgmt.hdinsightcontainers.models.DeploymentMode
        :keyword job_spec: Job specifications for flink clusters in application deployment mode. The
         specification is immutable even if job properties are changed by calling the RunJob API, please
         use the ListJob API to get the latest job information.
        :paramtype job_spec: ~azure.mgmt.hdinsightcontainers.models.FlinkJobProfile
        """
        super().__init__(**kwargs)
        self.storage = storage
        self.num_replicas = num_replicas
        self.job_manager = job_manager
        self.history_server = history_server
        self.task_manager = task_manager
        self.catalog_options = catalog_options
        self.deployment_mode = deployment_mode
        self.job_spec = job_spec


class FlinkStorageProfile(_serialization.Model):
    """The storage profile.

    All required parameters must be populated in order to send to server.

    :ivar storage_uri: Storage account uri which is used for savepoint and checkpoint state.
     Required.
    :vartype storage_uri: str
    :ivar storagekey: Storage key is only required for wasb(s) storage.
    :vartype storagekey: str
    """

    _validation = {
        "storage_uri": {"required": True, "pattern": r"^(\w{4,5})://(.*)@(.*).\b(blob|dfs)\b.*$"},
    }

    _attribute_map = {
        "storage_uri": {"key": "storageUri", "type": "str"},
        "storagekey": {"key": "storagekey", "type": "str"},
    }

    def __init__(self, *, storage_uri: str, storagekey: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword storage_uri: Storage account uri which is used for savepoint and checkpoint state.
         Required.
        :paramtype storage_uri: str
        :keyword storagekey: Storage key is only required for wasb(s) storage.
        :paramtype storagekey: str
        """
        super().__init__(**kwargs)
        self.storage_uri = storage_uri
        self.storagekey = storagekey


class HiveCatalogOption(_serialization.Model):
    """Hive Catalog Option.

    All required parameters must be populated in order to send to server.

    :ivar catalog_name: Name of trino catalog which should use specified hive metastore. Required.
    :vartype catalog_name: str
    :ivar metastore_db_connection_authentication_mode: The authentication mode to connect to your
     Hive metastore database. More details:
     https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization.  # pylint: disable=line-too-long
     Known values are: "SqlAuth" and "IdentityAuth".
    :vartype metastore_db_connection_authentication_mode: str or
     ~azure.mgmt.hdinsightcontainers.models.MetastoreDbConnectionAuthenticationMode
    :ivar metastore_db_connection_password_secret: Secret reference name from
     secretsProfile.secrets containing password for database connection.
    :vartype metastore_db_connection_password_secret: str
    :ivar metastore_db_connection_url: Connection string for hive metastore database. Required.
    :vartype metastore_db_connection_url: str
    :ivar metastore_db_connection_user_name: User name for database connection.
    :vartype metastore_db_connection_user_name: str
    :ivar metastore_warehouse_dir: Metastore root directory URI, format:
     abfs[s]://<container>@:code:`<account_name>`.dfs.core.windows.net/:code:`<path>`. More details:
     https://docs.microsoft.com/en-us/azure/storage/blobs/data-lake-storage-introduction-abfs-uri.
     Required.
    :vartype metastore_warehouse_dir: str
    """

    _validation = {
        "catalog_name": {"required": True, "min_length": 1},
        "metastore_db_connection_url": {"required": True},
        "metastore_warehouse_dir": {"required": True},
    }

    _attribute_map = {
        "catalog_name": {"key": "catalogName", "type": "str"},
        "metastore_db_connection_authentication_mode": {
            "key": "metastoreDbConnectionAuthenticationMode",
            "type": "str",
        },
        "metastore_db_connection_password_secret": {"key": "metastoreDbConnectionPasswordSecret", "type": "str"},
        "metastore_db_connection_url": {"key": "metastoreDbConnectionURL", "type": "str"},
        "metastore_db_connection_user_name": {"key": "metastoreDbConnectionUserName", "type": "str"},
        "metastore_warehouse_dir": {"key": "metastoreWarehouseDir", "type": "str"},
    }

    def __init__(
        self,
        *,
        catalog_name: str,
        metastore_db_connection_url: str,
        metastore_warehouse_dir: str,
        metastore_db_connection_authentication_mode: Optional[
            Union[str, "_models.MetastoreDbConnectionAuthenticationMode"]
        ] = None,
        metastore_db_connection_password_secret: Optional[str] = None,
        metastore_db_connection_user_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword catalog_name: Name of trino catalog which should use specified hive metastore.
         Required.
        :paramtype catalog_name: str
        :keyword metastore_db_connection_authentication_mode: The authentication mode to connect to
         your Hive metastore database. More details:
         https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization.  # pylint: disable=line-too-long
         Known values are: "SqlAuth" and "IdentityAuth".
        :paramtype metastore_db_connection_authentication_mode: str or
         ~azure.mgmt.hdinsightcontainers.models.MetastoreDbConnectionAuthenticationMode
        :keyword metastore_db_connection_password_secret: Secret reference name from
         secretsProfile.secrets containing password for database connection.
        :paramtype metastore_db_connection_password_secret: str
        :keyword metastore_db_connection_url: Connection string for hive metastore database. Required.
        :paramtype metastore_db_connection_url: str
        :keyword metastore_db_connection_user_name: User name for database connection.
        :paramtype metastore_db_connection_user_name: str
        :keyword metastore_warehouse_dir: Metastore root directory URI, format:
         abfs[s]://<container>@:code:`<account_name>`.dfs.core.windows.net/:code:`<path>`. More details:
         https://docs.microsoft.com/en-us/azure/storage/blobs/data-lake-storage-introduction-abfs-uri.
         Required.
        :paramtype metastore_warehouse_dir: str
        """
        super().__init__(**kwargs)
        self.catalog_name = catalog_name
        self.metastore_db_connection_authentication_mode = metastore_db_connection_authentication_mode
        self.metastore_db_connection_password_secret = metastore_db_connection_password_secret
        self.metastore_db_connection_url = metastore_db_connection_url
        self.metastore_db_connection_user_name = metastore_db_connection_user_name
        self.metastore_warehouse_dir = metastore_warehouse_dir


class IpTag(_serialization.Model):
    """Contains the IpTag associated with the public IP address.

    All required parameters must be populated in order to send to server.

    :ivar ip_tag_type: Gets or sets the ipTag type: Example FirstPartyUsage. Required.
    :vartype ip_tag_type: str
    :ivar tag: Gets or sets value of the IpTag associated with the public IP. Example HDInsight,
     SQL, Storage etc. Required.
    :vartype tag: str
    """

    _validation = {
        "ip_tag_type": {"required": True},
        "tag": {"required": True},
    }

    _attribute_map = {
        "ip_tag_type": {"key": "ipTagType", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
    }

    def __init__(self, *, ip_tag_type: str, tag: str, **kwargs: Any) -> None:
        """
        :keyword ip_tag_type: Gets or sets the ipTag type: Example FirstPartyUsage. Required.
        :paramtype ip_tag_type: str
        :keyword tag: Gets or sets value of the IpTag associated with the public IP. Example HDInsight,
         SQL, Storage etc. Required.
        :paramtype tag: str
        """
        super().__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class KafkaConnectivityEndpoints(_serialization.Model):
    """Kafka bootstrap server and broker related connectivity endpoints.

    :ivar bootstrap_server_endpoint: bootstrap server connectivity endpoint.
    :vartype bootstrap_server_endpoint: str
    :ivar broker_endpoints: Kafka broker endpoint list.
    :vartype broker_endpoints: list[str]
    """

    _attribute_map = {
        "bootstrap_server_endpoint": {"key": "bootstrapServerEndpoint", "type": "str"},
        "broker_endpoints": {"key": "brokerEndpoints", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        bootstrap_server_endpoint: Optional[str] = None,
        broker_endpoints: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword bootstrap_server_endpoint: bootstrap server connectivity endpoint.
        :paramtype bootstrap_server_endpoint: str
        :keyword broker_endpoints: Kafka broker endpoint list.
        :paramtype broker_endpoints: list[str]
        """
        super().__init__(**kwargs)
        self.bootstrap_server_endpoint = bootstrap_server_endpoint
        self.broker_endpoints = broker_endpoints


class KafkaProfile(_serialization.Model):
    """The Kafka cluster profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar enable_k_raft: Expose Kafka cluster in KRaft mode.
    :vartype enable_k_raft: bool
    :ivar enable_public_endpoints: Expose worker nodes as public endpoints.
    :vartype enable_public_endpoints: bool
    :ivar remote_storage_uri: Fully qualified path of Azure Storage container used for Tiered
     Storage.
    :vartype remote_storage_uri: str
    :ivar disk_storage: Kafka disk storage profile. Required.
    :vartype disk_storage: ~azure.mgmt.hdinsightcontainers.models.DiskStorageProfile
    :ivar connectivity_endpoints: Kafka bootstrap server and brokers related connectivity
     endpoints.
    :vartype connectivity_endpoints:
     ~azure.mgmt.hdinsightcontainers.models.KafkaConnectivityEndpoints
    """

    _validation = {
        "remote_storage_uri": {"pattern": r"^(https?|abfss?):\/\/[^/]+(?:\/|$)"},
        "disk_storage": {"required": True},
        "connectivity_endpoints": {"readonly": True},
    }

    _attribute_map = {
        "enable_k_raft": {"key": "enableKRaft", "type": "bool"},
        "enable_public_endpoints": {"key": "enablePublicEndpoints", "type": "bool"},
        "remote_storage_uri": {"key": "remoteStorageUri", "type": "str"},
        "disk_storage": {"key": "diskStorage", "type": "DiskStorageProfile"},
        "connectivity_endpoints": {"key": "connectivityEndpoints", "type": "KafkaConnectivityEndpoints"},
    }

    def __init__(
        self,
        *,
        disk_storage: "_models.DiskStorageProfile",
        enable_k_raft: bool = True,
        enable_public_endpoints: bool = False,
        remote_storage_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_k_raft: Expose Kafka cluster in KRaft mode.
        :paramtype enable_k_raft: bool
        :keyword enable_public_endpoints: Expose worker nodes as public endpoints.
        :paramtype enable_public_endpoints: bool
        :keyword remote_storage_uri: Fully qualified path of Azure Storage container used for Tiered
         Storage.
        :paramtype remote_storage_uri: str
        :keyword disk_storage: Kafka disk storage profile. Required.
        :paramtype disk_storage: ~azure.mgmt.hdinsightcontainers.models.DiskStorageProfile
        """
        super().__init__(**kwargs)
        self.enable_k_raft = enable_k_raft
        self.enable_public_endpoints = enable_public_endpoints
        self.remote_storage_uri = remote_storage_uri
        self.disk_storage = disk_storage
        self.connectivity_endpoints = None


class LoadBasedConfig(_serialization.Model):
    """Profile of load based Autoscale.

    All required parameters must be populated in order to send to server.

    :ivar min_nodes: User needs to set the minimum number of nodes for load based scaling, the load
     based scaling will use this to scale up and scale down between minimum and maximum number of
     nodes. Required.
    :vartype min_nodes: int
    :ivar max_nodes: User needs to set the maximum number of nodes for load based scaling, the load
     based scaling will use this to scale up and scale down between minimum and maximum number of
     nodes. Required.
    :vartype max_nodes: int
    :ivar poll_interval: User can specify the poll interval, this is the time period (in seconds)
     after which scaling metrics are polled for triggering a scaling operation.
    :vartype poll_interval: int
    :ivar cooldown_period: This is a cool down period, this is a time period in seconds, which
     determines the amount of time that must elapse between a scaling activity started by a rule and
     the start of the next scaling activity, regardless of the rule that triggers it. The default
     value is 300 seconds.
    :vartype cooldown_period: int
    :ivar scaling_rules: The scaling rules. Required.
    :vartype scaling_rules: list[~azure.mgmt.hdinsightcontainers.models.ScalingRule]
    """

    _validation = {
        "min_nodes": {"required": True},
        "max_nodes": {"required": True},
        "scaling_rules": {"required": True},
    }

    _attribute_map = {
        "min_nodes": {"key": "minNodes", "type": "int"},
        "max_nodes": {"key": "maxNodes", "type": "int"},
        "poll_interval": {"key": "pollInterval", "type": "int"},
        "cooldown_period": {"key": "cooldownPeriod", "type": "int"},
        "scaling_rules": {"key": "scalingRules", "type": "[ScalingRule]"},
    }

    def __init__(
        self,
        *,
        min_nodes: int,
        max_nodes: int,
        scaling_rules: List["_models.ScalingRule"],
        poll_interval: Optional[int] = None,
        cooldown_period: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_nodes: User needs to set the minimum number of nodes for load based scaling, the
         load based scaling will use this to scale up and scale down between minimum and maximum number
         of nodes. Required.
        :paramtype min_nodes: int
        :keyword max_nodes: User needs to set the maximum number of nodes for load based scaling, the
         load based scaling will use this to scale up and scale down between minimum and maximum number
         of nodes. Required.
        :paramtype max_nodes: int
        :keyword poll_interval: User can specify the poll interval, this is the time period (in
         seconds) after which scaling metrics are polled for triggering a scaling operation.
        :paramtype poll_interval: int
        :keyword cooldown_period: This is a cool down period, this is a time period in seconds, which
         determines the amount of time that must elapse between a scaling activity started by a rule and
         the start of the next scaling activity, regardless of the rule that triggers it. The default
         value is 300 seconds.
        :paramtype cooldown_period: int
        :keyword scaling_rules: The scaling rules. Required.
        :paramtype scaling_rules: list[~azure.mgmt.hdinsightcontainers.models.ScalingRule]
        """
        super().__init__(**kwargs)
        self.min_nodes = min_nodes
        self.max_nodes = max_nodes
        self.poll_interval = poll_interval
        self.cooldown_period = cooldown_period
        self.scaling_rules = scaling_rules


class ManagedIdentityProfile(_serialization.Model):
    """The details of managed identity.

    All required parameters must be populated in order to send to server.

    :ivar identity_list: The list of managed identity. Required.
    :vartype identity_list: list[~azure.mgmt.hdinsightcontainers.models.ManagedIdentitySpec]
    """

    _validation = {
        "identity_list": {"required": True},
    }

    _attribute_map = {
        "identity_list": {"key": "identityList", "type": "[ManagedIdentitySpec]"},
    }

    def __init__(self, *, identity_list: List["_models.ManagedIdentitySpec"], **kwargs: Any) -> None:
        """
        :keyword identity_list: The list of managed identity. Required.
        :paramtype identity_list: list[~azure.mgmt.hdinsightcontainers.models.ManagedIdentitySpec]
        """
        super().__init__(**kwargs)
        self.identity_list = identity_list


class ManagedIdentitySpec(_serialization.Model):
    """The details of a managed identity.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of managed identity. Required. Known values are: "cluster", "user", and
     "internal".
    :vartype type: str or ~azure.mgmt.hdinsightcontainers.models.ManagedIdentityType
    :ivar resource_id: ResourceId of the managed identity. Required.
    :vartype resource_id: str
    :ivar client_id: ClientId of the managed identity. Required.
    :vartype client_id: str
    :ivar object_id: ObjectId of the managed identity. Required.
    :vartype object_id: str
    """

    _validation = {
        "type": {"required": True},
        "resource_id": {"required": True},
        "client_id": {
            "required": True,
            "pattern": r"^[{(]?[0-9A-Fa-f]{8}[-]?(?:[0-9A-Fa-f]{4}[-]?){3}[0-9A-Fa-f]{12}[)}]?$",
        },
        "object_id": {
            "required": True,
            "pattern": r"^[{(]?[0-9A-Fa-f]{8}[-]?(?:[0-9A-Fa-f]{4}[-]?){3}[0-9A-Fa-f]{12}[)}]?$",
        },
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedIdentityType"],
        resource_id: str,
        client_id: str,
        object_id: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of managed identity. Required. Known values are: "cluster", "user", and
         "internal".
        :paramtype type: str or ~azure.mgmt.hdinsightcontainers.models.ManagedIdentityType
        :keyword resource_id: ResourceId of the managed identity. Required.
        :paramtype resource_id: str
        :keyword client_id: ClientId of the managed identity. Required.
        :paramtype client_id: str
        :keyword object_id: ObjectId of the managed identity. Required.
        :paramtype object_id: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.resource_id = resource_id
        self.client_id = client_id
        self.object_id = object_id


class MavenLibraryProperties(ClusterLibraryProperties):
    """Properties of a Maven library in the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of the library. Required. Known values are: "pypi" and "maven".
    :vartype type: str or ~azure.mgmt.hdinsightcontainers.models.Type
    :ivar remarks: Remark of the latest library management operation.
    :vartype remarks: str
    :ivar timestamp: Timestamp of the latest library management operation.
    :vartype timestamp: ~datetime.datetime
    :ivar status: Status of the library. Known values are: "INSTALLING", "INSTALLED",
     "INSTALL_FAILED", "UNINSTALLING", and "UNINSTALL_FAILED".
    :vartype status: str or ~azure.mgmt.hdinsightcontainers.models.Status
    :ivar message: Error message of the library operation when a failure occurs.
    :vartype message: str
    :ivar group_id: GroupId of the Maven package. Required.
    :vartype group_id: str
    :ivar name: ArtifactId of the Maven package. Required.
    :vartype name: str
    :ivar version: Version of the Maven package.
    :vartype version: str
    """

    _validation = {
        "type": {"required": True},
        "timestamp": {"readonly": True},
        "status": {"readonly": True},
        "message": {"readonly": True},
        "group_id": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "remarks": {"key": "remarks", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "group_id": {"key": "groupId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self, *, group_id: str, name: str, remarks: Optional[str] = None, version: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword remarks: Remark of the latest library management operation.
        :paramtype remarks: str
        :keyword group_id: GroupId of the Maven package. Required.
        :paramtype group_id: str
        :keyword name: ArtifactId of the Maven package. Required.
        :paramtype name: str
        :keyword version: Version of the Maven package.
        :paramtype version: str
        """
        super().__init__(remarks=remarks, **kwargs)
        self.type: str = "maven"
        self.group_id = group_id
        self.name = name
        self.version = version


class NameAvailabilityParameters(_serialization.Model):
    """Details of check name availability request body.

    :ivar name: Name for checking availability.
    :vartype name: str
    :ivar type: The resource type in Microsoft.HDInsight.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name for checking availability.
        :paramtype name: str
        :keyword type: The resource type in Microsoft.HDInsight.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class NameAvailabilityResult(_serialization.Model):
    """Result of check name availability.

    :ivar name_available: Indicator of availability of the Microsoft.HDInsight resource name.
    :vartype name_available: bool
    :ivar reason: The reason of unavailability.
    :vartype reason: str
    :ivar message: The error message of unavailability.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Indicator of availability of the Microsoft.HDInsight resource name.
        :paramtype name_available: bool
        :keyword reason: The reason of unavailability.
        :paramtype reason: str
        :keyword message: The error message of unavailability.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class NodeProfile(_serialization.Model):
    """The node profile.

    All required parameters must be populated in order to send to server.

    :ivar type: The node type. Required.
    :vartype type: str
    :ivar vm_size: The virtual machine SKU. Required.
    :vartype vm_size: str
    :ivar count: The number of virtual machines. Required.
    :vartype count: int
    """

    _validation = {
        "type": {"required": True, "pattern": r"^(head|Head|HEAD|worker|Worker|WORKER)$"},
        "vm_size": {"required": True, "pattern": r"^[a-zA-Z0-9_\-]{0,256}$"},
        "count": {"required": True, "minimum": 0},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, type: str, vm_size: str, count: int, **kwargs: Any) -> None:
        """
        :keyword type: The node type. Required.
        :paramtype type: str
        :keyword vm_size: The virtual machine SKU. Required.
        :paramtype vm_size: str
        :keyword count: The number of virtual machines. Required.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.type = type
        self.vm_size = vm_size
        self.count = count


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.hdinsightcontainers.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.hdinsightcontainers.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.hdinsightcontainers.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.hdinsightcontainers.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PyPiLibraryProperties(ClusterLibraryProperties):
    """Properties of a PyPi library in the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of the library. Required. Known values are: "pypi" and "maven".
    :vartype type: str or ~azure.mgmt.hdinsightcontainers.models.Type
    :ivar remarks: Remark of the latest library management operation.
    :vartype remarks: str
    :ivar timestamp: Timestamp of the latest library management operation.
    :vartype timestamp: ~datetime.datetime
    :ivar status: Status of the library. Known values are: "INSTALLING", "INSTALLED",
     "INSTALL_FAILED", "UNINSTALLING", and "UNINSTALL_FAILED".
    :vartype status: str or ~azure.mgmt.hdinsightcontainers.models.Status
    :ivar message: Error message of the library operation when a failure occurs.
    :vartype message: str
    :ivar name: Name of the PyPi package. Required.
    :vartype name: str
    :ivar version: Version of the PyPi package.
    :vartype version: str
    """

    _validation = {
        "type": {"required": True},
        "timestamp": {"readonly": True},
        "status": {"readonly": True},
        "message": {"readonly": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "remarks": {"key": "remarks", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self, *, name: str, remarks: Optional[str] = None, version: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword remarks: Remark of the latest library management operation.
        :paramtype remarks: str
        :keyword name: Name of the PyPi package. Required.
        :paramtype name: str
        :keyword version: Version of the PyPi package.
        :paramtype version: str
        """
        super().__init__(remarks=remarks, **kwargs)
        self.type: str = "pypi"
        self.name = name
        self.version = version


class RangerAdminSpec(_serialization.Model):
    """Specification for the Ranger Admin service.

    All required parameters must be populated in order to send to server.

    :ivar admins: List of usernames that should be marked as ranger admins. These usernames should
     match the user principal name (UPN) of the respective AAD users. Required.
    :vartype admins: list[str]
    :ivar database: Required.
    :vartype database: ~azure.mgmt.hdinsightcontainers.models.RangerAdminSpecDatabase
    """

    _validation = {
        "admins": {"required": True},
        "database": {"required": True},
    }

    _attribute_map = {
        "admins": {"key": "admins", "type": "[str]"},
        "database": {"key": "database", "type": "RangerAdminSpecDatabase"},
    }

    def __init__(self, *, admins: List[str], database: "_models.RangerAdminSpecDatabase", **kwargs: Any) -> None:
        """
        :keyword admins: List of usernames that should be marked as ranger admins. These usernames
         should match the user principal name (UPN) of the respective AAD users. Required.
        :paramtype admins: list[str]
        :keyword database: Required.
        :paramtype database: ~azure.mgmt.hdinsightcontainers.models.RangerAdminSpecDatabase
        """
        super().__init__(**kwargs)
        self.admins = admins
        self.database = database


class RangerAdminSpecDatabase(_serialization.Model):
    """RangerAdminSpecDatabase.

    All required parameters must be populated in order to send to server.

    :ivar host: The database URL. Required.
    :vartype host: str
    :ivar name: The database name. Required.
    :vartype name: str
    :ivar password_secret_ref: Reference for the database password.
    :vartype password_secret_ref: str
    :ivar username: The name of the database user.
    :vartype username: str
    """

    _validation = {
        "host": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "host": {"key": "host", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "password_secret_ref": {"key": "passwordSecretRef", "type": "str"},
        "username": {"key": "username", "type": "str"},
    }

    def __init__(
        self,
        *,
        host: str,
        name: str,
        password_secret_ref: Optional[str] = None,
        username: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host: The database URL. Required.
        :paramtype host: str
        :keyword name: The database name. Required.
        :paramtype name: str
        :keyword password_secret_ref: Reference for the database password.
        :paramtype password_secret_ref: str
        :keyword username: The name of the database user.
        :paramtype username: str
        """
        super().__init__(**kwargs)
        self.host = host
        self.name = name
        self.password_secret_ref = password_secret_ref
        self.username = username


class RangerAuditSpec(_serialization.Model):
    """Properties required to describe audit log storage.

    :ivar storage_account: Azure storage location of the blobs. MSI should have read/write access
     to this Storage account.
    :vartype storage_account: str
    """

    _validation = {
        "storage_account": {"min_length": 1, "pattern": r"^(https)|(abfss)://.*$"},
    }

    _attribute_map = {
        "storage_account": {"key": "storageAccount", "type": "str"},
    }

    def __init__(self, *, storage_account: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword storage_account: Azure storage location of the blobs. MSI should have read/write
         access to this Storage account.
        :paramtype storage_account: str
        """
        super().__init__(**kwargs)
        self.storage_account = storage_account


class RangerProfile(_serialization.Model):
    """The ranger cluster profile.

    All required parameters must be populated in order to send to server.

    :ivar ranger_admin: Specification for the Ranger Admin service. Required.
    :vartype ranger_admin: ~azure.mgmt.hdinsightcontainers.models.RangerAdminSpec
    :ivar ranger_audit: Properties required to describe audit log storage.
    :vartype ranger_audit: ~azure.mgmt.hdinsightcontainers.models.RangerAuditSpec
    :ivar ranger_usersync: Specification for the Ranger Usersync service. Required.
    :vartype ranger_usersync: ~azure.mgmt.hdinsightcontainers.models.RangerUsersyncSpec
    """

    _validation = {
        "ranger_admin": {"required": True},
        "ranger_usersync": {"required": True},
    }

    _attribute_map = {
        "ranger_admin": {"key": "rangerAdmin", "type": "RangerAdminSpec"},
        "ranger_audit": {"key": "rangerAudit", "type": "RangerAuditSpec"},
        "ranger_usersync": {"key": "rangerUsersync", "type": "RangerUsersyncSpec"},
    }

    def __init__(
        self,
        *,
        ranger_admin: "_models.RangerAdminSpec",
        ranger_usersync: "_models.RangerUsersyncSpec",
        ranger_audit: Optional["_models.RangerAuditSpec"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ranger_admin: Specification for the Ranger Admin service. Required.
        :paramtype ranger_admin: ~azure.mgmt.hdinsightcontainers.models.RangerAdminSpec
        :keyword ranger_audit: Properties required to describe audit log storage.
        :paramtype ranger_audit: ~azure.mgmt.hdinsightcontainers.models.RangerAuditSpec
        :keyword ranger_usersync: Specification for the Ranger Usersync service. Required.
        :paramtype ranger_usersync: ~azure.mgmt.hdinsightcontainers.models.RangerUsersyncSpec
        """
        super().__init__(**kwargs)
        self.ranger_admin = ranger_admin
        self.ranger_audit = ranger_audit
        self.ranger_usersync = ranger_usersync


class RangerUsersyncSpec(_serialization.Model):
    """Specification for the Ranger Usersync service.

    :ivar enabled: Denotes whether usersync service should be enabled.
    :vartype enabled: bool
    :ivar groups: List of groups that should be synced. These group names should match the object
     id of the respective AAD groups.
    :vartype groups: list[str]
    :ivar mode: User & groups can be synced automatically or via a static list that's refreshed.
     Known values are: "static" and "automatic".
    :vartype mode: str or ~azure.mgmt.hdinsightcontainers.models.RangerUsersyncMode
    :ivar user_mapping_location: Azure storage location of a mapping file that lists user & group
     associations.
    :vartype user_mapping_location: str
    :ivar users: List of user names that should be synced. These usernames should match the User
     principal name of the respective AAD users.
    :vartype users: list[str]
    """

    _validation = {
        "user_mapping_location": {"min_length": 1, "pattern": r"^(https)|(abfss)://.*$"},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "groups": {"key": "groups", "type": "[str]"},
        "mode": {"key": "mode", "type": "str"},
        "user_mapping_location": {"key": "userMappingLocation", "type": "str"},
        "users": {"key": "users", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        enabled: bool = True,
        groups: Optional[List[str]] = None,
        mode: Union[str, "_models.RangerUsersyncMode"] = "automatic",
        user_mapping_location: Optional[str] = None,
        users: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Denotes whether usersync service should be enabled.
        :paramtype enabled: bool
        :keyword groups: List of groups that should be synced. These group names should match the
         object id of the respective AAD groups.
        :paramtype groups: list[str]
        :keyword mode: User & groups can be synced automatically or via a static list that's refreshed.
         Known values are: "static" and "automatic".
        :paramtype mode: str or ~azure.mgmt.hdinsightcontainers.models.RangerUsersyncMode
        :keyword user_mapping_location: Azure storage location of a mapping file that lists user &
         group associations.
        :paramtype user_mapping_location: str
        :keyword users: List of user names that should be synced. These usernames should match the User
         principal name of the respective AAD users.
        :paramtype users: list[str]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.groups = groups
        self.mode = mode
        self.user_mapping_location = user_mapping_location
        self.users = users


class ScalingRule(_serialization.Model):
    """The scaling rule.

    All required parameters must be populated in order to send to server.

    :ivar action_type: The action type. Required. Known values are: "scaleup" and "scaledown".
    :vartype action_type: str or ~azure.mgmt.hdinsightcontainers.models.ScaleActionType
    :ivar evaluation_count: This is an evaluation count for a scaling condition, the number of
     times a trigger condition should be successful, before scaling activity is triggered. Required.
    :vartype evaluation_count: int
    :ivar scaling_metric: Metrics name for individual workloads. For example: cpu. Required.
    :vartype scaling_metric: str
    :ivar comparison_rule: The comparison rule. Required.
    :vartype comparison_rule: ~azure.mgmt.hdinsightcontainers.models.ComparisonRule
    """

    _validation = {
        "action_type": {"required": True},
        "evaluation_count": {"required": True},
        "scaling_metric": {"required": True},
        "comparison_rule": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "evaluation_count": {"key": "evaluationCount", "type": "int"},
        "scaling_metric": {"key": "scalingMetric", "type": "str"},
        "comparison_rule": {"key": "comparisonRule", "type": "ComparisonRule"},
    }

    def __init__(
        self,
        *,
        action_type: Union[str, "_models.ScaleActionType"],
        evaluation_count: int,
        scaling_metric: str,
        comparison_rule: "_models.ComparisonRule",
        **kwargs: Any
    ) -> None:
        """
        :keyword action_type: The action type. Required. Known values are: "scaleup" and "scaledown".
        :paramtype action_type: str or ~azure.mgmt.hdinsightcontainers.models.ScaleActionType
        :keyword evaluation_count: This is an evaluation count for a scaling condition, the number of
         times a trigger condition should be successful, before scaling activity is triggered. Required.
        :paramtype evaluation_count: int
        :keyword scaling_metric: Metrics name for individual workloads. For example: cpu. Required.
        :paramtype scaling_metric: str
        :keyword comparison_rule: The comparison rule. Required.
        :paramtype comparison_rule: ~azure.mgmt.hdinsightcontainers.models.ComparisonRule
        """
        super().__init__(**kwargs)
        self.action_type = action_type
        self.evaluation_count = evaluation_count
        self.scaling_metric = scaling_metric
        self.comparison_rule = comparison_rule


class Schedule(_serialization.Model):
    """Schedule definition.

    All required parameters must be populated in order to send to server.

    :ivar start_time: User has to set the start time of current schedule configuration, format like
     10:30 (HH:MM). Required.
    :vartype start_time: str
    :ivar end_time: User has to set the end time of current schedule configuration, format like
     10:30 (HH:MM). Required.
    :vartype end_time: str
    :ivar count: User has to set the node count anticipated at end of the scaling operation of the
     set current schedule configuration, format is integer. Required.
    :vartype count: int
    :ivar days: User has to set the days where schedule has to be set for autoscale operation.
     Required.
    :vartype days: list[str or ~azure.mgmt.hdinsightcontainers.models.ScheduleDay]
    """

    _validation = {
        "start_time": {"required": True, "pattern": r"^([0-1]?[0-9]|2[0-3]):[0-5][0-9]$"},
        "end_time": {"required": True, "pattern": r"^([0-1]?[0-9]|2[0-3]):[0-5][0-9]$"},
        "count": {"required": True},
        "days": {"required": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "days": {"key": "days", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        start_time: str,
        end_time: str,
        count: int,
        days: List[Union[str, "_models.ScheduleDay"]],
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: User has to set the start time of current schedule configuration, format
         like 10:30 (HH:MM). Required.
        :paramtype start_time: str
        :keyword end_time: User has to set the end time of current schedule configuration, format like
         10:30 (HH:MM). Required.
        :paramtype end_time: str
        :keyword count: User has to set the node count anticipated at end of the scaling operation of
         the set current schedule configuration, format is integer. Required.
        :paramtype count: int
        :keyword days: User has to set the days where schedule has to be set for autoscale operation.
         Required.
        :paramtype days: list[str or ~azure.mgmt.hdinsightcontainers.models.ScheduleDay]
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.count = count
        self.days = days


class ScheduleBasedConfig(_serialization.Model):
    """Profile of schedule based Autoscale.

    All required parameters must be populated in order to send to server.

    :ivar time_zone: User has to specify the timezone on which the schedule has to be set for
     schedule based autoscale configuration. Required.
    :vartype time_zone: str
    :ivar default_count: Setting default node count of current schedule configuration. Default node
     count specifies the number of nodes which are default when an specified scaling operation is
     executed (scale up/scale down). Required.
    :vartype default_count: int
    :ivar schedules: This specifies the schedules where scheduled based Autoscale to be enabled,
     the user has a choice to set multiple rules within the schedule across days and times
     (start/end). Required.
    :vartype schedules: list[~azure.mgmt.hdinsightcontainers.models.Schedule]
    """

    _validation = {
        "time_zone": {"required": True},
        "default_count": {"required": True},
        "schedules": {"required": True},
    }

    _attribute_map = {
        "time_zone": {"key": "timeZone", "type": "str"},
        "default_count": {"key": "defaultCount", "type": "int"},
        "schedules": {"key": "schedules", "type": "[Schedule]"},
    }

    def __init__(
        self, *, time_zone: str, default_count: int, schedules: List["_models.Schedule"], **kwargs: Any
    ) -> None:
        """
        :keyword time_zone: User has to specify the timezone on which the schedule has to be set for
         schedule based autoscale configuration. Required.
        :paramtype time_zone: str
        :keyword default_count: Setting default node count of current schedule configuration. Default
         node count specifies the number of nodes which are default when an specified scaling operation
         is executed (scale up/scale down). Required.
        :paramtype default_count: int
        :keyword schedules: This specifies the schedules where scheduled based Autoscale to be enabled,
         the user has a choice to set multiple rules within the schedule across days and times
         (start/end). Required.
        :paramtype schedules: list[~azure.mgmt.hdinsightcontainers.models.Schedule]
        """
        super().__init__(**kwargs)
        self.time_zone = time_zone
        self.default_count = default_count
        self.schedules = schedules


class ScriptActionProfile(_serialization.Model):
    """The script action profile.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of the script action. Supported type is bash scripts. Required.
    :vartype type: str
    :ivar name: Script name. Required.
    :vartype name: str
    :ivar url: Url of the script file. Required.
    :vartype url: str
    :ivar parameters: Additional parameters for the script action. It should be space-separated
     list of arguments required for script execution.
    :vartype parameters: str
    :ivar services: List of services to apply the script action. Required.
    :vartype services: list[str]
    :ivar timeout_in_minutes: Timeout duration for the script action in minutes.
    :vartype timeout_in_minutes: int
    :ivar should_persist: Specify if the script should persist on the cluster.
    :vartype should_persist: bool
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
        "url": {"required": True, "pattern": r"^(https)|(http)://.*$"},
        "services": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "parameters": {"key": "parameters", "type": "str"},
        "services": {"key": "services", "type": "[str]"},
        "timeout_in_minutes": {"key": "timeoutInMinutes", "type": "int"},
        "should_persist": {"key": "shouldPersist", "type": "bool"},
    }

    def __init__(
        self,
        *,
        type: str,
        name: str,
        url: str,
        services: List[str],
        parameters: Optional[str] = None,
        timeout_in_minutes: Optional[int] = None,
        should_persist: bool = True,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the script action. Supported type is bash scripts. Required.
        :paramtype type: str
        :keyword name: Script name. Required.
        :paramtype name: str
        :keyword url: Url of the script file. Required.
        :paramtype url: str
        :keyword parameters: Additional parameters for the script action. It should be space-separated
         list of arguments required for script execution.
        :paramtype parameters: str
        :keyword services: List of services to apply the script action. Required.
        :paramtype services: list[str]
        :keyword timeout_in_minutes: Timeout duration for the script action in minutes.
        :paramtype timeout_in_minutes: int
        :keyword should_persist: Specify if the script should persist on the cluster.
        :paramtype should_persist: bool
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name
        self.url = url
        self.parameters = parameters
        self.services = services
        self.timeout_in_minutes = timeout_in_minutes
        self.should_persist = should_persist


class SecretReference(_serialization.Model):
    """Secret reference and corresponding properties of a key vault secret.

    All required parameters must be populated in order to send to server.

    :ivar reference_name: Reference name of the secret to be used in service configs. Required.
    :vartype reference_name: str
    :ivar type: Type of key vault object: secret, key or certificate. Required. Known values are:
     "Key", "Secret", and "Certificate".
    :vartype type: str or ~azure.mgmt.hdinsightcontainers.models.KeyVaultObjectType
    :ivar version: Version of the secret in key vault.
    :vartype version: str
    :ivar key_vault_object_name: Object identifier name of the secret in key vault. Required.
    :vartype key_vault_object_name: str
    """

    _validation = {
        "reference_name": {"required": True},
        "type": {"required": True},
        "key_vault_object_name": {"required": True, "pattern": r"^[a-zA-Z][a-zA-Z0-9-]{1,126}$"},
    }

    _attribute_map = {
        "reference_name": {"key": "referenceName", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "key_vault_object_name": {"key": "keyVaultObjectName", "type": "str"},
    }

    def __init__(
        self,
        *,
        reference_name: str,
        type: Union[str, "_models.KeyVaultObjectType"],
        key_vault_object_name: str,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword reference_name: Reference name of the secret to be used in service configs. Required.
        :paramtype reference_name: str
        :keyword type: Type of key vault object: secret, key or certificate. Required. Known values
         are: "Key", "Secret", and "Certificate".
        :paramtype type: str or ~azure.mgmt.hdinsightcontainers.models.KeyVaultObjectType
        :keyword version: Version of the secret in key vault.
        :paramtype version: str
        :keyword key_vault_object_name: Object identifier name of the secret in key vault. Required.
        :paramtype key_vault_object_name: str
        """
        super().__init__(**kwargs)
        self.reference_name = reference_name
        self.type = type
        self.version = version
        self.key_vault_object_name = key_vault_object_name


class SecretsProfile(_serialization.Model):
    """The cluster secret profile.

    All required parameters must be populated in order to send to server.

    :ivar key_vault_resource_id: Name of the user Key Vault where all the cluster specific user
     secrets are stored. Required.
    :vartype key_vault_resource_id: str
    :ivar secrets: Properties of Key Vault secret.
    :vartype secrets: list[~azure.mgmt.hdinsightcontainers.models.SecretReference]
    """

    _validation = {
        "key_vault_resource_id": {"required": True},
    }

    _attribute_map = {
        "key_vault_resource_id": {"key": "keyVaultResourceId", "type": "str"},
        "secrets": {"key": "secrets", "type": "[SecretReference]"},
    }

    def __init__(
        self, *, key_vault_resource_id: str, secrets: Optional[List["_models.SecretReference"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_resource_id: Name of the user Key Vault where all the cluster specific user
         secrets are stored. Required.
        :paramtype key_vault_resource_id: str
        :keyword secrets: Properties of Key Vault secret.
        :paramtype secrets: list[~azure.mgmt.hdinsightcontainers.models.SecretReference]
        """
        super().__init__(**kwargs)
        self.key_vault_resource_id = key_vault_resource_id
        self.secrets = secrets


class ServiceConfigListResult(_serialization.Model):
    """Cluster instance service configs api response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Cluster instance service config array.
    :vartype value: list[~azure.mgmt.hdinsightcontainers.models.ServiceConfigResult]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServiceConfigResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ServiceConfigResult"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Cluster instance service config array.
        :paramtype value: list[~azure.mgmt.hdinsightcontainers.models.ServiceConfigResult]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ServiceConfigListResultProperties(_serialization.Model):
    """Service config response.

    All required parameters must be populated in order to send to server.

    :ivar service_name: Service Config Name. Required.
    :vartype service_name: str
    :ivar file_name: File Name. Required.
    :vartype file_name: str
    :ivar content: Content in the service config file.
    :vartype content: str
    :ivar component_name: Component Name. Required.
    :vartype component_name: str
    :ivar type: Config type.
    :vartype type: str
    :ivar path: Config file path.
    :vartype path: str
    :ivar custom_keys: The custom keys.
    :vartype custom_keys: dict[str, str]
    :ivar default_keys: The default keys.
    :vartype default_keys: dict[str,
     ~azure.mgmt.hdinsightcontainers.models.ServiceConfigListResultValueEntity]
    """

    _validation = {
        "service_name": {"required": True},
        "file_name": {"required": True},
        "component_name": {"required": True},
    }

    _attribute_map = {
        "service_name": {"key": "serviceName", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "content": {"key": "content", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "custom_keys": {"key": "customKeys", "type": "{str}"},
        "default_keys": {"key": "defaultKeys", "type": "{ServiceConfigListResultValueEntity}"},
    }

    def __init__(
        self,
        *,
        service_name: str,
        file_name: str,
        component_name: str,
        content: Optional[str] = None,
        type: Optional[str] = None,
        path: Optional[str] = None,
        custom_keys: Optional[Dict[str, str]] = None,
        default_keys: Optional[Dict[str, "_models.ServiceConfigListResultValueEntity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_name: Service Config Name. Required.
        :paramtype service_name: str
        :keyword file_name: File Name. Required.
        :paramtype file_name: str
        :keyword content: Content in the service config file.
        :paramtype content: str
        :keyword component_name: Component Name. Required.
        :paramtype component_name: str
        :keyword type: Config type.
        :paramtype type: str
        :keyword path: Config file path.
        :paramtype path: str
        :keyword custom_keys: The custom keys.
        :paramtype custom_keys: dict[str, str]
        :keyword default_keys: The default keys.
        :paramtype default_keys: dict[str,
         ~azure.mgmt.hdinsightcontainers.models.ServiceConfigListResultValueEntity]
        """
        super().__init__(**kwargs)
        self.service_name = service_name
        self.file_name = file_name
        self.content = content
        self.component_name = component_name
        self.type = type
        self.path = path
        self.custom_keys = custom_keys
        self.default_keys = default_keys


class ServiceConfigListResultValueEntity(_serialization.Model):
    """Default config details.

    All required parameters must be populated in order to send to server.

    :ivar value: Config value. Required.
    :vartype value: str
    :ivar description: Config description.
    :vartype description: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, value: str, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Config value. Required.
        :paramtype value: str
        :keyword description: Config description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.description = description


class ServiceConfigResult(_serialization.Model):
    """Cluster instance service config.

    :ivar properties: Cluster instance service config properties.
    :vartype properties: ~azure.mgmt.hdinsightcontainers.models.ServiceConfigResultProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ServiceConfigResultProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ServiceConfigResultProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Cluster instance service config properties.
        :paramtype properties: ~azure.mgmt.hdinsightcontainers.models.ServiceConfigResultProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ServiceConfigResultProperties(ServiceConfigListResultProperties):
    """Cluster instance service config properties.

    All required parameters must be populated in order to send to server.

    :ivar service_name: Service Config Name. Required.
    :vartype service_name: str
    :ivar file_name: File Name. Required.
    :vartype file_name: str
    :ivar content: Content in the service config file.
    :vartype content: str
    :ivar component_name: Component Name. Required.
    :vartype component_name: str
    :ivar type: Config type.
    :vartype type: str
    :ivar path: Config file path.
    :vartype path: str
    :ivar custom_keys: The custom keys.
    :vartype custom_keys: dict[str, str]
    :ivar default_keys: The default keys.
    :vartype default_keys: dict[str,
     ~azure.mgmt.hdinsightcontainers.models.ServiceConfigListResultValueEntity]
    """


class ServiceStatus(_serialization.Model):
    """Describes the status of a service of a HDInsight on AKS cluster.

    All required parameters must be populated in order to send to server.

    :ivar kind: Kind of the service. E.g. "Zookeeper". Required.
    :vartype kind: str
    :ivar ready: Indicates if the service is ready / healthy. Values can be "true", "false",
     "unknown" or anything else. Required.
    :vartype ready: str
    :ivar message: A message describing the error if any.
    :vartype message: str
    """

    _validation = {
        "kind": {"required": True},
        "ready": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "ready": {"key": "ready", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, kind: str, ready: str, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of the service. E.g. "Zookeeper". Required.
        :paramtype kind: str
        :keyword ready: Indicates if the service is ready / healthy. Values can be "true", "false",
         "unknown" or anything else. Required.
        :paramtype ready: str
        :keyword message: A message describing the error if any.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.ready = ready
        self.message = message


class SparkMetastoreSpec(_serialization.Model):
    """The metastore specification for Spark cluster.

    All required parameters must be populated in order to send to server.

    :ivar db_server_host: The database server host. Required.
    :vartype db_server_host: str
    :ivar db_name: The database name. Required.
    :vartype db_name: str
    :ivar db_connection_authentication_mode: The authentication mode to connect to your Hive
     metastore database. More details:
     https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization.  # pylint: disable=line-too-long
     Known values are: "SqlAuth" and "IdentityAuth".
    :vartype db_connection_authentication_mode: str or
     ~azure.mgmt.hdinsightcontainers.models.DbConnectionAuthenticationMode
    :ivar db_user_name: The database user name.
    :vartype db_user_name: str
    :ivar db_password_secret_name: The secret name which contains the database user password.
    :vartype db_password_secret_name: str
    :ivar key_vault_id: The key vault resource id.
    :vartype key_vault_id: str
    :ivar thrift_url: The thrift url.
    :vartype thrift_url: str
    """

    _validation = {
        "db_server_host": {"required": True},
        "db_name": {"required": True},
    }

    _attribute_map = {
        "db_server_host": {"key": "dbServerHost", "type": "str"},
        "db_name": {"key": "dbName", "type": "str"},
        "db_connection_authentication_mode": {"key": "dbConnectionAuthenticationMode", "type": "str"},
        "db_user_name": {"key": "dbUserName", "type": "str"},
        "db_password_secret_name": {"key": "dbPasswordSecretName", "type": "str"},
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
        "thrift_url": {"key": "thriftUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        db_server_host: str,
        db_name: str,
        db_connection_authentication_mode: Union[str, "_models.DbConnectionAuthenticationMode"] = "IdentityAuth",
        db_user_name: Optional[str] = None,
        db_password_secret_name: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        thrift_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword db_server_host: The database server host. Required.
        :paramtype db_server_host: str
        :keyword db_name: The database name. Required.
        :paramtype db_name: str
        :keyword db_connection_authentication_mode: The authentication mode to connect to your Hive
         metastore database. More details:
         https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization.  # pylint: disable=line-too-long
         Known values are: "SqlAuth" and "IdentityAuth".
        :paramtype db_connection_authentication_mode: str or
         ~azure.mgmt.hdinsightcontainers.models.DbConnectionAuthenticationMode
        :keyword db_user_name: The database user name.
        :paramtype db_user_name: str
        :keyword db_password_secret_name: The secret name which contains the database user password.
        :paramtype db_password_secret_name: str
        :keyword key_vault_id: The key vault resource id.
        :paramtype key_vault_id: str
        :keyword thrift_url: The thrift url.
        :paramtype thrift_url: str
        """
        super().__init__(**kwargs)
        self.db_server_host = db_server_host
        self.db_name = db_name
        self.db_connection_authentication_mode = db_connection_authentication_mode
        self.db_user_name = db_user_name
        self.db_password_secret_name = db_password_secret_name
        self.key_vault_id = key_vault_id
        self.thrift_url = thrift_url


class SparkProfile(_serialization.Model):
    """The spark cluster profile.

    :ivar default_storage_url: The default storage URL.
    :vartype default_storage_url: str
    :ivar metastore_spec: The metastore specification for Spark cluster.
    :vartype metastore_spec: ~azure.mgmt.hdinsightcontainers.models.SparkMetastoreSpec
    :ivar user_plugins_spec: Spark user plugins spec.
    :vartype user_plugins_spec: ~azure.mgmt.hdinsightcontainers.models.SparkUserPlugins
    """

    _attribute_map = {
        "default_storage_url": {"key": "defaultStorageUrl", "type": "str"},
        "metastore_spec": {"key": "metastoreSpec", "type": "SparkMetastoreSpec"},
        "user_plugins_spec": {"key": "userPluginsSpec", "type": "SparkUserPlugins"},
    }

    def __init__(
        self,
        *,
        default_storage_url: Optional[str] = None,
        metastore_spec: Optional["_models.SparkMetastoreSpec"] = None,
        user_plugins_spec: Optional["_models.SparkUserPlugins"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default_storage_url: The default storage URL.
        :paramtype default_storage_url: str
        :keyword metastore_spec: The metastore specification for Spark cluster.
        :paramtype metastore_spec: ~azure.mgmt.hdinsightcontainers.models.SparkMetastoreSpec
        :keyword user_plugins_spec: Spark user plugins spec.
        :paramtype user_plugins_spec: ~azure.mgmt.hdinsightcontainers.models.SparkUserPlugins
        """
        super().__init__(**kwargs)
        self.default_storage_url = default_storage_url
        self.metastore_spec = metastore_spec
        self.user_plugins_spec = user_plugins_spec


class SparkUserPlugin(_serialization.Model):
    """Spark user plugin.

    All required parameters must be populated in order to send to server.

    :ivar path: Fully qualified path to the folder containing the plugins. Required.
    :vartype path: str
    """

    _validation = {
        "path": {"required": True, "min_length": 1, "pattern": r"^(https)|(abfss)://.*$"},
    }

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
    }

    def __init__(self, *, path: str, **kwargs: Any) -> None:
        """
        :keyword path: Fully qualified path to the folder containing the plugins. Required.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.path = path


class SparkUserPlugins(_serialization.Model):
    """Spark user plugins spec.

    :ivar plugins: Spark user plugins.
    :vartype plugins: list[~azure.mgmt.hdinsightcontainers.models.SparkUserPlugin]
    """

    _attribute_map = {
        "plugins": {"key": "plugins", "type": "[SparkUserPlugin]"},
    }

    def __init__(self, *, plugins: Optional[List["_models.SparkUserPlugin"]] = None, **kwargs: Any) -> None:
        """
        :keyword plugins: Spark user plugins.
        :paramtype plugins: list[~azure.mgmt.hdinsightcontainers.models.SparkUserPlugin]
        """
        super().__init__(**kwargs)
        self.plugins = plugins


class SshConnectivityEndpoint(_serialization.Model):
    """SSH connectivity endpoint details.

    All required parameters must be populated in order to send to server.

    :ivar endpoint: SSH connectivity endpoint. Required.
    :vartype endpoint: str
    :ivar private_ssh_endpoint: Private SSH connectivity endpoint. This property will only be
     returned when enableInternalIngress is true.
    :vartype private_ssh_endpoint: str
    """

    _validation = {
        "endpoint": {"required": True},
    }

    _attribute_map = {
        "endpoint": {"key": "endpoint", "type": "str"},
        "private_ssh_endpoint": {"key": "privateSshEndpoint", "type": "str"},
    }

    def __init__(self, *, endpoint: str, private_ssh_endpoint: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword endpoint: SSH connectivity endpoint. Required.
        :paramtype endpoint: str
        :keyword private_ssh_endpoint: Private SSH connectivity endpoint. This property will only be
         returned when enableInternalIngress is true.
        :paramtype private_ssh_endpoint: str
        """
        super().__init__(**kwargs)
        self.endpoint = endpoint
        self.private_ssh_endpoint = private_ssh_endpoint


class SshProfile(_serialization.Model):
    """Ssh profile for the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar count: Number of ssh pods per cluster. Required.
    :vartype count: int
    :ivar pod_prefix: Prefix of the pod names. Pod number will be appended to the prefix. The
     ingress URLs for the pods will be available at
     :code:`<clusterFqdn>`/:code:`<sshBasePath>`/:code:`<prefix>`-:code:`<number>`.
    :vartype pod_prefix: str
    :ivar vm_size: The virtual machine SKU.
    :vartype vm_size: str
    """

    _validation = {
        "count": {"required": True, "maximum": 5, "minimum": 0},
        "pod_prefix": {"readonly": True},
        "vm_size": {"pattern": r"^[a-zA-Z0-9_\-]{0,256}$"},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "pod_prefix": {"key": "podPrefix", "type": "str"},
        "vm_size": {"key": "vmSize", "type": "str"},
    }

    def __init__(self, *, count: int, vm_size: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword count: Number of ssh pods per cluster. Required.
        :paramtype count: int
        :keyword vm_size: The virtual machine SKU.
        :paramtype vm_size: str
        """
        super().__init__(**kwargs)
        self.count = count
        self.pod_prefix = None
        self.vm_size = vm_size


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.hdinsightcontainers.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.hdinsightcontainers.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.hdinsightcontainers.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.hdinsightcontainers.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsObject(_serialization.Model):
    """Tags object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class TrinoCoordinator(_serialization.Model):
    """Trino Coordinator.

    :ivar debug: Trino debug configuration.
    :vartype debug: ~azure.mgmt.hdinsightcontainers.models.TrinoDebugConfig
    :ivar high_availability_enabled: The flag that if enable coordinator HA, uses multiple
     coordinator replicas with auto failover, one per each head node. Default: true.
    :vartype high_availability_enabled: bool
    """

    _attribute_map = {
        "debug": {"key": "debug", "type": "TrinoDebugConfig"},
        "high_availability_enabled": {"key": "highAvailabilityEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        debug: Optional["_models.TrinoDebugConfig"] = None,
        high_availability_enabled: bool = True,
        **kwargs: Any
    ) -> None:
        """
        :keyword debug: Trino debug configuration.
        :paramtype debug: ~azure.mgmt.hdinsightcontainers.models.TrinoDebugConfig
        :keyword high_availability_enabled: The flag that if enable coordinator HA, uses multiple
         coordinator replicas with auto failover, one per each head node. Default: true.
        :paramtype high_availability_enabled: bool
        """
        super().__init__(**kwargs)
        self.debug = debug
        self.high_availability_enabled = high_availability_enabled


class TrinoDebugConfig(_serialization.Model):
    """Trino debug configuration.

    :ivar enable: The flag that if enable debug or not.
    :vartype enable: bool
    :ivar port: The debug port.
    :vartype port: int
    :ivar suspend: The flag that if suspend debug or not.
    :vartype suspend: bool
    """

    _attribute_map = {
        "enable": {"key": "enable", "type": "bool"},
        "port": {"key": "port", "type": "int"},
        "suspend": {"key": "suspend", "type": "bool"},
    }

    def __init__(self, *, enable: bool = False, port: int = 8008, suspend: bool = False, **kwargs: Any) -> None:
        """
        :keyword enable: The flag that if enable debug or not.
        :paramtype enable: bool
        :keyword port: The debug port.
        :paramtype port: int
        :keyword suspend: The flag that if suspend debug or not.
        :paramtype suspend: bool
        """
        super().__init__(**kwargs)
        self.enable = enable
        self.port = port
        self.suspend = suspend


class TrinoProfile(_serialization.Model):
    """Trino Cluster profile.

    :ivar catalog_options: Trino cluster catalog options.
    :vartype catalog_options: ~azure.mgmt.hdinsightcontainers.models.CatalogOptions
    :ivar coordinator: Trino Coordinator.
    :vartype coordinator: ~azure.mgmt.hdinsightcontainers.models.TrinoCoordinator
    :ivar user_plugins_spec: Trino user plugins spec.
    :vartype user_plugins_spec: ~azure.mgmt.hdinsightcontainers.models.TrinoUserPlugins
    :ivar user_telemetry_spec: User telemetry.
    :vartype user_telemetry_spec: ~azure.mgmt.hdinsightcontainers.models.TrinoUserTelemetry
    :ivar worker: Trino worker.
    :vartype worker: ~azure.mgmt.hdinsightcontainers.models.TrinoWorker
    """

    _attribute_map = {
        "catalog_options": {"key": "catalogOptions", "type": "CatalogOptions"},
        "coordinator": {"key": "coordinator", "type": "TrinoCoordinator"},
        "user_plugins_spec": {"key": "userPluginsSpec", "type": "TrinoUserPlugins"},
        "user_telemetry_spec": {"key": "userTelemetrySpec", "type": "TrinoUserTelemetry"},
        "worker": {"key": "worker", "type": "TrinoWorker"},
    }

    def __init__(
        self,
        *,
        catalog_options: Optional["_models.CatalogOptions"] = None,
        coordinator: Optional["_models.TrinoCoordinator"] = None,
        user_plugins_spec: Optional["_models.TrinoUserPlugins"] = None,
        user_telemetry_spec: Optional["_models.TrinoUserTelemetry"] = None,
        worker: Optional["_models.TrinoWorker"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword catalog_options: Trino cluster catalog options.
        :paramtype catalog_options: ~azure.mgmt.hdinsightcontainers.models.CatalogOptions
        :keyword coordinator: Trino Coordinator.
        :paramtype coordinator: ~azure.mgmt.hdinsightcontainers.models.TrinoCoordinator
        :keyword user_plugins_spec: Trino user plugins spec.
        :paramtype user_plugins_spec: ~azure.mgmt.hdinsightcontainers.models.TrinoUserPlugins
        :keyword user_telemetry_spec: User telemetry.
        :paramtype user_telemetry_spec: ~azure.mgmt.hdinsightcontainers.models.TrinoUserTelemetry
        :keyword worker: Trino worker.
        :paramtype worker: ~azure.mgmt.hdinsightcontainers.models.TrinoWorker
        """
        super().__init__(**kwargs)
        self.catalog_options = catalog_options
        self.coordinator = coordinator
        self.user_plugins_spec = user_plugins_spec
        self.user_telemetry_spec = user_telemetry_spec
        self.worker = worker


class TrinoTelemetryConfig(_serialization.Model):
    """Trino user telemetry definition.

    :ivar hivecatalog_name: Hive Catalog name used to mount external tables on the logs written by
     trino, if not specified there tables are not created.
    :vartype hivecatalog_name: str
    :ivar hivecatalog_schema: Schema of the above catalog to use, to mount query logs as external
     tables, if not specified tables will be mounted under schema trinologs.
    :vartype hivecatalog_schema: str
    :ivar partition_retention_in_days: Retention period for query log table partitions, this
     doesn't have any affect on actual data.
    :vartype partition_retention_in_days: int
    :ivar path: Azure storage location of the blobs.
    :vartype path: str
    """

    _validation = {
        "hivecatalog_name": {"min_length": 1},
        "path": {"min_length": 1},
    }

    _attribute_map = {
        "hivecatalog_name": {"key": "hivecatalogName", "type": "str"},
        "hivecatalog_schema": {"key": "hivecatalogSchema", "type": "str"},
        "partition_retention_in_days": {"key": "partitionRetentionInDays", "type": "int"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self,
        *,
        hivecatalog_name: Optional[str] = None,
        hivecatalog_schema: str = "trinologs",
        partition_retention_in_days: int = 365,
        path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hivecatalog_name: Hive Catalog name used to mount external tables on the logs written
         by trino, if not specified there tables are not created.
        :paramtype hivecatalog_name: str
        :keyword hivecatalog_schema: Schema of the above catalog to use, to mount query logs as
         external tables, if not specified tables will be mounted under schema trinologs.
        :paramtype hivecatalog_schema: str
        :keyword partition_retention_in_days: Retention period for query log table partitions, this
         doesn't have any affect on actual data.
        :paramtype partition_retention_in_days: int
        :keyword path: Azure storage location of the blobs.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.hivecatalog_name = hivecatalog_name
        self.hivecatalog_schema = hivecatalog_schema
        self.partition_retention_in_days = partition_retention_in_days
        self.path = path


class TrinoUserPlugin(_serialization.Model):
    """Trino user plugin.

    :ivar enabled: Denotes whether the plugin is active or not.
    :vartype enabled: bool
    :ivar name: This field maps to the sub-directory in trino plugins location, that will contain
     all the plugins under path.
    :vartype name: str
    :ivar path: Fully qualified path to the folder containing the plugins.
    :vartype path: str
    """

    _validation = {
        "name": {"min_length": 1},
        "path": {"min_length": 1, "pattern": r"^(https)|(abfss)://.*$"},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self, *, enabled: Optional[bool] = None, name: Optional[str] = None, path: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Denotes whether the plugin is active or not.
        :paramtype enabled: bool
        :keyword name: This field maps to the sub-directory in trino plugins location, that will
         contain all the plugins under path.
        :paramtype name: str
        :keyword path: Fully qualified path to the folder containing the plugins.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.name = name
        self.path = path


class TrinoUserPlugins(_serialization.Model):
    """Trino user plugins spec.

    :ivar plugins: Trino user plugins.
    :vartype plugins: list[~azure.mgmt.hdinsightcontainers.models.TrinoUserPlugin]
    """

    _attribute_map = {
        "plugins": {"key": "plugins", "type": "[TrinoUserPlugin]"},
    }

    def __init__(self, *, plugins: Optional[List["_models.TrinoUserPlugin"]] = None, **kwargs: Any) -> None:
        """
        :keyword plugins: Trino user plugins.
        :paramtype plugins: list[~azure.mgmt.hdinsightcontainers.models.TrinoUserPlugin]
        """
        super().__init__(**kwargs)
        self.plugins = plugins


class TrinoUserTelemetry(_serialization.Model):
    """User telemetry.

    :ivar storage: Trino user telemetry definition.
    :vartype storage: ~azure.mgmt.hdinsightcontainers.models.TrinoTelemetryConfig
    """

    _attribute_map = {
        "storage": {"key": "storage", "type": "TrinoTelemetryConfig"},
    }

    def __init__(self, *, storage: Optional["_models.TrinoTelemetryConfig"] = None, **kwargs: Any) -> None:
        """
        :keyword storage: Trino user telemetry definition.
        :paramtype storage: ~azure.mgmt.hdinsightcontainers.models.TrinoTelemetryConfig
        """
        super().__init__(**kwargs)
        self.storage = storage


class TrinoWorker(_serialization.Model):
    """Trino worker.

    :ivar debug: Trino debug configuration.
    :vartype debug: ~azure.mgmt.hdinsightcontainers.models.TrinoDebugConfig
    """

    _attribute_map = {
        "debug": {"key": "debug", "type": "TrinoDebugConfig"},
    }

    def __init__(self, *, debug: Optional["_models.TrinoDebugConfig"] = None, **kwargs: Any) -> None:
        """
        :keyword debug: Trino debug configuration.
        :paramtype debug: ~azure.mgmt.hdinsightcontainers.models.TrinoDebugConfig
        """
        super().__init__(**kwargs)
        self.debug = debug


class UpdatableClusterProfile(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Cluster resource patch properties.

    :ivar service_configs_profiles: The service configs profiles.
    :vartype service_configs_profiles:
     list[~azure.mgmt.hdinsightcontainers.models.ClusterServiceConfigsProfile]
    :ivar ssh_profile: Ssh profile for the cluster.
    :vartype ssh_profile: ~azure.mgmt.hdinsightcontainers.models.SshProfile
    :ivar autoscale_profile: This is the Autoscale profile for the cluster. This will allow
     customer to create cluster enabled with Autoscale.
    :vartype autoscale_profile: ~azure.mgmt.hdinsightcontainers.models.AutoscaleProfile
    :ivar authorization_profile: Authorization profile with details of AAD user Ids and group Ids
     authorized for data plane access.
    :vartype authorization_profile: ~azure.mgmt.hdinsightcontainers.models.AuthorizationProfile
    :ivar log_analytics_profile: Cluster log analytics profile to enable or disable OMS agent for
     cluster.
    :vartype log_analytics_profile:
     ~azure.mgmt.hdinsightcontainers.models.ClusterLogAnalyticsProfile
    :ivar prometheus_profile: Cluster Prometheus profile.
    :vartype prometheus_profile: ~azure.mgmt.hdinsightcontainers.models.ClusterPrometheusProfile
    :ivar ranger_plugin_profile: Cluster Ranger plugin profile.
    :vartype ranger_plugin_profile:
     ~azure.mgmt.hdinsightcontainers.models.ClusterRangerPluginProfile
    :ivar ranger_profile: The ranger cluster profile.
    :vartype ranger_profile: ~azure.mgmt.hdinsightcontainers.models.RangerProfile
    :ivar script_action_profiles: The script action profile list.
    :vartype script_action_profiles:
     list[~azure.mgmt.hdinsightcontainers.models.ScriptActionProfile]
    :ivar secrets_profile: The cluster secret profile.
    :vartype secrets_profile: ~azure.mgmt.hdinsightcontainers.models.SecretsProfile
    :ivar trino_profile: Trino Cluster profile.
    :vartype trino_profile: ~azure.mgmt.hdinsightcontainers.models.TrinoProfile
    """

    _attribute_map = {
        "service_configs_profiles": {"key": "serviceConfigsProfiles", "type": "[ClusterServiceConfigsProfile]"},
        "ssh_profile": {"key": "sshProfile", "type": "SshProfile"},
        "autoscale_profile": {"key": "autoscaleProfile", "type": "AutoscaleProfile"},
        "authorization_profile": {"key": "authorizationProfile", "type": "AuthorizationProfile"},
        "log_analytics_profile": {"key": "logAnalyticsProfile", "type": "ClusterLogAnalyticsProfile"},
        "prometheus_profile": {"key": "prometheusProfile", "type": "ClusterPrometheusProfile"},
        "ranger_plugin_profile": {"key": "rangerPluginProfile", "type": "ClusterRangerPluginProfile"},
        "ranger_profile": {"key": "rangerProfile", "type": "RangerProfile"},
        "script_action_profiles": {"key": "scriptActionProfiles", "type": "[ScriptActionProfile]"},
        "secrets_profile": {"key": "secretsProfile", "type": "SecretsProfile"},
        "trino_profile": {"key": "trinoProfile", "type": "TrinoProfile"},
    }

    def __init__(
        self,
        *,
        service_configs_profiles: Optional[List["_models.ClusterServiceConfigsProfile"]] = None,
        ssh_profile: Optional["_models.SshProfile"] = None,
        autoscale_profile: Optional["_models.AutoscaleProfile"] = None,
        authorization_profile: Optional["_models.AuthorizationProfile"] = None,
        log_analytics_profile: Optional["_models.ClusterLogAnalyticsProfile"] = None,
        prometheus_profile: Optional["_models.ClusterPrometheusProfile"] = None,
        ranger_plugin_profile: Optional["_models.ClusterRangerPluginProfile"] = None,
        ranger_profile: Optional["_models.RangerProfile"] = None,
        script_action_profiles: Optional[List["_models.ScriptActionProfile"]] = None,
        secrets_profile: Optional["_models.SecretsProfile"] = None,
        trino_profile: Optional["_models.TrinoProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_configs_profiles: The service configs profiles.
        :paramtype service_configs_profiles:
         list[~azure.mgmt.hdinsightcontainers.models.ClusterServiceConfigsProfile]
        :keyword ssh_profile: Ssh profile for the cluster.
        :paramtype ssh_profile: ~azure.mgmt.hdinsightcontainers.models.SshProfile
        :keyword autoscale_profile: This is the Autoscale profile for the cluster. This will allow
         customer to create cluster enabled with Autoscale.
        :paramtype autoscale_profile: ~azure.mgmt.hdinsightcontainers.models.AutoscaleProfile
        :keyword authorization_profile: Authorization profile with details of AAD user Ids and group
         Ids authorized for data plane access.
        :paramtype authorization_profile: ~azure.mgmt.hdinsightcontainers.models.AuthorizationProfile
        :keyword log_analytics_profile: Cluster log analytics profile to enable or disable OMS agent
         for cluster.
        :paramtype log_analytics_profile:
         ~azure.mgmt.hdinsightcontainers.models.ClusterLogAnalyticsProfile
        :keyword prometheus_profile: Cluster Prometheus profile.
        :paramtype prometheus_profile: ~azure.mgmt.hdinsightcontainers.models.ClusterPrometheusProfile
        :keyword ranger_plugin_profile: Cluster Ranger plugin profile.
        :paramtype ranger_plugin_profile:
         ~azure.mgmt.hdinsightcontainers.models.ClusterRangerPluginProfile
        :keyword ranger_profile: The ranger cluster profile.
        :paramtype ranger_profile: ~azure.mgmt.hdinsightcontainers.models.RangerProfile
        :keyword script_action_profiles: The script action profile list.
        :paramtype script_action_profiles:
         list[~azure.mgmt.hdinsightcontainers.models.ScriptActionProfile]
        :keyword secrets_profile: The cluster secret profile.
        :paramtype secrets_profile: ~azure.mgmt.hdinsightcontainers.models.SecretsProfile
        :keyword trino_profile: Trino Cluster profile.
        :paramtype trino_profile: ~azure.mgmt.hdinsightcontainers.models.TrinoProfile
        """
        super().__init__(**kwargs)
        self.service_configs_profiles = service_configs_profiles
        self.ssh_profile = ssh_profile
        self.autoscale_profile = autoscale_profile
        self.authorization_profile = authorization_profile
        self.log_analytics_profile = log_analytics_profile
        self.prometheus_profile = prometheus_profile
        self.ranger_plugin_profile = ranger_plugin_profile
        self.ranger_profile = ranger_profile
        self.script_action_profiles = script_action_profiles
        self.secrets_profile = secrets_profile
        self.trino_profile = trino_profile
