// AUTOGENERATED FROM index-jis0208.txt, ORIGINAL COMMENT FOLLOWS:
//
// Any copyright is dedicated to the Public Domain.
// https://creativecommons.org/publicdomain/zero/1.0/
//
// For details on index index-jis0208.txt see the Encoding Standard
// https://encoding.spec.whatwg.org/
//
// Identifier: cbaa91f3deb7d0841faf5c33041fc15a285da0e87e64ab802c4bf04b7c4da861
// Date: 2016-01-20

#[allow(dead_code)] const X: u16 = 0xffff;

fn premap_forward(code: u16) -> u16 {
    match code {
        0...689 => code,
        690...1127 => X,
        1128...1219 => code - 438,
        1220...1409 => X,
        1410...7807 => code - 628,
        7808...8271 => X,
        8272...8647 => code - 1092,
        8648...10715 => X,
        _ => code - 3160,
    }
}

#[cfg(feature = "no-optimized-legacy-encoding")]
fn premap_backward(code: u16) -> u16 {
    match code {
        0...689 => code,
        690...781 => code + 438,
        782...7179 => code + 628,
        7180...7555 => code + 1092,
        _ => code.saturating_add(3160),
    }
}

const FORWARD_TABLE: &'static [u16] = &[
    12288, 12289, 12290, 65292, 65294, 12539, 65306, 65307, 65311, 65281,
    12443, 12444, 180, 65344, 168, 65342, 65507, 65343, 12541, 12542, 12445,
    12446, 12291, 20189, 12293, 12294, 12295, 12540, 8213, 8208, 65295, 65340,
    65374, 8741, 65372, 8230, 8229, 8216, 8217, 8220, 8221, 65288, 65289,
    12308, 12309, 65339, 65341, 65371, 65373, 12296, 12297, 12298, 12299,
    12300, 12301, 12302, 12303, 12304, 12305, 65291, 65293, 177, 215, 247,
    65309, 8800, 65308, 65310, 8806, 8807, 8734, 8756, 9794, 9792, 176, 8242,
    8243, 8451, 65509, 65284, 65504, 65505, 65285, 65283, 65286, 65290, 65312,
    167, 9734, 9733, 9675, 9679, 9678, 9671, 9670, 9633, 9632, 9651, 9650,
    9661, 9660, 8251, 12306, 8594, 8592, 8593, 8595, 12307, X, X, X, X, X, X,
    X, X, X, X, X, 8712, 8715, 8838, 8839, 8834, 8835, 8746, 8745, X, X, X, X,
    X, X, X, X, 8743, 8744, 65506, 8658, 8660, 8704, 8707, X, X, X, X, X, X, X,
    X, X, X, X, 8736, 8869, 8978, 8706, 8711, 8801, 8786, 8810, 8811, 8730,
    8765, 8733, 8757, 8747, 8748, X, X, X, X, X, X, X, 8491, 8240, 9839, 9837,
    9834, 8224, 8225, 182, X, X, X, X, 9711, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 65296, 65297, 65298, 65299, 65300, 65301, 65302, 65303, 65304,
    65305, X, X, X, X, X, X, X, 65313, 65314, 65315, 65316, 65317, 65318,
    65319, 65320, 65321, 65322, 65323, 65324, 65325, 65326, 65327, 65328,
    65329, 65330, 65331, 65332, 65333, 65334, 65335, 65336, 65337, 65338, X, X,
    X, X, X, X, 65345, 65346, 65347, 65348, 65349, 65350, 65351, 65352, 65353,
    65354, 65355, 65356, 65357, 65358, 65359, 65360, 65361, 65362, 65363,
    65364, 65365, 65366, 65367, 65368, 65369, 65370, X, X, X, X, 12353, 12354,
    12355, 12356, 12357, 12358, 12359, 12360, 12361, 12362, 12363, 12364,
    12365, 12366, 12367, 12368, 12369, 12370, 12371, 12372, 12373, 12374,
    12375, 12376, 12377, 12378, 12379, 12380, 12381, 12382, 12383, 12384,
    12385, 12386, 12387, 12388, 12389, 12390, 12391, 12392, 12393, 12394,
    12395, 12396, 12397, 12398, 12399, 12400, 12401, 12402, 12403, 12404,
    12405, 12406, 12407, 12408, 12409, 12410, 12411, 12412, 12413, 12414,
    12415, 12416, 12417, 12418, 12419, 12420, 12421, 12422, 12423, 12424,
    12425, 12426, 12427, 12428, 12429, 12430, 12431, 12432, 12433, 12434,
    12435, X, X, X, X, X, X, X, X, X, X, X, 12449, 12450, 12451, 12452, 12453,
    12454, 12455, 12456, 12457, 12458, 12459, 12460, 12461, 12462, 12463,
    12464, 12465, 12466, 12467, 12468, 12469, 12470, 12471, 12472, 12473,
    12474, 12475, 12476, 12477, 12478, 12479, 12480, 12481, 12482, 12483,
    12484, 12485, 12486, 12487, 12488, 12489, 12490, 12491, 12492, 12493,
    12494, 12495, 12496, 12497, 12498, 12499, 12500, 12501, 12502, 12503,
    12504, 12505, 12506, 12507, 12508, 12509, 12510, 12511, 12512, 12513,
    12514, 12515, 12516, 12517, 12518, 12519, 12520, 12521, 12522, 12523,
    12524, 12525, 12526, 12527, 12528, 12529, 12530, 12531, 12532, 12533,
    12534, X, X, X, X, X, X, X, X, 913, 914, 915, 916, 917, 918, 919, 920, 921,
    922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937,
    X, X, X, X, X, X, X, X, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954,
    955, 956, 957, 958, 959, 960, 961, 963, 964, 965, 966, 967, 968, 969, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 1040, 1041, 1042, 1043, 1044, 1045, 1025,
    1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057,
    1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069,
    1070, 1071, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1072, 1073, 1074,
    1075, 1076, 1077, 1105, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085,
    1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097,
    1098, 1099, 1100, 1101, 1102, 1103, X, X, X, X, X, X, X, X, X, X, X, X, X,
    9472, 9474, 9484, 9488, 9496, 9492, 9500, 9516, 9508, 9524, 9532, 9473,
    9475, 9487, 9491, 9499, 9495, 9507, 9523, 9515, 9531, 9547, 9504, 9519,
    9512, 9527, 9535, 9501, 9520, 9509, 9528, 9538, 9312, 9313, 9314, 9315,
    9316, 9317, 9318, 9319, 9320, 9321, 9322, 9323, 9324, 9325, 9326, 9327,
    9328, 9329, 9330, 9331, 8544, 8545, 8546, 8547, 8548, 8549, 8550, 8551,
    8552, 8553, X, 13129, 13076, 13090, 13133, 13080, 13095, 13059, 13110,
    13137, 13143, 13069, 13094, 13091, 13099, 13130, 13115, 13212, 13213,
    13214, 13198, 13199, 13252, 13217, X, X, X, X, X, X, X, X, 13179, 12317,
    12319, 8470, 13261, 8481, 12964, 12965, 12966, 12967, 12968, 12849, 12850,
    12857, 13182, 13181, 13180, 8786, 8801, 8747, 8750, 8721, 8730, 8869, 8736,
    8735, 8895, 8757, 8745, 8746, 20124, 21782, 23043, 38463, 21696, 24859,
    25384, 23030, 36898, 33909, 33564, 31312, 24746, 25569, 28197, 26093,
    33894, 33446, 39925, 26771, 22311, 26017, 25201, 23451, 22992, 34427,
    39156, 32098, 32190, 39822, 25110, 31903, 34999, 23433, 24245, 25353,
    26263, 26696, 38343, 38797, 26447, 20197, 20234, 20301, 20381, 20553,
    22258, 22839, 22996, 23041, 23561, 24799, 24847, 24944, 26131, 26885,
    28858, 30031, 30064, 31227, 32173, 32239, 32963, 33806, 34915, 35586,
    36949, 36986, 21307, 20117, 20133, 22495, 32946, 37057, 30959, 19968,
    22769, 28322, 36920, 31282, 33576, 33419, 39983, 20801, 21360, 21693,
    21729, 22240, 23035, 24341, 39154, 28139, 32996, 34093, 38498, 38512,
    38560, 38907, 21515, 21491, 23431, 28879, 32701, 36802, 38632, 21359,
    40284, 31418, 19985, 30867, 33276, 28198, 22040, 21764, 27421, 34074,
    39995, 23013, 21417, 28006, 29916, 38287, 22082, 20113, 36939, 38642,
    33615, 39180, 21473, 21942, 23344, 24433, 26144, 26355, 26628, 27704,
    27891, 27945, 29787, 30408, 31310, 38964, 33521, 34907, 35424, 37613,
    28082, 30123, 30410, 39365, 24742, 35585, 36234, 38322, 27022, 21421,
    20870, 22290, 22576, 22852, 23476, 24310, 24616, 25513, 25588, 27839,
    28436, 28814, 28948, 29017, 29141, 29503, 32257, 33398, 33489, 34199,
    36960, 37467, 40219, 22633, 26044, 27738, 29989, 20985, 22830, 22885,
    24448, 24540, 25276, 26106, 27178, 27431, 27572, 29579, 32705, 35158,
    40236, 40206, 40644, 23713, 27798, 33659, 20740, 23627, 25014, 33222,
    26742, 29281, 20057, 20474, 21368, 24681, 28201, 31311, 38899, 19979,
    21270, 20206, 20309, 20285, 20385, 20339, 21152, 21487, 22025, 22799,
    23233, 23478, 23521, 31185, 26247, 26524, 26550, 27468, 27827, 28779,
    29634, 31117, 31166, 31292, 31623, 33457, 33499, 33540, 33655, 33775,
    33747, 34662, 35506, 22057, 36008, 36838, 36942, 38686, 34442, 20420,
    23784, 25105, 29273, 30011, 33253, 33469, 34558, 36032, 38597, 39187,
    39381, 20171, 20250, 35299, 22238, 22602, 22730, 24315, 24555, 24618,
    24724, 24674, 25040, 25106, 25296, 25913, 39745, 26214, 26800, 28023,
    28784, 30028, 30342, 32117, 33445, 34809, 38283, 38542, 35997, 20977,
    21182, 22806, 21683, 23475, 23830, 24936, 27010, 28079, 30861, 33995,
    34903, 35442, 37799, 39608, 28012, 39336, 34521, 22435, 26623, 34510,
    37390, 21123, 22151, 21508, 24275, 25313, 25785, 26684, 26680, 27579,
    29554, 30906, 31339, 35226, 35282, 36203, 36611, 37101, 38307, 38548,
    38761, 23398, 23731, 27005, 38989, 38990, 25499, 31520, 27179, 27263,
    26806, 39949, 28511, 21106, 21917, 24688, 25324, 27963, 28167, 28369,
    33883, 35088, 36676, 19988, 39993, 21494, 26907, 27194, 38788, 26666,
    20828, 31427, 33970, 37340, 37772, 22107, 40232, 26658, 33541, 33841,
    31909, 21000, 33477, 29926, 20094, 20355, 20896, 23506, 21002, 21208,
    21223, 24059, 21914, 22570, 23014, 23436, 23448, 23515, 24178, 24185,
    24739, 24863, 24931, 25022, 25563, 25954, 26577, 26707, 26874, 27454,
    27475, 27735, 28450, 28567, 28485, 29872, 29976, 30435, 30475, 31487,
    31649, 31777, 32233, 32566, 32752, 32925, 33382, 33694, 35251, 35532,
    36011, 36996, 37969, 38291, 38289, 38306, 38501, 38867, 39208, 33304,
    20024, 21547, 23736, 24012, 29609, 30284, 30524, 23721, 32747, 36107,
    38593, 38929, 38996, 39000, 20225, 20238, 21361, 21916, 22120, 22522,
    22855, 23305, 23492, 23696, 24076, 24190, 24524, 25582, 26426, 26071,
    26082, 26399, 26827, 26820, 27231, 24112, 27589, 27671, 27773, 30079,
    31048, 23395, 31232, 32000, 24509, 35215, 35352, 36020, 36215, 36556,
    36637, 39138, 39438, 39740, 20096, 20605, 20736, 22931, 23452, 25135,
    25216, 25836, 27450, 29344, 30097, 31047, 32681, 34811, 35516, 35696,
    25516, 33738, 38816, 21513, 21507, 21931, 26708, 27224, 35440, 30759,
    26485, 40653, 21364, 23458, 33050, 34384, 36870, 19992, 20037, 20167,
    20241, 21450, 21560, 23470, 24339, 24613, 25937, 26429, 27714, 27762,
    27875, 28792, 29699, 31350, 31406, 31496, 32026, 31998, 32102, 26087,
    29275, 21435, 23621, 24040, 25298, 25312, 25369, 28192, 34394, 35377,
    36317, 37624, 28417, 31142, 39770, 20136, 20139, 20140, 20379, 20384,
    20689, 20807, 31478, 20849, 20982, 21332, 21281, 21375, 21483, 21932,
    22659, 23777, 24375, 24394, 24623, 24656, 24685, 25375, 25945, 27211,
    27841, 29378, 29421, 30703, 33016, 33029, 33288, 34126, 37111, 37857,
    38911, 39255, 39514, 20208, 20957, 23597, 26241, 26989, 23616, 26354,
    26997, 29577, 26704, 31873, 20677, 21220, 22343, 24062, 37670, 26020,
    27427, 27453, 29748, 31105, 31165, 31563, 32202, 33465, 33740, 34943,
    35167, 35641, 36817, 37329, 21535, 37504, 20061, 20534, 21477, 21306,
    29399, 29590, 30697, 33510, 36527, 39366, 39368, 39378, 20855, 24858,
    34398, 21936, 31354, 20598, 23507, 36935, 38533, 20018, 27355, 37351,
    23633, 23624, 25496, 31391, 27795, 38772, 36705, 31402, 29066, 38536,
    31874, 26647, 32368, 26705, 37740, 21234, 21531, 34219, 35347, 32676,
    36557, 37089, 21350, 34952, 31041, 20418, 20670, 21009, 20804, 21843,
    22317, 29674, 22411, 22865, 24418, 24452, 24693, 24950, 24935, 25001,
    25522, 25658, 25964, 26223, 26690, 28179, 30054, 31293, 31995, 32076,
    32153, 32331, 32619, 33550, 33610, 34509, 35336, 35427, 35686, 36605,
    38938, 40335, 33464, 36814, 39912, 21127, 25119, 25731, 28608, 38553,
    26689, 20625, 27424, 27770, 28500, 31348, 32080, 34880, 35363, 26376,
    20214, 20537, 20518, 20581, 20860, 21048, 21091, 21927, 22287, 22533,
    23244, 24314, 25010, 25080, 25331, 25458, 26908, 27177, 29309, 29356,
    29486, 30740, 30831, 32121, 30476, 32937, 35211, 35609, 36066, 36562,
    36963, 37749, 38522, 38997, 39443, 40568, 20803, 21407, 21427, 24187,
    24358, 28187, 28304, 29572, 29694, 32067, 33335, 35328, 35578, 38480,
    20046, 20491, 21476, 21628, 22266, 22993, 23396, 24049, 24235, 24359,
    25144, 25925, 26543, 28246, 29392, 31946, 34996, 32929, 32993, 33776,
    34382, 35463, 36328, 37431, 38599, 39015, 40723, 20116, 20114, 20237,
    21320, 21577, 21566, 23087, 24460, 24481, 24735, 26791, 27278, 29786,
    30849, 35486, 35492, 35703, 37264, 20062, 39881, 20132, 20348, 20399,
    20505, 20502, 20809, 20844, 21151, 21177, 21246, 21402, 21475, 21521,
    21518, 21897, 22353, 22434, 22909, 23380, 23389, 23439, 24037, 24039,
    24055, 24184, 24195, 24218, 24247, 24344, 24658, 24908, 25239, 25304,
    25511, 25915, 26114, 26179, 26356, 26477, 26657, 26775, 27083, 27743,
    27946, 28009, 28207, 28317, 30002, 30343, 30828, 31295, 31968, 32005,
    32024, 32094, 32177, 32789, 32771, 32943, 32945, 33108, 33167, 33322,
    33618, 34892, 34913, 35611, 36002, 36092, 37066, 37237, 37489, 30783,
    37628, 38308, 38477, 38917, 39321, 39640, 40251, 21083, 21163, 21495,
    21512, 22741, 25335, 28640, 35946, 36703, 40633, 20811, 21051, 21578,
    22269, 31296, 37239, 40288, 40658, 29508, 28425, 33136, 29969, 24573,
    24794, 39592, 29403, 36796, 27492, 38915, 20170, 22256, 22372, 22718,
    23130, 24680, 25031, 26127, 26118, 26681, 26801, 28151, 30165, 32058,
    33390, 39746, 20123, 20304, 21449, 21766, 23919, 24038, 24046, 26619,
    27801, 29811, 30722, 35408, 37782, 35039, 22352, 24231, 25387, 20661,
    20652, 20877, 26368, 21705, 22622, 22971, 23472, 24425, 25165, 25505,
    26685, 27507, 28168, 28797, 37319, 29312, 30741, 30758, 31085, 25998,
    32048, 33756, 35009, 36617, 38555, 21092, 22312, 26448, 32618, 36001,
    20916, 22338, 38442, 22586, 27018, 32948, 21682, 23822, 22524, 30869,
    40442, 20316, 21066, 21643, 25662, 26152, 26388, 26613, 31364, 31574,
    32034, 37679, 26716, 39853, 31545, 21273, 20874, 21047, 23519, 25334,
    25774, 25830, 26413, 27578, 34217, 38609, 30352, 39894, 25420, 37638,
    39851, 30399, 26194, 19977, 20632, 21442, 23665, 24808, 25746, 25955,
    26719, 29158, 29642, 29987, 31639, 32386, 34453, 35715, 36059, 37240,
    39184, 26028, 26283, 27531, 20181, 20180, 20282, 20351, 21050, 21496,
    21490, 21987, 22235, 22763, 22987, 22985, 23039, 23376, 23629, 24066,
    24107, 24535, 24605, 25351, 25903, 23388, 26031, 26045, 26088, 26525,
    27490, 27515, 27663, 29509, 31049, 31169, 31992, 32025, 32043, 32930,
    33026, 33267, 35222, 35422, 35433, 35430, 35468, 35566, 36039, 36060,
    38604, 39164, 27503, 20107, 20284, 20365, 20816, 23383, 23546, 24904,
    25345, 26178, 27425, 28363, 27835, 29246, 29885, 30164, 30913, 31034,
    32780, 32819, 33258, 33940, 36766, 27728, 40575, 24335, 35672, 40235,
    31482, 36600, 23437, 38635, 19971, 21489, 22519, 22833, 23241, 23460,
    24713, 28287, 28422, 30142, 36074, 23455, 34048, 31712, 20594, 26612,
    33437, 23649, 34122, 32286, 33294, 20889, 23556, 25448, 36198, 26012,
    29038, 31038, 32023, 32773, 35613, 36554, 36974, 34503, 37034, 20511,
    21242, 23610, 26451, 28796, 29237, 37196, 37320, 37675, 33509, 23490,
    24369, 24825, 20027, 21462, 23432, 25163, 26417, 27530, 29417, 29664,
    31278, 33131, 36259, 37202, 39318, 20754, 21463, 21610, 23551, 25480,
    27193, 32172, 38656, 22234, 21454, 21608, 23447, 23601, 24030, 20462,
    24833, 25342, 27954, 31168, 31179, 32066, 32333, 32722, 33261, 33311,
    33936, 34886, 35186, 35728, 36468, 36655, 36913, 37195, 37228, 38598,
    37276, 20160, 20303, 20805, 21313, 24467, 25102, 26580, 27713, 28171,
    29539, 32294, 37325, 37507, 21460, 22809, 23487, 28113, 31069, 32302,
    31899, 22654, 29087, 20986, 34899, 36848, 20426, 23803, 26149, 30636,
    31459, 33308, 39423, 20934, 24490, 26092, 26991, 27529, 28147, 28310,
    28516, 30462, 32020, 24033, 36981, 37255, 38918, 20966, 21021, 25152,
    26257, 26329, 28186, 24246, 32210, 32626, 26360, 34223, 34295, 35576,
    21161, 21465, 22899, 24207, 24464, 24661, 37604, 38500, 20663, 20767,
    21213, 21280, 21319, 21484, 21736, 21830, 21809, 22039, 22888, 22974,
    23100, 23477, 23558, 23567, 23569, 23578, 24196, 24202, 24288, 24432,
    25215, 25220, 25307, 25484, 25463, 26119, 26124, 26157, 26230, 26494,
    26786, 27167, 27189, 27836, 28040, 28169, 28248, 28988, 28966, 29031,
    30151, 30465, 30813, 30977, 31077, 31216, 31456, 31505, 31911, 32057,
    32918, 33750, 33931, 34121, 34909, 35059, 35359, 35388, 35412, 35443,
    35937, 36062, 37284, 37478, 37758, 37912, 38556, 38808, 19978, 19976,
    19998, 20055, 20887, 21104, 22478, 22580, 22732, 23330, 24120, 24773,
    25854, 26465, 26454, 27972, 29366, 30067, 31331, 33976, 35698, 37304,
    37664, 22065, 22516, 39166, 25325, 26893, 27542, 29165, 32340, 32887,
    33394, 35302, 39135, 34645, 36785, 23611, 20280, 20449, 20405, 21767,
    23072, 23517, 23529, 24515, 24910, 25391, 26032, 26187, 26862, 27035,
    28024, 28145, 30003, 30137, 30495, 31070, 31206, 32051, 33251, 33455,
    34218, 35242, 35386, 36523, 36763, 36914, 37341, 38663, 20154, 20161,
    20995, 22645, 22764, 23563, 29978, 23613, 33102, 35338, 36805, 38499,
    38765, 31525, 35535, 38920, 37218, 22259, 21416, 36887, 21561, 22402,
    24101, 25512, 27700, 28810, 30561, 31883, 32736, 34928, 36930, 37204,
    37648, 37656, 38543, 29790, 39620, 23815, 23913, 25968, 26530, 36264,
    38619, 25454, 26441, 26905, 33733, 38935, 38592, 35070, 28548, 25722,
    23544, 19990, 28716, 30045, 26159, 20932, 21046, 21218, 22995, 24449,
    24615, 25104, 25919, 25972, 26143, 26228, 26866, 26646, 27491, 28165,
    29298, 29983, 30427, 31934, 32854, 22768, 35069, 35199, 35488, 35475,
    35531, 36893, 37266, 38738, 38745, 25993, 31246, 33030, 38587, 24109,
    24796, 25114, 26021, 26132, 26512, 30707, 31309, 31821, 32318, 33034,
    36012, 36196, 36321, 36447, 30889, 20999, 25305, 25509, 25666, 25240,
    35373, 31363, 31680, 35500, 38634, 32118, 33292, 34633, 20185, 20808,
    21315, 21344, 23459, 23554, 23574, 24029, 25126, 25159, 25776, 26643,
    26676, 27849, 27973, 27927, 26579, 28508, 29006, 29053, 26059, 31359,
    31661, 32218, 32330, 32680, 33146, 33307, 33337, 34214, 35438, 36046,
    36341, 36984, 36983, 37549, 37521, 38275, 39854, 21069, 21892, 28472,
    28982, 20840, 31109, 32341, 33203, 31950, 22092, 22609, 23720, 25514,
    26366, 26365, 26970, 29401, 30095, 30094, 30990, 31062, 31199, 31895,
    32032, 32068, 34311, 35380, 38459, 36961, 40736, 20711, 21109, 21452,
    21474, 20489, 21930, 22766, 22863, 29245, 23435, 23652, 21277, 24803,
    24819, 25436, 25475, 25407, 25531, 25805, 26089, 26361, 24035, 27085,
    27133, 28437, 29157, 20105, 30185, 30456, 31379, 31967, 32207, 32156,
    32865, 33609, 33624, 33900, 33980, 34299, 35013, 36208, 36865, 36973,
    37783, 38684, 39442, 20687, 22679, 24974, 33235, 34101, 36104, 36896,
    20419, 20596, 21063, 21363, 24687, 25417, 26463, 28204, 36275, 36895,
    20439, 23646, 36042, 26063, 32154, 21330, 34966, 20854, 25539, 23384,
    23403, 23562, 25613, 26449, 36956, 20182, 22810, 22826, 27760, 35409,
    21822, 22549, 22949, 24816, 25171, 26561, 33333, 26965, 38464, 39364,
    39464, 20307, 22534, 23550, 32784, 23729, 24111, 24453, 24608, 24907,
    25140, 26367, 27888, 28382, 32974, 33151, 33492, 34955, 36024, 36864,
    36910, 38538, 40667, 39899, 20195, 21488, 22823, 31532, 37261, 38988,
    40441, 28381, 28711, 21331, 21828, 23429, 25176, 25246, 25299, 27810,
    28655, 29730, 35351, 37944, 28609, 35582, 33592, 20967, 34552, 21482,
    21481, 20294, 36948, 36784, 22890, 33073, 24061, 31466, 36799, 26842,
    35895, 29432, 40008, 27197, 35504, 20025, 21336, 22022, 22374, 25285,
    25506, 26086, 27470, 28129, 28251, 28845, 30701, 31471, 31658, 32187,
    32829, 32966, 34507, 35477, 37723, 22243, 22727, 24382, 26029, 26262,
    27264, 27573, 30007, 35527, 20516, 30693, 22320, 24347, 24677, 26234,
    27744, 30196, 31258, 32622, 33268, 34584, 36933, 39347, 31689, 30044,
    31481, 31569, 33988, 36880, 31209, 31378, 33590, 23265, 30528, 20013,
    20210, 23449, 24544, 25277, 26172, 26609, 27880, 34411, 34935, 35387,
    37198, 37619, 39376, 27159, 28710, 29482, 33511, 33879, 36015, 19969,
    20806, 20939, 21899, 23541, 24086, 24115, 24193, 24340, 24373, 24427,
    24500, 25074, 25361, 26274, 26397, 28526, 29266, 30010, 30522, 32884,
    33081, 33144, 34678, 35519, 35548, 36229, 36339, 37530, 38263, 38914,
    40165, 21189, 25431, 30452, 26389, 27784, 29645, 36035, 37806, 38515,
    27941, 22684, 26894, 27084, 36861, 37786, 30171, 36890, 22618, 26626,
    25524, 27131, 20291, 28460, 26584, 36795, 34086, 32180, 37716, 26943,
    28528, 22378, 22775, 23340, 32044, 29226, 21514, 37347, 40372, 20141,
    20302, 20572, 20597, 21059, 35998, 21576, 22564, 23450, 24093, 24213,
    24237, 24311, 24351, 24716, 25269, 25402, 25552, 26799, 27712, 30855,
    31118, 31243, 32224, 33351, 35330, 35558, 36420, 36883, 37048, 37165,
    37336, 40718, 27877, 25688, 25826, 25973, 28404, 30340, 31515, 36969,
    37841, 28346, 21746, 24505, 25764, 36685, 36845, 37444, 20856, 22635,
    22825, 23637, 24215, 28155, 32399, 29980, 36028, 36578, 39003, 28857,
    20253, 27583, 28593, 30000, 38651, 20814, 21520, 22581, 22615, 22956,
    23648, 24466, 26007, 26460, 28193, 30331, 33759, 36077, 36884, 37117,
    37709, 30757, 30778, 21162, 24230, 22303, 22900, 24594, 20498, 20826,
    20908, 20941, 20992, 21776, 22612, 22616, 22871, 23445, 23798, 23947,
    24764, 25237, 25645, 26481, 26691, 26812, 26847, 30423, 28120, 28271,
    28059, 28783, 29128, 24403, 30168, 31095, 31561, 31572, 31570, 31958,
    32113, 21040, 33891, 34153, 34276, 35342, 35588, 35910, 36367, 36867,
    36879, 37913, 38518, 38957, 39472, 38360, 20685, 21205, 21516, 22530,
    23566, 24999, 25758, 27934, 30643, 31461, 33012, 33796, 36947, 37509,
    23776, 40199, 21311, 24471, 24499, 28060, 29305, 30563, 31167, 31716,
    27602, 29420, 35501, 26627, 27233, 20984, 31361, 26932, 23626, 40182,
    33515, 23493, 37193, 28702, 22136, 23663, 24775, 25958, 27788, 35930,
    36929, 38931, 21585, 26311, 37389, 22856, 37027, 20869, 20045, 20970,
    34201, 35598, 28760, 25466, 37707, 26978, 39348, 32260, 30071, 21335,
    26976, 36575, 38627, 27741, 20108, 23612, 24336, 36841, 21250, 36049,
    32905, 34425, 24319, 26085, 20083, 20837, 22914, 23615, 38894, 20219,
    22922, 24525, 35469, 28641, 31152, 31074, 23527, 33905, 29483, 29105,
    24180, 24565, 25467, 25754, 29123, 31896, 20035, 24316, 20043, 22492,
    22178, 24745, 28611, 32013, 33021, 33075, 33215, 36786, 35223, 34468,
    24052, 25226, 25773, 35207, 26487, 27874, 27966, 29750, 30772, 23110,
    32629, 33453, 39340, 20467, 24259, 25309, 25490, 25943, 26479, 30403,
    29260, 32972, 32954, 36649, 37197, 20493, 22521, 23186, 26757, 26995,
    29028, 29437, 36023, 22770, 36064, 38506, 36889, 34687, 31204, 30695,
    33833, 20271, 21093, 21338, 25293, 26575, 27850, 30333, 31636, 31893,
    33334, 34180, 36843, 26333, 28448, 29190, 32283, 33707, 39361, 40614,
    20989, 31665, 30834, 31672, 32903, 31560, 27368, 24161, 32908, 30033,
    30048, 20843, 37474, 28300, 30330, 37271, 39658, 20240, 32624, 25244,
    31567, 38309, 40169, 22138, 22617, 34532, 38588, 20276, 21028, 21322,
    21453, 21467, 24070, 25644, 26001, 26495, 27710, 27726, 29256, 29359,
    29677, 30036, 32321, 33324, 34281, 36009, 31684, 37318, 29033, 38930,
    39151, 25405, 26217, 30058, 30436, 30928, 34115, 34542, 21290, 21329,
    21542, 22915, 24199, 24444, 24754, 25161, 25209, 25259, 26000, 27604,
    27852, 30130, 30382, 30865, 31192, 32203, 32631, 32933, 34987, 35513,
    36027, 36991, 38750, 39131, 27147, 31800, 20633, 23614, 24494, 26503,
    27608, 29749, 30473, 32654, 40763, 26570, 31255, 21305, 30091, 39661,
    24422, 33181, 33777, 32920, 24380, 24517, 30050, 31558, 36924, 26727,
    23019, 23195, 32016, 30334, 35628, 20469, 24426, 27161, 27703, 28418,
    29922, 31080, 34920, 35413, 35961, 24287, 25551, 30149, 31186, 33495,
    37672, 37618, 33948, 34541, 39981, 21697, 24428, 25996, 27996, 28693,
    36007, 36051, 38971, 25935, 29942, 19981, 20184, 22496, 22827, 23142,
    23500, 20904, 24067, 24220, 24598, 25206, 25975, 26023, 26222, 28014,
    29238, 31526, 33104, 33178, 33433, 35676, 36000, 36070, 36212, 38428,
    38468, 20398, 25771, 27494, 33310, 33889, 34154, 37096, 23553, 26963,
    39080, 33914, 34135, 20239, 21103, 24489, 24133, 26381, 31119, 33145,
    35079, 35206, 28149, 24343, 25173, 27832, 20175, 29289, 39826, 20998,
    21563, 22132, 22707, 24996, 25198, 28954, 22894, 31881, 31966, 32027,
    38640, 25991, 32862, 19993, 20341, 20853, 22592, 24163, 24179, 24330,
    26564, 20006, 34109, 38281, 38491, 31859, 38913, 20731, 22721, 30294,
    30887, 21029, 30629, 34065, 31622, 20559, 22793, 29255, 31687, 32232,
    36794, 36820, 36941, 20415, 21193, 23081, 24321, 38829, 20445, 33303,
    37610, 22275, 25429, 27497, 29995, 35036, 36628, 31298, 21215, 22675,
    24917, 25098, 26286, 27597, 31807, 33769, 20515, 20472, 21253, 21574,
    22577, 22857, 23453, 23792, 23791, 23849, 24214, 25265, 25447, 25918,
    26041, 26379, 27861, 27873, 28921, 30770, 32299, 32990, 33459, 33804,
    34028, 34562, 35090, 35370, 35914, 37030, 37586, 39165, 40179, 40300,
    20047, 20129, 20621, 21078, 22346, 22952, 24125, 24536, 24537, 25151,
    26292, 26395, 26576, 26834, 20882, 32033, 32938, 33192, 35584, 35980,
    36031, 37502, 38450, 21536, 38956, 21271, 20693, 21340, 22696, 25778,
    26420, 29287, 30566, 31302, 37350, 21187, 27809, 27526, 22528, 24140,
    22868, 26412, 32763, 20961, 30406, 25705, 30952, 39764, 40635, 22475,
    22969, 26151, 26522, 27598, 21737, 27097, 24149, 33180, 26517, 39850,
    26622, 40018, 26717, 20134, 20451, 21448, 25273, 26411, 27819, 36804,
    20397, 32365, 40639, 19975, 24930, 28288, 28459, 34067, 21619, 26410,
    39749, 24051, 31637, 23724, 23494, 34588, 28234, 34001, 31252, 33032,
    22937, 31885, 27665, 30496, 21209, 22818, 28961, 29279, 30683, 38695,
    40289, 26891, 23167, 23064, 20901, 21517, 21629, 26126, 30431, 36855,
    37528, 40180, 23018, 29277, 28357, 20813, 26825, 32191, 32236, 38754,
    40634, 25720, 27169, 33538, 22916, 23391, 27611, 29467, 30450, 32178,
    32791, 33945, 20786, 26408, 40665, 30446, 26466, 21247, 39173, 23588,
    25147, 31870, 36016, 21839, 24758, 32011, 38272, 21249, 20063, 20918,
    22812, 29242, 32822, 37326, 24357, 30690, 21380, 24441, 32004, 34220,
    35379, 36493, 38742, 26611, 34222, 37971, 24841, 24840, 27833, 30290,
    35565, 36664, 21807, 20305, 20778, 21191, 21451, 23461, 24189, 24736,
    24962, 25558, 26377, 26586, 28263, 28044, 29494, 29495, 30001, 31056,
    35029, 35480, 36938, 37009, 37109, 38596, 34701, 22805, 20104, 20313,
    19982, 35465, 36671, 38928, 20653, 24188, 22934, 23481, 24248, 25562,
    25594, 25793, 26332, 26954, 27096, 27915, 28342, 29076, 29992, 31407,
    32650, 32768, 33865, 33993, 35201, 35617, 36362, 36965, 38525, 39178,
    24958, 25233, 27442, 27779, 28020, 32716, 32764, 28096, 32645, 34746,
    35064, 26469, 33713, 38972, 38647, 27931, 32097, 33853, 37226, 20081,
    21365, 23888, 27396, 28651, 34253, 34349, 35239, 21033, 21519, 23653,
    26446, 26792, 29702, 29827, 30178, 35023, 35041, 37324, 38626, 38520,
    24459, 29575, 31435, 33870, 25504, 30053, 21129, 27969, 28316, 29705,
    30041, 30827, 31890, 38534, 31452, 40845, 20406, 24942, 26053, 34396,
    20102, 20142, 20698, 20001, 20940, 23534, 26009, 26753, 28092, 29471,
    30274, 30637, 31260, 31975, 33391, 35538, 36988, 37327, 38517, 38936,
    21147, 32209, 20523, 21400, 26519, 28107, 29136, 29747, 33256, 36650,
    38563, 40023, 40607, 29792, 22593, 28057, 32047, 39006, 20196, 20278,
    20363, 20919, 21169, 23994, 24604, 29618, 31036, 33491, 37428, 38583,
    38646, 38666, 40599, 40802, 26278, 27508, 21015, 21155, 28872, 35010,
    24265, 24651, 24976, 28451, 29001, 31806, 32244, 32879, 34030, 36899,
    37676, 21570, 39791, 27347, 28809, 36034, 36335, 38706, 21172, 23105,
    24266, 24324, 26391, 27004, 27028, 28010, 28431, 29282, 29436, 31725,
    32769, 32894, 34635, 37070, 20845, 40595, 31108, 32907, 37682, 35542,
    20525, 21644, 35441, 27498, 36036, 33031, 24785, 26528, 40434, 20121,
    20120, 39952, 35435, 34241, 34152, 26880, 28286, 30871, 33109, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 24332, 19984, 19989, 20010,
    20017, 20022, 20028, 20031, 20034, 20054, 20056, 20098, 20101, 35947,
    20106, 33298, 24333, 20110, 20126, 20127, 20128, 20130, 20144, 20147,
    20150, 20174, 20173, 20164, 20166, 20162, 20183, 20190, 20205, 20191,
    20215, 20233, 20314, 20272, 20315, 20317, 20311, 20295, 20342, 20360,
    20367, 20376, 20347, 20329, 20336, 20369, 20335, 20358, 20374, 20760,
    20436, 20447, 20430, 20440, 20443, 20433, 20442, 20432, 20452, 20453,
    20506, 20520, 20500, 20522, 20517, 20485, 20252, 20470, 20513, 20521,
    20524, 20478, 20463, 20497, 20486, 20547, 20551, 26371, 20565, 20560,
    20552, 20570, 20566, 20588, 20600, 20608, 20634, 20613, 20660, 20658,
    20681, 20682, 20659, 20674, 20694, 20702, 20709, 20717, 20707, 20718,
    20729, 20725, 20745, 20737, 20738, 20758, 20757, 20756, 20762, 20769,
    20794, 20791, 20796, 20795, 20799, 20800, 20818, 20812, 20820, 20834,
    31480, 20841, 20842, 20846, 20864, 20866, 22232, 20876, 20873, 20879,
    20881, 20883, 20885, 20886, 20900, 20902, 20898, 20905, 20906, 20907,
    20915, 20913, 20914, 20912, 20917, 20925, 20933, 20937, 20955, 20960,
    34389, 20969, 20973, 20976, 20981, 20990, 20996, 21003, 21012, 21006,
    21031, 21034, 21038, 21043, 21049, 21071, 21060, 21067, 21068, 21086,
    21076, 21098, 21108, 21097, 21107, 21119, 21117, 21133, 21140, 21138,
    21105, 21128, 21137, 36776, 36775, 21164, 21165, 21180, 21173, 21185,
    21197, 21207, 21214, 21219, 21222, 39149, 21216, 21235, 21237, 21240,
    21241, 21254, 21256, 30008, 21261, 21264, 21263, 21269, 21274, 21283,
    21295, 21297, 21299, 21304, 21312, 21318, 21317, 19991, 21321, 21325,
    20950, 21342, 21353, 21358, 22808, 21371, 21367, 21378, 21398, 21408,
    21414, 21413, 21422, 21424, 21430, 21443, 31762, 38617, 21471, 26364,
    29166, 21486, 21480, 21485, 21498, 21505, 21565, 21568, 21548, 21549,
    21564, 21550, 21558, 21545, 21533, 21582, 21647, 21621, 21646, 21599,
    21617, 21623, 21616, 21650, 21627, 21632, 21622, 21636, 21648, 21638,
    21703, 21666, 21688, 21669, 21676, 21700, 21704, 21672, 21675, 21698,
    21668, 21694, 21692, 21720, 21733, 21734, 21775, 21780, 21757, 21742,
    21741, 21754, 21730, 21817, 21824, 21859, 21836, 21806, 21852, 21829,
    21846, 21847, 21816, 21811, 21853, 21913, 21888, 21679, 21898, 21919,
    21883, 21886, 21912, 21918, 21934, 21884, 21891, 21929, 21895, 21928,
    21978, 21957, 21983, 21956, 21980, 21988, 21972, 22036, 22007, 22038,
    22014, 22013, 22043, 22009, 22094, 22096, 29151, 22068, 22070, 22066,
    22072, 22123, 22116, 22063, 22124, 22122, 22150, 22144, 22154, 22176,
    22164, 22159, 22181, 22190, 22198, 22196, 22210, 22204, 22209, 22211,
    22208, 22216, 22222, 22225, 22227, 22231, 22254, 22265, 22272, 22271,
    22276, 22281, 22280, 22283, 22285, 22291, 22296, 22294, 21959, 22300,
    22310, 22327, 22328, 22350, 22331, 22336, 22351, 22377, 22464, 22408,
    22369, 22399, 22409, 22419, 22432, 22451, 22436, 22442, 22448, 22467,
    22470, 22484, 22482, 22483, 22538, 22486, 22499, 22539, 22553, 22557,
    22642, 22561, 22626, 22603, 22640, 27584, 22610, 22589, 22649, 22661,
    22713, 22687, 22699, 22714, 22750, 22715, 22712, 22702, 22725, 22739,
    22737, 22743, 22745, 22744, 22757, 22748, 22756, 22751, 22767, 22778,
    22777, 22779, 22780, 22781, 22786, 22794, 22800, 22811, 26790, 22821,
    22828, 22829, 22834, 22840, 22846, 31442, 22869, 22864, 22862, 22874,
    22872, 22882, 22880, 22887, 22892, 22889, 22904, 22913, 22941, 20318,
    20395, 22947, 22962, 22982, 23016, 23004, 22925, 23001, 23002, 23077,
    23071, 23057, 23068, 23049, 23066, 23104, 23148, 23113, 23093, 23094,
    23138, 23146, 23194, 23228, 23230, 23243, 23234, 23229, 23267, 23255,
    23270, 23273, 23254, 23290, 23291, 23308, 23307, 23318, 23346, 23248,
    23338, 23350, 23358, 23363, 23365, 23360, 23377, 23381, 23386, 23387,
    23397, 23401, 23408, 23411, 23413, 23416, 25992, 23418, 23424, 23427,
    23462, 23480, 23491, 23495, 23497, 23508, 23504, 23524, 23526, 23522,
    23518, 23525, 23531, 23536, 23542, 23539, 23557, 23559, 23560, 23565,
    23571, 23584, 23586, 23592, 23608, 23609, 23617, 23622, 23630, 23635,
    23632, 23631, 23409, 23660, 23662, 20066, 23670, 23673, 23692, 23697,
    23700, 22939, 23723, 23739, 23734, 23740, 23735, 23749, 23742, 23751,
    23769, 23785, 23805, 23802, 23789, 23948, 23786, 23819, 23829, 23831,
    23900, 23839, 23835, 23825, 23828, 23842, 23834, 23833, 23832, 23884,
    23890, 23886, 23883, 23916, 23923, 23926, 23943, 23940, 23938, 23970,
    23965, 23980, 23982, 23997, 23952, 23991, 23996, 24009, 24013, 24019,
    24018, 24022, 24027, 24043, 24050, 24053, 24075, 24090, 24089, 24081,
    24091, 24118, 24119, 24132, 24131, 24128, 24142, 24151, 24148, 24159,
    24162, 24164, 24135, 24181, 24182, 24186, 40636, 24191, 24224, 24257,
    24258, 24264, 24272, 24271, 24278, 24291, 24285, 24282, 24283, 24290,
    24289, 24296, 24297, 24300, 24305, 24307, 24304, 24308, 24312, 24318,
    24323, 24329, 24413, 24412, 24331, 24337, 24342, 24361, 24365, 24376,
    24385, 24392, 24396, 24398, 24367, 24401, 24406, 24407, 24409, 24417,
    24429, 24435, 24439, 24451, 24450, 24447, 24458, 24456, 24465, 24455,
    24478, 24473, 24472, 24480, 24488, 24493, 24508, 24534, 24571, 24548,
    24568, 24561, 24541, 24755, 24575, 24609, 24672, 24601, 24592, 24617,
    24590, 24625, 24603, 24597, 24619, 24614, 24591, 24634, 24666, 24641,
    24682, 24695, 24671, 24650, 24646, 24653, 24675, 24643, 24676, 24642,
    24684, 24683, 24665, 24705, 24717, 24807, 24707, 24730, 24708, 24731,
    24726, 24727, 24722, 24743, 24715, 24801, 24760, 24800, 24787, 24756,
    24560, 24765, 24774, 24757, 24792, 24909, 24853, 24838, 24822, 24823,
    24832, 24820, 24826, 24835, 24865, 24827, 24817, 24845, 24846, 24903,
    24894, 24872, 24871, 24906, 24895, 24892, 24876, 24884, 24893, 24898,
    24900, 24947, 24951, 24920, 24921, 24922, 24939, 24948, 24943, 24933,
    24945, 24927, 24925, 24915, 24949, 24985, 24982, 24967, 25004, 24980,
    24986, 24970, 24977, 25003, 25006, 25036, 25034, 25033, 25079, 25032,
    25027, 25030, 25018, 25035, 32633, 25037, 25062, 25059, 25078, 25082,
    25076, 25087, 25085, 25084, 25086, 25088, 25096, 25097, 25101, 25100,
    25108, 25115, 25118, 25121, 25130, 25134, 25136, 25138, 25139, 25153,
    25166, 25182, 25187, 25179, 25184, 25192, 25212, 25218, 25225, 25214,
    25234, 25235, 25238, 25300, 25219, 25236, 25303, 25297, 25275, 25295,
    25343, 25286, 25812, 25288, 25308, 25292, 25290, 25282, 25287, 25243,
    25289, 25356, 25326, 25329, 25383, 25346, 25352, 25327, 25333, 25424,
    25406, 25421, 25628, 25423, 25494, 25486, 25472, 25515, 25462, 25507,
    25487, 25481, 25503, 25525, 25451, 25449, 25534, 25577, 25536, 25542,
    25571, 25545, 25554, 25590, 25540, 25622, 25652, 25606, 25619, 25638,
    25654, 25885, 25623, 25640, 25615, 25703, 25711, 25718, 25678, 25898,
    25749, 25747, 25765, 25769, 25736, 25788, 25818, 25810, 25797, 25799,
    25787, 25816, 25794, 25841, 25831, 33289, 25824, 25825, 25260, 25827,
    25839, 25900, 25846, 25844, 25842, 25850, 25856, 25853, 25880, 25884,
    25861, 25892, 25891, 25899, 25908, 25909, 25911, 25910, 25912, 30027,
    25928, 25942, 25941, 25933, 25944, 25950, 25949, 25970, 25976, 25986,
    25987, 35722, 26011, 26015, 26027, 26039, 26051, 26054, 26049, 26052,
    26060, 26066, 26075, 26073, 26080, 26081, 26097, 26482, 26122, 26115,
    26107, 26483, 26165, 26166, 26164, 26140, 26191, 26180, 26185, 26177,
    26206, 26205, 26212, 26215, 26216, 26207, 26210, 26224, 26243, 26248,
    26254, 26249, 26244, 26264, 26269, 26305, 26297, 26313, 26302, 26300,
    26308, 26296, 26326, 26330, 26336, 26175, 26342, 26345, 26352, 26357,
    26359, 26383, 26390, 26398, 26406, 26407, 38712, 26414, 26431, 26422,
    26433, 26424, 26423, 26438, 26462, 26464, 26457, 26467, 26468, 26505,
    26480, 26537, 26492, 26474, 26508, 26507, 26534, 26529, 26501, 26551,
    26607, 26548, 26604, 26547, 26601, 26552, 26596, 26590, 26589, 26594,
    26606, 26553, 26574, 26566, 26599, 27292, 26654, 26694, 26665, 26688,
    26701, 26674, 26702, 26803, 26667, 26713, 26723, 26743, 26751, 26783,
    26767, 26797, 26772, 26781, 26779, 26755, 27310, 26809, 26740, 26805,
    26784, 26810, 26895, 26765, 26750, 26881, 26826, 26888, 26840, 26914,
    26918, 26849, 26892, 26829, 26836, 26855, 26837, 26934, 26898, 26884,
    26839, 26851, 26917, 26873, 26848, 26863, 26920, 26922, 26906, 26915,
    26913, 26822, 27001, 26999, 26972, 27000, 26987, 26964, 27006, 26990,
    26937, 26996, 26941, 26969, 26928, 26977, 26974, 26973, 27009, 26986,
    27058, 27054, 27088, 27071, 27073, 27091, 27070, 27086, 23528, 27082,
    27101, 27067, 27075, 27047, 27182, 27025, 27040, 27036, 27029, 27060,
    27102, 27112, 27138, 27163, 27135, 27402, 27129, 27122, 27111, 27141,
    27057, 27166, 27117, 27156, 27115, 27146, 27154, 27329, 27171, 27155,
    27204, 27148, 27250, 27190, 27256, 27207, 27234, 27225, 27238, 27208,
    27192, 27170, 27280, 27277, 27296, 27268, 27298, 27299, 27287, 34327,
    27323, 27331, 27330, 27320, 27315, 27308, 27358, 27345, 27359, 27306,
    27354, 27370, 27387, 27397, 34326, 27386, 27410, 27414, 39729, 27423,
    27448, 27447, 30428, 27449, 39150, 27463, 27459, 27465, 27472, 27481,
    27476, 27483, 27487, 27489, 27512, 27513, 27519, 27520, 27524, 27523,
    27533, 27544, 27541, 27550, 27556, 27562, 27563, 27567, 27570, 27569,
    27571, 27575, 27580, 27590, 27595, 27603, 27615, 27628, 27627, 27635,
    27631, 40638, 27656, 27667, 27668, 27675, 27684, 27683, 27742, 27733,
    27746, 27754, 27778, 27789, 27802, 27777, 27803, 27774, 27752, 27763,
    27794, 27792, 27844, 27889, 27859, 27837, 27863, 27845, 27869, 27822,
    27825, 27838, 27834, 27867, 27887, 27865, 27882, 27935, 34893, 27958,
    27947, 27965, 27960, 27929, 27957, 27955, 27922, 27916, 28003, 28051,
    28004, 27994, 28025, 27993, 28046, 28053, 28644, 28037, 28153, 28181,
    28170, 28085, 28103, 28134, 28088, 28102, 28140, 28126, 28108, 28136,
    28114, 28101, 28154, 28121, 28132, 28117, 28138, 28142, 28205, 28270,
    28206, 28185, 28274, 28255, 28222, 28195, 28267, 28203, 28278, 28237,
    28191, 28227, 28218, 28238, 28196, 28415, 28189, 28216, 28290, 28330,
    28312, 28361, 28343, 28371, 28349, 28335, 28356, 28338, 28372, 28373,
    28303, 28325, 28354, 28319, 28481, 28433, 28748, 28396, 28408, 28414,
    28479, 28402, 28465, 28399, 28466, 28364, 28478, 28435, 28407, 28550,
    28538, 28536, 28545, 28544, 28527, 28507, 28659, 28525, 28546, 28540,
    28504, 28558, 28561, 28610, 28518, 28595, 28579, 28577, 28580, 28601,
    28614, 28586, 28639, 28629, 28652, 28628, 28632, 28657, 28654, 28635,
    28681, 28683, 28666, 28689, 28673, 28687, 28670, 28699, 28698, 28532,
    28701, 28696, 28703, 28720, 28734, 28722, 28753, 28771, 28825, 28818,
    28847, 28913, 28844, 28856, 28851, 28846, 28895, 28875, 28893, 28889,
    28937, 28925, 28956, 28953, 29029, 29013, 29064, 29030, 29026, 29004,
    29014, 29036, 29071, 29179, 29060, 29077, 29096, 29100, 29143, 29113,
    29118, 29138, 29129, 29140, 29134, 29152, 29164, 29159, 29173, 29180,
    29177, 29183, 29197, 29200, 29211, 29224, 29229, 29228, 29232, 29234,
    29243, 29244, 29247, 29248, 29254, 29259, 29272, 29300, 29310, 29314,
    29313, 29319, 29330, 29334, 29346, 29351, 29369, 29362, 29379, 29382,
    29380, 29390, 29394, 29410, 29408, 29409, 29433, 29431, 20495, 29463,
    29450, 29468, 29462, 29469, 29492, 29487, 29481, 29477, 29502, 29518,
    29519, 40664, 29527, 29546, 29544, 29552, 29560, 29557, 29563, 29562,
    29640, 29619, 29646, 29627, 29632, 29669, 29678, 29662, 29858, 29701,
    29807, 29733, 29688, 29746, 29754, 29781, 29759, 29791, 29785, 29761,
    29788, 29801, 29808, 29795, 29802, 29814, 29822, 29835, 29854, 29863,
    29898, 29903, 29908, 29681, 29920, 29923, 29927, 29929, 29934, 29938,
    29936, 29937, 29944, 29943, 29956, 29955, 29957, 29964, 29966, 29965,
    29973, 29971, 29982, 29990, 29996, 30012, 30020, 30029, 30026, 30025,
    30043, 30022, 30042, 30057, 30052, 30055, 30059, 30061, 30072, 30070,
    30086, 30087, 30068, 30090, 30089, 30082, 30100, 30106, 30109, 30117,
    30115, 30146, 30131, 30147, 30133, 30141, 30136, 30140, 30129, 30157,
    30154, 30162, 30169, 30179, 30174, 30206, 30207, 30204, 30209, 30192,
    30202, 30194, 30195, 30219, 30221, 30217, 30239, 30247, 30240, 30241,
    30242, 30244, 30260, 30256, 30267, 30279, 30280, 30278, 30300, 30296,
    30305, 30306, 30312, 30313, 30314, 30311, 30316, 30320, 30322, 30326,
    30328, 30332, 30336, 30339, 30344, 30347, 30350, 30358, 30355, 30361,
    30362, 30384, 30388, 30392, 30393, 30394, 30402, 30413, 30422, 30418,
    30430, 30433, 30437, 30439, 30442, 34351, 30459, 30472, 30471, 30468,
    30505, 30500, 30494, 30501, 30502, 30491, 30519, 30520, 30535, 30554,
    30568, 30571, 30555, 30565, 30591, 30590, 30585, 30606, 30603, 30609,
    30624, 30622, 30640, 30646, 30649, 30655, 30652, 30653, 30651, 30663,
    30669, 30679, 30682, 30684, 30691, 30702, 30716, 30732, 30738, 31014,
    30752, 31018, 30789, 30862, 30836, 30854, 30844, 30874, 30860, 30883,
    30901, 30890, 30895, 30929, 30918, 30923, 30932, 30910, 30908, 30917,
    30922, 30956, 30951, 30938, 30973, 30964, 30983, 30994, 30993, 31001,
    31020, 31019, 31040, 31072, 31063, 31071, 31066, 31061, 31059, 31098,
    31103, 31114, 31133, 31143, 40779, 31146, 31150, 31155, 31161, 31162,
    31177, 31189, 31207, 31212, 31201, 31203, 31240, 31245, 31256, 31257,
    31264, 31263, 31104, 31281, 31291, 31294, 31287, 31299, 31319, 31305,
    31329, 31330, 31337, 40861, 31344, 31353, 31357, 31368, 31383, 31381,
    31384, 31382, 31401, 31432, 31408, 31414, 31429, 31428, 31423, 36995,
    31431, 31434, 31437, 31439, 31445, 31443, 31449, 31450, 31453, 31457,
    31458, 31462, 31469, 31472, 31490, 31503, 31498, 31494, 31539, 31512,
    31513, 31518, 31541, 31528, 31542, 31568, 31610, 31492, 31565, 31499,
    31564, 31557, 31605, 31589, 31604, 31591, 31600, 31601, 31596, 31598,
    31645, 31640, 31647, 31629, 31644, 31642, 31627, 31634, 31631, 31581,
    31641, 31691, 31681, 31692, 31695, 31668, 31686, 31709, 31721, 31761,
    31764, 31718, 31717, 31840, 31744, 31751, 31763, 31731, 31735, 31767,
    31757, 31734, 31779, 31783, 31786, 31775, 31799, 31787, 31805, 31820,
    31811, 31828, 31823, 31808, 31824, 31832, 31839, 31844, 31830, 31845,
    31852, 31861, 31875, 31888, 31908, 31917, 31906, 31915, 31905, 31912,
    31923, 31922, 31921, 31918, 31929, 31933, 31936, 31941, 31938, 31960,
    31954, 31964, 31970, 39739, 31983, 31986, 31988, 31990, 31994, 32006,
    32002, 32028, 32021, 32010, 32069, 32075, 32046, 32050, 32063, 32053,
    32070, 32115, 32086, 32078, 32114, 32104, 32110, 32079, 32099, 32147,
    32137, 32091, 32143, 32125, 32155, 32186, 32174, 32163, 32181, 32199,
    32189, 32171, 32317, 32162, 32175, 32220, 32184, 32159, 32176, 32216,
    32221, 32228, 32222, 32251, 32242, 32225, 32261, 32266, 32291, 32289,
    32274, 32305, 32287, 32265, 32267, 32290, 32326, 32358, 32315, 32309,
    32313, 32323, 32311, 32306, 32314, 32359, 32349, 32342, 32350, 32345,
    32346, 32377, 32362, 32361, 32380, 32379, 32387, 32213, 32381, 36782,
    32383, 32392, 32393, 32396, 32402, 32400, 32403, 32404, 32406, 32398,
    32411, 32412, 32568, 32570, 32581, 32588, 32589, 32590, 32592, 32593,
    32597, 32596, 32600, 32607, 32608, 32616, 32617, 32615, 32632, 32642,
    32646, 32643, 32648, 32647, 32652, 32660, 32670, 32669, 32666, 32675,
    32687, 32690, 32697, 32686, 32694, 32696, 35697, 32709, 32710, 32714,
    32725, 32724, 32737, 32742, 32745, 32755, 32761, 39132, 32774, 32772,
    32779, 32786, 32792, 32793, 32796, 32801, 32808, 32831, 32827, 32842,
    32838, 32850, 32856, 32858, 32863, 32866, 32872, 32883, 32882, 32880,
    32886, 32889, 32893, 32895, 32900, 32902, 32901, 32923, 32915, 32922,
    32941, 20880, 32940, 32987, 32997, 32985, 32989, 32964, 32986, 32982,
    33033, 33007, 33009, 33051, 33065, 33059, 33071, 33099, 38539, 33094,
    33086, 33107, 33105, 33020, 33137, 33134, 33125, 33126, 33140, 33155,
    33160, 33162, 33152, 33154, 33184, 33173, 33188, 33187, 33119, 33171,
    33193, 33200, 33205, 33214, 33208, 33213, 33216, 33218, 33210, 33225,
    33229, 33233, 33241, 33240, 33224, 33242, 33247, 33248, 33255, 33274,
    33275, 33278, 33281, 33282, 33285, 33287, 33290, 33293, 33296, 33302,
    33321, 33323, 33336, 33331, 33344, 33369, 33368, 33373, 33370, 33375,
    33380, 33378, 33384, 33386, 33387, 33326, 33393, 33399, 33400, 33406,
    33421, 33426, 33451, 33439, 33467, 33452, 33505, 33507, 33503, 33490,
    33524, 33523, 33530, 33683, 33539, 33531, 33529, 33502, 33542, 33500,
    33545, 33497, 33589, 33588, 33558, 33586, 33585, 33600, 33593, 33616,
    33605, 33583, 33579, 33559, 33560, 33669, 33690, 33706, 33695, 33698,
    33686, 33571, 33678, 33671, 33674, 33660, 33717, 33651, 33653, 33696,
    33673, 33704, 33780, 33811, 33771, 33742, 33789, 33795, 33752, 33803,
    33729, 33783, 33799, 33760, 33778, 33805, 33826, 33824, 33725, 33848,
    34054, 33787, 33901, 33834, 33852, 34138, 33924, 33911, 33899, 33965,
    33902, 33922, 33897, 33862, 33836, 33903, 33913, 33845, 33994, 33890,
    33977, 33983, 33951, 34009, 33997, 33979, 34010, 34000, 33985, 33990,
    34006, 33953, 34081, 34047, 34036, 34071, 34072, 34092, 34079, 34069,
    34068, 34044, 34112, 34147, 34136, 34120, 34113, 34306, 34123, 34133,
    34176, 34212, 34184, 34193, 34186, 34216, 34157, 34196, 34203, 34282,
    34183, 34204, 34167, 34174, 34192, 34249, 34234, 34255, 34233, 34256,
    34261, 34269, 34277, 34268, 34297, 34314, 34323, 34315, 34302, 34298,
    34310, 34338, 34330, 34352, 34367, 34381, 20053, 34388, 34399, 34407,
    34417, 34451, 34467, 34473, 34474, 34443, 34444, 34486, 34479, 34500,
    34502, 34480, 34505, 34851, 34475, 34516, 34526, 34537, 34540, 34527,
    34523, 34543, 34578, 34566, 34568, 34560, 34563, 34555, 34577, 34569,
    34573, 34553, 34570, 34612, 34623, 34615, 34619, 34597, 34601, 34586,
    34656, 34655, 34680, 34636, 34638, 34676, 34647, 34664, 34670, 34649,
    34643, 34659, 34666, 34821, 34722, 34719, 34690, 34735, 34763, 34749,
    34752, 34768, 38614, 34731, 34756, 34739, 34759, 34758, 34747, 34799,
    34802, 34784, 34831, 34829, 34814, 34806, 34807, 34830, 34770, 34833,
    34838, 34837, 34850, 34849, 34865, 34870, 34873, 34855, 34875, 34884,
    34882, 34898, 34905, 34910, 34914, 34923, 34945, 34942, 34974, 34933,
    34941, 34997, 34930, 34946, 34967, 34962, 34990, 34969, 34978, 34957,
    34980, 34992, 35007, 34993, 35011, 35012, 35028, 35032, 35033, 35037,
    35065, 35074, 35068, 35060, 35048, 35058, 35076, 35084, 35082, 35091,
    35139, 35102, 35109, 35114, 35115, 35137, 35140, 35131, 35126, 35128,
    35148, 35101, 35168, 35166, 35174, 35172, 35181, 35178, 35183, 35188,
    35191, 35198, 35203, 35208, 35210, 35219, 35224, 35233, 35241, 35238,
    35244, 35247, 35250, 35258, 35261, 35263, 35264, 35290, 35292, 35293,
    35303, 35316, 35320, 35331, 35350, 35344, 35340, 35355, 35357, 35365,
    35382, 35393, 35419, 35410, 35398, 35400, 35452, 35437, 35436, 35426,
    35461, 35458, 35460, 35496, 35489, 35473, 35493, 35494, 35482, 35491,
    35524, 35533, 35522, 35546, 35563, 35571, 35559, 35556, 35569, 35604,
    35552, 35554, 35575, 35550, 35547, 35596, 35591, 35610, 35553, 35606,
    35600, 35607, 35616, 35635, 38827, 35622, 35627, 35646, 35624, 35649,
    35660, 35663, 35662, 35657, 35670, 35675, 35674, 35691, 35679, 35692,
    35695, 35700, 35709, 35712, 35724, 35726, 35730, 35731, 35734, 35737,
    35738, 35898, 35905, 35903, 35912, 35916, 35918, 35920, 35925, 35938,
    35948, 35960, 35962, 35970, 35977, 35973, 35978, 35981, 35982, 35988,
    35964, 35992, 25117, 36013, 36010, 36029, 36018, 36019, 36014, 36022,
    36040, 36033, 36068, 36067, 36058, 36093, 36090, 36091, 36100, 36101,
    36106, 36103, 36111, 36109, 36112, 40782, 36115, 36045, 36116, 36118,
    36199, 36205, 36209, 36211, 36225, 36249, 36290, 36286, 36282, 36303,
    36314, 36310, 36300, 36315, 36299, 36330, 36331, 36319, 36323, 36348,
    36360, 36361, 36351, 36381, 36382, 36368, 36383, 36418, 36405, 36400,
    36404, 36426, 36423, 36425, 36428, 36432, 36424, 36441, 36452, 36448,
    36394, 36451, 36437, 36470, 36466, 36476, 36481, 36487, 36485, 36484,
    36491, 36490, 36499, 36497, 36500, 36505, 36522, 36513, 36524, 36528,
    36550, 36529, 36542, 36549, 36552, 36555, 36571, 36579, 36604, 36603,
    36587, 36606, 36618, 36613, 36629, 36626, 36633, 36627, 36636, 36639,
    36635, 36620, 36646, 36659, 36667, 36665, 36677, 36674, 36670, 36684,
    36681, 36678, 36686, 36695, 36700, 36706, 36707, 36708, 36764, 36767,
    36771, 36781, 36783, 36791, 36826, 36837, 36834, 36842, 36847, 36999,
    36852, 36869, 36857, 36858, 36881, 36885, 36897, 36877, 36894, 36886,
    36875, 36903, 36918, 36917, 36921, 36856, 36943, 36944, 36945, 36946,
    36878, 36937, 36926, 36950, 36952, 36958, 36968, 36975, 36982, 38568,
    36978, 36994, 36989, 36993, 36992, 37002, 37001, 37007, 37032, 37039,
    37041, 37045, 37090, 37092, 25160, 37083, 37122, 37138, 37145, 37170,
    37168, 37194, 37206, 37208, 37219, 37221, 37225, 37235, 37234, 37259,
    37257, 37250, 37282, 37291, 37295, 37290, 37301, 37300, 37306, 37312,
    37313, 37321, 37323, 37328, 37334, 37343, 37345, 37339, 37372, 37365,
    37366, 37406, 37375, 37396, 37420, 37397, 37393, 37470, 37463, 37445,
    37449, 37476, 37448, 37525, 37439, 37451, 37456, 37532, 37526, 37523,
    37531, 37466, 37583, 37561, 37559, 37609, 37647, 37626, 37700, 37678,
    37657, 37666, 37658, 37667, 37690, 37685, 37691, 37724, 37728, 37756,
    37742, 37718, 37808, 37804, 37805, 37780, 37817, 37846, 37847, 37864,
    37861, 37848, 37827, 37853, 37840, 37832, 37860, 37914, 37908, 37907,
    37891, 37895, 37904, 37942, 37931, 37941, 37921, 37946, 37953, 37970,
    37956, 37979, 37984, 37986, 37982, 37994, 37417, 38000, 38005, 38007,
    38013, 37978, 38012, 38014, 38017, 38015, 38274, 38279, 38282, 38292,
    38294, 38296, 38297, 38304, 38312, 38311, 38317, 38332, 38331, 38329,
    38334, 38346, 28662, 38339, 38349, 38348, 38357, 38356, 38358, 38364,
    38369, 38373, 38370, 38433, 38440, 38446, 38447, 38466, 38476, 38479,
    38475, 38519, 38492, 38494, 38493, 38495, 38502, 38514, 38508, 38541,
    38552, 38549, 38551, 38570, 38567, 38577, 38578, 38576, 38580, 38582,
    38584, 38585, 38606, 38603, 38601, 38605, 35149, 38620, 38669, 38613,
    38649, 38660, 38662, 38664, 38675, 38670, 38673, 38671, 38678, 38681,
    38692, 38698, 38704, 38713, 38717, 38718, 38724, 38726, 38728, 38722,
    38729, 38748, 38752, 38756, 38758, 38760, 21202, 38763, 38769, 38777,
    38789, 38780, 38785, 38778, 38790, 38795, 38799, 38800, 38812, 38824,
    38822, 38819, 38835, 38836, 38851, 38854, 38856, 38859, 38876, 38893,
    40783, 38898, 31455, 38902, 38901, 38927, 38924, 38968, 38948, 38945,
    38967, 38973, 38982, 38991, 38987, 39019, 39023, 39024, 39025, 39028,
    39027, 39082, 39087, 39089, 39094, 39108, 39107, 39110, 39145, 39147,
    39171, 39177, 39186, 39188, 39192, 39201, 39197, 39198, 39204, 39200,
    39212, 39214, 39229, 39230, 39234, 39241, 39237, 39248, 39243, 39249,
    39250, 39244, 39253, 39319, 39320, 39333, 39341, 39342, 39356, 39391,
    39387, 39389, 39384, 39377, 39405, 39406, 39409, 39410, 39419, 39416,
    39425, 39439, 39429, 39394, 39449, 39467, 39479, 39493, 39490, 39488,
    39491, 39486, 39509, 39501, 39515, 39511, 39519, 39522, 39525, 39524,
    39529, 39531, 39530, 39597, 39600, 39612, 39616, 39631, 39633, 39635,
    39636, 39646, 39647, 39650, 39651, 39654, 39663, 39659, 39662, 39668,
    39665, 39671, 39675, 39686, 39704, 39706, 39711, 39714, 39715, 39717,
    39719, 39720, 39721, 39722, 39726, 39727, 39730, 39748, 39747, 39759,
    39757, 39758, 39761, 39768, 39796, 39827, 39811, 39825, 39830, 39831,
    39839, 39840, 39848, 39860, 39872, 39882, 39865, 39878, 39887, 39889,
    39890, 39907, 39906, 39908, 39892, 39905, 39994, 39922, 39921, 39920,
    39957, 39956, 39945, 39955, 39948, 39942, 39944, 39954, 39946, 39940,
    39982, 39963, 39973, 39972, 39969, 39984, 40007, 39986, 40006, 39998,
    40026, 40032, 40039, 40054, 40056, 40167, 40172, 40176, 40201, 40200,
    40171, 40195, 40198, 40234, 40230, 40367, 40227, 40223, 40260, 40213,
    40210, 40257, 40255, 40254, 40262, 40264, 40285, 40286, 40292, 40273,
    40272, 40281, 40306, 40329, 40327, 40363, 40303, 40314, 40346, 40356,
    40361, 40370, 40388, 40385, 40379, 40376, 40378, 40390, 40399, 40386,
    40409, 40403, 40440, 40422, 40429, 40431, 40445, 40474, 40475, 40478,
    40565, 40569, 40573, 40577, 40584, 40587, 40588, 40594, 40597, 40593,
    40605, 40613, 40617, 40632, 40618, 40621, 38753, 40652, 40654, 40655,
    40656, 40660, 40668, 40670, 40669, 40672, 40677, 40680, 40687, 40692,
    40694, 40695, 40697, 40699, 40700, 40701, 40711, 40712, 30391, 40725,
    40737, 40748, 40766, 40778, 40786, 40788, 40803, 40799, 40800, 40801,
    40806, 40807, 40812, 40810, 40823, 40818, 40822, 40853, 40860, 40864,
    22575, 27079, 36953, 29796, 20956, 29081, 32394, 35100, 37704, 37512,
    34012, 20425, 28859, 26161, 26824, 37625, 26363, 24389, 20008, 20193,
    20220, 20224, 20227, 20281, 20310, 20370, 20362, 20378, 20372, 20429,
    20544, 20514, 20479, 20510, 20550, 20592, 20546, 20628, 20724, 20696,
    20810, 20836, 20893, 20926, 20972, 21013, 21148, 21158, 21184, 21211,
    21248, 21255, 21284, 21362, 21395, 21426, 21469, 64014, 21660, 21642,
    21673, 21759, 21894, 22361, 22373, 22444, 22472, 22471, 64015, 64016,
    22686, 22706, 22795, 22867, 22875, 22877, 22883, 22948, 22970, 23382,
    23488, 29999, 23512, 23532, 23582, 23718, 23738, 23797, 23847, 23891,
    64017, 23874, 23917, 23992, 23993, 24016, 24353, 24372, 24423, 24503,
    24542, 24669, 24709, 24714, 24798, 24789, 24864, 24818, 24849, 24887,
    24880, 24984, 25107, 25254, 25589, 25696, 25757, 25806, 25934, 26112,
    26133, 26171, 26121, 26158, 26142, 26148, 26213, 26199, 26201, 64018,
    26227, 26265, 26272, 26290, 26303, 26362, 26382, 63785, 26470, 26555,
    26706, 26560, 26625, 26692, 26831, 64019, 26984, 64020, 27032, 27106,
    27184, 27243, 27206, 27251, 27262, 27362, 27364, 27606, 27711, 27740,
    27782, 27759, 27866, 27908, 28039, 28015, 28054, 28076, 28111, 28152,
    28146, 28156, 28217, 28252, 28199, 28220, 28351, 28552, 28597, 28661,
    28677, 28679, 28712, 28805, 28843, 28943, 28932, 29020, 28998, 28999,
    64021, 29121, 29182, 29361, 29374, 29476, 64022, 29559, 29629, 29641,
    29654, 29667, 29650, 29703, 29685, 29734, 29738, 29737, 29742, 29794,
    29833, 29855, 29953, 30063, 30338, 30364, 30366, 30363, 30374, 64023,
    30534, 21167, 30753, 30798, 30820, 30842, 31024, 64024, 64025, 64026,
    31124, 64027, 31131, 31441, 31463, 64028, 31467, 31646, 64029, 32072,
    32092, 32183, 32160, 32214, 32338, 32583, 32673, 64030, 33537, 33634,
    33663, 33735, 33782, 33864, 33972, 34131, 34137, 34155, 64031, 34224,
    64032, 64033, 34823, 35061, 35346, 35383, 35449, 35495, 35518, 35551,
    64034, 35574, 35667, 35711, 36080, 36084, 36114, 36214, 64035, 36559,
    64036, 64037, 36967, 37086, 64038, 37141, 37159, 37338, 37335, 37342,
    37357, 37358, 37348, 37349, 37382, 37392, 37386, 37434, 37440, 37436,
    37454, 37465, 37457, 37433, 37479, 37543, 37495, 37496, 37607, 37591,
    37593, 37584, 64039, 37589, 37600, 37587, 37669, 37665, 37627, 64040,
    37662, 37631, 37661, 37634, 37744, 37719, 37796, 37830, 37854, 37880,
    37937, 37957, 37960, 38290, 63964, 64041, 38557, 38575, 38707, 38715,
    38723, 38733, 38735, 38737, 38741, 38999, 39013, 64042, 64043, 39207,
    64044, 39326, 39502, 39641, 39644, 39797, 39794, 39823, 39857, 39867,
    39936, 40304, 40299, 64045, 40473, 40657, X, X, 8560, 8561, 8562, 8563,
    8564, 8565, 8566, 8567, 8568, 8569, 65506, 65508, 65287, 65282, 8560, 8561,
    8562, 8563, 8564, 8565, 8566, 8567, 8568, 8569, 8544, 8545, 8546, 8547,
    8548, 8549, 8550, 8551, 8552, 8553, 65506, 65508, 65287, 65282, 12849,
    8470, 8481, 8757, 32394, 35100, 37704, 37512, 34012, 20425, 28859, 26161,
    26824, 37625, 26363, 24389, 20008, 20193, 20220, 20224, 20227, 20281,
    20310, 20370, 20362, 20378, 20372, 20429, 20544, 20514, 20479, 20510,
    20550, 20592, 20546, 20628, 20724, 20696, 20810, 20836, 20893, 20926,
    20972, 21013, 21148, 21158, 21184, 21211, 21248, 21255, 21284, 21362,
    21395, 21426, 21469, 64014, 21660, 21642, 21673, 21759, 21894, 22361,
    22373, 22444, 22472, 22471, 64015, 64016, 22686, 22706, 22795, 22867,
    22875, 22877, 22883, 22948, 22970, 23382, 23488, 29999, 23512, 23532,
    23582, 23718, 23738, 23797, 23847, 23891, 64017, 23874, 23917, 23992,
    23993, 24016, 24353, 24372, 24423, 24503, 24542, 24669, 24709, 24714,
    24798, 24789, 24864, 24818, 24849, 24887, 24880, 24984, 25107, 25254,
    25589, 25696, 25757, 25806, 25934, 26112, 26133, 26171, 26121, 26158,
    26142, 26148, 26213, 26199, 26201, 64018, 26227, 26265, 26272, 26290,
    26303, 26362, 26382, 63785, 26470, 26555, 26706, 26560, 26625, 26692,
    26831, 64019, 26984, 64020, 27032, 27106, 27184, 27243, 27206, 27251,
    27262, 27362, 27364, 27606, 27711, 27740, 27782, 27759, 27866, 27908,
    28039, 28015, 28054, 28076, 28111, 28152, 28146, 28156, 28217, 28252,
    28199, 28220, 28351, 28552, 28597, 28661, 28677, 28679, 28712, 28805,
    28843, 28943, 28932, 29020, 28998, 28999, 64021, 29121, 29182, 29361,
    29374, 29476, 64022, 29559, 29629, 29641, 29654, 29667, 29650, 29703,
    29685, 29734, 29738, 29737, 29742, 29794, 29833, 29855, 29953, 30063,
    30338, 30364, 30366, 30363, 30374, 64023, 30534, 21167, 30753, 30798,
    30820, 30842, 31024, 64024, 64025, 64026, 31124, 64027, 31131, 31441,
    31463, 64028, 31467, 31646, 64029, 32072, 32092, 32183, 32160, 32214,
    32338, 32583, 32673, 64030, 33537, 33634, 33663, 33735, 33782, 33864,
    33972, 34131, 34137, 34155, 64031, 34224, 64032, 64033, 34823, 35061,
    35346, 35383, 35449, 35495, 35518, 35551, 64034, 35574, 35667, 35711,
    36080, 36084, 36114, 36214, 64035, 36559, 64036, 64037, 36967, 37086,
    64038, 37141, 37159, 37338, 37335, 37342, 37357, 37358, 37348, 37349,
    37382, 37392, 37386, 37434, 37440, 37436, 37454, 37465, 37457, 37433,
    37479, 37543, 37495, 37496, 37607, 37591, 37593, 37584, 64039, 37589,
    37600, 37587, 37669, 37665, 37627, 64040, 37662, 37631, 37661, 37634,
    37744, 37719, 37796, 37830, 37854, 37880, 37937, 37957, 37960, 38290,
    63964, 64041, 38557, 38575, 38707, 38715, 38723, 38733, 38735, 38737,
    38741, 38999, 39013, 64042, 64043, 39207, 64044, 39326, 39502, 39641,
    39644, 39797, 39794, 39823, 39857, 39867, 39936, 40304, 40299, 64045,
    40473, 40657,
]; // 7944 entries

/// Returns the index code point for pointer `code` in this index.
#[inline]
pub fn forward(code: u16) -> u32 {
    let code = premap_forward(code);
    let code = code as usize;
    if code < 7944 {
        FORWARD_TABLE[code] as u32
    } else {
        X as u32
    }
}

#[cfg(not(feature = "no-optimized-legacy-encoding"))]
const BACKWARD_TABLE_LOWER: &'static [u16] = &[
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 80, 81, 137, 16, 8645, 78, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 62, X, X, X, X, X, X, X,
    X, X, 3528, 7273, 2653, 2601, 3630, 3276, X, X, X, 2619, X, 2895, X, 7274,
    X, 7275, X, X, X, X, X, X, X, 7716, X, 7715, X, X, X, X, X, 2127, X, X, X,
    X, X, X, X, X, X, X, 7720, X, X, X, X, X, 2921, 4568, 2689, X, X, 4569, X,
    3287, 4260, 3447, X, X, X, X, X, X, X, X, 4642, X, X, X, X, 4570, 7806,
    2010, X, X, 4040, 1808, X, 5221, X, 2104, 1711, X, X, 5218, X, X, 4253,
    5220, 1463, 5222, X, 5213, 5219, 5226, 2103, 5214, X, X, X, X, X, X, 4196,
    X, 5431, 2537, 2279, 5429, X, X, X, X, 5430, X, 2843, X, X, X, 5428, X, X,
    2458, X, X, X, X, 8393, X, 8394, X, X, X, 5433, 5432, 5437, 5057, X, X,
    5056, 5055, 3852, X, 5064, X, X, X, X, 4005, X, 5058, X, X, X, X, X, 5060,
    4022, X, 5059, X, X, X, X, X, X, X, 5061, 4687, X, X, X, 4689, X, 4691, X,
    X, X, 8325, 2429, 4357, X, 4680, 4678, 4690, X, 4685, X, X, X, X, X, X, X,
    X, X, 8324, X, X, X, 1887, 2202, 4942, 1747, X, X, 4943, X, 3126, X, X, X,
    X, 4944, 4984, X, 4945, X, 4946, X, X, 4947, X, 4949, X, X, X, X, X, 1527,
    1800, X, 4896, X, 4078, 3776, X, X, X, X, X, X, X, X, X, X, 1417, X, X, X,
    X, 1498, X, X, X, 2492, 1632, X, X, 4313, X, X, 8313, X, X, 2716, 3439,
    2324, 4607, 4608, X, 8487, X, 4298, X, X, 4334, 4610, X, X, X, 2251, X, X,
    4609, X, 1706, X, 4889, 3572, 3727, 4090, X, X, X, X, X, 3576, X, X, 4898,
    X, X, X, X, X, 1903, X, X, 4172, X, X, 4056, X, 4993, X, 4890, X, X, 8421,
    X, 8422, X, X, X, 3672, X, 5653, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 5657, 5654, X, X, X, X, 2341, 2509, X, X, X, X, X, X, X, X, 5971, 5972,
    X, X, X, X, X, X, X, 5974, X, X, X, X, X, X, X, X, 4314, X, X, 5889, X, X,
    X, 1511, X, X, X, X, X, X, X, X, X, 5891, X, X, X, 5890, X, 5888, 3236, X,
    X, X, 5637, X, X, X, X, X, X, X, X, 5635, 2234, X, 5634, X, X, X, X, X, X,
    5640, X, X, X, X, 5507, X, X, X, 4229, X, X, X, X, X, 8476, X, 6009, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 6010, 8477, 3660, X, 1818,
    4319, X, X, X, X, X, X, X, 4042, 3339, X, X, X, X, 5824, 5826, X, X, X, X,
    X, 3025, X, X, X, X, X, 5828, 5822, 5556, 5543, X, 5553, X, X, X, 5547, X,
    X, X, X, X, X, 2844, 5557, X, X, 2932, X, X, X, X, X, X, 5555, 1814, X, X,
    X, X, X, 5759, X, 8430, 2760, X, X, X, 4151, X, 5756, X, X, X, X, 5751, X,
    5757, 8432, X, X, 4291, X, 3466, 3511, X, X, X, 6062, X, 6061, X, X, X, X,
    X, 1557, X, X, X, X, X, 6070, 3737, 6064, X, 6066, X, X, 6068, 2849, X, X,
    6069, 6067, 2569, X, 6080, X, X, X, X, X, X, X, 6087, X, 6085, X, 6086, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 6088, 5917, X, X, X, X,
    3078, 2467, 5919, X, X, X, X, 5918, 2823, 4662, X, X, X, X, X, X, 5920, X,
    X, X, 5922, X, 5905, 5921, X, 8458, 5923, 5679, X, X, 5681, 5680, X, 4003,
    X, X, 2693, 2613, 2479, X, 5682, X, X, X, X, X, X, X, 5684, 2822, X, 5683,
    X, X, X, X, X, 5685, X, 4002, 3185, X, X, X, X, X, X, X, X, 4034, X, X,
    5731, X, X, 5732, X, 1644, X, X, X, X, 3861, 4134, 5734, 2540, 2759, 5727,
    5733, 1575, 8398, X, 3299, X, X, X, 4310, X, X, X, X, 2478, X, X, 3928, X,
    X, X, 8399, X, 3976, X, X, X, 5453, 5448, X, X, 5451, X, 5450, 8400, 5070,
    X, X, X, X, X, 3440, 2383, X, X, X, 2204, X, 3366, X, X, X, X, X, X, X,
    1444, 2709, 2270, 4174, X, X, X, X, X, X, X, 5306, 1416, X, X, 2384, X, X,
    X, 2841, X, X, X, X, X, X, X, X, X, X, 3371, X, X, 3717, 5312, 3069, 4950,
    X, X, 4951, X, 3181, X, 1510, 2610, 1443, X, 3062, 1801, 2558, X, 2263, X,
    X, X, X, X, 3453, X, 2632, 1802, 3267, 3363, 1433, 1904, 3938, X, 2571,
    2727, 1982, X, 4631, 8318, X, X, X, X, X, 3724, X, X, X, X, 4632, X, 4633,
    X, 4634, X, X, X, X, 4635, 3763, 2045, 1478, X, X, X, 3508, 439, 440, 441,
    442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456,
    457, 458, 459, 460, 461, X, X, X, X, 5, 27, 18, 19, X, 4259, X, X, X, X,
    3887, X, 8284, X, 4421, X, X, 3265, X, X, X, 4422, 2063, X, X, X, 4423, X,
    1846, 3211, X, 2608, 4424, X, X, 4425, 629, 630, 631, 632, 633, 634, 635,
    636, 637, 638, 639, 640, 641, 642, 643, 644, X, 618, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 7324, 8577, X, 3962, 8581, X, 8579, X, 8575, X,
    8576, X, X, X, X, X, X, 7194, X, X, 3629, 4285, X, X, X, X, 2651, X, X, X,
    7195, X, X, X, X, 4137, 7197, X, 7196, X, X, 7200, 4168, 8564, X, X, X,
    3403, 7311, X, X, 7314, 7312, X, 7317, X, X, 8566, X, 7318, 8568, X, X, X,
    X, X, 7310, X, 8567, 7323, 1587, X, X, 7309, X, 6993, X, X, X, X, 6996, X,
    6997, X, X, X, X, X, X, X, 2379, 3135, 6995, X, 2784, 3789, X, X, X, X, X,
    6994, X, X, 2519, X, 3841, 6741, 3478, X, X, 1426, X, X, 6734, X, 6730,
    3089, 6724, 6732, 6737, X, 3583, X, X, X, 1419, X, 6729, X, 6738, 3847, X,
    X, X, X, X, 6486, X, 8511, X, X, X, X, 6487, 6488, 6489, X, 6490, 6491, X,
    X, 6493, 6492, X, X, 6494, X, X, X, X, X, X, 6495, 6335, X, X, X, 6359,
    6361, X, X, X, X, X, X, 6362, X, X, X, X, X, X, 3891, X, 6363, X, X, X, X,
    X, X, X, X, 4107, X, 6252, 6253, 2812, X, X, X, X, X, 6254, X, 1738, X, X,
    X, X, 6256, X, X, X, 2141, X, 1949, X, X, 6257, 2058, X, X, 6258, X, 3005,
    3264, X, X, X, X, X, 8486, 6150, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 6151, 6154, X, X, X, X, 3691, X, X, X, X, 6829, X, X, 6830,
    3799, 3723, 6833, X, X, X, X, X, X, X, X, 3194, 6843, X, 6839, X, X, 1672,
    X, 2213, 2515, X, X, 3743, X, X, X, 2171, 3982, X, 6564, 6562, X, 2301, X,
    2302, 1482, X, 2421, X, X, X, X, X, 3628, X, X, X, X, X, 6305, X, 6307, X,
    X, X, X, 6310, X, 6311, X, 6308, 6309, X, X, 6306, 6304, X, X, X, X, 6298,
    X, X, X, X, X, 6184, X, X, X, X, X, X, X, X, 8489, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 2768, X, X, 7003, X, 7004, 7002, X, 2217, X, 4167, X, X,
    2522, 3578, X, X, X, 7007, X, 2945, X, 3229, X, X, 4157, X, 7010, X, X, X,
    2237, X, 6753, X, X, X, X, X, X, X, X, X, X, X, 6731, X, X, X, X, 1778, X,
    8520, X, X, X, 2813, 6742, X, 6747, 3090, X, X, 6743, 6701, X, 6691, X, X,
    X, X, X, 6703, X, 6689, 3663, X, X, X, X, X, 4208, X, X, X, 6698, X, X, X,
    X, X, X, X, 6720, X, X, 7283, X, X, X, X, 2701, X, 7282, X, 7281, X, 3174,
    X, X, 2240, X, 2948, X, X, X, X, 3681, X, X, X, X, 2656, X, X, X, 1161,
    1171, X, X, 1170, 1164, X, X, X, 1172, X, X, X, X, X, X, X, X, X, X, 1166,
    X, X, X, X, 1174, X, X, X, X, 1523, X, 2371, 2835, X, X, X, X, X, X, X,
    4708, 3449, X, X, X, 4709, X, 1411, X, X, X, X, X, X, X, X, X, 4465, X, X,
    X, X, X, 4468, 4466, X, X, 1631, X, 3880, 4460, X, X, X, X, 4464, 2244, X,
    X, 2483, 153, X, X, X, X, 33, X, 135, 136, 126, 125, 166, 167, X, 1210, X,
    X, X, X, X, 71, 165, X, X, X, X, X, X, X, 163, X, X, 2803, X, X, X, X, X,
    X, X, 4932, X, 3349, X, X, X, 1540, X, 4930, X, X, X, 4933, X, X, X, X, X,
    X, X, 4934, X, 5111, 2100, X, X, X, 3766, 8364, X, 2393, 3782, 3295, 3802,
    5112, X, X, 2745, 1541, X, 5113, X, X, X, 5114, X, 4123, X, X, 3729, X, X,
    5117, 4771, X, 3596, X, X, 4774, X, X, X, X, X, X, X, X, 4775, X, X, X, X,
    X, 4777, X, 4776, X, X, X, X, X, 4779, X, X, X, 2839, X, 3771, X, X, X, X,
    X, X, 1872, 3577, X, X, X, X, X, X, X, X, 5129, 2497, 3973, 3974, X, X,
    1597, 5134, 8366, X, 5410, X, 5408, 5411, 4254, 5409, X, X, X, X, 3004,
    5412, X, X, 3119, X, X, 5413, X, X, X, X, 1875, X, 5415, X, 5414, X, X, X,
    X, 2696, X, 5846, X, X, X, X, X, X, 5839, 3301, 5836, 3346, X, X, X, 5871,
    X, X, X, 5833, X, 5832, X, 5841, X, X, X, 1472, 6569, X, 3227, X, X, X, X,
    X, 3627, X, 3160, X, X, X, X, X, X, X, 6571, X, X, 6567, 6570, 6565, X,
    6568, 3953, X, 6441, 6447, 6440, X, X, 2667, X, X, X, X, 3952, X, X, 2675,
    X, X, 6443, 6455, X, X, 6451, X, 6454, X, 6452, 6456, 6450, X, 6424, 2964,
    X, 6370, 6368, X, 6366, 1786, X, 2774, 6371, X, X, 6369, X, 6367, 6375, X,
    X, 6374, 6373, 6372, X, X, X, X, X, 6376, X, X, X, 6377, 2939, X, 3522, X,
    2977, 2434, X, X, X, 6259, X, X, X, X, X, X, X, X, X, 3261, 3082, X, 6261,
    6263, 6260, 6262, X, X, X, X, X, X, 2069, 6162, X, X, X, X, 3898, X, X, X,
    X, X, X, 2685, 4267, X, X, 6164, X, X, 3500, X, X, 6165, X, X, 6166, X,
    6170, 6168, 6169, X, 6167, 5986, X, 1646, X, X, X, X, X, 5982, 8465, 2468,
    X, X, 3322, 5984, X, X, X, 8468, X, X, X, 8466, X, X, X, X, X, X, X, 5989,
    X, 1617, 4343, X, X, X, X, 3997, X, 3863, X, X, X, X, X, X, X, X, 2936, X,
    5939, X, X, X, X, 3512, X, X, X, 2164, 5940, X, 4062, X, X, X, X, 2764, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 3026, X, X, X, X, X, 2763, X, X,
    X, 6693, X, X, X, X, 1490, X, X, 6684, X, X, X, 6683, X, 6678, 6677, X,
    6675, 6674, 3262, X, 3192, 6680, X, X, X, X, X, X, 6449, 6457, X, 6465,
    6464, X, X, 4037, X, X, 2078, X, X, X, X, X, X, X, X, 6463, X, 6467, 6466,
    6470, X, 6472, 6355, X, X, 6352, X, X, X, X, X, X, X, X, 6351, 2963, X,
    6354, 6356, X, X, X, 6353, X, 6360, X, 6357, X, X, X, X, X, X, 6358, 6242,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 2616, X, X, 6245, 1489, X, X, X, X,
    6248, X, X, X, 6246, 1649, 2113, 6247, 2293, 4059, X, X, X, 6143, 6145,
    6146, X, X, 6142, X, X, X, X, X, X, X, X, X, X, X, X, X, 6148, 6149, X,
    3304, X, 1852, X, X, X, 2144, X, 6991, X, X, X, X, 3959, X, X, 2976, X, X,
    X, 1965, X, 4126, 3049, X, 6992, 8531, X, X, 2858, 3275, 2783, X, X, X,
    7693, X, X, 7694, 3507, 7691, 7690, X, X, X, X, 1607, X, X, X, 7702, X, X,
    7701, X, X, X, X, X, 1588, X, X, X, 7699, 2339, 4066, X, X, 7710, X, X, X,
    X, X, X, 8628, 3965, X, X, 7718, 8627, X, 7714, X, X, X, X, X, X, X, 7719,
    X, X, X, X, X, 1180, X, X, X, X, X, X, X, X, 1194, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 1201, 1202, X, X, X, X, X, X, 1203, X, X, X,
    X, X, X, 4895, X, X, 2491, X, 2490, X, X, X, X, 1434, 2201, X, 2924, 1458,
    X, X, X, X, 4899, 4900, X, 4897, X, X, X, 2133, X, X, X, X, 5356, X, X, X,
    X, X, X, X, X, X, 2464, 5353, X, 5352, X, X, X, X, 3589, X, X, 8382, 3498,
    X, 4263, X, 5527, X, 3634, X, X, X, X, X, X, X, 5535, X, 5522, X, X, X,
    1429, 5524, X, X, 2283, X, X, X, 5526, X, 5525, X, 5521, 5192, 2636, X,
    5195, X, X, 5189, X, 4133, 4132, X, X, X, 5199, 5200, 1462, X, 8374, X, X,
    X, 5188, X, X, X, X, 2055, 1415, X, X, X, 1807, 4816, X, 2259, 1723, 4818,
    X, X, X, X, X, 4819, X, 8331, X, X, X, 4820, X, X, 4817, X, X, X, X, X, X,
    X, X, X, X, X, X, 2386, 4170, X, X, X, X, 4511, 4514, 4510, 2385, X, 2724,
    X, X, X, X, X, X, 2092, X, 4667, X, 1920, 1729, X, X, X, 2326, 1919, 3352,
    1508, 3494, 4071, 2256, 4224, 3422, 2255, X, X, X, X, X, X, X, X, X, 2082,
    X, 4676, X, 2040, 2657, 2865, 4447, X, 4445, X, 4446, 1935, X, X, 2352,
    1677, X, 4444, 4443, 3862, X, X, X, X, 2481, 2480, 3131, 4448, 3812, 2984,
    X, X, X, 23, 4449, 4451, 140, X, 156, 141, X, X, X, 157, 119, X, X, 120, X,
    X, X, X, X, 1211, X, X, X, X, X, X, X, X, 162, X, X, 164, 70, 1215, X,
    7676, X, X, 7675, 7674, X, X, X, X, X, X, X, 3800, 7672, 1492, 7677, X,
    7679, X, X, X, X, X, X, 1770, 7658, 1526, X, X, 7681, X, 7386, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 8600, X, X, X, 4061, X, X, 4871, X, 3172, X, 3406, 3133, 3814, 4872,
    4873, 1594, X, X, 2563, 4874, X, X, X, X, 1457, 4875, X, X, X, X, X, 4876,
    X, 3912, X, 5092, 4337, X, X, X, X, 5093, 3885, 5096, 4418, 4434, X, 2553,
    3562, 5097, X, 1940, 3293, 1499, 5098, 3859, 2271, X, X, 3243, X, X, X,
    3368, 4769, X, X, X, X, X, 4768, 1728, X, X, 4770, X, X, X, X, 4773, X, X,
    X, X, 4772, X, X, X, X, X, X, X, X, X, X, X, X, 3956, X, 4324, X, X, X, X,
    X, 6756, X, X, X, X, X, X, X, 6763, X, X, 6755, 6715, X, X, X, X, X, X, X,
    X, 3931, X, 6706, X, X, X, 1655, 2215, 3768, 6716, X, 6704, X, 8518, 6713,
    X, X, X, 6723, X, 6708, X, X, 7284, X, 2788, X, X, X, X, X, 7287, 7285, X,
    X, X, 7286, X, X, X, X, 7289, 7288, X, X, 2815, X, 7290, X, X, X, X, X,
    7175, 7172, X, 7176, X, 2591, 7177, 1895, 2086, X, 8545, X, X, 2175, X, X,
    X, X, X, X, X, X, 7178, X, X, X, 3557, 7256, 7255, 7253, 6271, 1837, X, X,
    7221, X, 7258, 7257, X, X, X, X, 7259, X, 4159, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 4328, X, X, 8622, X, 7636, 8621, X, X, X, X, X, X, X, X,
    X, X, 6012, X, X, X, X, 6013, X, X, X, X, 6014, X, X, X, X, X, X, X, 1530,
    X, X, X, 6765, X, X, X, X, 4370, 3479, 3842, 8523, X, 6778, X, X, X, X, X,
    X, X, X, X, 6784, X, X, X, X, X, X, 6785, X, 6537, X, X, X, X, X, X, 6538,
    X, X, X, X, X, X, X, X, X, X, 2547, X, X, 4118, X, X, X, X, 6540, X, 3226,
    X, 6539, 6378, X, 6380, X, X, 6379, X, X, X, X, 2211, X, X, X, 3031, X, X,
    X, 6382, X, X, X, 3475, X, 6381, X, X, X, 6383, X, 3874, 3083, 2772, 6281,
    6282, 2686, X, 3501, 6283, 8500, X, X, 3203, 8502, X, 6284, X, 3223, 6285,
    X, X, X, X, X, 1978, X, 4542, 3256, 2556, X, X, X, X, 1825, 6215, X, 3581,
    X, X, 2770, X, X, 3787, X, X, X, X, 2404, X, X, X, X, X, X, X, X, X, 3471,
    X, X, 6221, X, X, X, X, 6222, 6016, X, 3786, 6017, X, X, 1789, 6018, X,
    6019, X, X, X, X, 6020, X, 6022, 6023, 6021, X, X, X, 3810, 6025, 6024, X,
    X, X, X, X, X, X, 6204, 4012, X, X, X, 6203, X, X, 1484, X, X, X, X, 6207,
    X, X, X, X, X, X, X, X, 6206, X, X, 7014, X, 7012, X, X, 3239, X, X, X,
    2946, 1835, 7013, X, 2878, X, X, 4271, X, X, X, 4355, X, X, X, 7015, 7026,
    3310, X, 7025, 8535, 7034, 4191, X, X, X, X, 7037, X, 7040, X, X, 7038,
    3780, X, X, X, X, X, X, 7035, X, X, X, X, X, 2037, X, X, X, X, 7039, X,
    6754, X, X, X, X, 3342, X, X, X, X, X, 6759, 1503, X, X, X, X, X, X, X,
    3103, X, X, X, X, X, X, X, 3888, X, X, 8589, X, X, X, 2455, X, X, X, X, X,
    X, X, X, 7328, 2896, X, X, X, X, X, X, X, 2897, 7332, 7334, X, X, 8588,
    8586, X, 7064, X, X, X, X, 3483, X, 7066, X, 3960, X, 7067, X, 7068, X,
    7069, X, X, X, X, 7070, X, X, X, X, 3535, X, X, X, X, X, 6865, X, 8528, X,
    X, X, X, X, 6885, 6889, 6884, X, 6891, X, X, X, 6893, 6892, X, X, X, X, X,
    X, X, X, X, 6264, 2073, X, X, X, 1950, 4185, 6266, X, X, X, X, X, 6267, X,
    X, X, 1517, X, X, X, X, 6270, 6182, 8488, X, X, X, 3437, 2403, 1925, X, X,
    X, X, X, X, X, X, X, X, 3951, X, 3614, X, X, X, X, X, 3438, X, X, X, X,
    2315, 2615, X, X, 8467, X, 5987, X, X, X, X, 2097, X, X, 3706, 5988, X, X,
    6015, X, X, X, 8470, X, X, 5994, X, X, X, X, X, 2190, X, 6001, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 5997, X, X, X, 6000, 2235,
    1548, 6002, X, 2899, 5999, 4041, X, 5800, X, X, X, X, X, X, X, X, X, 3679,
    X, X, 5812, 2188, X, X, X, X, X, 2695, X, 5802, X, X, X, 4244, 2289, X,
    5815, 8407, 3141, X, X, 3886, X, 5505, X, X, X, 3761, X, X, X, 5504, 3651,
    3978, 1812, X, 3000, 2663, X, X, X, 3340, X, 4149, X, X, 5500, 5499, X,
    5586, X, 5594, X, X, X, 7803, X, X, 5591, 2284, 3329, 3075, 5589, X, 5584,
    X, X, 5587, X, X, X, X, 4180, 4021, X, X, X, 5592, 5602, X, 5675, 2506,
    2934, 2350, X, 3839, X, X, 3919, 4359, X, X, X, X, 2528, X, X, X, 2397,
    4311, X, X, X, 5676, 5677, X, 2507, X, X, X, 5678, 5368, 5369, 3390, 5371,
    X, X, 2447, 5366, X, X, X, X, 1907, X, X, 5372, X, 5365, 5376, X, 5375, X,
    5374, X, X, X, 5377, X, X, 5379, 2806, X, 5562, 5541, 5561, X, 5554, 5542,
    X, 5558, X, 5559, X, X, X, X, X, 5576, X, X, X, 3523, X, 5549, X, X, 5572,
    X, X, X, 5574, X, 3345, 5257, X, X, X, X, X, X, X, 5258, 5259, 3927, X,
    5261, 5260, 2662, X, 2927, 1667, 1689, 8378, 5262, X, 1440, X, X, X, 2957,
    5263, X, 7084, 5264, 2132, 3882, 4290, X, X, X, X, X, X, X, X, 1681, 4835,
    X, X, X, X, X, 3033, 4838, X, 3450, X, X, 3424, 3451, 3690, 3334, X, X, X,
    2390, X, 3673, 5062, 3883, 5063, X, X, X, X, X, X, X, X, X, X, X, X, X,
    1804, 3884, 3586, 5065, 5066, X, 2267, 1805, 5067, 2185, 4171, 4144, 1871,
    5069, 1414, 3801, 4701, X, 4697, X, X, 4692, 4698, 2389, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 4705, X, X, X, X, X, X, X, 2153, 4741, 4739, 3058,
    1921, 1985, X, 4736, X, 2057, X, X, X, X, X, 1539, X, X, X, X, X, X, X, X,
    X, 1659, X, X, X, X, X, 4765, X, 2817, 4761, X, 4759, X, 4760, X, 4762, X,
    X, X, X, X, X, X, 2901, X, X, X, 5009, X, X, 2423, X, X, 5015, X, X, 5016,
    5010, 1710, 5011, 5020, 5019, 5018, 5014, X, X, X, 5013, 4669, X, 4327, X,
    X, X, 3935, X, 3361, 2227, 2335, X, X, X, 4677, X, X, 3538, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 4681, 8287, 1860, X, 8288, X, X, X, X, X, 4453,
    1452, X, X, 2225, 1861, 3849, 3683, 1936, X, X, X, X, X, X, X, X, 1678, X,
    4488, 3416, X, X, 8357, X, X, X, X, X, X, X, X, 5024, 5021, X, 5023, X,
    4217, X, 5022, 8355, X, X, X, X, X, X, X, X, 5012, X, X, X, 5518, X, X, X,
    3775, X, X, X, X, X, X, X, X, X, X, X, X, 5530, X, 1616, 5519, X, X, X, X,
    X, X, 5536, 5520, 5179, 5177, X, 3065, X, X, X, 5167, 2463, X, X, X, X, X,
    X, X, 3139, 5198, 8373, 3066, 5193, X, 5190, 5191, X, 2607, 5194, 5197, X,
    X, X, X, 4218, 5655, X, X, X, X, 5607, X, X, X, X, X, X, X, 5658, X, X, X,
    5659, X, X, X, X, X, X, 1524, X, 5661, 5330, X, X, 3124, 5336, X, 5331, X,
    X, 5333, X, X, X, X, X, 3792, 3372, X, 5334, X, X, X, 4147, X, X, X, 4175,
    1810, X, X, X, X, 8429, X, X, X, X, X, X, 4181, 5749, X, X, X, X, X, 5748,
    X, X, X, X, 2999, X, 5745, X, 4211, X, X, 3499, 5739, 5456, X, X, X, X, X,
    5458, X, X, 5459, X, X, X, X, X, X, 5460, X, 2015, 1543, 2280, 5461, X,
    5462, 2712, 3073, 8401, 8282, 4661, 3037, 3036, 3157, 2744, 5082, 5081,
    5077, X, X, X, X, 5083, 5084, X, X, 5085, X, X, X, 5088, 5086, X, 5087,
    5089, X, 1571, 3367, 5090, X, 2157, 1683, 3593, X, 5091, 3568, 4728, X, X,
    4738, 3024, X, 8328, 4740, X, 2257, 4730, 3288, X, X, X, X, X, X, X, X, X,
    X, X, X, 4734, 4727, 1798, X, 1863, 1760, 4735, 4731, 8296, X, 8302, 4497,
    X, X, 8300, 4498, 4502, 1455, X, X, X, X, X, 3901, 4501, X, X, X, X, 4500,
    4504, X, X, X, 4503, X, 3357, X, X, X, 2487, 4747, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 4750, X, 4755, X, X, X, 4753, 4752, X, 1609,
    X, X, X, X, 8351, X, 3034, 1853, X, 4994, 4049, X, X, X, X, 3151, X, 1748,
    X, X, 4996, 4998, 1848, X, 8352, 4995, 4997, X, 5000, X, 5265, X, X, X, X,
    2992, X, X, X, 5266, X, X, X, 5267, 1905, 5268, X, 5269, 5270, 3156, X, X,
    X, 2206, X, X, 4106, X, X, X, 3975, 4884, X, 4883, 8342, X, 1595, X, 4885,
    2734, 4887, 3200, X, 4886, X, 3872, X, X, X, X, 2718, 3442, X, X, X, 4888,
    X, X, X, X, 2260, X, X, 5604, X, X, 5611, X, X, X, X, 5617, 3750, 5623, X,
    X, X, X, X, 5618, 5621, 5615, X, X, 3279, X, 3783, X, 5605, X, X, 5613,
    2757, 1906, X, 5279, 5286, 2747, X, X, X, X, 5280, 3607, X, X, X, X, X, X,
    4197, 5282, 5283, 5287, 3457, 5284, 2274, 2975, X, X, 5301, 3685, X, 3183,
    X, 5472, X, X, X, X, 5475, X, X, 2908, X, X, X, X, 4226, 1450, 2413, 3129,
    X, 2598, X, X, 2808, X, X, 5478, X, X, 3429, X, 5476, 3112, 3268, X, X, X,
    5131, X, X, X, X, X, X, 1684, X, X, X, X, 5182, 5133, X, X, X, 3587, X, X,
    5132, X, X, 5130, X, 2345, X, 5136, 4782, 4780, 4778, 4781, X, X, X, X,
    4783, X, X, X, X, X, 4784, X, X, 4785, X, 4786, X, X, X, 4787, 4548, X,
    2629, 2488, X, X, 1680, X, 2699, X, 3074, X, 2264, 2373, 2265, 1959, X, X,
    5045, X, X, 2374, X, X, 2203, 5046, 4047, 3606, 5047, X, 2266, X, X, X,
    1797, X, 3202, 2023, X, 1423, X, 5332, X, X, X, X, X, 5329, X, X, X, X,
    1873, X, X, X, X, X, 1574, 8380, 5335, X, X, X, 4176, X, X, X, X, X, 2805,
    5184, 3532, X, X, X, X, X, X, X, X, X, 4362, X, 5180, X, 8371, X, X, 5186,
    X, 2346, X, 2956, X, 8370, 1461, 4807, X, 2417, X, X, X, X, 2022, X, X,
    3970, X, X, X, 4805, 4808, 2382, 2258, X, X, X, X, X, X, X, 8329, X, X, X,
    X, X, X, 5339, X, X, X, X, X, X, 3128, X, 5346, X, X, X, 5340, X, X, 5337,
    5344, X, X, X, X, 5314, X, X, X, 5750, 5752, X, 1529, X, X, 2287, 4341, X,
    1720, X, 3825, 8431, X, X, X, X, 4200, X, X, 1695, 2846, 5754, X, X, X, X,
    X, X, 3280, 3178, 8448, X, X, X, 2918, X, X, X, 5875, X, 5877, X, X, X, X,
    X, X, X, X, X, X, X, 5876, X, 5849, X, 5848, 5850, X, X, X, X, X, 5853, X,
    X, X, X, X, X, 3418, X, 5847, X, 8444, X, X, X, 5851, X, X, X, X, X, X,
    8454, 8455, X, 4320, X, X, 5901, X, 3002, X, X, X, X, X, X, 5897, 5902, X,
    X, 1579, X, X, 8453, X, X, X, 6709, 3503, X, X, 6714, X, X, X, 6711, 3955,
    6717, 1473, X, X, X, X, 6705, X, X, X, X, X, X, X, X, X, X, X, X, 5819, X,
    X, 5825, X, X, 5823, X, 3392, X, X, 5830, 5820, X, X, X, X, X, 5821, 5797,
    5532, X, 2756, X, X, X, 4870, 2233, 4227, X, X, X, X, 5523, X, 3373, 1694,
    2362, X, 5515, X, 5531, 1756, X, X, 5529, 5533, X, 3461, X, X, X, 5879, X,
    X, X, X, X, X, X, 1645, X, X, X, 3467, 1696, X, X, X, X, X, X, X, 1947, X,
    X, X, 2599, 2399, X, X, 8515, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 6699, X, 6700, X, 1654, X, X, X, 1611, 6697, X, X, 8516, 6608, X, 6609,
    X, X, X, 1615, X, 6616, 6611, X, X, X, 6612, X, X, X, 6613, X, 3102, X, X,
    X, X, 6615, 6614, 6617, X, X, X, X, 6618, 6496, X, X, X, X, X, X, 6499,
    6497, 6498, 2414, 2118, X, X, 3249, X, 3684, X, 2711, X, X, 3616, X, 3742,
    6500, 5246, X, X, X, X, X, X, 1969, 6225, X, X, 6227, X, X, X, 6228, X,
    3580, X, X, 6229, X, X, X, X, X, 6230, 6231, X, X, 2030, 1648, 3514, 3676,
    X, 3772, X, 6046, 4241, 2112, 6047, X, 6045, 3719, 6048, X, 6049, X, 8479,
    1468, X, X, 2811, 6054, X, 6051, 3554, 6050, X, X, X, X, X, X, 1885, 2134,
    3190, 5845, 3598, X, X, 5852, X, X, X, X, X, X, X, X, X, X, X, X, X, 5857,
    5855, X, X, 5858, X, X, 5861, X, X, X, 5854, 3556, 5577, 3551, X, X, X, X,
    X, 8412, X, 5581, 5568, X, 2013, 5571, 2692, X, X, X, 3635, 5573, 2016, X,
    5565, 5567, 5564, X, X, 4339, 1749, 5570, X, 5619, 5644, 5643, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 5649, X, 4329, X, X, X, X, X, X, 5652, 2064, X,
    X, 5648, 5650, 4240, 2395, 3216, 5321, X, 2973, X, 2276, 2887, 1573, 3035,
    5319, 1916, X, X, X, X, X, 2106, X, 3336, 5325, X, X, X, X, X, 3070, X, X,
    5328, X, 8408, 3335, 3519, 1544, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    2995, X, X, 2933, 2077, X, X, X, X, X, X, 5508, X, 4088, 5633, 5620, X, X,
    X, X, X, 2163, 1600, 1754, X, X, 5596, X, 8416, X, X, X, X, 2758, 5625, X,
    5632, 2626, 1773, X, X, 3209, X, X, 2516, X, X, 2001, 2953, 4361, 4055,
    6572, 2965, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1930, 6575, X, X,
    X, X, 7330, X, X, X, 8274, X, X, 3550, X, 3436, X, X, X, X, X, X, 3344, X,
    7343, 8591, X, X, X, 3230, 7339, X, X, X, 4987, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 4215, X, 3570, X, X, X, X, X, X, X, X, X, X, 1790, X, 4531,
    X, X, X, X, X, X, X, X, 4140, X, X, X, X, X, X, X, 4098, X, X, X, X, 4533,
    X, X, 4532, 4535, 4534, X, X, 4536, 73, X, 72, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1190, 1206,
    1205, 1204, X, 8285, X, 3170, 4294, 1451, X, X, X, X, X, X, X, 4450, 1627,
    X, 2009, X, 3266, X, X, X, 2146, 4452, X, X, X, 3575, 8286, X, X, X, 4717,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4732,
    4737, X, 4733, X, 3844, 2989, X, 2582, 4968, 2738, 4969, 4970, 1460, 3127,
    2869, X, 4971, 3496, 2739, X, 2740, X, 4972, X, X, 2990, X, X, X, 2741, X,
    X, X, 8350, X, 5151, 5161, 5159, X, X, 5156, X, X, X, 5155, 4317, X, 5157,
    X, X, 1991, X, 2272, X, X, 2721, X, X, X, 5164, 5150, X, X, 8367, X, 5154,
    1497, X, X, 3231, X, X, X, X, X, X, X, X, X, X, 4788, X, 2353, X, 1456,
    2881, X, X, X, X, X, 4789, 2200, X, X, 2336, X, 4791, 1902, 4525, 4526, X,
    1612, X, X, X, X, 4524, X, X, X, X, X, X, X, X, 2621, X, 4529, 4528, 4527,
    X, 4471, X, 4530, X, X, X, X, 2725, 96, 95, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 98, 97, X, X, X, X, X, X, X, X, 100, 99, X, X, 5017, X,
    X, X, X, 8354, X, 3941, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 2620, 7555, 7556, 2320, X, X, X, X, 8617, X, 7368, X, X, X,
    X, X, X, X, X, X, 7366, X, X, X, X, X, 8596, X, X, X, 7367, 7365, X, 3189,
    X, 7369, X, X, X, X, X, 7557, X, X, 1721, X, X, X, 3618, 7558, 7559, X, X,
    X, X, 3253, 3552, X, X, X, X, X, X, X, 7560, X, X, X, 2885, X, X, X, X, X,
    4811, 4814, X, 2098, X, X, X, X, X, X, X, 4815, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 4251, X, X, X, X, X, X, X, 7799, X, X, X, X, X, X, 7800, 6255,
    X, X, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
    390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
    405, 406, 517, 518, X, 519, 520, 521, 522, 523, 524, 525, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1829, X, 6484, X, 6485, X,
    X, X, X, X, 6303, 3773, X, 3671, 3472, X, 2031, 6302, 6300, X, 3686, 6297,
    3257, 3474, X, 3473, X, 2435, X, X, X, X, X, X, 6321, X, X, 7118, X, X, X,
    X, X, X, X, X, 7126, 7124, X, X, 7121, X, X, X, X, X, X, 7123, X, X, X,
    7122, 7125, X, 1966, X, 7129, 7151, X, X, 7153, 7150, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 7156, X, 2650, X, 7155, X, X, X, X, X, 7157, X, X, X,
    689, X, X, X, X, X, X, X, X, 679, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 3633, X, X, X, X, X, X, X, 4914, 3777, X, X, X, X, 1879,
    X, 5563, X, 8280, 4082, 5538, 1878, X, 5545, X, 8410, X, X, 3979, X, 5546,
    5548, X, 5552, 5540, X, 3205, X, X, X, X, 3462, 8372, 5196, X, X, X, X, X,
    5204, 5203, X, X, X, 5208, X, X, X, 8376, X, X, X, 5209, X, X, 8375, X, X,
    X, X, 5207, 5210, 5202, 5206, 4810, X, X, 4821, X, X, 4822, 8333, 8332, X,
    X, 4015, X, X, 2800, X, X, X, 4824, 4825, 4823, X, 4827, X, X, X, X, X,
    3595, X, X, 1481, 1792, X, 4558, X, 4556, 4070, 4557, X, 3817, 4559, 4560,
    4561, 3446, X, X, X, 4565, 4563, 4564, 4562, 2416, 4566, 4115, 4297, X, X,
    X, X, X, 4567, 8309, X, 4812, X, X, 2354, 8330, 3214, X, X, 4809, 3347, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4813, 4546, X,
    4547, X, X, 3543, 1566, X, X, 4550, 2442, X, 4549, 2387, X, 4551, 6563,
    4552, 3980, 4553, X, 4554, 4555, 2798, X, 2581, X, X, X, 8308, X, X, 5211,
    X, 5212, X, X, 5201, 2535, X, 5205, 3155, 2273, 5187, 2840, X, X, X, X,
    5225, X, 3926, X, X, 5215, 5216, 5217, X, X, 5224, X, 5223, 3813, X, X,
    4828, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2818, X, X, 2562, X,
    3632, 1865, X, 2424, X, X, X, 5242, X, X, 5243, 2358, 5241, 5239, 5238,
    5245, 5237, 5247, X, X, 1688, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    3647, 4455, X, X, X, 3693, X, 4295, X, 2832, 8289, 2482, X, 2530, 1629, X,
    X, 5030, X, 5029, X, X, 5028, X, X, X, 3455, 5007, X, X, X, 5036, X, X, X,
    X, X, X, X, X, X, X, X, X, 5032, X, X, 5814, X, 5808, 4080, X, X, X, 5803,
    X, 2539, 5827, X, X, X, X, 1765, X, 5805, 5810, 5811, X, X, X, X, X, X, X,
    3177, 3159, X, 1968, 3785, X, X, X, 2568, X, X, 2342, X, X, X, X, X, 4342,
    X, 5817, X, 5829, 1576, 3077, X, X, X, X, X, X, X, X, X, X, X, 6160, X, X,
    6159, X, X, 6161, X, X, X, X, X, X, X, X, X, X, X, X, 6163, X, 2236, X, X,
    X, X, 6187, 3375, X, X, X, X, 6190, 1714, 6185, X, X, 3739, X, 1519, X,
    2425, X, 4373, X, X, 6189, X, X, X, X, X, 2935, X, 1764, 2398, 2761, 5762,
    2665, X, X, X, X, X, X, X, 2111, X, 5761, X, X, X, 5783, 2708, 2187, X,
    5798, X, 5792, 2388, X, X, 4499, X, X, X, X, 2145, 4148, X, 3947, X, 3853,
    8402, 5463, X, X, X, X, 2432, 3320, 5464, 4338, X, X, X, 3977, X, 3300,
    5465, 1877, 1596, 2925, 5116, 5115, 2101, 3153, X, 5121, 5119, X, 5118,
    4236, 2230, X, X, X, 2720, 5120, 3427, 2661, X, X, X, 3509, 5124, 5123, X,
    X, X, X, 5122, X, 1431, X, X, 2025, 2958, X, 3823, X, X, X, 5406, 2477,
    3234, X, 2502, 2842, X, X, X, X, X, X, 5407, X, 3946, X, X, 1590, 2503, X,
    X, 2378, X, X, X, X, X, X, X, X, X, 6179, X, X, X, X, X, 6180, X, 2167,
    2402, X, X, X, X, X, X, X, X, X, X, X, 1491, X, 6652, X, X, X, X, 6653, X,
    X, X, X, X, X, 3830, X, X, X, 2576, X, 6655, 6594, X, 6595, 6591, X, X, X,
    X, 6592, X, 6593, X, X, X, X, 2304, X, X, X, 6601, X, 6597, X, X, X, X,
    3829, X, 4023, 3767, X, X, 7268, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 7269, X, X, 8551, X, X, X, 7270, X, X, X, X, X, X, 6735, X, 8519, 4188,
    X, X, X, X, 4239, X, X, X, X, X, X, X, X, 3283, X, X, X, 1766, X, X, X, X,
    7462, X, X, 4065, X, X, 7463, X, X, X, X, X, 7464, X, 4333, 8604, X, X, X,
    X, 5468, 7465, X, 8605, X, 7466, 7467, X, 2072, 7207, 7208, 7209, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    2860, 7210, X, 2550, 7211, 8580, X, X, X, 2722, X, X, 8574, X, 7327, 3916,
    X, X, 1555, X, X, X, X, 3797, 3277, X, X, X, X, 1967, 8281, 7329, 8584,
    2316, X, X, 8587, 1506, X, X, 4286, X, X, X, 7436, 7251, X, 7435, X, X, X,
    X, 8603, 7439, 7437, 7438, X, 7440, X, 7441, 4305, 7442, 7443, X, 2954,
    3692, X, X, X, 4541, X, 8307, 3571, X, X, 3027, 4543, 4544, 3677, 2249,
    4350, 4545, X, X, 1979, X, X, X, 3881, 3123, 2054, 3404, X, X, X, 2150, X,
    X, X, 4893, 8343, 3138, X, X, 3971, X, X, X, 3425, X, X, X, X, X, 4894, X,
    X, X, X, X, X, 4016, 8344, 2391, X, X, 2735, X, 8362, X, X, X, 4120, 2186,
    2205, X, 5099, X, X, X, 5100, X, 5106, X, 2606, X, X, 8363, 3294, X, 1988,
    5101, X, X, X, 3770, X, 3233, X, 4177, 5364, X, X, 5360, X, 5361, X, X, X,
    X, X, 3071, 8383, X, X, X, 5359, X, 5294, X, X, X, 5363, X, 5358, X, X, X,
    X, X, 5490, X, 3755, X, 5481, X, 5487, 5486, X, X, X, 2960, X, X, X, X,
    4024, X, 4280, X, X, 4018, X, 1641, 2505, X, X, 2471, 6468, X, X, X, X,
    6473, 6474, 8272, X, 6475, X, 6481, 3410, 6477, X, 6476, 6478, 6479, X,
    6480, X, X, X, X, 6482, 6483, X, X, X, 7354, X, X, 8593, X, 7357, X, X, X,
    X, X, X, X, 7356, 3396, X, X, X, X, 7349, 7350, 7353, X, X, X, X, 7355,
    8594, X, 7116, X, X, X, 3311, X, X, X, X, 1562, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 7117, X, X, X, X, X, X, 6542, X, X, X, 6541, X, X, X, X, X,
    X, X, 6543, X, X, X, 2940, X, 6544, X, 6545, X, X, X, 3878, 6546, 2294, X,
    6384, X, X, X, X, 4269, X, X, X, X, X, X, X, 6386, X, X, 6387, X, 6388, X,
    6389, X, 2512, X, 6390, 2114, X, X, 1953, X, 1826, X, X, X, X, X, X, X, X,
    3224, X, X, 3006, X, X, X, 3667, X, X, 6327, X, X, X, 3669, X, X, X, X, X,
    X, X, 6421, X, X, 2032, 3741, X, X, X, 3084, X, 4277, 2710, X, X, 6469,
    8509, X, 6431, X, 3007, X, 6427, 6432, 6434, X, 2019, 2076, 6364, X, X, X,
    X, X, 3873, X, 2891, X, 4057, X, X, 6365, X, 4248, X, X, 3655, X, 3045,
    3591, X, X, 2676, X, X, X, 1441, 2337, X, 3923, 6249, X, X, 3999, X, X,
    6251, X, X, X, 2962, 1550, 1623, 1421, X, X, X, X, X, X, 6250, X, X, X, X,
    X, X, X, X, 5908, X, X, X, 5909, X, X, X, X, 3585, X, X, X, X, X, X, X,
    5911, X, X, X, X, 5912, X, 5866, X, X, X, 8446, X, 8447, X, 5862, X, 5863,
    X, X, X, 5867, X, 5865, X, X, X, 3805, X, X, 5873, X, 5870, 5869, X, 5872,
    3529, 5874, 5598, X, X, X, X, X, X, 5595, X, X, X, X, X, X, 5583, X, X,
    5612, 5582, X, 5601, X, X, X, X, X, X, 5593, X, X, 5588, 5585, 2705, 5271,
    X, X, X, X, X, 2993, 7266, 3731, X, 2611, X, 2394, 5272, X, X, X, X, 3140,
    X, 3860, X, X, 3182, X, X, 5275, X, X, 5273, X, 5447, X, X, 5452, X, X,
    3539, X, 5449, X, X, X, X, X, X, X, X, X, X, X, X, 5454, X, X, 2707, 5455,
    X, 4178, 3659, X, X, 2641, 2191, 3047, 6396, 6402, X, 8505, X, X, 6397,
    2115, X, 6405, 6409, 2142, X, X, X, X, X, 6404, X, X, X, X, 6413, 8506, X,
    2297, X, 1827, X, 6344, X, X, X, 6345, X, X, 6346, 6349, X, X, X, X, X, X,
    X, X, X, X, X, 6348, 3751, X, X, X, X, 6350, 4321, 3930, 1888, X, X, X, X,
    X, X, X, 6238, X, X, 3377, X, 6239, 2952, X, X, X, X, X, 4054, X, X, 3762,
    6240, 6241, 3248, X, 4268, X, X, 6243, 6114, X, 8480, 6115, 3393, X, 1698,
    2291, 6116, X, X, 6117, X, X, 6118, X, 2452, X, X, 6120, X, X, 6119, X, X,
    6121, 6122, 8483, 8481, X, 8482, X, 2767, X, X, 6141, X, X, 6140, 6139,
    3758, X, 1824, 2170, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 6147, X, X,
    6144, 2850, 2401, 5942, 5941, X, X, X, X, 5943, X, X, X, X, X, X, X, X, X,
    X, 5944, X, X, X, 5945, X, X, X, X, X, X, X, X, X, 1867, X, 4928, 4927, X,
    X, X, X, X, X, X, X, X, 4929, X, X, X, X, X, X, X, X, X, 2902, X, X, 5025,
    8358, X, 2372, X, X, X, 5026, X, X, 5027, X, X, X, X, X, X, X, X, X, 5039,
    X, X, 1849, 5040, X, X, 8361, X, 5042, 5041, X, X, 5043, X, X, X, X, 5044,
    X, 2991, 2634, X, 2536, 5307, X, X, X, X, 2499, 5308, 1445, X, X, 5303, X,
    X, X, X, 3298, X, X, X, X, X, X, X, 1962, X, X, X, X, X, 1993, 4937, X, X,
    4935, X, 4936, X, X, X, X, X, X, X, X, X, X, 2493, 4938, X, X, 2261, 4939,
    8345, 2533, 3125, X, 4940, 4941, 2501, 2262, X, 4091, 8316, 4113, 3564, X,
    X, 3934, 4623, 8317, 4624, X, X, X, X, 4626, X, 4628, 4627, X, X, X, X,
    4629, 1626, 3991, X, 2441, 4630, X, X, 3064, X, X, 5299, X, X, 3215, 5293,
    5300, 5295, 5302, 5298, X, 5297, 3650, X, 5291, 1690, 5289, 1960, 3184,
    5285, X, X, 5288, 2275, 2972, X, 2748, 5296, 3621, X, X, 6128, 3625, X, X,
    4010, X, 1549, X, 1558, X, X, 6129, X, X, X, X, 6131, X, X, X, 6130, 3463,
    X, X, X, 2938, 5664, X, 6132, 4074, 1909, X, 5946, X, X, X, X, 5947, X, X,
    X, X, 2165, X, X, 3705, X, 8459, 5949, X, X, X, 2810, X, X, 5948, X, X, X,
    X, 8460, X, 8457, X, 3590, X, X, X, X, 3468, 5914, X, X, X, X, 5916, X,
    4282, X, 5913, X, 5915, 1580, X, 5910, X, X, X, X, X, X, X, 4758, 2138,
    2538, X, 2026, X, X, X, 1601, X, X, X, X, X, X, X, X, X, X, 4198, X, X, X,
    X, 5663, 5662, 5665, 1908, X, X, 2027, 1815, X, 5717, 5714, 4199, X, X,
    8426, X, 3321, X, X, X, 3534, 5715, X, X, 5723, X, 5722, 2070, X, X, 1610,
    X, X, 2376, 5716, 5718, X, X, X, X, 6038, X, 6043, X, X, 6041, 6040, 5391,
    1697, 6039, X, 1467, X, 3675, X, X, 3707, X, X, X, X, 4246, 6044, 6042,
    3255, 2919, X, X, 6920, X, 6922, X, X, X, X, X, X, 3744, X, X, 6918, X,
    6923, 6925, X, X, 2212, 6913, X, 1442, X, X, X, X, X, X, X, 6924, 6954, X,
    X, X, 6957, X, 6956, X, X, X, 6959, X, X, 6958, X, 6960, X, X, 2648, X,
    6961, X, X, 6962, X, X, X, X, X, X, 6963, 2943, 1554, X, 7001, 2123, X, X,
    2521, X, X, 2520, X, 4368, 7000, 6999, 3014, X, 1924, 4358, 1717, 2785, X,
    X, X, X, X, 8532, X, X, 6998, X, X, X, 7698, X, X, 7696, X, 1782, X, 7695,
    2555, 1606, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2322, X, X, 7705,
    7704, 7767, X, X, X, X, 7768, X, X, 7769, X, X, X, X, X, X, 7770, X, X, X,
    X, 7771, X, 7772, 7773, X, 7774, X, 7775, 7776, 7777, X, X, 282, 283, 284,
    285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
    300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, X, 9,
    8647, 83, 79, 82, 84, 8646, 41, 42, 85, 59, 3, 60, 4, 30, 203, 204, 205,
    206, 207, 208, 209, 210, 211, 212, 6, 7, 66, 64, 67, 8, 13, 252, 253, 254,
    255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
    270, 271, 272, 273, 274, 275, 276, 277, 47, 34, 48, 32, X, 7511, X, X,
    7510, X, X, X, X, X, X, X, 3990, 3489, X, X, X, X, X, X, 1551, X, X, 7512,
    7509, X, X, 3808, 4209, 7513, X, X, 570, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 564, 565, 566, 567, 568, 569, 571, 572, 573, 574, 575, 576, 577,
    578, 579, 580, X, 1692, 2367, 7630, 7629, 4046, X, X, X, X, X, X, X, 7632,
    7633, 7631, X, 7634, X, X, 4013, X, X, X, 7635, X, 1970, X, X, X, X, X,
    7753, 3665, X, X, 7754, 7756, X, X, 7757, X, X, X, X, X, X, X, X, X, X,
    7755, 2332, 4086, 4014, 5068, X, 5703, 4038, 7801, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4915,
    4919, 4916, X, 5102, X, X, X, 8283, X, X, 5103, X, 1989, X, 5104, X, 5105,
    X, X, 5107, X, 3469, X, X, 5108, 5109, X, 5110, X, X, 5095, 5094, X, X,
    5990, X, X, X, X, 6011, X, X, X, X, X, X, X, X, 1821, X, X, X, X, X, X, X,
    X, X, X, X, X, 2542, X, X, 6866, X, X, X, X, X, X, X, X, 6875, X, X, X,
    6869, X, X, X, 6877, X, X, X, X, X, X, 4205, 6880, X, 6871, X, X, 4234,
    3558, X, X, X, X, 1514, X, 2980, 2559, X, X, X, X, 3876, X, 1535, X, X, X,
    4306, 4210, X, 7452, X, 3420, X, X, X, X, 3338, X, X, 3197, 4459, X, X, X,
    X, X, 1453, 3356, 2658, 2369, 4139, X, 3147, X, 1628, 8290, 4458, X, 4165,
    4454, 4456, 2427, 4457, 4891, X, 1538, 3056, 2254, 2198, 2044, X, X, 4664,
    3196, 3195, 1984, 2729, 4665, 4663, 1633, 3171, 2561, 2486, 1509, X, X,
    1771, 2325, 2485, X, 4666, X, X, X, X, X, 89, 88, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 63, X, X, X, X, X, X, X,
    X, X, 7378, X, X, 7306, X, X, X, X, X, X, X, 4304, X, X, 2219, X, 8569,
    8563, X, 8565, X, X, 7316, 3144, X, 7419, X, 3836, X, X, X, X, X, X, 7422,
    7420, 2318, X, 7421, 2195, X, X, X, X, X, X, X, X, X, X, 3890, 7424, 7426,
    7425, 7427, 7474, 7758, 4085, X, 7475, X, 7476, X, 7477, 1746, X, 7479, X,
    2876, X, X, X, 7480, X, X, 2071, X, X, X, X, 7481, 7485, X, 7483, X, X, X,
    2461, 4657, X, X, X, X, 4031, 2370, 1937, 4142, 3055, 3696, 2630, X, X, X,
    X, X, 2670, X, 2609, 2622, X, 2717, X, 3697, X, 8322, X, 4660, 4438, 3967,
    4439, X, 2243, 1480, 4029, X, 1971, X, X, 1972, 1973, 3355, 4257, X, 4440,
    X, X, 4441, X, X, 4442, X, X, X, 2864, X, X, X, X, X, X, 7735, X, X, X, X,
    X, X, 7736, X, 7737, X, X, 4364, X, X, X, X, X, 7734, 3176, 2426, X, X,
    7738, X, X, 1195, X, X, X, X, X, X, X, X, X, 175, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 159, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 1178, 1179, X, X, X, X, X, X, X, X, X, X, X, X, 1175, 1176, 1177,
    X, 2833, X, 4030, 4480, 4481, X, X, X, X, X, X, X, X, 2635, 4494, X, X, X,
    3619, X, 3781, 4489, X, 3933, X, 1619, X, X, X, 4493, 8298, 658, 669, 659,
    670, X, X, X, X, X, X, X, X, 660, X, X, 671, 661, X, X, 672, 663, X, X,
    674, 662, X, X, 673, 664, 685, X, X, 1929, 2988, 2565, 4143, 4952, X, X, X,
    X, X, X, X, 1939, X, 2392, X, X, 1709, 1570, 2737, 1637, X, 4953, 4173, X,
    X, X, X, X, 2672, 4636, 2660, X, 2986, X, 4638, 4637, 2728, 2226, 4640,
    3695, X, X, 4641, X, X, X, 3725, 3121, 3179, 1981, X, X, 3555, 3212, X,
    3649, X, 3993, X, 4643, X, 1459, X, 1412, X, X, X, X, X, 4905, X, X, X, X,
    X, X, X, 4903, X, X, X, X, X, X, 4069, X, 4906, X, 4904, X, X, 4902, 8314,
    4611, X, 4001, X, 3317, X, 4141, X, 3910, X, X, X, 4612, X, X, X, X, 7478,
    X, X, 3493, X, 4613, 1795, 4060, X, 8315, X, 2726, 4614, 3924, 345, 346,
    347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361,
    362, 363, 364, X, X, X, X, X, X, X, 10, 11, 20, 21, X, 1181, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    3835, X, X, X, 4515, X, X, 2020, X, X, X, 4512, 4513, X, X, 3492, X, 3099,
    X, 1976, X, X, X, 3992, 4516, X, 8305, X, 4258, X, X, X, 4517, X, 1496,
    4714, X, X, 4706, 4707, X, 2730, 4020, X, X, X, 4712, 4711, X, X, X, 3398,
    X, X, X, X, X, X, X, 4713, X, X, 4710, X, 8327, 1975, 1630, X, X, X, X, X,
    X, X, X, X, 4892, X, 4036, 3837, 2245, X, X, X, X, X, 2834, 4252, X, X, X,
    X, X, X, X, X, 3909, 65, 158, X, X, X, X, 68, 69, X, X, 160, 161, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 155, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 4719, 4138, X, 2732, X, 4725, X, X, X, X, 4724,
    4715, X, X, X, X, 3136, X, 1638, 4961, X, 4959, 4963, 4960, 3582, 5590,
    2838, X, 4964, 8349, X, 4261, X, 4965, X, X, 4967, X, 3289, 4966, X, 2916,
    X, 2534, X, X, X, 3149, 2624, 4651, X, X, X, X, 4653, 4652, X, 2882, 1528,
    X, X, X, 1565, 4654, X, 4655, X, 8321, 2184, X, X, 4656, X, X, X, X, 1957,
    X, X, X, X, 4858, 4856, X, X, X, X, X, 2489, 2868, X, 3059, 4860, 2941,
    1486, 3639, X, X, X, X, 3348, X, 4862, 4861, 4863, 4864, 4865, X, X, 5501,
    X, 5498, X, X, 5506, X, 5496, X, X, 5494, X, 5502, 5492, X, 3271, X, 4129,
    2575, 2433, X, X, X, X, X, 2375, X, X, 4026, 1724, 5138, X, 1687, 5158,
    5160, 3244, X, X, 2357, 1621, 5152, 5163, 5162, 1992, X, 3110, 1761, X, X,
    X, X, 2102, X, 5153, X, X, X, X, X, X, X, X, 3994, X, X, 4844, X, X, 4849,
    X, X, X, 8337, 3868, X, X, X, X, 4848, 4842, 4845, 4847, X, X, 2355, X,
    5071, 5072, 3620, X, X, X, X, 5073, 4316, 4336, X, X, X, X, 5075, 5074, X,
    X, 1730, X, X, 5076, X, X, X, 5079, 5080, X, 5078, X, 3791, 4716, X, X, X,
    3180, 4721, 2731, X, X, X, X, X, 4718, X, X, 4109, X, X, X, 2095, X, X,
    4722, 4723, X, X, X, X, 4720, 4726, X, X, 1811, 2465, X, X, 3533, X, X, X,
    X, X, 2108, X, X, X, 2903, X, 5399, X, 2929, 3391, X, 3822, 5400, X, X, X,
    X, X, X, X, 4150, X, X, X, 5788, X, X, 5781, 3465, X, X, 5784, X, X, X,
    5790, X, X, X, X, X, X, X, 4372, 2567, 4363, 5489, 2904, X, X, X, 5488, X,
    X, 5483, X, X, X, X, X, 2208, X, X, X, 5495, 5493, X, 1642, 5491, 5497,
    5503, X, 8405, X, X, X, X, 5906, X, X, X, 5898, X, 2074, X, X, X, X, 5904,
    X, X, X, X, 4183, 5907, X, X, X, 7807, X, X, X, X, X, 2678, 5636, X, 5638,
    5639, X, X, X, X, X, X, 5651, X, 5647, X, 5528, X, X, X, X, 5646, X, X, X,
    X, 5645, X, X, 5642, X, X, X, X, 8461, 5969, X, X, X, 5968, 3281, 3584, X,
    X, 2166, 5967, X, X, X, X, 5966, X, 4152, 4153, X, X, X, X, X, X, 5970,
    1581, 4203, X, X, X, X, 5773, 5767, 5764, X, X, X, 4281, 5770, X, X, 8434,
    X, 2673, 5772, X, X, 5777, X, X, 3464, 5775, X, X, X, X, 5769, X, 4243, X,
    X, 2809, 2998, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    5755, 5753, X, 3804, X, X, X, 2469, X, 1592, 6035, X, 4184, X, X, 3920,
    6036, X, X, 8347, 3419, 4154, 2290, 2848, X, X, X, 3238, 4625, X, 3303,
    1669, 6037, X, X, X, 6814, 3605, X, X, X, X, 6815, 6816, 6826, X, X, X,
    6820, 6823, X, X, X, X, X, 6819, X, X, X, X, X, X, X, X, X, 1850, X, X, X,
    X, X, X, X, X, 4301, 5983, X, X, X, X, X, X, X, 5985, X, 8464, X, X, 6868,
    X, X, X, X, X, X, X, X, X, X, 4162, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 6867, 6883, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 6881, X,
    X, 6882, X, X, X, 6887, 6888, X, 1701, X, 1913, X, X, 6886, X, 2214, X, X,
    1502, 6566, X, X, X, X, X, X, X, X, X, 6573, X, 6574, X, X, 3502, X, X, X,
    2000, X, X, X, 6585, 3600, X, X, 7218, X, X, 7217, 1661, X, X, 3563, 7219,
    3658, X, 3402, X, 7220, 2681, X, X, X, 7222, X, X, 4075, 7237, 7224, 7225,
    X, X, 3330, X, X, 7575, X, X, X, X, X, X, X, X, X, X, 7566, 7567, X, X,
    7568, 7569, X, X, X, X, X, 7571, X, X, 7570, X, X, X, 2688, 7598, X, X, X,
    2900, X, X, X, X, X, X, X, X, X, X, 7599, X, 7600, X, 7601, 7602, X, X, X,
    2321, 8619, X, X, 8620, X, 7603, 7604, 7643, X, X, X, X, X, X, X, 7644, X,
    4025, 2456, X, 2439, 3022, X, X, 8624, X, X, 7645, X, X, X, X, 7648, X,
    8625, X, X, X, X, 4520, X, 4518, X, 3053, X, X, X, X, X, 4519, 4521, X, X,
    X, X, X, 8304, 4523, X, X, X, 4522, X, 3893, X, X, X, X, 4745, 4743, X,
    4800, X, X, X, X, X, X, X, X, X, X, X, X, 4748, X, X, X, X, X, 4742, X,
    4746, X, X, 4744, 4507, X, X, X, X, 4509, X, X, X, X, X, X, X, 3968, X, X,
    X, 2137, X, X, 8303, X, X, X, 2460, 3752, 4508, X, X, X, X, X, 154, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1216,
    X, 7703, X, X, 7700, X, 7706, X, 7707, X, X, X, X, X, X, X, 7712, 7711, X,
    X, X, X, X, X, X, 7713, X, X, 1516, 7708, 7709, X, 7412, 7414, X, X, 7413,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 8630, 7739, 7740, X, X, 7741, X, 7415, X, X, X, X, X, X, 7416, X, 2418,
    X, X, X, 7417, 7418, X, X, 3988, X, X, X, X, X, X, X, X, 3050, X, X, X,
    1413, 2628, X, X, X, 7453, X, 7454, 2863, 7455, X, 4307, X, X, 7450, 7457,
    7459, X, 7458, X, 7456, X, X, 7460, X, X, 7461, X, X, 3097, X, 1663, X,
    7169, X, X, X, X, X, X, X, X, 7168, 2859, 7170, X, X, 2050, 7171, 7173, X,
    X, X, X, X, X, X, X, X, X, X, X, 7174, X, 6908, 6915, X, X, X, X, X, 2089,
    X, X, 3163, X, 6921, X, X, X, X, 6917, X, X, X, 3122, 6916, X, 6919, X, X,
    X, X, 6910, X, 6658, X, 6659, X, 2604, 2049, 3282, X, X, X, 3526, X, X, X,
    X, X, 1552, X, 6663, 6662, X, X, X, X, 6668, 6664, 6667, X, X, X, X, 8592,
    X, X, 1718, X, X, X, X, 7345, 7346, 3324, X, 7344, X, X, X, X, X, X, X, X,
    7348, X, X, X, X, X, X, 8560, X, X, X, 8562, X, X, 3540, 1726, X, 8561,
    7308, X, X, 7305, 7307, X, X, X, X, X, X, X, X, 7303, X, 6969, X, X, X, X,
    6971, 4222, X, 6970, 2857, X, 6972, X, X, 6973, X, X, 6974, 1834, X, X, X,
    X, X, X, 6975, X, X, 6976, X, 6977, 2944, 7006, X, 7011, 2238, 7008, 7009,
    8533, 7005, X, X, X, 2979, 3518, X, X, 3210, X, 1658, X, X, X, X, X, X,
    3745, X, X, 1914, X, 8534, 3309, 3984, 1561, 1475, X, 3482, X, X, 7028, X,
    X, X, X, 7027, X, 3547, X, 7032, X, X, X, 7021, X, 7031, 7033, X, 2173,
    7029, 2309, X, 2590, X, X, 1897, X, X, X, X, X, X, 7530, X, 7531, X, 4617,
    5666, 3716, X, X, 1500, X, 1436, X, X, X, X, X, X, X, 2527, 3963, 2819, X,
    2087, 7264, X, 7265, X, X, X, 3843, X, X, X, X, 1743, X, X, X, X, X, X, X,
    4160, X, 2004, X, X, X, X, X, 3435, X, X, 7589, X, 7591, 7590, X, X, X,
    7592, 7594, 7593, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483,
    484, X, 3664, X, X, 3145, 1559, 2051, X, 2052, X, X, X, X, X, X, X, 3278,
    7565, 2053, X, X, 1676, X, X, 7564, X, X, 7562, X, 7563, X, 7561, 7581, X,
    7580, 7582, X, 7579, X, X, X, X, X, X, X, 7585, 8618, X, X, X, X, X, X,
    7584, X, 7587, X, X, 2008, 7586, X, X, X, 7588, 7646, X, X, X, X, X, 7649,
    X, X, 2242, 7647, X, X, X, X, 7650, X, 7651, 7652, X, 7656, X, 2453, X, X,
    X, X, 3169, X, X, X, X, 3359, 4588, X, X, 3108, X, X, 2428, 4589, 4590,
    3023, X, 4587, X, X, X, X, 4592, X, 3969, X, X, X, X, 2323, X, X, 4591, X,
    3894, X, X, X, 4850, X, 3232, X, X, 1682, X, 2802, X, X, X, X, 4852, X,
    4851, X, 2327, X, 4853, 4855, 4854, X, X, 4857, X, 4846, 4859, 3448, X, X,
    2866, 4578, X, 3865, 2971, 1787, X, 1794, 4579, X, X, 4581, X, X, 2093, X,
    X, 4580, 8311, X, 4312, X, X, X, X, X, 2704, X, X, 4146, X, X, X, X, 5229,
    X, X, 5233, X, X, X, 3101, X, 4318, 5234, X, X, 5231, X, 5228, X, 8377,
    5227, 5232, X, X, X, X, X, 2886, X, X, X, X, X, 2496, X, 2955, X, 3152,
    1881, X, X, 3291, X, X, 5053, 5054, 2804, X, X, X, X, 3972, X, X, 3187, X,
    X, 5993, 8471, X, X, 8473, 8472, X, X, X, 8474, X, X, X, 5995, 4283, 2028,
    3757, 3613, X, X, X, 5996, X, X, X, X, 5998, 1963, 3430, X, 5787, 5796,
    1424, 1521, 8440, X, 1622, X, 5789, 3113, 5780, 5782, 2288, X, X, X, X, X,
    X, X, X, 5799, 8438, 5794, X, 8441, X, 5786, X, 3219, X, X, 5776, X, 5765,
    X, 5771, X, 5778, 1501, 5768, X, 5779, X, X, 2847, 8436, 2694, X, 3858, X,
    2363, 8435, 5760, 5774, 3409, 8437, X, X, X, 1777, 6269, 6268, X, 6272,
    6265, X, 6273, 4238, X, 6274, X, 6275, X, 8499, 4877, 6277, X, 6276, X, X,
    X, 6278, 6279, X, 4250, 6280, X, 7504, 6214, 2090, X, X, X, X, X, 1911,
    1886, 2510, X, X, X, X, X, X, 4155, X, X, 6220, X, 6219, 3043, 6216, X, X,
    6218, X, X, 2674, 2851, 6217, 4289, X, 8475, 6005, 7805, X, X, X, X, 6003,
    6006, X, X, X, X, 5992, 6004, X, X, 2377, X, X, 6007, X, X, X, X, X, X, X,
    6008, X, 8478, X, 6027, 6026, 6028, X, X, X, X, X, X, 6029, 6031, 6030, X,
    X, 2344, X, 6033, X, 6032, X, X, 1822, X, 2870, X, 3411, X, 6034, 2937,
    5835, 5834, 5840, X, 2914, X, 5831, X, 8443, X, X, X, X, X, 5843, X, X,
    5844, X, X, X, X, X, 1819, X, X, X, X, X, X, X, X, 5704, X, X, X, X, X, X,
    2508, X, 4058, X, 5705, 5706, X, X, 1883, X, X, X, 5707, X, X, X, X, 2189,
    X, X, 4237, X, 2017, X, 1603, X, X, X, X, X, X, X, X, X, X, 2047, X, X, X,
    X, X, X, X, X, X, 3111, X, X, 2454, 5313, X, 5315, 5311, X, X, X, X, 3918,
    X, 3318, X, X, X, X, 3067, X, X, X, 5709, 5708, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 2888, X, X, 3784, 1545, X, X, X, X, X, 3702, 8424, 8385,
    X, 2278, 5421, X, X, 2360, 2751, X, 8388, 5420, X, 2752, X, 4073, 2359, X,
    X, X, 1464, 2959, 8386, X, X, X, X, X, X, 5427, X, 8390, 2930, 3426, 2577,
    X, X, 3063, 4225, X, X, X, X, X, X, 4985, X, 4986, 3531, X, 2462, X, X, X,
    X, 4988, X, X, 4989, X, X, X, X, X, X, 5341, X, 5345, X, X, X, 3699, 3458,
    X, X, X, X, X, X, 5338, X, 5342, X, X, X, 2107, X, X, X, 2430, X, 2282,
    1783, X, X, X, X, X, X, 5510, 1775, 5516, X, X, X, X, X, X, 5513, X, 2996,
    X, X, X, 1734, 2361, X, X, 1733, 2396, X, X, 6501, 6503, X, 4204, 6502,
    6505, 6504, X, 4186, X, 6506, X, 3759, X, X, X, X, X, 6507, X, X, X, X, X,
    6510, X, X, 6509, 6508, X, 1582, X, X, 3553, 6438, X, X, X, 6445, 6439,
    6446, X, X, X, X, X, X, 6442, X, X, X, X, X, X, X, X, 3662, X, X, 2579,
    6444, 6336, X, X, X, X, X, X, 6337, X, X, X, X, X, 6342, X, X, X, 6331,
    4658, 6338, 6332, X, X, 6341, X, X, X, X, X, X, X, 6347, 2639, 2511, X, X,
    X, X, X, X, X, 6232, X, 2640, X, X, X, X, X, 1639, 3794, X, X, 6233, X, X,
    3740, X, X, X, X, X, X, 3044, 6090, 6091, 6092, X, 6093, X, X, 6089, X, X,
    X, X, X, X, X, X, 6095, X, X, X, 6094, X, X, X, X, X, X, 6096, X, X, X, X,
    6821, X, 6822, 2593, X, 6824, X, 3228, X, 2121, 1725, X, X, X, X, X, 6827,
    X, X, X, X, 1722, X, 6832, X, X, 6828, 6831, 6772, X, X, X, 3657, X, X,
    6782, 6774, X, 6776, X, X, X, X, X, 6786, 6775, X, X, 6779, X, X, 1585, X,
    3546, X, 6780, 6783, X, X, X, 7532, X, 4104, X, X, X, 7533, 4195, X, 1537,
    X, X, X, 2476, X, 7534, 1675, 7535, X, X, X, 7536, X, X, X, X, 7538, 7539,
    X, 7298, X, 3353, 8558, 8559, 4000, 2065, X, X, X, X, X, 8556, 8557, X, X,
    X, X, X, X, 7301, 7302, X, X, X, X, X, 7300, X, X, 7304, 7395, X, 1841,
    1744, 2317, 3687, X, 7397, 7396, X, X, X, X, 7398, X, X, X, X, 1563, X, X,
    X, X, X, X, 7401, X, 7400, 7399, X, 7402, X, 7158, X, X, 7161, 7160, X,
    7159, X, X, 7163, 7162, X, 4127, X, X, X, 7165, X, 7164, 7166, X, X, X, X,
    7167, X, X, X, X, X, X, 6581, X, X, X, X, 6579, X, X, 2872, X, 3828, 6584,
    X, 6583, 2303, 4374, X, X, X, X, X, X, X, X, X, 6600, 3046, 3981, 2436, X,
    X, X, X, X, X, X, X, 2514, 3350, X, 6398, 4292, 2406, X, 6399, 2853, X,
    6401, X, X, X, 2775, 2365, X, X, X, X, 6400, 1753, X, X, X, X, 2877, 3827,
    X, 6295, X, X, X, 3173, X, X, X, X, X, X, 6290, X, 6294, 6296, X, X, 2440,
    X, X, X, X, X, X, 6181, X, X, X, 6183, 6213, 6212, X, X, X, 8492, X, X, X,
    X, X, X, X, X, X, 2545, X, 4302, X, 2587, X, 2769, X, X, X, X, X, 6208, X,
    X, X, X, X, X, 3042, X, X, 6210, 6209, X, X, X, X, X, X, 6211, X, X, X, X,
    X, X, 8484, X, X, X, X, X, X, X, 3738, X, 6123, X, X, X, 6124, X, X, 7780,
    6125, 6126, 6127, X, X, X, X, 2457, 5935, X, X, X, X, X, 5936, 3903, 3704,
    X, X, 5937, 3626, X, X, X, X, X, 3302, X, X, X, X, X, 5938, 1668, X, 1956,
    X, 4079, X, 4063, 3374, 2664, 1944, X, X, X, X, X, X, X, X, X, X, X, 3703,
    X, 2551, X, X, X, X, 5711, X, 1817, X, X, 1591, X, 8425, 3559, 5710, 2285,
    1542, X, X, X, 8391, 2684, X, 4017, 2431, X, X, X, X, 2753, 8389, 2920, X,
    8279, X, X, 5426, 5424, 5425, X, X, X, X, 8387, 3270, X, X, 5457, 3506,
    1987, X, X, X, X, X, X, 1666, 5003, 5008, X, X, 5006, X, 3940, 3939, X, X,
    X, X, 8353, 3454, X, X, X, 5005, 2683, X, 5004, X, X, 1487, X, X, 5813, X,
    X, X, X, 5801, X, X, X, X, 5807, X, X, 5809, X, X, X, 4182, 5804, X, X,
    3397, X, X, 5806, X, 8442, 5511, 2136, 2110, 3460, 8409, X, 5509, X, 1447,
    X, X, X, X, 5512, 5514, X, 2018, 2079, 8406, 1813, 1922, X, X, X, X, 5517,
    X, X, 2438, 4028, X, 2466, 4145, X, X, 1806, X, X, 1560, 5175, X, 3597,
    1422, X, X, X, X, X, X, X, 3730, 5135, 5181, 5185, 4110, X, 5178, X, X, X,
    3456, 5183, X, X, 4230, 6075, X, X, X, X, X, 3080, X, X, X, X, X, X, 6081,
    X, 6083, 6084, 3247, X, X, X, X, X, 6082, X, 6079, X, 6077, 6078, 2329,
    3579, X, X, 5758, X, X, X, X, X, X, 4219, 5856, X, 5860, 3186, X, 5859, X,
    5838, X, 8445, 7404, X, X, X, 5864, X, X, X, 5868, X, 5816, X, X, X, 1820,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 2140, X, X, X, 5842, X, X, 5837,
    3001, X, X, 1758, 4371, 5537, X, X, 5551, 1465, X, X, 5539, X, X, 4067,
    5544, 2821, 3328, 5534, X, X, 5550, X, X, X, X, X, X, 2909, 5560, 1772,
    2162, X, X, X, 2666, X, X, X, X, 5976, X, 5975, X, X, X, X, X, 5977, X,
    1736, X, X, 5979, X, 8463, 5978, X, 5981, 5980, X, X, X, X, 3480, 6794, X,
    X, X, 3710, 6781, X, X, X, X, X, X, X, X, X, X, X, X, 2714, X, 6796, 6801,
    3091, X, X, 6800, X, 3086, 6547, X, X, X, X, X, 6548, X, X, X, X, X, X,
    4323, 6551, X, 6550, 6549, 3305, X, 6552, 2825, X, 6553, X, X, X, 6554,
    4347, 6555, 1889, X, 6392, X, 4124, 2295, 6391, X, X, X, 6395, 4111, X,
    3599, X, X, 3778, X, X, X, 2698, 6394, X, 2588, 2296, 2513, 1952, 3875,
    6393, X, X, X, 3542, X, X, 3961, X, 7260, X, 2594, X, X, X, X, 7261, X,
    7262, X, X, X, 7263, X, X, 3384, X, X, X, X, X, X, X, 8571, X, X, X, X, X,
    3019, X, X, X, X, X, X, X, X, X, 7326, X, 7325, X, X, X, X, X, X, 2124, X,
    X, X, X, 7049, 7051, X, X, 7052, 1915, 6518, 2814, X, 7053, X, X, 2239, X,
    X, X, X, X, 7054, X, 8539, 3832, 2415, 2310, X, X, X, X, 3806, 1660, 3711,
    7086, 1836, 2966, 7085, 7090, 3284, 4108, X, 7088, 7089, 1893, X, 7091,
    3638, 3164, X, X, 3746, 3412, 7087, X, 3986, 3640, X, 2174, 7095, 7094, X,
    3833, X, X, X, 2570, X, X, 3433, X, X, 8540, X, X, X, 8541, X, X, X, X, X,
    7098, 7099, 2311, 7097, X, X, 7546, X, X, 7548, X, X, X, 7547, X, 7550,
    7553, X, X, X, 7549, 7551, 7552, X, X, 7554, X, 2007, X, X, X, X, X, X, X,
    X, 3146, X, X, 7577, X, X, X, X, 3490, X, X, X, X, X, X, 7578, X, X, X, X,
    X, X, 7583, X, 7370, X, X, 7372, 8597, X, X, 8598, X, X, X, X, X, X, X, X,
    1838, 7371, 4131, X, X, X, X, X, X, 7383, 7373, X, X, 7376, X, 2968, X,
    7130, X, X, X, X, 2218, X, 7127, 7128, X, X, X, 4332, X, X, X, 3312, X,
    3016, X, X, X, X, X, X, 7131, X, X, 7134, 3165, 3094, X, 3485, X, 7223,
    1932, X, X, X, X, 7232, X, 7229, 7242, 3486, 3259, 7226, X, 3383, 3434,
    7227, 7231, 2883, X, 3642, 3333, X, X, 2947, 7230, 3115, 7340, X, X, X, X,
    X, X, X, X, X, X, X, 2080, X, 7342, X, 8590, X, X, X, X, 2177, X, X, X, X,
    X, X, 7341, X, 2790, X, 2786, 7071, X, X, X, X, X, X, X, 2330, 4431, 7072,
    X, X, X, X, X, X, X, X, X, X, X, 7073, 3790, 7074, X, 7082, X, X, X, 123,
    124, X, X, 121, 122, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 3206, X, X, 7063, X, X, X, X, 7065, 1673, 7093, 4331,
    3323, 4360, X, X, 2524, 7092, X, 3118, X, X, 7109, 3015, X, X, 3565, X,
    3807, X, X, X, X, X, X, 7096, 2474, 2525, X, 2787, X, 6895, 6894, 6825, X,
    X, X, 6899, X, X, X, X, X, X, X, X, X, 6896, X, X, X, X, 6897, X, X, 6898,
    X, 6900, X, X, X, X, 1608, X, X, X, X, X, X, X, 7759, 1927, 7760, 7761,
    7762, 8631, 2340, X, 7763, X, X, X, 5973, 4100, X, 3168, 7764, 7766, 7765,
    X, 7484, X, X, 1774, 7482, 7486, X, X, X, X, 7487, X, 1449, X, 7488, 7489,
    X, X, X, X, X, X, X, 2793, X, X, X, 7490, X, X, X, 4693, X, 4702, 4695, X,
    X, 4699, 8326, X, 4700, 4696, X, X, 4729, X, X, 2422, 1708, X, X, X, X,
    4694, X, X, X, 4704, 1495, 4703, X, 3263, X, 4920, X, X, 4922, X, X, 4923,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4925, 4926, X, X, X, X,
    5622, X, 8418, 5627, 5631, X, X, 1995, X, X, X, X, X, X, X, X, X, X, X, X,
    1923, 5629, X, X, X, X, X, 1880, 1961, 1731, X, X, X, X, X, X, X, X, X, X,
    1762, 2820, 5304, 5309, X, 5305, X, 2160, X, 5310, 2445, 2328, X, X, X, X,
    X, X, 2637, 5292, 4907, 4335, X, X, X, X, 3615, X, X, 4909, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, 2356, X, X, X, X, X, 2149, X, X, X, X, X,
    X, 4505, X, X, X, 8301, X, 2574, X, 3107, 3358, 2059, X, 4506, X, X, X, X,
    1901, X, X, 2495, 3818, X, X, 3698, X, X, X, X, 5048, 1870, X, X, X, X,
    5051, X, X, X, X, 3290, X, X, 5050, 5049, 5052, X, 3364, X, X, 1997, 5950,
    5952, X, 5951, X, X, X, X, X, X, X, 5953, X, 2210, X, 5954, X, X, X, X,
    2046, X, 3039, X, 2348, X, X, X, X, 6773, X, 3013, X, 6777, 2450, 2856,
    2083, 4125, X, 4130, 2713, 8525, X, X, X, X, X, X, X, X, 6790, 6788, X, X,
    X, X, X, 1700, 1427, X, X, X, X, 6654, 6657, 3617, X, 2855, X, 1651, X,
    3954, X, X, X, X, 2128, 2033, X, 6656, X, 1671, X, X, 2880, 7276, X, 7277,
    X, X, X, 7278, 4214, X, 2654, X, X, X, X, X, 7280, 7279, X, 2313, X, 2338,
    2475, X, X, X, X, X, X, X, 7778, 7779, X, X, X, X, X, 3387, X, X, X, X,
    2222, X, 7781, X, X, X, X, X, X, X, X, X, X, 7152, X, X, X, X, X, 7141, X,
    X, X, 7142, 7140, X, X, X, X, X, X, X, X, X, X, 5962, X, X, X, X, X, X, X,
    X, X, X, X, 5964, 5961, X, X, X, 4093, 5963, 5965, X, 4265, 3246, X, 5712,
    X, X, X, X, X, 5720, X, 5713, X, X, X, X, 8427, 3134, X, 1945, 5721, X, X,
    X, X, X, X, 2139, X, X, 1884, 5719, X, 1996, X, X, 5724, 5729, X, X, X,
    2997, 3652, X, 3736, X, X, X, X, X, X, 5726, X, 3948, X, 5728, X, 5737,
    8428, 5735, X, 5730, X, X, 6643, X, 6642, X, 1832, X, 6644, X, 6645, 6646,
    X, X, 2366, 4270, X, 6648, 2826, X, X, X, 1583, 6649, 6650, X, X, X, X, X,
    6651, X, 1604, X, X, X, 6519, 6520, X, X, X, 6521, X, 4201, X, X, X, X, X,
    2643, X, 6523, 6522, X, X, X, X, X, X, X, X, X, X, 179, X, X, 178, X, 177,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 187, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 104, 105, 103, 106, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 6807, 2216, X, 1931, X, X, X, 6809, 4572, X, X, X, X, 1964, X,
    4255, X, 2056, 6810, 6764, 6768, X, 3722, X, X, X, X, 6767, 2779, 2578,
    6770, X, X, 2003, X, X, X, X, 8521, X, 6771, X, 3848, 6766, 8522, 6727, X,
    X, X, X, X, 6588, 6589, X, X, X, X, 2617, X, X, 6587, X, 2343, 6586, X, X,
    6590, X, X, X, 3307, 3855, 3010, X, X, X, X, 3161, 8508, X, 6425, 6419, X,
    X, X, X, X, X, X, 6423, 2627, 1470, 6418, 6426, 6430, 2298, 4095, X, 3343,
    6420, X, 8507, 6428, X, 6417, 3225, X, 6422, 1438, 4083, 2573, X, X, X,
    3515, 6334, 6333, X, X, 6330, X, X, X, 4345, X, X, X, X, X, 6339, X, X,
    6343, 6340, X, X, X, X, X, X, X, X, 5927, X, 3351, X, 5929, 5928, X, X,
    5930, X, 5931, X, X, 2600, 3826, X, X, X, 4117, 5932, 5933, 3061, 2541,
    5934, 4837, X, X, X, X, 1882, 5695, X, X, X, X, 5696, X, 3929, 4019, X, X,
    X, 3516, 5697, 3735, X, 8423, X, 3756, X, X, 4092, X, X, X, 5698, 5416,
    5417, 1876, X, X, 3569, 3217, 1955, 2504, 3072, X, X, 2691, 1425, X, X, X,
    5418, X, X, X, X, X, X, X, X, 1599, 5422, X, X, X, X, 8452, X, X, X, X,
    5892, X, X, X, X, X, 8451, X, X, X, X, 1578, X, X, X, X, 5895, 3871, X,
    5894, X, X, X, 6577, X, X, X, X, X, 6576, X, X, X, X, X, 6578, X, 3201, X,
    3601, X, X, X, X, X, 3306, X, X, X, X, 6582, X, 3708, X, 6453, X, X, 6448,
    X, X, X, 3008, 2117, X, 2642, X, X, X, X, 8510, X, 2824, 3029, 6459, X, X,
    6461, 6462, X, X, 6458, 6460, X, 4212, 1437, 6410, X, X, 1954, X, 6407, X,
    X, X, X, X, 6408, X, X, 3476, 6406, 6403, X, 1699, 2981, X, X, 2169, X, X,
    X, 6415, X, X, 3413, 7179, X, X, X, X, X, X, X, 7182, X, X, X, X, X, X, X,
    X, X, X, X, X, 2557, X, X, 7181, 7180, 2125, 7183, X, 2408, 4315, 6926,
    6927, 3092, X, X, X, X, X, X, X, X, X, 4231, X, X, X, X, 6928, 4156, X, X,
    6929, 6930, X, X, 3921, 6931, X, 2381, 6978, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 1740, X, X, X, X, X, X, X, 6979, X, 6980, 6981, X, X,
    7471, 8606, 7468, X, 7469, X, 7470, 7472, X, X, X, 8607, X, 8608, X, 8609,
    2949, X, X, 8610, 4128, X, X, 2950, X, X, 7473, X, 3748, X, 3536, 2894, X,
    X, 3252, X, 2061, X, 7243, 4158, 1534, X, 3908, 1662, 7238, 7239, 7240,
    7241, 3504, 3198, 1476, 7245, X, 7246, 7804, X, X, 3130, X, 7247, X, 6947,
    X, 6942, 6948, X, X, X, X, X, X, X, 6952, 7448, X, X, X, X, X, X, X, X,
    1605, X, X, X, X, X, X, X, 6955, 2036, 2193, X, 3380, 6985, X, X, X, X,
    2122, X, 2873, X, 6988, X, 3481, X, 6987, X, 8530, 2084, X, X, 6986, 3188,
    1892, X, X, 6989, X, 6990, X, 2782, 7022, 7030, 7023, X, 7019, X, 3381,
    7018, X, X, X, 7016, X, 4136, 2523, X, X, 7020, X, 7017, X, X, 8537, 7024,
    2715, X, 2194, X, X, X, 3191, X, 6750, X, X, 3258, X, 6751, X, X, 4189,
    6740, 1715, X, 6746, X, X, 6749, 4053, X, X, X, X, 6752, X, X, 6745, 6748,
    X, 8276, X, X, X, 7528, 7527, X, 7529, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 3749, 6529, X, X, 2828, 7541, 7537, X, X, 7540, X,
    X, 8615, 1844, X, X, X, 7542, X, 7543, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 7544, 7545, X, 2005, X, X, 7358, 7352, X, X, 7351, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 8595, X, X, X, X, X, X, X, 94, 93, X, X, X, 90,
    X, X, 92, 91, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 29, X, X, X,
    X, 28, X, X, 37, 38, X, X, 39, 40, X, X, 4912, X, X, X, 3815, X, X, X,
    4913, X, 4908, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 4068,
    4618, X, 2923, 4615, 2021, X, 4616, 1796, X, X, X, X, X, X, X, X, X, X,
    2081, 4619, X, 4620, X, X, 4621, 4622, 2596, X, X, X, 2252, 4103, 407, 408,
    409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423,
    424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438,
    581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595,
    596, 612, 613, 614, 615, 616, 617, 619, 620, 621, 622, 623, 624, 625, 626,
    627, 628, X, 7657, 7654, 7653, 7655, X, X, X, 2130, X, X, X, X, X, X, X,
    7661, 7660, 7659, X, X, 1428, X, X, X, X, X, X, X, X, X, X, 1664, 6817,
    6818, X, X, X, X, X, X, 6813, X, 2472, X, X, X, X, X, X, X, X, X, X, 4179,
    X, X, X, X, X, X, X, X, 3845, 5569, 3143, X, X, X, 5575, 3038, X, 5566,
    5579, 5578, X, 3520, 5628, X, X, X, 5630, X, X, X, X, 8417, X, X, X, X, X,
    X, 5624, 8419, X, X, X, X, 5626, X, X, X, X, X, 8420, 1755, 5318, X, X,
    3068, X, X, X, X, 2625, 5323, X, X, 2749, X, 5317, 5322, X, X, 3622, X, X,
    X, 5316, X, 2068, X, X, 1752, X, X, X, 5324, 8346, X, 2605, 4954, 1868,
    3527, 4050, 4955, X, 4956, X, X, 3816, X, X, X, 4958, X, 1793, 2060, 4957,
    X, X, X, 8348, X, X, 1803, X, 2837, 4962, 2444, 2987, X, X, X, X, X, 2088,
    X, X, 4644, X, X, X, X, 4645, 1515, 1494, 1862, 8319, 3109, 1928, 4216, X,
    4648, 1620, X, X, 4647, X, X, X, 1983, 1485, 3285, X, 2560, X, X, X, 4039,
    2795, 2459, 2794, 1625, X, 3811, 4166, X, 4419, 1518, X, X, 1769, 4420,
    2917, 4639, 1933, 3879, X, X, X, X, 2796, X, 4490, 8297, 3932, 3240, 4486,
    2148, X, 4483, 4491, 4485, 4278, 4492, 4356, X, X, X, X, X, X, X, X, 2043,
    X, X, 2147, X, X, X, X, X, X, 8379, X, X, X, X, 3733, 5370, X, X, X, X,
    3943, X, X, X, 3370, X, X, X, 4032, X, 5290, 1598, 3269, X, X, 4266, X, X,
    X, 6099, 6097, 6098, X, X, X, 1851, X, X, X, X, X, 4135, X, X, X, 3895, X,
    6101, X, X, X, 6100, X, X, X, 1679, X, X, 2827, 6982, X, X, X, X, X, X, X,
    X, X, X, X, X, 6983, X, X, X, 6984, X, X, X, X, X, X, X, 8552, X, X, X, X,
    X, 3385, X, X, 7272, X, 7271, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    8323, 8334, 8335, 8356, 8395, 8411, 8413, 8456, 8462, 8485, 8493, 8494,
    8495, 8497, 8501, 8504, 8513, 8524, 8526, 8527, 8536, 8544, 8546, 8547,
    8550, 8578, 8585, 8601, 8613, 8614, 8616, 8629, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 5883, X, X, X, X, X, X, X, 3950, X, X, X, 5893,
    X, X, 6733, X, 6728, X, X, X, X, X, X, 2778, X, X, X, X, 2646, X, X, X,
    2549, X, X, X, X, 4097, X, X, 3798, X, X, 6744, 6679, X, X, X, X, 6682, X,
    X, X, 3087, 2120, X, X, X, X, 1536, 6681, X, 2306, X, X, X, X, X, 3088, X,
    X, X, X, X, X, X, 6811, X, X, X, 3273, X, X, X, X, X, 6812, X, X, X, X, X,
    X, X, 3567, X, 1435, X, X, X, X, 7721, X, X, X, X, 7722, X, 7717, X, X, X,
    7697, X, X, 7723, X, 3354, X, X, X, 7727, X, 7728, 7726, X, X, X, X, 1727,
    X, X, X, 2131, 4603, 4242, X, X, X, 4599, X, X, X, 4604, 4601, X, 4600, X,
    X, X, X, X, X, 4276, 8312, X, X, 2250, 313, 314, 315, 316, 317, 318, 319,
    320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334,
    335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 485, 486, X, 487, 488,
    489, 490, 491, 492, 493, X, X, X, X, X, X, X, 502, 503, 504, 505, 506, 507,
    508, 509, 510, 511, 512, 513, 514, 515, 516, X, 7572, X, X, X, 7574, X, X,
    X, X, X, X, X, X, 1898, 7573, X, X, 3098, 2180, X, X, X, X, X, 7576, X, X,
    X, X, X, X, 7615, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 7616,
    X, 7617, X, X, X, X, 7618, 8626, X, X, X, 7671, X, 7667, X, 7668, 7664,
    7670, X, 7666, 1757, X, X, 4367, X, 7669, 7665, 7663, 7662, X, X, X, X, X,
    7673, X, X, X, X, 2152, 2411, 3648, X, X, X, 4595, 4593, X, X, X, X, 3850,
    2799, 4602, 1759, 4596, 4594, 3054, X, X, X, X, X, X, X, 4598, X, 4597, 0,
    1, 2, 22, X, 24, 25, 26, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 102, 107,
    43, 44, X, X, X, X, X, X, X, 1191, X, 1192, X, 7745, X, X, X, X, X, X,
    7746, X, X, 7747, 7748, X, X, X, X, 7751, 7749, 4351, X, 7750, X, 4308, X,
    X, X, X, X, 7752, X, 4288, 7790, 7791, 4309, 7788, X, X, 7792, 7793, X, X,
    7795, X, 7794, X, X, X, X, X, 7797, X, X, X, 7798, 7796, X, X, X, X, X, X,
    X, X, 2347, X, X, X, X, 7595, X, X, 7596, X, X, X, X, X, X, X, 1719, X, X,
    X, 7597, X, X, X, 4834, X, X, X, X, X, X, 1589, X, 3405, X, X, X, X, 4836,
    X, 4832, X, X, 2867, X, X, X, 4840, X, X, X, X, 2677, X, 3292, X, 2268,
    2742, X, X, 3728, X, X, 2743, X, X, X, X, 2719, X, X, X, X, X, 3365, 3942,
    3408, X, X, 2269, X, 3819, X, X, X, 5668, X, X, X, 5667, X, 5669, X, X,
    1643, X, 3218, X, 5670, X, X, 1816, 5672, X, X, X, X, 5671, X, 5673, X, X,
    X, 5674, 8381, X, X, X, X, X, X, 5347, X, 4011, X, X, X, X, X, 5348, X, X,
    X, X, X, X, 5349, X, 4087, X, 2915, X, X, X, X, X, 2207, X, X, 5392, X, X,
    X, X, 5395, 8384, 3809, X, 1942, X, X, X, 5394, 5393, 3623, 5396, 1994, X,
    X, X, 5398, 5397, X, 5580, 1712, X, X, X, X, X, X, X, 2420, X, X, X, 1564,
    X, X, 5597, X, X, 4340, 5600, X, X, 8414, X, X, 2845, 5599, X, X, X, 1948,
    X, 5991, 4228, 8469, X, 4245, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 7742, X, X, 2181, 7743, X, X, X, 7744, X, 2552, 3052,
    7782, X, X, X, X, X, X, X, X, X, X, 7783, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 3760, X, X, 7784, X, 3892, 3315, 2351, X, 2319, 2702, X, 2879, X,
    X, X, 7508, X, X, 7507, 4169, 1857, 3715, 3537, X, X, X, 2911, 4275, X,
    2126, X, X, X, X, X, 3316, X, 7687, X, 3688, X, 7692, 7688, X, X, X, 7689,
    X, X, 3964, 4077, X, 3525, X, X, X, X, X, X, X, X, X, 2983, X, 4348, 6855,
    X, 6856, X, X, X, X, 6862, X, 2829, X, 6858, X, 6861, X, X, X, X, X, 6853,
    6852, X, X, 6863, X, X, 1657, X, 6859, X, 6864, X, X, X, 6860, X, X, X, X,
    X, 6857, X, 3308, X, 6854, X, X, X, X, X, X, 3643, 6872, X, X, X, 6876, X,
    6879, 6878, X, X, X, 6870, X, X, X, X, 6873, X, 6890, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 5142, 5148, 5140, X, 3443, X, X, 5145, 3820, X, X,
    5139, X, 5144, 4300, 2498, X, X, 6063, 6065, X, 3793, X, 2766, X, X, 6072,
    X, X, 6071, X, X, X, X, 6073, X, 2543, 2364, X, X, 3470, 6074, X, 3332, X,
    X, 6076, X, 6102, 6103, X, X, X, X, 6107, 6104, 6105, 6106, X, 6108, X, X,
    X, 6109, X, 6110, X, X, X, 6111, X, 6112, X, 3680, 3431, 6113, 3653, 3779,
    X, 6133, X, 1823, 3720, 6134, X, 6135, X, X, 6136, X, X, X, 4101, X, X, X,
    4094, X, 3319, X, X, X, 3081, X, X, 6138, X, X, 2697, X, 2890, X, 3513, X,
    6155, 3998, X, 6152, X, X, 6153, X, X, X, X, X, X, X, X, X, X, X, X, X,
    6158, X, X, X, X, 6157, 6156, 5956, 5957, 5955, X, X, X, X, X, X, 2614, X,
    X, 3517, 1998, X, X, X, X, X, X, X, X, X, 5959, 3207, 5958, X, X, 4344,
    3637, X, X, 6803, X, X, X, X, X, X, X, X, X, X, 4221, X, 6137, 6805, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 6806, 2572, X, X, X, X, X, 6722, X, X,
    X, X, X, X, X, X, X, X, 3899, X, 4043, 6762, 6761, X, 6757, 6758, X, 1525,
    X, X, X, X, 6760, 6719, X, 6718, X, X, X, X, X, X, 3646, 6725, X, 6736, X,
    X, X, X, 1785, X, X, X, 6739, X, X, 6721, X, X, X, 6726, 4213, X, X, 3678,
    X, 7313, X, 2789, 8570, X, X, X, X, X, X, X, X, X, 2314, X, X, X, X, X,
    8572, 8573, X, X, X, X, X, 3987, X, 7041, X, X, X, X, X, X, X, 7045, X, X,
    7042, X, 7044, 7043, X, X, X, 8538, X, X, 7046, X, 2554, X, 7048, 7047,
    3831, X, X, 7050, 7055, X, X, 2473, X, X, X, X, X, X, 5403, X, 7056, X,
    7057, X, 2649, X, 7058, 7059, X, X, 7060, X, X, 7061, 7062, X, X, X, X, X,
    6849, X, X, X, 6850, X, X, X, X, X, X, X, X, X, X, 6845, X, X, 6847, X, X,
    X, 6848, X, X, X, 6846, 6837, X, 3957, 6838, X, X, 6835, X, 6836, 6841,
    6844, X, X, 6842, X, X, X, 6840, 6834, X, X, X, X, X, 3251, X, 6851, X,
    4051, X, X, X, 7638, X, X, X, X, X, X, X, X, X, X, 1439, 8623, X, 7639,
    3864, 7637, X, X, 7640, 7641, X, X, X, X, X, X, X, 7642, 7683, X, X, X, X,
    X, X, 7684, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 7685, X, 7686, X, X,
    X, X, X, X, X, 3213, X, X, 1634, X, X, X, X, X, X, X, X, X, X, 4749, X,
    4751, 2733, 1522, X, X, 4754, X, X, X, X, 1569, X, X, 1866, 3541, 3937, X,
    X, X, X, 4880, 3060, 4879, 2099, X, 8339, 4006, 4878, X, 3452, 4882, X,
    4881, 8340, X, 8341, X, X, 8415, X, X, X, X, 5610, 5603, X, X, 5616, X,
    5614, X, X, X, X, 5609, X, X, X, X, X, X, 5608, X, 3337, X, 3076, X, 5606,
    5276, X, X, 5274, X, X, X, X, 5277, X, X, X, X, X, 3870, X, X, 1432, X, X,
    X, X, 3821, X, X, 3732, X, X, 5278, X, 5281, 2746, 2836, X, X, X, X, 4901,
    X, X, X, 3911, X, X, X, X, X, 2229, X, X, X, X, X, 4910, 4911, X, X, X, X,
    X, 2736, X, X, X, 5384, 5383, X, X, X, X, X, 5351, 5385, 5373, X, X, 2500,
    X, X, X, X, 5386, 5387, 5389, 5388, 5390, 1691, X, 2277, X, X, 3945, 2928,
    4973, X, 4974, X, 4105, X, X, X, 4975, X, X, X, X, 2011, X, X, X, 2633, X,
    X, X, X, X, X, 4976, 4977, 2597, 2831, 3561, 2871, 3753, 3573, 3989, X, X,
    X, X, X, 3726, X, X, 4675, X, 1847, 4670, 4671, 4673, X, X, X, X, X, X, X,
    4674, X, 1938, 2884, X, 3866, 4672, 4668, 2228, X, 1636, 4918, X, X, X, X,
    X, X, 2564, X, 4917, 2156, X, X, X, 4931, X, X, X, X, X, 4924, 4921, X, X,
    X, X, X, X, X, X, 2631, X, 2623, X, X, X, X, X, 4684, 4682, X, 4044, X,
    4679, 4688, 4683, X, X, X, 4686, 2199, 4072, X, X, 2974, X, X, X, X, X, X,
    X, X, X, X, X, 5350, X, X, X, X, X, X, X, X, X, 3389, X, X, X, X, X, X, X,
    3944, 2583, 5327, X, 5326, X, X, 2907, X, X, X, 2161, X, X, X, 5320, 2750,
    X, X, 3549, 3588, X, X, X, X, 5686, X, X, X, X, X, 5687, 5688, X, X, X,
    5689, X, 5691, 5690, 5692, 1602, 3237, X, 5693, X, X, 2449, 1735, 5694, X,
    X, 3417, 5378, X, X, X, X, 5382, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 5380, X, X, X, 5381, 5343, X, X, 4121, 6176, X, 3241, X, 3645,
    X, 2048, X, X, X, 3222, 6177, 1999, X, X, X, 2961, X, X, X, X, X, X, X, X,
    6178, X, X, X, 1742, X, 7185, X, X, X, 2409, 7184, X, 7193, X, X, X, X, X,
    7187, 7189, 3922, 7186, X, X, X, 7188, X, 7192, 7190, 1896, X, 7191, 7291,
    7292, X, X, X, X, 3713, 2400, 2602, 7293, X, 7294, 4233, 2668, 4119, 4273,
    7295, 2039, X, X, X, X, 7296, 8554, 3386, X, 8553, 7299, 1779, 2862, 8555,
    7297, 4112, X, 7388, 3021, X, X, X, 7389, X, 3889, 7390, 1702, X, X, X,
    1531, X, 1840, 8599, 1839, 7391, X, 7392, X, 7393, 7394, X, X, X, X, X, X,
    7514, X, X, X, X, 7516, 3175, 1750, 1751, 7515, X, X, X, X, 1858, 2179, X,
    8611, 1859, X, X, 3414, X, X, 4293, X, 1483, X, X, X, X, X, X, X, X, 2312,
    X, X, X, 4349, X, X, X, X, X, X, X, X, X, X, X, X, 7267, X, X, 8549, X,
    4190, X, 6964, X, X, 3857, 3609, 6965, X, 6966, 2172, X, X, X, 1891, X, X,
    X, 6967, X, X, 2518, 3604, 6968, X, 1739, X, X, X, X, X, 6687, X, 6695, X,
    6702, 6696, X, X, X, 6694, X, X, X, X, 6665, X, X, 6692, X, X, X, 6688, X,
    X, X, 1833, 6690, 6619, X, X, 2854, X, 1670, X, 6620, 4284, X, 2548, X, X,
    2644, X, X, X, X, X, 2517, 3250, X, X, X, X, X, 6621, 6622, 1520, X, 6623,
    X, 8512, X, 6511, 2085, X, X, X, 3009, 1912, X, X, X, X, 6515, 6512, X, X,
    6513, X, X, X, 6516, X, 6517, 6514, X, X, X, 1512, X, X, 7199, X, 1768,
    7198, 7203, X, X, 7202, X, X, 7201, 3401, 7204, X, X, X, X, X, X, X, X,
    7205, X, X, X, X, 7206, X, X, 2331, 2041, X, X, 2669, X, 3505, X, X, 8275,
    X, X, X, X, X, X, X, X, 3020, X, 7321, X, 7315, 7320, X, 4076, X, 3313,
    7322, 7319, X, X, X, 4426, 3592, X, 1934, X, X, X, X, X, 3594, X, 3544,
    2196, 3966, X, X, X, X, X, 6808, 4427, 2797, 4428, 1618, X, X, X, 2042,
    2241, 4114, 180, 181, X, X, X, 36, 35, X, X, X, X, X, X, X, X, X, 176, X,
    75, 76, X, X, X, X, X, X, X, 101, X, X, X, X, 3694, 3897, X, 4582, X, 4223,
    4583, X, X, X, 4584, X, 3477, X, X, 4585, X, X, 2922, 2443, 2151, 4586,
    2484, 2334, X, X, X, X, 4764, X, X, X, 1864, X, 4767, 4763, 4766, X, X, X,
    X, X, X, X, 3867, X, X, X, 3530, X, 3689, X, X, X, X, X, 4487, 4496, X, X,
    3057, X, 2197, X, 3631, X, 5960, X, 4495, 3444, X, 4484, X, 2247, X, X,
    2246, 4482, X, X, X, 8299, 2595, 680, X, X, 675, 666, 687, X, X, 682, X, X,
    677, 665, X, X, 681, 686, X, X, 676, 667, X, X, 683, 688, X, X, 678, 668,
    X, X, 684, X, 7725, 7731, X, 7724, X, 7729, X, X, X, X, X, X, X, X, 7730,
    X, X, X, 7733, X, X, X, X, X, 7732, X, X, X, X, X, X, 7680, 7678, 3208, X,
    X, X, X, X, X, X, X, X, 4027, X, X, X, X, 4287, X, X, 7682, X, X, X, X, X,
    1196, 1197, 1198, 1199, 1200, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 3314, X, X, X, X, X, X, X, X, 3846, X, 7523, X, X,
    X, X, 7524, X, 7525, X, X, X, X, 7526, X, X, X, X, X, X, X, X, X, 6632,
    2305, 6633, 3709, X, 6647, X, X, X, X, 6635, X, 3142, 3656, 2192, 6634,
    3012, X, X, X, X, X, X, 3900, 1650, X, X, X, 6318, X, 6315, X, 6320, X, X,
    6319, X, 3654, 4048, X, 2470, 6313, 6322, 6317, X, 6316, 6312, 8503, 6314,
    6244, 2029, X, X, 4352, 3028, X, X, X, X, 6223, X, X, 1647, 3376, 3854, X,
    X, X, X, 8496, X, X, X, X, X, X, 8498, X, 6224, X, X, 7075, X, X, 7077, X,
    X, X, 7076, 7078, X, 3985, 7079, 7080, X, X, X, X, X, 7081, X, X, X, 7083,
    X, X, X, X, 1704, 3360, X, 4369, X, X, X, X, X, X, X, 6787, X, X, X, 4220,
    X, 6789, 6791, X, X, X, X, 6792, X, X, X, X, X, X, 6795, 6793, X, X, 1504,
    2875, 2723, 1842, 7428, X, X, X, 3641, X, 7430, X, X, X, 1505, X, 7429,
    3325, X, 4274, 3488, 7423, 4235, X, 2178, X, X, 4194, X, X, 7605, 7606, X,
    X, 7607, X, X, X, 3682, 7609, X, 3765, 7610, 7608, X, 7612, X, X, 7611, X,
    X, 7613, X, X, X, 7614, X, X, X, X, 1791, X, X, 4469, X, 4461, X, 8292,
    4296, X, 2531, X, 4462, X, 4467, 8291, X, 8294, X, 4470, X, 4463, X, 8293,
    1974, X, 1454, X, X, 5031, X, X, X, X, X, X, X, X, X, 5033, X, 5034, X, X,
    X, X, X, X, X, X, 5037, 8359, 8360, 4299, X, 5038, 5035, X, X, 5900, X,
    3636, 5896, 5899, 2765, X, 3714, X, X, 5903, X, 2586, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 3003, X, X, 6769, X, X, X, 6802, 3048, X, X, 6797,
    6799, X, X, X, X, X, X, X, 6798, X, X, 5656, 5641, X, X, 6804, X, X, X, X,
    X, 1788, X, X, X, X, X, X, X, X, X, X, X, 1584, 6661, 4303, 3162, X, X,
    3795, X, 6673, X, 1652, 6671, X, 6669, 6660, 6596, X, X, 6599, 6598, X, X,
    X, 3983, 6602, X, X, X, X, X, X, 6603, X, X, 3030, X, 6604, X, X, 6606, X,
    6610, X, X, 6607, 6605, 3602, 3378, 6437, X, X, 6433, X, X, X, 3905, 1828,
    X, X, 4084, X, X, 1471, X, X, 6436, X, 4322, X, X, X, X, X, X, 6435, X, X,
    X, X, 2967, X, 2584, 7112, X, X, X, 1741, X, 7113, X, X, 3093, 7114, X,
    7115, 3834, X, 8543, 1894, X, X, X, X, X, X, X, X, 7132, 7133, 4192, X, X,
    X, X, 3484, 7137, X, X, X, X, X, X, X, X, X, X, X, X, 7135, 7136, 7138,
    3105, 7228, 1418, 4325, X, X, X, 7233, X, X, X, X, X, X, 3166, X, X, 2652,
    2861, X, X, 7235, 7234, X, 1488, 7236, X, X, 3774, X, 7244, X, 4232, X, X,
    X, X, X, X, 6936, X, X, X, X, X, X, X, X, X, 6937, 2781, 6935, 8529, X, X,
    4206, 6932, X, X, 6934, 2942, 2913, X, 8514, 4089, 6666, 1653, 1784, 6670,
    X, X, 6672, X, X, X, X, 2119, X, X, X, X, X, X, X, 6676, 6685, 6686, X, X,
    X, 1420, X, X, X, 7496, X, X, 7497, X, 7498, X, X, 7499, X, X, X, X, X, X,
    X, 1843, X, X, X, X, X, X, X, X, 7500, X, X, X, 1532, X, X, X, X, X, X, X,
    X, X, 3032, X, 4756, X, 4757, X, X, X, X, X, X, X, X, X, X, 1781, X, X, X,
    X, 3869, X, X, 3497, X, 2105, X, 5235, 5230, X, 5236, X, X, X, 2158, X, X,
    X, 1614, X, X, X, 5244, X, X, X, 1809, X, 2012, X, 5440, 5444, X, X, 1640,
    5441, 5443, X, X, X, X, 5442, X, X, 2706, X, X, X, X, 3235, 1446, 5445,
    8397, X, X, X, 5446, X, X, 6286, X, 6299, X, 6289, X, 1951, X, 6288, 6301,
    X, X, X, 6287, X, 2773, X, X, X, X, X, X, 6291, 6292, X, 3394, X, X, 6293,
    X, 6236, X, 6237, 3644, X, 2852, 6234, X, 3260, X, X, 6235, X, X, X, 2771,
    X, X, X, X, X, X, X, X, X, X, 1469, X, X, X, X, 7100, 7101, X, 7103, 3104,
    X, 7102, 1855, X, 7105, X, 7104, 7106, X, 8542, 7108, 7110, X, 7111, X, X,
    X, X, X, X, X, X, X, 6412, X, X, X, X, X, 6414, X, X, X, 6411, X, X, X, X,
    X, 2116, 3120, 6416, 3085, X, X, 6429, 2978, 6324, X, X, 3712, X, 6328,
    3904, X, 3254, X, 6323, 6325, X, X, 6326, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 6329, X, X, 7139, X, 3382, X, X, 7144, 7148, 7145, 7143, X, 7146, X,
    X, X, 7147, X, X, X, X, 7154, X, X, X, 7149, X, X, X, X, X, 2969, 1586,
    3051, X, 2176, X, 4193, X, 8548, 7248, 3395, X, X, X, 3095, 2592, 7249, X,
    X, 7252, X, X, 2700, 7250, 3018, 3017, X, 1477, X, 4272, 7254, X, 3747,
    7374, X, 7375, X, X, X, X, X, X, X, 7377, X, X, X, X, X, 7379, X, X, X, X,
    7380, X, 7381, X, X, X, X, 7384, 7382, 7385, 7387, 2912, 1856, X, X, 4161,
    1674, 2655, 2220, X, 7446, X, 7445, 2526, 7447, 7444, X, X, 2451, X, X, X,
    7451, 6874, X, X, 4659, X, 2906, 7449, X, X, X, 4649, X, 4122, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 8320, X, X, 4650, X, 4279, X, 2253, X, X, X,
    X, 2183, 1900, X, 4429, X, X, 4430, 4256, X, 4164, 3079, 4432, 2529, 3560,
    X, 4435, X, X, 1533, 2224, X, 2223, 1479, X, X, 4366, 4365, X, 2368, 1410,
    X, 4436, 4437, 1148, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 1157,
    X, X, X, X, X, X, 8634, 8635, 8636, 8637, 8638, 8639, 8640, 8641, 8642,
    8643, X, X, X, X, X, X, 4802, 1430, 2412, X, X, X, X, 2096, X, X, 3242, X,
    X, X, X, X, X, 4803, 4804, X, X, 4806, X, X, X, X, 3400, 5354, X, X, X,
    5355, X, 3838, X, 3608, 2446, X, 2994, X, 3995, X, X, X, X, X, X, 1732, X,
    5362, 5357, X, X, X, 5793, X, X, X, X, X, X, 4052, X, X, 5791, 5795, X, X,
    X, X, X, X, X, 2209, X, 2762, X, X, 3220, 8439, X, X, 5785, 5477, 2807,
    4102, 5479, 5480, 4207, 8404, X, X, X, 5485, X, X, 2281, X, 3624, 5482,
    3459, 5419, 5423, X, 1926, X, 3610, X, X, X, X, 5484, X, 2755, 3701, 3154,
    5137, X, X, X, 1941, 5147, 2926, 1572, 5141, 1685, 5146, X, X, X, 1990, X,
    5143, X, X, X, X, X, X, X, X, 5149, X, X, X, X, X, 4999, X, 5001, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 5002, X, X, X, X, X, X, 5466,
    5467, 4099, X, 4045, 4033, 4007, 2448, 5469, X, X, 2612, X, X, 3996, X,
    5471, 5474, 5473, X, 1874, X, X, 1943, X, 5470, 5125, 2231, X, X, X, X, X,
    X, 5126, 3851, 2690, X, X, 5127, 3754, X, X, X, X, 3510, 3296, X, X, 8365,
    X, 3399, X, X, 5128, 1890, X, X, 6057, X, X, X, 6052, 6053, X, 6056, 6055,
    3764, X, X, 3041, 3040, X, 1910, X, X, 6058, X, X, X, X, X, 6059, X, X,
    6060, X, X, 6933, X, 6938, X, X, 3856, X, X, 6940, X, 6939, X, X, X, 1767,
    X, 3958, 6941, X, X, X, X, X, X, X, X, 8273, 6953, 6943, X, 6712, X, X, X,
    2910, X, 8517, X, X, 1917, X, 2034, X, 6707, X, X, X, X, 1656, X, X, 2777,
    X, 6710, X, X, X, 2407, X, X, 3432, 6636, X, X, X, X, X, X, 3379, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 6638, 6637, 6640, X, X, 6639, X,
    6641, 4187, 4346, X, 2300, 6531, 2589, 6530, X, X, X, X, 6532, 2546, X, X,
    X, 3150, X, 6533, X, X, 2299, X, 4096, 6534, 6535, X, X, 6536, X, X, X,
    7405, X, X, X, 1448, X, X, 7403, X, 7407, 7406, X, X, X, X, X, X, 7409,
    7408, 7410, X, 3491, X, X, X, 7411, X, X, X, 2091, 3106, 1665, X, X, X, X,
    8277, 2682, X, X, 8295, 4474, X, 4479, 4477, X, X, 4472, X, X, 3116, 4475,
    X, 4478, 4476, X, 3914, X, 4473, 1128, 1129, 1130, 1131, 1132, 1133, 1134,
    1135, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1146,
    1147, X, X, X, X, X, X, X, X, X, X, X, X, X, 7501, 3574, X, X, X, 7503,
    1624, X, 7506, 7505, X, X, X, X, 1507, X, X, X, 2006, 1918, X, X, 7493, X,
    X, 7492, X, 7491, X, X, 7036, X, 3913, X, X, X, X, X, 7494, 7495, X, X, X,
    X, X, X, X, X, X, X, X, 5700, 5699, X, X, 5702, X, X, X, 5701, X, X, X, X,
    X, X, X, X, X, X, X, X, 4990, X, X, X, 1869, 4991, X, X, 4992, X, X, X, X,
    X, X, X, X, X, X, X, X, 1780, X, X, X, X, X, X, X, 7347, X, 2380, 3096, X,
    X, 3331, X, X, X, X, X, 2062, 4249, X, 2075, X, 3167, 6580, X, 7431, 1703,
    2898, X, X, X, X, 1745, 7433, X, 7434, 7432, 2135, X, 2410, 2792, 8602, X,
    X, 7619, 7620, X, 7621, X, 7622, 7623, 7624, 7625, X, X, X, 7626, 7627, X,
    5660, 7628, X, X, X, X, X, X, X, X, 6385, 1899, X, X, X, 4866, X, X, X, X,
    X, X, 3902, 4867, 8338, X, X, X, 1635, 4868, X, X, X, X, 4163, 1707, X,
    4646, 2671, 3132, 4869, 4116, X, X, X, 5249, X, X, 5248, X, X, X, X, X, X,
    X, X, X, X, X, 3297, X, 5252, X, 5250, 5240, 2159, X, 5251, X, 5255, 5254,
    5256, 5253, 4004, X, 3495, X, X, 2155, 3148, X, X, X, 4826, 4829, X, X, X,
    X, X, X, X, X, X, 3137, X, X, X, 4830, X, X, X, 4831, X, X, 5401, 5402, X,
    X, X, 3877, 4948, 2951, X, X, 3803, X, 2405, X, 3734, 3700, X, X, X, X, X,
    3428, X, 4262, X, 5404, 2585, X, X, 5405, 2014, 4978, X, X, X, 1958, 4979,
    X, 2067, X, 3524, 1613, X, 2494, 4980, 4983, 4982, 2066, X, 4981, X, 3407,
    X, X, X, X, X, X, X, X, 3117, X, 5165, X, 5168, 5170, 8368, X, X, X, 2566,
    8369, 5176, 3369, 5166, X, X, X, X, 5174, X, 1686, X, 5172, 5173, X, X,
    5169, 5171, X, X, X, 2232, 4790, X, X, 3917, 4792, X, X, X, 4794, 4793, X,
    4795, X, 4796, X, 2154, X, X, 1567, 4797, X, X, 4799, X, 4798, X, X, X,
    4801, X, X, 3441, 4537, 1493, X, 2182, 2094, 2659, 3286, 1977, 2985, 2248,
    8306, 2333, 4539, 4081, 3421, X, 2532, X, 4538, X, 4540, X, X, X, X, X,
    3445, X, 1776, X, X, X, 1986, X, 4841, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 3925, X, X, X, 3100, X, X, X, X, 3327, X, 8336, 4843, 4571, 4009, X, X,
    X, X, 2703, 3193, X, 4573, 3545, X, 8310, 4574, X, X, 4575, 1705, X, X, X,
    4576, 1980, X, 3521, 1593, 2679, X, X, 3666, 4577, X, 4833, X, X, 3362, X,
    X, X, X, X, 1799, X, X, X, X, 7802, 1568, 3936, X, X, 2801, 3423, X, X, X,
    X, 2419, X, X, 4839, X, X, 5438, X, 5434, 8392, 1693, 5435, 5436, 3718, X,
    X, X, X, 3824, 2109, 5439, X, X, 8396, 2931, X, 2754, X, X, X, 3245, X, X,
    X, X, X, 3326, X, X, X, 1547, 2286, 5742, X, X, X, X, X, X, 2638, 5747, X,
    5746, 5741, X, 5744, X, X, 1763, X, 5743, 3612, X, 3949, 3611, 1946, X,
    3388, X, X, 3272, X, 5738, X, X, X, X, 5736, 3158, 5725, X, 1546, X, X, X,
    X, X, X, X, X, X, X, X, X, 8433, X, X, 1713, X, X, 1556, X, X, 5763, X, X,
    5766, X, X, X, 4264, X, X, X, 6191, X, X, X, 3896, X, 2970, 6193, X, X, X,
    X, 6194, X, X, X, X, X, 6192, X, X, X, X, 1737, X, 6200, X, 6199, X, 2544,
    X, X, X, 6201, 6196, X, X, X, 6202, 6197, X, X, X, X, 3721, 6195, X, X,
    6198, X, X, X, X, X, 6205, X, X, X, X, X, 8449, X, X, X, 4330, 2889, X, X,
    X, 1577, X, X, X, 5881, X, X, X, X, X, X, 5880, X, X, X, X, X, X, 3661, X,
    X, X, X, X, X, 5924, X, X, 5925, X, X, X, X, X, X, X, X, X, X, 5926, X, X,
    X, X, 6556, 6558, 6557, 3670, X, 3566, X, 4353, 3674, X, X, X, X, X, X,
    6560, X, X, 2776, X, 3769, X, 6561, 6559, X, 1831, X, X, 1513, X, 4035,
    2874, X, X, X, X, X, X, X, X, 2129, X, X, 2038, X, X, 3907, X, X, X, X, X,
    7216, X, X, X, X, X, 6944, X, X, X, X, 6945, 6946, X, X, X, X, X, X, X, X,
    X, X, 6950, X, 6951, X, X, 6949, X, X, X, X, 77, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, 1193, X, X, X, X, X, X, X, X, X, 1159, 1173, X,
    X, 1162, X, X, X, 1167, X, X, X, X, X, 1168, X, X, X, X, X, X, X, X, X,
    8403, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    138, X, 139, X, X, X, X, X, X, X, X, X, X, X, X, 5818, X, X, X, X, 5878, X,
    X, X, X, X, X, 3548, X, X, X, X, X, X, X, 6171, X, X, X, X, X, 6172, X, X,
    X, X, X, X, X, X, X, 6173, X, X, 6174, 4064, 6175, X, X, X, 2618, X, X, X,
    X, 2905, X, X, X, X, X, X, X, X, X, X, 3114, X, X, X, X, X, X, 7120, X, X,
    X, 7119, X, 2308, 6906, 1474, X, X, X, X, 3788, X, X, 6907, X, X, X, X,
    2893, X, 6914, X, X, 6911, X, 3274, X, X, X, X, X, 6912, 6909, 2035, 2143,
    X, 6902, X, 6901, X, 2647, X, X, X, X, X, 2307, 5740, X, X, X, X, 6903,
    2680, X, X, X, 1716, X, 6904, X, 1553, X, 2780, 6905, X, 6624, 6625, X, X,
    6626, X, 6627, 2002, 5367, 6628, X, 2982, 6629, 2580, X, 6630, X, 4433, X,
    X, X, 6631, 3915, 1845, X, X, 3011, 2687, X, 3840, 2645, 2892, 6524, X, X,
    X, X, 6525, X, X, 6526, X, 1854, X, X, X, X, 1830, X, X, 6527, X, X, X, X,
    X, 6528, X, 4008, 4202, X, X, X, 7362, X, X, X, 7363, X, X, X, X, X, X, X,
    X, 7364, X, X, 7361, 7360, X, X, X, 2791, 3487, 7359, X, X, X, X, X, 8612,
    X, 2221, X, X, X, 7517, X, X, X, 7518, 7519, 7520, X, 7522, 7521, X, X, X,
    X, X, X, X, X, X, X, X, 8450, 5884, 3221, 5887, 5882, X, X, X, 5886, X, X,
    X, X, 5885, 3415, 1466, 8278, X, X, X, X, 8490, X, X, X, X, X, X, 4247,
    2292, X, X, 2168, X, X, 3668, X, 6186, X, X, X, X, X, 8491, X, 6188, X, X,
    X, 7212, X, X, X, 4606, 4605, X, X, X, X, 7213, 6471, 7214, 3199, 2830,
    3603, X, X, X, X, 7215, X, X, 3906, 3341, 2349, X, X, 3204, 2816, 8583,
    7333, 7335, X, 8582, 2024, X, 3796, X, X, 2603, 4326, X, 7331, 2437, X, X,
    4354, X, X, 7337, X, X, X, X, 7336, 7338, X, X, X, X, 1165, X, X, X, X, X,
    X, X, X, X, 1169, X, X, X, X, X, X, 1160, X, X, X, 1163, X, X, X, X, X, X,
    X, 87, 14, X, X, X, X, X, X, X, 74, 61, X, X, 12, X, 182, X, X, X, X, X, X,
    X, X, X, X, 7785, 6226, X, X, 7107, 7502, X, X, 7786, X, 7787, X, X, X, X,
    X, X, X, X, X, X, 7789, 86, 220, 221, 222, 223, 224, 225, 226, 227, 228,
    229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243,
    244, 245, 45, 31, 46, 15, 17,
]; // 19977 entries

#[cfg(not(feature = "no-optimized-legacy-encoding"))]
const BACKWARD_TABLE_UPPER: &'static [u16] = &[
    0, 0, 0, 0, 0, 19890, 41, 8502, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 10529, 14857, 5775, 0, 8190, 14207, 999, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14081, 16810, 0, 0, 0, 0,
    0, 0, 19408, 8710, 0, 18084, 13317, 0, 19469, 0, 2586, 1608, 8724, 9123,
    12613, 10048, 0, 0, 9137, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18562, 0, 0, 0, 0,
    8806, 16925, 5904, 0, 0, 5564, 14065, 13301, 8493, 0, 5341, 13284, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15008,
    0, 8064, 14825, 8963, 5743, 14175, 936, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2321, 0,
    0, 0, 17011, 0, 0, 19865, 1525, 19431, 5346, 8743, 8994, 2306, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 14442, 967, 16778, 5278, 18052, 8652, 2554, 5377, 3893,
    6213, 8435, 1576, 17275, 9091, 18530, 8774, 16893, 14473, 4200, 12924,
    10021, 2491, 9028, 9961, 5532, 5309, 18981, 6777, 6105, 6042, 118, 19042,
    10717, 16838, 10654, 14976, 14793, 331, 8931, 14143, 7664, 904, 8868,
    14410, 18020, 9219, 8620, 8466, 2522, 16215, 3861, 16270, 243, 12774, 3756,
    9059, 1553, 9156, 9396, 5406, 4168, 3781, 9989, 4229, 16000, 3804, 17661,
    16866, 2746, 1701, 4480, 5500, 18949, 18110, 4601, 6073, 5692, 2471, 6010,
    6167, 18824, 19073, 3693, 15126, 19010, 9333, 10685, 9247, 18763, 2683,
    16028, 4323, 362, 6806, 2347, 299, 8899, 16122, 12897, 14111, 5918, 8285,
    16246, 12805, 7523, 1638, 7632, 272, 872, 8836, 14378, 9187, 5437, 16183,
    18886, 11191, 18655, 4260, 18258, 11889, 3829, 5594, 3923, 7546, 6243,
    17305, 7569, 4511, 12954, 10774, 211, 3724, 15157, 815, 9364, 4136, 2714,
    6837, 8316, 1669, 6448, 18316, 1730, 4448, 15512, 18231, 5468, 9309, 18917,
    11983, 4569, 3984, 2439, 5978, 6135, 148, 10747, 17689, 6196, 18792, 3661,
    4291, 7281, 16090, 4385, 14499, 7694, 12865, 7600, 840, 11098, 16325,
    14346, 5128, 4044, 4542, 4627, 11217, 16300, 15218, 2376, 18138, 6868,
    3598, 16385, 16151, 15245, 9426, 18854, 6479, 1761, 13548, 11159, 11857,
    179, 19103, 17720, 783, 7312, 4104, 6416, 18284, 4416, 18199, 6895, 9483,
    3504, 9277, 5159, 11248, 11951, 3952, 2407, 4820, 5946, 569, 12108, 3629,
    14283, 5065, 15276, 7249, 3535, 16058, 4353, 5190, 12833, 14314, 476, 9543,
    5096, 392, 4012, 7819, 15186, 3566, 720, 16353, 13516, 18635, 11047, 11127,
    11825, 13170, 7850, 751, 13201, 19161, 4072, 19130, 9634, 4656, 596, 19181,
    9603, 10867, 6384, 10836, 18167, 9451, 3472, 11919, 6273, 4788, 6304, 537,
    12076, 1789, 11023, 4713, 5033, 12045, 7217, 4682, 19490, 4849, 19268,
    19747, 444, 14649, 13576, 2037, 4739, 17335, 9511, 7186, 7787, 688, 19294,
    13484, 11793, 2006, 7500, 7756, 12984, 15667, 13138, 9571, 420, 12137,
    11075, 9715, 1975, 3409, 15305, 10804, 3440, 10960, 505, 8346, 2928, 3116,
    10991, 9663, 7878, 5001, 18346, 625, 15542, 12013, 656, 11405, 14529,
    15573, 7437, 11761, 7724, 15604, 7468, 2188, 1259, 15635, 6326, 1943,
    19515, 16415, 6509, 3377, 1372, 19775, 6357, 19210, 19241, 3141, 11735,
    11704, 10928, 3084, 17125, 4969, 11373, 17781, 7405, 2156, 7162, 1227,
    1911, 3345, 10896, 3052, 17750, 11678, 5812, 1345, 17093, 7074, 17864,
    13460, 11341, 7373, 2124, 1196, 7130, 1880, 3020, 7043, 12228, 11646, 7342,
    13667, 17832, 13428, 7099, 17456, 11309, 1849, 13636, 2092, 6925, 0, 0, 0,
    0, 5785, 1164, 4943, 11278, 16686, 13262, 19670, 18471, 2988, 7011, 12196,
    19322, 1318, 1818, 9808, 5220, 13605, 11614, 13396, 6563, 17424, 4911,
    16655, 19638, 17067, 18439, 13231, 6531, 13039, 17392, 10274, 17602, 2066,
    14711, 4879, 16623, 1465, 18407, 2799, 4768, 15761, 6619, 1137, 14679,
    1433, 13947, 2767, 15729, 3234, 13369, 2957, 11465, 13012, 17186, 12165,
    17365, 15697, 13337, 14736, 14261, 9692, 11433, 1287, 15913, 15881, 15429,
    15461, 9745, 8376, 15493, 9777, 3322, 12685, 19607, 19575, 10243, 7908,
    13728, 17571, 18376, 19379, 13852, 7940, 16596, 10359, 13760, 14558, 13884,
    2217, 1106, 7972, 1402, 10391, 3171, 13916, 10423, 3203, 15822, 12308,
    15854, 0, 0, 0, 0, 12622, 3295, 12583, 17155, 12340, 12654, 12372, 17809,
    0, 0, 17484, 6985, 19544, 5842, 12488, 17508, 13116, 17894, 5874, 11588,
    10212, 2856, 13697, 16444, 1043, 16716, 6678, 6683, 19804, 19352, 9838,
    12520, 17540, 13821, 17926, 2888, 12257, 16565, 10484, 6593, 14583, 65,
    13069, 1495, 2829, 16476, 11525, 10328, 8526, 1075, 15791, 16748, 12282,
    1017, 6715, 3264, 19836, 5248, 12552, 18676, 10302, 6954, 14039, 19699,
    5635, 12457, 17958, 2649, 0, 0, 0, 0, 0, 0, 17020, 16508, 11557, 18500,
    10111, 8998, 10149, 8558, 17216, 18703, 6747, 17990, 8406, 10181, 6647,
    13790, 8590, 12744, 18614, 17631, 18582, 15379, 8159, 16534, 19726, 0,
    17044, 13976, 10453, 11494, 14008, 12402, 0, 5604, 5662, 10561, 9868,
    14889, 12426, 10593, 10514, 0, 15096, 9900, 17246, 14915, 18733, 8222,
    2906, 15942, 9932, 10625, 14239, 14947, 2618, 16983, 15974, 0, 0, 0, 15406,
    2246, 8001, 10080, 2278, 90, 14764, 16957, 8679, 10118, 0, 0, 15316, 15040,
    8249, 12713, 8033, 13094, 15348, 19913, 15072, 5712, 8281, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19455, 0, 0, 0, 0, 2653, 0, 14602, 14634, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8096, 19945, 8128, 0, 0, 0, 0, 32,
]; // 2048 entries

#[cfg(feature = "no-optimized-legacy-encoding")]
const BACKWARD_SEARCH_LOWER: &'static [(u16, u16)] = &[
    (12, 183), (470, 526), (564, 645), (28, 182), (710, 779), (7542, 7552),
    (72, 188), (658, 710), (0, 462), (721, 769), (32791, 20189),
    (33550, 20124), (823, 827), (851, 858), (890, 906), (990, 1004),
    (1037, 1051), (1141, 1164), (1218, 1234), (34040, 20096), (1305, 1309),
    (1343, 1348), (34149, 20208), (34182, 20061), (34203, 20018),
    (34231, 20418), (34286, 20214), (34336, 20046), (1595, 1618), (1724, 1742),
    (34567, 20316), (34599, 19977), (1852, 1856), (1901, 1904), (34700, 19971),
    (34748, 20027), (34775, 20462), (2029, 2031), (34822, 20426), (2166, 2170),
    (2204, 2207), (2236, 2238), (35057, 19990), (35124, 20185), (35219, 20105),
    (2478, 2520), (35310, 20195), (2569, 2584), (2637, 2658), (2710, 2729),
    (35556, 20253), (2916, 2967), (35759, 20467), (35787, 20271), (3055, 3066),
    (35921, 20469), (3183, 3185), (3209, 3260), (3281, 3306), (3338, 3340),
    (3401, 3412), (36254, 20063), (36279, 20305), (3536, 3539), (36355, 20081),
    (3624, 3632), (3666, 3669), (3737, 3739), (3791, 3867), (36779, 19991),
    (4263, 4265), (37127, 20066), (38948, 20053), (7185, 7207), (33595, 20553),
    (33618, 21307), (865, 867), (881, 888), (33668, 21417), (33678, 21473),
    (937, 939), (33733, 20985), (984, 1006), (1077, 1079), (33867, 21123),
    (33899, 21106), (1143, 1149), (1159, 1169), (34002, 21361), (1273, 1275),
    (34068, 21364), (34077, 21450), (34097, 21435), (1348, 1357),
    (34150, 20957), (1392, 1394), (1415, 1418), (1426, 1432), (1453, 1467),
    (1503, 1510), (1519, 1525), (1554, 1557), (1569, 1571), (34366, 21320),
    (1618, 1627), (1695, 1707), (34510, 21449), (1757, 1760), (1783, 1789),
    (34568, 21066), (1813, 1816), (1832, 1834), (1856, 1859), (34672, 20816),
    (34701, 21489), (1946, 1954), (1967, 1969), (34749, 21462), (1993, 2003),
    (2031, 2033), (34810, 21460), (34819, 20986), (34829, 20934), (2075, 2077),
    (2088, 2102), (2170, 2172), (35006, 20995), (35022, 21416), (2293, 2296),
    (35111, 20999), (2357, 2360), (2395, 2400), (2425, 2437), (2471, 2482),
    (2493, 2496), (2543, 2552), (2565, 2569), (35352, 21336), (35380, 20516),
    (2658, 2660), (35457, 21189), (2729, 2732), (35544, 20856), (35561, 20814),
    (2811, 2821), (35617, 21040), (2864, 2866), (35648, 21311), (35661, 20984),
    (2915, 2918), (35695, 21335), (2936, 2944), (35771, 20493), (3020, 3022),
    (35806, 20989), (35817, 20843), (3066, 3070), (3096, 3098), (35892, 20633),
    (35903, 21305), (35957, 20904), (35990, 21103), (36005, 20998),
    (36021, 20853), (3265, 3274), (36050, 21193), (3296, 3307), (3340, 3342),
    (36120, 20882), (3363, 3382), (36171, 21448), (36200, 21209),
    (36210, 20901), (36221, 20813), (3470, 3476), (3485, 3495), (3512, 3515),
    (36310, 20653), (3588, 3596), (36382, 21129), (3630, 3633), (3648, 3652),
    (3669, 3671), (3684, 3686), (36474, 21172), (3722, 3729), (36611, 20760),
    (3854, 4039), (38100, 20495), (38703, 20880), (39618, 21202),
    (39946, 20956), (7204, 7231), (40163, 21167), (783, 803), (33596, 22258),
    (853, 912), (33707, 22290), (33774, 22025), (33799, 22057), (33820, 22238),
    (1080, 1102), (33900, 21917), (1153, 1171), (1219, 1238), (1291, 1311),
    (34125, 21932), (34162, 22343), (1412, 1430), (1454, 1471), (1525, 1527),
    (1571, 1573), (1599, 1601), (1627, 1632), (1698, 1727), (1743, 1762),
    (1784, 1802), (1859, 1861), (34702, 22519), (1995, 2004), (2102, 2106),
    (34940, 22478), (2189, 2191), (34975, 21767), (2253, 2258), (2396, 2405),
    (35198, 21930), (35276, 21822), (35320, 21828), (2585, 2587), (2603, 2615),
    (35428, 21899), (2719, 2734), (35538, 21746), (35562, 21520), (2813, 2822),
    (35634, 21516), (2902, 2911), (2967, 2969), (35772, 22521), (35829, 22138),
    (35866, 21542), (3173, 3186), (3238, 3240), (36057, 22275), (36075, 21574),
    (36110, 22346), (36129, 21536), (3387, 3393), (36184, 21619), (3443, 3445),
    (36249, 21839), (36278, 21807), (36364, 21519), (36467, 21570),
    (36497, 21644), (36688, 22232), (4039, 4201), (7232, 7242), (784, 790),
    (805, 816), (829, 832), (858, 883), (33667, 23013), (33680, 23344),
    (940, 943), (961, 968), (1007, 1011), (1053, 1055), (1079, 1082),
    (33887, 23398), (1165, 1176), (1238, 1241), (34027, 23395), (1275, 1277),
    (1301, 1312), (34126, 22659), (34200, 23507), (34239, 22865), (1527, 1529),
    (1573, 1575), (34369, 23087), (1632, 1636), (34467, 22741), (1727, 1729),
    (1762, 1765), (34559, 22586), (34584, 23519), (1861, 1874), (1905, 1907),
    (1930, 1944), (1977, 1983), (1996, 2005), (2043, 2050), (34858, 22899),
    (2106, 2110), (2173, 2176), (2208, 2211), (2239, 2241), (2288, 2297),
    (35081, 22768), (35128, 23459), (35173, 22609), (2431, 2435),
    (35240, 22679), (2497, 2522), (2544, 2554), (35340, 22890), (35372, 22727),
    (2635, 2640), (35429, 23541), (2699, 2707), (2720, 2722), (2734, 2736),
    (2777, 2779), (2795, 2798), (2814, 2826), (35635, 22530), (35667, 23493),
    (35681, 22856), (2944, 2955), (35755, 23110), (3005, 3012), (35830, 22617),
    (35867, 22915), (3148, 3150), (3186, 3189), (3240, 3284), (3297, 3311),
    (36111, 22952), (3366, 3389), (3422, 3451), (3462, 3464), (36256, 22812),
    (36283, 23461), (3535, 3546), (36401, 23534), (36430, 22593),
    (36475, 23105), (36786, 22808), (4198, 4340), (4356, 4366), (37730, 23528),
    (39942, 22575), (7244, 7258), (33584, 24245), (33600, 23561),
    (33639, 24341), (33681, 24433), (33711, 24310), (968, 970), (981, 986),
    (33806, 23784), (1055, 1057), (33850, 23830), (33870, 24275),
    (33888, 23731), (1169, 1178), (1220, 1226), (1241, 1263), (34080, 24339),
    (1330, 1332), (1359, 1362), (1383, 1396), (1438, 1440), (1472, 1474),
    (34297, 24314), (1557, 1559), (1575, 1578), (1602, 1604), (1636, 1644),
    (34485, 24573), (1744, 1766), (34563, 23822), (34602, 23665), (1866, 1870),
    (34693, 24335), (1949, 1955), (1969, 1979), (2005, 2007), (34801, 24467),
    (2055, 2093), (2110, 2118), (34944, 24120), (2203, 2212), (2241, 2244),
    (35026, 24101), (2273, 2275), (35065, 24449), (35095, 24109), (2361, 2364),
    (35174, 23720), (2435, 2447), (2489, 2500), (2523, 2526), (35342, 24061),
    (2605, 2616), (35408, 24544), (2662, 2669), (2736, 2741), (2771, 2781),
    (2798, 2800), (35580, 24230), (2826, 2828), (35609, 24403), (2868, 2883),
    (2896, 2904), (2933, 2966), (35746, 24052), (35760, 24259), (35813, 24161),
    (35838, 24070), (3100, 3102), (3125, 3127), (3138, 3144), (3154, 3164),
    (35942, 24428), (3190, 3192), (3216, 3232), (3255, 3258), (36052, 24321),
    (3311, 3315), (3344, 3347), (36145, 24140), (36162, 24149), (3419, 3422),
    (36245, 23588), (3492, 3496), (36284, 24189), (3543, 3547), (3589, 3598),
    (36376, 24459), (36439, 23994), (36456, 24265), (3708, 3710),
    (36558, 24332), (36574, 24333), (4340, 4509), (37322, 24560),
    (39959, 24389), (7258, 7275), (787, 818), (833, 836), (932, 947),
    (33738, 25276), (986, 994), (33807, 25105), (1057, 1063), (33851, 24936),
    (33871, 25313), (1124, 1135), (1178, 1183), (34013, 25582), (1277, 1289),
    (34081, 24613), (1332, 1335), (1362, 1366), (1427, 1441), (1474, 1479),
    (34272, 25119), (1530, 1534), (34346, 25144), (34372, 24735), (1644, 1649),
    (34468, 25335), (1718, 1731), (1756, 1768), (1817, 1836), (1870, 1872),
    (1907, 1909), (34706, 24713), (34723, 25448), (1979, 1984), (1997, 2010),
    (34802, 25102), (34845, 25152), (34861, 24661), (2118, 2123),
    (34945, 24773), (34960, 25325), (2212, 2214), (35027, 25512),
    (35047, 25454), (2298, 2300), (2328, 2330), (2344, 2348), (2364, 2366),
    (35175, 25514), (2437, 2443), (2473, 2497), (2511, 2513), (2526, 2529),
    (2554, 2557), (2587, 2589), (35384, 24677), (35409, 25277), (2669, 2671),
    (35458, 25431), (35476, 25524), (2741, 2745), (35583, 24594), (2828, 2830),
    (35637, 24999), (35672, 24775), (35689, 25466), (2960, 2980), (2993, 2995),
    (35790, 25293), (35825, 25244), (35857, 25405), (3102, 3106),
    (35932, 25551), (3192, 3194), (3232, 3243), (3290, 3300), (3315, 3317),
    (36115, 25151), (3404, 3413), (3478, 3483), (3504, 3520), (3547, 3549),
    (3568, 3570), (36380, 25504), (36393, 24942), (36440, 24604), (3689, 3691),
    (36502, 24785), (4507, 4709), (37510, 25260), (39224, 25117),
    (39406, 25160), (7275, 7289), (797, 804), (818, 823), (33604, 26131),
    (914, 916), (962, 972), (1012, 1015), (1063, 1066), (1096, 1105),
    (1183, 1185), (1246, 1250), (34047, 25836), (34066, 26485), (1314, 1316),
    (34095, 26087), (34134, 25945), (1384, 1398), (1479, 1482), (34273, 25731),
    (34285, 26376), (1579, 1581), (1649, 1654), (1731, 1733), (34515, 26619),
    (34528, 26368), (1777, 1786), (1802, 1806), (1818, 1838), (1849, 1851),
    (1872, 1878), (34677, 26178), (1947, 1958), (34738, 26451), (34752, 26417),
    (34803, 26580), (2056, 2064), (2078, 2085), (2123, 2128), (2178, 2181),
    (2214, 2216), (2275, 2304), (2323, 2333), (35114, 25666), (2366, 2377),
    (2408, 2410), (2443, 2446), (2484, 2502), (35281, 26561), (35297, 26367),
    (35357, 26086), (2606, 2618), (2642, 2644), (2671, 2673), (35460, 26389),
    (35480, 26584), (2761, 2773), (2800, 2802), (2830, 2832), (35638, 25758),
    (2905, 2912), (35709, 26085), (35729, 25754), (2980, 2983), (2995, 2997),
    (3023, 3032), (3071, 3074), (35858, 26217), (35874, 26000), (3127, 3134),
    (3175, 3182), (3194, 3197), (35978, 25771), (35993, 26381), (3249, 3259),
    (36068, 26286), (3317, 3320), (3348, 3351), (3367, 3406), (36185, 26410),
    (36213, 26126), (36227, 25720), (3471, 3475), (36269, 26611), (3520, 3522),
    (3549, 3551), (36347, 26469), (36366, 26446), (3626, 3635), (36420, 26519),
    (36450, 26278), (36478, 26391), (36503, 26528), (36639, 26371),
    (36801, 26364), (37088, 25992), (37434, 25812), (37454, 25628),
    (4709, 4879), (7187, 7191), (7289, 7316), (33569, 26771), (33587, 26696),
    (33605, 26885), (33664, 27421), (33684, 26628), (33704, 27022), (972, 989),
    (33783, 27468), (33834, 26800), (33852, 27010), (1105, 1108), (1121, 1129),
    (1144, 1156), (1185, 1189), (1250, 1255), (34048, 27450), (1294, 1296),
    (34135, 27211), (1385, 1400), (1436, 1452), (34250, 26690), (1508, 1511),
    (1534, 1536), (1605, 1607), (1654, 1657), (1722, 1735), (1768, 1770),
    (34560, 27018), (1810, 1822), (1838, 1852), (1878, 1880), (1900, 1911),
    (1985, 1999), (2064, 2066), (2128, 2131), (2193, 2195), (2216, 2218),
    (35049, 26905), (2304, 2307), (2367, 2369), (35178, 26970), (2447, 2449),
    (35283, 26965), (2577, 2591), (2608, 2610), (35419, 27159), (2700, 2718),
    (35513, 26799), (35557, 27583), (2832, 2835), (2888, 2896), (2923, 2929),
    (3006, 3008), (35812, 27368), (35875, 27604), (3122, 3129), (3147, 3156),
    (3211, 3218), (3291, 3302), (36119, 26834), (36143, 27526), (3391, 3401),
    (36207, 26891), (3454, 3465), (3551, 3553), (36338, 27442), (3590, 3600),
    (36403, 26753), (36451, 27508), (3701, 3713), (3731, 3744), (36977, 27584),
    (37010, 26790), (4879, 5075), (7175, 7189), (7314, 7332), (33564, 28197),
    (33627, 28322), (33641, 28139), (893, 902), (917, 929), (947, 949),
    (33731, 27738), (982, 995), (33784, 27827), (33835, 28023), (1085, 1093),
    (1130, 1138), (1189, 1193), (1255, 1257), (1316, 1319), (1335, 1341),
    (34136, 27841), (34210, 27795), (34251, 28179), (1506, 1513), (1559, 1561),
    (34349, 28246), (1657, 1662), (1701, 1715), (1735, 1749), (34538, 28168),
    (34648, 27663), (1911, 1924), (1939, 1941), (34778, 27954), (2036, 2046),
    (2066, 2081), (2131, 2135), (34949, 27972), (2218, 2220), (35028, 27700),
    (35054, 28548), (35075, 28165), (2369, 2374), (35165, 28472),
    (35217, 28437), (35253, 28204), (35274, 27760), (2530, 2532), (2549, 2563),
    (2591, 2593), (35386, 27744), (35412, 27880), (35441, 28526), (2693, 2719),
    (35514, 27712), (2760, 2803), (2836, 2839), (2871, 2884), (35674, 27788),
    (35699, 27741), (35719, 28641), (2970, 2985), (3024, 3033), (35819, 28300),
    (3074, 3076), (35876, 27852), (3156, 3158), (35944, 27996), (35965, 28014),
    (3230, 3234), (3320, 3322), (36142, 27809), (3406, 3431), (36220, 28357),
    (36274, 27833), (3522, 3524), (3553, 3555), (3571, 3592), (3615, 3617),
    (36404, 28092), (3653, 3664), (36459, 28451), (3713, 3715), (36512, 28286),
    (5076, 5244), (39544, 28662), (7332, 7354), (33606, 28858), (33651, 28879),
    (949, 954), (975, 990), (1017, 1019), (33808, 29273), (33836, 28784),
    (33876, 29554), (33990, 29609), (34049, 29344), (1319, 1329), (1369, 1390),
    (1418, 1420), (34214, 29066), (34237, 29674), (1536, 1539), (1561, 1563),
    (34350, 29392), (1713, 1721), (1771, 1774), (1839, 1841), (34649, 29509),
    (34681, 29246), (1958, 1988), (2038, 2051), (2135, 2138), (2182, 2196),
    (35029, 28810), (2290, 2309), (2374, 2376), (2398, 2412), (2433, 2451),
    (35318, 28711), (2579, 2594), (2652, 2654), (35442, 29266), (35462, 29645),
    (35491, 29226), (35555, 28857), (2839, 2841), (2884, 2921), (2956, 2963),
    (2998, 3010), (35801, 29190), (3076, 3087), (35945, 28693), (35966, 29238),
    (3235, 3244), (36043, 29255), (36090, 28921), (36137, 29287), (3434, 3466),
    (36257, 29242), (3524, 3526), (36323, 29076), (36377, 29575), (3637, 3655),
    (3673, 3717), (36802, 29166), (36898, 29151), (37958, 28748), (5234, 5367),
    (38155, 29681), (7179, 7187), (7354, 7379), (839, 841), (33670, 29916),
    (920, 931), (33732, 29989), (33809, 30011), (1069, 1071), (33929, 29926),
    (1193, 1197), (1223, 1225), (34025, 30079), (34050, 30097), (34088, 29699),
    (34139, 30703), (34168, 29748), (34188, 30697), (34252, 30054),
    (34310, 30476), (34375, 29786), (1662, 1664), (34484, 29969), (1736, 1750),
    (1824, 1842), (1914, 1916), (34709, 30142), (2057, 2070), (2138, 2140),
    (34951, 30067), (2220, 2223), (35010, 29978), (2262, 2272), (35059, 30045),
    (2309, 2311), (35101, 30707), (2412, 2414), (2452, 2454), (35327, 29730),
    (35362, 30701), (2610, 2637), (2675, 2677), (2691, 2705), (35533, 30340),
    (2783, 2804), (2835, 2843), (2872, 2886), (35694, 30071), (2985, 2998),
    (3017, 3026), (3047, 3053), (3079, 3093), (3109, 3111), (3129, 3166),
    (35950, 29942), (3267, 3271), (36060, 29995), (3370, 3383), (3431, 3447),
    (3466, 3474), (3493, 3508), (36294, 30001), (36324, 29992), (3600, 3619),
    (3638, 3640), (3655, 3662), (36765, 30008), (37531, 30027), (37804, 30428),
    (5362, 5551), (39920, 30391), (39945, 29796), (40023, 29999), (7377, 7395),
    (33561, 31312), (33609, 31227), (856, 862), (889, 892), (33690, 31310),
    (33763, 31311), (1011, 1023), (33854, 30861), (1109, 1111), (33893, 31520),
    (33917, 31427), (1197, 1199), (1258, 1261), (1283, 1298), (1321, 1324),
    (1341, 1351), (1401, 1404), (1430, 1446), (34230, 31041), (34253, 31293),
    (34281, 31348), (1539, 1541), (34376, 30849), (1664, 1666), (34455, 30783),
    (34477, 31296), (34518, 30722), (1774, 1777), (1797, 1813), (34610, 31639),
    (1882, 1884), (1916, 1929), (1945, 1960), (34756, 31278), (2011, 2013),
    (2046, 2059), (2140, 2146), (34952, 31331), (2223, 2225), (35017, 31525),
    (2324, 2351), (2377, 2379), (2400, 2417), (35222, 31379), (35313, 31532),
    (35343, 31466), (2595, 2597), (2620, 2634), (2747, 2750), (35534, 31515),
    (2809, 2811), (2843, 2847), (2873, 2895), (2952, 2954), (35754, 30772),
    (3016, 3044), (35826, 31567), (3084, 3094), (3111, 3113), (3134, 3167),
    (35967, 31526), (35994, 31119), (3268, 3277), (36063, 31298),
    (36091, 30770), (3371, 3385), (3420, 3427), (36295, 31056), (36325, 31407),
    (3610, 3623), (36408, 31260), (36442, 31036), (3717, 3725), (36513, 30871),
    (36682, 31480), (37017, 31442), (5551, 5716), (39644, 31455), (7396, 7412),
    (809, 814), (842, 844), (33652, 32701), (33722, 32257), (33744, 32705),
    (33839, 32117), (33926, 31909), (1199, 1203), (33994, 32747),
    (34029, 32000), (34052, 32681), (1324, 1327), (1391, 1405), (1448, 1458),
    (1486, 1491), (34282, 32080), (34309, 32121), (34331, 32067),
    (34351, 31946), (1666, 1671), (34505, 32058), (1778, 1787), (34576, 32034),
    (34611, 32386), (1884, 1887), (1951, 1961), (1999, 2016), (2039, 2049),
    (2070, 2084), (2146, 2148), (34964, 32340), (34993, 32051), (2263, 2265),
    (35079, 31934), (2335, 2354), (2379, 2382), (2401, 2420), (2455, 2458),
    (35260, 32154), (35365, 32187), (35389, 32622), (2715, 2723),
    (35518, 32224), (35550, 32399), (2847, 2849), (35693, 32260), (2963, 2972),
    (35756, 32629), (3027, 3035), (35824, 32624), (35848, 32321), (3113, 3132),
    (35918, 32016), (3245, 3278), (36070, 31807), (36092, 32299),
    (36121, 32033), (36148, 32763), (36177, 32365), (36197, 31885),
    (3455, 3497), (3558, 3585), (36388, 31890), (3641, 3665), (3693, 3695),
    (36798, 31762), (37386, 32633), (5703, 5901), (39948, 32394), (7413, 7421),
    (792, 800), (844, 875), (33660, 33276), (33676, 33615), (33692, 33521),
    (955, 957), (983, 988), (1023, 1044), (33840, 33445), (1156, 1161),
    (1203, 1218), (1289, 1303), (1372, 1375), (1405, 1407), (34189, 33510),
    (1491, 1501), (34311, 32937), (34332, 33335), (1585, 1588), (1671, 1679),
    (34483, 33136), (34506, 33390), (34547, 33756), (34561, 32948),
    (1887, 1890), (1918, 1921), (1948, 1962), (1976, 1990), (2016, 2018),
    (34827, 33308), (2148, 2150), (2197, 2199), (2226, 2228), (35012, 33102),
    (35050, 33733), (2312, 2338), (35122, 33292), (2382, 2385), (35170, 33203),
    (2458, 2461), (35242, 33235), (2514, 2535), (2564, 2574), (2598, 2600),
    (2622, 2635), (35422, 33511), (2677, 2680), (35519, 33351), (35572, 33759),
    (35642, 33012), (35666, 33515), (35706, 32905), (2972, 2975), (2989, 3001),
    (3028, 3047), (35849, 33324), (35883, 32933), (3139, 3142), (35935, 33495),
    (3200, 3213), (35995, 33145), (36018, 32862), (36055, 33303),
    (36071, 33769), (3325, 3327), (3354, 3356), (36163, 33180), (36195, 33032),
    (3461, 3469), (36258, 32822), (36327, 32768), (36348, 33713),
    (36410, 33391), (36424, 33256), (36443, 33491), (36463, 32879),
    (3718, 3747), (36573, 33298), (37507, 33289), (5902, 6096), (7422, 7427),
    (791, 808), (33613, 33806), (33643, 34093), (33665, 34074), (33725, 34199),
    (1029, 1045), (1073, 1098), (1138, 1158), (34053, 34811), (34071, 34384),
    (34104, 34394), (34143, 34126), (34196, 34398), (34223, 34219),
    (34261, 34509), (34356, 34382), (34590, 34217), (34612, 34453),
    (34689, 33940), (1944, 1966), (34786, 33936), (2085, 2087), (2150, 2152),
    (2185, 2202), (34996, 34218), (35123, 34633), (35153, 34214),
    (35188, 34311), (2461, 2476), (35334, 34552), (35368, 34507), (2623, 2656),
    (35448, 34678), (35482, 34086), (2850, 2853), (35643, 33796),
    (35686, 34201), (2939, 2956), (35745, 34468), (3015, 3030), (35831, 34532),
    (3082, 3096), (3170, 3172), (3213, 3221), (3260, 3272), (3327, 3330),
    (3415, 3426), (36237, 33945), (3497, 3503), (36302, 34701), (3560, 3594),
    (3611, 3628), (36464, 34030), (36488, 34635), (3741, 3743), (36712, 34389),
    (5013, 5029), (38277, 34351), (6077, 6263), (39952, 34012), (7427, 7434),
    (33582, 34999), (846, 848), (925, 934), (33745, 35158), (33798, 35506),
    (33819, 35299), (1088, 1090), (1111, 1113), (33907, 35088), (1206, 1208),
    (1263, 1265), (1286, 1297), (34105, 35377), (1407, 1410), (1456, 1462),
    (1494, 1517), (1544, 1546), (1565, 1590), (1609, 1612), (1679, 1682),
    (1751, 1754), (34548, 35009), (34613, 35715), (1890, 1896), (34694, 35672),
    (34730, 35613), (2019, 2022), (34820, 34899), (34855, 35576), (2152, 2158),
    (2186, 2200), (2229, 2266), (35053, 35070), (2314, 2319), (2348, 2352),
    (35154, 35438), (35189, 35380), (35232, 35013), (2494, 2508),
    (35303, 34955), (2560, 2612), (2646, 2648), (2681, 2683), (2752, 2754),
    (2853, 2855), (35658, 35501), (35687, 35598), (35718, 35469), (2976, 2982),
    (3116, 3118), (3152, 3162), (35971, 35676), (3228, 3230), (36061, 35036),
    (3330, 3332), (36124, 35584), (3498, 3509), (3528, 3540), (3562, 3605),
    (36411, 35538), (36455, 35010), (3727, 3741), (37543, 35722),
    (37880, 34893), (38658, 35697), (38965, 34851), (39005, 34821),
    (6256, 6435), (39588, 35149), (39949, 35100), (7436, 7448), (33653, 36802),
    (33702, 36234), (1032, 1046), (33844, 35997), (1113, 1115), (33908, 36676),
    (1208, 1228), (1265, 1269), (34106, 36317), (1410, 1423), (1444, 1459),
    (1497, 1502), (1546, 1548), (34358, 36328), (1682, 1684), (1702, 1722),
    (1781, 1788), (34614, 36059), (1896, 1898), (1922, 1964), (34758, 36259),
    (2022, 2024), (34821, 36848), (2158, 2160), (34970, 36785), (2231, 2247),
    (35045, 36264), (2338, 2342), (2387, 2389), (2465, 2491), (35304, 36024),
    (2571, 2579), (35424, 36015), (2683, 2714), (35500, 35998), (35522, 36420),
    (2773, 2786), (35573, 36077), (2855, 2857), (35675, 35930), (2929, 2938),
    (35743, 36786), (3001, 3031), (35851, 36009), (35886, 36027), (3162, 3180),
    (3204, 3207), (3278, 3295), (36100, 35914), (3357, 3359), (36175, 36804),
    (36215, 36855), (36248, 36016), (3499, 3510), (36308, 36671),
    (36332, 36362), (36425, 36650), (3703, 3705), (36500, 36036),
    (36571, 35947), (3977, 3979), (38611, 36782), (6435, 6610), (7448, 7454),
    (33558, 36898), (848, 861), (33674, 36939), (33695, 37613), (958, 960),
    (33802, 36942), (1090, 1099), (33883, 37101), (1151, 1153), (33977, 36996),
    (34072, 36870), (34107, 37624), (1376, 1378), (1396, 1414), (1433, 1460),
    (1548, 1550), (34359, 37431), (34380, 37264), (1684, 1689), (34478, 37239),
    (34520, 37782), (34540, 37319), (34577, 37679), (34595, 37638),
    (34615, 37240), (1964, 1976), (34759, 37202), (2024, 2042), (2072, 2074),
    (34862, 37604), (2160, 2163), (2187, 2189), (2233, 2235), (2252, 2270),
    (2319, 2321), (2389, 2393), (35191, 36961), (2466, 2503), (2537, 2547),
    (35338, 36948), (35370, 37723), (2624, 2632), (2648, 2650), (2685, 2726),
    (2755, 2776), (2806, 2809), (2857, 2859), (2876, 2878), (2900, 2923),
    (3002, 3015), (3050, 3054), (35853, 37318), (35887, 36991), (35914, 36924),
    (3168, 3170), (35983, 37096), (3280, 3289), (3333, 3335), (3359, 3373),
    (36216, 37528), (36259, 37326), (3530, 3533), (36333, 36965),
    (36354, 37226), (36373, 37324), (3644, 3646), (36444, 37428), (3697, 3699),
    (3721, 3727), (38411, 36995), (6593, 6731), (39518, 37417), (7176, 7190),
    (7456, 7504), (33553, 38463), (820, 822), (876, 908), (33703, 38322),
    (33764, 38899), (1035, 1047), (1074, 1076), (1116, 1119), (33914, 38788),
    (1210, 1229), (34058, 38816), (34146, 38911), (1434, 1448), (34275, 38553),
    (1550, 1568), (34360, 38599), (1689, 1691), (1782, 1791), (34591, 38609),
    (34666, 38604), (34699, 38635), (34768, 38656), (34795, 38598),
    (34863, 38500), (2163, 2166), (2235, 2285), (2321, 2327), (35120, 38634),
    (35161, 38275), (35190, 38459), (35237, 38684), (35284, 38464),
    (2539, 2562), (2686, 2698), (35560, 38651), (2859, 2864), (2930, 2947),
    (35781, 38506), (3059, 3065), (35888, 38750), (3207, 3209), (3248, 3263),
    (36053, 38829), (36128, 38450), (3437, 3458), (3484, 3504), (36301, 38596),
    (3566, 3583), (3606, 3622), (3646, 3680), (36473, 38706), (36799, 38617),
    (37608, 38712), (38720, 38539), (39014, 38614), (39176, 38827),
    (39391, 38568), (6731, 6879), (39898, 38753), (7504, 7519), (800, 812),
    (33640, 39154), (909, 932), (1047, 1065), (1091, 1094), (1122, 1124),
    (1216, 1232), (1269, 1272), (34110, 39770), (1379, 1381), (1423, 1426),
    (1498, 1503), (1551, 1553), (1593, 1615), (1691, 1694), (1719, 1740),
    (1811, 1849), (34667, 39164), (34760, 39318), (2060, 2075), (2191, 2201),
    (2251, 2284), (35162, 39854), (35238, 39442), (2517, 2519), (2541, 2548),
    (35393, 39347), (35418, 39376), (35455, 38914), (35554, 39003),
    (2861, 2863), (2909, 2925), (35758, 39340), (3036, 3055), (3087, 3089),
    (3121, 3138), (35948, 38971), (3218, 3237), (36032, 38913), (36103, 39165),
    (36130, 38956), (3385, 3398), (36186, 39749), (36244, 39173),
    (36309, 38928), (3567, 3582), (3647, 3666), (36468, 39791), (36757, 39149),
    (5032, 5039), (38525, 39739), (38669, 39132), (6879, 7034), (7519, 7534),
    (864, 899), (960, 981), (1129, 1155), (34067, 40653), (34267, 40335),
    (34321, 40568), (34362, 40723), (1694, 1713), (34566, 40442), (1924, 1928),
    (35192, 40736), (2540, 2581), (35456, 40165), (35494, 40372),
    (35527, 40718), (2879, 2898), (3037, 3061), (35900, 40763), (35940, 39981),
    (3336, 3338), (3386, 3473), (36391, 40845), (3659, 3682), (3723, 3740),
    (37208, 40636), (37843, 40638), (38113, 40664), (5598, 5628),
    (39247, 40782), (39642, 40783), (7030, 7174), (7534, 7540), (7231, 7538),
    (3, 278), (7553, 7556),
]; // 1575 entries

#[cfg(feature = "no-optimized-legacy-encoding")]
const BACKWARD_SEARCH_UPPER: &'static [u16] = &[
    0, 2, 3, 3, 3, 3, 3, 3, 3, 6, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 74, 194,
    259, 345, 441, 532, 631, 707, 790, 855, 926, 1005, 1075, 1156, 1217, 1288,
    1352, 1426, 1486, 1540, 1572, 1572, 1572, 1572, 1572, 1572, 1572, 1572,
    1572, 1572, 1572, 1572, 1572, 1572, 1572, 1572, 1572, 1572, 1572, 1572,
    1572, 1572, 1572, 1573, 1575,
]; // 65 entries

const BACKWARD_TABLE_REMAPPED: &'static [u16] = &[
    10744, 10745, 10746, 10747, 10748, 10749, 10750, 10751, 10752, 10753,
    10754, 10755, 10756, 10757, 10758, 10759, 10760, 10761, 10762, 10763,
    10764, 10765, 10766, 10767, 10768, 10769, 10770, 10771, 10772, 10773,
    10774, 10775, 10776, 10777, 10778, 10779, 10780, 10781, 10782, 10783,
    10784, 10785, 10786, 10787, 10788, 10789, 10790, 10791, 10792, 10793,
    10794, 10795, 10796, 10797, 10798, 10799, 10800, 10801, 10802, 10803,
    10804, 10805, 10806, 10807, 10808, 10809, 10810, 10811, 10812, 10813,
    10814, 10815, 10816, 10817, 10818, 10819, 10820, 10821, 10822, 10823,
    10824, 10825, 10826, 10827, 10828, 10829, 10830, 10831, 10832, 10833,
    10834, 10835, 10836, 10837, 10838, 10839, 10840, 10841, 10842, 10843,
    10844, 10845, 10846, 10847, 10848, 10849, 10850, 10851, 10852, 10853,
    10854, 10855, 10856, 10857, 10858, 10859, 10860, 10861, 10862, 10863,
    10864, 10865, 10866, 10867, 10868, 10869, 10870, 10871, 10872, 10873,
    10874, 10875, 10876, 10877, 10878, 10879, 10880, 10881, 10882, 10883,
    10884, 10885, 10886, 10887, 10888, 10889, 10890, 10891, 10892, 10893,
    10894, 10895, 10896, 10897, 10898, 10899, 10900, 10901, 10902, 10903,
    10904, 10905, 10906, 10907, 10908, 10909, 10910, 10911, 10912, 10913,
    10914, 10915, 10916, 10917, 10918, 10919, 10920, 10921, 10922, 10923,
    10924, 10925, 10926, 10927, 10928, 10929, 10930, 10931, 10932, 10933,
    10934, 10935, 10936, 10937, 10938, 10939, 10940, 10941, 10942, 10943,
    10944, 10945, 10946, 10947, 10948, 10949, 10950, 10951, 10952, 10953,
    10954, 10955, 10956, 10957, 10958, 10959, 10960, 10961, 10962, 10963,
    10964, 10965, 10966, 10967, 10968, 10969, 10970, 10971, 10972, 10973,
    10974, 10975, 10976, 10977, 10978, 10979, 10980, 10981, 10982, 10983,
    10984, 10985, 10986, 10987, 10988, 10989, 10990, 10991, 10992, 10993,
    10994, 10995, 10996, 10997, 10998, 10999, 11000, 11001, 11002, 11003,
    11004, 11005, 11006, 11007, 11008, 11009, 11010, 11011, 11012, 11013,
    11014, 11015, 11016, 11017, 11018, 11019, 11020, 11021, 11022, 11023,
    11024, 11025, 11026, 11027, 11028, 11029, 11030, 11031, 11032, 11033,
    11034, 11035, 11036, 11037, 11038, 11039, 11040, 11041, 11042, 11043,
    11044, 11045, 11046, 11047, 11048, 11049, 11050, 11051, 11052, 11053,
    11054, 11055, 11056, 11057, 11058, 11059, 11060, 11061, 11062, 11063,
    11064, 11065, 11066, 11067, 11068, 11069, 11070, 11071, 11072, 11073,
    11074, 11075, 11076, 11077, 11078, 11079, 11080, 11081, 11082, 11083,
    11084, 11085, 11086, 11087, 11088, 11089, 11090, 11091, 11092, 11093,
    11094, 11095, 11096, 11097, 11098, 11099, 11100, 11101, 11102, 11103,
    65535, 65535, 10716, 10717, 10718, 10719, 10720, 10721, 10722, 10723,
    10724, 10725, 137, 10737, 10738, 10739, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
    65535, 65535, 65535,
]; // 564 entries

/// Returns the index pointer for code point `code` in this index.
#[inline]
#[cfg(not(feature = "no-optimized-legacy-encoding"))]
pub fn backward(code: u32) -> u16 {
    let offset = (code >> 5) as usize;
    let offset = if offset < 2048 {BACKWARD_TABLE_UPPER[offset] as usize} else {0};
    // BACKWARD_TABLE_LOWER stores the actual (pre-mapped) value
    // so we don't have to call premap_backward here.
    BACKWARD_TABLE_LOWER[offset + ((code & 31) as usize)]
}

/// Returns the index pointer for code point `code` in this index.
#[cfg(feature = "no-optimized-legacy-encoding")]
pub fn backward(code: u32) -> u16 {
    // avoid mistaking a placeholder for the actual value
    if code == X as u32 { return 0xffff; }
    let codelo = (code & 0xffff) as u16;
    let offset = (code >> 10) as usize;
    let (start, end) = if offset < 64 {
        (BACKWARD_SEARCH_UPPER[offset], BACKWARD_SEARCH_UPPER[offset+1])
    } else {
        (0, 0)
    };
    for &(s, e) in &BACKWARD_SEARCH_LOWER[(start as usize)..(end as usize)] {
        if s >= 0x8000 {
            if e == codelo {
                return premap_backward(s & 0x7fff);
            }
        } else {
            for i in s..e {
                if FORWARD_TABLE[i as usize] == codelo {
                    return premap_backward(i);
                }
            }
        }
    }
    X
}

/// Returns the index shift_jis pointer for code point `code`.
#[inline]
pub fn backward_remapped(code: u32) -> u16 {
    let value = backward(code);
    if 8272 <= value && value <= 8835 {
        BACKWARD_TABLE_REMAPPED[(value - 8272) as usize]
    } else {
        value
    }
}

#[cfg(test)]
multi_byte_tests! {
    remap = [8272, 8835],
    dups = [
        1207, 1208, 1209, 1212, 1213, 1214, 1217, 1218, 1219, 8644, 10716,
        10717, 10718, 10719, 10720, 10721, 10722, 10723, 10724, 10725, 10726,
        10727, 10728, 10729, 10730, 10731, 10732, 10733, 10734, 10735, 10736,
        10737, 10738, 10739, 10740, 10741, 10742, 10743, 10744, 10745, 10746,
        10747, 10748, 10749, 10750, 10751, 10752, 10753, 10754, 10755, 10756,
        10757, 10758, 10759, 10760, 10761, 10762, 10763, 10764, 10765, 10766,
        10767, 10768, 10769, 10770, 10771, 10772, 10773, 10774, 10775, 10776,
        10777, 10778, 10779, 10780, 10781, 10782, 10783, 10784, 10785, 10786,
        10787, 10788, 10789, 10790, 10791, 10792, 10793, 10794, 10795, 10796,
        10797, 10798, 10799, 10800, 10801, 10802, 10803, 10804, 10805, 10806,
        10807, 10808, 10809, 10810, 10811, 10812, 10813, 10814, 10815, 10816,
        10817, 10818, 10819, 10820, 10821, 10822, 10823, 10824, 10825, 10826,
        10827, 10828, 10829, 10830, 10831, 10832, 10833, 10834, 10835, 10836,
        10837, 10838, 10839, 10840, 10841, 10842, 10843, 10844, 10845, 10846,
        10847, 10848, 10849, 10850, 10851, 10852, 10853, 10854, 10855, 10856,
        10857, 10858, 10859, 10860, 10861, 10862, 10863, 10864, 10865, 10866,
        10867, 10868, 10869, 10870, 10871, 10872, 10873, 10874, 10875, 10876,
        10877, 10878, 10879, 10880, 10881, 10882, 10883, 10884, 10885, 10886,
        10887, 10888, 10889, 10890, 10891, 10892, 10893, 10894, 10895, 10896,
        10897, 10898, 10899, 10900, 10901, 10902, 10903, 10904, 10905, 10906,
        10907, 10908, 10909, 10910, 10911, 10912, 10913, 10914, 10915, 10916,
        10917, 10918, 10919, 10920, 10921, 10922, 10923, 10924, 10925, 10926,
        10927, 10928, 10929, 10930, 10931, 10932, 10933, 10934, 10935, 10936,
        10937, 10938, 10939, 10940, 10941, 10942, 10943, 10944, 10945, 10946,
        10947, 10948, 10949, 10950, 10951, 10952, 10953, 10954, 10955, 10956,
        10957, 10958, 10959, 10960, 10961, 10962, 10963, 10964, 10965, 10966,
        10967, 10968, 10969, 10970, 10971, 10972, 10973, 10974, 10975, 10976,
        10977, 10978, 10979, 10980, 10981, 10982, 10983, 10984, 10985, 10986,
        10987, 10988, 10989, 10990, 10991, 10992, 10993, 10994, 10995, 10996,
        10997, 10998, 10999, 11000, 11001, 11002, 11003, 11004, 11005, 11006,
        11007, 11008, 11009, 11010, 11011, 11012, 11013, 11014, 11015, 11016,
        11017, 11018, 11019, 11020, 11021, 11022, 11023, 11024, 11025, 11026,
        11027, 11028, 11029, 11030, 11031, 11032, 11033, 11034, 11035, 11036,
        11037, 11038, 11039, 11040, 11041, 11042, 11043, 11044, 11045, 11046,
        11047, 11048, 11049, 11050, 11051, 11052, 11053, 11054, 11055, 11056,
        11057, 11058, 11059, 11060, 11061, 11062, 11063, 11064, 11065, 11066,
        11067, 11068, 11069, 11070, 11071, 11072, 11073, 11074, 11075, 11076,
        11077, 11078, 11079, 11080, 11081, 11082, 11083, 11084, 11085, 11086,
        11087, 11088, 11089, 11090, 11091, 11092, 11093, 11094, 11095, 11096,
        11097, 11098, 11099, 11100, 11101, 11102, 11103,
    ]
}
