(use gauche.regexp)
(define (escape str)
  (set! str (regexp-replace-all #/&/ str "&amp;"))
  (set! str (regexp-replace-all #/</ str "&lt;"))
  (set! str (regexp-replace-all #/\"/ str "&quot;"))
  (set! str (regexp-replace-all #/@/ str "&#64;"))
  (set! str (regexp-replace-all #/>/ str "&gt;"))
  str)

(define (read-file-and-escape file)
  (call-with-input-file file
    (lambda (in)
      (escape (port->string in)))))

(define (main args)
  (call-with-input-file (cadr args)
    (lambda (in)
      (let* ((content (port->string in))
             (content (regexp-replace-all #/#\{(.*?)\}/ content
                                          (lambda (m)
                                            (string-append 
                                             "<pre>\n"
                                             (read-file-and-escape (rxmatch-substring m 1))
                                             "</pre>\n")))))
        (display content))))
  0)
