.TH XFACES 1
.SH NAME
xfaces - mail image display for X
.SH SYNOPSIS
.B xfaces
[-\fItoolkitoption\fP ...] [-\fIoption\fP ...]
.SH DESCRIPTION
.I XFaces
version 3.0
is a program that will display an image and optionally 
play a sound for each
piece of mail in your mail box. Additionaly, you can have 
a shell command executed. This lets you know at a
glance (or a listen, or a whatever) who you have mail from.
.I XFaces
starts out (when you
have no mail) looking like a color xbiff.
As you receive mail
.I XFaces
becomes a column (or a number of columns) of mail icons.
.PP
\fIXFaces\fP can also be used to monitor other lists using the
\fB\-e\fP option or the \fBlistCommand\fP resource.
.SH OPTIONS
.I Xfaces
accepts all of the standard X Toolkit command line options as well as
the following options designed to be compatible with Rich Burridge's
faces program:
.TP 8
.BI \-c " <columns>"
Specify the number of images that faces will allow before starting a
new row. This is also available as resource \fBXFaces.frame.maxWidth\fP.
.TP 8
.BI \-e " <command>"
Run \fI<command>\fP and use output for faces list.  This is also
available as \fBXFaces.listCommand\fP.
.TP 8
.BI \-f " <facedb path>"
This option set the default facedb search path to the colon separated
list of directories specified in \fB<facedb path>\fP.  Also available
as resource \fBXFaces.facedbPath\fP.
.TP 8
.BI \-h " <image height>"
This option sets the height used internally by \fIXFaces\fP to layout
images in a tiled fashion.  This is also available as the resource
\fBXFaces.frame.tileHeight\fP.
.TP 8
.BI \-p " <update time>"
Specify the amount of time to wait between checks for new mail.  Also
available as resource \fBXFaces.update\fP.
.TP 8
.BI \-s " <spool file>"
This option specifies an alternate mail spool file to watch.  Also
available as \fBXFaces.spoolFile\fP.
.TP 8
.BI \-w " <image width>"
This option sets the width used internally by \fIXFaces\fP to layout
images in a tiled fashion.  This is also available as the resource
\fBXFaces.frame.tileWidth\fP.
.TP 8
.B \-C
This option disables image compression.  Image compression is used to
only show a particular image only once in the display.  Also available
as resource \fBXFaces.compressImages\fP.
.TP 8
.B \-K
This option insists that the order of the images in the display reflect
the order of the images in the spool file or those returned by a
\fI<command>\fP.  Also available as resource \fBXFaces.keepOrder\fP.
.TP 8
.B \-S
This option says not to shape extra space added to images that are smaller
than the tile size.
.TP 8
.BI \-pop " <hostname>"
This option specifies the host name to use for a POP3 mailbox.  Also
available as \fBXFaces.popHost\fP.
.SH X DEFAULTS
The application class name is \fBXFaces\fP.  For best results the
following \fBShell\fP resource is suggested:
.PP
.TP 8
.BI XFaces.allowShellResize: " True"
This will allow the \fIXFaces\fP window to resize to be the exact size
that is required for the current images.
.PP
This program uses a very simple tiled layout widget to layout the
images.  Each image is displayed in an Athena Label widget.  The name
of the layout widget is \fIframe\fP and the following resources are
available:
.PP
.TP 8
.BI XFaces.frame.tileWidth: " <tile width>"
This resource specifies the width of the children that the \fBTiled\fP
widget is to manage.  This size is enforced.  The default is 64
.TP 8
.BI XFaces.frame.tileHeight: " <tile height>"
This resource specifies the height of the children that the \fBTiled\fP
widget is to manage.  This size is enforced.  The default is 64.
.TP 8
.BI XFaces.frame.setWidth: " <force width>"
This resource forces the width of the \fBTiled\fP widget to be
\fI<width>\fP tiles wide.  If the value is zero then no width is
forced.  The default is 0.
.TP 8
.BI XFaces.frame.setHeight: " <force height>"
This resource forces the height of the \fBTiled\fP widget to be
\fI<height>\fP tiles wide.  If the value is zero then no height is
forced.  The default is 0.
.TP 8
.BI XFaces.frame.minWidth: " <minimum width>"
This resource specifies the minimum width in tiles that the \fBTiled\fP
widget is allowed.  If the value is zero then there is no minimum.
The default is 0.
.TP 8
.BI XFaces.frame.minHeight: " <minimum height>"
This resource specifies the minimum height in tiles that the \fBTiled\fP
widget is allowed.  If the value is zero then there is no minimum.
The default is 0.
.TP 8
.BI XFaces.frame.maxWidth: " <maximum width>"
This resource specifies the maximum width in tiles that the \fBTiled\fP
widget is allowed.  If the value is zero then there is no maximum.
The default is 0.  Note that since the \fBTiled\fP widget lays out its
children in row major order a value of 0 creates a horizontal list of
images.  If the value is specified as 1 a vertical list is created.
.TP 8
.BI XFaces.frame.maxHeight: " <maximum height>"
This resource specifies the maximum height in tiles that the \fBTiled\fP
widget is allowed.  If the value is zero then there is no maximum.
The default is 0.
.TP 8
.BI XFaces.frame.vertSpacing: " <spacing>"
This resource specifies the spacing in pixels that the \fBTiled\fP
widget places vertically between children.
.TP 8
.B XFaces.frame.horizSpacing
This resource specifies the spacing in pixels that the \fBTiled\fP
widget places horizontally between children.
.TP 8
.B XFaces.frame.internalWidth
This resource specifies the spacing in pixels that the \fBTiled\fP
widget places horizontally between its borders and its children.
.TP 8
.B XFaces.frame.internalHeight
This resource specifies the spacing in pixels that the \fBTiled\fP
widget places vertically between its borders and its children.
.PP
.RS
\fBNote:\fP \fIIf you have specified a border width for the children
of the\fP \fBTiled\fP \fIwidget that is non zero then you should specify
the following resource values to be at least two times the border
width specified for the children:\fP
.RS
\(bu vertSpacing
.br
\(bu horizSpacing
.br
\(bu internalWidth
.br
\(bu internalHeight
.RE
.RE
.PP
\fIXFaces\fP also introduces the following application resources:
.PP
.TP 8
.BI XFaces.spoolFile: " <mail spool file>"
This can be used to specify the mail spool file to watch.  The default
is to append the users name onto the \fBspoolDir\fP resource.
.TP 8
.BI XFaces.spoolDir: " <mail spool directory>"
This resource specifies the directory that contains user mail spool
files.  The default is \fI/usr/spool/mail\fP.  On some machines (SVR4?)
you may want to set this to \fI/usr/mail\fP.
.TP 8
.BI XFaces.popHost: " <hostname>"
This resource specifies the name of a host to contact for a POP3
mailbox.  Note that in order for this to work you need to create a
file called \fI.popauth\fP in your home directory.  The file needs to
contain one line that contains your pop host login id followed by
white space followed by your pop host password.  Since this file
contains a clear text password it is not the most secure method.  I
currently do not have access to a pop server that supports any other
type of authentication.
.TP 8
.BI XFaces.popPort: " <port number>"
This specifies what \fIport number\fP to use for POP.  The default is
the standard POP3 port 110.
.TP 8
.BI XFaces.listCommand: <user command>
This resource specifies a user command that will be executed instead
of looking at the spool file. If this resource is specified then
value specified in the \fBspoolFile\fP is ignored.  See the \fBUSER
COMMANDS\fP section for a description of the data format that
\fIXFaces\fP expects from user commands.
.TP 8
.BI XFaces.imagePath: " <image path>"
This resource specifies a colon-separated list of directories that
specify the default directories to use for image files.  The default
is \fI/usr/images\fP.
.TP 8
.BI XFaces.soundPath: " <sound path>"
This resource specifies a colon-separated list of directories that
specify the default directories to use for sound files.  The default
is \fI/usr/sounds\fP.
.TP 8
.BI XFaces.facedbPath: " <facedb path>"
This is a list of directories that contain a multi-level directory hierarchy.
The first few levels are the host name where each part of the host
name is a new directory level. Inside this is another directory using
the users name. And finally, inside of this directory are the actual
image and sound files for this user.  The root of the face (for images
and for sounds) is \fIface\fP.  This file can be in any of the
supported image/sound formats.  See the description of the
\fIfacedb\fP search type under the \fBimageSearch\fP resource.
.TP 8
.BI XFaces.machine: " <machine file>"
This resource specifies the name of a file that is used to alias
machine names.  Each facedb tree is allowed to contain one of these.
The default is \fImachine.tab\fP.  Any blank lines and lines starting
with the \fI#\fP character are ignored.  All other lines are expected
to look like:
.PP
.RS
.RS
old.host.name=new.name
.RE
.RE
.TP 8
.BI XFaces.people: " <people file>"
This resource specifies the name of a file that is used to alias
user names for specific hosts.  Each facedb tree is allowed to contain
 one of these.  The default is \fIpeople.tab\fP.  Any blank lines and
lines starting with the \fI#\fP character are ignored.  All other
lines are expected to look like:
.PP
.RS
.RS
host.name/olduser=newuser
.RE
.RE
.TP 8
.BI XFaces.update: " <update time>"
How often to check for new mail in seconds. The
default is 60.
.TP 8
.B XFaces.volume:
The volume at which to play sounds. The default is
33.
.TP 8
.B XFaces.fromField:
This resource specifies which mail header to use as
the from header.  The default is the old uucp "From_"
header. (the _ is really a space character)
.TP 8
.BI XFaces.noMailImage: " <empty image>"
The image to use when you have no mail. The default
is "nomail".  The \fBimagePath\fI is used to locate this file.
.TP 8
.BI XFaces.noMailSound: " <empty sound>"
The sound to use when you have no mail. The default
not to play a sound with no mail.  The \fBsoundPath\fP is used to
locate this sound.
.TP 8
.BI XFaces.lookupHostname: " <flag>"
If this resource is \fBTrue\fP then the host name part of
the from address will be looked up and translated to the real
hostname. The default value is \fIFalse\fP.
.TP 8
.BI XFaces.keepOrder: " <flag>"
This boolean resource controls the image ordering in faces.  For
performance reasons the default is \fIFalse\fP.  When scripts are
being run you will usually want to specify this as \fITrue\fP.
.TP 8
.BI XFaces.compressImages: " <flag>"
Only show each image once in the image display. The
default is \fITrue\fP. When scripts are
being run you will usually want to specify this as \fIFalse\fP.
.TP 8
.BI XFaces.useSound: " <flag>"
Play sounds.  The default is \fITrue\fP.  A user can
disable sounds for his XFaces by setting this
resource to \fIFalse\fP in his resources.
.TP 8
.BI XFaces.useShape: " <flag>"
Use shaped images if available.  This will also cause the background
of the \fIXFaces\fP main window to become transparent where there is
no image.  This defaults to \fITrue\fP.
.TP 8
.BI XFaces.useCommands: " <flag>"
This resource tells \FIXFaces\fP if it needs to search for shell commands to
run in addition to image and sounds.  The default is \fIFalse\fP.
.TP 8
.BI XFaces.useContentLength: " <flag>"
This resource enable code to use a Content-Length: mail header to specify
how large the mail body is.  After the headers this many bytes are skiped.
.TP 8
.BI XFaces.shapeBorders: " <flag>"
This resource, when set to \fITrue\fP will cause the borders of the
Label widgets to be \fIshaped out\fP.  The default is \fITrue\fP.
.TP 8
.BI XFaces.shapeInternal: " <flag>"
This resource when set to \fITrue\fP will cause the internal width and
height margins of the Label widgets to be \fIshaped out\fP.  The
default is \fITrue\fP.
.TP 8
.BI XFaces.closeness: " <closeness value>"
This resource controls how close a color must come to the actual color
for the XPM library to accept it. The default is \fI40000\fP.
.TP 8
.BI XFaces.imageTypes: " <image type list>"
This resource specifies the default image types that are used to
attempt to load an image file.  The list also specifies the order the
types are attempted. Valid types are:
.PP
.RS 8
.TP 8
.B xpm-shaped
This is a shaped color image.  Shaped xpm files should be named
\fIface-shaped.xpm\fP.
.TP 8
.B xpm
This is a non shaped color image. These files should be named
\fIface.xpm\fP.
.TP 8
.B xbm-shaped
This a an monochrome shaped image.  The image file and mask are stored
in separate files called \fIface-shape.xbm\fP for the image data and
\fIface-shape.xbm-mask\fP for the shape mask.
.TP 8
.B xbm
This is a non shaped monochrome image.  These files should be called
\fIface.xbm\fP.
.RE
the default value for this resource is:
.PP
.RS 12
\fIxpm-shape:xpm:xbm-shape:xbm\fP
.RE
.TP 8
.BI XFaces.imageSearch: " <search specs>"
.TP 8
.BI XFaces.soundSearch: " <search specs>"
.TP 8
.BI XFaces.commandSearch: " <search specs>"
These resources have complete control of the search type , image types
for images and path arguments for locating images, sounds and commands.
The search spec is a multi line resource. Each line represents a new
search.  Each line is constructed as follows:
.PP
.RS 12
<search type> [<format list> [<search path>]]
.RE
.RS 8
.PP
The \fI<format list>\fP is currently ignored for the \fBsoundSearch\fP
resource. Both the \fI<format list>\fP and the <search path> are 
(except if you use the \fIfacedb\fP search) for the \fBcommandSearch\fP
resoiurce.  If the \fI<format list>\fP is empty then the list in the
\fBimageFormats\fP resource is used.  If the \fI<search path>\fP is
empty then the \fBfacedbPath\fP is used for \fIfacedb\fP searches for
both sounds and images and one of the \fBsoundPath\fP or
\fBimagePath\fP is used for the other search types.
.PP
The valid search types are:
.TP 8
.B beforeImage
The \fBbeforeImageBindings\fP resource is used as a set of regular
expression to match lines in the mail header.
.B beforeSound
The \fBbeforeSoundBindings\fP resource is used as a set of regular
expression to match lines in the mail header.
.B beforeCommand
The \fBbeforeCommandBindings\fP resource is used as a set of regular
expression to match lines in the mail header.
.TP 8
.B resource
The user name and host name are looked up in the X resources for a
match. The resources attempted are:
.PP
.RS 12
XFaces.\fI<type>\fP.user@host
.br
XFaces.\fI<type>\fP.user
.br
XFaces.\fI<type>\fP.host
.RE
Where type is one of: \fBimage\fP, \fBsound\fP, \fBcommand\fP.
.TP 8
.B u@h
The user name and host name is combined and looked for as a file name.
The names attempted are:
.PP
.RS 12
[path]user@host
.br
[path]user
.br
[path]host
.RE
.TP 8
.B facedb
This is the search that is used in Rich Burridge's \fIfaces\fP
program.  The search attempts the following for the address
liebman@zod.clark.net:
.PP
.RS 12
[path]/net/clark/zod/liebman
.br
[path]/net/clark/zod/liebman/face
.br
[path]/net/clark/liebman
.br
[path]/net/clark/liebman/face
.br
[path]/net/liebman
.br
[path]/net/liebman/face
.br
[path]/MISC/liebman
.br
[path]/MISC/liebman/face
.br
[path]/net/clark/zod/unknown
.br
[path]/net/clark/zod/unknown/face
.br
[path]/net/clark/unknown
.br
[path]/net/clark/unknown/face
.br
[path]/net/unknown
.br
[path]/net/unknown/face
.br
[path]/MISC/unknown
.br
[path]/MISC/unknown/face
.RE
.TP 8
.B x-face
This looks for an \fBX-Face:\fP header and extracts a 48 pixel by 48
pixel monochrome image.
.TP 8
.B afterImage
The \fBafterImageBindings\fP resource is used as a set of regular
expression to match lines in the mail header.
.TP 8
.B afterSound
The \fBafterSoundBindings\fP resource is used as a set of regular
expression to match lines in the mail header.
.TP 8
.B afterImage
The \fBafterCommandBindings\fP resource is used as a set of regular
expression to match lines in the mail header.
.PP
The default value of the \fBimageSearch\fP resource is:
.RS 12
\fIbeforeImage\fP\\n\\
.br
\fIresource\fP\\n\\
.br
\fIfacedb\fP\\n\\
.br
\fIx-face\fP\\n\\
.br
\fIafterImage\fP
.RE
The default value of the \fBsoundSearch\fP resource is:
.RS 12
\fIbeforeImage\fP\\n\\
.br
\fIresource\fP\\n\\
.br
\fIfacedb\fP\\n\\
.br
\fIafterImage\fP
.RE
The default value of the \fBcommandSearch\fP resource is:
.RS 12
\fIbeforeImage\fP\\n\\
.br
\fIresource\fP\\n\\
.br
\fIafterImage\fP
.RE
.RE
.TP 8
.BI XFaces.beforeImageBindings: " <spec>"
.TP 8
.BI XFaces.afterImageBindings: " <spec>"
.TP 8
.BI XFaces.beforeSoundBindings: " <spec>"
.TP 8
.BI XFaces.afterSoundBindings: " <spec>"
.TP 8
.BI XFaces.beforeCommandBindings: " <spec>"
.TP 8
.BI XFaces.afterCommandBindings: " <spec>"
These resources specify regular expressions that can be matched
against the mail headers to locate an image or sound.  These are
multi-line resources.  Each line is constructed as:
.PP
.RS 12
\fI<field name> <regexp><:> <file> <label><:><anno>\fP
.RE
If the \fI<field name>\fP is specified as \fI*\fP then all headers are
tested.  If the \fI<field name>\fP begins with a \| (like
\fI\|Subject:\fP or \fI\|*\fP) then the search is case insensitive.
The \fI<label>\fP field is only used for image and if specified, it
will be used in the annotations at position \fI<anno>\fP if
\fI<anno>\fP is not supplied then it defaults to \fI1\fP.
.TP 8
.B XFaces.ignoreMessageBindings:
These resources specify regular expressions that can be matched
against the mail headers to locate an image or sound.  These are
multi-line resources.  Each line is constructed as:
.PP
.RS 12
\fI<field name> <regexp>\fP
.RE
If the field name is specified as \fI*\fP then all headers are tested.
Any match found will cause the message to be ignored, no sound, no
image, no nothing!
.TP 8
.BI XFaces.annotationCount: " <number of annotations>"
.TP 8
.BI XFaces.unknownAnnotationCount: " <number of annotations>"
This resource specifies the number of annotations that the user is
specifing. The unknown annotations are applied on faces that were
located via the \fBfacedb\fP search when substituting "unknown" for
the user name. For each annotation the following resources will be
retrieved where \fIN\fP runs from \fI1\fP to \fBannotationCount\fP (or
\fBunknownAnnotationCount\fP)
.RS 8
.TP 8
.BI XFaces.annotation N .x: " <x>"
.TP 8
.BI XFaces.unknownAnnotation N .x: " <x>"
If \fI<x>\fP is a positive number then it is the offset from the
left side of the image to the left side of the text. If \fI<x>\P is a
negative number then it is the offset from the right side of the image
to the right side of the text.
.TP 8
.BI XFaces.annotation N .y: " <y>"
.TP 8
.BI XFaces.unknownAnnotation N .y: " <y>"
If \fI<y>\fP is a positive number then it is the offset from the
top of the image to the top of the text. If \fI<y>\P is a negative
number then it is the offset from the bottom of the image to the
bottom of the text.
.TP 8
.BI XFaces.annotation N .maxWidth: " <width>"
.TP 8
.BI XFaces.unknownAnnotation N .maxWidth: " <width>"
This specifies the maximum width in pixels the text is allowed to be.
.TP 8
.BI XFaces.annotation N .font: " <font name>"
.TP 8
.BI XFaces.unknownAnnotation N .font: " <font name>"
This is the font to use to render the annotation.
.TP 8
.BI XFaces.annotation N .foreground: " <X color spec>"
.TP 8
.BI XFaces.unknownAnnotation N .foreground: " <X color spec>"
This is the foreground color for the annotation.
.TP 8
.BI XFaces.annotation N .background: " <X color spec>"
.TP 8
.BI XFaces.unknownAnnotation N .background: " <X color spec>"
This is the background color for the annotation.
.TP 8
.BI XFaces.annotation N .shapeText: " <flag>"
.TP 8
.BI XFaces.unknownAnnotation N .shapeText: " <flag>"
If true then the text itself is used as the shape mask, if false then
the shape mask is a filled rectangle with extents matching those of
the text. The default is \fIFalse\fP.
.TP 8
.BI XFaces.annotation N .opaqueText: " <flag>"
.TP 8
.BI XFaces.unknownAnnotation N .opaqueText: " <flag>"
If true then the text background is drawn too (the background is the
bounding filled rectangle, when false only the text is drawn. The
default is \fITrue\fP.
.RE
.TP 8
.BI XFaces.mail.annotation N : " <type>
.TP 8
.BI XFaces.mail.unknownAnnotation N : " <type>
This specifies what is to be placed into this annotation position for
mail items.  The values for type are:
.TP 12
.B none
An empty string.
.TP 12
.B user
The user part of the From address.
.TP 12
.B host
The host part of the From address.
.TP 12
.B user@host
The user and host parts of the From address.
.TP 12
.B count
The number of messages represented by this face.
.TP 12
.BI * <header>
Any value beginning with a '*' is expected to be a header name and the
contents of that header will be displayed. For instance "*subject:"
will display the subject line.
.TP 8
.BI XFaces.annotationAbove: " <flag>"
This really should be called something else! Anyway, when this
resource is true and the image found is smaller than the tile size the
extra space allocated will be placed on teh top instead of the bottom.
The default value is \fIFalse\fP.
.TP 8
.BI XFaces.background: " <color>"
This is the color of any extra image space allocated.
.TP 8
.BI XFaces.shapeExtra: " <flag>"
This, if true, will cause any extra image space allocated to be shaped
out.
.TP 8
.BI XFaces.xbm.foreground: " <color>"
This is the foreground color for loaded X bitmaps.
.TP 8
.BI XFaces.xbm.background: " <color>"
This is the background color for loaded X bitmaps.
.TP 8
.BI XFaces.xpm.noneColor: " <color>"
This is the color used to represent the transparent pixels when the
\fBoverrideNoneColor\fP is \fITrue\fP.
.TP 8
.BI XFaces.xpm.overrideNoneColor: " <flag>"
When this value is set to true the transparent pixels in a Xpm image
are replaced bu the color specified in the \fBnoneColor\fP resource.
The default value is \fIFalse\fP.
.TP 8
.BI XFaces.xpm.filterCount: " <count>"
This resource specifies the number of external filters to look for.
The filters are specified with the following resources:
.RS 8
.TP 8
.BI XFaces.xpmFilter N .name: " <name>"
This is the image type name used to refer to this filter.
It can be used in the \fBimageType\fP resource and anywhere else an
image type name is expected.
.TP 8
.BI XFaces.xpmFilter N .filter: " <command>"
This is the command that will produce an xpm file on stdout.  This could be
something like: "giftopnm %s | ppmtoxpm".  A single %s will be replaced by the
file name of the image to be loaded.
.TP 8
.BI XFaces.xpmFilter N .extension: " <entension>"
This is the file extension that the image file is expected to have.
.RE
.SH "USER COMMANDS"
These commands add a very powerful feature to \fIXFaces\fP. They allow
almost anything to be monitored visually and audibly.  When a value is
specified for the \fBlistCommand\fP resource \fIXFaces\fP will run the
command and read the commands standard output.  The following is
expected.
.IP
The first line consists of two tokens.  The first is expected to be a
user name and the second a host name.  They are intended to describe
the image that should be displayed by \fIXFaces\fP in an \fIiconic\fP
state. \fBNote:\fP \fIThis is currently not implemented though the line
is still expected.\fP
.IP
The second line is expected as
.RS
Cols=\fI<columns>\fP Rows=\fI<rows>\fP
.RE
where \fI<columns>\fP is the number of columns and \fI<rows>\fP that
faces should display.  These values are used to set the \fBsetWidth\fP
and \fBsetHeight\fP resources on the \fPTiled\fP layout widget.
.IP
Each line following is expected to contain two to six TAB separated
fields. The fields are: user, host, annotation1, annotation2,
annotation3, annotation4. See the \fBannotationCount\fP resource to
see how to specify how and where each of the annotations are
displayed.
.PP
Steve Kinzler maintains a distribution of scripts that can be used to
generate faces lists in cs.indiana.edu:pub/faces/scripts.tar.Z.
.SH "SEE ALSO"
mail(1), sendmail(8)
.SH AUTHOR
Christopher B. Liebman (liebman@zod.clark.net)
.SH ACKNOWLEDGEMENTS
Special thanks to Rich Burridge.  A lot of the concepts that now
exist in XFaces came from \fIfaces\fP first.
.PP
Thanks also go to James Ashton for the X-Faces header face compression
/ decompression code.

