/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.io.j2me.comm;

import com.sun.cldc.io.GeneralBase;
import com.sun.cldc.io.j2me.comm.Protocol;
import java.io.IOException;
import java.io.InputStream;

class PrivateInputStream
extends InputStream {
    byte[] buf = new byte[1];
    private Protocol parent;

    public PrivateInputStream(Protocol parent) throws IOException {
        this.parent = parent;
    }

    void ensureOpen() throws IOException {
        if (this.parent == null) {
            throw new IOException("Stream closed");
        }
    }

    public synchronized int read() throws IOException {
        if (this.read(this.buf, 0, 1) > 0) {
            return this.buf[0] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        while (true) {
            int count;
            if ((count = this.read1(this.parent.hPort, b, off, len)) != 0 || this.parent.blocking == 0) {
                if (count > len) {
                    throw new IOException("Read overrun in comm:");
                }
                return count;
            }
            GeneralBase.iowait();
        }
    }

    protected int read1(int port, byte[] b, int off, int len) throws IOException {
        return Protocol.native_readBytes(port, b, off, len);
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return Protocol.native_available(this.parent.hPort);
    }

    public synchronized void close() throws IOException {
        if (this.parent != null) {
            this.parent.realClose();
            this.parent = null;
        }
    }
}

