/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kssl;

import com.sun.ksecurity.CryptoException;
import com.sun.ksecurity.Key;
import com.sun.ksecurity.RSAPublicKey;
import com.sun.ksecurity.RandomData;
import com.sun.kssl.Cipher;

final class Alg2
extends Cipher {
    private Key ckey = null;
    private byte mode = 0;
    private static RandomData rnd = null;

    Alg2() {
    }

    private static native void modExp(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4) throws IllegalArgumentException;

    private byte[] doIt(byte[] data) throws CryptoException {
        int modLen = this.ckey.getSize() >>> 3;
        byte[] buf = new byte[modLen];
        byte[] rLen = new byte[1];
        byte[] mod = new byte[modLen];
        short val = ((RSAPublicKey)this.ckey).getModulus(mod, (short)0);
        if (val == 0) {
            throw new CryptoException(5);
        }
        byte[] tmp = new byte[modLen];
        val = ((RSAPublicKey)this.ckey).getExponent(tmp, (short)0);
        if (val == 0) {
            throw new CryptoException(5);
        }
        byte[] exp = new byte[val];
        System.arraycopy(tmp, 0, exp, 0, val);
        Alg2.modExp(data, exp, mod, buf, rLen);
        int bufLen = rLen[0] & 0xFF;
        if (bufLen == modLen) {
            return buf;
        }
        if (bufLen < modLen) {
            int i = 0;
            while (i < modLen) {
                tmp[i] = 0;
                ++i;
            }
            if (buf[0] == 1) {
                tmp[0] = 0;
                tmp[1] = 1;
                int i2 = 2;
                while (i2 < modLen - bufLen + 1) {
                    tmp[i2] = -1;
                    ++i2;
                }
                System.arraycopy(buf, 1, tmp, modLen - bufLen + 1, bufLen - 1);
            } else {
                System.arraycopy(buf, 0, tmp, modLen - bufLen, bufLen);
            }
            return tmp;
        }
        return null;
    }

    public void Alg2() {
        this.mode = 0;
    }

    public byte getAlgorithm() {
        return 2;
    }

    public void init(Key theKey, byte theMode, byte[] b, int off, int len) throws CryptoException {
        throw new CryptoException(1);
    }

    public void init(Key theKey, byte theMode) throws CryptoException {
        if (theKey.getType() != 2 && theKey.getType() != 1 || theMode != 1 && theMode != 2) {
            throw new CryptoException(2);
        }
        if (rnd == null) {
            rnd = RandomData.getInstance((byte)2);
        }
        this.mode = theMode;
        this.ckey = theKey;
    }

    public int update(byte[] inBuf, int inOff, int inLen, byte[] outBuf, int outOff) throws CryptoException {
        if (this.ckey == null) {
            throw new CryptoException(5);
        }
        if (this.mode == 0) {
            throw new CryptoException(3);
        }
        int modLen = this.ckey.getSize() >>> 3;
        if (inLen < 0 || inOff + inLen > inBuf.length || outOff + modLen > outBuf.length) {
            throw new CryptoException(1);
        }
        int val = 0;
        byte[] tmp = null;
        byte[] res = null;
        int padLen = 0;
        byte keyType = this.ckey.getType();
        switch (this.mode) {
            case 1: {
                if (inLen > modLen - 11) {
                    throw new CryptoException(1);
                }
                tmp = new byte[modLen];
                tmp[0] = 0;
                tmp[1] = keyType == 1 ? 2 : 1;
                padLen = modLen - inLen - 3;
                byte[] pad = new byte[padLen];
                rnd.generateData(pad, (short)0, (short)padLen);
                int i = 0;
                while (i < padLen) {
                    tmp[2 + i] = pad[i] == 0 ? -1 : pad[i];
                    ++i;
                }
                tmp[modLen - inLen - 1] = 0;
                System.arraycopy(inBuf, inOff, tmp, modLen - inLen, inLen);
                res = this.doIt(tmp);
                if (res == null) break;
                System.arraycopy(res, 0, outBuf, outOff, res.length);
                val = res.length;
                break;
            }
            case 2: {
                if (inLen != modLen) {
                    throw new CryptoException(1);
                }
                if (inOff != 0) {
                    tmp = new byte[modLen];
                    System.arraycopy(inBuf, inOff, tmp, 0, modLen);
                    res = this.doIt(tmp);
                } else {
                    res = this.doIt(inBuf);
                }
                if (res == null) {
                    return 0;
                }
                padLen = 0;
                int i = 2;
                while (res[i] != 0 && i < res.length) {
                    ++padLen;
                    ++i;
                }
                if (padLen >= modLen - 3 || res[0] != 0 || (keyType != 1 || res[1] != 1 && res[1] != 0) && (keyType != 2 || res[1] != 2)) break;
                val = modLen - padLen - 3;
                System.arraycopy(res, padLen + 3, outBuf, outOff, val);
            }
        }
        return val;
    }

    public int doFinal(byte[] inBuf, int inOff, int inLen, byte[] outBuf, int outOff) throws CryptoException {
        int val = this.update(inBuf, inOff, inLen, outBuf, outOff);
        this.init(this.ckey, this.mode);
        return val;
    }
}

