/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kssl;

import com.sun.ksecurity.KeyBuilder;
import com.sun.ksecurity.MessageDigest;
import com.sun.ksecurity.SecretKey;
import com.sun.kssl.Cipher;
import com.sun.kssl.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Record {
    static final byte CCS = 20;
    static final byte ALRT = 21;
    static final byte HNDSHK = 22;
    static final byte APP = 23;
    static final byte WARNING = 1;
    static final byte FATAL = 2;
    static final byte CLOSE_NTFY = 0;
    static final byte UNEXP_MSG = 10;
    static final byte BAD_MAC = 20;
    static final byte HNDSHK_FAIL = 40;
    static final byte NO_CERT = 41;
    static final byte BAD_CERT = 42;
    static final byte UNSUP_CERT = 43;
    static final byte CERT_REVKD = 44;
    static final byte CERT_EXPRD = 45;
    static final byte CERT_UNKWN = 46;
    static final byte BAD_PARAM = 47;
    static final byte SERVER = 0;
    static final byte CLIENT = 1;
    static final byte[] PAD1 = new byte[]{54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54};
    static final byte[] PAD2 = new byte[]{92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92};
    private InputStream in;
    private OutputStream out;
    private byte[] cMACKey;
    private byte[] sMACKey;
    private byte[] cKey;
    private byte[] sKey;
    private byte[] cIV;
    private byte[] sIV;
    private long cSeq = 0L;
    private long sSeq = 0L;
    private byte role;
    private byte rActive = 0;
    private byte wActive = 0;
    private MessageDigest d = null;
    private byte dLen = 0;
    private int padLen = 0;
    private Cipher cc = null;
    private Cipher sc = null;
    private SecretKey cBulkKey = null;
    private SecretKey sBulkKey = null;
    private byte ver;
    private byte isBlk = 0;
    private int cblk = 1;

    Record(byte who, InputStream ins, OutputStream outs) {
        this.in = ins;
        this.out = outs;
        this.ver = (byte)48;
        this.role = who;
    }

    void destroy() {
        this.in = null;
        this.out = null;
        this.sMACKey = null;
        this.cMACKey = null;
        this.sIV = null;
        this.cIV = null;
        this.d = null;
        this.sc = null;
        this.cc = null;
        this.sBulkKey = null;
        this.cBulkKey = null;
    }

    private void bump(byte who) throws IOException {
        if (who == 1) {
            if (++this.cSeq == 0L) {
                throw new IOException("Clnt seq rolled over");
            }
        } else if (++this.sSeq == 0L) {
            throw new IOException("Srvr seq rolled over");
        }
    }

    void init(byte[] crand, byte[] srand, byte suite, byte[] master) throws Exception {
        byte[] res;
        byte[][] expansion = new byte[][]{{65}, {66, 66}, {67, 67, 67}, {68, 68, 68, 68}, {69, 69, 69, 69, 69}, {70, 70, 70, 70, 70, 70}, {71, 71, 71, 71, 71, 71, 71}};
        this.d = MessageDigest.getInstance((byte)1, false);
        this.dLen = (byte)16;
        this.padLen = 48;
        byte[] tmp = new byte[master.length + srand.length + crand.length];
        System.arraycopy(master, 0, tmp, 0, master.length);
        System.arraycopy(srand, 0, tmp, master.length, srand.length);
        System.arraycopy(crand, 0, tmp, master.length + srand.length, crand.length);
        int keyMat = suite == 4 ? 16 : 5;
        int ivSize = 0;
        int i = this.dLen + keyMat + ivSize << 1;
        byte[] kBlk = new byte[i + 15 >>> 4 << 4];
        MessageDigest md = MessageDigest.getInstance((byte)1, false);
        MessageDigest sd = MessageDigest.getInstance((byte)2, false);
        i = 0;
        while (i < kBlk.length >>> 4) {
            md.update(master, 0, master.length);
            sd.update(expansion[i], 0, expansion[i].length);
            res = new byte[20];
            sd.doFinal(tmp, 0, tmp.length, res, 0);
            md.doFinal(res, 0, 20, kBlk, i << 4);
            ++i;
        }
        this.cMACKey = new byte[this.dLen];
        this.sMACKey = new byte[this.dLen];
        System.arraycopy(kBlk, 0, this.cMACKey, 0, this.cMACKey.length);
        System.arraycopy(kBlk, this.cMACKey.length, this.sMACKey, 0, this.sMACKey.length);
        this.cKey = new byte[keyMat];
        this.sKey = new byte[keyMat];
        System.arraycopy(kBlk, 2 * this.cMACKey.length, this.cKey, 0, this.cKey.length);
        System.arraycopy(kBlk, 2 * this.cMACKey.length + this.cKey.length, this.sKey, 0, this.sKey.length);
        this.cIV = new byte[ivSize];
        this.sIV = new byte[ivSize];
        if (suite != 4) {
            res = new byte[16];
            md.update(this.cKey, 0, this.cKey.length);
            md.update(crand, 0, crand.length);
            md.doFinal(srand, 0, srand.length, res, 0);
            byte[] fcKey = new byte[16];
            System.arraycopy(res, 0, fcKey, 0, fcKey.length);
            md.update(this.sKey, 0, this.sKey.length);
            md.update(srand, 0, srand.length);
            md.doFinal(crand, 0, crand.length, res, 0);
            byte[] fsKey = new byte[fcKey.length];
            System.arraycopy(res, 0, fsKey, 0, fsKey.length);
            this.cKey = fcKey;
            this.sKey = fsKey;
        }
        this.cBulkKey = (SecretKey)KeyBuilder.buildKey((byte)3, (short)(this.cKey.length << 3), false);
        this.cBulkKey.setKey(this.cKey, (short)0);
        this.cc = Cipher.getInstance((byte)3, false);
        this.cc.init(this.cBulkKey, (byte)1);
        this.sBulkKey = (SecretKey)KeyBuilder.buildKey((byte)3, (short)(this.sKey.length << 3), false);
        this.sBulkKey.setKey(this.sKey, (short)0);
        this.sc = Cipher.getInstance((byte)3, false);
        this.sc.init(this.sBulkKey, (byte)2);
        this.cblk = 1;
        this.isBlk = 0;
    }

    private byte[] getMAC(byte who, byte type, byte[] buf, int off, int len) {
        byte[] mKey;
        byte[] res = null;
        if (who == 1) {
            this.d.update(this.cMACKey, 0, this.cMACKey.length);
            this.d.update(PAD1, 0, this.padLen);
            res = Utils.longToBytes(this.cSeq);
            this.d.update(res, 0, res.length);
            mKey = this.cMACKey;
        } else {
            this.d.update(this.sMACKey, 0, this.sMACKey.length);
            this.d.update(PAD1, 0, this.padLen);
            res = Utils.longToBytes(this.sSeq);
            this.d.update(res, 0, res.length);
            mKey = this.sMACKey;
        }
        res = new byte[]{type, (byte)(len >>> 8), (byte)(len & 0xFF)};
        this.d.update(res, 0, res.length);
        byte[] mac = new byte[this.d.getLength()];
        this.d.doFinal(buf, off, len, mac, 0);
        this.d.update(mKey, 0, mKey.length);
        this.d.update(PAD2, 0, this.padLen);
        byte[] val = new byte[mac.length];
        this.d.doFinal(mac, 0, mac.length, val, 0);
        return val;
    }

    private byte[] encode(byte[] ptxt) throws IOException {
        byte[] fragNMAC = null;
        if (this.d != null) {
            fragNMAC = new byte[ptxt.length - 5 + this.dLen];
            System.arraycopy(ptxt, 5, fragNMAC, 0, ptxt.length - 5);
            System.arraycopy(this.getMAC(this.role, ptxt[0], ptxt, 5, ptxt.length - 5), 0, fragNMAC, ptxt.length - 5, this.dLen);
        } else {
            fragNMAC = new byte[ptxt.length - 5];
            System.arraycopy(ptxt, 5, fragNMAC, 0, ptxt.length - 5);
        }
        byte[] efragNMAC = null;
        if (this.cc != null) {
            try {
                efragNMAC = fragNMAC;
                this.cc.update(fragNMAC, 0, fragNMAC.length, efragNMAC, 0);
            }
            catch (Exception e) {
                throw new IOException("Encode caught " + e);
            }
        } else {
            efragNMAC = fragNMAC;
        }
        byte[] rec = new byte[efragNMAC.length + 5];
        System.arraycopy(ptxt, 0, rec, 0, 3);
        rec[3] = (byte)(efragNMAC.length >>> 8);
        rec[4] = (byte)(efragNMAC.length & 0xFF);
        System.arraycopy(efragNMAC, 0, rec, 5, efragNMAC.length);
        this.bump(this.role);
        return rec;
    }

    private byte[] decode(byte[] ctxt) throws IOException {
        byte[] fragNMAC = null;
        int pLen = 0;
        if (this.sc != null) {
            try {
                fragNMAC = new byte[ctxt.length - 5];
                this.sc.update(ctxt, 5, (short)(ctxt.length - 5), fragNMAC, 0);
            }
            catch (Exception e) {
                throw new IOException("Decode caught " + e);
            }
        } else {
            fragNMAC = new byte[ctxt.length - 5];
            System.arraycopy(ctxt, 5, fragNMAC, 0, fragNMAC.length);
        }
        if (this.d != null) {
            byte[] expMAC = null;
            expMAC = this.getMAC((byte)(1 - this.role), ctxt[0], fragNMAC, 0, fragNMAC.length - this.dLen - pLen);
            if (!Utils.byteMatch(expMAC, 0, fragNMAC, fragNMAC.length - pLen - this.dLen, this.dLen)) {
                this.alert((byte)2, (byte)20);
                throw new IOException("Bad MAC");
            }
        }
        int fragLen = fragNMAC.length - this.dLen - pLen;
        byte[] res = new byte[fragLen + 5];
        System.arraycopy(ctxt, 0, res, 0, 3);
        res[3] = (byte)(fragLen >>> 8);
        res[4] = (byte)(fragLen & 0xFF);
        System.arraycopy(fragNMAC, 0, res, 5, fragLen);
        this.bump((byte)(1 - this.role));
        return res;
    }

    byte[] rdRec(byte type) throws IOException {
        byte[] r = this.rdRec();
        if (r == null || r[0] == type) {
            return r;
        }
        switch (r[0]) {
            default: {
                this.alert((byte)2, (byte)10);
                throw new IOException("Unexpected SSL record");
            }
            case 21: 
        }
        if (r.length > 6 && r[5] == 1 && r[6] == 0 && type == 23) {
            return null;
        }
        if (r.length < 7 || r[5] < 1 || r[5] > 2) {
            throw new IOException("Bad alert");
        }
        throw new IOException("Alert (" + r[5] + "," + r[6] + ")");
    }

    private byte[] rdRec() throws IOException {
        byte[] tmp = new byte[5];
        int b = this.in.read(tmp, 0, 5);
        if (b == -1) {
            return null;
        }
        if (b != 5) {
            throw new IOException("SSL connection ended abnormally while reading record header byte " + (b + 1));
        }
        if (tmp[0] < 20 || tmp[0] > 23 || tmp[1] != (byte)(this.ver >>> 4) || tmp[2] != (byte)(this.ver & 0xF)) {
            this.alert((byte)2, (byte)10);
            throw new IOException("Bad record type (" + tmp[0] + ") or version (" + tmp[1] + "." + tmp[2] + ")");
        }
        int rlen = ((tmp[3] & 0xFF) << 8) + (tmp[4] & 0xFF);
        byte[] rec = new byte[rlen + 5];
        int cnt = 0;
        b = 0;
        while (cnt != rlen && b != -1) {
            b = this.in.read(rec, 5 + cnt, rlen - cnt);
            if (b == -1) continue;
            cnt += b;
        }
        if (cnt != rlen) {
            throw new IOException("SSL connection ended abnormally while reading a record byte " + (b + 6));
        }
        System.arraycopy(tmp, 0, rec, 0, 5);
        byte[] res = null;
        res = this.rActive == 1 ? this.decode(rec) : rec;
        if (res[0] == 20) {
            this.rActive = 1;
        }
        return res;
    }

    void wrRec(byte type, byte[] buf, int off, int len) throws IOException {
        byte[] rec = new byte[len + 5];
        rec[0] = type;
        rec[1] = (byte)(this.ver >>> 4);
        rec[2] = (byte)(this.ver & 0xF);
        rec[3] = (byte)(len >>> 8);
        rec[4] = (byte)(len & 0xFF);
        System.arraycopy(buf, off, rec, 5, len);
        if (this.wActive == 1) {
            this.out.write(this.encode(rec));
        } else {
            this.out.write(rec);
        }
        if (type == 20) {
            this.wActive = 1;
        }
    }

    public void alert(byte level, byte type) throws IOException {
        byte[] tmp = new byte[]{level, type};
        this.wrRec((byte)21, tmp, 0, 2);
    }
}

