/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp;

import com.sun.midp.CommandState;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.midletsuite.InvalidJadException;
import java.io.IOException;

public class CommandProcessor {
    static final int MAIN_EXIT = 2001;
    static final int OK = 0;
    static final int ERROR = -1;
    static final int MIDLET_SUITE_NOT_FOUND = -2;
    static final int EXIT = 1;
    static final int MANAGE = 2;
    static final int INSTALL = 3;
    static final int INSTALL_RUN = 4;
    static final int RUN = 5;
    static final int REMOVE = 6;
    static final int LIST = 7;
    static final int RUN_CLASS = 8;
    static final int STORAGE_NAMES = 9;
    private static boolean performing = false;
    private static Installer installer = null;

    public static void perform(CommandState state) throws IOException, InvalidJadException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (performing) {
            return;
        }
        performing = true;
        if (installer == null) {
            installer = Installer.getInstaller();
        }
        CommandProcessor.dispatch(state);
        String nextMidletSuiteToRun = installer.getNextMIDletSuiteToRun();
        if (nextMidletSuiteToRun != null) {
            state.nextCommand = 5;
            state.suiteStorageName = nextMidletSuiteToRun;
            state.midletName = installer.getNextMIDletToRun();
        }
        performing = false;
    }

    private static void dispatch(CommandState state) throws IOException, InvalidJadException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int currentCommand = state.nextCommand;
        state.nextCommand = 1;
        try {
            if (currentCommand == 3 || currentCommand == 4) {
                CommandProcessor.install(state);
            } else if (currentCommand == 5) {
                CommandProcessor.run(state);
            } else if (currentCommand == 6) {
                CommandProcessor.remove(state);
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (state.initialCommand == 2) {
                state.nextCommand = 2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void install(CommandState state) throws IOException, InvalidJadException {
        block9: {
            state.status = -1;
            state.suiteStorageName = installer.install(state.suiteURL, state.forceOverwrite);
            state.status = 0;
            if (state.initialCommand == 4) {
                state.nextCommand = 5;
            }
            if (state.status != -1 || !state.autotest) break block9;
            state.nextCommand = 3;
        }
        try {
            try {
                return;
            }
            catch (InvalidJadException ije) {
                if (ije.getReason() != 1 && ije.getReason() != 2) throw ije;
                state.status = -2;
                return;
            }
        }
        finally {
            if (state.status == -1 && state.autotest) {
                state.nextCommand = 3;
            }
        }
    }

    private static void run(CommandState state) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        MIDletSuite midletSuite;
        try {
            midletSuite = installer.getMIDletSuite(state.suiteStorageName, state.midletName);
        }
        catch (Exception e) {
            state.status = -2;
            return;
        }
        if (midletSuite == null) {
            state.status = -2;
            return;
        }
        if ("Y".equals(midletSuite.getProperty("APP-Run-Once"))) {
            state.runOnce = true;
        }
        if (state.runOnce) {
            state.nextCommand = 6;
        }
        state.status = -1;
        midletSuite.schedule();
        state.status = 0;
    }

    private static void remove(CommandState state) {
        state.status = -1;
        if (state.suiteStorageName == null) {
            throw new IllegalArgumentException("No suite specified");
        }
        if (state.suiteStorageName.equals("all")) {
            String[] suite = installer.list();
            int i = 0;
            while (i < suite.length) {
                installer.remove(suite[i]);
                ++i;
            }
        } else {
            installer.remove(state.suiteStorageName);
        }
        state.status = 0;
        if (state.autotest) {
            state.nextCommand = state.initialCommand;
        }
    }

    private CommandProcessor() {
    }
}

