/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private int value;

    public static String toString(int i, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        char[] buf = new char[33];
        boolean negative = i < 0;
        int charPos = 32;
        if (!negative) {
            i = -i;
        }
        while (i <= -radix) {
            buf[charPos--] = digits[-(i % radix)];
            i /= radix;
        }
        buf[charPos] = digits[-i];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 33 - charPos);
    }

    public static String toHexString(int i) {
        return Integer.toUnsignedString(i, 4);
    }

    public static String toOctalString(int i) {
        return Integer.toUnsignedString(i, 3);
    }

    public static String toBinaryString(int i) {
        return Integer.toUnsignedString(i, 1);
    }

    private static String toUnsignedString(int i, int shift) {
        char[] buf = new char[32];
        int charPos = 32;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = digits[i & mask];
        } while ((i >>>= shift) != 0);
        return new String(buf, charPos, 32 - charPos);
    }

    public static String toString(int i) {
        return Integer.toString(i, 10);
    }

    public static int parseInt(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            int limit;
            if (s.charAt(0) == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(s);
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(s);
                }
                if (result < multmin) {
                    throw new NumberFormatException(s);
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException(s);
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException(s);
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }

    public static int parseInt(String s) throws NumberFormatException {
        return Integer.parseInt(s, 10);
    }

    public static Integer valueOf(String s, int radix) throws NumberFormatException {
        return new Integer(Integer.parseInt(s, radix));
    }

    public static Integer valueOf(String s) throws NumberFormatException {
        return new Integer(Integer.parseInt(s, 10));
    }

    public Integer(int value) {
        this.value = value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Integer) {
            return this.value == (Integer)obj;
        }
        return false;
    }
}

