/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;

public abstract class Displayable {
    private int hScrollPosition = 0;
    private int hScrollProportion = 100;
    private int vScrollPosition = 0;
    private int vScrollProportion = 100;
    Display currentDisplay;
    Command[] commands;
    int numCommands;
    CommandListener listener;

    Displayable() {
    }

    public boolean isShown() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.currentDisplay == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.currentDisplay.isShown(this);
            return bl;
        }
    }

    public void addCommand(Command cmd) {
        if (cmd == null) {
            throw new NullPointerException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.addCommandImpl(cmd);
        }
    }

    public void removeCommand(Command cmd) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.removeCommandImpl(cmd);
        }
    }

    public void setCommandListener(CommandListener l) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.listener = l;
        }
    }

    void keyPressed(int keyCode) {
    }

    void keyRepeated(int keyCode) {
    }

    void keyReleased(int keyCode) {
    }

    void keyTyped(char c) {
    }

    void pointerPressed(int x, int y) {
    }

    void pointerDragged(int x, int y) {
    }

    void pointerReleased(int x, int y) {
    }

    void repaint(int x, int y, int width, int height) {
        if (this.currentDisplay != null) {
            this.currentDisplay.repaintImpl(this, x, y, width, height, 30);
        }
    }

    void repaint() {
        this.repaint(0, 0, Display.WIDTH, Display.HEIGHT);
    }

    abstract void paint(Graphics var1);

    void setHorizontalScroll(int scrollPosition, int scrollProportion) {
        this.hScrollPosition = scrollPosition;
        this.hScrollProportion = scrollProportion;
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.currentDisplay != null && this.currentDisplay.isShown(this)) {
                this.currentDisplay.setHorizontalScroll(scrollPosition, scrollProportion);
            }
        }
    }

    int getHorizontalScrollPosition() {
        return this.hScrollPosition;
    }

    int getHorizontalScrollProportion() {
        return this.hScrollProportion;
    }

    void setVerticalScroll(int scrollPosition, int scrollProportion) {
        this.vScrollPosition = scrollPosition;
        this.vScrollProportion = scrollProportion;
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.currentDisplay != null && this.currentDisplay.isShown(this)) {
                this.currentDisplay.setVerticalScroll(scrollPosition, scrollProportion);
            }
        }
    }

    int getVerticalScrollPosition() {
        return this.vScrollPosition;
    }

    int getVerticalScrollProportion() {
        return this.vScrollProportion;
    }

    void showNotify(Display d) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.showNotifyImpl(d);
        }
        Object object2 = Display.calloutLock;
        synchronized (object2) {
            try {
                this.showNotify();
            }
            catch (Throwable thr) {
                Display.handleThrowable(thr);
            }
        }
    }

    void hideNotify(Display d) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.hideNotifyImpl(d);
        }
        Object object2 = Display.calloutLock;
        synchronized (object2) {
            try {
                this.hideNotify();
            }
            catch (Throwable thr) {
                Display.handleThrowable(thr);
            }
        }
    }

    void showNotify() {
    }

    void hideNotify() {
    }

    void showNotifyImpl(Display d) {
        this.currentDisplay = d;
    }

    void hideNotifyImpl(Display d) {
        this.currentDisplay = null;
    }

    Command[] getCommands() {
        return this.commands;
    }

    int getCommandCount() {
        return this.numCommands;
    }

    CommandListener getCommandListener() {
        return this.listener;
    }

    void addCommandImpl(Command cmd) {
        int i = 0;
        while (i < this.numCommands) {
            if (this.commands[i] == cmd) {
                return;
            }
            ++i;
        }
        if (this.commands == null || this.numCommands == this.commands.length) {
            Command[] newCommands = new Command[this.numCommands + 4];
            if (this.commands != null) {
                System.arraycopy(this.commands, 0, newCommands, 0, this.numCommands);
            }
            this.commands = newCommands;
        }
        this.commands[this.numCommands] = cmd;
        ++this.numCommands;
        if (this.currentDisplay != null && this.currentDisplay.isShown(this)) {
            this.currentDisplay.updateCommandSet();
        }
    }

    void removeCommandImpl(Command cmd) {
        int i = 0;
        while (i < this.numCommands) {
            if (this.commands[i] == cmd) {
                this.commands[i] = this.commands[--this.numCommands];
                this.commands[this.numCommands] = null;
                if (this.currentDisplay == null || !this.currentDisplay.isShown(this)) break;
                this.currentDisplay.updateCommandSet();
                break;
            }
            ++i;
        }
    }
}

