/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.NumericPolicy;
import javax.microedition.lcdui.PassNumericPolicy;
import javax.microedition.lcdui.PassTextPolicy;
import javax.microedition.lcdui.PhonePolicy;
import javax.microedition.lcdui.TextPolicy;

abstract class Policy {
    Font f;
    int lineHeight;
    int width = -1;
    int height;
    int cursorY;
    int cursorX;

    Policy(Font f) {
        this.f = f;
        this.lineHeight = f.getHeight();
    }

    boolean validateContent(char[] buffer, int offset, int length) {
        return true;
    }

    int constrainedSize(int size, char[] buffer) {
        return size;
    }

    int contentChanged(char[] buf, int numChars, int fromPos, int curPos) {
        return 0;
    }

    int setWidth(int width, char[] buf, int numChars, int curPos) {
        this.width = width;
        this.contentChanged(buf, numChars, 0, curPos);
        return this.height;
    }

    abstract void paint(Graphics var1, char[] var2, int var3, boolean var4, int var5, boolean var6);

    int moveCursor(int dir, int cursorPos, char[] buf, int numChars) {
        return cursorPos;
    }

    static Policy getPolicy(int constraint) {
        Policy newPolicy;
        boolean passEnabled = false;
        Font defaultFont = Font.getDefaultFont();
        if ((constraint & 0x10000) != 0) {
            passEnabled = true;
        }
        switch (constraint & 0xFFFF) {
            case 0: 
            case 1: 
            case 4: {
                if (passEnabled) {
                    newPolicy = new PassTextPolicy(defaultFont);
                    break;
                }
                newPolicy = new TextPolicy(defaultFont);
                break;
            }
            case 2: {
                if (passEnabled) {
                    newPolicy = new PassNumericPolicy(defaultFont);
                    break;
                }
                newPolicy = new NumericPolicy(defaultFont);
                break;
            }
            case 3: {
                if (passEnabled) {
                    newPolicy = new PassNumericPolicy(defaultFont){

                        boolean validateContent(char[] buffer, int offset, int length) {
                            int i = offset;
                            while (i < offset + length) {
                                char c = buffer[i];
                                if ((c < '0' || c > '9') && c != '#' && c != '*' && c != '+') {
                                    return false;
                                }
                                ++i;
                            }
                            return true;
                        }
                    };
                    break;
                }
                newPolicy = new PhonePolicy(defaultFont);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return newPolicy;
    }

    int getMaxWidth(int allowedWidth, int maxSize) {
        int w = this.f.charWidth('W') * maxSize;
        if (w < allowedWidth) {
            return w;
        }
        return allowedWidth;
    }

    int getMinimumHeight(int height) {
        return 2 * this.lineHeight;
    }
}

