/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.InputMethodClient;
import com.sun.midp.lcdui.InputMethodHandler;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.PhoneDial;
import javax.microedition.lcdui.PhonePolicy;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.TextBasic;

public class TextBox
extends Screen {
    private boolean cursorEnabled = true;
    private char[] keyBoardChar = new char[1];
    TextBasic sD;
    InputMethodImpl imi = new InputMethodImpl();
    static InputMethodHandler imHandler = InputMethodHandler.getInputMethodHandler();

    public TextBox(String title, String text, int maxSize, int constraints) {
        super(title);
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.initializeTextBasic(constraints, maxSize, text);
            this.hasBorder = true;
        }
    }

    public String getString() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            String string = new String(this.sD.buffer, 0, this.sD.numChars);
            return string;
        }
    }

    public void setString(String text) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.contentChanged(null, 0, 0, this.sD.setString(text));
        }
    }

    public int getChars(char[] data) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.sD.getChars(data);
            return n;
        }
    }

    public void setChars(char[] data, int offset, int length) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.contentChanged(null, 0, 0, this.sD.setChars(data, offset, length));
        }
    }

    public void insert(String src, int position) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.contentChanged(null, 0, 0, this.sD.insert(src, position));
        }
    }

    public void insert(char[] data, int offset, int length, int position) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.contentChanged(null, 0, 0, this.sD.insert(data, offset, length, position));
        }
    }

    public void delete(int offset, int length) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.contentChanged(null, 0, 0, this.sD.deleteChars(offset, length));
        }
    }

    public int getMaxSize() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.sD.buffer.length;
            return n;
        }
    }

    public int setMaxSize(int maxSize) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.contentChanged(null, 0, 0, this.sD.setMaxSize(maxSize));
            int n = this.sD.buffer.length;
            return n;
        }
    }

    public int size() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.sD.numChars;
            return n;
        }
    }

    public int getCaretPosition() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.sD.curPos;
            return n;
        }
    }

    public void setConstraints(int constraints) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int deltaHeight = this.sD.setConstraints(constraints);
            this.contentChanged(null, 0, 0, deltaHeight += this.sD.setMaxSize(this.sD.buffer.length));
        }
    }

    public int getConstraints() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.sD.constraints;
            return n;
        }
    }

    void initializeTextBasic(int constraints, int maxSize, String text) {
        this.sD = new TextBasic(constraints, maxSize, text);
    }

    void paintContent(Graphics g) {
        g.setColor(Display.ERASE_COLOR);
        g.fillRect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        this.sD.policy.paint(g, this.sD.buffer, this.sD.numChars, this.cursorEnabled, this.sD.curPos, false);
    }

    int heightChanged(int vpY, int vpH, int deltaHeight) {
        vpY = super.heightChanged(vpY, vpH, deltaHeight);
        return this.initHilight(vpY, vpH);
    }

    int layoutContent(int w, int h) {
        return this.sD.setWidth(w);
    }

    int initHilight(int vpY, int vpH) {
        int cursorY1 = this.sD.policy.cursorY;
        int cursorY2 = cursorY1 + this.sD.policy.lineHeight;
        if (vpY > cursorY1 || vpY + vpH < cursorY2) {
            int t2;
            int t1;
            vpY += (t1 = cursorY2 - vpY - vpH) >= (t2 = vpY - cursorY1) ? t1 : t2;
        }
        return vpY;
    }

    void keyReleased(int keyCode) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (imHandler.keyReleased(keyCode)) {
                return;
            }
        }
    }

    void keyPressed(int keyCode) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.keyPressedImpl(keyCode);
        }
    }

    int traverse(int dir, int top, int bottom) {
        return this.sD.traverse(dir, top, bottom);
    }

    int getMinimumContentHeight(int width, int height) {
        return this.sD.policy.getMinimumHeight(height) + 8;
    }

    void showNotifyImpl(Display d) {
        super.showNotifyImpl(d);
        imHandler.setInputMethodClient(this.imi);
    }

    void hideNotifyImpl(Display d) {
        super.hideNotifyImpl(d);
        imHandler.endComposition();
        imHandler.clearInputMethodClient(this.imi);
    }

    void keyTyped(char c) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.keyTypedImpl(c);
        }
    }

    Object getClientObject() {
        return this;
    }

    void keyTypedImpl(char c) {
        int curPos = this.getCaretPosition();
        if (c == '\b' || c == '\u007f') {
            if (curPos > 0) {
                this.imi.replace(null, 0, 1, curPos - 1, curPos);
                this.repaintContent();
            }
        } else if (this.sD.numChars < this.sD.buffer.length) {
            this.keyBoardChar[0] = c;
            try {
                this.imi.insert(this.keyBoardChar, 0, 1, curPos);
                this.repaintContent();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    void keyPressedImpl(int keyCode) {
        if (Display.getSystemKey(keyCode) == 2) {
            if (this.sD.policy instanceof PhonePolicy) {
                PhoneDial.call(this.getString());
            }
            return;
        }
        if (imHandler.keyPressed(keyCode)) {
            return;
        }
        super.keyPressedImpl(keyCode);
    }

    class InputMethodImpl
    implements InputMethodClient {
        InputMethodImpl() {
        }

        public Display getDisplay() {
            return TextBox.this.currentDisplay;
        }

        public int getSize() {
            return TextBox.this.size();
        }

        public int getMaxSize() {
            return TextBox.this.getMaxSize();
        }

        public int getConstraints() {
            return TextBox.this.getConstraints();
        }

        public int getChars(char[] data) {
            return TextBox.this.getChars(data);
        }

        public void setChars(char[] data, int offset, int length) {
            TextBox.this.setChars(data, offset, length);
        }

        public int getCaretPosition() {
            return TextBox.this.getCaretPosition();
        }

        public void setCaretPosition(int pos) {
            TextBox.this.sD.curPos = pos;
        }

        public void setCaretVisible(boolean t) {
            if (TextBox.this.cursorEnabled != t) {
                TextBox.this.cursorEnabled = t;
                TextBox.this.repaintContent();
            }
        }

        public void insert(char[] data, int offset, int length, int pos) {
            TextBox.this.insert(data, offset, length, pos);
        }

        public void replace(char[] data, int offset, int length, int start, int end) {
            TextBox.this.delete(start, end - start);
            if (data != null) {
                TextBox.this.insert(data, offset, length, start);
            }
        }

        public void repaint() {
            TextBox.this.repaintContent();
            if (TextBox.this.isShown()) {
                TextBox.this.currentDisplay.updateCommandSet();
            }
        }

        public void repaintContent() {
            TextBox.this.repaintContent();
        }

        public Font getFont() {
            return Screen.CONTENT_FONT;
        }

        public String getTitle() {
            return TextBox.this.getTitle();
        }

        public void getLocation(int[] rect) {
            TextBox.this.getContentRect(rect);
        }

        public void setInputMode(int mode) {
            TextBox.this.currentDisplay.setInputMode(mode);
        }

        public Object getClientObject() {
            return TextBox.this.getClientObject();
        }
    }
}

