/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Available;
import org.apache.tools.ant.taskdefs.UpToDate;
import org.apache.tools.ant.taskdefs.condition.And;
import org.apache.tools.ant.taskdefs.condition.Equals;
import org.apache.tools.ant.taskdefs.condition.Not;
import org.apache.tools.ant.taskdefs.condition.Or;
import org.apache.tools.ant.taskdefs.condition.Os;

public abstract class ConditionBase {
    private Vector conditions = new Vector();
    private Project project;

    public void setProject(Project project) {
        this.project = project;
    }

    protected Project getProject() {
        return this.project;
    }

    protected int countConditions() {
        return this.conditions.size();
    }

    protected final Enumeration getConditions() {
        return new ConditionEnumeration();
    }

    public void addAvailable(Available available) {
        this.conditions.addElement(available);
    }

    public void addUptodate(UpToDate upToDate) {
        this.conditions.addElement(upToDate);
    }

    public void addNot(Not not) {
        this.conditions.addElement(not);
    }

    public void addAnd(And and) {
        this.conditions.addElement(and);
    }

    public void addOr(Or or) {
        this.conditions.addElement(or);
    }

    public void addEquals(Equals equals) {
        this.conditions.addElement(equals);
    }

    public void addOs(Os os) {
        this.conditions.addElement(os);
    }

    private class ConditionEnumeration
    implements Enumeration {
        private int currentElement = 0;

        private ConditionEnumeration() {
        }

        public boolean hasMoreElements() {
            return ConditionBase.this.countConditions() > this.currentElement;
        }

        public Object nextElement() throws NoSuchElementException {
            Object var1_1 = null;
            try {
                var1_1 = ConditionBase.this.conditions.elementAt(this.currentElement++);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
            if (var1_1 instanceof Task) {
                ((Task)var1_1).setProject(ConditionBase.this.getProject());
            } else if (var1_1 instanceof ConditionBase) {
                ((ConditionBase)var1_1).setProject(ConditionBase.this.getProject());
            }
            return var1_1;
        }
    }
}

