// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceBindFrontendOKCode is the HTTP code returned for type ReplaceBindFrontendOK
const ReplaceBindFrontendOKCode int = 200

/*
ReplaceBindFrontendOK Bind replaced

swagger:response replaceBindFrontendOK
*/
type ReplaceBindFrontendOK struct {

	/*
	  In: Body
	*/
	Payload *models.Bind `json:"body,omitempty"`
}

// NewReplaceBindFrontendOK creates ReplaceBindFrontendOK with default headers values
func NewReplaceBindFrontendOK() *ReplaceBindFrontendOK {

	return &ReplaceBindFrontendOK{}
}

// WithPayload adds the payload to the replace bind frontend o k response
func (o *ReplaceBindFrontendOK) WithPayload(payload *models.Bind) *ReplaceBindFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace bind frontend o k response
func (o *ReplaceBindFrontendOK) SetPayload(payload *models.Bind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceBindFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceBindFrontendAcceptedCode is the HTTP code returned for type ReplaceBindFrontendAccepted
const ReplaceBindFrontendAcceptedCode int = 202

/*
ReplaceBindFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceBindFrontendAccepted
*/
type ReplaceBindFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Bind `json:"body,omitempty"`
}

// NewReplaceBindFrontendAccepted creates ReplaceBindFrontendAccepted with default headers values
func NewReplaceBindFrontendAccepted() *ReplaceBindFrontendAccepted {

	return &ReplaceBindFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace bind frontend accepted response
func (o *ReplaceBindFrontendAccepted) WithReloadID(reloadID string) *ReplaceBindFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace bind frontend accepted response
func (o *ReplaceBindFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace bind frontend accepted response
func (o *ReplaceBindFrontendAccepted) WithPayload(payload *models.Bind) *ReplaceBindFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace bind frontend accepted response
func (o *ReplaceBindFrontendAccepted) SetPayload(payload *models.Bind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceBindFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceBindFrontendBadRequestCode is the HTTP code returned for type ReplaceBindFrontendBadRequest
const ReplaceBindFrontendBadRequestCode int = 400

/*
ReplaceBindFrontendBadRequest Bad request

swagger:response replaceBindFrontendBadRequest
*/
type ReplaceBindFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceBindFrontendBadRequest creates ReplaceBindFrontendBadRequest with default headers values
func NewReplaceBindFrontendBadRequest() *ReplaceBindFrontendBadRequest {

	return &ReplaceBindFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace bind frontend bad request response
func (o *ReplaceBindFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceBindFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace bind frontend bad request response
func (o *ReplaceBindFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace bind frontend bad request response
func (o *ReplaceBindFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceBindFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace bind frontend bad request response
func (o *ReplaceBindFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceBindFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceBindFrontendNotFoundCode is the HTTP code returned for type ReplaceBindFrontendNotFound
const ReplaceBindFrontendNotFoundCode int = 404

/*
ReplaceBindFrontendNotFound The specified resource was not found

swagger:response replaceBindFrontendNotFound
*/
type ReplaceBindFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceBindFrontendNotFound creates ReplaceBindFrontendNotFound with default headers values
func NewReplaceBindFrontendNotFound() *ReplaceBindFrontendNotFound {

	return &ReplaceBindFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace bind frontend not found response
func (o *ReplaceBindFrontendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceBindFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace bind frontend not found response
func (o *ReplaceBindFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace bind frontend not found response
func (o *ReplaceBindFrontendNotFound) WithPayload(payload *models.Error) *ReplaceBindFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace bind frontend not found response
func (o *ReplaceBindFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceBindFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceBindFrontendDefault General Error

swagger:response replaceBindFrontendDefault
*/
type ReplaceBindFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceBindFrontendDefault creates ReplaceBindFrontendDefault with default headers values
func NewReplaceBindFrontendDefault(code int) *ReplaceBindFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceBindFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace bind frontend default response
func (o *ReplaceBindFrontendDefault) WithStatusCode(code int) *ReplaceBindFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace bind frontend default response
func (o *ReplaceBindFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace bind frontend default response
func (o *ReplaceBindFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceBindFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace bind frontend default response
func (o *ReplaceBindFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace bind frontend default response
func (o *ReplaceBindFrontendDefault) WithPayload(payload *models.Error) *ReplaceBindFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace bind frontend default response
func (o *ReplaceBindFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceBindFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
