// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllLogTargetPeerOKCode is the HTTP code returned for type ReplaceAllLogTargetPeerOK
const ReplaceAllLogTargetPeerOKCode int = 200

/*
ReplaceAllLogTargetPeerOK All Log Target lines replaced

swagger:response replaceAllLogTargetPeerOK
*/
type ReplaceAllLogTargetPeerOK struct {

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetPeerOK creates ReplaceAllLogTargetPeerOK with default headers values
func NewReplaceAllLogTargetPeerOK() *ReplaceAllLogTargetPeerOK {

	return &ReplaceAllLogTargetPeerOK{}
}

// WithPayload adds the payload to the replace all log target peer o k response
func (o *ReplaceAllLogTargetPeerOK) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetPeerOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target peer o k response
func (o *ReplaceAllLogTargetPeerOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetPeerOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetPeerAcceptedCode is the HTTP code returned for type ReplaceAllLogTargetPeerAccepted
const ReplaceAllLogTargetPeerAcceptedCode int = 202

/*
ReplaceAllLogTargetPeerAccepted Configuration change accepted and reload requested

swagger:response replaceAllLogTargetPeerAccepted
*/
type ReplaceAllLogTargetPeerAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetPeerAccepted creates ReplaceAllLogTargetPeerAccepted with default headers values
func NewReplaceAllLogTargetPeerAccepted() *ReplaceAllLogTargetPeerAccepted {

	return &ReplaceAllLogTargetPeerAccepted{}
}

// WithReloadID adds the reloadId to the replace all log target peer accepted response
func (o *ReplaceAllLogTargetPeerAccepted) WithReloadID(reloadID string) *ReplaceAllLogTargetPeerAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all log target peer accepted response
func (o *ReplaceAllLogTargetPeerAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all log target peer accepted response
func (o *ReplaceAllLogTargetPeerAccepted) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetPeerAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target peer accepted response
func (o *ReplaceAllLogTargetPeerAccepted) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetPeerAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetPeerBadRequestCode is the HTTP code returned for type ReplaceAllLogTargetPeerBadRequest
const ReplaceAllLogTargetPeerBadRequestCode int = 400

/*
ReplaceAllLogTargetPeerBadRequest Bad request

swagger:response replaceAllLogTargetPeerBadRequest
*/
type ReplaceAllLogTargetPeerBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetPeerBadRequest creates ReplaceAllLogTargetPeerBadRequest with default headers values
func NewReplaceAllLogTargetPeerBadRequest() *ReplaceAllLogTargetPeerBadRequest {

	return &ReplaceAllLogTargetPeerBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target peer bad request response
func (o *ReplaceAllLogTargetPeerBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetPeerBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target peer bad request response
func (o *ReplaceAllLogTargetPeerBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target peer bad request response
func (o *ReplaceAllLogTargetPeerBadRequest) WithPayload(payload *models.Error) *ReplaceAllLogTargetPeerBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target peer bad request response
func (o *ReplaceAllLogTargetPeerBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetPeerBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllLogTargetPeerDefault General Error

swagger:response replaceAllLogTargetPeerDefault
*/
type ReplaceAllLogTargetPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetPeerDefault creates ReplaceAllLogTargetPeerDefault with default headers values
func NewReplaceAllLogTargetPeerDefault(code int) *ReplaceAllLogTargetPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllLogTargetPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all log target peer default response
func (o *ReplaceAllLogTargetPeerDefault) WithStatusCode(code int) *ReplaceAllLogTargetPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all log target peer default response
func (o *ReplaceAllLogTargetPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target peer default response
func (o *ReplaceAllLogTargetPeerDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target peer default response
func (o *ReplaceAllLogTargetPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target peer default response
func (o *ReplaceAllLogTargetPeerDefault) WithPayload(payload *models.Error) *ReplaceAllLogTargetPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target peer default response
func (o *ReplaceAllLogTargetPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
