// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceSpoeAgentOKCode is the HTTP code returned for type ReplaceSpoeAgentOK
const ReplaceSpoeAgentOKCode int = 200

/*
ReplaceSpoeAgentOK Spoe agent replaced

swagger:response replaceSpoeAgentOK
*/
type ReplaceSpoeAgentOK struct {

	/*
	  In: Body
	*/
	Payload *models.SpoeAgent `json:"body,omitempty"`
}

// NewReplaceSpoeAgentOK creates ReplaceSpoeAgentOK with default headers values
func NewReplaceSpoeAgentOK() *ReplaceSpoeAgentOK {

	return &ReplaceSpoeAgentOK{}
}

// WithPayload adds the payload to the replace spoe agent o k response
func (o *ReplaceSpoeAgentOK) WithPayload(payload *models.SpoeAgent) *ReplaceSpoeAgentOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace spoe agent o k response
func (o *ReplaceSpoeAgentOK) SetPayload(payload *models.SpoeAgent) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceSpoeAgentOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceSpoeAgentBadRequestCode is the HTTP code returned for type ReplaceSpoeAgentBadRequest
const ReplaceSpoeAgentBadRequestCode int = 400

/*
ReplaceSpoeAgentBadRequest Bad request

swagger:response replaceSpoeAgentBadRequest
*/
type ReplaceSpoeAgentBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceSpoeAgentBadRequest creates ReplaceSpoeAgentBadRequest with default headers values
func NewReplaceSpoeAgentBadRequest() *ReplaceSpoeAgentBadRequest {

	return &ReplaceSpoeAgentBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace spoe agent bad request response
func (o *ReplaceSpoeAgentBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceSpoeAgentBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace spoe agent bad request response
func (o *ReplaceSpoeAgentBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace spoe agent bad request response
func (o *ReplaceSpoeAgentBadRequest) WithPayload(payload *models.Error) *ReplaceSpoeAgentBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace spoe agent bad request response
func (o *ReplaceSpoeAgentBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceSpoeAgentBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceSpoeAgentNotFoundCode is the HTTP code returned for type ReplaceSpoeAgentNotFound
const ReplaceSpoeAgentNotFoundCode int = 404

/*
ReplaceSpoeAgentNotFound The specified resource was not found

swagger:response replaceSpoeAgentNotFound
*/
type ReplaceSpoeAgentNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceSpoeAgentNotFound creates ReplaceSpoeAgentNotFound with default headers values
func NewReplaceSpoeAgentNotFound() *ReplaceSpoeAgentNotFound {

	return &ReplaceSpoeAgentNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace spoe agent not found response
func (o *ReplaceSpoeAgentNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceSpoeAgentNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace spoe agent not found response
func (o *ReplaceSpoeAgentNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace spoe agent not found response
func (o *ReplaceSpoeAgentNotFound) WithPayload(payload *models.Error) *ReplaceSpoeAgentNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace spoe agent not found response
func (o *ReplaceSpoeAgentNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceSpoeAgentNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceSpoeAgentDefault General Error

swagger:response replaceSpoeAgentDefault
*/
type ReplaceSpoeAgentDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceSpoeAgentDefault creates ReplaceSpoeAgentDefault with default headers values
func NewReplaceSpoeAgentDefault(code int) *ReplaceSpoeAgentDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceSpoeAgentDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace spoe agent default response
func (o *ReplaceSpoeAgentDefault) WithStatusCode(code int) *ReplaceSpoeAgentDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace spoe agent default response
func (o *ReplaceSpoeAgentDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace spoe agent default response
func (o *ReplaceSpoeAgentDefault) WithConfigurationVersion(configurationVersion string) *ReplaceSpoeAgentDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace spoe agent default response
func (o *ReplaceSpoeAgentDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace spoe agent default response
func (o *ReplaceSpoeAgentDefault) WithPayload(payload *models.Error) *ReplaceSpoeAgentDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace spoe agent default response
func (o *ReplaceSpoeAgentDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceSpoeAgentDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
