// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteTCPRequestRuleFrontendAcceptedCode is the HTTP code returned for type DeleteTCPRequestRuleFrontendAccepted
const DeleteTCPRequestRuleFrontendAcceptedCode int = 202

/*
DeleteTCPRequestRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response deleteTcpRequestRuleFrontendAccepted
*/
type DeleteTCPRequestRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteTCPRequestRuleFrontendAccepted creates DeleteTCPRequestRuleFrontendAccepted with default headers values
func NewDeleteTCPRequestRuleFrontendAccepted() *DeleteTCPRequestRuleFrontendAccepted {

	return &DeleteTCPRequestRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the delete Tcp request rule frontend accepted response
func (o *DeleteTCPRequestRuleFrontendAccepted) WithReloadID(reloadID string) *DeleteTCPRequestRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Tcp request rule frontend accepted response
func (o *DeleteTCPRequestRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteTCPRequestRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteTCPRequestRuleFrontendNoContentCode is the HTTP code returned for type DeleteTCPRequestRuleFrontendNoContent
const DeleteTCPRequestRuleFrontendNoContentCode int = 204

/*
DeleteTCPRequestRuleFrontendNoContent TCP Request Rule deleted

swagger:response deleteTcpRequestRuleFrontendNoContent
*/
type DeleteTCPRequestRuleFrontendNoContent struct {
}

// NewDeleteTCPRequestRuleFrontendNoContent creates DeleteTCPRequestRuleFrontendNoContent with default headers values
func NewDeleteTCPRequestRuleFrontendNoContent() *DeleteTCPRequestRuleFrontendNoContent {

	return &DeleteTCPRequestRuleFrontendNoContent{}
}

// WriteResponse to the client
func (o *DeleteTCPRequestRuleFrontendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteTCPRequestRuleFrontendNotFoundCode is the HTTP code returned for type DeleteTCPRequestRuleFrontendNotFound
const DeleteTCPRequestRuleFrontendNotFoundCode int = 404

/*
DeleteTCPRequestRuleFrontendNotFound The specified resource was not found

swagger:response deleteTcpRequestRuleFrontendNotFound
*/
type DeleteTCPRequestRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteTCPRequestRuleFrontendNotFound creates DeleteTCPRequestRuleFrontendNotFound with default headers values
func NewDeleteTCPRequestRuleFrontendNotFound() *DeleteTCPRequestRuleFrontendNotFound {

	return &DeleteTCPRequestRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Tcp request rule frontend not found response
func (o *DeleteTCPRequestRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteTCPRequestRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Tcp request rule frontend not found response
func (o *DeleteTCPRequestRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Tcp request rule frontend not found response
func (o *DeleteTCPRequestRuleFrontendNotFound) WithPayload(payload *models.Error) *DeleteTCPRequestRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Tcp request rule frontend not found response
func (o *DeleteTCPRequestRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteTCPRequestRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteTCPRequestRuleFrontendDefault General Error

swagger:response deleteTcpRequestRuleFrontendDefault
*/
type DeleteTCPRequestRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteTCPRequestRuleFrontendDefault creates DeleteTCPRequestRuleFrontendDefault with default headers values
func NewDeleteTCPRequestRuleFrontendDefault(code int) *DeleteTCPRequestRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteTCPRequestRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete TCP request rule frontend default response
func (o *DeleteTCPRequestRuleFrontendDefault) WithStatusCode(code int) *DeleteTCPRequestRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete TCP request rule frontend default response
func (o *DeleteTCPRequestRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete TCP request rule frontend default response
func (o *DeleteTCPRequestRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *DeleteTCPRequestRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete TCP request rule frontend default response
func (o *DeleteTCPRequestRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete TCP request rule frontend default response
func (o *DeleteTCPRequestRuleFrontendDefault) WithPayload(payload *models.Error) *DeleteTCPRequestRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete TCP request rule frontend default response
func (o *DeleteTCPRequestRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteTCPRequestRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
