/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.release.BintrayUploadInfoOverride;
import org.jfrog.build.api.release.Distribution;
import org.jfrog.build.api.release.Promotion;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryHttpClient;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.ItemLastModified;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.bintrayResponse.BintrayResponse;
import org.jfrog.build.client.bintrayResponse.BintrayResponseFactory;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.util.DeploymentUrlUtils;
import org.jfrog.build.extractor.clientConfiguration.util.JsonSerializer;
import org.jfrog.build.extractor.usageReport.UsageReporter;
import org.jfrog.build.util.VersionCompatibilityType;
import org.jfrog.build.util.VersionException;

public class ArtifactoryBuildInfoClient
extends ArtifactoryBaseClient
implements AutoCloseable {
    private static final String LOCAL_REPOS_REST_URL = "/api/repositories?type=local";
    private static final String REMOTE_REPOS_REST_URL = "/api/repositories?type=remote";
    private static final String VIRTUAL_REPOS_REST_URL = "/api/repositories?type=virtual";
    private static final String PUSH_TO_BINTRAY_REST_URL = "/api/build/pushToBintray/";
    private static final String BUILD_REST_URL = "/api/build";
    private static final String BUILD_RETENTION_REST_URL = "/api/build/retention/";
    private static final String BUILD_RETENTION_REST_ASYNC_PARAM = "?async=";
    private static final int CHECKSUM_DEPLOY_MIN_FILE_SIZE = 10240;
    public static final String BUILD_BROWSE_URL = "/webapp/builds";
    public static final String APPLICATION_VND_ORG_JFROG_ARTIFACTORY_JSON = "application/vnd.org.jfrog.artifactory+json";
    public static final String APPLICATION_JSON = "application/json";
    public static final String ITEM_LAST_MODIFIED = "/api/storage/";
    private static final String USAGE_API = "/api/system/usage";
    private static final ArtifactoryVersion USAGE_ARTIFACTORY_MIN_VERSION = new ArtifactoryVersion("6.9.0");

    public ArtifactoryBuildInfoClient(String artifactoryUrl, Log log) {
        this(artifactoryUrl, "", "", "", log);
    }

    public ArtifactoryBuildInfoClient(String artifactoryUrl, String username, String password, String accessToken, Log log) {
        super(artifactoryUrl, username, password, accessToken, log);
    }

    public ArtifactoryBuildInfoClient(String artifactoryUrl, String username, String password, Log log) {
        this(artifactoryUrl, username, password, "", log);
    }

    public List<String> getLocalRepositoriesKeys() throws IOException {
        return this.getRepositoriesList(LOCAL_REPOS_REST_URL);
    }

    public List<String> getLocalAndCacheRepositoriesKeys() throws IOException {
        List<String> localRepositoriesKeys = this.getLocalRepositoriesKeys();
        List<String> remoteRepositories = this.getRemoteRepositoriesKeys();
        ArrayList<String> cacheRepositories = CommonUtils.transformList(remoteRepositories, repoKey -> repoKey + "-cache");
        return CommonUtils.concatLists(localRepositoriesKeys, cacheRepositories);
    }

    public List<String> getRemoteRepositoriesKeys() throws IOException {
        return this.getRepositoriesList(REMOTE_REPOS_REST_URL);
    }

    public List<String> getVirtualRepositoryKeys() throws IOException {
        return this.getRepositoriesList(VIRTUAL_REPOS_REST_URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRepositoriesList(String restUrl) throws IOException {
        ArrayList<String> repositories = new ArrayList<String>();
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        String reposUrl = this.artifactoryUrl + restUrl;
        this.log.debug("Requesting repositories list from: " + reposUrl);
        HttpGet httpget = new HttpGet(reposUrl);
        HttpResponse response = client.execute(httpget);
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() != 200) {
            throw new IOException("Failed to obtain list of repositories. Status code: " + statusLine.getStatusCode() + this.httpClient.getMessageFromEntity(entity));
        }
        if (entity != null) {
            repositories = new ArrayList();
            try (InputStream content = entity.getContent();){
                JsonParser parser = this.httpClient.createJsonParser(content);
                JsonNode result = (JsonNode)parser.readValueAsTree();
                this.log.debug("Repositories result = " + result);
                for (JsonNode jsonNode : result) {
                    String repositoryKey = jsonNode.get("key").asText();
                    repositories.add(repositoryKey);
                }
            }
        }
        return repositories;
    }

    public void sendBuildInfo(String buildInfoJson) throws IOException {
        String url = String.format("%s%s", this.artifactoryUrl, BUILD_REST_URL);
        HttpPut httpPut = new HttpPut(url);
        try {
            this.log.info("Deploying build descriptor to: " + httpPut.getURI().toString());
            this.sendHttpEntityRequest(httpPut, buildInfoJson, APPLICATION_VND_ORG_JFROG_ARTIFACTORY_JSON);
        }
        catch (IOException e) {
            throw new IOException("Failed to send build descriptor. " + e.getMessage(), e);
        }
    }

    public Build getBuildInfo(String buildName, String buildNumber) throws IOException {
        if ((buildNumber = this.getLatestBuildNumberFromArtifactory(buildName, buildNumber)) == null) {
            return null;
        }
        String url = String.format("%s%s/%s/%s", this.artifactoryUrl, BUILD_REST_URL, ArtifactoryHttpClient.encodeUrl(buildName), ArtifactoryHttpClient.encodeUrl(buildNumber));
        HttpGet httpGet = new HttpGet(url);
        try {
            HttpResponse httpResponse = this.sendHttpRequest(httpGet, 200);
            String buildInfoJson = EntityUtils.toString(httpResponse.getEntity(), "UTF-8");
            return this.getBuildFromJson(buildInfoJson);
        }
        catch (IOException e) {
            throw new IOException("Failed to get build info. " + e.getMessage(), e);
        }
    }

    private String getLatestBuildNumberFromArtifactory(String buildName, String buildNumber) throws IOException {
        ArtifactoryDependenciesClient dependenciesClient = new ArtifactoryDependenciesClient(this.artifactoryUrl, this.httpClient, this.log);
        return dependenciesClient.getLatestBuildNumberFromArtifactory(buildName, buildNumber);
    }

    public void sendBuildRetetion(BuildRetention buildRetention, String buildName, boolean async) throws IOException {
        String buildRetentionJson = this.toJsonString(buildRetention);
        String url = this.artifactoryUrl + BUILD_RETENTION_REST_URL + buildName + BUILD_RETENTION_REST_ASYNC_PARAM + async;
        HttpPost httpPost = new HttpPost(url);
        try {
            this.log.info(this.createBuildRetentionLogMsg(buildRetention, async));
            this.log.debug(buildRetentionJson);
            this.sendHttpEntityRequest(httpPost, buildRetentionJson, APPLICATION_JSON);
        }
        catch (IOException e) {
            this.log.error("Failed to execute build retention.", e);
            throw new IOException("Failed to execute build retention: " + e.getMessage(), e);
        }
    }

    private String createBuildRetentionLogMsg(BuildRetention buildRetention, boolean async) {
        StringBuilder strBuilder = new StringBuilder().append("Sending");
        if (async) {
            strBuilder.append(" async");
        }
        strBuilder.append(" request for build retention");
        if (buildRetention.isDeleteBuildArtifacts()) {
            strBuilder.append(", deleting build artifacts");
        }
        if (buildRetention.getCount() != -1) {
            strBuilder.append(", max number of builds to store: ").append(buildRetention.getCount());
        }
        if (buildRetention.getMinimumBuildDate() != null) {
            strBuilder.append(", min build date: ").append(buildRetention.getMinimumBuildDate());
        }
        if (!buildRetention.getBuildNumbersNotToBeDiscarded().isEmpty()) {
            strBuilder.append(", build numbers not to be discarded: ").append(buildRetention.getBuildNumbersNotToBeDiscarded());
        }
        strBuilder.append(".");
        return strBuilder.toString();
    }

    public void sendBuildInfo(Build buildInfo) throws IOException {
        this.log.debug("Sending build info: " + buildInfo);
        try {
            this.sendBuildInfo(this.buildInfoToJsonString(buildInfo));
        }
        catch (Exception e) {
            this.log.error("Could not build the build-info object.", e);
            throw new IOException("Could not publish build-info: " + e.getMessage());
        }
        String url = this.artifactoryUrl + BUILD_BROWSE_URL + "/" + ArtifactoryHttpClient.encodeUrl(buildInfo.getName()) + "/" + ArtifactoryHttpClient.encodeUrl(buildInfo.getNumber());
        this.log.info("Build successfully deployed. Browse it in Artifactory under " + url);
    }

    public void sendModuleInfo(Build build) throws IOException {
        this.log.debug("Sending build info modules: " + build);
        try {
            String url = this.artifactoryUrl + BUILD_REST_URL + "/append/" + ArtifactoryHttpClient.encodeUrl(build.getName()) + "/" + ArtifactoryHttpClient.encodeUrl(build.getNumber());
            HttpPost httpPost = new HttpPost(url);
            String modulesAsJsonString = this.toJsonString(build.getModules());
            this.log.info("Deploying build descriptor to: " + httpPost.getURI().toString());
            this.sendHttpEntityRequest(httpPost, modulesAsJsonString, APPLICATION_VND_ORG_JFROG_ARTIFACTORY_JSON);
        }
        catch (Exception e) {
            this.log.error("Could not build the build-info modules object.", e);
            throw new IOException("Could not publish build-info modules: " + e.getMessage(), e);
        }
    }

    private void sendHttpEntityRequest(HttpEntityEnclosingRequestBase request, String content, String contentType) throws IOException {
        StringEntity stringEntity = new StringEntity(content, "UTF-8");
        stringEntity.setContentType(contentType);
        request.setEntity(stringEntity);
        this.sendHttpRequest(request, 201, 200, 204);
    }

    private HttpResponse sendHttpRequest(HttpUriRequest request, int ... httpStatuses) throws IOException {
        HttpResponse httpResponse = this.httpClient.getHttpClient().execute(request);
        StatusLine statusLine = httpResponse.getStatusLine();
        for (int status : httpStatuses) {
            if (statusLine.getStatusCode() != status) continue;
            return httpResponse;
        }
        HttpEntity responseEntity = httpResponse.getEntity();
        throw new IOException(statusLine.getStatusCode() + this.httpClient.getMessageFromEntity(responseEntity));
    }

    /*
     * Loose catch block
     */
    public ItemLastModified getItemLastModified(String path) throws IOException {
        String url = this.artifactoryUrl + ITEM_LAST_MODIFIED + path + "?lastModified";
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.httpClient.getHttpClient().execute(get);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new IOException("While requesting item info for path " + path + " received " + response.getStatusLine().getStatusCode() + ":" + this.httpClient.getMessageFromEntity(response.getEntity()));
        }
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity != null) {
            try {
                try (InputStream content = httpEntity.getContent();){
                    JsonNode result = this.httpClient.getJsonNode(content);
                    JsonNode lastModified = result.get("lastModified");
                    JsonNode uri = result.get("uri");
                    if (lastModified == null || uri == null) {
                        throw new IOException("Unexpected JSON response when requesting info for path " + path + this.httpClient.getMessageFromEntity(response.getEntity()));
                    }
                    ItemLastModified itemLastModified = new ItemLastModified(uri.asText(), lastModified.asText());
                    return itemLastModified;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                EntityUtils.consume(httpEntity);
            }
        }
        throw new IOException("The path " + path + " returned empty entity");
    }

    public ArtifactoryUploadResponse deployArtifact(DeployDetails details) throws IOException {
        return this.deployArtifact(details, null);
    }

    public ArtifactoryUploadResponse deployArtifact(DeployDetails details, String logPrefix) throws IOException {
        String deploymentPath = this.buildDeploymentPath(details);
        logPrefix = logPrefix == null ? "" : logPrefix + " ";
        this.log.info(logPrefix + "Deploying artifact: " + deploymentPath);
        return this.doDeployArtifact(details, deploymentPath);
    }

    private String buildDeploymentPath(DeployDetails details) throws IOException {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(ArtifactoryHttpClient.encodeUrl(this.artifactoryUrl));
        pathComponents.add(DeploymentUrlUtils.encodePath(details.getTargetRepository()));
        pathComponents.add(DeploymentUrlUtils.encodePath(details.getArtifactPath()));
        return StringUtils.join(pathComponents, "/");
    }

    private ArtifactoryUploadResponse doDeployArtifact(DeployDetails details, String deploymentPath) throws IOException {
        ArtifactoryUploadResponse response = this.uploadFile(details, deploymentPath);
        if (!this.getArtifactoryVersion().isAtLeast(new ArtifactoryVersion("2.3.2"))) {
            this.uploadChecksums(details, deploymentPath);
        }
        return response;
    }

    public ArtifactoryVersion verifyCompatibleArtifactoryVersion() throws VersionException {
        ArtifactoryVersion version;
        try {
            version = this.httpClient.getVersion();
        }
        catch (IOException e) {
            throw new VersionException("Error occurred while requesting version information: " + e.getMessage(), e, VersionCompatibilityType.NOT_FOUND);
        }
        if (version.isNotFound()) {
            throw new VersionException("There is either an incompatible or no instance of Artifactory at the provided URL.", VersionCompatibilityType.NOT_FOUND);
        }
        boolean isCompatibleArtifactory = version.isAtLeast(ArtifactoryHttpClient.MINIMAL_ARTIFACTORY_VERSION);
        if (!isCompatibleArtifactory) {
            throw new VersionException("This plugin is compatible with version " + ArtifactoryHttpClient.MINIMAL_ARTIFACTORY_VERSION + " of Artifactory and above. Please upgrade your Artifactory server!", VersionCompatibilityType.INCOMPATIBLE);
        }
        return version;
    }

    public BintrayResponse pushToBintray(String buildName, String buildNumber, String signMethod, String passphrase, BintrayUploadInfoOverride bintrayUploadInfo) throws IOException, URISyntaxException {
        if (StringUtils.isBlank(buildName)) {
            throw new IllegalArgumentException("Build name is required for promotion.");
        }
        if (StringUtils.isBlank(buildNumber)) {
            throw new IllegalArgumentException("Build number is required for promotion.");
        }
        String requestUrl = this.createRequestUrl(buildName, buildNumber, signMethod, passphrase);
        String requestBody = this.createJsonRequestBody(bintrayUploadInfo);
        HttpPost httpPost = new HttpPost(requestUrl);
        StringEntity entity = new StringEntity(requestBody);
        entity.setContentType(APPLICATION_JSON);
        httpPost.setEntity(entity);
        HttpResponse response = this.httpClient.getHttpClient().execute(httpPost);
        return this.parseResponse(response);
    }

    private String createRequestUrl(String buildName, String buildNumber, String signMethod, String passphrase) throws URISyntaxException {
        URIBuilder urlBuilder = new URIBuilder();
        urlBuilder.setPath(this.artifactoryUrl + PUSH_TO_BINTRAY_REST_URL + buildName + "/" + buildNumber);
        if (StringUtils.isNotEmpty(passphrase)) {
            urlBuilder.setParameter("gpgPassphrase", passphrase);
        }
        if (!StringUtils.equals(signMethod, "descriptor")) {
            urlBuilder.setParameter("gpgSign", signMethod);
        }
        return urlBuilder.toString();
    }

    private String createJsonRequestBody(BintrayUploadInfoOverride info) throws IOException {
        String bintrayInfoJson = !info.isValid() ? "{}" : this.toJsonString(info);
        return bintrayInfoJson;
    }

    private BintrayResponse parseResponse(HttpResponse response) throws IOException {
        InputStream content = response.getEntity().getContent();
        int status = response.getStatusLine().getStatusCode();
        JsonParser parser = this.httpClient.createJsonFactory().createParser(content);
        BintrayResponse responseObject = BintrayResponseFactory.createResponse(status, parser);
        return responseObject;
    }

    public HttpResponse stageBuild(String buildName, String buildNumber, Promotion promotion) throws IOException {
        if (StringUtils.isBlank(buildName)) {
            throw new IllegalArgumentException("Build name is required for promotion.");
        }
        if (StringUtils.isBlank(buildNumber)) {
            throw new IllegalArgumentException("Build number is required for promotion.");
        }
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append(BUILD_REST_URL).append("/promote/").append(ArtifactoryHttpClient.encodeUrl(buildName)).append("/").append(ArtifactoryHttpClient.encodeUrl(buildNumber));
        String promotionJson = this.toJsonString(promotion);
        HttpPost httpPost = new HttpPost(urlBuilder.toString());
        StringEntity stringEntity = new StringEntity(promotionJson);
        stringEntity.setContentType("application/vnd.org.jfrog.artifactory.build.PromotionRequest+json");
        httpPost.setEntity(stringEntity);
        this.log.info("Promoting build " + buildName + ", #" + buildNumber);
        return this.httpClient.getHttpClient().execute(httpPost);
    }

    public HttpResponse distributeBuild(String buildName, String buildNumber, Distribution promotion) throws IOException {
        if (StringUtils.isBlank(buildName)) {
            throw new IllegalArgumentException("Build name is required for distribution.");
        }
        if (StringUtils.isBlank(buildNumber)) {
            throw new IllegalArgumentException("Build number is required for distribution.");
        }
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append(BUILD_REST_URL).append("/distribute/").append(ArtifactoryHttpClient.encodeUrl(buildName)).append("/").append(ArtifactoryHttpClient.encodeUrl(buildNumber));
        String distributionJson = this.toJsonString(promotion);
        HttpPost httpPost = new HttpPost(urlBuilder.toString());
        StringEntity stringEntity = new StringEntity(distributionJson);
        stringEntity.setContentType(APPLICATION_JSON);
        httpPost.setEntity(stringEntity);
        this.log.info("Distributing build " + buildName + ", #" + buildNumber);
        return this.httpClient.getHttpClient().execute(httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Map>> getUserPluginInfo() throws IOException {
        String url = this.artifactoryUrl + "/api/plugins";
        HttpGet getPlugins = new HttpGet(url);
        HttpResponse getResponse = this.httpClient.getHttpClient().execute(getPlugins);
        StatusLine statusLine = getResponse.getStatusLine();
        HttpEntity responseEntity = getResponse.getEntity();
        if (statusLine.getStatusCode() != 200) {
            throw new IOException("Failed to obtain user plugin information. Status code: " + statusLine.getStatusCode() + this.httpClient.getMessageFromEntity(responseEntity));
        }
        if (responseEntity != null) {
            try (InputStream content = responseEntity.getContent();){
                JsonParser parser = this.httpClient.createJsonParser(content);
                Map map = parser.readValueAs(Map.class);
                return map;
            }
        }
        return new HashMap<String, List<Map>>();
    }

    public HttpResponse executeUserPlugin(String executionName, Map<String, String> requestParams) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/plugins/execute/").append(executionName).append("?");
        this.appendParamsToUrl(requestParams, urlBuilder);
        HttpPost postRequest = new HttpPost(urlBuilder.toString());
        return this.httpClient.getHttpClient().execute(postRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStagingStrategy(String strategyName, String buildName, Map<String, String> requestParams) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/plugins/build/staging/").append(ArtifactoryHttpClient.encodeUrl(strategyName)).append("?buildName=").append(ArtifactoryHttpClient.encodeUrl(buildName)).append("&");
        this.appendParamsToUrl(requestParams, urlBuilder);
        HttpGet getRequest = new HttpGet(urlBuilder.toString());
        HttpResponse response = this.httpClient.getHttpClient().execute(getRequest);
        StatusLine statusLine = response.getStatusLine();
        HttpEntity responseEntity = response.getEntity();
        if (statusLine.getStatusCode() != 200) {
            throw new IOException("Failed to obtain staging strategy. Status code: " + statusLine.getStatusCode() + this.httpClient.getMessageFromEntity(responseEntity));
        }
        if (responseEntity != null) {
            try (InputStream content = responseEntity.getContent();){
                JsonParser parser = this.httpClient.createJsonParser(content);
                Map map = parser.readValueAs(Map.class);
                return map;
            }
        }
        return new HashMap();
    }

    public HttpResponse executePromotionUserPlugin(String promotionName, String buildName, String buildNumber, Map<String, String> requestParams) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/plugins/build/promote/").append(promotionName).append("/").append(ArtifactoryHttpClient.encodeUrl(buildName)).append("/").append(ArtifactoryHttpClient.encodeUrl(buildNumber)).append("?");
        this.appendParamsToUrl(requestParams, urlBuilder);
        HttpPost postRequest = new HttpPost(urlBuilder.toString());
        return this.httpClient.getHttpClient().execute(postRequest);
    }

    public HttpResponse executeUpdateFileProperty(String itemPath, String properties) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append(ITEM_LAST_MODIFIED).append(ArtifactoryHttpClient.encodeUrl(itemPath)).append("?").append("properties=").append(ArtifactoryHttpClient.encodeUrl(properties));
        HttpPut postRequest = new HttpPut(urlBuilder.toString());
        return this.httpClient.getHttpClient().execute(postRequest);
    }

    private void appendParamsToUrl(Map<String, String> requestParams, StringBuilder urlBuilder) throws UnsupportedEncodingException {
        if (requestParams != null && !requestParams.isEmpty()) {
            urlBuilder.append("params=");
            Iterator<Map.Entry<String, String>> paramEntryIterator = requestParams.entrySet().iterator();
            String encodedPipe = ArtifactoryHttpClient.encodeUrl("|");
            while (paramEntryIterator.hasNext()) {
                Map.Entry<String, String> paramEntry = paramEntryIterator.next();
                urlBuilder.append(ArtifactoryHttpClient.encodeUrl(paramEntry.getKey()));
                String paramValue = paramEntry.getValue();
                if (StringUtils.isNotBlank(paramValue)) {
                    urlBuilder.append("=").append(ArtifactoryHttpClient.encodeUrl(paramValue));
                }
                if (!paramEntryIterator.hasNext()) continue;
                urlBuilder.append(encodedPipe);
            }
        }
    }

    public String buildInfoToJsonString(Build buildInfo) throws Exception {
        ArtifactoryVersion version = this.verifyCompatibleArtifactoryVersion();
        if (!version.isAtLeast(ArtifactoryHttpClient.UNKNOWN_PROPERTIES_TOLERANT_ARTIFACTORY_VERSION)) {
            buildInfo.setBuildAgent(null);
            buildInfo.setParentName(null);
            buildInfo.setParentNumber(null);
        }
        if (!version.isAtLeast(ArtifactoryHttpClient.NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION)) {
            String buildNumber = buildInfo.getNumber();
            this.verifyNonNumericBuildNumber(buildNumber);
            String parentBuildNumber = buildInfo.getParentNumber();
            this.verifyNonNumericBuildNumber(parentBuildNumber);
        }
        return this.toJsonString(buildInfo);
    }

    String toJsonString(Object object) throws IOException {
        JsonFactory jsonFactory = this.httpClient.createJsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator(writer);
        jsonGenerator.useDefaultPrettyPrinter();
        jsonGenerator.writeObject(object);
        String result = writer.getBuffer().toString();
        return result;
    }

    private Build getBuildFromJson(String buildInfoJson) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actualObj = mapper.readTree(buildInfoJson);
        return mapper.readValue(actualObj.get("buildInfo").toString(), Build.class);
    }

    private void verifyNonNumericBuildNumber(String buildNumber) {
        if (buildNumber != null) {
            try {
                Long.parseLong(buildNumber);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot handle build/parent build number: " + buildNumber + ". Non-numeric build numbers are supported by Artifactory version " + ArtifactoryHttpClient.NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION + " and above. Please upgrade your Artifactory or use numeric build numbers.");
            }
        }
    }

    private ArtifactoryUploadResponse uploadFile(DeployDetails details, String uploadUrl) throws IOException {
        FileEntity fileEntity;
        int statusCode;
        ArtifactoryUploadResponse response = this.tryChecksumDeploy(details, uploadUrl);
        if (response != null) {
            return response;
        }
        HttpPut httpPut = this.createHttpPutMethod(details, uploadUrl);
        httpPut.addHeader("Expect", "100-continue");
        if (details.isExplode()) {
            httpPut.addHeader("X-Explode-Archive", "true");
        }
        if ((statusCode = (response = this.httpClient.upload(httpPut, fileEntity = new FileEntity(details.getFile(), "binary/octet-stream"))).getStatusLine().getStatusCode()) != 201 && statusCode != 200) {
            throw new IOException("Failed to deploy file. Status code: " + statusCode + this.getMessage(response));
        }
        return response;
    }

    private ArtifactoryUploadResponse tryChecksumDeploy(DeployDetails details, String uploadUrl) throws UnsupportedEncodingException {
        long fileLength = details.getFile().length();
        if (fileLength < 10240L) {
            this.log.debug("Skipping checksum deploy of file size " + fileLength + " , falling back to regular deployment.");
            return null;
        }
        if (details.isExplode()) {
            this.log.debug("Skipping checksum deploy due to explode file request.");
            return null;
        }
        if (!this.getArtifactoryVersion().isAtLeast(new ArtifactoryVersion("2.5.1"))) {
            return null;
        }
        HttpPut httpPut = this.createHttpPutMethod(details, uploadUrl);
        httpPut.addHeader("X-Checksum-Deploy", "true");
        String fileAbsolutePath = details.getFile().getAbsolutePath();
        try {
            ArtifactoryUploadResponse response = this.httpClient.execute(httpPut);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 201 || statusCode == 200) {
                this.log.debug("Successfully performed checksum deploy of file " + fileAbsolutePath + " : " + details.getSha1());
                return response;
            }
            this.log.debug("Failed checksum deploy of checksum '" + details.getSha1() + "' with statusCode: " + statusCode);
        }
        catch (IOException e) {
            this.log.debug("Failed artifact checksum deploy of file " + fileAbsolutePath + " : " + details.getSha1());
        }
        return null;
    }

    private HttpPut createHttpPutMethod(DeployDetails details, String uploadUrl) throws UnsupportedEncodingException {
        StringBuilder deploymentPathBuilder = new StringBuilder().append(uploadUrl);
        deploymentPathBuilder.append(DeploymentUrlUtils.buildMatrixParamsString(details.getProperties(), true));
        HttpPut httpPut = new HttpPut(deploymentPathBuilder.toString());
        httpPut.addHeader("X-Checksum-Sha1", details.getSha1());
        httpPut.addHeader("X-Checksum-Md5", details.getMd5());
        this.log.debug("Full Artifact Http path: " + httpPut.toString() + "\n@Http Headers: " + Arrays.toString(httpPut.getAllHeaders()));
        return httpPut;
    }

    public void uploadChecksums(DeployDetails details, String uploadUrl) throws IOException {
        String md5;
        Map<String, String> checksums = this.getChecksumMap(details);
        String fileAbsolutePath = details.getFile().getAbsolutePath();
        String sha1 = checksums.get("SHA1");
        if (StringUtils.isNotBlank(sha1)) {
            this.log.debug("Uploading SHA1 for file " + fileAbsolutePath + " : " + sha1);
            String sha1Url = uploadUrl + ".sha1" + DeploymentUrlUtils.buildMatrixParamsString(details.getProperties(), true);
            HttpPut putSha1 = new HttpPut(sha1Url);
            StringEntity sha1StringEntity = new StringEntity(sha1);
            ArtifactoryUploadResponse response = this.httpClient.upload(putSha1, sha1StringEntity);
            StatusLine sha1StatusLine = response.getStatusLine();
            int sha1StatusCode = sha1StatusLine.getStatusCode();
            if (sha1StatusCode != 201 && sha1StatusCode != 200) {
                throw new IOException("Failed to deploy SHA1 checksum. Status code: " + sha1StatusCode + this.getMessage(response));
            }
        }
        if (StringUtils.isNotBlank(md5 = checksums.get("MD5"))) {
            this.log.debug("Uploading MD5 for file " + fileAbsolutePath + " : " + md5);
            String md5Url = uploadUrl + ".md5" + DeploymentUrlUtils.buildMatrixParamsString(details.getProperties(), true);
            HttpPut putMd5 = new HttpPut(md5Url);
            StringEntity md5StringEntity = new StringEntity(md5);
            ArtifactoryUploadResponse response = this.httpClient.upload(putMd5, md5StringEntity);
            StatusLine md5StatusLine = response.getStatusLine();
            int md5StatusCode = md5StatusLine.getStatusCode();
            if (md5StatusCode != 201 && md5StatusCode != 200) {
                throw new IOException("Failed to deploy MD5 checksum. Status code: " + md5StatusCode + this.getMessage(response));
            }
        }
    }

    private Map<String, String> getChecksumMap(DeployDetails details) throws IOException {
        HashMap<String, String> checksums = new HashMap<String, String>();
        ArrayList<String> checksumTypeList = new ArrayList<String>();
        if (StringUtils.isBlank(details.getMd5())) {
            checksumTypeList.add("MD5");
        } else {
            checksums.put("MD5", details.getMd5());
        }
        if (StringUtils.isBlank(details.getSha1())) {
            checksumTypeList.add("SHA1");
        } else {
            checksums.put("SHA1", details.getSha1());
        }
        if (!checksumTypeList.isEmpty()) {
            try {
                checksums.putAll(FileChecksumCalculator.calculateChecksums(details.getFile(), checksumTypeList.toArray(new String[checksumTypeList.size()])));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return checksums;
    }

    private void throwHttpIOException(String message, StatusLine statusLine) throws IOException {
        String errorMessage = message + " HTTP response code: " + statusLine.getStatusCode() + ". HTTP response message: " + statusLine.getReasonPhrase();
        throw new IOException(errorMessage);
    }

    private String getMessage(ArtifactoryUploadResponse response) {
        String responseMessage = "";
        if (response.getErrors() != null && StringUtils.isNotBlank(responseMessage = this.getResponseMessage(response.getErrors()))) {
            responseMessage = " Response message: " + responseMessage;
        }
        return responseMessage;
    }

    private String getResponseMessage(List<ArtifactoryUploadResponse.Error> errorList) {
        if (errorList == null || errorList.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("Artifactory returned the following errors: ");
        for (ArtifactoryUploadResponse.Error error : errorList) {
            builder.append("\n").append(error.getMessage()).append(" Status code: ").append(error.getStatus());
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportUsage(UsageReporter usageReporter) throws IOException {
        ArtifactoryVersion version = this.getArtifactoryVersion();
        if (version.isNotFound()) {
            throw new IOException("Could not get Artifactory version.");
        }
        if (!version.isAtLeast(USAGE_ARTIFACTORY_MIN_VERSION)) {
            throw new IOException("Usage report is not supported on targeted Artifactory server.");
        }
        String url = this.artifactoryUrl + USAGE_API;
        String encodedUrl = ArtifactoryHttpClient.encodeUrl(url);
        String requestBody = new JsonSerializer<UsageReporter>().toJSON(usageReporter);
        StringEntity entity = new StringEntity(requestBody, "UTF-8");
        entity.setContentType(APPLICATION_JSON);
        HttpPost request = new HttpPost(encodedUrl);
        request.setEntity(entity);
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.getHttpClient().execute(request);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                throw new IOException(String.format("Artifactory response: %s %s", statusLine.getStatusCode(), statusLine.getReasonPhrase()));
            }
        }
        finally {
            if (httpResponse != null) {
                EntityUtils.consumeQuietly(httpResponse.getEntity());
            }
        }
    }
}

