"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.STAGING_BASE_URL = exports.PROD_BASE_URL = exports.GATEWAY_BASE_URL = exports.FEDM_STAGING_BASE_URL = exports.FEDM_PROD_BASE_URL = exports.DEV_BASE_URL = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _types = require("../types");
var _version = require("../version");
var _errors = require("./errors");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var DEFAULT_REQUEST_TIMEOUT_MS = 5000;
var PROD_BASE_URL = exports.PROD_BASE_URL = 'https://api.atlassian.com/flags';
var STAGING_BASE_URL = exports.STAGING_BASE_URL = 'https://api.stg.atlassian.com/flags';
var DEV_BASE_URL = exports.DEV_BASE_URL = 'https://api.dev.atlassian.com/flags';
var FEDM_STAGING_BASE_URL = exports.FEDM_STAGING_BASE_URL = 'https://api.stg.atlassian-us-gov-mod.com/flags';
var FEDM_PROD_BASE_URL = exports.FEDM_PROD_BASE_URL = 'https://api.atlassian-us-gov-mod.com/flags';
var GATEWAY_BASE_URL = exports.GATEWAY_BASE_URL = '/gateway/api/flags';
var Fetcher = exports.default = /*#__PURE__*/function () {
  function Fetcher() {
    (0, _classCallCheck2.default)(this, Fetcher);
  }
  return (0, _createClass2.default)(Fetcher, null, [{
    key: "fetchClientSdk",
    value: function () {
      var _fetchClientSdk = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(fetcherOptions) {
        var targetApp, url;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              targetApp = fetcherOptions.targetApp;
              url = "/api/v2/frontend/clientSdkKey/".concat(targetApp);
              _context.prev = 2;
              _context.next = 5;
              return this.fetchRequest(url, 'GET', fetcherOptions);
            case 5:
              return _context.abrupt("return", _context.sent);
            case 8:
              _context.prev = 8;
              _context.t0 = _context["catch"](2);
              if (!(_context.t0 instanceof Error)) {
                _context.next = 12;
                break;
              }
              throw _context.t0;
            case 12:
              throw Error('Failed to retrieve client sdk key');
            case 13:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[2, 8]]);
      }));
      function fetchClientSdk(_x) {
        return _fetchClientSdk.apply(this, arguments);
      }
      return fetchClientSdk;
    }()
  }, {
    key: "fetchExperimentValues",
    value: function () {
      var _fetchExperimentValues = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(fetcherOptions, identifiers, customAttributes) {
        var requestBody;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              requestBody = {
                identifiers: identifiers,
                customAttributes: customAttributes,
                targetApp: fetcherOptions.targetApp
              };
              _context2.prev = 1;
              _context2.next = 4;
              return this.fetchRequest('/api/v2/frontend/experimentValues', 'POST', fetcherOptions, requestBody);
            case 4:
              return _context2.abrupt("return", _context2.sent);
            case 7:
              _context2.prev = 7;
              _context2.t0 = _context2["catch"](1);
              if (!(_context2.t0 instanceof Error)) {
                _context2.next = 11;
                break;
              }
              throw _context2.t0;
            case 11:
              throw Error('Failed to retrieve experiment values');
            case 12:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this, [[1, 7]]);
      }));
      function fetchExperimentValues(_x2, _x3, _x4) {
        return _fetchExperimentValues.apply(this, arguments);
      }
      return fetchExperimentValues;
    }()
  }, {
    key: "handleResponseError",
    value: function () {
      var _handleResponseError = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(response) {
        var body;
        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              if (response.ok) {
                _context3.next = 5;
                break;
              }
              _context3.next = 3;
              return response.text();
            case 3:
              body = _context3.sent;
              throw new _errors.ResponseError("Non 2xx response status received, status: ".concat(response.status, ", body: ").concat(JSON.stringify(body)));
            case 5:
              if (!(response.status === 204)) {
                _context3.next = 7;
                break;
              }
              throw new _errors.ResponseError('Unexpected 204 response');
            case 7:
            case "end":
              return _context3.stop();
          }
        }, _callee3);
      }));
      function handleResponseError(_x5) {
        return _handleResponseError.apply(this, arguments);
      }
      return handleResponseError;
    }()
  }, {
    key: "extractResponseBody",
    value: function () {
      var _extractResponseBody = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4(response) {
        var value;
        return _regenerator.default.wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              _context4.next = 2;
              return response.text();
            case 2:
              value = _context4.sent;
              return _context4.abrupt("return", JSON.parse(value));
            case 4:
            case "end":
              return _context4.stop();
          }
        }, _callee4);
      }));
      function extractResponseBody(_x6) {
        return _extractResponseBody.apply(this, arguments);
      }
      return extractResponseBody;
    }()
  }, {
    key: "getBaseUrl",
    value: function getBaseUrl(serviceEnv) {
      var useGatewayUrl = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var perimeter = arguments.length > 2 ? arguments[2] : undefined;
      if (useGatewayUrl) {
        return GATEWAY_BASE_URL;
      }
      if (perimeter === _types.PerimeterType.FEDRAMP_MODERATE) {
        switch (serviceEnv) {
          case _types.FeatureGateEnvironment.Production:
            return FEDM_PROD_BASE_URL;
          case _types.FeatureGateEnvironment.Staging:
            return FEDM_STAGING_BASE_URL;
          default:
            throw new Error("Invalid environment \"".concat(serviceEnv, "\" for \"").concat(perimeter, "\" perimeter"));
        }
      } else if (perimeter === _types.PerimeterType.COMMERCIAL) {
        switch (serviceEnv) {
          case _types.FeatureGateEnvironment.Development:
            return DEV_BASE_URL;
          case _types.FeatureGateEnvironment.Staging:
            return STAGING_BASE_URL;
          default:
            return PROD_BASE_URL;
        }
      } else {
        throw new Error("Invalid perimeter \"".concat(perimeter, "\""));
      }
    }
  }, {
    key: "fetchRequest",
    value: function () {
      var _fetchRequest = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee5(path, method, fetcherOptions, body) {
        var baseUrl, fetchTimeout, abortSignal, abortController, response;
        return _regenerator.default.wrap(function _callee5$(_context5) {
          while (1) switch (_context5.prev = _context5.next) {
            case 0:
              baseUrl = Fetcher.getBaseUrl(fetcherOptions.environment, fetcherOptions.useGatewayURL, fetcherOptions.perimeter);
              fetchTimeout = fetcherOptions.fetchTimeoutMs || DEFAULT_REQUEST_TIMEOUT_MS;
              if (AbortSignal.timeout) {
                abortSignal = AbortSignal.timeout(fetchTimeout);
              } else if (AbortController) {
                abortController = new AbortController();
                abortSignal = abortController.signal;
                setTimeout(function () {
                  return abortController.abort();
                }, fetchTimeout);
              }
              _context5.next = 5;
              return fetch("".concat(baseUrl).concat(path), _objectSpread({
                method: method,
                headers: {
                  'Content-Type': 'application/json',
                  'X-Client-Name': 'feature-gate-js-client',
                  'X-Client-Version': _version.CLIENT_VERSION,
                  'X-API-KEY': fetcherOptions.apiKey
                },
                signal: abortSignal
              }, body && {
                body: JSON.stringify(body)
              }));
            case 5:
              response = _context5.sent;
              _context5.next = 8;
              return this.handleResponseError(response);
            case 8:
              _context5.next = 10;
              return this.extractResponseBody(response);
            case 10:
              return _context5.abrupt("return", _context5.sent);
            case 11:
            case "end":
              return _context5.stop();
          }
        }, _callee5, this);
      }));
      function fetchRequest(_x7, _x8, _x9, _x10) {
        return _fetchRequest.apply(this, arguments);
      }
      return fetchRequest;
    }()
  }]);
}();