/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import React, { type ReactNode } from 'react';
import type { BasePrimitiveProps, BleedSpaceToken } from './types';
export type BleedProps = {
    /**
     * Elements to be rendered inside the Flex.
     */
    children: ReactNode;
    /**
     * Bleed along both axis.
     */
    all?: BleedSpaceToken;
    /**
     * Bleed along the inline axis.
     */
    inline?: BleedSpaceToken;
    /**
     * Bleed along the block axis
     */
    block?: BleedSpaceToken;
} & BasePrimitiveProps;
/**
 * __Bleed__
 *
 * `Bleed` is a primitive layout component that controls negative whitespace.
 *
 * - [Examples](https://atlassian.design/components/primitives/bleed/examples)
 * - [Code](https://atlassian.design/components/primitives/bleed/code)
 */
declare const Bleed: React.MemoExoticComponent<({ children, testId, inline, block, all, xcss }: BleedProps) => JSX.Element>;
export default Bleed;
