/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.internal;

import java.lang.ref.SoftReference;
import java.util.Stack;
import java.util.function.Supplier;

public class SoftPool<T> {
    final ThreadLocal<SoftReference<Stack<T>>> threadLocalStack;
    private final Supplier<T> initializer;
    static final int MaxIdle = 12;

    public SoftPool(Supplier<T> initializer) {
        this.initializer = initializer;
        this.threadLocalStack = ThreadLocal.withInitial(() -> new SoftReference(new Stack()));
    }

    public T borrow() {
        Stack<T> stack = this.getStack();
        if (!stack.isEmpty()) {
            return stack.pop();
        }
        return this.initializer.get();
    }

    public void release(T value) {
        Stack<T> stack = this.getStack();
        if (stack.size() < 12) {
            stack.push(value);
        }
    }

    Stack<T> getStack() {
        Stack<Object> stack = this.threadLocalStack.get().get();
        if (stack == null) {
            stack = new Stack();
            this.threadLocalStack.set(new SoftReference<Stack<T>>(stack));
        }
        return stack;
    }
}

