/*
 * Decompiled with CFR 0.152.
 */
package mill.api;

import java.io.Serializable;
import java.util.concurrent.Semaphore;
import mill.moduledefs.Scaladoc;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@Scaladoc(value="/**\n * A combination lock & cache; users provide a key, value-factory, and a\n * body function to be called with the value. [[KeyedLockedCache]] ensures that\n * the body function is called with the computed/cached value sequentially.\n */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005caB\t\u0013!\u0003\r\na\u0006\u0005\u0006?\u00011\t\u0001I\u0004\u0006+JA\tA\u0016\u0004\u0006#IA\t\u0001\u0017\u0005\u00063\u000e!\tA\u0017\u0004\u00057\u000e\u0001A\f\u0003\u0005b\u000b\t\u0005\t\u0015!\u0003c\u0011!)WA!A!\u0002\u0013\u0011\u0007\"B-\u0006\t\u00031\u0007bB6\u0006\u0005\u0004%I\u0001\u001c\u0005\u0007g\u0016\u0001\u000b\u0011B7\t\u000fQ,!\u0019!C\u0001k\"1q0\u0002Q\u0001\nYD\u0011\"!\u0001\u0006\u0001\u0004%\t!a\u0001\t\u0013\u0005]Q\u00011A\u0005\u0002\u0005e\u0001\u0002CA\u0013\u000b\u0001\u0006K!!\u0002\t\r})A\u0011AA\u0014\u0005AYU-_3e\u0019>\u001c7.\u001a3DC\u000eDWM\u0003\u0002\u0014)\u0005\u0019\u0011\r]5\u000b\u0003U\tA!\\5mY\u000e\u0001QC\u0001\r6'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0010o&$\bnQ1dQ\u0016$g+\u00197vKV\u0011\u0011E\n\u000b\u0003Eq\"\"aI\u001c\u0015\u0005\u0011z\u0003CA\u0013'\u0019\u0001!QaJ\u0001C\u0002!\u0012\u0011AV\t\u0003S1\u0002\"A\u0007\u0016\n\u0005-Z\"a\u0002(pi\"Lgn\u001a\t\u000355J!AL\u000e\u0003\u0007\u0005s\u0017\u0010C\u00031\u0003\u0001\u0007\u0011'\u0001\u0002geA!!D\r\u001b%\u0013\t\u00194DA\u0005Gk:\u001cG/[8ocA\u0011Q%\u000e\u0003\u0006m\u0001\u0011\r\u0001\u000b\u0002\u0002)\"1\u0001(\u0001CA\u0002e\n\u0011A\u001a\t\u00045i\"\u0014BA\u001e\u001c\u0005!a$-\u001f8b[\u0016t\u0004\"B\u001f\u0002\u0001\u0004q\u0014aA6fsB\u0011!dP\u0005\u0003\u0001n\u0011A\u0001T8oO\"\"\u0001A\u0011%J!\t\u0019e)D\u0001E\u0015\t)E#\u0001\u0006n_\u0012,H.\u001a3fMNL!a\u0012#\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f\u0013AS\u0001\u0002Z>R#F\u0003\u0011+A\u0005\u00033m\\7cS:\fG/[8oA1|7m\u001b\u0011'A\r\f7\r[3<AU\u001cXM]:!aJ|g/\u001b3fA\u0005\u00043.Z=-AY\fG.^3.M\u0006\u001cGo\u001c:zY\u0001\ng\u000e\u001a\u0011b\u0015\u0001R\u0003EY8es\u00022WO\\2uS>t\u0007\u0005^8!E\u0016\u00043-\u00197mK\u0012\u0004s/\u001b;iAQDW\r\t<bYV,g\u0006I.\\\u0017\u0016LX\r\u001a'pG.,GmQ1dQ\u0016lV\fI3ogV\u0014Xm\u001d\u0011uQ\u0006$(\u0002\t\u0016!i\",\u0007EY8es\u00022WO\\2uS>t\u0007%[:!G\u0006dG.\u001a3!o&$\b\u000e\t;iK\u0002\u001aw.\u001c9vi\u0016$wfY1dQ\u0016$\u0007E^1mk\u0016\u00043/Z9vK:$\u0018.\u00197ms:R\u0001EK\u0018)\r\u0001au\n\u0015*T!\tQR*\u0003\u0002O7\tQA-\u001a9sK\u000e\fG/\u001a3\u0002\u000f5,7o]1hK\u0006\n\u0011+\u0001\u0012Vg\u0016\u0004S.\u001b7m]\u0005\u0004\u0018NL\"bG\",GMR1di>\u0014\u0018\u0010I5ogR,\u0017\rZ\u0001\u0006g&t7-Z\u0011\u0002)\u0006\tR*\u001b7mAMLgnY3!a9\n$GL\u001a\u0002!-+\u00170\u001a3M_\u000e\\W\rZ\"bG\",\u0007CA,\u0004\u001b\u0005\u00112CA\u0002\u001a\u0003\u0019a\u0014N\\5u}Q\taK\u0001\nSC:$w.\u001c\"pk:$W\rZ\"bG\",WCA/a'\r)\u0011D\u0018\t\u0004/\u0002y\u0006CA\u0013a\t\u00151TA1\u0001)\u00039Aw\u000e\u001e)be\u0006dG.\u001a7jg6\u0004\"AG2\n\u0005\u0011\\\"aA%oi\u0006i1m\u001c7e\u0007\u0006\u001c\u0007.Z*ju\u0016$2aZ5k!\rAWaX\u0007\u0002\u0007!)\u0011\r\u0003a\u0001E\")Q\r\u0003a\u0001E\u00061!/\u00198e_6,\u0012!\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0003an\tA!\u001e;jY&\u0011!o\u001c\u0002\u0007%\u0006tGm\\7\u0002\u000fI\fg\u000eZ8nA\u0005I\u0011M^1jY\u0006\u0014G.Z\u000b\u0002mB\u0011q/`\u0007\u0002q*\u0011\u0011P_\u0001\u000bG>t7-\u001e:sK:$(B\u00019|\u0015\u0005a\u0018\u0001\u00026bm\u0006L!A =\u0003\u0013M+W.\u00199i_J,\u0017AC1wC&d\u0017M\u00197fA\u0005)1-Y2iKV\u0011\u0011Q\u0001\t\u00065\u0005\u001d\u00111B\u0005\u0004\u0003\u0013Y\"!B!se\u0006L\b#\u0002\u000e\u0002\u000e\u0005E\u0011bAA\b7\t1q\n\u001d;j_:\u0004RAGA\n}}K1!!\u0006\u001c\u0005\u0019!V\u000f\u001d7fe\u0005I1-Y2iK~#S-\u001d\u000b\u0005\u00037\t\t\u0003E\u0002\u001b\u0003;I1!a\b\u001c\u0005\u0011)f.\u001b;\t\u0013\u0005\rb\"!AA\u0002\u0005\u0015\u0011a\u0001=%c\u000511-Y2iK\u0002*B!!\u000b\u00022Q!\u00111FA\u001e)\u0011\ti#a\u000e\u0015\t\u0005=\u00121\u0007\t\u0004K\u0005EB!B\u0014\u0011\u0005\u0004A\u0003B\u0002\u0019\u0011\u0001\u0004\t)\u0004E\u0003\u001be}\u000by\u0003C\u00049!\u0011\u0005\r!!\u000f\u0011\u0007iQt\fC\u0003>!\u0001\u0007a\b\u000b\u0004\u0004\u0019>\u0003&k\u0015\u0015\u0007\u00051{\u0005KU*")
public interface KeyedLockedCache<T> {
    public <V> V withCachedValue(long var1, Function0<T> var3, Function1<T, V> var4);

    public static class RandomBoundedCache<T>
    implements KeyedLockedCache<T> {
        private final Random random = new Random(313373);
        private final Semaphore available;
        private Option<Tuple2<Object, T>>[] cache;

        private Random random() {
            return this.random;
        }

        public Semaphore available() {
            return this.available;
        }

        public Option<Tuple2<Object, T>>[] cache() {
            return this.cache;
        }

        public void cache_$eq(Option<Tuple2<Object, T>>[] x$1) {
            this.cache = x$1;
        }

        @Override
        public <V> V withCachedValue(long key2, Function0<T> f, Function1<T, V> f2) {
            T t;
            this.available().acquire();
            RandomBoundedCache randomBoundedCache = this;
            synchronized (randomBoundedCache) {
                T t2;
                Object qual$1 = Predef$.MODULE$.refArrayOps(this.cache());
                Function1<Option, Object> & Serializable x$12 = (Function1<Option, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.exists((Function1<Tuple2, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(RandomBoundedCache.$anonfun$withCachedValue$2(key$1, x$2))));
                int x$2 = ArrayOps$.MODULE$.indexWhere$default$2$extension(qual$1);
                int n = ArrayOps$.MODULE$.indexWhere$extension(qual$1, x$12, x$2);
                switch (n) {
                    case -1: {
                        t2 = f.apply();
                        break;
                    }
                    default: {
                        Tuple2<Object, T> tuple2 = this.cache()[n].get();
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        long k = tuple2._1$mcJ$sp();
                        T v = tuple2._2();
                        Tuple2<Long, T> tuple22 = new Tuple2<Long, T>(BoxesRunTime.boxToLong(k), v);
                        long k2 = tuple22._1$mcJ$sp();
                        T v2 = tuple22._2();
                        this.cache()[n] = None$.MODULE$;
                        t2 = v2;
                        break;
                    }
                }
                t = t2;
            }
            T pickedValue = t;
            V result2 = f2.apply(pickedValue);
            RandomBoundedCache randomBoundedCache2 = this;
            synchronized (randomBoundedCache2) {
                Object qual$2 = Predef$.MODULE$.refArrayOps(this.cache());
                Function1<Option, Object> & Serializable x$3 = (Function1<Option, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.isEmpty());
                int x$42 = ArrayOps$.MODULE$.indexWhere$default$2$extension(qual$2);
                int n = ArrayOps$.MODULE$.indexWhere$extension(qual$2, x$3, x$42);
                switch (n) {
                    case -1: {
                        this.cache()[this.random().nextInt((int)this.cache().length)] = new Some<Tuple2<Long, T>>(new Tuple2<Long, T>(BoxesRunTime.boxToLong(key2), pickedValue));
                        break;
                    }
                    default: {
                        this.cache()[n] = new Some<Tuple2<Long, T>>(new Tuple2<Long, T>(BoxesRunTime.boxToLong(key2), pickedValue));
                        break;
                    }
                }
            }
            this.available().release();
            return result2;
        }

        public static final /* synthetic */ boolean $anonfun$withCachedValue$2(long key$1, Tuple2 x$2) {
            return x$2._1$mcJ$sp() == key$1;
        }

        public RandomBoundedCache(int hotParallelism, int coldCacheSize) {
            this.available = new Semaphore(hotParallelism);
            this.cache = (Option[])Array$.MODULE$.fill(coldCacheSize, (Function0<None$> & Serializable)() -> None$.MODULE$, ClassTag$.MODULE$.apply(Option.class));
        }
    }
}

