#!/usr/bin/env python
# Copyright (C) 2013-2022 The ESPResSo project
# Copyright (C) 2012 Olaf Lenz
#
# This file is part of ESPResSo.
#
# ESPResSo is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# ESPResSo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# This script generates the file doxy-features
#
import sys
import os

import time

if len(sys.argv) != 3:
    print(f"Usage: {sys.argv[0]} CONFIG_PATH DOXYCONFIG", file=sys.stderr)
    exit(2)

configpath, configfilename = sys.argv[1:3]

# find featuredefs.py
sys.path.append(configpath)
import featuredefs

deffilename = os.path.join(configpath, 'features.def')

print(f"Reading definitions from {deffilename}...")
defs = featuredefs.defs(deffilename)
print("Done.")

print(f"Writing {configfilename}...")
configfile = open(configfilename, 'w')

configfile.write(f"""# WARNING: This file was autogenerated by
#
#   {sys.argv[0]}
#   on {time.asctime()}
#   Do not modify it or your changes will be overwritten!
#   Modify features.def instead.
#
#  This file is needed so that doxygen will generate documentation for
#  all functions of all features.
PREDEFINED = \\
""")

for feature in sorted(defs.allfeatures):
    configfile.write(f"  {feature} \\\n")
configfile.write("  DOXYGEN\n")

configfile.close()
print("Done.")
