// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/schedule_service.proto

#include "google/cloud/aiplatform/v1/schedule_connection.h"
#include "google/cloud/aiplatform/v1/internal/schedule_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/schedule_option_defaults.h"
#include "google/cloud/aiplatform/v1/internal/schedule_stub_factory.h"
#include "google/cloud/aiplatform/v1/internal/schedule_tracing_connection.h"
#include "google/cloud/aiplatform/v1/schedule_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ScheduleServiceConnection::~ScheduleServiceConnection() = default;

StatusOr<google::cloud::aiplatform::v1::Schedule>
ScheduleServiceConnection::CreateSchedule(
    google::cloud::aiplatform::v1::CreateScheduleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
ScheduleServiceConnection::DeleteSchedule(
    google::cloud::aiplatform::v1::DeleteScheduleRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ScheduleServiceConnection::DeleteSchedule(
    NoAwaitTag, google::cloud::aiplatform::v1::DeleteScheduleRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
ScheduleServiceConnection::DeleteSchedule(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::Schedule>
ScheduleServiceConnection::GetSchedule(
    google::cloud::aiplatform::v1::GetScheduleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::Schedule>
ScheduleServiceConnection::ListSchedules(
    google::cloud::aiplatform::v1::
        ListSchedulesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Schedule>>();
}

Status ScheduleServiceConnection::PauseSchedule(
    google::cloud::aiplatform::v1::PauseScheduleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ScheduleServiceConnection::ResumeSchedule(
    google::cloud::aiplatform::v1::ResumeScheduleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::Schedule>
ScheduleServiceConnection::UpdateSchedule(
    google::cloud::aiplatform::v1::UpdateScheduleRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ScheduleServiceConnection> MakeScheduleServiceConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ScheduleServicePolicyOptionList>(options,
                                                                  __func__);
  options = aiplatform_v1_internal::ScheduleServiceDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = aiplatform_v1_internal::CreateDefaultScheduleServiceStub(
      std::move(auth), options);
  return aiplatform_v1_internal::MakeScheduleServiceTracingConnection(
      std::make_shared<aiplatform_v1_internal::ScheduleServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
