// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orchestration/airflow/service/v1/environments.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPOSER_V1_MOCKS_MOCK_ENVIRONMENTS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPOSER_V1_MOCKS_MOCK_ENVIRONMENTS_CONNECTION_H

#include "google/cloud/composer/v1/environments_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace composer_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `EnvironmentsConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `EnvironmentsClient`. To do so,
 * construct an object of type `EnvironmentsClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockEnvironmentsConnection : public composer_v1::EnvironmentsConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateEnvironment(Matcher<google::cloud::orchestration::airflow::service::v1::CreateEnvironmentRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::orchestration::airflow::service::v1::Environment>>,
      CreateEnvironment,
      (google::cloud::orchestration::airflow::service::v1::
           CreateEnvironmentRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateEnvironment(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreateEnvironment,
              (NoAwaitTag, google::cloud::orchestration::airflow::service::v1::
                               CreateEnvironmentRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateEnvironment(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::orchestration::airflow::service::v1::Environment>>,
      CreateEnvironment, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::orchestration::airflow::service::v1::Environment>,
      GetEnvironment,
      (google::cloud::orchestration::airflow::service::v1::
           GetEnvironmentRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<
          google::cloud::orchestration::airflow::service::v1::Environment>),
      ListEnvironments,
      (google::cloud::orchestration::airflow::service::v1::
           ListEnvironmentsRequest request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateEnvironment(Matcher<google::cloud::orchestration::airflow::service::v1::UpdateEnvironmentRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::orchestration::airflow::service::v1::Environment>>,
      UpdateEnvironment,
      (google::cloud::orchestration::airflow::service::v1::
           UpdateEnvironmentRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateEnvironment(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdateEnvironment,
              (NoAwaitTag, google::cloud::orchestration::airflow::service::v1::
                               UpdateEnvironmentRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateEnvironment(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<
          google::cloud::orchestration::airflow::service::v1::Environment>>,
      UpdateEnvironment, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteEnvironment(Matcher<google::cloud::orchestration::airflow::service::v1::DeleteEnvironmentRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::orchestration::airflow::service::
                                  v1::OperationMetadata>>,
              DeleteEnvironment,
              (google::cloud::orchestration::airflow::service::v1::
                   DeleteEnvironmentRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteEnvironment(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteEnvironment,
              (NoAwaitTag, google::cloud::orchestration::airflow::service::v1::
                               DeleteEnvironmentRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteEnvironment(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::orchestration::airflow::service::
                                  v1::OperationMetadata>>,
              DeleteEnvironment,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(StatusOr<google::cloud::orchestration::airflow::service::v1::
                           ExecuteAirflowCommandResponse>,
              ExecuteAirflowCommand,
              (google::cloud::orchestration::airflow::service::v1::
                   ExecuteAirflowCommandRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::orchestration::airflow::service::v1::
                           StopAirflowCommandResponse>,
              StopAirflowCommand,
              (google::cloud::orchestration::airflow::service::v1::
                   StopAirflowCommandRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::orchestration::airflow::service::v1::
                           PollAirflowCommandResponse>,
              PollAirflowCommand,
              (google::cloud::orchestration::airflow::service::v1::
                   PollAirflowCommandRequest const& request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::orchestration::airflow::service::v1::
                       ListWorkloadsResponse::ComposerWorkload>),
      ListWorkloads,
      (google::cloud::orchestration::airflow::service::v1::ListWorkloadsRequest
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CheckUpgrade(Matcher<google::cloud::orchestration::airflow::service::v1::CheckUpgradeRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::orchestration::airflow::service::
                                  v1::CheckUpgradeResponse>>,
              CheckUpgrade,
              (google::cloud::orchestration::airflow::service::v1::
                   CheckUpgradeRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CheckUpgrade(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CheckUpgrade,
              (NoAwaitTag, google::cloud::orchestration::airflow::service::v1::
                               CheckUpgradeRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CheckUpgrade(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::orchestration::airflow::service::
                                  v1::CheckUpgradeResponse>>,
              CheckUpgrade, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::orchestration::airflow::service::v1::
                           UserWorkloadsSecret>,
              CreateUserWorkloadsSecret,
              (google::cloud::orchestration::airflow::service::v1::
                   CreateUserWorkloadsSecretRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::orchestration::airflow::service::v1::
                           UserWorkloadsSecret>,
              GetUserWorkloadsSecret,
              (google::cloud::orchestration::airflow::service::v1::
                   GetUserWorkloadsSecretRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::orchestration::airflow::service::v1::
                               UserWorkloadsSecret>),
              ListUserWorkloadsSecrets,
              (google::cloud::orchestration::airflow::service::v1::
                   ListUserWorkloadsSecretsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::orchestration::airflow::service::v1::
                           UserWorkloadsSecret>,
              UpdateUserWorkloadsSecret,
              (google::cloud::orchestration::airflow::service::v1::
                   UpdateUserWorkloadsSecretRequest const& request),
              (override));

  MOCK_METHOD(Status, DeleteUserWorkloadsSecret,
              (google::cloud::orchestration::airflow::service::v1::
                   DeleteUserWorkloadsSecretRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::orchestration::airflow::service::v1::
                           UserWorkloadsConfigMap>,
              CreateUserWorkloadsConfigMap,
              (google::cloud::orchestration::airflow::service::v1::
                   CreateUserWorkloadsConfigMapRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::orchestration::airflow::service::v1::
                           UserWorkloadsConfigMap>,
              GetUserWorkloadsConfigMap,
              (google::cloud::orchestration::airflow::service::v1::
                   GetUserWorkloadsConfigMapRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::orchestration::airflow::service::v1::
                               UserWorkloadsConfigMap>),
              ListUserWorkloadsConfigMaps,
              (google::cloud::orchestration::airflow::service::v1::
                   ListUserWorkloadsConfigMapsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::orchestration::airflow::service::v1::
                           UserWorkloadsConfigMap>,
              UpdateUserWorkloadsConfigMap,
              (google::cloud::orchestration::airflow::service::v1::
                   UpdateUserWorkloadsConfigMapRequest const& request),
              (override));

  MOCK_METHOD(Status, DeleteUserWorkloadsConfigMap,
              (google::cloud::orchestration::airflow::service::v1::
                   DeleteUserWorkloadsConfigMapRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// SaveSnapshot(Matcher<google::cloud::orchestration::airflow::service::v1::SaveSnapshotRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::orchestration::airflow::service::
                                  v1::SaveSnapshotResponse>>,
              SaveSnapshot,
              (google::cloud::orchestration::airflow::service::v1::
                   SaveSnapshotRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, SaveSnapshot(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, SaveSnapshot,
              (NoAwaitTag, google::cloud::orchestration::airflow::service::v1::
                               SaveSnapshotRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, SaveSnapshot(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::orchestration::airflow::service::
                                  v1::SaveSnapshotResponse>>,
              SaveSnapshot, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// LoadSnapshot(Matcher<google::cloud::orchestration::airflow::service::v1::LoadSnapshotRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::orchestration::airflow::service::
                                  v1::LoadSnapshotResponse>>,
              LoadSnapshot,
              (google::cloud::orchestration::airflow::service::v1::
                   LoadSnapshotRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, LoadSnapshot(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, LoadSnapshot,
              (NoAwaitTag, google::cloud::orchestration::airflow::service::v1::
                               LoadSnapshotRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, LoadSnapshot(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::orchestration::airflow::service::
                                  v1::LoadSnapshotResponse>>,
              LoadSnapshot, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DatabaseFailover(Matcher<google::cloud::orchestration::airflow::service::v1::DatabaseFailoverRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::orchestration::airflow::service::
                                  v1::DatabaseFailoverResponse>>,
              DatabaseFailover,
              (google::cloud::orchestration::airflow::service::v1::
                   DatabaseFailoverRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DatabaseFailover(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DatabaseFailover,
              (NoAwaitTag, google::cloud::orchestration::airflow::service::v1::
                               DatabaseFailoverRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DatabaseFailover(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::orchestration::airflow::service::
                                  v1::DatabaseFailoverResponse>>,
              DatabaseFailover,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(StatusOr<google::cloud::orchestration::airflow::service::v1::
                           FetchDatabasePropertiesResponse>,
              FetchDatabaseProperties,
              (google::cloud::orchestration::airflow::service::v1::
                   FetchDatabasePropertiesRequest const& request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace composer_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPOSER_V1_MOCKS_MOCK_ENVIRONMENTS_CONNECTION_H
