// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_instance_groups/v1/region_instance_groups.proto

#include "google/cloud/compute/region_instance_groups/v1/internal/region_instance_groups_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_region_instance_groups_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RegionInstanceGroupsTracingConnection::RegionInstanceGroupsTracingConnection(
    std::shared_ptr<
        compute_region_instance_groups_v1::RegionInstanceGroupsConnection>
        child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::cpp::compute::v1::InstanceGroup>
RegionInstanceGroupsTracingConnection::GetInstanceGroup(
    google::cloud::cpp::compute::region_instance_groups::v1::
        GetInstanceGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instance_groups_v1::RegionInstanceGroupsConnection::"
      "GetInstanceGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstanceGroup(request));
}

StreamRange<google::cloud::cpp::compute::v1::InstanceGroup>
RegionInstanceGroupsTracingConnection::ListRegionInstanceGroups(
    google::cloud::cpp::compute::region_instance_groups::v1::
        ListRegionInstanceGroupsRequest request) {
  auto span = internal::MakeSpan(
      "compute_region_instance_groups_v1::RegionInstanceGroupsConnection::"
      "ListRegionInstanceGroups");
  internal::OTelScope scope(span);
  auto sr = child_->ListRegionInstanceGroups(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::InstanceGroup>(std::move(span),
                                                      std::move(sr));
}

StreamRange<google::cloud::cpp::compute::v1::InstanceWithNamedPorts>
RegionInstanceGroupsTracingConnection::ListInstances(
    google::cloud::cpp::compute::region_instance_groups::v1::
        ListInstancesRequest request) {
  auto span = internal::MakeSpan(
      "compute_region_instance_groups_v1::RegionInstanceGroupsConnection::"
      "ListInstances");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstances(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::InstanceWithNamedPorts>(std::move(span),
                                                               std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupsTracingConnection::SetNamedPorts(
    google::cloud::cpp::compute::region_instance_groups::v1::
        SetNamedPortsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instance_groups_v1::RegionInstanceGroupsConnection::"
      "SetNamedPorts");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetNamedPorts(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionInstanceGroupsTracingConnection::SetNamedPorts(
    NoAwaitTag, google::cloud::cpp::compute::region_instance_groups::v1::
                    SetNamedPortsRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_instance_groups_v1::RegionInstanceGroupsConnection::"
      "SetNamedPorts");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->SetNamedPorts(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionInstanceGroupsTracingConnection::SetNamedPorts(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_region_instance_groups_v1::RegionInstanceGroupsConnection::"
      "SetNamedPorts");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetNamedPorts(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<
    compute_region_instance_groups_v1::RegionInstanceGroupsConnection>
MakeRegionInstanceGroupsTracingConnection(
    std::shared_ptr<
        compute_region_instance_groups_v1::RegionInstanceGroupsConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<RegionInstanceGroupsTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_instance_groups_v1_internal
}  // namespace cloud
}  // namespace google
