// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/v1/eventarc.proto

#include "google/cloud/eventarc/v1/internal/eventarc_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace eventarc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

EventarcTracingConnection::EventarcTracingConnection(
    std::shared_ptr<eventarc_v1::EventarcConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::eventarc::v1::Trigger>
EventarcTracingConnection::GetTrigger(
    google::cloud::eventarc::v1::GetTriggerRequest const& request) {
  auto span = internal::MakeSpan("eventarc_v1::EventarcConnection::GetTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTrigger(request));
}

StreamRange<google::cloud::eventarc::v1::Trigger>
EventarcTracingConnection::ListTriggers(
    google::cloud::eventarc::v1::ListTriggersRequest request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::ListTriggers");
  internal::OTelScope scope(span);
  auto sr = child_->ListTriggers(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::eventarc::v1::Trigger>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcTracingConnection::CreateTrigger(
    google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::CreateTrigger");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateTrigger(request));
}

StatusOr<google::longrunning::Operation>
EventarcTracingConnection::CreateTrigger(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateTriggerRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::CreateTrigger");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateTrigger(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcTracingConnection::CreateTrigger(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::CreateTrigger");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateTrigger(operation));
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcTracingConnection::UpdateTrigger(
    google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::UpdateTrigger");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateTrigger(request));
}

StatusOr<google::longrunning::Operation>
EventarcTracingConnection::UpdateTrigger(
    NoAwaitTag,
    google::cloud::eventarc::v1::UpdateTriggerRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::UpdateTrigger");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateTrigger(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcTracingConnection::UpdateTrigger(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::UpdateTrigger");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateTrigger(operation));
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcTracingConnection::DeleteTrigger(
    google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::DeleteTrigger");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteTrigger(request));
}

StatusOr<google::longrunning::Operation>
EventarcTracingConnection::DeleteTrigger(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteTriggerRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::DeleteTrigger");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteTrigger(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::eventarc::v1::Trigger>>
EventarcTracingConnection::DeleteTrigger(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::DeleteTrigger");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteTrigger(operation));
}

StatusOr<google::cloud::eventarc::v1::Channel>
EventarcTracingConnection::GetChannel(
    google::cloud::eventarc::v1::GetChannelRequest const& request) {
  auto span = internal::MakeSpan("eventarc_v1::EventarcConnection::GetChannel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetChannel(request));
}

StreamRange<google::cloud::eventarc::v1::Channel>
EventarcTracingConnection::ListChannels(
    google::cloud::eventarc::v1::ListChannelsRequest request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::ListChannels");
  internal::OTelScope scope(span);
  auto sr = child_->ListChannels(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::eventarc::v1::Channel>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcTracingConnection::CreateChannel(
    google::cloud::eventarc::v1::CreateChannelRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::CreateChannel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateChannel(request));
}

StatusOr<google::longrunning::Operation>
EventarcTracingConnection::CreateChannel(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateChannelRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::CreateChannel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateChannel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcTracingConnection::CreateChannel(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::CreateChannel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateChannel(operation));
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcTracingConnection::UpdateChannel(
    google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::UpdateChannel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateChannel(request));
}

StatusOr<google::longrunning::Operation>
EventarcTracingConnection::UpdateChannel(
    NoAwaitTag,
    google::cloud::eventarc::v1::UpdateChannelRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::UpdateChannel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateChannel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcTracingConnection::UpdateChannel(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::UpdateChannel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateChannel(operation));
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcTracingConnection::DeleteChannel(
    google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::DeleteChannel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteChannel(request));
}

StatusOr<google::longrunning::Operation>
EventarcTracingConnection::DeleteChannel(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteChannelRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::DeleteChannel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteChannel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::eventarc::v1::Channel>>
EventarcTracingConnection::DeleteChannel(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::DeleteChannel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteChannel(operation));
}

StatusOr<google::cloud::eventarc::v1::Provider>
EventarcTracingConnection::GetProvider(
    google::cloud::eventarc::v1::GetProviderRequest const& request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::GetProvider");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetProvider(request));
}

StreamRange<google::cloud::eventarc::v1::Provider>
EventarcTracingConnection::ListProviders(
    google::cloud::eventarc::v1::ListProvidersRequest request) {
  auto span =
      internal::MakeSpan("eventarc_v1::EventarcConnection::ListProviders");
  internal::OTelScope scope(span);
  auto sr = child_->ListProviders(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::eventarc::v1::Provider>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::eventarc::v1::ChannelConnection>
EventarcTracingConnection::GetChannelConnection(
    google::cloud::eventarc::v1::GetChannelConnectionRequest const& request) {
  auto span = internal::MakeSpan(
      "eventarc_v1::EventarcConnection::GetChannelConnection");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetChannelConnection(request));
}

StreamRange<google::cloud::eventarc::v1::ChannelConnection>
EventarcTracingConnection::ListChannelConnections(
    google::cloud::eventarc::v1::ListChannelConnectionsRequest request) {
  auto span = internal::MakeSpan(
      "eventarc_v1::EventarcConnection::ListChannelConnections");
  internal::OTelScope scope(span);
  auto sr = child_->ListChannelConnections(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::eventarc::v1::ChannelConnection>(std::move(span),
                                                      std::move(sr));
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcTracingConnection::CreateChannelConnection(
    google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "eventarc_v1::EventarcConnection::CreateChannelConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateChannelConnection(request));
}

StatusOr<google::longrunning::Operation>
EventarcTracingConnection::CreateChannelConnection(
    NoAwaitTag,
    google::cloud::eventarc::v1::CreateChannelConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "eventarc_v1::EventarcConnection::CreateChannelConnection");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateChannelConnection(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcTracingConnection::CreateChannelConnection(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "eventarc_v1::EventarcConnection::CreateChannelConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateChannelConnection(operation));
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcTracingConnection::DeleteChannelConnection(
    google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "eventarc_v1::EventarcConnection::DeleteChannelConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteChannelConnection(request));
}

StatusOr<google::longrunning::Operation>
EventarcTracingConnection::DeleteChannelConnection(
    NoAwaitTag,
    google::cloud::eventarc::v1::DeleteChannelConnectionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "eventarc_v1::EventarcConnection::DeleteChannelConnection");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteChannelConnection(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::eventarc::v1::ChannelConnection>>
EventarcTracingConnection::DeleteChannelConnection(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "eventarc_v1::EventarcConnection::DeleteChannelConnection");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteChannelConnection(operation));
}

StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
EventarcTracingConnection::GetGoogleChannelConfig(
    google::cloud::eventarc::v1::GetGoogleChannelConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "eventarc_v1::EventarcConnection::GetGoogleChannelConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGoogleChannelConfig(request));
}

StatusOr<google::cloud::eventarc::v1::GoogleChannelConfig>
EventarcTracingConnection::UpdateGoogleChannelConfig(
    google::cloud::eventarc::v1::UpdateGoogleChannelConfigRequest const&
        request) {
  auto span = internal::MakeSpan(
      "eventarc_v1::EventarcConnection::UpdateGoogleChannelConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateGoogleChannelConfig(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<eventarc_v1::EventarcConnection> MakeEventarcTracingConnection(
    std::shared_ptr<eventarc_v1::EventarcConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<EventarcTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc_v1_internal
}  // namespace cloud
}  // namespace google
