// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicecontrol/v2/service_controller.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICECONTROL_V2_SERVICE_CONTROLLER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICECONTROL_V2_SERVICE_CONTROLLER_CLIENT_H

#include "google/cloud/servicecontrol/v2/service_controller_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace servicecontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// [Service Control API
/// v2](https://cloud.google.com/service-infrastructure/docs/service-control/access-control)
///
/// Private Preview. This feature is only available for approved services.
///
/// This API provides admission control and telemetry reporting for services
/// that are integrated with [Service
/// Infrastructure](https://cloud.google.com/service-infrastructure).
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ServiceControllerClient {
 public:
  explicit ServiceControllerClient(
      std::shared_ptr<ServiceControllerConnection> connection,
      Options opts = {});
  ~ServiceControllerClient();

  ///@{
  /// @name Copy and move support
  ServiceControllerClient(ServiceControllerClient const&) = default;
  ServiceControllerClient& operator=(ServiceControllerClient const&) = default;
  ServiceControllerClient(ServiceControllerClient&&) = default;
  ServiceControllerClient& operator=(ServiceControllerClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(ServiceControllerClient const& a,
                         ServiceControllerClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ServiceControllerClient const& a,
                         ServiceControllerClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Private Preview. This feature is only available for approved services.
  ///
  /// This method provides admission control for services that are integrated
  /// with [Service
  /// Infrastructure](https://cloud.google.com/service-infrastructure). It checks
  /// whether an operation should be allowed based on the service configuration
  /// and relevant policies. It must be called before the operation is executed.
  /// For more information, see
  /// [Admission
  /// Control](https://cloud.google.com/service-infrastructure/docs/admission-control).
  ///
  /// NOTE: The admission control has an expected policy propagation delay of
  /// 60s. The caller **must** not depend on the most recent policy changes.
  ///
  /// NOTE: The admission control has a hard limit of 1 referenced resources
  /// per call. If an operation refers to more than 1 resources, the caller
  /// must call the Check method multiple times.
  ///
  /// This method requires the `servicemanagement.services.check` permission
  /// on the specified service. For more information, see
  /// [Service Control API Access
  /// Control](https://cloud.google.com/service-infrastructure/docs/service-control/access-control).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicecontrol.v2.CheckRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.servicecontrol.v2.CheckResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicecontrol.v2.CheckRequest]: @googleapis_reference_link{google/api/servicecontrol/v2/service_controller.proto#L104}
  /// [google.api.servicecontrol.v2.CheckResponse]: @googleapis_reference_link{google/api/servicecontrol/v2/service_controller.proto#L157}
  ///
  // clang-format on
  StatusOr<google::api::servicecontrol::v2::CheckResponse> Check(
      google::api::servicecontrol::v2::CheckRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Private Preview. This feature is only available for approved services.
  ///
  /// This method provides telemetry reporting for services that are integrated
  /// with [Service
  /// Infrastructure](https://cloud.google.com/service-infrastructure). It
  /// reports a list of operations that have occurred on a service. It must be
  /// called after the operations have been executed. For more information, see
  /// [Telemetry
  /// Reporting](https://cloud.google.com/service-infrastructure/docs/telemetry-reporting).
  ///
  /// NOTE: The telemetry reporting has a hard limit of 1000 operations and 1MB
  /// per Report call. It is recommended to have no more than 100 operations per
  /// call.
  ///
  /// This method requires the `servicemanagement.services.report` permission
  /// on the specified service. For more information, see
  /// [Service Control API Access
  /// Control](https://cloud.google.com/service-infrastructure/docs/service-control/access-control).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.api.servicecontrol.v2.ReportRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.api.servicecontrol.v2.ReportResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.api.servicecontrol.v2.ReportRequest]: @googleapis_reference_link{google/api/servicecontrol/v2/service_controller.proto#L168}
  /// [google.api.servicecontrol.v2.ReportResponse]: @googleapis_reference_link{google/api/servicecontrol/v2/service_controller.proto#L190}
  ///
  // clang-format on
  StatusOr<google::api::servicecontrol::v2::ReportResponse> Report(
      google::api::servicecontrol::v2::ReportRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<ServiceControllerConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicecontrol_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICECONTROL_V2_SERVICE_CONTROLLER_CLIENT_H
