/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.Trie2;
import com.ibm.icu.impl.Trie2_16;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Locale;

public final class UCaseProps {
    private static final byte[] flagsOffset;
    public static final int MAX_STRING_LENGTH = 31;
    public static final int LOC_ROOT = 1;
    static final int LOC_TURKISH = 2;
    static final int LOC_LITHUANIAN = 3;
    static final int LOC_GREEK = 4;
    public static final int LOC_DUTCH = 5;
    static final int LOC_ARMENIAN = 6;
    private static final String iDot = "i\u0307";
    private static final String jDot = "j\u0307";
    private static final String iOgonekDot = "\u012f\u0307";
    private static final String iDotGrave = "i\u0307\u0300";
    private static final String iDotAcute = "i\u0307\u0301";
    private static final String iDotTilde = "i\u0307\u0303";
    static final int FOLD_CASE_OPTIONS_MASK = 7;
    public static final StringBuilder dummyStringBuilder;
    private int[] indexes;
    private String exceptions;
    private char[] unfold;
    private Trie2_16 trie;
    private static final String DATA_NAME = "ucase";
    private static final String DATA_TYPE = "icu";
    private static final String DATA_FILE_NAME = "ucase.icu";
    private static final int FMT = 1665225541;
    private static final int IX_TRIE_SIZE = 2;
    private static final int IX_EXC_LENGTH = 3;
    private static final int IX_UNFOLD_LENGTH = 4;
    private static final int IX_TOP = 16;
    public static final int TYPE_MASK = 3;
    public static final int NONE = 0;
    public static final int LOWER = 1;
    public static final int UPPER = 2;
    public static final int TITLE = 3;
    static final int IGNORABLE = 4;
    private static final int EXCEPTION = 8;
    private static final int SENSITIVE = 16;
    private static final int DOT_MASK = 96;
    private static final int SOFT_DOTTED = 32;
    private static final int ABOVE = 64;
    private static final int OTHER_ACCENT = 96;
    private static final int DELTA_SHIFT = 7;
    private static final int EXC_SHIFT = 4;
    private static final int EXC_LOWER = 0;
    private static final int EXC_FOLD = 1;
    private static final int EXC_UPPER = 2;
    private static final int EXC_TITLE = 3;
    private static final int EXC_DELTA = 4;
    private static final int EXC_CLOSURE = 6;
    private static final int EXC_FULL_MAPPINGS = 7;
    private static final int EXC_DOUBLE_SLOTS = 256;
    private static final int EXC_NO_SIMPLE_CASE_FOLDING = 512;
    private static final int EXC_DELTA_IS_NEGATIVE = 1024;
    private static final int EXC_SENSITIVE = 2048;
    private static final int EXC_DOT_SHIFT = 7;
    private static final int EXC_CONDITIONAL_SPECIAL = 16384;
    private static final int EXC_CONDITIONAL_FOLD = 32768;
    private static final int FULL_LOWER = 15;
    private static final int CLOSURE_MAX_LENGTH = 15;
    private static final int UNFOLD_ROWS = 0;
    private static final int UNFOLD_ROW_WIDTH = 1;
    private static final int UNFOLD_STRING_WIDTH = 2;
    public static final UCaseProps INSTANCE;

    static {
        byte[] byArray = new byte[256];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 1;
        byArray[5] = 2;
        byArray[6] = 2;
        byArray[7] = 3;
        byArray[8] = 1;
        byArray[9] = 2;
        byArray[10] = 2;
        byArray[11] = 3;
        byArray[12] = 2;
        byArray[13] = 3;
        byArray[14] = 3;
        byArray[15] = 4;
        byArray[16] = 1;
        byArray[17] = 2;
        byArray[18] = 2;
        byArray[19] = 3;
        byArray[20] = 2;
        byArray[21] = 3;
        byArray[22] = 3;
        byArray[23] = 4;
        byArray[24] = 2;
        byArray[25] = 3;
        byArray[26] = 3;
        byArray[27] = 4;
        byArray[28] = 3;
        byArray[29] = 4;
        byArray[30] = 4;
        byArray[31] = 5;
        byArray[32] = 1;
        byArray[33] = 2;
        byArray[34] = 2;
        byArray[35] = 3;
        byArray[36] = 2;
        byArray[37] = 3;
        byArray[38] = 3;
        byArray[39] = 4;
        byArray[40] = 2;
        byArray[41] = 3;
        byArray[42] = 3;
        byArray[43] = 4;
        byArray[44] = 3;
        byArray[45] = 4;
        byArray[46] = 4;
        byArray[47] = 5;
        byArray[48] = 2;
        byArray[49] = 3;
        byArray[50] = 3;
        byArray[51] = 4;
        byArray[52] = 3;
        byArray[53] = 4;
        byArray[54] = 4;
        byArray[55] = 5;
        byArray[56] = 3;
        byArray[57] = 4;
        byArray[58] = 4;
        byArray[59] = 5;
        byArray[60] = 4;
        byArray[61] = 5;
        byArray[62] = 5;
        byArray[63] = 6;
        byArray[64] = 1;
        byArray[65] = 2;
        byArray[66] = 2;
        byArray[67] = 3;
        byArray[68] = 2;
        byArray[69] = 3;
        byArray[70] = 3;
        byArray[71] = 4;
        byArray[72] = 2;
        byArray[73] = 3;
        byArray[74] = 3;
        byArray[75] = 4;
        byArray[76] = 3;
        byArray[77] = 4;
        byArray[78] = 4;
        byArray[79] = 5;
        byArray[80] = 2;
        byArray[81] = 3;
        byArray[82] = 3;
        byArray[83] = 4;
        byArray[84] = 3;
        byArray[85] = 4;
        byArray[86] = 4;
        byArray[87] = 5;
        byArray[88] = 3;
        byArray[89] = 4;
        byArray[90] = 4;
        byArray[91] = 5;
        byArray[92] = 4;
        byArray[93] = 5;
        byArray[94] = 5;
        byArray[95] = 6;
        byArray[96] = 2;
        byArray[97] = 3;
        byArray[98] = 3;
        byArray[99] = 4;
        byArray[100] = 3;
        byArray[101] = 4;
        byArray[102] = 4;
        byArray[103] = 5;
        byArray[104] = 3;
        byArray[105] = 4;
        byArray[106] = 4;
        byArray[107] = 5;
        byArray[108] = 4;
        byArray[109] = 5;
        byArray[110] = 5;
        byArray[111] = 6;
        byArray[112] = 3;
        byArray[113] = 4;
        byArray[114] = 4;
        byArray[115] = 5;
        byArray[116] = 4;
        byArray[117] = 5;
        byArray[118] = 5;
        byArray[119] = 6;
        byArray[120] = 4;
        byArray[121] = 5;
        byArray[122] = 5;
        byArray[123] = 6;
        byArray[124] = 5;
        byArray[125] = 6;
        byArray[126] = 6;
        byArray[127] = 7;
        byArray[128] = 1;
        byArray[129] = 2;
        byArray[130] = 2;
        byArray[131] = 3;
        byArray[132] = 2;
        byArray[133] = 3;
        byArray[134] = 3;
        byArray[135] = 4;
        byArray[136] = 2;
        byArray[137] = 3;
        byArray[138] = 3;
        byArray[139] = 4;
        byArray[140] = 3;
        byArray[141] = 4;
        byArray[142] = 4;
        byArray[143] = 5;
        byArray[144] = 2;
        byArray[145] = 3;
        byArray[146] = 3;
        byArray[147] = 4;
        byArray[148] = 3;
        byArray[149] = 4;
        byArray[150] = 4;
        byArray[151] = 5;
        byArray[152] = 3;
        byArray[153] = 4;
        byArray[154] = 4;
        byArray[155] = 5;
        byArray[156] = 4;
        byArray[157] = 5;
        byArray[158] = 5;
        byArray[159] = 6;
        byArray[160] = 2;
        byArray[161] = 3;
        byArray[162] = 3;
        byArray[163] = 4;
        byArray[164] = 3;
        byArray[165] = 4;
        byArray[166] = 4;
        byArray[167] = 5;
        byArray[168] = 3;
        byArray[169] = 4;
        byArray[170] = 4;
        byArray[171] = 5;
        byArray[172] = 4;
        byArray[173] = 5;
        byArray[174] = 5;
        byArray[175] = 6;
        byArray[176] = 3;
        byArray[177] = 4;
        byArray[178] = 4;
        byArray[179] = 5;
        byArray[180] = 4;
        byArray[181] = 5;
        byArray[182] = 5;
        byArray[183] = 6;
        byArray[184] = 4;
        byArray[185] = 5;
        byArray[186] = 5;
        byArray[187] = 6;
        byArray[188] = 5;
        byArray[189] = 6;
        byArray[190] = 6;
        byArray[191] = 7;
        byArray[192] = 2;
        byArray[193] = 3;
        byArray[194] = 3;
        byArray[195] = 4;
        byArray[196] = 3;
        byArray[197] = 4;
        byArray[198] = 4;
        byArray[199] = 5;
        byArray[200] = 3;
        byArray[201] = 4;
        byArray[202] = 4;
        byArray[203] = 5;
        byArray[204] = 4;
        byArray[205] = 5;
        byArray[206] = 5;
        byArray[207] = 6;
        byArray[208] = 3;
        byArray[209] = 4;
        byArray[210] = 4;
        byArray[211] = 5;
        byArray[212] = 4;
        byArray[213] = 5;
        byArray[214] = 5;
        byArray[215] = 6;
        byArray[216] = 4;
        byArray[217] = 5;
        byArray[218] = 5;
        byArray[219] = 6;
        byArray[220] = 5;
        byArray[221] = 6;
        byArray[222] = 6;
        byArray[223] = 7;
        byArray[224] = 3;
        byArray[225] = 4;
        byArray[226] = 4;
        byArray[227] = 5;
        byArray[228] = 4;
        byArray[229] = 5;
        byArray[230] = 5;
        byArray[231] = 6;
        byArray[232] = 4;
        byArray[233] = 5;
        byArray[234] = 5;
        byArray[235] = 6;
        byArray[236] = 5;
        byArray[237] = 6;
        byArray[238] = 6;
        byArray[239] = 7;
        byArray[240] = 4;
        byArray[241] = 5;
        byArray[242] = 5;
        byArray[243] = 6;
        byArray[244] = 5;
        byArray[245] = 6;
        byArray[246] = 6;
        byArray[247] = 7;
        byArray[248] = 5;
        byArray[249] = 6;
        byArray[250] = 6;
        byArray[251] = 7;
        byArray[252] = 6;
        byArray[253] = 7;
        byArray[254] = 7;
        byArray[255] = 8;
        flagsOffset = byArray;
        dummyStringBuilder = new StringBuilder();
        try {
            INSTANCE = new UCaseProps();
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private UCaseProps() throws IOException {
        ByteBuffer bytes = ICUBinary.getRequiredData(DATA_FILE_NAME);
        this.readData(bytes);
    }

    private final void readData(ByteBuffer bytes) throws IOException {
        ICUBinary.readHeader(bytes, 1665225541, new IsAcceptable());
        int count = bytes.getInt();
        if (count < 16) {
            throw new IOException("indexes[0] too small in ucase.icu");
        }
        this.indexes = new int[count];
        this.indexes[0] = count;
        int i = 1;
        while (i < count) {
            this.indexes[i] = bytes.getInt();
            ++i;
        }
        this.trie = Trie2_16.createFromSerialized(bytes);
        int expectedTrieLength = this.indexes[2];
        int trieLength = this.trie.getSerializedLength();
        if (trieLength > expectedTrieLength) {
            throw new IOException("ucase.icu: not enough bytes for the trie");
        }
        ICUBinary.skipBytes(bytes, expectedTrieLength - trieLength);
        count = this.indexes[3];
        if (count > 0) {
            this.exceptions = ICUBinary.getString(bytes, count, 0);
        }
        if ((count = this.indexes[4]) > 0) {
            this.unfold = ICUBinary.getChars(bytes, count, 0);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public final void addPropertyStarts(UnicodeSet set) {
        Trie2.Range range;
        Iterator<Trie2.Range> trieIterator = this.trie.iterator();
        if (true) {
            return;
        }
        do {
            set.add(range.startCodePoint);
            if (!trieIterator.hasNext()) return;
            range = trieIterator.next();
        } while (!range.leadSurrogate);
    }

    private static final int getExceptionsOffset(int props) {
        return props >> 4;
    }

    static final boolean propsHasException(int props) {
        return (props & 8) != 0;
    }

    private static final boolean hasSlot(int flags, int index) {
        return (flags & 1 << index) != 0;
    }

    private static final byte slotOffset(int flags, int index) {
        return flagsOffset[flags & (1 << index) - 1];
    }

    private final long getSlotValueAndOffset(int excWord, int index, int excOffset) {
        long value;
        if ((excWord & 0x100) == 0) {
            value = this.exceptions.charAt(excOffset += UCaseProps.slotOffset(excWord, index));
        } else {
            excOffset += 2 * UCaseProps.slotOffset(excWord, index);
            value = this.exceptions.charAt(excOffset++);
            value = value << 16 | (long)this.exceptions.charAt(excOffset);
        }
        return value | (long)excOffset << 32;
    }

    private final int getSlotValue(int excWord, int index, int excOffset) {
        int value;
        if ((excWord & 0x100) == 0) {
            value = this.exceptions.charAt(excOffset += UCaseProps.slotOffset(excWord, index));
        } else {
            excOffset += 2 * UCaseProps.slotOffset(excWord, index);
            value = this.exceptions.charAt(excOffset++);
            value = value << 16 | this.exceptions.charAt(excOffset);
        }
        return value;
    }

    public final int tolower(int c) {
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.isUpperOrTitleFromProps(props)) {
                c += UCaseProps.getDelta(props);
            }
        } else {
            char excWord;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            if (UCaseProps.hasSlot(excWord = this.exceptions.charAt(excOffset++), 4) && UCaseProps.isUpperOrTitleFromProps(props)) {
                int delta = this.getSlotValue(excWord, 4, excOffset);
                return (excWord & 0x400) == 0 ? c + delta : c - delta;
            }
            if (UCaseProps.hasSlot(excWord, 0)) {
                c = this.getSlotValue(excWord, 0, excOffset);
            }
        }
        return c;
    }

    public final int toupper(int c) {
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.getTypeFromProps(props) == 1) {
                c += UCaseProps.getDelta(props);
            }
        } else {
            char excWord;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            if (UCaseProps.hasSlot(excWord = this.exceptions.charAt(excOffset++), 4) && UCaseProps.getTypeFromProps(props) == 1) {
                int delta = this.getSlotValue(excWord, 4, excOffset);
                return (excWord & 0x400) == 0 ? c + delta : c - delta;
            }
            if (UCaseProps.hasSlot(excWord, 2)) {
                c = this.getSlotValue(excWord, 2, excOffset);
            }
        }
        return c;
    }

    public final int totitle(int c) {
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.getTypeFromProps(props) == 1) {
                c += UCaseProps.getDelta(props);
            }
        } else {
            int index;
            char excWord;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            if (UCaseProps.hasSlot(excWord = this.exceptions.charAt(excOffset++), 4) && UCaseProps.getTypeFromProps(props) == 1) {
                int delta = this.getSlotValue(excWord, 4, excOffset);
                return (excWord & 0x400) == 0 ? c + delta : c - delta;
            }
            if (UCaseProps.hasSlot(excWord, 3)) {
                index = 3;
            } else if (UCaseProps.hasSlot(excWord, 2)) {
                index = 2;
            } else {
                return c;
            }
            c = this.getSlotValue(excWord, index, excOffset);
        }
        return c;
    }

    public final void addCaseClosure(int c, UnicodeSet set) {
        switch (c) {
            case 73: {
                set.add(105);
                return;
            }
            case 105: {
                set.add(73);
                return;
            }
            case 304: {
                set.add(iDot);
                return;
            }
            case 305: {
                return;
            }
        }
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            int delta;
            if (UCaseProps.getTypeFromProps(props) != 0 && (delta = UCaseProps.getDelta(props)) != 0) {
                set.add(c + delta);
            }
        } else {
            int closureOffset;
            int closureLength;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            char excWord = this.exceptions.charAt(excOffset++);
            int excOffset0 = excOffset;
            int index = 0;
            while (index <= 3) {
                if (UCaseProps.hasSlot(excWord, index)) {
                    excOffset = excOffset0;
                    c = this.getSlotValue(excWord, index, excOffset);
                    set.add(c);
                }
                ++index;
            }
            if (UCaseProps.hasSlot(excWord, 4)) {
                excOffset = excOffset0;
                int delta = this.getSlotValue(excWord, 4, excOffset);
                set.add((excWord & 0x400) == 0 ? c + delta : c - delta);
            }
            if (UCaseProps.hasSlot(excWord, 6)) {
                excOffset = excOffset0;
                long value = this.getSlotValueAndOffset(excWord, 6, excOffset);
                closureLength = (int)value & 0xF;
                closureOffset = (int)(value >> 32) + 1;
            } else {
                closureLength = 0;
                closureOffset = 0;
            }
            if (UCaseProps.hasSlot(excWord, 7)) {
                excOffset = excOffset0;
                long value = this.getSlotValueAndOffset(excWord, 7, excOffset);
                int fullLength = (int)value;
                excOffset = (int)(value >> 32) + 1;
                excOffset += (fullLength &= 0xFFFF) & 0xF;
                int length = (fullLength >>= 4) & 0xF;
                if (length != 0) {
                    set.add(this.exceptions.substring(excOffset, excOffset + length));
                    excOffset += length;
                }
                excOffset += (fullLength >>= 4) & 0xF;
                closureOffset = excOffset += (fullLength >>= 4);
            }
            int limit = closureOffset + closureLength;
            index = closureOffset;
            while (index < limit) {
                c = this.exceptions.codePointAt(index);
                set.add(c);
                index += UTF16.getCharCount(c);
            }
        }
    }

    private final int strcmpMax(String s, int unfoldOffset, int max) {
        int length = s.length();
        max -= length;
        int i1 = 0;
        do {
            char c2;
            int c1 = s.charAt(i1++);
            if ((c2 = this.unfold[unfoldOffset++]) == '\u0000') {
                return 1;
            }
            if ((c1 -= c2) == 0) continue;
            return c1;
        } while (--length > 0);
        if (max == 0 || this.unfold[unfoldOffset] == '\u0000') {
            return 0;
        }
        return -max;
    }

    public final boolean addStringCaseClosure(String s, UnicodeSet set) {
        if (this.unfold == null || s == null) {
            return false;
        }
        int length = s.length();
        if (length <= 1) {
            return false;
        }
        int unfoldRows = this.unfold[0];
        char unfoldRowWidth = this.unfold[1];
        int unfoldStringWidth = this.unfold[2];
        if (length > unfoldStringWidth) {
            return false;
        }
        int start = 0;
        int limit = unfoldRows;
        while (start < limit) {
            int i = (start + limit) / 2;
            int unfoldOffset = (i + 1) * unfoldRowWidth;
            int result = this.strcmpMax(s, unfoldOffset, unfoldStringWidth);
            if (result == 0) {
                i = unfoldStringWidth;
                while (i < unfoldRowWidth && this.unfold[unfoldOffset + i] != '\u0000') {
                    int c = UTF16.charAt(this.unfold, unfoldOffset, this.unfold.length, i);
                    set.add(c);
                    this.addCaseClosure(c, set);
                    i += UTF16.getCharCount(c);
                }
                return true;
            }
            if (result < 0) {
                limit = i;
                continue;
            }
            start = i + 1;
        }
        return false;
    }

    public final int getType(int c) {
        return UCaseProps.getTypeFromProps(this.trie.get(c));
    }

    public final int getTypeOrIgnorable(int c) {
        return UCaseProps.getTypeAndIgnorableFromProps(this.trie.get(c));
    }

    public final int getDotType(int c) {
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            return props & 0x60;
        }
        return this.exceptions.charAt(UCaseProps.getExceptionsOffset(props)) >> 7 & 0x60;
    }

    public final boolean isSoftDotted(int c) {
        return this.getDotType(c) == 32;
    }

    public final boolean isCaseSensitive(int c) {
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            return (props & 0x10) != 0;
        }
        return (this.exceptions.charAt(UCaseProps.getExceptionsOffset(props)) & 0x800) != 0;
    }

    public static final int getCaseLocale(Locale locale) {
        return UCaseProps.getCaseLocale(locale.getLanguage());
    }

    public static final int getCaseLocale(ULocale locale) {
        return UCaseProps.getCaseLocale(locale.getLanguage());
    }

    private static final int getCaseLocale(String language) {
        if (language.length() == 2) {
            if (language.equals("en") || language.charAt(0) > 't') {
                return 1;
            }
            if (language.equals("tr") || language.equals("az")) {
                return 2;
            }
            if (language.equals("el")) {
                return 4;
            }
            if (language.equals("lt")) {
                return 3;
            }
            if (language.equals("nl")) {
                return 5;
            }
            if (language.equals("hy")) {
                return 6;
            }
        } else if (language.length() == 3) {
            if (language.equals("tur") || language.equals("aze")) {
                return 2;
            }
            if (language.equals("ell")) {
                return 4;
            }
            if (language.equals("lit")) {
                return 3;
            }
            if (language.equals("nld")) {
                return 5;
            }
            if (language.equals("hye")) {
                return 6;
            }
        }
        return 1;
    }

    private final boolean isFollowedByCasedLetter(ContextIterator iter, int dir) {
        int c;
        if (iter == null) {
            return false;
        }
        iter.reset(dir);
        while ((c = iter.next()) >= 0) {
            int type = this.getTypeOrIgnorable(c);
            if ((type & 4) != 0) continue;
            return type != 0;
        }
        return false;
    }

    private final boolean isPrecededBySoftDotted(ContextIterator iter) {
        int c;
        if (iter == null) {
            return false;
        }
        iter.reset(-1);
        while ((c = iter.next()) >= 0) {
            int dotType = this.getDotType(c);
            if (dotType == 32) {
                return true;
            }
            if (dotType == 96) continue;
            return false;
        }
        return false;
    }

    private final boolean isPrecededBy_I(ContextIterator iter) {
        int c;
        if (iter == null) {
            return false;
        }
        iter.reset(-1);
        while ((c = iter.next()) >= 0) {
            if (c == 73) {
                return true;
            }
            int dotType = this.getDotType(c);
            if (dotType == 96) continue;
            return false;
        }
        return false;
    }

    private final boolean isFollowedByMoreAbove(ContextIterator iter) {
        int c;
        if (iter == null) {
            return false;
        }
        iter.reset(1);
        while ((c = iter.next()) >= 0) {
            int dotType = this.getDotType(c);
            if (dotType == 64) {
                return true;
            }
            if (dotType == 96) continue;
            return false;
        }
        return false;
    }

    private final boolean isFollowedByDotAbove(ContextIterator iter) {
        int c;
        if (iter == null) {
            return false;
        }
        iter.reset(1);
        while ((c = iter.next()) >= 0) {
            if (c == 775) {
                return true;
            }
            int dotType = this.getDotType(c);
            if (dotType == 96) continue;
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int toFullLower(int c, ContextIterator iter, Appendable out, int caseLocale) {
        int n;
        int result = c;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.isUpperOrTitleFromProps(props)) {
                result = c + UCaseProps.getDelta(props);
            }
        } else {
            long value;
            int full;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            char excWord = this.exceptions.charAt(excOffset++);
            int excOffset2 = excOffset;
            if ((excWord & 0x4000) != 0) {
                if (caseLocale == 3 && ((c == 73 || c == 74 || c == 302) && this.isFollowedByMoreAbove(iter) || c == 204 || c == 205 || c == 296)) {
                    try {
                        switch (c) {
                            case 73: {
                                out.append(iDot);
                                return 2;
                            }
                            case 74: {
                                out.append(jDot);
                                return 2;
                            }
                            case 302: {
                                out.append(iOgonekDot);
                                return 2;
                            }
                            case 204: {
                                out.append(iDotGrave);
                                return 3;
                            }
                            case 205: {
                                out.append(iDotAcute);
                                return 3;
                            }
                            case 296: {
                                out.append(iDotTilde);
                                return 3;
                            }
                        }
                        return 0;
                    }
                    catch (IOException e) {
                        throw new ICUUncheckedIOException(e);
                    }
                }
                if (caseLocale == 2 && c == 304) {
                    return 105;
                }
                if (caseLocale == 2 && c == 775 && this.isPrecededBy_I(iter)) {
                    return 0;
                }
                if (caseLocale == 2 && c == 73 && !this.isFollowedByDotAbove(iter)) {
                    return 305;
                }
                if (c == 304) {
                    try {
                        out.append(iDot);
                        return 2;
                    }
                    catch (IOException e) {
                        throw new ICUUncheckedIOException(e);
                    }
                }
                if (c == 931 && !this.isFollowedByCasedLetter(iter, 1) && this.isFollowedByCasedLetter(iter, -1)) {
                    return 962;
                }
            } else if (UCaseProps.hasSlot(excWord, 7) && (full = (int)(value = this.getSlotValueAndOffset(excWord, 7, excOffset)) & 0xF) != 0) {
                excOffset = (int)(value >> 32) + 1;
                try {
                    out.append(this.exceptions, excOffset, excOffset + full);
                    return full;
                }
                catch (IOException e) {
                    throw new ICUUncheckedIOException(e);
                }
            }
            if (UCaseProps.hasSlot(excWord, 4) && UCaseProps.isUpperOrTitleFromProps(props)) {
                int n2;
                int delta = this.getSlotValue(excWord, 4, excOffset2);
                if ((excWord & 0x400) == 0) {
                    n2 = c + delta;
                    return n2;
                }
                n2 = c - delta;
                return n2;
            }
            if (UCaseProps.hasSlot(excWord, 0)) {
                result = this.getSlotValue(excWord, 0, excOffset2);
            }
        }
        if (result == c) {
            n = ~result;
            return n;
        }
        n = result;
        return n;
    }

    private final int toUpperOrTitle(int c, ContextIterator iter, Appendable out, int loc, boolean upperNotTitle) {
        int result = c;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.getTypeFromProps(props) == 1) {
                result = c + UCaseProps.getDelta(props);
            }
        } else {
            int index;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            char excWord = this.exceptions.charAt(excOffset++);
            int excOffset2 = excOffset;
            if ((excWord & 0x4000) != 0) {
                if (loc == 2 && c == 105) {
                    return 304;
                }
                if (loc == 3 && c == 775 && this.isPrecededBySoftDotted(iter)) {
                    return 0;
                }
                if (c == 1415) {
                    try {
                        if (loc == 6) {
                            out.append(upperNotTitle ? "\u0535\u054e" : "\u0535\u057e");
                        } else {
                            out.append(upperNotTitle ? "\u0535\u0552" : "\u0535\u0582");
                        }
                        return 2;
                    }
                    catch (IOException e) {
                        throw new ICUUncheckedIOException(e);
                    }
                }
            } else if (UCaseProps.hasSlot(excWord, 7)) {
                long value = this.getSlotValueAndOffset(excWord, 7, excOffset);
                int full = (int)value & 0xFFFF;
                excOffset = (int)(value >> 32) + 1;
                excOffset += full & 0xF;
                excOffset += (full >>= 4) & 0xF;
                full >>= 4;
                if (upperNotTitle) {
                    full &= 0xF;
                } else {
                    excOffset += full & 0xF;
                    full = full >> 4 & 0xF;
                }
                if (full != 0) {
                    try {
                        out.append(this.exceptions, excOffset, excOffset + full);
                        return full;
                    }
                    catch (IOException e) {
                        throw new ICUUncheckedIOException(e);
                    }
                }
            }
            if (UCaseProps.hasSlot(excWord, 4) && UCaseProps.getTypeFromProps(props) == 1) {
                int delta = this.getSlotValue(excWord, 4, excOffset2);
                return (excWord & 0x400) == 0 ? c + delta : c - delta;
            }
            if (!upperNotTitle && UCaseProps.hasSlot(excWord, 3)) {
                index = 3;
            } else if (UCaseProps.hasSlot(excWord, 2)) {
                index = 2;
            } else {
                return ~c;
            }
            result = this.getSlotValue(excWord, index, excOffset2);
        }
        return result == c ? ~result : result;
    }

    public final int toFullUpper(int c, ContextIterator iter, Appendable out, int caseLocale) {
        return this.toUpperOrTitle(c, iter, out, caseLocale, true);
    }

    public final int toFullTitle(int c, ContextIterator iter, Appendable out, int caseLocale) {
        return this.toUpperOrTitle(c, iter, out, caseLocale, false);
    }

    public final int fold(int c, int options) {
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.isUpperOrTitleFromProps(props)) {
                c += UCaseProps.getDelta(props);
            }
        } else {
            int index;
            char excWord;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            if (((excWord = this.exceptions.charAt(excOffset++)) & 0x8000) != 0) {
                if ((options & 7) == 0) {
                    if (c == 73) {
                        return 105;
                    }
                    if (c == 304) {
                        return c;
                    }
                } else {
                    if (c == 73) {
                        return 305;
                    }
                    if (c == 304) {
                        return 105;
                    }
                }
            }
            if ((excWord & 0x200) != 0) {
                return c;
            }
            if (UCaseProps.hasSlot(excWord, 4) && UCaseProps.isUpperOrTitleFromProps(props)) {
                int delta = this.getSlotValue(excWord, 4, excOffset);
                return (excWord & 0x400) == 0 ? c + delta : c - delta;
            }
            if (UCaseProps.hasSlot(excWord, 1)) {
                index = 1;
            } else if (UCaseProps.hasSlot(excWord, 0)) {
                index = 0;
            } else {
                return c;
            }
            c = this.getSlotValue(excWord, index, excOffset);
        }
        return c;
    }

    public final int toFullFolding(int c, Appendable out, int options) {
        int result = c;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.isUpperOrTitleFromProps(props)) {
                result = c + UCaseProps.getDelta(props);
            }
        } else {
            int index;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            char excWord = this.exceptions.charAt(excOffset++);
            int excOffset2 = excOffset;
            if ((excWord & 0x8000) != 0) {
                if ((options & 7) == 0) {
                    if (c == 73) {
                        return 105;
                    }
                    if (c == 304) {
                        try {
                            out.append(iDot);
                            return 2;
                        }
                        catch (IOException e) {
                            throw new ICUUncheckedIOException(e);
                        }
                    }
                } else {
                    if (c == 73) {
                        return 305;
                    }
                    if (c == 304) {
                        return 105;
                    }
                }
            } else if (UCaseProps.hasSlot(excWord, 7)) {
                long value = this.getSlotValueAndOffset(excWord, 7, excOffset);
                int full = (int)value & 0xFFFF;
                excOffset = (int)(value >> 32) + 1;
                excOffset += full & 0xF;
                if ((full = full >> 4 & 0xF) != 0) {
                    try {
                        out.append(this.exceptions, excOffset, excOffset + full);
                        return full;
                    }
                    catch (IOException e) {
                        throw new ICUUncheckedIOException(e);
                    }
                }
            }
            if ((excWord & 0x200) != 0) {
                return ~c;
            }
            if (UCaseProps.hasSlot(excWord, 4) && UCaseProps.isUpperOrTitleFromProps(props)) {
                int delta = this.getSlotValue(excWord, 4, excOffset2);
                return (excWord & 0x400) == 0 ? c + delta : c - delta;
            }
            if (UCaseProps.hasSlot(excWord, 1)) {
                index = 1;
            } else if (UCaseProps.hasSlot(excWord, 0)) {
                index = 0;
            } else {
                return ~c;
            }
            result = this.getSlotValue(excWord, index, excOffset2);
        }
        return result == c ? ~result : result;
    }

    public final boolean hasBinaryProperty(int c, int which) {
        switch (which) {
            case 22: {
                return 1 == this.getType(c);
            }
            case 30: {
                return 2 == this.getType(c);
            }
            case 27: {
                return this.isSoftDotted(c);
            }
            case 34: {
                return this.isCaseSensitive(c);
            }
            case 49: {
                return this.getType(c) != 0;
            }
            case 50: {
                return this.getTypeOrIgnorable(c) >> 2 != 0;
            }
            case 51: {
                dummyStringBuilder.setLength(0);
                return this.toFullLower(c, null, dummyStringBuilder, 1) >= 0;
            }
            case 52: {
                dummyStringBuilder.setLength(0);
                return this.toFullUpper(c, null, dummyStringBuilder, 1) >= 0;
            }
            case 53: {
                dummyStringBuilder.setLength(0);
                return this.toFullTitle(c, null, dummyStringBuilder, 1) >= 0;
            }
            case 55: {
                dummyStringBuilder.setLength(0);
                return this.toFullLower(c, null, dummyStringBuilder, 1) >= 0 || this.toFullUpper(c, null, dummyStringBuilder, 1) >= 0 || this.toFullTitle(c, null, dummyStringBuilder, 1) >= 0;
            }
        }
        return false;
    }

    static Trie2_16 getTrie() {
        return UCaseProps.INSTANCE.trie;
    }

    static final int getTypeFromProps(int props) {
        return props & 3;
    }

    private static final int getTypeAndIgnorableFromProps(int props) {
        return props & 7;
    }

    static final boolean isUpperOrTitleFromProps(int props) {
        return (props & 2) != 0;
    }

    static final int getDelta(int props) {
        return (short)props >> 7;
    }

    public static interface ContextIterator {
        public void reset(int var1);

        public int next();
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] version) {
            return version[0] == 4;
        }
    }

    static final class LatinCase {
        static final char LIMIT = '\u0180';
        static final char LONG_S = '\u017f';
        static final byte EXC = -128;
        static final byte[] TO_LOWER_NORMAL;
        static final byte[] TO_LOWER_TR_LT;
        static final byte[] TO_UPPER_NORMAL;
        static final byte[] TO_UPPER_TR;

        static {
            byte[] byArray = new byte[384];
            byArray[65] = 32;
            byArray[66] = 32;
            byArray[67] = 32;
            byArray[68] = 32;
            byArray[69] = 32;
            byArray[70] = 32;
            byArray[71] = 32;
            byArray[72] = 32;
            byArray[73] = 32;
            byArray[74] = 32;
            byArray[75] = 32;
            byArray[76] = 32;
            byArray[77] = 32;
            byArray[78] = 32;
            byArray[79] = 32;
            byArray[80] = 32;
            byArray[81] = 32;
            byArray[82] = 32;
            byArray[83] = 32;
            byArray[84] = 32;
            byArray[85] = 32;
            byArray[86] = 32;
            byArray[87] = 32;
            byArray[88] = 32;
            byArray[89] = 32;
            byArray[90] = 32;
            byArray[181] = -128;
            byArray[192] = 32;
            byArray[193] = 32;
            byArray[194] = 32;
            byArray[195] = 32;
            byArray[196] = 32;
            byArray[197] = 32;
            byArray[198] = 32;
            byArray[199] = 32;
            byArray[200] = 32;
            byArray[201] = 32;
            byArray[202] = 32;
            byArray[203] = 32;
            byArray[204] = 32;
            byArray[205] = 32;
            byArray[206] = 32;
            byArray[207] = 32;
            byArray[208] = 32;
            byArray[209] = 32;
            byArray[210] = 32;
            byArray[211] = 32;
            byArray[212] = 32;
            byArray[213] = 32;
            byArray[214] = 32;
            byArray[216] = 32;
            byArray[217] = 32;
            byArray[218] = 32;
            byArray[219] = 32;
            byArray[220] = 32;
            byArray[221] = 32;
            byArray[222] = 32;
            byArray[223] = -128;
            byArray[256] = 1;
            byArray[258] = 1;
            byArray[260] = 1;
            byArray[262] = 1;
            byArray[264] = 1;
            byArray[266] = 1;
            byArray[268] = 1;
            byArray[270] = 1;
            byArray[272] = 1;
            byArray[274] = 1;
            byArray[276] = 1;
            byArray[278] = 1;
            byArray[280] = 1;
            byArray[282] = 1;
            byArray[284] = 1;
            byArray[286] = 1;
            byArray[288] = 1;
            byArray[290] = 1;
            byArray[292] = 1;
            byArray[294] = 1;
            byArray[296] = 1;
            byArray[298] = 1;
            byArray[300] = 1;
            byArray[302] = 1;
            byArray[304] = -128;
            byArray[306] = 1;
            byArray[308] = 1;
            byArray[310] = 1;
            byArray[313] = 1;
            byArray[315] = 1;
            byArray[317] = 1;
            byArray[319] = 1;
            byArray[321] = 1;
            byArray[323] = 1;
            byArray[325] = 1;
            byArray[327] = 1;
            byArray[329] = -128;
            byArray[330] = 1;
            byArray[332] = 1;
            byArray[334] = 1;
            byArray[336] = 1;
            byArray[338] = 1;
            byArray[340] = 1;
            byArray[342] = 1;
            byArray[344] = 1;
            byArray[346] = 1;
            byArray[348] = 1;
            byArray[350] = 1;
            byArray[352] = 1;
            byArray[354] = 1;
            byArray[356] = 1;
            byArray[358] = 1;
            byArray[360] = 1;
            byArray[362] = 1;
            byArray[364] = 1;
            byArray[366] = 1;
            byArray[368] = 1;
            byArray[370] = 1;
            byArray[372] = 1;
            byArray[374] = 1;
            byArray[376] = -121;
            byArray[377] = 1;
            byArray[379] = 1;
            byArray[381] = 1;
            byArray[383] = -128;
            TO_LOWER_NORMAL = byArray;
            byte[] byArray2 = new byte[384];
            byArray2[65] = 32;
            byArray2[66] = 32;
            byArray2[67] = 32;
            byArray2[68] = 32;
            byArray2[69] = 32;
            byArray2[70] = 32;
            byArray2[71] = 32;
            byArray2[72] = 32;
            byArray2[73] = -128;
            byArray2[74] = -128;
            byArray2[75] = 32;
            byArray2[76] = 32;
            byArray2[77] = 32;
            byArray2[78] = 32;
            byArray2[79] = 32;
            byArray2[80] = 32;
            byArray2[81] = 32;
            byArray2[82] = 32;
            byArray2[83] = 32;
            byArray2[84] = 32;
            byArray2[85] = 32;
            byArray2[86] = 32;
            byArray2[87] = 32;
            byArray2[88] = 32;
            byArray2[89] = 32;
            byArray2[90] = 32;
            byArray2[181] = -128;
            byArray2[192] = 32;
            byArray2[193] = 32;
            byArray2[194] = 32;
            byArray2[195] = 32;
            byArray2[196] = 32;
            byArray2[197] = 32;
            byArray2[198] = 32;
            byArray2[199] = 32;
            byArray2[200] = 32;
            byArray2[201] = 32;
            byArray2[202] = 32;
            byArray2[203] = 32;
            byArray2[204] = -128;
            byArray2[205] = -128;
            byArray2[206] = 32;
            byArray2[207] = 32;
            byArray2[208] = 32;
            byArray2[209] = 32;
            byArray2[210] = 32;
            byArray2[211] = 32;
            byArray2[212] = 32;
            byArray2[213] = 32;
            byArray2[214] = 32;
            byArray2[216] = 32;
            byArray2[217] = 32;
            byArray2[218] = 32;
            byArray2[219] = 32;
            byArray2[220] = 32;
            byArray2[221] = 32;
            byArray2[222] = 32;
            byArray2[223] = -128;
            byArray2[256] = 1;
            byArray2[258] = 1;
            byArray2[260] = 1;
            byArray2[262] = 1;
            byArray2[264] = 1;
            byArray2[266] = 1;
            byArray2[268] = 1;
            byArray2[270] = 1;
            byArray2[272] = 1;
            byArray2[274] = 1;
            byArray2[276] = 1;
            byArray2[278] = 1;
            byArray2[280] = 1;
            byArray2[282] = 1;
            byArray2[284] = 1;
            byArray2[286] = 1;
            byArray2[288] = 1;
            byArray2[290] = 1;
            byArray2[292] = 1;
            byArray2[294] = 1;
            byArray2[296] = -128;
            byArray2[298] = 1;
            byArray2[300] = 1;
            byArray2[302] = -128;
            byArray2[304] = -128;
            byArray2[306] = 1;
            byArray2[308] = 1;
            byArray2[310] = 1;
            byArray2[313] = 1;
            byArray2[315] = 1;
            byArray2[317] = 1;
            byArray2[319] = 1;
            byArray2[321] = 1;
            byArray2[323] = 1;
            byArray2[325] = 1;
            byArray2[327] = 1;
            byArray2[329] = -128;
            byArray2[330] = 1;
            byArray2[332] = 1;
            byArray2[334] = 1;
            byArray2[336] = 1;
            byArray2[338] = 1;
            byArray2[340] = 1;
            byArray2[342] = 1;
            byArray2[344] = 1;
            byArray2[346] = 1;
            byArray2[348] = 1;
            byArray2[350] = 1;
            byArray2[352] = 1;
            byArray2[354] = 1;
            byArray2[356] = 1;
            byArray2[358] = 1;
            byArray2[360] = 1;
            byArray2[362] = 1;
            byArray2[364] = 1;
            byArray2[366] = 1;
            byArray2[368] = 1;
            byArray2[370] = 1;
            byArray2[372] = 1;
            byArray2[374] = 1;
            byArray2[376] = -121;
            byArray2[377] = 1;
            byArray2[379] = 1;
            byArray2[381] = 1;
            byArray2[383] = -128;
            TO_LOWER_TR_LT = byArray2;
            byte[] byArray3 = new byte[384];
            byArray3[97] = -32;
            byArray3[98] = -32;
            byArray3[99] = -32;
            byArray3[100] = -32;
            byArray3[101] = -32;
            byArray3[102] = -32;
            byArray3[103] = -32;
            byArray3[104] = -32;
            byArray3[105] = -32;
            byArray3[106] = -32;
            byArray3[107] = -32;
            byArray3[108] = -32;
            byArray3[109] = -32;
            byArray3[110] = -32;
            byArray3[111] = -32;
            byArray3[112] = -32;
            byArray3[113] = -32;
            byArray3[114] = -32;
            byArray3[115] = -32;
            byArray3[116] = -32;
            byArray3[117] = -32;
            byArray3[118] = -32;
            byArray3[119] = -32;
            byArray3[120] = -32;
            byArray3[121] = -32;
            byArray3[122] = -32;
            byArray3[181] = -128;
            byArray3[223] = -128;
            byArray3[224] = -32;
            byArray3[225] = -32;
            byArray3[226] = -32;
            byArray3[227] = -32;
            byArray3[228] = -32;
            byArray3[229] = -32;
            byArray3[230] = -32;
            byArray3[231] = -32;
            byArray3[232] = -32;
            byArray3[233] = -32;
            byArray3[234] = -32;
            byArray3[235] = -32;
            byArray3[236] = -32;
            byArray3[237] = -32;
            byArray3[238] = -32;
            byArray3[239] = -32;
            byArray3[240] = -32;
            byArray3[241] = -32;
            byArray3[242] = -32;
            byArray3[243] = -32;
            byArray3[244] = -32;
            byArray3[245] = -32;
            byArray3[246] = -32;
            byArray3[248] = -32;
            byArray3[249] = -32;
            byArray3[250] = -32;
            byArray3[251] = -32;
            byArray3[252] = -32;
            byArray3[253] = -32;
            byArray3[254] = -32;
            byArray3[255] = 121;
            byArray3[257] = -1;
            byArray3[259] = -1;
            byArray3[261] = -1;
            byArray3[263] = -1;
            byArray3[265] = -1;
            byArray3[267] = -1;
            byArray3[269] = -1;
            byArray3[271] = -1;
            byArray3[273] = -1;
            byArray3[275] = -1;
            byArray3[277] = -1;
            byArray3[279] = -1;
            byArray3[281] = -1;
            byArray3[283] = -1;
            byArray3[285] = -1;
            byArray3[287] = -1;
            byArray3[289] = -1;
            byArray3[291] = -1;
            byArray3[293] = -1;
            byArray3[295] = -1;
            byArray3[297] = -1;
            byArray3[299] = -1;
            byArray3[301] = -1;
            byArray3[303] = -1;
            byArray3[305] = -128;
            byArray3[307] = -1;
            byArray3[309] = -1;
            byArray3[311] = -1;
            byArray3[314] = -1;
            byArray3[316] = -1;
            byArray3[318] = -1;
            byArray3[320] = -1;
            byArray3[322] = -1;
            byArray3[324] = -1;
            byArray3[326] = -1;
            byArray3[328] = -1;
            byArray3[329] = -128;
            byArray3[331] = -1;
            byArray3[333] = -1;
            byArray3[335] = -1;
            byArray3[337] = -1;
            byArray3[339] = -1;
            byArray3[341] = -1;
            byArray3[343] = -1;
            byArray3[345] = -1;
            byArray3[347] = -1;
            byArray3[349] = -1;
            byArray3[351] = -1;
            byArray3[353] = -1;
            byArray3[355] = -1;
            byArray3[357] = -1;
            byArray3[359] = -1;
            byArray3[361] = -1;
            byArray3[363] = -1;
            byArray3[365] = -1;
            byArray3[367] = -1;
            byArray3[369] = -1;
            byArray3[371] = -1;
            byArray3[373] = -1;
            byArray3[375] = -1;
            byArray3[378] = -1;
            byArray3[380] = -1;
            byArray3[382] = -1;
            byArray3[383] = -128;
            TO_UPPER_NORMAL = byArray3;
            byte[] byArray4 = new byte[384];
            byArray4[97] = -32;
            byArray4[98] = -32;
            byArray4[99] = -32;
            byArray4[100] = -32;
            byArray4[101] = -32;
            byArray4[102] = -32;
            byArray4[103] = -32;
            byArray4[104] = -32;
            byArray4[105] = -128;
            byArray4[106] = -32;
            byArray4[107] = -32;
            byArray4[108] = -32;
            byArray4[109] = -32;
            byArray4[110] = -32;
            byArray4[111] = -32;
            byArray4[112] = -32;
            byArray4[113] = -32;
            byArray4[114] = -32;
            byArray4[115] = -32;
            byArray4[116] = -32;
            byArray4[117] = -32;
            byArray4[118] = -32;
            byArray4[119] = -32;
            byArray4[120] = -32;
            byArray4[121] = -32;
            byArray4[122] = -32;
            byArray4[181] = -128;
            byArray4[223] = -128;
            byArray4[224] = -32;
            byArray4[225] = -32;
            byArray4[226] = -32;
            byArray4[227] = -32;
            byArray4[228] = -32;
            byArray4[229] = -32;
            byArray4[230] = -32;
            byArray4[231] = -32;
            byArray4[232] = -32;
            byArray4[233] = -32;
            byArray4[234] = -32;
            byArray4[235] = -32;
            byArray4[236] = -32;
            byArray4[237] = -32;
            byArray4[238] = -32;
            byArray4[239] = -32;
            byArray4[240] = -32;
            byArray4[241] = -32;
            byArray4[242] = -32;
            byArray4[243] = -32;
            byArray4[244] = -32;
            byArray4[245] = -32;
            byArray4[246] = -32;
            byArray4[248] = -32;
            byArray4[249] = -32;
            byArray4[250] = -32;
            byArray4[251] = -32;
            byArray4[252] = -32;
            byArray4[253] = -32;
            byArray4[254] = -32;
            byArray4[255] = 121;
            byArray4[257] = -1;
            byArray4[259] = -1;
            byArray4[261] = -1;
            byArray4[263] = -1;
            byArray4[265] = -1;
            byArray4[267] = -1;
            byArray4[269] = -1;
            byArray4[271] = -1;
            byArray4[273] = -1;
            byArray4[275] = -1;
            byArray4[277] = -1;
            byArray4[279] = -1;
            byArray4[281] = -1;
            byArray4[283] = -1;
            byArray4[285] = -1;
            byArray4[287] = -1;
            byArray4[289] = -1;
            byArray4[291] = -1;
            byArray4[293] = -1;
            byArray4[295] = -1;
            byArray4[297] = -1;
            byArray4[299] = -1;
            byArray4[301] = -1;
            byArray4[303] = -1;
            byArray4[305] = -128;
            byArray4[307] = -1;
            byArray4[309] = -1;
            byArray4[311] = -1;
            byArray4[314] = -1;
            byArray4[316] = -1;
            byArray4[318] = -1;
            byArray4[320] = -1;
            byArray4[322] = -1;
            byArray4[324] = -1;
            byArray4[326] = -1;
            byArray4[328] = -1;
            byArray4[329] = -128;
            byArray4[331] = -1;
            byArray4[333] = -1;
            byArray4[335] = -1;
            byArray4[337] = -1;
            byArray4[339] = -1;
            byArray4[341] = -1;
            byArray4[343] = -1;
            byArray4[345] = -1;
            byArray4[347] = -1;
            byArray4[349] = -1;
            byArray4[351] = -1;
            byArray4[353] = -1;
            byArray4[355] = -1;
            byArray4[357] = -1;
            byArray4[359] = -1;
            byArray4[361] = -1;
            byArray4[363] = -1;
            byArray4[365] = -1;
            byArray4[367] = -1;
            byArray4[369] = -1;
            byArray4[371] = -1;
            byArray4[373] = -1;
            byArray4[375] = -1;
            byArray4[378] = -1;
            byArray4[380] = -1;
            byArray4[382] = -1;
            byArray4[383] = -128;
            TO_UPPER_TR = byArray4;
        }

        LatinCase() {
        }
    }
}

